/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.pagedatamodel.api.IDOMModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNodeProvider;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeAdapter;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeContainerAdapter;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeProvidersRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;

public class PageDataNodeAdapterFactory
extends AbstractAdapterFactory {
    private static PageDataNodeContainerAdapter parentAdapterSingleton;
    private IPageDataModel pageDataModel;
    List pageTypes = null;
    public static final String ADAPTER_KEY_BASE = "PageDataNodeAdapterFactory";
    private KeyList adapterKeys;

    public PageDataNodeAdapterFactory() {
        this(ADAPTER_KEY_BASE, true);
    }

    public PageDataNodeAdapterFactory(Object adapterKey, boolean registerAdapters) {
        super(adapterKey, registerAdapters);
        parentAdapterSingleton = new PageDataNodeContainerAdapter();
        this.adapterKeys = new KeyList();
        this.adapterKeys.add(ADAPTER_KEY_BASE);
        IConfigurationElement[] elements = PageDataNodeProvidersRegistryReader.getPageDataNodeProviderElements();
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                String typeID = elements[i].getAttribute("typeID");
                if (typeID == null) {
                    IPageDataNodeProvider provider = PageDataNodeProvidersRegistryReader.getPageDataNodeProvider(elements[i]);
                    typeID = provider.getTypeID();
                }
                this.adapterKeys.add(ADAPTER_KEY_BASE + typeID);
                ++i;
            }
        }
    }

    public INodeAdapter adapt(INodeNotifier target) {
        if (target == null) {
            return null;
        }
        INodeAdapter adapter = null;
        if (this.adapterKeys.size() > 0) {
            int i = 0;
            while (i < this.adapterKeys.size()) {
                adapter = target.getExistingAdapter(this.adapterKeys.get(i));
                if (adapter != null) break;
                ++i;
            }
        }
        return adapter != null ? adapter : this.adaptNew(target);
    }

    public boolean isFactoryForType(Object type) {
        if (type instanceof String) {
            return this.adapterKeys.containsKey((String)type);
        }
        return false;
    }

    protected INodeAdapter createAdapter(INodeNotifier node) {
        if (node instanceof IDOMNode) {
            IDOMNode xmlNode = (IDOMNode)node;
            if (this.pageDataModel == null) {
                this.pageDataModel = PageDataModelUtil.getPageDataModel(xmlNode);
            }
            if (this.pageTypes == null) {
                this.pageTypes = PageDataModelUtil.getAllPageTypesForDocument((Document)xmlNode.getModel().getDocument());
            }
            IPageDataNodeProvider[] providers = PageDataNodeProvidersRegistryReader.getPageDataNodeProviders(this.pageTypes);
            boolean adapterAdded = false;
            int i = 0;
            while (i < providers.length) {
                if (!providers[i].isStaticProvider()) {
                    String adapterKey = PageDataModelUtil.createUniqueAdapterKey(providers[i]);
                    IPageDataNode pageDataNode = providers[i].createPageDataNode(xmlNode);
                    if (pageDataNode != null && this.pageDataModel != null) {
                        Map map;
                        Object categoryId;
                        if (pageDataNode instanceof IDOMModelLifeCycleListener) {
                            this.pageDataModel.addDomModelListener((IDOMModelLifeCycleListener)((Object)pageDataNode));
                        }
                        if (pageDataNode instanceof ISSEPageDataNode) {
                            ISSEPageDataNode ssenode = (ISSEPageDataNode)pageDataNode;
                            ssenode.setDOMNode(xmlNode);
                            PageDataModelUtil.addChildWithOrdering(this.pageDataModel, ssenode);
                        }
                        if ((categoryId = (map = PageDataNodeProvidersRegistryReader.getProvidersWithCategory()).get(providers[i])) != null) {
                            pageDataNode.setCategory((String)categoryId);
                        }
                        PageDataNodeAdapter adapter = new PageDataNodeAdapter((INodeAdapterFactory)this);
                        adapter.setPageDataNode(pageDataNode);
                        adapter.setAdapterKey(adapterKey);
                        xmlNode.addAdapter((INodeAdapter)adapter);
                        adapterAdded = true;
                    }
                }
                ++i;
            }
            if (adapterAdded) {
                return null;
            }
            return parentAdapterSingleton;
        }
        return null;
    }

    public void release() {
        List listeners;
        this.adapterKeys.clear();
        if (this.pageDataModel != null && (listeners = this.pageDataModel.getDomModelListeners()) != null && listeners.size() > 0) {
            int size = listeners.size();
            int i = size - 1;
            while (i >= 0) {
                IDOMModelLifeCycleListener listener = (IDOMModelLifeCycleListener)listeners.get(i);
                listener.domModelReleased();
                --i;
            }
            listeners.clear();
        }
        this.pageTypes = null;
    }

    private class KeyList
    extends ArrayList {
        private static final long serialVersionUID = 1L;

        private KeyList() {
        }

        public boolean containsKey(String keyToFind) {
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                if (!((String)itr.next()).equals(keyToFind)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean add(String o) {
            if (!this.containsKey(o)) {
                return super.add(o);
            }
            return false;
        }
    }
}

