/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.api.AdapterFactory;
import com.ibm.etools.webtools.pagedatamodel.api.IAdapter;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public abstract class PageDataNode
implements IPageDataNode {
    protected IPageDataNode parent = null;
    protected boolean childrenPopulated = false;
    private IPageDataModel pageDataModel;
    private EList children = null;
    public int sortOrder;
    private static ICodeGenModelFactory codeGenModelFactory;
    private String categoryId;
    private ISchedulingRule childrenRule;
    private List adapters;
    protected final int INIT_CHILDREN_SIZE = 5;
    private Boolean isComponent;

    public PageDataNode(IPageDataModel model, IPageDataNode parent) {
        this.pageDataModel = model;
        this.parent = parent;
        this.children = new BasicEList();
    }

    @Override
    public void addChild(IPageDataNode child) {
        this.children.add((Object)child);
        this.getPageDataModel().getPageDataNotifier().firePageNodeAdded(this, child);
        this.childrenPopulated = true;
    }

    @Override
    public void addChild(IPageDataNode child, int index) {
        this.children.add(index, (Object)child);
        this.getPageDataModel().getPageDataNotifier().firePageNodeAdded(this, child);
        this.childrenPopulated = true;
    }

    public void addChildWithoutNotification(IPageDataNode child) {
        this.children.add((Object)child);
        this.childrenPopulated = true;
    }

    @Override
    public void removeChild(IPageDataNode child) {
        if (this.children.remove((Object)child)) {
            this.getPageDataModel().getPageDataNotifier().firePageNodeRemoved(this, child);
        }
    }

    public void removeChildWithoutNotification(IPageDataNode child) {
        this.children.remove((Object)child);
    }

    @Override
    public IPageDataNode getParent() {
        return this.parent;
    }

    @Override
    public IPageDataModel getPageDataModel() {
        return this.pageDataModel;
    }

    public IPageDataNode basicGetParent() {
        return this.parent;
    }

    public void setParent(IPageDataNode parent) {
        this.parent = parent;
    }

    @Override
    public EList getChildren() {
        return this.children;
    }

    @Override
    public boolean isComponentNode() {
        if (this.isComponent == null) {
            this.isComponent = new Boolean(PageDataModelUtil.isComponentNode(this));
        }
        return this.isComponent;
    }

    @Override
    public EList getChildrenByDataCatagory(String dataCategory) {
        BasicEList basicList = new BasicEList();
        EList locChildren = this.getChildren();
        if (dataCategory != null && locChildren != null) {
            for (IPageDataNode child : locChildren) {
                if (!dataCategory.equals(child.getDataCategory())) continue;
                basicList.add((Object)child);
            }
        }
        return basicList;
    }

    public ISchedulingRule getChildrenRule() {
        ISchedulingRule rule;
        Job current;
        if (this.childrenRule == null) {
            this.childrenRule = new BatchSimilarSchedulingRule("x");
        }
        if ((current = Platform.getJobManager().currentJob()) != null && (rule = current.getRule()) instanceof IWorkspaceRoot) {
            return rule;
        }
        return this.childrenRule;
    }

    public void setPageDataModel(IPageDataModel pageDataModel) {
        this.pageDataModel = pageDataModel;
    }

    @Override
    public boolean hasChildren() {
        return this.children == null ? false : this.children.size() > 0;
    }

    @Override
    public Object getAdapter(Class key) {
        List factories;
        IAdapter ret = this.getExistingAdapter(key);
        if (ret == null && (factories = PageDataModelRegistryReader.getAdapterFactories()) != null && factories.size() > 0) {
            int i = 0;
            int size = factories.size();
            while (i < size) {
                AdapterFactory factory = (AdapterFactory)factories.get(i);
                IAdapter adapter = null;
                if (factory.isFactoryFor(key)) {
                    adapter = factory.adapt(this);
                }
                if (adapter != null) {
                    return adapter;
                }
                ++i;
            }
        }
        return ret;
    }

    protected IAdapter getExistingAdapter(Class key) {
        if (this.adapters != null && this.adapters.size() > 0) {
            int i = 0;
            int size = this.adapters.size();
            while (i < size) {
                IAdapter adptr = (IAdapter)this.adapters.get(i);
                if (adptr.isAdapterFor(key)) {
                    return adptr;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void setCategory(String category) {
        this.categoryId = category;
    }

    @Override
    public void addAdapter(IAdapter adapter) {
        if (this.adapters == null) {
            this.adapters = new ArrayList(1);
        }
        this.adapters.add(adapter);
    }

    @Override
    public ICodeGenModelFactory getCodeGenModelFactory() {
        if (codeGenModelFactory == null) {
            codeGenModelFactory = new CodeGenModelFactory();
        }
        return codeGenModelFactory;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public String getDataCategory() {
        return "Server Side";
    }

    @Override
    public String getCategory() {
        return this.categoryId;
    }

    protected final void clearChildren(boolean notify) {
        if (notify) {
            int size = this.children.size();
            int i = size - 1;
            while (i >= 0) {
                this.removeChild((IPageDataNode)this.children.get(i));
                --i;
            }
        } else {
            this.children.clear();
        }
        this.childrenPopulated = false;
    }

    protected boolean isChildrenFieldPopulated() {
        return this.childrenPopulated;
    }

    private class BatchSimilarSchedulingRule
    implements ISchedulingRule {
        public String id;

        public BatchSimilarSchedulingRule(String id) {
            this.id = id;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof BatchSimilarSchedulingRule) {
                return ((BatchSimilarSchedulingRule)rule).id.equals(this.id);
            }
            return false;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof BatchSimilarSchedulingRule) {
                return ((BatchSimilarSchedulingRule)rule).id.equals(this.id);
            }
            if (rule instanceof MultiRule) {
                MultiRule multi = (MultiRule)rule;
                ISchedulingRule[] lchildren = multi.getChildren();
                int i = 0;
                while (i < lchildren.length) {
                    if (!this.contains(lchildren[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return rule instanceof IResource;
        }
    }
}

