/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.model.util.IDisposeListener;
import com.ibm.etools.webtools.pagedatamodel.PageDataModelRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class PageDataModelAdapter
implements INodeAdapter,
IDisposeListener {
    public static final Class ADAPTER_KEY = PageDataModelAdapter.class;
    private static boolean SYNC_INITIALIZATION = false;
    private IPageDataModel pageDataModel = new PageDataModel();

    public static boolean isSyncInitialization() {
        return SYNC_INITIALIZATION;
    }

    public static void setSyncInitialization(boolean doSync) {
        SYNC_INITIALIZATION = doSync;
    }

    public void initialize(IDOMDocument node) {
        IProject project = this.getProjectFromDomModel(node.getModel());
        IPageDataModelLifeCycleListener[] listeners = PageDataModelRegistryReader.getPageDataModelListeners(project);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].pageDataModelToBeInitialized(this.pageDataModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        ((PageDataModel)this.pageDataModel).setIDOMModel(node.getModel());
        ((PageDataModel)this.pageDataModel).initialize(node);
        i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].pageDataModelInitialized(this.pageDataModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        PageDataModelAdapter.setSyncInitialization(false);
    }

    public void dispose() {
        IPageDataModelLifeCycleListener[] listeners = PageDataModelRegistryReader.getCachedPageDataModelListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].pageDataModelToBeReleased(this.pageDataModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].pageDataModelReleased();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(ADAPTER_KEY);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public IPageDataModel getPageDataModel() {
        return this.pageDataModel;
    }

    public void setPageDataModel(IPageDataModel pageDataModel) {
        this.pageDataModel = pageDataModel;
    }

    private IProject getProjectFromDomModel(IDOMModel xmlModel) {
        if (xmlModel == null) {
            return null;
        }
        String path = xmlModel.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = xmlModel.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path resourcePath = new Path(path);
        IFile file = resourcePath.toFile().exists() ? root.getFileForLocation((IPath)resourcePath) : root.getFile((IPath)resourcePath);
        return file.getProject();
    }
}

