/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.pagedatamodel.api.IDOMModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNodeProvider;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNotifier;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeProvidersRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNotifier;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.RootPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;

public class PageDataModel
implements IPageDataModel {
    private IPageDataNode root = new RootPageDataNode(this, null);
    private IDOMModel xmlModel;
    private IPageDataNotifier pageDataNotifier = new PageDataNotifier();
    private List domModelListeners = new ArrayList(2);
    private List staticPageDataNodes = new ArrayList(4);

    public void initialize(IDOMDocument doc) {
        List pageTypes;
        IPageDataNodeProvider[] providers;
        if (doc != null && (providers = PageDataNodeProvidersRegistryReader.getPageDataNodeProviders(pageTypes = PageDataModelUtil.getAllPageTypesForDocument((Document)doc))) != null && providers.length > 0) {
            int i = 0;
            while (i < providers.length) {
                IPageDataNode child;
                if (providers[i].isStaticProvider() && (child = providers[i].createPageDataNode(null)) != null) {
                    String categoryId;
                    ((PageDataNode)child).setPageDataModel(this);
                    if (child instanceof ISSEPageDataNode) {
                        ((ISSEPageDataNode)child).setDOMNode((IDOMNode)doc);
                    }
                    this.staticPageDataNodes.add(child);
                    if (child.getParent() == null) {
                        ((PageDataNode)child).setParent(this.root);
                    }
                    if ((categoryId = PageDataNodeProvidersRegistryReader.getCategoryForProvider(providers[i])) != null) {
                        child.setCategory(categoryId);
                    }
                    if (child instanceof IDOMModelLifeCycleListener) {
                        this.domModelListeners.add(child);
                    }
                    this.root.addChild(child);
                }
                ++i;
            }
        }
    }

    public IDOMModel getIDOMModel() {
        return this.xmlModel;
    }

    public void setIDOMModel(IDOMModel xmlModel) {
        this.xmlModel = xmlModel;
    }

    @Override
    public IPageDataNode getRoot() {
        return this.root;
    }

    public void setRoot(IPageDataNode root) {
        this.root = root;
    }

    @Override
    public IPageDataNotifier getPageDataNotifier() {
        return this.pageDataNotifier;
    }

    @Override
    public IFile getResource() {
        if (this.xmlModel == null) {
            return null;
        }
        String path = this.xmlModel.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = this.xmlModel.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot lroot = ResourcesPlugin.getWorkspace().getRoot();
        Path resourcePath = new Path(path);
        IFile file = resourcePath.toFile().exists() ? lroot.getFileForLocation((IPath)resourcePath) : lroot.getFile((IPath)resourcePath);
        return file;
    }

    @Override
    public List getDomModelListeners() {
        return this.domModelListeners;
    }

    @Override
    public void addDomModelListener(IDOMModelLifeCycleListener listener) {
        this.domModelListeners.add(listener);
    }

    @Override
    public void removeDomModelListener(IDOMModelLifeCycleListener listener) {
        this.domModelListeners.remove(listener);
    }

    public boolean isStaticPageDataNode(IPageDataNode node) {
        return this.staticPageDataNodes.contains(node);
    }
}

