/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.generation.util.TemplateLoader;
import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IGenControlPanel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Generator;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.GeneratorElement;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.osgi.framework.Bundle;

public class GenControlPanel
implements IGenControlPanel {
    private List fControlIds = new ArrayList(5);
    private List controlLabels = new ArrayList(5);
    private List controlTemplates = new ArrayList(5);
    private List backupTemplateClasses = new ArrayList(5);
    private CompiledTemplate[] compiledTemplateCache;
    private List dynamicTemplates;
    private Map pluginIdsForTemplates;
    private IClasspathEntry[] baseEntries;
    private List basePaths;
    private String defaultControlId;
    private RTypeListEntry[] rtTypes = new RTypeListEntry[0];
    private GeneratorElement defaultGenerator;
    private static HashMap pluginPathMap;

    private static void addAllUnique(List theList, List controlIds) {
        for (String controlId : controlIds) {
            if (theList.contains(controlId)) continue;
            theList.add(controlId);
        }
    }

    public GenControlPanel() {
        this.compiledTemplateCache = this.compiledTemplateCache == null ? new CompiledTemplate[]{} : this.compiledTemplateCache;
        this.pluginIdsForTemplates = new HashMap(2);
        this.dynamicTemplates = new ArrayList();
    }

    public void initialize(GenControlPanel panel) {
        this.fControlIds = panel.fControlIds;
        this.controlLabels = panel.controlLabels;
        this.controlTemplates = panel.controlTemplates;
        this.backupTemplateClasses = panel.backupTemplateClasses;
        this.compiledTemplateCache = panel.compiledTemplateCache;
        this.pluginIdsForTemplates = panel.pluginIdsForTemplates;
        this.baseEntries = panel.baseEntries;
        this.basePaths = panel.basePaths;
        this.defaultControlId = panel.defaultControlId;
        this.rtTypes = panel.rtTypes;
        this.defaultGenerator = panel.defaultGenerator;
        this.dynamicTemplates = panel.dynamicTemplates;
    }

    @Override
    public void addControl(String id, String label, String template, IConfigurationElement backupClass) {
        if (!this.fControlIds.contains(id)) {
            this.fControlIds.add(id);
            this.controlLabels.add(label);
            this.controlTemplates.add(template);
            this.backupTemplateClasses.add(backupClass);
        }
    }

    @Override
    public void addPluginIdForTemplate(String pluginId, String templateURI) {
        ArrayList<String> templateURIs = (ArrayList<String>)this.pluginIdsForTemplates.get(pluginId);
        if (templateURIs == null) {
            templateURIs = new ArrayList<String>(1);
        }
        templateURIs.add(templateURI);
        this.pluginIdsForTemplates.put(pluginId, templateURIs);
    }

    public String getPluginIdForTemplate(String controlId) {
        int idx = this.fControlIds.indexOf(controlId);
        if (idx >= 0) {
            String templateURI = (String)this.controlTemplates.get(idx);
            for (Map.Entry entry : this.pluginIdsForTemplates.entrySet()) {
                List values = (List)entry.getValue();
                if (!values.contains(templateURI)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    @Override
    public void setDefaultControlId(String string) {
        this.defaultControlId = string;
    }

    @Override
    public String getDefaultControlId() {
        return this.defaultControlId;
    }

    @Override
    public String getDefaultControlLabel() {
        int idx = this.fControlIds.indexOf(this.defaultControlId);
        if (idx >= 0) {
            return (String)this.controlLabels.get(idx);
        }
        return null;
    }

    @Override
    public IGenerationTemplate getDefaultControlTemplate() {
        return this.getTemplateForControl(this.defaultControlId);
    }

    @Override
    public String getLabelForControl(String controlId) {
        int idx = this.fControlIds.indexOf(controlId);
        if (idx >= 0) {
            return (String)this.controlLabels.get(idx);
        }
        return null;
    }

    @Override
    public IGenerationTemplate getTemplateForControl(String controlId) {
        int idx = this.fControlIds.indexOf(controlId);
        if (idx >= 0) {
            CompiledTemplate template = null;
            if (!this.dynamicTemplates.contains(controlId)) {
                template = this.loadBackUpClass(idx);
            } else {
                Plugin templatePlugin;
                String templateURI = (String)this.controlTemplates.get(idx);
                try {
                    template = this.compiledTemplateCache[idx];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    CompiledTemplate[] temp = this.compiledTemplateCache;
                    this.compiledTemplateCache = new CompiledTemplate[idx + 1];
                    System.arraycopy(temp, 0, this.compiledTemplateCache, 0, temp.length);
                }
                long timeStamp = this.getTimeStamp(templateURI);
                if ((template == null || template.modificationStamp != timeStamp) && (templatePlugin = Platform.getPlugin((String)this.getPluginIdForTemplate(controlId))) != null) {
                    ClassLoader cloader = templatePlugin.getDescriptor().getPluginClassLoader();
                    TemplateLoader loader = new TemplateLoader(cloader, this.getClasspathEntries(controlId), this.getClassPathPaths(controlId));
                    IGenerationTemplate temp = null;
                    try {
                        temp = (IGenerationTemplate)loader.createTemplate(templateURI, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (JETException jete) {
                        PageDataModelPlugin.getDefault().write(jete.getMessage());
                    }
                    catch (ClassCastException classCastException) {
                        PageDataModelPlugin.getDefault().write(ResourceHandler._EXC_bad_tempClass);
                        return null;
                    }
                    this.compiledTemplateCache[idx] = template = new CompiledTemplate(temp, timeStamp);
                }
                if (template == null || template.template == null) {
                    Object backupClass;
                    if (template == null) {
                        template = new CompiledTemplate(null, timeStamp);
                    }
                    if ((backupClass = this.backupTemplateClasses.get(idx)) instanceof IConfigurationElement) {
                        try {
                            Object temp = ((IConfigurationElement)backupClass).createExecutableExtension("class");
                            template.template = (IGenerationTemplate)temp;
                            this.backupTemplateClasses.set(idx, template);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        template.template = ((CompiledTemplate)backupClass).template;
                    }
                }
            }
            return template.template;
        }
        return null;
    }

    private CompiledTemplate loadBackUpClass(int idx) {
        CompiledTemplate template = new CompiledTemplate(null, 0L);
        Object backupClass = this.backupTemplateClasses.get(idx);
        if (backupClass instanceof IConfigurationElement) {
            try {
                Object temp = ((IConfigurationElement)backupClass).createExecutableExtension("class");
                template.template = (IGenerationTemplate)temp;
                this.backupTemplateClasses.set(idx, template);
            }
            catch (CoreException coreException) {}
        } else {
            template.template = ((CompiledTemplate)backupClass).template;
        }
        return template;
    }

    private String[] getClassPathPaths(String controlId) {
        ArrayList<Object> classPathPaths = new ArrayList<Object>();
        try {
            if (pluginPathMap == null) {
                pluginPathMap = new HashMap();
                String key = "com.ibm.etools.webtools.generation";
                Bundle generationBundle = Platform.getBundle((String)key);
                URL generationURL = FileLocator.find((Bundle)generationBundle, (IPath)new Path(""), null);
                String generationLocation = FileLocator.toFileURL((URL)generationURL).getPath();
                Path generationBundlePath = new Path(generationLocation);
                IPath cpAbsolute = generationBundlePath.makeAbsolute();
                String cpAsString = cpAbsolute.toOSString();
                pluginPathMap.put(key, cpAsString);
                key = "com.ibm.etools.webtools.pagedatamodel";
                Bundle pageDataModelBundle = Platform.getBundle((String)key);
                URL pageDataModelURL = FileLocator.find((Bundle)pageDataModelBundle, (IPath)new Path(""), null);
                String pageDataModelLocation = FileLocator.toFileURL((URL)pageDataModelURL).getPath();
                Path pageDataModelBundlePath = new Path(pageDataModelLocation);
                cpAbsolute = pageDataModelBundlePath.makeAbsolute();
                cpAsString = cpAbsolute.toOSString();
                pluginPathMap.put(key, cpAsString);
                key = "org.eclipse.emf.codegen";
                Bundle emfCodegenBundle = Platform.getBundle((String)key);
                URL emfCodegenURL = FileLocator.find((Bundle)emfCodegenBundle, (IPath)new Path(""), null);
                String emfCodegenLocation = FileLocator.toFileURL((URL)emfCodegenURL).getPath();
                Path emfCodegenBundlePath = new Path(emfCodegenLocation);
                cpAbsolute = emfCodegenBundlePath.makeAbsolute();
                cpAsString = cpAbsolute.toOSString();
                pluginPathMap.put(key, cpAsString);
            }
            classPathPaths.addAll(pluginPathMap.values());
            String declaringPlugin = this.getPluginIdForTemplate(controlId);
            String cpAsString = (String)pluginPathMap.get(declaringPlugin);
            if (cpAsString == null) {
                Bundle declaringPluginBundle = Platform.getBundle((String)declaringPlugin);
                URL declaringPluginURL = FileLocator.find((Bundle)declaringPluginBundle, (IPath)new Path(""), null);
                String declaringPluginLocation = FileLocator.toFileURL((URL)declaringPluginURL).getPath();
                Path declaringPluginPath = new Path(declaringPluginLocation);
                IPath cpAbsolute = declaringPluginPath.makeAbsolute();
                cpAsString = cpAbsolute.toOSString();
                pluginPathMap.put(declaringPlugin, cpAsString);
            }
            classPathPaths.add(cpAsString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classPathPaths.toArray(new String[classPathPaths.size()]);
    }

    private long getTimeStamp(String fileURI) {
        URL file = null;
        try {
            file = Platform.resolve((URL)new URL(fileURI));
        }
        catch (IOException iOException) {
            return 0L;
        }
        File tempFile = new File(file.getPath());
        long stamp = tempFile.lastModified();
        return stamp;
    }

    @Override
    public void addControlsForRT(String rtType, List controlIds, boolean input, IVirtualComponent vc) throws CoreException {
        int idx = -1;
        int i = 0;
        while (i < this.rtTypes.length) {
            RTypeListEntry entry = this.rtTypes[i];
            String entryType = entry.rtType.getType();
            if (entryType.equals(rtType)) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx >= 0) {
            RTypeListEntry existing = this.rtTypes[idx];
            List theList = null;
            theList = input ? existing.inputControlsList : existing.outputControlsList;
            GenControlPanel.addAllUnique(theList, controlIds);
        } else {
            RTypeListEntry entry = new RTypeListEntry(rtType);
            if (input) {
                GenControlPanel.addAllUnique(entry.inputControlsList, controlIds);
            } else {
                GenControlPanel.addAllUnique(entry.outputControlsList, controlIds);
            }
            RTypeListEntry[] temp = this.rtTypes;
            this.rtTypes = new RTypeListEntry[this.rtTypes.length + 1];
            System.arraycopy(temp, 0, this.rtTypes, 0, temp.length);
            this.rtTypes[temp.length] = entry;
        }
    }

    @Override
    public List getControlsForRT(String rtType, final short input, final IVirtualComponent vc) throws ClassNotFoundException {
        final String rtTypeErasure = Signature.toString((String)Signature.getTypeErasure((String)Signature.createTypeSignature((String)rtType, (boolean)true)));
        List explicitControls = this.getExplicityDefinedControlsForRT(rtTypeErasure, input);
        if (explicitControls != null) {
            return explicitControls;
        }
        final List[] listHolder = new List[1];
        Exception[] exceptionHolder = new Exception[1];
        Runnable busyRunnable = new Runnable(){

            @Override
            public void run() {
                JavaHelpers jclass = null;
                if (rtTypeErasure != null && !rtTypeErasure.equals("")) {
                    jclass = new JavaHelpers(rtTypeErasure, vc.getProject());
                    listHolder[0] = GenControlPanel.this.getControlsForRT(jclass, input, vc);
                }
            }
        };
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        if (exceptionHolder[0] != null) {
            if (exceptionHolder[0] instanceof CoreException) {
                throw new ClassNotFoundException(NLS.bind((String)ResourceHandler._EXC_classNotFound, (Object[])new String[]{rtType}));
            }
            if (exceptionHolder[0] instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exceptionHolder[0];
            }
            ClassNotFoundException e = new ClassNotFoundException();
            e.initCause(exceptionHolder[0]);
            throw e;
        }
        return listHolder[0];
    }

    public List getControlsForRT(JavaHelpers rtType, short input, IVirtualComponent vc) {
        int i = 0;
        while (i < this.rtTypes.length) {
            JavaHelpers jclass = this.rtTypes[i].rtType.get(vc);
            if (jclass instanceof JavaHelpers) {
                boolean isBothArray;
                JavaHelpers left = jclass;
                JavaHelpers right = rtType;
                boolean bl = isBothArray = right.isArray() && left.isArray();
                if (isBothArray) {
                    String leftElementName = Signature.toString((String)Signature.getElementType((String)left.signature));
                    left = new JavaHelpers(leftElementName, vc.getProject());
                    String rightElementName = Signature.toString((String)Signature.getElementType((String)right.signature));
                    right = new JavaHelpers(rightElementName, vc.getProject());
                }
                if (left.isAssignableFrom(right) || isBothArray && right.isPrimitive() && left.fullyQualifiedType.equals("java.lang.Object")) {
                    ArrayList ret = null;
                    if (input == 1) {
                        ret = new ArrayList(this.rtTypes[i].inputControlsList);
                    } else if (input == 2) {
                        ret = new ArrayList(this.rtTypes[i].outputControlsList);
                    } else if (input == 0) {
                        ret = new ArrayList(this.rtTypes[i].inputControlsList);
                        ArrayList temp = new ArrayList(this.rtTypes[i].outputControlsList);
                        if (ret != null && temp != null) {
                            for (Object element : temp) {
                                if (ret.contains(element)) continue;
                                ret.add(element);
                            }
                        } else if (ret == null && temp != null) {
                            ret = temp;
                        }
                    }
                    return ret;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public Generator getGeneratorForRT(final String rtType, final IVirtualComponent vc) throws ClassNotFoundException {
        Generator explicitGen = this.getExplicityDefinedGeneratorForRT(rtType);
        if (explicitGen != null) {
            return explicitGen;
        }
        final Generator[] generatorHolder = new Generator[1];
        Exception[] exceptionHolder = new Exception[1];
        Runnable busyRunnable = new Runnable(){

            @Override
            public void run() {
                JavaHelpers jclass = null;
                jclass = new JavaHelpers(rtType, vc.getProject());
                generatorHolder[0] = GenControlPanel.this.getGeneratorForRT(jclass, vc);
            }
        };
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        if (exceptionHolder[0] != null) {
            if (exceptionHolder[0] instanceof CoreException) {
                throw new ClassNotFoundException(NLS.bind((String)ResourceHandler._EXC_classNotFound, (Object[])new String[]{rtType}));
            }
            if (exceptionHolder[0] instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exceptionHolder[0];
            }
            ClassNotFoundException e = new ClassNotFoundException();
            e.initCause(exceptionHolder[0]);
            throw e;
        }
        return generatorHolder[0];
    }

    public Generator getGeneratorForRT(JavaHelpers rtType, IVirtualComponent vc) {
        int i = 0;
        while (i < this.rtTypes.length) {
            JavaHelpers jclass = this.rtTypes[i].rtType.get(vc);
            if (jclass instanceof JavaHelpers) {
                boolean isBothArray;
                JavaHelpers left = jclass;
                JavaHelpers right = rtType;
                boolean bl = isBothArray = right.isArray() && left.isArray();
                if (isBothArray) {
                    String leftElementName = Signature.toString((String)Signature.getElementType((String)left.signature));
                    left = new JavaHelpers(leftElementName, vc.getProject());
                    String rightElementName = Signature.toString((String)Signature.getElementType((String)right.signature));
                    right = new JavaHelpers(rightElementName, vc.getProject());
                }
                if (left.isAssignableFrom(right) || isBothArray && right.isPrimitive() && left.fullyQualifiedType.equals("java.lang.Object")) {
                    return this.rtTypes[i].generator.getGenerator();
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addGeneratorForRT(String rtType, GeneratorElement gen, IVirtualComponent vc) throws CoreException {
        int idx = -1;
        int i = 0;
        while (i < this.rtTypes.length) {
            RTypeListEntry entry = this.rtTypes[i];
            String entryType = entry.rtType.getType();
            if (entryType.equals(rtType)) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx >= 0) {
            RTypeListEntry existing = this.rtTypes[idx];
            existing.generator = gen;
        } else {
            RTypeListEntry entry = new RTypeListEntry(rtType);
            entry.generator = gen;
            RTypeListEntry[] temp = this.rtTypes;
            this.rtTypes = new RTypeListEntry[this.rtTypes.length + 1];
            System.arraycopy(temp, 0, this.rtTypes, 0, temp.length);
            this.rtTypes[temp.length] = entry;
        }
    }

    @Override
    public GeneratorElement getDefaultGenerator() {
        return this.defaultGenerator;
    }

    @Override
    public void setDefaultGenerator(GeneratorElement element) {
        this.defaultGenerator = element;
    }

    private IClasspathEntry[] getClasspathEntries(String controlId) {
        if (this.baseEntries == null) {
            this.baseEntries = new IClasspathEntry[1];
            this.baseEntries[0] = this.loadJREVar();
        }
        return this.baseEntries;
    }

    private IClasspathEntry loadJREVar() {
        return JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
    }

    @Override
    public List getControlIds() {
        return this.fControlIds;
    }

    @Override
    public boolean isRTExplicitlyDefined(String runtimeType) {
        boolean isExplicit = false;
        if (this.rtTypes != null && runtimeType != null) {
            int i = 0;
            while (i < this.rtTypes.length) {
                RTypeListEntry entry = this.rtTypes[i];
                if (entry != null && entry.rtType != null && entry.rtType.getType() != null && runtimeType.equals(entry.rtType.getType())) {
                    isExplicit = true;
                    break;
                }
                ++i;
            }
        }
        return isExplicit;
    }

    protected Generator getExplicityDefinedGeneratorForRT(String runtimeType) {
        Generator generator = null;
        if (this.rtTypes != null && runtimeType != null) {
            int i = 0;
            while (i < this.rtTypes.length) {
                RTypeListEntry entry = this.rtTypes[i];
                if (entry != null && entry.rtType != null && entry.rtType.getType() != null && runtimeType.equals(entry.rtType.getType())) {
                    generator = entry.generator.getGenerator();
                    break;
                }
                ++i;
            }
        }
        return generator;
    }

    protected List getExplicityDefinedControlsForRT(String runtimeType, short input) {
        if (this.rtTypes != null && runtimeType != null) {
            int i = 0;
            while (i < this.rtTypes.length) {
                RTypeListEntry entry = this.rtTypes[i];
                if (entry != null && entry.rtType != null && entry.rtType.getType() != null && runtimeType.equals(entry.rtType.getType())) {
                    ArrayList ret = null;
                    if (input == 1) {
                        ret = new ArrayList(entry.inputControlsList);
                    } else if (input == 2) {
                        ret = new ArrayList(entry.outputControlsList);
                    } else if (input == 0) {
                        ret = new ArrayList(entry.inputControlsList);
                        ArrayList temp = new ArrayList(entry.outputControlsList);
                        if (ret != null && temp != null) {
                            for (Object element : temp) {
                                if (ret.contains(element)) continue;
                                ret.add(element);
                            }
                        } else if (ret == null && temp != null) {
                            ret = temp;
                        }
                    }
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Object[] getRtTypes() {
        return this.rtTypes;
    }

    @Override
    public void sortRuntimeTypes(IVirtualComponent vc) {
        int i = 0;
        while (i < this.rtTypes.length) {
            this.rtTypes[i].rtType.introspect(vc.getProject(), this.rtTypes[i].rtType.type);
            ++i;
        }
        RTypeListEntry[] sortedTypes = new RTypeListEntry[this.rtTypes.length];
        int i2 = 0;
        while (i2 < this.rtTypes.length) {
            JavaHelpers jClass = this.rtTypes[i2].rtType.getJClass();
            int pos = this.getRTTypePosition(jClass, sortedTypes, i2, vc.getProject());
            if (pos == i2 + 1) {
                sortedTypes[i2] = this.rtTypes[i2];
            } else {
                System.arraycopy(sortedTypes, pos, sortedTypes, pos + 1, i2 - pos);
                sortedTypes[pos] = this.rtTypes[i2];
            }
            ++i2;
        }
        this.rtTypes = sortedTypes;
    }

    private int getRTTypePosition(JavaHelpers right, RTypeListEntry[] sortedTypes, int unsortedPos, IProject project) {
        if (right == null) {
            return unsortedPos + 1;
        }
        int i = 0;
        while (i < unsortedPos) {
            JavaHelpers jClass = sortedTypes[i].rtType.getJClass();
            if (jClass instanceof JavaHelpers) {
                boolean isBothArray;
                JavaHelpers left = jClass;
                boolean bl = isBothArray = right.isArray() && left.isArray();
                if (isBothArray) {
                    String leftElementName = Signature.toString((String)Signature.getElementType((String)left.signature));
                    left = new JavaHelpers(leftElementName, project);
                    String rightElementName = Signature.toString((String)Signature.getElementType((String)right.signature));
                    right = new JavaHelpers(rightElementName, project);
                }
                if (left.isAssignableFrom(right) || isBothArray && right.isPrimitive() && left.fullyQualifiedType.equals("java.lang.Object")) {
                    return i;
                }
            }
            ++i;
        }
        return unsortedPos + 1;
    }

    public void addDynamicTemplate(String templateID) {
        this.dynamicTemplates.add(templateID);
    }

    private class CompiledTemplate {
        public IGenerationTemplate template;
        public long modificationStamp;

        public CompiledTemplate(IGenerationTemplate template, long stamp) {
            this.template = template;
            this.modificationStamp = stamp;
        }
    }

    protected class JavaHelpers {
        public IType iType;
        public String signature;
        public String fullyQualifiedType;

        public String toString() {
            return this.fullyQualifiedType;
        }

        public JavaHelpers(String runTimeType, IProject project) {
            this.fullyQualifiedType = runTimeType;
            if (runTimeType != null && !runTimeType.equals("")) {
                this.signature = Signature.createTypeSignature((String)runTimeType, (boolean)true);
                String elementSignature = this.signature;
                if (Signature.getArrayCount((String)elementSignature) > 0) {
                    elementSignature = Signature.getElementType((String)elementSignature);
                }
                if (Signature.getTypeArguments((String)elementSignature).length > 0) {
                    elementSignature = Signature.getTypeErasure((String)elementSignature);
                }
                if (!this.isPrimitive()) {
                    try {
                        this.iType = JavaCore.create((IProject)project).findType(Signature.toString((String)elementSignature));
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public boolean isArray() {
            return Signature.getArrayCount((String)this.signature) > 0;
        }

        public boolean isPrimitive() {
            String type = this.fullyQualifiedType;
            if (this.isArray()) {
                type = Signature.toString((String)Signature.getElementType((String)this.signature));
            }
            if (type == null || type.length() == 0) {
                return false;
            }
            boolean isPrimitive = false;
            if (type.equals("float")) {
                isPrimitive = true;
            } else if (type.equals("double")) {
                isPrimitive = true;
            } else if (type.equals("long")) {
                isPrimitive = true;
            } else if (type.equals("int")) {
                isPrimitive = true;
            } else if (type.equals("boolean")) {
                isPrimitive = true;
            } else if (type.equals("short")) {
                isPrimitive = true;
            } else if (type.equals("byte")) {
                isPrimitive = true;
            } else if (type.equals("char")) {
                isPrimitive = true;
            }
            return isPrimitive;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isAssignableFrom(JavaHelpers aClass) {
            try {
                if (aClass.isPrimitive() || this.isPrimitive()) {
                    return false;
                }
                if (aClass.iType == null || this.iType == null) {
                    return false;
                }
                if (aClass.isArray() && !this.isArray() || !aClass.isArray() && this.isArray()) {
                    return false;
                }
                IType theClass = aClass.iType;
                ITypeHierarchy typeHierarchy = theClass.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] superTypes = typeHierarchy.getAllSupertypes(theClass);
                int i = 0;
                while (true) {
                    if (i >= superTypes.length) {
                        return !aClass.isPrimitive() && this.fullyQualifiedType.equals("java.lang.Object");
                    }
                    String superType = superTypes[i].getFullyQualifiedName();
                    if (superType.equals(this.iType.getFullyQualifiedName())) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    protected class RTypeListEntry {
        public MyMap rtType;
        List outputControlsList;
        List inputControlsList;
        public GeneratorElement generator;

        public RTypeListEntry(String type) {
            this.rtType = new MyMap(type);
            this.outputControlsList = new ArrayList();
            this.inputControlsList = new ArrayList();
        }

        public String toString() {
            return this.rtType.type;
        }

        private class MyMap {
            protected String type;
            private JavaHelpers jClass;

            public MyMap(String type) {
                this.type = type;
            }

            public JavaHelpers get(IVirtualComponent key) {
                JavaHelpers ret = null;
                if (this.type != null) {
                    ret = this.introspect(key.getProject(), this.type);
                }
                return ret;
            }

            public String getType() {
                return this.type;
            }

            protected JavaHelpers introspect(IProject project, Object jclass) {
                JavaHelpers temp = null;
                this.jClass = temp = new JavaHelpers(this.type, project);
                return temp;
            }

            public JavaHelpers getJClass() {
                return this.jClass;
            }
        }
    }
}

