/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CodeGenNode
implements ICodeGenNode {
    private static final Object customControlMapKey = new Object();
    protected IPageDataNode fPageDataNode;
    private boolean fIsSelected = true;
    private String fLabel;
    private String fFieldNameLabel;
    private String fControlId;
    private ICodeGenModel fCodeGenModel;
    private ICodeGenModel fChildCodeGenModel;
    private int fHowToCreate;
    private boolean fIsListNode = false;
    private boolean fIsComplex = false;
    private Map fCustomPropertyMap;

    public CodeGenNode(IPageDataNode node, ICodeGenModel model) {
        this.fPageDataNode = node;
        this.fCodeGenModel = model;
    }

    @Override
    public IPageDataNode getEnclosedNode() {
        return this.fPageDataNode;
    }

    @Override
    public void setSelected(boolean selected) {
        this.fIsSelected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.fIsSelected;
    }

    @Override
    public void setLabel(String label) {
        this.fLabel = label;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public void setControlId(String type) {
        this.fControlId = type;
    }

    @Override
    public String getControlId() {
        return this.fControlId;
    }

    @Override
    public ICodeGenModel getCodeGenModel() {
        return this.fCodeGenModel;
    }

    @Override
    public void setCodeGenModel(ICodeGenModel model) {
        this.fCodeGenModel = model;
    }

    public List getLegalControlIds(short ioType) {
        IBindingAttribute binding = (IBindingAttribute)this.fPageDataNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (binding == null) {
            return null;
        }
        List<String> ids = null;
        String pageType = this.fCodeGenModel.getPageType();
        try {
            String rtType = binding.getRuntimeType(this.fPageDataNode);
            IVirtualComponent component = this.fCodeGenModel.getTarget().getWebModel().getComponent();
            if (ioType != 0) {
                ids = CodeGenerationManager.getControlsForRT(pageType, rtType, ioType, component);
            } else {
                ids = CodeGenerationManager.getControlsForRT(pageType, rtType, (short)1, component);
                List temp = CodeGenerationManager.getControlsForRT(pageType, rtType, (short)2, component);
                if (ids != null && temp != null) {
                    ids.addAll(temp);
                } else if (ids == null && temp != null) {
                    ids = temp;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ids = new ArrayList<String>(1);
            ids.add(CodeGenerationManager.getDefaultControlId(pageType));
        }
        if (ids == null) {
            ids = new ArrayList(1);
            ids.add(CodeGenerationManager.getDefaultControlId(pageType));
        }
        return ids;
    }

    @Override
    public void setFieldNameLabel(String label) {
        this.fFieldNameLabel = label;
    }

    @Override
    public String getFieldNameLabel() {
        return this.fFieldNameLabel;
    }

    @Override
    public ICodeGenModel getChildCodeGenModel() {
        return this.fChildCodeGenModel;
    }

    @Override
    public void setChildCodeGenModel(ICodeGenModel model) {
        this.fChildCodeGenModel = model;
    }

    @Override
    public int getHowToCreate() {
        return this.fHowToCreate;
    }

    @Override
    public void setHowToCreate(int style) {
        this.fHowToCreate = style;
    }

    @Override
    public boolean isListNode() {
        return this.fIsListNode;
    }

    @Override
    public void setIsListNode(boolean isListNode) {
        this.fIsListNode = isListNode;
    }

    @Override
    public void addCustomProperty(Object key, Object value) {
        if (this.fCustomPropertyMap == null) {
            this.fCustomPropertyMap = new HashMap(1);
        }
        this.fCustomPropertyMap.put(key, value);
    }

    @Override
    public Object getCustomProperty(Object key) {
        return this.fCustomPropertyMap == null ? null : this.fCustomPropertyMap.get(key);
    }

    @Override
    public void addCustomControl(String id, short io) {
        if ("embedded.form".equals(id)) {
            if (!this.fIsComplex) {
                this.fIsComplex = true;
                this.addControl(id, (short)1);
                this.addControl(id, (short)2);
                this.addControl(id, (short)0);
            }
        } else if (this.fIsComplex) {
            this.addControl(id, io);
            if (io == 0) {
                this.addControl(id, (short)1);
                this.addControl(id, (short)2);
            } else {
                this.addControl(id, (short)0);
            }
        }
    }

    private void addControl(String id, short io) {
        List<String> controls = this.getCustomControlList(io, true);
        if (!controls.contains(id)) {
            controls.add(id);
        }
    }

    @Override
    public boolean isComplex() {
        return this.fIsComplex;
    }

    @Override
    public List<String> getAvailableControls(short io) {
        return this.fIsComplex ? this.getCustomControlList(io, true) : this.getDefaultControlList(io);
    }

    protected List<String> getDefaultControlList(short io) {
        return CodeGenUtil.getControlsForRT(this.getEnclosedNode(), this.getCodeGenModel(), io);
    }

    private List<String> getCustomControlList(short io, boolean force) {
        Short ioObject;
        ArrayList controls = null;
        HashMap map = (HashMap)this.getCustomProperty(customControlMapKey);
        if (map == null && force) {
            map = new HashMap();
            this.addCustomProperty(customControlMapKey, map);
        }
        if (map != null && (controls = (ArrayList)map.get(ioObject = Short.valueOf(io))) == null && force) {
            controls = new ArrayList();
            map.put(ioObject, controls);
        }
        return controls;
    }
}

