/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding.internal;

import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.CodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class CodeGenModel
implements ICodeGenModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private IProject fProject;
    private JSP fJSP;
    private String fPageType;
    private String fWidgetType;
    private ICodeGenNode fRoot;
    private List fCodeGenNodes;
    private boolean fIsList = false;
    private int fControlType = 0;
    private int fAlignment = 0;
    private boolean fUseColon = true;
    private boolean fUseCapitalization = true;
    private boolean fGenValidation = false;
    private boolean fCreateSubmitButton = true;
    private boolean fCreateDeleteButton = true;
    private String fSubmitButtonLabel = ResourceHandler.UI_Submit;
    private String fDeleteButtonLabel = ResourceHandler.UI_Delete;
    private PageActionNode fSubmitButtonAction;
    private PageActionNode fDeleteButtonAction;
    private HashMap fRuntimeToControlsMap;
    private HashMap fControlIdToLabelMap;
    private String fDefaultControlId;
    private String fControlId = "formattedControls";
    private int fDepth = 4;
    private boolean fIsFinalized = false;
    private Map fCustomPropertyMap;
    private ICodeGenModel fNextModel;
    private ICodeGenModel fPreviousModel;

    protected CodeGenModel() {
    }

    public CodeGenModel(IProject project, String pageType) {
        this.fProject = project;
        this.fPageType = pageType;
    }

    public CodeGenModel(IProject project, String pageType, ICodeGenNode root) {
        this.fProject = project;
        this.fPageType = pageType;
        this.setRoot(root);
    }

    public CodeGenModel(IProject project, String pageType, IPageDataNode pdRoot) {
        this.fProject = project;
        this.fPageType = pageType;
        this.setRoot(new CodeGenNode(pdRoot, this));
    }

    public CodeGenModel(JSP jsp, String pageType) {
        this.fJSP = jsp;
        this.fPageType = pageType;
    }

    public CodeGenModel(JSP jsp, String pageType, ICodeGenNode root) {
        this(jsp, pageType);
        this.setRoot(root);
    }

    public CodeGenModel(JSP jsp, String pageType, IPageDataNode pdRoot) {
        this(jsp, pageType);
        this.setRoot(new CodeGenNode(pdRoot, this));
    }

    @Override
    public void setRoot(ICodeGenNode node) {
        this.fRoot = node;
    }

    @Override
    public ICodeGenNode getRoot() {
        return this.fRoot;
    }

    @Override
    public void setControlId(String Id) {
        this.fControlId = Id;
    }

    @Override
    public String getControlId() {
        return this.fControlId;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public String getPageType() {
        return this.fPageType;
    }

    @Override
    public void addCustomProperty(Object key, Object value) {
        this.getCustomProperties().put(key, value);
    }

    @Override
    public void addRootProperty(Object key, Object value) {
        this.getRootProperties().put(key, value);
    }

    @Override
    public void addLocalProperty(Object key, Object value) {
        if (this.fCustomPropertyMap == null) {
            this.fCustomPropertyMap = new HashMap(1);
        }
        this.fCustomPropertyMap.put(key, value);
    }

    @Override
    public Object getLocalProperty(Object key) {
        return this.fCustomPropertyMap == null ? null : this.fCustomPropertyMap.get(key);
    }

    @Override
    public Object getCustomProperty(Object key) {
        Map customProperties = this.getCustomProperties();
        return customProperties == null ? null : customProperties.get(key);
    }

    @Override
    public Object getRootProperty(Object key) {
        Map rootProperties = this.getRootProperties();
        return rootProperties == null ? null : rootProperties.get(key);
    }

    @Override
    public Map getCustomProperties() {
        ICodeGenModel model;
        ICodeGenNode cgRoot = this.getRoot();
        if (cgRoot != null && (model = cgRoot.getCodeGenModel()) != this && model != null) {
            return model.getCustomProperties();
        }
        if (this.getPreviousModel() != null) {
            return this.getPreviousModel().getCustomProperties();
        }
        if (this.fCustomPropertyMap == null) {
            this.fCustomPropertyMap = new HashMap(1);
        }
        return this.fCustomPropertyMap;
    }

    @Override
    public Map getRootProperties() {
        ICodeGenModel model;
        ICodeGenNode cgRoot = this.getRoot();
        if (cgRoot != null && (model = cgRoot.getCodeGenModel()) != this && model != null) {
            return model.getRootProperties();
        }
        if (this.fCustomPropertyMap == null) {
            this.fCustomPropertyMap = new HashMap(1);
        }
        return this.fCustomPropertyMap;
    }

    @Override
    public List getCodeGenNodes() {
        return this.fCodeGenNodes != null ? this.fCodeGenNodes : Collections.EMPTY_LIST;
    }

    @Override
    public void setCodeGenNodes(List nodes) {
        this.fCodeGenNodes = nodes;
    }

    @Override
    public String getWidgetType() {
        return this.fWidgetType == null ? this.getPageType() : this.fWidgetType;
    }

    @Override
    public void setWidgetType(String widgetType) {
        this.fWidgetType = widgetType;
    }

    public HashMap getRuntimeToControlsMap() {
        CodeGenModel model = (CodeGenModel)this.getRoot().getCodeGenModel();
        if (model != this) {
            return model.getRuntimeToControlsMap();
        }
        if (this.fRuntimeToControlsMap == null) {
            this.fRuntimeToControlsMap = new HashMap();
        }
        return this.fRuntimeToControlsMap;
    }

    public HashMap getControlIdToLabelMap() {
        CodeGenModel model = (CodeGenModel)this.getRoot().getCodeGenModel();
        if (model != this) {
            return model.getControlIdToLabelMap();
        }
        if (this.fControlIdToLabelMap == null) {
            this.fControlIdToLabelMap = new HashMap();
        }
        return this.fControlIdToLabelMap;
    }

    @Override
    public void addNode(ICodeGenNode node) {
        if (this.fCodeGenNodes == null) {
            this.fCodeGenNodes = new ArrayList(1);
        }
        this.fCodeGenNodes.add(node);
    }

    @Override
    public boolean isList() {
        return this.fIsList;
    }

    @Override
    public void setIsList(boolean isList) {
        this.fIsList = isList;
    }

    public String getDefaultControlId() {
        CodeGenModel model = (CodeGenModel)this.getRoot().getCodeGenModel();
        if (model != this) {
            return model.getDefaultControlId();
        }
        if (this.fDefaultControlId == null) {
            this.fDefaultControlId = CodeGenerationManager.getDefaultControlId(this.getPageType());
        }
        return this.fDefaultControlId;
    }

    @Override
    public void setControlType(int type) {
        this.fControlType = type;
    }

    @Override
    public int getControlType() {
        return this.fControlType;
    }

    @Override
    public void setAlignment(int alignment) {
        this.fAlignment = alignment;
    }

    @Override
    public int getAlignment() {
        return this.fAlignment;
    }

    @Override
    public void setUseColon(boolean useColon) {
        this.fUseColon = useColon;
    }

    @Override
    public boolean isUseColon() {
        return this.fUseColon;
    }

    @Override
    public void setCapitalizeLabel(boolean capitalize) {
        this.fUseCapitalization = capitalize;
    }

    @Override
    public boolean isCapitalizeLabel() {
        return this.fUseCapitalization;
    }

    @Override
    public void moveDown(ICodeGenNode node) {
        List nodes;
        int index;
        if (node != null && (index = (nodes = this.getCodeGenNodes()).indexOf(node)) >= 0 && index < nodes.size() - 1) {
            nodes.remove(index);
            nodes.add(index + 1, node);
        }
    }

    @Override
    public void moveUp(ICodeGenNode node) {
        List nodes;
        int index;
        if (node != null && (index = (nodes = this.getCodeGenNodes()).indexOf(node)) > 0) {
            nodes.remove(index);
            nodes.add(index - 1, node);
        }
    }

    @Override
    public void setGenValidation(boolean validation) {
        this.fGenValidation = validation;
    }

    @Override
    public boolean isGenValidation() {
        return this.fGenValidation;
    }

    @Override
    public void setCreateSubmitButton(boolean doCreate) {
        this.fCreateSubmitButton = doCreate;
    }

    @Override
    public boolean isCreateSubmitButton() {
        return this.fCreateSubmitButton;
    }

    @Override
    public void setSubmitButtonLabel(String label) {
        this.fSubmitButtonLabel = label;
    }

    @Override
    public String getSubmitButtonLabel() {
        return this.fSubmitButtonLabel;
    }

    @Override
    public void setCreateDeleteButton(boolean doCreate) {
        this.fCreateDeleteButton = doCreate;
    }

    @Override
    public boolean isCreateDeleteButton() {
        return this.fCreateDeleteButton;
    }

    @Override
    public void setDeleteButtonLabel(String label) {
        this.fDeleteButtonLabel = label;
    }

    @Override
    public String getDeleteButtonLabel() {
        return this.fDeleteButtonLabel;
    }

    @Override
    public PageActionNode getDeleteButtonAction() {
        return this.fDeleteButtonAction;
    }

    @Override
    public PageActionNode getSubmitButtonAction() {
        return this.fSubmitButtonAction;
    }

    @Override
    public void setDeleteButtonAction(PageActionNode node) {
        this.fDeleteButtonAction = node;
    }

    @Override
    public void setSubmitButtonAction(PageActionNode node) {
        this.fSubmitButtonAction = node;
    }

    @Override
    public int getDepth() {
        return this.fDepth;
    }

    @Override
    public void setDepth(int depth) {
        this.fDepth = depth;
    }

    @Override
    public ICodeGenModel getNextModel() {
        return this.fNextModel;
    }

    @Override
    public ICodeGenModel getPreviousModel() {
        return this.fPreviousModel;
    }

    @Override
    public void setNextModel(ICodeGenModel model) {
        this.fNextModel = model;
    }

    @Override
    public void setPreviousModel(ICodeGenModel model) {
        this.fPreviousModel = model;
    }

    @Override
    public JSP getTarget() {
        return this.fJSP;
    }

    @Override
    public void setTarget(JSP jsp) {
        this.fJSP = jsp;
    }

    public boolean isFinalized() {
        return this.fIsFinalized;
    }

    public void setFinalized(boolean isFinalized) {
        this.fIsFinalized = isFinalized;
    }
}

