/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;

public class PageDataModelRegistryReader
extends RegistryReader {
    public static final String LSTNR_EXT_PNT_ID = "pageDataModelListeners";
    public static final String LSTNR_ELMNT = "listener";
    public static final String FACS_EXT_PNT_ID = "adapterFactories";
    public static final String FAC_ELMNT = "factory";
    public static final String CLASS_ATT = "class";
    public static final String LABEL_ATT = "label";
    public static final String ID_ATT = "id";
    public static final String ICON_ATT = "icon";
    public static final String PT_ATT = "pageType";
    public static final String ELEM_FACET = "facet";
    public static final String ATT_FACET_EXISTS = "exists";
    public static final String ATT_FACET_VERSION = "version";
    public static final String ELEM_OR = "or";
    private static PageDataModelRegistryReader singleton;
    private List pageDataModelListenerConfigElements = new ArrayList(1);
    private boolean modelListenersParsed = false;
    private Map listenerClasses = new HashMap();
    private List adapterFactories;
    private boolean adapterFactoriesParsed = false;

    protected PageDataModelRegistryReader() {
    }

    private void parseModelListeners() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataModelPlugin.getDefault().getBundle().getSymbolicName(), LSTNR_EXT_PNT_ID);
    }

    private void parseAdapterFactories() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataModelPlugin.getDefault().getBundle().getSymbolicName(), FACS_EXT_PNT_ID);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(LSTNR_ELMNT)) {
            return this.parseListenerElement(element);
        }
        if (element.getName().equalsIgnoreCase(FAC_ELMNT)) {
            return this.parseFactoryElement(element);
        }
        return false;
    }

    private boolean parseFactoryElement(IConfigurationElement element) {
        String factoryClass = element.getAttribute(CLASS_ATT);
        if (factoryClass != null) {
            Object factoryObject = null;
            try {
                factoryObject = element.createExecutableExtension(CLASS_ATT);
            }
            catch (CoreException coreException) {
                this.logError(element, NLS.bind((String)ResourceHandler._EXC_factory, (Object[])new String[]{factoryClass}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (factoryObject != null) {
                if (this.adapterFactories == null) {
                    this.adapterFactories = new ArrayList(1);
                }
                this.adapterFactories.add(factoryObject);
            }
            return true;
        }
        return false;
    }

    private boolean parseListenerElement(IConfigurationElement element) {
        String listenerClass = element.getAttribute(CLASS_ATT);
        if (listenerClass != null) {
            this.pageDataModelListenerConfigElements.add(element);
            return true;
        }
        return false;
    }

    private IPageDataModelLifeCycleListener[] getListeners() {
        if (!this.modelListenersParsed) {
            this.parseModelListeners();
            this.modelListenersParsed = true;
        }
        ArrayList<Object> pageDataModelListenerClasses = new ArrayList<Object>();
        int i = 0;
        while (i < this.pageDataModelListenerConfigElements.size()) {
            Object listenerClass;
            IConfigurationElement element = (IConfigurationElement)this.pageDataModelListenerConfigElements.get(i);
            if (this.listenerClasses.get(element) == null) {
                listenerClass = this.createListenerClass(element);
                this.listenerClasses.put(element, listenerClass);
            } else {
                listenerClass = this.listenerClasses.get(element);
            }
            pageDataModelListenerClasses.add(listenerClass);
            ++i;
        }
        return pageDataModelListenerClasses.toArray(new IPageDataModelLifeCycleListener[0]);
    }

    private Object createListenerClass(IConfigurationElement element) {
        String listenerClass = element.getAttribute(CLASS_ATT);
        Object classObject = null;
        try {
            classObject = element.createExecutableExtension(CLASS_ATT);
        }
        catch (CoreException coreException) {
            this.logError(element, NLS.bind((String)ResourceHandler._EXC_listener, (Object[])new String[]{listenerClass}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classObject;
    }

    public static IPageDataModelLifeCycleListener[] getPageDataModelListeners() {
        if (singleton == null) {
            singleton = new PageDataModelRegistryReader();
        }
        return singleton.getListeners();
    }

    public static IPageDataModelLifeCycleListener[] getPageDataModelListeners(IProject project) {
        if (singleton == null) {
            singleton = new PageDataModelRegistryReader();
        }
        return singleton.getListeners(project);
    }

    public static IPageDataModelLifeCycleListener[] getCachedPageDataModelListeners() {
        if (singleton == null) {
            singleton = new PageDataModelRegistryReader();
        }
        return singleton.getCachedListeners();
    }

    private IPageDataModelLifeCycleListener[] getCachedListeners() {
        ArrayList cachedListeners = new ArrayList();
        cachedListeners.addAll(this.listenerClasses.values());
        return cachedListeners.toArray(new IPageDataModelLifeCycleListener[0]);
    }

    private IPageDataModelLifeCycleListener[] getListeners(IProject project) {
        if (!this.modelListenersParsed) {
            this.parseModelListeners();
            this.modelListenersParsed = true;
        }
        ArrayList<Object> listenerClassesForThisProject = new ArrayList<Object>();
        int i = 0;
        while (i < this.pageDataModelListenerConfigElements.size()) {
            IConfigurationElement element = (IConfigurationElement)this.pageDataModelListenerConfigElements.get(i);
            IConfigurationElement[] facetElements = element.getChildren(ELEM_FACET);
            IConfigurationElement[] orLists = element.getChildren(ELEM_OR);
            boolean orGroupsSatisfied = true;
            int j = 0;
            while (j < orLists.length) {
                if (!this.processOrList(orLists[j], project)) {
                    orGroupsSatisfied = false;
                    break;
                }
                ++j;
            }
            if (orGroupsSatisfied) {
                boolean facetsSatisfied = true;
                int j2 = 0;
                while (j2 < facetElements.length) {
                    String facetID = facetElements[j2].getAttribute(ID_ATT);
                    boolean shouldExist = facetElements[j2].getAttribute(ATT_FACET_EXISTS) == null ? true : Boolean.valueOf(facetElements[j2].getAttribute(ATT_FACET_EXISTS));
                    if (this.projectHasFacet(project, facetID, null) != shouldExist) {
                        facetsSatisfied = false;
                        break;
                    }
                    ++j2;
                }
                if (facetsSatisfied) {
                    Object listenerClass;
                    if (this.listenerClasses.get(element) == null) {
                        listenerClass = this.createListenerClass(element);
                        this.listenerClasses.put(element, listenerClass);
                    } else {
                        listenerClass = this.listenerClasses.get(element);
                    }
                    listenerClassesForThisProject.add(listenerClass);
                }
            }
            ++i;
        }
        return listenerClassesForThisProject.toArray(new IPageDataModelLifeCycleListener[0]);
    }

    private boolean processOrList(IConfigurationElement orList, IProject proj) {
        boolean satisfied = false;
        IConfigurationElement[] facets = orList.getChildren(ELEM_FACET);
        int i = 0;
        while (i < facets.length) {
            IConfigurationElement facetElement = facets[i];
            boolean shouldExist = facetElement.getAttribute(ATT_FACET_EXISTS) == null ? true : Boolean.valueOf(facetElement.getAttribute(ATT_FACET_EXISTS));
            String facetID = facetElement.getAttribute(ID_ATT);
            String facetVersion = facetElement.getAttribute(ATT_FACET_VERSION);
            if (facetVersion == "") {
                facetVersion = null;
            }
            if (this.projectHasFacet(proj, facetID, facetVersion) == shouldExist) {
                satisfied = true;
                break;
            }
            ++i;
        }
        return satisfied;
    }

    public static List getAdapterFactories() {
        if (singleton == null) {
            singleton = new PageDataModelRegistryReader();
        }
        if (!PageDataModelRegistryReader.singleton.adapterFactoriesParsed) {
            singleton.parseAdapterFactories();
            PageDataModelRegistryReader.singleton.adapterFactoriesParsed = true;
        }
        return PageDataModelRegistryReader.singleton.adapterFactories;
    }

    private boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }
}

