/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.util;

import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.viewer.utils.ModelAdapterFactoryRegistry;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.ModelPlugin;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.model.api.WebNode;
import com.ibm.etools.webtools.model.api.WebPage;
import com.ibm.etools.webtools.model.framework.WebNodeHelper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class ModelUtil {
    private static ModelUtil INSTANCE;
    private final Map fJsp2EditDomain = new HashMap();
    private final Map fEditDomain2JSP = new HashMap();

    private ModelUtil() {
    }

    private static ModelUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelUtil();
        }
        return INSTANCE;
    }

    public static WebModel getModel(IResource resource) throws WebModelCreationException {
        return ModelManager.getModel(resource);
    }

    public static WebModel getModel(IVirtualComponent component) throws WebModelCreationException {
        return ModelManager.getModel(component);
    }

    public static HTMLEditDomain getEditDomain(WebPage page) {
        return ModelUtil.getEditDomain(page, false);
    }

    public static HTMLEditDomain getEditDomain(WebPage page, boolean forceProxy) {
        return ModelUtil.getInstance().getEditDomainForceProxy(page, forceProxy);
    }

    public HTMLEditDomain getEditDomainForceProxy(WebPage page, boolean proxy) {
        HTMLEditDomain editDomain = null;
        if (page != null) {
            IDOMModel activeModel;
            IFile file;
            IEditorPart editor;
            IWorkbenchPage wbPage;
            IWorkbenchWindow workbenchWindow;
            IWorkbench workbench;
            if (!proxy && PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (wbPage = workbenchWindow.getActivePage()) != null && (editor = wbPage.getActiveEditor()) != null && editor instanceof HTMLEditDomain && (file = ModelUtil.getFileFor(activeModel = ((HTMLEditDomain)editor).getActiveModel())) != null && file.equals((Object)page.getFile())) {
                editDomain = (HTMLEditDomain)editor.getAdapter(HTMLEditDomain.class);
            }
            if (editDomain == null) {
                editDomain = this.getEditDomainProxy(page);
                IDOMModel dom = editDomain.getActiveModel();
                if (((DomainWrapper)this.fJsp2EditDomain.get((Object)page)).fCount == 1) {
                    if (!dom.isShared()) {
                        EditorModelUtil.addFactoriesTo((IStructuredModel)dom);
                    }
                    ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)dom);
                    ModelUtil.initMediator(editDomain);
                }
            }
        }
        return editDomain;
    }

    public static final IFile getFileFor(IDOMModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path resourcePath = new Path(path);
        if (resourcePath.segmentCount() == 1) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            resourcePath = new Path(id.toString());
        }
        IFile file = resourcePath.toFile().exists() ? root.getFileForLocation((IPath)resourcePath) : root.getFile((IPath)resourcePath);
        return file;
    }

    private synchronized HTMLEditDomain getEditDomainProxy(WebPage page) {
        HTMLEditDomainCommandProxy editDomain;
        DomainWrapper wrapper = (DomainWrapper)this.fJsp2EditDomain.get(page);
        HTMLEditDomainCommandProxy hTMLEditDomainCommandProxy = editDomain = wrapper != null ? wrapper.getEditDomain() : null;
        if (editDomain == null) {
            editDomain = new HTMLEditDomainCommandProxy(page.getModel());
            this.put(page, editDomain);
        }
        return editDomain;
    }

    public static Object getAdapter(HTMLEditDomain editDomain, Class clz) {
        return editDomain.getActiveModel().getDocument().getAdapterFor((Object)clz);
    }

    protected Object getDomAdapter(HTMLEditDomain editDomain, Class clz) {
        JSP jsp = (JSP)this.fEditDomain2JSP.get(editDomain);
        DomainWrapper wrapper = (DomainWrapper)this.fJsp2EditDomain.get(jsp);
        return wrapper != null ? wrapper.getAdapter(clz) : null;
    }

    private void put(WebPage page, HTMLEditDomainCommandProxy editDomain) {
        this.fJsp2EditDomain.put(page, new DomainWrapper(editDomain));
        this.fEditDomain2JSP.put(editDomain, page);
    }

    private static void initMediator(HTMLEditDomain editDomain) {
        IDOMModel dom = editDomain.getModel();
        IDOMNode node = SelectionUtil.getNodeFromSourceOffset((IStructuredModel)dom, (int)0);
        int offset = SelectionUtil.calcRangeOffset((IDOMNode)node, (int)0);
        if (node == null) {
            node = dom.getDocument();
            offset = 0;
        }
        try {
            Range range = null;
            if (node != null) {
                range = ((DocumentRange)dom.getDocument()).createRange();
                range.setStart((Node)node, offset);
                range.setEnd((Node)node, offset);
            }
            Node focusNode = null;
            if (range != null && range.getStartContainer() == range.getEndContainer() && range.getStartOffset() == range.getEndOffset()) {
                focusNode = range.getEndContainer();
            }
            editDomain.getSelectionMediator().setRange(range, focusNode);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
    }

    public static void releaseEditDomain(HTMLEditDomain domain) {
        if (domain != null && domain instanceof HTMLEditDomainCommandProxy) {
            try {
                ModelUtil.getInstance().release((HTMLEditDomainCommandProxy)domain);
            }
            catch (Exception e) {
                Status status = new Status(4, ModelPlugin.getDefault().getBundle().getSymbolicName(), 4, "Error during release of edit model: " + e.getMessage(), (Throwable)e);
                ModelPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public static void releaseAndSaveIfNecessaryEditDomain(HTMLEditDomain domain) throws Exception {
        if (domain != null && domain instanceof HTMLEditDomainCommandProxy) {
            ModelUtil.getInstance().release((HTMLEditDomainCommandProxy)domain);
        }
    }

    private synchronized void release(HTMLEditDomainCommandProxy domain) throws Exception {
        int count;
        WebPage page = (WebPage)this.fEditDomain2JSP.get(domain);
        DomainWrapper wrapper = (DomainWrapper)this.fJsp2EditDomain.get(page);
        CommandResult result = wrapper.releaseEditDomain(domain);
        if (result.getReturnValue() != null && (count = ((Integer)result.getReturnValue()).intValue()) == 0) {
            this.fJsp2EditDomain.remove(page);
        }
        if (!result.getStatus().isOK() && result.getStatus().getException() != null) {
            throw (Exception)result.getStatus().getException();
        }
    }

    public static HTMLEditDomain getEditDomain(IFile file) throws WebModelCreationException {
        try {
            IVirtualComponent component = ComponentUtilities.findComponent((IResource)file);
            WebModel model = ModelManager.getModel(component);
            WebPage page = model.getPage(file);
            return ModelUtil.getEditDomain(page);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static WebNodeHelper getWebNodeHelper(WebNode node) {
        return new WebNodeHelper(node);
    }

    private class DomainWrapper {
        private HTMLEditDomainCommandProxy fEditDomain;
        private Map fAdapterMap;
        int fCount = 1;

        private DomainWrapper(HTMLEditDomainCommandProxy editDomain) {
            this.fEditDomain = editDomain;
        }

        HTMLEditDomainCommandProxy getEditDomain() {
            if (this.fEditDomain != null) {
                ++this.fCount;
            }
            return this.fEditDomain;
        }

        CommandResult releaseEditDomain(HTMLEditDomainCommandProxy editDomain) {
            Status status = new Status(0, ModelPlugin.getDefault().getBundle().getSymbolicName(), 0, "OK", null);
            if (editDomain != null && editDomain == this.fEditDomain) {
                if (--this.fCount == 0) {
                    try {
                        IDOMModel model = this.fEditDomain.getActiveModel();
                        if (StructuredModelManager.getModelManager().getReferenceCountForEdit((Object)model.getId()) == 1 && model.isDirty()) {
                            model.save();
                        }
                    }
                    catch (Exception e) {
                        status = new Status(4, ModelPlugin.getDefault().getBundle().getSymbolicName(), 4, e.getMessage() == null ? "Error during save" : e.getMessage(), (Throwable)e);
                    }
                    this.fEditDomain.dispose();
                    ModelUtil.this.fEditDomain2JSP.remove(this.fEditDomain);
                    this.fEditDomain = null;
                }
            } else {
                status = new Status(4, ModelPlugin.getDefault().getBundle().getSymbolicName(), 4, "Trying to release edit domain for which we are not a proxy", null);
                return new CommandResult((IStatus)status, (Object)new Integer(-1));
            }
            return new CommandResult((IStatus)status, (Object)new Integer(this.fCount));
        }

        Object getAdapter(Class clz) {
            IDOMDocument doc;
            Object adapter;
            if (this.fAdapterMap == null) {
                this.fAdapterMap = new HashMap();
            }
            if ((adapter = this.fAdapterMap.get(clz)) == null && (adapter = (doc = this.fEditDomain.getActiveModel().getDocument()).getAdapterFor((Object)clz)) != null) {
                this.fAdapterMap.put(clz, adapter);
            }
            return adapter;
        }
    }
}

