/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.internal;

import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.model.api.WebNode;
import com.ibm.etools.webtools.model.api.WebPage;
import com.ibm.etools.webtools.model.framework.INodeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class WebPageProvider
implements INodeProvider {
    protected List fValidExtensions = null;

    protected abstract WebPage createPage(IFile var1, WebModel var2);

    protected abstract String getContentTypeID();

    @Override
    public boolean updateFeature(WebNode parent, List feature) {
        boolean changed = false;
        if (feature != null) {
            List projectFiles = this.getProjectFiles(parent.getWebModel());
            List modelFiles = this.getModelFiles(feature);
            for (IFile file : modelFiles) {
                if (projectFiles.contains(file)) continue;
                this.remove(feature, file);
                changed = true;
            }
            ArrayList<WebPage> temp = new ArrayList<WebPage>(projectFiles.size());
            for (IFile file : projectFiles) {
                if (modelFiles.contains(file)) continue;
                temp.add(this.createPage(file, parent.getWebModel()));
                changed = true;
            }
            if (temp.size() > 0) {
                feature.addAll(temp);
            }
        }
        return changed;
    }

    protected void remove(List feature, IFile file) {
        for (WebPage page : feature) {
            if (!file.equals((Object)page.getFile())) continue;
            feature.remove(page);
            return;
        }
    }

    protected List getProjectFiles(WebModel node) {
        IVirtualComponent component = node.getComponent();
        IContainer container = component.getRootFolder().getUnderlyingFolder();
        return this.getFiles(container, node);
    }

    protected List getModelFiles(List feature) {
        ArrayList<IFile> existingFiles = new ArrayList<IFile>(feature.size());
        for (WebPage page : feature) {
            existingFiles.add(page.getFile());
        }
        return existingFiles;
    }

    protected List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = Platform.getContentTypeManager().getContentType(this.getContentTypeID());
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private List getFiles(IContainer container, WebModel webModel) {
        ArrayList<IResource> fileList = new ArrayList<IResource>();
        List validExtensions = this.getValidExtensions();
        try {
            IResource[] resources = container.members();
            String fileExtension = null;
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() == 1) {
                    fileExtension = resources[i].getFileExtension();
                    if (fileExtension != null && validExtensions.contains(fileExtension)) {
                        fileList.add(resources[i]);
                    }
                } else if (resources[i].getType() == 2) {
                    fileList.addAll(this.getFiles((IContainer)resources[i], webModel));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return fileList;
    }

    private List getPages(IContainer container, WebModel webModel) {
        List fileList = this.getFiles(container, webModel);
        ArrayList<WebPage> pageList = new ArrayList<WebPage>(fileList.size());
        Iterator iter = fileList.iterator();
        while (iter.hasNext()) {
            pageList.add(this.createPage((IFile)iter.next(), webModel));
        }
        return pageList;
    }

    @Override
    public INodeProvider.FeatureContainer getFeature(WebNode node, boolean updating) {
        IVirtualComponent component = ((WebModel)node).getComponent();
        IContainer container = component.getRootFolder().getUnderlyingFolder();
        List pages = this.getPages(container, (WebModel)node);
        return new INodeProvider.FeatureContainer(null, pages);
    }

    @Override
    public INodeProvider.FeatureContainer getFeatureByTypeId(WebNode node, String nodeTypeId, boolean updating) {
        return this.isProviderOfNodeType(nodeTypeId) ? this.getFeature(node, updating) : null;
    }
}

