/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.internal;

import com.ibm.etools.webtools.model.ModelFactory;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.model.api.WebNode;
import com.ibm.etools.webtools.model.framework.INodeProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class RegistryReader {
    public static RegistryReader INSTANCE;
    private static final String NAME_SPACE = "com.ibm.etools.webtools.model.";
    public static final String NODE_PROVIDER_EXT_PT = "nodeProvider";
    public static final String PROVIDER__PROVIDER = "provider";
    public static final String PROVIDER__PROVIDER_ID = "id";
    public static final String PROVIDER__PROVIDER_PARENT = "parent";
    public static final String PROVIDER__PROVIDER_FEATURE = "feature";
    public static final String PROVIDER__PROVIDER_CLASS = "class";
    public static final String PROVIDER__NODETYPE = "nodeType";
    public static final String PROVIDER__NODETYPE_ID = "id";
    public static final String PROVIDER__NODETYPE_EXTENDS = "extends";
    Map fExtPt2ExtensionsMap;
    private Map fComponent2ModelMap;
    private Map fModel2NPMMap = new HashMap(5);

    public static void reset() {
        INSTANCE = new RegistryReader();
    }

    private RegistryReader() {
        this.fExtPt2ExtensionsMap = new HashMap(5);
    }

    public static RegistryReader getReader(ModelManager manager) {
        return manager == null ? null : (INSTANCE == null ? (INSTANCE = new RegistryReader()) : INSTANCE);
    }

    public List getNodeProviders(WebModel webModel, WebNode parentNode, String featureName) {
        NodeProviderManager npm = (NodeProviderManager)this.fModel2NPMMap.get(webModel);
        if (npm == null) {
            npm = new NodeProviderManager();
            this.fModel2NPMMap.put(webModel, npm);
        }
        List providers = npm.getProviders(parentNode, featureName);
        return providers;
    }

    public INodeProvider getDefaultProvider(WebModel webModel, WebNode parentNode, String featureName) {
        NodeProviderManager npm = (NodeProviderManager)this.fModel2NPMMap.get(webModel);
        if (npm == null) {
            npm = new NodeProviderManager();
            this.fModel2NPMMap.put(webModel, npm);
        }
        List providers = npm.getProviders(parentNode, featureName);
        INodeProvider provider = null;
        for (INodeProvider element : providers) {
            if (!element.isProviderOfNodeType("default")) continue;
            provider = element;
            break;
        }
        return provider;
    }

    public WebModel getWebModel(IVirtualComponent vc) {
        WebModel webModel;
        if (vc == null) {
            return null;
        }
        if (this.fComponent2ModelMap == null) {
            this.fComponent2ModelMap = new HashMap(5);
        }
        if ((webModel = (WebModel)this.fComponent2ModelMap.get(vc.getProject())) == null) {
            webModel = ModelFactory.eINSTANCE.createWebModel(vc);
            this.fComponent2ModelMap.put(vc.getProject(), webModel);
        }
        return webModel;
    }

    protected IConfigurationElement getConfigElement(IExtension extension, String elementName, String attrib, String value) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        IConfigurationElement element = null;
        int j = 0;
        while (j < elements.length) {
            if (elementName.equals(elements[j].getName())) {
                if (attrib != null && value != null && !value.equals(elements[j].getAttribute(attrib))) break;
                element = elements[j];
                break;
            }
            ++j;
        }
        return element;
    }

    protected IConfigurationElement[] getConfigElements(IExtension extension, String elementName) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ArrayList<IConfigurationElement> namedElements = new ArrayList<IConfigurationElement>(5);
        int j = 0;
        while (j < elements.length) {
            if (elementName.equals(elements[j].getName())) {
                namedElements.add(elements[j]);
            }
            ++j;
        }
        return namedElements.toArray(new IConfigurationElement[namedElements.size()]);
    }

    private IExtension[] getExtensions(String ext) {
        IExtension[] extensions = (IExtension[])this.fExtPt2ExtensionsMap.get(ext);
        extensions = null;
        if (extensions == null) {
            IExtensionPoint extension_point = Platform.getExtensionRegistry().getExtensionPoint(NAME_SPACE + ext);
            extensions = extension_point != null ? extension_point.getExtensions() : new IExtension[]{};
            this.fExtPt2ExtensionsMap.put(ext, extensions);
        }
        return extensions;
    }

    private List getConfigElements(String ext, String element, String[] attrib_value) {
        ArrayList<IConfigurationElement> elementList = new ArrayList<IConfigurationElement>(5);
        IExtension[] extensions = this.getExtensions(ext);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (element.equals(elements[j].getName())) {
                    boolean addElement = true;
                    if (attrib_value != null) {
                        int k = 0;
                        while (k < attrib_value.length / 2) {
                            String v = elements[j].getAttribute(attrib_value[k * 2]);
                            if (!attrib_value[k * 2 + 1].equals(v)) {
                                addElement = false;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (addElement) {
                        elementList.add(elements[j]);
                    }
                }
                ++j;
            }
            ++i;
        }
        return elementList;
    }

    private Object createObject(IConfigurationElement element, String cls) {
        Object object = null;
        if (element != null) {
            try {
                object = element.createExecutableExtension(cls);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    class NodeProviderManager {
        Map fProviderMap = new HashMap(5);

        NodeProviderManager() {
        }

        List getProviders(WebNode node, String featureName) {
            HashMap features2providersMap = (HashMap)this.fProviderMap.get(node.getName());
            if (features2providersMap == null) {
                features2providersMap = new HashMap(5);
            }
            if (!features2providersMap.containsKey(featureName)) {
                List elements = RegistryReader.this.getConfigElements(RegistryReader.NODE_PROVIDER_EXT_PT, RegistryReader.PROVIDER__PROVIDER, new String[]{RegistryReader.PROVIDER__PROVIDER_PARENT, node.getName(), RegistryReader.PROVIDER__PROVIDER_FEATURE, featureName});
                ArrayList<INodeProvider> providerList = new ArrayList<INodeProvider>(5);
                if (elements != null && elements.size() > 0) {
                    for (IConfigurationElement element : elements) {
                        INodeProvider provider = (INodeProvider)RegistryReader.this.createObject(element, RegistryReader.PROVIDER__PROVIDER_CLASS);
                        providerList.add(provider);
                    }
                }
                features2providersMap.put(featureName, providerList);
                this.fProviderMap.put(node.getName(), features2providersMap);
            }
            return (List)features2providersMap.get(featureName);
        }

        void setProviders(String providedNodeType, List providers) {
            this.fProviderMap.put(providedNodeType, providers);
        }
    }
}

