/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.css.internal.providers.detectors;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.events.IndexListener;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.html.core.internal.htmlcss.StyleElementAdapter;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class CSSClassLinkDetector
implements ILinkDetectorProvider,
IndexListener {
    private Map<IFile, ICSSStyleSheet> styleSheetCache = new HashMap<IFile, ICSSStyleSheet>();

    public CSSClassLinkDetector() {
        InternalAPI.registerIndexListener((IndexListener)this);
    }

    private void addLinkParameters(ReferenceElementFactory factory, Node n, String nName, String linkType, ILink desc, IDOMModel model, Collection<ICSSStyleSheet> sheets) {
        String cssUri;
        if ("wst.css.class.link" == linkType && (cssUri = this.getCSSURIForClass(n, model, sheets)) != null) {
            factory.addParam(desc, "css.uri", cssUri);
        }
    }

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        List ignoredResources = InternalAPI.getEnabledIgnoredResources();
        ArrayList<ILink> links = new ArrayList<ILink>();
        boolean detectCSSLinks = false;
        int i = 0;
        while (i < ignoredResources.size()) {
            if (((StringMatcher)ignoredResources.get(i)).toString().equals("*enableCSSClassLinks*")) {
                detectCSSLinks = true;
                break;
            }
            ++i;
        }
        if (!detectCSSLinks) {
            return links;
        }
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            Collection<ICSSStyleSheet> sheets = null;
            while (n != null) {
                String domNodeName = n.getNodeName();
                if (domNodeName != null && domNodeName.indexOf(":") == -1) {
                    IDOMElement domElement = (IDOMElement)n;
                    NamedNodeMap domAttributeNodes = n.getAttributes();
                    int length = domAttributeNodes.getLength();
                    int i2 = 0;
                    while (i2 < length) {
                        Node domAttributeItem = domAttributeNodes.item(i2);
                        String linkName = null;
                        String domAttName = domAttributeItem.getNodeName();
                        if (domAttName.compareToIgnoreCase("class") == 0) {
                            if (sheets == null) {
                                sheets = this.getAllImportedSheets(model);
                            }
                            String linkType = this.getLinkType(domNodeName, domAttName);
                            IDOMAttr attr = (IDOMAttr)domAttributeItem;
                            ILink webLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)attr, linkType, linkName, false));
                            this.addLinkParameters(factory, n, domNodeName, linkType, webLink, model, sheets);
                            links.add(webLink);
                            break;
                        }
                        ++i2;
                    }
                }
                n = iter.nextNode();
            }
        }
        return links;
    }

    private String getLinkType(String nodeName, String attName) {
        String linkType = "web.commonlink";
        if (attName.equalsIgnoreCase("class")) {
            linkType = "wst.css.class.link";
        }
        return linkType;
    }

    private Collection<ICSSStyleSheet> getAllImportedSheets(IDOMModel model) {
        LinkedHashSet<ICSSStyleSheet> importedSheets = new LinkedHashSet<ICSSStyleSheet>();
        Object[] result = this.getReferencedStyleSheets(model);
        List sheets = (List)result[0];
        importedSheets.addAll((List)result[1]);
        for (IFile file : sheets) {
            ICSSStyleSheet sheet = this.getStyleSheet(file);
            if (sheet == null) continue;
            this.getAllImportedStyleSheets(sheet, importedSheets);
        }
        return importedSheets;
    }

    private Object[] getReferencedStyleSheets(IDOMModel model) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        ArrayList<ICSSStyleSheet> embeddedSheets = new ArrayList<ICSSStyleSheet>();
        IDOMDocument document = model.getDocument();
        NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
        IDOMNode n = (IDOMNode)iter.nextNode();
        while (n != null) {
            if ("STYLE".equalsIgnoreCase(n.getNodeName())) {
                StyleElementAdapter styleAdapter = (StyleElementAdapter)n.getAdapterFor(IStyleSheetAdapter.class);
                if (styleAdapter != null) {
                    ICSSStyleSheet sheet = (ICSSStyleSheet)styleAdapter.getSheet();
                    embeddedSheets.add(sheet);
                    List<ICSSImportRule> imports = this.getImportRules(sheet);
                    for (ICSSImportRule cssimport : imports) {
                        files.add(this.getFile(sheet, cssimport.getHref()));
                    }
                }
            } else if ("LINK".equalsIgnoreCase(n.getNodeName())) {
                IDOMNode a;
                NamedNodeMap map = n.getAttributes();
                boolean isStylesheet = false;
                int i = 0;
                while (i < map.getLength()) {
                    String rel;
                    a = (IDOMNode)map.item(i);
                    if ("rel".equalsIgnoreCase(a.getNodeName()) && "stylesheet".equalsIgnoreCase(rel = a.getNodeValue())) {
                        isStylesheet = true;
                        break;
                    }
                    ++i;
                }
                if (isStylesheet) {
                    i = 0;
                    while (i < map.getLength()) {
                        String href;
                        a = (IDOMNode)map.item(i);
                        if ("href".equalsIgnoreCase(a.getNodeName()) && (href = a.getNodeValue()) != null) {
                            Path container = new Path(model.getBaseLocation());
                            IFile containerFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)container);
                            files.add(this.getAbs(href, containerFile));
                        }
                        ++i;
                    }
                }
            }
            n = (IDOMNode)iter.nextNode();
        }
        return new Object[]{files, embeddedSheets};
    }

    private IFile getFile(ICSSStyleSheet sheet, String href) {
        Path container = null;
        container = sheet.getModel().getOwnerDOMNode() != null ? new Path(((IDOMNode)sheet.getModel().getOwnerDOMNode()).getModel().getBaseLocation()) : new Path(sheet.getModel().getBaseLocation());
        IFile containerFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)container);
        IFile targetCSSFile = this.getAbs(href, containerFile);
        return targetCSSFile;
    }

    private IFile getAbs(String href, IFile containerFile) {
        URIUtil.ParsedURI uri = URIUtil.parse((String)href);
        IPath path = WebUtil.getAbsolutePathFromURI((IFile)containerFile, (URIUtil.ParsedURI)uri);
        IFile targetCSSFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return targetCSSFile;
    }

    private List<ICSSImportRule> getImportRules(ICSSStyleSheet sheet) {
        ArrayList<ICSSImportRule> rules = new ArrayList<ICSSImportRule>();
        CSSRuleList cssRules = sheet.getCssRules();
        int j = 0;
        while (j < cssRules.getLength()) {
            CSSRule rule = cssRules.item(j);
            if (rule.getType() == 3) {
                ICSSImportRule importRule = (ICSSImportRule)rule;
                rules.add(importRule);
            } else if (rule.getType() == 1) break;
            ++j;
        }
        return rules;
    }

    private void getAllImportedStyleSheets(ICSSStyleSheet sheet, LinkedHashSet<ICSSStyleSheet> seenSheets) {
        if (!seenSheets.contains(sheet)) {
            seenSheets.add(sheet);
            List<ICSSImportRule> importRules = this.getImportRules(sheet);
            for (ICSSImportRule importRule : importRules) {
                IFile targetCSSFile = this.getFile(sheet, importRule.getHref());
                ICSSStyleSheet cachedSheet = this.getStyleSheet(targetCSSFile);
                if (cachedSheet == null) continue;
                this.getAllImportedStyleSheets(cachedSheet, seenSheets);
            }
        }
    }

    private synchronized ICSSStyleSheet getStyleSheet(IFile targetCSSFile) {
        ICSSStyleSheet cachedSheet = this.styleSheetCache.get(targetCSSFile);
        if (cachedSheet == null) {
            try {
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(targetCSSFile);
                if (model instanceof ICSSModel) {
                    ICSSModel cssmodel = (ICSSModel)model;
                    cachedSheet = (ICSSStyleSheet)cssmodel.getDocument();
                    this.styleSheetCache.put(targetCSSFile, cachedSheet);
                } else if (model != null) {
                    model.releaseFromRead();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cachedSheet;
    }

    private synchronized void removeCachedStyleSheets() {
        Collection<ICSSStyleSheet> sheets = this.styleSheetCache.values();
        for (ICSSStyleSheet sheet : sheets) {
            sheet.getModel().releaseFromRead();
        }
        this.styleSheetCache = new HashMap<IFile, ICSSStyleSheet>();
    }

    private String getCSSURIForClass(Node node, IDOMModel model, Collection<ICSSStyleSheet> sheets) {
        int specificity = 0;
        String styleSheetHref = null;
        for (ICSSStyleSheet sheet : sheets) {
            CSSRuleList ruleList = sheet.getCssRules();
            int i = 0;
            while (i < ruleList.getLength()) {
                CSSRule rule = ruleList.item(i);
                if (rule.getType() == 1) {
                    ICSSStyleRule styleRule = (ICSSStyleRule)rule;
                    ICSSSelectorList selectors = styleRule.getSelectors();
                    int j = 0;
                    while (j < selectors.getLength()) {
                        int selectorSpecifity;
                        ICSSSelector selector = selectors.getSelector(j);
                        boolean match = selector.match((Element)node, null);
                        if (match && (selectorSpecifity = selector.getSpecificity()) > specificity) {
                            specificity = selectorSpecifity;
                            String href = sheet.getHref();
                            styleSheetHref = href != null ? href : model.getBaseLocation();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return styleSheetHref;
    }

    public synchronized void workspaceIndexingEnded() {
        this.removeCachedStyleSheets();
    }

    public synchronized void workspaceIndexingStarted() {
    }
}

