/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.edit.jsf.internal;

import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class Util {
    public static IDataModel getWebProjectDataModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
    }

    public static WebProjectWizard getWebProjectWizard(IDataModel model) {
        return model == null ? new WebProjectWizard() : new WebProjectWizard(model);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String[] getDisplayNames(WebModel webModel) {
        ArrayList displayItems = new ArrayList();
        Util.populatePageNameArrays(webModel, new ArrayList(), displayItems, new HashMap());
        return displayItems.toArray(new String[0]);
    }

    public static String[] getActualNames(WebModel webModel) {
        ArrayList actualItems = new ArrayList();
        Util.populatePageNameArrays(webModel, actualItems, new ArrayList(), new HashMap());
        return actualItems.toArray(new String[0]);
    }

    private static void populatePageNameArrays(WebModel webModel, List actualItems, List displayItems, Map pagePathMap) {
        if (webModel != null) {
            IProject project = webModel.getComponent().getProject();
            IContainer rootFolder = webModel.getComponent().getRootFolder().getUnderlyingFolder();
            ArrayList<IResource> allMembers = new ArrayList<IResource>();
            ArrayList<Object> allContainers = new ArrayList<Object>();
            allContainers.add(rootFolder);
            try {
                IPath rootPath = rootFolder.getFullPath();
                IContainer metaFolder = JsfProjectUtil.getMetaInfFolder((IProject)project);
                IContainer webinfFolder = JsfProjectUtil.getWebInfFolder((IProject)project);
                while (allContainers.size() > 0) {
                    IContainer container = (IContainer)allContainers.get(0);
                    String containerName = container.getName();
                    if (containerName == null) {
                        containerName = "";
                    }
                    if (container == metaFolder || container == webinfFolder) {
                        allContainers.remove(container);
                        continue;
                    }
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IContainer) {
                            allContainers.add(members[i]);
                        } else {
                            allMembers.add(members[i]);
                        }
                        ++i;
                    }
                    allContainers.remove(container);
                }
                IPath parentPath = rootFolder.getFullPath();
                int i = 0;
                while (i < allMembers.size()) {
                    String extension;
                    IResource res = (IResource)allMembers.get(i);
                    if (res.toString().indexOf(".") != -1 && res.toString().indexOf(".ibmjsfres") == -1 && ("jsp".equalsIgnoreCase(extension = res.getFileExtension()) || "html".equalsIgnoreCase(extension))) {
                        IPath resPath = res.getFullPath();
                        int matchingSegmentCount = rootPath.matchingFirstSegments(resPath);
                        String path = null;
                        matchingSegmentCount = resPath.matchingFirstSegments(parentPath);
                        path = resPath.removeFirstSegments(matchingSegmentCount).makeRelative().toString();
                        if (path.length() > 0) {
                            displayItems.add(path);
                        }
                        pagePathMap.put(resPath.removeFirstSegments(1).toString(), path);
                        path = String.valueOf(JsfProjectUtil.getJsfUrlPrefix()) + path;
                        if (path.length() > 0) {
                            actualItems.add(path);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public String getAction(PageActionNode node) {
        IBindingAttribute attr;
        String action;
        action = node != null ? (!"".equals(action = (attr = (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY)).getReferenceString((IPageDataNode)node)) && action != null ? "#{" + action + "}\"" : "") : "";
        return action;
    }
}

