/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.edit.jsf;

import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.model.edit.jsf.AbstractNavigationCommand;
import com.ibm.etools.webtools.model.edit.jsf.AddNavigationCommand;
import com.ibm.etools.webtools.model.edit.jsf.EditNavigationCommand;
import com.ibm.etools.webtools.model.edit.jsf.NavigationDataModel;
import com.ibm.etools.webtools.model.edit.jsf.internal.Util;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NavigationDialog
extends Dialog
implements SelectionListener {
    private static final int MARGIN = 7;
    private static final int SPACING = 4;
    public static final String ANY_OUTCOME = "Any outcome";
    public static final String ANY_ACTION = "Any Action";
    protected Text fOutcomeText;
    private Button fAnyOutcomeButton;
    private Button fNamedOutcomeButton;
    protected Text fActionText;
    private Button fAnyActionButton;
    private Button fNamedActionButton;
    protected Combo fToPageCombo;
    protected Combo fFromPageCombo;
    private Button fPageButton;
    private Button fGlobalButton;
    private Button fForwardButton;
    private Button fRedirectButton;
    protected String[] fDisplayPageNames;
    protected String[] fActualPageNames;
    NavigationDataModel fModel;
    private String[] fActionRefList = null;
    private boolean fIsNewNavigation = false;

    public NavigationDialog(Shell parentShell, NavigationDataModel model) {
        super(parentShell);
        this.fModel = model;
        this.fIsNewNavigation = this.fModel.getOutcome() == null && this.fModel.getActionRef() == null && this.fModel.getToPage() == null;
        this.fDisplayPageNames = Util.getDisplayNames(this.fModel.getWebModel());
        this.fActualPageNames = Util.getActualNames(this.fModel.getWebModel());
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createBaseComposite(parent, 1, false);
        this.createTop(composite);
        new Label(composite, 0).setText("When the action returns the outcome:");
        Composite outcomeContainer = new Composite(composite, 0);
        outcomeContainer.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        outcomeContainer.setLayoutData((Object)gridData);
        this.fAnyOutcomeButton = new Button(outcomeContainer, 16);
        this.fAnyOutcomeButton.setText("Any Outcome");
        this.fAnyOutcomeButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.fAnyOutcomeButton.setLayoutData((Object)gridData);
        this.fNamedOutcomeButton = new Button(outcomeContainer, 16);
        this.fNamedOutcomeButton.setText("The outcome named:");
        this.fNamedOutcomeButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.fNamedOutcomeButton.setLayoutData((Object)gridData);
        this.fOutcomeText = new Text(outcomeContainer, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fOutcomeText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        new Label(composite, 258).setLayoutData((Object)gridData);
        Composite ruleContainer = new Composite(composite, 0);
        ruleContainer.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        ruleContainer.setLayoutData((Object)gridData);
        this.createTypeSection(ruleContainer);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        new Label(ruleContainer, 514).setLayoutData((Object)gridData);
        Composite actionContainer = new Composite(ruleContainer, 0);
        actionContainer.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        actionContainer.setLayoutData((Object)gridData);
        Label label = new Label(actionContainer, 0);
        label.setText("This rule is used by:");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fAnyActionButton = new Button(actionContainer, 16);
        this.fAnyActionButton.setText("Any action");
        this.fAnyActionButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 5;
        gridData.horizontalAlignment = 4;
        this.fAnyActionButton.setLayoutData((Object)gridData);
        this.fNamedActionButton = new Button(actionContainer, 16);
        this.fNamedActionButton.setText("This action only:");
        this.fNamedActionButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalIndent = 5;
        this.fNamedActionButton.setLayoutData((Object)gridData);
        this.fActionText = new Text(actionContainer, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fActionText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        new Label(composite, 258).setLayoutData((Object)gridData);
        new Label(composite, 0).setText("When following this rule:");
        this.fForwardButton = new Button(composite, 16);
        this.fForwardButton.setText("Use request forwarding (parameters work automatically)");
        this.fForwardButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.horizontalAlignment = 4;
        this.fForwardButton.setLayoutData((Object)gridData);
        this.fRedirectButton = new Button(composite, 16);
        this.fRedirectButton.setText("Use request redirection (parameters must be coded)");
        this.fRedirectButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.horizontalAlignment = 4;
        this.fRedirectButton.setLayoutData((Object)gridData);
        this.initilize();
        return composite;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fToPageCombo) {
            this.enableOKButton();
        } else if (e.widget != this.fRedirectButton && e.widget != this.fForwardButton) {
            if (e.widget == this.fNamedActionButton) {
                this.fActionText.setEnabled(true);
            } else if (e.widget == this.fAnyActionButton) {
                this.fActionText.setEnabled(false);
            } else if (e.widget == this.fNamedOutcomeButton) {
                this.fOutcomeText.setEnabled(true);
            } else if (e.widget == this.fAnyOutcomeButton) {
                this.fOutcomeText.setEnabled(false);
            }
        }
    }

    protected void createTypeSection(Composite ruleContainer) {
        Composite typeContainer = new Composite(ruleContainer, 0);
        typeContainer.setLayout((Layout)new GridLayout());
        new Label(typeContainer, 0).setText("This rule is used for:");
        this.fGlobalButton = new Button(typeContainer, 16);
        this.fGlobalButton.setText("All pages");
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.horizontalAlignment = 4;
        this.fGlobalButton.setLayoutData((Object)gridData);
        this.fPageButton = new Button(typeContainer, 16);
        this.fPageButton.setText("This page only");
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.horizontalAlignment = 4;
        this.fPageButton.setLayoutData((Object)gridData);
    }

    protected void initilize() {
        if (this.fModel.getOutcome() != null && !this.fModel.getOutcome().equals(ANY_OUTCOME)) {
            this.fOutcomeText.setEnabled(true);
            this.fOutcomeText.setText(this.fModel.getOutcome());
            this.fAnyOutcomeButton.setSelection(false);
            this.fNamedOutcomeButton.setSelection(true);
        } else {
            this.fOutcomeText.setEnabled(false);
            this.fAnyOutcomeButton.setSelection(true);
            this.fNamedOutcomeButton.setSelection(false);
        }
        if (this.fActionRefList != null && this.fActionRefList.length > 0) {
            this.fActionText.setText(this.fActionRefList[0]);
        }
        if (this.fModel.getActionRef() != null && !this.fModel.getActionRef().equals(ANY_ACTION)) {
            this.fActionText.setText(this.fModel.getActionRef());
            this.fActionText.setEnabled(true);
            this.fAnyActionButton.setSelection(false);
            this.fNamedActionButton.setSelection(true);
        } else {
            this.fActionText.setEnabled(false);
            this.fAnyActionButton.setSelection(true);
            this.fNamedActionButton.setSelection(false);
        }
        if (this.fModel.getToPage() != null) {
            this.fToPageCombo.setText(this.fModel.getToPage());
        }
        if (this.fModel.isTemplate()) {
            this.fModel.setGlobal(true);
            this.fPageButton.setEnabled(false);
        }
        if (this.fPageButton != null && this.fGlobalButton != null) {
            if (!this.fModel.isGlobal()) {
                this.fPageButton.setSelection(true);
                this.fGlobalButton.setSelection(false);
            } else {
                this.fPageButton.setSelection(false);
                this.fGlobalButton.setSelection(true);
            }
        }
        if (!this.fModel.isRedirect()) {
            this.fForwardButton.setSelection(true);
            this.fRedirectButton.setSelection(false);
        } else {
            this.fForwardButton.setSelection(false);
            this.fRedirectButton.setSelection(true);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fIsNewNavigation ? "Add Navigation Rule" : "Edit Navigation Rule");
    }

    protected void doSetModel() {
        String toPage;
        int selectedItem;
        if (this.fFromPageCombo != null) {
            String fromPage;
            selectedItem = this.fFromPageCombo.getSelectionIndex();
            if (selectedItem != -1) {
                fromPage = this.fActualPageNames[selectedItem];
                if (fromPage.startsWith("/faces")) {
                    fromPage = fromPage.substring(6);
                }
            } else {
                fromPage = this.fFromPageCombo.getText();
                if (!fromPage.startsWith("/")) {
                    fromPage = "/" + fromPage;
                }
            }
            this.fModel.setFromPage(fromPage);
        }
        if ((selectedItem = this.fToPageCombo.getSelectionIndex()) != -1) {
            toPage = this.fActualPageNames[selectedItem];
            if (toPage.startsWith("/faces")) {
                toPage = toPage.substring(6);
            }
        } else {
            toPage = this.fToPageCombo.getText();
            if (!toPage.startsWith("/")) {
                toPage = "/" + toPage;
            }
        }
        this.fModel.setToPage(toPage);
        this.fModel.setOutcome(this.fAnyOutcomeButton.getSelection() ? "" : this.fOutcomeText.getText());
        this.fModel.setActionRef(this.fAnyActionButton.getSelection() ? "" : this.fActionText.getText());
        this.fModel.setGlobal(this.fGlobalButton == null ? false : this.fGlobalButton.getSelection());
        this.fModel.setRedirect(this.fRedirectButton.getSelection());
    }

    protected void okPressed() {
        this.doSetModel();
        AbstractNavigationCommand command = null;
        command = this.fIsNewNavigation ? new AddNavigationCommand("Add", this.fModel) : new EditNavigationCommand("Edit", this.fModel);
        try {
            command.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public void setActionRefList(String[] actionRefs) {
        this.fActionRefList = actionRefs;
    }

    protected void enableOKButton() {
        if (this.getButton(0) != null) {
            boolean fromOK = true;
            if (this.fFromPageCombo != null) {
                String fromPage = this.fFromPageCombo.getText();
                fromOK = fromPage != null && !fromPage.equals("");
            }
            String toPage = this.fToPageCombo.getText();
            this.getButton(0).setEnabled(fromOK && toPage != null && !toPage.equals(""));
        }
    }

    public void create() {
        super.create();
        this.enableOKButton();
    }

    protected void createTop(Composite composite) {
        GridData gridData;
        Label label;
        new Label(composite, 0).setText("Navigate:");
        Composite pageContainer = new Composite(composite, 0);
        pageContainer.setLayout((Layout)new GridLayout(2, false));
        if (this.fModel.getFromPage() == null || this.fModel.getFromPage() == "") {
            label = new Label(pageContainer, 0);
            label.setText("From this page:  ");
            gridData = new GridData();
            gridData.horizontalIndent = 5;
            label.setLayoutData((Object)gridData);
            this.fFromPageCombo = new Combo(pageContainer, 2048);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.widthHint = this.convertHorizontalDLUsToPixels(200);
            this.fFromPageCombo.setLayoutData((Object)gridData);
            this.fFromPageCombo.setItems(this.fDisplayPageNames);
            this.fFromPageCombo.addSelectionListener((SelectionListener)this);
            this.fFromPageCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NavigationDialog.this.enableOKButton();
                }
            });
        }
        label = new Label(pageContainer, 0);
        label.setText("To this page:  ");
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.fToPageCombo = new Combo(pageContainer, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.fToPageCombo.setLayoutData((Object)gridData);
        this.fToPageCombo.setItems(this.fDisplayPageNames);
        this.fToPageCombo.addSelectionListener((SelectionListener)this);
        this.fToPageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NavigationDialog.this.enableOKButton();
            }
        });
    }

    protected IProject getProject() {
        return JsfProjectUtil.getProject();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

