/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.edit.jsf;

import com.ibm.etools.webtools.model.edit.jsf.AbstractNavigationCommand;
import com.ibm.etools.webtools.model.edit.jsf.NavigationDataModel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FromActionType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.RedirectType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class AddNavigationCommand
extends AbstractNavigationCommand {
    public AddNavigationCommand(String label, NavigationDataModel model) {
        super(label, model);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {
        IProject project = this.fModel.getWebModel().getComponent().getProject();
        FacesConfigArtifactEdit edit = null;
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)"WEB-INF/faces-config.xml");
            if (edit.getFacesConfig() != null) {
                EList navRules = edit.getFacesConfig().getNavigationRule();
                boolean foundNewCase = false;
                int i = 0;
                while (i < navRules.size()) {
                    boolean isGlobal;
                    NavigationRuleType navRule = (NavigationRuleType)navRules.get(i);
                    String fromTreeId = navRule.getFromViewId() != null ? navRule.getFromViewId().getTextContent() : null;
                    boolean bl = isGlobal = fromTreeId == null || fromTreeId.equals("");
                    if (!foundNewCase && isGlobal == this.fModel.isGlobal() && (isGlobal || this.fModel.getFromPage().equalsIgnoreCase(fromTreeId))) {
                        this.addNewCase(navRule);
                        foundNewCase = true;
                    }
                    ++i;
                }
                if (!foundNewCase) {
                    this.addNewRule(navRules);
                }
            }
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return null;
    }

    protected void addNewCase(NavigationRuleType navRule) {
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        NavigationCaseType navCase = facesConfigFactory.createNavigationCaseType();
        if (!this.fModel.getOutcome().equals("Any outcome") && !this.fModel.getOutcome().equals("")) {
            FromOutcomeType fromOutcome = facesConfigFactory.createFromOutcomeType();
            fromOutcome.setTextContent(this.fModel.getOutcome());
            navCase.setFromOutcome(fromOutcome);
        } else {
            navCase.setFromOutcome(null);
        }
        if (!this.fModel.getActionRef().equals("Any Action") && !this.fModel.getActionRef().equals("")) {
            FromActionType fromAction = facesConfigFactory.createFromActionType();
            fromAction.setTextContent(this.fModel.getActionRef());
            navCase.setFromAction(fromAction);
        } else {
            navCase.setFromAction(null);
        }
        ToViewIdType toViewId = facesConfigFactory.createToViewIdType();
        toViewId.setTextContent(this.fModel.getToPage());
        navCase.setToViewId(toViewId);
        if (this.fModel.isRedirect()) {
            RedirectType redirect = facesConfigFactory.createRedirectType();
            navCase.setRedirect(redirect);
        } else {
            navCase.setRedirect(null);
        }
        EList navCases = navRule.getNavigationCase();
        navCases.add((Object)navCase);
    }

    protected void addNewRule(EList navRules) {
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        NavigationRuleType newNavRule = facesConfigFactory.createNavigationRuleType();
        if (!this.fModel.isGlobal()) {
            FromViewIdType fromViewId = facesConfigFactory.createFromViewIdType();
            fromViewId.setTextContent(this.fModel.getFromPage());
            newNavRule.setFromViewId(fromViewId);
        }
        NavigationCaseType newNavCase = facesConfigFactory.createNavigationCaseType();
        if (!this.fModel.getOutcome().equals("Any outcome") && !this.fModel.getOutcome().equals("")) {
            FromOutcomeType fromOutcome = facesConfigFactory.createFromOutcomeType();
            fromOutcome.setTextContent(this.fModel.getOutcome());
            newNavCase.setFromOutcome(fromOutcome);
        } else {
            newNavCase.setFromOutcome(null);
        }
        if (!this.fModel.getActionRef().equals("Any Action") && !this.fModel.getActionRef().equals("")) {
            FromActionType fromAction = facesConfigFactory.createFromActionType();
            fromAction.setTextContent(this.fModel.getActionRef());
            newNavCase.setFromAction(fromAction);
        } else {
            newNavCase.setFromAction(null);
        }
        ToViewIdType toViewId = facesConfigFactory.createToViewIdType();
        toViewId.setTextContent(this.fModel.getToPage());
        newNavCase.setToViewId(toViewId);
        if (this.fModel.isRedirect()) {
            RedirectType redirect = facesConfigFactory.createRedirectType();
            newNavCase.setRedirect(redirect);
        }
        newNavRule.getNavigationCase().add((Object)newNavCase);
        navRules.add((Object)newNavRule);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

