/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jspbatchcompile.internal.actions;

import com.ibm.etools.webtools.jspbatchcompile.Activator;
import com.ibm.etools.webtools.jspbatchcompile.internal.core.CompileJSPsUtil;
import com.ibm.etools.webtools.jspbatchcompile.internal.dialogs.IntroductionDialog;
import com.ibm.etools.webtools.jspbatchcompile.internal.dialogs.RetargetDialog;
import com.ibm.etools.webtools.jspbatchcompile.internal.nls.ResourceHandler;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IRuntime;

public class CompileJSPsAction
implements IActionDelegate {
    public static final String PREF_DO_NOT_SHOW_INFO = "com.ibm.etools.webtools.jspbatchcompilenoShowInfo";
    public static final String PREF_DO_NOT_SHOW_COMPLETION = "com.ibm.etools.webtools.jspbatchcompilenoShowComplete";
    private static final String NAME_DELIMETER = " - ";
    private Object[] selectedObjects;

    public void run(IAction action) {
        IProject project = this.getProject();
        if (project != null) {
            String pathToCompiler;
            String projectName;
            String configName;
            ILaunchConfigurationType programConfigType;
            IntroductionDialog introDiag;
            IRuntime runtime = CompileJSPsUtil.getServerRuntime(project);
            if (runtime == null || !CompileJSPsUtil.isServerValid(runtime)) {
                RetargetDialog serverMessageDialog = new RetargetDialog(Activator.getShell(), project);
                if (serverMessageDialog.open() != 0) {
                    return;
                }
                runtime = CompileJSPsUtil.getServerRuntime(project);
            }
            if (!Activator.getDefault().getPluginPreferences().getBoolean(PREF_DO_NOT_SHOW_INFO) && (introDiag = new IntroductionDialog(Activator.getShell(), runtime.getRuntimeType().getId())).open() != 0) {
                return;
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration launchConfig = this.getLaunchConfig(launchManager, programConfigType = launchManager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType"), configName = this.constructConfigurationName(projectName = project.getName()));
            if (launchConfig == null && (pathToCompiler = CompileJSPsUtil.getPathToJSPBatchCompiler(runtime)) != null) {
                String workingDirectory = pathToCompiler.substring(0, pathToCompiler.lastIndexOf("/"));
                ILaunchConfigurationWorkingCopy wc = null;
                try {
                    wc = programConfigType.newInstance(null, configName);
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", pathToCompiler);
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDirectory);
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", this.constructDefaultArguments(project));
                    wc.setAttribute("org.eclipse.debug.core.ATTR_REFRESH_SCOPE", "${container}");
                    wc.doSave();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                launchConfig = this.getLaunchConfig(launchManager, programConfigType, configName);
            }
            StructuredSelection initialSelection = new StructuredSelection((Object)launchConfig);
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)Activator.getShell(), (IStructuredSelection)initialSelection, (String)"org.eclipse.ui.externaltools.launchGroup");
        }
    }

    private IProject getProject() {
        IProject project = null;
        if (this.selectedObjects != null) {
            IResource resource = (IResource)this.selectedObjects[0];
            if (resource instanceof IProject) {
                project = (IProject)resource;
            } else if (resource instanceof IFile) {
                project = ((IFile)resource).getProject();
            }
        }
        return project;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectedObjects = ((IStructuredSelection)selection).toArray();
        }
    }

    private ILaunchConfiguration getLaunchConfig(ILaunchManager launchManager, ILaunchConfigurationType type, String configName) {
        ILaunchConfiguration launchConfiguration = null;
        try {
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations(type);
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                String name = config.getName();
                if (name != null && name.equals(configName)) {
                    launchConfiguration = config;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return launchConfiguration;
    }

    private String constructConfigurationName(String projectName) {
        return String.valueOf(ResourceHandler.JSPPreCompile) + NAME_DELIMETER + projectName;
    }

    private String constructDefaultArguments(IProject project) {
        String additionalClassPath;
        StringBuilder builder = new StringBuilder();
        IPath webContentLocation = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IContainer webcontentFolder = component.getRootFolder().getUnderlyingFolder();
        if (webcontentFolder != null) {
            webContentLocation = webcontentFolder.getFullPath();
            builder.append("-war.path");
            builder.append(" \"${workspace_loc}" + webContentLocation.toString() + "\"");
        }
        builder.append("\n");
        builder.append("-keepgenerated true");
        builder.append("\n");
        if (webContentLocation != null) {
            builder.append("-compileToDir");
            builder.append(" \"${workspace_loc}" + webContentLocation.toString());
            builder.append("/WEB-INF/classes/\"");
        }
        if ((additionalClassPath = this.getAdditionalClassPathEntries(project)) != null) {
            builder.append("\n");
            builder.append("-additional.classpath");
            builder.append(" \"" + additionalClassPath + "\"");
        }
        return builder.toString();
    }

    private String getAdditionalClassPathEntries(IProject rootProject) {
        IProject[] dependentProjects;
        String additionalClassPathString = null;
        HashMap<String, IProject> allProjects = new HashMap<String, IProject>();
        if (rootProject != null) {
            this.addReferences(rootProject, allProjects);
        }
        if ((dependentProjects = allProjects.values().toArray(new IProject[0])).length > 0) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < dependentProjects.length) {
                IJavaProject jProject = JavaCore.create((IProject)dependentProjects[i]);
                try {
                    if (jProject != null) {
                        if (!builder.toString().equals("")) {
                            builder.append(";");
                        }
                        String outputLocation = jProject.getOutputLocation().toString();
                        builder.append("${workspace_loc}" + outputLocation);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            additionalClassPathString = builder.toString();
        }
        return additionalClassPathString;
    }

    private void addReferences(IProject rootProject, HashMap<String, IProject> existingProjects) {
        IVirtualReference[] references;
        IVirtualComponent createComponent;
        if (rootProject != null && existingProjects != null && (createComponent = ComponentCore.createComponent((IProject)rootProject)) != null && (references = createComponent.getReferences()) != null) {
            IVirtualReference[] iVirtualReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IVirtualReference virtualReference = iVirtualReferenceArray[n2];
                IVirtualComponent referencedComponent = virtualReference.getReferencedComponent();
                if (referencedComponent != null && !referencedComponent.isBinary() && (project = referencedComponent.getProject()) != null && project.exists() && !existingProjects.containsKey(project.getName())) {
                    existingProjects.put(project.getName(), project);
                    this.addReferences(project, existingProjects);
                }
                ++n2;
            }
        }
    }
}

