/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.util.JpaUtil;
import java.util.Vector;

public class SelectionTable {
    private Vector items;

    public SelectionTable(String[] values) {
        if (values != null) {
            this.setItems(values);
        }
    }

    public void addItem(String value) {
        if (this.items == null) {
            this.items = new Vector();
        } else if (this.getItemIndexByValue(value) != -1) {
            return;
        }
        this.items.add(new Item(value));
    }

    public Item getItem(int index) {
        if (this.items != null && index >= 0 && index < this.items.size()) {
            return (Item)this.items.get(index);
        }
        return null;
    }

    public int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    public int getItemIndexByValue(String value) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.size()) {
                Item item = (Item)this.items.get(i);
                if (JpaUtil.compareStringsIgnoreCase(item.getValue(), value)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getValue(int index) {
        Item item = this.getItem(index);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public String[] getValues() {
        int count = this.getItemCount();
        if (count > 0) {
            String[] values = new String[count];
            int i = 0;
            while (i < count) {
                values[i] = ((Item)this.items.get(i)).getValue();
                ++i;
            }
            return values;
        }
        return null;
    }

    public void reset() {
        this.items = null;
    }

    public void setItems(String[] values) {
        this.reset();
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.addItem(values[i]);
                ++i;
            }
        }
    }

    public class Item {
        private String value;

        public Item(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

