/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaOrderedAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.AttributeContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrderByPage
implements Listener,
ISelectionChangedListener {
    private Composite parent;
    private IDataModel model;
    private JpaQueryMethodInfo queryMethod;
    private JpaManagerBeanInfo managerBean;
    private Table availableTable;
    private Table orderedTable;
    private TableViewer availableViewer;
    private TableViewer orderedViewer;
    private Button fUpOrderButton;
    private Button fDownOrderButton;
    private Button fOrderButton;
    private Button fUnorderButton;
    private List<JpaOrderedAttributeInfo> orderedAttributes;
    private List<JpaOrderedAttributeInfo> availableAttributes;
    private List selectedAttributes;

    public OrderByPage(Composite parent, IDataModel model) {
        this.parent = parent;
        this.model = model;
        this.queryMethod = (JpaQueryMethodInfo)model.getProperty("IJpaDataModelProperties.selectedQueryMethod");
        this.managerBean = (JpaManagerBeanInfo)model.getProperty("IJpaDataModelProperties.userSelection");
    }

    private void createAvailableGroup(Composite parent) {
        Group availableGroup = UIPartsUtil.createGroup(parent, 1, 1, JpaUI._UI_Available_Cols);
        GridData tableData = (GridData)availableGroup.getLayoutData();
        tableData.heightHint = 110;
        tableData.grabExcessVerticalSpace = true;
        this.availableTable = UIPartsUtil.createTable((Composite)availableGroup, 2, 1, false, false);
        this.availableViewer = new TableViewer(this.availableTable);
        this.availableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TableLayout layout = new TableLayout();
        new TableColumn(this.availableTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.availableViewer.setLabelProvider((IBaseLabelProvider)new OrderByAttributeLabelProvider());
        this.availableViewer.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.availableAttributes = JpaUtil.getAvailableAttributes(this.managerBean.getEntity(), this.queryMethod);
        this.availableViewer.setInput(this.availableAttributes);
        this.availableTable.setLayout((Layout)layout);
        this.availableTable.layout(true);
    }

    private void createOrderedGroup(Composite parent) {
        Group orderedGroup = UIPartsUtil.createGroup(parent, 2, 1, JpaUI._UI_Ordered_Cols);
        GridData tableData = (GridData)orderedGroup.getLayoutData();
        tableData.heightHint = 120;
        Composite orderedColsComposite = UIPartsUtil.createComposite((Composite)orderedGroup, 1, 1);
        this.orderedTable = UIPartsUtil.createTable(orderedColsComposite, 2, 1, true, false);
        this.orderedViewer = new TableViewer(this.orderedTable);
        this.orderedViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TableLayout layout = new TableLayout();
        TableColumn columnOrderedName = new TableColumn(this.orderedTable, 0);
        columnOrderedName.setText(JpaUI._UI_Ordered_Cols);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        TableColumn columnOrderedOrder = new TableColumn(this.orderedTable, 0);
        columnOrderedOrder.setText(JpaUI._UI_Ordering);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.orderedViewer.setLabelProvider((IBaseLabelProvider)new OrderByAttributeLabelProvider());
        this.orderedViewer.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.orderedViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.orderedTable), new ComboBoxCellEditor((Composite)this.orderedTable, new String[]{JpaUI._UI_Not_Ordered, JpaUI._UI_Ascending, JpaUI._UI_Descending}, 8)});
        this.orderedViewer.setColumnProperties(new String[]{"Ordered Attributes", "Ordering"});
        this.orderedViewer.setCellModifier(this.getCellModifier());
        this.orderedAttributes = this.queryMethod.getOrderedAttributes();
        this.orderedViewer.setInput(this.orderedAttributes);
        this.orderedTable.setLayout((Layout)layout);
        this.orderedTable.layout(true);
        Composite updownComposite = UIPartsUtil.createComposite((Composite)orderedGroup, 1, 1);
        ((GridLayout)updownComposite.getLayout()).marginWidth = 0;
        ((GridLayout)updownComposite.getLayout()).marginHeight = 0;
        GridData data = (GridData)updownComposite.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        data.verticalAlignment = 0x1000000;
        this.fUpOrderButton = UIPartsUtil.createPushButton(updownComposite, "", 1, false);
        this.fUpOrderButton.setImage(JpaPlugin.getImage("icons/size16/up.gif"));
        this.fUpOrderButton.setToolTipText(JpaUI._UI_Up);
        this.fDownOrderButton = UIPartsUtil.createPushButton(updownComposite, "", 1, false);
        this.fDownOrderButton.setImage(JpaPlugin.getImage("icons/size16/down.gif"));
        this.fDownOrderButton.setToolTipText(JpaUI._UI_Down);
        this.fUpOrderButton.setEnabled(false);
        this.fDownOrderButton.setEnabled(false);
        this.fUpOrderButton.addListener(13, (Listener)this);
        this.fDownOrderButton.addListener(13, (Listener)this);
    }

    private void createOrderingButtons(Composite parent) {
        Composite buttonsComposite = UIPartsUtil.createComposite(parent, 2, 1);
        GridData data = (GridData)buttonsComposite.getLayoutData();
        data.horizontalAlignment = 0x1000000;
        data.grabExcessVerticalSpace = false;
        this.fOrderButton = UIPartsUtil.createPushButton(buttonsComposite, JpaUI._UI_Order, 1, false);
        this.fOrderButton.setEnabled(false);
        this.fOrderButton.addListener(13, (Listener)this);
        this.fOrderButton.setImage(JpaPlugin.getImage("icons/size16/up.gif"));
        this.fUnorderButton = UIPartsUtil.createPushButton(buttonsComposite, JpaUI._UI_Remove_Ordering, 1, false);
        this.fUnorderButton.setEnabled(false);
        this.fUnorderButton.addListener(13, (Listener)this);
        this.fUnorderButton.setImage(JpaPlugin.getImage("icons/size16/down.gif"));
    }

    protected ICellModifier getCellModifier() {
        ICellModifier cellModifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("Ordering");
            }

            public Object getValue(Object element, String property) {
                if (property.equals("Ordering")) {
                    JpaOrderedAttributeInfo attribute = (JpaOrderedAttributeInfo)element;
                    return attribute.getOrdering();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                Integer order = (Integer)value;
                int index = OrderByPage.this.orderedAttributes.indexOf(item.getData());
                JpaOrderedAttributeInfo attribute = (JpaOrderedAttributeInfo)OrderByPage.this.orderedAttributes.get(index);
                attribute.setOrdering(order);
                if (order.equals(JpaOrderedAttributeInfo.NOT_ORDERED)) {
                    if (OrderByPage.this.orderedAttributes != null) {
                        OrderByPage.this.orderedAttributes.remove(attribute);
                    }
                    if (OrderByPage.this.availableAttributes == null) {
                        OrderByPage.this.availableAttributes = new ArrayList();
                    }
                    OrderByPage.this.availableAttributes.add(attribute);
                    OrderByPage.this.availableViewer.setInput((Object)OrderByPage.this.availableAttributes);
                    OrderByPage.this.availableViewer.refresh();
                }
                OrderByPage.this.queryMethod.setOrderedAttributes(OrderByPage.this.orderedAttributes);
                OrderByPage.this.queryMethod.updateQuery(OrderByPage.this.managerBean.getEntity());
                OrderByPage.this.orderedViewer.refresh();
                OrderByPage.this.model.notifyPropertyChange("IJpaDataModelProperties.selectedQueryMethod", 1);
            }
        };
        return cellModifier;
    }

    public Composite getContents() {
        Composite area = UIPartsUtil.createComposite(this.parent, 1, 1);
        this.createOrderedGroup(area);
        this.createOrderingButtons(area);
        this.createAvailableGroup(area);
        return area;
    }

    public void handleEvent(Event event) {
        Widget w = event.widget;
        if (w == this.fUpOrderButton || w == this.fDownOrderButton) {
            int itemCount;
            boolean moveUp;
            boolean bl = moveUp = w == this.fUpOrderButton;
            if (!moveUp) {
                Collections.reverse(this.selectedAttributes);
            }
            for (JpaOrderedAttributeInfo attribute : this.selectedAttributes) {
                int movedIndex = this.orderedAttributes.indexOf(attribute);
                if (moveUp) {
                    this.orderedAttributes.remove(movedIndex);
                    this.orderedAttributes.add(movedIndex - 1, attribute);
                    continue;
                }
                this.orderedAttributes.remove(movedIndex);
                this.orderedAttributes.add(movedIndex + 1, attribute);
            }
            if (!moveUp) {
                Collections.reverse(this.selectedAttributes);
            }
            if ((itemCount = this.orderedTable.getItemCount()) > 1 && this.selectedAttributes != null) {
                this.fUpOrderButton.setEnabled(this.orderedAttributes.get(0) != this.selectedAttributes.get(0));
                this.fDownOrderButton.setEnabled(this.orderedAttributes.get(itemCount - 1) != this.selectedAttributes.get(this.selectedAttributes.size() - 1));
            } else {
                this.fUpOrderButton.setEnabled(false);
                this.fDownOrderButton.setEnabled(false);
            }
        } else if (w == this.fOrderButton || w == this.fUnorderButton) {
            boolean order = w == this.fOrderButton;
            for (JpaOrderedAttributeInfo attribute : this.selectedAttributes) {
                if (order) {
                    if (this.availableAttributes != null) {
                        this.availableAttributes.remove(attribute);
                    }
                    if (this.orderedAttributes == null) {
                        this.orderedAttributes = new ArrayList<JpaOrderedAttributeInfo>();
                    }
                    attribute.setOrdering(JpaOrderedAttributeInfo.ASCENDING);
                    this.orderedAttributes.add(attribute);
                    continue;
                }
                if (this.orderedAttributes != null) {
                    this.orderedAttributes.remove(attribute);
                }
                if (this.availableAttributes == null) {
                    this.availableAttributes = new ArrayList<JpaOrderedAttributeInfo>();
                }
                attribute.setOrdering(JpaOrderedAttributeInfo.NOT_ORDERED);
                this.availableAttributes.add(attribute);
            }
        }
        this.availableViewer.setInput(this.availableAttributes);
        this.orderedViewer.setInput(this.orderedAttributes);
        this.queryMethod.setOrderedAttributes(this.orderedAttributes);
        this.queryMethod.updateQuery(this.managerBean.getEntity());
        this.availableViewer.refresh();
        this.orderedViewer.refresh();
        this.model.notifyPropertyChange("IJpaDataModelProperties.selectedQueryMethod", 1);
    }

    public void refresh() {
        this.availableAttributes = JpaUtil.getAvailableAttributes(this.managerBean.getEntity(), this.queryMethod);
        this.orderedAttributes = this.queryMethod.getOrderedAttributes();
        if (this.availableViewer != null && this.orderedViewer != null) {
            this.availableViewer.setInput(this.availableAttributes);
            this.orderedViewer.setInput(this.orderedAttributes);
            this.availableViewer.refresh();
            this.orderedViewer.refresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.selectedAttributes = selection.toList();
        if (source.equals(this.orderedViewer)) {
            int itemCount = this.orderedTable.getItemCount();
            if (itemCount > 1 && this.selectedAttributes != null && this.selectedAttributes.size() > 0) {
                this.fUpOrderButton.setEnabled(this.orderedAttributes.get(0) != this.selectedAttributes.get(0));
                this.fDownOrderButton.setEnabled(this.orderedAttributes.get(itemCount - 1) != this.selectedAttributes.get(this.selectedAttributes.size() - 1));
            } else {
                this.fUpOrderButton.setEnabled(false);
                this.fDownOrderButton.setEnabled(false);
            }
            this.fUnorderButton.setEnabled(true);
            this.fOrderButton.setEnabled(false);
        } else if (source.equals(this.availableViewer)) {
            this.fUpOrderButton.setEnabled(false);
            this.fDownOrderButton.setEnabled(false);
            this.fUnorderButton.setEnabled(false);
            this.fOrderButton.setEnabled(true);
        }
    }

    private class OrderByAttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private OrderByAttributeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            if (element instanceof JpaOrderedAttributeInfo) {
                JpaOrderedAttributeInfo attribute = (JpaOrderedAttributeInfo)element;
                Integer ordering = attribute.getOrdering();
                if (ordering == 0) {
                    return JpaPlugin.getImage("icons/size16/columns.gif");
                }
                if (ordering == 1) {
                    return JpaPlugin.getImage("icons/size16/up.gif");
                }
                if (ordering == 2) {
                    return JpaPlugin.getImage("icons/size16/down.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JpaOrderedAttributeInfo) {
                JpaOrderedAttributeInfo attribute = (JpaOrderedAttributeInfo)element;
                if (columnIndex == 0) {
                    return attribute.getAttributeName();
                }
                if (columnIndex == 1) {
                    Integer ordering = attribute.getOrdering();
                    if (ordering == 0) {
                        return JpaUI._UI_Not_Ordered;
                    }
                    if (ordering == 1) {
                        return JpaUI._UI_Ascending;
                    }
                    if (ordering == 2) {
                        return JpaUI._UI_Descending;
                    }
                }
            }
            return "";
        }
    }
}

