/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.filters.IConditionData;
import com.ibm.etools.webtools.jpa.filters.ISingleColumnConditionData;
import com.ibm.etools.webtools.jpa.filters.RelationalSingleColumnConditionData;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.wizard.ui.FocusTextCellEditor;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.AddFilterDialog;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class FilterPage
implements Listener,
ISelectionChangedListener,
IDoubleClickListener {
    private Composite parent;
    private IDataModel model;
    private JpaQueryMethodInfo queryMethod;
    private JpaManagerBeanInfo managerBean;
    private ToolItem fDownFilterButton;
    private ToolItem fUpFilterButton;
    private ToolItem fRemoveFilterButton;
    private ToolItem fEditFilterButton;
    private ToolItem fAddFilterButton;
    private Table fFilterTable;
    private TableViewer fFilterViewer;

    public FilterPage(Composite parent, IDataModel model) {
        this.parent = parent;
        this.model = model;
        this.queryMethod = (JpaQueryMethodInfo)model.getProperty("IJpaDataModelProperties.selectedQueryMethod");
        this.managerBean = (JpaManagerBeanInfo)model.getProperty("IJpaDataModelProperties.userSelection");
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.fFilterViewer && !event.getSelection().isEmpty()) {
            this.handleEditFilterBtnPressed();
            this.updateFilterWidgetStates();
        }
    }

    protected ICellModifier getCellModifier() {
        ICellModifier cellModifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return !property.equals("1");
            }

            public Object getValue(Object element, String property) {
                String result = "";
                if (property.equals("1")) {
                    result = "";
                } else if (property.equals("2")) {
                    int op = ((RelationalSingleColumnConditionData)element).getOperand();
                    return op == 0 ? new Integer(0) : new Integer(1);
                }
                return result;
            }

            public void modify(Object element, String property, Object value) {
                Integer input = (Integer)value;
                if (property.equals("2")) {
                    if (input == null) {
                        input = new Integer(0);
                    }
                    ((RelationalSingleColumnConditionData)((TableItem)element).getData()).setOperand(FilterPage.this.managerBean.getEntity(), input);
                    FilterPage.this.queryMethod.setFilter(FilterPage.this.queryMethod.getFilter(FilterPage.this.managerBean.getEntity()));
                    FilterPage.this.queryMethod.updateQuery(FilterPage.this.managerBean.getEntity());
                    FilterPage.this.fFilterViewer.refresh(((TableItem)element).getData());
                    FilterPage.this.model.notifyPropertyChange("IJpaDataModelProperties.selectedQueryMethod", 1);
                }
            }
        };
        return cellModifier;
    }

    public Composite getContents() {
        Composite area = UIPartsUtil.createComposite(this.parent, 1, 1);
        Composite buttonComposite = UIPartsUtil.createComposite(area, 5, 1);
        GridData data = (GridData)buttonComposite.getLayoutData();
        data.grabExcessVerticalSpace = false;
        ToolBar buttonsToolBar = new ToolBar(buttonComposite, 0x800040);
        data = new GridData(896);
        data.horizontalSpan = 5;
        buttonsToolBar.setLayoutData((Object)data);
        this.fAddFilterButton = new ToolItem(buttonsToolBar, 8);
        this.fAddFilterButton.setImage(JpaPlugin.getImage("icons/obj16/common/add.gif"));
        this.fAddFilterButton.setToolTipText(JpaUI._UI_Add);
        this.fEditFilterButton = new ToolItem(buttonsToolBar, 8);
        this.fEditFilterButton.setImage(JpaPlugin.getImage("icons/obj16/common/edit.gif"));
        this.fEditFilterButton.setToolTipText(JpaUI._UI_Edit);
        this.fRemoveFilterButton = new ToolItem(buttonsToolBar, 8);
        this.fRemoveFilterButton.setImage(JpaPlugin.getImage("icons/obj16/common/remove.gif"));
        this.fRemoveFilterButton.setToolTipText(JpaUI._UI_Remove);
        this.fUpFilterButton = new ToolItem(buttonsToolBar, 8);
        this.fUpFilterButton.setImage(JpaPlugin.getImage("icons/size16/up.gif"));
        this.fUpFilterButton.setToolTipText(JpaUI._UI_Up);
        this.fDownFilterButton = new ToolItem(buttonsToolBar, 8);
        this.fDownFilterButton.setImage(JpaPlugin.getImage("icons/size16/down.gif"));
        this.fDownFilterButton.setToolTipText(JpaUI._UI_Down);
        this.fFilterTable = UIPartsUtil.createTable(area, 2, 1, true, false);
        this.fFilterViewer = new TableViewer(this.fFilterTable);
        this.fFilterViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fFilterViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fFilterViewer.setContentProvider(this.getFilterContentProvider());
        this.fFilterViewer.setLabelProvider(this.getFilterLabelProvider());
        TableColumn tc1 = new TableColumn(this.fFilterTable, 0);
        TableColumn tc2 = new TableColumn(this.fFilterTable, 0);
        tc1.setText(JpaUI._UI_Filter_Task);
        tc2.setText("And/Or");
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, 220, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 55, true));
        this.fFilterTable.setLayout((Layout)tlayout);
        this.fFilterViewer.setCellEditors(new CellEditor[]{new FocusTextCellEditor((Composite)this.fFilterTable), new ComboBoxCellEditor((Composite)this.fFilterTable, new String[]{"AND", "OR"})});
        this.fFilterViewer.setColumnProperties(new String[]{"1", "2"});
        this.fFilterViewer.setCellModifier(this.getCellModifier());
        this.fFilterViewer.setInput((Object)this.queryMethod);
        this.fAddFilterButton.addListener(13, (Listener)this);
        this.fEditFilterButton.addListener(13, (Listener)this);
        this.fRemoveFilterButton.addListener(13, (Listener)this);
        this.fUpFilterButton.addListener(13, (Listener)this);
        this.fDownFilterButton.addListener(13, (Listener)this);
        this.updateFilterWidgetStates();
        return area;
    }

    private IContentProvider getFilterContentProvider() {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JpaFilterInfo filterData;
                Object[] ret = new Object[]{};
                if (inputElement instanceof JpaQueryMethodInfo && (filterData = ((JpaQueryMethodInfo)inputElement).getFilter(FilterPage.this.managerBean.getEntity())) != null) {
                    List conditionList = filterData.getConditionsList();
                    return conditionList.toArray();
                }
                return ret;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        return contentProvider;
    }

    private IBaseLabelProvider getFilterLabelProvider() {
        ITableLabelProvider labelProvider = new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return JpaPlugin.getImage("icons/condition1.gif");
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                RelationalSingleColumnConditionData condData = (RelationalSingleColumnConditionData)element;
                if (columnIndex == 0) {
                    return condData.getCondition();
                }
                return condData.getOperand() == 0 ? "AND" : "OR";
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        return labelProvider;
    }

    private void handleAddFilterBtnPressed() {
        Object result;
        AddFilterDialog addDialog = new AddFilterDialog(this.parent.getShell(), false);
        JpaEntityInfo entity = this.managerBean.getEntity();
        JpaFilterInfo filter = this.queryMethod.getFilter(entity);
        RelationalSingleColumnConditionData columnConditionData = RelationalSingleColumnConditionData.createRelationalSingleColumnConditionData(filter, entity.getAttributes(), null, null, null, null, "");
        addDialog.getConditionDataList().add(columnConditionData);
        addDialog.open();
        Object[] resultObjects = addDialog.getResult();
        if (resultObjects != null && resultObjects.length > 0 && (result = resultObjects[0]) instanceof RelationalSingleColumnConditionData) {
            JpaFilterInfo filterData = this.queryMethod.getFilter(this.managerBean.getEntity());
            filterData.addConditionsList(this.managerBean.getEntity(), (IConditionData)((RelationalSingleColumnConditionData)result));
            filterData.updateJPAFilterData(this.managerBean.getEntity());
            this.queryMethod.setFilter(filterData);
            this.queryUpdated();
        }
    }

    private void handleEditFilterBtnPressed() {
        Object result;
        AddFilterDialog addDialog = new AddFilterDialog(this.parent.getShell(), true);
        JpaEntityInfo entity = this.managerBean.getEntity();
        JpaFilterInfo filter = this.queryMethod.getFilter(entity);
        List<JpaAttributeInfo> attributeList = entity.getAttributes();
        if (attributeList.size() > 0) {
            ISingleColumnConditionData columnConditionData = (ISingleColumnConditionData)((StructuredSelection)this.fFilterViewer.getSelection()).getFirstElement();
            columnConditionData.setELValuePrefix("");
            addDialog.getConditionDataList().add(columnConditionData);
        }
        addDialog.open();
        Object[] resultObjects = addDialog.getResult();
        if (resultObjects != null && resultObjects.length > 0 && (result = resultObjects[0]) instanceof RelationalSingleColumnConditionData) {
            filter.editConditionsList(this.managerBean.getEntity(), (RelationalSingleColumnConditionData)result);
            this.queryUpdated();
        }
    }

    public void handleEvent(Event event) {
        Widget w = event.widget;
        if (w == this.fAddFilterButton) {
            this.handleAddFilterBtnPressed();
        } else if (w == this.fEditFilterButton) {
            this.handleEditFilterBtnPressed();
        } else if (w == this.fRemoveFilterButton) {
            this.handleRemoveFilterBtnPressed();
        } else if (w == this.fUpFilterButton || w == this.fDownFilterButton) {
            boolean moveUp = w == this.fUpFilterButton;
            this.handleUpDownFilterBtnPressed(moveUp);
        }
        this.updateFilterWidgetStates();
    }

    private void handleRemoveFilterBtnPressed() {
        JpaFilterInfo filter = this.queryMethod.getFilter(this.managerBean.getEntity());
        for (IConditionData conditionData : (StructuredSelection)this.fFilterViewer.getSelection()) {
            filter.removeConditionsList(this.managerBean.getEntity(), conditionData);
        }
        this.queryUpdated();
    }

    private void handleUpDownFilterBtnPressed(boolean moveUp) {
        JpaFilterInfo filter = this.queryMethod.getFilter(this.managerBean.getEntity());
        for (IConditionData conditionData : (StructuredSelection)this.fFilterViewer.getSelection()) {
            filter.moveConditionsList(this.managerBean.getEntity(), moveUp, conditionData);
        }
        this.queryUpdated();
    }

    private void queryUpdated() {
        this.queryMethod.updateQuery(this.managerBean.getEntity());
        this.fFilterViewer.refresh();
        this.model.notifyPropertyChange("IJpaDataModelProperties.selectedQueryMethod", 1);
    }

    public void refresh() {
        if (this.fFilterViewer != null) {
            this.fFilterViewer.refresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateFilterWidgetStates();
    }

    public void updateFilterWidgetStates() {
        boolean isFilterEmpty = this.fFilterViewer.getSelection().isEmpty();
        this.fAddFilterButton.setEnabled(true);
        this.fEditFilterButton.setEnabled(!isFilterEmpty);
        this.fRemoveFilterButton.setEnabled(!isFilterEmpty);
        this.fUpFilterButton.setEnabled(!isFilterEmpty);
        this.fDownFilterButton.setEnabled(!isFilterEmpty);
        if (!isFilterEmpty) {
            IConditionData conditionData = (IConditionData)((StructuredSelection)this.fFilterViewer.getSelection()).getFirstElement();
            this.fUpFilterButton.setEnabled(this.fFilterViewer.getElementAt(0) != conditionData);
            this.fDownFilterButton.setEnabled(this.fFilterViewer.getElementAt(this.fFilterViewer.getTable().getItemCount() - 1) != conditionData);
        }
    }
}

