/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipMappingInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddRelationshipDialog
extends TitleAreaDialog {
    private JpaManagerBeanInfo managerBean;
    private JpaRelationshipInfo relationship;
    private boolean showFullPath;
    private Combo entityCombo;
    private Button oneToOneButton;
    private Button oneToManyButton;
    private Button manyToOneButton;
    private Button manyToManyButton;
    private Button biDirectionButton;
    private Button uniDirectionButton;
    private Table relationshipTable;
    private TableColumn leftColumn;
    private TableColumn rightColumn;
    private TableViewer relationshipViewer;
    private ComboBoxCellEditor leftCellEditor;
    private ComboBoxCellEditor rightCellEditor;
    private List<JpaEntityInfo> entities;
    private List<JpaAttributeInfo> owningAttributes;
    private List<JpaAttributeInfo> relationshipAttributes;
    private List<JpaAttributeInfo> leftModifyAttributes;
    private List<JpaAttributeInfo> rightModifyAttributes;

    public AddRelationshipDialog(Shell parent, IDataModel model) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x20);
        this.managerBean = (JpaManagerBeanInfo)model.getProperty("IJpaDataModelProperties.userSelection");
        this.relationship = (JpaRelationshipInfo)model.getProperty("IJpaDataModelProperties.selectedRelationship");
        this.showFullPath = model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
        List allEntities = (List)model.getProperty("IJpaDataModelProperties.availableSelections");
        for (JpaManagerBeanInfo entity : allEntities) {
            if (this.entities == null) {
                this.entities = new ArrayList<JpaEntityInfo>();
            }
            this.entities.add(entity.getEntity());
        }
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(JpaUI._UI_Add_Relationship);
        this.setTitle(JpaUI._UI_Add_Relationship);
        this.setMessage(JpaUI._UI_Relationship_Desc);
        Composite area = UIPartsUtil.createComposite(parent, 1, 1);
        GridLayout layout = (GridLayout)area.getLayout();
        layout.marginWidth = 2;
        UIPartsUtil.createSeparator(area, 256, 1);
        this.createEntitySelectionComposite(area);
        this.createToggleButtonComposite(area);
        this.createRadioButtonComposite(area);
        this.createTablesComposite(area);
        this.setInitialValues();
        return area;
    }

    private Composite createEntitySelectionComposite(Composite parent) {
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        GridData data = (GridData)area.getLayoutData();
        data.grabExcessVerticalSpace = false;
        UIPartsUtil.createLabel(area, JpaUI._UI_Create_New_Relationship, 1);
        this.entityCombo = UIPartsUtil.createCombo(area, 8, 1);
        this.entityCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = AddRelationshipDialog.this.entityCombo.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                JpaEntityInfo selectedEntity = (JpaEntityInfo)AddRelationshipDialog.this.entities.get(index);
                selectedEntity.initializeIfNeeded();
                AddRelationshipDialog.this.relationship.setEntity(selectedEntity);
                AddRelationshipDialog.this.oneToOneButton.setEnabled(true);
                AddRelationshipDialog.this.oneToManyButton.setEnabled(true);
                AddRelationshipDialog.this.manyToOneButton.setEnabled(true);
                AddRelationshipDialog.this.manyToManyButton.setEnabled(true);
                AddRelationshipDialog.this.relationshipTable.setEnabled(AddRelationshipDialog.this.shouldEnabledTable());
                AddRelationshipDialog.this.updateAttributeTable();
                AddRelationshipDialog.this.updateMappings();
                AddRelationshipDialog.this.validatePage();
            }
        });
        return area;
    }

    private Composite createRadioButtonComposite(Composite parent) {
        Composite radioButtonComposite = UIPartsUtil.createComposite(parent, 2, 1);
        this.biDirectionButton = UIPartsUtil.createRadioButton(radioButtonComposite, JpaUI._UI_Bidirectional, 1, true);
        this.biDirectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipDialog.this.handleRadioButton(e);
            }
        });
        this.uniDirectionButton = UIPartsUtil.createRadioButton(radioButtonComposite, JpaUI._UI_Unidirectional, 1, false);
        this.uniDirectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipDialog.this.handleRadioButton(e);
            }
        });
        return radioButtonComposite;
    }

    private Composite createTablesComposite(Composite parent) {
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        this.relationshipTable = UIPartsUtil.createTable(area, 4, 1, true, true);
        this.relationshipTable.setEnabled(false);
        GridData data = (GridData)this.relationshipTable.getLayoutData();
        data.heightHint = 80;
        this.relationshipViewer = new TableViewer(this.relationshipTable);
        TableLayout layout = new TableLayout();
        this.leftColumn = new TableColumn(this.relationshipTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.rightColumn = new TableColumn(this.relationshipTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.relationshipViewer.setLabelProvider((IBaseLabelProvider)new RelationshipLabelProvider());
        this.relationshipViewer.setContentProvider((IContentProvider)new RelationshipContentProvider());
        this.relationshipViewer.setCellEditors(new CellEditor[]{this.getLeftCellEditor(), this.getRightCellEditor()});
        this.relationshipViewer.setColumnProperties(new String[]{"Left", "Right"});
        this.relationshipViewer.setCellModifier((ICellModifier)new RelationshipCellModifier());
        this.relationshipTable.setLayout((Layout)layout);
        this.relationshipTable.layout(true);
        return area;
    }

    private Composite createToggleButtonComposite(Composite parent) {
        Composite buttonComposite = UIPartsUtil.createComposite(parent, 5, 1);
        UIPartsUtil.createLabel(buttonComposite, JpaUI._UI_Multiplicity, 1);
        this.oneToOneButton = UIPartsUtil.createToggleButton(buttonComposite, null, 1, false);
        this.oneToOneButton.setImage(JpaPlugin.getImage("icons/size16/one-to-one.gif"));
        this.oneToOneButton.setToolTipText(JpaUI._UI_One_to_One);
        this.oneToOneButton.setEnabled(false);
        this.oneToOneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipDialog.this.handleMultiplicityButton(e);
            }
        });
        this.oneToManyButton = UIPartsUtil.createToggleButton(buttonComposite, null, 1, false);
        this.oneToManyButton.setImage(JpaPlugin.getImage("icons/size16/one-to-many.gif"));
        this.oneToManyButton.setToolTipText(JpaUI._UI_One_to_Many);
        this.oneToManyButton.setEnabled(false);
        this.oneToManyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipDialog.this.handleMultiplicityButton(e);
            }
        });
        this.manyToOneButton = UIPartsUtil.createToggleButton(buttonComposite, null, 1, false);
        this.manyToOneButton.setImage(JpaPlugin.getImage("icons/size16/many-to-one.gif"));
        this.manyToOneButton.setToolTipText(JpaUI._UI_Many_to_One);
        this.manyToOneButton.setEnabled(false);
        this.manyToOneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipDialog.this.handleMultiplicityButton(e);
            }
        });
        this.manyToManyButton = UIPartsUtil.createToggleButton(buttonComposite, null, 1, false);
        this.manyToManyButton.setImage(JpaPlugin.getImage("icons/size16/many-to-many.gif"));
        this.manyToManyButton.setToolTipText(JpaUI._UI_Many_to_Many);
        this.manyToManyButton.setEnabled(false);
        this.manyToManyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipDialog.this.handleMultiplicityButton(e);
            }
        });
        return buttonComposite;
    }

    private ComboBoxCellEditor getLeftCellEditor() {
        if (this.leftCellEditor == null) {
            this.leftCellEditor = new ComboBoxCellEditor((Composite)this.relationshipTable, new String[0], 8);
        }
        return this.leftCellEditor;
    }

    private ComboBoxCellEditor getRightCellEditor() {
        if (this.rightCellEditor == null) {
            this.rightCellEditor = new ComboBoxCellEditor((Composite)this.relationshipTable, new String[0], 8);
        }
        return this.rightCellEditor;
    }

    private void handleMultiplicityButton(SelectionEvent event) {
        ((Button)event.widget).setSelection(true);
        if (event.widget == this.oneToOneButton) {
            this.relationship.setMultiplicity(JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE);
        } else {
            this.oneToOneButton.setSelection(false);
        }
        if (event.widget == this.oneToManyButton) {
            this.relationship.setMultiplicity(JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY);
        } else {
            this.oneToManyButton.setSelection(false);
        }
        if (event.widget == this.manyToOneButton) {
            this.relationship.setMultiplicity(JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE);
        } else {
            this.manyToOneButton.setSelection(false);
        }
        if (event.widget == this.manyToManyButton) {
            this.relationship.setMultiplicity(JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY);
        } else {
            this.manyToManyButton.setSelection(false);
        }
        this.relationshipTable.setEnabled(this.shouldEnabledTable());
        this.updateMappings();
        this.validatePage();
    }

    private void handleRadioButton(SelectionEvent event) {
        if (this.uniDirectionButton.getSelection()) {
            this.relationship.setDirectional(JpaRelationshipInfo.DIRECTIONAL.UNIDIRECTION);
        } else {
            this.relationship.setDirectional(JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL);
        }
        this.relationshipTable.setEnabled(this.shouldEnabledTable());
        if (this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
            this.updateMappings();
        }
        this.validatePage();
    }

    private void setInitialValues() {
        Collections.sort(this.entities);
        ArrayList<String> entityNameList = new ArrayList<String>();
        for (JpaEntityInfo entity : this.entities) {
            if (this.showFullPath) {
                entityNameList.add(entity.getFullyQualifiedEntityName());
                continue;
            }
            entityNameList.add(entity.getEntityName());
        }
        this.entityCombo.setItems(entityNameList.toArray(new String[0]));
        this.oneToOneButton.setSelection(true);
        this.relationship.setMultiplicity(JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE);
        this.biDirectionButton.setSelection(true);
        this.relationship.setDirectional(JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL);
        this.updateAttributeTable();
        this.updateMappings();
        this.validatePage();
    }

    private boolean shouldEnabledTable() {
        if (this.entityCombo.getSelectionIndex() == -1) {
            return false;
        }
        if (this.uniDirectionButton.getSelection()) {
            return !this.oneToManyButton.getSelection() && !this.manyToManyButton.getSelection();
        }
        return !this.manyToManyButton.getSelection();
    }

    private void updateAttributeTable() {
        JpaEntityInfo relEntity;
        if (this.owningAttributes == null) {
            JpaEntityInfo entity = this.managerBean.getEntity();
            this.owningAttributes = entity.getAttributes();
            Collections.sort(this.owningAttributes);
        }
        if ((relEntity = this.relationship.getEntity()) != null) {
            this.relationshipAttributes = this.relationship.getEntity().getAttributes();
            Collections.sort(this.relationshipAttributes);
        }
        this.relationshipViewer.refresh();
    }

    private void updateMappings() {
        this.relationship.clearAttributeMappings();
        JpaEntityInfo entity = this.managerBean.getEntity();
        JpaEntityInfo relEntity = this.relationship.getEntity();
        if (this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
            if (relEntity != null) {
                this.leftColumn.setText(NLS.bind((String)JpaUI._UI_Foreign_Key, (Object)entity.getEntityName()));
                this.rightColumn.setText(NLS.bind((String)JpaUI._UI_Primary_Key, (Object)relEntity.getEntityName()));
                List<JpaAttributeInfo> primaryKeys = relEntity.getPrimaryKeyAttributes();
                for (JpaAttributeInfo attribute : primaryKeys) {
                    this.relationship.addAttributeMapping(new JpaRelationshipMappingInfo(attribute, null));
                }
            }
        } else if (this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
            if (relEntity != null) {
                if (this.relationship.getDirectional() == JpaRelationshipInfo.DIRECTIONAL.UNIDIRECTION) {
                    this.leftColumn.setText("");
                    this.rightColumn.setText("");
                } else {
                    this.leftColumn.setText(NLS.bind((String)JpaUI._UI_Primary_Key, (Object)entity.getEntityName()));
                    this.rightColumn.setText(NLS.bind((String)JpaUI._UI_Foreign_Key, (Object)relEntity.getEntityName()));
                    List<JpaAttributeInfo> primaryKeys = entity.getPrimaryKeyAttributes();
                    for (JpaAttributeInfo attribute : primaryKeys) {
                        this.relationship.addAttributeMapping(new JpaRelationshipMappingInfo(attribute, null));
                    }
                }
            }
        } else if (this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY && relEntity != null) {
            this.leftColumn.setText("");
            this.rightColumn.setText("");
        }
        this.relationshipViewer.setInput((Object)this.relationship);
        this.relationshipViewer.refresh();
    }

    private boolean validatePage() {
        if (this.getButton(0) != null) {
            if (this.entityCombo.getText() == null || this.entityCombo.getText().equals("")) {
                this.setErrorMessage(JpaUI._UI_Select_Entity_Error);
                this.getButton(0).setEnabled(false);
                return false;
            }
            List<JpaRelationshipMappingInfo> mappings = this.relationship.getAttributeMappings();
            if (mappings == null || mappings.size() < 1) {
                if (this.relationship.getDirectional() == JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL && this.relationship.getMultiplicity() != JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) {
                    this.getButton(0).setEnabled(false);
                    return false;
                }
                if (this.relationship.getDirectional() == JpaRelationshipInfo.DIRECTIONAL.UNIDIRECTION && this.relationship.getMultiplicity() != JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY && this.relationship.getMultiplicity() != JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) {
                    this.getButton(0).setEnabled(false);
                    return false;
                }
            }
            for (JpaRelationshipMappingInfo mapping : mappings) {
                if (mapping.getForeignKey() == null) {
                    this.setErrorMessage(NLS.bind((String)JpaUI._UI_Select_Foreign_Error, (Object)mapping.getPrimaryKey().getAttributeName()));
                    this.getButton(0).setEnabled(false);
                    return false;
                }
                if (!mapping.getForeignKey().isPrimaryKey()) continue;
                this.setErrorMessage(NLS.bind((String)JpaUI._UI_Select_Non_Primary_Key_Error, (Object)mapping.getForeignKey().getAttributeName()));
                this.getButton(0).setEnabled(false);
                return false;
            }
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(JpaUI._UI_Relationship_Desc);
        }
        return true;
    }

    public class RelationshipCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            boolean ret = false;
            if (property.equals("Right") ? AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY : property.equals("Left") && (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE)) {
                return true;
            }
            return ret;
        }

        private void filterCellEditorContents(JpaRelationshipMappingInfo mapping, String property) {
            String attType = mapping.getPrimaryKey().getAttributeType();
            ArrayList<String> theseAttributeStrings = new ArrayList<String>();
            if (property.equals("Left")) {
                AddRelationshipDialog.this.leftModifyAttributes = new ArrayList();
                for (JpaAttributeInfo thisAttribute : AddRelationshipDialog.this.owningAttributes) {
                    String type = thisAttribute.getAttributeType();
                    if (!type.equals(attType)) continue;
                    if (type.startsWith("java.lang.")) {
                        type = type.substring("java.lang.".length());
                    }
                    theseAttributeStrings.add(String.valueOf(thisAttribute.getAttributeName()) + " : " + type);
                    AddRelationshipDialog.this.leftModifyAttributes.add(thisAttribute);
                }
                AddRelationshipDialog.this.getLeftCellEditor().setItems(theseAttributeStrings.toArray(new String[0]));
            } else if (property.equals("Right")) {
                AddRelationshipDialog.this.rightModifyAttributes = new ArrayList();
                for (JpaAttributeInfo thisAttribute : AddRelationshipDialog.this.relationshipAttributes) {
                    String type = thisAttribute.getAttributeType();
                    if (!type.equals(attType)) continue;
                    if (type.startsWith("java.lang.")) {
                        type = type.substring("java.lang.".length());
                    }
                    theseAttributeStrings.add(String.valueOf(thisAttribute.getAttributeName()) + " : " + type);
                    AddRelationshipDialog.this.rightModifyAttributes.add(thisAttribute);
                }
                AddRelationshipDialog.this.getRightCellEditor().setItems(theseAttributeStrings.toArray(new String[0]));
            }
        }

        public Object getValue(Object element, String property) {
            JpaAttributeInfo attribute = null;
            JpaRelationshipMappingInfo mapping = (JpaRelationshipMappingInfo)element;
            this.filterCellEditorContents(mapping, property);
            if (property.equals("Right")) {
                if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                    attribute = mapping.getForeignKey();
                } else if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                    attribute = mapping.getPrimaryKey();
                }
                return AddRelationshipDialog.this.rightModifyAttributes.indexOf(attribute);
            }
            if (property.equals("Left")) {
                if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                    attribute = mapping.getPrimaryKey();
                } else if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                    attribute = mapping.getForeignKey();
                }
                return AddRelationshipDialog.this.leftModifyAttributes.indexOf(attribute);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            JpaRelationshipMappingInfo mapping = (JpaRelationshipMappingInfo)item.getData();
            Integer val = (Integer)value;
            if (property.equals("Right")) {
                if (val >= 0) {
                    if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                        mapping.setForeignKey((JpaAttributeInfo)AddRelationshipDialog.this.rightModifyAttributes.get(val));
                    } else if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                        mapping.setPrimaryKey((JpaAttributeInfo)AddRelationshipDialog.this.rightModifyAttributes.get(val));
                    }
                }
            } else if (property.equals("Left") && val >= 0) {
                if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                    mapping.setPrimaryKey((JpaAttributeInfo)AddRelationshipDialog.this.leftModifyAttributes.get(val));
                } else if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                    mapping.setForeignKey((JpaAttributeInfo)AddRelationshipDialog.this.leftModifyAttributes.get(val));
                }
            }
            AddRelationshipDialog.this.relationshipViewer.refresh();
            AddRelationshipDialog.this.validatePage();
        }
    }

    private class RelationshipContentProvider
    implements IStructuredContentProvider {
        private RelationshipContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            JpaRelationshipInfo relationshipElement;
            List<JpaRelationshipMappingInfo> mappings;
            if (inputElement instanceof JpaRelationshipInfo && (mappings = (relationshipElement = (JpaRelationshipInfo)inputElement).getAttributeMappings()) != null) {
                return mappings.toArray();
            }
            return new JpaRelationshipMappingInfo[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RelationshipLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RelationshipLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof JpaRelationshipMappingInfo) {
                Image ret = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                JpaRelationshipMappingInfo mapping = (JpaRelationshipMappingInfo)element;
                if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE ? columnIndex == 0 && mapping.getForeignKey() == null : AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY && columnIndex == 1 && mapping.getForeignKey() == null) {
                    return ret;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JpaRelationshipMappingInfo) {
                JpaRelationshipMappingInfo mapping = (JpaRelationshipMappingInfo)element;
                if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE || AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                    if (columnIndex == 0) {
                        if (mapping.getForeignKey() == null) {
                            return JpaUI._UI_Select_Foreign_Key;
                        }
                        return mapping.getForeignKey().getAttributeName();
                    }
                    if (columnIndex == 1) {
                        return mapping.getPrimaryKey().getAttributeName();
                    }
                } else if (AddRelationshipDialog.this.relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                    if (columnIndex == 0) {
                        return mapping.getPrimaryKey().getAttributeName();
                    }
                    if (columnIndex == 1) {
                        if (mapping.getForeignKey() == null) {
                            return JpaUI._UI_Select_Foreign_Key;
                        }
                        return mapping.getForeignKey().getAttributeName();
                    }
                }
            }
            return "";
        }
    }
}

