/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages;

import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaMsg;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.QueryMethodContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.QueryMethodLabelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.SingleTableColumnMaximizer;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.AddEditMethodDialog;
import com.ibm.etools.webtools.slickui.SlickControlProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class QueryMethodsControlProvider
extends SlickControlProvider
implements IDataModelListener,
ISelectionChangedListener {
    private IDataModel dataModel;
    private boolean isConfigureEntities;
    private List<JpaQueryMethodInfo> queryMethods;
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button defaultButton;
    private Text queryText;

    public Composite getContents(Composite parent) {
        if (this.dataModel == null) {
            this.dataModel = (IDataModel)this.modelObject;
            this.dataModel.addListener((IDataModelListener)this);
            this.isConfigureEntities = this.dataModel.getBooleanProperty("IJpaDataModelProperties.isConfigureEntities");
        }
        final Shell shell = parent.getShell();
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        Label createLabel = UIPartsUtil.createLabel(area, JpaUI.QueryMethodsControlProvider_0, 2);
        GridData labelData = new GridData(0);
        labelData.horizontalSpan = 2;
        labelData.grabExcessHorizontalSpace = false;
        labelData.widthHint = 300;
        createLabel.setLayoutData((Object)labelData);
        Composite methodsComposite = UIPartsUtil.createComposite(area, 1, 1);
        Table table = UIPartsUtil.createTable(methodsComposite, 67586, 1, false, false);
        GridData data = (GridData)table.getLayoutData();
        data.widthHint = 225;
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText(JpaUI._UI_Query_Methods_Task);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new QueryMethodLabelProvider(this.isConfigureEntities));
        this.viewer.setContentProvider((IContentProvider)new QueryMethodContentProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (((JpaQueryMethodInfo)e1).getMethodName() == null) {
                    return -1;
                }
                return ((JpaQueryMethodInfo)e1).getMethodName().compareTo(((JpaQueryMethodInfo)e2).getMethodName());
            }
        });
        this.queryMethods = JpaUtil.getQueryMethods((JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection"));
        this.viewer.setInput(this.queryMethods);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        new SingleTableColumnMaximizer(table);
        table.setLayout((Layout)layout);
        table.layout(true);
        Composite buttonsComposite = UIPartsUtil.createComposite(area, 1, 1);
        data = (GridData)buttonsComposite.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        buttonsComposite.setLayoutData((Object)data);
        this.addButton = UIPartsUtil.createPushButton(buttonsComposite, JpaUI._UI_Add, 1, false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryMethodsControlProvider.this.handleAddButton(shell);
            }
        });
        this.editButton = UIPartsUtil.createPushButton(buttonsComposite, JpaUI._UI_Edit, 1, false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryMethodsControlProvider.this.handleEditButton(shell);
            }
        });
        this.removeButton = UIPartsUtil.createPushButton(buttonsComposite, JpaUI._UI_Remove, 1, false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryMethodsControlProvider.this.handleRemoveButton(shell);
            }
        });
        UIPartsUtil.createLabel(buttonsComposite, "", 1);
        this.defaultButton = UIPartsUtil.createPushButton(buttonsComposite, JpaUI.Restore, 1, false);
        this.defaultButton.setToolTipText(JpaUI.RestoreDefaultQuery);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryMethodsControlProvider.this.handleDefaultButton(shell);
            }
        });
        UIPartsUtil.createLabel(area, JpaUI._UI_Query_Statement, 2);
        this.queryText = UIPartsUtil.createMultiTextField(area, 2, 8, 35);
        this.setInitialSelection();
        return area;
    }

    public IStatus getValidationState() {
        return new Status(0, "com.ibm.etools.webtools.jpa", "");
    }

    public void handleAddButton(Shell shell) {
        ArrayList<String> methodNames = new ArrayList<String>();
        JpaManagerBeanInfo managerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection");
        for (JpaQueryMethodInfo queryMethod : this.queryMethods) {
            methodNames.add(queryMethod.getMethodName());
        }
        String methodName = JpaUtil.getUniqueDataName("get" + managerBean.getEntity().getName(), methodNames.toArray(new String[0]));
        this.dataModel.setProperty("IJpaDataModelProperties.selectedQueryMethod", (Object)new JpaQueryMethodInfo(methodName, methodName, NamedQueriesUtil.createQuery(managerBean.getEntity().getName(), null, null), JpaQueryMethodInfo.STATUS.NEW));
        AddEditMethodDialog addDialog = new AddEditMethodDialog(shell, this.dataModel, true);
        if (addDialog.open() == 0) {
            JpaQueryMethodInfo newMethod = (JpaQueryMethodInfo)this.dataModel.getProperty("IJpaDataModelProperties.selectedQueryMethod");
            newMethod.updateQuery(managerBean.getEntity());
            this.queryMethods.add(newMethod);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)newMethod), true);
        }
    }

    public void handleDefaultButton(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText(JpaUI.RestoreDefaultQuery);
        messageBox.setMessage(JpaMsg._Default_Query_Warning);
        if (messageBox.open() == 64) {
            boolean found;
            JpaManagerBeanInfo managerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection");
            List<JpaQueryMethodInfo> newQueryMethods = JpaUtil.getDefaultQueryMethods(managerBean);
            for (JpaQueryMethodInfo existingQueryMethod : this.queryMethods) {
                found = false;
                for (JpaQueryMethodInfo newDefaultQuery : newQueryMethods) {
                    if (!newDefaultQuery.getQueryName().equals(existingQueryMethod.getQueryName())) continue;
                    found = true;
                    if (newDefaultQuery.getQueryValue().equals(existingQueryMethod.getQueryValue())) continue;
                    existingQueryMethod.setStatus(JpaQueryMethodInfo.STATUS.CHANGED);
                    existingQueryMethod.setOldQueryName(existingQueryMethod.getQueryName());
                    existingQueryMethod.setOldQueryValue(existingQueryMethod.getQueryValue());
                    existingQueryMethod.setOldMethodName(existingQueryMethod.getMethodName());
                    existingQueryMethod.setQueryName(newDefaultQuery.getQueryName());
                    existingQueryMethod.setQueryValue(newDefaultQuery.getQueryValue());
                    existingQueryMethod.setMethodName(newDefaultQuery.getMethodName());
                }
                if (found) continue;
                existingQueryMethod.setStatus(JpaQueryMethodInfo.STATUS.REMOVE);
                existingQueryMethod.setOldQueryName(existingQueryMethod.getQueryName());
                existingQueryMethod.setOldQueryValue(existingQueryMethod.getQueryValue());
                existingQueryMethod.setOldMethodName(existingQueryMethod.getMethodName());
            }
            for (JpaQueryMethodInfo newDefaultQuery : newQueryMethods) {
                found = false;
                for (JpaQueryMethodInfo existingQueryMethod : this.queryMethods) {
                    if (!newDefaultQuery.getQueryName().equals(existingQueryMethod.getQueryName())) continue;
                    found = true;
                }
                if (found) continue;
                this.queryMethods.add(newDefaultQuery);
            }
            this.viewer.refresh();
        }
    }

    public void handleEditButton(Shell shell) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            JpaManagerBeanInfo managerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection");
            JpaQueryMethodInfo selectedMethod = (JpaQueryMethodInfo)selection.getFirstElement();
            this.dataModel.setProperty("IJpaDataModelProperties.selectedQueryMethod", (Object)new JpaQueryMethodInfo(selectedMethod.getMethodName(), selectedMethod.getQueryName(), selectedMethod.getQueryValue(), selectedMethod.getStatus()));
            AddEditMethodDialog editDialog = new AddEditMethodDialog(shell, this.dataModel, false);
            if (editDialog.open() == 0) {
                this.queryMethods.remove(selectedMethod);
                JpaQueryMethodInfo editedMethod = (JpaQueryMethodInfo)this.dataModel.getProperty("IJpaDataModelProperties.selectedQueryMethod");
                if (editedMethod.getStatus() != JpaQueryMethodInfo.STATUS.NEW) {
                    editedMethod.setStatus(JpaQueryMethodInfo.STATUS.CHANGED);
                }
                editedMethod.setOldQueryName(selectedMethod.getQueryName());
                editedMethod.setOldQueryValue(selectedMethod.getQueryValue());
                editedMethod.setOldMethodName(selectedMethod.getMethodName());
                editedMethod.updateQuery(managerBean.getEntity());
                this.queryMethods.add(editedMethod);
                this.viewer.refresh();
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)editedMethod), true);
            }
        }
    }

    public void handleRemoveButton(Shell shell) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            String selectListMethodName;
            IMethod method;
            JpaManagerBeanInfo managerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection");
            IType mgrBeanType = managerBean.getExistingManagerBeanType();
            if (mgrBeanType != null && managerBean.getEntity() != null && (method = mgrBeanType.getMethod(selectListMethodName = "get" + managerBean.getEntity().getEntityName() + "SelectList", new String[0])) != null && method.exists()) {
                try {
                    String source = method.getSource();
                    if (source != null) {
                        List selectedMethods = selection.toList();
                        for (JpaQueryMethodInfo selectedMethod : selectedMethods) {
                            String methodName = selectedMethod.getMethodName();
                            if (!source.contains(String.valueOf(methodName) + "()")) continue;
                            MessageBox messageBox = new MessageBox(shell, 196);
                            messageBox.setText(JpaUI.QueryMethodsControlProvider_3);
                            messageBox.setMessage(NLS.bind((String)JpaUI.QueryMethodsControlProvider_4, (Object)selectListMethodName));
                            if (messageBox.open() == 64) {
                                managerBean.setRegenSelectListMethod(true);
                                continue;
                            }
                            return;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            List selectedMethods = selection.toList();
            for (JpaQueryMethodInfo selectedMethod : selectedMethods) {
                if (selectedMethod.getStatus() == JpaQueryMethodInfo.STATUS.NEW) {
                    this.queryMethods.remove(selectedMethod);
                    continue;
                }
                selectedMethod.setStatus(JpaQueryMethodInfo.STATUS.REMOVE);
                selectedMethod.setOldQueryName(selectedMethod.getQueryName());
                selectedMethod.setOldQueryValue(selectedMethod.getQueryValue());
                selectedMethod.setOldMethodName(selectedMethod.getMethodName());
            }
            this.viewer.refresh();
        }
        this.setInitialSelection();
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJpaDataModelProperties.userSelection") && event.getFlag() == 1 && this.viewer != null) {
            this.queryMethods = JpaUtil.getQueryMethods((JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection"));
            this.viewer.setInput(this.queryMethods);
            this.dataModel.notifyPropertyChange("IJpaManagerBeanDataModelProperties.queryMethods", 1);
            this.viewer.refresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source.equals(this.viewer)) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            JpaQueryMethodInfo selectedMethod = (JpaQueryMethodInfo)selection.getFirstElement();
            if (selectedMethod == null) {
                this.queryText.setText("");
            } else if (selectedMethod.getQueryValue() != null) {
                this.queryText.setText(selectedMethod.getQueryValue());
            } else {
                this.queryText.setText("");
            }
        }
    }

    private void setInitialSelection() {
        Object firstMethod;
        if (this.viewer != null && (firstMethod = this.viewer.getElementAt(0)) != null) {
            StructuredSelection selection = new StructuredSelection(firstMethod);
            this.viewer.setSelection((ISelection)selection);
        }
    }

    public boolean shouldShow(Object model) {
        return true;
    }
}

