/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.pages;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.commands.JpaManagerBeanCommand;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.EntityLabelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.JpaManagerContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.SingleTableColumnMaximizer;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class ManagerBeanSelectionPage
extends DataModelWizardPage {
    private CheckboxTableViewer viewer;
    private Button newEntityButton;
    private Button selectAllButton;
    private Button deSelectAllButton;
    private MenuItem showFullPath;
    private List<JpaManagerBeanInfo> availableEntities;

    public ManagerBeanSelectionPage(IDataModel model, String pageName) {
        super(model, pageName, JpaUI._UI_New_JPA_Manager_Control_Wizard_Title, JpaPlugin.getImageDescriptor("icons/wizban/gen_beans_wiz.gif"));
        this.setDescription(String.valueOf(JpaUI.ManagerBeanSelectionPage_0) + JpaUI.ManagerBeanSelectionPage_1);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        UIPartsUtil.createLabel(area, JpaUI.PageLevelManagerBeanSelectionPage_2, 2);
        Table table = UIPartsUtil.createTable(area, 34, 1, false, true);
        GridData data = (GridData)table.getLayoutData();
        data.widthHint = 250;
        data.heightHint = 250;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText(JpaUI._UI_Entity_Name);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntityLabelProvider(false, true, false, false));
        boolean showAllInClasspath = this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
        IProject currentProject = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        this.viewer.setContentProvider((IContentProvider)new JpaManagerContentProvider(currentProject, showAllInClasspath, true));
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((JpaManagerBeanInfo)e1).getExistingManagerBeanType().getElementName().compareTo(((JpaManagerBeanInfo)e2).getExistingManagerBeanType().getElementName());
            }
        });
        this.availableEntities = (List)this.model.getProperty("IJpaDataModelProperties.availableSelections");
        this.viewer.setInput(this.availableEntities);
        this.synchHelper.synchCheckBoxTableViewer(this.viewer, "IJpaDataModelProperties.userSelections", null);
        new SingleTableColumnMaximizer(table);
        Menu menu = new Menu((Control)area);
        table.setMenu(menu);
        this.showFullPath = new MenuItem(menu, 32);
        this.showFullPath.setText(JpaUI._UI_Fully_Qualified);
        this.showFullPath.setSelection(this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath"));
        this.showFullPath.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean existingSelection = ManagerBeanSelectionPage.this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
                boolean newSelection = ((MenuItem)event.widget).getSelection();
                if (newSelection != existingSelection) {
                    ManagerBeanSelectionPage.this.model.setBooleanProperty("IJpaDataModelProperties.showFullPath", newSelection);
                }
            }
        });
        MenuItem showAll = new MenuItem(menu, 32);
        showAll.setText(JpaUI._UI_All_Managers);
        showAll.setSelection(this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath"));
        showAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean existingSelection = ManagerBeanSelectionPage.this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
                boolean newSelection = ((MenuItem)event.widget).getSelection();
                if (newSelection != existingSelection) {
                    IProject currentProject = null;
                    if (!newSelection) {
                        currentProject = (IProject)ManagerBeanSelectionPage.this.model.getProperty("IJpaDataModelProperties.selectedProject");
                    }
                    ManagerBeanSelectionPage.this.model.setBooleanProperty("IJpaDataModelProperties.showAllInClasspath", newSelection);
                    ManagerBeanSelectionPage.this.viewer.setContentProvider((IContentProvider)new JpaManagerContentProvider(currentProject, newSelection, true));
                    ManagerBeanSelectionPage.this.viewer.refresh();
                }
            }
        });
        table.setLayout((Layout)layout);
        table.layout(true);
        this.newEntityButton = UIPartsUtil.createPushButton(area, JpaUI.PageLevelManagerBeanSelectionPage_3, 1, false);
        this.newEntityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerBeanSelectionPage.this.handleNewManagerButton();
            }
        });
        Composite buttonComposite = UIPartsUtil.createComposite(area, 2, 1);
        ((GridLayout)buttonComposite.getLayout()).marginWidth = 0;
        ((GridLayout)buttonComposite.getLayout()).marginHeight = 0;
        this.selectAllButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Select_All, 1, false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerBeanSelectionPage.this.handleSelectAllButton();
            }
        });
        this.selectAllButton.setFocus();
        this.deSelectAllButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Deselect_All, 1, false);
        this.deSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerBeanSelectionPage.this.handleDeselectAllButton();
            }
        });
        return area;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJpaDataModelProperties.userSelections"};
    }

    private void handleDeselectAllButton() {
        this.viewer.setAllChecked(false);
        this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)new Object[0]);
    }

    private void handleNewManagerButton() {
        String generationType = this.model.getStringProperty("IJpaDataModelProperties.generationType");
        IProject project = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        JpaManagerBeanCommand cmd = new JpaManagerBeanCommand(project, this.getShell(), generationType, false, false);
        cmd.execute();
        boolean showAllProjects = this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
        List<JpaManagerBeanInfo> currentEntities = JpaUtil.createExistingManagerBeanModelsWithEntities(project, showAllProjects);
        for (JpaManagerBeanInfo info : currentEntities) {
            if (JpaUtil.contains(this.availableEntities, info.getEntity().getName())) continue;
            this.availableEntities.add(info);
        }
        this.model.setProperty("IJpaDataModelProperties.availableSelections", this.availableEntities);
        this.viewer.refresh();
    }

    private void handleSelectAllButton() {
        this.viewer.setAllChecked(true);
        Object[] checkedItems = this.viewer.getCheckedElements();
        this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)checkedItems);
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJpaDataModelProperties.showFullPath") && this.viewer != null) {
            boolean newValue = this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
            this.showFullPath.setSelection(newValue);
            this.viewer.setLabelProvider((IBaseLabelProvider)new EntityLabelProvider(false, true, false, newValue));
            this.viewer.refresh();
        }
        super.propertyChanged(event);
    }
}

