/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class UIPartsUtil {
    public static final int INDENT_SIZE = 15;

    private UIPartsUtil() {
    }

    public static Button createCheckBox(Composite group, String label, SelectionListener slistener, int span) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Combo createCombo(Composite parent, int style, int span) {
        Combo combo = new Combo(parent, style);
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public static Composite createComposite(Composite parent, int numColumns, int span) {
        Composite composite = new Composite(parent, 0);
        UIPartsUtil.setGridLayout(composite, numColumns, span);
        return composite;
    }

    public static Group createGroup(Composite parent, int numColumns, int span, String text) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 128, true, false, span, 1);
        group.setLayoutData((Object)data);
        group.setText(text);
        return group;
    }

    public static Hyperlink createHyperLink(Composite parent, String linkText) {
        return UIPartsUtil.createHyperLink(parent, linkText, true);
    }

    public static Hyperlink createHyperLink(Composite parent, String linkText, boolean userLeadingSpacer) {
        final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        toolkit.setBackground(parent.getBackground());
        if (userLeadingSpacer) {
            new Label(parent, 0);
        }
        Hyperlink linkToHelp = toolkit.createHyperlink(parent, linkText, 0);
        linkToHelp.setLayoutData((Object)new GridData(2));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        return linkToHelp;
    }

    public static Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData(256);
        data.horizontalSpan = span;
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createMultiTextField(Composite parent, int span, int style, int heightHint) {
        Text text = new Text(parent, style | 2 | 0x800 | 0x40 | 0x200);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = span;
        data.heightHint = heightHint;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Button createPushButton(Composite parent, String label, int span, boolean expand) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(4, 128, false, false, span, 1);
        if (expand) {
            data.grabExcessHorizontalSpace = false;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 2;
        }
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createRadioButton(Composite parent, String label, int span, boolean selected) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setSelection(selected);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Label createSeparator(Composite parent, int style, int span) {
        Label sep = new Label(parent, 2 | style);
        GridData data = new GridData(256);
        data.horizontalSpan = span;
        sep.setLayoutData((Object)data);
        return sep;
    }

    public static Table createTable(Composite parent, int selectionStyle, int span, boolean showHeader, boolean showLines) {
        Table table = new Table(parent, selectionStyle | 0x800 | 0x100 | 0x200 | 0x10000);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = span;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(showLines);
        table.setHeaderVisible(showHeader);
        return table;
    }

    public static Text createTextField(Composite parent, int span) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = span;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Button createToggleButton(Composite parent, String label, int span, boolean selected) {
        Button button = new Button(parent, 2);
        if (label != null) {
            button.setText(label);
        }
        button.setSelection(selected);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    private static void setGridLayout(Composite composite, int numColumns, int span) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = span;
        composite.setLayoutData((Object)data);
    }
}

