/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard;

import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.NamedQuerySelectParts;
import com.ibm.etools.webtools.jpa.wizard.model.JpaPageDataModelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.pages.GenerateControlsPage;
import com.ibm.etools.webtools.jpa.wizard.ui.pages.PageLevelFilterValuesPage;
import com.ibm.etools.webtools.jpa.wizard.ui.pages.PageLevelManagerBeanSelectionPage;
import com.ibm.etools.webtools.jpa.wizard.ui.pages.PageLevelQuerySelectPage;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class JpaDataWizard
extends DataModelWizard {
    private static final String WIZARD_PAGE_MANAGER_SELECTION = "WIZARD_PAGE_MANAGER_SELECTION";
    private static final String WIZARD_PAGE_GENERATE_CONTROLS = "WIZARD_PAGE_GENERATE_CONTROLS";
    private static final String WIZARD_PAGE_QUERY = "WIZARD_PAGE_QUERY";
    private static final String WIZARD_PAGE_QUERY_FILTER = "WIZARD_PAGE_QUERY_FILTER";

    public JpaDataWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(JpaUI.JpaDataWizardAddJpaDataTitle);
    }

    protected void doAddPages() {
        if (!this.getDataModel().getBooleanProperty("IJpaDataModelProperties.isConfigure") && !this.getDataModel().getBooleanProperty("IJpaDataModelProperties.isMethodPreselected")) {
            this.addPage((IWizardPage)new PageLevelManagerBeanSelectionPage(this.getDataModel(), WIZARD_PAGE_MANAGER_SELECTION));
        }
        if (!this.getDataModel().getBooleanProperty("IJpaDataModelProperties.isMethodPreselected")) {
            this.addPage((IWizardPage)new PageLevelQuerySelectPage(this.getDataModel(), WIZARD_PAGE_QUERY));
            this.addPage((IWizardPage)new PageLevelFilterValuesPage(this.getDataModel(), WIZARD_PAGE_QUERY_FILTER));
        } else if (!this.getDataModel().getBooleanProperty("IJpaDataModelProperties.generationTypeCreate")) {
            this.addPage((IWizardPage)new PageLevelFilterValuesPage(this.getDataModel(), WIZARD_PAGE_QUERY_FILTER));
        }
        if (this.getDataModel().getBooleanProperty("IJpaDataModelProperties.generateUI")) {
            this.addPage((IWizardPage)new GenerateControlsPage(this.getDataModel(), WIZARD_PAGE_GENERATE_CONTROLS));
        }
    }

    protected IDataModelProvider getDefaultProvider() {
        return new JpaPageDataModelProvider();
    }

    public String getNextPage(String currentPageName, String expectedNextPageName) {
        if (currentPageName != null) {
            JpaQueryMethodInfo queryMethod;
            JpaManagerBeanInfo jpaManagerBean;
            if (currentPageName.equals(WIZARD_PAGE_MANAGER_SELECTION)) {
                if (this.getDataModel().getBooleanProperty("IJpaDataModelProperties.generationTypeCreate")) {
                    if (this.getDataModel().getBooleanProperty("IJpaDataModelProperties.generateUI")) {
                        return WIZARD_PAGE_GENERATE_CONTROLS;
                    }
                    return null;
                }
            } else if (currentPageName.equals(WIZARD_PAGE_QUERY) && (jpaManagerBean = (JpaManagerBeanInfo)this.getDataModel().getProperty("IJpaDataModelProperties.userSelection")) != null && (queryMethod = (JpaQueryMethodInfo)this.getDataModel().getProperty("IJpaDataModelProperties.selectedQueryMethod")) != null) {
                JpaEntityInfo entity = jpaManagerBean.getEntity();
                JpaFilterInfo filterInfo = queryMethod.getFilter(entity);
                if (filterInfo != null) {
                    List<JpaFilterParameterInfo> parameters = filterInfo.getParameters();
                    if (parameters != null && parameters.isEmpty()) {
                        if (this.getDataModel().getBooleanProperty("IJpaDataModelProperties.generateUI")) {
                            return WIZARD_PAGE_GENERATE_CONTROLS;
                        }
                        return null;
                    }
                } else {
                    if (queryMethod.getSelectParts().getQueryType() == NamedQuerySelectParts.QUERY_TYPE.BEAN) {
                        if (this.getDataModel().getBooleanProperty("IJpaDataModelProperties.generateUI")) {
                            return WIZARD_PAGE_GENERATE_CONTROLS;
                        }
                        return null;
                    }
                    return null;
                }
            }
        }
        return expectedNextPageName;
    }

    public String getPreviousPage(String currentPageName, String expectedPreviousPageName) {
        return expectedPreviousPageName;
    }
}

