/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaOrderedAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.NamedQuerySelectParts;
import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;
import org.eclipse.emf.common.util.EList;

public class QueryParsingUtil {
    private static int findLowIndex(int startIndex, int[] possibleIndexes) {
        int lowIndex = -1;
        int i = 0;
        while (i < possibleIndexes.length) {
            if ((possibleIndexes[i] < lowIndex || lowIndex == -1) && possibleIndexes[i] > startIndex) {
                lowIndex = possibleIndexes[i];
            }
            ++i;
        }
        return lowIndex;
    }

    private static QueryStatement getParseResult(String statement) throws SQLParserException, SQLParserInternalException {
        SQLQueryParserManager parserManager = SQLQueryParserManagerProvider.getInstance().getParserManager(null, null);
        SQLQueryParseResult parseResult = parserManager.parseQuery(statement);
        return parseResult.getQueryStatement();
    }

    public static void initializeStatementParts(JpaQueryMethodInfo queryMethod) {
        QuerySearchCondition havingClause;
        QueryStatement queryStatement = null;
        QuerySelect selectQuery = null;
        boolean isBadParse = false;
        int fromIndex = -1;
        int whereIndex = -1;
        int groupByIndex = -1;
        int orderByIndex = -1;
        int havingIndex = -1;
        try {
            queryStatement = QueryParsingUtil.getParseResult(queryMethod.getQueryValue());
            selectQuery = (QuerySelect)((QuerySelectStatement)queryStatement).getQueryExpr().getQuery();
        }
        catch (SQLParserException sQLParserException) {
            isBadParse = true;
            String queryValue = queryMethod.getQueryValue();
            fromIndex = queryValue.indexOf(" FROM ");
            if (fromIndex == -1) {
                fromIndex = queryValue.indexOf(" from ");
            }
            if (fromIndex == -1) {
                fromIndex = queryValue.indexOf(" From ");
            }
            if ((whereIndex = queryValue.indexOf(" WHERE ")) == -1) {
                whereIndex = queryValue.indexOf(" where ");
            }
            if (whereIndex == -1) {
                whereIndex = queryValue.indexOf(" Where ");
            }
            if ((groupByIndex = queryValue.indexOf(" GROUP BY ")) == -1) {
                groupByIndex = queryValue.indexOf(" group by ");
            }
            if (groupByIndex == -1) {
                groupByIndex = queryValue.indexOf(" Group By ");
            }
            if (groupByIndex == -1) {
                groupByIndex = queryValue.indexOf(" Group by ");
            }
            if ((orderByIndex = queryValue.indexOf(" ORDER BY ")) == -1) {
                orderByIndex = queryValue.indexOf(" order by ");
            }
            if (orderByIndex == -1) {
                orderByIndex = queryValue.indexOf(" Order By ");
            }
            if (orderByIndex == -1) {
                orderByIndex = queryValue.indexOf(" Order by ");
            }
            if ((havingIndex = queryValue.indexOf(" HAVING ")) == -1) {
                havingIndex = queryValue.indexOf(" having ");
            }
            if (havingIndex == -1) {
                havingIndex = queryValue.indexOf(" Having ");
            }
        }
        catch (SQLParserInternalException e1) {
            e1.printStackTrace();
        }
        EList statement = null;
        String statementString = "";
        int index = 0;
        if (isBadParse) {
            String tempSelectStatement = null;
            int lowIndex = QueryParsingUtil.findLowIndex(0, new int[]{fromIndex, whereIndex, groupByIndex, orderByIndex, havingIndex});
            NamedQuerySelectParts selectParts = null;
            selectParts = lowIndex == -1 ? new NamedQuerySelectParts(queryMethod.getQueryValue()) : new NamedQuerySelectParts(queryMethod.getQueryValue().substring(0, lowIndex));
            queryMethod.setSelectParts(selectParts);
            if (selectParts.getQueryType() == NamedQuerySelectParts.QUERY_TYPE.BEAN) {
                tempSelectStatement = "SELECT *";
                if (fromIndex >= 0) {
                    tempSelectStatement = String.valueOf(tempSelectStatement) + queryMethod.getQueryValue().substring(fromIndex);
                }
                try {
                    queryStatement = QueryParsingUtil.getParseResult(tempSelectStatement);
                    isBadParse = false;
                    selectQuery = (QuerySelect)((QuerySelectStatement)queryStatement).getQueryExpr().getQuery();
                }
                catch (SQLParserException e1) {
                    e1.printStackTrace();
                }
                catch (SQLParserInternalException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            queryMethod.setSelectParts(new NamedQuerySelectParts(selectQuery.getSelectClause(), selectQuery.isDistinct()));
        }
        if (isBadParse) {
            int lowIndex = QueryParsingUtil.findLowIndex(fromIndex, new int[]{whereIndex, groupByIndex, orderByIndex, havingIndex});
            if (lowIndex == -1) {
                queryMethod.setFromStatement(queryMethod.getQueryValue().substring(fromIndex));
            } else {
                queryMethod.setFromStatement(queryMethod.getQueryValue().substring(fromIndex + 6, lowIndex));
            }
        } else {
            statement = selectQuery.getFromClause();
            statementString = "";
            index = 0;
            for (TableInDatabase from : statement) {
                statementString = index == 0 ? from.getSourceInfo().getSourceSnippet() : String.valueOf(statementString) + ", " + from.getSourceInfo().getSourceSnippet();
                ++index;
            }
            queryMethod.setFromStatement(statementString);
        }
        if (isBadParse) {
            String newWhereStatement = "SELECT * FROM table WHERE " + queryMethod.getQueryValue().substring(whereIndex + 7);
            try {
                selectQuery = null;
                queryStatement = QueryParsingUtil.getParseResult(newWhereStatement);
                selectQuery = (QuerySelect)((QuerySelectStatement)queryStatement).getQueryExpr().getQuery();
            }
            catch (SQLParserException e1) {
                e1.printStackTrace();
            }
            catch (SQLParserInternalException e1) {
                e1.printStackTrace();
            }
        }
        if (selectQuery != null) {
            QuerySearchCondition whereClause = selectQuery.getWhereClause();
            JpaFilterInfo filterInfo = new JpaFilterInfo();
            if (whereClause != null) {
                filterInfo.setPredicate(whereClause.getSourceInfo().getSourceSnippet());
            }
            queryMethod.setFilter(filterInfo);
        }
        if (!isBadParse) {
            statement = selectQuery.getGroupByClause();
            statementString = "";
            index = 0;
            for (GroupingExpression grouping : statement) {
                statementString = index == 0 ? grouping.getSourceInfo().getSourceSnippet() : String.valueOf(statementString) + ", " + grouping.getSourceInfo().getSourceSnippet();
                ++index;
            }
            queryMethod.setGroupStatement(statementString);
        }
        if (!isBadParse) {
            ArrayList<JpaOrderedAttributeInfo> orderedAttributes = new ArrayList<JpaOrderedAttributeInfo>();
            statement = ((QuerySelectStatement)queryStatement).getOrderByClause();
            for (Object orderBy : statement) {
                int spaceIndex;
                int indexOf;
                int val = 0;
                String attributeName = null;
                if (orderBy instanceof OrderByValueExpression) {
                    val = ((OrderByValueExpression)orderBy).getOrderingSpecOption().getValue();
                    attributeName = ((OrderByValueExpression)orderBy).getSourceInfo().getSourceSnippet();
                } else if (orderBy instanceof OrderByResultColumn) {
                    val = ((OrderByResultColumn)orderBy).getOrderingSpecOption().getValue();
                    attributeName = ((OrderByResultColumn)orderBy).getResultCol().getSourceInfo().getSourceSnippet();
                }
                if (val == 0) {
                    val = 1;
                }
                if ((indexOf = attributeName.indexOf(".")) >= 0) {
                    attributeName = attributeName.substring(indexOf + 1);
                }
                if ((spaceIndex = (attributeName = attributeName.trim()).indexOf(" ")) >= 0) {
                    attributeName = attributeName.substring(0, spaceIndex);
                }
                JpaOrderedAttributeInfo orderedAttribute = new JpaOrderedAttributeInfo(attributeName, val);
                orderedAttributes.add(orderedAttribute);
            }
            queryMethod.setOrderedAttributes(orderedAttributes);
        }
        if (isBadParse && havingIndex >= 0) {
            int lowIndex = QueryParsingUtil.findLowIndex(havingIndex, new int[]{fromIndex, whereIndex, groupByIndex, orderByIndex});
            if (lowIndex == -1) {
                queryMethod.setHavingStatement(queryMethod.getQueryValue().substring(havingIndex + 8));
            } else {
                queryMethod.setHavingStatement(queryMethod.getQueryValue().substring(havingIndex + 8, lowIndex));
            }
        } else if (!isBadParse && (havingClause = selectQuery.getHavingClause()) != null) {
            queryMethod.setHavingStatement(havingClause.getSourceInfo().getSourceSnippet());
        }
        queryMethod.setBadParse(isBadParse);
    }
}

