/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTModifiedDeclaration;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.orm.OrmResourceModel;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class AnnotationUtil {
    public static void addJPAManagerAnnotation(IType entityManagerBeanType, final String targetEntityClass, boolean saveCompilationUnit) {
        final CompilationUnit cu = JDTTools.buildASTRoot((ICompilationUnit)entityManagerBeanType.getCompilationUnit());
        String typeName = entityManagerBeanType.getElementName();
        final BodyDeclaration bodyDeclaration = NamedQueriesUtil.bodyDeclaration(cu, typeName);
        JDTModifiedDeclaration modDec = new JDTModifiedDeclaration(bodyDeclaration);
        try {
            AnnotationUtil.edit_(new Editor(){

                @Override
                public boolean edit(ModifiedDeclaration declaration, boolean overwriteIfExists) {
                    boolean contains;
                    AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)cu.types().get(0);
                    AST newAST = typeDeclaration.getAST();
                    Annotation annotation = AnnotationUtil.annotation(bodyDeclaration, "JPAManager");
                    if (!overwriteIfExists && (contains = bodyDeclaration.modifiers().contains(annotation))) {
                        return false;
                    }
                    bodyDeclaration.modifiers().remove(annotation);
                    declaration.addImport("com.ibm.jpa.web.JPAManager");
                    NormalAnnotation jpaManagerAnnotation = AnnotationUtil.newNormalAnnotation(newAST, "JPAManager");
                    jpaManagerAnnotation.values().add(AnnotationUtil.newMemberValuePair(newAST, newAST.newSimpleName("targetEntity"), (Expression)AnnotationUtil.newTypeLiteral(newAST, targetEntityClass)));
                    bodyDeclaration.modifiers().add(AnnotationUtil.newAnnotationInsertionIndex(bodyDeclaration), jpaManagerAnnotation);
                    return true;
                }
            }, entityManagerBeanType.getCompilationUnit(), cu, (ModifiedDeclaration)modDec, false, saveCompilationUnit, false);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static void addSuppressWarningsAnnotation(IType entityManagerBeanType, boolean saveCompilationUnit) {
        final CompilationUnit cu = JDTTools.buildASTRoot((ICompilationUnit)entityManagerBeanType.getCompilationUnit());
        String typeName = entityManagerBeanType.getElementName();
        final BodyDeclaration bodyDeclaration = NamedQueriesUtil.bodyDeclaration(cu, typeName);
        JDTModifiedDeclaration modDec = new JDTModifiedDeclaration(bodyDeclaration);
        try {
            AnnotationUtil.edit_(new Editor(){

                @Override
                public boolean edit(ModifiedDeclaration declaration, boolean overwriteIfExists) {
                    boolean contains;
                    AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)cu.types().get(0);
                    AST newAST = typeDeclaration.getAST();
                    Annotation annotation = AnnotationUtil.annotation(bodyDeclaration, "SuppressWarnings");
                    if (!overwriteIfExists && (contains = bodyDeclaration.modifiers().contains(annotation))) {
                        return false;
                    }
                    bodyDeclaration.modifiers().remove(annotation);
                    SingleMemberAnnotation singleAnnotation = AnnotationUtil.createSingleAnnotation("SuppressWarnings", "unchecked", true, newAST);
                    bodyDeclaration.modifiers().add(AnnotationUtil.newAnnotationInsertionIndex(bodyDeclaration), singleAnnotation);
                    return true;
                }
            }, entityManagerBeanType.getCompilationUnit(), cu, (ModifiedDeclaration)modDec, false, saveCompilationUnit, false);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static Annotation annotation(BodyDeclaration bodyDeclaration, String annotationName) {
        for (IExtendedModifier modifier : bodyDeclaration.modifiers()) {
            if (!modifier.isAnnotation() || !((Annotation)modifier).getTypeName().getFullyQualifiedName().equals(annotationName)) continue;
            return (Annotation)modifier;
        }
        return null;
    }

    public static SingleMemberAnnotation createJoinColumnsAnnotation(List<Annotation> joinColumnAnnotations, AST ast) {
        int packageIndex = "javax.persistence.".length();
        SingleMemberAnnotation joinColumnsAnnotation = AnnotationUtil.newSingleAnnotation(ast, "javax.persistence.JoinColumns".substring(packageIndex));
        ArrayInitializer ai = ast.newArrayInitializer();
        List arrayExpressions = ai.expressions();
        for (Annotation joinColumnAnnotation : joinColumnAnnotations) {
            arrayExpressions.add(joinColumnAnnotation);
        }
        joinColumnsAnnotation.setValue((Expression)ai);
        return joinColumnsAnnotation;
    }

    public static MarkerAnnotation createMarkerAnnotation(String name) {
        AST ast = AST.newAST((int)3);
        MarkerAnnotation annotation = AnnotationUtil.newMarkerAnnotation(ast, name);
        return annotation;
    }

    public static NormalAnnotation createNormalAnnotation(String name, String[] names, String[] values, ANNOTATION_TYPE[] types) {
        AST ast = AST.newAST((int)3);
        return AnnotationUtil.createNormalAnnotation(name, names, values, types, ast);
    }

    public static NormalAnnotation createNormalAnnotation(String name, String[] names, String[] values, ANNOTATION_TYPE[] types, AST ast) {
        NormalAnnotation annotation = AnnotationUtil.newNormalAnnotation(ast, name);
        int i = 0;
        while (i < names.length) {
            Object exp = types[i] == ANNOTATION_TYPE.STRING ? AnnotationUtil.newStringLiteral(ast, values[i]) : (types[i] == ANNOTATION_TYPE.TYPE ? AnnotationUtil.newTypeLiteral(ast, values[i]) : AnnotationUtil.newQualifiedName(ast, values[i]));
            annotation.values().add(AnnotationUtil.newMemberValuePair(ast, ast.newSimpleName(names[i]), (Expression)exp));
            ++i;
        }
        return annotation;
    }

    public static SingleMemberAnnotation createSingleAnnotation(String name, String value, boolean isString) {
        AST ast = AST.newAST((int)3);
        return AnnotationUtil.createSingleAnnotation(name, value, isString, ast);
    }

    public static SingleMemberAnnotation createSingleAnnotation(String name, String value, boolean isString, AST ast) {
        SingleMemberAnnotation annotation = AnnotationUtil.newSingleAnnotation(ast, name);
        Object exp = null;
        exp = isString ? AnnotationUtil.newStringLiteral(ast, value) : AnnotationUtil.newQualifiedName(ast, value);
        annotation.setValue((Expression)exp);
        return annotation;
    }

    private static void edit_(Editor editor, ICompilationUnit compilationUnit, CompilationUnit astRoot, ModifiedDeclaration modifiedDeclaration, boolean ignoreReconcile, boolean saveCompilationUnit, boolean overwriteIfExists) throws JavaModelException {
        if (!compilationUnit.isWorkingCopy()) {
            compilationUnit.becomeWorkingCopy(null, null);
        }
        astRoot.recordModifications();
        boolean edited = editor.edit(modifiedDeclaration, overwriteIfExists);
        if (edited) {
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(compilationUnit.getResource().getFullPath());
            boolean textEditorPresent = buffer != null;
            IDocument doc = textEditorPresent ? buffer.getDocument() : new Document(compilationUnit.getBuffer().getContents());
            TextEdit edits = astRoot.rewrite(doc, compilationUnit.getJavaProject().getOptions(true));
            try {
                edits.apply(doc, 2);
                DefaultAnnotationEditFormatter.instance().format(doc, edits);
            }
            catch (MalformedTreeException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (!textEditorPresent) {
                compilationUnit.getBuffer().setContents(doc.get());
                compilationUnit.commitWorkingCopy(true, null);
                compilationUnit.discardWorkingCopy();
            } else {
                if (!ignoreReconcile) {
                    compilationUnit.reconcile(0, false, null, null);
                }
                if (compilationUnit.isWorkingCopy()) {
                    if (JpaPlugin.handleValidateEdit(compilationUnit, null)) {
                        compilationUnit.commitWorkingCopy(true, null);
                    }
                } else if (JpaPlugin.handleValidateEdit(compilationUnit, null)) {
                    compilationUnit.save(null, true);
                }
            }
        }
    }

    private static OrmResource getOrmXMLResource(OrmPersistentType entity) {
        OrmResourceModel model;
        JpaFile jpaFile;
        OrmResource ormResource = null;
        JpaProject jpaProject = entity.getJpaProject();
        IResource resource = entity.getResource();
        if (jpaProject != null && resource != null && (jpaFile = jpaProject.getJpaFile((IFile)resource)) != null && (model = (OrmResourceModel)jpaFile.getResourceModel()) != null) {
            ormResource = model.getResource();
        }
        return ormResource;
    }

    public static int newAnnotationInsertionIndex(BodyDeclaration bodyDeclaration) {
        int index = 0;
        Iterator stream = bodyDeclaration.modifiers().iterator();
        while (stream.hasNext()) {
            if (((IExtendedModifier)stream.next()).isModifier()) break;
            ++index;
        }
        return index;
    }

    public static MarkerAnnotation newMarkerAnnotation(AST ast, String name) {
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    public static MemberValuePair newMemberValuePair(AST ast, SimpleName name, Expression value) {
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(name);
        pair.setValue(value);
        return pair;
    }

    public static NormalAnnotation newNormalAnnotation(AST ast, String name) {
        NormalAnnotation annotation = ast.newNormalAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    public static Name newQualifiedName(AST ast, String value) {
        int lastDotIndex = value.lastIndexOf(46);
        String qualifier = "";
        String simpleName = "";
        if (lastDotIndex >= 0) {
            qualifier = value.substring(0, lastDotIndex);
            simpleName = value.substring(lastDotIndex + 1);
            return ast.newQualifiedName(ast.newName(qualifier), ast.newSimpleName(simpleName));
        }
        return ast.newSimpleName(value);
    }

    public static SingleMemberAnnotation newSingleAnnotation(AST ast, String name) {
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    public static StringLiteral newStringLiteral(AST ast, String value) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(value);
        return stringLiteral;
    }

    public static TypeLiteral newTypeLiteral(AST ast, String value) {
        Name newName = ast.newName(value);
        SimpleType type = ast.newSimpleType(newName);
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        typeLiteral.setType((Type)type);
        return typeLiteral;
    }

    public static TypeLiteral newTypeLiteral(AST ast, Type value) {
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        typeLiteral.setType(value);
        return typeLiteral;
    }

    public static void saveEntityModel(PersistentType entity) {
        OrmResource ormXMLResource;
        if (entity instanceof OrmPersistentType && (ormXMLResource = AnnotationUtil.getOrmXMLResource((OrmPersistentType)entity)) != null) {
            try {
                ormXMLResource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            IResource resource = JpaUtil.getJavaResourceFromPersistentType(entity);
            ICompilationUnit compUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
            if (compUnit.isWorkingCopy()) {
                if (JpaPlugin.handleValidateEdit(compUnit, null)) {
                    compUnit.commitWorkingCopy(true, null);
                }
            } else if (JpaPlugin.handleValidateEdit(compUnit, null)) {
                compUnit.save(null, true);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static enum ANNOTATION_TYPE {
        STRING,
        NAME,
        TYPE;

    }

    public static interface Editor {
        public boolean edit(ModifiedDeclaration var1, boolean var2);
    }
}

