/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.webtools.jpa.models.IJpaManagerBeanListener;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JpaManagerBeanController
implements IResourceChangeListener,
IElementChangedListener {
    private static JpaManagerBeanController instance;
    private Map<String, List<JpaUtil.ManagerBeanInfoContainer>> jpaManagers = new HashMap<String, List<JpaUtil.ManagerBeanInfoContainer>>();
    private boolean resourceChangeListenerAdded = false;
    private IJpaManagerBeanListener jpaManagerBeanListener = null;

    public static JpaManagerBeanController getInstance() {
        if (instance == null) {
            instance = new JpaManagerBeanController();
        }
        return instance;
    }

    private static List<JpaUtil.ManagerBeanInfoContainer> getManagerBeansByAnnotationList(IProject project) {
        IFolder sourceFolder = JpaUtil.getSourceFolder(project);
        final ArrayList<JpaUtil.ManagerBeanInfoContainer> list = new ArrayList<JpaUtil.ManagerBeanInfoContainer>();
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy resource) throws CoreException {
                switch (resource.getType()) {
                    case 2: 
                    case 4: {
                        return true;
                    }
                    case 1: {
                        ICompilationUnit cu;
                        IType type;
                        IFile file = (IFile)resource.requestResource();
                        if (file.getFileExtension().equals("java") && (type = (cu = JavaCore.createCompilationUnitFrom((IFile)file)).findPrimaryType()) != null && JpaUtil.isJPAManagerBean(type)) {
                            list.add(new JpaUtil.ManagerBeanInfoContainer(type));
                        }
                        return false;
                    }
                }
                return false;
            }
        };
        try {
            sourceFolder.accept(visitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void addJpaManagerBeanListener(IJpaManagerBeanListener listener) {
        if (this.jpaManagerBeanListener != listener) {
            this.jpaManagerBeanListener = listener;
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta jDelta = event.getDelta();
        if (jDelta == null) {
            return;
        }
        this.synchWithJavaDelta(jDelta);
    }

    public List<JpaUtil.ManagerBeanInfoContainer> getAllManagerBeans(IProject project) {
        List<JpaUtil.ManagerBeanInfoContainer> list;
        if (!this.resourceChangeListenerAdded) {
            project.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
            JavaCore.addElementChangedListener((IElementChangedListener)this);
            this.resourceChangeListenerAdded = true;
        }
        if ((list = this.jpaManagers.get(project.getName())) == null) {
            list = this.scanProjectForManagerBeans(project);
            this.jpaManagers.put(project.getName(), list);
        }
        return list;
    }

    private void handleAddCompilationUnit(ICompilationUnit cu) {
        IResource resource;
        IType type;
        if (cu != null && cu.exists() && (type = cu.findPrimaryType()) != null && JpaUtil.isJPAManagerBean(type) && (resource = cu.getResource()) != null) {
            IProject project = resource.getProject();
            List<JpaUtil.ManagerBeanInfoContainer> list = this.jpaManagers.get(project.getName());
            if (list == null) {
                this.getAllManagerBeans(project);
            } else {
                JpaUtil.ManagerBeanInfoContainer managerBeanContainer = new JpaUtil.ManagerBeanInfoContainer(type);
                boolean exists = false;
                for (JpaUtil.ManagerBeanInfoContainer managerBeanInfoContainer : list) {
                    if (!managerBeanInfoContainer.getMangerBeanType().getFullyQualifiedName().equals(type.getFullyQualifiedName())) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(managerBeanContainer);
                    this.sendAddNofication(managerBeanContainer);
                }
            }
        }
    }

    private void handleRemoveCompilationUnit(ICompilationUnit cu) {
        IProject project;
        List<JpaUtil.ManagerBeanInfoContainer> list;
        IResource resource;
        if (cu != null && (resource = cu.getResource()) != null && (list = this.jpaManagers.get((project = resource.getProject()).getName())) != null) {
            String removedType = String.valueOf(cu.getParent().getElementName()) + "." + cu.getElementName();
            if (removedType.endsWith(".java")) {
                removedType = removedType.substring(0, removedType.length() - ".java".length());
            }
            for (JpaUtil.ManagerBeanInfoContainer managerBeanInfoContainer : list) {
                if (!managerBeanInfoContainer.getMangerBeanType().getFullyQualifiedName().equals(removedType)) continue;
                list.remove(managerBeanInfoContainer);
                this.sendRemoveNofication(managerBeanInfoContainer);
                break;
            }
        }
    }

    private void handleRemovePackage(IPackageFragment frag) {
        IProject project;
        List<JpaUtil.ManagerBeanInfoContainer> list;
        IResource resource = frag.getResource();
        if (resource != null && (list = this.jpaManagers.get((project = resource.getProject()).getName())) != null) {
            String packageName = frag.getElementName();
            int size = list.size();
            int i = size - 1;
            while (i >= 0) {
                JpaUtil.ManagerBeanInfoContainer managerBeanInfoContainer = list.get(i);
                if (managerBeanInfoContainer.getMangerBeanType().getFullyQualifiedName().startsWith(packageName)) {
                    list.remove(managerBeanInfoContainer);
                    this.sendRemoveNofication(managerBeanInfoContainer);
                }
                --i;
            }
        }
    }

    public void removeJpaManagerBeanListener() {
        this.jpaManagerBeanListener = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        List<JpaUtil.ManagerBeanInfoContainer> list;
        IProject project = event.getResource().getProject();
        if (project != null && (list = this.jpaManagers.get(project.getName())) != null) {
            list.clear();
            this.jpaManagers.remove(project.getName());
        }
    }

    public List<JpaUtil.ManagerBeanInfoContainer> scanProjectForManagerBeans(IProject project) {
        return JpaManagerBeanController.getManagerBeansByAnnotationList(project);
    }

    private void sendAddNofication(JpaUtil.ManagerBeanInfoContainer managerBeanContainer) {
        IType mangerBeanType = managerBeanContainer.getMangerBeanType();
        if (mangerBeanType != null && this.jpaManagerBeanListener != null) {
            this.jpaManagerBeanListener.jpaManagerBeanAdded(managerBeanContainer);
        }
    }

    private void sendRemoveNofication(JpaUtil.ManagerBeanInfoContainer managerBeanContainer) {
        IType mangerBeanType = managerBeanContainer.getMangerBeanType();
        if (mangerBeanType != null && this.jpaManagerBeanListener != null) {
            this.jpaManagerBeanListener.jpaManagerBeanRemoved(managerBeanContainer);
        }
    }

    private void synchChildrenWithJavaDelta(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.synchWithJavaDelta(child);
            ++n2;
        }
    }

    private void synchCompilationUnitWithJavaDelta(IJavaElementDelta delta) {
        if (delta.getKind() == 1) {
            ICompilationUnit cu = (ICompilationUnit)delta.getElement();
            this.handleAddCompilationUnit(cu);
        } else if (delta.getKind() == 2) {
            ICompilationUnit cu = (ICompilationUnit)delta.getElement();
            this.handleRemoveCompilationUnit(cu);
        }
    }

    private void synchPackagetWithJavaDelta(IJavaElementDelta delta) {
        IPackageFragment frag = (IPackageFragment)delta.getElement();
        if (delta.getKind() == 1) {
            try {
                ICompilationUnit[] compilationUnits = frag.getCompilationUnits();
                if (compilationUnits != null && compilationUnits.length > 0) {
                    ICompilationUnit[] iCompilationUnitArray = compilationUnits;
                    int n = compilationUnits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit compilationUnit = iCompilationUnitArray[n2];
                        if (delta.getKind() == 1) {
                            this.handleAddCompilationUnit(compilationUnit);
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else if (delta.getKind() == 2) {
            this.handleRemovePackage(frag);
        }
    }

    private void synchWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: {
                this.synchChildrenWithJavaDelta(delta);
                break;
            }
            case 4: {
                if (delta.getAffectedChildren().length == 0) {
                    this.synchPackagetWithJavaDelta(delta);
                    break;
                }
                this.synchChildrenWithJavaDelta(delta);
                break;
            }
            case 5: {
                this.synchCompilationUnitWithJavaDelta(delta);
                break;
            }
        }
    }
}

