/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipInfo;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.GenericRootContextNode;

public class JpaEntityInfo
implements Comparable {
    private PersistentType type;
    private List<JpaAttributeInfo> attributes;
    private List<JpaRelationshipInfo> relationships;
    private String fullyQualifiedEntityName;
    private IProject project;

    public JpaEntityInfo(PersistentType type) {
        this(type, true);
    }

    public JpaEntityInfo(PersistentType type, boolean shouldInitialize) {
        IProject project = null;
        IResource resource = JpaUtil.getJavaResourceFromPersistentType(type);
        if (resource != null) {
            project = resource.getProject();
        }
        this.type = type;
        this.project = project;
        if (type != null && shouldInitialize) {
            this.initialize();
        }
    }

    public JpaEntityInfo(PersistentType type, String fullyQualifiedEntityPath, IProject project) {
        this(type, fullyQualifiedEntityPath, project, true);
    }

    public JpaEntityInfo(PersistentType type, String fullyQualifiedEntityName, IProject project, boolean shouldInitialize) {
        this.type = type;
        this.fullyQualifiedEntityName = fullyQualifiedEntityName;
        this.project = project;
        if (type != null && shouldInitialize) {
            this.initialize();
        }
    }

    public static List<JpaAttributeInfo> getEmbeddedAttributes(JpaProject jpaProject, AttributeMapping mapping, JpaAttributeInfo jpaAttributeInfo, boolean removeNonEmbeddedAttributes) {
        PersistenceUnit persistenceUnit;
        ListIterator persistenceUnits;
        GenericRootContextNode rootContext;
        PersistenceXml persistenceXml;
        ArrayList<JpaAttributeInfo> cols = new ArrayList<JpaAttributeInfo>();
        if (jpaProject != null && (persistenceXml = (rootContext = (GenericRootContextNode)jpaProject.getRootContext()).getPersistenceXml()) != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (persistenceUnit = (PersistenceUnit)persistenceUnits.next()) != null) {
            PersistentAttribute persistentAttribute = mapping.getPersistentAttribute();
            String embeddedIdClassType = "";
            if (persistentAttribute instanceof JavaPersistentAttribute) {
                embeddedIdClassType = ((JavaPersistentAttribute)persistentAttribute).getResourcePersistentAttribute().getQualifiedTypeName();
            } else if (persistentAttribute instanceof OrmPersistentAttribute) {
                embeddedIdClassType = ((OrmPersistentAttribute)persistentAttribute).getMapping().getJavaPersistentAttribute().getResourcePersistentAttribute().getQualifiedTypeName();
            }
            ListIterator classRefs = persistenceUnit.classRefs();
            block4: while (classRefs.hasNext()) {
                JavaPersistentType javaPersistentType;
                String name;
                ClassRef classRef = (ClassRef)classRefs.next();
                if (classRef.getJavaPersistentType() == null || !"embeddable".equals(classRef.getJavaPersistentType().getMappingKey()) && removeNonEmbeddedAttributes || !(name = (javaPersistentType = classRef.getJavaPersistentType()).getName()).equals(embeddedIdClassType)) continue;
                Iterator iter2 = javaPersistentType.allAttributes();
                while (iter2.hasNext()) {
                    try {
                        PersistentAttribute jpAtt = (PersistentAttribute)iter2.next();
                        AttributeMapping mapping2 = jpAtt.getMapping();
                        if (mapping2.getKey() != MappingKeys.NULL_TYPE_MAPPING_KEY && mapping2.getKey().equals("embedded")) {
                            JpaEntityInfo.getEmbeddedAttributes(jpaProject, mapping, jpaAttributeInfo, removeNonEmbeddedAttributes);
                            continue;
                        }
                        cols.add(new JpaAttributeInfo(jpAtt, jpaAttributeInfo));
                    }
                    catch (NoSuchElementException e) {
                        e.printStackTrace();
                        continue block4;
                    }
                }
            }
            ListIterator mappingFiles = persistenceUnit.mappingFileRefs();
            while (mappingFiles.hasNext()) {
                EntityMappings entityMappings;
                MappingFileRef mappingFileRef = (MappingFileRef)mappingFiles.next();
                OrmXml ormXml = mappingFileRef.getOrmXml();
                if (ormXml == null || (entityMappings = ormXml.getEntityMappings()) == null) continue;
                ListIterator persistentTypes = entityMappings.ormPersistentTypes();
                block7: while (persistentTypes.hasNext()) {
                    String name;
                    OrmPersistentType ormPersistentType = (OrmPersistentType)persistentTypes.next();
                    if (ormPersistentType.getMappingKey() != "entity" || !(name = ormPersistentType.getName()).equals(embeddedIdClassType)) continue;
                    Iterator iter2 = ormPersistentType.allAttributes();
                    while (iter2.hasNext()) {
                        try {
                            PersistentAttribute jpAtt = (PersistentAttribute)iter2.next();
                            AttributeMapping mapping2 = jpAtt.getMapping();
                            if (mapping2.getKey() != MappingKeys.NULL_TYPE_MAPPING_KEY && mapping2.getKey().equals("embedded")) {
                                JpaEntityInfo.getEmbeddedAttributes(jpaProject, mapping, jpaAttributeInfo, removeNonEmbeddedAttributes);
                                continue;
                            }
                            cols.add(new JpaAttributeInfo(jpAtt, jpaAttributeInfo));
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            continue block7;
                        }
                    }
                }
            }
        }
        return cols;
    }

    public int compareTo(Object o) {
        return this.getEntityName().compareTo(((JpaEntityInfo)o).getEntityName());
    }

    public List<JpaAttributeInfo> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<JpaAttributeInfo>();
        }
        return this.attributes;
    }

    public String getEntityName() {
        if (this.getPersistentType() != null) {
            String name = this.getPersistentType().getName();
            if (name != null) {
                return Signature.getSimpleName((String)name);
            }
        } else {
            String path = this.getFullyQualifiedEntityName();
            if (path != null) {
                return Signature.getSimpleName((String)path);
            }
        }
        return null;
    }

    public String getFullyQualifiedEntityName() {
        if (this.fullyQualifiedEntityName == null && this.getPersistentType() != null) {
            return this.getPersistentType().getName();
        }
        return this.fullyQualifiedEntityName;
    }

    public String getName() {
        if (this.type != null) {
            String name = this.type.getName();
            if (name != null) {
                return Signature.getSimpleName((String)name);
            }
        } else if (this.fullyQualifiedEntityName != null) {
            return Signature.getSimpleName((String)this.fullyQualifiedEntityName);
        }
        return null;
    }

    public JpaAttributeInfo getOCCAttribute() {
        if (this.attributes != null) {
            for (JpaAttributeInfo attribute : this.attributes) {
                if (!attribute.isOCC()) continue;
                return attribute;
            }
        }
        return null;
    }

    public PersistentType getPersistentType() {
        return this.type;
    }

    public List<JpaAttributeInfo> getPrimaryKeyAttributes() {
        ArrayList<JpaAttributeInfo> keysList = new ArrayList<JpaAttributeInfo>();
        if (this.attributes != null) {
            for (JpaAttributeInfo element : this.attributes) {
                if (!element.isPrimaryKey()) continue;
                keysList.add(element);
            }
        }
        return keysList;
    }

    public IProject getProject() {
        if (this.project != null) {
            return this.project;
        }
        if (this.type != null) {
            return this.type.getJpaProject().getProject();
        }
        return null;
    }

    public List<JpaRelationshipInfo> getRelationships() {
        return this.relationships;
    }

    public String getSpecifiedName() {
        String name = "";
        if (this.type != null) {
            TypeMapping mapping = this.type.getMapping();
            if (mapping instanceof Entity && ((name = ((Entity)mapping).getSpecifiedName()) == null || name.length() == 0)) {
                name = ((Entity)mapping).getDefaultName();
            }
            if (name == null) {
                name = this.getName();
            }
        }
        return name;
    }

    private void initialize() {
        if (this.type != null) {
            this.attributes = new ArrayList<JpaAttributeInfo>();
            this.relationships = new ArrayList<JpaRelationshipInfo>();
            JpaProject jpaProject = this.type.getJpaProject();
            Iterator iter = this.type.allAttributes();
            while (iter.hasNext()) {
                List<JpaAttributeInfo> embeddedAttributes;
                PersistentAttribute jpAtt = (PersistentAttribute)iter.next();
                AttributeMapping mapping = jpAtt.getMapping();
                String mappingKey = mapping.getKey();
                if (mappingKey != MappingKeys.NULL_TYPE_MAPPING_KEY && mappingKey.equals("embedded")) {
                    embeddedAttributes = JpaEntityInfo.getEmbeddedAttributes(jpaProject, mapping, new JpaAttributeInfo(jpAtt), true);
                    this.attributes.addAll(embeddedAttributes);
                    continue;
                }
                if (mappingKey != MappingKeys.NULL_TYPE_MAPPING_KEY && mappingKey.equals("embeddedId")) {
                    embeddedAttributes = JpaEntityInfo.getEmbeddedAttributes(jpaProject, mapping, new JpaAttributeInfo(jpAtt), true);
                    this.attributes.addAll(embeddedAttributes);
                    continue;
                }
                if (mappingKey != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY && (mappingKey.equals("oneToOne") || mappingKey.equals("oneToMany") || mappingKey.equals("manyToOne") || mappingKey.equals("manyToMany"))) {
                    this.relationships.add(new JpaRelationshipInfo((RelationshipMapping)mapping, null, JpaRelationshipInfo.STATUS.EXISTING));
                    this.attributes.add(new JpaAttributeInfo(jpAtt));
                    continue;
                }
                this.attributes.add(new JpaAttributeInfo(jpAtt));
            }
        }
    }

    public void initializeIfNeeded() {
        if (this.attributes == null || this.relationships == null) {
            this.initialize();
        }
    }

    public void setAttributes(List<JpaAttributeInfo> attributes) {
        this.attributes = attributes;
    }

    public void setFullyQualifiedEntityName(String fullyQualifiedEntityName) {
        this.fullyQualifiedEntityName = fullyQualifiedEntityName;
    }

    public void setOCCAttribute(JpaAttributeInfo occAtt) {
        for (JpaAttributeInfo attribute : this.attributes) {
            if (attribute.equals(occAtt)) {
                attribute.setMappingKey("version");
                continue;
            }
            if (!attribute.isOCC()) continue;
            attribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        }
    }

    public void setPersistentType(PersistentType type) {
        this.type = type;
        this.initialize();
    }

    public void setPrimaryKeys(List<JpaAttributeInfo> keys) {
        boolean found = false;
        if (this.attributes != null) {
            for (JpaAttributeInfo attribute : this.attributes) {
                for (JpaAttributeInfo keyAttribute : keys) {
                    if (!attribute.equals(keyAttribute)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    if (!attribute.isPartOfCompositePrimaryKey()) {
                        attribute.setMappingKey("id");
                    }
                } else if (attribute.isPrimaryKey() && !attribute.isPartOfCompositePrimaryKey()) {
                    attribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
                }
                found = false;
            }
        }
    }

    public void setRelationships(List<JpaRelationshipInfo> relationships) {
        this.relationships = relationships;
    }
}

