/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.filters;

import com.ibm.etools.webtools.jpa.filters.ConditionData;
import com.ibm.etools.webtools.jpa.filters.IConditionData;
import com.ibm.etools.webtools.jpa.filters.RelationalSingleColumnConditionData;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RelationalMultiConditionData
extends ConditionData {
    private RelationalMultiConditionData fMultiCondData;
    private JpaFilterInfo jpaFilterInfo;
    List predicatesList = new ArrayList();
    private int operand = 0;

    public RelationalMultiConditionData(JpaFilterInfo jpaFilterInfo) {
        this.jpaFilterInfo = jpaFilterInfo;
    }

    public static JpaAttributeInfo getAttribute(JpaEntityInfo entity, String attributeName) {
        List<JpaAttributeInfo> attributes = entity.getAttributes();
        for (JpaAttributeInfo attribute : attributes) {
            if (!attribute.getAttributeName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public boolean addPredicate(JpaEntityInfo entity, IConditionData conditionData, boolean updateFilter) {
        boolean isAdd = false;
        isAdd = this.predicatesList.add(conditionData);
        if (isAdd) {
            if (conditionData instanceof RelationalMultiConditionData) {
                ((RelationalMultiConditionData)conditionData).setMultiCondData(this);
            } else {
                ((RelationalSingleColumnConditionData)conditionData).setMultiCondData(this);
            }
            if (updateFilter) {
                this.getJpaFilterInfo().updateJPAFilterData(entity);
            }
        }
        return isAdd;
    }

    public JpaFilterInfo getJpaFilterInfo() {
        return this.jpaFilterInfo;
    }

    public RelationalMultiConditionData getMultiCondData() {
        return this.fMultiCondData;
    }

    public int getOperand() {
        return this.operand;
    }

    public IConditionData[] getPredicates() {
        ArrayList<IConditionData> childrenList = new ArrayList<IConditionData>();
        for (IConditionData element : this.predicatesList) {
            if (element instanceof RelationalSingleColumnConditionData) {
                childrenList.add(element);
                continue;
            }
            if (!(element instanceof RelationalMultiConditionData)) continue;
            IConditionData[] children = ((RelationalMultiConditionData)element).getPredicates();
            childrenList.addAll(Arrays.asList(children));
        }
        return childrenList.toArray(new IConditionData[childrenList.size()]);
    }

    public boolean moveConditionsList(JpaEntityInfo entity, boolean moveUp, IConditionData conditionData) {
        boolean isMove = false;
        if (conditionData instanceof RelationalSingleColumnConditionData) {
            int index;
            RelationalSingleColumnConditionData singleColData = (RelationalSingleColumnConditionData)conditionData;
            RelationalMultiConditionData searchConditionData = singleColData.getMultiConditionData();
            if (searchConditionData != null && (index = searchConditionData.predicatesList.indexOf(singleColData)) != -1) {
                if (moveUp) {
                    if (index != 0) {
                        Object aboveElement = searchConditionData.predicatesList.get(index - 1);
                        searchConditionData.predicatesList.set(index, aboveElement);
                        searchConditionData.predicatesList.set(index - 1, singleColData);
                        isMove = true;
                    }
                } else if (index != searchConditionData.predicatesList.size() - 1) {
                    Object aboveElement = searchConditionData.predicatesList.get(index + 1);
                    searchConditionData.predicatesList.set(index, aboveElement);
                    searchConditionData.predicatesList.set(index + 1, singleColData);
                    isMove = true;
                }
            }
            if (isMove) {
                this.updateSelf(entity);
                this.getJpaFilterInfo().updateJPAFilterData(entity);
            }
        }
        return isMove;
    }

    public boolean removePredicate(JpaEntityInfo entity, IConditionData conditionData, boolean updateMetadata) {
        boolean isRemove = false;
        if (conditionData instanceof RelationalSingleColumnConditionData) {
            RelationalSingleColumnConditionData singleColData = (RelationalSingleColumnConditionData)conditionData;
            RelationalMultiConditionData searchConditionData = singleColData.getMultiConditionData();
            if (searchConditionData != null && searchConditionData != this) {
                isRemove = searchConditionData.removePredicate(entity, conditionData, updateMetadata);
            } else if (this.predicatesList.contains(conditionData)) {
                isRemove = this.predicatesList.remove(conditionData);
            }
        }
        if (isRemove) {
            this.updateSelf(entity);
            this.getJpaFilterInfo().updateJPAFilterData(entity);
        }
        return isRemove;
    }

    public void setJpaFilterInfo(JpaFilterInfo jpaFilterInfo) {
        this.jpaFilterInfo = jpaFilterInfo;
    }

    public void setMultiCondData(RelationalMultiConditionData data) {
        this.fMultiCondData = data;
    }

    public void setOperand(int code) {
        if (this.operand != code) {
            this.operand = code;
        }
    }

    public void updateMetadata(JpaEntityInfo entity, StringBuffer filter) {
        int i = 0;
        if (this.predicatesList.size() > 0) {
            String operand;
            filter.append("(");
            for (Object element : this.predicatesList) {
                ConditionData conditionData;
                if (element instanceof RelationalSingleColumnConditionData) {
                    conditionData = (RelationalSingleColumnConditionData)element;
                    JpaFilterParameterInfo[] arg = i == this.predicatesList.size() - 1 ? ((RelationalSingleColumnConditionData)conditionData).constructSingleQueryAndOperand(entity, filter, false) : ((RelationalSingleColumnConditionData)conditionData).constructSingleQueryAndOperand(entity, filter, true);
                    if (arg != null) {
                        int j = 0;
                        while (j < arg.length) {
                            JpaFilterParameterInfo argument = arg[j];
                            this.getJpaFilterInfo().addParameter(argument);
                            ++j;
                        }
                    }
                } else if (element instanceof RelationalMultiConditionData) {
                    conditionData = (RelationalMultiConditionData)element;
                    ((RelationalMultiConditionData)conditionData).updateMetadata(entity, filter);
                }
                ++i;
            }
            filter.append(")");
            String string = operand = this.getOperand() == 0 ? "AND" : "OR";
            if (this.getMultiCondData() != null && this.getMultiCondData().predicatesList.indexOf(this) < this.getMultiCondData().predicatesList.size() - 1) {
                filter.append(" " + operand);
            }
        }
    }

    public void updateSelf(JpaEntityInfo entity) {
        Iterator iter = this.predicatesList.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof RelationalMultiConditionData) {
                RelationalMultiConditionData searchCondition = (RelationalMultiConditionData)element;
                searchCondition.updateSelf(entity);
                if (searchCondition.getPredicates().length != 0) continue;
                iter.remove();
                continue;
            }
            RelationalSingleColumnConditionData conditionData = (RelationalSingleColumnConditionData)element;
            if (RelationalMultiConditionData.getAttribute(entity, conditionData.getColumnName()) != null) continue;
            iter.remove();
        }
    }
}

