/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.connection;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsUIUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.connection.JDBCConnectionModel;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import java.io.IOException;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.core.context.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.GenericRootContextNode;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.orm.OrmResourceModel;
import org.eclipse.jpt.core.resource.persistence.PersistenceResourceModel;
import org.eclipse.swt.widgets.Shell;

public class JDBCConnectionJob
extends Job {
    public static final String OPENJPA_CONNECTION_DRIVER_NAME = "openjpa.ConnectionDriverName";
    public static final String OPENJPA_CONNECTION_URL = "openjpa.ConnectionURL";
    public static final String OPENJPA_CONNECTION_USER_NAME = "openjpa.ConnectionUserName";
    public static final String OPENJPA_CONNECTION_PASSWORD = "openjpa.ConnectionPassword";
    public static final String OPENJPA_CONNECTION_SCHEMA = "openjpa.jdbc.Schema";
    private final JDBCConnectionModel model;
    private final JpaProject jpaProject;
    private Shell shell;

    public JDBCConnectionJob(JDBCConnectionModel model, JpaProject project, Shell optionalShell) {
        super(JpaUI.OtherOptionsControlProvider_2);
        this.model = model;
        this.jpaProject = project;
        this.shell = optionalShell;
    }

    public static Property getProperty(EList<Property> propertiesList, String propertyName) {
        for (Property property : propertiesList) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    private boolean clearConnectionProperties(PersistenceUnit unit) {
        boolean removed = false;
        if (unit != null) {
            unit.removeProperty(OPENJPA_CONNECTION_DRIVER_NAME);
            unit.removeProperty(OPENJPA_CONNECTION_URL);
            unit.removeProperty(OPENJPA_CONNECTION_USER_NAME);
            unit.removeProperty(OPENJPA_CONNECTION_PASSWORD);
        }
        return removed;
    }

    private void clearDataSourceProperties(PersistenceUnit unit) {
        unit.setJtaDataSource(null);
        unit.setNonJtaDataSource(null);
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.model != null) {
            String connectionProfileName = this.model.getConnectionProfileName();
            IConnectionData connectionData = ConnectionsUIUtil.createConnectionDataForProfile((String)connectionProfileName, (IProject)this.jpaProject.getProject(), (!this.model.isUseDirectConnectionProperties() ? 1 : 0) != 0);
            boolean revalidateDaliConnection = false;
            String profileName = this.jpaProject.getDataSource().getConnectionProfileName();
            if (profileName == null || profileName.length() == 0 && connectionProfileName != null && connectionProfileName.length() > 0) {
                try {
                    this.jpaProject.getDataSource().setConnectionProfileName(connectionProfileName);
                    JptCorePlugin.setConnectionProfileName((IProject)this.jpaProject.getProject(), (String)connectionProfileName);
                    revalidateDaliConnection = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.model.isUpdatePersistenceXML()) {
                this.updatePersistenceXML(connectionData);
                this.updateORMXML();
            }
            if (this.model.isDeployJDBCConnection() && connectionData != null) {
                String datasourceName;
                if (!this.model.isUseDirectConnectionProperties() && (datasourceName = this.model.getDataSourceName()) != null) {
                    try {
                        if (!ConnectionsHelper.isConnectionExist((IProject)this.jpaProject.getProject(), (String)connectionProfileName)) {
                            if (datasourceName.startsWith("java:comp/env/")) {
                                String resourceRefName = datasourceName.substring("java:comp/env/".length());
                                if (resourceRefName.length() > 0) {
                                    connectionData.setResourceRefName(resourceRefName);
                                }
                            } else if (datasourceName.startsWith("jdbc/")) {
                                connectionData.setJNDIName(datasourceName);
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ConnectionsUIUtil.deployJDBCConnection((IProject)this.jpaProject.getProject(), null, (IConnectionData)connectionData);
            }
            if (revalidateDaliConnection) {
                try {
                    this.jpaProject.getProject().build(6, monitor);
                }
                catch (Exception exception) {}
            }
        }
        return new Status(0, "com.ibm.etools.webtools.jpa", "");
    }

    private void updateORMXML() {
        PersistenceUnit persistenceUnit;
        ListIterator persistenceUnits;
        GenericRootContextNode rootContext;
        PersistenceXml persistenceXml;
        if (this.model.getSchemaName() != null && this.model.getSchemaName().length() > 0 && (persistenceXml = (rootContext = (GenericRootContextNode)this.jpaProject.getRootContext()).getPersistenceXml()) != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (persistenceUnit = (PersistenceUnit)persistenceUnits.next()) != null) {
            ListIterator mappingFiles = persistenceUnit.mappingFileRefs();
            while (mappingFiles.hasNext()) {
                PersistenceUnitMetadata persistenceUnitMetadata;
                PersistenceUnitDefaults persistenceUnitDefaults;
                String schema;
                IResource ormXMLFile;
                JpaFile jpaFile;
                MappingFileRef mappingFileRef = (MappingFileRef)mappingFiles.next();
                OrmXml ormXml = mappingFileRef.getOrmXml();
                if (ormXml == null || !JpaPlugin.handleValidateEdit((jpaFile = this.jpaProject.getJpaFile((IFile)(ormXMLFile = ormXml.getResource()))).getFile(), (Object)this.shell)) continue;
                EntityMappings entityMappings = ormXml.getEntityMappings();
                if (entityMappings == null || (schema = (persistenceUnitDefaults = (persistenceUnitMetadata = entityMappings.getPersistenceUnitMetadata()).getPersistenceUnitDefaults()).getSpecifiedSchema()) != null && schema.equals(this.model.getSchemaName())) break;
                persistenceUnitDefaults.setSpecifiedSchema(this.model.getSchemaName());
                OrmResource ormResource = ((OrmResourceModel)jpaFile.getResourceModel()).getResource();
                try {
                    ormResource.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    private void updatePersistenceXML(IConnectionData connectionData) {
        IResource persistenceXMLFile;
        JpaFile jpaFile;
        PersistenceUnit unit;
        ListIterator persistenceUnits;
        GenericRootContextNode rootContext = (GenericRootContextNode)this.jpaProject.getRootContext();
        PersistenceXml persistenceXml = rootContext.getPersistenceXml();
        if (persistenceXml != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (unit = (PersistenceUnit)persistenceUnits.next()) != null && (jpaFile = this.jpaProject.getJpaFile((IFile)(persistenceXMLFile = persistenceXml.getResource()))) != null) {
            JpaXmlResource persistenceXmlResource = ((PersistenceResourceModel)jpaFile.getResourceModel()).getResource();
            IFile file = jpaFile.getFile();
            if (JpaPlugin.handleValidateEdit(file, (Object)this.shell)) {
                if (this.model.getDataSourceType() == JDBCConnectionModel.DATA_SOURCE_TYPE.JTA) {
                    unit.setJtaDataSource(this.model.getDataSourceName());
                    this.clearConnectionProperties(unit);
                } else if (this.model.getDataSourceType() == JDBCConnectionModel.DATA_SOURCE_TYPE.NON_JTA) {
                    unit.setNonJtaDataSource(this.model.getDataSourceName());
                    this.clearConnectionProperties(unit);
                }
                if (this.model.isUseDirectConnectionProperties()) {
                    this.updatePropertiesForConnection(unit, connectionData);
                    this.clearDataSourceProperties(unit);
                }
                if (this.model.getSchemaName() != null && this.model.getSchemaName().length() > 0) {
                    this.updateSchemaName(unit, this.model.getSchemaName());
                }
                try {
                    persistenceXmlResource.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void updatePropertiesForConnection(PersistenceUnit unit, IConnectionData connectionData) {
        if (unit != null && connectionData != null) {
            Property url;
            Property driverName = unit.getProperty(OPENJPA_CONNECTION_DRIVER_NAME);
            if (driverName == null) {
                driverName = unit.addProperty();
                driverName.setName(OPENJPA_CONNECTION_DRIVER_NAME);
            }
            if (connectionData.getDriver() != null) {
                driverName.setValue(connectionData.getDriver());
            }
            if ((url = unit.getProperty(OPENJPA_CONNECTION_URL)) == null) {
                url = unit.addProperty();
                url.setName(OPENJPA_CONNECTION_URL);
            }
            if (connectionData.getURL() != null) {
                url.setValue(connectionData.getURL());
            }
            Property userName = unit.getProperty(OPENJPA_CONNECTION_USER_NAME);
            String userNameValue = connectionData.getUserName();
            if (userName == null && userNameValue != null && userNameValue.length() > 0) {
                userName = unit.addProperty();
                userName.setName(OPENJPA_CONNECTION_USER_NAME);
                userName.setValue(connectionData.getUserName());
            } else if (userName != null && (userNameValue == null || userNameValue.length() == 0)) {
                unit.removeProperty(OPENJPA_CONNECTION_USER_NAME);
            }
            if (userNameValue != null && userNameValue.length() > 0) {
                userName.setValue(userNameValue);
            }
            Property password = unit.getProperty(OPENJPA_CONNECTION_PASSWORD);
            String passwordFromStore = RSCConnectionsHelper.getPasswordFromStore((IConnectionProfile)connectionData.getConnectionProfile(), (IConnectionData)connectionData);
            if (password == null && passwordFromStore != null && passwordFromStore.length() > 0) {
                password = unit.addProperty();
                password.setName(OPENJPA_CONNECTION_PASSWORD);
                password.setValue(passwordFromStore);
            } else if (password != null && (passwordFromStore == null || passwordFromStore.length() == 0)) {
                unit.removeProperty(OPENJPA_CONNECTION_PASSWORD);
            }
            if (passwordFromStore != null && passwordFromStore.length() > 0) {
                password.setValue(passwordFromStore);
            }
        }
    }

    private void updateSchemaName(PersistenceUnit unit, String schemaName) {
        Property schemaProp = unit.getProperty(OPENJPA_CONNECTION_SCHEMA);
        if (schemaProp == null) {
            schemaProp = unit.addProperty();
            schemaProp.setName(OPENJPA_CONNECTION_SCHEMA);
        }
        schemaProp.setValue(schemaName);
    }
}

