/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.connection;

import com.ibm.etools.webtools.jpa.connection.DeployJDBCAction;
import com.ibm.etools.webtools.jpa.connection.JDBCConnectionJob;
import com.ibm.etools.webtools.jpa.connection.JDBCConnectionModel;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.GenericRootContextNode;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.widgets.Display;

public class AutoDeployJDBCUIJob
extends Job {
    public static final Object AUTODEPLOY_JOB = new Object();
    private final JpaProject jpaProject;

    public AutoDeployJDBCUIJob(JpaProject jpaProject) {
        super(JpaUI.OtherOptionsControlProvider_2);
        this.jpaProject = jpaProject;
    }

    public static boolean isResourceRefDefinedForConnection(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public boolean belongsTo(Object family) {
        return family == AUTODEPLOY_JOB;
    }

    private boolean containsDefaultSchema(String connectionProfileName) {
        Schema defaultSchema;
        ConnectionProfile profileNamed = JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(connectionProfileName);
        return profileNamed != null && (defaultSchema = this.getDefaultSchema(profileNamed)) != null;
    }

    private JDBCConnectionModel getConfiguredJDBCModel() {
        IConnectionProfile[] profilesByCategory;
        JDBCConnectionModel model = null;
        String connectionProfileName = null;
        ConnectionProfile jptProfile = this.getProjectConnectionProfile();
        if (jptProfile != null && !jptProfile.isNull()) {
            connectionProfileName = jptProfile.getName();
        }
        if ((connectionProfileName == null || connectionProfileName.length() == 0) && (profilesByCategory = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category")).length == 1) {
            connectionProfileName = profilesByCategory[0].getName();
        }
        if (connectionProfileName != null) {
            boolean containsUserSchema = false;
            String userDefinedSchema = this.jpaProject.getUserOverrideDefaultSchemaName();
            if (userDefinedSchema != null && userDefinedSchema.length() > 0) {
                containsUserSchema = true;
            }
            boolean containsDefaultSchema = this.containsDefaultSchema(connectionProfileName);
            Schema defaultSchema = this.getDefaultSchema(connectionProfileName);
            String defaultSchemaName = null;
            if (defaultSchema != null) {
                defaultSchemaName = defaultSchema.getName();
            }
            if (containsDefaultSchema || containsUserSchema) {
                model = new JDBCConnectionModel();
                model.setConnectionProfileName(connectionProfileName);
                model.setUpdatePersistenceXML(true);
                model.setDataSourceType(JDBCConnectionModel.DATA_SOURCE_TYPE.JTA);
                model.setUseDirectConnectionProperties(false);
                if (userDefinedSchema != null && !userDefinedSchema.equals(defaultSchemaName)) {
                    model.setSchemaName(userDefinedSchema);
                }
                String dataSourceName = null;
                dataSourceName = AutoDeployJDBCUIJob.isResourceRefDefinedForConnection(this.jpaProject.getProject()) ? "java:comp/env/" + connectionProfileName : "jdbc/" + connectionProfileName;
                model.setDataSourceName(dataSourceName);
                model.setDeployJDBCConnection(true);
            }
        }
        return model;
    }

    private Schema getDefaultSchema(ConnectionProfile profile) {
        Schema defaultSchema = profile.getDefaultSchema();
        return defaultSchema;
    }

    private Schema getDefaultSchema(String connectionProfileName) {
        ConnectionProfile profileNamed = JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(connectionProfileName);
        if (profileNamed != null) {
            return this.getDefaultSchema(profileNamed);
        }
        return null;
    }

    private ConnectionProfile getProjectConnectionProfile() {
        String profileName = this.jpaProject.getDataSource().getConnectionProfileName();
        return JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(profileName);
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            boolean shouldUpdate = this.shouldUpdate();
            if (shouldUpdate) {
                JDBCConnectionModel configuredJDBCModel = this.getConfiguredJDBCModel();
                if (configuredJDBCModel != null) {
                    JDBCConnectionJob op = new JDBCConnectionJob(configuredJDBCModel, this.jpaProject, null);
                    op.run((IProgressMonitor)new NullProgressMonitor());
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DeployJDBCAction db = new DeployJDBCAction(AutoDeployJDBCUIJob.this.jpaProject.getProject());
                            db.run(null);
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new Status(0, "com.ibm.etools.webtools.jpa", "");
    }

    private boolean shouldUpdate() {
        Property url;
        PersistenceUnit unit;
        ListIterator persistenceUnits;
        GenericRootContextNode rootContext;
        PersistenceXml persistenceXml;
        return this.jpaProject != null && (persistenceXml = (rootContext = (GenericRootContextNode)this.jpaProject.getRootContext()).getPersistenceXml()) != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (unit = (PersistenceUnit)persistenceUnits.next()) != null && unit.getJtaDataSource() == null && unit.getNonJtaDataSource() == null && (url = unit.getProperty("openjpa.ConnectionURL")) == null;
    }
}

