/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.commands;

import com.ibm.etools.webtools.jpa.codegen.CodeGenConstants;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaOrderedAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.ManagerBeanUtil;
import com.ibm.etools.webtools.jpa.wizard.JpaDataWizard;
import com.ibm.etools.webtools.jpa.wizard.model.JpaPageDataModelProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JpaPageCommand
extends Command {
    protected IProject project;
    IDataModel model;
    private boolean isConfigure;
    List<JpaFilterParameterInfo> filterParameters;
    String namedQuery;
    private String generationType;
    private String elPrefix;
    Set<CodeGenConstants.CODE_GENERATION_TYPE> codeGenTypes;
    protected String dataName;
    private final IDOMModel selectedJspModel;
    private final Shell shell;
    private String entityName;
    private IType managerBeanType;
    private boolean generateUi;
    private boolean isMethodPreselected;
    private JpaManagerBeanInfo managerBeanInfo;
    private JpaQueryMethodInfo namedQueryForMethod;

    public JpaPageCommand(IProject project, IDOMModel selectedJspModel, Shell shell, boolean isMethodPreselected, JpaManagerBeanInfo managerBeanInfo, JpaQueryMethodInfo namedQueryForMethod, Set<CodeGenConstants.CODE_GENERATION_TYPE> codeGenTypes2, String generationType, boolean generateUi, String prefix) {
        this.project = project;
        this.shell = shell;
        this.selectedJspModel = selectedJspModel;
        this.isMethodPreselected = isMethodPreselected;
        this.managerBeanInfo = managerBeanInfo;
        this.namedQueryForMethod = namedQueryForMethod;
        this.codeGenTypes = codeGenTypes2;
        this.generationType = generationType;
        this.generateUi = generateUi;
        this.elPrefix = prefix;
    }

    public JpaPageCommand(IProject project, IDOMModel selectedJspModel, Shell shell, List<JpaOrderedAttributeInfo> orderBys, List<JpaFilterParameterInfo> filterParameters, String namedQuery, String generationType, String elPrefix, IType managerBeanType, String entityName, Set<CodeGenConstants.CODE_GENERATION_TYPE> codeGenTypes, String dataName) {
        this.project = project;
        this.shell = shell;
        this.selectedJspModel = selectedJspModel;
        this.filterParameters = filterParameters;
        this.namedQuery = namedQuery;
        this.managerBeanType = managerBeanType;
        this.entityName = entityName;
        this.codeGenTypes = codeGenTypes;
        this.dataName = dataName;
        this.isConfigure = true;
        this.generationType = generationType;
        this.elPrefix = elPrefix;
    }

    public JpaPageCommand(IProject project, IDOMModel selectedJspModel, Shell shell, String generationType, boolean generateUi, String elPrefix) {
        this.project = project;
        this.selectedJspModel = selectedJspModel;
        this.shell = shell;
        this.generateUi = generateUi;
        this.isConfigure = false;
        this.generationType = generationType;
        this.elPrefix = elPrefix;
    }

    public void execute() {
        try {
            this.primeDataModel();
            if (this.model != null) {
                JpaDataWizard wizard = new JpaDataWizard(this.model);
                WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
                dialog.open();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected IRunnableWithProgress getPrimeDataModelOperation() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            private void fillFilterValues(JpaEntityInfo entityInfo, JpaQueryMethodInfo jpaQueryMethodInfo) {
                JpaFilterInfo filter = jpaQueryMethodInfo.getFilter(entityInfo);
                List<JpaFilterParameterInfo> parameters = filter.getParameters();
                for (JpaFilterParameterInfo jpaFilterParameterInfo : parameters) {
                    for (JpaFilterParameterInfo valueParam : JpaPageCommand.this.filterParameters) {
                        if (!valueParam.getParameterName().equals(jpaFilterParameterInfo.getParameterName())) continue;
                        jpaFilterParameterInfo.setParameterValue(valueParam.getParameterValue());
                    }
                }
            }

            private void intializeForPreselectedMethod() {
                JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.userSelection", (Object)JpaPageCommand.this.managerBeanInfo);
                JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.selectedQueryMethod", (Object)JpaPageCommand.this.namedQueryForMethod);
                JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.isMethodPreselected", true);
                if (JpaPageCommand.this.codeGenTypes != null && JpaPageCommand.this.codeGenTypes.size() > 0) {
                    if (JpaPageCommand.this.codeGenTypes.contains((Object)CodeGenConstants.CODE_GENERATION_TYPE.LIST)) {
                        JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeList", true);
                    }
                    if (JpaPageCommand.this.codeGenTypes.contains((Object)CodeGenConstants.CODE_GENERATION_TYPE.DISPLAY)) {
                        JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeDisplay", true);
                    }
                    if (JpaPageCommand.this.codeGenTypes.contains((Object)CodeGenConstants.CODE_GENERATION_TYPE.CREATE)) {
                        JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeCreate", true);
                    }
                    if (JpaPageCommand.this.codeGenTypes.contains((Object)CodeGenConstants.CODE_GENERATION_TYPE.UPDATE)) {
                        JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeUpdate", true);
                    }
                }
            }

            private void intiializeForConfigure() {
                IMethod targetManagerMethod;
                JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.isConfigure", true);
                IProject managerBeanProject = JpaUtil.getManagerBeanProject(JpaPageCommand.this.managerBeanType, JpaPageCommand.this.project);
                JpaEntityInfo entityInfo = new JpaEntityInfo(null, JpaPageCommand.this.entityName, managerBeanProject);
                JpaManagerBeanInfo jpaManagerBeanInfo = new JpaManagerBeanInfo(entityInfo, JpaPageCommand.this.managerBeanType, false);
                JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.userSelection", (Object)jpaManagerBeanInfo);
                if (JpaPageCommand.this.codeGenTypes != null && JpaPageCommand.this.codeGenTypes.size() > 0) {
                    for (CodeGenConstants.CODE_GENERATION_TYPE codeGenType : JpaPageCommand.this.codeGenTypes) {
                        if (codeGenType == CodeGenConstants.CODE_GENERATION_TYPE.LIST) {
                            JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeList", true);
                            continue;
                        }
                        if (codeGenType == CodeGenConstants.CODE_GENERATION_TYPE.DISPLAY) {
                            JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeDisplay", true);
                            continue;
                        }
                        if (codeGenType == CodeGenConstants.CODE_GENERATION_TYPE.CREATE) {
                            JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeCreate", true);
                            continue;
                        }
                        if (codeGenType != CodeGenConstants.CODE_GENERATION_TYPE.UPDATE) continue;
                        JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeUpdate", true);
                    }
                }
                jpaManagerBeanInfo.initializeMethodsIfNeeded();
                List<JpaQueryMethodInfo> queryMethods = JpaUtil.getQueryMethods(jpaManagerBeanInfo);
                if (JpaPageCommand.this.namedQuery != null) {
                    for (JpaQueryMethodInfo jpaQueryMethodInfo : queryMethods) {
                        if (!JpaPageCommand.this.namedQuery.equals(jpaQueryMethodInfo.getQueryName())) continue;
                        this.fillFilterValues(entityInfo, jpaQueryMethodInfo);
                        JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.selectedQueryMethod", (Object)jpaQueryMethodInfo);
                        break;
                    }
                } else if ((JpaPageCommand.this.model.getBooleanProperty("IJpaDataModelProperties.generationTypeDisplay") || JpaPageCommand.this.model.getBooleanProperty("IJpaDataModelProperties.generationTypeUpdate")) && (targetManagerMethod = ManagerBeanUtil.getManagerMethodForAction(jpaManagerBeanInfo.getExistingManagerBeanType(), "Action.ACTION_TYPE.FIND")) != null) {
                    String findMethodName = targetManagerMethod.getElementName();
                    String defaultQuery = ManagerBeanUtil.constructDefaultPrimaryKeyQuery(targetManagerMethod, jpaManagerBeanInfo.getEntity().getEntityName());
                    JpaQueryMethodInfo findMethod = new JpaQueryMethodInfo(findMethodName, null, defaultQuery, JpaQueryMethodInfo.STATUS.EXISTING);
                    findMethod.setMethodType(JpaQueryMethodInfo.METHOD_TYPE.FIND);
                    this.fillFilterValues(entityInfo, findMethod);
                    JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.selectedQueryMethod", (Object)findMethod);
                }
                if (JpaPageCommand.this.dataName != null && JpaPageCommand.this.dataName.length() > 0) {
                    JpaPageCommand.this.model.setStringProperty("IJpaDataModelProperties.dataName", JpaPageCommand.this.dataName);
                }
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(JpaUI.JpaPageCommand_0, 5);
                        monitor.worked(1);
                        JpaPageDataModelProvider provider = new JpaPageDataModelProvider();
                        JpaPageCommand.this.model = DataModelFactory.createDataModel((IDataModelProvider)provider);
                        JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.selectedProject", (Object)JpaPageCommand.this.project);
                        JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.selectedJsp", (Object)JpaPageCommand.this.selectedJspModel);
                        JpaPageCommand.this.model.setBooleanProperty("IJpaDataModelProperties.generateUI", JpaPageCommand.this.generateUi);
                        JpaPageCommand.this.model.setStringProperty("IJpaDataModelProperties.generationType", JpaPageCommand.this.generationType);
                        JpaPageCommand.this.model.setStringProperty("IJpaDataModelProperties.elPrefix", JpaPageCommand.this.elPrefix);
                        monitor.worked(2);
                        if (JpaPageCommand.this.isMethodPreselected) {
                            this.intializeForPreselectedMethod();
                        }
                        if (JpaPageCommand.this.isConfigure) {
                            this.intiializeForConfigure();
                        }
                        if (!JpaPageCommand.this.isMethodPreselected && !JpaPageCommand.this.isConfigure && JpaPageCommand.this.managerBeanType != null && JpaPageCommand.this.entityName != null) {
                            IProject managerBeanProject = JpaUtil.getManagerBeanProject(JpaPageCommand.this.managerBeanType, JpaPageCommand.this.project);
                            IProject rootProject = JpaUtil.getTargetEntityProject(managerBeanProject, JpaPageCommand.this.entityName);
                            JpaEntityInfo entityInfo = new JpaEntityInfo(null, JpaPageCommand.this.entityName, rootProject);
                            JpaManagerBeanInfo jpaManagerBeanInfo = new JpaManagerBeanInfo(entityInfo, JpaPageCommand.this.managerBeanType, false);
                            JpaPageCommand.this.model.setProperty("IJpaDataModelProperties.userSelection", (Object)jpaManagerBeanInfo);
                        }
                        monitor.worked(1);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        return runnable;
    }

    protected void primeDataModel() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress primeDataModelOp = this.getPrimeDataModelOperation();
        if (primeDataModelOp != null) {
            ProgressMonitorDialog pmDlg = new ProgressMonitorDialog(this.shell);
            pmDlg.run(false, false, primeDataModelOp);
        }
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setManagerBeanType(IType managerBeanType) {
        this.managerBeanType = managerBeanType;
    }
}

