/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.codegen;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateFieldCommand;
import com.ibm.etools.webtools.javamodel.commands.CreateImportCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteFieldCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteImportConditionallyCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadFieldCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.UpdateMethodCommand;
import com.ibm.etools.webtools.jpa.codegen.template.DataParameter;
import com.ibm.etools.webtools.jpa.codegen.template.IdClass;
import com.ibm.etools.webtools.jpa.codegen.template.PageCodeTemplateHelper;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipMappingInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.AnnotationUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueryParameter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GenerateHashCodeEqualsOperation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.core.context.java.JavaManyToOneMapping;
import org.eclipse.jpt.core.context.java.JavaMultiRelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.ui.internal.SynchronousUiCommandExecutor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EntityAnnotationOperation {
    private static final String ID_CLASS_NAME_SUFFIX = "PK";
    private static final String PUBLIC_MODIFIER = "public";
    private static final String VOID_RETURN_TYPE = "void";
    private JpaEntityInfo entity;
    private boolean updateForJsf = false;
    private boolean ifAddRelationshipOnly = false;
    private final int JPA_PACKAGE_INDEX = "javax.persistence.".length();
    private Integer updateRelationshipFetchType;
    private int primaryKeyPropertySetCount;

    public EntityAnnotationOperation(JpaManagerBeanInfo managerBean) {
        this.entity = managerBean.getEntity();
        this.updateForJsf = managerBean.isUpdateForJsf();
        this.ifAddRelationshipOnly = managerBean.getRelationshipAdded();
        this.updateRelationshipFetchType = managerBean.getUpdateRelationshipFetchType();
        this.primaryKeyPropertySetCount = managerBean.getPrimaryKeyPropertySetCount();
    }

    private void addEqualsHash(IType type, Shell shell2, List<JpaAttributeInfo> primaryKeyAttributes) {
        if (primaryKeyAttributes != null && primaryKeyAttributes.size() > 0) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(type.getCompilationUnit());
            parser.setResolveBindings(true);
            CompilationUnit fUnit = (CompilationUnit)parser.createAST(null);
            ITypeBinding fTypeBinding = null;
            IVariableBinding[] declaredFields = null;
            try {
                AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)fUnit, (ISourceRange)type.getNameRange()), AbstractTypeDeclaration.class);
                if (declaration != null) {
                    fTypeBinding = declaration.resolveBinding();
                }
                if (fTypeBinding != null) {
                    declaredFields = fTypeBinding.getDeclaredFields();
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (declaredFields != null && declaredFields.length > 0) {
                ArrayList<IVariableBinding> bindingsList = new ArrayList<IVariableBinding>();
                boolean compositeAdded = false;
                block4: for (JpaAttributeInfo jpaAtt : primaryKeyAttributes) {
                    String attName = null;
                    if (jpaAtt.isPartOfCompositePrimaryKey()) {
                        if (!compositeAdded) {
                            attName = jpaAtt.getParentAttribute().getAttributeName();
                            compositeAdded = true;
                        }
                    } else {
                        attName = jpaAtt.getAttributeName();
                    }
                    if (attName == null) continue;
                    IVariableBinding[] iVariableBindingArray = declaredFields;
                    int n = declaredFields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVariableBinding variableBinding = iVariableBindingArray[n2];
                        if (attName.equals(variableBinding.getName())) {
                            bindingsList.add(variableBinding);
                            continue block4;
                        }
                        ++n2;
                    }
                }
                IVariableBinding[] selectedFields = bindingsList.toArray(new IVariableBinding[0]);
                try {
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
                    settings.createComments = true;
                    final GenerateHashCodeEqualsOperation operation = new GenerateHashCodeEqualsOperation(fTypeBinding, selectedFields, fUnit, null, settings, true, false, true, true);
                    operation.setUseBlocksForThen(true);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                operation.run((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void addEqualsMethodToEntity(IProgressMonitor monitor) {
        IResource resource;
        ICompilationUnit compUnit;
        IType type;
        List<JpaAttributeInfo> primaryKeyAttributes = this.entity.getPrimaryKeyAttributes();
        if (primaryKeyAttributes != null && primaryKeyAttributes.size() > 0 && (type = (compUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)(resource = JpaUtil.getJavaResourceFromPersistentType(this.entity.getPersistentType()))))).findPrimaryType()) != null) {
            IMethod equalsMethod = type.getMethod("equals", new String[]{Signature.createTypeSignature((String)"Object", (boolean)false)});
            if (equalsMethod != null && equalsMethod.exists()) {
                return;
            }
            IMethod hashCodeMethod = type.getMethod("hashCode", new String[0]);
            if (hashCodeMethod != null && hashCodeMethod.exists()) {
                return;
            }
            this.addEqualsHash(type, null, primaryKeyAttributes);
        }
    }

    private void addImport(JavaModel model, String importType, IProgressMonitor monitor) throws JavaModelException {
        CreateImportCommand importCmd = new CreateImportCommand();
        importCmd.setFullyQualifiedType(importType);
        importCmd.execute(model, monitor);
    }

    private void addRelationshipEntity(JavaModel model, JpaEntityInfo entity, String mappedBy, JpaRelationshipInfo.MULTIPLICITY multiplicity, IProgressMonitor monitor) throws JavaModelException {
        IField field;
        this.addImport(model, entity.getFullyQualifiedEntityName(), monitor);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) {
            this.addImport(model, "javax.persistence.OneToOne", monitor);
            annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.OneToOne".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy"}, new String[]{mappedBy}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
        }
        String newFieldName = JpaUtil.getUniqueDataName(entity.getEntityName().toLowerCase(), model.getType().getFields());
        this.createField(model, newFieldName, entity.getEntityName(), annotations, monitor);
        String methodName = JpaUtil.getMethodName(newFieldName, true);
        this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[0], new String[0], entity.getEntityName(), null, "\treturn this." + newFieldName + ";", null, null, monitor);
        methodName = JpaUtil.getMethodName(newFieldName, false);
        String newFieldType = "";
        IType type = model.getType();
        if (type != null && (field = type.getField(newFieldName)).exists()) {
            newFieldType = field.getTypeSignature();
        }
        this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[]{newFieldType}, new String[]{newFieldName}, VOID_RETURN_TYPE, null, "\tthis." + newFieldName + " = " + newFieldName + ";", null, null, monitor);
    }

    private String addRelationshipEntityList(JavaModel model, JpaEntityInfo entity, String mappedBy, JpaRelationshipInfo.MULTIPLICITY multiplicity, IProgressMonitor monitor) throws JavaModelException {
        IField field;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY || multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
            this.addImport(model, "javax.persistence.OneToMany", monitor);
            if (this.updateRelationshipFetchType == 1) {
                this.addImport(model, "javax.persistence.FetchType", monitor);
                if (mappedBy != null) {
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy", "fetch"}, new String[]{mappedBy, "javax.persistence.FetchType.LAZY".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING, AnnotationUtil.ANNOTATION_TYPE.NAME}));
                } else {
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"fetch"}, new String[]{"javax.persistence.FetchType.LAZY".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.NAME}));
                }
            } else if (this.updateRelationshipFetchType == 2) {
                this.addImport(model, "javax.persistence.FetchType", monitor);
                if (mappedBy != null) {
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy", "fetch"}, new String[]{mappedBy, "javax.persistence.FetchType.EAGER".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING, AnnotationUtil.ANNOTATION_TYPE.NAME}));
                } else {
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"fetch"}, new String[]{"javax.persistence.FetchType.EAGER".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.NAME}));
                }
            } else if (mappedBy != null) {
                annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy"}, new String[]{mappedBy}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
            } else {
                annotations.add((Annotation)AnnotationUtil.createMarkerAnnotation("javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX)));
            }
        } else if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) {
            this.addImport(model, "javax.persistence.ManyToMany", monitor);
            if (mappedBy != null) {
                if (this.updateRelationshipFetchType == 1) {
                    this.addImport(model, "javax.persistence.FetchType", monitor);
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy", "fetch"}, new String[]{mappedBy, "javax.persistence.FetchType.LAZY".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING, AnnotationUtil.ANNOTATION_TYPE.NAME}));
                } else if (this.updateRelationshipFetchType == 2) {
                    this.addImport(model, "javax.persistence.FetchType", monitor);
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy", "fetch"}, new String[]{mappedBy, "javax.persistence.FetchType.EAGER".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING, AnnotationUtil.ANNOTATION_TYPE.NAME}));
                } else {
                    annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"mappedBy"}, new String[]{mappedBy}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
                }
            } else if (this.updateRelationshipFetchType == 1) {
                this.addImport(model, "javax.persistence.FetchType", monitor);
                annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"fetch"}, new String[]{"javax.persistence.FetchType.LAZY".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.NAME}));
            } else if (this.updateRelationshipFetchType == 2) {
                this.addImport(model, "javax.persistence.FetchType", monitor);
                annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX), new String[]{"fetch"}, new String[]{"javax.persistence.FetchType.EAGER".substring(this.JPA_PACKAGE_INDEX)}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.NAME}));
            } else {
                annotations.add((Annotation)AnnotationUtil.createMarkerAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX)));
            }
        }
        this.addImport(model, "java.util.List", monitor);
        String newFieldName = JpaUtil.getUniqueDataName(String.valueOf(entity.getEntityName().toLowerCase()) + "List", model.getType().getFields());
        this.createField(model, newFieldName, "List<" + entity.getEntityName() + ">", annotations, monitor);
        String methodName = JpaUtil.getMethodName(newFieldName, true);
        this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[0], new String[0], "List<" + entity.getEntityName() + ">", null, "\treturn this." + newFieldName + ";", null, null, monitor);
        methodName = JpaUtil.getMethodName(newFieldName, false);
        String newFieldType = "";
        IType type = model.getType();
        if (type != null && (field = type.getField(newFieldName)).exists()) {
            newFieldType = field.getTypeSignature();
        }
        this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[]{newFieldType}, new String[]{newFieldName}, VOID_RETURN_TYPE, null, "\tthis." + newFieldName + " = " + newFieldName + ";", null, null, monitor);
        return newFieldName;
    }

    private void createField(JavaModel model, String attributeName, String attributeType, List<Annotation> annotations, IProgressMonitor monitor) throws JavaModelException {
        CreateFieldCommand createFieldCmd = new CreateFieldCommand();
        createFieldCmd.setModifier("private");
        createFieldCmd.setIdentifier(attributeName);
        createFieldCmd.setFullyQualifiedType(attributeType);
        createFieldCmd.setAnnotations(annotations);
        createFieldCmd.execute(model, monitor);
    }

    private String createIDClass(IProgressMonitor monitor) {
        List<JpaAttributeInfo> primaryKeyAttributes2 = this.entity.getPrimaryKeyAttributes();
        int numberOfParameters = primaryKeyAttributes2.size();
        ArrayList<DataParameter> dataParameters = new ArrayList<DataParameter>(numberOfParameters);
        ArrayList<String> resolvedTypesToImport = new ArrayList<String>(1);
        int i = 0;
        while (i < numberOfParameters) {
            DataParameter param = new DataParameter();
            param.setName(primaryKeyAttributes2.get(i).getAttributeName());
            param.setFullyResolvedType(primaryKeyAttributes2.get(i).getAttributeType());
            if (!resolvedTypesToImport.contains(primaryKeyAttributes2.get(i).getAttributeType())) {
                resolvedTypesToImport.add(primaryKeyAttributes2.get(i).getAttributeType());
            }
            dataParameters.add(param);
            ++i;
        }
        PageCodeTemplateHelper helper = new PageCodeTemplateHelper();
        String entityPackage = this.entity.getFullyQualifiedEntityName();
        int lastIndex = entityPackage.lastIndexOf(46);
        if (lastIndex != -1) {
            entityPackage = entityPackage.substring(0, lastIndex);
        }
        String idClassName = String.valueOf(this.entity.getEntityName()) + ID_CLASS_NAME_SUFFIX;
        String idClassJavaName = String.valueOf(idClassName) + ".java";
        IPath classpath = new Path(entityPackage).append(idClassJavaName);
        IFolder sourceFolder = JavaCodeUtil.getWebSourceFolder((IProject)this.entity.getProject());
        if (classpath.segmentCount() > 0 && classpath.segment(0).equals(sourceFolder.getName())) {
            classpath = classpath.removeFirstSegments(1);
        }
        helper.setPackageName(entityPackage);
        helper.setConverterClassName(idClassName);
        helper.setFullyQualifiedEntityName(this.entity.getFullyQualifiedEntityName());
        helper.setDataParameters(dataParameters);
        String contents = new IdClass().generate(helper);
        ICompilationUnit idClassCU = JavaCodeUtil.createClass((IProject)this.entity.getProject(), (IPath)classpath, (String)entityPackage, (String)idClassJavaName, (String)contents, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
        if (idClassCU != null) {
            IType idClassType = idClassCU.findPrimaryType();
            this.addEqualsHash(idClassType, null, primaryKeyAttributes2);
        }
        return idClassName;
    }

    private void deleteField(JavaModel model, String attributeName, boolean deleteImports, IProgressMonitor monitor) throws JavaModelException {
        DeleteFieldCommand deleteFieldCmd = new DeleteFieldCommand();
        deleteFieldCmd.setIdentifier(attributeName);
        deleteFieldCmd.setDeleteImport(deleteImports);
        deleteFieldCmd.execute(model, monitor);
    }

    private void deleteImport(JavaModel model, String importType, IProgressMonitor monitor) throws JavaModelException {
        DeleteImportConditionallyCommand deleteImportCmd = new DeleteImportConditionallyCommand();
        deleteImportCmd.setTypeSignature(importType);
        deleteImportCmd.execute(model, monitor);
    }

    private void deleteMethod(JavaModel model, String methodName, String[] parameterNames, String[] parameterTypes, IProgressMonitor monitor) throws JavaModelException {
        DeleteMethodCommand deleteMethodCmd = new DeleteMethodCommand();
        deleteMethodCmd.setIdentifier(methodName);
        deleteMethodCmd.setParameterNames(parameterNames);
        deleteMethodCmd.setParameters(parameterTypes);
        deleteMethodCmd.execute(model, monitor);
    }

    public void execute(IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)JpaUI.EntityAnnotationOperation_0, (Object)this.entity.getEntityName()), 100);
        if (this.ifAddRelationshipOnly) {
            return;
        }
        if (this.entity != null && this.entity.getPersistentType() != null) {
            block23: {
                List<JpaAttributeInfo> attributes = this.entity.getAttributes();
                if (this.updateForJsf) {
                    this.addEqualsMethodToEntity(monitor);
                }
                JpaProject jpaProject = this.entity.getPersistentType().getJpaProject();
                jpaProject.setThreadLocalModifySharedDocumentCommandExecutor(SynchronousUiCommandExecutor.instance());
                ArrayList<DateTimeConverter> sqldateMappings = new ArrayList<DateTimeConverter>();
                JavaModel primaryModel = null;
                try {
                    try {
                        if (this.updateForJsf) {
                            for (JpaAttributeInfo jpaAttribute : attributes) {
                                String attributeTypeName;
                                PersistentAttribute attribute = jpaAttribute.getAttribute();
                                if (!(attribute instanceof JavaPersistentAttribute) || (attributeTypeName = jpaAttribute.getAttributeType()) == null || !attributeTypeName.equals("java.sql.Date") && !attributeTypeName.equals("java.sql.Time") && !attributeTypeName.equals("java.sql.Timestamp")) continue;
                                sqldateMappings.add(new DateTimeConverter(jpaAttribute, attributeTypeName));
                            }
                            boolean addedDate = false;
                            if (!sqldateMappings.isEmpty()) {
                                PersistentType persistentType;
                                ICompilationUnit cu;
                                primaryModel = JavaModelManager.getInstance().getModel("defaultjavamodel", this.entity.getProject(), JpaUtil.getJavaResourceFromPersistentType(this.entity.getPersistentType()).getProjectRelativePath());
                                primaryModel.prepareCompilationUnit(monitor);
                                for (DateTimeConverter sqlDateAttribute : sqldateMappings) {
                                    AttributeMapping mapping = sqlDateAttribute.jpaAttribute.getAttribute().getMapping();
                                    if (mapping == null) continue;
                                    if (sqlDateAttribute.resolvedType.equals("java.sql.Date")) {
                                        ((ColumnMapping)mapping).setTemporal(TemporalType.DATE);
                                        sqlDateAttribute.jpaAttribute.setTemporalType(NamedQueryParameter.TemporalType.DATE);
                                        addedDate = true;
                                        continue;
                                    }
                                    if (sqlDateAttribute.resolvedType.equals("java.sql.Time")) {
                                        this.updateFieldType(primaryModel, sqlDateAttribute.jpaAttribute.getAttributeName(), "Date", null, monitor);
                                        this.updateGetterSetterMethods(primaryModel, sqlDateAttribute.jpaAttribute.getAttributeName(), Signature.createTypeSignature((String)"java.sql.Time", (boolean)false), "Date", monitor);
                                        ((ColumnMapping)mapping).setTemporal(TemporalType.TIME);
                                        sqlDateAttribute.jpaAttribute.setTemporalType(NamedQueryParameter.TemporalType.TIME);
                                        addedDate = true;
                                        continue;
                                    }
                                    if (!sqlDateAttribute.resolvedType.equals("java.sql.Timestamp")) continue;
                                    this.updateFieldType(primaryModel, sqlDateAttribute.jpaAttribute.getAttributeName(), "Date", null, monitor);
                                    this.updateGetterSetterMethods(primaryModel, sqlDateAttribute.jpaAttribute.getAttributeName(), Signature.createTypeSignature((String)"java.sql.Timestamp", (boolean)false), "Date", monitor);
                                    ((ColumnMapping)mapping).setTemporal(TemporalType.TIMESTAMP);
                                    sqlDateAttribute.jpaAttribute.setTemporalType(NamedQueryParameter.TemporalType.TIMESTAMP);
                                    addedDate = true;
                                }
                                if (addedDate && (cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)JpaUtil.getJavaResourceFromPersistentType(persistentType = this.entity.getPersistentType())))) != null && cu.exists()) {
                                    this.switchSqlDateToUtilDate(cu, monitor);
                                }
                            }
                        }
                        for (JpaAttributeInfo jpaAttribute : attributes) {
                            PersistentAttribute currentAttribute = jpaAttribute.getAttribute();
                            if (currentAttribute instanceof JavaPersistentAttribute) {
                                jpaAttribute.getAttribute().setSpecifiedMappingKey(jpaAttribute.getMappingKey());
                                continue;
                            }
                            if (!(currentAttribute instanceof OrmPersistentAttribute)) continue;
                            if (((OrmPersistentAttribute)currentAttribute).isVirtual()) {
                                if (jpaAttribute.getMappingKey() != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY && !jpaAttribute.getMappingKey().equals("basic")) {
                                    ((OrmPersistentAttribute)currentAttribute).makeSpecified(jpaAttribute.getMappingKey());
                                    continue;
                                }
                                if (((OrmPersistentAttribute)currentAttribute).getMappingKey() == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY || ((OrmPersistentAttribute)currentAttribute).getMappingKey().equals("basic")) continue;
                                ((OrmPersistentAttribute)currentAttribute).makeSpecified("basic");
                                continue;
                            }
                            if (jpaAttribute.getMappingKey() == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
                                ((OrmPersistentAttribute)currentAttribute).setSpecifiedMappingKey("basic");
                                continue;
                            }
                            if (jpaAttribute.getMappingKey().equals(((OrmPersistentAttribute)currentAttribute).getMappingKey())) continue;
                            ((OrmPersistentAttribute)currentAttribute).setSpecifiedMappingKey(jpaAttribute.getMappingKey());
                        }
                        this.handleRelationships(primaryModel, monitor);
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                        if (primaryModel != null) {
                            primaryModel.save();
                            primaryModel.release();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (primaryModel != null) {
                        primaryModel.save();
                        primaryModel.release();
                    }
                    throw throwable;
                }
                if (primaryModel != null) {
                    primaryModel.save();
                    primaryModel.release();
                }
            }
            this.setPrimaryKeyIdClass(monitor);
            AnnotationUtil.saveEntityModel(this.entity.getPersistentType());
        }
        monitor.worked(100);
        monitor.done();
    }

    private void handleRelationships(JavaModel primaryModel, IProgressMonitor monitor) throws JavaModelException {
        List<JpaRelationshipInfo> relationships = this.entity.getRelationships();
        if (relationships != null) {
            JavaModel relationshipModel = null;
            try {
                for (JpaRelationshipInfo relationship : relationships) {
                    JavaJoinColumn joinColumn;
                    ArrayList<Annotation> annotations;
                    IField field;
                    IField field2;
                    IType type;
                    IField field3;
                    RelationshipMapping otherMapping;
                    List<JpaRelationshipInfo> otherRelationships;
                    String initialFieldType;
                    String typeToChangeTo;
                    String attributeNameToChange;
                    String attributeNameToRemove;
                    JpaEntityInfo relationshipEntity;
                    JpaRelationshipInfo.STATUS status = relationship.getStatus();
                    if (primaryModel == null && (status != JpaRelationshipInfo.STATUS.EXISTING || this.updateForJsf)) {
                        primaryModel = JavaModelManager.getInstance().getModel("defaultjavamodel", this.entity.getProject(), JpaUtil.getJavaResourceFromPersistentType(this.entity.getPersistentType()).getProjectRelativePath());
                        primaryModel.prepareCompilationUnit(monitor);
                    }
                    if (status == JpaRelationshipInfo.STATUS.NEW) {
                        String mappedBy;
                        relationshipEntity = relationship.getEntity();
                        if (relationshipEntity != null) {
                            relationshipModel = JavaModelManager.getInstance().getModel("defaultjavamodel", relationshipEntity.getProject(), JpaUtil.getJavaResourceFromPersistentType(relationshipEntity.getPersistentType()).getProjectRelativePath());
                            relationshipModel.prepareCompilationUnit(monitor);
                        }
                        List<JpaRelationshipMappingInfo> mappings = relationship.getAttributeMappings();
                        if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) {
                            mappedBy = this.updateForeignKey(primaryModel, mappings, relationshipEntity, JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE, monitor);
                            if (relationship.getDirectional() != JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL) continue;
                            this.addRelationshipEntity(relationshipModel, this.entity, mappedBy, JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE, monitor);
                            continue;
                        }
                        if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                            if (relationship.getDirectional() == JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL) {
                                mappedBy = this.updateForeignKey(relationshipModel, mappings, this.entity, JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY, monitor);
                                this.addRelationshipEntityList(primaryModel, relationshipEntity, mappedBy, JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY, monitor);
                                continue;
                            }
                            this.addRelationshipEntityList(primaryModel, relationshipEntity, null, JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY, monitor);
                            continue;
                        }
                        if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                            mappedBy = this.updateForeignKey(primaryModel, mappings, relationshipEntity, JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE, monitor);
                            if (relationship.getDirectional() != JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL) continue;
                            this.addRelationshipEntityList(relationshipModel, this.entity, mappedBy, JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE, monitor);
                            continue;
                        }
                        if (relationship.getMultiplicity() != JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) continue;
                        mappedBy = this.addRelationshipEntityList(primaryModel, relationshipEntity, null, JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY, monitor);
                        if (relationship.getDirectional() != JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL) continue;
                        this.addRelationshipEntityList(relationshipModel, this.entity, mappedBy, JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY, monitor);
                        continue;
                    }
                    if (status == JpaRelationshipInfo.STATUS.EXISTING && (this.updateForJsf || this.updateRelationshipFetchType != 0)) {
                        relationshipEntity = relationship.getEntity();
                        if (primaryModel == null) {
                            primaryModel = JavaModelManager.getInstance().getModel("defaultjavamodel", this.entity.getProject(), JpaUtil.getJavaResourceFromPersistentType(this.entity.getPersistentType()).getProjectRelativePath());
                            primaryModel.prepareCompilationUnit(monitor);
                        }
                        if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                            if (this.updateForJsf) {
                                this.updateForJsfEntityList(primaryModel, relationship.getEntity(), relationship.getRelationshipMapping(), monitor);
                            }
                            this.updateRelationshipFetchTypeMapping(primaryModel, relationship.getRelationshipMapping(), "javax.persistence.OneToMany".substring(this.JPA_PACKAGE_INDEX), monitor);
                            continue;
                        }
                        if (relationship.getMultiplicity() != JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) continue;
                        if (this.updateForJsf) {
                            this.updateForJsfEntityList(primaryModel, relationshipEntity, relationship.getRelationshipMapping(), monitor);
                        }
                        this.updateRelationshipFetchTypeMapping(primaryModel, relationship.getRelationshipMapping(), "javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX), monitor);
                        continue;
                    }
                    if (status != JpaRelationshipInfo.STATUS.REMOVED) continue;
                    relationshipEntity = relationship.getEntity();
                    if (relationshipEntity != null) {
                        relationshipModel = JavaModelManager.getInstance().getModel("defaultjavamodel", relationshipEntity.getProject(), JpaUtil.getJavaResourceFromPersistentType(relationshipEntity.getPersistentType()).getProjectRelativePath());
                        relationshipModel.prepareCompilationUnit(monitor);
                    }
                    if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) {
                        JavaJoinColumn joinColumn2;
                        Object annotations2;
                        IType type2;
                        attributeNameToRemove = null;
                        attributeNameToChange = null;
                        typeToChangeTo = null;
                        initialFieldType = null;
                        JavaOneToOneMapping oneToOne = (JavaOneToOneMapping)relationship.getRelationshipMapping();
                        String mappedBy = oneToOne.getMappedBy();
                        JavaOneToOneMapping otherOneToOne = null;
                        otherRelationships = relationshipEntity.getRelationships();
                        for (JpaRelationshipInfo otherRelationship : otherRelationships) {
                            otherMapping = otherRelationship.getRelationshipMapping();
                            if (!(otherMapping instanceof JavaOneToOneMapping) || otherMapping.getResolvedTargetEntity() == null || otherMapping.getResolvedTargetEntity().getPersistentType() != this.entity.getPersistentType()) continue;
                            otherOneToOne = (JavaOneToOneMapping)otherMapping;
                            break;
                        }
                        if (mappedBy == null) {
                            attributeNameToChange = oneToOne.getPersistentAttribute().getName();
                            type2 = primaryModel.getType();
                            if (type2 != null && (field3 = type2.getField(attributeNameToChange)).exists()) {
                                initialFieldType = field3.getTypeSignature();
                            }
                            typeToChangeTo = relationshipEntity.getPrimaryKeyAttributes().get(0).getAttributeType();
                            this.updateGetterSetterMethods(primaryModel, attributeNameToChange, initialFieldType, Signature.getSimpleName((String)typeToChangeTo), monitor);
                            annotations2 = new ArrayList();
                            if (oneToOne.specifiedJoinColumnsSize() == 1 && !(joinColumn2 = (JavaJoinColumn)oneToOne.specifiedJoinColumns().next()).getName().equals(attributeNameToChange)) {
                                this.addImport(primaryModel, "javax.persistence.Column", monitor);
                                annotations2.add(AnnotationUtil.createNormalAnnotation("javax.persistence.Column".substring(this.JPA_PACKAGE_INDEX), new String[]{"name"}, new String[]{joinColumn2.getName()}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
                            }
                            this.updateFieldType(primaryModel, attributeNameToChange, Signature.getSimpleName((String)typeToChangeTo), (List<Annotation>)annotations2, new String[]{"javax.persistence.OneToOne".substring(this.JPA_PACKAGE_INDEX), "javax.persistence.JoinColumn".substring(this.JPA_PACKAGE_INDEX)}, monitor);
                            this.deleteImport(primaryModel, Signature.createTypeSignature((String)"javax.persistence.JoinColumn", (boolean)true), monitor);
                            if (otherOneToOne != null) {
                                attributeNameToRemove = otherOneToOne.getPersistentAttribute().getName();
                                this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemove, true), new String[0], new String[0], monitor);
                                this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemove, false), new String[]{attributeNameToRemove}, new String[]{Signature.createTypeSignature((String)this.entity.getEntityName(), (boolean)false)}, monitor);
                                this.deleteField(relationshipModel, attributeNameToRemove, true, monitor);
                            }
                        } else {
                            attributeNameToRemove = oneToOne.getPersistentAttribute().getName();
                            attributeNameToChange = mappedBy;
                            typeToChangeTo = this.entity.getPrimaryKeyAttributes().get(0).getAttributeType();
                            type2 = relationshipModel.getType();
                            if (type2 != null && (field3 = type2.getField(attributeNameToChange)).exists()) {
                                initialFieldType = field3.getTypeSignature();
                            }
                            annotations2 = new ArrayList();
                            if (otherOneToOne.specifiedJoinColumnsSize() == 1 && !(joinColumn2 = (JavaJoinColumn)otherOneToOne.specifiedJoinColumns().next()).getName().equals(attributeNameToChange)) {
                                this.addImport(relationshipModel, "javax.persistence.Column", monitor);
                                annotations2.add(AnnotationUtil.createNormalAnnotation("javax.persistence.Column".substring(this.JPA_PACKAGE_INDEX), new String[]{"name"}, new String[]{joinColumn2.getName()}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
                            }
                            this.updateGetterSetterMethods(relationshipModel, attributeNameToChange, initialFieldType, Signature.getSimpleName((String)typeToChangeTo), monitor);
                            this.updateFieldType(relationshipModel, attributeNameToChange, Signature.getSimpleName((String)typeToChangeTo), (List<Annotation>)annotations2, new String[]{"javax.persistence.OneToOne".substring(this.JPA_PACKAGE_INDEX), "javax.persistence.JoinColumn".substring(this.JPA_PACKAGE_INDEX)}, monitor);
                            this.deleteImport(relationshipModel, Signature.createTypeSignature((String)"javax.persistence.JoinColumn", (boolean)true), monitor);
                            this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemove, true), new String[0], new String[0], monitor);
                            this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemove, false), new String[]{attributeNameToRemove}, new String[]{Signature.createTypeSignature((String)relationshipEntity.getEntityName(), (boolean)false)}, monitor);
                            this.deleteField(primaryModel, attributeNameToRemove, true, monitor);
                        }
                        this.deleteImport(primaryModel, Signature.createTypeSignature((String)"javax.persistence.OneToOne", (boolean)true), monitor);
                        this.deleteImport(relationshipModel, Signature.createTypeSignature((String)"javax.persistence.OneToOne", (boolean)true), monitor);
                        continue;
                    }
                    if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                        attributeNameToRemove = null;
                        attributeNameToChange = null;
                        typeToChangeTo = null;
                        initialFieldType = null;
                        JavaOneToManyMapping oneToMany = (JavaOneToManyMapping)relationship.getRelationshipMapping();
                        attributeNameToRemove = oneToMany.getPersistentAttribute().getName();
                        type = primaryModel.getType();
                        if (type != null && (field2 = type.getField(attributeNameToRemove)).exists()) {
                            initialFieldType = field2.getTypeSignature();
                        }
                        this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemove, true), new String[0], new String[0], monitor);
                        if (initialFieldType != null) {
                            this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemove, false), new String[]{attributeNameToRemove}, new String[]{initialFieldType}, monitor);
                        }
                        this.deleteField(primaryModel, attributeNameToRemove, true, monitor);
                        attributeNameToChange = oneToMany.getMappedBy();
                        if (attributeNameToChange != null && attributeNameToChange.length() > 0) {
                            JavaManyToOneMapping manyToOne = null;
                            otherRelationships = relationshipEntity.getRelationships();
                            for (JpaRelationshipInfo otherRelationship : otherRelationships) {
                                otherMapping = otherRelationship.getRelationshipMapping();
                                if (!(otherMapping instanceof JavaManyToOneMapping) || otherMapping.getResolvedTargetEntity().getPersistentType() != this.entity.getPersistentType()) continue;
                                manyToOne = (JavaManyToOneMapping)otherMapping;
                                break;
                            }
                            typeToChangeTo = this.entity.getPrimaryKeyAttributes().get(0).getAttributeType();
                            type = relationshipModel.getType();
                            if (type != null && (field = type.getField(attributeNameToChange)).exists()) {
                                initialFieldType = field.getTypeSignature();
                            }
                            this.updateGetterSetterMethods(relationshipModel, attributeNameToChange, initialFieldType, Signature.getSimpleName((String)typeToChangeTo), monitor);
                            annotations = new ArrayList<Annotation>();
                            if (manyToOne.specifiedJoinColumnsSize() == 1 && !(joinColumn = (JavaJoinColumn)manyToOne.specifiedJoinColumns().next()).getName().equals(attributeNameToChange)) {
                                this.addImport(relationshipModel, "javax.persistence.Column", monitor);
                                annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.Column".substring(this.JPA_PACKAGE_INDEX), new String[]{"name"}, new String[]{joinColumn.getName()}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
                            }
                            this.updateFieldType(relationshipModel, attributeNameToChange, Signature.getSimpleName((String)typeToChangeTo), annotations, new String[]{"javax.persistence.ManyToOne".substring(this.JPA_PACKAGE_INDEX), "javax.persistence.JoinColumn".substring(this.JPA_PACKAGE_INDEX)}, monitor);
                            this.deleteImport(relationshipModel, Signature.createTypeSignature((String)"javax.persistence.JoinColumn", (boolean)true), monitor);
                        }
                        this.deleteImport(relationshipModel, Signature.createTypeSignature((String)"javax.persistence.ManyToOne", (boolean)true), monitor);
                        this.deleteImport(primaryModel, Signature.createTypeSignature((String)"javax.persistence.OneToMany", (boolean)true), monitor);
                        continue;
                    }
                    if (relationship.getMultiplicity() == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                        attributeNameToRemove = null;
                        attributeNameToChange = null;
                        typeToChangeTo = null;
                        initialFieldType = null;
                        JavaManyToOneMapping manyToOne = (JavaManyToOneMapping)relationship.getRelationshipMapping();
                        JavaOneToManyMapping oneToMany = null;
                        List<JpaRelationshipInfo> otherRelationships2 = relationshipEntity.getRelationships();
                        for (JpaRelationshipInfo otherRelationship : otherRelationships2) {
                            RelationshipMapping otherMapping2 = otherRelationship.getRelationshipMapping();
                            if (!(otherMapping2 instanceof JavaOneToManyMapping) || otherMapping2.getResolvedTargetEntity().getPersistentType() != this.entity.getPersistentType()) continue;
                            oneToMany = (JavaOneToManyMapping)otherMapping2;
                            break;
                        }
                        attributeNameToChange = manyToOne.getPersistentAttribute().getName();
                        IType type3 = primaryModel.getType();
                        if (type3 != null && (field = type3.getField(attributeNameToChange)).exists()) {
                            initialFieldType = field.getTypeSignature();
                        }
                        typeToChangeTo = relationshipEntity.getPrimaryKeyAttributes().get(0).getAttributeType();
                        this.updateGetterSetterMethods(primaryModel, attributeNameToChange, initialFieldType, Signature.getSimpleName((String)typeToChangeTo), monitor);
                        annotations = new ArrayList();
                        if (manyToOne.specifiedJoinColumnsSize() == 1 && !(joinColumn = (JavaJoinColumn)manyToOne.specifiedJoinColumns().next()).getName().equals(attributeNameToChange)) {
                            this.addImport(primaryModel, "javax.persistence.Column", monitor);
                            annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.Column".substring(this.JPA_PACKAGE_INDEX), new String[]{"name"}, new String[]{joinColumn.getName()}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
                        }
                        this.updateFieldType(primaryModel, attributeNameToChange, Signature.getSimpleName((String)typeToChangeTo), (List<Annotation>)annotations, new String[]{"javax.persistence.ManyToOne".substring(this.JPA_PACKAGE_INDEX), "javax.persistence.JoinColumn".substring(this.JPA_PACKAGE_INDEX)}, monitor);
                        this.deleteImport(primaryModel, Signature.createTypeSignature((String)"javax.persistence.JoinColumn", (boolean)true), monitor);
                        if (oneToMany != null) {
                            attributeNameToRemove = oneToMany.getPersistentAttribute().getName();
                            type3 = relationshipModel.getType();
                            if (type3 != null && (field3 = type3.getField(attributeNameToRemove)).exists()) {
                                initialFieldType = field3.getTypeSignature();
                            }
                            this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemove, true), new String[0], new String[0], monitor);
                            if (initialFieldType != null) {
                                this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemove, false), new String[]{attributeNameToRemove}, new String[]{initialFieldType}, monitor);
                            }
                            this.deleteField(relationshipModel, attributeNameToRemove, true, monitor);
                        }
                        this.deleteImport(primaryModel, Signature.createTypeSignature((String)"javax.persistence.ManyToOne", (boolean)true), monitor);
                        this.deleteImport(relationshipModel, Signature.createTypeSignature((String)"javax.persistence.OneToMany", (boolean)true), monitor);
                        continue;
                    }
                    if (relationship.getMultiplicity() != JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) continue;
                    String attributeNameToRemoveOwning = null;
                    String attributeNameToRemoveInverse = null;
                    String initialFieldType2 = null;
                    JavaManyToManyMapping manyToMany = (JavaManyToManyMapping)relationship.getRelationshipMapping();
                    String mappedBy = manyToMany.getMappedBy();
                    if (mappedBy == null) {
                        attributeNameToRemoveOwning = manyToMany.getPersistentAttribute().getName();
                        type = primaryModel.getType();
                        if (type != null && (field2 = type.getField(attributeNameToRemoveOwning)).exists()) {
                            initialFieldType2 = field2.getTypeSignature();
                        }
                        this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemoveOwning, true), new String[0], new String[0], monitor);
                        if (initialFieldType2 != null) {
                            this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemoveOwning, false), new String[]{attributeNameToRemoveOwning}, new String[]{initialFieldType2}, monitor);
                        }
                        this.deleteField(primaryModel, attributeNameToRemoveOwning, true, monitor);
                        JavaManyToManyMapping otherManyToMany = null;
                        otherRelationships = relationshipEntity.getRelationships();
                        for (JpaRelationshipInfo otherRelationship : otherRelationships) {
                            otherMapping = otherRelationship.getRelationshipMapping();
                            if (!(otherMapping instanceof JavaManyToManyMapping) || otherMapping.getResolvedTargetEntity().getPersistentType() != this.entity.getPersistentType()) continue;
                            otherManyToMany = (JavaManyToManyMapping)otherMapping;
                            break;
                        }
                        if (otherManyToMany != null) {
                            attributeNameToRemoveInverse = otherManyToMany.getPersistentAttribute().getName();
                            type = relationshipModel.getType();
                            if (type != null && (field = type.getField(attributeNameToRemoveInverse)).exists()) {
                                initialFieldType2 = field.getTypeSignature();
                            }
                            this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemoveInverse, true), new String[0], new String[0], monitor);
                            if (initialFieldType2 != null) {
                                this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemoveInverse, false), new String[]{attributeNameToRemoveInverse}, new String[]{initialFieldType2}, monitor);
                            }
                            this.deleteField(relationshipModel, attributeNameToRemoveInverse, true, monitor);
                        }
                    } else {
                        attributeNameToRemoveOwning = manyToMany.getPersistentAttribute().getName();
                        attributeNameToRemoveInverse = mappedBy;
                        type = primaryModel.getType();
                        if (type != null && (field2 = type.getField(attributeNameToRemoveOwning)).exists()) {
                            initialFieldType2 = field2.getTypeSignature();
                        }
                        this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemoveOwning, true), new String[0], new String[0], monitor);
                        if (initialFieldType2 != null) {
                            this.deleteMethod(primaryModel, JpaUtil.getMethodName(attributeNameToRemoveOwning, false), new String[]{attributeNameToRemoveOwning}, new String[]{initialFieldType2}, monitor);
                        }
                        this.deleteField(primaryModel, attributeNameToRemoveOwning, true, monitor);
                        type = relationshipModel.getType();
                        if (type != null && (field2 = type.getField(attributeNameToRemoveInverse)).exists()) {
                            initialFieldType2 = field2.getTypeSignature();
                        }
                        this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemoveInverse, true), new String[0], new String[0], monitor);
                        if (initialFieldType2 != null) {
                            this.deleteMethod(relationshipModel, JpaUtil.getMethodName(attributeNameToRemoveInverse, false), new String[]{attributeNameToRemoveInverse}, new String[]{initialFieldType2}, monitor);
                        }
                        this.deleteField(relationshipModel, attributeNameToRemoveInverse, true, monitor);
                    }
                    this.deleteImport(primaryModel, Signature.createTypeSignature((String)"javax.persistence.ManyToMany", (boolean)true), monitor);
                    this.deleteImport(relationshipModel, Signature.createTypeSignature((String)"javax.persistence.ManyToMany", (boolean)true), monitor);
                }
            }
            finally {
                if (relationshipModel != null) {
                    relationshipModel.save();
                    relationshipModel.release();
                }
            }
        }
    }

    private void setPrimaryKeyIdClass(IProgressMonitor monitor) {
        Entity entity;
        String idClass;
        TypeMapping mapping;
        PersistentType persistentType;
        List<JpaAttributeInfo> primaryKeyAttributes = this.entity.getPrimaryKeyAttributes();
        if (primaryKeyAttributes != null && primaryKeyAttributes.size() > 1) {
            Entity entity2;
            String idClass2;
            TypeMapping mapping2;
            PersistentType persistentType2;
            if (!primaryKeyAttributes.get(0).isPartOfCompositePrimaryKey() && primaryKeyAttributes.get(0).getParentAttribute() == null && (persistentType2 = this.entity.getPersistentType()) != null && (mapping2 = persistentType2.getMapping()) instanceof Entity && ((idClass2 = (entity2 = (Entity)mapping2).getIdClass()) == null || this.primaryKeyPropertySetCount > 1)) {
                idClass2 = this.createIDClass(monitor);
                entity2.setIdClass(idClass2);
            }
        } else if (primaryKeyAttributes != null && primaryKeyAttributes.size() == 1 && this.primaryKeyPropertySetCount > 1 && (persistentType = this.entity.getPersistentType()) != null && (mapping = persistentType.getMapping()) instanceof Entity && (idClass = (entity = (Entity)mapping).getIdClass()) != null) {
            entity.setIdClass(null);
        }
    }

    private void switchSqlDateToUtilDate(ICompilationUnit cu, IProgressMonitor monitor) {
        if (cu != null) {
            try {
                IImportDeclaration[] imports;
                IImportDeclaration[] iImportDeclarationArray = imports = cu.getImports();
                int n = imports.length;
                int n2 = 0;
                while (n2 < n) {
                    IImportDeclaration iimport = iImportDeclarationArray[n2];
                    String name = iimport.getElementName();
                    if (name.equals("java.sql.Date") || name.equals("java.sql.Time") || name.equals("java.sql.Timestamp")) {
                        iimport.delete(false, monitor);
                    }
                    ++n2;
                }
                IImportDeclaration _import = cu.getImport("java.util.Date");
                if (!_import.exists()) {
                    cu.createImport("java.util.Date", null, monitor);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateFieldType(JavaModel model, String attributeName, String newType, List<Annotation> newAnnotations, IProgressMonitor monitor) throws JavaModelException {
        this.updateFieldType(model, attributeName, newType, newAnnotations, null, monitor);
    }

    private void updateFieldType(JavaModel model, String attributeName, String newType, List<Annotation> newAnnotations, String[] removeAnnotations, IProgressMonitor monitor) throws JavaModelException {
        ReadFieldCommand readFieldCmd = new ReadFieldCommand();
        readFieldCmd.setIdentifier(attributeName);
        readFieldCmd.setReadAnnotations(true);
        readFieldCmd.execute(model, monitor);
        this.deleteField(model, attributeName, true, monitor);
        ArrayList<Annotation> annotations = readFieldCmd.getAnnotations();
        if (annotations == null) {
            annotations = new ArrayList<Annotation>();
        }
        if (removeAnnotations != null) {
            String[] stringArray = removeAnnotations;
            int n = removeAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                String removeAnnotation = stringArray[n2];
                for (Annotation annotation : annotations) {
                    if (!annotation.getTypeName().getFullyQualifiedName().equals(removeAnnotation)) continue;
                    annotations.remove(annotation);
                    break;
                }
                ++n2;
            }
        }
        if (newAnnotations != null) {
            annotations.addAll(newAnnotations);
        }
        this.createField(model, attributeName, newType, annotations, monitor);
    }

    private String updateForeignKey(JavaModel model, List<JpaRelationshipMappingInfo> mappings, JpaEntityInfo relationshipEntity, JpaRelationshipInfo.MULTIPLICITY multiplicity, IProgressMonitor monitor) throws JavaModelException {
        IType type = model.getType();
        AST ast = AST.newAST((int)3);
        String foreignAttributeName = null;
        String currentTypeSignature = null;
        if (type != null) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            this.addImport(model, relationshipEntity.getFullyQualifiedEntityName(), monitor);
            this.addImport(model, "javax.persistence.JoinColumn", monitor);
            if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) {
                this.addImport(model, "javax.persistence.OneToOne", monitor);
                annotations.add((Annotation)AnnotationUtil.createMarkerAnnotation("javax.persistence.OneToOne".substring(this.JPA_PACKAGE_INDEX)));
            } else if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY || multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                this.addImport(model, "javax.persistence.ManyToOne", monitor);
                annotations.add((Annotation)AnnotationUtil.createMarkerAnnotation("javax.persistence.ManyToOne".substring(this.JPA_PACKAGE_INDEX)));
            } else if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) {
                this.addImport(model, "javax.persistence.ManyToMany", monitor);
                annotations.add((Annotation)AnnotationUtil.createMarkerAnnotation("javax.persistence.ManyToMany".substring(this.JPA_PACKAGE_INDEX)));
            }
            if (mappings.size() > 1) {
                ArrayList<Annotation> joinAnnotations = new ArrayList<Annotation>();
                foreignAttributeName = JpaUtil.getUniqueDataName(relationshipEntity.getEntityName().toLowerCase(), model.getType().getFields());
                for (JpaRelationshipMappingInfo mapping : mappings) {
                    String currentAttributeName = mapping.getForeignKey().getAttributeName();
                    String currentColumnName = mapping.getForeignKey().getColumnName();
                    IField field = type.getField(currentAttributeName);
                    if (field.exists()) {
                        currentTypeSignature = field.getTypeSignature();
                    }
                    joinAnnotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.JoinColumn".substring(this.JPA_PACKAGE_INDEX), new String[]{"name", "referencedColumnName"}, new String[]{currentColumnName, mapping.getPrimaryKey().getColumnName()}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING, AnnotationUtil.ANNOTATION_TYPE.STRING}, ast));
                    this.deleteField(model, currentAttributeName, true, monitor);
                    this.deleteMethod(model, JpaUtil.getMethodName(currentAttributeName, true), new String[0], new String[0], monitor);
                    this.deleteMethod(model, JpaUtil.getMethodName(currentAttributeName, false), new String[]{currentAttributeName}, new String[]{currentTypeSignature}, monitor);
                }
                this.addImport(model, "javax.persistence.JoinColumns", monitor);
                annotations.add((Annotation)AnnotationUtil.createJoinColumnsAnnotation(joinAnnotations, ast));
                this.createField(model, foreignAttributeName, relationshipEntity.getEntityName(), annotations, monitor);
                String methodName = JpaUtil.getMethodName(foreignAttributeName, true);
                this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[0], new String[0], relationshipEntity.getEntityName(), null, "\treturn this." + foreignAttributeName + ";", null, null, monitor);
                methodName = JpaUtil.getMethodName(foreignAttributeName, false);
                String newFieldType = "";
                IField field = type.getField(foreignAttributeName);
                if (field.exists()) {
                    newFieldType = field.getTypeSignature();
                }
                this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[]{newFieldType}, new String[]{foreignAttributeName}, VOID_RETURN_TYPE, null, "\tthis." + foreignAttributeName + " = " + foreignAttributeName + ";", null, null, monitor);
            } else {
                foreignAttributeName = mappings.get(0).getForeignKey().getAttributeName();
                String currentColumnName = mappings.get(0).getForeignKey().getColumnName();
                IField field = type.getField(foreignAttributeName);
                if (field.exists()) {
                    currentTypeSignature = field.getTypeSignature();
                }
                annotations.add((Annotation)AnnotationUtil.createNormalAnnotation("javax.persistence.JoinColumn".substring(this.JPA_PACKAGE_INDEX), new String[]{"name"}, new String[]{currentColumnName}, new AnnotationUtil.ANNOTATION_TYPE[]{AnnotationUtil.ANNOTATION_TYPE.STRING}));
                this.updateFieldType(model, foreignAttributeName, relationshipEntity.getEntityName(), annotations, new String[]{"javax.persistence.Column".substring(this.JPA_PACKAGE_INDEX)}, monitor);
                this.updateGetterSetterMethods(model, foreignAttributeName, currentTypeSignature, relationshipEntity.getEntityName(), monitor);
                this.deleteImport(model, Signature.createTypeSignature((String)"javax.persistence.Column", (boolean)true), monitor);
            }
        }
        return foreignAttributeName;
    }

    private void updateForJsfEntityList(JavaModel model, JpaEntityInfo entity, RelationshipMapping mapping, IProgressMonitor monitor) throws JavaModelException {
        if (mapping instanceof JavaMultiRelationshipMapping) {
            IField field;
            JavaMultiRelationshipMapping javaMapping = (JavaMultiRelationshipMapping)mapping;
            String attributeName = javaMapping.getPersistentAttribute().getName();
            IType type = model.getType();
            String initialFieldType = null;
            if (type != null && (field = type.getField(attributeName)).exists()) {
                initialFieldType = field.getTypeSignature();
            }
            this.addImport(model, "java.util.List", monitor);
            this.updateFieldType(model, attributeName, "List<" + Signature.getSimpleName((String)javaMapping.getTargetEntity()) + ">", null, monitor);
            this.updateGetterSetterMethods(model, attributeName, initialFieldType, "List<" + Signature.getSimpleName((String)javaMapping.getTargetEntity()) + ">", monitor);
        }
    }

    private void updateGetterSetterMethods(JavaModel model, String attributeName, String oldTypeSig, String newType, IProgressMonitor monitor) throws JavaModelException {
        String methodName = JpaUtil.getMethodName(attributeName, true);
        ReadMethodCommand readMethodCmd = new ReadMethodCommand();
        readMethodCmd.setIdentifier(methodName);
        readMethodCmd.execute(model, monitor);
        String methodContent = readMethodCmd.getContents();
        if (methodContent == null) {
            methodContent = "\treturn this." + attributeName + ";";
        }
        this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[0], new String[0], newType, readMethodCmd.getJavadoc(), methodContent, readMethodCmd.getAnnotations(), readMethodCmd.getThrowsClause(), monitor);
        methodName = JpaUtil.getMethodName(attributeName, false);
        readMethodCmd = new ReadMethodCommand();
        readMethodCmd.setIdentifier(methodName);
        readMethodCmd.setParameterNames(new String[]{attributeName});
        readMethodCmd.setParameters(new String[]{oldTypeSig});
        readMethodCmd.execute(model, monitor);
        this.deleteMethod(model, methodName, new String[]{attributeName}, new String[]{oldTypeSig}, monitor);
        methodContent = readMethodCmd.getContents();
        if (methodContent == null) {
            methodContent = "\tthis." + attributeName + " = " + attributeName + ";";
        }
        this.updateMethod(model, methodName, PUBLIC_MODIFIER, new String[]{Signature.createTypeSignature((String)newType, (boolean)false)}, new String[]{attributeName}, VOID_RETURN_TYPE, readMethodCmd.getJavadoc(), methodContent, readMethodCmd.getAnnotations(), readMethodCmd.getThrowsClause(), monitor);
    }

    private void updateMethod(JavaModel model, String methodName, String modifier, String[] parameters, String[] parameterNames, String returnType, JavaDocInfo javaDoc, String methodContents, List<Annotation> annotations, String throwsClause, IProgressMonitor monitor) throws JavaModelException {
        UpdateMethodCommand updateMethod = new UpdateMethodCommand();
        updateMethod.setIdentifier(methodName);
        updateMethod.setModifier(modifier);
        updateMethod.setParameters(parameters);
        updateMethod.setParameterNames(parameterNames);
        updateMethod.setReturnType(returnType);
        updateMethod.setForce(true);
        updateMethod.setJavadoc(javaDoc);
        updateMethod.setContents(methodContents);
        updateMethod.setAnnotations(annotations);
        updateMethod.setThrowsClause(throwsClause);
        updateMethod.setAddImports(false);
        updateMethod.execute(model, monitor);
    }

    private void updateRelationshipFetchTypeMapping(JavaModel model, RelationshipMapping mapping, String annotationName, IProgressMonitor monitor) throws JavaModelException {
        if (mapping instanceof JavaMultiRelationshipMapping) {
            ArrayList<Annotation> newAnnotations = new ArrayList<Annotation>();
            IType type = model.getType();
            String attributeName = mapping.getPersistentAttribute().getName();
            IField field = type.getField(attributeName);
            String fieldType = null;
            String[] paramTypes = null;
            String[] paramValues = null;
            AnnotationUtil.ANNOTATION_TYPE[] annotationType = null;
            if (field.exists()) {
                fieldType = field.getTypeSignature();
                IAnnotation oldAnnotation = field.getAnnotation(annotationName);
                IMemberValuePair[] pairs = oldAnnotation.getMemberValuePairs();
                paramTypes = new String[pairs.length];
                paramValues = new String[pairs.length];
                annotationType = new AnnotationUtil.ANNOTATION_TYPE[pairs.length];
                int i = 0;
                while (i < pairs.length) {
                    paramTypes[i] = pairs[i].getMemberName();
                    paramValues[i] = pairs[i].getValue().toString();
                    ++i;
                }
            }
            if (this.updateRelationshipFetchType == 2) {
                boolean found = false;
                int i = 0;
                while (i < paramTypes.length) {
                    if (paramTypes[i].equalsIgnoreCase("fetch")) {
                        paramValues[i] = "javax.persistence.FetchType.EAGER".substring(this.JPA_PACKAGE_INDEX);
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.NAME;
                        found = true;
                    } else if (paramTypes[i].equalsIgnoreCase("mappedBy")) {
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.STRING;
                    } else if (paramTypes[i].equalsIgnoreCase("targetEntity")) {
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.TYPE;
                    } else if (paramTypes[i].equalsIgnoreCase("cascade")) {
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.NAME;
                    }
                    ++i;
                }
                if (!found) {
                    String[] paramTypesFinal = new String[paramTypes.length + 1];
                    String[] paramValuesFinal = new String[paramTypes.length + 1];
                    AnnotationUtil.ANNOTATION_TYPE[] annotationTypeFinal = new AnnotationUtil.ANNOTATION_TYPE[paramTypes.length + 1];
                    int i2 = 0;
                    while (i2 < paramTypes.length) {
                        paramTypesFinal[i2] = paramTypes[i2];
                        paramValuesFinal[i2] = paramValues[i2];
                        annotationTypeFinal[i2] = annotationType[i2];
                        ++i2;
                    }
                    paramTypesFinal[paramTypesFinal.length - 1] = "fetch";
                    paramValuesFinal[paramTypesFinal.length - 1] = "javax.persistence.FetchType.EAGER".substring(this.JPA_PACKAGE_INDEX);
                    annotationTypeFinal[paramTypesFinal.length - 1] = AnnotationUtil.ANNOTATION_TYPE.NAME;
                    paramTypes = paramTypesFinal;
                    paramValues = paramValuesFinal;
                    annotationType = annotationTypeFinal;
                }
                newAnnotations.add((Annotation)AnnotationUtil.createNormalAnnotation(annotationName, paramTypes, paramValues, annotationType));
                this.addImport(model, "javax.persistence.FetchType", monitor);
                this.updateFieldType(model, attributeName, Signature.getSignatureSimpleName((String)fieldType), newAnnotations, new String[]{annotationName}, monitor);
            } else if (this.updateRelationshipFetchType == 1) {
                boolean found = false;
                int i = 0;
                while (i < paramTypes.length) {
                    if (paramTypes[i].equals("fetch")) {
                        paramValues[i] = "javax.persistence.FetchType.LAZY".substring(this.JPA_PACKAGE_INDEX);
                        found = true;
                    } else if (paramTypes[i].equalsIgnoreCase("mappedBy")) {
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.STRING;
                    } else if (paramTypes[i].equalsIgnoreCase("targetEntity")) {
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.TYPE;
                    } else if (paramTypes[i].equalsIgnoreCase("cascade")) {
                        annotationType[i] = AnnotationUtil.ANNOTATION_TYPE.NAME;
                    }
                    ++i;
                }
                if (!found) {
                    String[] paramTypesFinal = new String[paramTypes.length + 1];
                    String[] paramValuesFinal = new String[paramTypes.length + 1];
                    AnnotationUtil.ANNOTATION_TYPE[] annotationTypeFinal = new AnnotationUtil.ANNOTATION_TYPE[paramTypes.length + 1];
                    int i3 = 0;
                    while (i3 < paramTypes.length) {
                        paramTypesFinal[i3] = paramTypes[i3];
                        paramValuesFinal[i3] = paramValues[i3];
                        annotationTypeFinal[i3] = annotationType[i3];
                        ++i3;
                    }
                    paramTypesFinal[paramTypesFinal.length - 1] = "fetch";
                    paramValuesFinal[paramTypesFinal.length - 1] = "javax.persistence.FetchType.LAZY".substring(this.JPA_PACKAGE_INDEX);
                    annotationTypeFinal[paramTypesFinal.length - 1] = AnnotationUtil.ANNOTATION_TYPE.NAME;
                    paramTypes = paramTypesFinal;
                    paramValues = paramValuesFinal;
                    annotationType = annotationTypeFinal;
                }
                newAnnotations.add((Annotation)AnnotationUtil.createNormalAnnotation(annotationName, paramTypes, paramValues, annotationType));
                this.addImport(model, "javax.persistence.FetchType", monitor);
                this.updateFieldType(model, attributeName, Signature.getSignatureSimpleName((String)fieldType), newAnnotations, new String[]{annotationName}, monitor);
            }
        }
    }

    private class DateTimeConverter {
        public String resolvedType;
        public JpaAttributeInfo jpaAttribute;

        DateTimeConverter(JpaAttributeInfo attribute, String resolvedType) {
            this.jpaAttribute = attribute;
            this.resolvedType = resolvedType;
        }
    }
}

