/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation.quickfix.internal;

import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.jpa.annotation.quickfix.internal.ModifyAnnotationAttributeAbstractProposal;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.AnnotationUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.ManagerBeanUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.IDocument;

public class GenerateNamedQueryMethodProposal
extends ModifyAnnotationAttributeAbstractProposal {
    private String namedQueryName;
    private String namedQueryQuery;
    private IType managerBeanType;

    public GenerateNamedQueryMethodProposal(CompilationUnit cu, ASTNode annotationNode, int relevance, String annotationAttribute, String errorId, String namedQueryName, String namedQueryQuery) {
        super(cu, annotationNode, relevance, annotationAttribute);
        this.namedQueryName = namedQueryName;
        this.namedQueryQuery = namedQueryQuery;
    }

    public GenerateNamedQueryMethodProposal(IInvocationContext context, IType findPrimaryType, String targetNamedQuery, ASTNode parent, int relevance, String annotationMember, String errorId, String namedQueryName, String namedQueryQuery) {
        this(context.getASTRoot(), parent, relevance, annotationMember, errorId, namedQueryName, namedQueryQuery);
        this.managerBeanType = findPrimaryType;
        this.namedQueryName = targetNamedQuery;
    }

    public static void addTargetNamedQueryCorrection(IType managerBeanType, IProject project, String targetQueryName, IProgressMonitor monitor) {
        IMethod managerMethodForNamedQuery = NamedQueriesUtil.getManagerMethodForNamedQuery(managerBeanType, targetQueryName);
        if (managerMethodForNamedQuery != null) {
            try {
                managerMethodForNamedQuery.delete(true, monitor);
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            if (targetQueryName != null) {
                String targetEntityName = JpaUtil.getEntityNameFromType(managerBeanType);
                IProject managerBeanProject = JpaUtil.getManagerBeanProject(managerBeanType, project);
                IProject targetEntityProject = JpaUtil.getTargetEntityProject(managerBeanProject, targetEntityName);
                JpaManagerBeanInfo managerBeanInfo = new JpaManagerBeanInfo(new JpaEntityInfo(null, targetEntityName, targetEntityProject), managerBeanType, false);
                JpaUtil.fillManagerBeanWithEntityType(project, managerBeanInfo);
                List<JpaQueryMethodInfo> existingNamedQueries = NamedQueriesUtil.getExistingNamedQueries(managerBeanInfo);
                for (JpaQueryMethodInfo jpaQueryMethodInfo : existingNamedQueries) {
                    String queryName = jpaQueryMethodInfo.getQueryName();
                    if (!queryName.equals(targetQueryName)) continue;
                    JavaModel javaModel = JavaModelManager.getInstance().getModel("defaultjavamodel", managerBeanInfo.getProject(), managerBeanInfo.getManagerBeanPath());
                    javaModel.prepareCompilationUnit(monitor);
                    ManagerBeanUtil.addNamedQueryGetter(javaModel, managerBeanInfo, jpaQueryMethodInfo, monitor);
                    break;
                }
            }
        }
    }

    @Override
    public void apply(IDocument document) {
        GenerateNamedQueryMethodProposal.addTargetNamedQueryCorrection(this.managerBeanType, this.managerBeanType.getJavaProject().getProject(), this.namedQueryName, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getAdditionalProposalInfo() {
        return this.namedQueryQuery;
    }

    public String getDisplayString() {
        return "Generate Manager Bean Method for named query: " + this.namedQueryName;
    }

    @Override
    Expression getExpression(AST ast) {
        StringLiteral newExpression = AnnotationUtil.newStringLiteral(ast, this.namedQueryName);
        return newExpression;
    }
}

