/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation.marker.internal;

import com.ibm.etools.webtools.jpa.annotation.marker.internal.SelectTargetQueryMethodDialog;
import com.ibm.etools.webtools.jpa.annotation.quickfix.internal.ModifyTargetNamedQueryProposal;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.ITextEditor;

public class TargetNamedQueryMethodMarkerResolution
implements IMarkerResolution {
    private ICompilationUnit icu_;
    private ModifyTargetNamedQueryProposal proposal_;
    private int startOffset_;
    private int length_;
    private final IProject project;
    private final String errorId;
    private final String annotationMemberName;

    public TargetNamedQueryMethodMarkerResolution(ICompilationUnit icu, IMarker marker, IProject project, String annotationMemberName, String errorId, String queryName, String queryValue) throws CoreException {
        this.icu_ = icu;
        this.project = project;
        this.annotationMemberName = annotationMemberName;
        this.errorId = errorId;
    }

    public String getLabel() {
        return "Select existing named query";
    }

    public void run(IMarker marker) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(this.icu_);
        parser.setResolveBindings(true);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        try {
            this.startOffset_ = (Integer)marker.getAttribute("charStart");
            int end = (Integer)marker.getAttribute("charEnd");
            this.length_ = end - this.startOffset_;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ASTNode annotationNode = NodeFinder.perform((ASTNode)cu, (int)this.startOffset_, (int)this.length_).getParent();
        annotationNode = annotationNode.getParent();
        IType managerBeanType = null;
        if (annotationNode instanceof NormalAnnotation) {
            List annotationMembers = ((NormalAnnotation)annotationNode).values();
            int i = 0;
            while (i < annotationMembers.size()) {
                MemberValuePair valPair = (MemberValuePair)annotationMembers.get(i);
                try {
                    if (valPair.getName().getFullyQualifiedName().equals("targetEntityManager")) {
                        Expression expr = valPair.getValue();
                        TypeLiteral typeLiteral = (TypeLiteral)expr;
                        Type type = typeLiteral.getType();
                        String entity = type.toString();
                        IJavaProject javaProject = JavaCore.create((IProject)this.project);
                        if (javaProject == null || entity == null) break;
                        managerBeanType = javaProject.findType(entity);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                ++i;
            }
        }
        if (managerBeanType != null) {
            String selectedQueryName;
            SelectTargetQueryMethodDialog dlg = new SelectTargetQueryMethodDialog(Display.getDefault().getActiveShell(), managerBeanType, this.project, marker, this.errorId);
            dlg.open();
            if (dlg.getReturnCode() == 0 && (selectedQueryName = dlg.getSelectedQueryName()) != null) {
                this.proposal_ = new ModifyTargetNamedQueryProposal(cu, annotationNode, 99, this.annotationMemberName, this.errorId, selectedQueryName, "");
                IEditorPart part = EditorUtility.isOpenInEditor((Object)this.icu_);
                if (part == null) {
                    try {
                        part = JavaUI.openInEditor((IJavaElement)this.icu_, (boolean)true, (boolean)false);
                        if (part instanceof ITextEditor) {
                            ((ITextEditor)part).selectAndReveal(this.startOffset_, this.length_);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = JavaUI.getDocumentProvider().getDocument((Object)input);
                    this.proposal_.apply(doc);
                }
            }
        }
    }
}

