/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation;

import com.ibm.etools.webtools.jpa.codegen.ManagerBeanCodeGenOperation;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.jpa.web.Action;
import com.ibm.jpa.web.JPAManager;
import com.ibm.jpa.web.NamedQueryTarget;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.util.EclipseMessager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JPAManagerAnnotationProcessor
implements AnnotationProcessor {
    public static final String ERROR_TARGET_NAMED_QUERY_NOT_FOUND = "ERROR_TARGET_NAMED_QUERY_NOT_FOUND";
    public static final String ERROR_TARGET_NAMED_QUERY_INCONSISTENT = "ERROR_TARGET_NAMED_QUERY_INCONSISTENT";
    private ArrayList<String> namedQueryList;
    private IType type;
    private AnnotationProcessorEnvironment _env;

    public JPAManagerAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this._env = env;
    }

    private EclipseAnnotationProcessorEnvironment getEnvironment() {
        return (EclipseAnnotationProcessorEnvironment)this._env;
    }

    private void getNamedQuery(AnnotationMirror mirror, AnnotationTypeDeclaration declaration) {
        if (declaration.getQualifiedName() != null && declaration.getQualifiedName().equals("javax.persistence.NamedQuery")) {
            Map valueMap3 = mirror.getElementValues();
            Set valueSet3 = valueMap3.entrySet();
            for (Map.Entry annoKeyValue3 : valueSet3) {
                AnnotationValue annoValue3 = (AnnotationValue)annoKeyValue3.getValue();
                if (annoValue3 == null) continue;
                Object value3 = annoValue3.getValue();
                this.namedQueryList.add(value3.toString());
            }
        }
    }

    private String getTargetNamedQueries() {
        if (this.namedQueryList == null || this.namedQueryList.isEmpty()) {
            this.namedQueryList = new ArrayList();
            AnnotationTypeDeclaration annoDec = (AnnotationTypeDeclaration)this._env.getTypeDeclaration(JPAManager.class.getName());
            if (annoDec == null) {
                return null;
            }
            Collection annotatedDecls = this._env.getDeclarationsAnnotatedWith(annoDec);
            for (Declaration decl : annotatedDecls) {
                Collection mirrors = decl.getAnnotationMirrors();
                for (AnnotationMirror mirror : mirrors) {
                    AnnotationTypeDeclaration declaration;
                    if (mirror.getAnnotationType() == null || mirror.getAnnotationType().getDeclaration() == null || (declaration = mirror.getAnnotationType().getDeclaration()).getQualifiedName() == null || !declaration.getQualifiedName().equals(JPAManager.class.getName())) continue;
                    Map valueMap = mirror.getElementValues();
                    Set valueSet = valueMap.entrySet();
                    for (Map.Entry annoKeyValue : valueSet) {
                        AnnotationValue annoValue = (AnnotationValue)annoKeyValue.getValue();
                        Object value = annoValue.getValue();
                        if (value == null || !(value instanceof TypeDeclaration)) continue;
                        TypeDeclaration td = (TypeDeclaration)value;
                        Collection annotationMirrors = td.getAnnotationMirrors();
                        for (AnnotationMirror mirror2 : annotationMirrors) {
                            if (mirror2.getAnnotationType() == null || mirror2.getAnnotationType().getDeclaration() == null) continue;
                            AnnotationTypeDeclaration declaration2 = mirror2.getAnnotationType().getDeclaration();
                            if (declaration2.getQualifiedName() != null && declaration2.getQualifiedName().equals("javax.persistence.NamedQueries")) {
                                Map valueMap2 = mirror2.getElementValues();
                                Set valueSet2 = valueMap2.entrySet();
                                for (Map.Entry annoKeyValue2 : valueSet2) {
                                    Object value2;
                                    AnnotationValue annoValue2 = (AnnotationValue)annoKeyValue2.getValue();
                                    if (annoValue2 == null || !((value2 = annoValue2.getValue()) instanceof List)) continue;
                                    List vals = (List)value2;
                                    for (AnnotationValue annotationValue : vals) {
                                        AnnotationMirror mirror3;
                                        Object val = annotationValue.getValue();
                                        if (!(val instanceof AnnotationMirror) || (mirror3 = (AnnotationMirror)val).getAnnotationType() == null || mirror3.getAnnotationType().getDeclaration() == null) continue;
                                        AnnotationTypeDeclaration declaration3 = mirror3.getAnnotationType().getDeclaration();
                                        this.getNamedQuery(mirror3, declaration3);
                                    }
                                }
                                continue;
                            }
                            this.getNamedQuery(mirror2, declaration2);
                        }
                    }
                }
            }
            if (this.namedQueryList.isEmpty()) {
                IType jpaManagerBeanType = this.getType();
                List<JpaQueryMethodInfo> managerBeanNamedQueries = ManagerBeanCodeGenOperation.getManagerBeanNamedQueries(jpaManagerBeanType);
                for (JpaQueryMethodInfo jpaQueryMethodInfo : managerBeanNamedQueries) {
                    this.namedQueryList.add(jpaQueryMethodInfo.getQueryName());
                }
            }
        }
        return "";
    }

    private IType getType() {
        IJavaElement javaElement;
        CompilationUnit ast;
        if (this.type == null && (ast = this.getEnvironment().getAST()) != null && (javaElement = ast.getJavaElement()) != null && javaElement instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)javaElement;
            this.type = cu.findPrimaryType();
        }
        return this.type;
    }

    protected boolean isValidTarget(Declaration declaration) {
        return declaration instanceof MethodDeclaration;
    }

    public void process() {
        this.processNamedQueryTargetAnnotations();
        if (this.namedQueryList != null) {
            this.namedQueryList.clear();
        }
    }

    protected void processActionAnnotations() {
        Phase phase = this.getEnvironment().getPhase();
        if (phase == Phase.RECONCILE) {
            AnnotationTypeDeclaration annoDec = (AnnotationTypeDeclaration)this.getEnvironment().getTypeDeclaration(Action.class.getName());
            if (annoDec == null) {
                return;
            }
            Collection annotatedDecls = this._env.getDeclarationsAnnotatedWith(annoDec);
            if (annotatedDecls == null) {
                return;
            }
            for (Declaration decl : annotatedDecls) {
                if (!this.isValidTarget(decl)) continue;
                Collection mirrors = decl.getAnnotationMirrors();
                for (AnnotationMirror mirror : mirrors) {
                    if (!mirror.getAnnotationType().getDeclaration().getQualifiedName().equals(Action.class.getName())) continue;
                    Map valueMap = mirror.getElementValues();
                    Set valueSet = valueMap.entrySet();
                    for (Map.Entry annoKeyValue : valueSet) {
                        AnnotationValue annoValue = (AnnotationValue)annoKeyValue.getValue();
                        String actionName = annoValue.getValue().toString();
                        String actionType = null;
                        if (actionName.endsWith("UPDATE")) {
                            actionType = "Action.ACTION_TYPE.UPDATE";
                        } else if (actionName.endsWith("DELETE")) {
                            actionType = "Action.ACTION_TYPE.DELETE";
                        } else if (actionName.endsWith("CREATE")) {
                            actionType = "Action.ACTION_TYPE.CREATE";
                        } else if (actionName.endsWith("NEW")) {
                            actionType = "Action.ACTION_TYPE.NEW";
                        } else if (actionName.endsWith("FIND")) {
                            actionType = "Action.ACTION_TYPE.FIND";
                        }
                        if (actionType == null) continue;
                        IType iType = this.getType();
                    }
                }
            }
        }
    }

    private void processNamedQueryTargetAnnotations() {
        Messager messager = this._env.getMessager();
        AnnotationTypeDeclaration annoDec = (AnnotationTypeDeclaration)this._env.getTypeDeclaration(NamedQueryTarget.class.getName());
        if (annoDec == null) {
            return;
        }
        Collection annotatedDecls = this._env.getDeclarationsAnnotatedWith(annoDec);
        if (annotatedDecls == null) {
            return;
        }
        for (Declaration decl : annotatedDecls) {
            if (!this.isValidTarget(decl)) continue;
            Collection mirrors = decl.getAnnotationMirrors();
            for (AnnotationMirror mirror : mirrors) {
                if (!mirror.getAnnotationType().getDeclaration().getQualifiedName().equals(NamedQueryTarget.class.getName())) continue;
                Map valueMap = mirror.getElementValues();
                Set valueSet = valueMap.entrySet();
                for (Map.Entry annoKeyValue : valueSet) {
                    IMethod managerMethodForNamedQuery;
                    IType findPrimaryType;
                    AnnotationValue annoValue = (AnnotationValue)annoKeyValue.getValue();
                    this.getTargetNamedQueries();
                    String namedQueryTargetName = annoValue.getValue().toString();
                    if (!this.namedQueryList.contains(namedQueryTargetName)) {
                        EclipseMessager eclipseMessager = (EclipseMessager)messager;
                        eclipseMessager.printFixableWarning(annoValue.getPosition(), String.valueOf(namedQueryTargetName) + ": target named query not found.", "com.ibm.etools.webtools.jpa", ERROR_TARGET_NAMED_QUERY_NOT_FOUND);
                        continue;
                    }
                    Phase phase = this.getEnvironment().getPhase();
                    if (phase != Phase.RECONCILE || (findPrimaryType = this.getType()) == null || (managerMethodForNamedQuery = NamedQueriesUtil.getManagerMethodForNamedQuery(findPrimaryType, namedQueryTargetName)) == null || !managerMethodForNamedQuery.exists()) continue;
                    try {
                        String targetName;
                        int lastIndex;
                        String string = managerMethodForNamedQuery.getSource().toString();
                        int index = string.lastIndexOf("createNamedQuery");
                        if (index != -1) {
                            index = string.indexOf(String.valueOf('\"') + namedQueryTargetName + '\"', index);
                            if (index != -1) continue;
                            EclipseMessager eclipseMessager = (EclipseMessager)messager;
                            eclipseMessager.printFixableWarning(annoValue.getPosition(), "Generated code does not match named query in annotation: " + namedQueryTargetName, "com.ibm.etools.webtools.jpa", ERROR_TARGET_NAMED_QUERY_INCONSISTENT);
                            continue;
                        }
                        index = string.indexOf("createQuery");
                        if (index == -1 || (index = string.indexOf("NamedQueries.", index)) == -1 || (lastIndex = string.indexOf(")", index + 1)) == -1 || namedQueryTargetName.equals(targetName = string.substring(index + "NamedQueries.".length(), lastIndex).trim())) continue;
                        EclipseMessager eclipseMessager = (EclipseMessager)messager;
                        eclipseMessager.printFixableWarning(annoValue.getPosition(), "Generated code does not match named query in annotation: " + namedQueryTargetName, "com.ibm.etools.webtools.jpa", ERROR_TARGET_NAMED_QUERY_INCONSISTENT);
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

