/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.actions;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.actions.AbstractProjectAction;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaMsg;
import com.ibm.etools.webtools.jpa.util.FacetUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.JpaManagerBeanWizard;
import com.ibm.etools.webtools.jpa.wizard.model.JpaManagerBeanDataModelProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class JpaManagerBeanProjectAction
extends AbstractProjectAction {
    private IDataModel model;
    private Object[] fSelectedObjects;

    @Override
    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        this.fSelectedObjects = selection.toArray();
        return true;
    }

    protected IRunnableWithProgress getPrimeDataModelOperation() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        IProject project = ((IResource)JpaManagerBeanProjectAction.this.fSelectedObjects[0]).getProject();
                        monitor.beginTask(JpaMsg._Message_Loading_Entities, 5);
                        monitor.worked(1);
                        JpaManagerBeanDataModelProvider provider = new JpaManagerBeanDataModelProvider();
                        JpaManagerBeanProjectAction.this.model = DataModelFactory.createDataModel((IDataModelProvider)provider);
                        JpaManagerBeanProjectAction.this.model.setProperty("IJpaDataModelProperties.selectedProject", (Object)project);
                        monitor.worked(2);
                        IWorkbench workbench = JpaPlugin.getDefault().getWorkbench();
                        if (workbench != null) {
                            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                            JpaManagerBeanProjectAction.this.model.setProperty("IJpaManagerBeanDataModelProperties.targetPart", (Object)window.getActivePage().getActivePart());
                        }
                        JpaManagerBeanProjectAction.this.model.setBooleanProperty("IJpaDataModelProperties.isConfigure", false);
                        if (FacetUtil.isFacetDefinedOnProject(project, "jst.jsf")) {
                            JpaManagerBeanProjectAction.this.model.setStringProperty("IJpaDataModelProperties.generationType", "JSF");
                        } else {
                            JpaManagerBeanProjectAction.this.model.setStringProperty("IJpaDataModelProperties.generationType", "JSP");
                        }
                        boolean showAllProjects = JpaManagerBeanProjectAction.this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
                        List<JpaManagerBeanInfo> managerBeans = JpaUtil.createManagerBeanModels(project, showAllProjects);
                        JpaManagerBeanProjectAction.this.model.setProperty("IJpaDataModelProperties.availableSelections", managerBeans);
                        ArrayList<JpaManagerBeanInfo> selectedManagers = new ArrayList<JpaManagerBeanInfo>();
                        Object[] objectArray = JpaManagerBeanProjectAction.this.fSelectedObjects;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object resource = objectArray[n2];
                            IResource selectedFile = (IResource)resource;
                            if (!(selectedFile instanceof IProject)) {
                                for (JpaManagerBeanInfo managerBean : managerBeans) {
                                    if (!JpaUtil.getJavaResourceFromPersistentType(managerBean.getEntity().getPersistentType()).getFullPath().equals((Object)selectedFile.getFullPath())) continue;
                                    selectedManagers.add(managerBean);
                                    break;
                                }
                            }
                            ++n2;
                        }
                        JpaManagerBeanProjectAction.this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)selectedManagers.toArray());
                        monitor.worked(1);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        return runnable;
    }

    protected void primeDataModel() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress primeDataModelOp = this.getPrimeDataModelOperation();
        if (primeDataModelOp != null) {
            ProgressMonitorDialog pmDlg = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            pmDlg.run(false, false, primeDataModelOp);
        }
    }

    public void run(IAction action) {
        try {
            this.primeDataModel();
            if (this.model != null) {
                JpaManagerBeanWizard wizard = new JpaManagerBeanWizard(this.model);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.open();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

