dojo.require("com.ibm.enabler.debug");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.DateTextBox");
dojo.require("dijit.form.TimeTextBox");
dojo.require("dijit.form.NumberTextBox");
dojo.require("dijit.form.CurrencyTextBox");
dojo.require("dijit.form.Textarea");
dojo.require("dojo.i18n");


dojo.declare("evtGenScope", null,{ 
      // assumption is to use only one instance of this widget on a page.
      // risky to use global variables when another instance of this widget is used on the same page. 
      // TODO: use hidden HTML objects to store global data
      selectOptions: [],
      payloadHelper:[],
      resourceBundle: null,
		
	  onLoad : function() {
	     this.globalize();
	     
	     dojo.parser.parse(this.iContext.getElementById("topDiv"));	
	      
	     var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
         var widgetwrapper = widgetModel.find("testWidget");
         if (widgetwrapper.isLoaded()) {
        	 this.getEvents();
         }
         else {
        	 var eventService = com.ibm.mashups.services.ServiceManager.getService("eventService"); 
       	     var eventName = com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + ".testWidget";
       	     eventService.subscribeEvent(eventName, this, "getEvents");
         }
	  },
	  
	  globalize:function() {
	    dojo.registerModulePath("evtGenMessages_js", this.iContext.io.rewriteURI("."));
		var cs = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
		dojo.requireLocalization("evtGenMessages_js", "evtGenMessages", cs.getValue("locale"), cs.getValue("availableLocales"));
		try {
			this.resourceBundle = dojo.i18n.getLocalization("evtGenMessages_js", "evtGenMessages");
		} 
		catch (e) {
			dojo.requireLocalization("evtGenMessages_js", "evtGenMessages", "en", cs.getValue("availableLocales"));
			this.resourceBundle = dojo.i18n.getLocalization("evtGenMessages_js", "evtGenMessages", "en");
	    }
	    this.iContext.getElementById('addButton').value = this.resourceBundle.ADD_EVENT_BUTTON;
		this.iContext.getElementById('sendButton').value = this.resourceBundle.SEND_EVENTS;
	  },
	  
	  
	  // Store the dojo widgets to be rendered in an associative array for each payload type.
	  initPayloadHelper:function() {
	     if(this.payloadHelper.length < 1) {
	         this.payloadHelper['date'] = "dijit.form.DateTextBox";
	         this.payloadHelper['time'] = "dijit.form.TimeTextBox";
	         this.payloadHelper['number'] = "dijit.form.NumberTextBox";
	         this.payloadHelper['currency'] = "dijit.form.CurrencyTextBox";
	         this.payloadHelper['atom'] = "dijit.form.Textarea";
	         this.payloadHelper['json'] = "dijit.form.Textarea";
	         this.payloadHelper['xml'] = "dijit.form.Textarea";	         
	     }
	  },
      
                     
      // this function must be called only once on load.
      getEvents:function() {
          initWidget();
          
          var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
          var widgetwrapper = widgetModel.find("testWidget");
          var handledEvents = widgetwrapper.getWidgetHandledEvents();
          if(handledEvents == null) {
        	  console.log("No handled events !");
        	  minimize('min0', 'max0', 'genPane', 'content0');
        	  minimize('min1', 'max1', 'logPane', 'content1');
              return;
          }
                   
          this.initPayloadHelper();

          dojo.style('tableSpan', 'display', 'inline');
          
          this.selectOptions[0] = ['ALL', 'ANY'];
          // Get the list of all events that the test widget handles. Store it once globally.
          for (var i=0; i < handledEvents.length; i++) {
              var evtsObj = [handledEvents[i].name, handledEvents[i].type];
              this.selectOptions[i + 1] = evtsObj;
          }
          
          this.addRow();       
       },      
      
      // Initialize the OPTIONS for each SELECT object. 
      initSelect:function(selectObject, target) {
    	  for (var i=0; i < this.selectOptions.length; i++) {
    		  var elOptNew = document.createElement('option');
    		  elOptNew.text = this.selectOptions[i][0];
              elOptNew.value = this.selectOptions[i][1];
              if (target != null) {
                 if (elOptNew.text == target)
                    elOptNew.selected = true;
              }              
    		  try {
    			  selectObject.add(elOptNew, null); // standards compliant; doesn't work in IE
    		  }
    		  catch(ex) {
    			  selectObject.add(elOptNew); // IE only
    		  } 
    	  }    	  
      },
            
      // SELECT onChange triggers this. Gets the payload type associated with the event handler.
      getPayloadType:function(selectObject, rowNo) {
    	  var selIndex = selectObject.selectedIndex;         
          var selOptionValue = selectObject.options[selIndex].value;
          var eventType = this.iContext.getElementById("evtType" + rowNo);         
          eventType.innerHTML = selOptionValue;
          
          this.showPayloadHelper(rowNo, selOptionValue);        
      }, 
      
      // Based on the payload type, the input is switched to show the appropriate dojo widget.
      // For eg: if the payload type is 'date', the DateTextBox is rendered.
      showPayloadHelper:function(rowNo, payloadType, data) {
          if(!data) data = '';
          
          var parentCell = this.iContext.getElementById('widgetCell' + rowNo);
          var tempNode = document.createElement("SPAN");
          parentCell.appendChild(tempNode);
          
          var oldDijit = dijit.byId('dataBox' + rowNo);
          if (oldDijit != null) {
             oldDijit.destroyRecursive(false);
          } 
        
          var helper = this.payloadHelper[payloadType];
          if(helper == null) helper = "dijit.form.TextBox";
                             
          var objThinger = dojo.getObject(helper);
          var newWidget = new objThinger(
                     {id: "dataBox" + rowNo,
                     style:"width:100%"}, tempNode);
          newWidget.startup();
          
          newWidget.attr('value', data);
          newWidget.focus();
        
          return newWidget.domNode;         
      },     
     
      // create wire to send from this row.
      wire:function(widgetInstance, selectObject) {
         if (selectObject == null) return;
         
         eventName = "sendEvent";
          
         var selIndex = selectObject.selectedIndex;         
         var selOptionText = selectObject.options[selIndex].text;
         
         if (selOptionText == "ALL") {
            for(i=1; i< selectObject.options.length; i++) {
               widgetInstance.addWire("generator", eventName, selectObject.options[i].text);
            }
         }
         else {
            widgetInstance.addWire("generator", eventName, selOptionText);
         }
         this.commitModel();
       },
       
       //remove the wire just created.
       removeWires:function(widgetInstance, selectObject) {
    	   if (selectObject == null) return;

    	   eventName = "sendEvent";

    	   var selIndex = selectObject.selectedIndex;         
    	   var selOptionText = selectObject.options[selIndex].text;

    	   if (selOptionText == "ALL") {
    		   for(i=1; i< selectObject.options.length; i++) {
    			   try {
    				   widgetInstance.removeWire("generator", eventName, selectObject.options[i].text);
    			   }
    			   catch (ex) {
    				   console.log(ex);
    			   }
    		   }
    	   }
    	   else {        	 
    		   try {
    			   widgetInstance.removeWire("generator", eventName, selOptionText);
    		   }
    		   catch (ex) {
    			   console.log(ex);
    		   }
    	   }

    	   this.commitModel();
        },
       
     
      // triggered by Send button.
      // create a wire for each row of data and fire the event.
      sendData:function(){ 
    	  var rows = this.iContext.getElementById("tableBody").getElementsByTagName("TR");
    	  var context = this.iContext;
    	  
    	  var widgetInstance = this.getWidgetInstance();
    	      	  
    	  for (var i=0; i < rows.length; i++) {
    		 var rowId = rows[i].id;
    		 
    	     var selectObject = this.iContext.getElementById("selectEvt" + rowId);    	     
    		 if(selectObject.disabled) continue;
    		 
    	     var selIndex = selectObject.selectedIndex;         
             var selOptionText = selectObject.options[selIndex].text;
             var selOptionValue = selectObject.options[selIndex].value
             
    	     this.wire(widgetInstance, selectObject);
             var data = dijit.byId("dataBox" + rowId).attr("value");           
             this.iContext.iEvents.fireEvent("sendEvent", null, data);
             this.iContext.iEvents.fireEvent("sendCustomEvent", null, [selOptionText, selOptionValue, data] );
             this.removeWires(widgetInstance, selectObject);
    	  }            
       },
       
       getWidgetInstance:function(){
    	   var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
    	   var widgetwrapper = widgetModel.find("testWidget");
    	   var widgetInstance = widgetwrapper.getIWidgetInstance();
    	   return widgetInstance;
       },
       
       commitModel:function(){
    	   com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel().commit(); 
       },

	   // returns a new unique rowId for each row added.
	   // called only once when the row is added.
	   getRowId:function() {
	       return (new Date()).getTime();
	   },       
     
     // used by Add Row button and programmatic Resend
     // TODO: consider using dojo.create. Maybe cleaner ?
     addRow: function(target, payload, data)  {
         if(!target) target = "ALL";
         if(!payload) payload = "ANY";
         if(!data) data = "";
         var rowId = this.getRowId();
         
    	 var tbody = this.iContext.getElementById("evtTable").getElementsByTagName("tbody")[0];
    	 var row = document.createElement("TR");
    	 row.id = rowId + '';
    	 
    	 var cell0 = document.createElement("TD");
    	 cell0.style['width'] = "10px";
    	 cell0.innerHTML = '<input type="checkbox" class="checkClass" checked onclick="_generator_iContext.scope.disableRow(' + rowId + ')" />';
    	 
    	 var cell1 = document.createElement("TD");
    	 cell1.style['width'] = "20%";
    	 var selectNode = this.newSelectNode(rowId);
    	 cell1.appendChild(selectNode);
    	 
    	 var cell2 = document.createElement("TD");  
    	 cell2.style['fontStyle'] = "italic"; 
    	 cell2.style['width'] = "10%";
    	 cell2.style['textAlign'] = "center";
    	 cell2.innerHTML = '<span id="evtType' + rowId + '">' + payload + '</span>' ;	 
         
    	 var cell3 = document.createElement("TD");
    	 cell3.id = "widgetCell" + rowId;
    	 
         var cell4 = document.createElement("TD");         
    	 cell4.innerHTML = '<img src="widgets/icons/delete.gif" onclick="_generator_iContext.scope.deleteRow(' + rowId + ')" />';    	 
    	 row.appendChild(cell0);
    	 row.appendChild(cell1);
    	 row.appendChild(cell2);
    	 row.appendChild(cell3);
    	 row.appendChild(cell4);
    	 tbody.appendChild(row);
    	 
    	 this.initSelect(selectNode, target);
    	 this.showPayloadHelper(rowId, payload, data);
    	      	 
     },    
     
     // create a SELECT object and wire it's onchange listener.
     newSelectNode:function(rowId) {
    	 var selectNode = document.createElement("SELECT");
    	 selectNode.id = "selectEvt" + rowId;
    	 
         var self = this;
         try {
        	 selectNode.addEventListener("change", function(){self.getPayloadType(selectNode, rowId)}, false);
		  }
		  catch(ex) {
			  selectNode.attachEvent("onchange", function(){ self.getPayloadType(selectNode, rowId); });
		  }
    	 return selectNode;
     },
     
     // Delete each row using the trashcan image/button
     deleteRow:function(rowNo) {
    	    var rows = this.iContext.getElementById("tableBody").getElementsByTagName("TR");
    	    var rowIndex = 1;
    	    for (var i=0; i < rows.length; i++) {
       		   var rowId = rows[i].id;
       		   if(rowNo + '' == rowId + '') {
       			   rowIndex = (+i) + 1;
       			   break;
       		   }
    	    }
    	    this.iContext.getElementById('evtTable').deleteRow(rowIndex);
            this.iContext.iEvents.removeEvent("sendEvent" + rowId);
     },
     
     // Enable/disable each row using the checkbox
     disableRow:function(rowNo) {
    	    var row = this.iContext.getElementById(rowNo);
    	    //row.disabled = !row.disabled;
    	    var selectObject = this.iContext.getElementById("selectEvt" + rowNo);
    	    selectObject.disabled = !selectObject.disabled;
            var inputDijit = dijit.byId('dataBox' + rowNo);
            isDisabled = inputDijit.attr("disabled");
            inputDijit.attr("disabled", !isDisabled);
            
            if(selectObject.disabled)
               this.iContext.getElementById("checkAll").checked = false; 	    
     },
     
     checkAll:function(mainCheck) {
        var checks = this.iContext.getElementById("evtTable").getElementsByTagName("input");
        for(var i=0; i< checks.length; i++) {
            if(checks[i].className != "checkClass")
                continue;
                
            if (checks[i].checked == mainCheck.checked)
               continue;
               
            if(document.createEventObject){
               checks[i].checked = mainCheck.checked;
               checks[i].fireEvent('onclick');
             }
             else if(document.createEvent) {               
                var clickevent=document.createEvent("MouseEvents");
                clickevent.initEvent("click", true, true);            
                checks[i].dispatchEvent(clickevent);
            }
        }
     },
     
     deleteAllRows:function() {
         var confirmed = confirm("Delete all rows ?");
         if(!confirmed) return;
         
         var rows = this.iContext.getElementById("tableBody").getElementsByTagName("TR");
         for (var i=rows.length; i > 0; i--) {
             this.deleteRow(rows[i-1].id);
         }
     }
});
