dojo.require("com.ibm.enabler.debug");
dojo.require("dojox.grid.DataGrid");
dojo.require("dojo.data.ItemFileWriteStore");
	
dojo.declare("eventExplorer", null,{ 
	selectOptions: [],
	resourceBundle: null,
	
     onLoad:function() { 
	    this.globalize();
	    
        if(this.iContext.getiWidgetAttributes().getItemValue("generatorLog") == "true") {
           var resend = this.iContext.getElementById("resend");
           dojo.style('resend', 'display', 'inline');
           
	        // set the layout structure:
	        var layout = [
	            { field: 'time', name: 'Time', width: '10%' },
	            { field: 'src', name: 'Event Target', width: '20%'},
	            { field: 'payload', name: 'Payload Type', hidden: true},
	            { field: 'data', name: 'Data', width: '70%'}
	        ];
        } 
        else {        
	        // set the layout structure:
	        var layout = [
	            { field: 'time', name: 'Time', width: '10%' },
	            //{ field: 'src', name: 'Event Source'},
	            { field: 'data', name: 'Data', width: 'auto'}
	        ];
        }
             
        var myStore = new dojo.data.ItemFileWriteStore(
                {data: {
	                    "identifier":"time", 
	                    "label":"time", 
	                    "items":[
	                        //{time: '123', src: 'all', data: 'foo'}
	                     ]
                      }
                 });
                 
        // create a new grid:
        var grid = new dojox.grid.DataGrid({
            store: myStore,
            clientSort: true,
            rowSelector: '0px',
            structure: layout
        }, document.createElement('div'));

        // append the new grid to the div "gridContainer":
        this.iContext.getElementById("gridContainer").appendChild(grid.domNode);
        var paneId = this.iContext.getiWidgetAttributes().getItemValue("paneId");
        if (!paneId) {
          dojo.connect(dijit.byId(paneId), "resize", grid, function() {
            grid.resize();
          });
        }

        // Call startup, in order to render the grid:
        grid.startup();      
      },
      
      getGrid:function() {
	      var divEl = this.iContext.getElementByClass("dojoxGrid");
		  return dijit.byNode(divEl[0]);
	  },
      
      getStore:function() {
	      return this.getGrid().store;
	  },
	  
	  globalize:function() {
	    dojo.registerModulePath("evtExpMessages_js", this.iContext.io.rewriteURI("."));
		var cs = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
			dojo.requireLocalization("evtExpMessages_js", "evtExpMessages", cs.getValue("locale"), cs.getValue("availableLocales"));
			try {
				this.resourceBundle = dojo.i18n.getLocalization("evtExpMessages_js", "evtExpMessages");
			} 
			catch (e) {
				dojo.requireLocalization("evtExpMessages_js", "evtExpMessages", "en", cs.getValue("availableLocales"));
				this.resourceBundle = dojo.i18n.getLocalization("evtExpMessages_js", "evtExpMessages", "en");
	    }
	    this.iContext.getElementById('clearButton').value = this.resourceBundle.CLEAR;
	    this.iContext.getElementById('resendButton').value = this.resourceBundle.RESEND;
	  },
      
	  onReceiveData:function(iEvent){
	       var date = new Date();
	       var timeStamp = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds()
	       
	       var store = this.getStore();
	        
		   var data = iEvent.payload;
			   
	      if(this.iContext.getiWidgetAttributes().getItemValue("generatorLog") == "true") {
	         var evtSource = data[0];
	         var payloadType = data[1];
	         var evtPayload = data[2];
	         store.newItem({time: timeStamp, src: evtSource, payload: payloadType, data: evtPayload });	         
	      }
	      else {
			  var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
	          var widgetwrapper = widgetModel.find(this.iContext.widgetId);
	          for(var i=0; i < widgetwrapper.getWires(); i++) {
	             var wire = wires[i];             
	          }
	          var evtSource = iEvent.source;
	          
	          var evtPayload = null;
	          if (dojo.isString(data)) 
		         evtPayload = data;
		      else if (dojo.isString(data.value)) 
		          evtPayload = data.value;
		      else if (dojo.isString(data.toString()))
		          evtPayload = data.toString();
		      
		      store.newItem({time: timeStamp, data: evtPayload });		      
          }         
          	
          store.save({onComplete: this.saveDone, onError: this.saveFailed});  
          this.getGrid().update();
           
          // hack to sleep for 1 second and wait for newItem() to complete
          var startTime = (new Date()).getTime();
          for (tt=0; tt < startTime + 1000; ) {
              tt = (new Date()).getTime();
          }	 
	  },
	    
	  saveDone:function() {
	    //alert("saved");
	  },
	  
	  saveFailed:function() {
	    alert("error");
	  },
	  
	  clearLog:function() {
	      var store = this.getStore();
	      
	     deleteAll = function(items, request) {
	         for (var i = 0; i < items.length; i++){
                 store.deleteItem(items[i]);
             }            
             store.save({onComplete: this.saveDone, onError: this.saveFailed});	  
	      }
	      var request = store.fetch({query: {}, onComplete: deleteAll });
	  },
	  
	  resend:function() {
		var self = this;
	    var grid = this.getGrid();
	    var items = grid.selection.getSelected();
        if(items.length){
        	var widgetInstance = this.getWidgetInstance();
            dojo.forEach(items, function(selectedItem) {
            	if(selectedItem !== null) {
                	var evtTarget = grid.store.getValue(selectedItem, 'src');                                         
                	self.wire(widgetInstance, evtTarget);
                	var data = grid.store.getValue(selectedItem, 'data');                                         
                	self.iContext.iEvents.fireEvent("resendEvent", null, data);
                	self.removeWires(widgetInstance, evtTarget);
                } // end if
            }); // end forEach
        } // end if              
	  },
	  
	// create wire to send from this row.
      wire:function(widgetInstance, evtTarget) {         
		  if(this.selectOptions.length < 1) {
			   this.getEvents();
		  }
		          
         eventName = "resendEvent";
         if (evtTarget == "ALL") {
            for(i=0; i< this.selectOptions.length; i++) {            	
               widgetInstance.addWire("explorer2", eventName, this.selectOptions[i]);
            }
         }
         else {
            widgetInstance.addWire("explorer2", eventName, evtTarget);
         }
         this.commitModel();
       },
       
       
       //remove wire to send from this row.
       removeWires:function(widgetInstance, evtTarget) {       
          eventName = "resendEvent";
          
          // remove old wires
          if (evtTarget == "ALL") {            
        	  for(i=0; i< this.selectOptions.length; i++) {
        		  try {
        			  widgetInstance.removeWire("explorer2", eventName, this.selectOptions[i]);
        		  }
        		  catch (ex) {
        			  console.log(ex);
        		  }
        	  }
          }
          else {        	 
        	  try {
        		  widgetInstance.removeWire("explorer2", eventName, evtTarget);
        	  }
        	  catch (ex) {
        		  console.log(ex);
        	  }
          }
          this.commitModel();
        },
        
        getWidgetInstance:function(){
     	   var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
     	   var widgetwrapper = widgetModel.find("testWidget");
     	   var widgetInstance = widgetwrapper.getIWidgetInstance();
     	   return widgetInstance;
        },
        
        commitModel:function(){
     	   com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel().commit(); 
        },
       
       getEvents:function() { 
    	   if(this.selectOptions.length > 0) {
    		   return;
    	   }
    	   
           var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
           var widgetwrapper = widgetModel.find("testWidget");
           var handledEvents = widgetwrapper.getWidgetHandledEvents();
           if(handledEvents == null) {
             return;
           }
           
           // Get the list of all events that the test widget handles. Store it once globally.
           for (var i=0; i < handledEvents.length; i++) {
        	   this.selectOptions[i] = handledEvents[i].name
           }           
        }   
	  
});