var initialContents = null;
var count = 0;
var collapsed = [];
collapsed['genPane'] = ["genPane", '33'];      
collapsed['logPane'] = ["logPane", '33'];
collapsed['expPane'] = ["expPane", '33'];

function initWidget() { 
       var spanEl = document.getElementById("testWidget");
       initialContents = spanEl.innerHTML;
       
       // an ugly hack to refresh the splitContainer with desired sizeShares.
       // without this, the first minimize collapses everybody
       maximize('max0', 'min0', 'genPane', 'content0');
       maximize('max1', 'min1', 'logPane', 'content1');
       maximize('max2', 'min2', 'expPane', 'content2');
       dijit.byId("splitCont").layout(); 
       count = 0;       
       // end hack
                
       var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
       var widgetwrapper = widgetModel.find("testWidget"); 

       var deferred = widgetwrapper.getIWidgetDefinition();
       deferred.setFinishedCallback(initModesCallBack);
       deferred.start();
     
       var publishedEvents = widgetwrapper.getWidgetPublishedEvents();
       if(!publishedEvents) {
           console.log("No published events");
    	   minimize('min2', 'max2', 'expPane', 'content2');
           return;      
       }
              
       var explorerWidgetWrapper = widgetModel.find("explorer");
       if (explorerWidgetWrapper.isLoaded()) {
    	   wireExplorer();      	 
       }
       else {
    	   var eventService = com.ibm.mashups.services.ServiceManager.getService("eventService"); 
    	   var eventName = com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + ".explorer";
    	   eventService.subscribeEvent(eventName, this, "wireExplorer"); 
       }
    }
    
     function wireExplorer() {
    	 var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();  
         var widgetwrapper = widgetModel.find("testWidget");
 		 var publishedEvents = widgetwrapper.getWidgetPublishedEvents();
 	       if(!publishedEvents) {
 	           console.log("No published events");
 	           return;      
 	       }
 	       
 		  var explorerWidgetInstance = widgetModel.find("explorer").getIWidgetInstance();
 	       for (i=0; i < publishedEvents.length; i++) {
 	           try {
 	              explorerWidgetInstance.addWire("testWidget",  publishedEvents[i].name, "receiveEvent");
 	           }
 	           catch(ex) {
 	              console.error(ex);
 	           }   
 	       } 
 	       widgetModel.commit();
 	  }
    

    function initModesCallBack(widgetDef, status) {
        var specObject = widgetDef.toSpecObject();
        dojo.byId("widgetLink").innerHTML = specObject._id;
         
    	var supportedModes = widgetDef.getSupportedModes(); 
        if(supportedModes.length < 2) {           
     	   //dojo.style('modeSpan', "display", "none");     	   
     	   return;
        } 
        var menu = new dijit.Menu({ style: "display: none;"});
        for(var i=0; i < supportedModes.length; i++) {    	
            var menuItem = new dijit.MenuItem({
                label: supportedModes[i],
                onClick: function(){ 
                    _testWidget_iContext.iEvents.fireEvent("onModeChanged", null, "{'newMode':'" + this.label +"'}"); 
                }
            });
            menu.addChild(menuItem);
        }

        var button = new dijit.form.DropDownButton({
            label: "Modes",
            name: "Modes",
            dropDown: menu,
            iconClass: "showModes",
            showLabel:false,
            id: "modesButton"
        });
        dojo.byId("dropdownButtonContainer").appendChild(button.domNode);
    }

    function refreshWidget() {
         //console.log(document.getElementById("testWidget").innerHTML);
         document.getElementById("testWidget").innerHTML = initialContents;
    }

    function minimize(oldButtonId, newButtonId, paneId, contentId) { 	
    	collapsed[paneId][1] = 0;
        count++;
        
        if(count == 3 ) {
           dojo.byId('blankPane').style.display = "inline";
           dijit.byId('blankPane').sizeShare = 100;
        }                
        
    	// even though 100ms is barely fast enough to see, fadeOut still needs 
    	// to be called so that fadeIn will work
        dojo.fadeOut({node: dojo.byId(contentId), duration: 100, onEnd: function() {	        
		        setSizeShare();		
		        dojo.byId(contentId).style.display = "none";
		        
		        // hide this button and show newButton
		        flipNodeDisplay(oldButtonId, newButtonId);
        	}
        }).play();              
    }

    function maximize(oldButtonId, newButtonId, paneId, contentId) {
        collapsed[paneId][1] = 33;
        
        dijit.byId('blankPane').sizeShare = 0;
        dojo.byId('blankPane').style.display = "none";

        setSizeShare();        
 
        dojo.byId(contentId).style.display = "inline";
        dojo.fadeIn({node: dojo.byId(contentId), duration: 500}).play();

		// hide this button and show newButton
        flipNodeDisplay(oldButtonId, newButtonId);
        count--;
    }
    
    // when the widgets are auto-minimized, it sets the sizeshare of the 
    // maximized widget to an arbitrary large value.
    // Hence the need to save state and set sizeshare for all widgets.
    function setSizeShare() {
        for (i in collapsed) {
          var pane = collapsed[i][0];
          dijit.byId(pane).sizeShare = collapsed[i][1];
        } 
        dijit.byId("splitCont").layout();
    }
    
    function flipNodeDisplay(idToHide, idToShow) {
    	dojo.byId(idToHide).style.display = "none";
        dojo.byId(idToShow).style.display = "inline";
    }