if(!window["OpenAjax"]){
OpenAjax=new function(){
this.hub={};
var h=this.hub;
h.implementer="http://openajax.org";
h.implVersion="2.0";
h.specVersion="2.0";
h.implExtraData={};
var _2={};
h.libraries=_2;
var _3="org.openajax.hub.";
h.registerLibrary=function(_4,_5,_6,_7){
_2[_4]={prefix:_4,namespaceURI:_5,version:_6,extraData:_7};
this.publish(_3+"registerLibrary",_2[_4]);
};
h.unregisterLibrary=function(_8){
this.publish(_3+"unregisterLibrary",_2[_8]);
delete _2[_8];
};
};
OpenAjax.hub.Error={BadParameters:"OpenAjax.hub.Error.BadParameters",Disconnected:"OpenAjax.hub.Error.Disconnected",Duplicate:"OpenAjax.hub.Error.Duplicate",NoContainer:"OpenAjax.hub.Error.NoContainer",NoSubscription:"OpenAjax.hub.Error.NoSubscription",NotAllowed:"OpenAjax.hub.Error.NotAllowed",WrongProtocol:"OpenAjax.hub.Error.WrongProtocol"};
OpenAjax.hub.SecurityAlert={LoadTimeout:"OpenAjax.hub.SecurityAlert.LoadTimeout",FramePhish:"OpenAjax.hub.SecurityAlert.FramePhish",ForgedMsg:"OpenAjax.hub.SecurityAlert.ForgedMsg"};
OpenAjax.hub._debugger=function(){
};
OpenAjax.hub.ManagedHub=function(_9){
if(!_9||!_9.onPublish||!_9.onSubscribe){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
this._p=_9;
this._onUnsubscribe=_9.onUnsubscribe?_9.onUnsubscribe:null;
this._scope=_9.scope||window;
if(_9.log){
var _a=this._scope;
var _b=_9.log;
this._log=function(_c){
_b.call(_a,"ManagedHub: "+_c);
};
}else{
this._log=function(){
};
}
this._subscriptions={c:{},s:null};
this._containers={};
this._seq=0;
this._active=true;
this._isPublishing=false;
this._pubQ=[];
};
OpenAjax.hub.ManagedHub.prototype.subscribeForClient=function(_d,_e,_f){
this._assertConn();
if(this._invokeOnSubscribe(_e,_d)){
return this._subscribe(_e,this._sendToClient,this,{c:_d,sid:_f});
}
throw new Error(OpenAjax.hub.Error.NotAllowed);
};
OpenAjax.hub.ManagedHub.prototype.unsubscribeForClient=function(_10,_11){
this._unsubscribe(_11);
this._invokeOnUnsubscribe(_10,_11);
};
OpenAjax.hub.ManagedHub.prototype.publishForClient=function(_12,_13,_14){
this._assertConn();
this._publish(_13,_14,_12);
};
OpenAjax.hub.ManagedHub.prototype.disconnect=function(){
this._active=false;
for(var c in this._containers){
this.removeContainer(this._containers[c]);
}
};
OpenAjax.hub.ManagedHub.prototype.getContainer=function(_16){
var _17=this._containers[_16];
return _17?_17:null;
};
OpenAjax.hub.ManagedHub.prototype.listContainers=function(){
var res=[];
for(var c in this._containers){
res.push(this._containers[c]);
}
return res;
};
OpenAjax.hub.ManagedHub.prototype.addContainer=function(_1a){
this._assertConn();
var _1b=_1a.getClientID();
if(this._containers[_1b]){
throw new Error(OpenAjax.hub.Error.Duplicate);
}
this._containers[_1b]=_1a;
};
OpenAjax.hub.ManagedHub.prototype.removeContainer=function(_1c){
var _1d=_1c.getClientID();
if(!this._containers[_1d]){
throw new Error(OpenAjax.hub.Error.NoContainer);
}
_1c.remove();
delete this._containers[_1d];
};
OpenAjax.hub.ManagedHub.prototype.subscribe=function(_1e,_1f,_20,_21,_22){
this._assertConn();
this._assertSubTopic(_1e);
if(!_1f){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
if(!this._invokeOnSubscribe(_1e,null)){
this._invokeOnComplete(_21,_20,null,false,OpenAjax.hub.Error.NotAllowed);
return;
}
_20=_20||window;
var _23=this;
function _24(_25,_26,sd,_28){
if(_23._invokeOnPublish(_25,_26,_28,null)){
try{
_1f.call(_20,_25,_26,_22);
}
catch(e){
OpenAjax.hub._debugger();
_23._log("caught error from onData callback to Hub.subscribe(): "+e.message);
}
}
};
var _29=this._subscribe(_1e,_24,_20,_22);
this._invokeOnComplete(_21,_20,_29,true);
return _29;
};
OpenAjax.hub.ManagedHub.prototype.publish=function(_2a,_2b){
this._assertConn();
this._assertPubTopic(_2a);
this._publish(_2a,_2b,null);
};
OpenAjax.hub.ManagedHub.prototype.unsubscribe=function(_2c,_2d,_2e){
this._assertConn();
if(typeof _2c==="undefined"||_2c==null){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
this._unsubscribe(_2c);
this._invokeOnUnsubscribe(null,_2c);
this._invokeOnComplete(_2d,_2e,_2c,true);
};
OpenAjax.hub.ManagedHub.prototype.isConnected=function(){
return this._active;
};
OpenAjax.hub.ManagedHub.prototype.getScope=function(){
return this._scope;
};
OpenAjax.hub.ManagedHub.prototype.getSubscriberData=function(_2f){
this._assertConn();
var _30=_2f.split(".");
var sid=_30.pop();
var sub=this._getSubscriptionObject(this._subscriptions,_30,0,sid);
if(sub){
return sub.data;
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
OpenAjax.hub.ManagedHub.prototype.getSubscriberScope=function(_33){
this._assertConn();
var _34=_33.split(".");
var sid=_34.pop();
var sub=this._getSubscriptionObject(this._subscriptions,_34,0,sid);
if(sub){
return sub.scope;
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
OpenAjax.hub.ManagedHub.prototype.getParameters=function(){
return this._p;
};
OpenAjax.hub.ManagedHub.prototype._sendToClient=function(_37,_38,sd,_3a){
if(!this.isConnected()){
return;
}
if(this._invokeOnPublish(_37,_38,_3a,sd.c)){
sd.c.sendToClient(_37,_38,sd.sid);
}
};
OpenAjax.hub.ManagedHub.prototype._assertConn=function(){
if(!this.isConnected()){
throw new Error(OpenAjax.hub.Error.Disconnected);
}
};
OpenAjax.hub.ManagedHub.prototype._assertPubTopic=function(_3b){
if((_3b==null)||(_3b=="")||(_3b.indexOf("*")!=-1)||(_3b.indexOf("..")!=-1)||(_3b.charAt(0)==".")||(_3b.charAt(_3b.length-1)==".")){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
};
OpenAjax.hub.ManagedHub.prototype._assertSubTopic=function(_3c){
if(!_3c){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
var _3d=_3c.split(".");
var len=_3d.length;
for(var i=0;i<len;i++){
var p=_3d[i];
if((p=="")||((p.indexOf("*")!=-1)&&(p!="*")&&(p!="**"))){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
if((p=="**")&&(i<len-1)){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
}
};
OpenAjax.hub.ManagedHub.prototype._invokeOnComplete=function(_41,_42,_43,_44,_45){
if(_41){
try{
_42=_42||window;
_41.call(_42,_43,_44,_45);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onComplete callback: "+e.message);
}
}
};
OpenAjax.hub.ManagedHub.prototype._invokeOnPublish=function(_46,_47,_48,_49){
try{
return this._p.onPublish.call(this._scope,_46,_47,_48,_49);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onPublish callback to constructor: "+e.message);
}
return false;
};
OpenAjax.hub.ManagedHub.prototype._invokeOnSubscribe=function(_4a,_4b){
try{
return this._p.onSubscribe.call(this._scope,_4a,_4b);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onSubscribe callback to constructor: "+e.message);
}
return false;
};
OpenAjax.hub.ManagedHub.prototype._invokeOnUnsubscribe=function(_4c,_4d){
if(this._onUnsubscribe){
var _4e=_4d.slice(0,_4d.lastIndexOf("."));
try{
this._onUnsubscribe.call(this._scope,_4e,_4c);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onUnsubscribe callback to constructor: "+e.message);
}
}
};
OpenAjax.hub.ManagedHub.prototype._subscribe=function(_4f,_50,_51,_52){
var _53=_4f+"."+this._seq;
var sub={scope:_51,cb:_50,data:_52,sid:this._seq++};
var _55=_4f.split(".");
this._recursiveSubscribe(this._subscriptions,_55,0,sub);
return _53;
};
OpenAjax.hub.ManagedHub.prototype._recursiveSubscribe=function(_56,_57,_58,sub){
var _5a=_57[_58];
if(_58==_57.length){
sub.next=_56.s;
_56.s=sub;
}else{
if(typeof _56.c=="undefined"){
_56.c={};
}
if(typeof _56.c[_5a]=="undefined"){
_56.c[_5a]={c:{},s:null};
this._recursiveSubscribe(_56.c[_5a],_57,_58+1,sub);
}else{
this._recursiveSubscribe(_56.c[_5a],_57,_58+1,sub);
}
}
};
OpenAjax.hub.ManagedHub.prototype._publish=function(_5b,_5c,_5d){
if(this._isPublishing){
this._pubQ.push({t:_5b,d:_5c,p:_5d});
return;
}
this._safePublish(_5b,_5c,_5d);
while(this._pubQ.length>0){
var pub=this._pubQ.shift();
this._safePublish(pub.t,pub.d,pub.p);
}
};
OpenAjax.hub.ManagedHub.prototype._safePublish=function(_5f,_60,_61){
this._isPublishing=true;
var _62=_5f.split(".");
this._recursivePublish(this._subscriptions,_62,0,_5f,_60,_61);
this._isPublishing=false;
};
OpenAjax.hub.ManagedHub.prototype._recursivePublish=function(_63,_64,_65,_66,msg,_68){
if(typeof _63!="undefined"){
var _69;
if(_65==_64.length){
_69=_63;
}else{
this._recursivePublish(_63.c[_64[_65]],_64,_65+1,_66,msg,_68);
this._recursivePublish(_63.c["*"],_64,_65+1,_66,msg,_68);
_69=_63.c["**"];
}
if(typeof _69!="undefined"){
var sub=_69.s;
while(sub){
var sc=sub.scope;
var cb=sub.cb;
var d=sub.data;
var sid=sub.sid;
if(typeof cb=="string"){
cb=sc[cb];
}
cb.call(sc,_66,msg,d,_68);
sub=sub.next;
}
}
}
};
OpenAjax.hub.ManagedHub.prototype._unsubscribe=function(_6f){
var _70=_6f.split(".");
var sid=_70.pop();
if(!this._recursiveUnsubscribe(this._subscriptions,_70,0,sid)){
throw new Error(OpenAjax.hub.Error.NoSubscription);
}
};
OpenAjax.hub.ManagedHub.prototype._recursiveUnsubscribe=function(_72,_73,_74,sid){
if(typeof _72=="undefined"){
return false;
}
if(_74<_73.length){
var _76=_72.c[_73[_74]];
if(!_76){
return false;
}
this._recursiveUnsubscribe(_76,_73,_74+1,sid);
if(_76.s==null){
for(var x in _76.c){
return true;
}
delete _72.c[_73[_74]];
}
}else{
var sub=_72.s;
var _79=null;
var _7a=false;
while(sub){
if(sid==sub.sid){
_7a=true;
if(sub==_72.s){
_72.s=sub.next;
}else{
_79.next=sub.next;
}
break;
}
_79=sub;
sub=sub.next;
}
if(!_7a){
return false;
}
}
return true;
};
OpenAjax.hub.ManagedHub.prototype._getSubscriptionObject=function(_7b,_7c,_7d,sid){
if(typeof _7b!="undefined"){
if(_7d<_7c.length){
var _7f=_7b.c[_7c[_7d]];
return this._getSubscriptionObject(_7f,_7c,_7d+1,sid);
}
var sub=_7b.s;
while(sub){
if(sid==sub.sid){
return sub;
}
sub=sub.next;
}
}
return null;
};
OpenAjax.hub._hub=new OpenAjax.hub.ManagedHub({onSubscribe:function(_81,_82){
return true;
},onPublish:function(_83,_84,_85,_86){
return true;
}});
OpenAjax.hub.subscribe=function(_87,_88,_89,_8a){
if(typeof _88==="string"){
_89=_89||window;
_88=_89[_88]||null;
}
return OpenAjax.hub._hub.subscribe(_87,_88,_89,null,_8a);
};
OpenAjax.hub.unsubscribe=function(_8b){
return OpenAjax.hub._hub.unsubscribe(_8b);
};
OpenAjax.hub.publish=function(_8c,_8d){
OpenAjax.hub._hub.publish(_8c,_8d);
};
OpenAjax.hub.registerLibrary("OpenAjax","http://openajax.org/hub","2.0",{});
}
if(typeof OpenAjax==="undefined"){
OpenAjax={hub:{}};
}
OpenAjax.hub.IframeContainer=function(hub,_8f,_90){
if(!hub||!_8f||!_90||!_90.Container||!_90.Container.onSecurityAlert||!_90.IframeContainer||!_90.IframeContainer.parent||!_90.IframeContainer.uri||!_90.IframeContainer.tunnelURI){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
this._params=_90;
this._id=_8f;
if(window.postMessage){
this._delegate=new OpenAjax.hub.IframePMContainer(this,hub,_8f,_90);
}else{
this._delegate=new OpenAjax.hub.IframeFIMContainer(this,hub,_8f,_90);
}
this._iframe=this._createIframe(_90.IframeContainer.parent,this._delegate.getURI(),_90.IframeContainer.iframeAttrs);
hub.addContainer(this);
};
OpenAjax.hub.IframeContainer.prototype.getHub=function(){
return this._delegate.getHub();
};
OpenAjax.hub.IframeContainer.prototype.sendToClient=function(_91,_92,_93){
this._delegate.sendToClient(_91,_92,_93);
};
OpenAjax.hub.IframeContainer.prototype.remove=function(){
this._delegate.remove();
this._iframe.parentNode.removeChild(this._iframe);
delete this._iframe;
};
OpenAjax.hub.IframeContainer.prototype.isConnected=function(){
return this._delegate.isConnected();
};
OpenAjax.hub.IframeContainer.prototype.getClientID=function(){
return this._id;
};
OpenAjax.hub.IframeContainer.prototype.getPartnerOrigin=function(){
return this._delegate.getPartnerOrigin();
};
OpenAjax.hub.IframeContainer.prototype.getParameters=function(){
return this._params;
};
OpenAjax.hub.IframeContainer.prototype.getIframe=function(){
return this._iframe;
};
OpenAjax.hub.IframeContainer.bind=function(_94,_95){
var _96=_95;
return function(){
return _96.apply(_94,arguments);
};
};
OpenAjax.hub.IframeContainer.prototype._createIframe=function(_97,src,_99){
var _9a=document.createElement("iframe");
if(_99){
for(var _9b in _99){
if(_9b=="style"){
for(var _9c in _99.style){
_9a.style[_9c]=_99.style[_9c];
}
}else{
_9a[_9b]=_99[_9b];
}
}
}
_9a.style.visibility="hidden";
_9a.src="javascript:\"<html></html>\"";
_97.appendChild(_9a);
_9a.src=src;
return _9a;
};
OpenAjax.hub.IframeHubClient=function(_9d){
if(!_9d||!_9d.HubClient||!_9d.HubClient.onSecurityAlert){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
this._params=_9d;
if(window.postMessage){
this._delegate=new OpenAjax.hub.IframePMHubClient(this,_9d);
}else{
this._delegate=new OpenAjax.hub.IframeFIMHubClient(this,_9d);
}
};
OpenAjax.hub.IframeHubClient.prototype.connect=function(_9e,_9f){
_9f=_9f||window;
if(this.isConnected()){
throw new Error(OpenAjax.hub.Error.Duplicate);
}
this._delegate.connect(_9e,_9f);
};
OpenAjax.hub.IframeHubClient.prototype.disconnect=function(_a0,_a1){
_a1=_a1||window;
if(!this.isConnected()){
throw new Error(OpenAjax.hub.Error.Disconnected);
}
this._delegate.disconnect(_a0,_a1);
};
OpenAjax.hub.IframeHubClient.prototype.getPartnerOrigin=function(){
return this._delegate.getPartnerOrigin();
};
OpenAjax.hub.IframeHubClient.prototype.getClientID=function(){
return this._delegate.getClientID();
};
OpenAjax.hub.IframeHubClient.prototype.subscribe=function(_a2,_a3,_a4,_a5,_a6){
this._assertConn();
this._assertSubTopic(_a2);
if(!_a3){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
_a4=_a4||window;
return this._delegate.subscribe(_a2,_a3,_a4,_a5,_a6);
};
OpenAjax.hub.IframeHubClient.prototype.publish=function(_a7,_a8){
this._assertConn();
this._assertPubTopic(_a7);
this._delegate.publish(_a7,_a8);
};
OpenAjax.hub.IframeHubClient.prototype.unsubscribe=function(_a9,_aa,_ab){
this._assertConn();
if(typeof _a9==="undefined"||_a9==null){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
_ab=_ab||window;
this._delegate.unsubscribe(_a9,_aa,_ab);
};
OpenAjax.hub.IframeHubClient.prototype.isConnected=function(){
return this._delegate.isConnected();
};
OpenAjax.hub.IframeHubClient.prototype.getScope=function(){
return this._delegate.getScope();
};
OpenAjax.hub.IframeHubClient.prototype.getSubscriberData=function(_ac){
this._assertConn();
return this._delegate.getSubscriberData(_ac);
};
OpenAjax.hub.IframeHubClient.prototype.getSubscriberScope=function(_ad){
this._assertConn();
return this._delegate.getSubscriberScope(_ad);
};
OpenAjax.hub.IframeHubClient.prototype.getParameters=function(){
return this._params;
};
OpenAjax.hub.IframeHubClient.prototype._assertConn=function(){
if(!this.isConnected()){
throw new Error(OpenAjax.hub.Error.Disconnected);
}
};
OpenAjax.hub.IframeHubClient.prototype._assertSubTopic=function(_ae){
if(!_ae){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
var _af=_ae.split(".");
var len=_af.length;
for(var i=0;i<len;i++){
var p=_af[i];
if((p=="")||((p.indexOf("*")!=-1)&&(p!="*")&&(p!="**"))){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
if((p=="**")&&(i<len-1)){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
}
};
OpenAjax.hub.IframeHubClient.prototype._assertPubTopic=function(_b3){
if((_b3==null)||(_b3=="")||(_b3.indexOf("*")!=-1)||(_b3.indexOf("..")!=-1)||(_b3.charAt(0)==".")||(_b3.charAt(_b3.length-1)==".")){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
};
OpenAjax.hub.IframePMContainer=function(_b4,hub,_b6,_b7){
this._container=_b4;
this._hub=hub;
this._id=_b6;
this._onSecurityAlert=_b7.Container.onSecurityAlert;
this._onConnect=_b7.Container.onConnect?_b7.Container.onConnect:null;
this._onDisconnect=_b7.Container.onDisconnect?_b7.Container.onDisconnect:null;
this._scope=_b7.Container.scope||window;
this._uri=_b7.IframeContainer.uri;
this._tunnelURI=_b7.IframeContainer.tunnelURI;
this._timeout=_b7.IframeContainer.timeout||15000;
if(_b7.Container.log){
var _b8=this._scope;
var _b9=_b7.Container.log;
this._log=function(msg){
_b9.call(_b8,"IframeContainer::"+_b6+": "+msg);
};
}else{
this._log=function(){
};
}
this._securityToken=this._generateSecurityToken(_b7);
this._connected=false;
this._subs={};
if(typeof OpenAjax.hub.IframePMContainer._pmCapabilities==="undefined"){
this._testPostMessage();
}
if(OpenAjax.hub.IframePMContainer._pmCapabilities.indexOf("s")==-1){
this._postMessage=function(win,msg,_bd){
win.postMessage(msg,_bd);
};
}else{
this._postMessage=function(win,msg,_c0){
setTimeout(function(){
win.postMessage(msg,_c0);
},0);
};
}
if(!OpenAjax.hub.IframePMContainer._pmListener){
OpenAjax.hub.IframePMContainer._pmListener=new OpenAjax.hub.IframePMContainer.PMListener();
}
this._internalID=OpenAjax.hub.IframePMContainer._pmListener.addContainer(this);
this._startLoadTimer();
};
OpenAjax.hub.IframePMContainer.protocolID="openajax-2.0";
OpenAjax.hub.IframePMContainer._pmListener=null;
OpenAjax.hub.IframePMContainer.prototype.getHub=function(){
return this._hub;
};
OpenAjax.hub.IframePMContainer.prototype.sendToClient=function(_c1,_c2,_c3){
this._sendMessage("pub",{t:_c1,d:_c2,s:_c3});
};
OpenAjax.hub.IframePMContainer.prototype.remove=function(){
this._disconnect();
OpenAjax.hub.IframePMContainer._pmListener.removeContainer(this._internalID);
clearTimeout(this._loadTimer);
delete this._iframe;
};
OpenAjax.hub.IframePMContainer.prototype.isConnected=function(){
return this._connected;
};
OpenAjax.hub.IframePMContainer.prototype.getPartnerOrigin=function(){
if(this._connected){
return new RegExp("^([a-zA-Z]+://[^:]+).*").exec(this._partnerOrigin)[1];
}
return null;
};
OpenAjax.hub.IframePMContainer.prototype.receiveMessage=function(_c4,msg){
if(msg.t!=this._securityToken||(typeof this._partnerOrigin!="undefined"&&!OpenAjax.hub.IframePMContainer.originMatches(this,_c4))){
this._invokeSecurityAlert(OpenAjax.hub.SecurityAlert.ForgedMsg);
return;
}
this._log("received message: ["+_c4.data+"]");
switch(msg.m){
case "sub":
var _c6="";
try{
this._subs[msg.p.s]=this._hub.subscribeForClient(this._container,msg.p.t,msg.p.s);
}
catch(e){
_c6=e.message;
}
this._sendMessage("sub_ack",{s:msg.p.s,e:_c6});
break;
case "pub":
this._hub.publishForClient(this._container,msg.p.t,msg.p.d);
break;
case "uns":
var _c7=this._subs[msg.p.s];
this._hub.unsubscribeForClient(this._container,_c7);
delete this._subs[msg.p.s];
this._sendMessage("uns_ack",msg.p.s);
break;
case "dis":
this._startLoadTimer();
this._disconnect();
this._sendMessage("dis_ack",null);
if(this._onDisconnect){
try{
this._onDisconnect.call(this._scope,this._container);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onDisconnect callback to constructor: "+e.message);
}
}
break;
}
};
OpenAjax.hub.IframePMContainer.prototype.connect=function(_c8,_c9,_ca){
this._log("client connecting to container "+this._id+" :: origin = "+_c8+" :: securityToken = "+_c9);
if(_c9!=this._securityToken){
this._invokeSecurityAlert(OpenAjax.hub.SecurityAlert.ForgedMsg);
return;
}
var _cb=this;
_ca.onunload=function(){
if(_cb.isConnected()){
setTimeout(function(){
_cb._invokeSecurityAlert(OpenAjax.hub.SecurityAlert.FramePhish);
},1);
}
};
clearTimeout(this._loadTimer);
this._iframe=this._container.getIframe();
this._iframe.style.visibility="visible";
this._partnerOrigin=_c8;
if(OpenAjax.hub.IframePMContainer._pmCapabilities.indexOf("d")!=-1){
this._partnerDomain=new RegExp("^.+://([^:]+).*").exec(this._partnerOrigin)[1];
}
this._sendMessage("con_ack",null);
this._connected=true;
if(this._onConnect){
try{
this._onConnect.call(this._scope,this._container);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onConnect callback to constructor: "+e.message);
}
}
};
OpenAjax.hub.IframePMContainer.prototype.getURI=function(){
var _cc="oahpv="+encodeURIComponent(OpenAjax.hub.IframePMContainer.protocolID)+"&oahi="+encodeURIComponent(this._internalID)+"&oaht="+this._securityToken+"&oahu="+encodeURIComponent(this._tunnelURI)+"&oahpm="+OpenAjax.hub.IframePMContainer._pmCapabilities;
if(this._id!==this._internalID){
_cc+="&oahj="+this._internalID;
}
var _cd=this._uri.split("#");
_cd[0]=_cd[0]+((_cd[0].indexOf("?")!=-1)?"&":"?")+_cc;
if(_cd.length==1){
return _cd[0];
}
return _cd[0]+"#"+_cd[1];
};
OpenAjax.hub.IframePMContainer.originMatches=function(obj,_cf){
if(_cf.origin){
return _cf.origin==obj._partnerOrigin;
}else{
return _cf.domain==obj._partnerDomain;
}
};
OpenAjax.hub.IframePMContainer.prototype._generateSecurityToken=function(_d0){
if(!OpenAjax.hub.IframePMContainer._prng){
var _d1=new Date().getTime()+Math.random()+document.cookie;
OpenAjax.hub.IframePMContainer._prng=OpenAjax._smash.crypto.newPRNG(_d1);
}
if(_d0.IframeContainer.seed){
try{
var _d2=_d0.IframeContainer.seed.call(this._scope);
OpenAjax.hub.IframePMContainer._prng.addSeed(_d2);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from 'seed' callback: "+e.message);
}
}
var _d3=_d0.IframeContainer.tokenLength||6;
return OpenAjax.hub.IframePMContainer._prng.nextRandomB64Str(_d3);
};
OpenAjax.hub.IframePMContainer.prototype._testPostMessage=function(){
OpenAjax.hub.IframePMContainer._pmCapabilities="";
var hit=false;
function _d5(_d6){
if(_d6.data=="postmessage.test"){
hit=true;
if(typeof _d6.origin==="undefined"){
OpenAjax.hub.IframePMContainer._pmCapabilities+="d";
}
}
};
if(window.addEventListener){
window.addEventListener("message",_d5,false);
}else{
if(window.attachEvent){
window.attachEvent("onmessage",_d5);
}
}
window.postMessage("postmessage.test","*");
if(hit){
OpenAjax.hub.IframePMContainer._pmCapabilities+="s";
}
if(window.removeEventListener){
window.removeEventListener("message",_d5,false);
}else{
window.detachEvent("onmessage",_d5);
}
};
OpenAjax.hub.IframePMContainer.prototype._startLoadTimer=function(){
var _d7=this;
this._loadTimer=setTimeout(function(){
OpenAjax.hub.IframePMContainer._pmListener.removeContainer(_d7._internalID);
_d7._invokeSecurityAlert(OpenAjax.hub.SecurityAlert.LoadTimeout);
},this._timeout);
};
OpenAjax.hub.IframePMContainer.prototype._sendMessage=function(_d8,_d9){
var msg=JSON.stringify({m:_d8,i:this._internalID,t:this._securityToken,p:_d9});
this._postMessage(this._iframe.contentWindow,msg,this._partnerOrigin);
};
OpenAjax.hub.IframePMContainer.prototype._disconnect=function(){
if(this._connected){
this._connected=false;
this._iframe.style.visibility="hidden";
for(var sub in this._subs){
this._hub.unsubscribeForClient(this._container,this._subs[sub]);
}
this._subs={};
}
};
OpenAjax.hub.IframePMContainer.prototype._invokeSecurityAlert=function(_dc){
try{
this._onSecurityAlert.call(this._scope,this._container,_dc);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onSecurityAlert callback to constructor: "+e.message);
}
};
OpenAjax.hub.IframePMContainer.PMListener=function(){
this._containers={};
if(window.addEventListener){
window.addEventListener("message",OpenAjax.hub.IframeContainer.bind(this,this._receiveMessage),false);
}else{
if(window.attachEvent){
window.attachEvent("onmessage",OpenAjax.hub.IframeContainer.bind(this,this._receiveMessage));
}
}
};
OpenAjax.hub.IframePMContainer.PMListener.prototype.addContainer=function(_dd){
var id=_dd._id;
while(this._containers[id]){
id=((32767*Math.random())|0).toString(16)+"_"+id;
}
this._containers[id]=_dd;
return id;
};
OpenAjax.hub.IframePMContainer.PMListener.prototype.removeContainer=function(_df){
delete this._containers[_df];
};
OpenAjax.hub.IframePMContainer.PMListener.prototype.connectFromTunnel=function(_e0,_e1,_e2,_e3){
if(this._containers[_e0]){
this._containers[_e0].connect(_e1,_e2,_e3);
}
};
OpenAjax.hub.IframePMContainer.PMListener.prototype._receiveMessage=function(_e4){
try{
var msg=JSON.parse(_e4.data);
}
catch(e){
return;
}
if(!this._verifyMsg(msg)){
return;
}
if(this._containers[msg.i]){
var _e6=this._containers[msg.i].receiveMessage(_e4,msg);
}
};
OpenAjax.hub.IframePMContainer.PMListener.prototype._verifyMsg=function(msg){
return typeof msg.m=="string"&&typeof msg.i=="string"&&"t" in msg&&"p" in msg;
};
OpenAjax.hub.IframePMHubClient=function(_e8,_e9){
this._checkProtocolID();
this._client=_e8;
this._onSecurityAlert=_e9.HubClient.onSecurityAlert;
this._scope=_e9.HubClient.scope||window;
this._id=OpenAjax.hub.IframePMHubClient.queryURLParam("oahi");
this._internalID=OpenAjax.hub.IframePMHubClient.queryURLParam("oahj")||this._id;
this._securityToken=OpenAjax.hub.IframePMHubClient.queryURLParam("oaht");
this._tunnelURI=OpenAjax.hub.IframePMHubClient.queryURLParam("oahu");
OpenAjax.hub.IframePMContainer._pmCapabilities=OpenAjax.hub.IframePMHubClient.queryURLParam("oahpm");
if(!this._id||!this._securityToken||!this._tunnelURI){
throw new Error(OpenAjax.hub.Error.WrongProtocol);
}
this._partnerOrigin=new RegExp("^([a-zA-Z]+://[^/?#]+).*").exec(this._tunnelURI)[1];
if(OpenAjax.hub.IframePMContainer._pmCapabilities.indexOf("d")!=-1){
this._partnerDomain=new RegExp("^.+://([^:]+).*").exec(this._partnerOrigin)[1];
}
if(_e9.HubClient.log){
var id=this._id;
var _eb=this._scope;
var _ec=_e9.HubClient.log;
this._log=function(msg){
_ec.call(_eb,"IframeHubClient::"+id+": "+msg);
};
}else{
this._log=function(){
};
}
this._connected=false;
this._subs={};
this._subIndex=0;
if(OpenAjax.hub.IframePMContainer._pmCapabilities.indexOf("s")==-1){
this._postMessage=function(win,msg,_f0){
win.postMessage(msg,_f0);
};
}else{
this._postMessage=function(win,msg,_f3){
setTimeout(function(){
win.postMessage(msg,_f3);
},0);
};
}
};
OpenAjax.hub.IframePMHubClient.protocolID="openajax-2.0";
OpenAjax.hub.IframePMHubClient.prototype.connect=function(_f4,_f5){
if(_f4){
this._connectOnComplete={cb:_f4,sc:_f5};
}
this._msgListener=OpenAjax.hub.IframeContainer.bind(this,this._receiveMessage);
if(window.addEventListener){
window.addEventListener("message",this._msgListener,false);
}else{
if(window.attachEvent){
window.attachEvent("onmessage",this._msgListener);
}
}
var _f6=window.location.protocol+"//"+window.location.host;
var _f7=document.createElement("iframe");
document.body.appendChild(_f7);
_f7.src=this._tunnelURI+(this._tunnelURI.indexOf("?")==-1?"?":"&")+"oahj="+encodeURIComponent(this._internalID)+"&oaht="+this._securityToken+"&oaho="+encodeURIComponent(_f6);
_f7.style.position="absolute";
_f7.style.left=_f7.style.top="-10px";
_f7.style.height=_f7.style.width="1px";
_f7.style.visibility="hidden";
this._tunnelIframe=_f7;
};
OpenAjax.hub.IframePMHubClient.prototype.disconnect=function(_f8,_f9){
this._connected=false;
if(_f8){
this._disconnectOnComplete={cb:_f8,sc:_f9};
}
this._sendMessage("dis",null);
};
OpenAjax.hub.IframePMHubClient.prototype.getPartnerOrigin=function(){
if(this._connected){
return new RegExp("^([a-zA-Z]+://[^:]+).*").exec(this._partnerOrigin)[1];
}
return null;
};
OpenAjax.hub.IframePMHubClient.prototype.getClientID=function(){
return this._id;
};
OpenAjax.hub.IframePMHubClient.prototype.subscribe=function(_fa,_fb,_fc,_fd,_fe){
var _ff=""+this._subIndex++;
this._subs[_ff]={cb:_fb,sc:_fc,d:_fe,oc:_fd};
this._sendMessage("sub",{t:_fa,s:_ff});
return _ff;
};
OpenAjax.hub.IframePMHubClient.prototype.publish=function(_100,data){
this._sendMessage("pub",{t:_100,d:data});
};
OpenAjax.hub.IframePMHubClient.prototype.unsubscribe=function(_102,_103,_104){
if(!this._subs[_102]||this._subs[_102].uns){
throw new Error(OpenAjax.hub.Error.NoSubscription);
}
this._subs[_102].uns={cb:_103,sc:_104};
this._sendMessage("uns",{s:_102});
};
OpenAjax.hub.IframePMHubClient.prototype.isConnected=function(){
return this._connected;
};
OpenAjax.hub.IframePMHubClient.prototype.getScope=function(){
return this._scope;
};
OpenAjax.hub.IframePMHubClient.prototype.getSubscriberData=function(_105){
var sub=this._subs[_105];
if(sub){
return sub.d;
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
OpenAjax.hub.IframePMHubClient.prototype.getSubscriberScope=function(_107){
var sub=this._subs[_107];
if(sub){
return sub.sc;
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
OpenAjax.hub.IframePMHubClient.queryURLParam=function(_109){
var _10a=new RegExp("[\\?&]"+_109+"=([^&#]*)").exec(window.location.search);
if(_10a){
return decodeURIComponent(_10a[1].replace(/\+/g,"%20"));
}
return null;
};
OpenAjax.hub.IframePMHubClient.prototype._checkProtocolID=function(){
var _10b=OpenAjax.hub.IframePMHubClient.queryURLParam("oahpv");
if(_10b!=OpenAjax.hub.IframePMHubClient.protocolID){
throw new Error(OpenAjax.hub.Error.WrongProtocol);
}
};
OpenAjax.hub.IframePMHubClient.prototype._receiveMessage=function(_10c){
try{
var msg=JSON.parse(_10c.data);
}
catch(e){
return;
}
if(!this._verifyMsg(msg)){
return;
}
if(msg.i!=this._internalID){
return;
}else{
if(!OpenAjax.hub.IframePMContainer.originMatches(this,_10c)||msg.t!=this._securityToken){
try{
this._onSecurityAlert.call(this._scope,this._client,OpenAjax.hub.SecurityAlert.ForgedMsg);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onSecurityAlert callback to constructor: "+e.message);
}
return;
}
}
this._log("received message: ["+_10c.data+"]");
switch(msg.m){
case "sub_ack":
var _10e=msg.p.s;
var _10f=this._subs[_10e].oc;
if(_10f){
try{
delete this._subs[_10e].oc;
var _110=this._subs[_10e].sc;
_10f.call(_110,msg.p.s,msg.p.e=="",msg.p.e);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onComplete callback to HubClient.subscribe(): "+e.message);
}
}
break;
case "pub":
var _10e=msg.p.s;
if(this._subs[_10e]&&!this._subs[_10e].uns){
var _111=this._subs[_10e].cb;
var _110=this._subs[_10e].sc;
var _112=this._subs[_10e].d;
try{
_111.call(_110,msg.p.t,msg.p.d,_112);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onData callback to HubClient.subscribe(): "+e.message);
}
}
break;
case "uns_ack":
var _10e=msg.p;
if(this._subs[_10e]){
var _10f=this._subs[_10e].uns.cb;
if(_10f){
try{
var _110=this._subs[_10e].uns.sc;
_10f.call(_110,_10e,true);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onComplete callback to HubClient.unsubscribe(): "+e.message);
}
}
delete this._subs[_10e];
}
break;
case "con_ack":
this._connected=true;
if(this._connectOnComplete){
var _10f=this._connectOnComplete.cb;
var _110=this._connectOnComplete.sc;
try{
_10f.call(_110,this._client,true);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onComplete callback to HubClient.connect(): "+e.message);
}
delete this._connectOnComplete;
}
break;
case "dis_ack":
if(window.removeEventListener){
window.removeEventListener("message",this._msgListener,false);
}else{
window.detachEvent("onmessage",this._msgListener);
}
delete this._msgListener;
this._tunnelIframe.parentNode.removeChild(this._tunnelIframe);
delete this._tunnelIframe;
if(this._disconnectOnComplete){
try{
var _10f=this._disconnectOnComplete.cb;
var _110=this._disconnectOnComplete.sc;
_10f.call(_110,this._client,true);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onComplete callback to HubClient.disconnect(): "+e.message);
}
delete this._disconnectOnComplete;
}
break;
}
};
OpenAjax.hub.IframePMHubClient.prototype._verifyMsg=function(msg){
return typeof msg.m=="string"&&"t" in msg&&"p" in msg;
};
OpenAjax.hub.IframePMHubClient.prototype._sendMessage=function(type,_115){
var msg=JSON.stringify({m:type,i:this._internalID,t:this._securityToken,p:_115});
this._postMessage(window.parent,msg,this._partnerOrigin);
};
if(typeof OpenAjax==="undefined"){
OpenAjax={hub:{}};
}
(function(){
OpenAjax.hub.IframeFIMContainer=function(_117,hub,_119,_11a){
this._container=_117;
this._hub=hub;
this._onSecurityAlert=_11a.Container.onSecurityAlert;
this._onConnect=_11a.Container.onConnect?_11a.Container.onConnect:null;
this._onDisconnect=_11a.Container.onDisconnect?_11a.Container.onDisconnect:null;
this._scope=_11a.Container.scope||window;
this._subs={};
this._clientURI=_11a.IframeContainer.uri;
_11b.SEComm.tunnelURI=_11a.IframeContainer.tunnelURI;
_11b._loadTimeout=_11a.IframeContainer.timeout||15000;
if(_11a.Container.log){
var _11c=this._scope;
var _11d=_11a.Container.log;
this._log=function(msg){
_11d.call(_11c,"IframeContainer::"+_119+": "+msg);
};
}else{
this._log=function(){
};
}
_11b._createPRNG(this,_11a);
_11b._ensureSingletonManager();
this._internalID=_11b._singletonManager.generateUniqueClientName(_119);
};
OpenAjax.hub.IframeFIMContainer.prototype.getHub=function(){
return this._hub;
};
OpenAjax.hub.IframeFIMContainer.prototype.sendToClient=function(_11f,data,_121){
_11b._singletonManager.sendToClient(this._internalID,_11f,data,[_121]);
};
OpenAjax.hub.IframeFIMContainer.prototype.remove=function(){
return _11b._singletonManager.prepareForUnload(this._internalID);
};
OpenAjax.hub.IframeFIMContainer.prototype.isConnected=function(){
return _11b._singletonManager.isConnected(this._internalID);
};
OpenAjax.hub.IframeFIMContainer.prototype.getPartnerOrigin=function(){
return _11b._singletonManager.getPartnerOrigin(this._internalID);
};
OpenAjax.hub.IframeFIMContainer.prototype.getURI=function(){
var that=this;
function _123(_124,_125){
var _126=null;
switch(_125){
case _11b.SecurityErrors.INVALID_TOKEN:
case _11b.SecurityErrors.TOKEN_VERIFICATION_FAILED:
_126=OpenAjax.hub.SecurityAlert.ForgedMsg;
break;
case _11b.SecurityErrors.TUNNEL_UNLOAD:
_126=OpenAjax.hub.SecurityAlert.FramePhish;
break;
case _11b.SecurityErrors.COMPONENT_LOAD:
_126=OpenAjax.hub.SecurityAlert.LoadTimeout;
break;
}
try{
that._onSecurityAlert.call(that._scope,that._container,_126);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onSecurityAlert callback to constructor: "+e.message);
}
};
var _127=_11b._singletonManager.prepareForLoad({clientName:this._internalID,uri:this._clientURI,commErrorCallback:_123,oaaContainer:this,log:this._log});
return _127;
};
OpenAjax.hub.IframeFIMHubClient=function(_128,_129){
var _12a=new RegExp("[\\?&]oahm=([^&#]*)").exec(window.location.search);
if(!_12a){
throw new Error(OpenAjax.hub.Error.WrongProtocol);
}
_12a=_12a[1];
var _12b=_12a.split(":",1);
if(_12b[0]!=_11b._protocolID){
throw new Error(OpenAjax.hub.Error.WrongProtocol);
}
_12a=_12a.substring(_12b[0].length+1);
var url=window.location.href+"#"+_12a;
window.location.replace(url);
this._client=_128;
this._onSecurityAlert=_129.HubClient.onSecurityAlert;
this._scope=_129.HubClient.scope||window;
var re=new RegExp("\\d{3}.{"+_11b._securityTokenLength+"}.{"+_11b._securityTokenLength+"}\\d{3}(.*)");
var _12e=re.exec(_12a)[1];
var _12f=_12e.split(":");
var _130=decodeURIComponent(_12f[0]);
this._id=_130.substring(_130.indexOf("_")+1);
if(_129.HubClient.log){
var id=this._id;
var _132=this._scope;
var _133=_129.HubClient.log;
this._log=function(msg){
_133.call(_132,"IframeHubClient::"+id+": "+msg);
};
}else{
this._log=function(){
};
}
this._connected=false;
this._subs={};
this._subIndex=0;
_11b._createPRNG(this,_129);
};
OpenAjax.hub.IframeFIMHubClient.prototype.connect=function(_135,_136){
if(_11b._singletonClientHub==null){
_11b._singletonClientHub=new _11b.SEHubClient(null,this._log);
var that=this;
_11b._singletonClientHub.setSecurityErrorCallback(function(_138){
if(_138!=_11b.SecurityErrors.INVALID_TOKEN){
that._log("unknown smash security error: "+_138);
}
try{
that._onSecurityAlert.call(that._scope,that._client,OpenAjax.hub.SecurityAlert.ForgedMsg);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onSecurityAlert callback to constructor: "+e.message);
}
});
}
var that=this;
function cb(_13a,_13b){
if(_13a){
that._connected=true;
}
if(_135){
try{
_135.call(_136,that._client,_13a);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onComplete callback to HubClient.connect(): "+e.message);
}
}
};
_11b._singletonClientHub.connect(cb);
};
OpenAjax.hub.IframeFIMHubClient.prototype.disconnect=function(_13c,_13d){
this._connected=false;
var that=this;
function cb(_140,_141){
if(_13c){
try{
_13c.call(_13d,that._client,_140);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onComplete callback to HubClient.disconnect(): "+e.message);
}
}
};
_11b._singletonClientHub.disconnect(cb);
};
OpenAjax.hub.IframeFIMHubClient.prototype.getPartnerOrigin=function(){
return _11b._singletonClientHub?_11b._singletonClientHub.getPartnerOrigin():null;
};
OpenAjax.hub.IframeFIMHubClient.prototype.getClientID=function(){
return this._id;
};
OpenAjax.hub.IframeFIMHubClient.prototype.subscribe=function(_142,_143,_144,_145,_146){
var _147=""+this._subIndex++;
var that=this;
var _149=!_145?null:function(_14a,_14b,_14c){
try{
_145.call(_144,_147,_14a,_14c);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onComplete callback to HubClient.subscribe(): "+e.message);
}
};
function _14d(_14e,_14f,data){
try{
_143.call(_144,_14f,data,_146);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onData callback to HubClient.subscribe(): "+e.message);
}
};
this._subs[_147]=_11b._singletonClientHub.subscribe(_142,_149,_14d,_144,_146);
return _147;
};
OpenAjax.hub.IframeFIMHubClient.prototype.publish=function(_151,data){
_11b._singletonClientHub.publish(_151,data);
};
OpenAjax.hub.IframeFIMHubClient.prototype.unsubscribe=function(_153,_154,_155){
if(!this._subs[_153]){
throw new Error(OpenAjax.hub.Error.NoSubscription);
}
var that=this;
function cb(_158,_159){
delete that._subs[_153];
if(_154){
try{
_154.call(_155,_153,_158);
}
catch(e){
OpenAjax.hub._debugger();
that._log("caught error from onComplete callback to HubClient.unsubscribe(): "+e.message);
}
}
};
this._subs[_153].unsubscribe(cb);
};
OpenAjax.hub.IframeFIMHubClient.prototype.isConnected=function(){
return this._connected;
};
OpenAjax.hub.IframeFIMHubClient.prototype.getScope=function(){
return this._scope;
};
OpenAjax.hub.IframeFIMHubClient.prototype.getSubscriberData=function(_15a){
var sub=this._subs[_15a];
if(sub){
return sub.getSubscriberData();
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
OpenAjax.hub.IframeFIMHubClient.prototype.getSubscriberScope=function(_15c){
var sub=this._subs[_15c];
if(sub){
return sub.getSubscriberScope();
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
if(typeof OpenAjax._smash=="undefined"){
OpenAjax._smash={};
}
var _11b=OpenAjax._smash;
_11b._singletonManager=undefined;
_11b._singletonClientHub=undefined;
_11b._protocolID="openajax-2.0";
_11b._prng=undefined;
_11b._securityTokenLength=6;
_11b._securityTokenOverhead=null;
_11b._computeOtherTokenConstants=function(){
_11b._securityTokenOverhead=2*_11b._securityTokenLength;
_11b._multiplier=Math.pow(10,_11b._securityTokenLength-1);
};
_11b._computeOtherTokenConstants();
_11b._createPRNG=function(_15e,_15f){
if(!_11b._prng){
var seed=new Date().getTime()+Math.random()+document.cookie;
_11b._prng=_11b.crypto.newPRNG(seed);
}
var p=_15f.IframeContainer||_15f.IframeHubClient;
if(p&&p.seed){
try{
var _162=p.seed.call(_15e._scope);
_11b._prng.addSeed(_162);
}
catch(e){
OpenAjax.hub._debugger();
_15e._log("caught error from 'seed' callback: "+e.message);
}
}
};
_11b._keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
_11b._generateSecurityToken=function(){
var r;
if(_11b._prng){
r=_11b._prng.nextRandomB64Str(_11b._securityTokenLength);
}else{
var r1=Math.random();
r="";
for(var i=0;i<_11b._securityTokenLength;i++){
var r2=r1*64;
var c=Math.floor(r2);
r1=(r2-c);
r=r+_11b._keyStr.charAt(c);
}
}
return r;
};
_11b._ensureSingletonManager=function(){
if(_11b._singletonManager==null){
_11b._singletonManager=new _11b.SEHub();
}
};
_11b.SEHub=function(){
var that=this;
this.componentInfo=[];
function _169(uri,_16b){
this.uri=uri;
this.connected=false;
this.errorCallback=_16b;
};
this.generateUniqueClientName=function(_16c){
do{
_16c=((32767*Math.random())|0).toString(16)+"_"+_16c;
}while(that.componentInfo[_16c]);
return _16c;
};
function _16d(_16e,_16f){
var ci=that.componentInfo[_16f];
if(ci!=null){
var _171=ci.errorCallback;
if(_171!=null){
_171(_16f,_16e);
}
}
};
this.prepareForLoad=function(_172){
var _173=_172.clientName;
var _174=_172.uri;
if((_173==null)||(_174==null)){
return null;
}
if(that.componentInfo[_173]!=null){
return null;
}
that.componentInfo[_173]=new _169(_174,_172.commErrorCallback);
that.componentInfo[_173].seComm=new _11b.SEComm();
that.componentInfo[_173].seComm.setSecurityListener(_16d);
that.componentInfo[_173].oaaContainer=_172.oaaContainer;
return that.componentInfo[_173].seComm.prepareForLoad(_173,_174,that,_11b._loadTimeout,_172.log);
};
this.prepareForUnload=function(_175){
if(!that.componentInfo[_175]){
return true;
}
that._disconnect(_175);
that.componentInfo[_175].seComm.prepareForUnload();
delete that.componentInfo[_175];
return true;
};
this.isConnected=function(_176){
if(that.componentInfo[_176]&&that.componentInfo[_176].connected){
return true;
}
return false;
};
this.sendToClient=function(_177,_178,data,_17a){
if(that.isConnected(_177)){
var _17b=that.componentInfo[_177].seComm;
if(_17b){
_17b.distribute(_178,_17a,data);
}
}
};
this.componentLoaded=function(_17c,_17d){
if(that.componentInfo[_17c]){
that.componentInfo[_17c].connected=true;
that.componentInfo[_17c].partnerOrigin=new RegExp("^([a-zA-Z]+://[^:/?#]+).*").exec(_17d)[1];
var _17e=that.componentInfo[_17c].oaaContainer;
_17e._container.getIframe().style.visibility="visible";
if(_17e._onConnect){
try{
_17e._onConnect.call(_17e._scope,_17e._container);
}
catch(e){
OpenAjax.hub._debugger();
_17e._log("caught error from onConnect callback to constructor: "+e.message);
}
}
}
};
this.publishInternal=function(_17f,_180,_181){
if(that.componentInfo[_17f]){
var _182=that.componentInfo[_17f].oaaContainer;
_182._hub.publishForClient(_182._container,_180,_181);
}
};
this.subscribeInternal=function(_183,_184,_185){
var _186=that.componentInfo[_183].oaaContainer;
_186._subs[_184]=_186._hub.subscribeForClient(_186._container,_185,_184);
};
this.unsubscribeInternal=function(_187,_188){
try{
var _189=that.componentInfo[_187].oaaContainer;
var _18a=_189._subs[_188];
_189._hub.unsubscribeForClient(_189._container,_18a);
return true;
}
catch(e){
}
return false;
};
this.disconnect=function(_18b){
that._disconnect(_18b);
var _18c=that.componentInfo[_18b].oaaContainer;
if(_18c._onDisconnect){
try{
_18c._onDisconnect.call(_18c._scope,_18c._container);
}
catch(e){
OpenAjax.hub._debugger();
_18c._log("caught error from onDisconnect callback to constructor: "+e.message);
}
}
};
this._disconnect=function(_18d){
if(that.componentInfo[_18d].connected){
that.componentInfo[_18d].connected=false;
var _18e=that.componentInfo[_18d].oaaContainer;
_18e._container.getIframe().style.visibility="hidden";
for(var sub in _18e._subs){
_18e._hub.unsubscribeForClient(_18e._container,_18e._subs[sub]);
}
_18e._subs={};
}
};
this.getPartnerOrigin=function(_190){
if(that.componentInfo[_190].connected){
return that.componentInfo[_190].partnerOrigin;
}
return null;
};
};
_11b.SEHubClient=function(_191,_192){
this.equals=function(_193){
return that===_193;
};
this.isConnected=function(){
return _195;
};
this.getClientName=function(){
return _191;
};
this.connect=function(_196){
_197=function(_198){
if(_198){
_195=true;
}
_196(_198,that);
};
_199.connect(_197);
};
this.disconnect=function(_19a){
_19b=function(_19c){
if(_19c){
_195=false;
_19d=[];
}
_19a(_19c,that);
};
_199.disconnect();
return;
};
this.subscribe=function(_19e,_19f,_1a0,_1a1,_1a2){
var _1a3=(_1a4+"");
_1a4++;
_19d[_1a3]=new _1a5(_1a3,_19e,_19f,_1a0,that,_1a1,_1a2);
_199.subscribe(_1a3,_19e);
return _19d[_1a3];
};
this.publish=function(_1a6,data){
_199.publish(_1a6,data);
return true;
};
function _1a5(_1a8,_1a9,_1aa,_1ab,_1ac,_1ad,_1ae){
var _1af=false;
var _1b0=_1ae;
var _1b1=_1ad;
var that=this;
this.getTopic=function(){
return _1a9;
};
this.getConnHandle=function(){
return _1ac;
};
this.equals=function(_1b3){
if((_1b3._getSubId!=null)&&(typeof _1b3._getSubId=="function")&&(_1b3.getConnHandle!=null)&&(typeof _1b3.getConnHandle=="function")){
if((_1a8===_1b3._getSubId())&&(_1ac===_1b3.getConnHandle())){
return true;
}
}
return false;
};
this.isSubscribed=function(){
return _1af;
};
this.unsubscribe=function(_1b4){
return _1ac._unsubscribe(that,_1b4);
};
this.getSubscriberData=function(){
return _1b0;
};
this.getSubscriberScope=function(){
return _1b1;
};
this._getSubId=function(){
return _1a8;
};
this._setIsSubscribed=function(_1b5){
_1af=_1b5;
};
this._getCallback=function(){
return _1aa;
};
this._getEventCallback=function(){
return _1ab;
};
};
this.getPartnerOrigin=function(){
if(_195&&_199!=null){
var ptu=_199.getParsedTunnelUrl();
if(ptu!=null){
return ptu.scheme+"://"+ptu.host;
}
}
return null;
};
this.setSecurityErrorCallback=function(_1b7){
_1b8=_1b7;
};
this._unsubscribe=function(_1b9,_1ba){
var _1bb=_1b9._getSubId();
if(!_19d[_1bb]){
throw new Error(OpenAjax.hub.Error.NoSubscription);
}
_19d[_1bb]=undefined;
_199.unsubscribe(_1bb);
if(_1ba!=null){
_1ba(true,_1b9);
}
return _1b9;
};
var _1b8=undefined;
var _1a4=0;
var _19d=[];
var _199=new _11b.SECommClient(_191,_192);
var _195=false;
var that=this;
var _197=null;
var _19b=null;
function _1bc(_1bd){
if(!_195&&_1bd.type!=_11b.SECommMessage.CONNECT_ACK){
return;
}
switch(_1bd.type){
case _11b.SECommMessage.DISTRIBUTE:
if((_1bd.additionalHeader!=null)&&(_1bd.additionalHeader.s!=null)){
var subs=_1bd.additionalHeader.s;
for(var i=0;i<subs.length;i++){
var _1c0=subs[i];
if((_1c0!=null)&&(_19d[_1c0]!=null)){
var _1c1=_19d[_1c0]._getEventCallback();
if(_1c1!=null){
_1c1(_19d[_1c0],_1bd.topic,_1bd.payload);
}
}
}
}
break;
case _11b.SECommMessage.SUBSCRIBE_ACK:
if(_1bd.additionalHeader!=null){
var _1c0=_1bd.additionalHeader.subId;
var isOk=_1bd.additionalHeader.isOk;
var err=_1bd.additionalHeader.err;
if((_1c0!=null)&&(isOk!=null)){
if(_19d[_1c0]!=null){
var _1c4=_19d[_1c0]._getCallback();
if(isOk){
_19d[_1c0]._setIsSubscribed(true);
if(_1c4!=null){
_1c4(true,_19d[_1c0]);
}
}else{
if(_1c4!=null){
_1c4(false,_19d[_1c0],err);
}
_19d[_1c0]=undefined;
}
}
}
}
break;
case _11b.SECommMessage.CONNECT_ACK:
_197(true);
break;
case _11b.SECommMessage.DISCONNECT_ACK:
_19b(true);
break;
}
};
function _1c5(_1c6){
if(_1b8!=null){
_1b8(_1c6);
}else{
throw new Error(errorString);
}
};
_199.handleIncomingMessage=_1bc;
_199.setSecurityListener(_1c5);
};
_11b.SecurityErrors={INVALID_TOKEN:0,TOKEN_VERIFICATION_FAILED:1,TUNNEL_UNLOAD:2,COMPONENT_LOAD:3};
_11b.SECommMessage=function(){
this.type=null;
this.topic=null;
this.additionalHeader=null;
this.payload=null;
var _1c7="y";
var _1c8="t";
var _1c9="h";
var _1ca="p";
this.serialize=function(){
var _1cb=_1c7+"="+this.type;
if(this.topic!=null){
var _1cc=encodeURIComponent(this.topic);
var _1cd="&"+_1c8+"="+_1cc;
_1cb+=_1cd;
}
if(this.additionalHeader!=null){
var _1ce=encodeURIComponent(JSON.stringify(this.additionalHeader));
var _1cf="&"+_1c9+"="+_1ce;
_1cb+=_1cf;
}
if(this.payload!=null){
var _1d0=encodeURIComponent(this.payload);
var _1d1="&"+_1ca+"="+_1d0;
_1cb+=_1d1;
}
return _1cb;
};
this.deserialize=function(_1d2){
var _1d3=_1d2.split("&");
for(var i=0;i<_1d3.length;i++){
var _1d5=_1d3[i].split("=");
switch(_1d5[0]){
case _1c7:
this.type=_1d5[1];
break;
case _1c8:
this.topic=decodeURIComponent(_1d5[1]);
break;
case _1c9:
var _1d6=decodeURIComponent(_1d5[1]);
this.additionalHeader=JSON.parse(_1d6);
break;
case _1ca:
this.payload=decodeURIComponent(_1d5[1]);
break;
}
}
};
};
_11b.SECommMessage.CONNECT="con";
_11b.SECommMessage.CONNECT_ACK="cac";
_11b.SECommMessage.DISCONNECT="xcon";
_11b.SECommMessage.DISCONNECT_ACK="xac";
_11b.SECommMessage.PUBLISH="pub";
_11b.SECommMessage.DISTRIBUTE="dis";
_11b.SECommMessage.SUBSCRIBE="sub";
_11b.SECommMessage.UNSUBSCRIBE="uns";
_11b.SECommMessage.SUBSCRIBE_ACK="sac";
_11b.SECommMessage.ERROR="err";
_11b.SECommErrors={};
_11b.SECommErrors.tunnelNotSetError=new Error("The tunnel URI was not set. Please set the tunnel URI.");
_11b.SEComm=function(){
var _1d7=1;
var _1d8=null;
var _1d9=0;
var _1da=null;
var _1db=null;
var _1dc=null;
var _1dd=null;
var _1de=null;
var _1df=[];
var _1e0=null;
var _1e1=null;
var _1e2=null;
var _1e3=null;
var _1e4=null;
var that=this;
var _1e6=false;
var _1e7=null;
this.setSecurityListener=function(_1e8){
_1e4=_1e8;
};
function _1e9(uri,_1eb){
var _1ec=uri.split("?");
if(_1ec.length>1){
return _1ec[0]+"?"+_1eb+"&"+_1ec[1];
}
_1ec=uri.split("#");
if(_1ec.length>1){
return _1ec[0]+"?"+_1eb+_1ec[1];
}
return uri+"?"+_1eb;
};
this.prepareForLoad=function(_1ed,_1ee,_1ef,_1f0,_1f1){
_1e7=_1f1;
this.log("Parent connecting to : "+_1ed);
_1e1=_1ef;
_1de=_1ed;
_1d9=_1f0;
if(_11b.SEComm.tunnelURI==null){
throw _11b.SECommErrors.tunnelNotSetError;
}
_1e3=_11b._generateSecurityToken();
_1db=_1e9(_1ee,"oahm="+_11b._protocolID+":100"+_1e3+_1e3+"000"+encodeURIComponent(_1ed)+":"+encodeURIComponent(_11b.SEComm.tunnelURI));
_11b.SEComm.instances[_1ed]=that;
_1d8=setInterval(_1f2,_1d9);
return _1db;
};
function _1f2(){
clearInterval(_1d8);
_1d8=null;
if(!_1dc){
that.handleSecurityError(_11b.SecurityErrors.COMPONENT_LOAD);
}
};
function _1f3(){
clearInterval(_1da);
that.handleSecurityError(_11b.SecurityErrors.COMPONENT_LOAD);
};
this.getScope=function(){
return this;
};
this.getCallback=function(){
return "messageReceived";
};
this.initializationFinished=function(_1f4,_1f5,_1f6,_1f7,_1f8){
this.log("Tunnel commLib initialization finished. Processing outgoing queue. Security token: "+_1f5);
if(_1e3!=_1f5){
that.handleSecurityError(_11b.SecurityErrors.TOKEN_VERIFICATION_FAILED);
return false;
}else{
_1dc=_1f4;
_1e6=true;
this.log("Token verified.");
_1f8.onunload=_1f9;
_1e1.componentLoaded(_1de,_1f6);
while(_1df.length>0){
_1dc.send(_1df.shift());
}
return true;
}
};
this.prepareForUnload=function(){
if(_1d8!=null){
clearInterval(_1d8);
_1d8=null;
}
};
function _1fa(_1fb,_1fc){
return function(){
_1e4(_1fb,_1fc);
};
};
this.handleSecurityError=function(_1fd){
if(_1fd==_11b.SecurityErrors.COMPONENT_LOAD){
this.initializationFinished=function(){
return false;
};
}
if(_1e4==null){
throw new Error(_1fd);
}else{
_1e4(_1fd,_1de);
}
return;
};
function _1f9(){
if(_1e4==null){
setTimeout("throw tunnelUnloadError;",_1d7);
}else{
setTimeout(_1fa(_11b.SecurityErrors.TUNNEL_UNLOAD,_1de),_1d7);
}
};
this.messageReceived=function(_1fe){
var msg=new _11b.SECommMessage();
msg.deserialize(_1fe);
switch(msg.type){
case _11b.SECommMessage.PUBLISH:
if(msg.additionalHeader!=null){
var _200=msg.payload;
if(msg.additionalHeader.f=="J"){
_200=JSON.parse(msg.payload);
}
_1e1.publishInternal(_1de,msg.topic,_200);
}
break;
case _11b.SECommMessage.SUBSCRIBE:
if(msg.additionalHeader!=null){
var isOk=true;
var _202="";
try{
_1e1.subscribeInternal(_1de,msg.additionalHeader.subId,msg.topic);
}
catch(e){
isOk=false;
_202=e.message;
}
var _203=new _11b.SECommMessage();
_203.type=_11b.SECommMessage.SUBSCRIBE_ACK;
_203.additionalHeader={subId:msg.additionalHeader.subId,isOk:isOk,err:_202};
send(_203.serialize());
}
break;
case _11b.SECommMessage.UNSUBSCRIBE:
if(msg.additionalHeader!=null){
_1e1.unsubscribeInternal(_1de,msg.additionalHeader.subId);
}
break;
case _11b.SECommMessage.CONNECT:
clearInterval(_1da);
_1e1.componentLoaded(_1de,msg.payload);
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.CONNECT_ACK;
send(msg.serialize());
break;
case _11b.SECommMessage.DISCONNECT:
_1e1.disconnect(_1de);
_1da=setInterval(_1f3,_1d9);
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.DISCONNECT_ACK;
send(msg.serialize());
break;
}
};
this.distribute=function(_205,_206,_207){
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.DISTRIBUTE;
msg.topic=_205;
msg.additionalHeader={s:_206};
if((typeof _207)=="string"){
msg.additionalHeader.f="S";
msg.payload=_207;
}else{
msg.additionalHeader.f="J";
msg.payload=JSON.stringify(_207);
}
send(msg.serialize());
};
function send(_209){
if(_1e6==false){
_1df.push(_209);
}else{
_1dc.send(_209);
}
};
this.log=function(msg){
_1e7(msg);
};
};
_11b.SEComm.instances=[];
_11b.SECommClient=function(_20b,_20c){
var _20d=[];
_20d["child"]=this;
var _20e=new _11b.CommLib(true,_20d,_20b);
var that=this;
var _210=[];
var _211=false;
var _212=null;
var _213={f:"J"};
var _214={f:"S"};
var _215=null;
this.publish=function(_216,data){
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.PUBLISH;
msg.topic=_216;
if((typeof data)=="string"){
msg.additionalHeader=_214;
msg.payload=data;
}else{
msg.additionalHeader=_213;
msg.payload=JSON.stringify(data);
}
send(msg.serialize());
};
this.subscribe=function(_21a,_21b){
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.SUBSCRIBE;
msg.topic=_21b;
msg.additionalHeader={subId:_21a};
send(msg.serialize());
};
this.connect=function(_21d){
if(_211){
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.CONNECT;
msg.payload=window.location.href.split("#")[0];
send(msg.serialize());
return;
}
connectCallback=_21d;
};
this.disconnect=function(){
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.DISCONNECT;
send(msg.serialize());
};
this.initializationFinished=function(_220){
this.log("Initialization finished. Processing outgoing queue.");
_215=new _221(_220);
_211=true;
connectCallback(true);
while(_210.length>0){
_20e.send(_210.shift());
}
};
this.getParsedTunnelUrl=function(){
return _215;
};
var _222=new RegExp("^((http|https):)?(//([^/?#:]*))?(:([0-9]*))?([^?#]*)(\\?([^#]*))?");
function _221(url){
var _224=url.match(_222);
this.scheme=(_224[2]=="")?null:_224[2];
this.host=(_224[4]=="")?null:_224[4];
this.port=(_224[6]=="")?null:_224[6];
this.path=(_224[7]=="")?null:_224[7];
this.query=(_224[8]=="")?null:_224[8];
};
this.unsubscribe=function(_225){
var msg=new _11b.SECommMessage();
msg.type=_11b.SECommMessage.UNSUBSCRIBE;
msg.additionalHeader={subId:_225};
send(msg.serialize());
};
function send(_227){
if(_211==false){
_210.push(_227);
}else{
_20e.send(_227);
}
};
this.messageReceived=function(_228){
var msg=new _11b.SECommMessage();
msg.deserialize(_228);
if(msg.type==_11b.SECommMessage.DISTRIBUTE){
var _22a=msg.additionalHeader;
if((_22a!=null)&&(_22a.f=="J")){
msg.payload=JSON.parse(msg.payload);
}
}
that.handleIncomingMessage(msg);
};
this.handleSecurityError=function(_22b){
if(_212==null){
throw new Error(_22b);
}else{
_212(_22b,_20b);
}
return;
};
this.setSecurityListener=function(_22c){
_212=_22c;
};
this.handleIncomingMessage=function(_22d){
alert("SECommClient\n\nTopic: "+_22d.topic+"\n\nPayload: "+_22d.payload);
};
this.log=function(msg){
_20c(msg);
};
};
_11b.CommLib=function(_22f,_230,_231){
var INIT="1";
var ACK="2";
var PART="3";
var END="4";
var that=this;
var _237=100;
var _238=4000;
var _239=6;
var ack=0;
var _23b=null;
var _23c=null;
var _23d=null;
var _23e=null;
var _23f=null;
var _240=null;
var _241=null;
var _242=[];
var msn=0;
var _244="";
var _245=null;
var _246=null;
var _247=null;
var _248=null;
var logQ=[];
this.send=function(_24a){
if(_240==null){
log("Trying to send without proper initialization. Message will be discarded. "+_24a);
return;
}
log("Sending: "+_24a);
var _24c=_24a;
var _24d=_238-_239-_11b._securityTokenOverhead-_240.length;
var _24e=_24c;
while(_24e.length>0){
var part=_24e.substr(0,_24d);
_24e=_24e.substr(_24d);
if(_24e==0){
_242.push({type:END,payload:part});
}else{
_242.push({type:PART,payload:part});
}
}
};
function _250(){
if(_251()){
if(_252()){
if(_253()){
_254();
}
}
}
if(_255()){
_256();
}
};
function _255(){
if(_23f.type==ACK){
return true;
}
if((_23f.msn==_23c.ackMsn)&&(_23c.ack==1)){
return true;
}
log("Waiting for ACK : "+_23f.msn);
return false;
};
function _257(){
msn++;
if(msn==100){
msn=0;
}
if(msn<10){
return "0"+msn;
}
return ""+msn;
};
function _251(){
var _258=window.location.href.split("#");
if(_258.length==2){
var _259=_258[1];
if(_259!=""&&_259!=_23b){
_23b=_259;
return true;
}
}
return false;
};
function _252(){
var type=_23b.substr(0,1);
var msn=_23b.substr(1,2);
var _25c=3;
var _25d=_23b.substr(_25c,_11b._securityTokenLength);
_25c+=_11b._securityTokenLength;
var _25e=_23b.substr(_25c,_11b._securityTokenLength);
_25c+=_11b._securityTokenLength;
var ack=_23b.substr(_25c,1);
_25c+=1;
var _260=_23b.substr(_25c,2);
_25c+=2;
var _261=_23b.substr(_25c);
log("In : Type: "+type+" msn: "+msn+" tokenParent: "+_25d+" tokenChild: "+_25e+" ack: "+ack+" msn: "+_260+" payload: "+_261);
_23c={type:type,msn:msn,tokenParent:_25d,tokenChild:_25e,ack:ack,ackMsn:_260,payload:_261};
return true;
};
function _253(){
if(_23c.type!=INIT&&(_23c.tokenParent!=_246||_23c.tokenChild!=_247)){
log("Security token error: Invalid security token received. The message will be discarded.");
_262(_11b.SecurityErrors.INVALID_TOKEN);
return false;
}
return true;
};
function _254(){
ack=1;
if(_23c.type!=INIT&&_22f&&_23f.type==INIT&&_23c.ack=="1"&&_23f.msn==_23c.ackMsn){
_248.initializationFinished(_240);
}
switch(_23c.type){
case INIT:
_263();
break;
case ACK:
_264();
break;
case PART:
_265();
break;
case END:
_266();
break;
}
_23d=_23c;
};
function _263(){
var _267=_23c.payload.split(":");
var _268=decodeURIComponent(_267[0]);
_240=decodeURIComponent(_267[1]);
_246=_23c.tokenParent;
_247=_23c.tokenChild;
if(_22f){
if(_231!=null){
_268=_231;
}
_247=_11b._generateSecurityToken();
var _269="3827816c-f3b1-11db-8314-0800200c9a66";
var _26a=document.createElement("iframe");
var _26b=encodeURIComponent(window.location.href.split("#")[0]);
var _26c=_26b;
var _26d=encodeURIComponent(_268)+":"+_26b+":"+_26c;
_240+=(_240.indexOf("?")!=-1?"&":"?")+"oahm=100"+_246+_247+"100"+_26d;
_26a.src=_240;
_26a.name=_269;
_26a.id=_269;
document.body.appendChild(_26a);
_26a.style.position="absolute";
_26a.style.left=_26a.style.top="-10px";
_26a.style.height=_26a.style.width="1px";
_26a.style.visibility="hidden";
ack=0;
_241=window.frames[_269];
_23f={type:INIT,msn:"00",tokenParent:_246,tokenChild:_247,ack:"0",ackMsn:"00",payload:_26d};
_248=_230["child"];
}else{
var _26c=decodeURIComponent(_267[2]);
_241=window.parent;
_248=_230[_268];
var _26e=_248.initializationFinished(that,_246,_240,_26c,window);
if(!_26e){
ack=0;
}
_23f={type:INIT,msn:"00",tokenParent:_246,tokenChild:_247,ack:"0",ackMsn:"00",payload:(encodeURIComponent(_268)+":"+encodeURIComponent(window.location.href.split("#")[0]))};
}
if(_241==null){
log("Init failed.");
}
};
function _264(){
ack=0;
};
function _265(){
_244+=_23c.payload;
};
function _266(){
_244+=_23c.payload;
log("Received: "+_244);
_248.messageReceived(_244);
_244="";
};
function _256(){
if(_242.length==0&&ack==1){
_242.push({type:ACK,payload:""});
}
if(_242.length!=0){
_23e=_242.shift();
_23e.tokenParent=_246;
_23e.tokenChild=_247;
_23e.msn=_257();
_23e.ack="1";
_23e.ackMsn=_23d.msn;
ack=0;
_26f();
}
};
function _26f(){
var url=_240+"#"+_23e.type+_23e.msn+_23e.tokenParent+_23e.tokenChild+_23e.ack+_23e.ackMsn+_23e.payload;
_241.location.replace(url);
_23f=_23e;
log("Out: Type: "+_23e.type+" msn: "+_23e.msn+" tokenParent: "+_23e.tokenParent+" tokenChild: "+_23e.tokenChild+" ack: "+_23e.ack+" msn: "+_23e.ackMsn+" payload: "+_23e.payload);
};
function _262(_271){
clearInterval(_245);
_248.handleSecurityError(_271);
};
function log(msg){
if(_248){
while(logQ.length>0){
_248.log(logQ.shift());
}
_248.log(msg);
}else{
logQ.push(msg);
}
};
_245=setInterval(_250,_237);
};
})();
if(typeof OpenAjax._smash=="undefined"){
OpenAjax._smash={};
}
OpenAjax._smash.crypto={"strToWA":function(str,_274){
var bin=Array();
var mask=(1<<_274)-1;
for(var i=0;i<str.length*_274;i+=_274){
bin[i>>5]|=(str.charCodeAt(i/_274)&mask)<<(32-_274-i%32);
}
return bin;
},"hmac_sha1":function(_278,_279,_27a){
var ipad=Array(16),opad=Array(16);
for(var i=0;i<16;i++){
ipad[i]=_278[i]^909522486;
opad[i]=_278[i]^1549556828;
}
var hash=this.sha1(ipad.concat(this.strToWA(_279,_27a)),512+_279.length*_27a);
return this.sha1(opad.concat(hash),512+160);
},"newPRNG":function(_27f){
that=this;
if((typeof _27f!="string")||(_27f.length<12)){
alert("WARNING: Seed length too short ...");
}
var _280=[43417,15926,18182,33130,9585,30800,49772,40144,47678,55453,4659,38181,65340,6787,54417,65301];
var _281=[];
var _cnt=0;
function _283(_284){
return that.hmac_sha1(_280,_284,8);
};
function _285(_286){
var _287=_283(_286);
for(var i=0;i<5;i++){
_281[i]^=_287[i];
}
};
_285(_27f);
return {"addSeed":function(seed){
_285(seed);
},"nextRandomOctets":function(len){
var _28b=[];
while(len>0){
_cnt+=1;
var _28c=that.hmac_sha1(_281,(_cnt).toString(16),8);
for(i=0;(i<20)&(len>0);i++,len--){
_28b.push((_28c[i>>2]>>(i%4))%256);
}
}
return _28b;
},"nextRandomB64Str":function(len){
var _28e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
var _28f=this.nextRandomOctets(len);
var _290="";
for(var i=0;i<len;i++){
_290+=_28e.charAt(_28f[i]&63);
}
return _290;
}};
},"sha1":function(){
var _292=function(x,y){
var lsw=(x&65535)+(y&65535);
var msw=(x>>16)+(y>>16)+(lsw>>16);
return (msw<<16)|(lsw&65535);
};
var rol=function(num,cnt){
return (num<<cnt)|(num>>>(32-cnt));
};
function _29a(t,b,c,d){
if(t<20){
return (b&c)|((~b)&d);
}
if(t<40){
return b^c^d;
}
if(t<60){
return (b&c)|(b&d)|(c&d);
}
return b^c^d;
};
function _29f(t){
return (t<20)?1518500249:(t<40)?1859775393:(t<60)?-1894007588:-899497514;
};
return function(_2a1,_2a2){
_2a1[_2a2>>5]|=128<<(24-_2a2%32);
_2a1[((_2a2+64>>9)<<4)+15]=_2a2;
var W=Array(80);
var H0=1732584193;
var H1=-271733879;
var H2=-1732584194;
var H3=271733878;
var H4=-1009589776;
for(var i=0;i<_2a1.length;i+=16){
var a=H0;
var b=H1;
var c=H2;
var d=H3;
var e=H4;
for(var j=0;j<80;j++){
W[j]=((j<16)?_2a1[i+j]:rol(W[j-3]^W[j-8]^W[j-14]^W[j-16],1));
var T=_292(_292(rol(a,5),_29a(j,b,c,d)),_292(_292(e,W[j]),_29f(j)));
e=d;
d=c;
c=rol(b,30);
b=a;
a=T;
}
H0=_292(a,H0);
H1=_292(b,H1);
H2=_292(c,H2);
H3=_292(d,H3);
H4=_292(e,H4);
}
return Array(H0,H1,H2,H3,H4);
};
}()};
if(!this.JSON){
JSON={};
}
(function(){
function f(n){
return n<10?"0"+n:n;
};
if(typeof Date.prototype.toJSON!=="function"){
Date.prototype.toJSON=function(key){
return this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z";
};
String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){
return this.valueOf();
};
}
var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,_2b6=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,_2b8,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r","\"":"\\\"","\\":"\\\\"},rep;
function _2bb(_2bc){
_2b6.lastIndex=0;
return _2b6.test(_2bc)?"\""+_2bc.replace(_2b6,function(a){
var c=meta[a];
return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4);
})+"\"":"\""+_2bc+"\"";
};
function str(key,_2c1){
var i,k,v,_2c5,mind=gap,_2c7,_2c8=_2c1[key];
if(_2c8&&typeof _2c8==="object"&&typeof _2c8.toJSON==="function"){
_2c8=_2c8.toJSON(key);
}
if(typeof rep==="function"){
_2c8=rep.call(_2c1,key,_2c8);
}
switch(typeof _2c8){
case "string":
return _2bb(_2c8);
case "number":
return isFinite(_2c8)?String(_2c8):"null";
case "boolean":
case "null":
return String(_2c8);
case "object":
if(!_2c8){
return "null";
}
gap+=_2b8;
_2c7=[];
if(Object.prototype.toString.apply(_2c8)==="[object Array]"){
_2c5=_2c8.length;
for(i=0;i<_2c5;i+=1){
_2c7[i]=str(i,_2c8)||"null";
}
v=_2c7.length===0?"[]":gap?"[\n"+gap+_2c7.join(",\n"+gap)+"\n"+mind+"]":"["+_2c7.join(",")+"]";
gap=mind;
return v;
}
if(rep&&typeof rep==="object"){
_2c5=rep.length;
for(i=0;i<_2c5;i+=1){
k=rep[i];
if(typeof k==="string"){
v=str(k,_2c8);
if(v){
_2c7.push(_2bb(k)+(gap?": ":":")+v);
}
}
}
}else{
for(k in _2c8){
if(Object.hasOwnProperty.call(_2c8,k)){
v=str(k,_2c8);
if(v){
_2c7.push(_2bb(k)+(gap?": ":":")+v);
}
}
}
}
v=_2c7.length===0?"{}":gap?"{\n"+gap+_2c7.join(",\n"+gap)+"\n"+mind+"}":"{"+_2c7.join(",")+"}";
gap=mind;
return v;
}
};
if(typeof JSON.stringify!=="function"){
JSON.stringify=function(_2c9,_2ca,_2cb){
var i;
gap="";
_2b8="";
if(typeof _2cb==="number"){
for(i=0;i<_2cb;i+=1){
_2b8+=" ";
}
}else{
if(typeof _2cb==="string"){
_2b8=_2cb;
}
}
rep=_2ca;
if(_2ca&&typeof _2ca!=="function"&&(typeof _2ca!=="object"||typeof _2ca.length!=="number")){
throw new Error("JSON.stringify");
}
return str("",{"":_2c9});
};
}
if(typeof JSON.parse!=="function"){
JSON.parse=function(text,_2ce){
if(text==null) return {};
var j;
function walk(_2d1,key){
var k,v,_2d5=_2d1[key];
if(_2d5&&typeof _2d5==="object"){
for(k in _2d5){
if(Object.hasOwnProperty.call(_2d5,k)){
v=walk(_2d5,k);
if(v!==undefined){
_2d5[k]=v;
}else{
delete _2d5[k];
}
}
}
}
return _2ce.call(_2d1,key,_2d5);
};
cx.lastIndex=0;
if(cx.test(text)){
text=text.replace(cx,function(a){
return "\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4);
});
}
if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){
j=eval("("+text+")");
return typeof _2ce==="function"?walk({"":j},""):j;
}
throw new SyntaxError("JSON.parse");
};
}
})();
OpenAjax.hub.InlineContainer=function(hub,_2d8,_2d9){
if(!hub||!_2d8||!_2d9||!_2d9.Container||!_2d9.Container.onSecurityAlert){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
this._params=_2d9;
this._hub=hub;
this._id=_2d8;
this._onSecurityAlert=_2d9.Container.onSecurityAlert;
this._onConnect=_2d9.Container.onConnect?_2d9.Container.onConnect:null;
this._onDisconnect=_2d9.Container.onDisconnect?_2d9.Container.onDisconnect:null;
this._scope=_2d9.Container.scope||window;
if(_2d9.Container.log){
var _2da=this._scope;
var _2db=_2d9.Container.log;
this._log=function(msg){
_2db.call(_2da,"InlineContainer::"+_2d8+": "+msg);
};
}else{
this._log=function(){
};
}
this._connected=false;
this._subs=[];
this._subIndex=0;
hub.addContainer(this);
};
OpenAjax.hub.InlineContainer.prototype.getHub=function(){
return this._hub;
};
OpenAjax.hub.InlineContainer.prototype.sendToClient=function(_2dd,data,_2df){
if(this.isConnected()){
var sub=this._subs[_2df];
try{
sub.cb.call(sub.sc,_2dd,data,sub.d);
}
catch(e){
OpenAjax.hub._debugger();
this._client._log("caught error from onData callback to HubClient.subscribe(): "+e.message);
}
}
};
OpenAjax.hub.InlineContainer.prototype.remove=function(){
if(this.isConnected()){
this._disconnect();
}
};
OpenAjax.hub.InlineContainer.prototype.isConnected=function(){
return this._connected;
};
OpenAjax.hub.InlineContainer.prototype.getClientID=function(){
return this._id;
};
OpenAjax.hub.InlineContainer.prototype.getPartnerOrigin=function(){
if(this._connected){
return window.location.protocol+"//"+window.location.hostname;
}
return null;
};
OpenAjax.hub.InlineContainer.prototype.getParameters=function(){
return this._params;
};
OpenAjax.hub.InlineContainer.prototype.connect=function(_2e1,_2e2,_2e3){
if(this._connected){
throw new Error(OpenAjax.hub.Error.Duplicate);
}
this._connected=true;
this._client=_2e1;
if(this._onConnect){
try{
this._onConnect.call(this._scope,this);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onConnect callback to constructor: "+e.message);
}
}
this._invokeOnComplete(_2e2,_2e3,_2e1,true);
};
OpenAjax.hub.InlineContainer.prototype.disconnect=function(_2e4,_2e5,_2e6){
if(!this._connected){
throw new Error(OpenAjax.hub.Error.Disconnected);
}
this._disconnect();
if(this._onDisconnect){
try{
this._onDisconnect.call(this._scope,this);
}
catch(e){
OpenAjax.hub._debugger();
this._log("caught error from onDisconnect callback to constructor: "+e.message);
}
}
this._invokeOnComplete(_2e5,_2e6,_2e4,true);
};
OpenAjax.hub.InlineContainer.prototype.subscribe=function(_2e7,_2e8,_2e9,_2ea,_2eb){
this._assertConn();
this._assertSubTopic(_2e7);
if(!_2e8){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
var _2ec=""+this._subIndex++;
var _2ed=false;
var msg=null;
try{
var _2ef=this._hub.subscribeForClient(this,_2e7,_2ec);
_2ed=true;
}
catch(e){
_2ec=null;
msg=e.message;
}
_2e9=_2e9||window;
if(_2ed){
this._subs[_2ec]={h:_2ef,cb:_2e8,sc:_2e9,d:_2eb};
}
this._invokeOnComplete(_2ea,_2e9,_2ec,_2ed,msg);
return _2ec;
};
OpenAjax.hub.InlineContainer.prototype.publish=function(_2f0,data){
this._assertConn();
this._assertPubTopic(_2f0);
this._hub.publishForClient(this,_2f0,data);
};
OpenAjax.hub.InlineContainer.prototype.unsubscribe=function(_2f2,_2f3,_2f4){
this._assertConn();
if(typeof _2f2==="undefined"||_2f2==null){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
var sub=this._subs[_2f2];
if(!sub){
throw new Error(OpenAjax.hub.Error.NoSubscription);
}
this._hub.unsubscribeForClient(this,sub.h);
delete this._subs[_2f2];
this._invokeOnComplete(_2f3,_2f4,_2f2,true);
};
OpenAjax.hub.InlineContainer.prototype.getSubscriberData=function(_2f6){
this._assertConn();
return this._getSubscription(_2f6).d;
};
OpenAjax.hub.InlineContainer.prototype.getSubscriberScope=function(_2f7){
this._assertConn();
return this._getSubscription(_2f7).sc;
};
OpenAjax.hub.InlineContainer.prototype._invokeOnComplete=function(func,_2f9,item,_2fb,_2fc){
if(func){
try{
_2f9=_2f9||window;
func.call(_2f9,item,_2fb,_2fc);
}
catch(e){
OpenAjax.hub._debugger();
this._client._log("caught error from onComplete callback: "+e.message);
}
}
};
OpenAjax.hub.InlineContainer.prototype._disconnect=function(){
for(var _2fd in this._subs){
this._hub.unsubscribeForClient(this,this._subs[_2fd].h);
}
this._subs=[];
this._subIndex=0;
this._connected=false;
};
OpenAjax.hub.InlineContainer.prototype._assertConn=function(){
if(!this._connected){
throw new Error(OpenAjax.hub.Error.Disconnected);
}
};
OpenAjax.hub.InlineContainer.prototype._assertPubTopic=function(_2fe){
if((_2fe==null)||(_2fe=="")||(_2fe.indexOf("*")!=-1)||(_2fe.indexOf("..")!=-1)||(_2fe.charAt(0)==".")||(_2fe.charAt(_2fe.length-1)==".")){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
};
OpenAjax.hub.InlineContainer.prototype._assertSubTopic=function(_2ff){
if(!_2ff){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
var path=_2ff.split(".");
var len=path.length;
for(var i=0;i<len;i++){
var p=path[i];
if((p=="")||((p.indexOf("*")!=-1)&&(p!="*")&&(p!="**"))){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
if((p=="**")&&(i<len-1)){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
}
};
OpenAjax.hub.InlineContainer.prototype._getSubscription=function(_304){
var sub=this._subs[_304];
if(sub){
return sub;
}
throw new Error(OpenAjax.hub.Error.NoSubscription);
};
OpenAjax.hub.InlineHubClient=function(_306){
if(!_306||!_306.HubClient||!_306.HubClient.onSecurityAlert||!_306.InlineHubClient||!_306.InlineHubClient.container){
throw new Error(OpenAjax.hub.Error.BadParameters);
}
this._params=_306;
this._onSecurityAlert=_306.HubClient.onSecurityAlert;
this._scope=_306.HubClient.scope||window;
this._container=_306.InlineHubClient.container;
if(_306.HubClient.log){
var id=this._container.getClientID();
var _308=this._scope;
var _309=_306.HubClient.log;
this._log=function(msg){
_309.call(_308,"InlineHubClient::"+id+": "+msg);
};
}else{
this._log=function(){
};
}
};
OpenAjax.hub.InlineHubClient.prototype.connect=function(_30b,_30c){
this._container.connect(this,_30b,_30c);
};
OpenAjax.hub.InlineHubClient.prototype.disconnect=function(_30d,_30e){
this._container.disconnect(this,_30d,_30e);
};
OpenAjax.hub.InlineHubClient.prototype.getPartnerOrigin=function(){
return this._container.getPartnerOrigin();
};
OpenAjax.hub.InlineHubClient.prototype.getClientID=function(){
return this._container.getClientID();
};
OpenAjax.hub.InlineHubClient.prototype.subscribe=function(_30f,_310,_311,_312,_313){
return this._container.subscribe(_30f,_310,_311,_312,_313);
};
OpenAjax.hub.InlineHubClient.prototype.publish=function(_314,data){
this._container.publish(_314,data);
};
OpenAjax.hub.InlineHubClient.prototype.unsubscribe=function(_316,_317,_318){
this._container.unsubscribe(_316,_317,_318);
};
OpenAjax.hub.InlineHubClient.prototype.isConnected=function(){
return this._container.isConnected();
};
OpenAjax.hub.InlineHubClient.prototype.getScope=function(){
return this._scope;
};
OpenAjax.hub.InlineHubClient.prototype.getSubscriberData=function(_319){
return this._container.getSubscriberData(_319);
};
OpenAjax.hub.InlineHubClient.prototype.getSubscriberScope=function(_31a){
return this._container.getSubscriberScope(_31a);
};
OpenAjax.hub.InlineHubClient.prototype.getParameters=function(){
return this._params;
};

