/* Copyright IBM Corp. 2008  All Rights Reserved.                    */
dojo.provide("com.ibm.mm.enabler.debug");
if(!dojo._hasResource["com.ibm.mm.enabler.status"]){
dojo._hasResource["com.ibm.mm.enabler.status"]=true;
dojo.provide("com.ibm.mm.enabler.status");
dojo.declare("com.ibm.mm.enabler.status.StatusType",null,{constructor:function(id,_2,_3,_4){
this._id=id;
this._styleClass=_2;
this._iconPath=_3;
this._color=_4;
}});
dojo.declare("com.ibm.mm.enabler.status.StatusMessage",null,{constructor:function(_5,_6,_7){
this._type=_5;
this._message=_6;
this._details=_7;
},render:function(_8){
var _9=com.ibm.mm.enabler.status.statusTypesMap[this._type];
var _a=document.createElement("div");
_a.className=_9._styleClass;
var _b=document.createElement("h5");
var _c=document.createElement("div");
_c.className="statusHeaderLHS";
var _d=document.createElement("img");
_d.src=_9._iconPath;
_c.appendChild(_d);
_c.appendChild(document.createTextNode(this._message));
_b.appendChild(_c);
_a.appendChild(_b);
if(this._details){
var _e=document.createElement("div");
_e.className="details";
_e.appendChild(document.createTextNode(this._details));
_a.appendChild(_e);
}
_8.appendChild(_a);
}});
dojo.declare("com.ibm.mm.enabler.status.StatusTypesMap",null,{constructor:function(){
this._baseURL=new dojo.moduleUrl("com.ibm.mm.enabler","image/");
this.error=new com.ibm.mm.enabler.status.StatusType(0,"error",this._baseURL+"error.gif","#FF0000");
this.warn=new com.ibm.mm.enabler.status.StatusType(1,"warning",this._baseURL+"warning.gif","FFFF00");
this.info=new com.ibm.mm.enabler.status.StatusType(2,"info",this._baseURL+"info.gif","#0077FF");
this.constants={"ERROR":"error","WARN":"warn","INFO":"info"};
}});
com.ibm.mm.enabler.status.statusTypesMap=new com.ibm.mm.enabler.status.StatusTypesMap();
}
if(!dojo._hasResource["dojo.string"]){
dojo._hasResource["dojo.string"]=true;
dojo.provide("dojo.string");
dojo.string.rep=function(_f,num){
if(num<=0||!_f){
return "";
}
var buf=[];
for(;;){
if(num&1){
buf.push(_f);
}
if(!(num>>=1)){
break;
}
_f+=_f;
}
return buf.join("");
};
dojo.string.pad=function(_12,_13,ch,end){
if(!ch){
ch="0";
}
var out=String(_12),pad=dojo.string.rep(ch,Math.ceil((_13-out.length)/ch.length));
return end?out+pad:pad+out;
};
dojo.string.substitute=function(_18,map,_1a,_1b){
_1b=_1b||dojo.global;
_1a=(!_1a)?function(v){
return v;
}:dojo.hitch(_1b,_1a);
return _18.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_1d,key,_1f){
var _20=dojo.getObject(key,false,map);
if(_1f){
_20=dojo.getObject(_1f,false,_1b).call(_1b,_20,key);
}
return _1a(_20,key).toString();
});
};
dojo.string.trim=String.prototype.trim?dojo.trim:function(str){
str=str.replace(/^\s+/,"");
for(var i=str.length-1;i>=0;i--){
if(/\S/.test(str.charAt(i))){
str=str.substring(0,i+1);
break;
}
}
return str;
};
}
if(!dojo._hasResource["com.ibm.mashups.enabler.logging"]){
dojo._hasResource["com.ibm.mashups.enabler.logging"]=true;
dojo.provide("com.ibm.mashups.enabler.logging");
dojo.provide("com.ibm.mashups.enabler.logging.LogHandler");
dojo.provide("com.ibm.mashups.enabler.logging.Logger");
dojo.declare("com.ibm.mashups.enabler.logging.LogLevel",null,{TRACE:500,INFO:800,WARNING:900,SEVERE:1000});
com.ibm.mashups.enabler.logging.LogLevel=new com.ibm.mashups.enabler.logging.LogLevel();
dojo.declare("com.ibm.mashups.enabler.logging.LogHandler",null,{constructor:function(){
},getHandlerID:function(){
return null;
},getLogLevel:function(){
return null;
},log:function(_23,_24,_25,_26){
}});
dojo.declare("com.ibm.mashups.enabler.logging.Logger",null,{constructor:function(){
},getLogger:function(_27){
return null;
},addHandler:function(_28){
},removeHandler:function(_29){
},entering:function(_2a,_2b){
},exiting:function(_2c,_2d){
},info:function(_2e,_2f,_30){
},warning:function(_31,_32,_33){
},severe:function(_34,_35,_36){
},trace:function(_37,_38,_39){
},log:function(_3a,_3b,_3c,_3d){
},isLoggable:function(_3e){
return false;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.logging"]){
dojo._hasResource["com.ibm.mm.enabler.logging"]=true;
dojo.provide("com.ibm.mm.enabler.logging");
dojo.provide("com.ibm.mm.enabler.logging.ConsoleHandler");
dojo.provide("com.ibm.mm.enabler.logging.Logger");
dojo.declare("com.ibm.mm.enabler.logging.ConsoleHandler",[com.ibm.mashups.enabler.logging.LogHandler],{constructor:function(){
this.handlerID="com.ibm.mm.enabler.logging.ConsoleHandler";
this.logLevel=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
},getHandlerID:function(){
return this.handlerID;
},getLogLevel:function(){
return this.logLevel;
},log:function(_3f,_40,_41,_42){
if(_40==com.ibm.mashups.enabler.logging.LogLevel.SEVERE){
console.error(_3f+" "+_41+": "+_42);
}else{
if(_40==com.ibm.mashups.enabler.logging.LogLevel.WARNING){
console.warn(_3f+" "+_41+": "+_42);
}else{
if(_40==com.ibm.mashups.enabler.logging.LogLevel.INFO){
console.info(_3f+" "+_41+": "+_42);
}else{
if(_40==com.ibm.mashups.enabler.logging.LogLevel.TRACE){
console.debug(_3f+" "+_41+": "+_42);
}
}
}
}
}});
dojo.declare("com.ibm.mm.enabler.logging.LoggerImpl",[com.ibm.mashups.enabler.logging.Logger],{BASE_TOPIC:"com.ibm.mm.enabler.logging.",constructor:function(_43,_44){
this.loggers={};
this.handlers={};
this.name=_43?_43:null;
this.parentLogger=_44?_44:null;
if(!this.parentLogger){
if(ibmConfig&&ibmConfig.traceConfig&&dojo.isArray(ibmConfig.traceConfig)){
this._setTraceConfig(ibmConfig.traceConfig);
}else{
this._setTraceConfig();
}
}
},getLogger:function(_45){
if(this.parentLogger){
return this.parentLogger.getLogger(_45);
}
if(!this.loggers[_45]){
this.loggers[_45]=new com.ibm.mm.enabler.logging.LoggerImpl(_45,this);
}
return this.loggers[_45];
},addHandler:function(_46){
if(this.parentLogger){
return this.parentLogger.addHandler(_46);
}
this.handlers[_46.handlerID]={};
handlerObject=this.handlers[_46.handlerID];
handlerObject.handler=_46;
var _47=_46.getLogLevel();
var _48="log";
handlerObject.severeHandle=dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.SEVERE,_46,_48);
if(_47<=com.ibm.mashups.enabler.logging.LogLevel.WARNING){
handlerObject.warningHandle=dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.WARNING,_46,_48);
}
if(_47<=com.ibm.mashups.enabler.logging.LogLevel.INFO){
handlerObject.infoHandle=dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.INFO,_46,_48);
}
if(_47<=com.ibm.mashups.enabler.logging.LogLevel.TRACE){
handlerObject.traceHandle=dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.TRACE,_46,_48);
}
},removeHandler:function(_49){
var _4a=this.handlers[_49.getHandlerID()];
if(_4a){
if(_4a.severeHandle){
dojo.unsubscribe(_4a.severeHandle);
}
if(_4a.warningHandle){
dojo.unsubscribe(_4a.warningHandle);
}
if(_4a.infoHandle){
dojo.unsubscribe(_4a.infoHandle);
}
if(_4a.traceHandle){
dojo.unsubscribe(_4a.traceHandle);
}
if(_4a.handler){
delete _4a.handler;
}
}
this.handlers[_49.getHandlerID()]=null;
},entering:function(_4b,_4c){
var _4d=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
if(this.isLoggable(_4d)){
var msg=this._getMessageString(_4c);
this._log(this.name,_4d,_4b,"ENTRY"+(msg?" "+msg:""));
}
},exiting:function(_4f,_50){
var _51=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
if(this.isLoggable(_51)){
var msg=this._getMessageString(_50);
this._log(this.name,_51,_4f,"RETURN"+(msg?" "+msg:""));
}
},info:function(_53,_54,_55){
var _56=com.ibm.mashups.enabler.logging.LogLevel.INFO;
this.log(_56,_53,_54,_55);
},warning:function(_57,_58,_59){
var _5a=com.ibm.mashups.enabler.logging.LogLevel.WARNING;
this.log(_5a,_57,_58,_59);
},severe:function(_5b,_5c,_5d){
var _5e=com.ibm.mashups.enabler.logging.LogLevel.SEVERE;
this.log(_5e,_5b,_5c,_5d);
},trace:function(_5f,_60,_61){
var _62=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.log(_62,_5f,_60,_61);
},log:function(_63,_64,_65,_66){
if(!this.parentLogger){
this._log("com.ibm.mashups.enabler.logging.Logger",com.ibm.mashups.enabler.logging.LogLevel.WARNING,"{log|info|warning|severe|trace|entering|exiting}","You must not use the RootLogger (com.ibm.mashups.enabler.logging.Logger). Create your own logger for each class (https://w3.tap.ibm.com/w3ki03/display/MUM/Client+-+Development)");
}
if(this.isLoggable(_63)){
this._log(this.name,_63,_64,_65,_66);
}
},isLoggable:function(_67){
if(_67!=com.ibm.mashups.enabler.logging.LogLevel.TRACE){
return true;
}
if(!(ibmConfig&&ibmConfig.isDebug)){
return false;
}
var _68=this._getRegExp();
if(_68&&_68.exec(this.name)){
return true;
}
return false;
},_log:function(_69,_6a,_6b,_6c,_6d){
if((_6d&&!dojo.isArray(_6d))||_6d===false){
_6d=[_6d];
}
var _6e;
if(_6d){
_6e=dojo.string.substitute(_6c,_6d);
}else{
_6e=_6c;
}
dojo.publish(this.BASE_TOPIC+_6a,[_69,_6a,_6b,_6e]);
},_getMessageString:function(_6f){
var _70=0;
var msg="";
if(_6f||_6f===false){
msg+="[ ";
if(dojo.isArray(_6f)){
msg+=_6f.join(", ");
}else{
msg+=_6f;
}
msg+=" ]";
}
return msg;
},_setTraceConfig:function(_72){
if(_72){
this._log("RootLogger",com.ibm.mashups.enabler.logging.LogLevel.TRACE,"_setTraceConfig","Changing traceConfig: "+_72);
var _73=dojo.isArray(_72)?_72.join("|"):_72;
this.regExp=new RegExp(_73);
}else{
this.regExp=null;
}
},_getRegExp:function(){
if(this.parentLogger){
return this.parentLogger._getRegExp();
}
return this.regExp;
}});
com.ibm.mashups.enabler.logging.Logger=new com.ibm.mm.enabler.logging.LoggerImpl();
com.ibm.mashups.enabler.logging.Logger.addHandler(new com.ibm.mm.enabler.logging.ConsoleHandler());
}
if(!dojo._hasResource["com.ibm.mm.enabler.debug"]){
dojo._hasResource["com.ibm.mm.enabler.debug"]=true;
dojo.provide("com.ibm.mm.enabler.debug");
dojo.require("com.ibm.mm.enabler.status");
com.ibm.mm.enabler.debug.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.legacy");
com.ibm.mm.enabler.debug.Constants={MMLogging:"/mm/logging",MMStatusMsg:"/mm/statusMsg",MMTracing:"/mm/tracing",LOG:"log",INFO:"info",WARN:"warn",ERROR:"error"};
com.ibm.mm.enabler.debug.getObjectArryFromArguments=function(_74){
if(_74.length==1){
return null;
}
var _75=[];
for(var i=1;i<_74.length;i++){
_75[i-1]=_74[i];
}
return _75;
};
com.ibm.mm.enabler.debug.log=function(_77){
var _78=com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
var msg=com.ibm.mm.enabler.debug.LOGGER._getMessageString(_78);
com.ibm.mm.enabler.debug.LOGGER.trace(_77,msg);
};
com.ibm.mm.enabler.debug.entry=function(_7a){
var _7b=com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
com.ibm.mm.enabler.debug.LOGGER.entering(_7a,_7b);
};
com.ibm.mm.enabler.debug.exit=function(_7c){
var _7d=com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
com.ibm.mm.enabler.debug.LOGGER.exiting(_7c,_7d);
};
com.ibm.mm.enabler.debug.escapeXmlForHTMLDisplay=function(_7e){
_7e=_7e.replace(/</g,"&lt;");
_7e=_7e.replace(/>/g,"&gt;");
return _7e;
};
com.ibm.mm.enabler.debug.info=function(_7f){
var _80=com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
var msg=com.ibm.mm.enabler.debug.LOGGER._getMessageString(_80);
com.ibm.mm.enabler.debug.LOGGER.info(_7f,msg);
};
com.ibm.mm.enabler.debug.warn=function(_82){
var _83=com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
var msg=com.ibm.mm.enabler.debug.LOGGER._getMessageString(_83);
com.ibm.mm.enabler.debug.LOGGER.warning(_82,msg);
};
com.ibm.mm.enabler.debug.error=function(_85){
var _86=com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
var msg=com.ibm.mm.enabler.debug.LOGGER._getMessageString(_86);
com.ibm.mm.enabler.debug.LOGGER.severe(_85,msg);
};
com.ibm.mm.enabler.debug._log=function(_88,_89){
if(com.ibm.mm.enabler.debug.isLogging){
if(_89.length>=2&&dojo.isString(_89[1])){
var arr=[];
arr.push(_89[0]+_89[1]);
for(var i=2;i<_89.length;i++){
arr.push(_89[i]);
}
console[_88].apply(window.console,arr);
}else{
console[_88].apply(window.console,_89);
}
}
};
com.ibm.mm.enabler.debug._publishTracing=function(_8c,_8d){
if(typeof ibmConfig!="undefined"&&ibmConfig!==null&&ibmConfig.allowPublishTracing===true){
var _8e={};
_8e.type=_8c;
_8e.args=_8d;
var _8f=[];
_8f[0]=_8e;
dojo.publish(com.ibm.mm.enabler.debug.Constants.MMTracing,_8f);
}
};
com.ibm.mm.enabler.debug._publishLogging=function(_90,_91){
if(typeof ibmConfig!="undefined"&&ibmConfig!==null&&ibmConfig.allowPublishLogging===true){
var _92={};
_92.type=_90;
_92.args=_91;
var _93=[];
_93[0]=_92;
dojo.publish(com.ibm.mm.enabler.debug.Constants.MMLogging,_93);
}
};
if(typeof ibmConfig!="undefined"&&ibmConfig!==null&&ibmConfig.isDebug===true){
com.ibm.mm.enabler.debug.isLogging=true;
}else{
com.ibm.mm.enabler.debug.isLogging=false;
}
com.ibm.mm.enabler.debug.logInlineMessage=function(_94,_95,_96,_97,_98){
var _99=new com.ibm.mm.enabler.status.StatusMessage(_95,_96,_97);
if(_94){
_99.render(_94);
}
com.ibm.mm.enabler.debug._publishStatusMsg(_95,_96,_97,_98);
};
com.ibm.mm.enabler.debug._publishStatusMsg=function(_9a,_9b,_9c,_9d,_9e){
if(typeof ibmConfig!="undefined"&&ibmConfig!==null&&ibmConfig.allowPublishStatusMsg===true){
var _9f={};
_9f.type=_9a;
_9f.args=_9d;
_9f.message=_9b;
_9f.details=_9c;
_9f.component=_9e;
var _a0=[];
_a0[0]=_9f;
dojo.publish(com.ibm.mm.enabler.debug.Constants.MMStatusMsg,_a0);
}
};
}
if(!dojo._hasResource["com.ibm.mm.enabler.endpoints.endpoints"]){
dojo._hasResource["com.ibm.mm.enabler.endpoints.endpoints"]=true;
dojo.provide("com.ibm.mm.enabler.endpoints.endpoints");
dojo.declare("com.ibm.mm.enabler.endpoints.XHREndpointExtensionImpl",null,{LOG_LEVEL:com.ibm.mashups.enabler.logging.LogLevel.TRACE,constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_METHOD="dojo.xhrGet()";
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
this.originalDojoXHR=dojo.xhr;
dojo.xhr=dojo.hitch(this,function(_a1,_a2,_a3){
if(this.bIsLoggable){
this.LOGGER.entering(this.LOG_METHOD,[_a2]);
}
var url=_a2["url"];
var _a5=com.ibm.mm.enabler.model.Utils.checkForEndpoints(url);
if(_a5!=null){
_a2["url"]=_a5;
}
var ret=this.originalDojoXHR(_a1,_a2,_a3);
if(this.bIsLoggable){
this.LOGGER.exiting(this.LOG_METHOD);
}
return ret;
});
}});
com.ibm.mm.enabler.endpoints.XHREndpointExtension=new com.ibm.mm.enabler.endpoints.XHREndpointExtensionImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.services.ConfigService"]){
dojo._hasResource["com.ibm.mm.enabler.services.ConfigService"]=true;
dojo.provide("com.ibm.mm.enabler.services.ConfigService");
dojo.provide("com.ibm.mm.enabler.services.ConfigObject");
dojo.declare("com.ibm.mm.enabler.services.ConfigService",null,{PROXY_URL:"com.ibm.mashups.proxy.url",HUB_URL:"com.ibm.mashups.hub.url",LOGOUT_URL:"com.ibm.mashups.url.logout",LOGIN_URL:"com.ibm.mashups.url.login",CONTEXT_ROOT_MAIN:"com.ibm.mashups.contextroot",CONTEXT_ROOT_THEME_TEMP:"com.ibm.mashups.contextroot.theme.temp",CONTEXT_ROOT_BUILDER:"com.ibm.mashups.contextroot.builder",CONTEXT_ROOT_ENABLER:"com.ibm.mashups.contextroot.enabler",CONTENTHANDLER_PUBLIC:"com.ibm.mashups.contenthandler.public",CONTENTHANDLER_PRIVATE:"com.ibm.mashups.contenthandler.private",THEMES_FEEDS_EXPIRATION:"themes.feed.expiration",AVAILABLE_LOCALES:"available.locales",TUNNEL_MODE:"tunnel.mode",CLIENT_IS_DEBUG:"isDebug",CLIENT_IS_BIDI:"isBidi",WIDGETDEFID_SANDBOX_DISABLED:"com.ibm.mashups.sandbox.force.disable",CLIENT_ALLOW_PUBLISH_LOGGING:"allowPublishLogging",CLIENT_ALLOW_PUBLISH_TRACING:"allowPublishTracing",CLIENT_LOAD_SERVICES:"loadServices",CLIENT_POPUP_CONSOLE:"popupConsole",CLIENT_DEFAULT_THEME_ID:"com.ibm.mashups.theme.defaultThemeId",CLIENT_PAGE_SOURCE_READ_ONLY:"pageSourceReadOnly",CLIENT_AUTO_ACCEPT_SHARED_GROUPNAME:"autoAcceptSharedGroupName",CLIENT_USER_ID_KEY:"userIdKey",CLIENT_GROUP_CN_KEY:"groupCNKey",AUTO_WIRING_DEFAULT_ENABLED:"autoWiringDefaultEnabled",TRACE_CONFIG:"traceConfig",MULTIPART_ENABLED:"com.ibm.mashups.multipart.enabled",MULTIPART_CORRELATE_HOSTS:"com.ibm.mashups.multipart.correlatehosts",SUBDOMAINS:"subdomains",SERVERDOMAIN:"serverdomain",SANDBOXENABLED:"sandboxenabled",ENDPOINTS:"endpointIDs",ENDPOINT_CONFIG_PROVIDER:"Endpoints",NAVSTATE_PERSISTENCE_URL:"navstate.persistence.url",NAVSTATE_PERSISTENCE_PSTORE:"navstate.persistence.pstore",NAVSTATE_PERSISTENCE_URL_LIMIT:"navstate.persistence.url.limit",CREATE_SPACE_TEMPLATE_MODE:"createSpaceOnTemplateMode",FAVORITE_SPACES_MAXIMUM_NUMBER:"favorite.spaces.maximum.number",ENABLE_IMPORT_EXPORT_SPACE:"enable_import_export_space",WIDGET_BUILDER_ENABLED:"com.ibm.mashups.widgetBuilder.enabled",ANONYMOUS_USER:"anonymousUser",DEFAULT_USER_DISPLAY_PROP:"com.ibm.mashups.default.user.display.prop",DEFAULT_GROUP_DISPLAY_PROP:"com.ibm.mashups.default.group.display.prop",PRODUCT_NAME:"com.ibm.mashups.productname",ANON_VIRTUAL_USER_ID:"com.ibm.mashups.anonUserId",ALL_AUTH_VIRTUAL_GROUP_ID:"com.ibm.mashups.allAuthGroupId",ALL_AUTH_VIRTUAL_GROUP_ID:"com.ibm.mashups.allAuthGroupId",ANON_MODE_ENABLED:"com.ibm.mashups.anonymous.mode",constructor:function(){
this.ns={};
this.ns["app"]="http://www.w3.org/2007/app";
this.ns["atom"]="http://www.w3.org/2005/Atom";
},getPreferenceValue:function(_a7){
return this.getValue(_a7);
},getValue:function(_a8,_a9){
if(typeof _a9=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.services.ConfigService.getValue","This method must not be used directly. Use com.ibm.mashups.enabler.services.ConfigService.getValue instead.",_a8);
}
var _aa=ibmConfig[_a8];
return _aa;
},getConfigObject:function(_ab){
if(!ibmConfig["CO_"+_ab]){
var co=new com.ibm.mm.enabler.services.ConfigObject(_ab,this);
ibmConfig["CO_"+_ab]=co;
}
return ibmConfig["CO_"+_ab];
},getConfigProviderNames:function(){
var ret=[];
ret.push("all");
var _ae=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.CONFIG_URL,this);
_ae.setSchemeSpecificPart("/*");
_ae.setParameter("rep","compact");
var _af=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_ae,null,null,false,true);
var me=this;
_af.read(function(_b1,_b2,xhr,_b4){
var _b5=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("//atom:entry/atom:id",_b2,me.ns);
if(_b5&&_b5.length>0){
for(var i=0;i<_b5.length;i++){
var _b7=com.ibm.mm.enabler.dom.textContent(_b5[i]);
var _b8=_b7.indexOf("/",9);
_b7=_b7.substring(8,_b8).trim();
for(config in ibmConfig){
if(ibmConfig[config]===_b7){
_b7=config.substring(15);
}
}
ret.push(_b7);
}
}
});
return ret;
}});
dojo.declare("com.ibm.mm.enabler.services.ConfigObject",null,{constructor:function(_b9,_ba){
this.valuesArray=null;
this.provider=_b9;
this.configService=_ba;
this.ns={};
this.ns["app"]="http://www.w3.org/2007/app";
this.ns["atom"]="http://www.w3.org/2005/Atom";
},getPreferenceValue:function(_bb){
if(this.provider=="all"){
return this.configService.getValue(_bb);
}else{
return this._getValue(this.provider,_bb);
}
return null;
},getValue:function(_bc,_bd){
if(typeof _bd=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.services.ConfigObject.getValue","This method must not be used directly. Use com.ibm.mashups.enabler.services.ConfigObject.getValue instead.",_bc);
}
if(this.provider=="all"){
return this.configService.getValue(_bc,_bd);
}else{
return this._getValue(this.provider,_bc);
}
return null;
},_getValue:function(_be,_bf){
if(!this.valuesArray){
this._loadConfigData(_be);
}
return this.valuesArray[_bf];
},_loadConfigData:function(_c0){
var _c1="ConfigProvider."+_c0;
var _c2=ibmConfig[_c1];
if((typeof _c2!="undefined")||(_c2!=null)){
_c0=_c2;
}
var ret={};
var _c4=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.CONFIG_URL,this);
_c4.setSchemeSpecificPart("/"+_c0+"/*");
var _c5=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_c4,null,null,false,true);
var me=this;
_c5.read(function(_c7,_c8,xhr,_ca){
var _cb=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("//atom:entry/atom:content/preferences/root/node/map/*",_c8,me.ns);
if(_cb&&_cb.length>0){
for(var i=0;i<_cb.length;i++){
var _cd=_cb[i].getAttribute("key");
var _ce=_cb[i].getAttribute("value");
ret[_cd]=_ce;
}
}
});
this.valuesArray=ret;
}});
com.ibm.mm.enabler.services.CONFIG_SERVICE=new com.ibm.mm.enabler.services.ConfigService();
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.event"]){
dojo._hasResource["com.ibm.mashups.iwidget.event"]=true;
dojo.provide("com.ibm.mashups.iwidget.event");
dojo.provide("com.ibm.mashups.iwidget.IEvent");
dojo.provide("com.ibm.mashups.iwidget.IEventDescription");
dojo.declare("com.ibm.mashups.iwidget.IEvent",null,{constructor:function(){
},name:"",type:"",payload:null,source:""});
dojo.declare("com.ibm.mashups.iwidget.IEventDescription",null,{constructor:function(){
},name:"",type:"",aliases:null,handlingFn:"",getDescription:function(_cf){
return null;
},lang:"",isHandled:false,isPublished:false,getAttribute:function(_d0,_d1){
return null;
},setAttribute:function(_d2,_d3,_d4){
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.context.localized"]){
dojo._hasResource["com.ibm.mashups.enabler.context.localized"]=true;
dojo.provide("com.ibm.mashups.enabler.context.localized");
dojo.declare("com.ibm.mashups.enabler.context.LocalizedContext",null,{constructor:function(_d5,_d6){
},getPreferredLocale:function(){
return new String();
},getDefaultLocale:function(){
return new String();
},getLocale:function(_d7){
return new String();
},getTitle:function(_d8){
return new String();
},getDescription:function(_d9){
return new String();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.context.factory"]){
dojo._hasResource["com.ibm.mashups.enabler.context.factory"]=true;
dojo.provide("com.ibm.mashups.enabler.context.factory");
dojo.declare("com.ibm.mashups.enabler.context.Factory",null,{constructor:function(){
},getLocalizedContext:function(_da,_db){
return com.ibm.mashups.enabler.context.LocalizedContext();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.context"]){
dojo._hasResource["com.ibm.mashups.enabler.context"]=true;
dojo.provide("com.ibm.mashups.enabler.context");
}
if(!dojo._hasResource["com.ibm.mm.iwidget.eventImpl"]){
dojo._hasResource["com.ibm.mm.iwidget.eventImpl"]=true;
dojo.provide("com.ibm.mm.iwidget.eventImpl");
dojo.provide("com.ibm.mm.iwidget.eventImpl");
dojo.provide("com.ibm.mm.iwidget.iEventDescriptionImpl");
dojo.provide("com.ibm.mm.iwidget.iEvents");
dojo.declare("com.ibm.mm.iwidget.iEventImpl",com.ibm.mashups.iwidget.IEvent,{constructor:function(_dc,_dd,_de,_df){
this.name=_dc;
if(typeof _dd!="undefined"){
this.type=_dd;
}else{
this.type=null;
}
if(typeof _de!="undefined"){
this.payload=_de;
}else{
this.payload=null;
}
if(typeof _df!="undefined"){
this.source=_df;
}else{
this.source=null;
}
this.source=_df;
}});
dojo.declare("com.ibm.mm.iwidget.iEventDescriptionImpl",com.ibm.mashups.iwidget.IEventDescription,{constructor:function(_e0,_e1,_e2,_e3,_e4,_e5,_e6){
if(dojo.isString(_e0)){
var obj={};
obj.name=_e0;
if(_e1&&_e1!=null){
obj.handlingFn=_e1;
obj.isHandled=true;
obj.isPublished=false;
}else{
obj.isPublished=true;
}
if(typeof _e2!="undefined"&&_e2!=null){
obj.type=_e2;
}
if(typeof _e5!="undefined"&&_e5!=null){
obj.lang=_e5;
}else{
obj.lang="en";
}
obj.attributes={};
obj.localizedAttributes={};
if(typeof _e4!="undefined"&&_e4!=null){
obj.attributes.aliases=_e4;
}
if(typeof _e6!="undefined"&&_e6!=null){
obj.localizedAttributes=_e6;
}
if(_e3&&_e3!=null){
if(!obj.localizedAttributes[obj.lang]){
obj.localizedAttributes[obj.lang]={};
}
obj.localizedAttributes[obj.lang].description=_e3;
}
this._internalJsonObj=obj;
}else{
this._internalJsonObj=_e0;
}
this.initPredefinedFields(this._internalJsonObj);
},initPredefinedFields:function(obj){
this.name=obj.name;
this.type=obj.type;
this.lang=obj.lang;
this.handlingFn=obj.handlingFn;
if(this.handlingFn&&this.handlingFn!=null){
this.isHandled=true;
}else{
this.isHandled=false;
}
if((obj.isPublished&&obj.isPublished=="true")||(obj.isPublished&&obj.isPublished==true)){
this.isPublished=true;
}
},getDescription:function(_e9){
return this._getLocalizedAttribute("description",_e9);
},getTitle:function(_ea){
return this._getLocalizedAttribute("title",_ea);
},_getLocalizedAttribute:function(_eb,_ec){
var _ed=null,_ee=null;
var lc=com.ibm.mashups.enabler.context.Factory.getLocalizedContext();
var _f0=lc.getLocale(this,_ec,this.lang);
if(typeof this._internalJsonObj.localizedAttributes!="undefined"&&this._internalJsonObj.localizedAttributes!=null){
_ee=this._internalJsonObj.localizedAttributes[_f0];
if(typeof _ee!="undefined"&&_ee!=null){
_ed=_ee[_eb];
}
}
if(typeof _ed=="undefined"||_ed==null){
_ed=this[_eb];
}
if(typeof _ed=="undefined"){
_ed=null;
}
return _ed;
},setOnRemoveWire:function(_f1){
if(typeof _f1=="undefined"||_f1===null){
_f1="onRemoveWire";
}
this._internalJsonObj.attributes["onRemoveWire"]=_f1;
return this;
},getOnRemoveWire:function(){
if(this._internalJsonObj.attributes["onRemoveWire"]){
return this._internalJsonObj.attributes["onRemoveWire"];
}
return null;
},setOnNewWire:function(_f2){
if(typeof _f2=="undefined"||_f2===null){
_f2="onNewWire";
}
this._internalJsonObj.attributes["onNewWire"]=_f2;
return this;
},getOnNewWire:function(){
if(this._internalJsonObj.attributes["onNewWire"]){
return this._internalJsonObj.attributes["onNewWire"];
}
return null;
},getLocales:function(){
var _f3=[];
if(typeof this._internalJsonObj.localizedAttributes!="undefined"&&this._internalJsonObj.localizedAttributes!=null){
for(var i in this._internalJsonObj.localizedAttributes){
_f3.push(i);
}
}
return _f3;
},toString:function(){
var _f5=this.toJson();
return dojo.toJson(_f5);
},_getInternalJsonObj:function(){
return this._internalJsonObj;
},toJson:function(){
var _f6={};
for(var i in this._internalJsonObj){
if(i=="handlingFn"){
if(dojo.isFunction(this._internalJsonObj[i])==true){
_f6[i]="HANDLEFN";
continue;
}
}
_f6[i]=dojo.clone(this._internalJsonObj[i]);
}
return _f6;
},clone:function(){
var _f8=dojo.toJson(this._internalJsonObj);
if(_f8!=null){
return new com.ibm.mm.iwidget.iEventDescriptionImpl(dojo.fromJson(_f8));
}else{
return null;
}
},getAttribute:function(_f9,_fa){
if(typeof _f9=="undefined "||_f9==null){
return null;
}
if(typeof _fa=="undefined"||_fa==null){
if(this._internalJsonObj.attributes&&this._internalJsonObj.attributes[_f9]&&(this._internalJsonObj.attributes[_f9]!=null)){
return this._internalJsonObj.attributes[_f9];
}
if(this._internalJsonObj.localizedAttributes&&this._internalJsonObj.localizedAttributes[this.lang]&&(this._internalJsonObj.localizedAttributes[this.lang]!=null)){
var _fb=this._internalJsonObj.localizedAttributes[this.lang][_f9];
if(typeof _fb!="undefined"&&_fb!=null){
return _fb;
}
}
return null;
}else{
return this._getLocalizedAttribute(_f9,_fa);
}
},setAttribute:function(_fc,_fd,_fe){
if(typeof _fc=="undefined"||_fc==null){
return null;
}
if(typeof _fd=="undefined"){
return null;
}
if(typeof _fe=="undefined"&&_fe==null){
this._internalJsonObj.attributes[_fc]=_fd;
if(_fd==null){
delete this._internalJsonObj.attributes[_fc];
}
return this;
}
if(!this._internalJsonObj.localizedAttributes[_fe]){
this._internalJsonObj.localizedAttributes[_fe]={};
}
this._internalJsonObj.localizedAttributes[_fe][_fc]=_fd;
if(_fd==null){
delete this._internalJsonObj.localizedAttributes[_fe][_fc];
}
return this;
}});
dojo.declare("com.ibm.mm.iwidget.iEventsConstants",null,{constructor:function(){
},onLoad:"onLoad",onUnLoad:"onUnload",onModeChanged:"onModeChanged",onItemSetChanged:"onItemSetChanged",unloadWidget:"/enabler/unloadWidget",unSubscribeWire:"/enabler/unSubscribeWire",modeChanged:"modeChanged"});
com.ibm.mm.iwidget.iEvents.Constants=new com.ibm.mm.iwidget.iEventsConstants();
}
if(!dojo._hasResource["com.ibm.mashups.services"]){
dojo._hasResource["com.ibm.mashups.services"]=true;
dojo.provide("com.ibm.mashups.services");
dojo.provide("com.ibm.mashups.services.ServiceManager");
dojo.declare("com.ibm.mashups.services.ServiceManager",null,{constructor:function(){
},getService:function(_ff){
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.services"]){
dojo._hasResource["com.ibm.mm.enabler.services"]=true;
dojo.provide("com.ibm.mm.enabler.services");
dojo.declare("com.ibm.mm.enabler.services.ConfigServiceImpl",[com.ibm.mm.enabler.services.ConfigService],{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.services.ConfigService");
},getValue:function(name){
var _101="getValue(name)";
var _102=this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
if(_102){
this.LOGGER.entering(_101,name);
}
var ret=com.ibm.mm.enabler.services.CONFIG_SERVICE.getValue(name,true);
if(_102){
this.LOGGER.exiting(_101,ret);
}
return ret;
},getConfigObject:function(name){
var _105="getConfigObject(name)";
var _106=this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
if(_106){
this.LOGGER.entering(_105,name);
}
var ret=new com.ibm.mm.enabler.services.ConfigObjectImpl(name);
if(_106){
this.LOGGER.exiting(_105,ret);
}
return ret;
},getConfigProviderNames:function(){
var _108="getConfigProviderNames()";
var _109=this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
if(_109){
this.LOGGER.entering(_108,name);
}
var ret=com.ibm.mm.enabler.services.CONFIG_SERVICE.getConfigProviderNames();
if(_109){
this.LOGGER.exiting(_108,ret);
}
return ret;
}});
dojo.declare("com.ibm.mm.enabler.services.ConfigObjectImpl",[com.ibm.mm.enabler.services.ConfigObject],{constructor:function(_10b){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.services.ConfigObject");
this.provider=_10b;
},getValue:function(name){
var _10d="getValue(name)";
var _10e=this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
if(_10e){
this.LOGGER.entering(_10d,name);
}
var co=com.ibm.mm.enabler.services.CONFIG_SERVICE.getConfigObject(this.provider);
var ret=null;
if(co){
ret=co.getValue(name,true);
}
if(_10e){
this.LOGGER.exiting(_10d,ret);
}
return ret;
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.services"]){
dojo._hasResource["com.ibm.mashups.enabler.services"]=true;
dojo.provide("com.ibm.mashups.enabler.services");
dojo.provide("com.ibm.mashups.enabler.services.ConfigService");
dojo.provide("com.ibm.mashups.enabler.services.ConfigObject");
dojo.provide("com.ibm.mashups.enabler.services.ConfigConstants");
dojo.declare("com.ibm.mashups.enabler.services.ConfigService",null,{SERVICE_NAME:"configService",getValue:function(name){
return null;
},getConfigObject:function(name){
return null;
},getConfigProviderNames:function(){
return null;
}});
dojo.declare("com.ibm.mashups.enabler.services.ConfigObject",null,{getValue:function(name){
return null;
}});
com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME="configService";
dojo.declare("com.ibm.mashups.enabler.services.ConfigConstants",null,{PROXY_URL:"com.ibm.mashups.proxy.url",HUB_URL:"com.ibm.mashups.hub.url",LOGIN_URL:"com.ibm.mashups.url.login",LOGOUT_URL:"com.ibm.mashups.url.logout",CONTEXT_ROOT_ENABLER:"com.ibm.mashups.contextroot.enabler",CONTEXT_ROOT:"com.ibm.mashups.contextroot",CONTENTHANDLER_PUBLIC:"com.ibm.mashups.contenthandler.public",CONTENTHANDLER_PRIVATE:"com.ibm.mashups.contenthandler.private",EMBEDDING_PUBLIC:"com.ibm.mashups.embedding.public",EMBEDDING_PRIVATE:"com.ibm.mashups.embedding.private",THEMES_FEEDS_EXPIRATION:"themes.feed.expiration",AVAILABLE_LOCALES:"availableLocales",TUNNEL_MODE:"tunnel.mode",CLIENT_IS_DEBUG:"isDebug",CLIENT_IS_BIDI:"isBidi",WIDGETDEFID_SANDBOX_DISABLED:"com.ibm.mashups.sandbox.force.disable",TRACE_CONFIG:"traceConfig",CLIENT_POPUP_CONSOLE:"popupConsole",CLIENT_ALLOW_PUBLISH_LOGGING:"allowPublishLogging",CLIENT_ALLOW_PUBLISH_TRACING:"allowPublishTracing",CLIENT_ADDITIONAL_SERVICES:"additionalServices",CLIENT_DEFAULT_THEME_ID:"com.ibm.mashups.theme.defaultThemeId",CLIENT_PAGE_SOURCE_READ_ONLY:"pageSourceReadOnly",CLIENT_AUTO_ACCEPT_SHARED_GROUPNAME:"autoAcceptSharedGroupName",AUTO_WIRING_DEFAULT_ENABLED:"autoWiringDefaultEnabled",CLIENT_USER_ID_KEY:"userIdKey",CLIENT_GROUP_CN_KEY:"groupCNKey",SERVICE_DOCUMENT_URL:"serviceDocumentUrl",MULTIPART_ENABLED:"com.ibm.mashups.multipart.enabled",MULTIPART_CORRELATE_HOSTS:"com.ibm.mashups.multipart.correlatehosts",ENDPOINTS:"endpointIDs",ENDPOINT_CONFIG_PROVIDER:"Endpoints",ANONYMOUS_USER:"anonymousUser",USER:"user",SUBDOMAINS:"subdomains",SERVERDOMAIN:"serverdomain",SANDBOXENABLED:"sandboxenabled",SUBDOMAINREUSE:"subdomainreuse",NAVSTATE_PERSISTENCE_URL:"navstate.persistence.url",NAVSTATE_PERSISTENCE_PSTORE:"navstate.persistence.pstore",NAVSTATE_PERSISTENCE_URL_LIMIT:"navstate.persistence.url.limit",NAVSTATE_HUFFMANNENCODE_ENABLED:"navstate.huffmannencode.enabled",LOADING_HTML:"loadingHTML",PAGE_LOAD_OPTIMIZATION:"pageLoadOptimization",PAGE_LOAD_OPTIMIZATION_THEME:"pageLoadOptimizationTheme",PAGE_LOAD_OPTIMIZATION_APP_WIDGETS:"pageLoadOptimizationAppWidgets",ANONYMOUS_ALLOW_CREATE:"com.ibm.mashups.anonymous.allow.create",DEFAULT_USER_DISPLAY_PROP:"com.ibm.mashups.default.user.display.prop",PRODUCT_NAME:"com.ibm.mashups.productname",DEFAULT_GROUP_DISPLAY_PROP:"com.ibm.mashups.default.group.display.prop",WELCOME_SPACE_ID:"com.ibm.mashups.welcome.space.name",BUILDER_TITLE_FILTER_REGEXP:"com.ibm.mashups.builder.filter.title.regexp",ANON_VIRTUAL_USER_ID:"com.ibm.mashups.anonUserId",ALL_AUTH_VIRTUAL_GROUP_ID:"com.ibm.mashups.allAuthGroupId",SERVER_TYPE:"com.ibm.mashups.server",SERVER_TYPE_MASHUPS:"Lotus_Mashups",SERVER_TYPE_PORTAL:"WebSphere_Portal",ANON_MODE_ENABLED:"com.ibm.mashups.anonymous.mode"});
com.ibm.mashups.enabler.services.ConfigConstants=new com.ibm.mashups.enabler.services.ConfigConstants();
}
if(!dojo._hasResource["dojox.xml.parser"]){
dojo._hasResource["dojox.xml.parser"]=true;
dojo.provide("dojox.xml.parser");
dojox.xml.parser.parse=function(str,_115){
var _116=dojo.doc;
var doc;
_115=_115||"text/xml";
if(str&&dojo.trim(str)&&"DOMParser" in dojo.global){
var _118=new DOMParser();
doc=_118.parseFromString(str,_115);
var de=doc.documentElement;
var _11a="http://www.mozilla.org/newlayout/xml/parsererror.xml";
if(de.nodeName=="parsererror"&&de.namespaceURI==_11a){
var _11b=de.getElementsByTagNameNS(_11a,"sourcetext")[0];
if(!_11b){
_11b=_11b.firstChild.data;
}
throw new Error("Error parsing text "+nativeDoc.documentElement.firstChild.data+" \n"+_11b);
}
return doc;
}else{
if("ActiveXObject" in dojo.global){
var ms=function(n){
return "MSXML"+n+".DOMDocument";
};
var dp=["Microsoft.XMLDOM",ms(6),ms(4),ms(3),ms(2)];
dojo.some(dp,function(p){
try{
doc=new ActiveXObject(p);
}
catch(e){
return false;
}
return true;
});
if(str&&doc){
doc.async=false;
doc.loadXML(str);
var pe=doc.parseError;
if(pe.errorCode!==0){
throw new Error("Line: "+pe.line+"\n"+"Col: "+pe.linepos+"\n"+"Reason: "+pe.reason+"\n"+"Error Code: "+pe.errorCode+"\n"+"Source: "+pe.srcText);
}
}
if(doc){
return doc;
}
}else{
if(_116.implementation&&_116.implementation.createDocument){
if(str&&dojo.trim(str)&&_116.createElement){
var tmp=_116.createElement("xml");
tmp.innerHTML=str;
var _122=_116.implementation.createDocument("foo","",null);
dojo.forEach(tmp.childNodes,function(_123){
_122.importNode(_123,true);
});
return _122;
}else{
return _116.implementation.createDocument("","",null);
}
}
}
}
return null;
};
dojox.xml.parser.textContent=function(node,text){
if(arguments.length>1){
var _126=node.ownerDocument||dojo.doc;
dojox.xml.parser.replaceChildren(node,_126.createTextNode(text));
return text;
}else{
if(node.textContent!==undefined){
return node.textContent;
}
var _127="";
if(node){
dojo.forEach(node.childNodes,function(_128){
switch(_128.nodeType){
case 1:
case 5:
_127+=dojox.xml.parser.textContent(_128);
break;
case 3:
case 2:
case 4:
_127+=_128.nodeValue;
}
});
}
return _127;
}
};
dojox.xml.parser.replaceChildren=function(node,_12a){
var _12b=[];
if(dojo.isIE){
dojo.forEach(node.childNodes,function(_12c){
_12b.push(_12c);
});
}
dojox.xml.parser.removeChildren(node);
dojo.forEach(_12b,dojo.destroy);
if(!dojo.isArray(_12a)){
node.appendChild(_12a);
}else{
dojo.forEach(_12a,function(_12d){
node.appendChild(_12d);
});
}
};
dojox.xml.parser.removeChildren=function(node){
var _12f=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _12f;
};
dojox.xml.parser.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
return null;
};
}
if(!dojo._hasResource["com.ibm.mm.enabler.utilities"]){
dojo._hasResource["com.ibm.mm.enabler.utilities"]=true;
dojo.provide("com.ibm.mm.enabler.utilities");
dojo.provide("com.ibm.mm.enabler.ArrayMap");
com.ibm.mm.enabler.utilities={rewriteURL:function(_131){
var _132=new com.ibm.mm.enabler.utilities.HttpUrl(_131);
return _132.toProxifiedString();
},encodePath:function(path){
if(path.length==0){
return path;
}
var _134=path.split("/");
for(var i=0;i<_134.length;++i){
_134[i]=escape(unescape(_134[i]));
}
return _134.join("/");
},inStringArray:function(str,_137){
var rc=false;
for(var i in _137){
var _13a=_137[i];
if(_13a==str){
rc=true;
break;
}
}
return rc;
},isEmpty:function(_13b){
for(var i in _13b){
return false;
}
return true;
},getLocale:function(_13d,_13e,_13f){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.utilities.getLocale","Deprecated. Use com.ibm.mashups.enabler.context.Factory.getLocalizedContext().getLocale() instead.");
if(typeof _13d=="undefined"||_13d===null){
return null;
}
var _140=_13d.getLocales();
if(typeof _140=="undefined"||_140===null||!dojo.isArray(_140)){
return null;
}
if(_140.length===0){
return null;
}
var _141=null;
if(_140.length===1){
_141=_140[0];
}
var arr={};
for(var i in _140){
var temp=_140[i];
arr[temp]=temp;
}
if(_141===null){
if(typeof _13e!="undefined"&&_13e!==null){
_141=this.findMatchLocale(arr,_13e);
if(_141===null){
var _145=_13e.split(/-|_/);
if(_145.length==2){
var _146=_145[0];
if(typeof arr[_146]!="undefined"&&arr[_146]!==null){
_141=_146;
}
}
}
}
}
if(_141===null){
var _147=(dojo.isIE?navigator.userLanguage:navigator.language).toLowerCase();
if(typeof ibmConfig!="undefined"&&ibmConfig!=null&&typeof (ibmConfig.locale)!="undefined"&&ibmConfig.locale!=null){
_147=ibmConfig.locale;
}
if(_147!==null){
_141=this.findMatchLocale(arr,_147);
if(_141===null){
var _145=_147.split(/-|_/);
if(_145.length==2){
var _148=_145[0];
if(typeof arr[_148]!="undefined"&&arr[_148]!==null){
_141=_148;
}
}
}
}
}
if(_141===null){
if(typeof _13f!="undefined"&&_13f!=null){
_141=_13f;
}
}
if(_141===null){
if(typeof arr["en"]!="undefined"&&arr["en"]!==null){
_141="en";
}
}
if(_141===null){
_141=_140[0];
}
return _141;
},findMatchLocale:function(arr,_14a){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.utilities.findMatchLocale","Deprecated. Use com.ibm.mm.enabler.utilities.matchLocale() instead.");
var _14b=null;
if(typeof arr[_14a]!="undefined"&&arr[_14a]!=null){
_14b=_14a;
}
var _14c=this.toServerLocale(_14a);
if(_14b===null&&(typeof arr[_14c]!="undefined"&&arr[_14c]!=null)){
_14b=_14c;
}
var _14d=_14c.toLowerCase();
if(_14b===null&&(typeof arr[_14d]!="undefined"&&arr[_14d]!=null)){
_14b=_14d;
}
return _14b;
},matchLocale:function(_14e,_14f){
return com.ibm.mm.enabler.utilities._matchLocale(com.ibm.mm.enabler.utilities._getLocaleObj(_14e),com.ibm.mm.enabler.utilities.normalizeLocale(_14f));
},_matchLocale:function(_150,_151,stop){
var _153=_150;
var _154=null;
var _155=dojo.some(_151,function(item){
if(item==_150.toString()){
_154=item;
return true;
}
});
if(_155&&_154){
return _154;
}
if(_150.variant){
_150.variant=null;
return com.ibm.mm.enabler.utilities._matchLocale(_150,_151);
}
if(_150.country){
_150.country=null;
return com.ibm.mm.enabler.utilities._matchLocale(_150,_151);
}
if(!stop){
_150=_153;
switch(_150.language){
case "he":
_150.language="iw";
break;
case "iw":
_150.language="he";
break;
}
return com.ibm.mm.enabler.utilities._matchLocale(_150,_151,true);
}
return null;
},toServerLocale:function(_157){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.utilities.normalizeLocale","Deprecated. Use com.ibm.mm.enabler.utilities.normalizeLocale() instead.");
if(typeof _157=="undefined"||_157==null){
return null;
}
if(_157.indexOf("-")<0){
return _157;
}
_157=_157.replace(/-/,"_");
var _158=_157.split("_");
var lang=_158[0];
var _15a=_158[1].toUpperCase();
var _15b=lang+"_"+_15a;
return _15b;
},_getLocaleObj:function(_15c){
if(dojo.isArray(_15c)){
return dojo.map(_15c,function(item){
return com.ibm.mm.enabler.utilities._getLocaleObj(item);
});
}else{
if(dojo.isString(_15c)&&dojo.string.trim(_15c).length>0){
var _15e={language:null,country:null,variant:null,toString:function(){
return (this.language?this.language+(this.country?"_"+this.country+(this.variant?"_"+this.variant:""):""):"");
},isValid:function(){
return !!this.language;
}};
var _15f=dojo.string.trim(_15c).replace(/-/g,"_").split("_");
switch(_15f.length){
case 3:
_15e.variant=_15f[2];
case 2:
_15e.country=_15f[1].toUpperCase();
case 1:
_15e.language=_15f[0].toLowerCase();
break;
}
return _15e;
}else{
return null;
}
}
},normalizeLocale:function(_160){
if(dojo.isArray(_160)){
return dojo.map(_160,function(item){
return com.ibm.mm.enabler.utilities.normalizeLocale(item);
});
}else{
if(_160){
return com.ibm.mm.enabler.utilities._getLocaleObj(_160).toString();
}else{
return null;
}
}
},encodeModelID4Uri:function(uri){
var pos=uri.indexOf(":");
if(pos!=-1){
var _164=uri.slice(0,pos+1);
var end=uri.slice(pos+1);
uri=_164+encodeURIComponent(end);
}
return encodeURIComponent(uri);
},preloadImage:function(path,_167,_168){
var _169;
if(_167&&_168){
_169=new Image(_167,_168);
}else{
_169=new Image();
}
_169.src=path;
return _169;
},getAttributeWithNS:function(_16a,_16b,_16c,_16d){
if(typeof _16a=="undefined"||_16a==null){
return null;
}
if(typeof _16b=="undefined"||_16b==null){
return null;
}
if(typeof _16c=="undefined"||_16c==null){
return null;
}
if(typeof _16d=="undefined"||_16d==null){
return null;
}
var _16e=null;
if(dojo.isIE){
_16e=_16a.getAttribute(_16b);
if(_16e===null||_16e==""){
var _16f=_16a.attributes;
for(var i=_16f.length;i>0;i--){
if(_16f[i-1].baseName==_16c&&_16f[i-1].namespaceURI==_16d){
_16e=_16f[i-1].value;
break;
}
}
}
}else{
_16e=_16a.getAttributeNS(_16d,_16c);
}
return _16e;
},setAttributeWithNS:function(dom,_172,_173,_174,_175,_176){
if(dojo.isIE){
attribute=dom.createNode(2,_173,_175);
attribute.nodeValue=_176;
_172.setAttributeNode(attribute);
}else{
_172.setAttributeNS(_175,_173,_176);
}
}};
com.ibm.mm.enabler.dom={textContent:function(node,text){
if(node==null){
return "";
}
if(arguments.length>1){
var doc=node.ownerDocument;
if(!text){
text="";
}
var _17a=doc.createTextNode(text);
this.replaceChildren(node,_17a);
return;
}else{
var tc=dojox.xml.parser.textContent(node);
if(tc!="undefined"&&tc!=null){
return tc;
}
var _17c="";
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 3:
_17c+=node.childNodes[i].nodeValue;
break;
case 2:
case 4:
_17c+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _17c;
}
},createElement:function(dom,name,ns){
var _181;
if(dojo.isIE){
if(typeof ns!="undefined"&&ns!=null){
_181=dom.createNode(1,name,ns);
}else{
_181=dom.createElement(name);
}
}else{
_181=dom.createElementNS(ns,name);
}
return _181;
},destroyNode:function(node){
var _183=document.getElementById("IELeakGarbageBin");
if(!_183){
_183=document.createElement("DIV");
_183.id="IELeakGarbageBin";
_183.style.display="none";
document.body.appendChild(_183);
}
_183.appendChild(node);
_183.innerHTML="";
if(node.nodeType!=3){
if(dojo.isIE){
node.outerHTML="";
}
}
},createDocument:function(str,_185){
return dojox.xml.parser.parse(str,_185);
},replaceChildren:function(node,_187){
return dojox.xml.parser.replaceChildren(node,_187);
},innerXML:function(node){
return dojox.xml.parser.innerXML(node);
},removeChildren:function(node){
return dojox.xml.parser.removeChildren(node);
},copyChildren:function(_18a,_18b,trim){
var _18d=_18a.cloneNode(true);
return this.moveChildren(_18d,_18b,trim);
},moveChildren:function(_18e,_18f,trim){
var _191=0;
if(trim){
while(_18e.hasChildNodes()&&_18e.firstChild.nodeType==3){
_18e.removeChild(_18e.firstChild);
}
while(_18e.hasChildNodes()&&_18e.lastChild.nodeType==3){
_18e.removeChild(_18e.lastChild);
}
}
while(_18e.hasChildNodes()){
_18f.appendChild(_18e.firstChild);
_191++;
}
return _191;
}};
dojo.declare("com.ibm.mm.enabler.utilities.HttpUrl",null,{constructor:function(_192){
var _193=com.ibm.mm.enabler.model.Utils.checkForEndpoints(_192);
if(_193!=null){
_192=_193;
}
this.scheme=this._extractScheme(_192);
this.server=this._extractServer(_192);
this.port=this._extractPort(_192);
this.path=this._extractPath(_192);
this.parameters=this._extractQuery(_192);
this.anchor=this._extractAnchor(_192);
},addParameter:function(name,_195){
if(dojo.isString(this.parameters[name])){
this.parameters[name]=[this.parameters[name],_195];
}else{
if(dojo.isArray(this.parameters[name])){
this.parameters[name].push(_195);
}else{
this.parameters[name]=_195;
}
}
},setParameter:function(name,_197){
this.parameters[name]=_197;
},getParameter:function(name){
return this.parameters[name];
},getParameters:function(){
return this.parameters;
},isProxyNeeded:function(){
var loc=document.location;
if(loc.protocol!=this.scheme){
return true;
}
if(loc.hostname!=this.server){
return true;
}
if(loc.port==this.port){
return false;
}
if(this.scheme=="http:"){
var _19a="80";
if((loc.port==""&&this.port==_19a)||(loc.port==_19a&&this.port=="")){
return false;
}
}
if(this.scheme=="https:"){
var _19a="443";
if((loc.port==""&&this.port==_19a)||(loc.port==_19a&&this.port=="")){
return false;
}
}
return true;
},toServerRelativeString:function(){
var str="";
if(this.path!=""){
str+="/"+com.ibm.mm.enabler.utilities.encodePath(this.path);
}
if(!com.ibm.mm.enabler.utilities.isEmpty(this.parameters)){
str+="?"+dojo.objectToQuery(this.parameters);
}
if(this.anchor!=""){
str+="#"+this.anchor;
}
return str;
},toProxifiedString:function(){
if(typeof ibmConfig=="undefined"){
return this.toString();
}
var _19c=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
if(_19c==null){
return this.toString();
}
_19c+="/";
if(window.location.protocol==this.scheme&&window.location.hostname==this.server){
if(window.location.port==this.port){
return this.toString();
}else{
if(this.scheme=="http:"&&window.location.port==""&&this.port=="80"){
return this.toString();
}else{
if(this.scheme=="https:"&&window.location.port==""&&this.port=="443"){
return this.toString();
}else{
if(this.scheme=="http:"&&window.location.port=="80"&&this.port==""){
return this.toString();
}else{
if(this.scheme=="https:"&&window.location.port=="443"&&this.port==""){
return this.toString();
}
}
}
}
}
}
if(this.scheme=="https:"){
_19c+="https/"+this.server+((this.port!="443"&&this.port!="")?"%3A"+this.port:"");
}else{
_19c+="http/"+this.server+((this.port!="80"&&this.port!="")?"%3A"+this.port:"");
}
_19c+="/";
if(this.path!=""){
_19c+=com.ibm.mm.enabler.utilities.encodePath(this.path);
}
if(!com.ibm.mm.enabler.utilities.isEmpty(this.parameters)){
_19c+="?"+dojo.objectToQuery(this.parameters);
}
if(this.anchor!=""){
_19c+="#"+this.anchor;
}
return _19c;
},toString:function(){
var str="";
if(this.server!=""){
str+=this.scheme+"//"+this.server;
if(this.port!=""){
if(this.scheme=="http:"&&this.port=="80"){
str+="";
}else{
if(this.scheme=="https:"&&this.port=="443"){
str+="";
}else{
str+=":"+this.port;
}
}
}
}
str+="/";
if(this.path!=""){
str+=com.ibm.mm.enabler.utilities.encodePath(this.path);
}
if(!com.ibm.mm.enabler.utilities.isEmpty(this.parameters)){
str+="?"+dojo.objectToQuery(this.parameters);
}
if(this.anchor!=""){
str+="#"+this.anchor;
}
return str;
},_extractScheme:function(_19e){
var _19f=_19e.indexOf("://");
if(_19f==-1){
return window.location.protocol;
}
return _19e.substring(0,_19f+1);
},_extractServer:function(_1a0){
var _1a1=_1a0.indexOf(this.scheme);
var _1a2="";
if(_1a1==0){
var _1a3=_1a0.indexOf("/",_1a1+this.scheme.length+2);
if(_1a3!=-1){
var _1a4=_1a0.substring(_1a1+this.scheme.length+2,_1a3);
}else{
var _1a4=_1a0.substring(_1a1+this.scheme.length+2);
}
_1a2=_1a4.split(":")[0];
}else{
_1a2=window.location.hostname;
}
return _1a2;
},_extractPort:function(_1a5){
var _1a6=_1a5.indexOf(this.server);
var _1a7="";
if(_1a6>=0){
var _1a8=_1a5.indexOf("/",_1a6);
if(_1a8!=-1){
var _1a9=_1a5.substring(_1a6,_1a8);
}else{
var _1a9=_1a5.substring(_1a6);
}
var _1aa=_1a9.split(":");
if(_1aa.length>1){
_1a7=_1aa[1];
}
}
if(_1a7==""){
if(_1a5.indexOf("/")==0){
_1a7=window.location.port;
}else{
_1a7="";
}
}
return _1a7;
},_extractPath:function(_1ab){
var _1ac=_1ab.indexOf(this.scheme);
var _1ad=0;
if(_1ac==0){
_1ad=this.scheme.length+2;
}
var _1ae="";
var _1af=_1ab.indexOf("/",_1ad);
var _1b0=_1ab.indexOf("?");
var _1b1=_1ab.lastIndexOf("#");
if(_1b0>=0){
_1ae=_1ab.substring(_1af+1,_1b0);
}else{
if(_1b1>=0&&_1af!=-1){
_1ae=_1ab.substring(_1af+1,_1b1);
}else{
if(_1af!=-1){
_1ae=_1ab.substring(_1af+1);
}
}
}
return _1ae;
},_extractQuery:function(_1b2){
var _1b3={};
var _1b4=_1b2.split("?");
if(_1b4.length>1){
_1b3=dojo.queryToObject(_1b4[1].split("#")[0]);
}
return _1b3;
},_extractAnchor:function(_1b5){
var _1b6="";
var _1b7=_1b5.split("#");
if(_1b7.length>1){
_1b6=_1b7[_1b7.length-1];
}
return _1b6;
}});
dojo.declare("com.ibm.mm.enabler.ArrayMap",null,{constructor:function(){
this.entries=[];
this.keys={};
},values:function(){
return this.entries;
},put:function(key,_1b9){
var _1ba=this.keys[key];
if(typeof _1ba!="undefined"&&_1ba!=null){
this.entries[_1ba]=_1b9;
}else{
_1ba=this.entries.length;
this.entries.push(_1b9);
this.keys[key]=_1ba;
}
},getKey:function(_1bb){
if(_1bb<this.entries.length){
for(var key in this.keys){
var temp=this.keys[key];
if(temp!=null&&temp==_1bb){
return temp;
}
}
}else{
return null;
}
},getValue:function(_1be){
if(_1be<this.entries.length){
return this.entries[_1be];
}else{
return null;
}
},get:function(key){
var _1c0=this.keys[key];
if(typeof _1c0!="undefined"&&_1c0!=null){
var _1c1=this.entries[_1c0];
return _1c1;
}
return null;
},remove:function(key){
var _1c3=this.keys[key];
if(typeof _1c3!="undefined"&&_1c3!=null){
this.entries.splice(_1c3,1);
this.keys[key]=null;
}
return _1c3;
},size:function(){
return this.entries.length;
},keySet:function(){
var arr=[];
for(var key in this.keys){
arr.push(key);
}
return arr;
}});
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.services"]){
dojo._hasResource["com.ibm.mashups.iwidget.services"]=true;
dojo.provide("com.ibm.mashups.iwidget.services");
dojo.provide("com.ibm.mashups.iwidget.services.EventService");
dojo.declare("com.ibm.mashups.iwidget.services.EventService",null,{SERVICE_NAME:"eventService",constructor:function(){
},fireEvent:function(_1c6,_1c7,_1c8,_1c9,_1ca){
},broadcastEvent:function(_1cb,_1cc,_1cd,_1ce){
},broadcastEvent:function(_1cf,_1d0,_1d1,_1d2,_1d3){
},broadcastEvent:function(_1d4,_1d5,_1d6,_1d7,_1d8,_1d9){
},broadcastEvents:function(_1da,_1db){
},broadcastEvents:function(_1dc,_1dd,_1de){
},broadcastEvents:function(_1df,_1e0,_1e1,_1e2){
},publishEvent:function(_1e3,_1e4,_1e5,_1e6){
},subscribeEvent:function(_1e7,_1e8,_1e9,_1ea,_1eb){
},unsubscribeEvent:function(_1ec,_1ed){
}});
com.ibm.mashups.iwidget.services.EventService.SERVICE_NAME="eventService";
}
if(!dojo._hasResource["com.ibm.mm.iwidget.constants"]){
dojo._hasResource["com.ibm.mm.iwidget.constants"]=true;
dojo.provide("com.ibm.mm.iwidget.constants");
dojo.declare("com.ibm.mm.iwidget.Constants",null,{constructor:function(){
},WIDGETEVENT_PREFIX:"widgetevents.",WILDCARD_PREFIX:"*.",mode_view:"view",mode_edit:"edit",mode_help:"help",ATTRIBUTES:"attributes",IDESCRIPTOR:"idescriptor",USERPROFILE:"userprofile",iDescriptorItems:{title:"title",name:"name",description:"description",defaultHeight:"defaultHeight",defaultWidth:"defaultWidth",locales:"locales",mode:"mode",size:"size",author:"author",email:"email",website:"website",version:"version",globalAttributes:"globalAttributes",icon:"icon"},CSSCLASS_INSTANCE:{iwiWidget:"iWidget",iwDefinition:"Definition",iwHandler:"Handler",iwItemDescription:"ItemDescription",iwReadOnly:"ReadOnly",iwItemSet:"ItemSet",iwItemSetDescRef:"ItemSetDescRef",iwResource:"Resource",iwSrc:"iwSrc",iwmime:"mime",iwversion:"version",iwcallback:"callback",iwContent:"Content",iwAllowInstanceContent:"AllowInstanceContent",iwReceivedEvent:"ReceivedEvent",iwSourceEvent:"SourceEvent",iwTargetEvent:"TargetEvent",iwItem:"Item",iwValue:"Value"},RESOURCE:{src:"src",id:"id",mimetype:"mimetype",callback:"callback",version:"version"},EVENTS:{onLoad:"onLoad",onUnLoad:"onUnload",onModeChanged:"onModeChanged",onItemSetChanged:"onItemSetChanged",unloadWidget:"/enabler/unloadWidget",unSubscribeWire:"/enabler/unSubscribeWire",modeChanged:"modeChanged",onSizeChanged:"onSizeChanged",onNavStateChanged:"onNavStateChanged",onAttributeSaved:"com.ibm.mashups.iwidget.onAttributeSaved"}});
iwConstants=new com.ibm.mm.iwidget.Constants();
}
if(!dojo._hasResource["com.ibm.mm.enabler.hub.mainhub"]){
dojo._hasResource["com.ibm.mm.enabler.hub.mainhub"]=true;
dojo.provide("com.ibm.mm.enabler.hub.mainhub");
dojo.declare("com.ibm.mm.enabler.hub.ManagedHubImpl",null,{constructor:function(){
},publishMgr:function(_1ee,data,_1f0,_1f1){
var _1f2=_1f0?_1f0.getClientID():"manager";
var _1f3=_1f1?_1f1.getClientID():"manager";
var that=com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
if(that.bIsLoggable){
that.LOGGER.trace("publishMgr","(MANAGER): PUB: "+_1f2+" -> "+_1f3+" || topic: '"+_1ee+"' data: '"+data+"'");
}
return true;
},subscribeMgr:function(_1f5,_1f6){
var _1f7=_1f6?_1f6.getClientID():"manager";
var that=com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
if(that.bIsLoggable){
that.LOGGER.trace("subscribeMgr","(MANAGER): SUB: id: '"+_1f7+"' topic: '"+_1f5+"'");
}
return true;
},securityMgr:function(_1f9,_1fa){
var that=com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
if(that.bIsLoggable){
that.LOGGER.trace("securityMgr","source:"+_1f9+" alertType:"+_1fa);
}
},getInstance:function(){
var hub=com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
if(!hub){
com.ibm.mm.enabler.hub.ManagedHubImpl._instance=new OpenAjax.hub.ManagedHub({onPublish:this.publishMgr,onSubscribe:this.subscribeMgr,onSecurityAlert:this.securityMgr});
com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.hub.ManagedHubImpl");
com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
com.ibm.mm.enabler.hub.ManagedHubImpl._instance.bIsLoggable=com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOGGER.isLoggable(com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOG_LEVEL);
hub=com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
}
return hub;
}});
com.ibm.mm.enabler.hub.ManagedHubImpl=new com.ibm.mm.enabler.hub.ManagedHubImpl();
dojo.declare("com.ibm.mm.enabler.hub.MainHubAdapterImpl",null,{constructor:function(_1fd){
this._managedhub=_1fd;
this._inlineHubClients={};
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},PREFIX_INLINE:"_inline_",PREFIX_IFRAME:"_iframe_",createInlineHubContainer:function(id){
var _1ff=this.PREFIX_INLINE+id;
var me=this;
function onClientConnect(_201){
if(me.bIsLoggable){
me.LOGGER.trace("onClientConnect","++ "+_201.getClientID()+" connected");
}
};
function onClientDisconnect(_202){
if(me.bIsLoggable){
me.LOGGER.trace("onClientDisconnect","-- "+_202.getClientID()+" disconnected");
}
};
function onClientSecurityAlert(_203,_204){
if(me.bIsLoggable){
me.LOGGER.trace("onClientSecurityAlert","!! security alert - id: '"+_203.getClientID()+"' msg: '"+_204);
}
};
function onClientError(_205,_206){
if(me.bIsLoggable){
me.LOGGER.trace("onClientError","!! error - id: '"+_205.getClientID()+"' msg: '"+_206);
}
};
var _207={Container:{onConnect:onClientConnect,onDisconnect:onClientDisconnect,onSecurityAlert:onClientSecurityAlert,onError:onClientError}};
var _208=new OpenAjax.hub.InlineContainer(this._managedhub,_1ff,_207);
return _208;
},createIframeHubContainer:function(id,_20a,uri,_20c,_20d,_20e){
var _20f=this.PREFIX_IFRAME+id;
var _210=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _211=_210.getValue(_210.CONTEXT_ROOT_ENABLER);
var _212=_211+"/js/openajaxhub/tunnel.html";
var _213=window.location.protocol;
var host=window.location.hostname;
var port=window.location.port;
var _216=_213+"//"+host+":"+port+_212;
if(port==""){
_216=_213+"//"+host+_212;
}
var me=this;
function onClientConnect(_218){
if(me.bIsLoggable){
me.LOGGER.trace("onClientConnect","++ "+_218.getClientID()+" connected");
}
};
function onClientDisconnect(_219){
if(me.bIsLoggable){
me.LOGGER.trace("onClientDisconnect","-- "+_219.getClientID()+" disconnected");
}
};
function onClientSecurityAlert(_21a,_21b){
if(me.bIsLoggable){
me.LOGGER.trace("onClientSecurityAlert","!! security alert - id: '"+_21a.getClientID()+"' msg: '"+_21b);
}
};
try{
this.removeIframeHubContainer(id);
if(_20c&&_20c=="true"){
var w="600px";
var h="400px";
}else{
var w="400px";
var h="auto";
}
if(_20d){
w=_20d;
}
if(_20e){
h=_20e;
}
var _21e=new OpenAjax.hub.IframeContainer(this._managedhub,_20f,{Container:{onConnect:onClientConnect,onDisconnect:onClientDisconnect,onSecurityAlert:onClientSecurityAlert},IframeContainer:{uri:uri,tunnelURI:_216,parent:_20a,iframeAttrs:{title:"iframe",style:{width:w,height:h,border:"0px",overflow:"auto"},id:"iframe_"+id,name:id},timeout:1200000}});
}
catch(e){
if(me.bIsLoggable){
me.LOGGER.trace("createIframeHubContainer","Creating iframe container exception:"+e.message);
}
}
},createInlineHubClient:function(id){
var _220=this.PREFIX_INLINE+id;
var me=this;
var _222=this._managedhub.getContainer(_220);
function onHubClientSecurityAlert(_223,_224){
};
var _225=new OpenAjax.hub.InlineHubClient({HubClient:{onSecurityAlert:onHubClientSecurityAlert},InlineHubClient:{container:_222}});
function onHubClientConnect(_226,_227,_228){
if(!_227){
if(me.bIsLoggable){
me.LOGGER.trace("createIframeHubContainer","!! client connection error = id: '"+_226.getClientID()+"' msg: '"+_228);
}
}
};
_225.connect(onHubClientConnect);
this._inlineHubClients[_220]=_225;
return _225;
},_getInlineHubClient:function(id){
if(typeof id=="undefined"||id==null){
return null;
}
var _22a=this.PREFIX_INLINE+id;
var _22b=this._inlineHubClients[_22a];
if(typeof _22b=="undefined"){
_22b=null;
}
return _22b;
},getInlineHubClient:function(id){
if(typeof id=="undefined"||id==null){
return this._managedhub;
}
var _22d=this._getInlineHubClient(id);
return _22d?_22d:this._managedhub;
},isInlineClient:function(id){
var rc=false;
var _230=this._getInlineHubClient(id);
if(typeof _230!="undefined"&&_230!=null){
rc=true;
}
return rc;
},removeInlineHubClient:function(id){
var _232=this._getInlineHubClient(id);
var _233=this.PREFIX_INLINE+id;
if(typeof _232!="undefined"&&_232!=null){
var me=this;
function onHubClientDisconnect(_235,_236,_237){
if(!_236){
if(me.bIsLoggable){
me.LOGGER.trace("onHubClientDisconnect","-- "+_235.getClientID()+" msg:"+_237);
}
}
};
_232.disconnect(onHubClientDisconnect);
delete this._inlineHubClients[_233];
var _238=this._managedhub.getContainer(_233);
if(typeof _238!="undefined"&&_238!=null){
this._managedhub.removeContainer(_238);
}
return;
}
},removeIframeHubContainer:function(id){
var _23a=this.PREFIX_IFRAME+id;
var _23b=this._managedhub.getContainer(_23a);
if(typeof _23b!="undefined"&&_23b!=null){
this._managedhub.removeContainer(_23b);
}
},returnSubDomain:function(_23c){
this.getSubDomainPool().add(_23c);
},getSubDomainSize:function(){
return this.getSubDomainPool().getSize();
},getSubDomain:function(){
return this.getSubDomainPool().get();
},getSubDomainPool:function(){
if(typeof this.subDomainPool=="undefined"||this.subDomainPool==null){
var _23d=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _23e=_23d.getValue(_23d.SUBDOMAINS);
if(typeof _23e!="undefined"&&_23e!=null){
if(dojo.isArray(_23e)==true&&_23e.length!=0){
this.subDomainPool=new com.ibm.mm.enabler.hub.SubDomainPoolImpl(_23e);
}
}
if(!this.subDomainPool){
this.subDomainPool=new com.ibm.mm.enabler.hub.SubDomainPoolImpl();
}
}
return this.subDomainPool;
}});
dojo.declare("com.ibm.mm.enabler.hub.SubDomainPoolImpl",null,{constructor:function(arr){
if(arr){
this._pool=arr;
this._internalPool=dojo.clone(this._pool);
}else{
this._counter=0;
this._reusedSubDomain=[];
}
this.configService=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
this.reuseSubDomain=this.configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.SUBDOMAINREUSE);
},getSize:function(){
if(this._internalPool){
return this._internalPool.length;
}
return -1;
},get:function(){
if(this._pool){
return this._getFromPool();
}
var cnt=this._counter;
if(this.reuseSubDomain){
if(this._reusedSubDomain.length>0){
cnt=this._reusedSubDomain.shift();
return cnt;
}else{
this._counter++;
}
}else{
this._counter++;
}
var _241=new String(cnt);
return "w"+_241;
},add:function(_242){
if(!this.reuseSubDomain){
return;
}
if(this._pool){
return this._addToPool(_242);
}else{
this._reusedSubDomain.push(_242);
}
return;
},_getFromPool:function(){
if(this._pool.length==0){
return null;
}
return this._pool.shift();
},_addToPool:function(_243){
this._pool.push(_243);
}});
dojo.declare("com.ibm.mm.enabler.hub.XHRHeaderExtensionImpl",null,{LOG_LEVEL:com.ibm.mashups.enabler.logging.LogLevel.TRACE,constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_METHOD="dojo.xhr()";
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
this.originalDojoXHR=dojo.xhr;
dojo.xhr=dojo.hitch(this,function(_244,args,_246){
if(this.bIsLoggable){
this.LOGGER.entering(this.LOG_METHOD,[_244,args,_246]);
}
if(!args.headers){
args.headers={};
}
args.headers["com.ibm.lotus.openajax.virtualhost"]=document.location.hostname;
args.headers["com.ibm.lotus.openajax.virtualport"]=document.location.port;
if(this.bIsLoggable){
this.LOGGER.trace(this.LOG_METHOD,"Adding headers: com.ibm.lotus.openajax.virtualhost="+document.location.hostname+" - com.ibm.lotus.openajax.virtualport="+document.location.port);
}
var ret=this.originalDojoXHR(_244,args,_246);
if(this.bIsLoggable){
this.LOGGER.exiting(this.LOG_METHOD);
}
return ret;
});
}});
com.ibm.mm.enabler.hub.XHRHeaderExtension=new com.ibm.mm.enabler.hub.XHRHeaderExtensionImpl();
}
if(!dojo._hasResource["com.ibm.mm.iwidget.services.eventservice"]){
dojo._hasResource["com.ibm.mm.iwidget.services.eventservice"]=true;
dojo.provide("com.ibm.mm.iwidget.services.eventservice");
dojo.declare("com.ibm.mm.iwidget.services.EventServiceImpl",com.ibm.mashups.iwidget.services.EventService,{constructor:function(){
this.subMgr={};
this.managedhub=com.ibm.mm.enabler.hub.ManagedHubImpl.getInstance();
this.hubAdapter=new com.ibm.mm.enabler.hub.MainHubAdapterImpl(this.managedhub);
this._subscribeEventService();
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},setId:function(id){
this.id=id;
},getId:function(){
return "main";
},_subscribeEventService:function(){
var that=this;
function eventCallback(_24a,_24b,_24c){
var _24d=_24b.methodname;
if(typeof _24d!="undefined"&&_24d!=null){
var fn=that[_24b.methodname];
if(typeof fn!="undefined"&&fn!=null){
that[_24d].apply(that,_24b.params);
}
}
};
this.managedhub.subscribe("eventservice."+this.getId(),eventCallback,that,that._subscribeCallback);
},_subscribeCallback:function(_24f,_250,_251){
if(!_250){
console.log("subscribe failed "+_24f);
}
},_getHubAdapter:function(){
return this.hubAdapter;
},_getManagedHub:function(){
return this.managedhub;
},WIDGETEVENT_PREFIX:iwConstants.WIDGETEVENT_PREFIX,WILDCARD_PREFIX:iwConstants.WILDCARD_PREFIX,subscribeWire:function(_252,_253,_254,_255){
com.ibm.mm.enabler.debug.entry("eventService.subscribeWire","source:"+_252+" sourceEvent:"+_253+" targetWidget:"+_254+" targetEvent:"+_255);
if(typeof _252=="undefined"||_252===null){
return false;
}
if(typeof _253=="undefined"||_253===null){
return false;
}
if(typeof _254=="undefined"||_254===null){
return false;
}
if(typeof _255=="undefined"||_255===null){
return false;
}
var rc=true;
var that=this;
function eventCallback(_258,_259,_25a){
that.fireEvent(_254,_255,_259.payload,_259.payloadType,_252);
};
function callback(item,_25c,_25d){
if(!_25c){
console.log("eventService.subscribeWire subscribe failed "+"source:"+_252+" sourceEvent:"+_253+" targetWidget:"+_254+" targetEvent:"+_255);
}
};
var _25e=this.hubAdapter._getInlineHubClient(_254);
if(typeof _25e!="undefined"&&_25e!=null){
var _25f=_25e.subscribe(this.WIDGETEVENT_PREFIX+_252+"."+_253,eventCallback,null,callback);
var _260=this._generateWireId(_252,_253,_254,_255);
this.subMgr[_260]=_25f;
var _261={};
_261.targetWidget=_254;
_261.sourceEvent=_253;
_261.sourceWidget=_252;
_261.targetEvent=_255;
this.fireEvent(_252,"onNewWire",_261);
}
return rc;
},publishWire:function(_262,_263,_264,_265){
_264=this._serializePayload(_264);
com.ibm.mm.enabler.debug.entry("eventService.publishWire","source:"+_262+" sourceEvent:"+_263+" payload:"+_264+" payloadType:"+_265);
if(typeof _262=="undefined"||_262===null){
return false;
}
if(typeof _263=="undefined"||_263===null){
return false;
}
var _266=this.hubAdapter._getInlineHubClient(_262);
if(typeof _266!="undefined"&&_266!=null){
_266.publish(this.WIDGETEVENT_PREFIX+_262+"."+_263,{"payload":_264,"payloadType":_265});
}
return true;
},_serializePayload:function(_267){
if(typeof _267=="object"&&_267.toJson){
_267=_267.toJson();
}
return _267;
},unSubscribeWire:function(_268,_269,_26a,_26b){
if(typeof _268=="undefined"||_268===null){
return false;
}
if(typeof _269=="undefined"||_269===null){
return false;
}
if(typeof _26a=="undefined"||_26a===null){
return false;
}
if(typeof _26b=="undefined"||_26b===null){
return false;
}
var _26c=this.hubAdapter._getInlineHubClient(_26a);
if(typeof _26c!="undefined"&&_26c!=null){
var _26d=this._generateWireId(_268,_269,_26a,_26b);
var _26e=this.subMgr[_26d];
if(typeof (_26e)!="undefined"&&_26e!=null){
this.unsubscribeEvent(_26e,_26a);
delete this.subMgr[_26d];
}
var _26f={};
_26f.targetWidget=_26a;
_26f.targetEvent=_26b;
_26f.sourceWidget=_268;
_26f.sourceEvent=_269;
this.fireEvent(_26a,"onRemoveWire",_26f);
this.fireEvent(_268,"onRemoveWire",_26f);
this.publishEvent(com.ibm.mm.iwidget.iEvents.Constants.unSubscribeWire,{wires:[_26f]});
}
return true;
},addWire:function(_270,_271,_272,_273){
com.ibm.mm.enabler.debug.entry("eventService.addWire","source:"+_270+" sourceEvent:"+_271+" targetWidget:"+_272+" targetEvent:"+_273);
if(typeof _270=="undefined"||_270===null){
return false;
}
if(typeof _271=="undefined"||_271===null){
return false;
}
if(typeof _272=="undefined"||_272===null){
return false;
}
if(typeof _273=="undefined"||_273===null){
return false;
}
var rc=false;
var _275=this.hubAdapter.isInlineClient(_272);
if(_275==false){
var _276="eventservice."+_272;
var _277={};
_277.methodname="addWire";
_277.params=arguments;
_277.hubclient="main";
this._publishEvent(event,_277);
rc=true;
}else{
rc=this.subscribeWire(_270,_271,_272,_273);
if(rc){
var _278=iWidgetContainer.getWidgetById(_272);
if(typeof _278!="undefined"&&_278!==null){
var _279={};
_279.SourceWidget=_270;
_279.SourceEvent=_271;
_279.TargetEvent=_273;
var _27a=_278.getIWidgetInstance();
var _27b=new com.ibm.mm.iwidget.widget.WireImpl(_272,_279);
_27a._addWire(_27b);
}
}
}
return rc;
},removeWire:function(_27c,_27d,_27e,_27f){
com.ibm.mm.enabler.debug.entry("eventService.removeWire","source:"+_27c+" sourceEvent:"+_27d+" targetWidget:"+_27e+" targetEvent:"+_27f);
if(typeof _27c=="undefined"||_27c===null){
return false;
}
if(typeof _27d=="undefined"||_27d===null){
return false;
}
if(typeof _27e=="undefined"||_27e===null){
return false;
}
if(typeof _27f=="undefined"||_27f===null){
return false;
}
var rc=false;
var _281=this.hubAdapter.isInlineClient(_27e);
if(_281==false){
var _282="eventservice."+_27e;
var _283={};
_283.methodname="removeWire";
_283.params=arguments;
_283.hubclient="main";
this._publishEvent(event,_283);
rc=true;
}else{
rc=this.unSubscribeWire(_27c,_27d,_27e,_27f);
if(rc){
var _284=iWidgetContainer.getWidgetById(_27e);
if(typeof _284!="undefined"&&_284!==null){
var _285={};
_285.SourceWidget=_27c;
_285.SourceEvent=_27d;
_285.TargetEvent=_27f;
var _286=_284.getIWidgetInstance();
var _287=new com.ibm.mm.iwidget.widget.WireImpl(_27e,_285);
_286._removeWire(_287.getID());
}
}
}
return rc;
},fireEvent:function(_288,_289,_28a,_28b,_28c){
var _28d=new com.ibm.mm.iwidget.iEventImpl(_289,_28b,_28a,_28c);
var _28e=com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
var _28f=_28e.find(_288);
var cb=function(_291,_292,_293,_294){
var _295=_291.hubAdapter.isInlineClient(_292.id);
if(_295){
_291._publishEvent(_291.WIDGETEVENT_PREFIX+_292.id,_293,_293.source);
}else{
var _296={};
if(_293.name==iwConstants.EVENTS.onModeChanged){
_296.methodname="_handleOnModeChange";
_296.params=[_28a];
_292.handleEvent(_296);
return;
}
_296.methodname="fireEvent";
_296.hubclient=_291.getId();
_296.params=[_292.id,_293.name,_293.payload,_293.type];
_291._publishEvent("eventservice."+_292.id,_296);
}
if(_294){
var _297=_291.subMgr[_294];
if(_297){
_291.unsubscribeEvent(_297);
}
delete _291.subMgr[_294];
}
};
if(typeof _28f!="undefined"&&_28f!==null&&_28f.isLoaded()==true){
cb(this,_28f,_28d);
}else{
var that=this;
var _299=dojox.uuid.generateTimeBasedUuid();
var _29a=this.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+_288,null,function(){
var _29b=_28e.find(_288);
cb(that,_29b,_28d,_299);
});
this.subMgr[_299]=_29a;
}
},publishEvent:function(_29c,_29d,_29e,_29f){
com.ibm.mm.enabler.debug.entry("eventService.publishEvent"," sourceEvent:"+_29c);
if(typeof _29c=="undefined"||_29c===null){
return;
}
if(_29c.indexOf(this.WILDCARD_PREFIX)==0){
var temp=this.WILDCARD_PREFIX;
return this.broadcastEvent(_29c.substring(temp.length),_29d,_29e,_29f);
}else{
if(_29c.indexOf(this.WIDGETEVENT_PREFIX)==0){
var temp=_29c.substring(this.WIDGETEVENT_PREFIX.length);
var _2a1=temp.substring(0,temp.indexOf("."));
var _2a2=temp.substring(temp.indexOf(".")+1);
return this.fireEvent(_2a1,_2a2,_29d,_29e,_29f);
}
}
this._publishEvent(_29c,_29d,_29f);
},_publishEvent:function(_2a3,_2a4,_2a5){
var _2a6=this.hubAdapter.getInlineHubClient(_2a5);
if(typeof _2a4=="undefined"||_2a4===null){
_2a6.publish(_2a3);
}else{
_2a6.publish(_2a3,_2a4);
}
},BROADCAST_EVENTS_COOKIE_ID:"com.ibm.mashups.enabler.broadcastEvents",BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID:"com.ibm.mashups.enabler.broadcastEventsSourceId",broadcastEvent:function(_2a7,_2a8,_2a9,_2aa){
this.broadcastEvent(_2a7,_2a8,_2a9,_2aa,null);
return;
},broadcastEvent:function(_2ab,_2ac,_2ad,_2ae,_2af){
this.broadcastEvent(_2ab,_2ac,_2ad,_2ae,_2af,null);
return;
},broadcastEvent:function(_2b0,_2b1,_2b2,_2b3,_2b4,_2b5){
var _2b6=new Object();
_2b6.targetEvent=_2b0;
_2b6.payload=_2b1;
_2b6.payloadType=_2b2;
this.broadcastEvents([_2b6],_2b3,_2b4,_2b5);
return;
},broadcastEvents:function(_2b7,_2b8){
this.broadcastEvents(_2b7,_2b8,null);
return;
},broadcastEvents:function(_2b9,_2ba,_2bb){
this.broadcastEvents(_2b9,_2ba,_2bb,null);
return;
},broadcastEvents:function(_2bc,_2bd,_2be,_2bf){
if((_2bc===null)||!dojo.isArray(_2bc)){
return;
}
var _2c0=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
var _2c1=com.ibm.mashups.enabler.model.state.AccessorFactory.getSpaceAccessor(_2c0);
var _2c2=_2c1.getSpaceID();
var _2c3=com.ibm.mashups.enabler.model.state.AccessorFactory.getPageAccessor(_2c0,_2c2);
var _2c4=_2c3.getPageID();
if((_2be!=null)&&(typeof _2be=="string")&&(_2be!=_2c4)){
this.broadcastEventsCache=_2bc;
this.broadcastEventsSourceIdCache=_2bd;
if(dojo.cookie.isSupported()){
dojo.cookie(this.BROADCAST_EVENTS_COOKIE_ID,dojo.toJson(_2bc),{expires:1});
dojo.cookie(this.BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID,_2bd,{expires:1});
}
if((_2bf!=null)&&(typeof _2bf=="string")&&(_2bf!=_2c2)){
_2c1.setSpaceID(_2bf);
}
_2c3.setPageID(_2be);
var _2c5=_2c0.commit();
_2c5.start();
}else{
var _2c6=com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
var _2c7=_2c6.getAllWidgets();
var that=this;
var _2c9=function(_2ca,_2cb,_2cc){
var _2cd=_2ca.getWidgetHandledEvents();
if(_2cd!=null){
for(var i=0;i<_2cb.length;i++){
for(var j=0;j<_2cd.length;j++){
if(_2cb[i].targetEvent==_2cd[j].name){
that.fireEvent(_2ca.getID(),_2cb[i].targetEvent,_2cb[i].payload,_2cb[i].payloadType,_2bd);
break;
}
}
}
}
if(_2cc&&_2cc!=null){
var _2d0=that.subMgr[_2cc];
if(_2d0){
that.unsubscribeEvent(_2d0);
}
delete that.subMgr[_2cc];
}
};
for(var i in _2c7){
var _2d2=_2c7[i];
if(_2d2.isLoaded()==true){
_2c9(_2d2,_2bc);
}else{
if(!_2d2.lazyLoad||(_2d2.lazyLoad&&_2d2.lazyLoad!=true)){
var _2d3=dojox.uuid.generateTimeBasedUuid();
var _2d4=this.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+_2d2.getID(),null,dojo.partial(_2c9,_2d2,_2bc,_2d3));
this.subMgr[_2d3]=_2d4;
}
}
}
for(var i=0;i<_2bc.length;i++){
this._publishEvent(_2bc[i].targetEvent,_2bc[i].payload,_2bd);
}
}
return;
},_handleBroadcastEventsCache:function(){
if(this.broadcastEventsCache===null||typeof this.broadcastEventsCache=="undefined"){
if(dojo.cookie.isSupported()){
this.broadcastEventsCache=dojo.fromJson(dojo.cookie(this.BROADCAST_EVENTS_COOKIE_ID));
}
}
if(this.broadcastEventsCache!=null&&typeof this.broadcastEventsCache!="undefined"&&dojo.isArray(this.broadcastEventsCache)){
if(this.broadcastEventsSourceIdCache===null||typeof this.broadcastEventsSourceIdCache=="undefined"){
if(dojo.cookie.isSupported()){
this.broadcastEventsSourceIdCache=dojo.cookie(this.BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID);
}
}
this.broadcastEvents(dojo.map(this.broadcastEventsCache,function(item){
return item;
}),this.broadcastEventsSourceIdCache);
this.broadcastEventsCache=null;
this.broadcastEventsSourceIdCache=null;
dojo.cookie(this.BROADCAST_EVENTS_COOKIE_ID,null,{expires:-1});
dojo.cookie(this.BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID,null,{expires:-1});
}
},_subscribeEvent:function(_2d6,_2d7,_2d8,_2d9,_2da){
var _2db=this._getHubAdapter().getInlineHubClient(_2da);
var _2dc=_2db.subscribe(_2d6,function(_2dd,data,_2df){
var ec=_2d8;
if(typeof _2d7!="undefined"&&_2d7!=null&&typeof _2d8!="undefined"&&_2d8!=null){
ec=dojo.hitch(_2d7,_2d8);
}
if(typeof ec!="undefined"&&ec!=null){
ec(data);
}
},null,function(_2e1,_2e2,_2e3){
if(typeof _2d7!="undefined"&&_2d7!=null&&typeof _2d9!="undefined"&&_2d9!=null){
_2d9=dojo.hitch(_2d7,_2d9);
}
if(typeof _2d9!="undefined"&&_2d9!=null){
_2d9.apply(this,[_2e1,_2e2,_2e3]);
}
if(!_2e2){
console.log("subscription for "+_2e1+" failed");
return;
}
});
return _2dc;
},subscribeEvent:function(_2e4,_2e5,_2e6,_2e7,_2e8){
return this._subscribeEvent(_2e4,_2e5,_2e6,_2e7,_2e8);
},_unsubscribeEvent:function(_2e9,_2ea){
var _2eb=this._getHubAdapter().getInlineHubClient(_2ea);
try{
if(typeof _2eb!="undefined"||_2eb!=null){
_2eb.unsubscribe(_2e9);
}
}
catch(e){
console.log("unsubscribe failure:"+e);
}
},unsubscribeEvent:function(_2ec,_2ed){
if(typeof _2ec=="undefined"||_2ec==null){
return;
}
this._unsubscribeEvent(_2ec,_2ed);
},_generateWireId:function(_2ee,_2ef,_2f0,_2f1){
return _2ee+"_"+_2ef+"_"+_2f0+"_"+_2f1;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.services.iframeeventservice"]){
dojo._hasResource["com.ibm.mm.iwidget.services.iframeeventservice"]=true;
dojo.provide("com.ibm.mm.iwidget.services.iframeeventservice");
dojo.declare("com.ibm.mm.iwidget.services.IframeEventServiceImpl",null,{constructor:function(){
this.subMgr={};
this.eventQueue=[];
this.getHubClient();
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},PREFIX_IFRAME:"_iframe_",getHubClient:function(){
if(this._hubClient!=null){
return this._hubClient;
}
var that=this;
function onHubClientSecurityAlert(_2f3,_2f4){
if(that.bIsLoggable){
that.LOGGER.trace("onHubClientSecurityAlert","security alert from "+_2f3.getClientID());
}
};
var _2f5=new OpenAjax.hub.IframeHubClient({HubClient:{onSecurityAlert:onHubClientSecurityAlert}});
function onHubClientConnect2(_2f6,_2f7,_2f8){
if(!_2f7){
if(that.bIsLoggable){
that.LOGGER.trace("onHubClientConnect2","!! client connection error = id: '"+_2f6.getClientID()+"' msg: '"+_2f8);
}
}
var id=_2f6.getClientID();
id=id.slice(8);
that.setId(id);
that._hubClient=_2f6;
that._subscribeEventService();
for(var i in that.eventQueue){
var args=that.eventQueue[i];
args[0]="widgetevents."+id+args[0];
that._subscribeEvent.apply(that,args);
}
};
function onHubClientDisconnect(_2fc,_2fd,_2fe){
if(!_2fd){
if(that.bIsLoggable){
that.LOGGER.trace("onHubClientDisconnect2","!! client disconnection error = id: '"+_2fc.getClientID()+"' msg: '"+_2fe);
}
}
_2fc.connect(onHubClientConnect2);
};
function onHubClientConnect1(_2ff,_300,_301){
if(!_300){
if(that.bIsLoggable){
that.LOGGER.trace("onHubClientConnect1","!! client connection error = id: '"+_2ff.getClientID()+"' msg: '"+_301);
}
}
var _302=_2ff.getClientID();
if(_302.indexOf("_edit")==-1){
_2ff.disconnect(onHubClientDisconnect);
}else{
onHubClientConnect2(_2ff,_300,_301);
}
};
if(dojo.isIE){
_2f5.connect(onHubClientConnect2);
}else{
_2f5.connect(onHubClientConnect1);
}
return null;
},disconnectHubClient:function(){
if(this._hubClient==null){
return;
}
this._hubClient.disconnect();
this._hubClient=null;
},setId:function(id){
this.id=id;
},getId:function(){
return this.id;
},_subscribeEventService:function(){
var that=this;
function eventCallback(_305,_306,_307){
var _308=_306.methodname;
if(typeof _308!="undefined"&&_308!=null){
var fn=that[_306.methodname];
if(typeof fn!="undefined"&&fn!=null){
that[_308].apply(that,_306.params);
}
}
};
this._hubClient.subscribe("eventservice."+this.getId(),eventCallback,this,this._subscribeCallback);
},_subscribeCallback:function(_30a,_30b,_30c){
if(!_30b){
}
},WIDGETEVENT_PREFIX:iwConstants.WIDGETEVENT_PREFIX,WILDCARD_PREFIX:iwConstants.WILDCARD_PREFIX,subscribeWire:function(_30d,_30e,_30f,_310){
com.ibm.mm.enabler.debug.entry("eventService.subscribeWire","source:"+_30d+" sourceEvent:"+_30e+" targetWidget:"+_30f+" targetEvent:"+_310);
if(typeof _30d=="undefined"||_30d===null){
return false;
}
if(typeof _30e=="undefined"||_30e===null){
return false;
}
if(typeof _30f=="undefined"||_30f===null){
return false;
}
if(typeof _310=="undefined"||_310===null){
return false;
}
var rc=true;
var that=this;
function eventCallback(_313,_314,_315){
that.fireEvent(_30f,_310,_314.payload,_314.payloadType,_30d);
};
function callback(item,_317,_318){
if(!_317){
if(that.bIsLoggable){
that.LOGGER.trace("subscribeWire","eventService.subscribeWire subscribe failed "+"source:"+_30d+" sourceEvent:"+_30e+" targetWidget:"+_30f+" targetEvent:"+_310);
}
}
};
var _319=this._hubClient.subscribe(this.WIDGETEVENT_PREFIX+_30d+"."+_30e,eventCallback,null,callback);
var _31a=this._generateWireId(_30d,_30e,_30f,_310);
this.subMgr[_31a]=_319;
var _31b={};
_31b.targetWidget=_30f;
_31b.sourceEvent=_30e;
_31b.sourceWidget=_30d;
_31b.targetEvent=_310;
this.fireEvent(_30d,"onNewWire",_31b);
return rc;
},publishWire:function(_31c,_31d,_31e,_31f){
_31e=this._serializePayload(_31e);
if(typeof _31c=="undefined"||_31c===null){
return false;
}
if(typeof _31d=="undefined"||_31d===null){
return false;
}
this._hubClient.publish(this.WIDGETEVENT_PREFIX+_31c+"."+_31d,{"payload":_31e,"payloadType":_31f});
return true;
},_serializePayload:function(_320){
if(typeof _320=="object"&&_320.toJson){
_320=_320.toJson();
}
return _320;
},unSubscribeWire:function(_321,_322,_323,_324){
if(typeof _321=="undefined"||_321===null){
return false;
}
if(typeof _322=="undefined"||_322===null){
return false;
}
if(typeof _323=="undefined"||_323===null){
return false;
}
if(typeof _324=="undefined"||_324===null){
return false;
}
var _325=this._generateWireId(_321,_322,_323,_324);
var _326=this.subMgr[_325];
if(typeof (_326)!="undefined"&&_326!=null){
this._unsubscribeEvent(_326,_324);
delete this.subMgr[_325];
}
var _327={};
_327.targetWidget=_323;
_327.targetEvent=_324;
_327.sourceWidget=_321;
_327.sourceEvent=_322;
this.fireEvent(_323,"onRemoveWire",_327);
this.fireEvent(_321,"onRemoveWire",_327);
this._publishEvent(com.ibm.mm.iwidget.iEvents.Constants.unSubscribeWire,{wires:[_327]});
},fireEvent:function(_328,_329,_32a,_32b,_32c){
var _32d=new com.ibm.mm.iwidget.iEventImpl(_329,_32b,_32a,_32c);
var _32e=com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
var _32f=_32e.find(_328);
if(typeof _32f!="undefined"&&_32f!==null){
if(_32f.isLoaded()==true){
_32f.handleEvent(_32d);
}else{
var _330=dojox.uuid.generateTimeBasedUuid();
var cb=function(_332,_333,_334){
_333.handleEvent(_334);
var _335=_332.subMgr[_330];
if(_335){
_332._unsubscribeEvent(_335);
}
};
var _336=this.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+_32f.id,null,dojo.partial(cb,this,_32f,_32d));
this.subMgr[_330]=_336;
}
}else{
var _337={};
_337.methodname="fireEvent";
_337.hubclient=this.getId();
_337.params=[_328,_329,_32a,_32b];
this._publishEvent("eventservice.main",_337);
}
},publishEvent:function(_338,_339,_33a,_33b){
return;
},_publishEvent:function(_33c,_33d,_33e){
if(typeof _33d=="undefined"||_33d===null){
this._hubClient.publish(_33c,"");
}else{
this._hubClient.publish(_33c,_33d);
}
},broadcastEvent:function(_33f,_340,_341,_342){
return;
},broadcastEvent:function(_343,_344,_345,_346,_347){
return;
},broadcastEvent:function(_348,_349,_34a,_34b,_34c,_34d){
return;
},broadcastEvents:function(_34e,_34f){
return;
},broadcastEvents:function(_350,_351,_352){
return;
},broadcastEvents:function(_353,_354,_355,_356){
return;
},_handleBroadcastEventsCache:function(){
var _357={};
_357.methodname="_handleBroadcastEventsCache";
_357.hubclient=this.getId();
_357.params=[];
this._publishEvent("eventservice.main",_357);
},subscribeEvent:function(_358,_359,_35a,_35b,_35c){
return;
},_subscribeEvent:function(_35d,_35e,_35f,_360,_361){
if(this._hubClient==null){
this.eventQueue.push(arguments);
return;
}
var _362=this._hubClient.subscribe(_35d,function(_363,data,_365){
if(typeof _35e!="undefined"&&_35e!=null&&typeof _35f!="undefined"&&_35f!=null){
_35f=dojo.hitch(_35e,_35f);
}
if(typeof _35f!="undefined"&&_35f!=null){
_35f.apply(this,[data]);
}
},null,function(_366,_367,_368){
if(typeof _35e!="undefined"&&_35e!=null&&typeof _360!="undefined"&&_360!=null){
_360=dojo.hitch(_35e,_360);
}
if(typeof _360!="undefined"&&_360!=null){
_360.apply(this,[_366,_367,_368]);
}
if(!_367){
return;
}
});
return _362;
},_unsubscribeEvent:function(_369,_36a){
if(typeof _369=="undefined"||_369==null){
return;
}
this._hubClient.unsubscribe(_369);
},unsubscribeEvent:function(_36b,_36c){
return;
},_generateWireId:function(_36d,_36e,_36f,_370){
return _36d+"_"+_36e+"_"+_36f+"_"+_370;
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.xml"]){
dojo._hasResource["com.ibm.mashups.enabler.xml"]=true;
dojo.provide("com.ibm.mashups.enabler.xml");
dojo.provide("com.ibm.mashups.enabler.xml.XPath");
dojo.declare("com.ibm.mashups.enabler.xml.XPath",null,{constructor:function(){
},evaluateXPath:function(_371,doc,_373){
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.xpath"]){
dojo._hasResource["com.ibm.mm.enabler.xpath"]=true;
dojo.provide("com.ibm.mm.enabler.xpath");
com.ibm.mm.enabler.xpath.evaluateXPath=function(_374,doc,_376,_377){
if(typeof _377=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.xpath.evaluateXPath","This method must not be used directly. Use com.ibm.mashups.enabler.xml.evaluateXPath instead.",_374);
}
if(dojo.isSafari){
return com.ibm.mm.enabler.xpath.safari.evaluateXPath(_374,doc,_376);
}else{
if(dojo.isIE){
return com.ibm.mm.enabler.xpath.ie.evaluateXPath(_374,doc,_376);
}else{
return com.ibm.mm.enabler.xpath.gecko.evaluateXPath(_374,doc,_376);
}
}
};
dojo.provide("com.ibm.mm.enabler.xpath.safari");
com.ibm.mm.enabler.xpath.safari.evaluateXPath=function(_378,doc,_37a){
var _37b;
if(typeof XPathResult!="undefined"){
var _37c=document.evaluate(_378,doc,function(_37d){
return _37a[_37d]||null;
},XPathResult.ANY_TYPE,null);
var _37e;
_37b=[];
var len=0;
do{
_37e=_37c.iterateNext();
if(_37e){
_37b[len]=_37e;
len++;
}
}while(_37e);
}else{
if(doc.selectNodes){
_37b=doc.selectNodes(_378);
}
}
return _37b;
};
dojo.provide("com.ibm.mm.enabler.xpath.ie");
com.ibm.mm.enabler.xpath.ie.evaluateXPath=function(_380,doc,_382){
if(_382){
var ns="";
for(var prop in _382){
if(prop!="xml"){
ns+="xmlns:"+prop+"='"+_382[prop]+"' ";
}
}
if(doc.ownerDocument){
doc.ownerDocument.setProperty("SelectionNamespaces",ns);
doc.ownerDocument.setProperty("SelectionLanguage","XPath");
}else{
doc.setProperty("SelectionNamespaces",ns);
doc.setProperty("SelectionLanguage","XPath");
}
}
var _385=doc.selectNodes(_380);
var _386;
var _387=[];
var len=0;
for(var i=0;i<_385.length;i++){
_386=_385[i];
if(_386){
_387[len]=_386;
len++;
}
}
return _387;
};
dojo.provide("com.ibm.mm.enabler.xpath.gecko");
com.ibm.mm.enabler.xpath.gecko.evaluateXPath=function(_38a,doc,_38c){
var _38d;
try{
var _38e=doc;
if(doc.nodeType!=9){
_38e=doc.ownerDocument;
}
_38d=_38e.evaluate(_38a,doc,function(_38f){
return _38c[_38f]||null;
},XPathResult.ANY_TYPE,null);
}
catch(exc){
throw new Error("Error with xpath expression"+exc);
}
var _390;
var _391=[];
var len=0;
do{
_390=_38d.iterateNext();
if(_390){
_391[len]=_390;
len++;
}
}while(_390);
return _391;
};
com.ibm.mm.enabler.xpath.createXPath=function(_393,node,_395){
var _396=_393.split("/");
var _397=_396[0];
var _398=_397.split(":");
if(_398.length>1){
var _399=_398[0];
var name=_398[1];
}else{
var name=_398[0];
}
var _39b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath((_399?_399+":":"")+name,node,_395);
if(_39b&&_39b.length>0){
var _39c=_39b[0];
}else{
var _39c=com.ibm.mm.enabler.dom.createElement(node.ownerDocument,name,_399?_395[_399]:null);
node.appendChild(_39c);
}
if(_396.length>1){
_39c=com.ibm.mm.enabler.xpath.createXPath(_393.substr(_393.indexOf("/")+1),_39c,_395);
}
return _39c;
};
}
if(!dojo._hasResource["com.ibm.mm.enabler.xml"]){
dojo._hasResource["com.ibm.mm.enabler.xml"]=true;
dojo.provide("com.ibm.mm.enabler.xml");
dojo.declare("com.ibm.mm.enabler.xml.XPathImpl",[com.ibm.mashups.enabler.xml.XPath],{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.xml.XPath");
},evaluateXPath:function(_39d,doc,_39f){
var _3a0="evaluateXPath(xpathExpr,  doc, namespaces)";
var _3a1=this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
if(_3a1){
this.LOGGER.entering(_3a0,[_39d,doc,_39f]);
}
var ret=com.ibm.mm.enabler.xpath.evaluateXPath(_39d,doc,_39f,true);
if(_3a1){
this.LOGGER.exiting(_3a0,ret);
}
return ret;
}});
com.ibm.mashups.enabler.xml.XPath=new com.ibm.mm.enabler.xml.XPathImpl();
}
if(!dojo._hasResource["com.ibm.mm.iwidget.services.internalservices"]){
dojo._hasResource["com.ibm.mm.iwidget.services.internalservices"]=true;
dojo.provide("com.ibm.mm.iwidget.services.internalservices");
dojo.declare("com.ibm.mm.iwidget.services.ResourceLoadServiceImpl",null,{constructor:function(){
this.modules={};
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
this.LOADING_TOKEN=0;
this.LOADING_ERROR_TOKEN=1;
this.LOADED_TOKEN=2;
this.waitingqueue={};
},loadResource:function(_3a3,name,uri,cb,_3a7,cb2){
com.ibm.mm.enabler.debug.entry("loadService.loadResource","uri:"+uri+" mimetype:"+_3a7+" widgetId:"+_3a3);
var path=this._rewriteUrl(uri,_3a3);
var _3aa=this.modules[path];
var _3ab=function(data,_3ad){
if(cb2){
var _3ae=com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
_3ae.suspendTransaction();
if(data&&_3ad){
cb2(data,_3ad);
}else{
cb2();
}
_3ae.resumeTransaction();
}
};
if(_3aa&&_3aa!==null){
var type=_3aa.type;
switch(type){
case 0:
this.waitingqueue[path]=(this.waitingqueue[path])?this.waitingqueue[path]:[];
this.waitingqueue[path].push({uri:uri,cb:cb,cb2:cb2});
return;
break;
case 1:
_3ab(_3aa.data,_3aa.status);
return;
break;
case 2:
_3ab();
return;
break;
}
}
_3aa={};
_3aa.type=this.LOADING_TOKEN;
this.modules[path]=_3aa;
var _3b0=this._getExtension(uri);
if(_3b0!==null&&_3b0=="css"){
var _3b1=this._loadCSS(path);
this.modules[path].type=this.LOADED_TOKEN;
if(cb2){
var _3b2=com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
_3b2.suspendTransaction();
cb2();
_3b2.resumeTransaction();
}
return _3b1;
}
var _3b3=path;
if(dojo.isIE==6&&path.indexOf("/")==0){
var _3b4=window.location.protocol;
var host=window.location.hostname;
var port=window.location.port;
_3b3=_3b4+"//"+host+":"+port+path;
}
var me=this;
var _3b8=com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
var _3b9=(_3b8.isTransaction()==true)?false:true;
var args={url:_3b3,sync:_3b9,load:function(data,_3bc){
if(_3bc.xhr.status==200||_3bc.xhr.status==0){
var _3bd=_3bc.xhr.responseText;
var _3be=_3bd.replace(/_IWID_/g,"_"+_3a3+"_");
if(cb){
}
}
if(!_3be){
return false;
}
if(_3b0==="js"||_3a7=="text/javascript"){
if(window.execScript){
window.execScript(_3be);
}else{
dojo.eval(_3be);
}
}
me.modules[path].type=me.LOADED_TOKEN;
if(cb2){
var _3bf=com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
_3bf.suspendTransaction();
cb2();
_3bf.resumeTransaction();
}
var _3c0=me.waitingqueue[path];
if(_3c0&&_3c0!=null){
for(var j=0;j<_3c0.length;j++){
var req=_3c0[j];
if(req.cb2&&req.cb2!=null){
var _3c3=req.cb2;
_3c3();
}
}
}
me.waitingqueue[path]=null;
},error:function(data,_3c5){
me.modules[path].type=me.LOADING_ERROR_TOKEN;
me.modules[path].data=data;
me.modules[path].status=_3c5.xhr.status;
var xhr=_3c5.xhr;
if(cb2){
cb2(data,xhr.status);
}
var _3c7=me.waitingqueue[path];
if(_3c7&&_3c7!=null){
for(var h=0;h<_3c7.length;h++){
var req=_3c7[h];
if(req.cb2&&req.cb2!=null){
var _3ca=req.cb2;
_3ca(data,xhr.status);
}
}
}
me.waitingqueue[path]=null;
}};
dojo.xhrGet(args);
},_rewriteUrl:function(uri,id){
var _3cd=iWidgetContainer.getWidgetById(id);
var _3ce=_3cd.getIWidgetInstance().widgetXMLUrl;
var _3cf=com.ibm.mm.enabler.model.Utils.checkForEndpoints(_3ce);
if(_3cf!=null){
_3ce=_3cf;
}
var _3d0=_3ce.indexOf("?");
if(0<_3d0){
_3ce=_3ce.substring(0,_3d0);
}
var _3d1=_3ce.substring(0,_3ce.lastIndexOf("/")+1);
if(_3d1.indexOf("://")!=-1){
var _3d2=uri.indexOf("://");
var _3d3=uri.indexOf("/",_3d2+1);
var _3d4=uri.substring(0,_3d3);
}
var path=uri;
if(uri.indexOf("://")==-1){
if(uri.indexOf("/")===0){
if(typeof (_3d4)!="undefined"){
path=_3d4+uri;
}
}else{
if(typeof (_3d1)!="undefined"){
path=_3d1+uri;
}
}
}
if((path.indexOf("http")===0)||(path.indexOf("endpoint")===0)){
path=com.ibm.mm.enabler.utilities.rewriteURL(path);
}
return path;
},_getExtension:function(uri){
return uri.substring(uri.lastIndexOf(".")+1,uri.length);
},_loadCSS:function(path){
var link=document.createElement("link");
link.setAttribute("rel","stylesheet");
link.setAttribute("type","text/css");
link.setAttribute("href",path);
document.getElementsByTagName("head")[0].appendChild(link);
}});
dojo.declare("com.ibm.mm.iwidget.services.PersistentAttributesFactoryServiceImpl",null,{createPersistentAttributes:function(_3d9){
return new com.ibm.mm.iwidget.itemset.PersistentAttributes(_3d9,true);
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.services.qservice"]){
dojo._hasResource["com.ibm.mm.iwidget.services.qservice"]=true;
dojo.provide("com.ibm.mm.iwidget.services.qservice");
dojo.declare("com.ibm.mm.iwidget.services.QueryServiceImpl",null,{getiWidgetWrapperById:function(id){
var _3db=iWidgetContainer.getWidgetById(id);
if(typeof _3db=="undefined"||_3db===null){
return null;
}
return new com.ibm.mm.iwidget.iWidgetWrapperImpl(id);
},getWidgetById:function(id,obj,cb){
var _3df=iWidgetContainer.getWidgetById(id);
if(typeof _3df=="undefined"||_3df===null){
return null;
}
if(!obj||!cb){
if(_3df.isLoaded()==true){
return new com.ibm.mm.iwidget.WidgetStub(_3df);
}else{
return null;
}
}
var cbn=function(_3e1,obj,cb){
obj[cb](new com.ibm.mm.iwidget.WidgetStub(_3e1));
};
if(_3df.isLoaded()==true){
cbn(_3df,obj,cb);
}else{
com.ibm.mashups.services.ServiceManager.getService("eventService").subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+id,null,function(){
var _3e4=iWidgetContainer.find(id);
cbn(_3e4,obj,cb);
});
}
},getWidgetsByDefUrl:function(url){
for(id in iWidgetContainer.widgetArr){
var _3e6=iWidgetContainer.widgetArr[id];
if(_3e6&&_3e6!==null){
var _3e7=_3e6.getIWidgetInstance().widgetXMLUrl;
if(typeof _3e7!="undefined"&&_3e7!==null&&url==_3e7){
arr.push(id);
}
}
}
return arr;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.xslt"]){
dojo._hasResource["com.ibm.mm.enabler.xslt"]=true;
dojo.provide("com.ibm.mm.enabler.xslt");
com.ibm.mm.enabler.xslt.ie={};
com.ibm.mm.enabler.xslt.gecko={};
com.ibm.mm.enabler.xslt.getXmlHttpRequest=function(){
var oXml=null;
if(typeof ActiveXObject!="undefined"){
oXml=new ActiveXObject("Microsoft.XMLHTTP");
}else{
oXml=new XMLHttpRequest();
}
return oXml;
};
com.ibm.mm.enabler.xslt.loadXml=function(sUrl){
if(typeof ActiveXObject!="undefined"){
return com.ibm.mm.enabler.xslt.ie.loadXml(sUrl);
}else{
return com.ibm.mm.enabler.xslt.gecko.loadXml(sUrl);
}
};
com.ibm.mm.enabler.xslt.loadXmlString=function(sXml){
if(typeof ActiveXObject!="undefined"){
return com.ibm.mm.enabler.xslt.ie.loadXmlString(sXml);
}else{
var _3eb=new DOMParser();
return com.ibm.mm.enabler.xslt.gecko.loadXmlString(sXml);
}
};
com.ibm.mm.enabler.xslt.loadXsl=function(sUrl){
if(typeof ActiveXObject!="undefined"){
return com.ibm.mm.enabler.xslt.ie.loadXsl(sUrl);
}else{
return com.ibm.mm.enabler.xslt.gecko.loadXsl(sUrl);
}
};
com.ibm.mm.enabler.xslt.transform=function(xml,xsl,_3ef,_3f0,_3f1){
com.ibm.mm.enabler.debug.entry("xslt.transform",xml,xsl,_3ef,_3f0,_3f1);
if(typeof ActiveXObject!="undefined"){
return com.ibm.mm.enabler.xslt.ie.transform(xml,xsl,_3ef,_3f0,_3f1);
}else{
return com.ibm.mm.enabler.xslt.gecko.transform(xml,xsl,_3ef,_3f0,_3f1);
}
};
com.ibm.mm.enabler.xslt.transformAndUpdate=function(_3f2,xml,xsl,_3f5,_3f6){
com.ibm.mm.enabler.debug.entry("xslt.transformAndUpdate",_3f2,xml,xsl,_3f5,_3f6);
if(typeof ActiveXObject!="undefined"){
var _3f7=com.ibm.mm.enabler.xslt.ie.transform(xml,xsl,_3f5,_3f6,true);
com.ibm.mm.enabler.debug.log("xslt.transformAndUpdate","XSLT result: "+_3f7);
_3f2.innerHTML+=_3f7;
}else{
_3f7=com.ibm.mm.enabler.xslt.gecko.transform(xml,xsl,_3f5,_3f6,false);
com.ibm.mm.enabler.debug.log("xslt.transformAndUpdate","XSLT result: "+(new XMLSerializer()).serializeToString(_3f7),"com.ibm.mm.enabler.xslt.transformAndUpdate");
var _3f8=_3f7.documentElement;
if(_3f7.documentElement.tagName=="transformiix:result"){
_3f8=_3f7.documentElement.childNodes;
com.ibm.mm.enabler.dom.copyChildren(_3f7.documentElement,_3f2,true);
}else{
com.ibm.mm.enabler.debug.log("xslt.transformAndUpdate","Appending2: "+(new XMLSerializer()).serializeToString(_3f8),"com.ibm.mm.enabler.xslt.transformAndUpdate");
_3f2.appendChild(_3f8);
}
}
com.ibm.mm.enabler.debug.exit("xslt.transformAndUpdate");
};
com.ibm.mm.enabler.xslt.ie.loadXml=function(sUrl){
var _3fa=new ActiveXObject("MSXML2.DOMDocument");
_3fa.async=0;
_3fa.resolveExternals=0;
if(!_3fa.load(sUrl)){
throw new Error("Error loading xml file "+sUrl);
}
return _3fa;
};
com.ibm.mm.enabler.xslt.ie.loadXmlString=function(sXml){
var _3fc=new ActiveXObject("MSXML2.DOMDocument");
_3fc.async=0;
_3fc.resolveExternals=0;
if(!_3fc.loadXML(sXml)){
throw new Error("Error loading xml string "+sXml);
}
return _3fc;
};
com.ibm.mm.enabler.xslt.ie.loadXsl=function(sUrl){
var _3fe=new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
_3fe.async=0;
_3fe.resolveExternals=0;
if(!_3fe.load(sUrl)){
throw new Error("Error loading xsl file "+sUrl);
}
return _3fe;
};
com.ibm.mm.enabler.xslt.ie.transform=function(_3ff,xsl,_401,_402,_403){
var oXml=_3ff;
var oXsl=xsl;
try{
if(!oXsl.documentElement){
oXsl=this.loadXsl(xsl);
}
}
catch(e){
var sMsg=e.message;
throw new Error(""+sMsg,""+sMsg);
}
var _407=new ActiveXObject("Msxml2.XSLTemplate");
_407.stylesheet=oXsl;
var _408=_407.createProcessor();
_408.input=oXml;
if(_402){
for(var p in _402){
_408.addParameter(p,_402[p]);
}
}
if(_401){
_408.addParameter("mode",_401);
}
if(_403){
if(!_408.transform()){
throw new Error("Error transforming xml doc "+oXml);
}
return _408.output;
}else{
var _40a=new ActiveXObject("MSXML2.DOMDocument");
_40a.async=0;
_40a.validateOnParse=1;
oXml.transformNodeToObject(oXsl,_40a);
return _40a;
}
};
com.ibm.mm.enabler.xslt.gecko.loadXml=function(sUrl){
};
com.ibm.mm.enabler.xslt.gecko.loadXmlString=function(sXml){
var _40d=new DOMParser();
try{
oXmlDoc=_40d.parseFromString(sXml,"text/xml");
}
catch(exc){
throw new Error("Error loading xml string "+sXml);
}
return oXmlDoc;
};
com.ibm.mm.enabler.xslt.gecko.loadXsl=function(sUrl){
var _40f=document.implementation.createDocument("","",null);
_40f.async=0;
_40f.load(sUrl);
return _40f;
};
com.ibm.mm.enabler.xslt.gecko.transform=function(_410,xsl,_412,_413,_414){
try{
var _415=xsl;
if(!_415.documentElement){
_415=this.loadXsl(xsl);
}
var proc=new XSLTProcessor();
proc.importStylesheet(_415);
if(_413){
for(var p in _413){
proc.setParameter(null,p,_413[p]);
}
}
if(_412){
proc.setParameter(null,"mode",_412);
}
var _418=proc.transformToDocument(_410);
if(!_414){
return _418;
}
resultStr=_418.documentElement.childNodes[0].textContent;
}
catch(exc){
throw new Error("Error transforming xml doc "+exc);
}
return resultStr;
};
com.ibm.mm.enabler.xslt.setLayerContentByXml=function(_419,xml,xsl,_41c,_41d){
var _41e=com.ibm.mm.enabler.xslt.transform(xml,xsl,null,_41c,_41d);
if(_419.innerHTML){
_419.innerHTML=_41e;
}else{
var obj=document.getElementById(_419);
obj.innerHTML=_41e;
}
};
}
if(!dojo._hasResource["com.ibm.mm.iwidget.services.fragmentservice"]){
dojo._hasResource["com.ibm.mm.iwidget.services.fragmentservice"]=true;
dojo.provide("com.ibm.mm.iwidget.services.fragmentservice");
dojo.declare("com.ibm.mm.iwidget.services.IWidgetFragmentServiceImpl",null,{createItem:function(_420,_421,_422,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var item=document.createElement("a");
dojo.addClass(item,ns+iwConstants.CSSCLASS_INSTANCE.iwItem);
dojo.style(item,"visibility","hidden");
dojo.style(item,"display","none");
item.setAttribute("href","#"+_420);
if(_422){
item.setAttribute("lang",_422);
}
if(_421&&!_422){
item.innerHTML=_421;
}
return item;
},createItemSet:function(_425,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var _427=document.createElement("span");
dojo.addClass(_427,ns+iwConstants.CSSCLASS_INSTANCE.iwItemSet);
_427.setAttribute("title",_425);
dojo.style(_427,"visibility","hidden");
dojo.style(_427,"display","none");
return _427;
},createWidgetDefRef:function(_428,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var aTag=document.createElement("a");
dojo.addClass(aTag,ns+iwConstants.CSSCLASS_INSTANCE.iwDefinition);
aTag.setAttribute("href",_428);
dojo.style(aTag,"visibility","hidden");
dojo.style(aTag,"display","none");
return aTag;
},getItemSet:function(_42b,name,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var rc=null;
var _42f=dojo.byId(_42b);
var _430=dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwItemSet,_42f);
for(var i=0;i<_430.length;i++){
var _432=_430[i];
var _433=_432.getAttribute("title");
if(name==_433){
rc=_432;
break;
}
}
return rc;
},getItem:function(_434,name,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var rc=null;
var _438=dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwItem,_434);
for(var i=0;i<_438.length;i++){
var _43a=_438[i];
var _43b=this.getKeyFromHref(_43a);
if(_43b!=null&&_43b==name){
rc=_43a;
break;
}
}
return rc;
},getItems:function(_43c,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var _43e=dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwItem,_43c);
if(typeof _43e=="undefined"||_43e==null||_43e.length==0){
_43e=null;
}
return _43e;
},getWidgetDefRef:function(_43f,ns){
if(typeof ns=="undefined"||ns==null){
ns="mm_";
}
var rc=null;
var _442=dojo.byId(_43f);
var def=dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwDefinition,_442)[0];
var ref=def.getAttribute("href");
if(typeof ref!="undefined"&&ref!=null){
rc=ref;
}
return rc;
},getKeyFromHref:function(node){
var _446=node.getAttribute("href");
if(_446==null){
return null;
}
var pos=_446.indexOf("#");
if(pos<0){
return null;
}
return _446.substring(pos+1);
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widgetImpl"]){
dojo._hasResource["com.ibm.mm.iwidget.widgetImpl"]=true;
dojo.provide("com.ibm.mm.iwidget.widgetImpl");
dojo.declare("com.ibm.mm.iwidget.iWidgetWrapperImpl",null,{constructor:function(id){
this.id=id;
},getiWidgetMetadata:function(){
return new com.ibm.mm.iwidget.iWidgetMetadataImpl(this.id);
},getInstanceAttributes:function(){
var _449=iWidgetContainer.getWidgetById(this.id);
if(typeof _449=="undefined"||_449===null){
return null;
}
_449.getIWidgetInstance().loadItemSets();
var _44a=_449.getIWidgetInstance()._getAttributes();
var _44b=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl();
for(var j in _44a){
var _44d=j;
var _44e=_44a[_44d]["defaultValue"];
_44b.setItemValue(_44d,_44e,false);
}
return _44b;
}});
dojo.declare("com.ibm.mm.iwidget.iWidgetMetadataImpl",null,{constructor:function(id){
this._id=id;
this._items={};
this._debug=com.ibm.mm.enabler.debug;
},CONSTANTS:{"title":"title","icon":"icon"},getItemValue:function(_450,_451){
if(!_451){
_451="en";
}
if(typeof _450=="undefined"||_450===null){
return null;
}
if(!this.CONSTANTS[_450]){
return null;
}
var _452=this._getInternalIWidgetWrapper();
if(_452===null){
return null;
}
var data=this._items[_450][_451];
if(typeof data=="undefined"||data===null){
if(!this._loadData(_450,_451)){
return null;
}
data=this._items[_450][_451];
}
if(data["detail"]!="undefined"&&data["detail"]!=null){
return data.detail;
}else{
return null;
}
},_setItemValue:function(_454,_455){
if(typeof _454=="undefined"||_454==null||typeof _455=="undefined"||_455===null){
return null;
}
if(!this.CONSTANTS[_454]){
return null;
}
var _456=this._getInternalIWidgetWrapper().getIWidgetInstance().getIDescriptorItems();
if(!_456){
return;
}
_456.setItemValue(_454,_455);
},setItemValue:function(_457,_458,_459){
if(typeof _457=="undefined"||_457==null||typeof _458=="undefined"||_458===null){
return null;
}
if(!this.CONSTANTS[_457]){
return null;
}
var _45a=this._getInternalIWidgetWrapper().getIWidgetInstance().getIDescriptorItems();
if(!_45a){
return;
}
_45a.setItemValue(_457,_458,_459);
},save:function(){
iWidgetContainer.commit().start();
},_getInternalIWidgetWrapper:function(){
if(typeof (this._internalWidgetWrapper)=="undefined"||this._internalWidgetWrapper===null){
var _45b=iWidgetContainer.getWidgetById(this._id);
if(typeof _45b=="undefined"||_45b===null){
return null;
}
this._internalWidgetWrapper=_45b;
}
return this._internalWidgetWrapper;
},_loadData:function(_45c,_45d){
if(!_45d){
_45d="en";
}
var rc=false;
var _45f={};
var _460=this._getInternalIWidgetWrapper().getIWidgetInstance().getIDescriptorItems();
if(_460&&_460.getItemValue(_45c,_45d)){
var _461=dojo.toJson(_460.getItemValue(_45c,_45d));
_45f.isDirty=true;
_45f.detail=dojo.fromJson(_461);
rc=true;
}else{
_45f.detail={};
_45f.detail.itemName=_45c;
_45f.isDirty=false;
}
this._items[_45c][_45d]=_45f;
return rc;
},_updateMarkup:function(_462){
var _463=_462.itemName;
var _464=_462.defaultValue;
var _465=com.ibm.mashups.services.ServiceManager.getService("iwidgetFragmentService");
var _466=_465.getItemSet(this._id,iwConstants.IDESCRIPTOR);
if(_466==null){
var node=_465.createItemSet(iwConstants.IDESCRIPTOR);
var _468=dojo.byId(this._id);
_468.insertBefore(node,_468.firstChild.nextSibling);
_466=_465.getItemSet(this._id,iwConstants.IDESCRIPTOR);
}
var _469=_465.getItem(_466,_463);
if(_469==null){
var node=_465.createItem(_463,_464);
_466.appendChild(node);
}else{
_469.innerHTML=_464;
}
this._getInternalIWidgetWrapper().getIWidgetInstance().loadItemSets();
}});
dojo.declare("com.ibm.mm.iwidget.WidgetStub",null,{constructor:function(_46a){
this._wrapper=_46a;
this.id=_46a.id;
this.publishedEvents=_46a._getPublishedEvents();
this.handledEvents=_46a._getHandledEvents();
this.payloadDefs=_46a.widgetDef.getPayloadDefs();
this.supportedModes=_46a.widgetDef.getSupportedModes();
},getPublishedEventsNames:function(){
if(!this.publishedEvents){
return null;
}
var _46b=[];
var _46c;
for(_46c in this.publishedEvents){
_46b.push(_46c);
}
if(_46b.length==0){
return null;
}
return _46b;
},getHandledEventsNames:function(){
if(!this.handledEvents){
return null;
}
var _46d=[];
var _46e;
for(_46e in this.handledEvents){
_46d.push(_46e);
}
if(_46d.length==0){
return null;
}
return _46d;
},getPublishedEvent:function(_46f){
if(!this.publishedEvents){
return null;
}
return [this.publishedEvents[_46f]];
},getHandledEvent:function(_470){
if(!this.handledEvents){
return null;
}
return [this.handledEvents[_470]];
},getPayloadDefs:function(){
return this.payloadDefs;
},getPayloadDef:function(name){
var _472=this.payloadDefs[name];
if(typeof _472=="undefined"){
return null;
}
return _472;
},getPayloadDefNames:function(){
var arr=[];
var a;
for(a in this.payloadDefs){
arr.push(a);
}
if(arr.length==0){
return null;
}
return arr;
},getWires:function(){
return this._wrapper.getWires();
},getSupportedModes:function(){
return this.supportedModes;
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.shared"]){
dojo._hasResource["com.ibm.mashups.enabler.model.shared"]=true;
dojo.provide("com.ibm.mashups.enabler.model.shared");
dojo.provide("com.ibm.mashups.enabler.Identifiable");
dojo.provide("com.ibm.mashups.enabler.Localized");
dojo.provide("com.ibm.mashups.enabler.MetaData");
dojo.provide("com.ibm.mashups.enabler.Locator");
dojo.provide("com.ibm.mashups.enabler.Iterator");
dojo.provide("com.ibm.mashups.enabler.Logout");
dojo.provide("com.ibm.mashups.enabler.ResourceLocator");
dojo.provide("com.ibm.mashups.enabler.strategy.Strategy");
dojo.provide("com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.strategy.TreeLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.strategy.UserLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.model.Model");
dojo.provide("com.ibm.mashups.enabler.model.ListModel");
dojo.provide("com.ibm.mashups.enabler.model.TreeModel");
dojo.provide("com.ibm.mashups.enabler.SubmittableFormProvider");
dojo.provide("com.ibm.mashups.enabler.SubmittableForm");
dojo.declare("com.ibm.mashups.enabler.Iterator",null,{constructor:function(){
},hasNext:function(){
return new Boolean();
},next:function(){
return {};
},size:function(){
return new Deferred();
},setCursorPosition:function(_475){
},getCursorPosition:function(){
return null;
}});
dojo.declare("com.ibm.mashups.enabler.Deferred",null,{constructor:function(){
},setFinishedCallback:function(_476,_477){
},start:function(sync){
return {};
}});
dojo.declare("com.ibm.mashups.enabler.DeferredOperation",com.ibm.mashups.enabler.Deferred,{OPERATION_GET:"GET",OPERATION_CREATE:"CREATE",OPERATION_MODIFY:"MODIFY",OPERATION_DELETE:"DELETE",constructor:function(){
},setOperationCallback:function(_479,_47a){
}});
dojo.declare("com.ibm.mashups.enabler.DeferredIterator",[com.ibm.mashups.enabler.Deferred,com.ibm.mashups.enabler.Iterator],{constructor:function(){
},setForEachCallback:function(_47b,_47c){
return new Boolean();
}});
dojo.declare("com.ibm.mashups.enabler.Identifiable",null,{constructor:function(){
},getID:function(){
return String();
}});
dojo.declare("com.ibm.mashups.enabler.Transformable",null,{constructor:function(){
},getXml:function(){
return new Object();
}});
dojo.declare("com.ibm.mashups.enabler.Localized",null,{constructor:function(){
},getLocales:function(){
return [];
},getTitle:function(_47d){
return new String();
},getDescription:function(_47e){
return new String();
}});
dojo.declare("com.ibm.mashups.enabler.ModifiableLocalized",com.ibm.mashups.enabler.Localized,{constructor:function(){
},setTitle:function(_47f,_480){
return new String();
},confirmSetTitle:function(_481,_482){
return new Boolean();
},setDescription:function(desc,_484){
return new String();
},confirmSetDescription:function(desc,_486){
return new Boolean();
}});
dojo.declare("com.ibm.mashups.enabler.MetaData",null,{constructor:function(){
},getMetaDataNames:function(){
return [];
},getMetaData:function(name){
return new String();
}});
dojo.declare("com.ibm.mashups.enabler.ModifiableMetaData",com.ibm.mashups.enabler.MetaData,{constructor:function(){
},setMetaData:function(name,_489){
return new String();
},confirmSetMetaData:function(name,_48b){
return new Boolean();
},removeMetaData:function(name){
return new String();
},confirmRemoveMetaData:function(name){
return new Boolean();
}});
dojo.declare("com.ibm.mashups.enabler.Locator",null,{constructor:function(){
},find:function(id){
return new Deferred();
}});
dojo.declare("com.ibm.mashups.enabler.model.Model",null,{constructor:function(){
},setStrategy:function(_48f){
},getStrategies:function(){
return [];
},addStrategy:function(_490){
},removeStrategy:function(_491){
}});
dojo.declare("com.ibm.mashups.enabler.ListModel",[com.ibm.mashups.enabler.model.Model,com.ibm.mashups.enabler.Locator],{constructor:function(){
},iterator:function(){
return new Iterator();
}});
dojo.declare("com.ibm.mashups.enabler.ListModelController",com.ibm.mashups.enabler.ListModel,{constructor:function(){
},create:function(_492){
return new Object();
},confirmCreate:function(_493){
return new Boolean();
},insert:function(node,_495){
},confirmInsert:function(node,_497){
return new Boolean();
},remove:function(node){
},confirmRemove:function(node){
return new Boolean();
}});
dojo.declare("com.ibm.mashups.enabler.TreeModel",[com.ibm.mashups.enabler.model.Model,com.ibm.mashups.enabler.Locator],{constructor:function(){
},getRoot:function(){
return new Deferred();
},hasChildren:function(node){
return new Boolean();
},getChildren:function(node){
return new com.ibm.mashups.enabler.DeferredIterator();
},getParent:function(node){
return new Deferred();
}});
dojo.declare("com.ibm.mashups.enabler.TreeModelController",com.ibm.mashups.enabler.TreeModel,{constructor:function(){
},create:function(_49d){
return new Object();
},confirmCreate:function(_49e){
return new Boolean();
},insert:function(node,_4a0,_4a1){
},confirmInsert:function(node,_4a3,_4a4){
return new Boolean();
},remove:function(node){
},confirmRemove:function(node){
return new Boolean();
}});
dojo.declare("com.ibm.mashups.enabler.strategy.Strategy",null,{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy",com.ibm.mashups.enabler.strategy.Strategy,{constructor:function(_4a7){
this.interval=_4a7;
},getInterval:function(){
return this.interval;
}});
dojo.declare("com.ibm.mashups.enabler.strategy.TreeLoadAheadStrategy",com.ibm.mashups.enabler.strategy.Strategy,{constructor:function(_4a8,_4a9){
this.parentLevel=_4a8;
this.childrenLevel=_4a9;
},getChildrenLevel:function(){
return this.childrenLevel;
},getParentLevel:function(){
return this.parentLevel;
}});
dojo.declare("com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy",com.ibm.mashups.enabler.strategy.Strategy,{constructor:function(_4aa,_4ab){
this.loadAheadLayoutModel=_4aa;
this.loadAheadTheme=_4ab;
},isLoadAheadLayoutModel:function(){
return this.loadAheadLayoutModel;
},isLoadAheadTheme:function(){
return this.loadAheadTheme;
}});
dojo.declare("com.ibm.mashups.enabler.strategy.UserLoadAheadStrategy",com.ibm.mashups.enabler.strategy.Strategy,{constructor:function(_4ac){
this.loadAheadUser=_4ac;
this.userModel=null;
},isLoadAheadUser:function(){
return this.loadAheadUser;
},setUserModel:function(_4ad){
this.userModel=_4ad;
},getUserModel:function(){
if(null==this.userModel){
this.userModel=com.ibm.mashups.enabler.model.Factory.getUserModel();
}
return this.userModel;
}});
dojo.declare("com.ibm.mashups.enabler.strategy.CatalogCategoryLoadAheadStrategy",com.ibm.mashups.enabler.strategy.Strategy,{constructor:function(_4ae){
this.loadAheadCatalogCategoryModel=_4ae;
this.catalogCategoryModel=null;
},isLoadAheadCatalogCategoryModel:function(){
return this.loadAheadCatalogCategoryModel;
},setCatalogCategoryModel:function(_4af){
this.catalogCategoryModel=_4af;
},getCatalogCategoryModel:function(){
if(null==this.catalogCategoryModel){
this.catalogCategoryModel=com.ibm.mashups.enabler.model.Factory.getCatalogCategoryModel();
}
return this.catalogCategoryModel;
}});
dojo.declare("com.ibm.mashups.enabler.RepresentationProvider",null,{constructor:function(){
},getAlternateModel:function(){
return ListModel();
}});
dojo.declare("com.ibm.mashups.enabler.Representation",com.ibm.mashups.enabler.Identifiable,{constructor:function(){
},getID:function(){
return String();
},getURL:function(){
return String();
},getMimeType:function(){
return String();
}});
dojo.declare("com.ibm.mashups.enabler.model.SelectionLocator",null,{constructor:function(){
},findDefaultAcceptParent:function(){
}});
dojo.declare("com.ibm.mashups.enabler.ResourceLocator",com.ibm.mashups.enabler.Locator,{constructor:function(){
},findResourceUrl:function(node,name){
}});
dojo.declare("com.ibm.mashups.enabler.SubmittableFormProvider",null,{constructor:function(){
},getSubmittableForm:function(id){
return SubmittableForm();
}});
dojo.declare("com.ibm.mashups.enabler.SubmittableForm",com.ibm.mashups.enabler.Identifiable,{constructor:function(){
},getURL:function(){
return String();
},getMethod:function(){
return String();
},submit:function(){
return Deferred();
}});
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.widget"]){
dojo._hasResource["com.ibm.mashups.iwidget.widget"]=true;
dojo.provide("com.ibm.mashups.iwidget.widget");
dojo.provide("com.ibm.mashups.iwidget.widget.EventProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.Properties");
dojo.provide("com.ibm.mashups.iwidget.widget.PropertiesProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.ModifiableProperties");
dojo.provide("com.ibm.mashups.iwidget.widget.ModifiablePropertiesProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.Wire");
dojo.provide("com.ibm.mashups.iwidget.widget.WireProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.ModifiableWireProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.IWidgetWrapper");
dojo.provide("com.ibm.mashups.iwidget.widget.IWidgetDefinition");
dojo.provide("com.ibm.mashups.iwidget.widget.IWidgetInstance");
dojo.declare("com.ibm.mashups.iwidget.widget.EventProvider",null,{constructor:function(){
},getWidgetPublishedEvents:function(){
},getWidgetHandledEvents:function(){
},getPublicEvent:function(name){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.Properties",null,{constructor:function(){
},getItemValue:function(_4b4){
},getAllNames:function(){
return null;
}});
dojo.declare("com.ibm.mashups.iwidget.widget.PropertiesProvider",null,{constructor:function(){
},getIDescriptorItems:function(){
},getAttributes:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.ModifiableProperties",[com.ibm.mashups.iwidget.widget.Properties],{constructor:function(){
},setItemValue:function(_4b5,_4b6){
},removeItem:function(_4b7){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.ModifiablePropertiesProvider",null,{constructor:function(){
},getIDescriptorItems:function(){
},getAttributes:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.Wire",null,{constructor:function(){
},getSourceWidgetID:function(){
},getSourceEventName:function(){
},getTargetWidgetID:function(){
},getTargetEventName:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.WireProvider",null,{constructor:function(id){
},getWires:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.ModifiableWireProvider",com.ibm.mashups.iwidget.widget.WireProvider,{constructor:function(id){
},addWire:function(_4ba,_4bb,_4bc){
},removeWire:function(_4bd,_4be,_4bf){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.IWidgetWrapper",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.iwidget.widget.WireProvider,com.ibm.mashups.iwidget.widget.EventProvider],{constructor:function(){
},getIWidgetDefinition:function(){
},getIWidgetInstance:function(){
},getMarkup:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.IWidgetDefinition",[com.ibm.mashups.iwidget.widget.EventProvider,com.ibm.mashups.iwidget.widget.PropertiesProvider],{constructor:function(){
},getSupportedModes:function(){
},toSpecObject:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.widget.IWidgetInstance",[com.ibm.mashups.iwidget.widget.ModifiablePropertiesProvider,com.ibm.mashups.iwidget.widget.ModifiableWireProvider],{constructor:function(){
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widget.properties"]){
dojo._hasResource["com.ibm.mm.iwidget.widget.properties"]=true;
dojo.provide("com.ibm.mm.iwidget.widget.properties");
dojo.declare("com.ibm.mm.iwidget.widget.PropertiesImpl",[com.ibm.mashups.iwidget.widget.Properties],{DELETE_TOKEN:"com.ibm.mm.iwidget.widget.DELETE_TOKEN",constructor:function(_4c0,_4c1,_4c2){
this._defaultProperties=_4c2;
if(_4c0){
this._items=_4c0;
}else{
this._items={};
}
if(_4c1){
this._localizedItems=_4c1;
}else{
this._localizedItems={};
}
},_getItemValue:function(_4c3){
if(_4c3 in this._items){
var _4c4=this._items[_4c3];
if(_4c4==this.DELETE_TOKEN){
return null;
}
return _4c4;
}
if(this._defaultProperties){
return this._defaultProperties.getItemValue(_4c3);
}
return null;
},getItemValue:function(_4c5,_4c6){
var ret=this._getItemValue3(_4c5,_4c6);
var ret2=com.ibm.mm.enabler.model.Utils.checkForEndpoints(ret);
if(ret2!=null){
ret=ret2;
}
return ret;
},_getItemValue2:function(_4c9,_4ca){
if(!_4ca){
_4ca="en";
}
var loc=_4ca;
var dash=_4ca.indexOf("-");
if(-1<dash){
loc=_4ca.slice(0,dash);
loc+="_"+_4ca.slice(dash+1).toUpperCase();
}
if(_4c9 in this._localizedItems){
if(loc in this._localizedItems[_4c9]){
var _4cd=this._localizedItems[_4c9][loc];
if(_4cd==this.DELETE_TOKEN){
return null;
}
return _4cd;
}
}
if(this._defaultProperties){
return this._defaultProperties.getItemValue(_4c9,loc);
}
return this._getItemValue(_4c9);
},_getItemValue3:function(_4ce,_4cf){
if(!_4cf){
_4cf="en";
}
if(_4ce in this._localizedItems){
var _4d0=[];
for(var i in this._localizedItems[_4ce]){
_4d0.push(i);
}
var _4d2=this._localizedItems[_4ce][com.ibm.mm.enabler.utilities.matchLocale(_4cf,_4d0)]||null;
if(_4d2==this.DELETE_TOKEN){
return null;
}
return _4d2;
}
if(this._defaultProperties){
return this._defaultProperties.getItemValue(_4ce,_4cf);
}
return this._getItemValue(_4ce);
},getItemLocales:function(_4d3){
if(_4d3 in this._localizedItems){
return this._localizedItems[_4d3];
}
return [];
},getAllNames:function(){
var _4d4=[];
if(this._defaultProperties){
_4d4=this._defaultProperties.getAllNames();
}
var _4d5={};
for(var i=0;i<_4d4.length;i++){
_4d5[_4d4[i]]=null;
}
for(itemName in this._items){
if(this._items[itemName]==this.DELETE_TOKEN){
if(itemName in _4d5){
delete _4d5[itemName];
}
}else{
_4d5[itemName]=null;
}
}
for(itemName in this._localizedItems){
if(this._localizedItems[itemName]==this.DELETE_TOKEN){
if(itemName in _4d5){
delete _4d5[itemName];
}
}else{
_4d5[itemName]=null;
}
}
var _4d7=[];
for(itemName in _4d5){
_4d7.push(itemName);
}
return _4d7;
}});
dojo.declare("com.ibm.mm.iwidget.widget.ModifiablePropertiesImpl",[com.ibm.mm.iwidget.widget.PropertiesImpl],{constructor:function(_4d8,_4d9,_4da){
this._dirty=false;
},_setItemValue:function(_4db,_4dc){
this._items[_4db]=_4dc;
this._dirty=true;
return this;
},setItemValue:function(_4dd,_4de,_4df,_4e0){
if(_4e0){
if(!this._localizedItems[_4dd]){
this._localizedItems[_4dd]={};
}
var loc=_4e0.replace(/-/g,"_");
this._localizedItems[_4dd][loc]=_4de;
this._dirty=true;
return this;
}else{
return this._setItemValue(_4dd,_4de);
}
},_removeItem:function(_4e2){
var _4e3=false;
if(_4e2 in this._items){
delete this._items[_4e2];
_4e3=true;
}
if(this._defaultProperties&&this._defaultProperties.getItemValue(_4e2)!==null){
this._items[_4e2]=this.DELETE_TOKEN;
_4e3=true;
}
if(_4e3){
this._dirty=true;
return this;
}else{
return null;
}
},removeItem:function(_4e4,_4e5){
var _4e6=false;
if(_4e4 in this._localizedItems){
if(_4e5 in this._localizedItems[_4e4]){
delete this._localizedItems[_4e4][_4e5];
_4e6=true;
}
}
if(this._defaultProperties&&this._defaultProperties.getLocalizedItemValue(_4e4,_4e5)!==null){
this._localizedItems[_4e4][_4e5]=this.DELETE_TOKEN;
_4e6=true;
}
this._removeItem(_4e4);
if(_4e6){
this._dirty=true;
return this;
}else{
return null;
}
},_isDirty:function(){
return this._dirty;
},_setDirty:function(_4e7){
this._dirty=_4e7;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetdefinition"]){
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetdefinition"]=true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetdefinition");
dojo.require("com.ibm.mm.enabler.xml");
dojo.declare("com.ibm.mm.iwidget.widget.IWidgetDefinitionImpl",com.ibm.mashups.iwidget.widget.IWidgetDefinition,{namespaces:{"iw":"http://www.ibm.com/xmlns/prod/iWidget"},constructor:function(_4e8,_4e9){
this.widgetDef=_4e8;
if(_4e9){
this.xmlStr=_4e9;
}
},getAllowInstanceContent:function(){
return this.widgetDef.allowInstanceContent;
},getResources:function(){
return this.widgetDef.resources;
},getIScope:function(){
return this.widgetDef.iScope;
},getWidgetEvents:function(){
return this.widgetDef.widgetEvents;
},getMarkupByMode:function(mode){
if(typeof this.widgetDef.markup!="undefined"&&this.widgetDef.markup!=null){
if(!mode){
mode="view";
}
var temp=this.widgetDef.markup[mode];
return temp;
}else{
return null;
}
},getAttributes:function(){
if(!this.attributeProperties){
var _4ec={};
var _4ed=this.widgetDef.itemSetsArr[iwConstants.ATTRIBUTES];
if(_4ed){
for(itemName in _4ed.items){
_4ec[itemName]=_4ed.items[itemName].value;
}
}
var _4ee=this.widgetDef.simpleAttributes;
if(typeof _4ee!="undefined"&&_4ee!=null){
for(var i in _4ee){
var _4f0=_4ee[i];
if(typeof _4f0!="undefined"&&_4f0!=null){
_4ec[i]=_4f0;
}
}
}
this.attributeProperties=new com.ibm.mm.iwidget.widget.PropertiesImpl(_4ec);
}
return this.attributeProperties;
},getIDescriptorItems:function(){
if(!this.idescriptorProperties){
this.idescriptorProperties=new com.ibm.mm.iwidget.widget.PropertiesImpl(this.widgetDef.iDescriptor);
}
return this.idescriptorProperties;
},getAllItemSetNames:function(){
var _4f1=new Array();
if(typeof (this.widgetDef.itemSetsArr)=="undefined"||this.widgetDef.itemSetsArr==null){
return _4f1;
}
var i=0;
for(itemName in this.widgetDef.itemSetsArr){
var _4f3=this.widgetDef.itemSetsArr[itemName];
if(typeof (_4f3)!="undefined"&&itemName!=iwConstants.ATTRIBUTES){
_4f1[i]=_4f3.name;
i++;
}
}
return _4f1;
},getItemSet:function(name){
if(name=="attributes"){
return this.getAttributes();
}
var _4f5=this.widgetDef.itemSetsArr[name];
if(typeof _4f5=="undefined"||_4f5==null){
return null;
}
return _4f5;
},getPublishedEventsNames:function(){
if(!this.widgetDef.publicEvents){
return [];
}
var _4f6=[];
var _4f7;
for(_4f7 in this.widgetDef.publicEvents){
var temp=this.widgetDef.publicEvents[_4f7];
if(!temp.isPublished||(temp.isPublished&&temp["isPublished"]=="true")){
_4f6.push(_4f7);
}
}
return _4f6;
},getHandledEventsNames:function(){
if(!this.widgetDef.publicEvents){
return [];
}
var _4f9=[];
var _4fa;
for(_4fa in this.widgetDef.publicEvents){
var temp=this.widgetDef.publicEvents[_4fa];
if(temp.onEvent&&temp.onEvent!=null){
_4f9.push(_4fa);
}
}
return _4f9;
},getPublishedEvent:function(_4fc){
if(!this.widgetDef.publicEvents){
return null;
}
var _4fd=this.getPublicEvent(_4fc);
if(_4fd!=null){
if(!_4fd.isPublished||(_4fd.isPublished&&_4fd.isPublished=="false")){
_4fd=null;
}
}
return _4fd;
},getHandledEvent:function(_4fe){
if(!this.widgetDef.publicEvents){
return null;
}
var _4ff=this.getPublicEvent(_4fe);
if(_4ff!=null){
if(!_4ff.onEvent){
_4ff=null;
}
}
return _4ff;
},getPublicEvent:function(_500){
if(!this.widgetDef.publicEvents){
return null;
}
if(this.eventsCache&&this.eventsCache!=null&&this.eventsCache[_500]!=null){
return new com.ibm.mm.iwidget.iEventDescriptionImpl(this.eventsCache[_500]);
}
var data=this.widgetDef.publicEvents[_500];
var _502=null;
var obj={};
if(typeof data!="undefined"&&data!=null){
obj.name=data.id;
if(data.onEvent&&data.onEvent!=null){
obj.handlingFn=data.onEvent;
obj.isHandled=true;
}else{
obj.isHandled=false;
}
if((data.isPublished&&data.isPublished=="true")||(data.isPublished&&data.isPublished==true)){
obj.isPublished=true;
}
obj.attributes={};
obj.localizedAttributes={};
var _504=null;
for(var i in data){
if(i!="id"&&i!="onEvent"&&i!="description"){
obj.attributes[i]=data[i];
}
if(i=="description"){
_504=data[i];
}
}
var _506=null;
if(typeof _504!="undefined"&&_504!=null){
_506=this._getEventDescription(_504);
if(_506!=null){
var _507=_506.lang;
if(typeof _507=="undefined"||_507==null){
_507=this.getDefaultLanguage();
if(typeof _507=="undefined"||_507==null){
_507="en";
}
}
obj.lang=_507;
if(_506.payloadType&&_506.payloadType!=null){
obj.type=_506.payloadType;
}
if(_506.aliases&&_506.aliases!=null){
obj.attributes.aliases=_506.aliases;
}
var _508=_506.descriptions;
if(typeof _508!="undefined"&&_508!=null){
obj.localizedAttributes=_506.descriptions;
}
if(typeof (obj.localizedAttributes[_507])=="undefined"){
obj.localizedAttributes[_507]={};
}
if(_506.title&&_506.title!=null){
obj.localizedAttributes[_507].title=_506.title;
}
if(_506.description&&_506.description!=null){
obj.localizedAttributes[_507].description=_506.description;
}
if(_506.descriptionURI&&_506.descriptionURI!=null){
obj.localizedAttributes[_507].descriptionURI=_506.descriptionURI;
}
}
}
if(!this.eventsCache){
this.eventsCache={};
}
this.eventsCache[_500]=obj;
_502=new com.ibm.mm.iwidget.iEventDescriptionImpl(obj);
}
return _502;
},getWidgetId:function(){
return this.widgetDef.id;
},getWidgetName:function(){
return this.widgetDef.id;
},getPayloadDefs:function(){
return this.widgetDef.payloadDefs;
},getPayloadDef:function(name){
var _50a=this.widgetDef.payloadDefs[name];
if(typeof _50a=="undefined"){
return null;
}
return _50a;
},getPayloadDefNames:function(){
var arr=[];
var a;
for(a in this.widgetDef.payloadDefs){
arr.push(a);
}
return arr;
},getSupportedModes:function(){
var temp=this.widgetDef.supportedModes;
if(typeof temp=="undefined"||temp==null){
return null;
}
var arr=temp.split(" ");
return arr;
},_getEventDescription:function(id){
var _510=null;
if(typeof this.widgetDef.eventDescriptions!="undefined"||this.widgetDef.eventDescriptions!=null){
_510=this.widgetDef.eventDescriptions[id];
}
return _510;
},_getPublicEvents:function(){
var _511={};
for(aEventName in this.widgetDef.publicEvents){
var _512=this.getPublicEvent(aEventName);
if(_512!=null){
_511[aEventName]=_512;
}
}
return _511;
},getDefaultLanguage:function(){
return this.widgetDef.lang;
},getMarkup:function(){
return this.widgetDef.markup;
},getWidgetPublishedEvents:function(){
return this.getPublishedEvents();
},getWidgetHandledEvents:function(){
return this.getHandledEvents();
},getPublishedEvents:function(){
var _513=[];
var _514=this.getPublishedEventsNames();
for(var i=0;i<_514.length;i++){
var _516=_514[i];
var _517=this.getPublicEvent(_516);
if(_517!=null){
_513[i]=_517;
}
}
return _513;
},getHandledEvents:function(){
var _518=[];
var _519=this.getHandledEventsNames();
for(var i=0;i<_519.length;i++){
var _51b=_519[i];
var _51c=this.getPublicEvent(_51b);
if(_51c!=null){
_518[i]=_51c;
}
}
return _518;
},toSpecObject:function(){
var _51d={};
if(typeof this.xmlStr=="undefined"||this.xmlStr==null){
return {};
}
var _51e=com.ibm.mm.enabler.xslt.loadXmlString(this.xmlStr);
var expr="/iw:iwidget";
var _520=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_51e,this.namespaces);
if(_520&&_520.length>0){
var _521=_520[0];
this._addAttributesToJson(_521,_51d);
this._addElements(_521,"eventDescription","id","alt","lang",_51d);
this._addElements(_521,"event","id",null,null,_51d);
this._addElements(_521,"itemSetDescription","id","alt","lang",_51d);
this._addElements(_521,"itemDescription","id","alt","lang",_51d);
this._addElements(_521,"itemSet","id","item","id",_51d);
this._addElements(_521,"resource","id",null,null,_51d);
this._addElements(_521,"content","mode",null,null,_51d,true);
}
return _51d;
},_addAttributesToJson:function(node,_523){
var atts=node.attributes;
for(var i=0;i<atts.length;i++){
if(atts[i].nodeName.indexOf(":")==-1){
_523["_"+atts[i].nodeName]=atts[i].nodeValue;
}
}
},_addElements:function(node,_527,_528,_529,_52a,_52b,_52c){
var _52d=_52b[_527+"s"]={};
var expr="iw:"+_527;
var _52f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,node,this.namespaces);
if(_52f){
for(var i=0;i<_52f.length;i++){
var _531=_52f[i].getAttribute(_528);
if(_531){
var _532=_52d[_531]={};
this._addAttributesToJson(_52f[i],_532);
if(_529){
this._addElements(_52f[i],_529,_52a,null,null,_532);
}
if(_52c){
if(_52f[i].childNodes&&_52f[i].childNodes.length>0){
_532["value"]=_52f[i].childNodes[0].nodeValue+"";
}else{
_532["value"]="";
}
}
}
}
}
}});
dojo.declare("com.ibm.mm.iwidget.widget.IWidgetDefinitionLegacyImpl",com.ibm.mashups.iwidget.widget.IWidgetDefinition,{constructor:function(name,_534,_535,_536,_537,uri,_539,_53a,_53b,_53c,_53d,_53e){
var arg1=name;
if(dojo.isString(arg1)){
this.name=name;
this.markup=_534;
this.iScope=_535;
this.itemSetsArr=_536;
this.uri=uri;
this.widgetEvents=_537;
this.publishedEvents=_53a;
this.handledEvents=_53b;
this.supportedModes=_539;
this.resources=_53c;
this.payloadDefs=_53d;
this.iDescriptor=_53e;
}else{
this.name=arg1["name"];
this.markup=arg1["markup"];
this.metaData=arg1["metaData"];
this.events=arg1["events"];
this.itemSets=arg1["itemSets"];
this.resources=arg1["resources"];
this.payloadDefs=arg1["payloadDefs"];
this.iScope=this.metaData["iScope"];
this.supportedModes=this.metaData["supportedModes"];
this.uri=this.metaData["contentURI"];
var _540;
this.widgetEvents={};
for(_540 in this.metaData){
if(_540.indexOf("on")==0){
this.widgetEvents[_540]=this.metaData[_540];
}
}
var _541=arg1["events"]["publishedEvents"];
this.publishedEvents={};
this.handledEvents={};
var _542;
for(_542 in _541){
var _540=_541[_542];
var _543=new com.ibm.mm.iwidget.iEventDescriptionImpl(_540.eventName,_540.payloadType,_540.description,_540.onEvent);
if(!this.publishedEvents[_542]){
this.publishedEvents[_542]=[];
}
this.publishedEvents[_542].push(_543);
}
var _544=arg1["events"]["handledEvents"];
for(_542 in _544){
var _540=_544[_542];
var _543=new com.ibm.mm.iwidget.iEventDescriptionImpl(_540.eventName,_540.payloadType,_540.description,_540.onEvent);
if(!this.handledEvents[_542]){
this.handledEvents[_542]=[];
}
this.handledEvents[_542].push(_543);
}
var _545;
this.itemSetsArr={};
for(_545 in arg1["itemSets"]){
var _546=arg1["itemSets"][_545];
if(_545=="attributes"){
var _547=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(_546.name,_546.onItemSetChanged);
}else{
var _547=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(_546.name,_546.onItemSetChanged);
}
_547["itemLists"]["items"]=_546["itemLists"];
this.itemSetsArr[_545]=_547;
}
}
},_getPublishedEvents:function(){
return this.publishedEvents;
},_getHandledEvents:function(){
return this.handledEvents;
},getPublishedEvents:function(){
var arr=[];
for(var i in this.publishedEvents){
arr.push(this.publishedEvents[i]);
}
return arr;
},getHandledEvents:function(){
var arr=[];
for(var i in this.handledEvents){
arr.push(this.handledEvents[i]);
}
return arr;
},getAttributes:function(){
var _54c=this.itemSetsArr["attributes"];
if(typeof _54c=="undefined"||_54c==null){
_54c={name:"attributes",items:{}};
}
if(typeof (this.uri)!="undefined"&&_54c!=null){
_54c.items["contentURI"]={id:"contentURI",value:this.uri,readOnly:false};
}
if(typeof (this.supportedModes)!="undefined"&&_54c!=null){
_54c.items["supportedModes"]={id:"supportedModes",value:this.uri,readOnly:false};
}
return _54c;
},getAllItemSetNames:function(){
var _54d=new Array();
if(typeof (this.itemSetsArr)=="undefined"||this.itemSetsArr==null){
return _54d;
}
var i=0;
for(itemName in this.itemSetsArr){
var _54f=this.itemSetsArr[itemName];
if(typeof (_54f)!="undefined"){
_54d[i]=_54f.name;
}
i++;
}
return _54d;
},getItemSet:function(name){
if(name=="attributes"){
return this.getAttributes();
}
var _551=this.itemSetsArr[name];
if(typeof (_551)!="undefined"){
return _551;
}
return null;
},getPublishedEventsNames:function(){
if(!this.publishedEvents){
return null;
}
var _552=[];
var _553;
for(_553 in this.publishedEvents){
_552.push(_553);
}
return _552;
},getHandledEventsNames:function(){
if(!this.handledEvents){
return null;
}
var _554=[];
var _555;
for(_555 in this.handledEvents){
_554.push(_555);
}
return _554;
},getPublishedEvent:function(_556){
if(!this.publishedEvents){
return null;
}
return this.publishedEvents[_556];
},getHandledEvent:function(_557){
if(!this.handledEvents){
return null;
}
return this.handledEvents[_557];
},getWidgetName:function(){
return this.name;
},getPayloadDefs:function(){
return this.payloadDefs;
},getPayloadDef:function(name){
var _559=this.payloadDefs[name];
if(typeof _559=="undefined"){
return null;
}
return _559;
},getPayloadDefNames:function(){
var arr=[];
var a;
for(a in this.payloadDefs){
arr.push(a);
}
return arr;
},getSupportedModes:function(){
var temp=this.supportedModes;
if(typeof temp=="undefined"||temp==null){
return null;
}
var arr=temp.split(" ");
return arr;
},getIDescriptorItems:function(){
return null;
},getMarkupByMode:function(mode){
return this.markup;
},getWidgetEvents:function(){
return this.widgetEvents;
},getIScope:function(){
return this.iScope;
},getResources:function(){
return this.resources;
},getDefaultLanguage:function(){
return "en";
},getMarkup:function(){
return this.markup;
},getAllowInstanceContent:function(){
return false;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.parserImpl"]){
dojo._hasResource["com.ibm.mm.iwidget.parserImpl"]=true;
dojo.provide("com.ibm.mm.iwidget.parserImpl");
dojo.declare("com.ibm.mm.iwidget.parser.WidgetParser",null,{parseWidgetDefinition:function(){
return null;
}});
dojo.declare("com.ibm.mm.iwidget.parser.legacyXMLParser",com.ibm.mm.iwidget.parser.WidgetParser,{constructor:function(_55f){
this.xmlStr=_55f;
},namespaces:{"iw":"http://www.ibm.com/iWidget"},parseWidgetDefinition:function(){
var _560=com.ibm.mm.enabler.xslt.loadXmlString(this.xmlStr);
var _561=this.readMarkup(_560);
var _562=this.readItemSets(_560);
var uri=this.readContentURI(_560);
var _564=this.readWidgetEvents(_560);
var name=this.readName(_560);
var _566=this.readiScope(_560);
var _567=this.readSupportedModes(_560);
var _568=this.readPublicEvents(_560,"iw:handledEvents");
var _569=this.readPublicEvents(_560,"iw:publishedEvents");
var _56a=this.readResources(_560);
var _56b=this.readPayloadDefs(_560);
var _56c=this.readIDescriptor(_560);
return new com.ibm.mm.iwidget.widget.IWidgetDefinitionLegacyImpl(name,_561,_566,_562,_564,uri,_567,_569,_568,_56a,_56b,_56c);
},readMarkup:function(_56d){
com.ibm.mm.enabler.debug.entry("legacyXMLParser.readMarkup",_56d.text);
var _56e="/iw:iwidget/iw:content";
var _56f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_56e,_56d,this.namespaces);
var _570="";
if(_56f!=null&&_56f.length>0){
var _571=_56f[0];
var _572=_571.childNodes;
for(var j=0;j<_572.length;j++){
var _574=_572[j];
if(_574.nodeType==4){
_570=_570.concat(_574.nodeValue);
}else{
if(_574.nodeType==3){
_570=_570.concat(_574.nodeValue);
}
}
}
}
com.ibm.mm.enabler.debug.exit("legacyXMLParser.readMarkup",_570);
return _570;
},readSupportedModes:function(_575){
var root=_575.documentElement;
var _577=root.getAttribute("supportedModes");
if(typeof _577=="undefined"||_577==null){
return null;
}
return _577;
},readItemSets:function(_578){
com.ibm.mm.enabler.debug.entry("legacyXMLParser.readItemSets");
var _579={};
var _57a="/iw:iwidget/iw:itemSet";
var _57b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_57a,_578,this.namespaces);
for(var i=0;i<_57b.length;i++){
var _57d=_57b[i];
var name=_57d.getAttribute("name");
var _57f=_57d.getAttribute("onItemSetChanged");
var _580={name:name,onItemSetChanged:_57f};
_580.items={};
var _581=_57d.childNodes;
for(var j=0;j<_581.length;j++){
var _583=_581[j];
if(_583.nodeType==1){
var _584=_583.getAttribute("readOnly");
com.ibm.mm.enabler.debug.entry("legacyXMLParser.readItemSets found attribute name:"+_583.getAttribute("name")+" value:"+_583.getAttribute("value"));
var _585={id:_583.getAttribute("name"),value:_583.getAttribute("value"),readOnly:_584};
_580.items[_585.id]=_585;
}
}
_579[name]=_580;
}
com.ibm.mm.enabler.debug.exit("legacyXMLParser.readItemSets");
return _579;
},readPayloadDefs:function(_586){
com.ibm.mm.enabler.debug.entry("legacyXMLParser.readPayloadDefs");
var _587={};
var _588="/iw:iwidget/iw:payloadDef";
var _589=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_588,_586,this.namespaces);
for(var i=0;i<_589.length;i++){
var _58b=_589[i];
var _58c=com.ibm.mm.iwidget.utils.getPayloadDef(_58b);
_587[_58c.name]=_58c;
}
com.ibm.mm.enabler.debug.exit("legacyXMLParser.readPayloadDef ",_589.length+" payloadDefs are saved ");
return _587;
},readName:function(_58d){
var root=_58d.documentElement;
var name=root.getAttribute("name");
if(typeof name=="undefined"||name==null){
return null;
}
return name;
},readContentURI:function(_590){
var root=_590.documentElement;
var uri=root.getAttribute("contentURI");
if(typeof uri=="undefined"||uri==null){
return null;
}
return uri;
},readiScope:function(_593){
var root=_593.documentElement;
var _595=root.getAttribute("iScope");
if(typeof _595=="undefined"||_595==null){
return null;
}
return _595;
},readWidgetEvents:function(_596){
var root=_596.documentElement;
var _598={};
var _599=root.attributes;
for(var i=0;i<_599.length;i++){
var _59b=_599[i];
if(_59b.name.indexOf("on")==0){
var _59c=_59b.value;
if(typeof _59c!="undefined"&&_59c!=null){
_598[_59b.name]=_59c;
}
}
}
return _598;
},readPublicEvents:function(_59d,_59e){
var _59f="/iw:iwidget/"+_59e;
var _5a0=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_59f,_59d,this.namespaces);
if(typeof _5a0!="undefined"&&_5a0!=null&&_5a0.length!=0){
var _5a1={};
var node=_5a0[0];
var _5a3=node.childNodes;
for(var j=0;j<_5a3.length;j++){
var _5a5=_5a3[j];
if(_5a5.nodeType==1){
var _5a6=new com.ibm.mm.iwidget.iEventDescriptionImpl(_5a5.getAttribute("eventName"),_5a5.getAttribute("onEvent"),_5a5.getAttribute("payloadType"),_5a5.getAttribute("description"));
_5a1[_5a5.getAttribute("eventName")]=_5a6;
}
}
}
if(!_5a1){
return null;
}
return _5a1;
},readResources:function(_5a7){
var _5a8="/iw:iwidget/iw:resource";
var _5a9=[];
var _5aa=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_5a8,_5a7,this.namespaces);
if(typeof _5aa!="undefined"&&_5aa!=null&&_5aa.length!=0){
for(var i=0;i<_5aa.length;i++){
var node=_5aa[i];
var _5ad={};
_5ad["name"]=node.getAttribute("resourceName");
_5ad["src"]=node.getAttribute("uri");
_5ad["version"]=node.getAttribute("version");
_5ad["callback"]=node.getAttribute("callback");
_5ad["mimetype"]=node.getAttribute("mimetype");
_5a9[i]=_5ad;
}
}
return _5a9;
},readIDescriptor:function(_5ae){
return null;
}});
dojo.declare("com.ibm.mm.iwidget.parser.standardXMLParser",com.ibm.mm.iwidget.parser.WidgetParser,{constructor:function(_5af){
this.xmlStr=_5af;
},namespaces:{"iw":"http://www.ibm.com/xmlns/prod/iWidget"},reservedAttributes:{iScope:"iScope",supportedModes:"supportedModes",id:"id",allowInstanceContent:"allowInstanceContent",lang:"language","xmlns:iw":"xmlns:iw"},parseWidgetDefinition:function(){
var _5b0=com.ibm.mm.enabler.xslt.loadXmlString(this.xmlStr);
var _5b1=this.readRootElement(_5b0);
_5b1.markup=this.readMarkup(_5b0);
_5b1.itemSetsArr=this.readItemSets(_5b0);
_5b1.publicEvents=this.readPublicEvents(_5b0);
_5b1.resources=this.readResources(_5b0);
_5b1.payloadDefs=this.readPayloadDefs(_5b0);
_5b1.eventDescriptions=this.readEventDescriptions(_5b0);
return new com.ibm.mm.iwidget.widget.IWidgetDefinitionImpl(_5b1,this.xmlStr);
},readRootElement:function(_5b2){
var _5b3={};
var root=_5b2.documentElement;
var _5b5=root.getAttribute("supportedModes");
if(typeof _5b5=="undefined"||_5b5==null){
_5b5="view";
}
_5b3.supportedModes=_5b5;
var name=root.getAttribute("id");
if(typeof name=="undefined"||name==null){
name=null;
}
_5b3.id=name;
_5b3.name=name;
var temp=root.getAttribute("allowInstanceContent");
var _5b8=false;
if(typeof temp!="undefined"&&temp!=null&&temp=="true"){
_5b8=true;
}
_5b3.allowInstanceContent=_5b8;
var lang=root.getAttribute("language");
if(typeof lang=="undefined"||lang==null){
lang="en";
}
_5b3.lang=lang;
var _5ba={};
var _5bb=root.attributes;
for(var i=0;i<_5bb.length;i++){
var _5bd=_5bb[i];
if(_5bd.name.indexOf("on")==0){
var _5be=_5bd.value;
if(typeof _5be!="undefined"&&_5be!=null){
_5ba[_5bd.name]=_5be;
}
}
}
_5b3.widgetEvents=_5ba;
var _5bf=root.getAttribute("iScope");
if(typeof _5bf=="undefined"||_5bf==null){
_5bf=null;
}
_5b3.iScope=_5bf;
var _5c0=iwConstants.iDescriptorItems;
var _5c1={};
for(var i in _5c0){
var name=_5c0[i];
var _5c2=root.getAttribute(name);
_5c1[name]=_5c2;
}
_5b3.iDescriptor=_5c1;
var _5c3={};
var _5bb=root.attributes;
for(var i=0;i<_5bb.length;i++){
var att=_5bb[i];
if(att.name.indexOf("on")!=0&&!iwConstants.iDescriptorItems[att.name]&&!this.reservedAttributes[att.name]){
var _5c2=att.value;
if(typeof _5c2!="undefined"&&_5c2!=null){
_5c3[att.name]=_5c2;
}
}
}
_5b3.simpleAttributes=_5c3;
return _5b3;
},readMarkup:function(_5c5){
com.ibm.mm.enabler.debug.entry("standardXMLParser.readMarkup",_5c5.text);
var _5c6="/iw:iwidget/iw:content";
var _5c7=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_5c6,_5c5,this.namespaces);
var _5c8={};
var _5c9="";
var mode=null;
if(_5c7!=null&&_5c7.length>0){
for(var i=0;i<_5c7.length;i++){
var _5cc=_5c7[i];
var _5cd=_5cc.childNodes;
for(var j=0;j<_5cd.length;j++){
var _5cf=_5cd[j];
if(_5cf.nodeType==4){
_5c9=_5c9.concat(_5cf.nodeValue);
}else{
if(_5cf.nodeType==3){
_5c9=_5c9.concat(_5cf.nodeValue);
}
}
}
mode=_5cc.getAttribute("mode");
if(typeof mode=="undefined"||mode==null){
mode="view";
break;
}
_5c8[mode]=_5c9;
_5c9="";
}
}
com.ibm.mm.enabler.debug.exit("standardXMLParser.readMarkup",_5c8);
return _5c8;
},readItemSets:function(_5d0){
com.ibm.mm.enabler.debug.entry("standardXMLParser.readItemSets");
var _5d1={};
var _5d2="/iw:iwidget/iw:itemSet";
var _5d3=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_5d2,_5d0,this.namespaces);
for(var i=0;i<_5d3.length;i++){
var _5d5=_5d3[i];
var name=_5d5.getAttribute("id");
var _5d7=_5d5.getAttribute("onItemSetChanged");
var temp=_5d5.getAttribute("private");
var _5d9=false;
if(typeof temp!="undefined"&&temp!=null&&temp=="true"){
_5d9=true;
}
var _5da=_5d5.getAttribute("description");
var _5db={name:name,onItemSetChanged:_5d7,isPrivate:_5d9};
_5db.items={};
var _5dc=_5d5.childNodes;
for(var j=0;j<_5dc.length;j++){
var _5de=_5dc[j];
if(_5de.nodeType==1){
var _5df=_5de.getAttribute("readOnly");
com.ibm.mm.enabler.debug.entry("standardXMLParser.readItemSets found attribute name:"+_5de.getAttribute("name")+" value:"+_5de.getAttribute("value"));
if(typeof _5df!="undefined"&&_5df!=null&&_5df=="true"){
_5df=true;
}else{
_5df=false;
}
var id=_5de.getAttribute("id");
var _5e1=_5de.getAttribute("value");
var _5e2={id:id,value:_5e1,readOnly:_5df};
_5db.items[id]=_5e2;
}
}
_5d1[name]=_5db;
}
com.ibm.mm.enabler.debug.exit("standardXMLParser.readItemSets");
return _5d1;
},readPayloadDefs:function(_5e3){
com.ibm.mm.enabler.debug.entry("standardXMLParser.readPayloadDefs");
var _5e4={};
var _5e5="/iw:iwidget/iw:payloadDef";
var _5e6=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_5e5,_5e3,this.namespaces);
for(var i=0;i<_5e6.length;i++){
var _5e8=_5e6[i];
var _5e9=com.ibm.mm.iwidget.utils.getPayloadDef(_5e8);
_5e4[_5e9.name]=_5e9;
}
com.ibm.mm.enabler.debug.exit("standardXMLParser.readPayloadDef ",_5e6.length+" payloadDefs are saved ");
return _5e4;
},readPublicEvents:function(_5ea,_5eb){
var _5ec="/iw:iwidget/iw:event";
var _5ed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_5ec,_5ea,this.namespaces);
if(typeof _5ed!="undefined"&&_5ed!=null&&_5ed.length!=0){
var _5ee={};
for(var j=0;j<_5ed.length;j++){
var _5f0=_5ed[j];
if(_5f0.nodeType==1){
var _5f1={};
var _5f2=_5f0.attributes;
for(var i=0;i<_5f2.length;i++){
var att=_5f2[i];
var name=att.name;
var _5f6=att.value;
if(name=="eventDescName"){
name="description";
}
if(name=="handled"){
name="isHandled";
}
if(name=="published"){
name="isPublished";
}
if(typeof (_5f6)!="undefined"&&_5f6!=null){
_5f1[name]=_5f6;
}
}
_5ee[_5f1.id]=_5f1;
}
}
}
if(!_5ee){
return {};
}
return _5ee;
},readResources:function(_5f7){
var _5f8="/iw:iwidget/iw:resource";
var _5f9=[];
var _5fa=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_5f8,_5f7,this.namespaces);
if(typeof _5fa!="undefined"&&_5fa!=null&&_5fa.length!=0){
for(var i=0;i<_5fa.length;i++){
var node=_5fa[i];
var _5fd={};
_5fd[iwConstants.RESOURCE.id]=node.getAttribute("id");
var src=node.getAttribute("src");
if(typeof src=="undefined"||src==null){
src=node.getAttribute("uri");
}
_5fd[iwConstants.RESOURCE.src]=src;
_5fd[iwConstants.RESOURCE.version]=node.getAttribute("version");
_5fd[iwConstants.RESOURCE.callback]=node.getAttribute("callback");
_5fd[iwConstants.RESOURCE.mimetype]=node.getAttribute("mimeType");
_5f9[i]=_5fd;
}
}
return _5f9;
},readEventDescriptions:function(_5ff){
var _600="iw:iwidget/iw:eventDescription";
var _601={};
var _602=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_600,_5ff,this.namespaces);
if(typeof _602!="undefined"&&_602!=null&&_602.length!=0){
for(var i=0;i<_602.length;i++){
var node=_602[i];
var _605={};
var id=node.getAttribute("id");
_605["id"]=id;
_605["payloadType"]=node.getAttribute("payloadType");
_605["description"]=node.getAttribute("description");
_605["descriptionURI"]=node.getAttribute("descriptionURI");
_605["lang"]=node.getAttribute("lang");
_605["aliases"]=node.getAttribute("aliases");
_605["descriptions"]={};
var _607=node.childNodes;
for(var j=0;j<_607.length;j++){
var _609=_607[j];
if(_609.nodeType==1){
var temp={};
temp["description"]=_609.getAttribute("description");
temp["title"]=_609.getAttribute("title");
temp["descriptionURI"]=_609.getAttribute("descriptionURI");
_605["descriptions"][_609.getAttribute("lang")]=temp;
}
}
_601[id]=_605;
}
}
return _601;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.parser"]){
dojo._hasResource["com.ibm.mm.iwidget.parser"]=true;
dojo.provide("com.ibm.mm.iwidget.parser");
dojo.declare("com.ibm.mm.iwidget.parser.WidgetParserFactory",null,{getWidgetParser:function(_60b){
var _60c=_60b.replace(/^\s+/,"").replace(/\s+$/,"");
var _60d=this._isXML(_60c);
var _60e=this._isLegacy(_60c);
if(_60d&&_60e){
return new com.ibm.mm.iwidget.parser.legacyXMLParser(_60c);
}else{
if(_60d&&!_60e){
return new com.ibm.mm.iwidget.parser.standardXMLParser(_60c);
}
}
return null;
},_isXML:function(_60f){
var _610=true;
var _611=_60f.indexOf("=\"http://www.w3.org/1999/xhtml\"");
if(_611!=-1){
_610=false;
}
com.ibm.mm.enabler.debug.log("parser._isXML",_610);
return _610;
},_isLegacy:function(_612){
var _613=true;
var _614=_612.indexOf("=\"http://www.ibm.com/xmlns/prod/iWidget\"");
if(_614!=-1){
_613=false;
}
com.ibm.mm.enabler.debug.log("parser._isLegacy",_613);
return _613;
}});
com.ibm.mm.iwidget.parser.WidgetParserFactory=new com.ibm.mm.iwidget.parser.WidgetParserFactory();
}
if(!dojo._hasResource["com.ibm.mm.iwidget.services.widgetloadservice"]){
dojo._hasResource["com.ibm.mm.iwidget.services.widgetloadservice"]=true;
dojo.provide("com.ibm.mm.iwidget.services.widgetloadservice");
dojo.declare("com.ibm.mm.iwidget.services.WidgetLoadServiceImpl",null,{constructor:function(){
this.widgetDef={};
this.LOADING_TOKEN="LOADING_TOKEN";
this.LOADING_ERROR_TOKEN="LOADING_ERROR_TOKEN";
this.waitingqueue={};
},getWidgetXML:function(_615,sync,_617,_618){
var _619=this.widgetDef[_615];
if(typeof _619!="undefined"&&_619!=null&&_619==this.LOADING_TOKEN){
if(typeof (this.waitingqueue[_615])=="undefined"||this.waitingqueue[_615]==null){
this.waitingqueue[_615]=[];
}
var _61a={id:_618,cb:_617};
this.waitingqueue[_615].push(_61a);
return;
}else{
if(typeof _619!="undefined"&&_619!=null&&_619.error&&_619.error==this.LOADING_ERROR_TOKEN){
return this.handleCallback(_617,_619.data,_619.status);
}else{
if(typeof _619!="undefined"&&_619!=null){
return this.handleCallback(_617,_619,"200");
}
}
}
this.widgetDef[_615]=this.LOADING_TOKEN;
var me=this;
var _61c=_615;
if(_61c.indexOf("http")===0){
_61c=com.ibm.mm.enabler.utilities.rewriteURL(_61c);
}
var args={url:_61c,load:function(data,_61f){
var xhr=_61f.xhr;
var _621=com.ibm.mm.iwidget.parser.WidgetParserFactory.getWidgetParser(xhr.responseText);
var _622=_621.parseWidgetDefinition();
me.widgetDef[_615]=_622;
me.handleCallback(_617,_622,xhr.status,xhr);
var _623=me.waitingqueue[_615];
if(_623&&_623!=null){
for(var i in _623){
me.handleCallback(_623[i].cb,_622,xhr.status,xhr);
}
me.waitingqueue[_615]=null;
}
},error:function(data,_626){
var xhr=_626.xhr;
me.widgetDef[_615]={error:me.LOADING_ERROR_TOKEN,data:data,status:xhr.status};
me.handleCallback(_617,data,xhr.status,xhr);
var _628=me.waitingqueue[_615];
if(_628&&_628!=null){
for(var i in _628){
me.handleCallback(_628[i].cb,data,xhr.status,xhr);
}
me.waitingqueue[_615]=null;
}
},handleAs:"text",sync:sync};
dojo.xhrGet(args);
return;
},handleCallback:function(_62a,data,_62c,xhr){
if(_62a){
_62a(data,_62c,xhr);
}
}});
}
if(!dojo._hasResource["com.ibm.mm.services"]){
dojo._hasResource["com.ibm.mm.services"]=true;
dojo.provide("com.ibm.mm.services");
dojo.declare("com.ibm.mm.services.ServiceManager",com.ibm.mashups.services.ServiceManager,{constructor:function(){
this._serviceEntries={};
this._serviceEntries["configService"]={name:"configService",baseClass:"com.ibm.mm.enabler.services.ConfigServiceImpl",path:dojo.moduleUrl("com.ibm.mm.enabler","services.js")};
this._serviceEntries["eventService"]={name:"eventService",baseClass:"com.ibm.mm.iwidget.services.EventServiceImpl",path:dojo.moduleUrl("com.ibm.mm.iwidget","services/eventservice.js")};
this._serviceEntries["queryService"]={name:"queryService",baseClass:"com.ibm.mm.iwidget.services.QueryServiceImpl",path:dojo.moduleUrl("com.ibm.mm.iwidget","services/qservice.js")};
this._serviceEntries["persistentAttributesFactoryService"]={name:"persistentAttributeFactoryService",baseClass:"com.ibm.mm.iwidget.services.PersistentAttributesFactoryServiceImpl",path:dojo.moduleUrl("com.ibm.mm.iwidget","services/internalservices.js")};
this._serviceEntries["iwidgetFragmentService"]={name:"iwidgetFragmentService",baseClass:"com.ibm.mm.iwidget.services.IWidgetFragmentServiceImpl",path:dojo.moduleUrl("com.ibm.mm.iwidget","services/internalservices.js")};
this._serviceEntries["widgetLoadService"]={name:"widgetLoadService",baseClass:"com.ibm.mm.iwidget.services.WidgetLoadServiceImpl",path:dojo.moduleUrl("com.ibm.mm.iwidget","services/widgetloadservice.js")};
this._serviceEntries["resourceLoadService"]={name:"resourceLoadService",baseClass:"com.ibm.mm.iwidget.services.ResourceLoadServiceImpl",path:dojo.moduleUrl("com.ibm.mm.iwidget","services/internalservices.js")};
if(typeof ibmConfig!="undefined"&&ibmConfig!=null&&typeof ibmConfig.additionalServices!="undefined"&&ibmConfig.additionalServices!=null&&ibmConfig.additionalServices==true){
var _62e=dojo.fromJson(ibmConfig.additionalServices);
for(var i in _62e){
var _630=_62e[i];
me._serviceEntried[_630.name]=_630;
}
}
},getService:function(_631){
var _632=this._serviceEntries[_631];
if(typeof _632!="undefined"&&_632!==null){
var _633=_632.serviceHandler;
if(typeof _633=="undefined"||_633===null){
_633=this._createService(_632);
if(typeof _633=="undefined"||_633===null){
this._loadScript(_632);
_633=this._createService(_632);
}
}
if(typeof _633!="undefined"&&_633!==null){
this._serviceEntries[_631]["serviceHandler"]=_633;
return _633;
}
}
return null;
},setService:function(_634,_635,path){
var _637=this._serviceEntries[_634];
if(_637!=null){
delete this._serviceEntries[_634];
}
this._serviceEntries[_634]={name:_634,baseClass:_635,path:path};
},_loadScript:function(_638){
var me=this;
dojo.xhrGet({url:_638.path,handleAs:"text",sync:true,load:function(_63a){
dojo.eval(_63a);
},error:function(data,_63c){
com.ibm.mm.enabler.debug.error("com.ibm.mm.iwidget.services.ServiceManager","error loading service:"+_638.name,data);
}});
},_createService:function(_63d){
var _63e=null;
try{
_63e=dojo.eval("new "+_63d.baseClass+"();");
}
catch(err){
com.ibm.mm.enabler.debug.log("services.getService"," failed to create service error detail: "+err.description);
}
return _63e;
}});
com.ibm.mashups.services.ServiceManager=new com.ibm.mm.services.ServiceManager();
window.serviceManager=com.ibm.mashups.services.ServiceManager;
}
if(!dojo._hasResource["com.ibm.mashups.enabler.embedding"]){
dojo._hasResource["com.ibm.mashups.enabler.embedding"]=true;
dojo.provide("com.ibm.mashups.enabler.embedding");
dojo.declare("com.ibm.mashups.enabler.EmbeddingGenerator",null,{widgetDefinition:"",pid:"",width:"",height:"",scrollbar:false,sandboxed:false,framework:"light",preferences:null,constructor:function(_63f,pid){
this.widgetDefinition=_63f;
this.pid=pid;
this.hostAlias=null;
},_getSecureHostAlias:function(){
if(this.hostAlias===null){
this.hostAlias=window.location.host;
}
return this.hostAlias;
},toString:function(){
var url=window.location.protocol;
url+="//"+this._getSecureHostAlias();
url+=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);
url+=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.EMBEDDING_PUBLIC);
url+="?";
url+="uri=widget:js";
url+="&url="+escape(this.widgetDefinition);
if(this.pid){
url+="&pid="+escape(this.pid);
this.height=this.height?this.height:"850";
this.width=this.width?this.width:"750";
}else{
this.height=this.height?this.height:"500";
this.width=this.width?this.width:"400";
}
url+="&h="+escape(this.height);
url+="&w="+escape(this.width);
if(this.scrollbar){
url+="&sb=yes";
}else{
url+="&sb=no";
}
if(this.framework&&!this.framework==="light"){
url+="&fw="+this.framework;
}
if(this.sandboxed){
url+="&sandbox=yes";
}
if(this.preferences&&this.preferences.getAllNames()){
var _642=this.preferences.getAllNames();
for(var i=0;i<_642.length;++i){
url+="&p_"+encodeURIComponent(_642[i])+"="+encodeURIComponent(this.preferences.getItemValue(_642[i]));
}
}
return url;
},getWidgetDefinition:function(){
return this.widgetDefinition;
},setWidgetDefinition:function(_644){
this.widgetDefinition=_644;
},getPid:function(){
return this.pid;
},setPid:function(_645){
this.pid=_645;
},getWidth:function(){
return this.width;
},setWidth:function(_646){
this.width=_646;
},getHeight:function(){
return this.height;
},setHeight:function(_647){
this.height=_647;
},getScrollbar:function(){
return this.scrollbar;
},setScrollbar:function(_648){
this.scrollbar=_648;
},getSandboxed:function(){
return this.sandboxed;
},setSandboxed:function(_649){
this.sandboxed=_649;
},getFramework:function(){
return this.framework;
},setFramework:function(_64a){
this.framework=_64a;
},getPreferences:function(){
return this.preferences;
},setPreferences:function(_64b){
this.preferences=_64b;
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.catalog"]){
dojo._hasResource["com.ibm.mashups.enabler.model.catalog"]=true;
dojo.provide("com.ibm.mashups.enabler.model.catalog");
dojo.provide("com.ibm.mashups.enabler.model.CatalogCategoryModel");
dojo.provide("com.ibm.mashups.enabler.model.CatalogElementModel");
dojo.provide("com.ibm.mashups.enabler.catalog.CatalogNode");
dojo.provide("com.ibm.mashups.enabler.catalog.CatalogCategory");
dojo.provide("com.ibm.mashups.enabler.catalog.CatalogElement");
dojo.declare("com.ibm.mashups.enabler.model.CatalogCategoryModel",com.ibm.mashups.enabler.TreeModelController,{constructor:function(){
},getCatalogEntryModel:function(_64c){
return new CatalogEntryModel();
},create:function(_64d){
return new CatalogCategoryNode();
},commit:function(){
return new Deferred();
}});
dojo.declare("com.ibm.mashups.enabler.model.CatalogEntryModel",com.ibm.mashups.enabler.ListModelController,{constructor:function(){
},create:function(_64e){
return new CatalogEntryNode();
}});
dojo.declare("com.ibm.mashups.enabler.catalog.CatalogCategoryNode",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.ModifiableLocalized],{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.catalog.CatalogEntryNode",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.ModifiableLocalized,com.ibm.mashups.enabler.ModifiableMetaData],{constructor:function(){
},getDefinitionURL:function(_64f){
return new String();
},getIconURL:function(_650){
return new String();
},getPreviewThumbnailURL:function(_651){
return new String();
},getPreviewURL:function(_652){
return new String();
},getHelpURL:function(_653){
return new String();
},setDefinitionURL:function(url){
},confirmSetDefinitionURL:function(url){
return new Boolean();
},setIconURL:function(url){
},confirmSetIconURL:function(url){
return new Boolean();
},setPreviewThumbnailURL:function(url){
},confirmSetPreviewThumbnailURL:function(url){
return new Boolean();
},setPreviewURL:function(url){
},confirmSetPreviewURL:function(url){
return new Boolean();
},setHelpURL:function(url){
},confirmSetHelpURL:function(url){
return new Boolean();
},getShortDescription:function(_65e){
return new String();
},setShortDescription:function(desc,_660){
return new String();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.theme"]){
dojo._hasResource["com.ibm.mashups.enabler.model.theme"]=true;
dojo.provide("com.ibm.mashups.enabler.model.theme");
dojo.declare("com.ibm.mashups.enabler.ThemeProvider",null,{constructor:function(){
},getTheme:function(){
return new String();
},setTheme:function(_661){
},getThemeIdentifier:function(){
return new com.ibm.mashups.enabler.Identifiable();
},setThemeIdentifier:function(_662){
}});
dojo.declare("com.ibm.mashups.enabler.model.ThemeModel",[com.ibm.mashups.enabler.ListModel,com.ibm.mashups.enabler.ResourceLocator],{constructor:function(){
},getSkinModel:function(_663){
return new SkinModel();
}});
dojo.declare("com.ibm.mashups.enabler.theme.Theme",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.Localized,com.ibm.mashups.enabler.MetaData],{constructor:function(){
},getBaseUrl:function(){
return new String();
},getDefaultSkin:function(){
return new String();
},getDefaultSkinIdentifier:function(){
return new com.ibm.mashups.enabler.Identifiable();
}});
dojo.declare("com.ibm.mashups.enabler.model.SkinModel",[com.ibm.mashups.enabler.ListModel,com.ibm.mashups.enabler.ResourceLocator],{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.theme.Skin",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.Localized,com.ibm.mashups.enabler.MetaData],{constructor:function(){
},getBaseUrl:function(){
return new String();
},getPreviewUrl:function(){
return new String();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.navigation"]){
dojo._hasResource["com.ibm.mashups.enabler.model.navigation"]=true;
dojo.provide("com.ibm.mashups.enabler.model.navigation");
dojo.provide("com.ibm.mashups.enabler.model.NavigationModel");
dojo.provide("com.ibm.mashups.enabler.navigation.NavigationNode");
dojo.declare("com.ibm.mashups.enabler.model.NavigationModel",[com.ibm.mashups.enabler.TreeModelController,com.ibm.mashups.enabler.model.SelectionLocator],{constructor:function(){
},hasLayoutModel:function(node){
return new Boolean();
},getLayoutModel:function(node){
return new com.ibm.mashups.enabler.model.LayoutModel();
},getSharedRoot:function(){
return new Deferred();
},confirmExport:function(node){
return new Boolean();
},create:function(_667){
return new com.ibm.mashups.enabler.navigation.NavigationNode();
},commit:function(){
return new Deferred();
}});
dojo.declare("com.ibm.mashups.enabler.navigation.NavigationNode",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.ModifiableLocalized,com.ibm.mashups.enabler.ModifiableMetaData,com.ibm.mashups.enabler.ThemeProvider,com.ibm.mashups.enabler.RepresentationProvider],{constructor:function(){
},isHidden:function(){
return new Boolean();
},setHidden:function(hide){
return new Boolean();
},confirmSetHidden:function(hide){
return new Boolean();
},getExportPageURL:function(){
return new String();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.user"]){
dojo._hasResource["com.ibm.mashups.enabler.model.user"]=true;
dojo.provide("com.ibm.mashups.enabler.model.user");
dojo.declare("com.ibm.mashups.enabler.user.AnonymousMode",null,{USER:"user",ANONYMOUS:"anonymous"});
com.ibm.mashups.enabler.user.AnonymousMode=new com.ibm.mashups.enabler.user.AnonymousMode();
dojo.declare("com.ibm.mashups.enabler.model.UserModel",[com.ibm.mashups.enabler.ListModel,com.ibm.mashups.enabler.Locator],{constructor:function(){
},getAnonymousMode:function(){
},findCurrentUser:function(){
return new Deferred();
},findUsersByAttribute:function(_66a,_66b){
return new Deferred();
},findGroupByID:function(id){
return new Deferred();
},findGroupsByAttribute:function(_66d,_66e){
return new Deferred();
},findGroupAttributes:function(){
return [];
},findUserAttributes:function(){
return [];
},getVirtualUsers:function(){
return [];
},getVirtualGroups:function(){
return [];
},getLookasideAttributeNames:function(){
return [];
}});
dojo.declare("com.ibm.mashups.enabler.user.Entity",[com.ibm.mashups.enabler.Identifiable],{constructor:function(){
},getDisplayName:function(){
return new String();
},getCN:function(){
return new String();
},getAttribute:function(name){
return new String();
},getAttributeNames:function(){
return [];
}});
dojo.declare("com.ibm.mashups.enabler.user.User",[com.ibm.mashups.enabler.user.Entity],{constructor:function(){
},getLoginName:function(){
return new String();
},getSN:function(){
return new String();
},getEmail:function(){
return new String();
},setAttribute:function(name,_671){
return new String();
},removeAttribute:function(name){
return new String();
}});
dojo.declare("com.ibm.mashups.enabler.user.CurrentUser",[com.ibm.mashups.enabler.user.User],{constructor:function(){
},getJ2EEPrincipalName:function(){
return new String();
}});
dojo.declare("com.ibm.mashups.enabler.user.Group",[com.ibm.mashups.enabler.user.Entity],{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.user.Attribute",null,{constructor:function(){
},getName:function(){
return new String();
},getType:function(){
return new String();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.factory"]){
dojo._hasResource["com.ibm.mashups.enabler.model.factory"]=true;
dojo.provide("com.ibm.mashups.enabler.model.factory");
dojo.declare("com.ibm.mashups.enabler.model.Factory",null,{getCatalogCategoryModel:function(){
return new com.ibm.mashups.enabler.model.CatalogCategoryModel();
},getNavigationModel:function(){
return new com.ibm.mashups.enabler.model.NavigationModel();
},getSharedNavigationModel:function(){
return new com.ibm.mashups.enabler.model.SharedNavigationModel();
},getThemeModel:function(){
return new com.ibm.mashups.enabler.model.ThemeModel();
},getUserModel:function(){
return new com.ibm.mashups.enabler.model.UserModel();
},getRemoteModel:function(){
return new com.ibm.mashups.enabler.model.RemoteModel();
},getSpaceModel:function(){
return new com.ibm.mashups.enabler.model.SpaceModel();
},getTemplateModel:function(){
return new com.ibm.mashups.enabler.model.TemplateModel();
},getSpaceExtensionModel:function(){
return new com.ibm.mashups.enabler.model.SpaceExtensionModel();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.layout"]){
dojo._hasResource["com.ibm.mashups.enabler.model.layout"]=true;
dojo.provide("com.ibm.mashups.enabler.model.layout");
dojo.provide("com.ibm.mashups.enabler.model.LayoutModel");
dojo.provide("com.ibm.mashups.enabler.layout.LayoutNode");
dojo.provide("com.ibm.mashups.enabler.layout.LayoutFragment");
dojo.declare("com.ibm.mashups.enabler.model.LayoutModel",com.ibm.mashups.enabler.TreeModelController,{constructor:function(){
},create:function(_673){
return new com.ibm.mashups.enabler.layout.LayoutNode();
}});
dojo.declare("com.ibm.mashups.enabler.layout.LayoutNode",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.ModifiableMetaData],{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.layout.LayoutFragment",[com.ibm.mashups.enabler.layout.LayoutNode],{constructor:function(){
},getFragment:function(){
return new String();
},setFragment:function(_674){
},confirmSetFragment:function(_675){
return new Boolean();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.sharedNavigation"]){
dojo._hasResource["com.ibm.mashups.enabler.model.sharedNavigation"]=true;
dojo.provide("com.ibm.mashups.enabler.model.sharedNavigation");
dojo.provide("com.ibm.mashups.enabler.model.SharedNavigationModel");
dojo.provide("com.ibm.mashups.enabler.navigation.SharedNavigationNode");
dojo.provide("com.ibm.mashups.enabler.navigation.SharedNavigationRoot");
dojo.declare("com.ibm.mashups.enabler.model.SharedNavigationModel",com.ibm.mashups.enabler.TreeModel,{constructor:function(){
},getLayoutModel:function(node){
return new com.ibm.mashups.enabler.model.LayoutModel();
},isAccepted:function(id){
return new Boolean();
}});
dojo.declare("com.ibm.mashups.enabler.navigation.SharedNavigationNode",com.ibm.mashups.enabler.navigation.NavigationNode,{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.navigation.SharedNavigationRoot",com.ibm.mashups.enabler.navigation.NavigationNode,{constructor:function(){
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.url"]){
dojo._hasResource["com.ibm.mashups.enabler.model.url"]=true;
dojo.provide("com.ibm.mashups.enabler.model.url");
dojo.declare("com.ibm.mashups.enabler.model.url.ModelUrlFactory",null,{NAVIGATION_URL:"nav",SHARED_NAVIGATION_URL:"sharednav",FRAGMENT_URL:"fragment",FRAGMENT_MEDIA_URL:"fragment-media",USER_URL:"user",THEME_URL:"theme",THEME_MEDIA_URL:"theme-media",CATALOG_URL:"cat",CONFIG_URL:"config",SPACE_URL:"space",SPACE_FAVORITE_URL:"space-favorite",AC_URL:"ac",AI_URL:"ai",TEMPLATE_URL:"template",SUBMODEL_MEMBER:"member",SUBMODEL_ROLE:"role",SUBMODEL_ACCESS:"access",SUBMODEL_RESOURCE:"resource",constructor:function(){
},createModelUrl:function(_678,_679){
return new com.ibm.mashups.enabler.model.url.ModelUrl(_678,_679);
},getModelUrl:function(url,_67b){
return new com.ibm.mashups.enabler.model.url.ModelUrl(url,_67b);
}});
dojo.declare("com.ibm.mashups.enabler.model.url.ModelUrl",null,{constructor:function(){
},setNodes:function(_67c){
},setSchemeSpecificPart:function(_67d){
},getSchemeSpecificPart:function(){
return null;
},addParameter:function(name,_67f){
},setParameter:function(name,_681){
},getParameter:function(name){
return null;
},getParameters:function(){
return null;
},getAbsoluteURL:function(){
return null;
},getProxifiedAbsoluteURL:function(){
return null;
},getModelURI:function(){
return null;
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.space"]){
dojo._hasResource["com.ibm.mashups.enabler.model.space"]=true;
dojo.provide("com.ibm.mashups.enabler.model.space");
dojo.provide("com.ibm.mashups.enabler.model.SpaceModel");
dojo.provide("com.ibm.mashups.enabler.space.SpaceNode");
dojo.declare("com.ibm.mashups.enabler.space.SpaceLocator",[com.ibm.mashups.enabler.Locator],{constructor:function(){
},findSpaceByNavigation:function(_683){
return new Deferred();
},findFavorites:function(){
return new Iterator();
}});
dojo.declare("com.ibm.mashups.enabler.model.SpaceModel",[com.ibm.mashups.enabler.ListModelController,com.ibm.mashups.enabler.SubmittableFormProvider,com.ibm.mashups.enabler.space.SpaceLocator],{constructor:function(){
},create:function(_684){
return new SpaceNode();
},commit:function(){
return new Deferred();
},confirmExport:function(node){
return new Boolean();
},confirmCopy:function(node){
return new Boolean();
},getSubmittableImportForm:function(id){
return SubmittableForm();
}});
dojo.declare("com.ibm.mashups.enabler.space.SpaceNode",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.ModifiableLocalized,com.ibm.mashups.enabler.ModifiableMetaData,com.ibm.mashups.enabler.ThemeProvider],{constructor:function(){
},getRootNavigation:function(){
return new com.ibm.mashups.enabler.Identifiable();
},getExportSpaceURL:function(){
return new String();
},getExportTemplateURL:function(){
return new String();
},saveAsTemplate:function(){
},isHidden:function(){
return new Boolean();
},setHidden:function(hide){
return new Boolean();
},confirmSetHidden:function(hide){
return new Boolean();
},isFavorite:function(){
return new Boolean();
},setFavorite:function(_68a){
return new Boolean();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.template"]){
dojo._hasResource["com.ibm.mashups.enabler.model.template"]=true;
dojo.provide("com.ibm.mashups.enabler.model.template");
dojo.provide("com.ibm.mashups.enabler.model.TemplateModel");
dojo.provide("com.ibm.mashups.enabler.template.TemplateNode");
dojo.declare("com.ibm.mashups.enabler.model.TemplateModel",[com.ibm.mashups.enabler.ListModelController,com.ibm.mashups.enabler.SubmittableFormProvider],{constructor:function(){
},commit:function(){
return new Deferred();
},confirmExport:function(node){
return new Boolean();
},getSubmittableImportForm:function(id){
return SubmittableForm();
}});
dojo.declare("com.ibm.mashups.enabler.template.TemplateNode",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.enabler.ModifiableLocalized],{constructor:function(){
},getExportURL:function(){
return new String();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteLocator"]){
dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteLocator"]=true;
dojo.provide("com.ibm.mashups.enabler.remote.RemoteLocator");
dojo.declare("com.ibm.mashups.enabler.remote.RemoteLocator",null,{constructor:function(){
},getUserRoot:function(){
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteFile"]){
dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteFile"]=true;
dojo.provide("com.ibm.mashups.enabler.remote.RemoteFile");
dojo.declare("com.ibm.mashups.enabler.remote.RemoteFile",[com.ibm.mashups.enabler.MetaData,com.ibm.mashups.enabler.Identifiable],{constructor:function(){
},getName:function(){
},isDirectory:function(){
},getUrl:function(){
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.remote"]){
dojo._hasResource["com.ibm.mashups.enabler.model.remote"]=true;
dojo.provide("com.ibm.mashups.enabler.model.remote");
dojo.declare("com.ibm.mashups.enabler.model.RemoteModel",[com.ibm.mashups.enabler.TreeModel,com.ibm.mashups.enabler.remote.RemoteLocator],{constructor:function(){
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.ac"]){
dojo._hasResource["com.ibm.mashups.enabler.model.ac"]=true;
dojo.provide("com.ibm.mashups.enabler.model.ac");
dojo.provide("com.ibm.mashups.enabler.ac.AccessControlModelFactory");
dojo.provide("com.ibm.mashups.enabler.ac.AccessControlModel");
dojo.provide("com.ibm.mashups.enabler.ac.ResourceAccessControlModel");
dojo.provide("com.ibm.mashups.enabler.ac.MemberModel");
dojo.provide("com.ibm.mashups.enabler.ac.RoleModel");
dojo.provide("com.ibm.mashups.enabler.ac.MemberNode");
dojo.provide("com.ibm.mashups.enabler.ac.RoleNode");
dojo.provide("com.ibm.mashups.enabler.ac.RoleType");
dojo.declare("com.ibm.mashups.enabler.ac.AccessFactory",null,{getEffectiveAccess:function(node){
},getEffectiveAccessVirtualResource:function(_68e){
}});
dojo.declare("com.ibm.mashups.enabler.ac.EffectiveAccess",null,{hasRole:function(_68f){
return false;
}});
dojo.declare("com.ibm.mashups.enabler.ac.VirtualResourceType",null,{ROOT:"wps.PORTAL",TEMPLATE:"wps.TEMPLATE_DEPLOYMENT",SPACE:"wps.APPLICATION_ENTITIES"});
com.ibm.mashups.enabler.ac.VirtualResourceType=new com.ibm.mashups.enabler.ac.VirtualResourceType();
dojo.declare("com.ibm.mashups.enabler.ac.AccessControlModelFactory",null,{constructor:function(){
},getAccessControlModel:function(_690){
return null;
},getAccessControlModel:function(_691){
return null;
},getAccessControlModel:function(_692,_693){
return null;
}});
dojo.declare("com.ibm.mashups.enabler.ac.AccessControlModel",[com.ibm.mashups.enabler.model.Model],{constructor:function(){
},getOwner:function(){
return new User();
},setOwner:function(user){
},confirmSetOwner:function(user){
return new Boolean();
},getRoleModel:function(){
return new RoleModel();
},getRoleModel:function(_696){
return new RoleModel();
},confirmGetRoleModel:function(){
return new Boolean();
},commit:function(){
return new Deferred();
}});
dojo.declare("com.ibm.mashups.enabler.ac.ResourceAccessControlModel",[com.ibm.mashups.enabler.ac.AccessControlModel],{constructor:function(){
},isInheritanceBlock:function(_697){
return true;
},setInheritanceBlock:function(_698,_699){
}});
dojo.declare("com.ibm.mashups.enabler.ac.RoleModel",[com.ibm.mashups.enabler.ListModelController],{constructor:function(){
},create:function(_69a){
return new RoleNode();
},getMemberModel:function(_69b){
return new MemberModel();
}});
dojo.declare("com.ibm.mashups.enabler.ac.MemberModel",[com.ibm.mashups.enabler.ListModelController],{constructor:function(){
},create:function(_69c){
return new MemberNode();
}});
dojo.declare("com.ibm.mashups.enabler.ac.RoleType",null,{USER:"USER",EDITOR:"EDITOR",MANAGER:"MANAGER",ADMIN:"ADMIN",UNKNOWN:"UNKNOWN"});
com.ibm.mashups.enabler.ac.RoleType=new com.ibm.mashups.enabler.ac.RoleType();
dojo.declare("com.ibm.mashups.enabler.ac.RoleNode",[com.ibm.mashups.enabler.Identifiable],{constructor:function(){
},getRoleName:function(){
return null;
},getRoleType:function(){
return null;
}});
dojo.declare("com.ibm.mashups.enabler.ac.MemberNode",null,{constructor:function(){
},getEntity:function(){
return new Entity();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.spaceextension"]){
dojo._hasResource["com.ibm.mashups.enabler.model.spaceextension"]=true;
dojo.provide("com.ibm.mashups.enabler.model.spaceextension");
dojo.provide("com.ibm.mashups.enabler.model.space.SpaceExtension");
dojo.provide("com.ibm.mashups.enabler.model.space.SpaceExtensionResult");
dojo.provide("com.ibm.mashups.enabler.model.SpaceExtensionModel");
dojo.declare("com.ibm.mashups.enabler.model.space.SpaceExtension",null,{constructor:function(){
},onSpaceCreate:function(_69d,_69e,_69f,_6a0){
},onSpaceCopy:function(_6a1,_6a2,_6a3,_6a4,_6a5){
},onSpaceUpdate:function(_6a6,_6a7,_6a8){
},onSpaceDelete:function(_6a9,_6aa){
},canExportSpace:function(_6ab,_6ac){
},canCopySpace:function(_6ad,_6ae){
},canDeleteSpace:function(_6af,_6b0){
}});
dojo.declare("com.ibm.mashups.enabler.model.space.SpaceExtensionResult",null,{STATE_OK:"OK",STATE_WARNING:"WARNING",STATE_ERROR:"ERROR",constructor:function(_6b1){
this.result=_6b1;
},getState:function(){
return this.result;
},getLocaleMessage:function(){
return this.message||"";
},getLocaleSolution:function(){
return this.solution||"";
},getOptionalInfo:function(){
return this.optionalInfo||"";
},setLocaleMessage:function(_6b2){
this.message=_6b2;
},setLocaleSolution:function(_6b3){
this.solution=_6b3;
},setOptionalInfo:function(info){
if(optionalInfo){
this.optionalInfo=info;
}
}});
dojo.declare("com.ibm.mashups.enabler.space.SpaceExtensionLocator",[com.ibm.mashups.enabler.Locator],{constructor:function(){
},findExtensionBySpace:function(_6b5){
return new Deferred();
}});
dojo.declare("com.ibm.mashups.enabler.model.SpaceExtensionModel",[com.ibm.mashups.enabler.ListModelController,com.ibm.mashups.enabler.space.SpaceExtensionLocator],{constructor:function(){
},create:function(_6b6){
return new SpaceExtension();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model"]){
dojo._hasResource["com.ibm.mashups.enabler.model"]=true;
dojo.provide("com.ibm.mashups.enabler.model");
}
if(!dojo._hasResource["com.ibm.mashups.enabler.model.navigationstate"]){
dojo._hasResource["com.ibm.mashups.enabler.model.navigationstate"]=true;
dojo.provide("com.ibm.mashups.enabler.model.navigationstate");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateModelFactory");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateModel");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateNode");
dojo.provide("com.ibm.mashups.enabler.model.state.AccessorFactory");
dojo.provide("com.ibm.mashups.enabler.model.state.Accessor");
dojo.provide("com.ibm.mashups.enabler.model.state.PageAccessor");
dojo.provide("com.ibm.mashups.enabler.model.state.SpaceAccessor");
dojo.provide("com.ibm.mashups.enabler.model.state.WidgetAccessor");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateProcessor");
dojo.declare("com.ibm.mashups.enabler.model.state.NavigationStateModelFactory",null,{constructor:function(){
},getNavigationStateModel:function(){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.NavigationStateModel",null,{constructor:function(){
},ONNAVSTATEUPDATED:"com.ibm.mashups.enabler.model.state.onNavStateUpdated",commit:function(){
return new com.ibm.mashups.enabler.Deferred();
},discard:function(){
return;
},dispose:function(){
return;
}});
dojo.declare("com.ibm.mashups.enabler.model.state.NavigationStateNode",com.ibm.mashups.enabler.Identifiable,{constructor:function(){
},get:function(){
},set:function(_6b7){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.AccessorFactory",null,{constructor:function(){
},getPageAccessor:function(_6b8,_6b9){
},getSpaceAccessor:function(_6ba){
},getWidgetAccessor:function(_6bb,_6bc){
},getPageModeAccessor:function(_6bd){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.Accessor",null,{constructor:function(){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.PageAccessor",[com.ibm.mashups.enabler.model.state.Accessor],{constructor:function(_6be,_6bf){
},getPageID:function(){
},setPageID:function(_6c0){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.PageModeAccessor",[com.ibm.mashups.enabler.model.state.Accessor],{VIEW:"view",EDIT:"edit",constructor:function(_6c1){
},getPageMode:function(){
},setPageMode:function(_6c2){
}});
com.ibm.mashups.enabler.model.state.PageModeAccessor.VIEW="view";
com.ibm.mashups.enabler.model.state.PageModeAccessor.EDIT="edit";
dojo.declare("com.ibm.mashups.enabler.model.state.SpaceAccessor",[com.ibm.mashups.enabler.model.state.Accessor],{constructor:function(_6c3){
},getSpaceID:function(){
},setSpaceID:function(_6c4){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.WidgetAccessor",[com.ibm.mashups.enabler.model.state.Accessor,com.ibm.mashups.enabler.Identifiable],{constructor:function(_6c5,id){
},getWidgetID:function(){
},getWidgetState:function(key){
},setWidgetState:function(key,_6c9){
},removeWidgetState:function(key){
},getWindowState:function(){
},setWindowState:function(_6cb){
},getSize:function(){
},setSize:function(_6cc,_6cd){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.NavigationStateProcessor",null,{decode:function(url,_6cf){
},encode:function(_6d0,_6d1,_6d2){
},generateUrl:function(_6d3,_6d4,_6d5){
},preprocess:function(_6d6,_6d7){
},dispose:function(_6d8){
},postprocess:function(_6d9,_6da,_6db){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.UrlGeneratorFactory",null,{constructor:function(){
},getUrlGenerator:function(){
}});
dojo.declare("com.ibm.mashups.enabler.model.state.UrlGenerator",null,{constructor:function(){
},getUrl:function(_6dc,_6dd,_6de){
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.navigationstate"]){
dojo._hasResource["com.ibm.mm.enabler.model.navigationstate"]=true;
dojo.provide("com.ibm.mm.enabler.model.navigationstate");
dojo.declare("com.ibm.mm.enabler.model.state.CookieManager",null,{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
this._dirty=false;
this.configSvr=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
this.cookiePath=window.location.pathname;
},disposeState:function(){
var id=this._getCookieID();
if(id!=null&&dojo.cookie(id)!=null){
dojo.isIE?dojo.cookie(id,null,{expires:-1}):dojo.cookie(id,null,{expires:-1,path:this.cookiePath});
}
if(this._state){
delete this._state;
}
this._dirty=false;
},_getCookieID:function(){
if(!this._cookieID){
var uid=this.configSvr.getValue(com.ibm.mashups.enabler.services.ConfigConstants.USER);
if(!uid||(uid&&uid=="null")){
return null;
}
this._cookieID=uid+"_state";
}
return this._cookieID;
},_init:function(){
if(this._getCookieID()==null){
this._state={};
return;
}
if(dojo.cookie.isSupported()){
if(dojo.cookie(this._getCookieID())!=null&&dojo.fromJson(dojo.cookie(this._getCookieID()))!=null){
this._state=dojo.fromJson(dojo.cookie(this._getCookieID()));
}
}
if(!this._state){
this._state={};
}
},getState:function(id){
if(!this._state){
this._init();
}
if(!id){
return this._state;
}
if(this._state[id]){
return this._state[id];
}
return null;
},setState:function(id,_6e3){
if(!this._state){
this._state={};
}
this._state[id]=_6e3;
this._dirty=true;
},removeState:function(id){
if(this._state[id]){
delete this._state[id];
this._dirty=true;
}
},commit:function(){
if(this._dirty){
if(this._getCookieID()==null){
this._dirty=false;
return;
}
if(dojo.cookie.isSupported()){
dojo.isIE?dojo.cookie(this._getCookieID(),dojo.toJson(this._state),{expires:3652}):dojo.cookie(this._getCookieID(),dojo.toJson(this._state),{expires:3652,path:this.cookiePath});
}
this._dirty=false;
}
}});
com.ibm.mashups.enabler.model.state.CookieManager=new com.ibm.mm.enabler.model.state.CookieManager();
dojo.declare("com.ibm.mm.enabler.model.state.NavigationStateProcessorImpl",com.ibm.mashups.enabler.model.state.NavigationStateProcessor,{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(this.bIsLoggable==true){
this.LOGGER.entering("constructor");
}
this.configService=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _6e5=this.configService.getValue(this.configService.NAVSTATE_PERSISTENCE_URL);
if(_6e5){
this.persistenceURL=this._getAssociativeArray(_6e5);
}
var _6e6=this.configService.getValue(this.configService.NAVSTATE_PERSISTENCE_PSTORE);
if(_6e6){
this.persistencePSTORE=this._getAssociativeArray(_6e6);
}
var _6e7=this.configService.getValue(this.configService.NAVSTATE_PERSISTENCE_URL_LIMIT);
var _6e8=10;
if(_6e7&&_6e7!=null){
_6e8=parseInt(_6e7);
}
this.urlpersistenceLIMIT=_6e8;
this.isHuffmannEnabled=this.configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.NAVSTATE_HUFFMANNENCODE_ENABLED);
},HUFFMANN_PREFIX:"mashup:huffman/",dispose:function(_6e9){
var _6ea=com.ibm.mashups.enabler.model.state.CookieManager;
var temp=_6ea.disposeState();
if(_6e9){
_6e9();
}
},_getAssociativeArray:function(_6ec){
var obj={};
if(dojo.isString(_6ec)==true){
obj[_6ec]=_6ec;
return obj;
}
for(var i in _6ec){
var _6ef=_6ec[i];
obj[_6ef]=_6ef;
}
return obj;
},decode:function(url,_6f1){
if(this.bIsLoggable==true){
this.LOGGER.entering("decode");
this.LOGGER.trace("decode","url is "+url);
}
var hash=this._getHash(url);
if(hash!=null){
if(url.indexOf("#")!=-1){
if(url.lastIndexOf("&")==(url.length-1)){
url=url.concat(hash);
}else{
url=url.concat("#");
url=url.concat(hash);
}
}else{
url=url.concat("#");
url=url.concat(hash);
}
}
var _6f3={};
if(url.indexOf(this.HUFFMANN_PREFIX)!=-1){
var arr=url.split(this.HUFFMANN_PREFIX);
var _6f5=com.ibm.mm.enabler.encode.huffman.HuffmanURL.getDataFromHuffmanTree(arr[1]);
if(_6f5!=null){
url=arr[0]+_6f5;
}
}
var _6f6=new com.ibm.mm.enabler.utilities.HttpUrl(url);
var _6f7=_6f6.anchor;
if(this.bIsLoggable==true){
this.LOGGER.trace("decode","fragment is "+_6f7);
}
if(_6f7&&_6f7!=null&&_6f7!=""){
var _6f8=dojo.queryToObject(_6f7);
var _6f9=new Date().getTime();
if(_6f8.pid){
_6f3.pid={};
_6f3.pid.value=decodeURIComponent(_6f8.pid);
_6f3.pid.params={};
_6f3.pid.params.lm=_6f9;
}
if(_6f8.sid){
_6f3.sid={};
_6f3.sid.value=decodeURIComponent(_6f8.sid);
_6f3.sid.params={};
_6f3.sid.params.lm=_6f9;
}
_6f3.wparams={};
for(var i in _6f8){
if(i.indexOf("w")==0&&i.indexOf("cp")==-1&&i.indexOf("rp")==-1){
var _6fb={};
var _6fc=i.substr(1)*1+_6f9;
var wID=_6f8[i];
var _6fe=i+"cp";
var _6ff=i+"rp";
if(_6f8[_6fe]){
_6fb.value=_6fb.value?_6fb.value:{};
_6fb.value.cp=dojo.fromJson(decodeURIComponent(_6f8[_6fe]));
_6fb.params=_6fb.params?_6fb.params:{};
_6fb.params.lm=_6fc;
}
if(_6f8[_6ff]){
_6fb.value=_6fb.value?_6fb.value:{};
_6fb.value.rp=dojo.fromJson(decodeURIComponent(_6f8[_6ff]));
_6fb.params=_6fb.params?_6fb.params:{};
_6fb.params.lm=_6fc;
}
_6f3.wparams[wID]=_6fb;
}
}
}
if(_6f1){
_6f1(_6f3);
}
if(!_6f1){
return _6f3;
}
},encode:function(_700,_701,_702){
var _703="";
for(var i in _700){
if(i=="pid"){
if(_700[i]&&_700[i]!=null&&_700[i].value&&_700[i].value!=null){
if(this._contains(i,this.persistenceURL)){
_703=_703+i+"="+encodeURIComponent(_700[i].value)+"&";
}
}
}
if(i=="sid"){
if(!_700["pid"]){
if(_700["pageselection"]&&_700["pageselection"]!=null){
var _705=_700["pageselection"];
var sid=_700["sid"].value;
if(_705[sid]&&_705[sid]!=null){
var pid=_705[sid].value;
_703=_703+"pid"+"="+encodeURIComponent(pid)+"&";
}
}
}
}
if(i=="wparams"&&_700[i]&&_700[i]!=null){
var _708=this._sortData(dojo.clone(_700[i]));
if(_708.length>this.urlpersistenceLIMIT){
_708=_708.slice(_708.length-this.urlpersistenceLIMIT);
}
var _709=0;
for(var j in _708){
var _70b=_708[j];
if(_70b!=null&&_70b["value"]&&_70b["value"]!=null&&_70b["value"]["cp"]&&_70b["value"]["cp"]!=null){
var _70c=this._filterData(dojo.clone(_70b["value"]["cp"]),this.persistenceURL,this.persistencePSTORE);
if(this._isEmpty(_70c)==false){
var _70d=dojo.toJson(_70c);
_703=_703+"w"+_709+"="+_70b.wid+"&"+"w"+_709+"cp="+encodeURIComponent(_70d)+"&";
_709++;
if(_709>=this.urlpersistenceLIMIT){
break;
}
}
}
}
}
}
if(this.isHuffmannEnabled==true){
if(_703.indexOf("&")!=-1){
var data=_703.substr(_703.indexOf("&")+1);
if(data.length>0){
data=com.ibm.mm.enabler.encode.huffman.HuffmanURL.createRawSchemeSpecificPartFromRegex(data,"[%&c=]");
_703=_703.substring(0,_703.indexOf("&")+1);
_703=_703.concat(this.HUFFMANN_PREFIX);
_703=_703.concat(data);
}
}
}
if(_701){
_701(_703);
}
if(!_701){
return _703;
}
},_removeQueryState:function(wru){
if(wru.indexOf("?")==-1){
return wru;
}
var _710=wru.substring(wru.indexOf("?")+1);
if(_710&&_710!=null&&_710.indexOf("#")!=-1){
_710=_710.substring(0,_710.indexOf("#"));
}
var _711=wru.substr(0,wru.indexOf("?"));
var st=null;
var _713="";
if(_710&&_710!=null&&(_710.indexOf("nst=")==0||_710.indexOf("&nst=")>=0)){
var temp=_710.substr(_710.indexOf("nst=")+3);
var _715="";
if(temp.indexOf("&")>0){
st=temp.substring(0,temp.indexOf("&"));
_715=temp.substring(temp.indexOf("&"));
}else{
st=temp;
}
if(_710.indexOf("&nst=")!=-1){
_713=_710.substring(0,_710.indexOf("&nst="));
}
if(_713.length==0&&_715.length!=0){
_713=_713.concat(_715.substring(1));
}else{
_713=_713.concat(_715);
}
}else{
return wru;
}
var hash=wru.substr(wru.indexOf("#")+1);
var _717=_711;
if(_713.length>0){
_717=_717.concat("?").concat(_713);
}
if(hash.length>0){
_717=_717.concat("#").concat(hash);
}
return _717;
},generateUrl:function(_718,_719,_71a){
var _71b=this.encode(_718);
var href=window.location.href;
href=this._removeQueryState(href);
var _71d=href.substr(0,href.indexOf("#"));
var url=_71d.concat("#");
url=url.concat(_71b);
if(_71a&&_71a.nohash&&_71a.nohash=="true"){
_71b=escape(_71b);
if(_71d.indexOf("?")==-1){
url=_71d.concat("?");
url=url.concat("nst=");
url=url.concat(_71b);
}else{
if(_71d.lastIndexOf("&")==(_71d.length-1)){
url=_71d.concat("nst=");
url=url.concat(_71b);
}else{
url=_71d.concat("&");
url=url.concat("nst=");
url=url.concat(_71b);
}
}
}
if(_719&&_719!=null){
_719(url);
}
return url;
},_getHash:function(wru){
if(wru.indexOf("?")==-1){
return null;
}
if(wru.indexOf("#")!=-1){
var _720=wru.substr(wru.indexOf("#")+1);
if(wru.indexOf("pid")!=-1||wru.indexOf("sid")!=-1){
return null;
}
}
var _721=wru.substring(wru.indexOf("?")+1);
if(_721&&_721!=null&&_721.indexOf("#")!=-1){
_721=_721.substring(0,_721.indexOf("#"));
}
var st=null;
if(_721&&_721!=null&&(_721.indexOf("nst=")==0||_721.indexOf("&nst=")>=0)){
var temp=_721.substr(_721.indexOf("nst=")+4);
var _724="";
if(temp.indexOf("&")>0){
st=temp.substring(0,temp.indexOf("&"));
}else{
st=temp;
}
st=unescape(st);
}else{
return null;
}
return st;
},_sortData:function(_725){
var arr=[];
for(var i in _725){
_725[i].wid=i;
var _728=_725[i];
arr.push(_728);
}
var _729=function(a,b){
return (a.params.lm-b.params.lm);
};
arr.sort(_729);
return arr;
},_getLength:function(obj){
var _72d=0;
for(var i in obj){
_72d++;
}
return _72d;
},_isEmpty:function(obj){
for(var i in obj){
return false;
}
return true;
},_contains:function(_731,obj){
if(obj[_731]){
return true;
}
return false;
},_filterData:function(data,_734,_735){
if(!_735){
for(var i in data){
if(this._contains(i,_734)==false){
delete data[i];
}
}
return data;
}
for(var i in data){
if(this._contains(i,_734)==false&&this._contains(i,_735)==true){
delete data[i];
}
}
return data;
},preprocess:function(_737,_738){
if(this.bIsLoggable==true){
this.LOGGER.entering("preprocess");
if(_737&&_737!=null){
this.LOGGER.trace("preprocess","state is "+dojo.toJson(_737));
}
}
var _739=com.ibm.mashups.enabler.model.state.CookieManager;
var temp=_739.getState();
if(!_737.pid&&temp.pid&&temp.pid!=null&!_737.sid){
_737.pid=temp.pid;
}
if(!_737.sid&&temp.sid&&temp.sid!=null){
_737.sid=temp.sid;
}
if(!_737.pageselection&&temp.pageselection&&temp.pageselection!=null){
_737.pageselection=temp.pageselection;
}
if(!_737.wparams){
_737.wparams={};
}
var _73b=_737.wparams;
var _73c=temp.wparams;
for(var i in _73c){
var _73e=i;
var _73f=_73c[i];
var _740=_73b[_73e];
if(_740&&_740!=null){
_73f=dojo.mixin(_73f,dojo.clone(_740));
_73b[_73e]=_73f;
}else{
_73b[_73e]=_73f;
}
}
if(_738){
_738(_737);
}
if(!_738){
return _737;
}
},postprocess:function(_741,_742,_743){
var _744=com.ibm.mashups.enabler.model.state.CookieManager;
for(var i in _741){
if(i=="pid"||i=="sid"||i=="pageselection"){
_744.setState(i,_741[i]);
}
if(i=="wparams"&&_741[i]&&_741[i]!=null){
var _746={};
var _747=_741[i];
for(j in _747){
var _748=_747[j];
var wID=j;
var _74a={};
if(_748!=null&&_748.value&&_748.value!=null){
if(_748.value.rp&&_748.value.rp!=null){
var _74b=this._filterData(dojo.clone(_748.value.rp),this.persistencePSTORE);
if(this._isEmpty(_74b)==false){
_74a.value=_74a.value?_74a.value:{};
_74a.value.rp=_74b;
}
}
if(_748.value.cp&&_748.value.cp!=null){
var _74c=this._filterData(dojo.clone(_748.value.cp),this.persistencePSTORE);
if(this._isEmpty(_74c)==false){
_74a.value=_74a.value?_74a.value:{};
_74a.value.cp=_74c;
}
}
if(this._isEmpty(_74a)==false){
if(_748.params&&_748.params!=null){
_74a.params=_748.params;
}
_746[wID]=_74a;
}
}
}
_744.setState("wparams",_746);
}
}
_744.commit();
if(_742){
_742(_741);
}
if(!_742){
return _741;
}
}});
dojo.declare("com.ibm.mm.enabler.model.state.NavigationStateProcessorFactoryImpl",null,{constructor:function(){
},getProcessor:function(){
return new com.ibm.mm.enabler.model.state.NavigationStateProcessorImpl();
}});
com.ibm.mashups.enabler.model.state.NavigationStateProcessorFactory=new com.ibm.mm.enabler.model.state.NavigationStateProcessorFactoryImpl();
dojo.declare("com.ibm.mm.enabler.model.state.NavigationStateNodeImpl",[com.ibm.mashups.enabler.model.state.NavigationStateNode],{constructor:function(_74d,key,_74f,id,ref){
this.model=_74d;
this.key=key;
this.value=_74f;
if(id){
this.id=id;
}
if(ref){
this.ref=ref;
}
},setID:function(id){
this.id=id;
},setRef:function(ref){
this.ref=ref;
},getID:function(){
return this.id;
},getRef:function(){
return this.ref;
},getKey:function(){
return this.key;
},getValue:function(){
return this.value;
},get:function(){
return dojo.clone(this._ref);
},set:function(_754){
this.ref=_754;
this.model.setDirty(true);
}});
dojo.declare("com.ibm.mm.enabler.model.state.NavigationStateModelImpl",[com.ibm.mashups.enabler.model.state.NavigationStateModel],{DELIMITER:"#",ROOT:"ROOT",DELETE_TOKEN:"DELETE_TOKEN",constructor:function(_755){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
this.processor=com.ibm.mashups.enabler.model.state.NavigationStateProcessorFactory.getProcessor();
if(_755){
this._state=_755;
this._loaded=true;
}else{
this._loaded=false;
this.processor.decode(window.location.href,dojo.hitch(this,"_preprocess"));
}
},_getFullUrl:function(cb,_757){
return this.processor.generateUrl(this._state,cb,_757);
},clone:function(){
var _758=dojo.clone(this._state);
return new com.ibm.mm.enabler.model.state.NavigationStateModelImpl(_758);
},_preprocess:function(_759){
if(this.bIsLoggable==true){
this.LOGGER.entering("_preprocess");
if(_759&&_759!=null){
this.LOGGER.trace("_preprocess","state:"+dojo.toJson(_759));
}
}
this.processor.preprocess(_759,dojo.hitch(this,"_initializeState"));
},_initializeState:function(_75a){
if(this.bIsLoggable==true){
this.LOGGER.entering("_initializeState");
if(_75a&&_75a!=null){
this.LOGGER.trace("_initializeState","state:"+dojo.toJson(_75a));
}
}
this._state=_75a;
this._stateInternal=dojo.clone(_75a);
this._rootNode=new com.ibm.mm.enabler.model.state.NavigationStateNodeImpl(this,this.ROOT,this._state,this.ROOT,this._state);
this._isDirty=false;
this._dirtyProperties={};
this._loaded=true;
},_postprocess:function(_75b){
this.processor.encode(_75b,dojo.hitch(this,"_finishCommit"),this._stateInternal);
},_finishCommit:function(_75c){
window.location.hash="#"+_75c;
if(this._isDirty==true){
var _75d=com.ibm.mashups.services.ServiceManager.getService("eventService");
_75d.publishEvent(this.ONNAVSTATEUPDATED);
}
this._isDirty=false;
this._stateInternal=dojo.clone(this._state);
delete this._dirtyProperties;
this._dirtyProperties={};
if(this._deferred){
var _75e=this._deferred;
if(_75e&&_75e.finishedCallback2){
if(_75e.finishedCallback2){
_75e.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_75e.finishedCallbackParameters2);
}
}
delete this._deferred;
}
},setDirty:function(_75f,_760){
this._isDirty=_75f;
if(_760){
this._dirtyProperties[_760]=_760;
}
},isDirty:function(){
return this._isDirty;
},_find:function(id){
if(typeof (id)=="undefined"||id==null){
return null;
}
if(id==this.ROOT){
return this._rootNode;
}else{
var _762=this._findReference(id);
if(_762!=null){
var _763=new com.ibm.mm.enabler.model.state.NavigationStateNodeImpl(this);
_763.setID(id);
_763.setRef(_762);
return _763;
}
}
return null;
},create:function(_764){
var key=_764.key?_764.key:null;
var _766=_764.value?_764.value:null;
var _767=new com.ibm.mm.enabler.model.state.NavigationStateNodeImpl(this,key,_766);
return _767;
},insert:function(_768,_769){
var _76a=_769.getRef();
var key=_768.getKey();
var _76c=_768.getValue();
if(_76c==null){
_76c={};
}
var _76d=_769.getID();
_76a[key]=_76c;
return;
},_getIndex:function(_76e){
var _76f=0;
for(var i in _76e){
_76f++;
}
return _76f;
},remove:function(_771){
var id=_771.getID();
var arr=id.split("#");
if(arr.length==1){
if(this._state[id]){
delete this._state[id];
}
}
if(arr.length>1){
var key=id.substring(id.lastIndexOf("#")+1);
var _775=id.substring(0,id.lastIndexOf("#"));
var _776=this._find(_775);
if(_776!=null){
var ref=_776.getRef();
if(ref[key]){
delete ref[key];
}
}
}
return;
},_getRoot:function(){
return this._rootNode;
},_findReference:function(id){
if(id==this.ROOT){
return this._state;
}
var _779=false;
var arr=id.split("#");
var node=this._state;
for(var i in arr){
var j=arr[i];
_779=false;
if(this._findMatch(node,j)==true){
node=node[j];
_779=true;
}else{
break;
}
}
if(_779==false){
return null;
}
return node;
},_findMatch:function(node,key){
if(node[key]&&node[key]!=null){
return true;
}
return false;
},commit:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._commit);
},_commit:function(_780,sync){
this._deferred=_780;
if(this._isDirty==true&&(!this._pagemode||(this._pagemode&&this._pagemode!="edit"))){
this.processor.postprocess(this._state,dojo.hitch(this,this._postprocess),this._stateInternal);
}
},discard:function(){
this._state=dojo.clone(this._stateInternal);
this._isDirty=false;
},_getPageMode:function(){
if(!this._pagemode){
return null;
}
return this._pagemode;
},_setPageMode:function(_782){
if(_782&&_782!=null){
this._pagemode=_782;
}
},dispose:function(){
this._state=null;
this._stateInternal=null;
this._rootNode=null;
this._isDirty=null;
this._dirtyProperties=null;
this._loaded=null;
this.processor.dispose();
}});
dojo.declare("com.ibm.mm.enabler.model.state.NavigationStateModelFactoryImpl",null,{constructor:function(){
},getNavigationStateModel:function(){
if(!this.navigationstatemodel){
this.navigationstatemodel=new com.ibm.mm.enabler.model.state.NavigationStateModelImpl();
}
return this.navigationstatemodel;
}});
com.ibm.mashups.enabler.model.state.NavigationStateModelFactory=new com.ibm.mm.enabler.model.state.NavigationStateModelFactoryImpl();
dojo.declare("com.ibm.mm.enabler.model.state.WidgetAccessorImpl",[com.ibm.mashups.enabler.model.state.WidgetAccessor],{constructor:function(_783,id){
this.navStateModel=_783;
this.wid=id;
this.widgetNavStateNode=_783._find(this.WIDGET_PREFIX+this.navStateModel.DELIMITER+id);
},WIDGET_PREFIX:"wparams",WIDTH:"w",HEIGHT:"h",WINDOWSTATE:"st",SYSTEMSTATE:"rp",CUSTOMSTATE:"cp",MIN:"min",MAX:"max",NORMAL:"normal",VALUE:"value",PARAMS:"params",getWidgetID:function(){
return this.wid;
},getWidgetStateSet:function(){
var _785=null;
if(!this.widgetNavStateNode||this.widgetNavStateNode==null){
return null;
}
var data=this.widgetNavStateNode.getRef();
if(data!=null&&data[this.VALUE]&&data[this.VALUE]!=null){
if(data[this.VALUE][this.CUSTOMSTATE]&&data[this.VALUE][this.CUSTOMSTATE]!=null){
_785=data[this.VALUE][this.CUSTOMSTATE];
}
}
return _785;
},_createWidgetNavStateNode:function(){
var _787=this.navStateModel.create({key:this.wid});
var _788=this.navStateModel._find(this.WIDGET_PREFIX);
if(_788==null){
var temp=this.navStateModel.create({key:this.WIDGET_PREFIX});
this.navStateModel.insert(temp,this.navStateModel._getRoot());
_788=this.navStateModel._find(this.WIDGET_PREFIX);
}
this.navStateModel.insert(_787,_788);
_787=this.navStateModel._find(this.WIDGET_PREFIX+this.navStateModel.DELIMITER+this.wid);
return _787;
},setWidgetStateSet:function(_78a){
var _78b=null;
if(this.widgetNavStateNode==null){
this.widgetNavStateNode=this._createWidgetNavStateNode();
}
var data=this.widgetNavStateNode.getRef();
data.params=data.params?data.params:{};
data.params.lm=new Date().getTime();
if(data!=null&&data[this.VALUE]&&data[this.VALUE]!=null){
if(data[this.VALUE][this.CUSTOMSTATE]&&data[this.VALUE][this.CUSTOMSTATE]!=null){
_78b=dojo.clone(data[this.VALUE][this.CUSTOMSTATE]);
}
}
data[this.VALUE]=data[this.VALUE]?data[this.VALUE]:{};
var obj=_78a;
if(_78b!=null&&dojo.isString(_78a)==false){
obj=dojo.mixin(_78b,_78a);
}
data[this.VALUE][this.CUSTOMSTATE]=obj;
this.navStateModel.setDirty(true);
return;
},getWidgetState:function(key){
if(key&&key!=null&&key=="cp"){
return this.getWidgetStateSet();
}
var _78f=null;
if(!this.widgetNavStateNode||this.widgetNavStateNode==null){
return null;
}
var data=this.widgetNavStateNode.getRef();
if(data!=null&&data[this.VALUE]&&data[this.VALUE]!=null){
if(data[this.VALUE][this.SYSTEMSTATE]&&data[this.VALUE][this.SYSTEMSTATE]!=null){
data=data[this.VALUE][this.SYSTEMSTATE];
if(data!=null&&data[key]&&data[key]!=null){
_78f=data[key];
}
}
}
return _78f;
},setWidgetState:function(key,_792){
if(key&&key!=null&&key=="cp"){
return this.setWidgetStateSet(_792);
}
if(!this.widgetNavStateNode||this.widgetNavStateNode==null){
this.widgetNavStateNode=this._createWidgetNavStateNode();
}
var data=this.widgetNavStateNode.getRef();
data.params=data.params?data.params:{};
data.params.lm=new Date().getTime();
var _794=null;
data[this.VALUE]=data[this.VALUE]?data[this.VALUE]:{};
data[this.VALUE][this.SYSTEMSTATE]=data[this.VALUE][this.SYSTEMSTATE]?data[this.VALUE][this.SYSTEMSTATE]:{};
_794=data[this.VALUE][this.SYSTEMSTATE];
_794[key]=_792;
this.navStateModel.setDirty(true);
return;
},removeWidgetState:function(key){
if(!this.widgetNavStateNode||this.widgetNavStateNode==null){
return;
}
var data=this.widgetNavStateNode.getRef();
data.params=data.params?data.params:{};
data.params.lm=new Date().getTime();
if(key&&key!=null&&key=="cp"){
if(data!=null&&data[this.VALUE]&&data[this.VALUE]!=null&&data[this.VALUE][this.CUSTOMSTATE]&&data[this.VALUE][this.CUSTOMSTATE]!=null){
data[this.VALUE][this.CUSTOMSTATE]=null;
this.navStateModel.setDirty(true);
}
return;
}
if(data!=null&&data[this.VALUE]&&data[this.VALUE]!=null&&data[this.VALUE][this.SYSTEMSTATE]&&data[this.VALUE][this.SYSTEMSTATE]!=null){
var _797=data[this.VALUE][this.SYSTEMSTATE];
if(_797!=null&&_797[key]&&_797[key]!=null){
_797[key]=null;
this.navStateModel.setDirty(true);
return;
}
}
return;
},getWindowState:function(){
rc=this.getWidgetState(this.WINDOWSTATE);
rc=rc?rc:this.NORMAL;
return rc;
},setWindowState:function(_798){
if(_798&&_798!=null&&(_798==this.MIN||_798==this.MAX||_798==this.NORMAL)){
return this.setWidgetState(this.WINDOWSTATE,_798);
}
},getSize:function(){
var size={};
var _79a=this.getWidgetState(this.HEIGHT);
var _79b=this.getWidgetState(this.WIDTH);
if(_79a&&_79a!=null){
size[this.HEIGHT]=_79a;
}
if(_79b&&_79b!=null){
size[this.WIDTH]=_79b;
}
if(!size[this.HEIGHT]&&!size[this.WIDTH]){
return null;
}
return size;
},setSize:function(_79c,_79d){
if(_79c&&_79c!=null){
this.setWidgetState(this.WIDTH,_79c);
}
if(_79d&&_79d!=null){
this.setWidgetState(this.HEIGHT,_79d);
}
return;
}});
dojo.declare("com.ibm.mm.enabler.model.state.PageAccessorImpl",[com.ibm.mashups.enabler.model.state.PageAccessor],{constructor:function(_79e,_79f){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(this.bIsLoggable==true){
this.LOGGER.entering("constructor");
this.LOGGER.trace("constructor","spaceId:"+_79f);
}
this.navStateModel=_79e;
if(_79f){
this.spaceid=_79f;
}
},getPageID:function(){
var _7a0=this.navStateModel._state;
var rc=null;
if(typeof _7a0=="undefined"||_7a0==null){
return null;
}
if(!this.spaceid){
if(_7a0["pid"]){
if(this.bIsLoggable==true){
this.LOGGER.trace("getPageID","No required pace is defined, return Pageid"+_7a0["pid"].value);
}
return _7a0["pid"].value;
}
if(this.bIsLoggable==true){
this.LOGGER.trace("getPageID","No required space is defined, no pid is defined in state  return null");
}
return null;
}else{
if(_7a0["pageselection"]&&_7a0["pageselection"][this.spaceid]){
if(this.bIsLoggable==true){
this.LOGGER.trace("getPageID","return pid:"+_7a0["pageselection"][this.spaceid]+" for space:"+this.spaceid);
}
return _7a0["pageselection"][this.spaceid].value;
}
if(this.bIsLoggable==true){
this.LOGGER.trace("getPageID","No page is found for required space "+this.spaceid+" return null");
}
return null;
}
if(this.bIsLoggable==true){
this.LOGGER.trace("getPageID","return null");
}
return null;
},setPageID:function(_7a2){
if(this.bIsLoggable==true){
this.LOGGER.trace("setPageID","pageId:"+_7a2);
}
var _7a3=this.navStateModel._state;
if(typeof _7a3=="undefined"||_7a3==null){
this.navStateModel._state={};
_7a3=this.navStateModel._state;
}
if(!_7a2||(_7a2&&_7a2==null)){
_7a3["pid"]=null;
if(this.spaceid&&this.spaceid!=null){
if(_7a3["pageselection"]&&_7a3["pageselection"]!=null&&_7a3["pageselection"][this.spaceid]&&_7a3["pageselection"][this.spaceid]!=null){
_7a3["pageselection"][this.spaceid]=null;
}
}
return;
}
var lm=new Date().getTime();
_7a3["pid"]=_7a3["pid"]?_7a3["pid"]:{};
_7a3["pid"].value=_7a2;
_7a3["pid"]["params"]=_7a3["pid"]["params"]?_7a3["pid"]["params"]:{};
_7a3["pid"]["params"].lm=lm;
if(this.spaceid&&this.spaceid!=null){
if(!_7a3["pageselection"]){
_7a3["pageselection"]={};
}
if(!_7a3["pageselection"][this.spaceid]){
_7a3["pageselection"][this.spaceid]={};
}
_7a3["pageselection"][this.spaceid].value=_7a2;
_7a3["pageselection"][this.spaceid]["params"]=_7a3["pageselection"][this.spaceid]["params"]?_7a3["pageselection"][this.spaceid]["params"]:{};
_7a3["pageselection"][this.spaceid]["params"].lm=lm;
}
this.navStateModel.setDirty(true,"pid");
}});
dojo.declare("com.ibm.mm.enabler.model.state.PageModeAccessorImpl",[com.ibm.mashups.enabler.model.state.PageModeAccessor],{constructor:function(_7a5){
this.navStateModel=_7a5;
},getPageMode:function(){
var _7a6=this.navStateModel._getPageMode();
if(!_7a6){
return null;
}
return _7a6;
},setPageMode:function(mode){
if(mode&&mode!=null){
this.navStateModel._setPageMode(mode);
}
return;
}});
dojo.declare("com.ibm.mm.enabler.model.state.SpaceAccessorImpl",[com.ibm.mashups.enabler.model.state.SpaceAccessor],{constructor:function(_7a8){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(this.bIsLoggable==true){
this.LOGGER.entering("constructor");
}
this.navStateModel=_7a8;
},getSpaceID:function(){
var _7a9=this.navStateModel._state;
if(typeof _7a9=="undefined"||_7a9==null){
return null;
}
if(_7a9["sid"]&&_7a9["sid"]!=null&&_7a9["sid"]["value"]&&_7a9["sid"]["value"]!=null){
if(this.bIsLoggable==true){
this.LOGGER.trace("getSpaceID","sid:"+_7a9["sid"]["value"]);
}
return _7a9["sid"]["value"];
}
if(this.bIsLoggable==true){
this.LOGGER.trace("getSpaceID","sid:null");
}
return null;
},setSpaceID:function(_7aa){
if(this.bIsLoggable==true){
this.LOGGER.trace("setSpaceID","sid:"+_7aa);
}
var _7ab=this.navStateModel._state;
if(typeof _7ab=="undefined"||_7ab==null){
this.navStateModel._state={};
_7ab=this.navStateModel._state;
}
var lm=new Date().getTime();
_7ab["sid"]=_7ab["sid"]?_7ab["sid"]:{};
_7ab["sid"].value=_7aa;
_7ab["sid"]["params"]=_7ab["sid"]["params"]?_7ab["sid"]["params"]:{};
_7ab["sid"]["params"].lm=lm;
this.navStateModel.setDirty(true,"sid");
}});
dojo.declare("com.ibm.mm.enabler.model.state.AccessorFactoryImpl",null,{constructor:function(){
},getPageAccessor:function(_7ad,_7ae){
return new com.ibm.mm.enabler.model.state.PageAccessorImpl(_7ad,_7ae);
},getPageModeAccessor:function(_7af){
return new com.ibm.mm.enabler.model.state.PageModeAccessorImpl(_7af);
},getSpaceAccessor:function(_7b0){
return new com.ibm.mm.enabler.model.state.SpaceAccessorImpl(_7b0);
},getWidgetAccessor:function(_7b1,_7b2){
return new com.ibm.mm.enabler.model.state.WidgetAccessorImpl(_7b1,_7b2);
}});
com.ibm.mashups.enabler.model.state.AccessorFactory=new com.ibm.mm.enabler.model.state.AccessorFactoryImpl();
dojo.declare("com.ibm.mm.enabler.model.state.UrlGeneratorImpl",com.ibm.mashups.enabler.model.state.UrlGenerator,{constructor:function(){
},getUrl:function(_7b3,_7b4,_7b5){
if(typeof _7b3=="undefined"&&_7b3!=null){
return null;
}
var _7b6=_7b3.clone();
return _7b6._getFullUrl(_7b4,_7b5);
}});
dojo.declare("com.ibm.mm.enabler.model.state.UrlGeneratorFactoryImpl",com.ibm.mashups.enabler.model.state.UrlGeneratorFactory,{constructor:function(){
this._urlGenerator=new com.ibm.mm.enabler.model.state.UrlGeneratorImpl();
},getUrlGenerator:function(){
return this._urlGenerator;
}});
com.ibm.mashups.enabler.model.state.UrlGeneratorFactory=new com.ibm.mm.enabler.model.state.UrlGeneratorFactoryImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.shared"]){
dojo._hasResource["com.ibm.mm.enabler.model.shared"]=true;
dojo.provide("com.ibm.mm.enabler.model.shared");
dojo.declare("com.ibm.mm.enabler.ModelImpl",com.ibm.mashups.enabler.Model,{constructor:function(){
this.strategy=null;
},setStrategy:function(_7b7){
if(_7b7 instanceof Array){
this.strategy=_7b7;
}else{
this.strategy=new Array();
this.strategy[0]=_7b7;
}
},getStrategies:function(){
return this.strategies;
},addStrategy:function(_7b8){
if(null==this.strategy){
this.strategy=new Array(_7b8);
}
var _7b9=this.strategy.length;
this.strategy[_7b9]=_7b8;
return _7b9;
},removeStrategy:function(_7ba){
if(null==this.strategy){
return;
}else{
if((_7ba)&&(_7ba<this.strategy.length)&&(_7ba>=0)){
this.strategy[_7ba]=null;
}
}
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.factory"]){
dojo._hasResource["com.ibm.mm.enabler.model.factory"]=true;
dojo.provide("com.ibm.mm.enabler.model.factory");
dojo.declare("com.ibm.mm.enabler.model.FactoryImpl",null,{constructor:function(){
},getCatalogCategoryModel:function(){
return new com.ibm.mm.enabler.model.CatalogCategoryModelImpl();
},getNavigationModel:function(){
return com.ibm.mm.enabler.model.NavigationModelImpl.prototype.getInstance();
},getSharedNavigationModel:function(){
return com.ibm.mm.enabler.model.SharedNavigationModelImpl.prototype.getInstance();
},getThemeModel:function(){
return com.ibm.mm.enabler.model.ThemeModelImpl.prototype.getInstance();
},getUserModel:function(){
return com.ibm.mm.enabler.model.UserModelImpl.prototype.getInstance();
},getRemoteModel:function(){
return new com.ibm.mm.enabler.model.RemoteModelImpl();
},getSpaceModel:function(){
return new com.ibm.mm.enabler.model.SpaceModelImpl();
},getTemplateModel:function(){
return new com.ibm.mm.enabler.model.TemplateModelImpl();
},getSpaceExtensionModel:function(){
return new com.ibm.mm.enabler.model.SpaceExtensionModelImpl();
}});
com.ibm.mashups.enabler.model.Factory=new com.ibm.mm.enabler.model.FactoryImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.services.ModelRestServiceRequest"]){
dojo._hasResource["com.ibm.mm.enabler.services.ModelRestServiceRequest"]=true;
dojo.provide("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.declare("com.ibm.mm.enabler.services.ModelRestServiceRequest",null,{REQUEST_METHOD_POST:"POST",REQUEST_METHOD_PUT:"PUT",REQUEST_METHOD_DELETE:"DELETE",POST_ACTION_HEADER:"X-Method-Override",MODIFICATION_COOKIE:"modified.id",constructor:function(_7bb,_7bc,_7bd,_7be,sync){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest.constructor",_7bb,_7bc,_7bd,_7be,sync);
this._feedURI=_7bb.toProxifiedString();
this._textOnly=_7be;
this._sync=sync;
this._formNode=_7bc;
this._formFilter=_7bd;
this._config=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
if(!this._sync){
this._sync=false;
}
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest.constructor");
},create:function(feed,_7c1,_7c2){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest.create",_7c1,_7c2);
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.create","feed:"+feed);
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.create","Attempting to retrieve: "+this._feedURI+"; synchronously? "+this._sync);
this._updateCookie();
var me=this;
var args={url:this._feedURI,headers:{"If-Modified-Since":"Thu, 1 Jan 1970 00:00:00 GMT","Content-Type":"application/atom+xml"},load:function(_7c5,_7c6){
var xhr=_7c6.xhr;
var data=_7c5;
var _7c9=xhr.getResponseHeader("Content-Type");
if(typeof _7c9!="undefined"&&_7c9!==null&&_7c9.indexOf("text/html")>=0){
me._doLogin();
return;
}
if(dojo.isIE){
data=dojox.xml.parser.parse(xhr.responseText);
_7c1("load",data,xhr,_7c2);
}else{
_7c1("load",data,xhr,_7c2);
}
},error:function(_7ca,_7cb){
var xhr=_7cb.xhr;
var _7cd=xhr.status;
if(_7cd==401){
me._doLogin();
return;
}
},sync:this._sync,postData:feed,handleAs:"xml"};
dojo.rawXhrPost(args);
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest.create");
},read:function(_7ce,_7cf){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest.read",_7ce,_7cf);
if(this._textOnly){
this._retrieveRawFeed(_7ce,_7cf);
}else{
this._retrieve(_7ce,_7cf);
}
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest.read");
},update:function(feed,_7d1,_7d2){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest.update",_7d1);
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update","feed:"+feed);
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update","Attempting to retrieve: "+this._feedURI+"; synchronously? "+this._sync);
this._updateCookie();
var me=this;
var args={url:this._feedURI,load:function(_7d5,_7d6){
var data=_7d5;
var xhr=_7d6.xhr;
var _7d9=xhr.getResponseHeader("Content-Type");
if(typeof _7d9!="undefined"&&_7d9!==null&&_7d9.indexOf("text/html")>=0){
me._doLogin();
return;
}
if(dojo.isIE){
data=dojox.xml.parser.parse(xhr.responseText);
_7d1("load",data,xhr,_7d2);
}else{
_7d1("load",data,xhr,_7d2);
}
},error:function(_7da,_7db){
var xhr=_7db.xhr;
var _7dd=xhr.status;
if(_7dd==401){
me._doLogin();
return;
}
},sync:this._sync,handleAs:"xml"};
var _7de={"If-Modified-Since":"Thu, 1 Jan 1970 00:00:00 GMT","Content-Type":"application/atom+xml"};
if(com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.TUNNEL_MODE)===true){
_7de[this.POST_ACTION_HEADER]=this.REQUEST_METHOD_PUT;
args.headers=_7de;
args.postData=feed;
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update","TUNNELMODE",true);
dojo.rawXhrPost(args);
}else{
args.putData=feed;
args.headers=_7de;
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update","TUNNELMODE",false);
dojo.rawXhrPut(args);
}
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest.update");
},remove:function(_7df,_7e0){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest.remove",_7df);
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.remove","Attempting to retrieve: "+this._feedURI+"; synchronously? "+this._sync);
this._updateCookie();
var me=this;
var args={url:this._feedURI,load:function(_7e3,_7e4){
var type="load";
var data=_7e3;
var xhr=_7e4.xhr;
var _7e8=xhr.getResponseHeader("Content-Type");
if(typeof _7e8!="undefined"&&_7e8!==null&&_7e8.indexOf("text/html")>=0){
me._doLogin();
return;
}
if(dojo.isIE){
data=dojox.xml.parser.parse(xhr.responseText);
_7df(type,data,xhr,_7e0);
}else{
_7df(type,data,xhr,_7e0);
}
},error:function(_7e9,_7ea){
var xhr=_7ea.xhr;
var _7ec=xhr.status;
if(_7ec==401){
me._doLogin();
return;
}
},sync:this._sync,handleAs:"xml"};
var _7ed={"If-Modified-Since":"Thu, 1 Jan 1970 00:00:00 GMT","Content-Type":"application/atom+xml"};
if(com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.TUNNEL_MODE)===true){
_7ed[this.POST_ACTION_HEADER]=this.REQUEST_METHOD_DELETE;
args.headers=_7ed;
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update","TUNNELMODE",true);
dojo.rawXhrPost(args);
}else{
args.headers=_7ed;
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update","TUNNELMODE",false);
dojo.xhrDelete(args);
}
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.remove","sync:",args.sync);
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest.remove");
},_retrieveRawFeed:function(_7ee,_7ef){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest._retrieveRawFeed",_7ee,_7ef);
dojo.xhrGet({url:this._feedURI,headers:{"If-Modified-Since":"Thu, 1 Jan 1970 00:00:00 GMT"},load:function(data,_7f1){
_7ee(com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD,data,_7f1.xhr,_7ef);
},error:function(data,_7f3){
_7ee(com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR,data,_7f3.xhr,_7ef);
},sync:this._sync});
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest._retrieveRawFeed");
},_retrieve:function(_7f4,_7f5,_7f6,_7f7){
com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest._retrieve",_7f4,_7f5,_7f6,_7f7);
var _7f8={};
var mt="xml";
if(dojo.isIE){
mt="text";
}
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest._retrieve","Attempting to retrieve: "+this._feedURI+"; synchronously? "+this._sync);
var me=this;
var args={url:this._feedURI,content:_7f8,headers:{"If-Modified-Since":"Thu, 1 Jan 1970 00:00:00 GMT"},load:function(_7fc,_7fd){
var data=_7fc;
var xhr=_7fd.xhr;
var _800=xhr.getResponseHeader("Content-Type");
if(typeof _800!="undefined"&&_800!==null&&_800.indexOf("text/html")>=0){
me._doLogin();
return;
}
if(dojo.isIE){
var doc=com.ibm.mm.enabler.dom.createDocument(data);
_7f4(com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD,doc,xhr,_7f5);
}else{
_7f4(com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD,data,xhr,_7f5);
}
},error:function(_802,_803){
var data=_802;
var xhr=_803.xhr;
var _806=xhr.status;
if(_806==401){
me._doLogin();
return;
}
if(dojo.isIE){
var doc=com.ibm.mm.enabler.dom.createDocument(data);
_7f4(com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR,doc,xhr,_7f5);
}else{
_7f4(com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR,data,xhr,_7f5);
}
},sync:this._sync,handleAs:mt};
var _808="Get";
if(this._formNode){
args.form=this._formNode;
_808="Post";
}
if(this._formFilter){
args.formFilter=this._formFilter;
}
com.ibm.mm.enabler.debug.log("ModelRestServiceRequest._retrieve","sync:",args.sync);
dojo["xhr"+_808](args);
com.ibm.mm.enabler.debug.exit("ModelRestServiceRequest._retrieve");
},_updateCookie:function(){
var dt=new Date();
var _80a={};
_80a.path=this._config.getValue(com.ibm.mm.enabler.services.CONFIG_SERVICE.CONTEXT_ROOT_MAIN);
dojo.cookie(this.MODIFICATION_COOKIE,dt.getTime(),_80a);
},_doLogin:function(){
var pid=null;
var url=document.location.href;
var cb=function(url){
if(url&&url!=null){
top.location.href=url;
}
};
var _80f=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
com.ibm.mashups.enabler.model.state.UrlGeneratorFactory.getUrlGenerator().getUrl(_80f,cb,{nohash:"true"});
},toString:function(){
return this._feedURI;
}});
com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD="load";
com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR="error";
dojo.declare("com.ibm.mm.enabler.services.XHRModelHeaderExtensionImpl",null,{LOG_LEVEL:com.ibm.mashups.enabler.logging.LogLevel.TRACE,constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_METHOD="dojo.xhr()";
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
this.originalDojoXHR=dojo.xhr;
dojo.xhr=dojo.hitch(this,function(_810,args,_812){
if(this.bIsLoggable){
this.LOGGER.entering(this.LOG_METHOD,[_810,args,_812]);
}
if(!args.headers){
args.headers={};
}
args.headers["X-IBM-XHR"]="true";
if(this.bIsLoggable){
this.LOGGER.trace(this.LOG_METHOD,"Adding X-IBM-XHR header");
}
var ret=this.originalDojoXHR(_810,args,_812);
if(this.bIsLoggable){
this.LOGGER.exiting(this.LOG_METHOD);
}
return ret;
});
}});
com.ibm.mm.enabler.services.XHRModelHeaderExtension=new com.ibm.mm.enabler.services.XHRModelHeaderExtensionImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.url"]){
dojo._hasResource["com.ibm.mm.enabler.model.url"]=true;
dojo.provide("com.ibm.mm.enabler.model.url");
dojo.declare("com.ibm.mm.enabler.model.url.ModelUrlFactoryImpl",[com.ibm.mashups.enabler.model.url.ModelUrlFactory],{WEBDAV_URL:"webdav",constructor:function(){
this.schemeMap={};
this.schemeMap[this.NAVIGATION_URL]="nm";
this.schemeMap[this.SHARED_NAVIGATION_URL]="snm";
this.schemeMap[this.FRAGMENT_URL]="fragment";
this.schemeMap[this.FRAGMENT_MEDIA_URL]="fragment-media";
this.schemeMap[this.USER_URL]="um";
this.schemeMap[this.THEME_URL]="theme";
this.schemeMap[this.THEME_MEDIA_URL]="theme-media";
this.schemeMap[this.CATALOG_URL]="catalog";
this.schemeMap[this.CONFIG_URL]="config";
this.schemeMap[this.SPACE_URL]="space";
this.schemeMap[this.SPACE_FAVORITE_URL]="space-favorite";
this.schemeMap[this.AC_URL]="ac";
this.schemeMap[this.AI_URL]="ai";
this.schemeMap[this.TEMPLATE_URL]="template";
this.schemeMap["service"]="service";
this.schemeMap[this.WEBDAV_URL]="dav:mmdav";
},createModelUrl:function(_814,_815){
var _816="createModelUrl(urlType, model)";
var _817=com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
if(_817){
com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.entering(_816,[_814,_815]);
}
var _818=com.ibm.mashups.enabler.model.url.ModelUrlFactory.schemeMap[_814];
if(_817){
com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.trace(_816,"modelSchema found for specified urlType: ${0}",_814);
}
if(!_818){
return null;
}
var _819;
if(_814==this.THEME_MEDIA_URL){
_819=new com.ibm.mm.enabler.model.url.ThemeResourceUrlImpl(_818,_815);
}else{
if(_814==this.FRAGMENT_MEDIA_URL){
_819=new com.ibm.mm.enabler.model.url.SchemeBasedModelMediaUrlImpl(_818,_815);
}else{
_819=new com.ibm.mm.enabler.model.url.SchemeBasedModelUrlImpl(_818,_815);
}
}
if(_817){
com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.exiting(_816,_819);
}
return _819;
},getModelUrl:function(url,_81b){
return new com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl(url,_81b);
}});
dojo.declare("com.ibm.mm.enabler.model.url.BaseModelUrl",[com.ibm.mashups.enabler.model.url.ModelUrl],{modelSchema:null,schemeSpecific:null,isMediaUrl:false,httpUrl:null,VALUE:"value",IS_ID:"isID",SUBMODEL:"submodel",constructor:function(){
this.nodes=[];
this.prefix=null;
this.subModelSchemeMap={};
this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_RESOURCE]="resource";
this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE]="role";
this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_MEMBER]="member";
this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ACCESS]="access";
},_loadPrefix:function(){
if(this.prefix==null){
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
this.prefix=this.serviceJson.idprefix;
}
},setPrimaryNode:function(_81c,isID,_81e){
if(typeof internal=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.model.url.ModelUrl.setPrimaryNode","This method must not be used anymore. Use setNodes instead.");
}
var _81f={};
_81f.value=_81c;
_81f.isID=(isID!=null)?isID:true;
_81f.subModel=_81e;
this.nodes[0]=_81f;
this._updateURI();
},setSecondaryNode:function(_820,isID,_822){
if(typeof internal=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.model.url.ModelUrl.setSecondaryNode","This method must not be used anymore. Use setNodes instead.");
}
var _823={};
_823.value=_820;
_823.isID=(isID!=null)?isID:true;
_823.subModel=_822;
this.nodes[1]=_823;
this._updateURI();
},setNodes:function(_824){
this.nodes=_824;
for(var i=0;i<_824.length;i++){
_824[i].isID=(_824[i].isID!=null)?_824[i].isID:true;
}
this._updateURI();
},setSchemeSpecificPart:function(_826){
this.nodes=[];
this.schemeSpecific=_826;
this._updateURI();
},getSchemeSpecificPart:function(){
if(this.schemeSpecific!=null){
return this.schemeSpecific;
}
var _827="";
if(this.isMediaUrl){
_827="/";
}
if(!this.nodes){
return _827;
}
if(this.isMediaUrl){
for(var i=0;i<this.nodes.length;i++){
var node=this.nodes[i];
if(node.isID&&!this.prefix){
this._loadPrefix();
}
if(i>0){
if(i<this.nodes.length-1){
_827+="@";
}else{
_827+="/";
}
}
_827+=node.value;
}
}else{
for(var i=0;i<this.nodes.length;i++){
var node=this.nodes[i];
if(node.isID&&!this.prefix){
this._loadPrefix();
}
if(_827!=""){
_827+="@";
}
if(node.subModel){
_827+=this.subModelSchemeMap[node.subModel]+":";
}
if(node.isID){
_827+=this.prefix+":";
}
_827+=node.value;
}
}
return _827;
},_updateURI:function(){
var uri=this.modelSchema+":"+this.getSchemeSpecificPart();
this.httpUrl.setParameter("uri",uri);
},addParameter:function(name,_82c){
this.httpUrl.addParameter(name,_82c);
},setParameter:function(name,_82e){
this.httpUrl.setParameter(name,_82e);
},getParameter:function(name){
return this.httpUrl.getParameter(name);
},getParameters:function(){
return this.httpUrl.getParameters();
},getAbsoluteURL:function(){
return this.httpUrl.toString();
},getProxifiedAbsoluteURL:function(){
return this.httpUrl.toProxifiedString();
},getModelURI:function(){
return this.httpUrl.getParameter("uri");
},toProxifiedString:function(){
return this.httpUrl.toProxifiedString();
}});
dojo.declare("com.ibm.mm.enabler.model.url.SchemeBasedModelUrlImpl",[com.ibm.mm.enabler.model.url.BaseModelUrl],{constructor:function(_830,_831){
this.modelSchema=_830;
this.model=_831;
var _832=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var url="";
url+=_832.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);
var _834=_832.getValue(com.ibm.mashups.enabler.services.ConfigConstants.ANONYMOUS_USER);
var _835;
if(_834){
_835=_832.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PUBLIC);
}else{
_835=_832.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PRIVATE);
}
url+=_835;
this.httpUrl=new com.ibm.mm.enabler.utilities.HttpUrl(url);
this.httpUrl.setParameter("uri",this.modelSchema);
}});
dojo.declare("com.ibm.mm.enabler.model.url.SchemeBasedModelMediaUrlImpl",[com.ibm.mm.enabler.model.url.SchemeBasedModelUrlImpl],{constructor:function(_836,_837){
this.isMediaUrl=true;
}});
dojo.declare("com.ibm.mm.enabler.model.url.ThemeResourceUrlImpl",[com.ibm.mm.enabler.model.url.BaseModelUrl],{constructor:function(_838,_839){
this.modelSchema=_838;
this.model=_839;
this.httpUrl=new com.ibm.mm.enabler.utilities.HttpUrl("/");
this.httpUrl.setParameter("uri",this.modelSchema);
},_updateURI:function(){
if(this.nodes.length==2){
var _83a=this.nodes[0].value;
var _83b=this.nodes[1].value;
var _83c=this.model.find(_83a).start();
var url=_83c._getBaseUrl();
this.httpUrl=new com.ibm.mm.enabler.utilities.HttpUrl(url+_83b);
}else{
if(this.nodes.length==3){
var _83e=this.nodes[0].value;
var _83a=this.nodes[1].value;
var _83b=this.nodes[2].value;
var _83f=this.model.find(_83e).start();
var url=_83f._getBaseUrl();
this.httpUrl=new com.ibm.mm.enabler.utilities.HttpUrl(url+_83b);
}else{
this.httpUrl=new com.ibm.mm.enabler.utilities.HttpUrl("/");
}
}
}});
dojo.declare("com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl",[com.ibm.mm.enabler.model.url.BaseModelUrl],{constructor:function(url,_841){
if(!com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT){
com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);
com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PRIVATE_HANDLER=com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT+com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PRIVATE);
com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PUBLIC_HANDLER=com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT+com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PUBLIC);
}
if(url.indexOf("?")==0){
var _842=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.ANONYMOUS_USER);
var _843;
if(_842){
_843=com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PUBLIC_HANDLER;
}else{
_843=com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PRIVATE_HANDLER;
}
var _844="";
_844+=_843;
url=_844+url;
}
this.httpUrl=new com.ibm.mm.enabler.utilities.HttpUrl(url);
}});
com.ibm.mm.enabler.model.UrlFactory=new com.ibm.mm.enabler.model.url.ModelUrlFactoryImpl();
com.ibm.mashups.enabler.model.url.ModelUrlFactory=com.ibm.mm.enabler.model.UrlFactory;
com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.model.UrlFactory");
}
if(!dojo._hasResource["com.ibm.mm.enabler.servicedocument"]){
dojo._hasResource["com.ibm.mm.enabler.servicedocument"]=true;
dojo.provide("com.ibm.mm.enabler.servicedocument");
dojo.require("dojox.xml.parser");
dojo.require("com.ibm.mashups.enabler.xml");
dojo.require("com.ibm.mm.enabler.xml");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.declare("com.ibm.mm.enabler.model.ServiceDocumentModelImpl",null,{SERVICE_NAVIGATION:"navigation",SERVICE_SPACE_NAVIGATION:"space-navigation",SERVICE_SHARED_NAVIGATION:"shared-navigation",SERVICE_CONTENT:"content",SERVICE_CATALOG:"catalog",SERVICE_RESOURCE:"resource",SERVICE_WIDGET:"widget",SERVICE_THEME:"theme",SERVICE_USER:"user",SERVICE_MODEL:"model",SERVICE_MULTIPART:"multipart",SERVICE_HUFFMAN:"huffman",SERVICE_SITEMAP:"sitemap",SERVICE_COMPOSITE:"composite-applications",SERVICE_SPACE:"application",SERVICE_SPACE_FAVORITE:"application-favorite",SERVICE_TEMPLATE:"template",SERVICE_CONFIG:"config",SERVICE_FILESTORE:"filestore",SERVICE_WEBDAV:"webdav",constructor:function(){
this.prefix="service";
this.ns={"atom":"http://www.w3.org/2005/Atom","app":"http://www.w3.org/2007/app","service":"http://www.ibm.com/xmlns/prod/sw/model/service/1.0"};
this.xmlData=null;
this.xmlDataAsString=null;
this.cache=[];
},getInstance:function(){
var _845=com.ibm.mm.enabler.model.ServiceDocumentModelImpl._instance;
return _845?_845:(com.ibm.mm.enabler.model.ServiceDocumentModelImpl._instance=new com.ibm.mm.enabler.model.ServiceDocumentModelImpl());
},_loadAhead:function(){
if(ibmConfig.servicedocument!=null){
if(this.xmlDataAsString!=ibmConfig.servicedocument){
this.xmlData=null;
}
}
if(this.xmlData!=null){
return;
}
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.ServiceDocumentModelImpl._loadAhead");
if(ibmConfig.servicedocument!=null){
this.xmlData=dojox.xml.parser.parse(ibmConfig.servicedocument);
this.xmlDataAsString=ibmConfig.servicedocument;
}else{
var _846;
if(ibmConfig.serviceDocumentUrl!=null){
_846=new com.ibm.mm.enabler.utilities.HttpUrl(ibmConfig.serviceDocumentUrl);
}else{
_846=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl("service",null);
_846.setNodes([{value:"collection",isID:false}]);
}
var _847=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_846,null,null,false,true);
_847.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
this.xmlData=data;
}else{
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
}
}
}));
}
this._fillCache();
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.ServiceDocumentModelImpl._loadAhead");
},_fillCache:function(){
var _84c=[];
var expr="//app:collection";
var _84e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
for(var i=0;i<_84e.length;++i){
var _850=this._processCollection(i,_84e[i]);
if(_850){
this.cache[this.cache.length]=_850;
}
}
var expr="//service:collection";
var _84e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
for(var i=0;i<_84e.length;++i){
var _850=this._processCollection(i,_84e[i]);
if(_850){
this.cache[this.cache.length]=_850;
}
}
},getModelCollections:function(){
this._loadAhead();
var ret=[];
var _852=0;
var expr="//atom:category[@term='enabler-ns-base']";
var _854=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
for(var i=0;i<_854.length;++i){
var _856=_854[i].parentNode;
var _857="//atom:category[not (@term='enabler-ns-base' or @term='enabler-ns-model' or @term='enabler-ns-ext' or @term='enabler-ns-creationcontext' or @term='mashups')]";
var _858=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_857,_856,this.ns);
if(_858&&_858.length>0){
var _859=[];
for(var ii=0;ii<_858.length;++ii){
if(_858[ii].parentNode==_856){
_859.push(_858[ii].getAttribute("term"));
}
}
_859.sort();
var dup=this._isDuplicate(ret,_859);
if(!dup){
ret[_852]=_859;
_852++;
}
}
}
return ret;
},_isDuplicate:function(_85c,_85d){
var dup=false;
for(var ii=0;ii<_85c.length;ii++){
if(_85c[ii].length==_85d.length){
var _860=true;
for(var c=0;c<_85d.length;c++){
if(_85c[ii][c]!=_85d[c]){
_860=false;
break;
}
}
if(_860){
dup=true;
break;
}
}
}
return dup;
},getMashupsCollections:function(){
this._loadAhead();
var ret=[];
var _863=0;
var expr="//atom:category[@term='mashups']";
var _865=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
for(var i=0;i<_865.length;++i){
var _867=_865[i].parentNode;
var _868="//atom:category[not (@term='enabler-ns-base' or @term='enabler-ns-model' or @term='enabler-ns-ext' or @term='enabler-ns-creationcontext' or @term='mashups')]";
var _869=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_868,_867,this.ns);
if(_869&&_869.length>0){
var _86a=[];
for(var ii=0;ii<_869.length;++ii){
if(_869[ii].parentNode==_867){
_86a.push(_869[ii].getAttribute("term"));
}
}
_86a.sort();
var dup=this._isDuplicate(ret,_86a);
if(!dup){
ret[_863]=_86a;
_863++;
}
}
}
return ret;
},getCollectionData:function(_86d){
this._loadAhead();
var ret={};
if(this.xmlData==null){
return ret;
}
var ids=[];
if(dojo.isArray(_86d)){
ids=_86d;
}else{
ids=[_86d];
}
ret=this._getCachedValue(ids);
return ret;
},_getCachedValue:function(ids){
var _871=[];
for(var i=0;i<this.cache.length;i++){
var _873=this.cache[i].id;
var _874=0;
for(j=0;j<_873.length;j++){
if(_873[j]=="mashups"){
_874+=500;
}
for(m=0;m<ids.length;m++){
if(_873[j]==ids[m]){
_874+=1000;
}
}
}
var _875=this.cache[i].version;
_875=_875.replace(/\./g,"");
_874+=parseInt(_875);
_871[i]=_874;
}
var _876=-1;
var _877=1000;
for(var i=0;i<_871.length;i++){
if(_871[i]>_877){
_876=i;
_877=_871[i];
}
}
if(_876==-1){
return null;
}
return this.cache[_876];
},_processCollection:function(i,node){
var ret={};
var _87b="app:categories//atom:category[@term]";
var _87c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_87b,node,this.ns);
var _87d=[];
if(_87c){
for(var jj=0;jj<_87c.length;jj++){
var term=_87c[jj].getAttribute("term");
if(term.indexOf("enabler-ns-")==0){
continue;
}
_87d.push(term);
}
}
ret["id"]=_87d;
ret["url"]=node.getAttribute("href");
ret["version"]=com.ibm.mm.enabler.utilities.getAttributeWithNS(node,"service:version","version",this.ns.service);
if(!ret["version"]){
ret["version"]="1.0";
}
ret["template"]=com.ibm.mm.enabler.utilities.getAttributeWithNS(node,"service:template","template",this.ns.service);
ret["idprefix"]="id";
var ns={};
var _87b="app:categories/atom:category[@term='enabler-ns-base']";
var _87c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_87b,node,this.ns);
if(_87c&&_87c.length>0){
ns["base"]=_87c[0].getAttribute("scheme");
if(ns["base"].indexOf("/mashups/")==-1){
ret["idprefix"]="oid";
}
}
var _87b="app:categories/atom:category[@term='enabler-ns-model']";
var _87c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_87b,node,this.ns);
if(_87c&&_87c.length>0){
ns["model"]=_87c[0].getAttribute("scheme");
}
var _87b="app:categories/atom:category[@term='enabler-ns-ext']";
var _87c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_87b,node,this.ns);
if(_87c&&_87c.length>0){
ns["ext"]=_87c[0].getAttribute("scheme");
}
var _87b="app:categories/atom:category[@term='enabler-ns-creationcontext']";
var _87c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_87b,node,this.ns);
if(_87c&&_87c.length>0){
ns["creation-context"]=_87c[0].getAttribute("scheme");
}
ret["namespaces"]=ns;
var _87b="app:accept";
var _87c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_87b,node,this.ns);
if(_87c&&_87c.length>0){
ret["accept"]=_87c[0].firstChild.nodeValue;
}
return ret;
}});
com.ibm.mm.enabler.model.ServiceDocumentModel=com.ibm.mm.enabler.model.ServiceDocumentModelImpl.prototype.getInstance();
}
if(!dojo._hasResource["com.ibm.mm.enabler.deferred"]){
dojo._hasResource["com.ibm.mm.enabler.deferred"]=true;
dojo.provide("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mashups.enabler.model.shared");
dojo.declare("com.ibm.mm.enabler.DeferredImpl",com.ibm.mashups.enabler.Deferred,{constructor:function(_881,_882,_883){
this.context=_881;
this.startfn=_882;
this.params=_883;
},addErrorCallback:function(_884,_885){
this.errorCallback=_884;
this.errorCallbackParameters=_885;
},addFinishedCallback:function(_886,_887){
this.finishedCallback=_886;
this.finishedCallbackParameters=_887;
},setFinishedCallback:function(_888,_889){
this.finishedCallback2=_888;
this.finishedCallbackParameters2=_889;
},start:function(sync){
var mode=(sync||typeof (sync)=="undefined")?true:false;
return dojo.hitch(this.context,this.startfn)(this,mode,this.params);
}});
dojo.declare("com.ibm.mm.enabler.DeferredOperationImpl",[com.ibm.mashups.enabler.DeferredOperation,com.ibm.mm.enabler.DeferredImpl],{setOperationCallback:function(_88c,_88d){
this.operationCallback=_88c;
this.operationCallbackParameters=_88d;
}});
dojo.declare("com.ibm.mm.enabler.DeferredIteratorImpl",[com.ibm.mashups.enabler.DeferredIterator,com.ibm.mm.enabler.DeferredImpl],{setForeachCallback:function(_88e,_88f){
this.foreachCallback=_88e;
this.foreachCallbackParameters=_88f;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.utils"]){
dojo._hasResource["com.ibm.mm.enabler.model.utils"]=true;
dojo.provide("com.ibm.mm.enabler.model.utils");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.servicedocument");
dojo.declare("com.ibm.mm.enabler.model.NameSpaceFactoryImpl",null,{constructor:function(){
this.NS_APP="app";
this.NS_ATOM="atom";
this.NS_THR="thr";
this.NS_UM="um";
this.NS_XHTML="xhtml";
this.NS_XML="xml";
this.NS_XSI="xsi";
this.NS_OPENSEARCH="opensearch";
this.NS_CM="cm";
this.NS_CA="ca";
this.NS_CREATION_CONTEXT="creation-context";
this.NS_AC="ac";
this.namespaces={};
this.namespaces[this.NS_APP]="http://www.w3.org/2007/app";
this.namespaces[this.NS_ATOM]="http://www.w3.org/2005/Atom";
this.namespaces[this.NS_THR]="http://purl.org/syndication/thread/1.0";
this.namespaces[this.NS_UM]="http://www.ibm.com/xmlns/prod/websphere/um.xsd";
this.namespaces[this.NS_XHTML]="http://www.w3.org/1999/xhtml";
this.namespaces[this.NS_XML]="http://www.w3.org/XML/1998/namespace";
this.namespaces[this.NS_XSI]="http://www.w3.org/2001/XMLSchema-datatypes";
this.namespaces[this.NS_OPENSEARCH]="http://a9.com/-/spec/opensearch/1.1/";
this.namespaces[this.NS_CM]="http://www.ibm.com/xmlns/prod/composite-applications/v1.0";
this.namespaces[this.NS_CA]="http://www.ibm.com/xmlns/prod/composite-applications/v1.0";
this.namespaces[this.NS_AC]="http://www.ibm.com/xmlns/prod/lotus/access-control/v1.0";
},getNameSpaces:function(_890){
var _891={};
var len=_890.length;
for(i=0;i<len;i++){
var name=_890[i];
_891[name]=this.namespaces[name];
}
return _891;
},getNameSpaceUri:function(_894){
return this.namespaces[_894];
}});
com.ibm.mm.enabler.model.NameSpaceFactory=new com.ibm.mm.enabler.model.NameSpaceFactoryImpl();
dojo.declare("com.ibm.mm.enabler.model.HttpStatusCodesImpl",null,{constructor:function(){
this.HTTP_CONTINUE="100";
this.HTTP_SWITCHING_PROTOCOLS="101";
this.HTTP_OK="200";
this.HTTP_CREATED="201";
this.HTTP_NOT_FOUND="404";
this.HTTP_REQUEST_TIMEOUT="408";
this.HTTP_INTERNAL_SERVER_ERROR="500";
this.HTTP_SERVICE_UNAVAILABLE="503";
}});
dojo.declare("com.ibm.mm.enabler.model.UtilsImpl",null,{constructor:function(){
this.serviceJson=null;
},_lazyInit:function(){
if(this.serviceJson){
return;
}
this.xmlDom=com.ibm.mm.enabler.dom.createDocument();
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},createNode:function(name,ns){
this._lazyInit();
return com.ibm.mm.enabler.dom.createElement(this.xmlDom,name,ns);
},createLinkNode:function(href,rel,ns){
var _89b=this.createNode("atom:link",ns);
_89b.setAttribute("href",href);
_89b.setAttribute("rel",rel);
return _89b;
},createExtLinkNode:function(href,rel,_89e){
this._lazyInit();
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
var _8a0=this.createNode("atom:link",this.ns[nsf.NS_ATOM]);
_8a0.setAttribute("href",href);
if(rel){
_8a0.setAttribute("rel",rel);
}
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom,_8a0,"ext:rel","rel",this.ns["ext"],_89e);
return _8a0;
},getIdFromExtUri:function(_8a1,node){
this._lazyInit();
var id=null;
var uri=com.ibm.mm.enabler.utilities.getAttributeWithNS(node,"ext:uri","uri",this.ns["ext"]);
if(uri){
var aPos=uri.indexOf("@");
if(aPos!=-1){
uri=uri.slice(0,aPos);
}
id=uri;
var _8a6=id.lastIndexOf(":");
if(_8a6!=-1){
id=id.slice(_8a6+1);
}
var _8a6=id.toUpperCase().lastIndexOf("%3A");
if(_8a6!=-1){
id=id.slice(_8a6+3);
}
_8a6=id.lastIndexOf("/");
if(_8a6!=-1){
id=id.slice(_8a6+1);
}
}
return id;
},getHrefFromIdentifiable:function(_8a7){
return (_8a7&&(typeof _8a7._getParameters=="function"))?_8a7._getParameters().href:null;
},getIdFromIdentifiable:function(_8a8){
return (_8a8 instanceof com.ibm.mashups.enabler.Identifiable)?_8a8.getID():_8a8;
},setAttributeWithNS:function(_8a9,_8aa,_8ab,_8ac){
this._lazyInit();
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom,_8a9,_8aa,null,_8ab,_8ac);
},createFeed:function(id,_8ae,_8af,_8b0){
var ns="";
for(prefix in _8b0){
ns+="xmlns:"+prefix+"=\""+_8b0[prefix]+"\" ";
}
var time=new Date();
var feed="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+"<atom:feed "+ns+" >\n"+"<atom:title>"+_8ae+"</atom:title>\n"+"<atom:id>"+id+"</atom:id>\n"+"<atom:updated>"+time.toGMTString()+"</atom:updated>\n"+_8af+"</atom:feed>";
return feed;
},checkForEndpoints:function(url){
if(!url){
return null;
}
var _8b5=url.toString();
if(_8b5){
var _8b6=_8b5.indexOf("endpoint://",0);
if(_8b6==0){
var _8b7=_8b5.indexOf("/",11);
if(_8b7>0){
var _8b8=_8b5.substring(11,_8b7);
var _8b9=_8b5.substring(_8b7+1);
var _8ba=this._resolveEndpoint(_8b8);
if(_8ba.charAt(_8ba.length-1)=="/"){
_8b5=_8ba+_8b9;
}else{
_8b5=_8ba+"/"+_8b9;
}
return _8b5;
}
}else{
if(_8b6>0){
var _8bb=_8b5.substring(0,_8b6);
var _8bc=_8b5.substring(_8b6);
var _8bd=this.checkForEndpoints(_8bc);
if(_8bd!=null){
return _8bb+_8bd.substring(1);
}
}
}
}
return null;
},_resolveEndpoint:function(_8be){
if(!this.cs){
this.cs=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
}
if(!this.co){
this.co=this.cs.getConfigObject(this.cs.ENDPOINT_CONFIG_PROVIDER);
}
var url=this.co.getValue(decodeURIComponent(_8be)+".url");
if((url)&&(url.charAt(0)!="/")&&(url.substr(0,4)!="http")){
url="/"+url;
}
return url;
}});
dojo.declare("com.ibm.mm.enabler.model.NavigationNodeFactoryImpl",null,{constructor:function(){
this.serviceJson=null;
},_lazyInit:function(){
if(this.serviceJson){
return;
}
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},createNavigationNode:function(_8c1){
this._lazyInit();
var _8c2=null;
var _8c3="atom:link[@ext:class='content-node']";
var _8c4=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_8c3,_8c1,this.ns);
if(_8c4&&_8c4.length>0){
var _8c5=com.ibm.mm.enabler.utilities.getAttributeWithNS(_8c4[0],"ext:user-own","user-own",this.ns["ext"]);
if(_8c5=="false"){
_8c2=new com.ibm.mm.enabler.navigation.SharedNavigationNodeImpl(_8c1);
}
}
if(!_8c2){
_8c2=new com.ibm.mm.enabler.navigation.NavigationNodeImpl(_8c1);
}
return _8c2;
}});
com.ibm.mm.enabler.model.HttpStatusCodes=new com.ibm.mm.enabler.model.HttpStatusCodesImpl();
com.ibm.mm.enabler.model.Utils=new com.ibm.mm.enabler.model.UtilsImpl();
com.ibm.mm.enabler.model.NavigationNodeFactory=new com.ibm.mm.enabler.model.NavigationNodeFactoryImpl();
}
if(!dojo._hasResource["dojo.io.iframe"]){
dojo._hasResource["dojo.io.iframe"]=true;
dojo.provide("dojo.io.iframe");
dojo.io.iframe={create:function(_8c6,_8c7,uri){
if(window[_8c6]){
return window[_8c6];
}
if(window.frames[_8c6]){
return window.frames[_8c6];
}
var _8c9=null;
var turi=uri;
if(!turi){
if(dojo.config["useXDomain"]&&!dojo.config["dojoBlankHtmlUrl"]){
console.warn("dojo.io.iframe.create: When using cross-domain Dojo builds,"+" please save dojo/resources/blank.html to your domain and set djConfig.dojoBlankHtmlUrl"+" to the path on your domain to blank.html");
}
turi=(dojo.config["dojoBlankHtmlUrl"]||dojo.moduleUrl("dojo","resources/blank.html"));
}
var _8cb=dojo.isIE?"<iframe name=\""+_8c6+"\" src=\""+turi+"\" onload=\""+_8c7+"\">":"iframe";
_8c9=dojo.doc.createElement(_8cb);
with(_8c9){
name=_8c6;
setAttribute("name",_8c6);
id=_8c6;
}
dojo.body().appendChild(_8c9);
window[_8c6]=_8c9;
with(_8c9.style){
if(!(dojo.isSafari<3)){
position="absolute";
}
left=top="1px";
height=width="1px";
visibility="hidden";
}
if(!dojo.isIE){
this.setSrc(_8c9,turi,true);
_8c9.onload=new Function(_8c7);
}
return _8c9;
},setSrc:function(_8cc,src,_8ce){
try{
if(!_8ce){
if(dojo.isWebKit){
_8cc.location=src;
}else{
frames[_8cc.name].location=src;
}
}else{
var idoc;
if(dojo.isIE||dojo.isWebKit>521){
idoc=_8cc.contentWindow.document;
}else{
if(dojo.isSafari){
idoc=_8cc.document;
}else{
idoc=_8cc.contentWindow;
}
}
if(!idoc){
_8cc.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
console.log("dojo.io.iframe.setSrc: ",e);
}
},doc:function(_8d0){
var doc=_8d0.contentDocument||(((_8d0.name)&&(_8d0.document)&&(document.getElementsByTagName("iframe")[_8d0.name].contentWindow)&&(document.getElementsByTagName("iframe")[_8d0.name].contentWindow.document)))||((_8d0.name)&&(document.frames[_8d0.name])&&(document.frames[_8d0.name].document))||null;
return doc;
},send:function(args){
if(!this["_frame"]){
this._frame=this.create(this._iframeName,dojo._scopeName+".io.iframe._iframeOnload();");
}
var dfd=dojo._ioSetArgs(args,function(dfd){
dfd.canceled=true;
dfd.ioArgs._callNext();
},function(dfd){
var _8d6=null;
try{
var _8d7=dfd.ioArgs;
var dii=dojo.io.iframe;
var ifd=dii.doc(dii._frame);
var _8da=_8d7.handleAs;
_8d6=ifd;
if(_8da!="html"){
if(_8da=="xml"){
if(dojo.isIE){
dojo.query("a",dii._frame.contentWindow.document.documentElement).orphan();
var _8db=(dii._frame.contentWindow.document).documentElement.innerText;
_8db=_8db.replace(/>\s+</g,"><");
_8db=dojo.trim(_8db);
var _8dc={responseText:_8db};
_8d6=dojo._contentHandlers["xml"](_8dc);
}
}else{
_8d6=ifd.getElementsByTagName("textarea")[0].value;
if(_8da=="json"){
_8d6=dojo.fromJson(_8d6);
}else{
if(_8da=="javascript"){
_8d6=dojo.eval(_8d6);
}
}
}
}
}
catch(e){
_8d6=e;
}
finally{
_8d7._callNext();
}
return _8d6;
},function(_8dd,dfd){
dfd.ioArgs._hasError=true;
dfd.ioArgs._callNext();
return _8dd;
});
dfd.ioArgs._callNext=function(){
if(!this["_calledNext"]){
this._calledNext=true;
dojo.io.iframe._currentDfd=null;
dojo.io.iframe._fireNextRequest();
}
};
this._dfdQueue.push(dfd);
this._fireNextRequest();
dojo._ioWatch(dfd,function(dfd){
return !dfd.ioArgs["_hasError"];
},function(dfd){
return (!!dfd.ioArgs["_finished"]);
},function(dfd){
if(dfd.ioArgs._finished){
dfd.callback(dfd);
}else{
dfd.errback(new Error("Invalid dojo.io.iframe request state"));
}
});
return dfd;
},_currentDfd:null,_dfdQueue:[],_iframeName:dojo._scopeName+"IoIframe",_fireNextRequest:function(){
try{
if((this._currentDfd)||(this._dfdQueue.length==0)){
return;
}
var dfd=this._currentDfd=this._dfdQueue.shift();
var _8e3=dfd.ioArgs;
var args=_8e3.args;
_8e3._contentToClean=[];
var fn=dojo.byId(args["form"]);
var _8e6=args["content"]||{};
if(fn){
if(_8e6){
var _8e7=function(name,_8e9){
var tn;
if(dojo.isIE){
tn=dojo.doc.createElement("<input type='hidden' name='"+name+"'>");
}else{
tn=dojo.doc.createElement("input");
tn.type="hidden";
tn.name=name;
}
tn.value=_8e9;
fn.appendChild(tn);
_8e3._contentToClean.push(name);
};
for(var x in _8e6){
var val=_8e6[x];
if(dojo.isArray(val)&&val.length>1){
var i;
for(i=0;i<val.length;i++){
_8e7(x,val[i]);
}
}else{
if(!fn[x]){
_8e7(x,val);
}else{
fn[x].value=val;
}
}
}
}
var _8ee=fn.getAttributeNode("action");
var _8ef=fn.getAttributeNode("method");
var _8f0=fn.getAttributeNode("target");
if(args["url"]){
_8e3._originalAction=_8ee?_8ee.value:null;
if(_8ee){
_8ee.value=args.url;
}else{
fn.setAttribute("action",args.url);
}
}
if(!_8ef||!_8ef.value){
if(_8ef){
_8ef.value=(args["method"])?args["method"]:"post";
}else{
fn.setAttribute("method",(args["method"])?args["method"]:"post");
}
}
_8e3._originalTarget=_8f0?_8f0.value:null;
if(_8f0){
_8f0.value=this._iframeName;
}else{
fn.setAttribute("target",this._iframeName);
}
fn.target=this._iframeName;
fn.submit();
}else{
var _8f1=args.url+(args.url.indexOf("?")>-1?"&":"?")+_8e3.query;
this.setSrc(this._frame,_8f1,true);
}
}
catch(e){
dfd.errback(e);
}
},_iframeOnload:function(){
var dfd=this._currentDfd;
if(!dfd){
this._fireNextRequest();
return;
}
var _8f3=dfd.ioArgs;
var args=_8f3.args;
var _8f5=dojo.byId(args.form);
if(_8f5){
var _8f6=_8f3._contentToClean;
for(var i=0;i<_8f6.length;i++){
var key=_8f6[i];
for(var j=0;j<_8f5.childNodes.length;j++){
var _8fa=_8f5.childNodes[j];
if(_8fa.name==key){
dojo.destroy(_8fa);
break;
}
}
}
if(_8f3["_originalAction"]){
_8f5.setAttribute("action",_8f3._originalAction);
}
if(_8f3["_originalTarget"]){
_8f5.setAttribute("target",_8f3._originalTarget);
_8f5.target=_8f3._originalTarget;
}
}
_8f3._finished=true;
}};
}
if(!dojo._hasResource["dojo.i18n"]){
dojo._hasResource["dojo.i18n"]=true;
dojo.provide("dojo.i18n");
dojo.i18n.getLocalization=function(_8fb,_8fc,_8fd){
_8fd=dojo.i18n.normalizeLocale(_8fd);
var _8fe=_8fd.split("-");
var _8ff=[_8fb,"nls",_8fc].join(".");
var _900=dojo._loadedModules[_8ff];
if(_900){
var _901;
for(var i=_8fe.length;i>0;i--){
var loc=_8fe.slice(0,i).join("_");
if(_900[loc]){
_901=_900[loc];
break;
}
}
if(!_901){
_901=_900.ROOT;
}
if(_901){
var _904=function(){
};
_904.prototype=_901;
return new _904();
}
}
throw new Error("Bundle not found: "+_8fc+" in "+_8fb+" , locale="+_8fd);
};
dojo.i18n.normalizeLocale=function(_905){
var _906=_905?_905.toLowerCase():dojo.locale;
if(_906=="root"){
_906="ROOT";
}
return _906;
};
dojo.i18n._requireLocalization=function(_907,_908,_909,_90a){
var _90b=dojo.i18n.normalizeLocale(_909);
var _90c=[_907,"nls",_908].join(".");
var _90d="";
if(_90a){
var _90e=_90a.split(",");
for(var i=0;i<_90e.length;i++){
if(_90b["indexOf"](_90e[i])==0){
if(_90e[i].length>_90d.length){
_90d=_90e[i];
}
}
}
if(!_90d){
_90d="ROOT";
}
}
var _910=_90a?_90d:_90b;
var _911=dojo._loadedModules[_90c];
var _912=null;
if(_911){
if(dojo.config.localizationComplete&&_911._built){
return;
}
var _913=_910.replace(/-/g,"_");
var _914=_90c+"."+_913;
_912=dojo._loadedModules[_914];
}
if(!_912){
_911=dojo["provide"](_90c);
var syms=dojo._getModuleSymbols(_907);
var _916=syms.concat("nls").join("/");
var _917;
dojo.i18n._searchLocalePath(_910,_90a,function(loc){
var _919=loc.replace(/-/g,"_");
var _91a=_90c+"."+_919;
var _91b=false;
if(!dojo._loadedModules[_91a]){
dojo["provide"](_91a);
var _91c=[_916];
if(loc!="ROOT"){
_91c.push(loc);
}
_91c.push(_908);
var _91d=_91c.join("/")+".js";
_91b=dojo._loadPath(_91d,null,function(hash){
var _91f=function(){
};
_91f.prototype=_917;
_911[_919]=new _91f();
for(var j in hash){
_911[_919][j]=hash[j];
}
});
}else{
_91b=true;
}
if(_91b&&_911[_919]){
_917=_911[_919];
}else{
_911[_919]=_917;
}
if(_90a){
return true;
}
});
}
if(_90a&&_90b!=_90d){
_911[_90b.replace(/-/g,"_")]=_911[_90d.replace(/-/g,"_")];
}
};
(function(){
var _921=dojo.config.extraLocale;
if(_921){
if(!_921 instanceof Array){
_921=[_921];
}
var req=dojo.i18n._requireLocalization;
dojo.i18n._requireLocalization=function(m,b,_925,_926){
req(m,b,_925,_926);
if(_925){
return;
}
for(var i=0;i<_921.length;i++){
req(m,b,_921[i],_926);
}
};
}
})();
dojo.i18n._searchLocalePath=function(_928,down,_92a){
_928=dojo.i18n.normalizeLocale(_928);
var _92b=_928.split("-");
var _92c=[];
for(var i=_92b.length;i>0;i--){
_92c.push(_92b.slice(0,i).join("-"));
}
_92c.push(false);
if(down){
_92c.reverse();
}
for(var j=_92c.length-1;j>=0;j--){
var loc=_92c[j]||"ROOT";
var stop=_92a(loc);
if(stop){
break;
}
}
};
dojo.i18n._preloadLocalizations=function(_931,_932){
function preload(_933){
_933=dojo.i18n.normalizeLocale(_933);
dojo.i18n._searchLocalePath(_933,true,function(loc){
for(var i=0;i<_932.length;i++){
if(_932[i]==loc){
dojo["require"](_931+"_"+loc);
return true;
}
}
return false;
});
};
preload();
var _936=dojo.config.extraLocale||[];
for(var i=0;i<_936.length;i++){
preload(_936[i]);
}
};
}
if(!dojo._hasResource["com.ibm.mm.enabler.aspects"]){
dojo._hasResource["com.ibm.mm.enabler.aspects"]=true;
dojo.provide("com.ibm.mm.enabler.aspects");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("com.ibm.mashups.enabler.model");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mm.enabler.model.utils");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("dojo.i18n");
dojo.declare("com.ibm.mm.enabler.EffectiveAccessImpl",[com.ibm.mashups.enabler.ac.EffectiveAccess],{constructor:function(){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns_ac=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_AC]);
this.EDIT_LINK="atom:link[@rel='edit']";
this.XPATH1="atom:content/*/ac:allowed-access";
this.XPATH2="atom:content/*/ac:allowed-access/ac:access-level";
},_init:function(data){
this.xmlData=data;
this.XPATH1="atom:content/ac:allowed-access";
this.XPATH2="atom:content/ac:allowed-access/ac:access-level";
},_hasEditLink:function(){
var _93a=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.EDIT_LINK,this.xmlData,this.ns_ac);
if(_93a&&_93a.length>0){
return true;
}else{
return false;
}
},_hasAllowedAccess:function(){
var _93b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.XPATH1,this.xmlData,this.ns_ac);
if(_93b&&_93b.length>0){
return true;
}else{
return false;
}
},hasRole:function(_93c){
_93c=_93c.toUpperCase();
if(this._hasAllowedAccess()){
var _93d=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.XPATH2,this.xmlData,this.ns_ac);
if(_93d&&_93d.length>0){
for(var i=0;i<_93d.length;i++){
var type=com.ibm.mm.enabler.utilities.getAttributeWithNS(_93d[i],"ac:type","type",this.ns_ac.ac);
if(type){
if(type.toUpperCase()==_93c){
return true;
}
}
}
}
return false;
}else{
if(_93c=="USER"){
return true;
}
return this._hasEditLink();
}
}});
dojo.declare("com.ibm.mm.enabler.AnonymousHelper",null,{constructor:function(){
},_isAnonymous:function(){
if(ibmConfig.anonymousUser){
return true;
}else{
return false;
}
},_isAnonymousLockedOnMode:function(){
var _940=ibmConfig["com.ibm.mashups.anonymous.mode.locked.on"];
if(_940){
return true;
}else{
return false;
}
},_isAnonymousLockedDown:function(){
if(!this._isAnonymous()){
return false;
}
return !this._isAnonymousLockedOnMode();
},_isAnonymousLockedOn:function(){
if(!this._isAnonymous()){
return false;
}
return this._isAnonymousLockedOnMode();
},getAnonymousMode:function(){
if(this._isAnonymousLockedDown()){
return com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS;
}else{
return com.ibm.mashups.enabler.user.AnonymousMode.USER;
}
}});
com.ibm.mm.enabler.AnonymousHelper=new com.ibm.mm.enabler.AnonymousHelper();
dojo.declare("com.ibm.mm.enabler.ConfirmableModelImpl",null,{constructor:function(){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns_ac=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_AC]);
this.helper=com.ibm.mm.enabler.AnonymousHelper;
},getConfirmCreate:function(){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
return true;
},getConfirmInsert:function(){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
return true;
},getConfirmReparent:function(node,_943,next){
if(this.helper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
var _945=true;
if(_943){
_945=_943.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
}
var _946=true;
if(node){
_946=node.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
}
return _946&&_945;
},getConfirmReorder:function(node,_948,next){
if(this.helper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
var _94a=true;
if(next){
_94a=next.hasRole(com.ibm.mashups.enabler.ac.RoleType.USER);
}
var _94b=true;
if(_948){
_94b=_948.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
}
var _94c=true;
if(node){
_94c=node.hasRole(com.ibm.mashups.enabler.ac.RoleType.USER);
}
return _94c&&_94b&&_94a;
},getConfirmRemove:function(node){
if(this.helper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
if(node){
return node.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
}
return false;
}});
dojo.declare("com.ibm.mm.enabler.SubmittableFormProviderImpl",com.ibm.mashups.enabler.SubmittableFormProvider,{constructor:function(){
},getSubmittableForm:function(id){
var _94f=null;
var url;
if(id=="spaceForm"){
url=new com.ibm.mm.enabler.model.UrlFactory.createModelUrl(com.ibm.mm.enabler.model.UrlFactory.SPACE_URL,null);
url.setNodes([{value:"collection",isID:false}]);
url.setParameter("mode","import");
url.setParameter("mime-type","text/html");
if(arguments[1]!=null){
url.setParameter("spaceId",arguments[1]);
}
url=url.toProxifiedString();
_94f=new com.ibm.mm.enabler.SubmittableFormImpl(url,"post",id);
}else{
if(id=="pageForm"){
var _951=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_RESOURCE);
url=new com.ibm.mm.enabler.model.UrlFactory.getModelUrl(_951.url,this);
url.setParameter("mode","import");
url.setParameter("mime-type","text/html");
if(arguments[1]!=null){
url.setParameter("spaceId",arguments[1]);
}
url=url.toProxifiedString();
_94f=new com.ibm.mm.enabler.SubmittableFormImpl(url,"post",id);
}
}
return _94f;
}});
dojo.declare("com.ibm.mm.enabler.SubmittableFormImpl",com.ibm.mashups.enabler.SubmittableForm,{constructor:function(url,_953,_954){
this.url=url;
this.method=_953;
this.formId=_954;
},getURL:function(){
return this.url;
},getMethod:function(){
return this.method;
},submit:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._submit);
},_submit:function(_955){
dojo.io.iframe.send({url:this.url,method:this.method,handleAs:"text",form:document.getElementsByName(this.formId)[0],load:function(data,_957){
if(_955&&_955.finishedCallback2){
_955.finishedCallback2(data,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_CREATED,_955.finishedCallbackParameters2);
}
},error:function(data,_959){
if(_955&&_955.finishedCallback2){
_955.finishedCallback2(data,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_955.finishedCallbackParameters2);
}
}});
}});
dojo.declare("com.ibm.mm.enabler.IdentifiableImpl",com.ibm.mashups.enabler.Identifiable,{constructor:function(){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.id_ns=nsf.getNameSpaces([nsf.NS_ATOM]);
this.ATOM_ID="atom:id";
this.id_serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
this.id_prefix=this.id_serviceJson.idprefix;
},getID:function(){
var _95b=null;
var _95c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ATOM_ID,this.xmlData,this.id_ns);
if(_95c&&_95c.length>0){
var id=com.ibm.mm.enabler.dom.textContent(_95c[0]);
var aPos=id.indexOf("@");
if(aPos!=-1){
id=id.slice(0,aPos);
}
var _95f=id.lastIndexOf(":");
if(_95f!=-1){
id=id.slice(_95f+1);
}
var _95f=id.toUpperCase().lastIndexOf("%3A");
if(_95f!=-1){
id=id.slice(_95f+3);
}
_95f=id.lastIndexOf("/");
if(_95f!=-1){
id=id.slice(_95f+1);
}
_95b=id;
}else{
throw new Error(dojo.string.substitute(me.modelMessages.E_ELEMENT_NOT_FOUND_2,[this.ATOM_ID,this.toString()]));
}
return _95b;
},setID:function(id){
var _961=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ATOM_ID,this.xmlData,this.id_ns);
if(_961&&_961.length>0){
var _962=com.ibm.mm.enabler.dom.textContent(_961[0]);
var aPos=_962.indexOf("@");
var _964=(aPos!=-1)?_962.slice(aPos):"";
var mPos=_962.indexOf(this.id_prefix+":");
var _966=(mPos>0)?_962.slice(0,mPos):"";
var _967=id.indexOf(this.id_prefix+":");
var _968=(_967>=0)?id.slice(_967):this.id_prefix+":"+id;
com.ibm.mm.enabler.dom.textContent(_961[0],_966+_968+_964);
}else{
throw new Error(dojo.string.substitute(me.modelMessages.E_ELEMENT_NOT_FOUND_2,[this.ATOM_ID,this.toString()]));
}
}});
dojo.declare("com.ibm.mm.enabler.TransformableImpl",com.ibm.mashups.enabler.Transformable,{constructor:function(){
},getXml:function(){
return this.xmlData;
},setXml:function(xml){
this.xmlData=xml;
}});
dojo.declare("com.ibm.mm.enabler.LocalizedImpl",[com.ibm.mashups.enabler.Localized,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(){
var _96a=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.li_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML]);
for(p in _96a.namespaces){
this.li_ns[p]=_96a.namespaces[p];
}
this.NLS_TITLE="atom:content/*/model:title/base:nls-string";
this.NLS_TITLE_TOP="atom:content/*/model:title";
this.NLS_DESCRIPTION="atom:content/*/model:description/base:nls-string";
this.NLS_DESCRIPTION_TOP="atom:content/*/model:description";
this.BASE_TITLE="base:nls-string";
this.BASE_DESCRIPTION="base:nls-string";
this.BASE_NS=this.li_ns.base;
},getLocales:function(){
var _96c=[];
var _96d=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_TITLE,this.xmlData,this.li_ns);
if(_96d){
for(var i=0;i<_96d.length;i++){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_96d[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null){
_96c.push(lang);
}
}
}
return _96c;
},getTitle:function(loc){
var _971=null;
var _972=loc.replace(/-/g,"_").toLowerCase();
var _973=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_TITLE,this.xmlData,this.li_ns);
if(_973){
for(var i=0;i<_973.length;i++){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_973[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null&&lang.replace(/-/g,"_").toLowerCase()==_972.toLowerCase()){
_971=com.ibm.mm.enabler.dom.textContent(_973[i]);
break;
}
}
}
return _971;
},getDescription:function(loc){
var _977=null;
var _978=loc.replace(/-/g,"_").toLowerCase();
var _979=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_DESCRIPTION,this.xmlData,this.li_ns);
if(_979){
for(var i=0;i<_979.length;i++){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_979[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null&&lang.replace(/-/g,"_").toLowerCase()==_978.toLowerCase()){
_977=com.ibm.mm.enabler.dom.textContent(_979[i]);
break;
}
}
}
return _977;
},setTitle:function(_97c,loc){
if(_97c!=null&&typeof (_97c)!="undefined"&&loc!=null&&typeof (loc)!="undefined"){
var _97e=com.ibm.mm.enabler.xpath.createXPath(this.NLS_TITLE_TOP,this.xmlData,this.li_ns);
var _97f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.BASE_TITLE,_97e,this.li_ns);
var _980=loc.replace(/-/g,"_").toLowerCase();
var _981=false;
var i=_97f.length;
while(--i>=0){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_97f[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null&&lang.replace(/-/g,"_").toLowerCase()==_980.toLowerCase()){
com.ibm.mm.enabler.dom.textContent(_97f[i],_97c);
_981=true;
break;
}
}
if(!_981){
var _984=this.xmlData.ownerDocument;
var node=com.ibm.mm.enabler.dom.createElement(_984,this.BASE_TITLE,this.BASE_NS);
com.ibm.mm.enabler.utilities.setAttributeWithNS(_984,node,"xml:lang","lang",this.li_ns.xml,loc);
com.ibm.mm.enabler.dom.textContent(node,_97c);
_97e.appendChild(node);
}
}else{
com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.Localized.setTitle","Make sure to not pass in undefined or null parameters.");
}
},confirmSetTitle:function(_986,_987){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},setDescription:function(_988,loc){
if(_988!=null&&typeof (_988)!="undefined"&&loc!=null&&typeof (loc)!="undefined"){
var _98a=com.ibm.mm.enabler.xpath.createXPath(this.NLS_DESCRIPTION_TOP,this.xmlData,this.li_ns);
var _98b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.BASE_DESCRIPTION,_98a,this.li_ns);
var _98c=loc.replace(/-/g,"_").toLowerCase();
var _98d=false;
var i=_98b.length;
while(--i>=0){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_98b[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null&&lang.replace(/-/g,"_").toLowerCase()==_98c.toLowerCase()){
com.ibm.mm.enabler.dom.textContent(_98b[i],_988);
_98d=true;
break;
}
}
if(!_98d){
var _990=this.xmlData.ownerDocument;
var node=com.ibm.mm.enabler.dom.createElement(_990,this.BASE_DESCRIPTION,this.BASE_NS);
com.ibm.mm.enabler.utilities.setAttributeWithNS(_990,node,"xml:lang","lang",this.li_ns.xml,loc);
com.ibm.mm.enabler.dom.textContent(node,_988);
_98a.appendChild(node);
}
}else{
com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.Localized.setDescription","Make sure to not pass in undefined or null parameters.");
}
},confirmSetDescription:function(_992,_993){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
}});
dojo.declare("com.ibm.mm.enabler.MetaDataImpl",[com.ibm.mashups.enabler.MetaData,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(){
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.mdi_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML]);
for(prefix in this.serviceJson.namespaces){
this.mdi_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.MODEL_METADATA="atom:content/*/model:metadata";
this.MODEL_VALUE="model:value";
},getMetadataNames:function(){
return this.getMetaDataNames();
},getMetadata:function(name){
return this.getMetaData(name);
},setMetadata:function(name,_997){
return this.setMetaData(name,_997);
},removeMetadata:function(name){
this.removeMetaData(name);
},getMetaDataNames:function(){
var _999=[];
var expr=this.MODEL_METADATA+"[@name]";
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(md){
for(var i=0;i<md.length;++i){
_999.push(md[i].getAttribute("name"));
}
}
return _999;
},getMetaData:function(name){
var expr=this.MODEL_METADATA+"[@name='"+name+"']/"+this.MODEL_VALUE;
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
return (md&&md.length>0)?md[0].getAttribute("value"):null;
},setMetaData:function(name,_9a1){
var _9a2=null;
var expr=this.MODEL_METADATA+"[@name='"+name+"']/"+this.MODEL_VALUE;
var _9a4=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(_9a4&&_9a4.length>0){
_9a4[0].setAttribute("value",_9a1);
}else{
var _9a5=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/*",this.xmlData,this.mdi_ns);
if(_9a5&&_9a5.length>0){
var _9a6=this.xmlData.ownerDocument;
var _9a7=com.ibm.mm.enabler.dom.createElement(_9a6,"model:metadata",this.mdi_ns.model);
_9a7.setAttribute("name",name);
var _9a8=com.ibm.mm.enabler.dom.createElement(_9a6,this.MODEL_VALUE,this.mdi_ns.model);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,_9a8,"xsi:type","type",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xsi"),"xsd:string");
_9a8.setAttribute("value",_9a1);
_9a5[0].appendChild(_9a7);
_9a7.appendChild(_9a8);
}
}
return _9a2;
},confirmSetMetaData:function(name,_9aa){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},removeMetaData:function(name){
var expr=this.MODEL_METADATA+"[@name='"+name+"']";
var _9ad=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(_9ad&&_9ad.length>0){
var _9ae=_9ad[0].parentNode;
_9ae.removeChild(_9ad[0]);
}
},confirmRemoveMetaData:function(name,_9b0){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
}});
dojo.declare("com.ibm.mm.enabler.MetaDataImpl2",[com.ibm.mashups.enabler.MetaData,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(){
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.mdi_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML]);
for(prefix in this.serviceJson.namespaces){
this.mdi_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.MODEL_METADATA="atom:content/*/model:metadata";
this.BASE_VALUE="base:value";
},getMetadataNames:function(){
return this.getMetaDataNames();
},getMetadata:function(name){
return this.getMetaData(name);
},setMetadata:function(name,_9b4){
return this.setMetaData(name,_9b4);
},removeMetadata:function(name){
this.removeMetaData(name);
},getMetaDataNames:function(){
var _9b6=[];
var expr=this.MODEL_METADATA+"[@name]";
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(md){
for(var i=0;i<md.length;++i){
_9b6.push(md[i].getAttribute("name"));
}
}
return _9b6;
},getMetaData:function(name,_9bb){
var expr=this.MODEL_METADATA+"[@name='"+name+"']/"+this.BASE_VALUE;
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(md&&md.length>0){
var valh=md[0].getAttribute("value");
if(_9bb==true){
var _9bf=com.ibm.mm.enabler.model.Utils.checkForEndpoints(valh);
if(_9bf!=null){
valh=_9bf;
}
}
return valh;
}
return null;
},setMetaData:function(name,_9c1){
var _9c2=null;
var expr=this.MODEL_METADATA+"[@name='"+name+"']/"+this.BASE_VALUE;
var _9c4=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(_9c4&&_9c4.length>0){
_9c4[0].setAttribute("value",_9c1);
}else{
var _9c5=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/*",this.xmlData,this.mdi_ns);
if(_9c5&&_9c5.length>0){
var _9c6=this.xmlData.ownerDocument;
var _9c7=com.ibm.mm.enabler.dom.createElement(_9c6,"model:metadata",this.mdi_ns.model);
_9c7.setAttribute("name",name);
var _9c8=com.ibm.mm.enabler.dom.createElement(_9c6,this.BASE_VALUE,this.mdi_ns.base);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,_9c8,"xsi:type","type",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xsi"),"xsd:string");
_9c8.setAttribute("value",_9c1);
_9c5[0].appendChild(_9c7);
_9c7.appendChild(_9c8);
}
}
return _9c2;
},confirmSetMetaData:function(name,_9ca){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},removeMetaData:function(name){
var expr=this.MODEL_METADATA+"[@name='"+name+"']";
var _9cd=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(_9cd&&_9cd.length>0){
var _9ce=_9cd[0].parentNode;
_9ce.removeChild(_9cd[0]);
}
},confirmRemoveMetaData:function(name){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
}});
dojo.declare("com.ibm.mm.enabler.MetaDataImpl3",[com.ibm.mashups.enabler.MetaData,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(){
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SPACE);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.mdi_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML,nsf.NS_CA]);
for(prefix in this.serviceJson.namespaces){
this.mdi_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.MODEL_METADATA="atom:content/ca:application/ca:meta-data";
this.MODEL_METADATA_BASE="ca:meta-data";
this.NAME_ATTR="ca:name";
},getMetadataNames:function(){
return this.getMetaDataNames();
},getMetadata:function(name){
return this.getMetaData(name);
},setMetadata:function(name,_9d3){
return this.setMetaData(name,_9d3);
},removeMetadata:function(name){
this.removeMetaData(name);
},getMetaDataNames:function(){
var _9d5=[];
var expr=this.MODEL_METADATA+"[@"+this.NAME_ATTR+"]";
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(md){
for(var i=0;i<md.length;++i){
_9d5.push(md[i].getAttribute(this.NAME_ATTR));
}
}
return _9d5;
},getMetaData:function(name){
var expr=this.MODEL_METADATA+"[@"+this.NAME_ATTR+"='"+name+"']";
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
return (md&&md.length>0)?com.ibm.mm.enabler.dom.textContent(md[0]):null;
},setMetaData:function(name,_9dd){
var _9de=null;
var expr=this.MODEL_METADATA+"[@"+this.NAME_ATTR+"='"+name+"']";
var _9e0=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(_9e0&&_9e0.length>0){
com.ibm.mm.enabler.dom.textContent(_9e0[0],_9dd);
}else{
var _9e1=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/*",this.xmlData,this.mdi_ns);
if(_9e1&&_9e1.length>0){
var _9e2=this.xmlData.ownerDocument;
var _9e3=com.ibm.mm.enabler.dom.createElement(_9e2,this.MODEL_METADATA_BASE,this.mdi_ns.ca);
var pos=this.NAME_ATTR.indexOf(":");
var _9e5=this.NAME_ATTR.slice(pos+1);
com.ibm.mm.enabler.utilities.setAttributeWithNS(_9e2,_9e3,this.NAME_ATTR,_9e5,this.mdi_ns.ca,name);
com.ibm.mm.enabler.dom.textContent(_9e3,_9dd);
_9e1[0].appendChild(_9e3);
}
}
return _9de;
},confirmSetMetaData:function(name,_9e7){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},removeMetaData:function(name){
var expr=this.MODEL_METADATA+"[@"+this.NAME_ATTR+"='"+name+"']";
var _9ea=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.mdi_ns);
if(_9ea&&_9ea.length>0){
var _9eb=_9ea[0].parentNode;
_9eb.removeChild(_9ea[0]);
}
},confirmRemoveMetaData:function(name){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
}});
dojo.declare("com.ibm.mm.enabler.EditLinkProviderImpl",null,{constructor:function(node){
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns_elp=nsf.getNameSpaces([nsf.NS_ATOM]);
this.ELP_EDIT_LINK="atom:link[@rel='edit']";
},getEditLink:function(){
var _9ef=null;
var _9f0=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ELP_EDIT_LINK,this.xmlData,this.ns_elp);
if(_9f0&&_9f0.length>0){
_9ef=_9f0[0].getAttribute("href");
}else{
throw new Error(dojo.string.substitute(this.modelMessages.E_ELEMENT_NOT_FOUND_2,[this.ELP_EDIT_LINK,this.toString()]));
}
return _9ef;
}});
dojo.declare("com.ibm.mm.enabler.NextLinkProviderImpl",null,{constructor:function(node){
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns_nlp=nsf.getNameSpaces([nsf.NS_ATOM]);
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
for(prefix in this.serviceJson.namespaces){
this.ns_nlp[prefix]=this.serviceJson.namespaces[prefix];
}
this.NLP_NEXT_LINK="atom:link[@rel='next']";
},_getNextURI:function(){
var _9f3=null;
var _9f4=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLP_NEXT_LINK,this.xmlData,this.ns_nlp);
if(_9f4&&_9f4.length>0){
_9f3=com.ibm.mm.enabler.utilities.getAttributeWithNS(link,"ext:rel","rel",this.ns_nlp["ext"]);
}else{
throw new Error(dojo.string.substitute(this.modelMessages.E_ELEMENT_NOT_FOUND_2,[this.NLP_NEXT_LINK,this.toString()]));
}
return _9f3;
}});
dojo.declare("com.ibm.mm.enabler.ACLinkProviderImpl",null,{constructor:function(){
var _9f5=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns_acrlp=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML,nsf.NS_EXT,nsf.NS_AC,nsf.NS_CA]);
for(prefix in _9f5.namespaces){
this.ns_acrlp[prefix]=_9f5.namespaces[prefix];
}
this.AC_RESOURCE_ATOM_LINK="atom:link[@ext:rel='ac-resource-config']";
this.AC_ROLES_ATOM_LINK="atom:link[@ext:rel='roles']";
this.CA_ROLES_ATOM_LINK="atom:link[@ca:rel='roles']";
this.AC_MEMBERS_ATOM_LINK="atom:link[@ac:rel='members']";
},getACResourceLink:function(_9f7){
var _9f8=null;
var _9f9=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.AC_RESOURCE_ATOM_LINK,_9f7,this.ns_acrlp);
if(_9f9&&_9f9.length>0){
_9f8=_9f9[0].getAttribute("href");
}
return _9f8;
},getACRolesLink:function(_9fa){
var _9fb=null;
var _9fc=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.AC_ROLES_ATOM_LINK,_9fa,this.ns_acrlp);
if(_9fc&&_9fc.length>0){
_9fb=_9fc[0].getAttribute("href");
}
return _9fb;
},getCARolesLink:function(_9fd){
var _9fe=null;
var _9ff=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.CA_ROLES_ATOM_LINK,_9fd,this.ns_acrlp);
if(_9ff&&_9ff.length>0){
_9fe=_9ff[0].getAttribute("href");
}
return _9fe;
},getACMembersLink:function(_a00){
var _a01=null;
var _a02=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.AC_MEMBERS_ATOM_LINK,_a00,this.ns_acrlp);
if(_a02&&_a02.length>0){
_a01=_a02[0].getAttribute("href");
}
return _a01;
}});
dojo.declare("com.ibm.mm.enabler.RepresentationProviderImpl",com.ibm.mashups.enabler.RepresentationProvider,{constructor:function(){
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.r_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML]);
for(prefix in this.serviceJson.namespaces){
this.r_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.XPATH="atom:link";
},getAlternateModel:function(){
var _a04=[];
var md=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.XPATH,this.xmlData,this.r_ns);
if(md&&md.length>0){
for(var i=0;i<md.length;i++){
var link=md[i];
var rel=link.getAttribute("rel");
var _a09=com.ibm.mm.enabler.utilities.getAttributeWithNS(link,"ext:rel","rel",this.r_ns["ext"]);
if(_a09==""){
_a09=null;
}
if(((rel==null)||(rel=="alternate"))&&(_a09==null)){
_a04[_a04.length]=link;
}
}
}
var _a0a=new com.ibm.mm.enabler.RepresentationModelImpl(_a04);
return _a0a;
}});
dojo.declare("com.ibm.mm.enabler.RepresentationModelImpl",[com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.DeferredIteratorImpl],{constructor:function(_a0b){
this.loadedNodes={};
this.entries=[];
this.cursor=0;
this.size=null;
this.start=null;
this.num=null;
this.strategy=null;
if(_a0b&&_a0b.length>0){
this.size=_a0b.length;
for(var i=0;i<_a0b.length;i++){
var link=_a0b[i];
var url=link.getAttribute("href");
var _a0f=link.getAttribute("type");
var uri=_a0f;
var node=new com.ibm.mm.enabler.RepresentationImpl(url,_a0f);
this.entries[i]=uri;
this.loadedNodes[uri]=node;
}
}
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,uri);
},_find:function(_a13,sync,uri){
return this._load(uri,_a13,sync);
},start:function(sync){
while(this._hasNext(this,sync)){
if(this._next(this,sync)){
continue;
}else{
break;
}
}
},hasNext:function(){
return this._hasNext(null,true);
},_hasNext:function(_a17,sync){
if(this.start===null||this.cursor<this.start||(this.cursor>=(this.start+this.num)&&(this.size>this.cursor))){
this._loadAhead(_a17,sync);
}
return (this.size>this.cursor);
},next:function(){
return this._next(null,true);
},_next:function(_a19,sync){
return this._hasNext(_a19,sync)?this.loadedNodes[this.entries[this.cursor++]]:null;
},size:function(){
return this.size;
},setCursorPosition:function(_a1b){
this.cursor=_a1b;
},getCursorPosition:function(){
return this.cursor;
},setStrategy:function(_a1c){
if(_a1c instanceof Array){
this.strategy=_a1c[0];
}else{
this.strategy=_a1c;
}
},_load:function(uri,_a1e,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.RepresentationModelImpl._load",uri,sync?"sync":"async");
if(uri in this.loadedNodes){
if(_a1e&&_a1e.finishedCallback2){
_a1e.finishedCallback2(this.loadedNodes[uri],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_a1e.finishedCallbackParameters2);
}
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.RepresentationModelImpl._load");
return this.loadedNodes[uri];
},_loadAhead:function(_a20,sync){
}});
dojo.declare("com.ibm.mm.enabler.RepresentationImpl",com.ibm.mashups.enabler.Representation,{constructor:function(url,type){
this.url=url;
this.type=type;
},getID:function(){
return this.type;
},getURL:function(){
return this.url;
},getMimeType:function(){
return this.type;
}});
dojo.declare("com.ibm.mm.enabler.IdentifierImpl",com.ibm.mashups.enabler.Identifiable,{constructor:function(id,_a25){
this.id=id;
this.params=_a25;
},getID:function(){
return this.id;
},_getParameters:function(){
return this.params;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.catalog"]){
dojo._hasResource["com.ibm.mm.enabler.model.catalog"]=true;
dojo.provide("com.ibm.mm.enabler.model.catalog");
dojo.require("com.ibm.mm.enabler.aspects");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mashups.enabler.model");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("dojo.i18n");
dojo.declare("com.ibm.mm.enabler.catalog.CatalogCategoryIteratorImpl",com.ibm.mm.enabler.DeferredIteratorImpl,{constructor:function(_a26,_a27){
this.model=_a27;
this.entries=[];
this.cursor=0;
this.sizeValue=null;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CATALOG);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.nextUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.serviceJson.url,this.model);
if(_a27.strategy){
for(x in _a27.strategy){
if(_a27.strategy[x] instanceof com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy){
this.nextUrl.setParameter("num",_a27.strategy[x].getInterval());
break;
}
}
}
this.nextUrl.setParameter("rep","full");
},start:function(sync){
while(this.hasNext(this,sync)){
this.next(this,sync);
}
},hasNext:function(dfr,sync){
if(typeof this.entries[this.cursor]=="undefined"){
this._loadAhead(dfr||null,typeof sync=="undefined"?true:sync);
}
return this.entries[this.cursor]?true:false;
},next:function(dfr,sync){
return this.hasNext(dfr||null,typeof sync=="undefined"?true:sync)?this.model.loadedNodes[this.entries[this.cursor++]]:null;
},setCursorPosition:function(_a2e){
this.cursor=_a2e;
},getCursorPosition:function(){
return this.cursor;
},size:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._size);
},_size:function(dfr,sync){
this.sizeValue!==null||this.hasNext(null,true);
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.sizeValue,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return this.sizeValue;
},_loadAhead:function(_a31,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.catalog.CatalogCategoryIteratorImpl._loadAhead",sync?"sync":"async");
this.nextUrl.setParameter("start",this.getCursorPosition());
this.nextUrl.addParameter("aspect","ac");
var _a33=new com.ibm.mm.enabler.services.ModelRestServiceRequest(this.nextUrl,null,null,false,sync);
_a33.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed/opensearch:totalResults";
var size=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(size&&size.length>0){
this.sizeValue=com.ibm.mm.enabler.dom.textContent(size[0]);
}
var expr="atom:feed/atom:entry";
var _a3a=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_a3a){
for(var i=0;i<_a3a.length;i++){
var node=new com.ibm.mm.enabler.catalog.CatalogCategoryNodeImpl(_a3a[i]);
var id=node.getID();
node.setParentModel(this.model);
this.model._cacheNode(node);
this.entries[this.cursor+i]=id;
if(_a31&&_a31.foreachCallback){
_a31.foreachCallback(this.model.loadedNodes[id],_a31.foreachCallbackParameters);
}
}
}
var expr="atom:feed/atom:link[@rel='next']";
var _a3e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_a3e&&_a3e.length>0){
var href=_a3e[0].getAttribute("href");
this.nextUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,this.model);
}else{
this.entries[this.cursor+_a3a.length]=null;
if(_a31&&_a31.finishedCallback2){
_a31.finishedCallback2(null,xhr.status,_a31.finishedCallbackParameters2);
}
}
}else{
if(_a31&&_a31.finishedCallback2){
_a31.finishedCallback2(null,xhr.status,_a31.finishedCallbackParameters2);
}
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.catalog.CatalogCategoryIteratorImpl._loadAhead");
}});
dojo.declare("com.ibm.mm.enabler.model.CatalogEntryModelImpl",[com.ibm.mashups.enabler.model.CatalogEntryModel,com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.DeferredIteratorImpl,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(_a40,_a41){
this.category=_a40;
this.parentModel=_a41;
this.strategy=_a41.strategy;
this.loadedNodes={};
this.createdNodes={};
this.deletedNodes={};
this.initialContents={};
this.nodeIds=[];
this.cursor=0;
this.length=null;
this.startElem=null;
this.num=null;
this.cid=0;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CATALOG);
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.cemi_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH,nsf.NS_XSI]);
for(prefix in this.serviceJson.namespaces){
this.cemi_ns[prefix]=this.serviceJson.namespaces[prefix];
}
var _a43=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ext:rel='entries']",this.category.xmlData,this.cemi_ns);
this.collectionUrl=_a43[0].getAttribute("href");
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,uri);
},_find:function(_a45,sync,uri){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogEntryModelImpl._find",uri,sync?"sync":"async");
if(this.category.getID()=="CATROOT"){
return null;
}
if(uri in this.deletedNodes){
if(_a45&&_a45.finishedCallback2){
_a45.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_a45.finishedCallbackParameters2);
}
return null;
}
if(uri in this.loadedNodes){
if(_a45&&_a45.finishedCallback2){
if(_a45.finishedCallback2){
_a45.finishedCallback2(this.loadedNodes[uri],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_a45.finishedCallbackParameters2);
}
}else{
return this.loadedNodes[uri];
}
}else{
var _a48=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.CATALOG_URL,this);
_a48.setNodes([{value:com.ibm.mm.enabler.utilities.encodeModelID4Uri(uri),isID:true},{value:com.ibm.mm.enabler.utilities.encodeModelID4Uri(this.category.getID()),isID:true}]);
_a48.setParameter("rep","full");
_a48.addParameter("aspect","ac");
var _a49=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_a48,null,null,false,sync);
var _a4a=null;
var _a4b={};
_a49.read(dojo.hitch(this,function(type,data,xhr,args){
var expr="atom:feed/atom:entry";
var _a51=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.cemi_ns);
if(_a51&&_a51.length>0){
this._cacheNode(new com.ibm.mm.enabler.catalog.CatalogEntryNodeImpl(_a51[0]));
}
if(_a45&&_a45.finishedCallback2){
_a45.finishedCallback2(this.loadedNodes[uri]||null,xhr.status,_a45.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_a4b.status=xhr.status;
}
}
}));
if(_a4b.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_CATNODE_NOTFOUND_1,[uri,_a4b.status]));
}
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogEntryModelImpl._find");
return this.loadedNodes[uri];
},_cacheNode:function(node){
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.initialContents[id]=node.toString();
}
return this.loadedNodes[id];
},iterator:function(){
return this;
},start:function(sync){
while(this._hasNext(this,sync)){
if(this._next(this,sync)){
continue;
}else{
break;
}
}
},hasNext:function(){
return this._hasNext(null,true);
},_hasNext:function(_a55,sync){
if(this.startElem===null||this.cursor<this.startElem||(this.cursor>=(this.startElem+this.num)&&(this.length>this.cursor))){
this._loadAhead(_a55,sync);
}
return (this.length>this.cursor);
},next:function(){
return this._next(null,true);
},_next:function(_a57,sync){
return this._hasNext(_a57,sync)?this.loadedNodes[this.nodeIds[this.cursor++]]:null;
},size:function(){
return this.length;
},setCursorPosition:function(_a59){
this.cursor=_a59;
},getCursorPosition:function(){
return this.cursor;
},_loadAhead:function(_a5a,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogEntryModelImpl._loadAhead",sync?"sync":"async");
var _a5c=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.collectionUrl,this);
_a5c.setParameter("start",this.getCursorPosition());
_a5c.setParameter("rep","full");
_a5c.addParameter("aspect","ac");
if(this.strategy){
for(x in this.strategy){
if(this.strategy[x] instanceof com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy){
_a5c.setParameter("num",this.strategy[x].getInterval());
break;
}
}
}
var _a5d=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_a5c,null,null,false,sync);
_a5d.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
this.startElem=this.getCursorPosition();
var _a62=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/opensearch:totalResults",data,this.cemi_ns);
if(_a62&&_a62.length>0){
this.length=com.ibm.mm.enabler.dom.textContent(_a62[0]);
}
var _a63=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.cemi_ns);
if(_a63){
this.num=_a63.length;
for(var i=0;i<_a63.length;i++){
node=new com.ibm.mm.enabler.catalog.CatalogEntryNodeImpl(_a63[i]);
var id=node.getID();
this.nodeIds[this.startElem+i]=id;
this._cacheNode(node);
if(_a5a&&_a5a.foreachCallback){
_a5a.foreachCallback(this.loadedNodes[id],_a5a.foreachCallbackParameters);
}
}
}
}
if(_a5a&&_a5a.finishedCallback2){
_a5a.finishedCallback2(null,xhr.status,_a5a.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogEntryModelImpl._loadAhead");
},create:function(_a66){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogEntryModelImpl.create");
var _a67;
if(_a66&&_a66.cid){
_a67=_a66.cid;
}else{
_a67=""+this.cid++;
}
var _a68=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.cemi_ns.atom);
var _a69=com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.cemi_ns.atom);
com.ibm.mm.enabler.dom.textContent(_a69,"cid:"+_a67+"@"+this.prefix+":"+this.category.getID());
_a68.appendChild(_a69);
var _a6a=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.cemi_ns.atom);
_a68.appendChild(_a6a);
var _a6b=com.ibm.mm.enabler.model.Utils.createNode("model:catalog-entry",this.cemi_ns.model);
_a6a.appendChild(_a6b);
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createNode("model:title",this.cemi_ns.model));
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createNode("model:description",this.cemi_ns.model));
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createExtLinkNode("",null,"definition"));
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createExtLinkNode("",null,"icon"));
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createExtLinkNode("",null,"preview"));
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createExtLinkNode("",null,"previewThumbnail"));
_a6b.appendChild(com.ibm.mm.enabler.model.Utils.createExtLinkNode("",null,"help"));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogEntryModelImpl.create");
return new com.ibm.mm.enabler.catalog.CatalogEntryNodeImpl(_a68);
},confirmCreate:function(_a6c){
return this.getConfirmCreate();
},insert:function(node,_a6e){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogEntryModelImpl.insert",node.getID());
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.createdNodes[id]=null;
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogEntryModelImpl.insert");
},confirmInsert:function(node,_a71){
return this.getConfirmInsert();
},remove:function(node){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogEntryModelImpl.remove",node);
var id=(node instanceof com.ibm.mm.enabler.catalog.CatalogEntryNodeImpl)?node.getID():node;
if(!(id in this.deletedNodes)){
this.deletedNodes[id]=this.loadedNodes[id];
}
if(id in this.loadedNodes){
delete this.loadedNodes[id];
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogEntryModelImpl.remove");
},confirmRemove:function(node){
return this.getConfirmRemove(node);
},_commit:function(_a75,sync,_a77){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogEntryModelImpl._commit",sync?"sync":"async");
var _a78;
var _a79,_a7a;
for(id in this.loadedNodes){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
var _a7c=com.ibm.mm.enabler.model.Utils.createFeed("catalog:"+id,"IBM Lotus Mashups Catalog Feed",this.loadedNodes[id],this.cemi_ns);
if(id in this.createdNodes){
var _a79=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.collectionUrl,this);
this.parentModel._acquire();
_a78=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_a79,null,null,false,sync);
_a78.create(_a7c,dojo.hitch(this,function(type,data,xhr,args){
if(_a75){
if(_a75.operationCallback){
_a75.operationCallback(this.loadedNodes[args],com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_a75.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_a75.errorCallback){
_a75.errorCallback(xhr.status,_a75.errorCallbackParameters);
}
}else{
this.length++;
}
}
this.parentModel._release(_a75,xhr.status);
}),id);
}else{
if(this.initialContents[id]===this.loadedNodes[id].toString()){
continue;
}
var _a79=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.loadedNodes[id].getEditLink(),this);
_a79.setParameter("update","replace");
this.parentModel._acquire();
_a78=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_a79,null,null,false,sync);
_a78.update(_a7c,dojo.hitch(this,function(type,data,xhr,args){
if(_a75){
if(_a75.operationCallback){
_a75.operationCallback(this.loadedNodes[args],com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_a75.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_a75.errorCallback){
_a75.errorCallback(xhr.status,_a75.errorCallbackParameters);
}
}
}
this.parentModel._release(_a75,xhr.status);
}),id);
this.initialContents[id]=this.loadedNodes[id].toString();
}
this.createdNodes={};
}
for(id in this.deletedNodes){
var _a79=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.deletedNodes[id].getEditLink(),this);
this.parentModel._acquire();
_a78=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_a79,null,null,false,sync);
_a78.remove(dojo.hitch(this,function(type,data,xhr,args){
if(_a75){
if(_a75.operationCallback){
_a75.operationCallback(args,com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_a75.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_a75.errorCallback){
_a75.errorCallback(xhr.status,_a75.errorCallbackParameters);
}
}
}
this.parentModel._release(_a75,xhr.status);
}),id);
}
this.deletedNodes={};
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogEntryModelImpl._commit");
}});
dojo.declare("com.ibm.mm.enabler.model.CatalogCategoryModelImpl",[com.ibm.mashups.enabler.model.CatalogCategoryModel,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(){
this.root=null;
this.loadedNodes={};
this.createdNodes={};
this.deletedNodes={};
this.initialContents={};
this.entryModels={};
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CATALOG);
this.entryUrl=this.serviceJson.url;
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},getCatalogEntryModel:function(_a8a){
if(!(_a8a in this.entryModels)){
this.entryModels[_a8a]=new com.ibm.mm.enabler.model.CatalogEntryModelImpl(_a8a,this);
}
return this.entryModels[_a8a];
},_cacheNode:function(node){
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.initialContents[id]=node.toString();
}
return this.loadedNodes[id];
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,uri);
},_find:function(_a8e,sync,uri){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogCategoryModelImpl._find",uri,sync?"sync":"async");
if(uri in this.deletedNodes){
if(_a8e&&_a8e.finishedCallback2){
_a8e.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_a8e.finishedCallbackParameters2);
}
return null;
}
if(uri in this.loadedNodes){
if(_a8e&&_a8e.finishedCallback2){
_a8e.finishedCallback2(this.loadedNodes[uri],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_a8e.finishedCallbackParameters2);
}
}else{
var _a91=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.CATALOG_URL,this);
_a91.setNodes([{value:com.ibm.mm.enabler.utilities.encodeModelID4Uri(uri),isID:true}]);
_a91.setParameter("rep","full");
_a91.addParameter("aspect","ac");
var _a92=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_a91,null,null,false,sync);
var _a93=null;
var _a94={};
_a92.read(dojo.hitch(this,function(type,data,xhr,args){
var expr="atom:feed/atom:entry";
var _a9a=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_a9a&&_a9a.length>0){
var _a9b=new com.ibm.mm.enabler.catalog.CatalogCategoryNodeImpl(_a9a[0]);
if(_a9b!==null){
_a9b.setParentModel(this);
if(!(uri in this.loadedNodes)){
this.loadedNodes[uri]=_a9b;
this.initialContents[uri]=_a9b.toString();
}
}
}
if(_a8e&&_a8e.finishedCallback2){
_a8e.finishedCallback2(this.loadedNodes[uri]||null,xhr.status,_a8e.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_a94.status=xhr.status;
}
}
}));
if(_a94.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_CCATNODE_NOTFOUND_1,[uri,_a94.status]));
}
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogCategoryModelImpl._find");
return this.loadedNodes[uri];
},create:function(_a9c){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogCategoryModelImpl.create");
if(_a9c&&_a9c.category){
var _a9d=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
var _a9e=com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom);
com.ibm.mm.enabler.dom.textContent(_a9e,"catalog:"+this.prefix+":"+_a9c.category);
_a9d.appendChild(_a9e);
_a9d.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.ns.atom));
_a9d.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:summary",this.ns.atom));
_a9d.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:published",this.ns.atom));
_a9d.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:updated",this.ns.atom));
var _a9f=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
_a9d.appendChild(_a9f);
var _aa0=com.ibm.mm.enabler.model.Utils.createNode("model:catalog-category",this.ns.model);
_a9f.appendChild(_aa0);
_aa0.appendChild(com.ibm.mm.enabler.model.Utils.createNode("model:title",this.ns.model));
_aa0.appendChild(com.ibm.mm.enabler.model.Utils.createNode("model:description",this.ns.model));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogCategoryModelImpl.create");
return new com.ibm.mm.enabler.catalog.CatalogCategoryNodeImpl(_a9d);
}
return null;
},confirmCreate:function(_aa1){
return this.getConfirmCreate();
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_aa2,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogCategoryModelImpl._commit",sync?"sync":"async");
this.statusCode=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
this.requestCount=0;
this._acquire();
var _aa4;
for(id in this.loadedNodes){
var time=new Date();
var _aa6="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+this.loadedNodes[id];
var _aa7=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.entryUrl,this);
if(id in this.createdNodes){
this._acquire();
_aa4=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_aa7,null,null,false,sync);
_aa4.create(_aa6,dojo.hitch(this,function(type,data,xhr,args){
if(_aa2){
if(_aa2.operationCallback){
_aa2.operationCallback(this.loadedNodes[args],com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_aa2.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_aa2.errorCallback){
_aa2.errorCallback(xhr.status,_aa2.errorCallbackParameters);
}
}
}
this._release(_aa2,xhr.status);
}),id);
}else{
if(this.initialContents[id]===this.loadedNodes[id].toString()){
continue;
}
var _aa7=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.loadedNodes[id].getEditLink(),this);
_aa7.setParameter("update","replace");
this._acquire();
_aa4=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_aa7,null,null,false,sync);
_aa4.update(_aa6,dojo.hitch(this,function(type,data,xhr,args){
if(_aa2){
if(_aa2.operationCallback){
_aa2.operationCallback(this.loadedNodes[args],com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_aa2.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_aa2.errorCallback){
_aa2.errorCallback(xhr.status,_aa2.errorCallbackParameters);
}
}
}
this._release(_aa2,xhr.status);
}),id);
}
}
for(id in this.deletedNodes){
var _aa7=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.deletedNodes[id].getEditLink(),this);
this._acquire();
_aa4=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_aa7,null,null,false,sync);
_aa4.remove(dojo.hitch(this,function(type,data,xhr,args){
if(_aa2){
if(_aa2.operationCallback){
_aa2.operationCallback(args,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_aa2.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_aa2.errorCallback){
_aa2.errorCallback(xhr.status,_aa2.errorCallbackParameters);
}
}
}
this._release(_aa2,xhr.status);
}),id);
}
for(id in this.entryModels){
this.entryModels[id]._commit(_aa2,sync);
}
this._release(_aa2,0);
if(_aa2&&_aa2.finishedCallback){
_aa2.finishedCallback(null,_aa2.finishedCallbackParameters);
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogCategoryModelImpl._commit");
},_acquire:function(){
this.requestCount++;
},_release:function(_ab4,_ab5){
this.statusCode=Math.max(parseInt(_ab5,10),this.statusCode);
this.requestCount--;
if(this.requestCount<=0){
if(_ab4&&_ab4.finishedCallback2){
_ab4.finishedCallback2(null,this.statusCode,_ab4.finishedCallbackParameters2);
}
}
},getRoot:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getRoot);
},_getRoot:function(_ab6,sync){
if(this.root===null){
var node=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
node.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom));
this.root=new com.ibm.mm.enabler.catalog.CatalogCategoryNodeImpl(node);
this.root.setParentModel(this);
this.root.setID("CATROOT");
}
return this.root;
},hasChildren:function(node){
return false;
},getChildren:function(node){
return new com.ibm.mm.enabler.catalog.CatalogCategoryIteratorImpl(node,this);
},getParent:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getParent,uri);
},_getParent:function(_abc,sync,node){
return (node.getID()=="CATROOT")?null:this.getRoot();
},insert:function(node){
this.loadedNodes[node.getID()]=node;
this.createdNodes[node.getID()]=null;
},confirmInsert:function(node){
return this.getConfirmCreate();
},remove:function(node){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.CatalogCategoryModelImpl.remove");
var id=(node instanceof com.ibm.mm.enabler.catalog.CatalogCategoryNodeImpl)?node.getID():node;
if(!(id in this.deletedNodes)){
this.deletedNodes[id]=this.loadedNodes[id];
}
if(id in this.loadedNodes){
delete this.loadedNodes[id];
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.CatalogCategoryModelImpl.remove");
},confirmRemove:function(node){
return this.getConfirmRemove(node);
}});
dojo.declare("com.ibm.mm.enabler.catalog.CatalogCategoryNodeImpl",[com.ibm.mashups.enabler.catalog.CatalogCategoryNode,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.EditLinkProviderImpl],{constructor:function(node){
this.xmlData=node;
this.parentModel=null;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CATALOG);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_XSI,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},getParentModel:function(){
return this.parentModel;
},setParentModel:function(_ac6){
this.parentModel=_ac6;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
dojo.declare("com.ibm.mm.enabler.catalog.CatalogEntryNodeImpl",[com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.MetaDataImpl2,com.ibm.mm.enabler.EditLinkProviderImpl,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(node){
this.xmlData=node;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CATALOG);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ceni_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_XSI,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(prefix in this.serviceJson.namespaces){
this.ceni_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.NLS_SHORT_DESCRIPTION="atom:content/*/model:shortDescription/base:nls-string";
this.NLS_SHORT_DESCRIPTION_TOP="atom:content/*/model:shortDescription";
this.BASE_SHORT_DESCRIPTION="base:nls-string";
},getDefinitionURL:function(_ac9){
return this._getURL("definition",_ac9);
},setDefinitionURL:function(aUrl){
this._setURL("definition",aUrl);
},confirmSetDefinitionURL:function(aUrl){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},getIconURL:function(_acc){
var _acd=this._getURL("icon",_acc);
return _acd;
},setIconURL:function(aUrl){
this._setURL("icon",aUrl);
},confirmSetIconURL:function(aUrl){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},getPreviewThumbnailURL:function(_ad0){
return this._getURL("previewThumbnail",_ad0);
},setPreviewThumbnailURL:function(aUrl){
this._setURL("previewThumbnail",aUrl);
},confirmSetPreviewThumbnailURL:function(aUrl){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},getPreviewURL:function(_ad3){
var pUrl=this._getURL("preview",_ad3);
return pUrl;
},setPreviewURL:function(aUrl){
this._setURL("preview",aUrl);
},confirmSetPreviewURL:function(aUrl){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},getHelpURL:function(_ad7){
var hUrl=this._getURL("help",_ad7);
return hUrl;
},setHelpURL:function(aUrl){
this._setURL("help",aUrl);
},confirmSetHelpURL:function(aUrl){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},getShortDescription:function(_adb){
var _adc=null;
_adb.replace(/-/g,"_");
var _add=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_SHORT_DESCRIPTION,this.xmlData,this.li_ns);
if(_add){
for(var i=0;i<_add.length;i++){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_add[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null&&lang.replace(/-/g,"_")==_adb){
_adc=com.ibm.mm.enabler.dom.textContent(_add[i]);
break;
}
}
}
return _adc;
},setShortDescription:function(_ae0,_ae1){
_ae1.replace(/-/g,"_");
var _ae2=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_SHORT_DESCRIPTION,this.xmlData,this.li_ns);
var _ae3=false;
var i=_ae2.length;
while(--i>=0){
var lang=com.ibm.mm.enabler.utilities.getAttributeWithNS(_ae2[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
if(lang!==null&&lang.replace(/-/g,"_")==_ae1){
com.ibm.mm.enabler.dom.textContent(_ae2[i],_ae0);
_ae3=true;
break;
}
}
if(!_ae3){
var _ae6=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_SHORT_DESCRIPTION_TOP,this.xmlData,this.li_ns);
if(_ae6&&_ae6.length>0){
var _ae7=this.xmlData.ownerDocument;
var node=com.ibm.mm.enabler.dom.createElement(_ae7,this.BASE_SHORT_DESCRIPTION,this.BASE_NS);
node.setAttribute("xml:lang",_ae1);
com.ibm.mm.enabler.dom.textContent(node,_ae0);
_ae6[0].appendChild(node);
}else{
throw new Error(dojo.string.substitute(this.modelMessages.E_ELEMENT_NOT_FOUND_2,[this.NLS_SHORT_DESCRIPTION_TOP,this.toString()]));
}
}
},confirmSetShortDescription:function(_ae9,_aea){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
},_getURL:function(rel,_aec){
var _aed=null;
var expr="atom:content/model:catalog-entry/atom:link[@ext:rel='"+rel+"']";
var _aef=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ceni_ns);
if(_aef&&_aef.length>0){
_aed=_aef[0].getAttribute("href");
}
var ret=_aed;
if((typeof _aec=="undefined")||(_aec==null)||(_aec==true)){
var ret2=com.ibm.mm.enabler.model.Utils.checkForEndpoints(ret);
if(ret2!=null){
ret=ret2;
}
}
return ret;
},_setURL:function(rel,href){
var expr="atom:content/model:catalog-entry/atom:link[@ext:rel='"+rel+"']";
var _af5=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ceni_ns);
if(_af5&&_af5.length>0){
_af5[0].setAttribute("href",href);
}
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.layout"]){
dojo._hasResource["com.ibm.mm.enabler.model.layout"]=true;
dojo.provide("com.ibm.mm.enabler.model.layout");
dojo.require("com.ibm.mm.enabler.aspects");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mashups.enabler.model");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("dojo.i18n");
dojo.declare("com.ibm.mm.enabler.model.LayoutModelImpl",[com.ibm.mashups.enabler.model.LayoutModel,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(href,uri,_af8){
this.uri=uri;
this.href=href;
this.root=null;
this.navigationModel=_af8;
this.m_create=false;
var _af9=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CONTENT);
this.entryUrl=_af9.url;
this.prefix=_af9.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH,nsf.NS_XHTML,nsf.NS_XSI]);
for(prefix in _af9.namespaces){
this.ns[prefix]=_af9.namespaces[prefix];
}
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.initialContents={};
this.initialLayout={};
},_getNavigationModel:function(){
return this.navigationModel;
},getRootInternal:function(){
if(!this.root){
this.getRoot().start(true);
}
return this.root;
},getRoot:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getRoot);
},_getRoot:function(_afb,sync){
if(this.root){
if(_afb&&_afb.finishedCallback2){
_afb.finishedCallback2(this.root,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_afb.finishedCallbackParameters2);
}
return this.root;
}
if(!this.href){
if(_afb&&_afb.finishedCallback2){
_afb.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_afb.finishedCallbackParameters2);
}
return null;
}
var _afd=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.href,this);
_afd.setParameter("rep","full");
_afd.addParameter("aspect","ac");
var _afe=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_afd,null,null,false,sync);
_afe.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var _b03=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_b03&&_b03.length>0){
this.root=new com.ibm.mm.enabler.layout.LayoutFragmentImpl(_b03[0],this);
this.initialLayout[this.uri]=this.root.toString();
var _b04=this._getMediaLink();
var _b05=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(_b04,this);
var _b06=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_b05,null,null,true,sync);
_b06.read(dojo.hitch(this,function(_b07,_b08,xhr2,_b0a){
if(_b07==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
this.root.setFragment(_b08);
this.initialContents[this.uri]=_b08;
}
if(_afb&&_afb.finishedCallback2){
_afb.finishedCallback2(this.root,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_afb.finishedCallbackParameters2);
}
}));
}else{
if(_afb&&_afb.finishedCallback2){
_afb.finishedCallback2(null,xhr.status,_afb.finishedCallbackParameters2);
}
}
}else{
if(_afb&&_afb.finishedCallback2){
_afb.finishedCallback2(null,xhr.status,_afb.finishedCallbackParameters2);
}
}
}));
return this.root;
},hasChildren:function(node){
return false;
},getChildren:function(node){
throw new Error(this.modelMessages.E_UNSUPPORTED_OP_0);
},getParent:function(node){
throw new Error(this.modelMessages.E_UNSUPPORTED_OP_0);
},insert:function(node,_b0f,_b10){
this.root=node;
},confirmInsert:function(node,_b12,_b13){
return true;
},_commit:function(_b14,sync,_b16){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.LayoutModelImpl._commit",sync?"sync":"async");
if(this.root){
var _b17=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_URL,this);
_b17.setNodes([{value:this.uri||"cid:0",isID:true}]);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
var _b19=(this.initialLayout[this.uri]==this.root.toString())?true:false;
var expr="atom:link";
var _b1b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.root.xmlData,this.ns);
for(var i=0;i<_b1b.length;i++){
var _b1d=com.ibm.mm.enabler.utilities.getAttributeWithNS(_b1b[i],"ext:rel","rel",this.ns["ext"]);
if(_b1d&&_b1d=="theme"){
var _b1e=_b1b[i].parentNode;
_b1e.removeChild(_b1b[i]);
if(_b19){
this.initialLayout[this.uri]=this.root.toString();
}
break;
}
}
var expr="atom:content/model:static-content-page/model:content";
var _b1f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.root.xmlData,this.ns);
if(_b1f&&_b1f.length>0){
var _b1e=_b1f[0].parentNode;
_b1e.removeChild(_b1f[0]);
if(_b19){
this.initialLayout[this.uri]=this.root.toString();
}
}
var _b20=com.ibm.mm.enabler.model.Utils.createFeed(_b17.getModelURI(),"IBM Lotus Mashups Fragment Feed",this.root.toString(),this.ns);
var _b21=this.root.getFragment();
if(this.m_create){
_b16._acquire();
var _b22=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.entryUrl,this);
var _b23=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_b22,null,null,false,sync);
_b23.create(_b20,dojo.hitch(this,function(type,data,xhr,args){
if(data!==null&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var _b28=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_b28&&_b28.length>0){
this.root=new com.ibm.mm.enabler.layout.LayoutFragmentImpl(_b28[0],this);
this.initialLayout[this.uri]=this.root.toString();
}
}
if(_b14&&_b14.operationCallback){
_b14.operationCallback(this.root,com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_b14.operationCallbackParameters);
}
if(_b21==null){
_b16._release(_b14,xhr.status);
}
}));
if(_b21!==null){
_b29=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL,this);
_b29.setNodes([{value:this.root.getID(),isID:true},{value:"index.html",isID:false}]);
_b2a=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_b29,null,null,false,sync);
_b2a.create(_b21,dojo.hitch(this,function(type,data,xhr,args){
_b16._release(_b14,xhr.status);
this.initialContents[this.uri]=_b21;
}));
}
}else{
if(this.initialLayout[this.uri]!=this.root.toString()){
_b16._acquire();
var _b22=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_URL,this);
_b22.setNodes([{value:this.root.getID(),isID:true}]);
var _b23=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_b22,null,null,false,sync);
_b23.update(_b20,dojo.hitch(this,function(type,data,xhr,args){
if(_b14&&_b14.operationCallback){
_b14.operationCallback(this.root,com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_b14.operationCallbackParameters);
}
_b16._release(_b14,xhr.status);
}));
this.initialLayout[this.uri]=this.root.toString();
}
var _b33=this._getEditMediaLink();
if(_b21!==null&&this.initialContents[this.uri]!=_b21&&_b33){
var _b29=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(_b33,this);
var _b2a=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_b29,null,null,false,sync);
_b16._acquire();
_b2a.update(_b21,dojo.hitch(this,function(type,data,xhr,args){
_b16._release(_b14,xhr.status);
}));
this.initialContents[this.uri]=_b21;
}
}
}
this.m_create=false;
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.LayoutModelImpl._commit");
},remove:function(node){
this.root=null;
},confirmRemove:function(node){
return this.getConfirmRemove(node);
},create:function(_b3a){
var _b3b=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
var id=com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom);
var _b3d=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_URL,this);
_b3d.setNodes([{value:this.uri,isID:true}]);
com.ibm.mm.enabler.dom.textContent(id,_b3d.getModelURI());
_b3b.appendChild(id);
var _b3e=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
var _b3f=com.ibm.mm.enabler.model.Utils.createNode("model:static-content-page",this.ns.model);
var _b40=com.ibm.mm.enabler.model.Utils.createNode("model:title",this.ns.model);
var _b41=com.ibm.mm.enabler.model.Utils.createNode("model:description",this.ns.model);
_b3f.appendChild(_b40);
_b3f.appendChild(_b41);
_b3e.appendChild(_b3f);
_b3b.appendChild(_b3e);
this.m_create=true;
return new com.ibm.mm.enabler.layout.LayoutFragmentImpl(_b3b,this);
},confirmCreate:function(_b42){
return this.getConfirmCreate();
},_getMediaLink:function(){
var _b43=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ext:rel='media']",this.root.xmlData,this.ns);
if(_b43&&_b43.length>0){
return _b43[0].getAttribute("href");
}
return null;
},_getEditMediaLink:function(){
var _b44=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@rel='edit-media']",this.root.xmlData,this.ns);
if(_b44&&_b44.length>0){
return _b44[0].getAttribute("href");
}
return null;
},switchUri:function(uri){
this.initialLayout[uri]=this.initialLayout[this.uri];
this.initialContents[uri]=this.initialContents[this.uri];
delete this.initialLayout[this.uri];
delete this.initialContents[this.uri];
this.uri=uri;
}});
dojo.declare("com.ibm.mm.enabler.layout.LayoutNodeImpl",[com.ibm.mashups.enabler.layout.LayoutNode,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.TransformableImpl,com.ibm.mm.enabler.MetaDataImpl2,com.ibm.mm.enabler.EditLinkProviderImpl,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(node,_b47){
this.xmlData=node;
this.layoutModel=_b47;
},_getLayoutModel:function(){
return this.layoutModel;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
dojo.declare("com.ibm.mm.enabler.layout.LayoutFragmentImpl",[com.ibm.mm.enabler.layout.LayoutNodeImpl,com.ibm.mm.enabler.LocalizedImpl],{constructor:function(){
this.fragment="";
},getFragment:function(){
return this.fragment;
},setFragment:function(_b48){
this.fragment=_b48;
},confirmSetFragment:function(_b49){
return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.iterator"]){
dojo._hasResource["com.ibm.mm.enabler.iterator"]=true;
dojo.provide("com.ibm.mm.enabler.iterator");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mashups.enabler.model");
dojo.require("com.ibm.mashups.enabler.Iterator");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("dojo.i18n");
dojo.declare("com.ibm.mm.enabler.ModelIteratorImpl",[com.ibm.mashups.enabler.Iterator,com.ibm.mm.enabler.DeferredIteratorImpl],{constructor:function(url,_b4b){
this.model=_b4b;
this.entries=[];
this.cursor=0;
this.sizeValue=null;
this.ATOM_FEED="atom:feed";
this.ATOM_ENTRY=this.ATOM_FEED+"/atom:entry";
this.ATOM_NEXT=this.ATOM_FEED+"/atom:link[@rel='next']";
this.OPENSEARCH_TOTALRESULTS=this.ATOM_FEED+"/opensearch:totalResults";
this.collectionUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(url,_b4b);
if(_b4b.strategy){
for(x in _b4b.strategy){
if(_b4b.strategy[x] instanceof com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy){
this.collectionUrl.setParameter("num",_b4b.strategy[x].getInterval());
this.collectionUrl.setParameter("start",this.getCursorPosition());
break;
}
}
}
this._customizeUrl(this.collectionUrl);
},_createNode:function(_b4c){
return null;
},_customizeUrl:function(url){
},start:function(sync){
while(this.hasNext(this,sync)){
this.next(this,sync);
}
},hasNext:function(dfr,sync){
if(typeof this.entries[this.cursor]=="undefined"){
this._loadAhead(dfr||null,typeof sync=="undefined"?true:sync);
}
return this.entries[this.cursor]?true:false;
},next:function(dfr,sync){
return this.hasNext(dfr||null,typeof sync=="undefined"?true:sync)?this.model.loadedNodes[this.entries[this.cursor++]]:null;
},setCursorPosition:function(_b53){
this.cursor=_b53;
this.collectionUrl.setParameter("start",this.getCursorPosition());
},getCursorPosition:function(){
return this.cursor;
},size:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._size);
},_size:function(dfr,sync){
this.sizeValue!==null||this.hasNext(null,true);
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.sizeValue,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return this.sizeValue;
},_loadAhead:function(_b56,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.navigation.ModelIteratorImpl._loadAhead",sync?"sync":"async");
var _b58=new com.ibm.mm.enabler.services.ModelRestServiceRequest(this.collectionUrl,null,null,false,sync);
_b58.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var size=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.OPENSEARCH_TOTALRESULTS,data,this.model.ns);
if(size&&size.length>0){
this.sizeValue=com.ibm.mm.enabler.dom.textContent(size[0]);
}
var c=0;
var _b5f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ATOM_ENTRY,data,this.model.ns);
if(_b5f){
for(var i=0;i<_b5f.length;i++){
var node=this._createNode(_b5f[i]);
if(node!=null){
this.entries[this.cursor+c++]=node.getID();
if(_b56&&_b56.foreachCallback){
_b56.foreachCallback(node,_b56.foreachCallbackParameters);
}
}else{
this.sizeValue--;
}
}
}
var next=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ATOM_NEXT,data,this.model.ns);
if(next&&next.length>0){
var url=next[0].getAttribute("href");
this.collectionUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(url,this.model);
this._customizeUrl(this.collectionUrl);
}else{
this.entries[this.cursor+c]=null;
if(_b56&&_b56.finishedCallback2){
_b56.finishedCallback2(null,xhr.status,_b56.finishedCallbackParameters2);
}
}
}else{
if(_b56&&_b56.finishedCallback2){
_b56.finishedCallback2(null,xhr.status,_b56.finishedCallbackParameters2);
}
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.navigation.ModelIteratorImpl._loadAhead");
}});
dojo.declare("com.ibm.mm.enabler.EmptyModelIteratorImpl",[com.ibm.mashups.enabler.Iterator,com.ibm.mm.enabler.DeferredIteratorImpl],{constructor:function(){
},start:function(){
if(this.finishedCallback2){
this.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,this.finishedCallbackParameters2);
}
},hasNext:function(dfr){
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return false;
},next:function(dfr){
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return null;
},setCursorPosition:function(){
},getCursorPosition:function(){
return 0;
},size:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._size);
},_size:function(dfr,sync){
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(0,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return 0;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.navigation"]){
dojo._hasResource["com.ibm.mm.enabler.model.navigation"]=true;
dojo.provide("com.ibm.mm.enabler.model.navigation");
dojo.declare("com.ibm.mm.enabler.navigation.NavigationModelIteratorImpl",[com.ibm.mashups.enabler.Iterator,com.ibm.mm.enabler.DeferredIteratorImpl,com.ibm.mm.enabler.ModelIteratorImpl],{constructor:function(){
this.THR_INREPLYTO_PREFIX="thr:in-reply-to[@ext:uri='";
this.THR_INREPLYTO_SUFFIX="']";
},_createNode:function(_b68){
var uri=this.collectionUrl.getModelURI();
var expr=this.THR_INREPLYTO_PREFIX+uri+this.THR_INREPLYTO_SUFFIX;
var _b6b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_b68,this.model.ns);
if(_b6b&&_b6b.length>0){
var node=com.ibm.mm.enabler.model.NavigationNodeFactory.createNavigationNode(_b68);
var id=uri.slice(uri.lastIndexOf(":")+1);
if(node.getID()==id){
return null;
}
node=this.model._cacheNode(node);
}
return node||null;
},_customizeUrl:function(url){
url.addParameter("aspect","ac");
url.addParameter("aspect","ca");
url.setParameter("rep","full");
}});
dojo.declare("com.ibm.mm.enabler.model.NavigationModelImpl",[com.ibm.mashups.enabler.model.NavigationModel,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(){
this.root=null;
this.loadedNodes={};
this.createdNodes={};
this.deletedNodes={};
this.initialContents={};
this.layoutModels={};
this.cid=0;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
this.entryUrl=this.serviceJson.url;
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH,nsf.NS_XHTML,nsf.NS_APP]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.fragmentServiceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_CONTENT);
this.fragmentPrefix=this.serviceJson.idprefix;
var _b70=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SPACE_NAVIGATION);
this.spaceNavigationEntryUrl=_b70.url;
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.urlType=com.ibm.mashups.enabler.model.url.ModelUrlFactory.NAVIGATION_URL;
this.VALID_LAYOUTS={"page":true,"staticpage":true};
},getInstance:function(){
var _b71=com.ibm.mm.enabler.model.NavigationModelImpl._instance;
return _b71?_b71:(com.ibm.mm.enabler.model.NavigationModelImpl._instance=new com.ibm.mm.enabler.model.NavigationModelImpl());
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,uri);
},findDefaultAcceptParent:function(){
return this.getRoot();
},getRoot:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getRoot);
},_getRoot:function(_b73,sync){
if(this.root===null){
this.root=this._find(_b73,sync,"collection");
}
if(_b73&&_b73.finishedCallback2){
_b73.finishedCallback2(this.root,_b73.finishedCallbackParameters2);
}
return this.root;
},hasChildren:function(node){
return this._getChildrenLink(node)!==null?true:false;
},getChildren:function(node){
var href=this._getChildrenLink(node);
if(href===null){
return new com.ibm.mm.enabler.EmptyModelIteratorImpl();
}else{
return new com.ibm.mm.enabler.navigation.NavigationModelIteratorImpl(href,this);
}
},_getChildrenLink:function(node){
var node=this._resolve(node);
if(node){
var _b79=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@rel='replies']",node.xmlData,this.ns);
if(_b79&&_b79.length>0){
var href=_b79[0].getAttribute("href");
}
}
return href||null;
},_resolve:function(node){
if(!node){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
var id=(typeof (node)=="string")?node:node.getID();
this._find(null,true,id);
return this.loadedNodes[id]||null;
},getParent:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getParent,uri);
},_getParent:function(_b7e,sync,node){
var node=this._resolve(node);
if(node!==null){
var refs=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("thr:in-reply-to[@ext:uri]",node.xmlData,this.ns);
if(refs&&refs.length>0){
var _b82=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,refs[0]);
var _b83=this._find(_b7e,sync,_b82);
}else{
if(_b7e&&_b7e.finishedCallback2){
_b7e.finishedCallback2(_b83,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_b7e.finishedCallbackParameters2);
}
}
}
return _b83||null;
},_setParent:function(node,_b85){
if(node!==null&&_b85!==null){
var _b86=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_b86.setNodes([{value:_b85.getID(),isID:true}]);
var thr=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("thr:in-reply-to",node.xmlData,this.ns);
if(thr&&thr.length>0){
com.ibm.mm.enabler.utilities.setAttributeWithNS(node.xmlData.ownerDocument,thr[0],"ext:uri","uri",this.ns["ext"],_b86.getModelURI());
thr[0].setAttribute("href",_b86.getAbsoluteURL());
}else{
thr=com.ibm.mm.enabler.model.Utils.createNode("thr:in-reply-to",this.ns.thr);
com.ibm.mm.enabler.utilities.setAttributeWithNS(node.xmlData.ownerDocument,thr,"ext:uri","uri",this.ns["ext"],_b86.getModelURI());
node.xmlData.appendChild(thr);
thr.setAttribute("href",_b86.getAbsoluteURL());
}
}
},_setNext:function(node,_b89){
if(node){
var next=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@rel='next']",node.xmlData,this.ns);
var _b8b=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
if(next&&next.length>0){
if(_b89){
_b8b.setNodes([{value:_b89.getID(),isID:true}]);
next[0].setAttribute("href","?uri="+_b8b.getModelURI());
com.ibm.mm.enabler.utilities.setAttributeWithNS(node.xmlData.ownerDocument,next[0],"ext:uri","uri",this.ns["ext"],_b8b.getModelURI());
}else{
var _b8c=next[0].parentNode;
_b8c.removeChild(next[0]);
}
}else{
if(_b89){
_b8b.setNodes([{value:_b89.getID(),isID:true}]);
next=com.ibm.mm.enabler.model.Utils.createNode("atom:link",this.ns.atom);
next.setAttribute("href","?uri="+_b8b.getModelURI());
next.setAttribute("rel","next");
next.setAttribute("type","application/atom+xml");
com.ibm.mm.enabler.utilities.setAttributeWithNS(node.xmlData.ownerDocument,next,"ext:uri","uri",this.ns["ext"],_b8b.getModelURI());
node.xmlData.appendChild(next);
}
}
}
},insert:function(node,_b8e,_b8f){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.NavigationModelImpl.insert");
if(!node){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
var _b90=_b8e?_b8e.getID():null;
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.createdNodes[id]=null;
}else{
var _b92=this.getParent(node.getID()).start();
if(_b92!==null){
var _b93=this.getChildren(_b92);
var prev=null;
while(_b93.hasNext()){
var _b95=_b93.next();
if(_b95.getID()==id&&prev!==null){
this._setNext(prev,_b93.hasNext()?_b93.next():null);
this.initialContents[prev.getID()]=prev.toString();
break;
}
if(prev==null&&_b95.getID()==id&&!_b93.hasNext()&&_b92.getID()!=_b90){
var _b96=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@rel='replies']",_b92.xmlData,this.ns);
if(_b96&&_b96.length>0){
var _b97=this.initialContents[_b8e.getID()]==_b8e.toString()?true:false;
var _b98=_b96[0].parentNode;
_b98.removeChild(_b96[0]);
if(_b97){
this.initialContents[_b8e.getID()]=_b8e.toString();
}
}
}
prev=_b95;
}
}
}
if(_b8e){
var _b93=this.getChildren(_b8e);
var prev=null;
var _b99=_b8f?_b8f.getID():null;
while(_b93.hasNext()){
var _b95=_b93.next();
if(_b95.getID()==_b99){
break;
}
prev=_b95;
}
if(prev){
this._setNext(prev,node);
this.initialContents[prev.getID()]=prev.toString();
}
var _b96=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@rel='replies']",_b8e.xmlData,this.ns);
if(!_b96||_b96.length==0){
var _b97=this.initialContents[_b8e.getID()]==_b8e.toString()?true:false;
var _b9a=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_b9a.setNodes([{value:_b8e.getID(),isID:true}]);
_b9a.setParameter("levels","2");
_b9a.setParameter("rep","full");
var _b9b=_b8e.xmlData.ownerDocument;
var _b96=com.ibm.mm.enabler.dom.createElement(_b9b,"atom:link",this.ns.atom);
_b96.setAttribute("href",_b9a.getAbsoluteURL());
_b96.setAttribute("rel","replies");
_b96.setAttribute("type","application/atom+xml");
com.ibm.mm.enabler.utilities.setAttributeWithNS(node.xmlData.ownerDocument,_b96,"ext:uri","uri",this.ns["ext"],_b9a.getModelURI());
_b8e.xmlData.appendChild(_b96);
if(_b97){
this.initialContents[_b8e.getID()]=_b8e.toString();
}
}
}
this._setParent(node,_b8e);
this._setNext(node,_b8f);
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.NavigationModelImpl.insert");
},confirmInsert:function(node,_b9d,_b9e){
if(_b9d==null){
return false;
}
if(node!=null){
var _b9f=false;
var _ba0=this.getParent(node.getID()).start();
if(_ba0!=null){
if(_ba0.getID()!=_b9d.getID()){
_b9f=true;
}
}
if(_b9f){
return this.getConfirmReparent(node,_b9d,_b9e);
}else{
return this.getConfirmReorder(node,_b9d,_b9e);
}
}
return this.getConfirmReparent(node,_b9d,_b9e);
},confirmExport:function(node){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
return true;
},remove:function(node){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.NavigationModelImpl.remove");
var page=this._resolve(node);
var id=page.getID();
if(page.toString()==this.initialContents[id]){
var _ba5=true;
}
var _ba6=this.getParent(id).start();
if(_ba6){
var _ba7=this.getChildren(_ba6);
if(_ba7&&_ba7.size().start()==1){
var _ba8=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@rel='replies']",_ba6.xmlData,this.ns);
if(_ba8&&_ba8.length>0){
var _ba9=_ba8[0].parentNode;
_ba9.removeChild(_ba8[0]);
if(_ba5&&_ba5==true){
this.initialContents[id]=page.toString();
}
}
}
}
this.deletedNodes[id]=this.loadedNodes[id];
this._removeCacheNode(id);
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.NavigationModelImpl.remove");
},confirmRemove:function(node){
return this.getConfirmRemove(node);
},hasLayoutModel:function(node){
var page=this._resolve(node);
var href=null;
if(page){
var expr="atom:link[@rel='related' and @ext:class='content-node']";
var _baf=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,page.xmlData,this.ns);
if(_baf&&_baf.length>0){
var rel=com.ibm.mm.enabler.utilities.getAttributeWithNS(_baf[0],"ext:rel","rel",this.ns["ext"]);
if(rel in this.VALID_LAYOUTS){
href=_baf[0].getAttribute("href");
}
}
}
return href?true:false;
},getLayoutModel:function(node){
if(!node){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
var _bb2=(typeof (node)=="string")?node:node.getID();
if(!(_bb2 in this.layoutModels)){
this._find(null,true,_bb2);
var href=null;
var _bb4=_bb2;
if(this.loadedNodes[_bb2]){
var expr="atom:link[@rel='related' and @ext:class='content-node']";
var _bb6=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.loadedNodes[_bb2].xmlData,this.ns);
if(_bb6&&_bb6.length>0){
href=_bb6[0].getAttribute("href");
var _bb7=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,_bb6[0]);
if(_bb7){
_bb4=_bb7;
}
}
}
this.layoutModels[_bb2]=new com.ibm.mm.enabler.model.LayoutModelImpl(href,_bb4,this);
if((com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled())&&(this.strategy!==null)&&(null!=this.loadedNodes[_bb2])&&(!((this.loadedNodes[_bb2]._fragmentData)&&(null!=this.loadedNodes[_bb2]._fragmentData)))){
var _bb8=new com.ibm.mm.enabler.strategy.PageLoadAheadStrategyExecutor(this.strategy);
_bb8.processLoadAhead([this.loadedNodes[_bb2]],false);
if((this.loadedNodes[_bb2]._fragmentData)&&(null!==this.loadedNodes[_bb2]._fragmentData)){
var _bb9=new com.ibm.mm.enabler.layout.LayoutFragmentImpl(this.loadedNodes[_bb2]._fragmentData,this.layoutModels[_bb2]);
_bb9.setFragment(this.loadedNodes[_bb2]._fragmentMediaData);
this.layoutModels[_bb2].insert(_bb9);
this.layoutModels[_bb2].initialLayout[_bb4]=_bb9.toString();
this.layoutModels[_bb2].initialContents[_bb4]=this.loadedNodes[_bb2]._fragmentMediaData;
}
}
}
return this.layoutModels[_bb2];
},create:function(_bba){
var node;
if(_bba&&_bba.template){
var _bbc=_bba.template.xmlData.cloneNode(true);
node=new com.ibm.mm.enabler.navigation.NavigationNodeImpl(_bbc);
var thr=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("thr:in-reply-to",node.xmlData,this.ns);
if(thr&&thr.length>0){
var _bbe=thr[0].parentNode;
_bbe.removeChild(thr[0]);
}
}else{
var _bbf=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
_bbf.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom));
_bbf.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.ns.atom));
var _bc0=com.ibm.mm.enabler.model.Utils.createNode("atom:updated",this.ns.atom);
var time=new Date();
com.ibm.mm.enabler.dom.textContent(_bc0,time.toGMTString());
_bbf.appendChild(_bc0);
var _bc2=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
var _bc3=com.ibm.mm.enabler.model.Utils.createNode("model:navigation-node",this.ns.model);
_bc2.appendChild(_bc3);
_bc3.appendChild(com.ibm.mm.enabler.model.Utils.createNode("model:title",this.ns.model));
_bc3.appendChild(com.ibm.mm.enabler.model.Utils.createNode("model:description",this.ns.model));
_bbf.appendChild(_bc2);
node=new com.ibm.mm.enabler.navigation.NavigationNodeImpl(_bbf);
node.setID((_bba&&_bba.cid)?_bba.cid:""+this.cid++);
}
return node;
},confirmCreate:function(_bc4){
return this.getConfirmCreate();
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_bc5,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.NavigationModelImpl._commit",sync?"sync":"async");
sync=true;
this.statusCode=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
this.requestCount=0;
this._acquire();
var _bc7;
var _bc8;
for(var id in this.loadedNodes){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
if(id in this.createdNodes){
var expr="atom:link[@ext:class='content-node']";
var _bcc=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.loadedNodes[id].xmlData,this.ns);
var _bcd=true;
if(_bcc&&_bcc.length>0){
_bcd=false;
}
var page=this.loadedNodes[id];
var _bcf=this.getParent(page).start();
if(_bcd){
var lm=this.layoutModels[id];
if(!lm){
lm=new com.ibm.mm.enabler.model.LayoutModelImpl();
var root=lm.create();
root.setID(this.loadedNodes[id].getID());
lm.insert(root);
root.setFragment(" ");
}
lm._commit(_bc5,true,this);
var _bd2=lm.root.getEditLink();
var _bd3="";
var expr="atom:id";
var ids=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,lm.root.xmlData,this.ns);
if(ids&&ids.length>0){
_bd3=com.ibm.mm.enabler.dom.textContent(ids[0]);
}
var _bd5=this.loadedNodes[id].xmlData;
var link=com.ibm.mm.enabler.dom.createElement(_bd5.ownerDocument,"atom:link",this.ns.atom);
link.setAttribute("rel","related");
link.setAttribute("href",_bd2);
link.setAttribute("type","application/atom+xml");
com.ibm.mm.enabler.utilities.setAttributeWithNS(_bd5.ownerDocument,link,"ext:rel","rel",this.ns["ext"],"page");
com.ibm.mm.enabler.utilities.setAttributeWithNS(_bd5.ownerDocument,link,"ext:class","class",this.ns["ext"],"content-node");
com.ibm.mm.enabler.utilities.setAttributeWithNS(_bd5.ownerDocument,link,"ext:uri","uri",this.ns["ext"],_bd3);
_bd5.appendChild(link);
}
var _bd7=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_bd7.setNodes([{value:id,isID:true}]);
var _bd8=com.ibm.mm.enabler.model.Utils.createFeed(_bd7.getModelURI(),"IBM Lotus Mashups Navigation Feed",this.loadedNodes[id],this.ns);
if(_bcf._getSpaceIdentifier()!=null){
_bc8=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.spaceNavigationEntryUrl,this);
}else{
_bc8=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.entryUrl,this);
}
_bc8.addParameter("aspect","ac");
_bc8.addParameter("aspect","ca");
_bc8.setParameter("rep","full");
this._acquire();
_bc7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_bc8,null,null,false,sync);
_bc7.create(_bd8,dojo.hitch(this,function(type,data,xhr,id){
var expr="atom:feed/atom:entry";
var _bde=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_bde){
page.setXml(_bde[0]);
this.loadedNodes[page.getID()]=page;
this.initialContents[page.getID()]=page.toString();
delete this.loadedNodes[id];
delete this.initialContents[id];
if(this.layoutModels[id]&&!this.layoutModels[page.getID()]){
this.layoutModels[page.getID()]=this.layoutModels[id];
this.layoutModels[page.getID()].switchUri(page.getID());
delete this.layoutModels[id];
}
if(_bc5&&_bc5.operationCallback){
_bc5.operationCallback(page,com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_bc5.operationCallbackParameters);
}
if(_bc5&&_bc5.finishedCallback){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
_bc5.finishedCallback(page,_bc5.finishedCallbackParameters);
}
}
}
this._release(_bc5,xhr.status);
}),id);
}else{
if(this.initialContents[id]==this.loadedNodes[id].toString()){
continue;
}
var _bd7=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_bd7.setNodes([{value:id,isID:true}]);
var _bd8=com.ibm.mm.enabler.model.Utils.createFeed(_bd7.getModelURI(),"IBM Lotus Mashups Navigation Feed",this.loadedNodes[id],this.ns);
var edit=this.loadedNodes[id].getEditLink();
_bc8=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(edit,this);
this._acquire();
_bc7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_bc8,null,null,false,sync);
_bc7.update(_bd8,dojo.hitch(this,function(type,data,xhr,args){
if(_bc5&&_bc5.operationCallback){
_bc5.operationCallback(this.loadedNodes[args],com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_bc5.operationCallbackParameters);
}
this._release(_bc5,xhr.status);
}),id);
this.initialContents[id]=this.loadedNodes[id].toString();
}
}
this.createdNodes={};
for(id in this.deletedNodes){
var edit=this.deletedNodes[id].getEditLink();
_bc8=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(edit,this);
this._acquire();
_bc7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_bc8,null,null,false,sync);
_bc7.remove(dojo.hitch(this,function(type,data,xhr,args){
if(_bc5&&_bc5.operationCallback){
_bc5.operationCallback(args,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_bc5.operationCallbackParameters);
}
this._release(_bc5,xhr.status);
}),id);
var expr="atom:link[@rel='related' and @ext:class='content-node']";
var _bcc=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.deletedNodes[id].xmlData,this.ns);
if(_bcc&&_bcc.length>0){
var href=_bcc[0].getAttribute("href");
if(href){
_bc8=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,this);
this._acquire();
_bc7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_bc8,null,null,false,sync);
_bc7.remove(dojo.hitch(this,function(type,data,xhr,args){
if(_bc5&&_bc5.operationCallback){
_bc5.operationCallback(args,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_bc5.operationCallbackParameters);
}
this._release(_bc5,xhr.status);
}),id);
}
}
if(id in this.layoutModels){
delete this.layoutModels[id];
}
}
this.deletedNodes={};
for(id in this.layoutModels){
this.layoutModels[id]._commit(_bc5,sync,this);
}
this._release(_bc5,0);
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.NavigationModelImpl._commit");
},_acquire:function(){
this.requestCount++;
},_release:function(_bed,_bee){
this.statusCode=Math.max(parseInt(_bee,10),this.statusCode);
this.requestCount--;
if(this.requestCount<=0){
if(_bed&&_bed.finishedCallback2){
_bed.finishedCallback2(null,this.statusCode,_bed.finishedCallbackParameters2);
}
}
},_find:function(_bef,sync,uri){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.NavigationModelImpl._find",uri,sync?"sync":"async");
if(!uri){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
var id=com.ibm.mm.enabler.model.Utils.getIdFromIdentifiable(uri);
if(id in this.deletedNodes){
if(_bef&&_bef.finishedCallback2){
_bef.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_bef.finishedCallbackParameters2);
}
return null;
}
var _bf3=null;
if(id in this.loadedNodes){
if(_bef&&_bef.finishedCallback2){
_bef.finishedCallback2(this.loadedNodes[uri],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_bef.finishedCallbackParameters2);
}
_bf3=this.loadedNodes[id];
}else{
var _bf4;
var href=com.ibm.mm.enabler.model.Utils.getHrefFromIdentifiable(uri);
if(href){
_bf4=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,this);
}else{
if(uri=="collection"){
_bf4=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.entryUrl,this);
}else{
_bf4=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_bf4.setNodes([{value:uri,isID:true}]);
}
}
_bf4.setParameter("levels","1");
_bf4.addParameter("aspect","ac");
_bf4.addParameter("aspect","ca");
_bf4.setParameter("rep","full");
var _bf6=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_bf4,null,null,false,sync);
var _bf7={};
_bf7.node=null;
_bf6.read(dojo.hitch(this,function(type,data,xhr,args){
var expr="atom:feed/atom:entry";
var _bfd=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_bfd){
var node=com.ibm.mm.enabler.model.NavigationNodeFactory.createNavigationNode(_bfd[0]);
_bf7.node=this._cacheNode(node);
}else{
throw new Error(dojo.string.substitute(this.modelMessages.E_LOAD_NAVNODE_1,[uri]));
}
if(_bef&&_bef.finishedCallback2){
_bef.finishedCallback2(_bf7.node,xhr.status,_bef.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_bf7.status=xhr.status;
}
}
}));
if(_bf7.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_NAVNODE_NOTFOUND_1,[uri,_bf7.status]));
}
_bf3=_bf7.node;
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.NavigationModelImpl._find");
return _bf3;
},invalidate:function(node){
var id=node.getID();
if(id in this.loadedNodes){
delete this.loadedNodes[id];
delete this.initialContents[id];
delete this.layoutModels[id];
}
},_removeCacheNode:function(node){
var node=this._resolve(node);
var id=node.getID();
if(id in this.loadedNodes){
delete this.loadedNodes[id];
delete this.initialContents[id];
}
},_cacheNode:function(node){
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.initialContents[id]=node.toString();
}
return this.loadedNodes[id];
}});
dojo.declare("com.ibm.mm.enabler.navigation.NavigationNodeImpl",[com.ibm.mashups.enabler.navigation.NavigationNode,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.TransformableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.MetaDataImpl2,com.ibm.mm.enabler.EditLinkProviderImpl,com.ibm.mm.enabler.NextLinkProviderImpl,com.ibm.mm.enabler.RepresentationProviderImpl,com.ibm.mm.enabler.EffectiveAccessImpl],{constructor:function(node){
this.xmlData=node;
this.cs=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns_nav=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_CA]);
for(prefix in this.serviceJson.namespaces){
this.ns_nav[prefix]=this.serviceJson.namespaces[prefix];
}
this._fragmentData;
this._fragmentMediaData;
},_getSpaceIdentifier:function(){
var _c07=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ca:rel='application']",this.xmlData,this.ns_nav);
if(_c07&&_c07.length>0){
var id=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,_c07[0]);
var href=_c07[0].getAttribute("href");
var _c0a=new com.ibm.mm.enabler.IdentifierImpl(id,{"href":href});
}
return _c0a||null;
},getThemeIdentifier:function(){
var _c0b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ext:rel='theme']",this.xmlData,this.ns_nav);
if(_c0b&&_c0b.length>0){
var id=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,_c0b[0]);
var href=_c0b[0].getAttribute("href");
var _c0e=new com.ibm.mm.enabler.IdentifierImpl(id,{"href":href});
}
return _c0e||null;
},setThemeIdentifier:function(_c0f){
var _c10=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ext:rel='theme']",this.xmlData,this.ns_nav);
if(_c10&&_c10.length>0){
var tn=_c10[0];
}else{
var tn=com.ibm.mm.enabler.dom.createElement(this.xmlData.ownerDocument,"atom:link",this.ns_nav.atom);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,tn,"ext:rel","rel",this.ns_nav["ext"],"theme");
this.xmlData.appendChild(tn);
}
var _c12=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.THEME_URL,this);
_c12.setNodes([{value:_c0f.getID(),isID:true}]);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,tn,"ext:uri","uri",this.ns_nav["ext"],_c12.getModelURI());
},getTheme:function(){
var id=this.getThemeIdentifier();
return id?id.getID():null;
},setTheme:function(id){
this.setThemeIdentifier(new com.ibm.mm.enabler.IdentifierImpl(id));
},isHidden:function(){
var ret1=(this.getMetaData("com.ibm.mashups.navigation.hidden")=="true")?true:false;
var ret2=(this.getMetaData("com.ibm.portal.Hidden")=="true")?true:false;
return (ret1||ret2);
},setHidden:function(hide){
var name=this.cs.getValue("com.ibm.mashups.navigation.hidden");
this.setMetaData(name,(hide)?"true":"false");
},confirmSetHidden:function(hide){
var ret1=this.confirmSetMetaData("com.ibm.mashups.navigation.hidden",(hide)?"true":"false");
var ret2=this.confirmSetMetaData("com.ibm.portal.Hidden",(hide)?"true":"false");
return (ret1&&ret2);
},getExportPageURL:function(){
var _c1c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ext:rel='resourcefeed']",this.xmlData,this.ns_nav);
if(_c1c&&_c1c.length>0){
var _c1d=_c1c[0].getAttribute("href");
return _c1d;
}
return null;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
},_getFragmentData:function(){
return this._fragmentData;
},_setFragmentData:function(data){
this._fragmentData=data;
},_getFragmentMediaData:function(){
return this._fragmentMediaData;
},_setFragmentMediaData:function(data){
this._fragmentMediaData=data;
}});
dojo.declare("com.ibm.mm.enabler.navigation.SharedNavigationNodeImpl",[com.ibm.mashups.enabler.navigation.SharedNavigationNode,com.ibm.mm.enabler.navigation.NavigationNodeImpl],{});
dojo.declare("com.ibm.mm.enabler.navigation.SharedNavigationRootImpl",[com.ibm.mashups.enabler.navigation.SharedNavigationRoot,com.ibm.mm.enabler.navigation.NavigationNodeImpl],{});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.sharedNavigation"]){
dojo._hasResource["com.ibm.mm.enabler.model.sharedNavigation"]=true;
dojo.provide("com.ibm.mm.enabler.model.sharedNavigation");
dojo.require("com.ibm.mm.enabler.aspects");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mm.enabler.iterator");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("dojo.i18n");
dojo.declare("com.ibm.mm.enabler.model.SharedNavigationModelImpl",[com.ibm.mashups.enabler.model.SharedNavigationModel,com.ibm.mm.enabler.model.NavigationModelImpl],{constructor:function(){
this.urlType=com.ibm.mashups.enabler.model.url.ModelUrlFactory.SHARED_NAVIGATION_URL;
var _c20=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SHARED_NAVIGATION);
this.entryUrl=_c20.url;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(p in _c20.namespaces){
this.ns[p]=_c20.namespaces[p];
}
},getInstance:function(){
var _c22=com.ibm.mm.enabler.model.SharedNavigationModelImpl._instance;
return _c22?_c22:(com.ibm.mm.enabler.model.SharedNavigationModelImpl._instance=new com.ibm.mm.enabler.model.SharedNavigationModelImpl());
},isAccepted:function(node){
if(!node){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
var _c24=(typeof (node)=="string")?node:node.getID();
var _c25=this.find(_c24).start();
if(!_c25){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
var expr="atom:link[@ext:rel='linked']";
var _c27=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_c25.xmlData,this.ns);
return (_c27&&dojo.isArray(_c27)&&_c27.length>0)?true:false;
},_find:function(_c28,sync,uri){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.SharedNavigationModelImpl._find",uri,sync?"sync":"async");
if(!uri){
throw new Error(this.modelMessages.E_NODE_ISNULL_0);
}
uri=(typeof (uri)=="string")?uri:uri.getID();
if(uri in this.deletedNodes){
if(_c28&&_c28.finishedCallback2){
_c28.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_c28.finishedCallbackParameters2);
}
return null;
}
if(uri in this.loadedNodes){
if(_c28&&_c28.finishedCallback2){
_c28.finishedCallback2(this.loadedNodes[uri],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_c28.finishedCallbackParameters2);
}
return this.loadedNodes[uri];
}
var _c2b;
if(uri=="collection"){
_c2b=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.entryUrl,this);
}else{
_c2b=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_c2b.setNodes([{value:uri,isID:true}]);
}
_c2b.setParameter("levels","1");
var _c2c=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_c2b,null,null,false,sync);
this._node=null;
_c2c.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed/atom:entry";
var _c32=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_c32){
var node=com.ibm.mm.enabler.model.NavigationNodeFactory.createNavigationNode(_c32[0]);
this._node=this._cacheNode(node);
}
}
if(_c28&&_c28.finishedCallback2){
_c28.finishedCallback2(this._node,xhr.status,_c28.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.SharedNavigationModelImpl._find");
return this._node;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.theme"]){
dojo._hasResource["com.ibm.mm.enabler.model.theme"]=true;
dojo.provide("com.ibm.mm.enabler.model.theme");
dojo.declare("com.ibm.mm.enabler.theme.ThemeModelIteratorImpl",[com.ibm.mashups.enabler.Iterator,com.ibm.mm.enabler.DeferredIteratorImpl,com.ibm.mm.enabler.ModelIteratorImpl],{constructor:function(){
},_createNode:function(_c34){
var node=new com.ibm.mm.enabler.theme.ThemeImpl(_c34);
this.model.loadedNodes[node.getID()]=node;
return node;
},_customizeUrl:function(url){
url.addParameter("aspect","ac");
url.setParameter("rep","full");
}});
dojo.declare("com.ibm.mm.enabler.model.ThemeModelImpl",[com.ibm.mashups.enabler.model.ThemeModel,com.ibm.mm.enabler.ModelImpl],{constructor:function(){
this.loadedNodes={};
this.skinModels={};
var _c37=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_THEME);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(p in _c37.namespaces){
this.ns[p]=_c37.namespaces[p];
}
this.collectionUrl=_c37.url;
},getInstance:function(){
var _c39=com.ibm.mm.enabler.model.ThemeModelImpl._instance;
return _c39?_c39:(com.ibm.mm.enabler.model.ThemeModelImpl._instance=new com.ibm.mm.enabler.model.ThemeModelImpl());
},iterator:function(){
return new com.ibm.mm.enabler.theme.ThemeModelIteratorImpl(this.collectionUrl,this);
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._load,uri);
},getSkinModel:function(_c3b){
var _c3c=_c3b.getID();
if(!(_c3c in this.skinModels)){
var expr="atom:link[@ext:rel='skin']";
var _c3e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_c3b.xmlData,this.ns);
if(_c3e&&_c3e.length>0){
var href=_c3e[0].getAttribute("href");
this.skinModels[_c3c]=new com.ibm.mm.enabler.model.SkinModelImpl(href,_c3c);
}
if(!href){
return new com.ibm.mm.enabler.model.EmptySkinModelImpl();
}
}
return this.skinModels[_c3c];
},_load:function(_c40,sync,_c42){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.ThemeModelImpl._load",_c42,sync?"sync":"async");
var id=com.ibm.mm.enabler.model.Utils.getIdFromIdentifiable(_c42);
if(id in this.loadedNodes){
if(_c40&&_c40.finishedCallback2){
_c40.finishedCallback2(this.loadedNodes[id],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_c40.finishedCallbackParameters2);
}
}else{
var href=com.ibm.mm.enabler.model.Utils.getHrefFromIdentifiable(_c42);
if(href){
var _c45=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,this);
}else{
var _c45=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.THEME_URL,this);
_c45.setNodes([{value:id,isID:true}]);
}
_c45.addParameter("aspect","ac");
_c45.setParameter("rep","full");
var _c46=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_c45,null,null,false,sync);
_c46.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed/atom:entry";
var _c4c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_c4c&&_c4c.length>0){
this.loadedNodes[id]=new com.ibm.mm.enabler.theme.ThemeImpl(_c4c[0]);
}
}
if(_c40&&_c40.finishedCallback2){
_c40.finishedCallback2(this.loadedNodes[id]||null,xhr.status,_c40.finishedCallbackParameters2);
}
}));
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.ThemeModelImpl._load");
return this.loadedNodes[id]||null;
},findResourceUrl:function(node,name){
var _c4f=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.THEME_MEDIA_URL,this);
var _c50=[{value:node.getID(),isID:true},{value:name,isID:false}];
_c4f.setNodes(_c50);
return _c4f.getAbsoluteURL();
}});
dojo.declare("com.ibm.mm.enabler.theme.SkinModelIteratorImpl",[com.ibm.mashups.enabler.Iterator,com.ibm.mm.enabler.DeferredIteratorImpl,com.ibm.mm.enabler.ModelIteratorImpl],{constructor:function(){
},_createNode:function(_c51){
var node=new com.ibm.mm.enabler.theme.SkinImpl(_c51);
this.model.loadedNodes[node.getID()]=node;
return node;
},_customizeUrl:function(url){
url.addParameter("aspect","ac");
url.setParameter("rep","full");
}});
dojo.declare("com.ibm.mm.enabler.model.SkinModelImpl",[com.ibm.mashups.enabler.model.SkinModel,com.ibm.mm.enabler.ModelImpl],{constructor:function(url,_c55){
var _c56=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_THEME);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
for(p in _c56.namespaces){
this.ns[p]=_c56.namespaces[p];
}
this.loadedNodes={};
this.collectionUrl=url;
this.themeId=_c55;
},iterator:function(){
return new com.ibm.mm.enabler.theme.SkinModelIteratorImpl(this.collectionUrl,this);
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._load,uri);
},_load:function(_c59,sync,uri){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.SkinModelImpl._load",uri,sync?"sync":"async");
if(uri in this.loadedNodes){
if(_c59&&_c59.finishedCallback2){
_c59.finishedCallback2(this.loadedNodes[uri],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_c59.finishedCallbackParameters2);
}
}else{
var _c5c=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.THEME_URL,this);
_c5c.setNodes([{value:uri,isID:true},{value:this.themeId,isID:true}]);
_c5c.addParameter("aspect","ac");
_c5c.setParameter("rep","full");
var _c5d=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_c5c,null,null,false,sync);
_c5d.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed/atom:entry";
var _c63=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_c63&&_c63.length>0){
this.loadedNodes[uri]=new com.ibm.mm.enabler.theme.SkinImpl(_c63[0]);
}
}
if(_c59&&_c59.finishedCallback2){
_c59.finishedCallback2(this.loadedNodes[uri]||null,xhr.status,_c59.finishedCallbackParameters2);
}
}));
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.SkinModelImpl._load");
return this.loadedNodes[uri]||null;
},findResourceUrl:function(node,name){
var _c66=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.THEME_MEDIA_URL,this);
var _c67=[{value:node.getID(),isID:true},{value:this.themeId,isID:true},{value:name,isID:false}];
_c66.setNodes(_c67);
return _c66.getAbsoluteURL();
}});
dojo.declare("com.ibm.mm.enabler.model.EmptySkinModelImpl",[com.ibm.mashups.enabler.model.SkinModel,com.ibm.mm.enabler.ModelImpl],{constructor:function(){
},iterator:function(){
return new com.ibm.mm.enabler.EmptyModelIteratorImpl();
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,uri);
},_find:function(dfr,sync,uri){
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,dfr.finishedCallbackParameters2);
}
return null;
}});
dojo.declare("com.ibm.mm.enabler.theme.ThemeImpl",[com.ibm.mashups.enabler.theme.Theme,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.MetaDataImpl2],{constructor:function(node){
this.xmlData=node;
var _c6d=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_THEME);
this.prefix=_c6d.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM]);
for(p in _c6d.namespaces){
this.ns[p]=_c6d.namespaces[p];
}
},getBaseUrl:function(_c6f){
if(typeof _c6f=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.theme.Theme.getBaseUrl","Deprecated. Use com.ibm.mashups.enabler.model.ThemeModel.findResourceUrl instead.");
}
return this._getBaseUrl();
},_getBaseUrl:function(){
var _c70=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/model:theme/model:link[@ext:rel='baseUrl']",this.xmlData,this.ns);
return (_c70&&_c70.length>0)?_c70[0].getAttribute("href"):null;
},getDefaultSkin:function(){
var id=this.getDefaultSkinIdentifier();
return id?id.getID():null;
},getDefaultSkinIdentifier:function(){
var expr="atom:link[@rel='related' and @ext:rel='defaultSkin']";
var _c73=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_c73&&_c73.length>0){
var id=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,_c73[0]);
var href=_c73[0].getAttribute("href");
var _c76=new com.ibm.mm.enabler.IdentifierImpl(id,{"href":href});
}
return _c76||null;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
dojo.declare("com.ibm.mm.enabler.theme.SkinImpl",[com.ibm.mashups.enabler.theme.Skin,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.MetaDataImpl2],{constructor:function(node){
this.xmlData=node;
var _c78=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_THEME);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM]);
for(p in _c78.namespaces){
this.ns[p]=_c78.namespaces[p];
}
},getBaseUrl:function(_c7a){
if(typeof _c7a=="undefined"){
com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.theme.Theme.getBaseUrl","Deprecated. Use com.ibm.mashups.enabler.model.ThemeModel.findResourceUrl instead.");
}
return this._getBaseUrl();
},_getBaseUrl:function(){
var _c7b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/model:skin/model:link[@ext:rel='baseUrl']",this.xmlData,this.ns);
return (_c7b&&_c7b.length>0)?_c7b[0].getAttribute("href"):null;
},getPreviewUrl:function(){
var _c7c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/model:skin/model:link[@ext:rel='previewUrl']",this.xmlData,this.ns);
return (_c7c&&_c7c.length>0)?_c7c[0].getAttribute("href"):null;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.user"]){
dojo._hasResource["com.ibm.mm.enabler.model.user"]=true;
dojo.provide("com.ibm.mm.enabler.model.user");
dojo.provide("com.ibm.mm.enabler.model.UserModel.iConfig");
dojo.declare("com.ibm.mm.enabler.model.UserModelImpl",[com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.ModelImpl],{constructor:function(){
this.root=null;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_UM]);
this.currentUser=null;
var _c7e=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var eps=_c7e.getValue("ConfigProvider.Endpoints");
this.anonUserID=_c7e.getValue(_c7e.ANON_VIRTUAL_USER_ID);
if((typeof this.anonUserID=="undefined")||(this.anonUserID===null)){
this.anonUserID="anonymous portal user";
}
this.allAuthID=_c7e.getValue(_c7e.ALL_AUTH_VIRTUAL_GROUP_ID);
if((typeof this.allAuthID=="undefined")||(this.allAuthID===null)){
this.allAuthID="all authenticated portal users";
}
this.anonEnabled=false;
var _c80=_c7e.getValue(_c7e.ANON_MODE_ENABLED);
if(_c80&&((_c80==true)||(_c80=="true")||(_c80=="on")||(_c80=="TRUE")||(_c80=="ON"))){
this.anonEnabled=true;
}
this.anonUserIDEncoded=encodeURIComponent(this.anonUserID);
this.allAuthIDEncoded=encodeURIComponent(this.allAuthID);
this.anonUser=new com.ibm.mm.enabler.user.AnonUserImpl(this.anonUserID,this.anonUserIDEncoded);
this.allAuth=new com.ibm.mm.enabler.user.AllAuthGroupImpl(this.allAuthID,this.allAuthIDEncoded);
this.loadedUsers={};
},getInstance:function(){
var _c81=com.ibm.mm.enabler.model.UserModelImpl._instance;
return _c81?_c81:(com.ibm.mm.enabler.model.UserModelImpl._instance=new com.ibm.mm.enabler.model.UserModelImpl());
},getAnonymousMode:function(){
return com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode();
},find:function(uri){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,uri);
},_find:function(dfr,sync,id){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._find",id);
if(this.currentUser!==null&&this.currentUser.getID()==id){
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.currentUser,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return this.currentUser;
}
if((id===this.anonUserID)||(id===this.anonUserIDEncoded)){
this.entry=this.anonUser;
return this.anonUser;
}
if((id===this.allAuthID)||(id===this.allAuthIDEncoded)){
this.entry=this.allAuth;
return this.allAuth;
}
if(id in this.loadedUsers){
this.entry=this.loadedUsers[id];
return this.entry;
}
var _c86=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_c86.setSchemeSpecificPart("users:profiles:"+encodeURIComponent(id));
_c86.setParameter("expandRefs","true");
var _c87=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_c86,null,null,false,sync);
this.entry=null;
_c87.read(dojo.hitch(this,function(type,data,xhr,args){
var _c8c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry",data,this.ns);
if(_c8c&&_c8c.length>0){
this.entry=new com.ibm.mm.enabler.user.UserImpl(_c8c[0],this.anonUserID,this.anonUserIDEncoded);
}else{
_c8c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_c8c&&_c8c.length>0){
this.entry=new com.ibm.mm.enabler.user.UserImpl(_c8c[0],this.anonUserID,this.anonUserIDEncoded);
}
}
this.loadedUsers[this.entry.getID()]=this.entry;
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.entry,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._find");
return this.entry;
},findUsersByAttribute:function(_c8d,_c8e){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findUsersByAttribute,{name:_c8d,value:_c8e});
},_findUsersByAttribute:function(dfr,sync,attr){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findUsersByAttribute",_c92,_c93);
var _c92=attr.name;
var _c93=attr.value;
var _c94=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_c94.setSchemeSpecificPart("users:profiles");
_c94.setParameter("expandRefs","true");
_c94.setParameter("searchAttributes",_c92+"="+encodeURIComponent(_c93));
var _c95=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_c94,null,null,false,sync);
this.entry=null;
_c95.read(dojo.hitch(this,function(type,data,xhr,args){
var _c9a=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
var _c9b=[];
for(var i=0;i<_c9a.length;i++){
var user=new com.ibm.mm.enabler.user.UserImpl(_c9a[i],this.anonUserID,this.anonUserIDEncoded);
_c9b.push(user);
}
this.entry=_c9b;
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.entry,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findUsersByAttribute");
return this.entry;
},findGroupByID:function(id){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findGroupByID,id);
},_findGroupByID:function(dfr,sync,id){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findGroupByID",id);
if((id===this.allAuthID)||(id===this.allAuthIDEncoded)){
this.entry=this.allAuth;
return this.allAuth;
}
var _ca2=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_ca2.setSchemeSpecificPart("groups:profiles:"+encodeURIComponent(id));
_ca2.setParameter("expandRefs","true");
var _ca3=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_ca2,null,null,false,sync);
this.entry=null;
_ca3.read(dojo.hitch(this,function(type,data,xhr,args){
var _ca8=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry",data,this.ns);
if(_ca8&&_ca8.length>0){
var _ca9=new com.ibm.mm.enabler.user.GroupImpl(_ca8[0],this.allAuthID,this.allAuthIDEncoded);
this.entry=_ca9;
}else{
_ca8=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_ca8&&_ca8.length>0){
var _ca9=new com.ibm.mm.enabler.user.GroupImpl(_ca8[0],this.allAuthID,this.allAuthIDEncoded);
this.entry=_ca9;
}
}
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.entry,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findGroupByID");
return this.entry;
},findGroupsByAttribute:function(_caa,_cab){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findGroupsByAttribute,{name:_caa,value:_cab});
},_findGroupsByAttribute:function(dfr,sync,attr){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findGroupsByAttribute",_caf,_cb0);
var _caf=attr.name;
var _cb0=attr.value;
var _cb1=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_cb1.setSchemeSpecificPart("groups:profiles");
_cb1.setParameter("expandRefs","true");
_cb1.setParameter("searchAttributes",_caf+"="+encodeURIComponent(_cb0));
var _cb2=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_cb1,null,null,false,sync);
this.entry=null;
_cb2.read(dojo.hitch(this,function(type,data,xhr,args){
var _cb7=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
var _cb8=[];
for(var i=0;i<_cb7.length;i++){
var _cba=new com.ibm.mm.enabler.user.GroupImpl(_cb7[i],this.allAuthID,this.allAuthIDEncoded);
_cb8.push(_cba);
}
this.entry=_cb8;
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.entry,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findGroupsByAttribute");
return this.entry;
},findCurrentUser:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findCurrentUser);
},_findCurrentUser:function(dfr,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findCurrentUser");
if(this.currentUser!==null){
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.currentUser,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return this.currentUser;
}
var _cbd=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_cbd.setSchemeSpecificPart("currentuser:profile");
_cbd.setParameter("expandRefs","true");
var _cbe=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_cbd,null,null,false,sync);
_cbe.read(dojo.hitch(this,function(type,data,xhr,args){
var _cc3=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry",data,this.ns);
if(_cc3&&_cc3.length>0){
this.currentUser=new com.ibm.mm.enabler.user.CurrentUserImpl(_cc3[0],this.anonUserID,this.anonUserIDEncoded);
this.entry=_cc3[0];
}else{
_cc3=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_cc3&&_cc3.length>0){
this.currentUser=new com.ibm.mm.enabler.user.CurrentUserImpl(_cc3[0],this.anonUserID,this.anonUserIDEncoded);
this.entry=_cc3[0];
}
}
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.currentUser,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findCurrentUser");
return this.currentUser;
},findGroupAttributes:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findGroupAttributes);
},_findGroupAttributes:function(dfr,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl.findGroupAttributes");
var _cc6=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_cc6.setSchemeSpecificPart("attributes:groups");
_cc6.setParameter("expandRefs","true");
var _cc7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_cc6,null,null,false,sync);
this.entry=null;
_cc7.read(dojo.hitch(this,function(type,data,xhr,args){
var _ccc=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
var _ccd=[];
for(var i=0;i<_ccc.length;i++){
var _ccf=new com.ibm.mm.enabler.user.AttributeImpl(_ccc[i]);
_ccd.push(_ccf);
}
this.entry=_ccd;
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.entry,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl.findGroupAttributes");
return this.entry;
},findUserAttributes:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findUserAttributes);
},_findUserAttributes:function(dfr,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl.findUserAttributes");
var _cd2=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_cd2.setSchemeSpecificPart("attributes:users");
_cd2.setParameter("expandRefs","true");
var _cd3=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_cd2,null,null,false,sync);
this.attEntry=null;
_cd3.read(dojo.hitch(this,function(type,data,xhr,args){
var _cd8=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
var _cd9=[];
for(var i=0;i<_cd8.length;i++){
var _cdb=new com.ibm.mm.enabler.user.AttributeImpl(_cd8[i]);
_cd9.push(_cdb);
}
this.attEntry=_cd9;
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.attEntry,xhr.status,dfr.finishedCallbackParameters2);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl.findUserAttributes");
return this.attEntry;
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_cdc,sync){
if(this.currentUser){
if(this.currentUser.getAddedAttributeNames()||this.currentUser.getChangedAttributeNames()||this.currentUser.getChangedAttributeNames()){
var _cde=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL,this);
_cde.setSchemeSpecificPart("currentuser:profile");
_cde.setParameter("expandRefs","true");
this.statusCode=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
this.requestCount=0;
this._acquire();
var _cdf=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_cde,null,null,false,true);
_cdf.update(this.currentUser.toString(),dojo.hitch(this,function(type,data,xhr,args){
if(_cdc&&_cdc.operationCallback){
_cdc.operationCallback(null,com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_cdc.operationCallbackParameters);
}
this._release(_cdc,xhr.status);
this.currentUser.clearChangedAttributeNames();
var _ce4=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry",data,this.ns);
if(_ce4&&_ce4.length>0){
var user=new com.ibm.mm.enabler.user.UserImpl(_ce4[0],this.anonUserID,this.anonUserIDEncoded);
this.currentUser=user;
this.entry=_ce4[0];
}else{
_ce4=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_ce4&&_ce4.length>0){
var user=new com.ibm.mm.enabler.user.UserImpl(_ce4[0]);
this.currentUser=user;
this.entry=_ce4[0];
}
}
if(user.getID() in this.loadedUsers){
this.loadedUsers[user.getID()]=user;
}
}));
}
}
},_acquire:function(){
this.requestCount++;
},_release:function(_ce6,_ce7){
this.statusCode=Math.max(parseInt(_ce7,10),this.statusCode);
this.requestCount--;
if(this.requestCount<=0){
if(_ce6&&_ce6.finishedCallback2){
_ce6.finishedCallback2(null,this.statusCode,_ce6.finishedCallbackParameters2);
}
}
},getVirtualUsers:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getVirtualUsers);
},_getVirtualUsers:function(dfr,sync){
var _cea=[];
if(this.anonEnabled){
_cea.push(this.anonUser);
}
return _cea;
},getVirtualGroups:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getVirtualGroups);
},_getVirtualGroups:function(dfr,sync){
var _ced=[];
_ced.push(this.allAuth);
return _ced;
},getLookasideAttributeNames:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._getLookasideAttributeNames);
},_getLookasideAttributeNames:function(dfr,sync){
if((typeof this.lookasideAttributes=="undefined")||(this.lookasideAttributes==null)){
this.lookasideAttributes=[];
var _cf0=this.findUserAttributes().start();
for(i=0;i<_cf0.length;i++){
var _cf1=_cf0[i].getName();
if(_cf1.indexOf("com.ibm.mashups.user.")==0){
this.lookasideAttributes.push(_cf1);
}
}
}
return this.lookasideAttributes;
}});
dojo.declare("com.ibm.mm.enabler.user.EntityImpl",[com.ibm.mm.enabler.IdentifiableImpl],{});
dojo.declare("com.ibm.mm.enabler.user.UserImpl",[com.ibm.mm.enabler.user.EntityImpl],{constructor:function(data,_cf3,_cf4){
this.anonUserID=_cf3;
this.anonUserIDEncoded=_cf4;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_UM]);
this.xmlData=data;
this.changedAttributes={};
this.addedAttributes={};
this.removedAttributes={};
},getAttribute:function(_cf6){
if(typeof _cf6=="undefined"||_cf6===null){
return null;
}
if(this.removedAttributes[_cf6]){
return null;
}else{
if(this.changedAttributes[_cf6]){
return this.changedAttributes[_cf6];
}else{
if(this.addedAttributes[_cf6]){
return this.addedAttributes[_cf6];
}
}
}
var expr="atom:content/um:profile/um:attribute[@name='"+_cf6+"']/um:attributeValue";
var _cf8=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_cf8.length===0){
return null;
}
var _cf9=com.ibm.mm.enabler.dom.textContent(_cf8[0]);
return _cf9;
},getAttributeNames:function(){
if(typeof this.attNames!="undefined"&&this.lookasideAttNames!==null){
return this.attNames;
}
var _cfa=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute",this.xmlData,this.ns);
if(_cfa.length===0){
return null;
}
this.attNames=[];
for(var i=0;i<_cfa.length;i++){
var _cfc=_cfa[i];
var _cfd=_cfc.getAttribute("name");
if(typeof _cfd!="undefined"&&_cfd!==null&&_cfd!==""){
if(_cfd.indexOf()==0){
this.attNames.push(_cfd);
}
}
}
return this.attNames;
},getID:function(){
var _cfe=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:id",this.xmlData,this.ns);
if((_cfe===null)||(_cfe.length===0)){
return null;
}
var _cff=com.ibm.mm.enabler.dom.textContent(_cfe[0]);
if((_cff===null)||(_cff.length===0)){
return null;
}
var pos=_cff.indexOf("profiles/");
if(pos==-1){
pos=_cff.indexOf("profiles:");
}
var id=_cff.slice(pos+"profiles:".length);
return decodeURIComponent(id);
},getLoginName:function(){
var _d02=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='principalName']/um:attributeValue",this.xmlData,this.ns);
if((_d02===null)||(_d02.length===0)){
return null;
}
var _d03=com.ibm.mm.enabler.dom.textContent(_d02[0]);
return _d03;
},getSN:function(){
var _d04=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='sn']/um:attributeValue",this.xmlData,this.ns);
if((_d04===null)||(_d04.length===0)){
return null;
}
var sn=com.ibm.mm.enabler.dom.textContent(_d04[0]);
return sn;
},getCN:function(){
var _d06=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='cn']/um:attributeValue",this.xmlData,this.ns);
if((_d06===null)||(_d06.length===0)){
return null;
}
var cn=com.ibm.mm.enabler.dom.textContent(_d06[0]);
return cn;
},getEmail:function(){
var _d08=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='email']/um:attributeValue",this.xmlData,this.ns);
if((_d08===null)||(_d08.length===0)){
_d08=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='mail']/um:attributeValue",this.xmlData,this.ns);
if((_d08===null)||(_d08.length===0)){
return null;
}
}
var _d09=com.ibm.mm.enabler.dom.textContent(_d08[0]);
return _d09;
},getDisplayName:function(){
if((this.getID()==this.anonUserID)||(this.getID()==this.anonUserIDEncoded)){
this.iwStr=dojo.i18n.getLocalization("com.ibm.mm.enabler","iwStr");
return this.iwStr.ANON;
}
var _d0a=null;
var _d0b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='displayName']/um:attributeValue",this.xmlData,this.ns);
if((_d0b!=null)&&(_d0b.length>0)){
_d0a=com.ibm.mm.enabler.dom.textContent(_d0b[0]);
}
if((typeof _d0a=="undefined")||(_d0a==null)){
var _d0c=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _d0d=_d0c.getValue(_d0c.DEFAULT_USER_DISPLAY_PROP);
if((typeof _d0d!="undefined")&&(_d0d!=null)){
_d0a=this.getAttribute(_d0d);
}
}
if((typeof _d0a=="undefined")||(_d0a==null)){
_d0a=this.getLoginName();
}
return _d0a;
},getEntityType:function(){
return "user";
},setAttribute:function(name,_d0f){
var _d10=null;
var expr="atom:content/*/um:attribute"+"[@name='"+name+"']/"+"um:attributeValue";
var _d12=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_d12&&_d12.length>0){
com.ibm.mm.enabler.dom.textContent(_d12[0],_d0f);
this.changedAttributes[name]=_d0f;
this.removedAttributes[name]=null;
}else{
var _d13=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile",this.xmlData,this.ns);
if(_d13&&_d13.length>0){
var _d14=this.xmlData.ownerDocument;
var _d15=com.ibm.mm.enabler.dom.createElement(_d14,"um:attribute",this.ns.um);
_d15.setAttribute("name",name);
_d15.setAttribute("type","xs:string");
_d15.setAttribute("multiValued","false");
var _d16=com.ibm.mm.enabler.dom.createElement(_d14,"um:attributeValue",this.ns.um);
com.ibm.mm.enabler.dom.textContent(_d16,_d0f);
_d15.appendChild(_d16);
_d13[0].appendChild(_d15);
this.changedAttributes[name]=null;
this.addedAttributes[name]=_d0f;
this.removedAttributes[name]=null;
}
}
return _d10;
},removeAttribute:function(name){
var expr="atom:content/*/um:attribute"+"[@name='"+name+"']";
var _d19=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_d19&&_d19.length>0){
var _d1a=_d19[0].parentNode;
_d1a.removeChild(_d19[0]);
this.changedAttributes[name]=null;
this.addedAttributes[name]=null;
this.removedAttributes[name]="";
return new String();
}
},getChangedAttributeNames:function(){
return this.changedAttributes;
},getAddedAttributeNames:function(){
return this.addedAttributes;
},getRemovedAttributeNames:function(){
return this.removedAttributes;
},clearChangedAttributeNames:function(){
this.changedAttributes={};
this.addedAttributes={};
this.removedAttributes={};
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
dojo.declare("com.ibm.mm.enabler.user.CurrentUserImpl",[com.ibm.mashups.enabler.user.CurrentUser,com.ibm.mm.enabler.user.UserImpl],{constructor:function(){
},getJ2EEPrincipalName:function(){
var _d1b=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='j2ee_principialname']/um:attributeValue",this.xmlData,this.ns);
if(_d1b!=null&&_d1b.length>0){
return com.ibm.mm.enabler.dom.textContent(_d1b[0]);
}else{
return this.getLoginName();
}
}});
dojo.declare("com.ibm.mm.enabler.user.GroupImpl",[com.ibm.mm.enabler.user.EntityImpl],{constructor:function(data,_d1d,_d1e){
this.allAuthID=_d1d;
this.allAuthIDEncoded=_d1e;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_UM]);
this.xmlData=data;
},getID:function(){
var _d20=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:id",this.xmlData,this.ns);
if((_d20===null)||(_d20.length===0)){
return null;
}
var _d21=com.ibm.mm.enabler.dom.textContent(_d20[0]);
if((_d21===null)||(_d21.length===0)){
return null;
}
if(com.ibm.mm.enabler.model.UserModel.iConfig.getID){
return com.ibm.mm.enabler.model.UserModel.iConfig.getID(_d21);
}
var pos=_d21.indexOf("profiles/");
if(pos==-1){
pos=_d21.indexOf("profiles:");
}
var id=_d21.slice(pos+"profiles:".length);
return decodeURIComponent(id);
},getCN:function(){
var _d24=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='cn']/um:attributeValue",this.xmlData,this.ns);
if((_d24===null)||(_d24.length===0)){
return null;
}
var cn=com.ibm.mm.enabler.dom.textContent(_d24[0]);
return cn;
},getDisplayName:function(){
if((this.getID()==this.allAuthID)||(this.getID()==this.allAuthIDEncoded)){
this.iwStr=dojo.i18n.getLocalization("com.ibm.mm.enabler","iwStr");
return this.iwStr.ALL_AUTH;
}
var _d26=null;
var _d27=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='displayName']/um:attributeValue",this.xmlData,this.ns);
if((_d27!=null)&&(_d27.length>0)){
_d26=com.ibm.mm.enabler.dom.textContent(_d27[0]);
}
if((typeof _d26=="undefined")||(_d26==null)){
var _d28=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _d29=_d28.getValue(_d28.DEFAULT_GROUP_DISPLAY_PROP);
if((typeof _d29!="undefined")&&(_d29!=null)){
_d26=this.getAttribute(_d29);
}
}
if((typeof _d26=="undefined")||(_d26==null)){
_d26=this.getCN();
}
return _d26;
},getEntityType:function(){
return "group";
},getAttribute:function(_d2a){
var expr="atom:content/um:profile/um:attribute[@name='"+_d2a+"']/um:attributeValue";
var _d2c=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_d2c.length===0){
return null;
}
var _d2d=com.ibm.mm.enabler.dom.textContent(_d2c[0]);
return _d2d;
}});
dojo.declare("com.ibm.mm.enabler.user.AttributeImpl",null,{constructor:function(data){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_UM]);
this.xmlData=data;
},getName:function(){
var _d30=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:title",this.xmlData,this.ns);
if((_d30===null)||(_d30.length===0)){
return null;
}
var name=com.ibm.mm.enabler.dom.textContent(_d30[0]);
return name;
},getType:function(){
var _d32=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:attribute",this.xmlData,this.ns);
if((_d32===null)||(_d32.length===0)){
return null;
}
return _d32[0].getAttribute("type");
}});
dojo.declare("com.ibm.mm.enabler.user.AllAuthGroupImpl",[com.ibm.mm.enabler.user.EntityImpl],{constructor:function(_d33,_d34){
this.allAuthID=_d33;
this.allAuthIDEncoded=_d34;
},getID:function(){
return this.allAuthID;
},getCN:function(){
return "all authenticated portal users";
},getDisplayName:function(){
this.iwStr=dojo.i18n.getLocalization("com.ibm.mm.enabler","iwStr");
return this.iwStr.ALL_AUTH;
},getEntityType:function(){
return "group";
},getAttribute:function(_d35){
return null;
}});
dojo.declare("com.ibm.mm.enabler.user.AnonUserImpl",[com.ibm.mm.enabler.user.EntityImpl],{constructor:function(_d36,_d37){
this.anonUserID=_d36;
this.anonUserIDEncoded=_d37;
},getAttribute:function(_d38){
return null;
},getAttributeNames:function(){
return [];
},getID:function(){
return this.anonUserID;
},getLoginName:function(){
return "anonymous portal user";
},getSN:function(){
return "anonymous portal user";
},getCN:function(){
return "anonymous portal user";
},getEmail:function(){
return null;
},getDisplayName:function(){
this.iwStr=dojo.i18n.getLocalization("com.ibm.mm.enabler","iwStr");
return this.iwStr.ANON;
},getEntityType:function(){
return "user";
},setAttribute:function(name,_d3a){
return null;
},removeAttribute:function(name){
return null;
},getChangedAttributeNames:function(){
return {};
},getAddedAttributeNames:function(){
return {};
},getRemovedAttributeNames:function(){
return {};
},clearChangedAttributeNames:function(){
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.space"]){
dojo._hasResource["com.ibm.mm.enabler.model.space"]=true;
dojo.provide("com.ibm.mm.enabler.model.space");
dojo.declare("com.ibm.mm.enabler.model.SpaceModelImpl",[com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl,com.ibm.mm.enabler.SubmittableFormProviderImpl],{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
var _d3c="constructor()";
var _d3d=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_d3d){
this.LOGGER.entering(_d3c);
}
this.root=null;
this.loadedNodes={};
this.createdNodes={};
this.deletedNodes={};
this.failedNodes={};
this.initialContents={};
this.createdFavorites={};
this.deletedFavorites={};
this.cid=0;
this.start=null;
this.num=null;
this.sizeValue=9999;
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.um=com.ibm.mashups.enabler.model.Factory.getUserModel();
this.entries=[];
this.cursor=0;
this.size=null;
this.nextLink=null;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SPACE);
this.prefix=this.serviceJson.idprefix;
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_XHTML,this.nsf.NS_OPENSEARCH,this.nsf.NS_CA,this.nsf.NS_APP]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.xmlDom=com.ibm.mm.enabler.dom.createDocument();
this.spaceExtensionModel=com.ibm.mashups.enabler.model.Factory.getSpaceExtensionModel();
this.favoritesModel=null;
this.urlType=com.ibm.mashups.enabler.model.url.ModelUrlFactory.SPACE_URL;
if(_d3d){
this.LOGGER.exiting(_d3c);
}
},find:function(id){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,{"id":id,"ignoreDeletedNodes":false});
},_find:function(_d3f,sync,_d41){
var _d42="_find(params, deferred, sync)";
var _d43=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_d43){
this.LOGGER.entering(_d42,[_d41,_d3f,sync]);
}
var id=com.ibm.mm.enabler.model.Utils.getIdFromIdentifiable(_d41.id);
var _d45=_d41.ignoreDeletedNodes;
if(!_d45){
if(id in this.deletedNodes){
if(_d3f&&_d3f.finishedCallback2){
_d3f.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_d3f.finishedCallbackParameters2);
}
if(_d43){
this.LOGGER.exiting(_d42);
}
return null;
}
}
if(id in this.loadedNodes){
if(_d3f&&_d3f.finishedCallback2){
_d3f.finishedCallback2(this.loadedNodes[id],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_d3f.finishedCallbackParameters2);
}
if(_d43){
this.LOGGER.exiting(_d42,this.loadedNodes[id]);
}
return this.loadedNodes[id];
}
if(this.favoritesModel!=null){
if(id in this.favoritesModel.loadedNodes){
var node=this.favoritesModel.loadedNodes[id];
if(_d3f&&_d3f.finishedCallback2){
_d3f.finishedCallback2(node,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_d3f.finishedCallbackParameters2);
}
if(_d43){
this.LOGGER.exiting(_d42,node);
}
return node;
}
}
var _d47=null;
var href=com.ibm.mm.enabler.model.Utils.getHrefFromIdentifiable(_d41.id);
if(href){
_d47=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,this);
}else{
_d47=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_d47.setNodes([{value:id,isID:true}]);
}
_d47.addParameter("aspect","ac");
var _d49=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d47,null,null,false,sync);
var _d4a=null;
var _d4b={};
_d49.read(dojo.hitch(this,function(type,data,xhr,args){
var _d50="_find_callback(type, data, xhr, args)";
if(_d43){
this.LOGGER.entering(_d50,[type,data,xhr,args]);
}
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _d53=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _d54=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_d53,this.ns);
var _d55=new com.ibm.mm.enabler.space.SpaceNodeImpl(_d54[0],this.um,this);
this.newid=_d55.getID();
this.loadedNodes[this.newid]=_d55;
this.initialContents[this.newid]=_d55.toString();
if(this.createdFavorites&&this.createdFavorites[id]&&(this.createdFavorites[id]!=null)){
this.createdFavorites[this.newid]=_d55;
this.createdFavorites[id]=null;
}
if(this.deletedFavorites&&this.deletedFavorites[id]&&(this.deletedFavorites[id]!=null)){
this.deletedFavorites[this.newid]=_d55;
this.deletedFavorites[id]=null;
}
if(_d3f&&_d3f.finishedCallback2){
_d3f.finishedCallback2(this.loadedNodes[this.newid]||null,xhr.status,_d3f.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_d4b.status=xhr.status;
}
}
if(_d43){
this.LOGGER.exiting(_d50);
}
}));
if(_d4b.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_COMNODE_NOTFOUND_1,[id,_d4b.status]));
}
if(_d43){
this.LOGGER.exiting(_d42,this.loadedNodes[this.newid]);
}
return this.loadedNodes[this.newid];
},findSpaceByNavigation:function(_d56){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findSpaceByNavigation,_d56);
},_findSpaceByNavigation:function(_d57,sync,_d59){
var _d5a="_findSpaceByNavigation(deferred, sync, navNode)";
var _d5b=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_d5b){
this.LOGGER.entering(_d5a,[_d57,sync,_d59]);
}
if(typeof (_d59)=="string"){
if(_d57&&_d57.finishedCallback2){
_d57.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_d57.finishedCallbackParameters2);
}
if(_d5b){
this.LOGGER.exiting(_d5a);
}
return null;
}
var _d5c=_d59._getSpaceIdentifier();
if(_d5c==null){
if(_d57&&_d57.finishedCallback2){
_d57.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_d57.finishedCallbackParameters2);
}
if(_d5b){
this.LOGGER.exiting(_d5a);
}
return null;
}
return this._find(_d57,sync,{"id":_d5c,"ignoreDeletedNodes":false});
},findFavorites:function(){
if(typeof (this.favoritesModel)=="undefined"||this.favoritesModel==null||this.favoritesModel._isOld()){
this.favoritesModel=new com.ibm.mm.enabler.model.FavoritesIteratorImpl(null,this,this.um);
}else{
this.favoritesModel._reset();
}
return this.favoritesModel;
},create:function(_d5d){
var _d5e=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
_d5e.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom));
var _d5f=com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.ns.atom);
com.ibm.mm.enabler.dom.textContent(_d5f,"New Space");
_d5e.appendChild(_d5f);
var _d60=com.ibm.mm.enabler.model.Utils.createNode("atom:updated",this.ns.atom);
var time=new Date();
com.ibm.mm.enabler.dom.textContent(_d60,time.toGMTString());
_d5e.appendChild(_d60);
var _d62=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
_d62.setAttribute("type","application/xml");
var app=com.ibm.mm.enabler.model.Utils.createNode("ca:application",this.ns.ca);
if(_d5d){
if(_d5d.clonedSpace){
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom,app,"creation-context:app-id","app-id",this.ns["creation-context"],_d5d.clonedSpace);
}else{
if(_d5d.templateID){
app.setAttribute("ca:template-id",_d5d.templateID);
}
}
}
_d62.appendChild(app);
_d5e.appendChild(_d62);
var _d64=new com.ibm.mm.enabler.space.SpaceNodeImpl(_d5e,this.um,this);
_d64.setID((_d5d&&_d5d.cid)?_d5d.cid:""+this.cid++);
if(_d5d&&_d5d.clonedSpace){
_d64._setCopiedFrom(_d5d.clonedSpace);
}
return _d64;
},confirmCreate:function(_d65){
return this.getConfirmCreate();
},insert:function(node,_d67){
var id=node.getID();
this.createdNodes[id]=node;
},confirmInsert:function(node,_d6a){
return this.getConfirmInsert();
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_d6b,sync){
var _d6d="_commit(deferred, sync)";
var _d6e=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_d6e){
this.LOGGER.entering(_d6d,[_d6b,sync]);
}
this.statusCode=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
this.requestCount=0;
this._acquire();
if(this.favoritesModel&&(this.favoritesModel!=null)){
this.favoritesModel._setOld();
this.favoritesModel=null;
}
for(var id in this.loadedNodes){
if(_d6e){
this.LOGGER.trace(_d6d,"Checking if loaded space ${0} is modified",id);
}
var _d70=this.loadedNodes[id];
if(this.initialContents[id]!==this.loadedNodes[id].toString()){
if(_d6e){
this.LOGGER.trace(_d6d,"Space is modified, updating");
}
var _d71=this.spaceExtensionModel.findExtensionBySpace(_d70).start();
if(_d71){
var _d72=_d71.onSpaceUpdate(_d70.getID(),dojo.toJson(_d70._diffSpaceChanges(),true),null);
if(_d72&&_d72.getState()!="OK"){
if(_d6e){
this.LOGGER.trace(_d6d,"Space update aborted: "+_d70.getID());
this.LOGGER.trace(_d6d,"Space extension update problem: "+_d72.getLocaleMessage());
this.LOGGER.trace(_d6d,"Solution: "+_d72.getLocaleSolution());
}
continue;
}
}
var _d73=com.ibm.mm.enabler.model.Utils.createFeed("space:"+_d70.getID(),"IBM Lotus Mashups Space Feed",this.loadedNodes[id],this.ns);
var _d74=new com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(_d70.getEditLink(),this);
var _d75=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d74,null,null,false,true);
var _d76=null;
this._acquire();
_d75.update(_d73,dojo.hitch(this,function(type,data,xhr,args){
if(_d6b&&_d6b.operationCallback){
_d6b.operationCallback(this.loadedNodes[args],com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_d6b.operationCallbackParameters);
}
this._release(_d6b,xhr.status);
}));
this.initialContents[id]=this.loadedNodes[id].toString();
}
}
for(var _d7b in this.createdNodes){
if(_d6e){
this.LOGGER.trace(_d6d,"Processing new space");
}
var node=this.createdNodes[_d7b];
var _d7d=node.getID();
var _d7e=node._getCopiedFrom();
if(_d7e){
var _d71=this.spaceExtensionModel.findExtensionBySpace(_d7e).start();
if(_d71){
var _d72=_d71.canCopySpace(_d70.getID(),null);
if(_d72&&_d72.getState()!="OK"){
if(_d6e){
this.LOGGER.trace(_d6d,"Space copy aborted: "+_d7e);
this.LOGGER.trace(_d6d,"Space extension does not allow to copy this space.");
}
continue;
}
}
}
var _d74=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.serviceJson.url,this);
var _d75=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d74,null,null,false,true);
var _d76=null;
this._acquire();
_d75.create(node.toString(),dojo.hitch(this,function(type,data,xhr,args){
var _d83="_commit_create_callback(type, data, xhr, args)";
if(_d6e){
this.LOGGER.entering(_d83,[type,data,xhr,args]);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _d86=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _d87=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_d86,this.ns);
if(_d87&&_d87.length>0){
var _d88=new com.ibm.mm.enabler.space.SpaceNodeImpl(_d87[0],this.um,this);
this.newid=_d88.getID();
this.loadedNodes[this.newid]=_d88;
this.initialContents[this.newid]=_d88.toString();
this._cacheNode(_d88);
var len=this.entries.length;
if(len==0){
this.entries[0]=this.newid;
this.entries[1]=null;
}else{
if(len==1){
this.entries[1]=this.newid;
this.entries[2]=null;
}else{
if(this.entries[len-1]==null){
this.entries[len-1]=this.newid;
this.entries[len]=null;
}else{
this.entries[len]=this.newid;
this.entries[len+1]=null;
}
}
}
if(this.createdFavorites&&this.createdFavorites[_d7d]&&(this.createdFavorites[_d7d]!=null)){
this.createdFavorites[this.newid]=_d88;
this.createdFavorites[_d7d]=null;
}
if(this.deletedFavorites&&this.deletedFavorites[_d7d]&&(this.deletedFavorites[_d7d]!=null)){
this.deletedFavorites[this.newid]=_d88;
this.deletedFavorites[_d7d]=null;
}
var _d8a=this.spaceExtensionModel.findExtensionBySpace(_d88).start();
if(_d8a){
var _d8b="en";
var id=_d88.getID();
var _d8d=_d88.getTitle(_d8b);
var _d8e=_d88.getDescription(_d8b);
var _d8f=args;
var _d90=_d8f?_d8a.onSpaceCopy(_d8f,id,_d8d,_d8e,null):_d8a.onSpaceCreate(id,_d8d,_d8e,null);
if(_d90&&_d90.getState()!="OK"){
if(_d6e){
this.LOGGER.trace(_d83,"Space create/copy aborted: "+id);
this.LOGGER.trace(_d83,"Space extension update problem: "+_d90.getLocaleMessage());
this.LOGGER.trace(_d83,"Solution: "+_d90.getLocaleSolution());
}
this.failedNodes[id]=_d88;
}
}
}
}
if(_d6b&&_d6b.operationCallback){
_d6b.operationCallback(_d88,com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_d6b.operationCallbackParameters);
}
this._release(_d6b,xhr.status);
if(_d6e){
this.LOGGER.exiting(_d83);
}
}),_d7e);
}
this.createdNodes={};
for(var _d91 in this.failedNodes){
if(_d6e){
this.LOGGER.trace(_d6d,"Processing delete of space ${0}",id);
}
var _d74=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.failedNodes[_d91].getEditLink(),this);
var _d75=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d74,null,null,false,sync);
this._acquire();
_d75.remove(dojo.hitch(this,function(type,data,xhr,args){
var _d96="_commit_remove_callback(type, data, xhr, args)";
if(_d6e){
this.LOGGER.entering(_d96,[type,data,xhr,args]);
}
if(_d6b&&_d6b.operationCallback){
_d6b.operationCallback(newentry,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_d6b.operationCallbackParameters);
}
this._release(_d6b,xhr.status);
if(_d6e){
this.LOGGER.exiting(_d96,[type,data,xhr,args]);
}
}));
}
this.failedNodes={};
for(var id in this.deletedNodes){
if(_d6e){
this.LOGGER.trace(_d6d,"Processing delete of space ${0}",id);
}
var _d6b=new com.ibm.mm.enabler.DeferredImpl(this,this._find,{"id":id,"ignoreDeletedNodes":true});
var _d97=_d6b.start();
var _d71=this.spaceExtensionModel.findExtensionBySpace(_d97).start();
if(_d71){
var _d98=_d97.getID();
var _d72=_d71.canDeleteSpace(_d98,null);
if(_d72&&_d72.getState()!="OK"){
if(_d6e){
this.LOGGER.trace(_d6d,"Space delete aborted: "+_d97.getID());
this.LOGGER.trace(_d6d,"Space extension update problem: "+_d72.getLocaleMessage());
this.LOGGER.trace(_d6d,"Solution: "+_d72.getLocaleSolution());
}
continue;
}
_d72=_d71.onSpaceDelete(_d98,null);
if(_d72&&_d72.getState()!="OK"){
if(_d6e){
this.LOGGER.trace(_d6d,"Space delete aborted: "+_d97.getID());
this.LOGGER.trace(_d6d,"Space extension update problem: "+_d72.getLocaleMessage());
this.LOGGER.trace(_d6d,"Solution: "+_d72.getLocaleSolution());
}
continue;
}
}
var _d74=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.deletedNodes[id].getEditLink(),this);
var _d75=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d74,null,null,false,sync);
this._acquire();
_d75.remove(dojo.hitch(this,function(type,data,xhr,args){
var _d9d="_commit_remove_callback(type, data, xhr, args)";
if(_d6e){
this.LOGGER.entering(_d9d,[type,data,xhr,args]);
}
if(_d6b&&_d6b.operationCallback){
_d6b.operationCallback(newentry,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_d6b.operationCallbackParameters);
}
this._release(_d6b,xhr.status);
if(_d6e){
this.LOGGER.exiting(_d9d,[type,data,xhr,args]);
}
}));
}
this.deletedNodes={};
for(var id in this.deletedFavorites){
if(this.deletedFavorites[id]&&(this.deletedFavorites[id]!=null)){
if(_d6e){
this.LOGGER.trace(_d6d,"Processing delete of space-favorite ${0}",id);
}
var _d74=null;
var link=this.deletedFavorites[id]._getFavoriteURL();
if(typeof (link)=="string"){
_d74=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
if((typeof (link)=="undefined")||(link==null)){
_d74=new com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.SPACE_FAVORITE_URL,this);
_d74.setNodes([{value:id,isID:true}]);
}else{
_d74=link;
}
}
var _d75=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d74,null,null,false,sync);
this._acquire();
_d75.remove(dojo.hitch(this,function(type,data,xhr,args){
var _da3="_commit_remove_callback(type, data, xhr, args)";
if(_d6e){
this.LOGGER.entering(_da3,[type,data,xhr,args]);
}
if(_d6b&&_d6b.operationCallback){
_d6b.operationCallback(newentry,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_d6b.operationCallbackParameters);
}
this._release(_d6b,xhr.status);
if(_d6e){
this.LOGGER.exiting(_da3,[type,data,xhr,args]);
}
}));
}
}
this.deletedFavorites={};
for(var id in this.createdFavorites){
if(this.createdFavorites[id]&&(this.createdFavorites[id]!=null)){
if(_d6e){
this.LOGGER.trace(_d6d,"Processing create of space-favorite ${0}",id);
}
var _d73=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.nsf.getNameSpaceUri(this.nsf.NS_ATOM));
_d73.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.nsf.getNameSpaceUri(this.nsf.NS_ATOM)));
var _da4=com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.nsf.getNameSpaceUri(this.nsf.NS_ATOM));
com.ibm.mm.enabler.dom.textContent(_da4,"Adding a favorite space "+id);
_d73.appendChild(_da4);
var _da5=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.nsf.getNameSpaceUri(this.nsf.NS_ATOM));
_da5.setAttribute("type","application/xml");
var _da6=com.ibm.mm.enabler.model.Utils.createNode("ca:application-favorite",this.nsf.getNameSpaceUri(this.nsf.NS_CA));
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_da6,"ca:app-id",this.nsf.getNameSpaceUri(this.nsf.NS_CA),id);
_da5.appendChild(_da6);
_d73.appendChild(_da5);
var _d74=null;
var link=this.createdFavorites[id]._getFavoriteURL();
if(typeof (link)=="string"){
_d74=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
if((typeof (link)=="undefined")||(link==null)){
_d74=new com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.SPACE_FAVORITE_URL,this);
_d74.setNodes([{value:id,isID:true}]);
}else{
_d74=link;
}
}
var _d75=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_d74,null,null,false,sync);
this._acquire();
_d75.create(com.ibm.mm.enabler.dom.innerXML(_d73),dojo.hitch(this,function(type,data,xhr,args){
this._release(_d6b,xhr.status);
}));
}
}
this.createdFavorites={};
this._release(_d6b,0);
if(_d6b&&_d6b.finishedCallback2){
_d6b.finishedCallback2(null,_d6b.finishedCallback2Parameters);
}
if(_d6e){
this.LOGGER.exiting(_d6d);
}
},getSubmittableImportForm:function(id){
var _dac=null;
var url;
if(id=="spaceForm"){
url=new com.ibm.mm.enabler.model.UrlFactory.createModelUrl(com.ibm.mm.enabler.model.UrlFactory.SPACE_URL,null);
url.setNodes([{value:"collection",isID:false}]);
url.setParameter("mode","import");
url.setParameter("mime-type","text/html");
url=url.toProxifiedString();
_dac=new com.ibm.mm.enabler.SubmittableFormImpl(url,"post",id);
}else{
if(id=="pageForm"){
var _dae=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_RESOURCE);
url=new com.ibm.mm.enabler.model.UrlFactory.getModelUrl(_dae.url,this);
url.setParameter("mode","import");
url.setParameter("mime-type","text/html");
if(arguments[1]!=null){
url.setParameter("spaceId",arguments[1]);
}
url=url.toProxifiedString();
_dac=new com.ibm.mm.enabler.SubmittableFormImpl(url,"post",id);
}
}
return _dac;
},_acquire:function(){
this.requestCount++;
},_release:function(_daf,_db0){
this.statusCode=Math.max(parseInt(_db0,10),this.statusCode);
this.requestCount--;
if(this.requestCount<=0){
if(_daf&&_daf.finishedCallback2){
_daf.finishedCallback2(null,this.statusCode,_daf.finishedCallbackParameters2);
}
}
},remove:function(node){
var _db2="remove(node)";
var _db3=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_db3){
this.LOGGER.entering(_db2,node);
}
var id=node.getID();
var _db5=null;
if(id in this.loadedNodes){
_db5=this.loadedNodes[id];
delete this.loadedNodes[id];
}else{
if(this.favoritesModel!=null&&id in this.favoritesModel.loadedNodes){
_db5=this.favoritesModel.loadedNodes[id];
delete this.favoritesModel.loadedNodes[id];
}else{
_db5=node;
}
}
if(!(id in this.deletedNodes)){
this.deletedNodes[id]=_db5;
}
var _db6=null;
for(var i=0;i<this.entries.length;i++){
if(this.entries[i]==id){
_db6=i;
}
}
if(_db6!=null){
this.entries.splice(_db6,1);
if(this.cursor>_db6){
this.cursor--;
}
}
if(_db3){
this.LOGGER.exiting(_db2,node);
}
},confirmRemove:function(node){
var _db9=true;
var _dba=this.spaceExtensionModel.findExtensionBySpace(node).start();
if(_dba){
var _dbb=typeof (node)=="string"?node:node.getID();
var _dbc=_dba.canDeleteSpace(_dbb,null);
_db9=(_dbc==null||_dbc.getState()=="OK");
}
return this.getConfirmRemove(node)&&_db9;
},confirmExport:function(node){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
var _dbe=true;
var _dbf=this.spaceExtensionModel.findExtensionBySpace(node).start();
if(_dbf){
var _dc0=typeof (node)=="string"?node:node.getID();
var _dc1=_dbf.canExportSpace(_dc0,null);
_dbe=(_dc1==null||_dc1.getState()=="OK");
}
return _dbe;
},confirmCopy:function(node){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
var _dc3=true;
var _dc4=this.spaceExtensionModel.findExtensionBySpace(node).start();
if(_dc4){
var _dc5=typeof (node)=="string"?node:node.getID();
var _dc6=_dc4.canCopySpace(_dc5,null);
_dc3=(_dc6==null||_dc6.getState()=="OK");
}
return _dc3;
},iterator:function(){
return this;
},start:function(sync){
while(this._hasNext(this,sync)){
if(this._next(this,sync)){
continue;
}else{
break;
}
}
},hasNext:function(){
return this._hasNext(null,true);
},_hasNext:function(_dc8,sync){
var _dca=false;
if(this.entries[this.cursor]===undefined){
this._loadAhead(_dc8,sync);
}
var next=this.entries[this.cursor];
if(next!==null&&next!==undefined){
_dca=true;
}
return _dca;
},next:function(){
return this._next(null,true);
},_next:function(_dcc,sync){
return this._hasNext(_dcc,sync)?this.loadedNodes[this.entries[this.cursor++]]:null;
},size:function(){
return this.sizeValue;
},setCursorPosition:function(_dce){
this.cursor=_dce;
},getCursorPosition:function(){
return this.cursor;
},_loadAhead:function(_dcf,sync){
var _dd1="_loadAhead(deferred, sync)";
var _dd2=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_dd2){
this.LOGGER.entering(_dd1,[_dcf,sync]);
}
var _dd3;
if(!this.nextLink){
if(_dd2){
this.LOGGER.trace(_dd1,"Creating new model URL link");
}
_dd3=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.serviceJson.url,this);
}else{
if(_dd2){
this.LOGGER.trace(_dd1,"Reusing 'next' link");
}
_dd3=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.nextLink,this);
}
_dd3.addParameter("aspect","ac");
_dd3.setParameter("start",this.getCursorPosition());
if(this.strategy){
for(x in this.strategy){
if(this.strategy[x] instanceof com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy){
_dd3.setParameter("num",this.strategy[x].getInterval());
break;
}
}
}
var _dd4=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_dd3,null,null,false,sync);
var _dd5=this.entries;
var _dd6=0;
var _dd7=this.model;
_dd4.read(dojo.hitch(this,function(type,data,xhr,args){
var _ddc="_loadAhead_callback(type, data, xhr, args)";
if(_dd2){
this.LOGGER.entering(_ddc,[type,data,xhr,args]);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr;
if(!this.sizeValue){
expr="atom:feed/openSearch:totalResults";
var _dde=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_dde&&_dde.length>0){
this.sizeValue=com.ibm.mm.enabler.dom.textContent(_dde[0]);
if(_dd2){
this.LOGGER.trace(_ddc,"Total reported entry count: ${0}",this.sizeValue);
}
}
}
this.nextLink=null;
expr="atom:feed/atom:link[@rel='next']";
var _ddf=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_ddf&&_ddf.length>0){
this.nextLink=_ddf[0].getAttribute("href");
}
if(_dd2){
this.LOGGER.trace(_ddc,"New nextLink = ${0}",this.nextLink);
}
expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _de1=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _ddf=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_de1,this.ns);
_dd6=_ddf.length;
this.start=this.getCursorPosition();
for(var i=0;i<_ddf.length;++i){
var node=new com.ibm.mm.enabler.space.SpaceNodeImpl(_ddf[i],this.um,this);
this.entries[this.cursor+i]=node.getID();
this._cacheNode(node);
if(_dcf&&_dcf.foreachCallback){
_dcf.foreachCallback(this.loadedNodes[id],_dcf.foreachCallbackParameters);
}
}
this.entries[this.cursor+_ddf.length]=this.nextLink?undefined:null;
if(_dcf&&_dcf.finishedCallback2){
_dcf.finishedCallback2(null,xhr.status,_dcf.finishedCallbackParameters2);
}
}else{
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_dcf&&_dcf.finishedCallback2){
_dcf.finishedCallback2(null,xhr.status,_dcf.finishedCallbackParameters2);
}
}
}
if(_dd2){
this.LOGGER.exiting(_ddc,[type,data,xhr,args]);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.SpaceModelImpl._loadAhead");
},_cacheNode:function(node){
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.initialContents[id]=node.toString();
}
return this.loadedNodes[id];
}});
dojo.declare("com.ibm.mm.enabler.model.FavoritesIteratorImpl",com.ibm.mm.enabler.DeferredIteratorImpl,{constructor:function(_de6,_de7,um){
this.model=_de7;
this.entries=[];
this.cursor=0;
this.sizeValue=null;
this.um=um;
this.loadedNodes={};
this._old=false;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SPACE);
this.prefix=this.serviceJson.idprefix;
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_XHTML,this.nsf.NS_OPENSEARCH,this.nsf.NS_CA,this.nsf.NS_APP]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},_reset:function(){
this.cursor=0;
},start:function(){
this._start(true);
},_start:function(sync){
while(this.hasNext(this,sync)){
this.next(this,sync);
}
},hasNext:function(dfr,sync){
if(typeof this.entries[this.cursor]=="undefined"){
this._loadAhead(dfr||null,typeof sync=="undefined"?true:sync);
}
return this.entries[this.cursor]?true:false;
},next:function(dfr,sync){
return this._next(null,true);
},_next:function(dfr,sync){
return this.hasNext(dfr||null,typeof sync=="undefined"?true:sync)?this.loadedNodes[this.entries[this.cursor++]]:null;
},setCursorPosition:function(_df0){
this.cursor=_df0;
},getCursorPosition:function(){
return this.cursor;
},size:function(){
return new com.ibm.mm.enabler.DeferredImpl(this,this._size);
},_size:function(dfr,sync){
this.sizeValue!==null||this.hasNext(null,true);
if(dfr&&dfr.finishedCallback2){
dfr.finishedCallback2(this.sizeValue,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,dfr.finishedCallbackParameters2);
}
return this.sizeValue;
},_loadAhead:function(_df3,sync){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.FavoritesIteratorImpl._loadAhead",sync?"sync":"async");
this._old=false;
var _df5=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.serviceJson.url,this.model);
_df5.addParameter("aspect","ac");
_df5.setParameter("filter","is-favorite=true");
_df5.setParameter("rep","full");
this.sizeValue=0;
var _df6=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_df5,null,null,false,sync);
_df6.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed/atom:entry";
var _dfc=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var ii=0;
if(_dfc){
for(var i=0;i<_dfc.length;i++){
var node=new com.ibm.mm.enabler.space.SpaceNodeImpl(_dfc[i],this.um,this);
var id=node.getID();
if(this.model.deletedFavorites&&this.model.deletedFavorites[id]&&(this.model.deletedFavorites[id]!=null)){
}else{
this._cacheNode(node);
this.entries[this.cursor+i]=id;
ii++;
this.sizeValue++;
}
if(_df3&&_df3.foreachCallback){
_df3.foreachCallback(this.loadedNodes[id],_df3.foreachCallbackParameters);
}
}
}
var iii=0;
for(var id in this.model.createdFavorites){
if(this.model.createdFavorites&&this.model.createdFavorites[id]&&(this.model.createdFavorites[id]!=null)){
this._cacheNode(this.model.createdFavorites[id]);
this.entries[this.cursor+ii+iii]=id;
iii++;
this.sizeValue++;
}
}
this.entries[this.cursor+_dfc.length]=null;
if(_df3&&_df3.finishedCallback2){
_df3.finishedCallback2(null,xhr.status,_df3.finishedCallbackParameters2);
}
}else{
if(_df3&&_df3.finishedCallback2){
_df3.finishedCallback2(null,xhr.status,_df3.finishedCallbackParameters2);
}
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.FavoritesIteratorImpl._loadAhead");
},_cacheNode:function(node){
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
}
return this.loadedNodes[id];
},_setOld:function(){
this._old=true;
this.entries=[];
this.cursor=0;
this.sizeValue=null;
this.loadedNodes={};
},_isOld:function(){
return this._old;
}});
dojo.declare("com.ibm.mm.enabler.space.SpaceNodeImpl",[com.ibm.mashups.enabler.space.SpaceNode,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.MetaDataImpl3,com.ibm.mm.enabler.EditLinkProviderImpl],{constructor:function(node,_um,_e06){
this.xmlData=node;
this.um=_um;
this.spaceModel=_e06;
this.cs=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
this.owner=null;
this.isFavoriteTracker=null;
this.isSpaceFavorite=false;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SPACE);
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_CA,nsf.NS_CREATION_CONTEXT]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.li_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML,nsf.NS_CA]);
for(prefix in this.serviceJson.namespaces){
this.li_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.NLS_TITLE="atom:content/ca:application/ca:title";
this.NLS_TITLE_TOP="atom:content/ca:application";
this.NLS_DESCRIPTION="atom:content/ca:application/ca:description";
this.NLS_DESCRIPTION_TOP="atom:content/ca:application";
this.BASE_TITLE="ca:title";
this.BASE_DESCRIPTION="ca:description";
this.BASE_NS=this.li_ns.ca;
this.changedProperties={};
this.sourceSpaceID=null;
},_getOwner:function(){
if(this.owner==null){
var expr="atom:content/ca:application/ca:owner";
var _e09=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_e09&&_e09.length>0){
var _e0a=com.ibm.mm.enabler.utilities.getAttributeWithNS(_e09[0],"ca:id","id",this.ns["ca"]);
this.owner=this.um.find(_e0a).start();
}
}
return this.owner;
},_setOwner:function(user){
if(this.changedProperties.owner==null){
this.changedProperties.owner=this._getOwner();
}
this.owner=user;
var expr="atom:content/ca:application/ca:owner";
var _e0d=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_e0d&&_e0d.length>0){
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_e0d[0],"ca:id",this.ns["ca"],user.getID());
}else{
expr="atom:content/ca:application";
var _e0e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_e0e&&_e0e.length>0){
var tn=com.ibm.mm.enabler.dom.createElement(this.xmlData.ownerDocument,"ca:owner",this.ns["ca"]);
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(tn,"ca:id",this.ns["ca"],user.getID());
_e0e[0].appendChild(tn);
}
}
},_getSpaceModel:function(){
return this.spaceModel;
},getExportSpaceURL:function(){
var expr="atom:link[@ca:rel='application-export']";
var _e11=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
var _e12=_e11[0].getAttribute("href");
return _e12;
},getExportTemplateURL:function(){
var expr="atom:link[@ca:rel='template-export']";
var _e14=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
var _e15=_e14[0].getAttribute("href");
return _e15;
},isHidden:function(){
var ret1=(this.getMetaData(this._getHiddenMetaNameFixed())=="true")?true:false;
var ret2=(this.getMetaData(this._getHiddenMetaNameDynamic())=="true")?true:false;
return (ret1||ret2);
},setHidden:function(hide){
var name=this._getHiddenMetaNameDynamic();
this.setMetaData(name,(hide)?"true":"false");
},confirmSetHidden:function(hide){
var ret1=this.confirmSetMetaData(this._getHiddenMetaNameFixed(),(hide)?"true":"false");
var ret2=this.confirmSetMetaData(this._getHiddenMetaNameDynamic(),(hide)?"true":"false");
return (ret1&&ret2);
},_getHiddenMetaNameFixed:function(){
return "{http://www.ibm.com/xmlns/prod/lotus/mashups/v1.0/extensions}com.ibm.mashups.space.hidden";
},_getHiddenMetaNameDynamic:function(){
var name=this.cs.getValue("com.ibm.mashups.space.hidden");
if(name.search("^{http://.*}.+")==-1){
name="{http://www.ibm.com/xmlns/prod/lotus/mashups/v1.0/extensions}"+name;
}
return name;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
},getRootNavigation:function(){
var expr="atom:link[@ca:rel='navigation']";
var _e1f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_e1f&&_e1f.length>0){
var id=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,_e1f[0]);
var href=_e1f[0].getAttribute("href");
var _e22=new com.ibm.mm.enabler.IdentifierImpl(id,{"href":href});
}
return _e22||null;
},saveAsTemplate:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._saveAsTemplate);
},_saveAsTemplate:function(_e23,sync){
var _e25=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
_e25.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom));
_e25.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.ns.atom));
var _e26=com.ibm.mm.enabler.model.Utils.createNode("atom:updated",this.ns.atom);
var time=new Date();
com.ibm.mm.enabler.dom.textContent(_e26,time.toGMTString());
_e25.appendChild(_e26);
var _e28=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
_e28.setAttribute("type","application/xml");
var _e29=com.ibm.mm.enabler.model.Utils.createNode("ca:template",this.ns.ca);
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_e29,"creation-context:app-id",this.ns["creation-context"],this.getID());
var _e2a=this.getLocales();
for(var i=0;i<_e2a.length;i++){
var _e2c=com.ibm.mm.enabler.model.Utils.createNode("ca:title",this.ns.ca);
_e2c.setAttribute("xml:lang",_e2a[i]);
com.ibm.mm.enabler.dom.textContent(_e2c,this.getTitle(_e2a[i]));
_e29.appendChild(_e2c);
var _e2d=com.ibm.mm.enabler.model.Utils.createNode("ca:description",this.ns.ca);
_e2d.setAttribute("xml:lang",_e2a[i]);
com.ibm.mm.enabler.dom.textContent(_e2d,this.getDescription(_e2a[i]));
_e29.appendChild(_e2d);
}
_e28.appendChild(_e29);
_e25.appendChild(_e28);
var _e2e=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_TEMPLATE);
var _e2f=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(_e2e.url,this.spaceModel);
var _e30=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_e2f,null,null,false,sync);
_e30.create(com.ibm.mm.enabler.dom.innerXML(_e25),dojo.hitch(this,function(type,data,xhr,args){
if(_e23&&_e23.operationCallback){
_e23.operationCallback(_e25,com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_e23.operationCallbackParameters);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_e23.errorCallback){
_e23.errorCallback(xhr.status,_e23.errorCallbackParameters);
}
}
}));
},setTitle:function(_e35,_e36){
if(this.changedProperties.title==null){
this.changedProperties.title={};
}
if(this.changedProperties.title[_e36]==null){
this.changedProperties.title[_e36]=this.getTitle(_e36);
}
this.inherited(arguments);
},setDescription:function(desc,_e38){
if(this.changedProperties.description==null){
this.changedProperties.description={};
}
if(this.changedProperties.description[_e38]==null){
this.changedProperties.description[_e38]=this.getDescription(_e38);
}
this.inherited(arguments);
},setMetaData:function(name,_e3a){
if(this.changedProperties.metadata==null){
this.changedProperties.metadata={};
}
if(this.changedProperties.metadata[name]==null){
this.changedProperties.metadata[name]=this.getMetaData(name);
}
this.inherited(arguments);
},removeMetaData:function(name){
if(this.changedProperties.metadata==null){
this.changedProperties.metadata={};
}
if(this.changedProperties.metadata[name]==null){
this.changedProperties.metadata[name]=this.getMetaData(name);
}
this.inherited(arguments);
},_getSpaceExtensionURL:function(){
return this.getMetaData("{http://www.ibm.com/xmlns/prod/lotus/mashups/v1.0/extensions}com.ibm.space.extension_url");
},_setCopiedFrom:function(_e3c){
this.sourceSpaceID=_e3c;
},_getCopiedFrom:function(){
return this.sourceSpaceID;
},_diffSpaceChanges:function(){
var _e3d={};
if("owner" in this.changedProperties){
var _e3e=(this.changedProperties.owner==null)?"":this.changedProperties.owner.getID();
var _e3f=this._getOwner();
var _e40=(_e3f==null)?"":_e3f.getID();
if(_e40!=_e3e){
_e3d.owner=_e40;
}
}
if("title" in this.changedProperties){
for(var _e41 in this.changedProperties.title){
var _e42=this.getTitle(_e41);
if(_e42!=this.changedProperties.title[_e41]){
if(_e3d.title==null){
_e3d.title={};
}
_e3d.title[_e41]=_e42;
}
}
}
if("description" in this.changedProperties){
for(var _e41 in this.changedProperties.description){
var _e43=this.getDescription(_e41);
if(_e43!=this.changedProperties.description[_e41]){
if(_e3d.description==null){
_e3d.description={};
}
_e3d.description[_e41]=_e43;
}
}
}
if("metadata" in this.changedProperties){
for(var name in this.changedProperties.metadata){
var _e45=this.getMetaData(name);
if(_e45!=this.changedProperties.metadata[name]){
if(_e3d.metadata==null){
_e3d.metadata={};
}
_e3d.metadata[name]=_e45;
}
}
}
this.changedProperties={};
return _e3d;
},_getFavoriteURL:function(){
var _e46=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ca:rel='favorite']",this.xmlData,this.ns);
if(_e46&&_e46.length>0){
return _e46[0].getAttribute("href");
}
return null;
},isFavorite:function(){
if(this.isFavoriteTracker==this){
return this.isSpaceFavorite;
}
var ret=false;
if(this.spaceModel.deletedFavorites&&this.spaceModel.deletedFavorites[this.getID()]&&(this.spaceModel.deletedFavorites[this.getID()]==this)){
ret=false;
}else{
if(this.spaceModel.createdFavorites&&this.spaceModel.createdFavorites[this.getID()]&&(this.spaceModel.createdFavorites[this.getID()]==this)){
ret=true;
}else{
var _e48=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:link[@ca:rel='favorite']",this.xmlData,this.ns);
if(_e48&&_e48.length>0){
ret=true;
}
}
}
this.isFavoriteTracker=this;
this.isSpaceFavorite=ret;
return ret;
},setFavorite:function(_e49){
this.isFavoriteTracker=this;
if(this.spaceModel.favoritesModel&&(this.spaceModel.favoritesModel!=null)){
this.spaceModel.favoritesModel._setOld();
}
if(_e49){
this.spaceModel.createdFavorites[this.getID()]=this;
if(this.spaceModel.deletedFavorites&&this.spaceModel.deletedFavorites[this.getID()]){
this.spaceModel.deletedFavorites[this.getID()]=null;
}
this.isSpaceFavorite=true;
return true;
}else{
this.spaceModel.deletedFavorites[this.getID()]=this;
if(this.spaceModel.createdFavorites&&this.spaceModel.createdFavorites[this.getID()]){
this.spaceModel.createdFavorites[this.getID()]=null;
}
return false;
}
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.template"]){
dojo._hasResource["com.ibm.mm.enabler.model.template"]=true;
dojo.provide("com.ibm.mm.enabler.model.template");
dojo.require("com.ibm.mm.enabler.model.user");
dojo.require("com.ibm.mm.enabler.aspects");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mashups.enabler.model");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("dojo.i18n");
dojo.declare("com.ibm.mm.enabler.model.TemplateModelImpl",[com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
var _e4a="constructor()";
var _e4b=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_e4b){
this.LOGGER.entering(_e4a);
}
this.root=null;
this.loadedNodes={};
this.createdNodes={};
this.deletedNodes={};
this.initialContents={};
this.start=null;
this.num=null;
this.sizeValue=9999;
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.entries=[];
this.cursor=0;
this.size=null;
this.nextLink=null;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_TEMPLATE);
this.prefix=this.serviceJson.idprefix;
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_XHTML,this.nsf.NS_OPENSEARCH,this.nsf.NS_CA,this.nsf.NS_APP]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.urlType=com.ibm.mashups.enabler.model.url.ModelUrlFactory.TEMPLATE_URL;
if(_e4b){
this.LOGGER.exiting(_e4a);
}
},find:function(id){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,id);
},_find:function(_e4d,sync,id){
var _e50="_find(id, deferred, sync)";
var _e51=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_e51){
this.LOGGER.entering(_e50,[id,_e4d,sync]);
}
if(id in this.deletedNodes){
if(_e4d&&_e4d.finishedCallback2){
_e4d.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_e4d.finishedCallbackParameters2);
}
if(_e51){
this.LOGGER.exiting(_e50);
}
return null;
}
if(id in this.loadedNodes){
if(_e4d&&_e4d.finishedCallback2){
_e4d.finishedCallback2(this.loadedNodes[id],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_e4d.finishedCallbackParameters2);
}
if(_e51){
this.LOGGER.exiting(_e50,this.loadedNodes[id]);
}
return this.loadedNodes[id];
}
var _e52=null;
var href=com.ibm.mm.enabler.model.Utils.getHrefFromIdentifiable(id);
if(href){
_e52=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,this);
}else{
_e52=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.urlType,this);
_e52.setNodes([{value:id,isID:true}]);
}
_e52.addParameter("aspect","ac");
var _e54=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_e52,null,null,false,sync);
var _e55=null;
var _e56={};
_e54.read(dojo.hitch(this,function(type,data,xhr,args){
var _e5b="_find_callback(type, data, xhr, args)";
if(_e51){
this.LOGGER.entering(_e5b,[type,data,xhr,args]);
}
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _e5e=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _e5f=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_e5e,this.ns);
var _e60=new com.ibm.mm.enabler.template.TemplateNodeImpl(_e5f[0]);
this.newid=_e60.getID();
this.loadedNodes[this.newid]=_e60;
this.initialContents[this.newid]=_e60.toString();
if(_e4d&&_e4d.finishedCallback2){
_e4d.finishedCallback2(this.loadedNodes[this.newid]||null,xhr.status,_e4d.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_e56.status=xhr.status;
}
}
if(_e51){
this.LOGGER.exiting(_e5b);
}
}));
if(_e56.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_COMNODE_NOTFOUND_1,[id,_e56.status]));
}
if(_e51){
this.LOGGER.exiting(_e50,this.loadedNodes[this.newid]);
}
return this.loadedNodes[this.newid];
},create:function(_e61){
return null;
},confirmCreate:function(_e62){
return this.getConfirmCreate();
},insert:function(node,_e64){
var id=node.getID();
this.createdNodes[id]=node;
},confirmInsert:function(node,_e67){
return this.getConfirmInsert(_e67);
},confirmExport:function(node){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
return true;
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_e69,sync){
var _e6b="_commit(deferred, sync)";
var _e6c=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_e6c){
this.LOGGER.entering(_e6b,[_e69,sync]);
}
this.statusCode=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
this.requestCount=0;
this._acquire();
for(id in this.loadedNodes){
}
for(count in this.createdNodes){
}
this.createdNodes={};
for(id in this.deletedNodes){
if(_e6c){
this.LOGGER.trace(_e6b,"Processing delete of template ${0}",id);
}
var _e6d=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.deletedNodes[id].getEditLink(),this);
var _e6e=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_e6d,null,null,false,sync);
this._acquire();
_e6e.remove(dojo.hitch(this,function(type,data,xhr,args){
var _e73="_commit_remove_callback(type, data, xhr, args)";
if(_e6c){
this.LOGGER.entering(_e73,[type,data,xhr,args]);
}
if(_e69&&_e69.operationCallback){
_e69.operationCallback(newentry,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_e69.operationCallbackParameters);
}
this._release(_e69,xhr.status);
if(_e6c){
this.LOGGER.exiting(_e73,[type,data,xhr,args]);
}
}));
}
this.deletedNodes={};
this._release(_e69,0);
if(_e69&&_e69.finishedCallback2){
_e69.finishedCallback2(null,_e69.finishedCallback2Parameters);
}
if(_e6c){
this.LOGGER.exiting(_e6b);
}
},_acquire:function(){
this.requestCount++;
},_release:function(_e74,_e75){
this.statusCode=Math.max(parseInt(_e75,10),this.statusCode);
this.requestCount--;
if(this.requestCount<=0){
if(_e74&&_e74.finishedCallback2){
_e74.finishedCallback2(null,this.statusCode,_e74.finishedCallbackParameters2);
}
}
},remove:function(node){
var _e77="remove(node)";
var _e78=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_e78){
this.LOGGER.entering(_e77,node);
}
var id=node.getID();
if(!(id in this.deletedNodes)){
this.deletedNodes[id]=this.loadedNodes[id];
}
if(id in this.loadedNodes){
delete this.loadedNodes[id];
}
if(_e78){
this.LOGGER.exiting(_e77,node);
}
},confirmRemove:function(node){
return this.getConfirmRemove(node);
},iterator:function(){
return this;
},start:function(sync){
while(this._hasNext(this,sync)){
if(this._next(this,sync)){
continue;
}else{
break;
}
}
},hasNext:function(){
return this._hasNext(null,true);
},_hasNext:function(_e7c,sync){
var _e7e=false;
if(this.entries[this.cursor]===undefined){
this._loadAhead(_e7c,sync);
}
var next=this.entries[this.cursor];
if(next!==null&&next!==undefined){
_e7e=true;
}
return _e7e;
},next:function(){
return this._next(null,true);
},_next:function(_e80,sync){
return this._hasNext(_e80,sync)?this.loadedNodes[this.entries[this.cursor++]]:null;
},size:function(){
return this.sizeValue;
},setCursorPosition:function(_e82){
this.cursor=_e82;
},getCursorPosition:function(){
return this.cursor;
},_loadAhead:function(_e83,sync){
var _e85="_loadAhead(deferred, sync)";
var _e86=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_e86){
this.LOGGER.entering(_e85,[_e83,sync]);
}
var _e87;
if(!this.nextLink){
if(_e86){
this.LOGGER.trace(_e85,"Creating new model URL link");
}
_e87=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.serviceJson.url,this);
_e87.setParameter("start",this.getCursorPosition());
if(this.strategy){
for(x in this.strategy){
if(this.strategy[x] instanceof com.ibm.mm.enabler.strategy.PageLoadAheadStrategyImpl){
_e87.setParameter("num",this.strategy[x].getInterval());
break;
}
}
}
}else{
if(_e86){
this.LOGGER.trace(_e85,"Reusing 'next' link");
}
_e87=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.nextLink,this);
}
_e87.addParameter("aspect","ac");
var _e88=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_e87,null,null,false,sync);
var _e89=this.entries;
var _e8a=0;
var _e8b=this.model;
_e88.read(dojo.hitch(this,function(type,data,xhr,args){
var _e90="_loadAhead_callback(type, data, xhr, args)";
if(_e86){
this.LOGGER.entering(_e90,[type,data,xhr,args]);
}
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr;
if(!this.sizeValue){
expr="atom:feed/openSearch:totalResults";
var _e92=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_e92&&_e92.length>0){
this.sizeValue=com.ibm.mm.enabler.dom.textContent(_e92[0]);
if(_e86){
this.LOGGER.trace(_e90,"Total reported entry count: ${0}",this.sizeValue);
}
}
}
this.nextLink=null;
expr="atom:feed/atom:link[@rel='next']";
var _e93=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_e93&&_e93.length>0){
this.nextLink=_e93[0].getAttribute("href");
}
if(_e86){
this.LOGGER.trace(_e90,"New nextLink = ${0}",this.nextLink);
}
expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _e95=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _e93=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_e95,this.ns);
_e8a=_e93.length;
this.start=this.getCursorPosition();
for(var i=0;i<_e93.length;++i){
var node=new com.ibm.mm.enabler.template.TemplateNodeImpl(_e93[i]);
this.entries[this.cursor+i]=node.getID();
this._cacheNode(node);
if(_e83&&_e83.foreachCallback){
_e83.foreachCallback(this.loadedNodes[id],_e83.foreachCallbackParameters);
}
}
this.entries[this.cursor+_e93.length]=this.nextLink?undefined:null;
if(_e83&&_e83.finishedCallback2){
_e83.finishedCallback2(null,xhr.status,_e83.finishedCallbackParameters2);
}
}else{
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_e83&&_e83.finishedCallback2){
_e83.finishedCallback2(null,xhr.status,_e83.finishedCallbackParameters2);
}
}
}
if(_e86){
this.LOGGER.exiting(_e90,[type,data,xhr,args]);
}
}));
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.TemplateModelImpl._loadAhead");
},_cacheNode:function(node){
var id=node.getID();
if(!(id in this.loadedNodes)){
this.loadedNodes[id]=node;
this.initialContents[id]=node.toString();
}
return this.loadedNodes[id];
}});
dojo.declare("com.ibm.mm.enabler.template.TemplateNodeImpl",[com.ibm.mashups.enabler.template.TemplateNode,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.LocalizedImpl,com.ibm.mm.enabler.EditLinkProviderImpl],{constructor:function(node){
this.xmlData=node;
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_TEMPLATE);
this.prefix=this.serviceJson.idprefix;
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_CA,nsf.NS_CREATION_CONTEXT]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.li_ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_XML,nsf.NS_CA]);
for(prefix in this.serviceJson.namespaces){
this.li_ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.NLS_TITLE="atom:content/ca:template/ca:title";
this.NLS_TITLE_TOP="atom:content/ca:template";
this.NLS_DESCRIPTION="atom:content/ca:template/ca:description";
this.NLS_DESCRIPTION_TOP="atom:content/ca:template";
this.BASE_TITLE="ca:title";
this.BASE_DESCRIPTION="ca:description";
this.BASE_NS=this.li_ns.ca;
},getExportURL:function(){
var expr="atom:link[@ca:rel='template-export']";
var _e9d=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
var _e9e=_e9d[0].getAttribute("href");
return _e9e;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.ac"]){
dojo._hasResource["com.ibm.mm.enabler.model.ac"]=true;
dojo.provide("com.ibm.mm.enabler.model.ac");
dojo.declare("com.ibm.mm.enabler.ac.AccessControlModelFactoryImpl",com.ibm.mashups.enabler.ac.AccessControlModelFactory,{constructor:function(){
this._resourceACModels={};
this._resourceSpaceACModels={};
},getAccessControlModel:function(_e9f){
return this._sortOutParams(null,_e9f);
},getAccessControlModel:function(_ea0){
return this._sortOutParams(_ea0,null);
},getAccessControlModel:function(_ea1,_ea2){
return this._sortOutParams(_ea1,_ea2);
},_sortOutParams:function(_ea3,_ea4){
var ret=null;
var _ea6=null;
var _ea7=null;
if((_ea3==null)&&(_ea4==null)){
return null;
}
if(_ea3){
if(_ea3 instanceof com.ibm.mashups.enabler.layout.LayoutNode){
_ea7=_ea3;
}else{
if(_ea3 instanceof com.ibm.mashups.enabler.space.SpaceNode){
_ea6=_ea3;
}
}
}
if(_ea4){
if(_ea4 instanceof com.ibm.mashups.enabler.layout.LayoutNode){
_ea7=_ea4;
}else{
if(_ea4 instanceof com.ibm.mashups.enabler.space.SpaceNode){
_ea6=_ea4;
}
}
}
if(_ea7&&_ea6){
var ret=null;
if(this._resourceSpaceACModels[_ea6.getID()]){
ret=this._resourceSpaceACModels[_ea6.getID()][_ea7.getID()];
}
if(!ret){
ret=new com.ibm.mm.enabler.ac.ResourceSpaceAccessControlModelImpl(_ea6,_ea7);
if(!this._resourceSpaceACModels[_ea6.getID()]){
this._resourceSpaceACModels[_ea6.getID()]={};
}
this._resourceSpaceACModels[_ea6.getID()][_ea7.getID()]=ret;
}else{
ret._init();
return ret;
}
}else{
if(_ea7){
var ret=this._resourceACModels[_ea7.getID()];
if(!ret){
ret=new com.ibm.mm.enabler.ac.ResourceAccessControlModelImpl(_ea7);
this._resourceACModels[_ea7.getID()]=ret;
}else{
ret._init();
return ret;
}
}else{
if(_ea6){
return new com.ibm.mm.enabler.ac.SpaceAccessControlModelImpl(_ea6);
}
}
}
if(ret!=null){
ret._init();
ret._loadAheadResource(null,true);
}
return ret;
}});
dojo.declare("com.ibm.mm.enabler.ac.AccessControlModelImpl",[com.ibm.mashups.enabler.ac.AccessControlModel,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.ACLinkProviderImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(_ea8){
this.mainResource=_ea8;
this.url=com.ibm.mashups.enabler.model.url.ModelUrlFactory.AI_URL;
},_init:function(){
this.initialContentsMembers=null;
this.rolesLoadedNodes={};
this.rolesCreatedNodes={};
this.roleModel=undefined;
this.rolesStart=null;
this.rolesNum=null;
this.rolesSizeValue=9999;
this.rolesEntries=[];
this.rolesCursor=0;
this.rolesSize=null;
this.membersLoadedNodes={};
this.membersCreatedNodes={};
this.membersDeletedNodes={};
this.membersDeletedNodesMemberIDs={};
this.memberModel={};
this.membersEntries={};
this.membersCursor={};
this.membersSize={};
this.xmlDataMember={};
this.initialContentsMember={};
this.owner=null;
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.um=com.ibm.mashups.enabler.model.Factory.getUserModel();
this.prefix="resource";
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_XML,this.nsf.NS_OPENSEARCH,this.nsf.NS_AC,this.nsf.NS_AI,this.nsf.NS_APP,this.nsf.NS_CA]);
this.changedProperties={};
},_isPageInSpace:function(){
return false;
},_getPossibleRoles:function(){
return null;
},_getRolesLink:function(){
return null;
},_getMembersLink:function(_ea9){
return null;
},_getCreationRoleName:function(_eaa){
return null;
},_getCreationResourceID:function(){
return this.mainResource.getID();
},_filterRole:function(node){
return false;
},setID:function(id){
throw new Error(this.modelMessages.E_UNSUPPORTED_OP_0);
},getRoleModel:function(){
if(this.roleModel===undefined){
this._loadAheadRole(null,true);
}
return this.roleModel;
},getRoleModel:function(_ead){
if(this.roleModel===undefined){
this._loadAheadRole(null,true);
}
return this.roleModel;
},confirmGetRoleModel:function(){
if(com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS){
return false;
}
return this.mainResource.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
},_loadAheadRole:function(_eae,sync){
var _eb0;
this.rolesEntries=[];
this.rolesStart=0;
this.rolesCursor=0;
var _eb1=this._getPossibleRoles();
if((this._isPageInSpace())&&(_eb1)){
var i=0;
for(var _eb3 in _eb1){
var _eb4=_eb1[_eb3];
var _eb0=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url,this);
var _eb5=[{value:"collection",isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE},{value:this.mainResource.getID(),isID:true}];
_eb0.setNodes(_eb5);
_eb0.setParameter("filter","type="+_eb4);
this.__loadAheadRole(_eb0,_eae,sync,i,_eb3);
i++;
}
this.roleModel=new com.ibm.mm.enabler.ac.RoleModelImpl(this,this.um);
}else{
if(!this.rolesNextLink){
var link=this._getRolesLink();
if(link){
_eb0=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
_eb0=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url,this);
var _eb5=[{value:"collection",isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE},{value:this.mainResource.getID(),isID:true}];
_eb0.setNodes(_eb5);
}
}else{
_eb0=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(this.rolesNextLink,this);
}
_eb0.setParameter("start",this.rolesPosition);
if(this.url===com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL){
_eb0.setParameter("filter","all");
}
if(this.strategy){
for(x in this.strategy){
if(this.strategy[x] instanceof com.ibm.mm.enabler.strategy.PageLoadAheadStrategyImpl){
_eb0.setParameter("num",this.strategy[x].getInterval());
break;
}
}
}
this.__loadAheadRole(_eb0,_eae,sync,null);
}
},__loadAheadRole:function(_eb7,_eb8,sync,_eba,_ebb){
var _ebc=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_eb7,null,null,false,sync);
_ebc.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr;
if(_eba==null){
if(!this.rolesSizeValue){
expr="atom:feed/openSearch:totalResults";
var _ec2=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_ec2&&_ec2.length>0){
this.rolesSizeValue=com.ibm.mm.enabler.dom.textContent(_ec2[0]);
}
}
this.rolesNextLink=null;
expr="atom:feed/atom:link[@rel='next']";
var _ec3=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_ec3&&_ec3.length>0){
this.rolesNextLink=_ec3[0].getAttribute("href");
}
}
expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _ec5=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _ec3=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_ec5,this.ns);
if(_ec3.length>0){
if(_eba==null){
for(var i=0,c=0;i<_ec3.length;i++){
var node=new com.ibm.mm.enabler.ac.RoleNodeImpl(_ec3[i],this.um);
if(this._filterRole(node)){
continue;
}
this.rolesEntries[this.rolesCursor+c]=node.getID();
this._cacheNodeRoles(node);
c++;
if(_eb8&&_eb8.foreachCallback){
_eb8.foreachCallback(this.rolesLoadedNodes[id],_eb8.foreachCallbackParameters);
}
}
}else{
for(var i=0,c=0;i<_ec3.length;i++){
var node=new com.ibm.mm.enabler.ac.RoleNodeImpl(_ec3[i],this.um,_ebb);
if(this._filterRole(node)){
continue;
}
this.rolesEntries[this.rolesCursor+_eba+c]=node.getID();
this._cacheNodeRoles(node);
c++;
}
}
}
if(_eba==null){
this.rolesEntries[this.rolesEntries.length]=this.rolesNextLink?undefined:null;
this.roleModel=new com.ibm.mm.enabler.ac.RoleModelImpl(this,this.um);
}else{
this.rolesEntries[this.rolesEntries.length]=null;
}
if(_eb8&&_eb8.finishedCallback2){
_eb8.finishedCallback2(null,xhr.status,_eb8.finishedCallbackParameters2);
}
}else{
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_eb8&&_eb8.finishedCallback2){
_eb8.finishedCallback2(null,xhr.status,_eb8.finishedCallbackParameters2);
}
}
}
}));
},_cacheNodeRoles:function(node){
var id=node.getID();
if(!(id in this.rolesLoadedNodes)){
this.rolesLoadedNodes[id]=node;
}
return this.rolesLoadedNodes[id];
},_replaceNodeRoles:function(_ecb,_ecc){
if(_ecb!=null){
var _ecd=_ecb.getID();
var _ece=_ecc.getID();
var len=this.rolesEntries.length;
if(len<=1){
this.rolesEntries=[];
this.rolesEntries[0]=_ecc.getID();
}else{
for(var i=0;i<len;i++){
var id=this.rolesEntries[i];
if(id==_ecd){
this.rolesEntries[i]=_ece;
if(this.membersCreatedNodes[_ecd]){
this.membersCreatedNodes[_ece]=this.membersCreatedNodes[_ecd];
delete this.membersCreatedNodes[_ecd];
}
break;
}
}
}
delete this.rolesCreatedNodes[_ecd];
delete this.rolesLoadedNodes[_ecd];
}
this._cacheNodeRoles(_ecc);
},_loadAheadMember:function(role,_ed3,sync){
this._loadMemberModel(role.getID(),role.getRoleType(),this._getMembersLink(role.xmlData),null,true);
},_loadMemberModel:function(id,_ed6,link,_ed8,sync){
this.memberModel[id]=null;
this.membersLoadedNodes[id]={};
this.membersCreatedNodes[id]={};
this.membersDeletedNodes[id]={};
this.membersDeletedNodesMemberIDs[id]={};
this.membersEntries[id]=[];
this.membersCursor[id]=0;
this.xmlDataMember[id]={};
this.initialContentsMember[id]={};
if(this.rolesCreatedNodes[id]){
var node=new com.ibm.mm.enabler.ac.MemberModelImpl(id,this,this.um,true);
this.memberModel[id]=node;
return;
}
var _edb=null;
if(!link){
_edb=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url,this);
var _edc=[{value:"collection",isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_MEMBER},{value:_ed6,isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE},{value:this.mainResource.getID(),isID:true}];
_edb.setNodes(_edc);
}else{
_edb=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}
var _edd=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_edb,null,null,false,sync);
var _ede=this.membersEntries[id];
var _edf=this.model;
_edd.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _ee6=(feed&&feed.length>0)?feed[0]:data;
this.xmlDataMember[id]=_ee6;
this.initialContentsMember[id]=com.ibm.mm.enabler.dom.innerXML(this.xmlDataMember[id]);
var node=new com.ibm.mm.enabler.ac.MemberModelImpl(id,this,this.um,false);
this.memberModel[id]=node;
if(_ed8&&_ed8.finishedCallback2){
_ed8.finishedCallback2(null,xhr.status,_ed8.finishedCallbackParameters2);
}
}else{
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(_ed8&&_ed8.finishedCallback2){
_ed8.finishedCallback2(null,xhr.status,_ed8.finishedCallbackParameters2);
}
}
}
}));
},_cacheNodeMembers:function(_id,_ee9){
var id=_ee9.getID();
if(!(id in this.membersLoadedNodes[_id])){
this.membersLoadedNodes[_id][id]=_ee9;
}
return this.membersLoadedNodes[_id][id];
},__commit:function(_eeb,sync){
if(this.mainResource instanceof com.ibm.mashups.enabler.space.SpaceNode){
var _eed=this.mainResource;
var _eee=com.ibm.mashups.enabler.model.Factory.getSpaceExtensionModel();
var _eef=_eee.findExtensionBySpace(_eed).start();
if(_eef){
var _ef0=this._diffAccessControlChanges();
if(_ef0!=null){
var _ef1=_eef.onSpaceUpdate(_eed.getID(),dojo.toJson(_ef0,true),null);
if(_ef1&&_ef1.getState()!="OK"){
return;
}
}
}
}
this._acquire();
for(id in this.rolesCreatedNodes){
var role=this.rolesCreatedNodes[id];
var _ef3=role.getRoleName();
var link=this._getRolesLink();
if(link){
_ef5=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
_ef5=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url,this);
var _ef6=[{value:"collection",isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE},{value:this.mainResource.getID(),isID:true}];
_ef5.setNodes(_ef6);
}
var _ef7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_ef5,null,null,false,sync);
this._acquire();
_ef7.create(role.toString(),dojo.hitch(this,function(type,data,xhr,args){
var _efc=null;
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _efe=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _eff=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_efe,this.ns);
if(_eff.length>0){
for(var i=0;i<_eff.length;i++){
_efc=new com.ibm.mm.enabler.ac.RoleNodeImpl(_eff[i],this.um);
if(_efc.getRoleName()==_ef3){
var len=this.rolesEntries.length;
var _f02=null;
for(id in this.rolesCreatedNodes){
var node=this.rolesCreatedNodes[id];
if(node.getRoleName()==_efc.getRoleName()){
_f02=node;
break;
}
}
this._replaceNodeRoles(_f02,_efc);
break;
}
}
}
}
if(_eeb&&_eeb.operationCallback){
_eeb.operationCallback(_efc,com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_eeb.operationCallbackParameters);
}
this._release(_eeb,xhr.status);
}));
}
this.rolesCreatedNodes={};
for(id1 in this.rolesLoadedNodes){
var _f04=this.rolesLoadedNodes[id1];
var _f05=_f04.getID();
var _f06=_f04.getRoleType();
for(id in this.membersCreatedNodes[_f05]){
var _f07=this.membersCreatedNodes[_f05][id];
var _ef5=null;
var link=this._getMembersLink(_f04.xmlData);
if(link){
_ef5=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
_ef5=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url,this);
var _ef6=[{value:"collection",isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_MEMBER},{value:_f06,isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE},{value:this.mainResource.getID(),isID:true}];
_ef5.setNodes(_ef6);
}
var _ef7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_ef5,null,null,false,sync);
this._acquire();
_ef7.create(_f07._toEntry(),dojo.hitch(this,function(type,data,xhr,args){
var _f0c=null;
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var expr="//atom:entry";
var _f0e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
if(_f0e&&_f0e.length>0){
for(var i=0;i<_f0e.length;i++){
_f0c=new com.ibm.mm.enabler.ac.MemberNodeImpl(id,_f0e[i],this.um);
}
}
}
if(_eeb&&_eeb.operationCallback){
_eeb.operationCallback(_f0c,com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY,xhr.status,_eeb.operationCallbackParameters);
}
this._release(_eeb,xhr.status);
}));
}
this.membersCreatedNodes[_f05]={};
for(id in this.membersDeletedNodes[_f05]){
var _f10=this.membersDeletedNodes[_f05][id];
var _f11=this.membersDeletedNodesMemberIDs[_f05][id];
var _f12=null;
var link=_f10.getEditLink();
if(link){
_f12=new com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
_f12=new com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url,this);
var _ef6=[{value:_f11,isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_MEMBER},{value:_f06,isID:false,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE},{value:this.mainResource.getID(),isID:true}];
_f12.setNodes(_ef6);
}
var _ef7=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_f12,null,null,false,sync);
this._acquire();
_ef7.remove(dojo.hitch(this,function(type,data,xhr,args){
var _f17=null;
if(type!=com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
_f17=id;
}
if(_eeb&&_eeb.operationCallback){
_eeb.operationCallback(_f17,com.ibm.mashups.enabler.DeferredOperation.OPERATION_DELETE,xhr.status,_eeb.operationCallbackParameters);
}
this._release(_eeb,xhr.status);
}));
}
this.membersDeletedNodes[_f05]={};
this.membersDeletedNodesMemberIDs[_f05]={};
this._release(_eeb,0);
if(_eeb&&_eeb.finishedCallback2){
_eeb.finishedCallback2(null,_eeb.finishedCallback2Parameters);
}
}
},_initDelta:function(){
var _f18={accesscontrol:{}};
var _f19,type;
if(this.subResource!=undefined&&this.subResource!=null){
_f19=this.subResource.getID();
type=(this.subResource instanceof com.ibm.mashups.enabler.space.SpaceNode)?"space":"page";
}else{
_f19=this.mainResource.getID();
type="space";
}
_f18.accesscontrol.resourceid=_f19;
_f18.accesscontrol.type=type;
return _f18;
},_diffAccessControlChanges:function(){
var _f1b=null;
if("owner" in this.changedProperties){
if(_f1b==null){
_f1b=this._initDelta();
}
var _f1c=this.getOwner();
if(_f1c!=this.changedProperties.owner){
_f1b.accesscontrol.owner=(typeof (_f1c)=="string")?_f1c:_f1c.getID();
}
}
if("roleblock" in this.changedProperties){
if(_f1b==null){
_f1b=this._initDelta();
}
for(var _f1d in this.changedProperties.roleblock){
var _f1e=this.changedProperties.roleblock[_f1d];
var _f1f=this._getRoleTypes(_f1d);
var _f20=(_f1f.length!=_f1e.length);
if(!_f20){
for(var i=0;i<_f1f.length;i++){
if(_f1e[_f1f[i]]!=undefined){
_f20=true;
break;
}
}
}
if(_f20){
if(_f1b.accesscontrol.roleblock==null){
_f1b.accesscontrol.roleblock={};
}
_f1b.accesscontrol.roleblock[_f1d]=_f1f;
}
}
}
if("role" in this.changedProperties){
if(_f1b==null){
_f1b=this._initDelta();
}
var _f22=function(_f23,_f24,_f25){
var _f26=[];
var _f27=0;
if(_f23){
for(id in _f23){
if(_f23[id]){
_f26[_f27++]=_f23[id];
}
}
}
if(_f24){
for(id in _f24){
if(_f23[id]==undefined&&_f24[id]){
_f26[_f27++]=_f24[id];
}
}
}
if(_f25){
for(id in _f25){
if(_f25[id]){
var _f28=_f25[id].getID();
for(var j=0;j<_f26.length;j++){
if(_f26[j].getID()==_f28){
_f26.splice(j,1);
break;
}
}
}
}
}
return _f26;
};
var _f2a=function(_f2b,_f2c,role,_f2e,_f2f,_f30,_f31){
var _f32=false;
for(id in _f2f){
_f32=true;
}
var _f33=false;
for(id in _f31){
_f33=true;
}
if(_f2e&&(_f32||_f33)||!_f2e){
if(_f2b.accesscontrol.role==null){
_f2b.accesscontrol.role=[];
}
_f2b.accesscontrol.role[_f2c]={};
_f2b.accesscontrol.role[_f2c].name=role.getRoleType();
var _f34=_f22(_f2f,_f30,_f31);
for(var i=0;i<_f34.length;i++){
var _f36=_f34[i];
var _f37=_f36.getEntity();
if(_f37){
if(_f2b.accesscontrol.role[_f2c].member==null){
_f2b.accesscontrol.role[_f2c].member=[];
}
_f2b.accesscontrol.role[_f2c].member[i]={id:_f36.getID(),type:_f37.getEntityType()};
}
}
}
};
var _f38=0;
var _f39=_f22(this.rolesCreatedNodes,this.rolesLoadedNodes,null);
for(var i=0;i<_f39.length;i++){
var role=_f39[i];
var _f3b=role.getID();
var _f3c=false;
for(id in this.changedProperties.role){
var _f3d=this.changedProperties.role[id];
if(_f3d==_f3b){
_f3c=true;
break;
}
}
_f2a(_f1b,_f38,role,_f3c,this.membersCreatedNodes[_f3b],this.membersLoadedNodes[_f3b],this.membersDeletedNodes[_f3b]);
_f38++;
}
}
this.changedProperties={};
return _f1b;
},_acquire:function(){
this.requestCount++;
},_release:function(_f3e,_f3f){
this.statusCode=Math.max(parseInt(_f3f,10),this.statusCode);
this.requestCount--;
if(this.requestCount<=0){
if(_f3e&&_f3e.finishedCallback2){
_f3e.finishedCallback2(null,this.statusCode,_f3e.finishedCallbackParameters2);
}
}
}});
dojo.declare("com.ibm.mm.enabler.ac.SpaceAccessControlModelImpl",[com.ibm.mm.enabler.ac.AccessControlModelImpl],{constructor:function(_f40){
this.mainResource=_f40;
this.xmlData=this.mainResource.xmlData;
this.initialContentsResource=null;
this.xmlDataResources=null;
this._init();
},_filterRole:function(node){
return (node.getRoleName().indexOf("@")>0);
},_getRolesLink:function(){
return this.getCARolesLink(this.mainResource.xmlData);
},_getMembersLink:function(_f42){
return this.getACMembersLink(_f42);
},getOwner:function(){
return this.mainResource._getOwner();
},setOwner:function(user){
this.mainResource._setOwner(user);
},confirmSetOwner:function(user){
return this.mainResource.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_f45,sync){
var _f47=this.mainResource._getSpaceModel();
_f47.commit().start();
this.__commit(_f45,sync);
}});
dojo.declare("com.ibm.mm.enabler.ac.ResourceAccessControlModelImpl",[com.ibm.mashups.enabler.ac.ResourceAccessControlModel,com.ibm.mm.enabler.ac.AccessControlModelImpl],{constructor:function(_f48){
this.mainResource=_f48;
this.subResource=this.mainResource;
this.url=com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL;
this.url2=com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL;
},_getRolesLink:function(){
return this.getACRolesLink(this.mainResource.xmlData);
},_getMembersLink:function(_f49){
return this.getACMembersLink(_f49);
},_getResourceLink:function(){
return this.getACResourceLink(this.mainResource.xmlData);
},isInheritanceBlock:function(_f4a){
return this.isRoleBlock(_f4a,"inheritance");
},setInheritanceBlock:function(_f4b,_f4c){
this.setRoleBlock(_f4b,_f4c,"inheritance");
},getOwner:function(){
if(this.owner===null){
if(this.xmlData===undefined){
this._loadAheadResource(null,true);
}
var expr="atom:content/ac:resource-config/ac:owner";
var _f4e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_f4e&&_f4e.length>0){
var _f4f=com.ibm.mm.enabler.utilities.getAttributeWithNS(_f4e[0],"ac:id","id",this.ns["ac"]);
this.owner=this.um.find(_f4f).start();
}
}
return this.owner;
},setOwner:function(user){
if(this.xmlData===undefined){
this._loadAheadResource(null,true);
}
if(this.changedProperties.owner==null){
this.changedProperties.owner=this._getOwner();
}
this.owner=user;
var expr="atom:content/ac:resource-config/ac:owner";
var _f52=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_f52&&_f52.length>0){
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_f52[0],"ac:id",this.nsf.getNameSpaceUri(this.nsf.NS_AC),user.getID());
}else{
expr="atom:content/ac:resource-config";
var _f53=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_f53&&_f53.length>0){
var tn=com.ibm.mm.enabler.dom.createElement(this.xmlData.ownerDocument,"ac:owner",this.nsf.getNameSpaceUri(this.nsf.NS_AC));
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(tn,"ac:id",this.nsf.getNameSpaceUri(this.nsf.NS_AC),user.getID());
_f53[0].appendChild(tn);
}
}
},confirmSetOwner:function(user){
return this.subResource.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
},confirmGetRoleModel:function(){
return this.subResource.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
},_getOwner:function(){
if(this.xmlData===undefined){
this._loadAheadResource(null,true);
}
var expr="atom:content/ac:resource-config/ac:owner";
var _f57=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_f57&&_f57.length>0){
return com.ibm.mm.enabler.utilities.getAttributeWithNS(_f57[0],"ac:id","id",this.nsf.getNameSpaceUri(this.nsf.NS_AC));
}
return null;
},_loadAheadResource:function(_f58,sync){
var _f5a=null;
var link=this._getResourceLink();
if(link){
_f5a=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(link,this);
}else{
_f5a=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url2,this);
var _f5c=[{value:this.subResource.getID(),isID:true,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_RESOURCE}];
_f5a.setNodes(_f5c);
}
var _f5d=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_f5a,null,null,false,sync);
_f5d.read(dojo.hitch(this,function(type,data,xhr,args){
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _f64=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _f65=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_f64,this.ns);
this.xmlData=_f65[0];
this.initialContentsResource=com.ibm.mm.enabler.dom.innerXML(this.xmlData);
if(_f58&&_f58.finishedCallback2){
_f58.finishedCallback2(null,xhr.status,_f58.finishedCallbackParameters2);
}
}));
},isRoleBlock:function(_f66,_f67){
if(this.xmlData===undefined){
this._loadAheadResource(null,true);
}
if(_f66){
var expr="atom:content/ac:resource-config/ac:role-block";
var _f69=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_f69&&_f69.length>0){
for(var i=0;i<_f69.length;i++){
var _f6b=_f69[i];
var _f6c=com.ibm.mm.enabler.utilities.getAttributeWithNS(_f6b,"ac:block-type","block-type",this.ns["ac"]);
var type=com.ibm.mm.enabler.utilities.getAttributeWithNS(_f6b,"ac:type","type",this.ns["ac"]);
if(_f6c&&type){
if(_f66.toUpperCase()==type.toUpperCase()){
if(_f67.toUpperCase()==_f6c.toUpperCase()){
return true;
}
}
}
}
}
}
return false;
},isPropagationBlock:function(_f6e){
return this.isRoleBlock(_f6e,"propagation");
},setRoleBlock:function(_f6f,_f70,_f71){
if(this.xmlData===undefined){
this._loadAheadResource(null,true);
}
if(this.changedProperties.roleblock==null){
this.changedProperties.roleblock={};
}
if(this.changedProperties.roleblock[_f71]==null){
this.changedProperties.roleblock[_f71]=this._getRoleTypes(_f71);
}
if(_f70==false){
var expr="atom:content/ac:resource-config/ac:role-block";
var _f73=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_f73&&_f73.length>0){
for(var i=0;i<_f73.length;i++){
var _f75=_f73[i];
var _f76=com.ibm.mm.enabler.utilities.getAttributeWithNS(_f75,"ac:block-type","block-type",this.ns["ac"]);
var type=com.ibm.mm.enabler.utilities.getAttributeWithNS(_f75,"ac:type","type",this.ns["ac"]);
if(_f76&&type){
if(_f6f.toUpperCase()==type.toUpperCase()){
if(_f71.toUpperCase()==_f76.toUpperCase()){
var _f78=_f75.parentNode;
_f78.removeChild(_f75);
return;
}
}
}
}
}
}else{
var expr="atom:content/ac:resource-config";
var _f79=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
var _f7a=_f79[0];
var _f76=com.ibm.mm.enabler.dom.createElement(this.xmlData.ownerDocument,"ac:role-block",this.ns.ac);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,_f76,"ac:block-type","block-type",this.ns["ac"],_f71);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,_f76,"ac:type","type",this.ns["ac"],_f6f);
_f7a.appendChild(_f76);
}
},_getRoleTypes:function(_f7b){
if(this.xmlData===undefined){
this._loadAheadResource(null,true);
}
var _f7c=[];
var expr="atom:content/ac:resource-config/ac:role-block[@ac:block-type='"+_f7b+"']";
var _f7e=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
for(var i=0;i<_f7e.length;i++){
_f7c[i]=com.ibm.mm.enabler.utilities.getAttributeWithNS(_f7e[i],"ac:type","type",this.ns["ac"]);
}
return _f7c;
},setPropagationBlock:function(_f80,_f81){
this.setRoleBlock(_f80,_f81,"propagation");
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_f82,sync){
if(this.initialContentsResource!==com.ibm.mm.enabler.dom.innerXML(this.xmlData)){
this.statusCode=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
this.requestCount=0;
this._acquire();
var _f84=new com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(this.url2,this);
var _f85=[{value:this.subResource.getID(),isID:true,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_RESOURCE}];
_f84.setNodes(_f85);
var _f86=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_f84,null,null,false,true);
this._acquire();
_f86.update(com.ibm.mm.enabler.dom.innerXML(this.xmlData),dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
}
this.initialContentsResource=com.ibm.mm.enabler.dom.innerXML(this.xmlData);
if(_f82&&_f82.operationCallback){
_f82.operationCallback(this,com.ibm.mashups.enabler.DeferredOperation.OPERATION_CREATE,xhr.status,_f82.operationCallbackParameters);
}
this._release(_f82,xhr.status);
}));
}
this.__commit(_f82,sync);
}});
dojo.declare("com.ibm.mm.enabler.ac.ResourceSpaceAccessControlModelImpl",[com.ibm.mm.enabler.ac.ResourceAccessControlModelImpl],{constructor:function(_f8b,_f8c){
this.mainResource=_f8b;
this.subResource=_f8c;
this.url=com.ibm.mashups.enabler.model.url.ModelUrlFactory.AI_URL;
this.url2=com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL;
},_getRolesLink:function(){
return this.getACRolesLink(this.mainResource.xmlData);
},_getResourceLink:function(){
return this.getACResourceLink(this.subResource.xmlData);
},_getCreationRoleName:function(_f8d){
return _f8d+"@"+this.subResource.getID();
},_getCreationResourceID:function(){
return this.subResource.getID();
},_isPageInSpace:function(){
return true;
},_getPossibleRoles:function(){
var _f8e={};
var _f8f=this.subResource.getMetaDataNames();
for(var i=0;i<_f8f.length;i++){
if(_f8f[i].indexOf("com.ibm.mashups.acl.role.")==0){
var _f91=_f8f[i].substring("com.ibm.mashups.acl.role.".length);
var _f92=this.subResource.getMetaData(_f8f[i]);
_f8e[_f91]=_f92;
}
}
return _f8e;
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_f93,sync){
for(id in this.rolesCreatedNodes){
var role=this.rolesCreatedNodes[id];
this.subResource.setMetaData("com.ibm.mashups.acl.role."+role.getRoleType(),role.getRoleName());
}
var _f96=this.subResource._getLayoutModel();
var _f97=_f96._getNavigationModel();
_f97.commit().start();
this.inherited(arguments);
}});
dojo.declare("com.ibm.mm.enabler.ac.RoleModelImpl",[com.ibm.mashups.enabler.ac.RoleModel,com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.DeferredIteratorImpl,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(_f98,_um){
this.accessControlModel=_f98;
this.um=_um;
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_AC,this.nsf.NS_AI,this.NS_CREATION_CONTEXT]);
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
this.prefix="role";
this.xmlDom=com.ibm.mm.enabler.dom.createDocument();
this.cid=0;
},create:function(_f9a){
if(!_f9a){
throw new Error("RoleModelImpl.create: no context");
return null;
}
if(!_f9a.roletype){
throw new Error("RoleModelImpl.create: no roletype context");
return null;
}
var _f9b=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
_f9b.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom));
var _f9c=com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.ns.atom);
com.ibm.mm.enabler.dom.textContent(_f9c,"Role");
_f9b.appendChild(_f9c);
var _f9d=com.ibm.mm.enabler.model.Utils.createNode("atom:updated",this.ns.atom);
var time=new Date();
com.ibm.mm.enabler.dom.textContent(_f9d,time.toGMTString());
_f9b.appendChild(_f9d);
var _f9f=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
_f9f.setAttribute("type","application/xml");
var _fa0=com.ibm.mm.enabler.model.Utils.createNode("ac:role",this.ns.ac);
var _fa1=this.accessControlModel._getCreationRoleName(_f9a.roletype);
if(!_fa1){
_fa1=_f9a.roletype;
}
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_fa0,"ac:type",this.nsf.getNameSpaceUri(this.nsf.NS_AC),_fa1);
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom,_fa0,"creation-context:role-types","role-types",this.ns[this.nsf.NS_CREATION_CONTEXT],_f9a.roletype);
var _fa2=this.accessControlModel._getCreationResourceID();
com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom,_fa0,"creation-context:resource-id","resource-id",this.ns[this.nsf.NS_CREATION_CONTEXT],_fa2);
_f9f.appendChild(_fa0);
_f9b.appendChild(_f9f);
var _fa3=new com.ibm.mm.enabler.ac.RoleNodeImpl(_f9b,this.um,_f9a.roletype);
_fa3.setID(""+(this.cid++));
return _fa3;
},iterator:function(){
return this;
},start:function(sync){
while(this._hasNext(this,sync)){
if(this._next(this,sync)){
continue;
}else{
break;
}
}
},hasNext:function(){
return this._hasNext(null,true);
},_hasNext:function(_fa5,sync){
var _fa7=false;
var next=this.accessControlModel.rolesEntries[this.accessControlModel.rolesCursor];
if(next!==null&&next!==undefined){
_fa7=true;
}
return _fa7;
},next:function(){
return this._next(null,true);
},_next:function(_fa9,sync){
var _fab=this._hasNext(_fa9,sync);
var _fac=this.accessControlModel.rolesEntries;
var _fad=this.accessControlModel.rolesLoadedNodes;
var ret=_fab?_fad[_fac[this.accessControlModel.rolesCursor]]:null;
this.accessControlModel.rolesCursor++;
return ret;
},size:function(){
return this.accessControlModel.rolesSizeValue;
},setCursorPosition:function(_faf){
this.accessControlModel.rolesCursor=_faf;
},getCursorPosition:function(){
return this.accessControlModel.rolesCursor;
},insert:function(node,_fb1){
if(this.accessControlModel.changedProperties.role==null){
this.accessControlModel.changedProperties.role=this._getRoles();
}
this.accessControlModel.rolesCreatedNodes[node.getID()]=node;
var _fb2=this.accessControlModel.rolesEntries.length;
if((!_fb2)||(_fb2==0)){
this.accessControlModel.rolesEntries[0]=node.getID();
this.accessControlModel.rolesEntries[1]=null;
}else{
this.accessControlModel.rolesEntries[_fb2-1]=node.getID();
this.accessControlModel.rolesEntries[_fb2]=null;
}
this.accessControlModel._cacheNodeRoles(node);
},_getRoles:function(){
var _fb3={};
this.setCursorPosition(0);
var _fb4=this.iterator();
while(_fb4.hasNext()){
var role=_fb4.next();
var _fb6=role.getID();
_fb3[_fb6]=_fb6;
}
return _fb3;
},find:function(id){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,id);
},_find:function(_fb8,sync,id){
if(id in this.accessControlModel.rolesLoadedNodes){
if(_fb8&&_fb8.finishedCallback2){
_fb8.finishedCallback2(this.accessControlModel.rolesLoadedNodes[id],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_fb8.finishedCallbackParameters2);
}
return this.accessControlModel.rolesLoadedNodes[id];
}
var _fbb=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL,this);
_fbb.setNodes([{value:id,isID:true}]);
var _fbc=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_fbb,null,null,false,sync);
var _fbd=null;
var _fbe={};
_fbc.read(dojo.hitch(this,function(type,data,xhr,args){
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _fc5=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _fc6=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_fc5,this.ns);
var _fc7=new com.ibm.mm.enabler.ac.RoleNodeImpl(_fc6[0],this);
this.accessControlModel.rolesNewid=_fc7.getID();
this.rolesLoadedNodes[this.rolesNewid]=_fc7;
if(_fb8&&_fb8.finishedCallback2){
_fb8.finishedCallback2(this.accessControlModel.rolesLoadedNodes[this.rolesNewid]||null,xhr.status,_fb8.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_fbe.status=xhr.status;
}
}
}));
if(_fbe.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_COMNODE_NOTFOUND_1,[id,_fbe.status]));
}
return this.accessControlModel.rolesLoadedNodes[this.rolesNewid];
},getMemberModel:function(_fc8){
if(!_fc8){
return null;
}
var id=_fc8.getID();
if(!id){
return null;
}
if(this.accessControlModel.memberModel){
if(this.accessControlModel.memberModel[id]){
return this.accessControlModel.memberModel[id];
}
}
this.accessControlModel._loadAheadMember(_fc8,null,true);
if(this.accessControlModel.memberModel[id]){
return this.accessControlModel.memberModel[id];
}
return null;
}});
dojo.declare("com.ibm.mm.enabler.ac.MemberModelImpl",[com.ibm.mashups.enabler.ListModel,com.ibm.mm.enabler.DeferredIteratorImpl,com.ibm.mm.enabler.ModelImpl,com.ibm.mm.enabler.ConfirmableModelImpl],{constructor:function(_fca,_fcb,_um,_fcd){
this.roleID=_fca;
this.accessControlModel=_fcb;
this.um=_um;
this.cid=0;
this.modelMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","modelMessages");
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_AC,this.nsf.NS_AI,this.NS_CREATION_CONTEXT]);
this.prefix="role";
this.xmlDom=com.ibm.mm.enabler.dom.createDocument();
this.accessControlModel.membersCursor[this.roleID]=0;
if(_fcd){
this.xmlData=undefined;
this.accessControlModel.membersEntries[this.roleID]=[];
this.accessControlModel.membersEntries[this.roleID][0]=null;
return;
}else{
this.xmlData=this.accessControlModel.xmlDataMember[this.roleID];
var expr="//atom:entry";
var _fcf=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_fcf&&_fcf.length>0){
for(var i=0;i<_fcf.length;i++){
var node=new com.ibm.mm.enabler.ac.MemberNodeImpl(this.roleID,_fcf[i],this.um);
this.accessControlModel.membersEntries[this.roleID][this.accessControlModel.membersCursor[this.roleID]+i]=node.getID();
this.accessControlModel._cacheNodeMembers(this.roleID,node);
}
var len=this.accessControlModel.membersEntries[this.roleID].length;
this.accessControlModel.membersEntries[this.roleID][len]=null;
}else{
this.accessControlModel.membersEntries[this.roleID]=[];
this.accessControlModel.membersEntries[this.roleID][0]=null;
}
}
},create:function(_fd3){
if(!_fd3){
throw new Error("MemberModelImpl.create: no context");
return null;
}
if(!_fd3.type){
throw new Error("MemberModelImpl.create: no type context");
return null;
}
if(!_fd3.id){
throw new Error("MemberModelImpl.create: no type context");
return null;
}
var _fd4=com.ibm.mm.enabler.model.Utils.createNode("atom:entry",this.ns.atom);
_fd4.appendChild(com.ibm.mm.enabler.model.Utils.createNode("atom:id",this.ns.atom));
var _fd5=com.ibm.mm.enabler.model.Utils.createNode("atom:title",this.ns.atom);
com.ibm.mm.enabler.dom.textContent(_fd5,"Member");
_fd4.appendChild(_fd5);
var _fd6=com.ibm.mm.enabler.model.Utils.createNode("atom:updated",this.ns.atom);
var time=new Date();
com.ibm.mm.enabler.dom.textContent(_fd6,time.toGMTString());
_fd4.appendChild(_fd6);
var _fd8=com.ibm.mm.enabler.model.Utils.createNode("atom:content",this.ns.atom);
_fd8.setAttribute("type","application/xml");
var _fd9=com.ibm.mm.enabler.model.Utils.createNode("ac:member",this.ns.ac);
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_fd9,"ac:id",this.nsf.getNameSpaceUri(this.nsf.NS_AC),_fd3.id);
com.ibm.mm.enabler.model.Utils.setAttributeWithNS(_fd9,"ac:type",this.nsf.getNameSpaceUri(this.nsf.NS_AC),_fd3.type);
_fd8.appendChild(_fd9);
_fd4.appendChild(_fd8);
var _fda=new com.ibm.mm.enabler.ac.MemberNodeImpl(this.roleID,_fd4,this.um);
return _fda;
},iterator:function(){
return this;
},start:function(sync){
while(this._hasNext(this,sync)){
if(this._next(this,sync)){
continue;
}else{
break;
}
}
},hasNext:function(){
return this._hasNext(null,true);
},_hasNext:function(_fdc,sync){
var _fde=false;
var next=this.accessControlModel.membersEntries[this.roleID][this.accessControlModel.membersCursor[this.roleID]];
if(next!==null&&next!==undefined){
_fde=true;
}
return _fde;
},next:function(){
return this._next(null,true);
},_next:function(_fe0,sync){
var _fe2=this._hasNext(_fe0,sync);
var _fe3=this.accessControlModel.membersEntries[this.roleID];
var _fe4=this.accessControlModel.membersLoadedNodes[this.roleID];
var ret=_fe2?_fe4[_fe3[this.accessControlModel.membersCursor[this.roleID]]]:null;
this.accessControlModel.membersCursor[this.roleID]++;
return ret;
},size:function(){
return this.accessControlModel.membersSizeValue[this.roleID];
},setCursorPosition:function(_fe6){
this.accessControlModel.membersCursor[this.roleID]=_fe6;
},getCursorPosition:function(){
return this.accessControlModel.membersCursor[this.roleID];
},insert:function(node,_fe8){
if(this.accessControlModel.changedProperties.role==null){
this.accessControlModel.changedProperties.role=this.accessControlModel.getRoleModel()._getRoles();
}
this.accessControlModel.membersCreatedNodes[this.roleID][node.getID()]=node;
var _fe9=this.accessControlModel.membersEntries[this.roleID].length;
if((!_fe9)||(_fe9==0)){
this.accessControlModel.membersEntries[this.roleID][0]=node.getID();
this.accessControlModel.membersEntries[this.roleID][1]=null;
}else{
this.accessControlModel.membersEntries[this.roleID][_fe9-1]=node.getID();
this.accessControlModel.membersEntries[this.roleID][_fe9]=null;
}
this.accessControlModel._cacheNodeMembers(this.roleID,node);
},find:function(id){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,id);
},_find:function(_feb,sync,id){
if(id in this.accessControlModel.membersDeletedNodes[this.roleID]){
if(_feb&&_feb.finishedCallback2){
_feb.finishedCallback2(null,com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND,_feb.finishedCallbackParameters2);
}
return null;
}
if(id in this.accessControlModel.membersLoadedNodes[this.roleID]){
if(_feb&&_feb.finishedCallback2){
_feb.finishedCallback2(this.accessControlModel.membersLoadedNodes[this.roleID][id],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_feb.finishedCallbackParameters2);
}
return this.accessControlModel.membersLoadedNodes[this.roleID][id];
}
var _fee=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL,this);
_fee.setNodes([{value:id,isID:true}]);
var _fef=new com.ibm.mm.enabler.services.ModelRestServiceRequest(_fee,null,null,false,sync);
var _ff0=null;
var _ff1={};
_fef.read(dojo.hitch(this,function(type,data,xhr,args){
var expr="atom:feed";
var feed=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,this.ns);
var _ff8=(feed&&feed.length>0)?feed[0]:data;
expr="atom:entry";
var _ff9=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_ff8,this.ns);
var _ffa=new com.ibm.mm.enabler.ac.MemberNodeImpl(_ff9[0],this);
this.accessControlModel.membersNewid[this.roleID]=_ffa.getID();
this.membersLoadedNodes[this.roleID][this.membersNewid[this.roleID]]=_ffa;
if(_feb&&_feb.finishedCallback2){
_feb.finishedCallback2(this.accessControlModel.membersLoadedNodes[this.roleID][this.membersNewid[this.roleID]]||null,xhr.status,_feb.finishedCallbackParameters2);
}
if(sync&&type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR){
if(xhr.status!=com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND){
_ff1.status=xhr.status;
}
}
}));
if(_ff1.status){
throw new Error(dojo.string.substitute(this.modelMessages.E_COMNODE_NOTFOUND_1,[id,_ff1.status]));
}
return this.accessControlModel.membersLoadedNodes[this.roleID][this.membersNewid[this.roleID]];
},remove:function(node){
if(this.accessControlModel.changedProperties.role==null){
this.accessControlModel.changedProperties.role=this.accessControlModel.getRoleModel()._getRoles();
}
var id=node.getID();
if(!(id in this.accessControlModel.membersDeletedNodes[this.roleID])){
this.accessControlModel.membersDeletedNodesMemberIDs[this.roleID][id]=node.getEntity().getID();
this.accessControlModel.membersDeletedNodes[this.roleID][id]=node;
}
if(id in this.accessControlModel.membersLoadedNodes[this.roleID]){
delete this.accessControlModel.membersLoadedNodes[this.roleID][id];
}
}});
dojo.declare("com.ibm.mm.enabler.ac.RoleNodeImpl",[com.ibm.mm.enabler.IdentifiableImpl,com.ibm.mm.enabler.TransformableImpl],{constructor:function(data,_ffe,_fff){
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_AC,this.nsf.NS_AI]);
this.modified=false;
this.xmlData=data;
this.um=_ffe;
if(_fff){
this.roleType=_fff;
}else{
this.roleType=com.ibm.mashups.enabler.ac.RoleType.UNKNOWN;
var expr="atom:content/ac:role";
var roles=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(roles&&roles.length>0){
var rt=com.ibm.mm.enabler.utilities.getAttributeWithNS(roles[0],"ac:type","type",this.ns["ac"]);
if(rt){
if(rt.toUpperCase().indexOf(com.ibm.mashups.enabler.ac.RoleType.USER)==0){
this.roleType=com.ibm.mashups.enabler.ac.RoleType.USER;
}else{
if(rt.toUpperCase().indexOf(com.ibm.mashups.enabler.ac.RoleType.EDITOR)==0){
this.roleType=com.ibm.mashups.enabler.ac.RoleType.EDITOR;
}else{
if(rt.toUpperCase().indexOf(com.ibm.mashups.enabler.ac.RoleType.MANAGER)==0){
this.roleType=com.ibm.mashups.enabler.ac.RoleType.MANAGER;
}else{
if("EDIT"==rt.toUpperCase()){
this.roleType=com.ibm.mashups.enabler.ac.RoleType.EDITOR;
}else{
if("MANAGE"==rt.toUpperCase()){
this.roleType=com.ibm.mashups.enabler.ac.RoleType.MANAGER;
}
}
}
}
}
}
}
}
},getRoleName:function(){
var expr="atom:content/ac:role";
var roles=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(roles&&roles.length>0){
var rt=com.ibm.mm.enabler.utilities.getAttributeWithNS(roles[0],"ac:type","type",this.ns["ac"]);
return rt;
}
return this.getRoleType();
},getRoleType:function(){
return this.roleType;
},toString:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
dojo.declare("com.ibm.mm.enabler.ac.MemberNodeImpl",[com.ibm.mm.enabler.EditLinkProviderImpl],{constructor:function(_1006,data,_1008){
this.nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=this.nsf.getNameSpaces([this.nsf.NS_ATOM,this.nsf.NS_AC,this.nsf.NS_AI]);
this.prefix="role";
this.modified=false;
this.xmlData=data;
this.um=_1008;
this.roleID=_1006;
if(this.xmlData){
var expr="atom:content/ac:member";
var _100a=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,this.xmlData,this.ns);
if(_100a&&_100a.length>0){
this.memberID=com.ibm.mm.enabler.utilities.getAttributeWithNS(_100a[0],"ac:id","id",this.ns["ac"]);
this.memberType=com.ibm.mm.enabler.utilities.getAttributeWithNS(_100a[0],"ac:type","type",this.ns["ac"]);
if(this.memberID){
var e=null;
if(this.memberType==="user"){
e=this.um.find(this.memberID).start();
}else{
e=this.um.findGroupByID(this.memberID).start();
if((typeof e=="undefined")||(e==null)){
e=this.um.find(this.memberID).start();
}
}
this.entity=e;
}
}
}
},getEntity:function(){
return this.entity;
},getID:function(){
if(this.entity){
return this.entity.getID();
}
return this.memberID;
},_toEntry:function(){
return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
}});
com.ibm.mashups.enabler.ac.AccessControlModelFactory=new com.ibm.mm.enabler.ac.AccessControlModelFactoryImpl();
dojo.declare("com.ibm.mm.enabler.ac.AccessFactoryImpl",[com.ibm.mashups.enabler.ac.AccessFactory],{getEffectiveAccess:function(node){
if((node)&&(node.hasRole)){
return node;
}
return null;
},getEffectiveAccessVirtualResource:function(_100d){
var myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.AC_URL,null);
myUrl.setNodes([{value:_100d,isID:true,subModel:com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ACCESS}]);
var _data=null;
var _1010=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,false,true);
_1010.read(dojo.hitch(this,function(type,data,xhr,args){
if(type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD){
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
var ns=nsf.getNameSpaces([nsf.NS_ATOM]);
var expr="//atom:entry";
var nodes=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,data,ns);
if(nodes){
_data=nodes[0];
}
}
}));
if(_data!=null){
var ret=new com.ibm.mm.enabler.EffectiveAccessImpl();
ret._init(_data);
return ret;
}
return null;
}});
com.ibm.mashups.enabler.ac.AccessFactory=new com.ibm.mm.enabler.ac.AccessFactoryImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.WebDavUrlFactoryImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.WebDavUrlFactoryImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.WebDavUrlFactoryImpl");
dojo.declare("com.ibm.mm.enabler.remote.WebDavUrlFactoryImpl",null,{constructor:function(){
var _101a=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData([com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_WEBDAV,com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_FILESTORE]);
this._fullUrl=_101a.url;
var idx=this._fullUrl.indexOf("//");
var _101c=this._fullUrl.substring(idx+2);
var idx2=_101c.indexOf("/");
var _101e=idx+idx2+2;
this._domainUrl=this._fullUrl.substring(0,_101e);
this._context=this._fullUrl.substring(_101e);
},createUrl:function(path){
var uri=null;
if(!path){
uri=this._fullUrl;
}else{
if(path==this._fullUrl){
uri=path+"/";
}else{
if(path.indexOf(this._fullUrl)==0){
uri=path;
}else{
if(path.indexOf(this._context)==0){
uri=this._domainUrl+path;
}else{
uri=this._fullUrl+path;
}
}
}
}
return uri;
},getUserHome:function(){
var _1021=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData([com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_WEBDAV,com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_USER]);
return _1021.url;
}});
com.ibm.mm.enabler.remote.WebDavUrlFactory=new com.ibm.mm.enabler.remote.WebDavUrlFactoryImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.WebDavCommandImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.WebDavCommandImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.WebDavCommandImpl");
dojo.declare("com.ibm.mm.enabler.remote.WebDavCommandImpl",null,{statics:{timeout:1000*60*3},constructor:function(_1022,path,form,data,_1026,_1027){
this._action=_1022;
if(dojo.isIE){
this._path=encodeURI(path);
}else{
this._path=path;
}
this._handleAs=_1027;
this._form=form;
this._data=data;
this._headers=_1026;
},getURI:function(){
var uri=com.ibm.mm.enabler.remote.WebDavUrlFactory.createUrl(this._path);
return uri;
},execute:function(){
var _1029={url:this.getURI(),sync:false,handleAs:this._handleAs,timeout:this.statics.timeout};
var _102a=false;
if(this._data){
_1029["postData"]=this._data;
_102a=true;
}
if(this._headers){
_1029["headers"]=this._headers;
}
if(this._form){
_1029["form"]=this._form;
_1029["method"]="POST";
if(_1029["url"].indexOf("?")==-1){
_1029["url"]=_1029["url"]+"?mime-type=text/html";
}else{
_1029["url"]=_1029["url"]+"&mime-type=text/html";
}
return dojo.io.iframe.send(_1029);
}else{
return dojo.xhr(this._action,_1029,_102a);
}
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.WebDavResponseImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.WebDavResponseImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.WebDavResponseImpl");
dojo.declare("com.ibm.mm.enabler.remote.WebDavResponseImpl",null,{namespace:{"D":"DAV:","a":"DAV:","dav":"DAV:"},paths:{collection:"//D:multistatus/D:response/D:propstat/D:prop/D:resourcetype/D:collection",href:"//D:multistatus/D:response/D:href"},constructor:function(){
},isCollection:function(data){
var nodes=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.paths.collection,data,this.namespace);
var _102d=(nodes&&nodes.length>0);
return _102d;
},getHrefs:function(data){
var nodes=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.paths.href,data,this.namespace);
return this.convertNodesToStrings(nodes);
},convertNodesToStrings:function(nodes){
if(nodes){
var _1031=new Array(nodes.length);
var i=0;
for(node in nodes){
var s=dojox.xml.parser.textContent(nodes[node]);
_1031[i]=decodeURI(s);
i++;
}
return _1031;
}else{
return null;
}
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.WebDavCommandFactoryImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.WebDavCommandFactoryImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.WebDavCommandFactoryImpl");
dojo.declare("com.ibm.mm.enabler.remote.WebDavCommandFactoryImpl",null,{constructor:function(){
},getDownloadCommand:function(path){
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("GET",path,null,null,null,"text");
},getCreateCommand:function(path,node,_1037){
var _1038=null;
if((node==null)&&(_1037!=null)){
_1038={"content-type":"text/html;charset=utf-8"};
}
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("POST",path,node,_1037,_1038,"text");
},getCopyCommand:function(path,dest){
var _103b={"destination":encodeURI(dest)};
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("COPY",path,null,null,_103b,"text");
},getMoveCommand:function(path,dest){
var _103e={"destination":encodeURI(dest),"overwrite":false};
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("MOVE",path,null,null,_103e,"text");
},getUpdateCommand:function(path,node,_1041){
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("PUT",path,node,_1041,null,"text");
},getDeleteCommand:function(path){
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("DELETE",path,null,null,null,"text");
},getMakeCollectionCommand:function(path){
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("MKCOL",path,null,null,null,"xml");
},getFindPropertiesCommand:function(path){
var data="<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:resourcetype/></D:prop></D:propfind>";
var _1046={"depth":"1"};
return new com.ibm.mm.enabler.remote.WebDavCommandImpl("PROPFIND",path,null,data,_1046,"xml");
}});
com.ibm.mm.enabler.remote.WebDavCommandFactory=new com.ibm.mm.enabler.remote.WebDavCommandFactoryImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.WebDavDeferredImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.WebDavDeferredImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.WebDavDeferredImpl");
dojo.declare("com.ibm.mm.enabler.remote.WebDavDeferredImpl",com.ibm.mashups.enabler.Deferred,{constructor:function(){
this._context=null;
this._startfn=null;
},constructor:function(_1047,_1048){
this._context=_1047;
this._startfn=_1048;
},setFinishedCallback:function(_1049,_104a){
this._callback=_1049;
this._parameters=_104a;
},start:function(sync){
if((this._context!=null)&&(this._startfn!=null)){
dojo.hitch(this._context,this._startfn)();
}
return null;
},doCallback:function(_104c,_104d){
if(this._callback){
this._callback(_104c,_104d,this._parameters);
}
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.RemoteFileImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.RemoteFileImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.RemoteFileImpl");
dojo.declare("com.ibm.mm.enabler.remote.RemoteFileImpl",[com.ibm.mashups.enabler.remote.RemoteFile],{constructor:function(_104e){
if(_104e&&_104e.name){
this._name=_104e.name;
}else{
this._name=null;
}
this._children=null;
this._isDirectory=_104e.isDirectory;
this._id=null;
this._properties=null;
this._context=_104e;
this._deferred=null;
},init:function(){
this._deferred=new com.ibm.mm.enabler.remote.WebDavDeferredImpl(this,this._init);
return this._deferred;
},_init:function(){
if(this._context&&this._context.isCreate){
if((this._context.isDirectory)&&(this._context.form)){
this._uploadDirectory(this._name,this._context.form);
}else{
if(this._context.isDirectory){
this._createDirectory(this._name);
}else{
this._createFile(this._name,this._context.form,this._context.content);
}
}
}else{
if(this._context&&this._context.isUpdate){
this._updateFile(this._name,this._context.form,this._context.content);
}else{
this._load(this._name);
}
}
},_load:function(name){
var _1050=com.ibm.mm.enabler.remote.WebDavCommandFactory;
var _1051=_1050.getFindPropertiesCommand(name);
var d=_1051.execute();
d.addCallback(dojo.hitch(this,this._handleLoad));
d.addCallback(dojo.hitch(this,this._handleSuccess));
d.addErrback(dojo.hitch(this,this._handleError));
},_createFile:function(name,form,_1055){
var _1056=com.ibm.mm.enabler.remote.WebDavCommandFactory;
var _1057=_1056.getCreateCommand(name,form,_1055);
var d=_1057.execute();
d.addCallback(dojo.hitch(this,this._handleSuccess));
d.addErrback(dojo.hitch(this,this._handleError));
},_updateFile:function(name,form,_105b){
var _105c=com.ibm.mm.enabler.remote.WebDavCommandFactory;
var _105d=_105c.getUpdateCommand(name,form,_105b);
var d=_105d.execute();
d.addCallback(dojo.hitch(this,this._handleSuccess));
d.addErrback(dojo.hitch(this,this._handleError));
},_createDirectory:function(name){
var _1060=com.ibm.mm.enabler.remote.WebDavCommandFactory;
var _1061=_1060.getMakeCollectionCommand(name);
var d=_1061.execute();
d.addCallback(dojo.hitch(this,this._handleSuccess));
d.addErrback(dojo.hitch(this,this._handleError));
},_uploadDirectory:function(name,form){
var _1065=com.ibm.mm.enabler.remote.WebDavCommandFactory;
var _1066=_1065.getUpdateCommand(name,form,null);
var d=_1066.execute();
d.addCallback(dojo.hitch(this,this._handleSuccess));
d.addErrback(dojo.hitch(this,this._handleError));
},_handleLoad:function(_1068){
this._properties=_1068;
},_handleSuccess:function(data){
this._deferred.doCallback(this,200);
},_handleError:function(error){
this._deferred.doCallback(this,500);
},_delete:function(){
var _106b=com.ibm.mm.enabler.remote.WebDavCommandFactory;
var _106c=_106b.getDeleteCommand(this.getID());
var d=_106c.execute();
d.addCallback(dojo.hitch(this,this._handleSuccess));
d.addErrback(dojo.hitch(this,this._handleError));
return this._deferred;
},getName:function(){
var ret=this._name;
if("/"==this._name){
}else{
var parts=this._name.split("/");
var c=this._name.charAt(this._name.length-1);
if(c=="/"){
ret=parts[parts.length-2];
}else{
ret=parts[parts.length-1];
}
}
return ret;
},isDirectory:function(){
if(this._isDirectory==null){
var resp=new com.ibm.mm.enabler.remote.WebDavResponseImpl();
this._isDirectory=resp.isCollection(this._properties);
}
return this._isDirectory;
},_getChildHrefs:function(){
if(this._children==null){
this._children=new Array();
if(this.isDirectory()){
var resp=new com.ibm.mm.enabler.remote.WebDavResponseImpl();
var nodes=resp.getHrefs(this._properties);
var i=0;
for(node in nodes){
if(i>0){
this._children[i]=nodes[node];
}
i++;
}
}
}
return this._children;
},getID:function(){
if(this._id==null){
this._id=com.ibm.mm.enabler.remote.WebDavUrlFactory.createUrl(this._name);
}
return this._id;
},getUrl:function(){
return this.getID();
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.RemoteIteratorImpl"]){
dojo._hasResource["com.ibm.mm.enabler.remote.RemoteIteratorImpl"]=true;
dojo.provide("com.ibm.mm.enabler.remote.RemoteIteratorImpl");
dojo.declare("com.ibm.mm.enabler.remote.RemoteIteratorImpl",com.ibm.mm.enabler.DeferredIteratorImpl,{constructor:function(model,hrefs){
this._model=model;
this._hrefs=hrefs;
this._position=1;
},start:function(sync){
},hasNext:function(sync){
return this._position<this._hrefs.length;
},next:function(sync){
var href=this._hrefs[this._position];
var next=null;
if(href){
this._position++;
next=this._model.find(href);
}
return next;
},setCursorPosition:function(_107c){
this._position=_107c;
},getCursorPosition:function(){
return (this._position-1);
},size:function(){
return this._hrefs.length;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.remote.WidgetHelper"]){
dojo._hasResource["com.ibm.mm.enabler.remote.WidgetHelper"]=true;
dojo.provide("com.ibm.mm.enabler.remote.WidgetHelper");
dojo.declare("com.ibm.mm.enabler.remote.WidgetHelper",null,{constructor:function(model){
this._model=model;
},getDirectoryAsZipUrl:function(dir){
return dir.getID()+"?mime-type=application/zip";
},addNewTemplate:function(name,form){
if(name!=null&&name.length>0){
var _1081=name.charAt(name.length-1);
if(_1081!="/"){
name=name+"/";
}
}
var d=new com.ibm.mm.enabler.DeferredImpl(this,this._addNewTemplate,{"name":name,"form":form});
return d;
},_addNewTemplate:function(_1083,sync,_1085){
_1085["deferred"]=_1083;
var d=this.getTemplateDir();
d.setFinishedCallback(function(_1087,_1088,_1089){
var _108a={};
_108a.name=_1087.getUrl()+_1089["name"]+"?mode=replace";
_108a.isDirectory=true;
_108a.isCreate=true;
_108a.form=_1089["form"];
var file=new com.ibm.mm.enabler.remote.RemoteFileImpl(_108a);
var d2=file.init();
d2.setFinishedCallback(function(_108d,_108e,_108f){
var _1090=_108f["deferred"];
_1090.finishedCallback2(_108d,_108e,_1090.finishedCallbackParameters2);
},_1089);
d2.start();
},_1085);
d.start();
},uploadZip:function(path,name,form){
if(name!=null&&name.length>0){
var _1094=name.charAt(name.length-1);
if(_1094!="/"){
name=name+"/";
}
}
var d=new com.ibm.mm.enabler.DeferredImpl(this,this._uploadZip,{"path":path,"name":name,"form":form});
return d;
},_uploadZip:function(_1096,sync,_1098){
_1098["deferred"]=_1096;
var d=this.getZipDir(_1098["path"]);
d.setFinishedCallback(function(_109a,_109b,_109c){
var _109d={};
_109d.name=_109a.getUrl()+_109c["name"]+"?mode=replace";
_109d.isDirectory=true;
_109d.isCreate=true;
_109d.form=_109c["form"];
var file=new com.ibm.mm.enabler.remote.RemoteFileImpl(_109d);
var d2=file.init();
d2.setFinishedCallback(function(_10a0,_10a1,_10a2){
var _10a3=_10a2["deferred"];
_10a3.finishedCallback2(_10a0,_10a1,_10a3.finishedCallbackParameters2);
},_109c);
d2.start();
},_1098);
d.start();
},getZipDir:function(path){
return this._model.find(path);
},getTemplateDir:function(){
return this._model.find("/public/templates/");
},getProjectDir:function(){
var _10a5=com.ibm.mm.enabler.remote.WebDavUrlFactory.getUserHome();
return this._model.find(_10a5+"/public/projects/");
},createFile:function(_10a6){
_10a6.isDirectory=false;
_10a6.isCreate=true;
var file=new com.ibm.mm.enabler.remote.RemoteFileImpl(_10a6);
return file.init();
},createFolder:function(path){
var _10a9={};
_10a9.isDirectory=true;
_10a9.isCreate=true;
_10a9.name=path;
var file=new com.ibm.mm.enabler.remote.RemoteFileImpl(_10a9);
return file.init();
},updateFile:function(file,_10ac){
_10ac.isDirectory=false;
_10ac.isUpdate=true;
var file=new com.ibm.mm.enabler.remote.RemoteFileImpl(_10ac);
return file.init();
},copy:function(file,_10ae){
var _10af=com.ibm.mm.enabler.remote.WebDavCommandFactory.getCopyCommand(file.getUrl(),_10ae);
var ed=new com.ibm.mm.enabler.remote.WebDavDeferredImpl();
var d=_10af.execute();
d.addCallback(dojo.partial(this._copy,ed));
return ed;
},_copy:function(ed,_10b3){
ed.doCallback(_10b3,200);
},move:function(file,_10b5){
var _10b6=com.ibm.mm.enabler.remote.WebDavCommandFactory.getMoveCommand(file.getUrl(),_10b5);
var ed=new com.ibm.mm.enabler.remote.WebDavDeferredImpl();
var d=_10b6.execute();
d.addCallback(dojo.partial(this._move,ed));
return ed;
},_move:function(ed,_10ba){
ed.doCallback(_10ba,200);
},deleteFile:function(file){
return file._delete();
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.remote"]){
dojo._hasResource["com.ibm.mm.enabler.model.remote"]=true;
dojo.provide("com.ibm.mm.enabler.model.remote");
dojo.declare("com.ibm.mm.enabler.model.RemoteModelImpl",[com.ibm.mashups.enabler.model.RemoteModel,com.ibm.mm.enabler.ModelImpl],{constructor:function(){
this._files=new Object();
},getRoot:function(){
return this.find("/");
},find:function(path){
var file=new com.ibm.mm.enabler.remote.RemoteFileImpl(new Object({name:path}));
var d=file.init();
return d;
},getUserRoot:function(){
var _10bf=com.ibm.mm.enabler.remote.WebDavUrlFactory.getUserHome();
return this.find(_10bf);
},hasChildren:function(file){
var kids=file._getChildren();
if(kids){
for(child in kids){
return true;
}
}
return false;
},getParent:function(file){
var id=file.getID();
var index=id.lastIndexOf("/");
var _10c5=id.substring(0,index);
if(file.isDirectory()){
_10c5=_10c5+"/../";
}
return this.find(_10c5);
},getChildren:function(file){
return new com.ibm.mm.enabler.remote.RemoteIteratorImpl(this,file._getChildHrefs());
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.model.spaceextension"]){
dojo._hasResource["com.ibm.mm.enabler.model.spaceextension"]=true;
dojo.provide("com.ibm.mm.enabler.model.spaceextension");
dojo.declare("com.ibm.mm.enabler.model.SpaceExtensionModelImpl",[com.ibm.mashups.enabler.model.SpaceExtensionModel],{constructor:function(){
this.loadedNodes={};
},confirmCreate:function(_10c7){
if(_10c7){
if(_10c7.space){
var _10c8=_10c7.space._getSpaceExtensionURL();
return (_10c8!=null);
}else{
if(_10c7.extensionURL){
return true;
}
}
}
return false;
},create:function(_10c9){
var _10ca=(_10c9.space)?_10c9.space._getSpaceExtensionURL():_10c9.extensionURL;
var _10cb=this._getEndpointAndURL(_10ca);
var url=this._getFullURL(_10cb);
this._loadJavaScript(url);
var _10cd=this._getSpaceExtensionClassName(_10cb.url);
var _10ce=this._createSpaceExtensionImpl(_10cd);
_10ce.id=_10ca;
return _10ce;
},_getEndpointAndURL:function(_10cf){
var _10d0="endpoint://";
var index=_10cf.indexOf(_10d0);
if(index==-1){
return {"endpoint":null,"url":_10cf};
}
var start=index+_10d0.length;
var _10d3=_10cf.indexOf("/",start);
var _10d4=_10d3==-1?_10cf.substring(start):_10cf.substring(start,_10d3);
var url=_10d3==-1?null:_10cf.substring(_10d3);
return {"endpoint":_10d4,"url":url};
},_getEndpointURL:function(_10d6){
var _10d7=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _10d8=_10d7.getConfigObject(com.ibm.mashups.enabler.services.ConfigConstants.ENDPOINT_CONFIG_PROVIDER);
var _10d9=_10d8.getValue(com.ibm.mashups.enabler.services.ConfigConstants.ENDPOINTS);
if(_10d9){
var _10da=_10d9.split(";");
for(var i=0;i<_10da.length;i++){
if(_10da[i]==_10d6){
return _10d8.getValue(_10d6+".url");
}
}
}
return null;
},_getLocalServer:function(url){
if(url.indexOf("http://")==-1&&url.indexOf("https://")==-1){
var _10dd=new com.ibm.mm.enabler.utilities.HttpUrl("/");
var _10de=_10dd.toString();
while(_10de.charAt(_10de.length-1)=="/"){
_10de=_10de.substr(0,_10de.length-1);
}
return _10de;
}
return null;
},_getFullURL:function(_10df){
var _10e0=(_10df.endpoint)?this._getEndpointURL(_10df.endpoint):null;
var _10e1=_10df.url;
var _10e2=_10e1;
if(_10e0&&_10e0.length>0){
if(_10e0.charAt(_10e0.length-1)=="/"){
if(_10e1.length>0&&_10e1.charAt(0)=="/"){
_10e1=_10e1.substring(1);
}
_10e2=_10e0+_10e1;
}else{
if(_10e1){
if(_10e1.length>0&&_10e1.charAt(0)=="/"){
_10e2=_10e0+_10e1;
}else{
_10e2=_10e0+"/"+_10e1;
}
}else{
_10e2=_10e0;
}
}
}
var _10e3=this._getLocalServer(_10e2);
if(_10e3){
_10e2=(_10e2.charAt(0)=="/")?_10e3+_10e2:_10e3+"/"+_10e2;
}
var _10e4=_10e2.lastIndexOf("#");
if(_10e4!=-1){
_10e2=_10e2.substring(0,_10e4);
}
return _10e2;
},_loadJavaScript:function(url){
var _10e6=new com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter();
_10e6.loadExternalScript(url);
},_getSpaceExtensionClassName:function(_10e7){
var urls=_10e7.split("#");
if(urls.length==0){
return null;
}else{
if(urls.length>1){
var _10e9=urls[1].replace(/^\s+|\s+$/g,"");
if(_10e9!=""){
return _10e9;
}
}
}
var _10ea=urls[0];
var _10eb=_10ea.lastIndexOf("/");
if(_10eb==-1){
_10eb=0;
}else{
if(_10eb==_10ea.length-1){
return null;
}else{
_10eb=_10eb+1;
}
}
var _10ec=_10ea.lastIndexOf(".js");
if(_10ec==-1){
return _10ea.substring(_10eb);
}else{
return _10ea.substring(_10eb,_10ec);
}
},_createSpaceExtensionImpl:function(_10ed){
if(_10ed.indexOf("()")==-1){
_10ed=_10ed+"()";
}
var _10ee=eval("new "+_10ed+";");
return _10ee;
},insert:function(node,_10f0){
},confirmInsert:function(node,_10f2){
return "false";
},find:function(id){
return new com.ibm.mm.enabler.DeferredImpl(this,this._find,id);
},_find:function(_10f4,sync,id){
if(id in this.loadedNodes){
if(_10f4&&_10f4.finishedCallback2){
_10f4.finishedCallback2(this.loadedNodes[id],com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK,_10f4.finishedCallbackParameters2);
}
return this.loadedNodes[id];
}
var _10f7=this.create({"extensionURL":id});
this.loadedNodes[id]=_10f7;
return _10f7;
},findExtensionBySpace:function(_10f8){
return new com.ibm.mm.enabler.DeferredImpl(this,this._findExtensionBySpace,_10f8);
},_findExtensionBySpace:function(_10f9,sync,_10fb){
var space;
if(typeof (_10fb)=="string"){
var _10fd=com.ibm.mashups.enabler.model.Factory.getSpaceModel();
space=_10fd.find(_10fb).start();
}else{
space=_10fb;
}
var _10fe=this.confirmCreate({"space":space});
if(!_10fe){
return null;
}
return this._find(_10f9,sync,space._getSpaceExtensionURL());
}});
dojo.declare("SpaceExtension",[com.ibm.mashups.enabler.model.space.SpaceExtension],{});
dojo.declare("SpaceExtensionResult",[com.ibm.mashups.enabler.model.space.SpaceExtensionResult],{});
}
if(!dojo._hasResource["com.ibm.mm.enabler.aggregation.javascript"]){
dojo._hasResource["com.ibm.mm.enabler.aggregation.javascript"]=true;
dojo.provide("com.ibm.mm.enabler.aggregation.javascript");
dojo.provide("com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter");
function com_ibm_enabler_aggregation_javascript_globalEvalNonIE(_10ff){
eval.call(self,_10ff);
};
dojo.declare("com.ibm.mm.enabler.aggregation.javascript.Filter",null,{doFilter:function(_1100){
},evalGlobal:function(_1101){
if(window.execScript){
window.execScript(this._stripHTMLComments(_1101),"JavaScript");
}else{
com_ibm_enabler_aggregation_javascript_globalEvalNonIE(_1101);
}
},_stripHTMLComments:function(str){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.aggregation.javascript.Filter._stripHTMLComments",str);
var _1103="";
var _1104=str.indexOf("<!--");
if(_1104!=-1){
_1103=str.substring(0,_1104);
}else{
_1103=str;
}
while(_1104>=0){
var _1105=str.indexOf("-->");
if(_1105<0){
throw new Error("Unclosed HTML comment found!!");
}
_1103+=str.substring(_1105+3);
com.ibm.mm.enabler.debug.log("com.ibm.mm.enabler.aggregation.javascript.Filter._stripHTMLComments","result str = "+_1103);
_1104=str.indexOf("<!--",_1105+3);
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.aggregation.javascript.Filter._stripHTMLComments",_1103);
return _1103;
},prepareDocumentWrite:function(_1106){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.aggregation.javascript.Filter.prepareDocumentWrite");
var me=this;
document.write=function(){
me._documentWrite(_1106,document.write.arguments);
};
document.writeln=function(str){
me._documentWrite(_1106,document.writeln.arguments);
};
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.aggregation.javascript.Filter.prepareDocumentWrite");
},_documentWrite:function(_1109,args){
for(var i=0;i<args.length;i++){
_1109.content+=args[i];
}
},applyDocumentWrite:function(_110c,_110d){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.aggregation.javascript.Filter.applyDocumentWrite",_110c,_110d.content);
var cont=_110d.content;
var id=_110c.getAttribute("id");
var _1110=document.getElementById(id);
if(cont!=null&&cont.length>0){
var div=document.createElement("DIV");
div.innerHTML=cont;
var _1112=div.childNodes;
if(_1112!=null&&_1112.length>0){
var pred=_1110;
for(var i=0;i<_1112.length;){
var node=_1112[_1112.length-1];
dojo.dom.insertBefore(node,pred);
pred=node;
}
}
dojo.dom.destroyNode(div);
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.aggregation.javascript.Filter.applyDocumentWrite");
}});
dojo.declare("com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter",com.ibm.mm.enabler.aggregation.javascript.Filter,{doFilter:function(_1116){
var url=this._getScriptUrl(_1116);
var _1118=false;
if(url){
var _1119=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
if(_1119!=null){
_1119+="/";
url=this._rewriteURL(url,_1119);
}
var _111a={content:""};
this.prepareDocumentWrite(_111a);
this._loadExternalScript(url);
this.applyDocumentWrite(_1116,_111a);
_1118=true;
}
return _1118;
},_getScriptUrl:function(_111b){
var url=null;
if(_111b.getAttribute){
url=_111b.getAttribute("src");
}else{
var start=_111b.toLowerCase().indexOf("<script");
var end=_111b.toLowerCase().indexOf(">");
var _111f=_111b.substring(start,end);
var _1120=_111f.toLowerCase().indexOf("src");
if(_1120!=-1){
var _1121=_111f.indexOf("'",_1120);
var _1122=_111f.indexOf("\"",_1120);
var _1123="\"";
var _1124=_1122;
if(_1122==-1||(_1121!=-1&&_1121<_1122)){
_1123="'";
_1124=_1121;
}
var _1125=_111f.indexOf(_1123,_1124+1);
url=_111f.substring(_1124+1,_1125);
}
}
return url;
},loadExternalScript:function(url){
var _1127=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
if(_1127!=null){
_1127+="/";
url=this._rewriteURL(url,_1127);
}
this._loadExternalScript(url);
},_loadExternalScript:function(url){
var me=this;
dojo.xhrGet({url:url,load:function(data,_112b){
com.ibm.mm.enabler.debug.log("com.ibm.mm.enabler.aggregation.javascript.Filter._loadExternalScript","Retrieved JS file: ",data);
me.evalGlobal(data);
},sync:true,handleAs:"text"});
},_rewriteURL:function(_112c,_112d){
var _112e=_112d;
var host=window.location.host;
var _1130=window.location.protocol;
if(_112c.indexOf("://")<0||_112c.indexOf(_1130)==0&&_112c.indexOf(host)==_1130.length+2){
return _112c;
}
if(_112c.indexOf("https")==0){
_112e+="https/";
}else{
_112e+="http/";
}
_112e+=_112c.substr(_112c.indexOf("://")+3);
return _112e;
}});
dojo.declare("com.ibm.mm.enabler.aggregation.javascript.InlineScriptFilter",com.ibm.mm.enabler.aggregation.javascript.Filter,{doFilter:function(_1131){
var _1132=false,_1133="";
if(!dojo.isString(_1131)){
_1133=_1131.innerHTML;
}else{
var _1134=_1135.indexOf(">");
var _1136=_1135.lastIndexOf("<");
var _1135=_1131;
_1133=_1135.substring(_1134+1,_1136);
}
com.ibm.mm.enabler.debug.log("com.ibm.mm.enabler.aggregation.javascript.InlineScriptFilter.doFilter","Stripped HTML tags out: "+_1133,"processScriptArray");
if(_1133){
var _1137={content:""};
this.prepareDocumentWrite(_1137);
this.evalGlobal(_1133);
_1132=true;
this.applyDocumentWrite(_1131,_1137);
}
return _1132;
}});
dojo.declare("com.ibm.mm.enabler.aggregation.javascript.FilterChain",null,{constructor:function(){
this._filters=new Array();
},addFilter:function(_1138){
if(!this._filters){
this._filters=new Array();
}
this._filters.push(_1138);
},applyFilters:function(_1139){
var i=0;
var _113b=false;
while(i<this._filters.length&&!_113b){
_113b=this._filters[i].doFilter(_1139);
i=i+1;
}
return _113b;
}});
dojo.declare("com.ibm.mm.enabler.aggregation.javascript.WidgetJavascriptHandler",null,{constructor:function(){
this.filterChain=new com.ibm.mm.enabler.aggregation.javascript.FilterChain();
},handle:function(_113c){
com.ibm.mm.enabler.debug.entry("WidgetJavascriptHandler.handle",_113c);
var val=this.filterChain.applyFilters(_113c);
com.ibm.mm.enabler.debug.exit("WidgetJavascriptHandler.handle");
}});
com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER=new com.ibm.mm.enabler.aggregation.javascript.WidgetJavascriptHandler();
com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER.filterChain.addFilter(new com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter());
com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER.filterChain.addFilter(new com.ibm.mm.enabler.aggregation.javascript.InlineScriptFilter());
}
if(!dojo._hasResource["com.ibm.mm.enabler.model"]){
dojo._hasResource["com.ibm.mm.enabler.model"]=true;
dojo.provide("com.ibm.mm.enabler.model");
dojo.require("com.ibm.mashups.enabler.model");
dojo.require("com.ibm.mm.enabler.model.shared");
dojo.require("com.ibm.mm.enabler.model.factory");
dojo.require("com.ibm.mm.enabler.servicedocument");
dojo.require("com.ibm.mm.enabler.model.catalog");
dojo.require("com.ibm.mm.enabler.model.layout");
dojo.require("com.ibm.mm.enabler.model.navigation");
dojo.require("com.ibm.mm.enabler.model.sharedNavigation");
dojo.require("com.ibm.mm.enabler.model.theme");
dojo.require("com.ibm.mm.enabler.model.user");
dojo.require("com.ibm.mm.enabler.model.url");
dojo.require("com.ibm.mm.enabler.model.space");
dojo.require("com.ibm.mm.enabler.model.template");
dojo.require("com.ibm.mm.enabler.model.ac");
dojo.require("com.ibm.mm.enabler.aspects");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.require("com.ibm.mm.enabler.model.remote");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.require("com.ibm.mm.enabler.services.ModelRestServiceRequest");
dojo.require("com.ibm.mm.enabler.xpath");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.debug");
dojo.require("dojo.i18n");
dojo.require("com.ibm.mm.enabler.model.spaceextension");
dojo.require("com.ibm.mm.enabler.aggregation.javascript");
}
if(!dojo._hasResource["com.ibm.mm.enabler.context.localized"]){
dojo._hasResource["com.ibm.mm.enabler.context.localized"]=true;
dojo.provide("com.ibm.mm.enabler.context.localized");
dojo.require("com.ibm.mashups.enabler.context.localized");
dojo.declare("com.ibm.mm.enabler.context.LocalizedContextImpl",[com.ibm.mashups.enabler.context.LocalizedContext],{constructor:function(_113e,_113f){
this.preferredLocale=_113e||null;
if(this.preferredLocale===null){
if(typeof ibmConfig!="undefined"&&ibmConfig!=null&&typeof (ibmConfig.locale)!="undefined"&&ibmConfig.locale!=null){
this.preferredLocale=ibmConfig.locale;
}else{
this.preferredLocale=(dojo.isIE?navigator.userLanguage:navigator.language).toLowerCase();
}
}
this.defaultLocale=_113f||"en";
},getPreferredLocale:function(){
return this.preferredLocale;
},getDefaultLocale:function(){
return this.defaultLocale;
},getLocale:function(_1140){
if(typeof _1140=="undefined"||_1140===null){
return null;
}
var _1141=_1140.getLocales();
switch(_1141.length){
case 0:
return null;
break;
case 1:
return com.ibm.mm.enabler.utilities.normalizeLocale(_1141[0]);
break;
default:
var _1142=com.ibm.mm.enabler.utilities.matchLocale(this.preferredLocale,_1141);
if(_1142){
return _1142;
}
var _1143=com.ibm.mm.enabler.utilities.matchLocale(this.defaultLocale,_1141);
if(_1143){
return _1143;
}
return com.ibm.mm.enabler.utilities.normalizeLocale(_1141[0]);
break;
}
return null;
},getTitle:function(_1144){
var _1145=this.getLocale(_1144);
return _1145?_1144.getTitle(_1145):null;
},getDescription:function(_1146){
var _1147=this.getLocale(_1146);
return _1147?_1146.getDescription(_1147):null;
},_normalizeLocale:function(_1148){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.context.LocalizedContextImpl._normalizeLocale","Deprecated. Use com.ibm.mm.enabler.utilities.normalizeLocale() instead.");
return _1148.toLowerCase().replace(/-/g,"_");
},_matchLocale:function(_1149,_114a){
com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.context.LocalizedContextImpl._matchLocale","Deprecated. Use com.ibm.mm.enabler.utilities.matchLocale() instead.");
var _114b=_114a[_1149];
if(!_114b){
var parts=_1149.split("_");
if(parts.length==2){
_114b=_114a[parts[0]];
}
}
return _114b||null;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.context.factory"]){
dojo._hasResource["com.ibm.mm.enabler.context.factory"]=true;
dojo.provide("com.ibm.mm.enabler.context.factory");
dojo.declare("com.ibm.mm.enabler.context.FactoryImpl",[com.ibm.mashups.enabler.context.Factory],{constructor:function(){
},getLocalizedContext:function(_114d,_114e){
return new com.ibm.mm.enabler.context.LocalizedContextImpl(_114d,_114e);
}});
com.ibm.mashups.enabler.context.Factory=new com.ibm.mm.enabler.context.FactoryImpl();
}
if(!dojo._hasResource["com.ibm.mm.enabler.context"]){
dojo._hasResource["com.ibm.mm.enabler.context"]=true;
dojo.provide("com.ibm.mm.enabler.context");
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.model"]){
dojo._hasResource["com.ibm.mashups.iwidget.model"]=true;
dojo.provide("com.ibm.mashups.iwidget.model");
dojo.provide("com.ibm.mashups.iwidget.model.WidgetModel");
dojo.provide("com.ibm.mashups.iwidget.model.Factory");
dojo.declare("com.ibm.mashups.iwidget.model.Factory",null,{constructor:function(){
},getGlobalWidgetModel:function(){
}});
dojo.declare("com.ibm.mashups.iwidget.model.WidgetModel",null,{constructor:function(id){
},find:function(id){
},hasChildren:function(_1151){
},getChildren:function(_1152,_1153){
},getParent:function(_1154){
},getWidgetDefinitionByUrl:function(url){
},commit:function(){
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.deferred"]){
dojo._hasResource["com.ibm.mm.iwidget.deferred"]=true;
dojo.provide("com.ibm.mm.iwidget.deferred");
dojo.require("com.ibm.mm.enabler.deferred");
dojo.declare("com.ibm.mm.iwidget.DeferredLoadImpl",com.ibm.mm.enabler.DeferredImpl,{constructor:function(uri,id,_1158){
this.uri=uri;
if(typeof id=="undefined"){
id=null;
}
this.id=id;
if(typeof _1158=="undefined"){
_1158=null;
}
this.widgetDef=_1158;
},start:function(sync){
if(this.widgetDef!=null){
this._handleCallback(this.widgetDef,200);
return this.widgetDef;
}
var mode=(sync||typeof (sync)=="undefined")?false:true;
var _115b=com.ibm.mashups.services.ServiceManager.getService("widgetLoadService");
_115b.getWidgetXML(this.uri,mode,dojo.hitch(this,"_handleLoad"),this.id);
if(sync&&sync==true){
return this.widgetDef;
}
return null;
},_handleLoad:function(data,_115d,xhr){
if(typeof xhr!="undefined"&&xhr!=null){
_115d=xhr.status;
}
if(_115d!=200){
data=null;
}
this.widgetDef=data;
this._handleCallback(data,status);
},_handleCallback:function(_115f,_1160){
var _1161=this.finishedCallback2;
if(this.finishedCallback2&&this.finishedCallbackParameters2){
_1161(_115f,_1160,this.finishedCallbackParameters2);
}else{
if(this.finishedCallback2){
_1161(_115f,_1160);
}
}
return;
}});
dojo.declare("com.ibm.mm.iwidget.DeferredLiveTextUnprocessImpl",com.ibm.mm.enabler.DeferredImpl,{constructor:function(_1162){
this.wrapper=_1162;
},start:function(sync){
if(sync){
return;
}
var _1164=this.wrapper.getIWidgetInstance();
if(dojo.isFunction(this.wrapper.iScope._onGetMarkup)){
this.wrapper.iScope._onGetMarkup();
}
var _1165=dojo.clone(this.wrapper.rootElement);
dojo.publish("/com/ibm/mashups/livetext/livetextunchange",[_1165,true,null,null,dojo.hitch(this,this._unchangeCompleteCallback),this.includeParent]);
},setIncludeParent:function(value){
this.includeParent=value;
},getIncludeParent:function(){
return this.includeParent;
},_unchangeCompleteCallback:function(node){
if(dojo.isFunction(this.finishedCallback2)){
this.finishedCallback2(node,200);
}
}});
dojo.declare("com.ibm.mm.iwidget.DeferredLiveTextUnprocessStubImpl",com.ibm.mm.enabler.DeferredImpl,{constructor:function(_1168){
this.wrapper=_1168;
},start:function(sync){
if(sync){
return;
}
var _116a=this.wrapper.getIWidgetInstance();
var _116b=dojo.clone(this.wrapper.rootElement);
this._unchangeCompleteCallback(_116b);
},setIncludeParent:function(value){
this.includeParent=value;
},getIncludeParent:function(){
return this.includeParent;
},_unchangeCompleteCallback:function(node){
console.debug(this.finishedCallback2);
if(dojo.isFunction(this.finishedCallback2)){
this.finishedCallback2(node,200);
}
}});
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.itemset"]){
dojo._hasResource["com.ibm.mashups.iwidget.itemset"]=true;
dojo.provide("com.ibm.mashups.iwidget.itemset");
dojo.provide("com.ibm.mashups.iwidget.itemset.ItemSet");
dojo.provide("com.ibm.mashups.iwidget.itemset.ManagedItemSet");
dojo.provide("com.ibm.mashups.iwidget.itemset.ManagedItemSetCallbackModel");
dojo.declare("com.ibm.mashups.iwidget.itemset.ItemSet",null,{constructor:function(){
},setItemValue:function(_116e,value,_1170){
return this;
},getItemValue:function(_1171){
return null;
},getAllNames:function(){
return null;
},removeItem:function(_1172){
return null;
},clone:function(){
return null;
},isReadOnly:function(_1173){
return null;
},getItemSetDescription:function(){
return null;
}});
dojo.declare("com.ibm.mashups.iwidget.itemset.ManagedItemSet",com.ibm.mashups.iwidget.itemset.ItemSet,{constructor:function(){
},save:function(_1174){
}});
dojo.declare("com.ibm.mashups.iwidget.itemset.ManagedItemSetCallbackModel",null,{constructor:function(){
},postSaveCallbackFn:function(_1175,_1176){
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.itemSetImpl"]){
dojo._hasResource["com.ibm.mm.iwidget.itemSetImpl"]=true;
dojo.provide("com.ibm.mm.iwidget.itemSetImpl");
dojo.provide("com.ibm.mm.iwidget.itemset");
dojo.declare("com.ibm.mm.iwidget.itemset.Item",null,{constructor:function(name,value,_1179,_117a){
this.name=name;
this.value=value;
this.descriptionId=_117a;
if(typeof _1179=="undefined"||_1179==null){
this.isReadOnly=false;
}else{
this.isReadOnly=_1179;
}
}});
dojo.declare("com.ibm.mm.iwidget.itemset.DefaultItemSetImpl",com.ibm.mashups.iwidget.itemset.ItemSet,{constructor:function(_117b,name,_117d,_117e,_117f){
if(_117b){
this.parent=_117b.id;
this.scope=_117b.iScope;
}
this.name=name;
this.onItemSetChanged=_117d;
this.description=_117e;
this.isPrivate=_117f;
this.items={};
this.listeners={};
if(_117d){
this.listeners[_117d]=_117d;
}
this._debug=com.ibm.mm.enabler.debug;
},addListener:function(fn){
this.listeners[fn.toString()]=fn;
},removeListener:function(fn){
if(this.listeners[fn.toString()]){
this.listeners[fn.toString()]=null;
}
},setItemValue:function(_1182,value,_1184){
this._debug.log("ItemSet.setItemValue ","itemName:"+_1182,"value:"+value,"readOnly:"+_1184);
if(typeof value=="undefined"){
return null;
}
var _1185=false;
if(!(typeof _1184=="undefined"||_1184==null)){
_1185=_1184;
}
this._debug.log("ManagedItemSet.setItemValue","creating new Item ("+"itemName:"+_1182+" value:"+value+" readOnly:"+_1184+")");
var item=new com.ibm.mm.iwidget.itemset.Item(_1182,value,_1185);
if(this.items[_1182]){
this._debug.log("ManagedItemSet.setItemValue","Itemset readOnly is "+this.items[_1182].isReadOnly);
if(this.items[_1182].isReadOnly=="true"){
return null;
}else{
var _1187={itemSetName:this.name,changeType:"changedValue"};
_1187.old=this.items[_1182].value;
_1187["new"]=value;
var _1188=new com.ibm.mm.iwidget.iEventImpl("onItemSetChanged",null,_1187);
this.items[_1182]=item;
this._handleOnItemSetChanged(_1188);
}
}else{
var _1187={itemSetName:this.name,changeType:"newItem"};
_1187["new"]=value;
var _1188=new com.ibm.mm.iwidget.iEventImpl("onItemSetChanged",null,_1187);
this.items[_1182]=item;
this._handleOnItemSetChanged(_1188);
}
return this;
},getItemValue:function(_1189){
var _118a=this.items[_1189];
if(typeof _118a=="undefined"||_118a==null){
return null;
}
var value=this.items[_1189].value;
if(typeof value=="undefined"||value==null){
return null;
}
return value;
},getAllNames:function(){
if(typeof this.items=="undefined"||this.items==null){
return null;
}
var names=new Array();
var aName;
var i=0;
for(aName in this.items){
names.push(aName);
i=i+1;
}
if(i==0){
return null;
}
return names;
},removeItem:function(_118f){
if(this.items[_118f]){
if(this.items[_118f].isReadOnly&&this.items[_118f].isReadOnly=="true"){
return null;
}else{
if(this.items[_118f]==null){
return null;
}
}
}
var _1190={itemSetName:this.name,changeType:"removedItem"};
_1190.old=this.items[_118f].value;
var _1191=new com.ibm.mm.iwidget.iEventImpl("onItemSetChanged",null,_1190);
this.items[_118f]=null;
this._handleOnItemSetChanged(_1191);
return this;
},clone:function(){
var _1192=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(null,this.name);
var arr=this.items;
var _1194;
for(_1194 in arr){
var _1195=new com.ibm.mm.iwidget.itemset.Item();
_1195=dojo.mixin(_1195,this.items[_1194]);
_1192.items[_1195.name]=_1195;
}
return _1192;
},isReadOnly:function(_1196){
this._debug.entry("ManagedItemSet.isReadOnly","itemName:"+_1196);
var _1197=this.items[_1196];
if(typeof _1197=="undefined"||_1197==null){
return false;
}
return _1197.isReadOnly;
},getItemSetDescription:function(){
return null;
},_handleOnItemSetChanged:function(_1198){
for(var i=0;i<this.listeners;i++){
var fn=this.listeners[i];
if(fn!=null&&this.scope){
dojo.hitch(this.scope,fn)(_1198);
}
}
}});
dojo.declare("com.ibm.mm.iwidget.itemset.iDescriptor",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{constructor:function(_119b,_119c,_119d){
this.widgetId=_119b;
this.defiDescriptorItems=_119c;
this.instanceiDescriptorItems=_119d;
},getItemValue:function(name){
var value=null;
if(typeof name!="undefined"&&name!=null&&name==iwConstants.iDescriptorItems.mode){
var _11a0=this._getWidgetWrapper();
if(_11a0!=null){
value=_11a0.currentMode;
}
}else{
value=this._getItemValue(name);
}
return value;
},_getItemValue:function(_11a1){
if(this.defiDescriptorItems!=null){
var _11a2=this.defiDescriptorItems.getItemValue(_11a1);
}
if(this.instanceiDescriptorItems!=null){
var _11a3=this.instanceiDescriptorItems.getItemValue(_11a1);
}
if(typeof _11a3!="undefined"&&_11a3!=null){
return _11a3;
}
if(typeof _11a2=="undefined"){
_11a2=null;
}
return _11a2;
},setItemValue:function(name,value,_11a6){
return null;
},isReadOnly:function(name){
return true;
},_getWidgetWrapper:function(){
if(this.widgetId){
var _11a8=iWidgetContainer.widgetArr[this.widgetId];
if(_11a8&&_11a8!=null){
return _11a8;
}
}
return null;
},removeItem:function(name){
return null;
},getAllNames:function(){
var arr={};
if(this.defiDescriptorItems!=null){
var _11ab=this.defiDescriptorItems.getAllNames();
for(var i in _11ab){
arr[_11ab[i]]=true;
}
}
if(this.instanceiDescriptorItems!=null){
var _11ad=this.instanceiDescriptorItems.getAllNames();
for(var j in _11ad){
arr[_11ad[j]]=true;
}
}
var _11af=[];
for(var name in arr){
_11af.push(name);
}
return _11af;
},save:function(cb){
return null;
},getItemSetDescription:function(){
return null;
}});
dojo.declare("com.ibm.mm.iwidget.itemset.InternalPersistentAttributesToPreferenceModelAdapter",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{constructor:function(_11b2,_11b3){
this.xmlItems={};
this.serverless=(_11b3==true);
this.modes=com.ibm.mm.iwidget.itemset._internalIbmModes;
this.widget=_11b2;
this.widgetInstance=this.widget.getIWidgetInstance();
this.attributes=this.widgetInstance.getAttributes();
},setItemValue:function(_11b4,value,_11b6,_mode){
value=value?value:"";
value=""+value;
if(typeof _11b6=="string"){
_11b6=(_11b6.toLowerCase()=="true");
}else{
_11b6=(_11b6==true);
}
if(this.serverless){
var mode=this._getMode(_mode);
if(mode!=this.modes.xml&&mode!=this.modes.microformat){
return null;
}
var _11b9=this.xmlItems[_11b4];
if(_11b9&&_11b9.readOnly){
return null;
}
if(mode==this.modes.xml){
this.xmlItems[_11b4]={value:value,readOnly:_11b6};
return this;
}
this.attributes.setItemValue(_11b4,value);
return (this);
}
return null;
},getItemValue:function(_11ba,_mode,_11bc){
if(this.serverless){
var mode=this._getMode(_mode);
if(mode!=this.modes.xml&&mode!=this.modes.microformat){
return null;
}
if(_11bc==undefined){
_11bc=true;
}
var _11be=this.xmlItems[_11ba];
if(mode==this.modes.xml){
if(!_11be){
return null;
}
return _11be.value;
}
var value=this.attributes.getItemValue(_11ba);
if(_11bc&&_11be&&(_11be.readOnly||(value==null))){
return _11be.value;
}
return value;
}
return null;
},getAllNames:function(_mode,_11c1){
if(this.serverless){
var mode=this._getMode(_mode);
if(mode!=this.modes.xml&&mode!=this.modes.microformat){
return null;
}
if(_11c1==undefined){
_11c1=true;
}
if(!_11c1){
if(mode==this.modes.xml){
return this._getNamesArray(this.xmlItems);
}
return this.attributes.getAllNames();
}
var _11c3={};
var name;
for(name in this.xmlItems){
_11c3[name]=true;
}
var _11c5=this.attributes.getAllNames();
for(name in _11c5){
_11c3[_11c5[name]]=true;
}
return this._getNamesArray(_11c3);
}
return null;
},removeItem:function(_11c6,_mode){
if(this.serverless){
var mode=this._getMode(_mode);
if(mode!=this.modes.microformat){
return null;
}
this.attributes.removeItem(_11c6);
return this;
}
return null;
},clone:function(){
return null;
},isReadOnly:function(_11c9,_mode,_11cb){
if(this.serverless){
var mode=this._getMode(_mode);
if(mode!=this.modes.xml&&mode!=this.modes.microformat){
return false;
}
if(_11cb==undefined){
_11cb=true;
}
var _11cd=this.xmlItems[_11c9];
var _11ce=null;
if(mode==this.mode.xml){
if(!_11cd){
return false;
}
return _11cd.readOnly;
}
if(_11cb&&_11cd&&(_11cd.readOnly||(_11ce==null))){
return _11cd.readOnly;
}
return false;
}
return null;
},save:function(_11cf){
if(this.serverless){
this._saveMicroformat();
}else{
return null;
}
this.reload();
if(_11cf){
_11cf();
}
return (this);
},reload:function(){
if(this.serverless){
return this;
}
return null;
},_getNamesArray:function(items){
var i=0;
var names=new Array();
var name;
for(name in items){
names.push(name);
i++;
}
if(i==0){
return null;
}
return names;
},_saveMicroformat:function(){
this.widget.commit();
var _11d4={};
_11d4.wid=this.widget.id;
this.widget.eventSvr._publishEvent(iwConstants.EVENTS.onAttributeSaved,_11d4,this.widget.hubId);
},_setMode:function(mode){
this._mode=mode;
},_getMode:function(_mode){
if(_mode){
return _mode;
}
if(!this._mode){
this._mode=this.modes.microformat;
}
return this._mode;
}});
dojo.declare("com.ibm.mm.iwidget.itemset.PersistentAttributes",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{constructor:function(_11d7,_11d8,_11d9){
this._internalPersistentAttributesToPreferenceModelAdapter=new com.ibm.mm.iwidget.itemset.InternalPersistentAttributesToPreferenceModelAdapter(_11d7,_11d8,_11d9);
},setItemValue:function(_11da,value,_11dc){
return this._internal().setItemValue(_11da,value,_11dc);
},getItemValue:function(_11dd){
return this._internal().getItemValue(_11dd);
},getAllNames:function(){
return this._internal().getAllNames();
},removeItem:function(_11de){
return this._internal().removeItem(_11de);
},clone:function(){
return this._internal().clone();
},isReadOnly:function(_11df,_mode,_11e1){
return this._internal().isReadOnly(_11df);
},save:function(_11e2){
return this._internal().save(_11e2);
},_internal:function(){
return this._internalPersistentAttributesToPreferenceModelAdapter;
}});
com.ibm.mm.iwidget.itemset._internalIbmModes={view:"view",edit:"edit",edit_default:"edit_default",microformat:"com.ibm.microformat",configure:"configure",xml:"com.ibm.xml",help:"help"};
dojo.declare("com.ibm.mm.iwidget.itemset.UserProfile",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{constructor:function(_11e3,user){
this.widgetId=_11e3;
this.user=user;
},getItemValue:function(name){
var value=this.user.getAttribute(name);
if(typeof value=="undefined"){
value=null;
}
return value;
},setItemValue:function(name,value,_11e9){
return null;
},isReadOnly:function(name){
return true;
},removeItem:function(name){
return null;
},getAllNames:function(){
return this.user.getAttributeNames();
},save:function(cb){
return null;
},getItemSetDescription:function(){
return null;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.payloadDef"]){
dojo._hasResource["com.ibm.mm.iwidget.payloadDef"]=true;
dojo.provide("com.ibm.mm.iwidget.payloadDef");
dojo.declare("com.ibm.mm.iwidget.payloadDef",null,{constructor:function(name,type,_11ef,_11f0,_11f1){
this.name=name;
this.attributes=_11f1;
if(typeof (this.attributes)=="undefined"||this.attributes==null){
this.attributes={};
}
if(typeof type!="undefined"&&type!=null){
this.attributes["type"]=type;
}
if(typeof _11ef!="undefined"&&_11ef!=null){
this.attributes["defaultValue"]=_11ef;
}
if(typeof _11f0!="undefined"&&_11f0!=null){
this.attributes["description"]=_11f0;
}
this.attributeNames=[];
this.attributeNames.push("type");
this.attributeNames.push("defaultValue");
this.attributeNames.push("description");
var aName;
for(aName in _11f1){
this.attributeNames.push(aName);
}
this.children=new com.ibm.mm.enabler.ArrayMap();
},setAttribute:function(name,_11f4){
this.attributes[name]=_11f4;
if(typeof (this.attributeNames[name])!="undefined"){
this.attributeNames.push(name);
}
},getAttribute:function(name){
var _11f6=this.attributes[name];
if(typeof _11f6=="undefined"){
_11f6=null;
}
return _11f6;
},getAttributeNames:function(){
this.attributeNames;
},getChildren:function(){
return this.children.values();
},getChild:function(name){
return this.children.get(name);
},setChild:function(name,_11f9){
this.children.put(name,_11f9);
},getChildrenNames:function(){
this.children.keySet();
},getName:function(){
return this.name;
},getType:function(){
return this.attributes["type"];
},getDefaultValue:function(){
return this.attributes["defaultValue"];
},getDescription:function(){
return this.attributes["description"];
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.utils"]){
dojo._hasResource["com.ibm.mm.iwidget.utils"]=true;
dojo.provide("com.ibm.mm.iwidget.utils");
dojo.declare("com.ibm.mm.iwidget.UtilImpl",null,{widgetClassRE:new RegExp("(mm:|mm_|iw-)iWidget"),findElementByAttribute:function(att,value,root,_11fd,_11fe){
var aRoot=root;
if(!root.childNodes||root.childNodes==null){
return false;
}
if(att&&att!=null&&att=="class"){
dojo.query("."+value,root).forEach(function(ele){
_11fd.push(ele);
});
if(_11fd.length!=0){
return true;
}
return false;
}
if(root.getElementsByTagName){
var nodes=root.getElementsByTagName("*");
for(var i=0;i<nodes.length;i++){
var aNode=nodes[i];
if(aNode&&aNode.getAttribute){
var _1204=aNode.getAttribute(att);
if(_1204==value){
_11fd.push(aNode);
if(!_11fe){
return true;
}
}
}
}
}
return false;
},getClass:function(node){
var _1206=node.getAttribute("class");
_1206=_1206?_1206:node.getAttribute("className");
return _1206;
},checkParentElement:function(_1207,_1208){
if(_1207){
var _1209=_1207.parentNode;
if(_1209){
if(_1209.className){
if(_1209.className.match(_1208)){
return _1209.id;
}
}
return this.checkParentElement(_1209,_1208);
}
}
return null;
},getWidgetParent:function(node,_120b){
if(dojo.isString(node)==true){
node=dojo.byId(node);
}
if(!_120b){
_120b=this.widgetClassRE;
}
return this.checkParentElement(node,_120b);
},getParents:function(_120c,arr){
var _120e=_120c.getParent();
if(typeof _120e!="undefined"&&_120e!=null){
arr.push(_120e);
this.getParents(_120e,arr);
}
return;
},getPayloadDef:function(aNode){
var name=aNode.getAttribute("name");
var _1211=new com.ibm.mm.iwidget.payloadDef(name);
var _1212=aNode.attributes;
for(var i=0;i<_1212.length;i++){
var _1214=_1212[i];
if(_1214.name!="name"){
_1211.setAttribute(_1214.name,_1214.value);
}
}
var _1215=aNode.childNodes;
for(var j=0;j<_1215.length;j++){
var child=_1215[j];
if(child.nodeType==1){
var _1218=this.getPayloadDef(child);
_1211.setChild(_1218.name,_1218);
}
}
return _1211;
}});
com.ibm.mm.iwidget.utils=new com.ibm.mm.iwidget.UtilImpl();
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.iContext"]){
dojo._hasResource["com.ibm.mashups.iwidget.iContext"]=true;
dojo.provide("com.ibm.mashups.iwidget.iContext");
dojo.provide("com.ibm.mashups.iwidget.iEvents");
dojo.provide("com.ibm.mashups.iwidget.io");
dojo.declare("com.ibm.mashups.iwidget.iContext",null,{constructor:function(){
},constants:{mode:{VIEW:"view",EDIT:"edit",HELP:"help"},ATTRIBUTES:"attributes",IDESCRIPTOR:"idescriptor",USERPROFILE:"userprofile",keys:{SHIFT:1,ALT:2,CTRL:4,META:8,CAPSLOCK:16}},getRootElement:function(){
return null;
},getElementById:function(id,root){
return null;
},getiWidgetAttributes:function(){
return {};
},getItemSet:function(name,_121c){
return null;
},requires:function(_121d,_121e,uri,cb,_1221){
},iScope:function(){
return null;
},processMarkup:function(_1222){
return null;
},processiWidgets:function(root){
},getElementByClass:function(_1224,root){
return null;
},getUserProfile:function(){
return null;
},getiDescriptor:function(){
return null;
},getWidgetXMLPath:function(){
return null;
},io:{},iEvents:{}});
dojo.declare("com.ibm.mashups.iwidget.iEvents",null,{constructor:function(){
},fireEvent:function(_1226,_1227,_1228){
},setEvent:function(_1229){
},removeEvent:function(_122a){
},getEvents:function(_122b){
},createEventDescription:function(_122c){
}});
dojo.declare("com.ibm.mashups.iwidget.io",null,{constructor:function(){
},rewriteURI:function(uri,isXhr){
return null;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.iContextImpl"]){
dojo._hasResource["com.ibm.mm.iwidget.iContextImpl"]=true;
dojo.provide("com.ibm.mm.iwidget.iContextImpl");
dojo.provide("com.ibm.mm.iwidget.iEventsImpl");
dojo.provide("com.ibm.mm.iwidget.io");
dojo.require("com.ibm.mm.enabler.utilities");
dojo.require("com.ibm.mm.enabler.model.factory");
dojo.declare("com.ibm.mm.iwidget.iContextImpl",com.ibm.mashups.iwidget.iContext,{constructor:function(_122f){
this.widgetwrapper=_122f;
this.widgetId=_122f.id;
this.scope={};
this.iEvents=new com.ibm.mm.iwidget.iEventsImpl(this.widgetwrapper);
this.io=new com.ibm.mm.iwidget.io(this.widgetwrapper);
this.rootElement=dojo.byId(this.widgetId);
this.ns=this.rootElement.className.substr(0,3);
this._mm=new com.ibm.mm.iwidget.iContextImpl.mmExtension(this.widgetwrapper);
},getRootElement:function(){
return dojo.byId(this.widgetId);
},getElementById:function(id,root){
if(!root){
root=this._getContentRoot();
}
var _1232=[];
var rc=com.ibm.mm.iwidget.utils.findElementByAttribute("id",id,root,_1232,false);
if(rc){
return _1232[0];
}else{
return null;
}
},getiWidgetAttributes:function(){
var attrs=this.widgetwrapper.getAttributes();
return attrs;
},getItemSet:function(name){
com.ibm.mm.enabler.debug.entry("iContext.getItemSet","name:"+name);
if(typeof name=="undefined"||name==null){
return null;
}
if(name==iwConstants.ATTRIBUTES){
return this.getiWidgetAttributes();
}
if(name==iwConstants.USERPROFILE){
return this.getUserProfile();
}
if(name==iwConstants.IDESCRIPTOR){
return this.getiDescriptor();
}
var _1236=this.widgetwrapper.getWidgetItemSet(name);
if(typeof _1236=="undefined"||_1236==null){
_1236=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl();
}
com.ibm.mm.enabler.debug.exit("iContext.getItemSet","object:"+_1236);
return _1236;
},requires:function(_1237,_1238,uri,cb,_123b){
if(typeof _123b=="undefined"||_123b==null){
_123b="text/plain";
}
if(typeof uri!="undefined"&&uri!=null){
com.ibm.mashups.services.ServiceManager.getService("resourceLoadService").loadResource(this.widgetId,_1237,uri,cb,_123b);
}
},iScope:function(){
return this.scope;
},processMarkup:function(_123c){
var _123d=_123c.replace(/_IWID_/g,"_"+this.widgetId+"_");
var _123e=_123d.replace(/iContext(?=\.|\s|\(|\))/g,"_"+this.widgetId+"_iContext");
return _123e;
},processiWidgets:function(root){
dojo.publish("/com/ibm/mashups/livetext/livetextchanged",[root,true]);
},getElementByClass:function(_1240,root){
if(!root){
root=this._getContentRoot();
}
var _1242=dojo.query("."+_1240,root);
if(typeof _1242!="undefined"&&_1242!==null){
if(_1242.length==0){
return null;
}else{
var _1243=[];
for(var i=0;i<_1242.length;i++){
_1243.push(_1242[i]);
}
return _1243;
}
}
return null;
},getWidgetXMLPath:function(){
var url=this.widgetwrapper.getIWidgetInstance().widgetXMLUrl;
var _1246=url.indexOf("?");
if(0<_1246){
url=url.substring(0,_1246);
}
var url2=com.ibm.mm.enabler.model.Utils.checkForEndpoints(url);
if(url2!=null){
url=url2;
}
return url;
},_getWidgetBaseUri:function(){
var _1248=this.widgetwrapper.getIWidgetInstance().widgetXMLUrl;
var _1249=_1248.indexOf("?");
if(0<_1249){
_1248=_1248.substring(0,_1249);
}
return _1248.substring(0,_1248.lastIndexOf("/")+1);
},_getContentRoot:function(){
var _124a=this.getRootElement();
var _124b=this.widgetwrapper.currentMode;
if(!_124b){
_124b="view";
}
var _124c=this.widgetwrapper.windowManager[_124b];
if(typeof _124c!="undefined"&&_124c!=null){
var temp=_124c.root;
if(typeof temp!="undefined"&&temp!=null){
_124a=temp;
}
}
return _124a;
},getUserProfile:function(){
var _124e=com.ibm.mashups.enabler.model.Factory.getUserModel();
var user=_124e.findCurrentUser().start();
var _1250=null;
if(typeof user!="undefined"&&user!=null){
_1250=new com.ibm.mm.iwidget.itemset.UserProfile(this.widgetId,user);
}
return _1250;
},getiDescriptor:function(){
var _1251=this.widgetwrapper.getIDescriptorItems();
return _1251;
}});
dojo.declare("com.ibm.mm.iwidget.iContextImpl.mmExtension",null,{constructor:function(_1252){
this.widget=_1252;
this.widgetId=_1252.id;
},getSupportedModes:function(){
var _1253=this.widgetwrapper.widgetDef.getSupportedModes();
return _1253;
},getPayloadDef:function(name){
var _1255=this.widget.widgetDef.payloadDefs;
var _1256=_1255[name];
if(typeof _1256=="undefined"){
return null;
}
return _1256;
},getPayloadDefNames:function(){
var _1257=this.widget.widgetDef.payloadDefs;
var arr=[];
var a;
for(a in _1257){
arr.push(a);
}
return arr;
}});
dojo.declare("com.ibm.mm.iwidget.io",com.ibm.mashups.iwidget.io,{constructor:function(_125a){
this.id=_125a.id;
var _125b=_125a;
var _125c=_125b.getIWidgetInstance().widgetXMLUrl;
var _125d=_125c.indexOf("?");
if(0<_125d){
_125c=_125c.substring(0,_125d);
}
var uri2=com.ibm.mm.enabler.model.Utils.checkForEndpoints(_125c);
if(uri2!=null){
_125c=uri2;
}
this.widgetBaseUri=_125c.substring(0,_125c.lastIndexOf("/")+1);
this.widgetBaseUriXhr=this.widgetBaseUri;
if(this.widgetBaseUri.indexOf("/")!=0){
this.widgetBaseUriXhr=com.ibm.mm.enabler.utilities.rewriteURL(this.widgetBaseUri);
}
if(this.widgetBaseUri.indexOf("://")!=-1){
var _125f=this.widgetBaseUri.indexOf("://");
var _1260=this.widgetBaseUri.indexOf("/",_125f+3);
this.serverRoot=this.widgetBaseUri.substring(0,_1260);
this.serverRootXhr=com.ibm.mm.enabler.utilities.rewriteURL(this.serverRoot);
this.serverRootXhr=this.serverRootXhr.substring(0,this.serverRootXhr.length-1);
}
},rewriteURI:function(uri,isXhr){
com.ibm.mm.enabler.debug.entry("com.ibm.mm.iwidget.io.rewriteURI",uri+" isXhr:"+isXhr);
if(typeof isXhr=="undefined"){
isXhr=true;
}
var uri2=com.ibm.mm.enabler.model.Utils.checkForEndpoints(uri);
if(uri2!=null){
uri=uri2;
}
var _1264=uri;
if(isXhr){
if(uri.indexOf("://")!=-1){
_1264=com.ibm.mm.enabler.utilities.rewriteURL(uri);
}else{
if(uri.indexOf(this.serverRootXhr)==0){
_1264=uri;
}else{
var _1265=uri.split("?");
var _1266=com.ibm.mm.enabler.utilities.encodePath(_1265[0]);
if(uri.indexOf("/")==0){
_1264=((typeof (this.serverRootXhr)!="undefined")?this.serverRootXhr:"")+_1266;
}else{
_1264=((typeof (this.widgetBaseUriXhr)!="undefined")?this.widgetBaseUriXhr:"")+_1266;
}
if(_1265.length==2){
_1264+="?"+_1265[1];
}
}
}
}else{
if(uri.indexOf("://")==-1){
var _1265=uri.split("?");
var _1266=com.ibm.mm.enabler.utilities.encodePath(_1265[0]);
if(uri.indexOf("/")==0){
if(typeof (this.serverRootXhr)!="undefined"){
_1264=this.serverRoot+_1266;
}
}else{
if(typeof (this.widgetBaseUri)!="undefined"){
_1264=this.widgetBaseUri+_1266;
}
}
if(_1265.length==2){
_1264+="?"+_1265[1];
}
}
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.iwidget.io.rewriteURI",_1264);
return _1264;
},getWebAppRootPath:function(){
var _1267="/";
if(typeof (this.widgetBaseUri)!="undefined"){
_1267=this.widgetBaseUri;
if(_1267.length>0){
if(_1267.indexOf("://")>0){
var parts=_1267.split("/");
if(parts.length>=4){
_1267=parts[0]+"//"+parts[2]+"/"+parts[3]+"/";
}else{
_1267="/";
}
}
}
}
return _1267;
},request:function(_1269,uri,_126b,_126c,_126d){
var xhr=dojo._xhrObj();
var _126f=this.rewriteURI(uri);
var async=false;
if(_126b){
xhr.onreadystatechange=_126b;
async=true;
}
var _1271=_1269;
if(typeof _1269=="undefined"||_1269==null){
_1271=this.httpmethods.GET;
}
if(typeof _1269!="undefined"&&_1269!=null){
if(!this.httpmethods[_1269]){
_1271=this.httpmethods.GET;
}
}
xhr.open(_1271,_126f,async);
console.debug(_1271+" "+_126f);
var _1272="application/x-www-form-urlencoded";
if(_126d){
for(var i=0;i<_126d.length;i++){
var _1274=_126d[i];
var _1275=_1274[_1275];
var value=_1274[value];
if(_1275=="Content-Type"){
var _1277=value;
}else{
xhr.setRequestHeader(_1275,value);
}
}
}
xhr.setRequestHeader("Content-Type",(_1277||_1272));
if(_1271==this.httpmethods.PUT||_1271==this.httpmethods.POST){
if(_126c){
xhr.send(_126c);
}
}else{
xhr.send(null);
}
return xhr;
},httpmethods:{GET:"GET",PUT:"PUT",POST:"POST",DELETE:"DELETE",HEAD:"HEAD",OPTIONS:"OPTIONS"}});
dojo.declare("com.ibm.mm.iwidget.iEventsImpl",com.ibm.mashups.iwidget.iEvents,{constructor:function(_1278){
this.widget=_1278;
this.id=_1278.id;
this.svc=com.ibm.mashups.services.ServiceManager.getService("eventService");
},createEventDescription:function(_1279){
return new com.ibm.mm.iwidget.iEventDescriptionImpl(_1279);
},getEvents:function(_127a){
var _127b=this.widget._getPublicEvents();
var _127c=_127b.getEvents(_127a);
if(_127c==null){
return null;
}
var arr=[];
for(var i in _127c){
arr.push(_127c[i].clone());
}
return arr;
},setEvent:function(_127f){
var _1280=this.widget._getPublicEvents();
var rc=_1280.eventExists(_127f.name);
if(rc){
if(this.widget._inIframe()){
this.svc._publishEvent(this.svc.WIDGETEVENT_PREFIX+"_stub_"+this.id,{"scope":"eventmodel","methodname":"updateEvent","params":[_127f.toJson()]},this.id);
}
rc=_1280.updateEvent(_127f);
}else{
if(this.widget._inIframe()){
this.svc._publishEvent(this.svc.WIDGETEVENT_PREFIX+"_stub_"+this.id,{"scope":"eventmodel","methodname":"createEvent","params":[_127f.toJson()]},this.id);
}
rc=_1280.createEvent(_127f);
}
return rc;
},removeEvent:function(_1282){
if(this.widget._inIframe()){
this.svc._publishEvent(this.svc.WIDGETEVENT_PREFIX+"_stub_"+this.id,{"scope":"eventmodel","methodname":"removeEvent","params":[_1282]},this.id);
}
var _1283=this.widget._getPublicEvents();
var rc=_1283.removeEvent(_1282);
return rc;
},publishEvent:function(_1285,_1286,_1287){
return this.fireEvent(_1285,_1287,_1286);
},fireEvent:function(_1288,_1289,_128a){
var _128b=new com.ibm.mm.iwidget.iEventImpl(_1288,_1289,_128a,null);
var _128c=this.widget._getPublicEvents();
var _128d=false;
if(_128c!=null){
var temp=_128c.find(_1288);
if(temp!=null&&temp.handlingFn&&temp.handlingFn!=null){
_128d=true;
}
}
if(_128d==false){
this.widget.handleEvent(_128b);
}
if(_128c!=null){
var temp=_128c.find(_1288);
if(temp!=null&&(temp.isPublished=="true"||temp.isPublished==true)){
this.svc.publishWire(this.id,_1288,_128a,_1289);
}
}
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widget.wire"]){
dojo._hasResource["com.ibm.mm.iwidget.widget.wire"]=true;
dojo.provide("com.ibm.mm.iwidget.widget.wire");
dojo.declare("com.ibm.mm.iwidget.widget.WireImpl",[com.ibm.mashups.iwidget.widget.Wire,com.ibm.mashups.enabler.Identifiable],{constructor:function(_128f,obj){
if(obj){
this.SourceWidget=obj.SourceWidget;
this.SourceEvent=obj.SourceEvent;
this.TargetEvent=obj.TargetEvent;
}
this.TargetWidget=_128f;
this._isDirty=false;
this._type=null;
},TYPE_NEW:"NEW",TYPE_DELETE:"DELETE",getID:function(){
return this.SourceWidget+"_"+this.SourceEvent+"_"+this.TargetWidget+"_"+this.TargetEvent;
},getSourceWidgetID:function(){
return this.SourceWidget;
},getSourceEventName:function(){
return this.SourceEvent;
},getTargetWidgetID:function(){
return this.TargetWidget;
},getTargetEventName:function(){
return this.TargetEvent;
},setDirty:function(_1291){
this._isDirty=_1291;
},isDirty:function(){
return this._isDirty;
},setType:function(type){
this._type=type;
},getType:function(){
return this._type;
},setSubHandler:function(_1293){
this._subHandle=_1293;
},getSubHandler:function(){
return this._subHandle;
}});
dojo.declare("com.ibm.mm.iwidget.widget.ModifiableWireModelImpl",null,{constructor:function(_1294){
this._dirty=false;
this._instance=_1294;
this.svc=com.ibm.mashups.services.ServiceManager.getService("eventService");
},toJson:function(){
var _1295={};
_1295._dirty=this._dirty;
if(this._wires){
_1295._wires=dojo.clone(this._wires);
}
if(this._targets){
_1295._targets=dojo.clone(this._targets);
}
return _1295;
},isDirty:function(){
return this._dirty;
},setDirty:function(_1296){
this._dirty=_1296;
},registerTargets:function(tw,te,se){
if(!this._targets){
this._targets={};
}
if(!this._targets[tw]){
this._targets[tw]=[];
}
var wire={tw:tw,te:te,sw:this._instance.id,se:se};
this._targets[tw].push(wire);
this._dirty=true;
},getTargets:function(){
if(!this._targets){
return null;
}
return this._targets;
},removeTargets:function(tw,te,se){
if(this._targets){
if(this._targets[tw]){
if(!te&&!se){
delete (this._targets[tw]);
this._dirty=true;
}
}
}
},_addWire:function(wire,_129f){
if(this._findWire(wire.getID())==null){
if(typeof this._wires=="undefined"||this._wires==null){
this._wires=[];
}
if(!(_129f&&_129f==true)){
wire.setDirty(true);
wire.setType(wire.TYPE_NEW);
this._dirty=true;
}
this._wires.push(wire);
this.svc.subscribeWire(wire.SourceWidget,wire.SourceEvent,this._instance.id,wire.TargetEvent);
}
},_removeWire:function(id){
var wire=this._findWire(id);
if(wire!=null){
for(var i in this._wires){
if(this._wires[i].getID()==id){
this._wires[i].setDirty(true);
this._wires[i].setType(this._wires[i].TYPE_DELETE);
this.svc.unSubscribeWire(wire.SourceWidget,wire.SourceEvent,this._instance.id,wire.TargetEvent);
this._dirty=true;
break;
}
}
}
},addWire:function(_12a3,_12a4,_12a5){
var aWire={};
aWire.SourceWidget=_12a3;
aWire.SourceEvent=_12a4;
aWire.TargetEvent=_12a5;
var wire=new com.ibm.mm.iwidget.widget.WireImpl(this._instance.id,aWire);
this._addWire(wire);
},removeWire:function(_12a8,_12a9,_12aa){
var aWire={};
if(_12a8&&_12a8!=null&&_12a9&&_12a9!=null&&_12aa&&_12aa!=null){
aWire.SourceWidget=_12a8;
aWire.SourceEvent=_12a9;
aWire.TargetEvent=_12aa;
var _12ac=new com.ibm.mm.iwidget.widget.WireImpl(this._instance.id,aWire);
this._removeWire(_12ac.getID());
}else{
if(_12a8&&_12a8!=null){
for(var w in this._wires){
if(this._wires[w].getSourceWidgetID()==_12a8){
this._wires[w].setDirty(true);
this._wires[w].setType(this._wires[w].TYPE_DELETE);
var wire=this._wires[w];
this.svc.unSubscribeWire(_12a8,wire.SourceEvent,wire.TargetWidget,wire.TargetEvent);
this._dirty=true;
}
}
}
}
},_findWire:function(id){
if(typeof (this._wires)!="undefined"&&this._wires!=null){
for(var w in this._wires){
if(this._wires[w].getID()==id){
var wire=this._wires[w];
if(wire.isDirty()&&wire.getType()!=null&&wire.getType()==wire.TYPE_DELETE){
this._removeFromDOM(wire);
delete this._wires[w];
wire=null;
}else{
break;
}
}
}
}
return wire||null;
},getWires:function(){
if(typeof (this._wires)=="undefined"||this._wires==null){
this._loadWires();
}
var arr=[];
for(var i in this._wires){
var aWire=this._wires[i];
if(!(aWire.isDirty()==true&&(aWire.getType()!=null&&aWire.getType()==aWire.TYPE_DELETE))){
arr.push(aWire);
}
}
return arr;
},_loadWires:function(){
this._wires=[];
var ns=this._instance.ns;
var _12b6="ReceivedEvent";
var nodes=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",ns+_12b6,this._instance.rootElement,nodes,true);
var names=["SourceWidget","SourceEvent","TargetEvent"];
var _12b9=["SourceEvent","TargetEvent"];
for(var i=0;i<nodes.length;i++){
var aNode=nodes[i];
var aWire={};
var _12bd=true;
for(var j=0;j<2;j++){
var _12bf=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",ns+_12b9[j],aNode,_12bf,false);
if(_12bf.length==0){
_12bd=false;
}else{
if(j==0){
var temp=_12bf[0].getAttribute("href");
if(typeof temp!="undefined"||temp!=null){
var index=temp.indexOf("#");
if(index!=-1){
temp=temp.substring(index+1);
}
aWire[names[0]]=temp;
aWire[names[1]]=_12bf[0].innerHTML;
}
}else{
aWire[names[2]]=_12bf[0].innerHTML;
}
}
}
if(_12bd){
this._addWire(new com.ibm.mm.iwidget.widget.WireImpl(this._instance.id,aWire),true);
}
}
},commit:function(){
if(this.isDirty()==true){
for(var i in this._wires){
var aWire=this._wires[i];
if(aWire.isDirty()&&aWire.getType()!=null&&aWire.getType()==aWire.TYPE_NEW){
this._addToDOM(aWire);
aWire.setDirty(false);
aWire.setType(null);
}else{
if(aWire.isDirty()&&aWire.getType()!=null&&aWire.getType()==aWire.TYPE_DELETE){
this._removeFromDOM(aWire);
this._wires.splice(i,1);
}
}
}
this.setDirty(false);
}
},_addToDOM:function(aWire){
var _12c5=aWire.getSourceWidgetID();
var _12c6=aWire.getSourceEventName();
var _12c7=aWire.getTargetEventName();
var _12c8=document.createElement("span");
_12c8.className=this._instance.ns+"ReceivedEvent";
var _12c9=document.createElement("a");
_12c9.className=this._instance.ns+"SourceEvent";
_12c9.setAttribute("href","#"+_12c5);
_12c9.innerHTML=_12c6;
var _12ca=document.createElement("span");
_12ca.className=this._instance.ns+"TargetEvent";
_12ca.innerHTML=_12c7;
_12c8.appendChild(_12c9);
_12c8.appendChild(_12ca);
this._instance.rootElement.appendChild(_12c8);
},_removeFromDOM:function(aWire){
var _12cc=aWire.getSourceWidgetID();
var _12cd=aWire.getSourceEventName();
var _12ce=aWire.getTargetEventName();
var _12cf=this._instance.rootElement;
var _12d0=dojo.query("."+this._instance.ns+"ReceivedEvent",_12cf);
var _12d1=com.ibm.mashups.services.ServiceManager.getService("iwidgetFragmentService");
for(var i=0;i<_12d0.length;i++){
var _12d3=_12d0[i];
var _12d4=dojo.query("."+this._instance.ns+"SourceEvent",_12d3)[0];
var _12d5=_12d4.innerHTML;
var _12d6=dojo.query("."+this._instance.ns+"TargetEvent",_12d3)[0];
if(_12d1.getKeyFromHref(_12d4)==_12cc&&_12d5==_12cd&&_12d6.innerHTML==_12ce){
_12cf.removeChild(_12d3);
break;
}
}
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetinstance"]){
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetinstance"]=true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetinstance");
dojo.declare("com.ibm.mm.iwidget.widget.IWidgetInstanceImpl",com.ibm.mashups.iwidget.widget.IWidgetInstance,{constructor:function(_12d7,id){
this.rootElement=_12d7;
this.id=id;
this.ns=_12d7.className.substr(0,3);
var nodes=[];
className=this.ns+"Definition";
com.ibm.mm.iwidget.utils.findElementByAttribute("class",className,this.rootElement,nodes,false);
var node=nodes[0];
var url=node.getAttribute("href");
if(typeof (url)!="undefined"&&url!==null){
this.widgetXMLUrl=url;
}
this.wiremodel=new com.ibm.mm.iwidget.widget.ModifiableWireModelImpl(this);
},getDefaultViewContent:function(){
if(this.defaultViewContent){
return this.defaultViewContent;
}
var _12dc=this.ns+"Content";
var _12dd=dojo.query("span."+_12dc,this.rootElement);
if(typeof _12dd!="undefined"&&_12dd!==null){
var node=_12dd[0];
}
if(node){
this.defaultViewContent=node.innerHTML;
return this.defaultViewContent;
}else{
return null;
}
},getWidgetEvents:function(){
if(this.widgetEvents){
return this.widgetEvents;
}
var _12df={};
var _12e0=this.rootElement.attributes;
for(var i=0;i<_12e0.length;i++){
var _12e2=_12e0[i];
if(_12e2.name!==null&&_12e2.name.indexOf("on")===0){
var _12e3=this.rootElement.getAttribute(_12e2.name);
if(typeof _12e3!="undefined"&&_12e3!==null){
_12df[_12e2.name]=_12e3;
com.ibm.mm.enabler.debug.log("iWidgetInstance.getWidgetEvents","eventName:"+_12e2.name+" handler:"+_12df[_12e2.name]);
}
}
}
this.widgetEvents=_12df;
return this.widgetEvents;
},_addWire:function(wire){
return this.wiremodel._addWire(wire);
},_removeWire:function(id){
return this.wiremodel._removeWire(id);
},addWire:function(_12e6,_12e7,_12e8){
return this.wiremodel.addWire(_12e6,_12e7,_12e8);
},removeWire:function(_12e9,_12ea,_12eb){
return this.wiremodel.removeWire(_12e9,_12ea,_12eb);
},getWires:function(){
return this.wiremodel.getWires();
},getWireModel:function(){
return this.wiremodel;
},getAttributes:function(){
if(!this.attributeProperties){
var _12ec=this.getItemSets()[iwConstants.ATTRIBUTES];
var items={};
var _12ee={};
if(_12ec){
for(itemName in _12ec){
items[itemName]=_12ec[itemName].defaultValue;
if(_12ec[itemName].localizedValues){
_12ee[itemName]={};
for(locale in _12ec[itemName].localizedValues){
_12ee[itemName][locale]=_12ec[itemName].localizedValues[locale];
}
}
}
}
this.attributeProperties=new com.ibm.mm.iwidget.widget.ModifiablePropertiesImpl(items,_12ee);
}
return this.attributeProperties;
},getIDescriptorItems:function(){
if(!this.idescriptorProperties){
var _12ef=this.getItemSets()[iwConstants.IDESCRIPTOR];
var items={};
var _12f1={};
if(_12ef){
for(itemName in _12ef){
items[itemName]=_12ef[itemName].defaultValue;
if(_12ef[itemName].localizedValues){
_12f1[itemName]={};
for(locale in _12ef[itemName].localizedValues){
_12f1[itemName][locale]=_12ef[itemName].localizedValues[locale];
}
}
}
}
this.idescriptorProperties=new com.ibm.mm.iwidget.widget.ModifiablePropertiesImpl(items,_12f1);
}
return this.idescriptorProperties;
},_getItemSets:function(){
if(this.itemSets){
return this.itemSets;
}
this.loadItemSets();
return this.itemSets;
},getItemSets:function(){
return this._getItemSets();
},loadItemSets:function(){
delete this.itemSets;
this.itemSets={};
var _12f2=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.ns+"ItemSet",this.rootElement,_12f2,true);
if(_12f2.length>0){
for(var i=0;i<_12f2.length;i++){
var elem=_12f2[i];
var _12f5=elem.getAttribute("title");
if(typeof (_12f5)!="undefined"){
aItemSet=this.itemSets[_12f5];
if(typeof aItemSet=="undefined"||aItemSet===null){
this.itemSets[_12f5]={};
}
var _12f6=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.ns+"Item",elem,_12f6,true);
if(_12f6.length!=0){
for(var j=0;j<_12f6.length;j++){
var elem1=_12f6[j];
var _12f9=this._loadLocalizedItem(elem1);
var _12fa=_12f9.itemName;
this.itemSets[_12f5][_12fa]=_12f9;
}
}
}
}
}
},_invalidateItemSets:function(name){
if(typeof itemSetName=="undefined"||itemSetName===null){
this.itemSets={};
}else{
this.itemSets[name]={};
}
},_loadLocalizedItem:function(elem1){
var item={};
var _12fe=elem1.getAttribute("href");
var index=_12fe.indexOf("#");
if(index!=-1){
_12fe=_12fe.substring(index+1);
}
item.itemName=_12fe;
var lang=elem1.getAttribute("lang");
if(typeof lang=="undefined"){
lang=null;
}
if(lang!=null){
item.defaultLang=lang;
}
item.defaultValue=null;
var _1301=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.ns+"Value",elem1,_1301,true);
if(_1301.length!=0){
item.localizedValues=[];
var _1302=null;
for(var j=0;j<_1301.length;j++){
var elem2=_1301[j];
var _1305=elem2.getAttribute("lang");
var _1306=com.ibm.mm.enabler.dom.textContent(elem2);
item.localizedValues[_1305]=_1306;
if("en"===_1305){
item.defaultValue=_1306;
}
if(_1302==null){
_1302=_1306;
}
}
if(item.defaultValue==null){
item.defaultValue=_1302;
}
}
if(item.defaultValue==null){
var _1307=elem1.innerHTML;
if(typeof _1307!="undefined"||_1307!=null){
item.defaultValue=_1307;
}
}
com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.iWidgetInstanceStandard._loadLocalizedItem","item:"+item);
return item;
},_getInstanceMarkup:function(){
var node=dojo.clone(this.rootElement);
dojo.query("."+this.ns+"Content",node).forEach(function(_1309){
com.ibm.mm.enabler.dom.destroyNode(_1309);
});
dojo.query("."+this.ns+"loading",node).forEach(function(_130a){
com.ibm.mm.enabler.dom.destroyNode(_130a);
});
var _130b=document.createElement("div");
_130b.appendChild(node);
var html=_130b.innerHTML;
return html;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.model.eventmodel"]){
dojo._hasResource["com.ibm.mm.iwidget.model.eventmodel"]=true;
dojo.provide("com.ibm.mm.iwidget.model.eventmodel");
dojo.declare("com.ibm.mm.iwidget.model.EventModelImpl",null,{constructor:function(obj,_130e){
this.wrapper=_130e;
this.eventDescriptionPool=obj;
},_PredefinedFields:{name:"name",type:"type",lang:"lang",isPublished:"isPublished",isHandled:"isHandled",handlingFn:"handlingFn"},find:function(id){
var event=this.eventDescriptionPool[id];
if(typeof (event)!="undefined"&&event!=null){
return event;
}
if(this.wrapper.handledEvents&&this.wrapper.handledEvents!=null){
if(this.wrapper.handledEvents[id]&&this.wrapper.handledEvents[id]!=null){
return this.wrapper.handledEvents[id][0];
}
}
if(this.wrapper.publishedEvents&&this.wrapper.publishedEvents!=null){
if(this.wrapper.publishedEvents[id]&&this.wrapper.publishedEvents[id]!=null){
return this.wrapper.publishedEvents[id][0];
}
}
return null;
},eventExists:function(_1311){
var temp=this.eventDescriptionPool[_1311];
if(typeof temp!="undefined"&&temp!=null){
return true;
}else{
return false;
}
},_getEventDescObj:function(_1313){
var obj=_1313;
var _1315=_1313.declaredClass;
if(typeof _1315=="undefined"||_1315==null){
obj=new com.ibm.mm.iwidget.iEventDescriptionImpl(_1313);
}
return obj;
},createEvent:function(_1316){
var _1317=this._getEventDescObj(_1316);
var _1318=this.eventExists(_1317.name);
if(_1318){
return false;
}else{
this.eventDescriptionPool[_1317.name]=_1317;
return true;
}
},removeEvent:function(_1319){
var _131a=this.eventExists(_1319);
if(_131a){
delete this.eventDescriptionPool[_1319];
return true;
}else{
return true;
}
},updateEvent:function(_131b){
var _131c=this._getEventDescObj(_131b);
var _131d=this.eventExists(_131c.name);
if(_131d){
this.eventDescriptionPool[_131c.name]=_131c;
}else{
return false;
}
},getEvents:function(_131e){
if(typeof _131e=="undefined"||_131e==null){
return this._getEventsInArray(this.eventDescriptionPool);
}
var array=[];
if(_131e.isHandled&&_131e.isHandled=="true"){
if(this.wrapper.handledEvents){
this._addEvents(array,this.wrapper.handledEvents);
}
}
if(_131e.isPublished&&_131e.isPublished=="true"){
if(this.wrapper.publishedEvents){
this._addEvents(array,this.wrapper.publishedEvents);
}
}
if(dojo.isString(_131e)){
try{
_131e=dojo.fromJson(_131e);
}
catch(e){
return null;
}
}
for(var j in this.eventDescriptionPool){
var _1321=this.eventDescriptionPool[j];
var rc=this._checkMatch(_1321._getInternalJsonObj(),_131e);
if(rc){
array.push(_1321);
}
}
if(array.length==0){
return null;
}else{
return array;
}
},_getEventsInArray:function(arr){
var _1324=[];
for(var j in arr){
_1324.push(arr[j]);
}
if(_1324.length==0){
return null;
}else{
return _1324;
}
},_checkBoolean:function(str,name,value){
var rc=false;
var temp="\""+name+"\""+":"+value;
if(str.indexOf(temp)!=-1){
return true;
}
temp="\""+name+"\""+":\""+value+"\"";
if(str.indexOf(temp)!=-1){
return true;
}
return false;
},_checkMatch:function(_132b,_132c){
var rc=true;
var _132e=[];
for(var i in _132c){
if(_132c[i]==null){
continue;
}
if(typeof (this._PredefinedFields[i])!="undefined"){
if(i==this._PredefinedFields.isPublished&&(_132c[i]==true||_132c[i]=="true")){
if(!this._checkBoolean(dojo.toJson(_132b),i,"true")){
rc=false;
break;
}
}else{
if(i==this._PredefinedFields.isPublished&&(_132c[i]=="false"||_132c[i]==false)){
if(!this._checkBoolean(dojo.toJson(_132b),i,"false")){
rc=false;
break;
}
}else{
if(i==this._PredefinedFields.isHandled&&(_132c[i]==true||_132c[i]=="true")){
if(!_132b[this._PredefinedFields.handlingFn]||(_132b[this._PredefinedFields.handlingFn]&&_132b[this._PredefinedFields.handlingFn]==null)){
rc=false;
break;
}
}else{
if(i==this._PredefinedFields.isHandled&&(_132c[i]=="false"||_132c[i]==false)){
if(_132b[this._PredefinedFields.handlingFn]&&(_132b[this._PredefinedFields.handlingFn]!=null)){
rc=false;
break;
}
}else{
if(!(_132b[i]&&_132b[i]!=null&&_132b[i]==_132c[i])){
rc=false;
break;
}
}
}
}
}
}else{
if(!(_132b.attributes&&_132b.attributes[i]&&_132b.attributes[i]==_132c[i])){
rc=false;
break;
}
}
}
return rc;
},_addEvents:function(arr,_1331){
for(var i in _1331){
var _1333=_1331[i];
for(var j in _1333){
arr.push(_1333[j]);
}
}
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapper"]){
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapper"]=true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetwrapper");
dojo.declare("com.ibm.mm.iwidget.widget.IWidgetWrapperDefaultImpl",com.ibm.mashups.iwidget.widget.IWidgetWrapper,{constructor:function(_1335,id){
this._internalIbmModes=com.ibm.mm.iwidget.itemset._internalIbmModes;
this.rootElement=_1335;
if(typeof (id)!="undefined"&&id!=null){
this.id=id;
}else{
this.id=_1335.getAttribute("id");
}
this.hubId=this.id;
this.simpleWidgetEvents={};
this.loaded=false;
this.widgetAttributes=null;
this.widgetItemSets=null;
this.ns=_1335.className.substr(0,3);
this.windowManager={};
this.iwMessages=dojo.i18n.getLocalization("com.ibm.mm.enabler","iwMessages");
this.eventSvr=com.ibm.mashups.services.ServiceManager.getService("eventService");
this._jsHandler=com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER;
this.eventHandlers=[];
this.publishedEvents={};
this.handledEvents={};
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},getID:function(){
return this.id;
},getIWidgetInstance:function(){
if(typeof this.widgetInstance!="undefined"||this.widgetInstance!=null){
return this.widgetInstance;
}
this.widgetInstance=new com.ibm.mm.iwidget.widget.IWidgetInstanceImpl(this.rootElement,this.id);
return this.widgetInstance;
},setIWidgetDefinition:function(_1337){
this.widgetDef=_1337;
},getIWidgetDefinition:function(){
if(this.loaded){
return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id,this.widgetDef);
}else{
return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id);
}
},getMarkup:function(){
return new com.ibm.mm.iwidget.DeferredLiveTextUnprocessImpl(this);
},doRender:function(){
try{
this.prepare();
this.execute();
}
catch(e){
com.ibm.mm.enabler.debug.error("IWidgetWrapper.doRender","widget:"+this.hubId+" OnloadingException:"+e);
}
},prepare:function(){
variableName="_"+this.id+"_"+"iContext";
if(this.isModal()==false){
dojo.global[variableName]=new com.ibm.mm.iwidget.iContextImpl(this,this.ns);
}else{
var _1338=this.id;
if(dojo.isIE){
_1338="iframe_"+this.id;
}
var _1339=parent[_1338][variableName];
dojo.global[variableName]=_1339;
}
var _133a=this.eventSvr._subscribeEvent(this.eventSvr.WIDGETEVENT_PREFIX+this.hubId,this,"handleEvent",null,this.hubId);
if(this._inIframe()==false){
this.eventHandlers.push(_133a);
}
},execute:function(){
this._initialize();
this._doRender();
},_updateMarkup:function(mode,_133c){
var wInfo=this.widgetDef;
var _133e=wInfo.getMarkupByMode(mode);
if(mode==iwConstants.mode_view){
if(this.widgetDef.getAllowInstanceContent()){
var temp=this.getIWidgetInstance().getDefaultViewContent();
if(temp&&temp!==null){
_133e=temp;
}
}
}
if(typeof _133e=="undefined"||_133e===null){
var error=dojo.string.substitute(this.iwMessages.E_IWIDGETDEF_CONTENTNOTAVAILABLE_1,[mode]);
com.ibm.mm.enabler.debug.info("iWidget._updateMarkup",error);
return false;
}
var _1341=this._prepareMarkup(_133e);
_1341=_1341.replace(/^\s+|\s+$/,"");
if(_1341.indexOf("<script")==0){
_1341="&nbsp;"+_1341;
}
var _1342=document.createElement("DIV");
_1342.innerHTML=_1341;
var _1343=_1342.getElementsByTagName("script");
if(_1343!==null){
for(var i=0;i<_1343.length;i++){
var _1345=_1343[i];
var id=_1345.getAttribute("id");
if(id===null||id==""){
_1345.setAttribute("id","_scr#"+i);
}
}
}
_133c.innerHTML=_1342.innerHTML;
com.ibm.mm.enabler.dom.destroyNode(_1342);
return true;
},_prepareMarkup:function(_1347){
var _1348=_1347.replace(/_IWID_/g,"_"+this.id+"_");
var _1349=_1348.replace(/iContext(?=\.|\s|\(|\))/g,"_"+this.id+"_iContext");
return _1349;
},destroy:function(){
if(this.loaded&&this.isModal()==false){
this._handleEventInternal(com.ibm.mm.iwidget.iEvents.Constants.onUnLoad);
}
if(this._inIframe()==false){
var _134a=this.getIWidgetInstance().getWireModel();
if(_134a&&_134a!=null){
var _134b=_134a.getTargets();
}
if(_134b&&_134b!=null){
var _134c=com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
for(var i in _134b){
var _134e=_134c.find(i);
if(_134e&&_134e!=null){
var wires=_134e.getIWidgetInstance().getWireModel();
wires.removeWire(this.id);
_134e.commit();
}
}
}
for(var i in this.eventHandlers){
this.eventSvr._unsubscribeEvent(this.eventHandlers[i],this.hubId);
}
this.eventSvr._getHubAdapter(this.hubId).removeInlineHubClient(this.hubId);
if(dojo.global["_"+this.id+"_"+"iContext"]&&dojo.global["_"+this.id+"_"+"iContext"]!=null){
dojo.global["_"+this.id+"_"+"iContext"]=null;
}
}else{
if(this.isModal()==false){
this.eventSvr.disconnectHubClient();
if(dojo.global["_"+this.id+"_"+"iContext"]&&dojo.global["_"+this.id+"_"+"iContext"]!=null){
dojo.global["_"+this.id+"_"+"iContext"]=null;
}
}
}
if(this.rootElement){
this.rootElement=null;
}
if(this.windowManager){
this.windowManager=null;
}
},update2:function(_1350){
this.rootElement=_1350;
var aMode=this._getDefaultMode();
this.currentMode=(aMode==null)?iwConstants.mode_view:aMode;
this._getPublicEvents();
this.getIWidgetInstance()._updateWires();
this.getIWidgetInstance().itemSets=null;
},_doRender:function(){
var _1352=document.createElement("div");
_1352.className=this.ns+"Content";
this.rootElement.appendChild(_1352);
var _1353=this.rootElement.lastChild;
dojo.addClass(_1353,this.currentMode);
_1353.style.visibility="hidden";
if(this._inIframe()==true){
dojo.style(_1353,"height","100%");
}
var _1354=this.widgetDef.getIDescriptorItems();
var _1355=_1354.getItemValue(iwConstants.iDescriptorItems.mode);
if(this.isModal()&&this.currentMode!=_1355){
var _1356=document.createElement("div");
_1356.className=this.ns+"Content";
this.rootElement.appendChild(_1356);
contentDiv1=this.rootElement.lastChild;
dojo.addClass(contentDiv1,_1355);
contentDiv1.style.visibility="hidden";
contentDiv1.style.display="none";
this._updateMarkup(_1355,contentDiv1);
}
this._updateMarkup(this.currentMode,_1353);
this._loadWidgetSharedResource(dojo.partial(this._finishRender,_1353,this));
},_finishRender:function(_1357,_1358){
var _1359=_1358.eventSvr._subscribeEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+"."+_1358.id,_1358,"handleSizeChanged",null,_1358.id);
_1358.eventHandlers.push(_1359);
_1358._createiScope();
_1358._evalScripts(_1357);
_1358.windowManager[_1358.currentMode]={id:_1358.currentMode,root:_1357,active:true,external:false};
_1358.onLoad();
_1358.eventSvr._handleBroadcastEventsCache();
if(typeof _1358._eventqueue!="undefined"&&_1358._eventqueue!=null){
for(var event in _1358._eventqueue){
_1358.handleEvent(_1358._eventqueue[event]);
}
}
dojo.query("."+_1358.ns+"loading",_1358.rootElement).forEach(function(elem){
com.ibm.mm.enabler.dom.destroyNode(elem);
});
dojo.query("."+_1358.currentMode,_1358.rootElement).style({"visibility":""});
},_initialize:function(){
var lang=this.widgetDef.getDefaultLanguage();
if(typeof lang!="undefined"&&lang!=null){
this.defaultLanguage=lang;
}else{
this.defaultLanguage="en";
}
var aMode=this._getDefaultMode();
if(aMode==null){
aMode=iwConstants.mode_view;
}
this.currentMode=aMode;
this._getPublicEvents();
this.getWires();
},_evalScripts:function(_135e){
var _135f=_135e.getElementsByTagName("script");
for(var i=0;i<_135f.length;i++){
this._jsHandler.handle(_135f[i]);
}
},onLoad:function(){
if(this.isModal()==false){
this._handleEventInternal(com.ibm.mm.iwidget.iEvents.Constants.onLoad);
}
this.updateState();
this._handleEventInternal("on"+this.currentMode);
this.loaded=true;
try{
dojo.publish(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+this.id,[this.id]);
}
catch(e){
console.log("!!!!!!Exception:"+e);
}
this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+this.hubId,this.hubId);
},_getSimpleEventHandler:function(_1361){
if(this.simpleWidgetEvents&&this.simpleWidgetEvents[_1361]){
return this.simpleWidgetEvents[_1361];
}
var _1362=this.widgetDef.getWidgetEvents()[_1361];
if(_1362==null){
_1362=_1361;
}
var scope=this._getHandlerScope(_1362);
var _1364=null;
if(scope!=null){
_1364=dojo.hitch(scope,_1362);
this.simpleWidgetEvents[_1361]=_1364;
}else{
if(_1362.indexOf("on")==0){
var _1365="on"+_1362.substr(2,1).toUpperCase()+_1362.substr(3);
if(_1365!=_1362){
scope=this._getHandlerScope(_1365);
if(scope!=null){
_1364=dojo.hitch(scope,_1365);
this.simpleWidgetEvents[_1361]=_1364;
}
}
}
}
return _1364;
},_getHandlerScope:function(_1366){
var fn=dojo.global["_"+this.id+"_"+_1366];
if(typeof (fn)=="undefined"){
widgetScope=dojo.global["_"+this.id+"_iContext"].iScope();
if(widgetScope&&widgetScope[_1366]){
fn=widgetScope;
}
}
if(typeof fn=="undefined"||fn==null){
fn=dojo.global[_1366];
}
if(typeof fn=="undefined"||fn==null){
return null;
}else{
return fn;
}
},handleEvent:function(_1368){
var _1369=_1368.declaredClass;
if(typeof _1369!="undefined"&&_1369!=null&&_1369=="com.ibm.mm.iwidget.iEventImpl"){
var _136a=_1368.name;
return this._handleEvent(_136a,_1368);
}
var scope=_1368.scope;
if(typeof scope!="undefined"&&scope!=null){
if(scope=="instance"){
scope=this.getIWidgetInstance();
}else{
if(scope=="eventmodel"){
scope=this._getPublicEvents();
}
}
}else{
scope=this;
}
var _136c=_1368.methodname;
if(typeof _136c!="undefined"&&_136c!=null){
if(scope[_136c]&&dojo.isFunction(scope[_136c])){
scope[_136c].apply(scope,_1368.params);
}
}
},_handleEvent:function(_136d,_136e){
_136e=this._deserializePayload(_136e);
if(typeof _136d=="undefined"||_136d==null){
return false;
}
if(this.loaded==false){
if(typeof this._eventqueue=="undefined"||this._eventqueue==null){
this._eventqueue={};
}
this._eventqueue[_136d]=_136e;
return;
}
try{
if(_136d==iwConstants.EVENTS.onNavStateChanged){
return this._handleOnNavStateChanged(_136e);
}
if(_136d==iwConstants.EVENTS.onModeChanged){
if(this._inIframe()==true){
var _136f={};
_136f.methodname="_handleOnModeChange";
_136f.hubclient=this.hubId;
_136f.params=[_136e.payload];
var id="_stub_"+this.id;
this.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX+id,_136f,this.hubId);
return;
}
return this._handleModeChange(_136e);
}
if(_136d=="onNewWire"){
return this._handleNewWire(_136e);
}
if(_136d=="onRemoveWire"){
return this._handleRemoveWire(_136e);
}
return this._handleEventInternal(_136d,_136e);
}
catch(e){
com.ibm.mm.enabler.debug.error("IWidgetWrapper.handleEvent","widget:"+this.hubId+"eventName:"+_136d+" HandleEventException:"+e);
}
},_deserializePayload:function(_1371){
if(typeof _1371.payload=="string"&&_1371.payload.indexOf("className")!=-1&&_1371.payload.indexOf("json")!=-1){
try{
var _1372=dojo.fromJson(_1371.payload);
if(_1372.className&&typeof _1372.className=="string"&&_1372.className.length>0&&_1372.json&&typeof _1372.json=="string"){
_1371.payload=eval("new "+_1372.className+"("+_1372.json+");");
}
}
catch(e){
}
}
return _1371;
},_handleNewWire:function(_1373){
var _1374=_1373.payload;
var _1375=this.getIWidgetInstance().getWireModel();
_1375.registerTargets(_1374.targetWidget,_1374.targetEvent,_1374.sourceEvent);
this.commit();
var _1376=_1374.sourceEvent;
var _1377=this._getPublicEvents();
if(_1377==null){
return false;
}
var _1378=_1377.find(_1376);
if(typeof _1378!="undefined"&&_1378!=null){
var _1379=_1378.getOnNewWire();
if(_1379!=null){
var scope=this._getHandlerScope(_1379);
if(scope!=null&&dojo.isFunction(scope)){
scope(_1373);
}else{
if(scope!=null&&dojo.isObject(scope)){
scope[_1379](_1373);
}
}
return true;
}
}
return false;
},_handleRemoveWire:function(_137b){
var _137c=_137b.payload;
var _137d=_137c.targetEvent;
if(this.id==_137c.sourceWidget){
_137d=_137c.sourceEvent;
}
var _137e=this._getPublicEvents();
if(_137e==null){
return false;
}
var _137f=_137e.find(_137d);
if(typeof _137f!="undefined"&&_137f!=null){
var _1380=_137f.getOnRemoveWire();
if(_1380!=null){
var scope=this._getHandlerScope(_1380);
if(scope!=null&&dojo.isFunction(scope)){
scope(_137b);
}else{
if(scope!=null&&dojo.isObject(scope)){
scope[_1380](_137b);
}
}
return true;
}
}
return false;
},_handleOnModeChange:function(_1382){
var _1383=new com.ibm.mm.iwidget.iEventImpl("onModeChanged",null,{newMode:_1382},null);
this._handleModeChange(_1383);
},_handleModeChange:function(_1384){
var _1385=false;
var _1386=this.currentMode;
var _1387=_1384.payload;
if(typeof _1387=="undefined"||_1387==null){
return false;
}
if(dojo.isString(_1387)){
_1387=dojo.fromJson(_1387);
}
if(typeof _1387=="undefined"||_1387==null){
return false;
}
var _1388=_1387.newMode;
if(typeof _1388=="undefined"){
_1388=null;
}
var _1389=_1387.rootElementId;
if(typeof _1389=="undefined"){
_1389=null;
}
if(_1388!=null&&_1388==this.currentMode){
return false;
}
if(_1388==null){
return false;
}
var _138a=false;
if(_1389!=null){
_138a=true;
}
var _138b=_1389;
var _138c=this._getDefaultMode();
if(!_138c||_138c==null){
_138c="view";
}
if(this._inIframe()==true&&_138c==_1388){
this.currentMode=_1388;
this.windowManager[_1388]={id:_1388,root:_138b,active:true,external:false};
this._handleOnModeEvent(_1388);
return;
}
var _138d=this.windowManager[_1388];
var _138e=false;
if(typeof _138d!="undefined"&&_138d!==null){
var _138f=_138d.root;
if(!_138d.external&&_138f!=null&&_1389===null){
_138b=_138f;
_138e=true;
_1385=true;
dojo.style(_138f,"display","");
}
}
if(!_138e){
if(_138b===null){
var _1390=document.createElement("div");
_1390.className=this.ns+"Content";
this.rootElement.appendChild(_1390);
_138b=this.rootElement.lastChild;
dojo.addClass(_138b,_1388);
}
_1385=this._updateMarkup(_1388,_138b);
}
if(_1385){
var _1391=this.windowManager[this.currentMode];
var _1392=_1391.root;
if(_1391.external){
dojo.style(_1392,"display","none");
this.windowManager[this.currentMode]=null;
}else{
if(_1389!=null){
_1391.active=false;
}else{
_1391.active=false;
dojo.style(_1392,"display","none");
}
}
this.currentMode=_1388;
this.windowManager[_1388]={id:_1388,root:_138b,active:true,external:_138a};
if(!_138e){
this._evalScripts(_138b);
}
this._handleOnModeEvent(_1388);
}
if(_1385&&this._inIframe()==false){
dojo.publish(com.ibm.mm.iwidget.iEvents.Constants.modeChanged,[this.id,_1386,_1388]);
var _1387={};
_1387.id=this.id;
_1387.oldMode=_1386;
_1387.newMode=_1388;
this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED,_1387,this.hubId);
}
if(this._inIframe()==true){
var _1393={};
_1393.methodname="_handleOnModeUpdated";
_1393.hubclient=this.hubId;
_1393.params=[_1384.payload];
var id="_stub_"+this.id;
this.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX+id,_1393,this.hubId);
}
return _1385;
},_handleOnModeUpdated:function(mode){
this.currentMode=mode;
this.windowManager[mode]={id:mode,active:true,external:true};
},_handleOnModeEvent:function(mode){
if(this._inIframe()==true){
dojo.setContext(iWidgetContainer.global,iWidgetContainer.doc);
if(dojo.isIE){
if(document._mmcreateElement&&document._mmcreateElement!=null){
document.createElement=document._mmcreateElement;
}
if(document._mmgetElementsByTagName&&document._mmgetElementsByTagName!=null){
document.getElementsByTagName=document._mmgetElementsByTagName;
}
}
}
var _1397=false;
var _1398="on"+mode;
var _1399=this._getSimpleEventHandler(_1398);
if(_1399!==null){
_1399();
_1397=true;
}
return _1397;
},_handleEventInternal:function(_139a,_139b){
if(typeof _139a=="undefined"||_139a===null){
return false;
}
var _139c=false;
var _139d=null;
if(_139a.indexOf("on")===0){
var _139e=this._getSimpleEventHandler(_139a);
if(_139e!==null){
_139d=_139e;
}
}
if(_139d===null){
_139d=this.getPublicEventHandler(_139a);
}
if(_139d&&_139d!==null){
try{
if(_139b&&_139b!==null){
_139d(_139b);
}else{
_139d();
}
}
catch(e){
com.ibm.mm.enabler.debug.error("IWidgetWrapper._handleEventInternal","widget:"+this.hubId+" eventName:"+_139a+" HandleEventException:"+e);
}
_139c=true;
}
return _139c;
},getPublicEventHandler:function(_139f){
var _13a0=this._getPublicEvents();
if(_13a0==null){
return null;
}
var _13a1=_13a0.find(_139f);
if(!_13a1){
return null;
}
var _13a2=_13a1.handlingFn;
if(_13a2&&_13a2!=null){
var _13a3=null;
if(dojo.isFunction(_13a2)){
_13a3=_13a2;
}else{
var scope=this._getHandlerScope(_13a2);
if(scope!=null){
_13a3=dojo.hitch(scope,_13a2);
}
}
}
return _13a3;
},_getParent:function(){
if(!this.parent){
this.parent=com.ibm.mm.iwidget.utils.getWidgetParent(this.rootElement);
}
if(typeof this.parent=="undefined"||this.parent==null){
this.parent=null;
}
return this.parent;
},_setParent:function(_13a5){
this.parent=_13a5;
},getAttributes:function(){
if(typeof (this.widgetAttributes)=="undefined"||this.widgetAttributes==null){
var _13a6=com.ibm.mashups.services.ServiceManager.getService("persistentAttributesFactoryService");
this.widgetAttributes=_13a6.createPersistentAttributes(this);
this._loadWidgetAttributes();
}
return this.widgetAttributes;
},_loadDefWidgetAttributes:function(){
if(typeof (this.widgetDef)!="undefined"){
var _13a7=this.widgetDef.getAttributes();
if(typeof _13a7!="undefined"&&_13a7!=null){
var _13a8=_13a7.getAllNames();
for(var i=0;i<_13a8.length;i++){
var _13aa=_13a8[i];
var _13ab=_13a7.getItemValue(_13aa);
this.widgetAttributes._internal().setItemValue(_13aa,_13ab,false,this._internalIbmModes.xml);
}
}
}
},_loadWidgetInstanceAttributesFromRootElement:function(){
var _13ac=this.rootElement.attributes;
for(var i=0;i<_13ac.length;i++){
var att=_13ac[i];
var value=this.rootElement.getAttribute(att.name);
if(typeof value!="undefined"&&value!=null&&value!=""){
this.widgetAttributes._internal().setItemValue(att.name,value,false,this._internalIbmModes.microformat);
}
}
},getWidgetItemSet:function(name){
if(typeof (this.widgetItemSets)=="undefined"||this.widgetItemSets==null){
this._loadItemSets();
}
var _13b1=this.widgetItemSets[name];
if(typeof _13b1=="undefined"){
_13b1=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(parent,name);
this.widgetItemSets[name]=_13b1;
}
return _13b1;
},_loadWidgetDefItemSets:function(){
if(typeof (this.widgetDef)!="undefined"){
var names=this.widgetDef.getAllItemSetNames();
for(var i=0;i<names.length;i++){
var name=names[i];
var _13b5=this.widgetDef.getItemSet(name);
var _13b6=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(parent,_13b5.name,_13b5.onItemSetChanged,null,_13b5.isPrivate);
var items=_13b5.items;
for(var j in items){
var _13b9=items[j];
_13b6.setItemValue(_13b9.id,_13b9.value,_13b9.isReadOnly);
}
this.widgetItemSets[name]=_13b6;
}
}
},_loadWidgetSharedResource:function(cb2){
var _13bb=this.widgetDef.getResources();
if(typeof _13bb!="undefined"&&_13bb!=null){
var size=_13bb.length-1;
if(size==-1){
cb2();
}
var _13bd=[];
for(var x in _13bb){
var _13bf=_13bb[x];
var uri=_13bf[iwConstants.RESOURCE.src];
var _13c1=uri.substring(uri.lastIndexOf(".")+1,uri.length);
if((null!==_13c1)&&("css"==_13c1)){
_13bd.unshift(_13bf);
}else{
_13bd.push(_13bf);
}
}
var me=this;
var mycb=function(i,_13c5,data,_13c7){
var self=this;
if(data&&_13c7&&_13c5&&_13c5!="css"){
self.error="true";
if(!self.data){
self.data=[];
}
self.data.push({data:data.message,status:_13c7});
}
if(size==i){
if(self.error&&self.error=="true"){
dojo.query("."+me.ns+"loading",me.rootElement).forEach(function(elem){
elem.innerHTML="";
var _13ca=unescape(me.getIWidgetInstance().getIDescriptorItems().getItemValue("title",dojo.locale));
if(!_13ca){
_13ca=me.widgetXMLUrl;
}
var _13cb="";
for(var j in self.data){
_13cb=_13cb.concat(self.data[j].data).concat("\n");
}
com.ibm.mm.enabler.debug.logInlineMessage(elem,"error",dojo.string.substitute(me.iwMessages.E_WIDGET_DISPLAY_FAIL_2,[_13ca,_13cb]));
});
self.error=null;
self.data=null;
}else{
if(cb2){
cb2();
}
}
}
};
for(var i=0;i<_13bd.length;i++){
var _13bf=_13bd[i];
var name=_13bf[iwConstants.RESOURCE.id];
var uri=_13bf[iwConstants.RESOURCE.src];
var _13cf=_13bf[iwConstants.RESOURCE.mimetype];
var _13d0=_13bf[iwConstants.RESOURCE.callback];
var _13c1=uri.substring(uri.lastIndexOf(".")+1,uri.length);
if(typeof _13cf=="undefined"||_13cf==null){
_13cf="text/plain";
}
if(typeof uri!="undefined"&&uri!=null){
com.ibm.mashups.services.ServiceManager.getService("resourceLoadService").loadResource(this.id,null,uri,_13d0,_13cf,dojo.partial(mycb,i,_13c1));
}
}
}
},_createiScope:function(){
if(this.isModal()==false){
var _13d1=this.widgetDef.getIScope();
var _13d2=null;
if(typeof _13d1!=undefined&&_13d1!=null){
try{
_13d2=eval("new "+_13d1+"();");
}
catch(err){
com.ibm.mm.enabler.debug.log("iWidget._createiScope","iScope"+_13d1,"Error",err);
}
}
if(typeof _13d2=="undefined"||_13d2==null){
_13d2={};
}
this.iScope=_13d2;
dojo.global["_"+this.id+"_iContext"].scope=this.iScope;
}else{
this.iScope=dojo.global["_"+this.id+"_iContext"].scope;
}
this.iScope.iContext=dojo.global["_"+this.id+"_iContext"];
},getIDescriptorItems:function(){
if(this.iDescriptor){
return this.iDescriptor;
}
this.iDescriptor=new com.ibm.mm.iwidget.itemset.iDescriptor(this.id,this.widgetDef.getIDescriptorItems(),this.getIWidgetInstance().getIDescriptorItems());
return this.iDescriptor;
},_getPublicEvents:function(){
if(!this.publicEvents){
var _13d3=this.widgetDef._getPublicEvents();
var _13d4={};
for(var i in _13d3){
_13d4[i]=_13d3[i];
}
this.publicEvents=new com.ibm.mm.iwidget.model.EventModelImpl(_13d4,this);
}
return this.publicEvents;
},_getPublishedEvents:function(){
var _13d6=this.getWidgetPublishedEvents();
var arr={};
if(_13d6!=null){
var i=0;
for(i;i<_13d6.length;i++){
arr[_13d6[i].name]=_13d6[i];
}
}
return arr;
},_getHandledEvents:function(){
var _13d9=this.getWidgetHandledEvents();
var arr={};
if(_13d9!=null){
var i=0;
for(i;i<_13d9.length;i++){
arr[_13d9[i].name]=_13d9[i];
}
}
return arr;
},getWidgetPublishedEvents:function(){
var _13dc=this._getPublicEvents();
if(_13dc&&_13dc!=null){
var _13dd={};
_13dd["isPublished"]="true";
return _13dc.getEvents(_13dd);
}
return null;
},getWidgetHandledEvents:function(){
var _13de=this._getPublicEvents();
if(_13de&&_13de!=null){
var _13df={};
_13df["isHandled"]="true";
return _13de.getEvents(_13df);
}
return null;
},getPublishedEvents:function(){
if(!this.publishedEvents){
this.publishedEvents={};
}
return this.publishedEvents;
},getHandledEvents:function(){
if(!this.handledEvents){
this.handledEvents={};
}
return this.handledEvents;
},_loadWidgetAttributes:function(){
this._loadDefWidgetAttributes();
var _13e0=this.getIWidgetInstance().getAttributes();
if(_13e0){
var names=_13e0.getAllNames();
for(var i=0;i<names.length;i++){
var name=names[i];
var value=_13e0.getItemValue(name);
value=value.replace(/&lt;/gi,"<");
value=value.replace(/&gt;/gi,">");
value=value.replace(/&amp;/gi,"&");
this.widgetAttributes._internal().setItemValue(name,value,false,this._internalIbmModes.microformat);
}
}
},_loadItemSets:function(){
this.widgetItemSets={};
this._loadWidgetDefItemSets();
var _13e5=this.getIWidgetInstance()._getItemSets();
if(_13e5!=null){
for(var i in _13e5){
if(i==iwConstants.ATTRIBUTES||i==iwConstants.USERPROFILE||i==iwConstants.IDESCRIPTOR){
continue;
}
var _13e7=_13e5[i];
var _13e8=this.widgetItemSets[i];
if(typeof _13e8=="undefined"||_13e8==null){
_13e8=new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(this,i);
this.widgetItemSets[i]=_13e8;
}
for(var j in _13e7){
var _13ea=j;
var _13eb=_13e7[_13ea]["defaultValue"];
this.widgetItemSets[i].setItemValue(_13ea,_13eb,false);
}
}
}
},_getDefaultMode:function(){
var _13ec=this.getIWidgetInstance().getIDescriptorItems();
if(typeof _13ec!="undefined"&&_13ec!=null){
var _13ed=_13ec.getItemValue(iwConstants.iDescriptorItems.mode);
if(typeof _13ed!="undefined"||_13ed!=null){
return _13ed;
}
}
var _13ee=this.widgetDef.getIDescriptorItems();
var _13ef=null;
if(typeof _13ee!="undefined"&&_13ee!=null){
_13ef=_13ee.getItemValue(iwConstants.iDescriptorItems.mode);
if(typeof _13ef=="undefined"){
_13ef=null;
}
}
return _13ef;
},getWires:function(){
return this.getIWidgetInstance().getWires();
},_getMarkup:function(_13f0){
var that=this;
function cb(node,_13f3){
that.eventSvr._publishEvent(that.eventSvr.WIDGETEVENT_PREFIX+that.id+".onMarkupReturned",node);
};
var _13f4=this.getMarkup();
_13f4.setIncludeParent(_13f0);
_13f4.setFinishedCallback(cb);
_13f4.start();
},_inIframe:function(){
if(this._isInIframe){
return this._isInIframe;
}
var _13f5=true;
if(this.eventSvr.declaredClass=="com.ibm.mm.iwidget.services.EventServiceImpl"){
_13f5=false;
}
this._isInIframe=_13f5;
return this._isInIframe;
},commit:function(_13f6){
var _13f7=this.getIWidgetInstance();
if(this._inIframe()==true&&(!(_13f6&&_13f6==true))){
var _13f8={};
var _13f9=_13f7.getAttributes();
if(_13f9&&_13f9._isDirty()){
_13f8.attributes=dojo.clone(_13f9);
}
var _13fa=_13f7.getWireModel();
if(_13fa&&_13fa!=null&&_13fa.isDirty()){
_13f8.wiremodel=_13fa.toJson();
}
var _13fb={};
_13fb.methodname="_handleDataSync";
_13fb.hubclient=this.hubId;
_13fb.params=[_13f8];
var id="_stub_"+this.id;
this.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX+id,_13fb,this.hubId);
return;
}
var _13f9=_13f7.getAttributes();
if(_13f9&&_13f9._isDirty()){
this._writePropertiesToDOM(this,"attributes",_13f9);
_13f9._setDirty(false);
}
var _13fd=_13f7.getIDescriptorItems();
if(_13fd&&_13fd._isDirty()){
this._writePropertiesToDOM(this,"idescriptor",_13fd);
_13fd._setDirty(false);
}
var _13fe=_13f7.getWireModel();
if(_13fe&&_13fe.isDirty()){
_13fe.commit();
}
},_writePropertiesToDOM:function(_13ff,_1400,_1401){
var i;
var ns=_13ff.ns;
var root=_13ff.rootElement;
var _1405=dojo.query("span."+ns+"ItemSet[title=\""+_1400+"\"]",root);
for(i=0;i<_1405.length;i++){
var _1406=_1405[i];
if(root==_1406.parentNode){
root.removeChild(_1406);
}
}
var _1407=document.createElement("span");
_1407.className=ns+"ItemSet";
_1407.title=_1400;
_1407.style.display="none";
_1407.style.visibility="hidden";
root.appendChild(_1407);
var names=_1401.getAllNames();
if(!names){
return;
}
for(i=0;i<names.length;i++){
var _1409=names[i];
var _140a=_1401._getItemValue3(_1409);
var _140b=document.createElement("a");
_140b.className=ns+"Item";
_140b.style.visibility="hidden";
_140b.style.display="none";
_140b.href="#"+_1409;
_140b.appendChild(document.createTextNode(_140a));
var _140c=_1401.getItemLocales(_1409);
for(locale in _140c){
var _140d=document.createElement("span");
_140d.setAttribute("class",ns+"Value");
_140d.setAttribute("lang",locale);
var _140e=_1401._getItemValue3(_1409,locale);
_140d.appendChild(document.createTextNode(_140e));
_140b.appendChild(_140d);
}
_1407.appendChild(_140b);
}
},getPublicEvent:function(name){
var _1410=this._getPublicEvents();
return _1410.find(name);
},setModal:function(_1411){
this._isModal=_1411;
},isModal:function(){
return this._isModal?this._isModal:false;
},_handleDataSync:function(_1412){
if(typeof _1412.attributes!="undefined"&&_1412.attributes!=null){
var _1413=_1412.attributes;
this._syncModifiableProperties(_1413,this.getIWidgetInstance().getAttributes());
}
if(typeof _1412.idescriptors!="undefined"&&_1412.idescriptors!=null){
var _1414=_1412.idescriptors;
this._syncModifiableProperties(_1414,this.getIWidgetInstance().getIDescriptorItems());
}
if(typeof _1412.wiremodel!="undefined"&&_1412.wiremodel!=null){
var _1415=_1412.wiremodel;
this._syncWireModel(_1415,this.getIWidgetInstance().getWireModel());
}
this.commit(true);
},_syncModifiableProperties:function(_1416,_1417){
var items=_1416._items;
for(var i in items){
var name=i;
var value=items[i];
if(typeof value!="undefined"&&value!=null&&value==_1417.DELETE_TOKEN){
_1417.removeItem(name);
}else{
_1417.setItemValue(name,value);
}
}
},_syncWireModel:function(_141c,_141d){
var wires=_141c._wires;
for(var i in wires){
var aWire=wires[i];
if(aWire._isDirty&&aWire._type!=null&&aWire._type=="NEW"){
_141d.addWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
}else{
if(aWire._isDirty&&aWire._type!=null&&aWire._type=="DELETE"){
_141d.removeWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
}
}
}
var _1421=_141c._targets;
_141d._targets=_1421;
},isLoaded:function(){
return this.loaded;
},handleSizeChanged:function(_1422){
if(_1422.newWidth&&_1422.newWidth!=null){
this.width=_1422.newWidth;
}
if(_1422.newHeight&&_1422.newHeight!=null){
this.height=_1422.newHeight;
}
var _1423=new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onSizeChanged,null,_1422,null);
this._handleEvent(iwConstants.EVENTS.onSizeChanged,_1423);
},setStateData:function(_1424){
this.stateData=_1424;
},updateState:function(){
if(this._inIframe()==false){
var _1425=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
var _1426=com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(_1425,this.id);
if(_1426!=null){
var _1427=_1426.getWidgetState("cp");
if(_1427&&_1427!=null){
var _1428=new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onNavStateChanged,"json",_1427);
this._handleEventInternal(iwConstants.EVENTS.onNavStateChanged,_1428);
}
}
}else{
if(this.stateData&&this.stateData!=null){
var _1428=new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onNavStateChanged,null,this.stateData);
this._handleEventInternal(iwConstants.EVENTS.onNavStateChanged,_1428);
}
}
},_isEmpty:function(_1429){
for(var i in _1429){
return false;
}
return true;
},_handleOnNavStateChanged:function(_142b){
if(this._inIframe()==false){
var state=_142b.payload;
if(state&&state!=null){
var _142d=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
var _142e=com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(_142d,this.id);
_142e.setWidgetState("cp",state);
var _142f=_142d.commit();
_142f.start();
}
}else{
var _1430={};
_1430.methodname="_handleOnNavStateChanged";
_1430.params=[_142b];
this.eventSvr._publishEvent(this.eventSvr.WIDGETEVENT_PREFIX+"_stub_"+this.id,_1430);
}
}});
}
if(!dojo._hasResource["com.ibm.mashups.iwidget.constants"]){
dojo._hasResource["com.ibm.mashups.iwidget.constants"]=true;
dojo.provide("com.ibm.mashups.iwidget.constants");
dojo.declare("com.ibm.mashups.iwidget.Constants",null,{WIDGET_LOADED:"com.ibm.mashups.iwidget.widgetloaded",RESIZE_WIDGET:"com.ibm.mashups.iwidget.resizewidget",UNLOAD_WIDGETS:"com.ibm.mashups.iwidget.unloadwidgets",WIDGETS_UNLOADED:"com.ibm.mashups.iwidget.widgetsunloaded",WIDGET_MODECHANGED:"com.ibm.mashups.iwidget.widgetmodechanged"});
com.ibm.mashups.iwidget.Constants=new com.ibm.mashups.iwidget.Constants();
}
if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapperstub"]){
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapperstub"]=true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetwrapperstub");
dojo.declare("com.ibm.mm.iwidget.widget.IWidgetWrapperStubImpl",com.ibm.mashups.iwidget.widget.IWidgetWrapper,{PREFIX_STUB:"_stub_",getID:function(){
return this.id;
},getIWidgetInstance:function(){
if(typeof this.widgetInstance!="undefined"||this.widgetInstance!=null){
return this.widgetInstance;
}
this.widgetInstance=new com.ibm.mm.iwidget.widget.IWidgetInstanceImpl(this.rootElement,this.id);
return this.widgetInstance;
},setIWidgetDefinition:function(_1431){
this.widgetDef=_1431;
},getIWidgetDefinition:function(){
if(this.loaded){
return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id,this.widgetDef);
}else{
return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id);
}
},getMarkup:function(){
return new com.ibm.mm.iwidget.DeferredLiveTextUnprocessStubImpl(this);
},doRender:function(){
try{
this.subHandler={};
this.eventSvr=com.ibm.mashups.services.ServiceManager.getService("eventService");
var _1432=this.eventSvr.subscribeEvent(this.eventSvr.WIDGETEVENT_PREFIX+this.PREFIX_STUB+this.id,this,"handleEvent");
this.subHandler[this.PREFIX_STUB+this.id]=[];
this.subHandler[this.PREFIX_STUB+this.id].push(_1432);
var _1433=this._getInstanceMarkup();
var aMode=this._getDefaultMode();
if(aMode==null){
aMode=iwConstants.mode_view;
}
this.currentMode=aMode;
var _1435=document.createElement("div");
_1435.className=this.ns+"Content";
this.rootElement.appendChild(_1435);
var _1436=this.rootElement.lastChild;
dojo.addClass(_1436,this.currentMode);
_1436.visibility="hidden";
this.windowManager[this.currentMode]={id:this.id,root:_1436,active:true,main:true};
var _1437=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
var _1438=com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(_1437,this.id);
if(_1438!=null){
var _1439=_1438.getWidgetState("cp");
}
this._createIframe(_1433,_1436,this.id,"false",this,_1439);
}
catch(e){
com.ibm.mm.enabler.debug.error("IWidgetWrapper.doRender","widget:"+this.id+" Creating iframe Exception:"+e);
}
},destroy:function(){
this.eventSvr._getHubAdapter(this.id).returnSubDomain(this._getSubDomain());
var _143a=this.getIWidgetInstance().getWireModel();
if(_143a&&_143a!=null){
var _143b=_143a.getTargets();
}
if(_143b&&_143b!=null){
var _143c=com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
for(var i in _143b){
var _143e=_143c.find(i);
if(_143e&&_143e!=null){
var wires=_143e.getIWidgetInstance().getWireModel();
wires.removeWire(this.id);
_143e.commit();
}
}
}
for(var i in this.subHandler){
for(var j in this.subHandler[i]){
this.eventSvr.unsubscribeEvent(this.subHandler[i][j]);
}
}
this.eventSvr._getHubAdapter(this.id).removeIframeHubContainer(this.id);
var node=dojo.byId(this.id);
if(node&&node!=null){
com.ibm.mm.enabler.dom.destroyNode(node);
}
if(this.windowManager){
this.windowManager=null;
}
},update2:function(span){
return;
},_getParent:function(){
if(!this.parent){
this.parent=com.ibm.mm.iwidget.utils.getWidgetParent(this.rootElement);
}
if(typeof this.parent=="undefined"||this.parent==null){
this.parent=null;
}
return this.parent;
},_setParent:function(_1443){
this.parent=_1443;
},_getPublicEvents:function(){
if(!this.publicEvents){
var _1444=this.widgetDef._getPublicEvents();
var _1445={};
for(var i in _1444){
_1445[i]=_1444[i].clone();
}
this.publicEvents=new com.ibm.mm.iwidget.model.EventModelImpl(_1445,this.id);
}
return this.publicEvents;
},_getPublishedEvents:function(){
var _1447=this.getWidgetPublishedEvents();
var arr={};
if(_1447!=null){
var i=0;
for(i;i<_1447.length;i++){
arr[_1447[i].name]=_1447[i];
}
}
return arr;
},_getHandledEvents:function(){
var _144a=this.getWidgetHandledEvents();
var arr={};
if(_144a!=null){
var i=0;
for(i;i<_144a.length;i++){
arr[_144a[i].name]=_144a[i];
}
}
return arr;
},getWidgetPublishedEvents:function(){
var _144d=this._getPublicEvents();
if(_144d&&_144d!=null){
var _144e={};
_144e["isPublished"]="true";
return _144d.getEvents(_144e);
}
return null;
},getWidgetHandledEvents:function(){
var _144f=this._getPublicEvents();
if(_144f&&_144f!=null){
var _1450={};
_1450["isHandled"]="true";
return _144f.getEvents(_1450);
}
return null;
},getWires:function(){
return this.getIWidgetInstance().getWires();
},_getInstanceMarkup:function(){
return this.getIWidgetInstance()._getInstanceMarkup();
},handleEvent:function(_1451){
var scope=_1451.scope;
if(typeof scope!="undefined"&&scope!=null){
if(scope=="instance"){
scope=this.getIWidgetInstance();
}else{
if(scope=="eventmodel"){
scope=this._getPublicEvents();
}
}
}else{
scope=this;
}
var _1453=_1451.methodname;
if(typeof _1453!="undefined"&&_1453!=null){
if(scope[_1453]&&dojo.isFunction(scope[_1453])){
scope[_1453].apply(scope,_1451.params);
}
}
},_handleOnModeChange:function(_1454){
var _1455=false;
var _1456=this.currentMode;
if(typeof _1454=="undefined"||_1454==null){
return false;
}
if(dojo.isString(_1454)){
_1454=dojo.fromJson(_1454);
}
if(typeof _1454=="undefined"||_1454==null){
return false;
}
var _1457=_1454.newMode;
if(typeof _1457=="undefined"){
_1457=null;
}
var _1458=_1454.rootElementId;
if(typeof _1458=="undefined"){
_1458=null;
}
if(_1457!=null&&_1457==this.currentMode){
return false;
}
if(_1457==null){
return false;
}
var _1459={};
var _145a=this.windowManager[this.currentMode];
if(typeof _145a!="undefined"&&_145a!=null&&_145a.main==true&&_1458==null){
_1459.methodname="_handleOnModeChange";
_1459.params=[_1457];
this.eventSvr._publishEvent("widgetevents."+this.id,_1459);
return;
}
if(typeof _145a!="undefined"&&_145a!=null&&_145a.main==true&&_1458!=null){
var _145b=this._getInstanceMarkup();
_145b=this._getInstanceMarkupForMode(_145b,_1457);
this._createIframe(_145b,_1458,this.id+"_"+_1457,"true",this);
var _1456=this.currentMode;
this.currentMode=_1457;
this.windowManager[this.currentMode]={id:this.id+"_"+_1457,root:_1458,active:true,main:false};
_1459.methodname="_handleOnModeUpdated";
_1459.params=[_1457];
this.eventSvr._publishEvent("widgetevents."+this.id,_1459);
dojo.publish(com.ibm.mm.iwidget.iEvents.Constants.modeChanged,[this.id,_1456,_1457]);
var _1454={};
_1454.id=this.id;
_1454.oldMode=_1456;
_1454.newMode=_1457;
this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED,_1454,this.hubId);
return;
}
var _145c=this.windowManager[_1457];
if(typeof _145c!="undefined"&&_145c!=null&&_145c.main==true){
var _1459={};
_1459.methodname="_handleOnModeChange";
_1459.params=[_1457];
try{
this.eventSvr._publishEvent("widgetevents."+this.id,_1459);
}
catch(e){
console.log("catching exception!!!"+e);
}
this.eventSvr._getHubAdapter(this.id).removeIframeHubContainer(this.id+"_"+this.currentMode);
try{
for(var j in this.subHandler[this.id+"_"+this.currentMode]){
this.eventSvr.unsubscribeEvent(this.subHandler[this.id+"_"+this.currentMode][j]);
}
}
catch(e){
console.log("IWidgetWrapperStub:_handleOnModeChange unsubscribe exception:"+e);
}
delete this.windowManager[this.currentMode];
var _1456=this.currentMode;
this.currentMode=_1457;
dojo.publish(com.ibm.mm.iwidget.iEvents.Constants.modeChanged,[this.id,_1456,_1457]);
var _1454={};
_1454.id=this.id;
_1454.oldMode=_1456;
_1454.newMode=_1457;
this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED,_1454,this.hubId);
}
return;
},_getDefaultMode:function(){
var _145e=this.getIWidgetInstance().getIDescriptorItems();
if(typeof _145e!="undefined"&&_145e!=null){
var _145f=_145e[iwConstants.iDescriptorItems.mode];
if(typeof _145f!="undefined"||_145f!=null){
return _145f.defaultValue;
}
}
var _1460=this.widgetDef.getIDescriptorItems();
var _1461=null;
if(typeof _1460!="undefined"&&_1460!=null){
_1461=_1460[iwConstants.iDescriptorItems.mode];
if(typeof _1461=="undefined"){
_1461=null;
}
}
return _1461;
},commit:function(_1462){
var _1463=this.getIWidgetInstance();
var _1464=_1463.getAttributes();
var _1465=_1463.getIDescriptorItems();
var _1466=_1463.getWireModel();
var _1467={};
if(_1464&&_1464._isDirty()){
_1467.attributes=_1464;
}
if(_1465&&_1465._isDirty()){
_1467.idescriptors=_1465;
}
if(_1466&&_1466.isDirty()){
_1467.wiremodel=_1466.toJson();
}
if(!(_1462&&_1462==true)){
this.eventSvr._publishEvent(this.eventSvr.WIDGETEVENT_PREFIX+this.id,{"methodname":"_handleDataSync","params":[_1467]},this.id);
}
if(_1464&&_1464._isDirty()){
this._writePropertiesToDOM(this,"attributes",_1464);
_1464._setDirty(false);
}
if(_1465&&_1465._isDirty()){
this._writePropertiesToDOM(this,"idescriptor",_1465);
_1465._setDirty(false);
}
if(_1466&&_1466.isDirty()){
_1466.commit();
}
},_writePropertiesToDOM:function(_1468,_1469,_146a){
var i;
var ns=_1468.ns;
var root=_1468.rootElement;
var _146e=dojo.query("span."+ns+"ItemSet[title=\""+_1469+"\"]",root);
for(i=0;i<_146e.length;i++){
var _146f=_146e[i];
if(root==_146f.parentNode){
root.removeChild(_146f);
}
}
var _1470=document.createElement("span");
_1470.className=ns+"ItemSet";
_1470.title=_1469;
_1470.style.display="none";
_1470.style.visibility="hidden";
root.appendChild(_1470);
var names=_146a.getAllNames();
if(!names){
return;
}
for(i=0;i<names.length;i++){
var _1472=names[i];
var _1473=_146a._getItemValue3(_1472);
var _1474=document.createElement("a");
_1474.className=ns+"Item";
_1474.style.visibility="hidden";
_1474.style.display="none";
_1474.href="#"+_1472;
_1474.appendChild(document.createTextNode(_1473));
_1470.appendChild(_1474);
}
},getPublicEvent:function(name){
var _1476=this._getPublicEvents();
return _1476.find(name);
},_getInstanceMarkupForMode:function(_1477,mode){
var _1479=document.createElement("div");
_1479.innerHTML=_1477;
var root=_1479.firstChild;
root.id=this.id;
var _147b=dojo.query("span."+this.ns+"ItemSet[title=\""+iwConstants.IDESCRIPTOR+"\"]",root);
var _147c=null;
if(_147b.length==0){
_147c=document.createElement("span");
_147c.className=this.ns+"ItemSet";
_147c.title=iwConstants.IDESCRIPTOR;
_147c.style.display="none";
_147c.style.visibility="hidden";
b;
root.appendChild(_147c);
}else{
_147c=_147b[0];
}
var items=dojo.query("."+this.ns+"Item[href=\"#"+"mode"+"\"]",_147c);
for(i=0;i<items.length;i++){
var item=items[i];
if(_147c==item.parentNode){
_147c.removeChild(item);
}
}
var _147f=document.createElement("a");
_147f.className=this.ns+"Item";
_147f.style.visibility="hidden";
_147f.style.display="none";
_147f.href="#"+"mode";
_147f.appendChild(document.createTextNode(mode));
_147c.appendChild(_147f);
return _1479.innerHTML;
},_createIframe:function(_1480,root,id,_1483,_1484,_1485){
var that=_1484;
var _1487=_1484.getCSSUrl();
_1484.subHandler[id]=[];
function eventCallback(_1488){
if(_1484.isLoaded()==true&&_1483&&_1483=="false"){
_1484.loaded=false;
_1480=_1484._getInstanceMarkup();
}
if(_1485&&_1485!=null){
that.eventSvr._publishEvent(that.eventSvr.WIDGETEVENT_PREFIX+id+"."+"onWidgetLoading",{"html":_1480,"xml":that.widgetDef.widgetDef,"isModal":_1483,"hubId":id,"cssUrl":_1487,"stateData":_1485});
}else{
that.eventSvr._publishEvent(that.eventSvr.WIDGETEVENT_PREFIX+id+"."+"onWidgetLoading",{"html":_1480,"xml":that.widgetDef.widgetDef,"isModal":_1483,"hubId":id,"cssUrl":_1487});
}
var _1489=that.eventSvr.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+id,null,function(_148a){
if(_1483=="false"){
that.loaded=true;
_1484.eventSvr._handleBroadcastEventsCache();
dojo.query("."+that.ns+"loading",that.rootElement).forEach(function(elem){
com.ibm.mm.enabler.dom.destroyNode(elem);
});
dojo.query("."+that.currentMode,that.rootElement).style({"visibility":""});
}
});
that.subHandler[id].push(_1489);
var _148c=that.eventSvr.subscribeEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+"."+that.id,that,"handleSizeChanged");
that.subHandler[id].push(_148c);
};
var _148d=_1484.eventSvr.subscribeEvent(_1484.eventSvr.WIDGETEVENT_PREFIX+id+"."+"onFrameLoaded",null,eventCallback);
_1484.subHandler[id].push(_148d);
var _148e=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var url=window.location.protocol;
var host=window.location.hostname;
var _1491=_148e.getValue(_148e.SERVERDOMAIN);
if(typeof _1491!="undefined"&&_1491!=null&&_1491!="null"){
host=_1491;
}
var port=window.location.port;
var path=window.location.pathname;
var _1494=_148e.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);
var _1495=null;
if(path.indexOf(_1494)>0){
_1495=path.slice(0,path.indexOf(_1494));
}
if(_1484._getSubDomain()!=null){
var _1496=_1484._getSubDomain()+"."+host;
if(port!=""){
url+="//"+_1496+":"+port;
}else{
url+="//"+_1496;
}
if(_1495!=null){
url+=_1495;
}
url+=_148e.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT_ENABLER);
url+="/widgetsandbox";
_1484.eventSvr._getHubAdapter().createIframeHubContainer(id,root,url,_1483);
}else{
var _1497=_1484.eventSvr._getHubAdapter().getSubDomainSize();
var _1498=unescape(_1484.getIWidgetInstance().getIDescriptorItems().getItemValue("title",dojo.locale));
if(!_1498){
_1498=_1484.getID();
}
var _1499=_148e.getValue(com.ibm.mashups.enabler.services.ConfigConstants.SUBDOMAINREUSE);
var fmt=_1484.iwMessages.E_SUBDOMAIN_NOTAVAILABLE1_2;
if(_1499){
fmt=_1484.iwMessages.E_SUBDOMAIN_NOTAVAILABLE_2;
}
var _149b=dojo.string.substitute(fmt,[_1498,_1497]);
var nodes=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",_1484.ns+"loading",_1484.rootElement,nodes,false);
if(nodes.length>0){
aNode=nodes[0];
aNode.innerHTML="";
com.ibm.mm.enabler.debug.logInlineMessage(aNode,"error",_149b);
}
}
},_getSubDomain:function(){
if(typeof this.subDomain=="undefined"||this.subDomain==null){
this.subDomain=this.eventSvr._getHubAdapter().getSubDomain();
}
return this.subDomain;
},_handleDataSync:function(_149d){
if(typeof _149d.attributes!="undefined"&&_149d.attributes!=null){
var _149e=_149d.attributes;
this._syncModifiableProperties(_149e,this.getIWidgetInstance().getAttributes());
}
if(typeof _149d.wiremodel!="undefined"&&_149d.wiremodel!=null){
var _149f=_149d.wiremodel;
this._syncWireModel(_149f,this.getIWidgetInstance().getWireModel());
}
this.commit(true);
},_syncWireModel:function(_14a0,_14a1){
var wires=_14a0._wires;
for(var i in wires){
var aWire=wires[i];
if(aWire._isDirty&&aWire._type!=null&&aWire._type=="NEW"){
_14a1.addWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
}else{
if(aWire._isDirty&&aWire._type!=null&&aWire._type=="DELETE"){
_14a1.removeWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
}
}
}
var _14a5=_14a0._targets;
_14a1._targets=_14a5;
},_syncModifiableProperties:function(_14a6,_14a7){
var items=_14a6._items;
if(_14a6._dirty&&_14a6._dirty==true){
for(var i in items){
var name=i;
var value=items[i];
if(typeof value!="undefined"&&value!=null&&value==_14a7.DELETE_TOKEN){
_14a7.removeItem(name);
}else{
_14a7.setItemValue(name,value);
}
}
}
},handleSizeChanged:function(_14ac){
var _14ad=this.windowManager[this.currentMode];
var id=this.id;
if(_14ad.main==false){
id=this.id+"_"+this.currentMode;
}
var root=_14ad.root;
var _14b0=root.childNodes[0];
if(_14ac.newWidth&&_14ac.newWidth!=null){
var width=parseInt(_14ac.newWidth);
width=width-5;
dojo.style(_14b0,"width",width+"px");
}
if(_14ac.newHeight&&_14ac.newHeight!=null){
var _14b2=parseInt(_14ac.newHeight);
_14b2=_14b2-5;
dojo.style(_14b0,"height",_14b2+"px");
}
this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+id,_14ac);
},getCSSUrl:function(){
var that=this;
if(this.themeCSS&&this.themeCSS!=null){
return this.themeCSS;
}
dojo.forEach(document.getElementsByTagName("link"),function(_14b4){
if(_14b4.href&&_14b4.href!=null&&_14b4.href.indexOf("theme.css")!=-1){
var _14b5=_14b4.href.length-9;
if(_14b4.href.indexOf("theme.css")==_14b5){
that.themeCSS=_14b4.href;
}
}else{
if(_14b4.href&&_14b4.href!=null&&_14b4.href.indexOf("theme_rtl.css")!=-1){
var _14b6=_14b4.href.length-13;
if(_14b4.href.indexOf("theme_rtl.css")==_14b6){
that.themeCSS=_14b4.href;
}
}
}
});
return this.themeCSS;
},_handleOnNavStateChanged:function(_14b7){
var state=_14b7.payload;
if(state&&state!=null){
var _14b9=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
var _14ba=com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(_14b9,this.id);
_14ba.setWidgetState("cp",state);
var _14bb=_14b9.commit();
_14bb.start();
}
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.rendercontroller"]){
dojo._hasResource["com.ibm.mm.iwidget.rendercontroller"]=true;
dojo.provide("com.ibm.mm.iwidget.rendercontroller");
dojo.declare("com.ibm.mm.iwidget.RenderController",null,{constructor:function(_14bc){
this.widgetwrapper=_14bc;
this.widgetXMLUrl=this.widgetwrapper.getIWidgetInstance().widgetXMLUrl;
this.iwStr=dojo.i18n.getLocalization("com.ibm.mm.enabler","iwStr");
dojo.subscribe(this.inlineMessageHandler);
},render:function(){
this._loadWidgetDefinition();
},_resourceBaseURL:new dojo.moduleUrl("com.ibm.mm.iwidget","image/"),_setLoading:function(){
var _14bd=document.createElement("div");
_14bd.className=this.widgetwrapper.ns+"loading";
if(ibmConfig&&ibmConfig.loadingHTML){
_14bd.innerHTML=ibmConfig.loadingHTML;
}else{
_14bd.innerHTML="<img alt='"+this.iwStr.LOAD+"' src='"+this._resourceBaseURL+"progress-anim.gif' />&nbsp;"+this.iwStr.LOAD;
}
this.widgetwrapper.rootElement.appendChild(_14bd);
},_loadWidgetDefinition:function(){
com.ibm.mm.enabler.debug.entry("iWidget.loadWidgetDefinition");
var _14be=this.widgetwrapper.rootElement;
if(this.widgetwrapper.loaded){
return false;
}
this._setLoading();
if(this.widgetXMLUrl!==null){
var _14bf=com.ibm.mashups.services.ServiceManager.getService("widgetLoadService");
_14bf.getWidgetXML(this.widgetXMLUrl,false,dojo.hitch(this,"handleWidgetInfoRetrieved"),this.widgetwrapper.id);
}else{
return false;
}
com.ibm.mm.enabler.debug.entry("iWidget.loadWidgetDefinition",true);
return true;
},handleWidgetInfoRetrieved:function(data,_14c1,xhr){
com.ibm.mm.enabler.debug.entry("iWidget.handleWidgetInfoRetrieved");
if(_14c1=="200"||_14c1=="0"){
this.widgetwrapper.setIWidgetDefinition(data);
this.widgetDef=data;
}else{
this._handleInlineMessage("error",dojo.string.substitute(this.widgetwrapper.iwMessages.E_IWIDGETDEF_NOTAVAILABLE_1,[this.widgetXMLUrl]),data.message);
return;
}
var _14c3=this.isSandboxed();
if(dojo.isIE<7&&_14c3==true){
var _14c4=unescape(this.widgetwrapper.getIWidgetInstance().getIDescriptorItems().getItemValue("title",dojo.locale));
if(!_14c4){
_14c4=this.widgetXMLUrl;
}
this._handleInlineMessage("error",dojo.string.substitute(this.widgetwrapper.iwMessages.E_NODISPLAY_UNSECUREWIDGET_1,[_14c4]));
return;
}
this._doRender(_14c3);
com.ibm.mm.enabler.debug.exit("iWidget.handleWidgetInfoRetrieved",this.id);
},isSandboxed:function(){
var _14c5=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _14c6=_14c5.getValue(_14c5.SANDBOXENABLED);
if(_14c6==false){
return false;
}
var _14c7=document.location+"";
var _14c6=false;
var _14c8=this.widgetDef.getAttributes();
if(typeof _14c8!="undefined"&&_14c8!=null){
var value=_14c8.getItemValue("sandbox");
if(typeof value!="undefined"&&value!=null){
if(value=="true"){
_14c6=true;
}
}
}
if(_14c6==false){
if(this.widgetwrapper.rootElement.getAttribute("sandbox")!==null&&this.widgetwrapper.rootElement.getAttribute("sandbox")=="true"){
_14c6=true;
}
}
if(_14c6==true){
if(this._isSandboxDisabledWidget(this.widgetXMLUrl)==true){
_14c6=false;
}
}
return _14c6;
},_isSandboxDisabledWidget:function(_14ca){
var _14cb=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var temp=_14cb.getValue(com.ibm.mashups.enabler.services.ConfigConstants.WIDGETDEFID_SANDBOX_DISABLED);
var _14cd=temp;
if(dojo.isString(_14cd)==true){
_14cd=[temp];
}
if(_14cd.length==0){
return false;
}
for(var i=0;i<_14cd.length;i++){
if(dojo.trim(_14ca)===dojo.trim(_14cd[i])){
return true;
}else{
if(dojo.trim(_14ca).indexOf(dojo.trim(_14cd[i]))!=-1&&dojo.trim(_14cd[i]).indexOf("/")!=0){
return true;
}else{
if(dojo.trim(_14ca).indexOf(dojo.trim(_14cd[i]))!=-1&&dojo.trim(_14cd[i]).indexOf("/")==0&&dojo.trim(_14ca).indexOf(":")!=-1){
var buf=_14ca.split("//");
var _14d0=buf[0];
var buf2=buf[1].split("/");
var host=buf2[0];
if(_14d0==window.location.protocol&&window.location.host==host){
return true;
}else{
if(_14d0==window.location.protocol&&_14d0=="http:"&&host.indexOf(window.location.host)==0){
if(host.substr(host.indexOf(":")+1)=="80"){
return true;
}
}else{
if(_14d0==window.location.protocol&&_14d0=="https:"&&host.indexOf(window.location.host)==0){
if(host.substr(host.indexOf(":")+1)=="443"){
return true;
}
}
}
}
}
}
}
}
return false;
},_handleInlineMessage:function(type,_14d4,_14d5){
var nodes=[];
com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.widgetwrapper.ns+"loading",this.widgetwrapper.rootElement,nodes,false);
var aNode=nodes[0];
aNode.innerHTML="";
com.ibm.mm.enabler.debug.logInlineMessage(aNode,type,_14d4,_14d5);
},_doRender:function(_14d8){
var _14d9=com.ibm.mashups.services.ServiceManager.getService("eventService");
if(_14d8){
dojo.mixin(this.widgetwrapper,new com.ibm.mm.iwidget.widget.IWidgetWrapperStubImpl());
}else{
_14d9._getHubAdapter().createInlineHubContainer(this.widgetwrapper.id);
_14d9._getHubAdapter().createInlineHubClient(this.widgetwrapper.id);
}
this.widgetwrapper.doRender();
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.model.widgetmodel"]){
dojo._hasResource["com.ibm.mm.iwidget.model.widgetmodel"]=true;
dojo.provide("com.ibm.mm.iwidget.model.widgetmodel");
dojo.require("com.ibm.mm.iwidget.deferred");
dojo.declare("com.ibm.mm.iwidget.model.WidgetModelImpl",com.ibm.mashups.iwidget.model.WidgetModel,{constructor:function(){
this.widgetArr={};
this.parentMap={};
this.eventService=com.ibm.mashups.services.ServiceManager.getService("eventService");
this.eventService.subscribeEvent("/enabler/pageChanged",this,"_unloadWidgets");
dojo.subscribe("/enabler/widgetDeleted",this,"_unloadWidgets");
this.eventService.subscribeEvent(com.ibm.mashups.iwidget.Constants.UNLOAD_WIDGETS,this,"_unloadWidgets");
if(!ibmConfig||(ibmConfig&&typeof ibmConfig.loadingHTML!="string")){
var url=new dojo.moduleUrl("com.ibm.mm.iwidget","image/"),url=url+"progress-anim.gif";
this.processAnim=com.ibm.mm.enabler.utilities.preloadImage(url,20,20);
}
dojo.connect(window,"onunload",this,"_onWindowUnload");
this.global=dojo.global;
this.doc=dojo.doc;
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},_onWindowUnload:function(){
try{
var arr=[];
for(i in this.widgetArr){
this._unloadWidget(i);
}
}
catch(e){
console.log("_onWindowUnload "+e.message);
}
},createWidget:function(_14dc){
var id=_14dc.getAttribute("id");
if(typeof (id)=="undefined"){
return;
}
var _14de=this.widgetArr[id];
if(typeof _14de!="undefined"&&_14de!==null){
var _14df=_14de.rootElement;
if(_14df==_14dc){
return _14de;
}else{
this._unloadWidget(id);
}
}
var _14e0=new com.ibm.mm.iwidget.widget.IWidgetWrapperDefaultImpl(_14dc,id);
this.widgetArr[id]=_14e0;
this.parentMap[id]="DEFER_TOKEN";
return _14e0;
},updateWidget:function(_14e1){
var _14e2=null;
var id=_14e1.getAttribute("id");
if(id!==null){
_14e2=this.find(id);
if(_14e2!==null){
_14e2.update2(_14e1);
}
}
return _14e2;
},renderWidget:function(_14e4){
if(typeof _14e4=="undefined"){
return;
}
if(_14e4.loaded&&_14e4.loaded==true){
return;
}
var _14e5=new com.ibm.mm.iwidget.RenderController(_14e4);
_14e5.render();
},getWidgetById:function(id){
return this.find(id);
},find:function(id){
var _14e8=this.widgetArr[id];
if(typeof _14e8!="undefined"){
if(_14e8.lazyLoad&&_14e8.loaded==false){
var _14e9=new com.ibm.mm.iwidget.RenderController(_14e8);
_14e9.render();
delete _14e8.lazyLoad;
}
return _14e8;
}
return null;
},commit:function(){
return new com.ibm.mm.enabler.DeferredOperationImpl(this,this._commit);
},_commit:function(_14ea,sync){
for(var _14ec in this.widgetArr){
var _14ed=this.widgetArr[_14ec];
var _14ee=_14ed.getIWidgetInstance();
if(!_14ee){
continue;
}
_14ed.commit();
}
},_unloadWidgets:function(arr){
var _14f0;
if(typeof arr!="undefined"||arr!==null){
if(dojo.isArray(arr)){
for(var i in arr){
_14f0=arr[i];
this._unloadWidget(_14f0);
}
dojo.publish(com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED,[arr]);
this.eventService.publishEvent(com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED,arr);
}else{
if(dojo.isString(arr)){
this._unloadWidget(arr);
}
}
}
},_unloadWidget:function(_14f2){
if(typeof this.widgetArr[_14f2]!="undefined"&&this.widgetArr[_14f2]!==null){
var _14f3=this.widgetArr[_14f2];
try{
_14f3.destroy();
}
catch(e){
}
delete this.widgetArr[_14f2];
if(this.parentMap[_14f2]){
delete this.parentMap[_14f2];
}
}
},getParent:function(_14f4){
var _14f5=this.parentMap[_14f4.getID()];
if(_14f5&&_14f5=="DEFER_TOKEN"){
_14f5=_14f4._getParent();
this.parentMap[_14f4.getID()]=_14f5;
}
if(_14f5&&_14f5!=null){
parent=this.find(_14f5);
}
return parent||null;
},hasChildren:function(_14f6){
return (this.getChildren(_14f6,false).length==0)?false:true;
},getChildren:function(_14f7,_14f8){
this._checkParentMap();
var _14f9=[];
var _14fa=(typeof _14f8=="undefined")?true:_14f8;
this._getChildren(_14f7,_14fa,_14f9);
return _14f9;
},_checkParentMap:function(){
for(var id in this.widgetArr){
var _14fc=this.parentMap[id];
if(_14fc&&_14fc=="DEFER_TOKEN"){
var _14fd=this.widgetArr[id];
_14fc=_14fd._getParent();
this.parentMap[id]=_14fc;
}
}
},_getChildren:function(_14fe,_14ff,_1500){
for(var id in this.parentMap){
if(this.parentMap[id]==_14fe.getID()){
var _1502=this.find(id);
if(_1502!=null){
_1500.push(_1502);
if(_14ff){
this._getChildren(_1502,_14ff,_1500);
}
}
}
}
},getWidgetDefinitionByUrl:function(url){
return new com.ibm.mm.iwidget.DeferredLoadImpl(url);
},getAllWidgets:function(){
return this.widgetArr;
}});
}
if(!dojo._hasResource["com.ibm.mm.iwidget.model.factory"]){
dojo._hasResource["com.ibm.mm.iwidget.model.factory"]=true;
dojo.provide("com.ibm.mm.iwidget.model.factory");
dojo.declare("com.ibm.mm.iwidget.model.FactoryImpl",com.ibm.mashups.iwidget.model.Factory,{constructor:function(){
},getGlobalWidgetModel:function(){
if(typeof (this._globalWidgetModel)=="undefined"||this._globalWidgetModel==null){
this._globalWidgetModel=new com.ibm.mm.iwidget.model.WidgetModelImpl();
}
return this._globalWidgetModel;
}});
com.ibm.mashups.iwidget.model.Factory=new com.ibm.mm.iwidget.model.FactoryImpl();
iWidgetContainer=com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
}
if(!dojo._hasResource["dojo.dnd.common"]){
dojo._hasResource["dojo.dnd.common"]=true;
dojo.provide("dojo.dnd.common");
dojo.dnd._isMac=navigator.appVersion.indexOf("Macintosh")>=0;
dojo.dnd._copyKey=dojo.dnd._isMac?"metaKey":"ctrlKey";
dojo.dnd.getCopyKeyState=function(e){
return e[dojo.dnd._copyKey];
};
dojo.dnd._uniqueId=0;
dojo.dnd.getUniqueId=function(){
var id;
do{
id=dojo._scopeName+"Unique"+(++dojo.dnd._uniqueId);
}while(dojo.byId(id));
return id;
};
dojo.dnd._empty={};
dojo.dnd.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
dojo.dnd._lmb=dojo.isIE?1:0;
dojo.dnd._isLmbPressed=dojo.isIE?function(e){
return e.button&1;
}:function(e){
return e.button===0;
};
}
if(!dojo._hasResource["dojo.dnd.autoscroll"]){
dojo._hasResource["dojo.dnd.autoscroll"]=true;
dojo.provide("dojo.dnd.autoscroll");
dojo.dnd.getViewport=function(){
var d=dojo.doc,dd=d.documentElement,w=window,b=dojo.body();
if(dojo.isMozilla){
return {w:dd.clientWidth,h:w.innerHeight};
}else{
if(!dojo.isOpera&&w.innerWidth){
return {w:w.innerWidth,h:w.innerHeight};
}else{
if(!dojo.isOpera&&dd&&dd.clientWidth){
return {w:dd.clientWidth,h:dd.clientHeight};
}else{
if(b.clientWidth){
return {w:b.clientWidth,h:b.clientHeight};
}
}
}
}
return null;
};
dojo.dnd.V_TRIGGER_AUTOSCROLL=32;
dojo.dnd.H_TRIGGER_AUTOSCROLL=32;
dojo.dnd.V_AUTOSCROLL_VALUE=16;
dojo.dnd.H_AUTOSCROLL_VALUE=16;
dojo.dnd.autoScroll=function(e){
var v=dojo.dnd.getViewport(),dx=0,dy=0;
if(e.clientX<dojo.dnd.H_TRIGGER_AUTOSCROLL){
dx=-dojo.dnd.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-dojo.dnd.H_TRIGGER_AUTOSCROLL){
dx=dojo.dnd.H_AUTOSCROLL_VALUE;
}
}
if(e.clientY<dojo.dnd.V_TRIGGER_AUTOSCROLL){
dy=-dojo.dnd.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-dojo.dnd.V_TRIGGER_AUTOSCROLL){
dy=dojo.dnd.V_AUTOSCROLL_VALUE;
}
}
window.scrollBy(dx,dy);
};
dojo.dnd._validNodes={"div":1,"p":1,"td":1};
dojo.dnd._validOverflow={"auto":1,"scroll":1};
dojo.dnd.autoScrollNodes=function(e){
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in dojo.dnd._validNodes)){
var s=dojo.getComputedStyle(n);
if(s.overflow.toLowerCase() in dojo.dnd._validOverflow){
var b=dojo._getContentBox(n,s),t=dojo._abs(n,true);
var w=Math.min(dojo.dnd.H_TRIGGER_AUTOSCROLL,b.w/2),h=Math.min(dojo.dnd.V_TRIGGER_AUTOSCROLL,b.h/2),rx=e.pageX-t.x,ry=e.pageY-t.y,dx=0,dy=0;
if(dojo.isWebKit||dojo.isOpera){
rx+=dojo.body().scrollLeft,ry+=dojo.body().scrollTop;
}
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
}
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
}
var _151d=n.scrollLeft,_151e=n.scrollTop;
n.scrollLeft=n.scrollLeft+dx;
n.scrollTop=n.scrollTop+dy;
if(_151d!=n.scrollLeft||_151e!=n.scrollTop){
return;
}
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
dojo.dnd.autoScroll(e);
};
}
if(!dojo._hasResource["dojo.dnd.Mover"]){
dojo._hasResource["dojo.dnd.Mover"]=true;
dojo.provide("dojo.dnd.Mover");
dojo.declare("dojo.dnd.Mover",null,{constructor:function(node,e,host){
this.node=dojo.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=this.host=host,d=node.ownerDocument,_1524=dojo.connect(d,"onmousemove",this,"onFirstMove");
this.events=[dojo.connect(d,"onmousemove",this,"onMouseMove"),dojo.connect(d,"onmouseup",this,"onMouseUp"),dojo.connect(d,"ondragstart",dojo.stopEvent),dojo.connect(d.body,"onselectstart",dojo.stopEvent),_1524];
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
dojo.dnd.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY});
dojo.stopEvent(e);
},onMouseUp:function(e){
if(dojo.isWebKit&&dojo.dnd._isMac&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
dojo.stopEvent(e);
},onFirstMove:function(){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left));
t=Math.round(parseFloat(s.top));
break;
default:
s.position="absolute";
var m=dojo.marginBox(this.node);
var b=dojo.doc.body;
var bs=dojo.getComputedStyle(b);
var bm=dojo._getMarginBox(b,bs);
var bc=dojo._getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this);
}
dojo.disconnect(this.events.pop());
},destroy:function(){
dojo.forEach(this.events,dojo.disconnect);
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
}
if(!dojo._hasResource["dojo.dnd.Moveable"]){
dojo._hasResource["dojo.dnd.Moveable"]=true;
dojo.provide("dojo.dnd.Moveable");
dojo.declare("dojo.dnd.Moveable",null,{handle:"",delay:0,skip:false,constructor:function(node,_1533){
this.node=dojo.byId(node);
if(!_1533){
_1533={};
}
this.handle=_1533.handle?dojo.byId(_1533.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_1533.delay>0?_1533.delay:0;
this.skip=_1533.skip;
this.mover=_1533.mover?_1533.mover:dojo.dnd.Mover;
this.events=[dojo.connect(this.handle,"onmousedown",this,"onMouseDown"),dojo.connect(this.handle,"ondragstart",this,"onSelectStart"),dojo.connect(this.handle,"onselectstart",this,"onSelectStart")];
},markupFactory:function(_1534,node){
return new dojo.dnd.Moveable(node,_1534);
},destroy:function(){
dojo.forEach(this.events,dojo.disconnect);
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dojo.dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(dojo.connect(this.handle,"onmousemove",this,"onMouseMove"),dojo.connect(this.handle,"onmouseup",this,"onMouseUp"));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
dojo.stopEvent(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
dojo.stopEvent(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
dojo.disconnect(this.events.pop());
}
dojo.stopEvent(e);
},onSelectStart:function(e){
if(!this.skip||!dojo.dnd.isFormElement(e)){
dojo.stopEvent(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(mover){
dojo.publish("/dnd/move/start",[mover]);
dojo.addClass(dojo.body(),"dojoMove");
dojo.addClass(this.node,"dojoMoveItem");
},onMoveStop:function(mover){
dojo.publish("/dnd/move/stop",[mover]);
dojo.removeClass(dojo.body(),"dojoMove");
dojo.removeClass(this.node,"dojoMoveItem");
},onFirstMove:function(mover){
},onMove:function(mover,_1540){
this.onMoving(mover,_1540);
var s=mover.node.style;
s.left=_1540.l+"px";
s.top=_1540.t+"px";
this.onMoved(mover,_1540);
},onMoving:function(mover,_1543){
},onMoved:function(mover,_1545){
}});
}
if(!dojo._hasResource["dojo.dnd.move"]){
dojo._hasResource["dojo.dnd.move"]=true;
dojo.provide("dojo.dnd.move");
dojo.declare("dojo.dnd.move.constrainedMoveable",dojo.dnd.Moveable,{constraints:function(){
},within:false,markupFactory:function(_1546,node){
return new dojo.dnd.move.constrainedMoveable(node,_1546);
},constructor:function(node,_1549){
if(!_1549){
_1549={};
}
this.constraints=_1549.constraints;
this.within=_1549.within;
},onFirstMove:function(mover){
var c=this.constraintBox=this.constraints.call(this,mover);
c.r=c.l+c.w;
c.b=c.t+c.h;
if(this.within){
var mb=dojo.marginBox(mover.node);
c.r-=mb.w;
c.b-=mb.h;
}
},onMove:function(mover,_154e){
var c=this.constraintBox,s=mover.node.style;
s.left=(_154e.l<c.l?c.l:c.r<_154e.l?c.r:_154e.l)+"px";
s.top=(_154e.t<c.t?c.t:c.b<_154e.t?c.b:_154e.t)+"px";
}});
dojo.declare("dojo.dnd.move.boxConstrainedMoveable",dojo.dnd.move.constrainedMoveable,{box:{},markupFactory:function(_1551,node){
return new dojo.dnd.move.boxConstrainedMoveable(node,_1551);
},constructor:function(node,_1554){
var box=_1554&&_1554.box;
this.constraints=function(){
return box;
};
}});
dojo.declare("dojo.dnd.move.parentConstrainedMoveable",dojo.dnd.move.constrainedMoveable,{area:"content",markupFactory:function(_1556,node){
return new dojo.dnd.move.parentConstrainedMoveable(node,_1556);
},constructor:function(node,_1559){
var area=_1559&&_1559.area;
this.constraints=function(){
var n=this.node.parentNode,s=dojo.getComputedStyle(n),mb=dojo._getMarginBox(n,s);
if(area=="margin"){
return mb;
}
var t=dojo._getMarginExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="border"){
return mb;
}
t=dojo._getBorderExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="padding"){
return mb;
}
t=dojo._getPadExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
return mb;
};
}});
dojo.dnd.move.constrainedMover=function(fun,_1560){
dojo.deprecated("dojo.dnd.move.constrainedMover, use dojo.dnd.move.constrainedMoveable instead");
var mover=function(node,e,_1564){
dojo.dnd.Mover.call(this,node,e,_1564);
};
dojo.extend(mover,dojo.dnd.Mover.prototype);
dojo.extend(mover,{onMouseMove:function(e){
dojo.dnd.autoScroll(e);
var m=this.marginBox,c=this.constraintBox,l=m.l+e.pageX,t=m.t+e.pageY;
l=l<c.l?c.l:c.r<l?c.r:l;
t=t<c.t?c.t:c.b<t?c.b:t;
this.host.onMove(this,{l:l,t:t});
},onFirstMove:function(){
dojo.dnd.Mover.prototype.onFirstMove.call(this);
var c=this.constraintBox=fun.call(this);
c.r=c.l+c.w;
c.b=c.t+c.h;
if(_1560){
var mb=dojo.marginBox(this.node);
c.r-=mb.w;
c.b-=mb.h;
}
}});
return mover;
};
dojo.dnd.move.boxConstrainedMover=function(box,_156d){
dojo.deprecated("dojo.dnd.move.boxConstrainedMover, use dojo.dnd.move.boxConstrainedMoveable instead");
return dojo.dnd.move.constrainedMover(function(){
return box;
},_156d);
};
dojo.dnd.move.parentConstrainedMover=function(area,_156f){
dojo.deprecated("dojo.dnd.move.parentConstrainedMover, use dojo.dnd.move.parentConstrainedMoveable instead");
var fun=function(){
var n=this.node.parentNode,s=dojo.getComputedStyle(n),mb=dojo._getMarginBox(n,s);
if(area=="margin"){
return mb;
}
var t=dojo._getMarginExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="border"){
return mb;
}
t=dojo._getBorderExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="padding"){
return mb;
}
t=dojo._getPadExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
return mb;
};
return dojo.dnd.move.constrainedMover(fun,_156f);
};
dojo.dnd.constrainedMover=dojo.dnd.move.constrainedMover;
dojo.dnd.boxConstrainedMover=dojo.dnd.move.boxConstrainedMover;
dojo.dnd.parentConstrainedMover=dojo.dnd.move.parentConstrainedMover;
}
if(!dojo._hasResource["dojox.uuid.generateTimeBasedUuid"]){
dojo._hasResource["dojox.uuid.generateTimeBasedUuid"]=true;
dojo.provide("dojox.uuid.generateTimeBasedUuid");
dojox.uuid.generateTimeBasedUuid=function(node){
var _1576=dojox.uuid.generateTimeBasedUuid._generator.generateUuidString(node);
return _1576;
};
dojox.uuid.generateTimeBasedUuid.isValidNode=function(node){
var _1578=16;
var _1579=parseInt(node,_1578);
var valid=dojo.isString(node)&&node.length==12&&isFinite(_1579);
return valid;
};
dojox.uuid.generateTimeBasedUuid.setNode=function(node){
dojox.uuid.assert((node===null)||this.isValidNode(node));
this._uniformNode=node;
};
dojox.uuid.generateTimeBasedUuid.getNode=function(){
return this._uniformNode;
};
dojox.uuid.generateTimeBasedUuid._generator=new function(){
this.GREGORIAN_CHANGE_OFFSET_IN_HOURS=3394248;
var _157c=null;
var _157d=null;
var _157e=null;
var _157f=0;
var _1580=null;
var _1581=null;
var _1582=16;
function _carry(_1583){
_1583[2]+=_1583[3]>>>16;
_1583[3]&=65535;
_1583[1]+=_1583[2]>>>16;
_1583[2]&=65535;
_1583[0]+=_1583[1]>>>16;
_1583[1]&=65535;
dojox.uuid.assert((_1583[0]>>>16)===0);
};
function _get64bitArrayFromFloat(x){
var _1585=new Array(0,0,0,0);
_1585[3]=x%65536;
x-=_1585[3];
x/=65536;
_1585[2]=x%65536;
x-=_1585[2];
x/=65536;
_1585[1]=x%65536;
x-=_1585[1];
x/=65536;
_1585[0]=x;
return _1585;
};
function _addTwo64bitArrays(_1586,_1587){
dojox.uuid.assert(dojo.isArray(_1586));
dojox.uuid.assert(dojo.isArray(_1587));
dojox.uuid.assert(_1586.length==4);
dojox.uuid.assert(_1587.length==4);
var _1588=new Array(0,0,0,0);
_1588[3]=_1586[3]+_1587[3];
_1588[2]=_1586[2]+_1587[2];
_1588[1]=_1586[1]+_1587[1];
_1588[0]=_1586[0]+_1587[0];
_carry(_1588);
return _1588;
};
function _multiplyTwo64bitArrays(_1589,_158a){
dojox.uuid.assert(dojo.isArray(_1589));
dojox.uuid.assert(dojo.isArray(_158a));
dojox.uuid.assert(_1589.length==4);
dojox.uuid.assert(_158a.length==4);
var _158b=false;
if(_1589[0]*_158a[0]!==0){
_158b=true;
}
if(_1589[0]*_158a[1]!==0){
_158b=true;
}
if(_1589[0]*_158a[2]!==0){
_158b=true;
}
if(_1589[1]*_158a[0]!==0){
_158b=true;
}
if(_1589[1]*_158a[1]!==0){
_158b=true;
}
if(_1589[2]*_158a[0]!==0){
_158b=true;
}
dojox.uuid.assert(!_158b);
var _158c=new Array(0,0,0,0);
_158c[0]+=_1589[0]*_158a[3];
_carry(_158c);
_158c[0]+=_1589[1]*_158a[2];
_carry(_158c);
_158c[0]+=_1589[2]*_158a[1];
_carry(_158c);
_158c[0]+=_1589[3]*_158a[0];
_carry(_158c);
_158c[1]+=_1589[1]*_158a[3];
_carry(_158c);
_158c[1]+=_1589[2]*_158a[2];
_carry(_158c);
_158c[1]+=_1589[3]*_158a[1];
_carry(_158c);
_158c[2]+=_1589[2]*_158a[3];
_carry(_158c);
_158c[2]+=_1589[3]*_158a[2];
_carry(_158c);
_158c[3]+=_1589[3]*_158a[3];
_carry(_158c);
return _158c;
};
function _padWithLeadingZeros(_158d,_158e){
while(_158d.length<_158e){
_158d="0"+_158d;
}
return _158d;
};
function _generateRandomEightCharacterHexString(){
var _158f=Math.floor((Math.random()%1)*Math.pow(2,32));
var _1590=_158f.toString(_1582);
while(_1590.length<8){
_1590="0"+_1590;
}
return _1590;
};
this.generateUuidString=function(node){
if(node){
dojox.uuid.assert(dojox.uuid.generateTimeBasedUuid.isValidNode(node));
}else{
if(dojox.uuid.generateTimeBasedUuid._uniformNode){
node=dojox.uuid.generateTimeBasedUuid._uniformNode;
}else{
if(!_157c){
var _1592=32768;
var _1593=Math.floor((Math.random()%1)*Math.pow(2,15));
var _1594=(_1592|_1593).toString(_1582);
_157c=_1594+_generateRandomEightCharacterHexString();
}
node=_157c;
}
}
if(!_157d){
var _1595=32768;
var _1596=Math.floor((Math.random()%1)*Math.pow(2,14));
_157d=(_1595|_1596).toString(_1582);
}
var now=new Date();
var _1598=now.valueOf();
var _1599=_get64bitArrayFromFloat(_1598);
if(!_1580){
var _159a=_get64bitArrayFromFloat(60*60);
var _159b=_get64bitArrayFromFloat(dojox.uuid.generateTimeBasedUuid._generator.GREGORIAN_CHANGE_OFFSET_IN_HOURS);
var _159c=_multiplyTwo64bitArrays(_159b,_159a);
var _159d=_get64bitArrayFromFloat(1000);
_1580=_multiplyTwo64bitArrays(_159c,_159d);
_1581=_get64bitArrayFromFloat(10000);
}
var _159e=_1599;
var _159f=_addTwo64bitArrays(_1580,_159e);
var _15a0=_multiplyTwo64bitArrays(_159f,_1581);
if(now.valueOf()==_157e){
_15a0[3]+=_157f;
_carry(_15a0);
_157f+=1;
if(_157f==10000){
while(now.valueOf()==_157e){
now=new Date();
}
}
}else{
_157e=now.valueOf();
_157f=1;
}
var _15a1=_15a0[2].toString(_1582);
var _15a2=_15a0[3].toString(_1582);
var _15a3=_padWithLeadingZeros(_15a1,4)+_padWithLeadingZeros(_15a2,4);
var _15a4=_15a0[1].toString(_1582);
_15a4=_padWithLeadingZeros(_15a4,4);
var _15a5=_15a0[0].toString(_1582);
_15a5=_padWithLeadingZeros(_15a5,3);
var _15a6="-";
var _15a7="1";
var _15a8=_15a3+_15a6+_15a4+_15a6+_15a7+_15a5+_15a6+_157d+_15a6+node;
_15a8=_15a8.toLowerCase();
return _15a8;
};
}();
}
if(!dojo._hasResource["tagservices.skins"]){
dojo._hasResource["tagservices.skins"]=true;
dojo.provide("tagservices.skins");
dojo.declare("tagservices.skins",null,{skinIdPrefix:"mm_ibm_skin_",allSkins:[],allVars:[],tempSkinHtmlObj:null,tempSkinJsObj:null,isProcessing:0,waitingList:[],subscribeHandler:null,skinAttachEvent:"/skinservice/attachEnd",LOGGER:com.ibm.mashups.enabler.logging.Logger.getLogger("tagservices.skins"),processTag:function(tag){
this.tempSkinHtmlObj=new Object();
this.tempSkinJsObj=new Object();
if(tag==null){
return;
}
var _15aa=tag.getAttribute("skin");
this._getSkinTemplate(_15aa,tag);
},unprocessTag:function(tag){
var _15ac=this._findSkinNode(tag);
var _15ad=_15ac.parentNode;
_15ad.insertBefore(tag,_15ac);
com.ibm.mm.enabler.dom.destroyNode(_15ac);
},_findSkinNode:function(node){
var _15af=node;
while(_15af&&_15af.id!=this.skinIdPrefix+node.id){
_15af=_15af.parentNode;
}
return _15af;
},_getSkinTemplate:function(_15b0,tag){
var aSkin=this.allSkins[_15b0];
if(aSkin==null){
var _15b3=this;
var _15b4=this._getSkinResourceUrl(_15b0,"skin.html");
var _15b5=this._getSkinResourceUrl(_15b0,"skin.js");
dojo.xhrGet({url:_15b4,handleAs:"text",sync:true,load:function(_15b6){
dojo.xhrGet({url:_15b5,handleAs:"json",sync:true,load:function(_15b7){
_15b6=_15b6.replace(/<!--.*-->\s*/,"");
_15b3.allSkins[_15b0]=_15b6;
_15b3.allVars[_15b0]=_15b7;
_15b3.startAttatchSkin(_15b0,tag);
},error:function(data){
_15b3.allSkins[_15b0]=_15b6;
_15b3.startAttatchSkin(_15b0,tag);
}});
},error:function(data){
this.LOGGER.severe("_getSkinTemplate",dojo.string.substitute(com.ibm.mm.builder.coreWidgetsMessages.E_SKIN_LOAD_TEMPLATE_FAIL_1,[data]));
}});
}else{
this.startAttatchSkin(_15b0,tag);
}
},startAttatchSkin:function(_15ba,tag){
if(this.isProcessing==0){
this.executeReplaceSkin(_15ba,tag);
}else{
this.addToWaitingList(_15ba,tag);
}
},chooseNext:function(){
if(this.waitingList.length!=0){
var _15bc=this.waitingList.pop();
this.executeReplaceSkin(_15bc.skin,_15bc.tag);
}
},addToWaitingList:function(_15bd,tag){
if(this.subscribeHandler==null){
this.subscribeHandler=dojo.subscribe(this.skinAttachEvent,this,"chooseNext");
}
var _15bf=new Object();
_15bf.skin=_15bd;
_15bf.tag=tag;
this.waitingList.push(_15bf);
},executeReplaceSkin:function(_15c0,tag){
this.isProcessing=1;
var temp=this.allSkins[_15c0];
if(temp!=null){
var _15c3=this._getNodeToReplace(tag);
var _15c4=_15c3.parentNode;
var anId=dojox.uuid.generateTimeBasedUuid().replace(/\-/g,"");
var args=this._getArgs(_15c0,tag,anId);
if(args==null){
this.LOGGER.severe("executeReplaceSkin",com.ibm.mm.builder.coreWidgetsMessages.E_SKIN_NOT_EXIST_0);
return;
}
var _15c7=this._getSkinResourceUrl(_15c0,"skin.css");
com.ibm.mm.builder.utils.htmlUtil.loadCss(_15c7);
if(builderConfig.isBidi){
var _15c8=this._getSkinResourceUrl(_15c0,"skin_rtl.css");
com.ibm.mm.builder.utils.htmlUtil.loadCss(_15c8);
}
var _15c9=dojo.string.substitute(temp,args);
_15c9=_15c9.replace(/\/>/g,"></div>");
var _15ca=this._getNodeFromMarkup(_15c9);
dojo.addClass(_15ca,"mumWidgetTitleBar");
_15c4.replaceChild(_15ca,_15c3);
var tNode=dojo.byId(anId);
tNode.parentNode.replaceChild(tag,tNode);
if(!dojo.hasClass(_15c3,"mm_iWidget")){
dojo._destroyElement(_15c3);
}
var para=new Object();
para.widgetId=tag.id;
para.skinNodeId=_15ca.id;
para.skinParam=args;
com.ibm.mashups.services.ServiceManager.getService("eventService").broadcastEvent("com.ibm.mashups.builder.skinLoaded",para);
}
this.isProcessing=0;
dojo.publish(this.skinAttachEvent,[null]);
},_getSkinResourceUrl:function(_15cd,_15ce){
try{
var _15cf=com.ibm.mm.builder.utils.skinUtil._getSkinModel();
var skin=com.ibm.mm.builder.utils.skinUtil.getSkinNode(_15cd)||com.ibm.mm.builder.utils.skinUtil.getDefaultSkin();
var url=_15cf.findResourceUrl(skin,_15ce);
return url;
}
catch(ex){
this.LOGGER.severe("_getSkinResourceUrl",dojo.string.substitute(com.ibm.mm.builder.coreWidgetsMessages.E_SKIN_LOAD_ROOT_FAIL_1,[ex.message]));
}
return null;
},_getArgs:function(_15d2,tag,anId){
var args={};
var _15d6=this.allVars[_15d2];
if(_15d6!=null){
dojo.mixin(args,_15d6);
}
args.widgetBody="<div id='"+anId+"'/>";
args.skinId=this.skinIdPrefix+tag.id;
if(args.process=="undefined"||args.process==null){
args.process=function(_15d7,tagId){
};
}
args.process(_15d2,tag.id);
return args;
},_getNodeMarkup:function(tag){
var _15da=document.createElement("div");
_15da.appendChild(tag.cloneNode(true));
var _15db=_15da.innerHTML;
_15da.removeChild(_15da.firstChild);
return _15db;
},_getNodeFromMarkup:function(_15dc){
var _15dd=document.createElement("div");
_15dd.innerHTML=_15dc;
return _15dd.removeChild(_15dd.firstChild);
},_getNodeToReplace:function(tag){
var node=dojo.byId(this.skinIdPrefix+tag.id);
if(node==null){
node=tag;
}
return node;
},_showParent:function(node){
var _15e1=node.parentNode;
while(_15e1!=null){
_15e1=_15e1.parentNode;
}
}});
}
if(!dojo._hasResource["com.ibm.mm.livetext.serviceImpl"]){
dojo._hasResource["com.ibm.mm.livetext.serviceImpl"]=true;
dojo.provide("com.ibm.mm.livetext.serviceImpl");
dojo.declare("com.ibm.mm.livetext.serviceImpl",null,{_tagTypes:null,tagChanged:"/com/ibm/mashups/livetext/livetextchanged",unchangeTag:"/com/ibm/mashups/livetext/livetextunchange",tagStatusChange:"/com/ibm/mashups/livetext/livetextchanged",tagContentChanged:"/com/ibm/mashups/livetext/livetextcontentchanged",entryAdded:"/com/ibm/mashups/livetext/configentryadded",entryRemoved:"/com/ibm/mashups/livetext/configentryremoved",constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},init:function(){
this._loadTags();
dojo.subscribe(this.tagChanged,this,"onTagChanged");
dojo.subscribe(this.unchangeTag,this,"onUnchangeTag");
dojo.subscribe(this.tagContentChanged,this,"onTagContentChanged");
dojo.subscribe(this.entryAdded,this,"onAddConfigEntry");
dojo.subscribe(this.entryRemoved,this,"onRemoveConfigEntry");
dojo.publish(this.tagContentChanged,[document,true]);
},_getNodes:function(node,_15e3){
if(_15e3.processEnclosedTags){
var _15e4=dojo.query(_15e3.match,node);
var a=[];
_15e4.forEach(function(node,index,_15e8){
a.push(node);
});
return a;
}else{
var _15e4=dojo.query(_15e3.match+" "+_15e3.match,node);
var a=[];
_15e4.forEach(function(node,index,_15eb){
a.push(node);
});
var _15ec=dojo.query(_15e3.match,node);
var b=[];
_15ec.forEach(function(node,index,_15f0){
b.push(node);
});
var _15f1,_15f2;
while(a.length>0){
_15f1=a[0];
_15f2=0;
while(_15f2<b.length){
if(_15f1==b[_15f2]){
a.splice(0,1);
b.splice(_15f2,1);
break;
}else{
_15f2++;
}
}
}
return b;
}
},onTagChanged:function(node,_15f4,_15f5,_15f6){
var tag=null,_15f8=null,tags=null;
for(var index=0;index<this._tagTypes.length;index++){
tag=this._tagTypes[index];
this._processTypeTag(node,tag,_15f4,_15f5,_15f6,true);
}
},onUnchangeTag:function(node,_15fc,_15fd,_15fe,_15ff){
var tag=null,_1601=null,tags=null;
for(var index=0;index<this._tagTypes.length;index++){
tag=this._tagTypes[index];
this._unprocessTypeTag(node,tag,_15fc,_15fd,_15fe,false);
}
if(dojo.isFunction(_15ff)){
_15ff(node);
}
},onTagContentChanged:function(node,_1605,_1606,_1607){
var tag=null,_1609=null,tags=null;
for(var index=0;index<this._tagTypes.length;index++){
tag=this._tagTypes[index];
this._processTypeTag(node,tag,_1605,_1606,_1607,false);
}
},_processTypeTag:function(node,tag,_160e,_160f,_1610,_1611){
var tags=[];
if(_1611&&this._checkRoot(node,tag)){
tags[0]=node;
}
tags=tags.concat(this._getNodes(node,tag));
var _1613=[];
_1613=_1613.concat(tags);
if(_1613.length>0){
if(tag.loaded==null){
this._loadTagHandler(tag);
}
var _1614=[];
if(dojo.isFunction(_160f)){
try{
_160f(node,_1613);
}
catch(error){
console.debug(error);
}
}
for(var _1615=0;_1615<tags.length;_1615++){
try{
tag.tagHandler.processTag(tags[_1615]);
}
catch(error){
this.LOGGER.trace("_processTypeTag","processTag tag:"+tag.baseClass+" error:"+error.message);
_1614[_1614.length]=error;
if(_160e){
break;
}
}
}
if(dojo.isFunction(_1610)){
try{
_1610(node,_1613,_1614);
}
catch(error){
console.debug(error);
}
}
}
},_unprocessTypeTag:function(node,tag,_1618,_1619,_161a,_161b){
var tags=[];
if(_161b&&this._checkRoot(node,tag)){
tags[0]=node;
}
tags=tags.concat(this._getNodes(node,tag));
var _161d=[];
_161d=_161d.concat(tags);
var _161e=[];
if(dojo.isFunction(_1619)){
try{
_1619(node,_161d);
}
catch(error){
console.debug(error);
}
}
if(_161d.length>0){
if(tag.loaded==null){
this._loadTagHandler(tag);
}
for(var _161f=0;_161f<tags.length;_161f++){
try{
tag.tagHandler.unprocessTag(tags[_161f]);
}
catch(error){
_161e[_161e.length]=error;
if(_1618){
break;
}
}
}
}
if(dojo.isFunction(_161a)){
try{
_161a(node,_161d,_161e);
}
catch(error){
console.debug(error);
}
}
},_checkRoot:function(node,tag){
var _1622=false;
if(node!=null&&node.nodeType){
var _1623=node.cloneNode(false);
var _1624=document.createElement("div");
_1624.appendChild(_1623);
var _1625=this._getNodes(_1624,tag);
if(_1625!=null&&_1625.length>0){
_1622=true;
}
delete _1623;
delete _1624;
delete _1625;
}
return _1622;
},_loadTags:function(){
if(this._tagTypes==null){
var _1626=this;
if(typeof ibmConfig.livetextService!="undefined"){
this._tagTypes=ibmConfig.livetextService;
}else{
dojo.xhrGet({url:dojo.moduleUrl("com.ibm.mm.livetext","tagservice.entries.cfg"),handleAs:"text",sync:true,load:function(_1627){
_1626._tagTypes=dojo.fromJson(_1627);
},error:function(data){
console.dir(data);
}});
}
}
},onAddConfigEntry:function(entry){
},onRemoveConfigEntry:function(entry){
},parseDom:function(_162b,node){
dojo.publish(this.tagChanged,[node]);
},_loadTagHandler:function(tag){
dojo.registerModulePath(tag.module,tag.path);
dojo.eval("dojo.r"+"equire('"+tag.baseClass+"')");
var _162e="{create:function(){return new "+tag.baseClass+"()}}";
var _162f=dojo.fromJson(_162e);
tag.tagHandler=_162f.create();
tag.loaded=true;
}});
}
if(!dojo._hasResource["tagservices.widgets"]){
dojo._hasResource["tagservices.widgets"]=true;
dojo.provide("tagservices.widgets");
dojo.declare("tagservices.widgets",null,{constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
this.bIsLoggable=this.LOGGER.isLoggable(this.LOG_LEVEL);
},processTag:function(tag){
var id=tag.getAttribute("id");
var _1632=tag.getAttribute("lazyLoad");
this.LOGGER.trace("processTag","widgets:process IWidget:"+id+"lazyLoad:"+_1632);
if(typeof (id)!="undefined"){
var _1633=iWidgetContainer.find(id);
if(_1633===null){
_1633=iWidgetContainer.createWidget(tag);
}else{
iWidgetContainer.updateWidget(tag);
}
if(_1633){
if(!_1632||(_1632&&_1632!="true")){
iWidgetContainer.renderWidget(_1633);
}else{
_1633.lazyLoad=true;
}
}
}
},unprocessTag:function(tag){
var ns="mm_";
var _1636=dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwContent,tag);
for(var i=0;i<_1636.length;i++){
com.ibm.mm.enabler.dom.destroyNode(_1636[i]);
}
}});
}
if(!dojo._hasResource["com.ibm.mashups.data.Util"]){
dojo._hasResource["com.ibm.mashups.data.Util"]=true;
dojo.provide("com.ibm.mashups.data.Util");
dojo.declare("com.ibm.mashups.data.Util",null,{encodeCSVCell:function(cell){
cell=""+cell;
var _1639=cell.replace(/"/g,"\"\"");
if(_1639.indexOf(",")>=0||_1639.indexOf("\"")>=0){
_1639="\""+_1639+"\"";
}
_1639=_1639.replace(/\n/g,"");
return _1639;
},JSONObject2CSV:function(json){
if(!dojo.isArray(json)){
json=[json];
}
var _163b="",_163c="";
var _163d=true;
for(var i=0;i<json.length;i++){
_163d=true;
for(var key in json[i]){
if(key){
if(i==0){
if(!_163d){
_163b+=",";
}
_163b+=this.encodeCSVCell(key);
}
if(!_163d){
_163c+=",";
}
_163c+=this.encodeCSVCell(json[i][key]);
}
_163d=false;
}
if(i==0){
_163b+="\n";
}
_163c+="\n";
}
return _163b+_163c;
},JSONObject2Table:function(json){
var csv=this.JSONObject2CSV(json);
var table=new com.ibm.mm.data.table({data:csv});
return table;
}});
com.ibm.mashups.data.Util=new com.ibm.mashups.data.Util();
}
if(!dojo._hasResource["com.ibm.mm.data.exception"]){
dojo._hasResource["com.ibm.mm.data.exception"]=true;
dojo.provide("com.ibm.mm.data.exception");
dojo.declare("com.ibm.mm.data.exception",null,{_exceptionId:null,_variable:null,constructor:function(_1643,_1644){
this._exceptionId=_1643;
this._variable=_1644;
},getMessage:function(_1645){
return "Not implemented";
}});
}
if(!dojo._hasResource["com.ibm.mm.data.datatypes"]){
dojo._hasResource["com.ibm.mm.data.datatypes"]=true;
dojo.provide("com.ibm.mm.data.datatypes");
dojo.declare("com.ibm.mm.data.datatypes",null,{_alltypes:{"text":1,"url":1,"html":1,"image":1,"number":1,"countrycode":1,"languagecode":1,"currency":1,"boolean":1,"date":1,"time":1,"timestamp":1,"email":1,"postalcode":1,"phone":1,"address":1,"person":1,"table":1,"atom":1,"xml":1,"json":1,"modeldata":1},_simpleTypes:{"text":1,"url":1,"html":1,"image":1,"number":1,"countrycode":1,"languagecode":1,"currency":1,"boolean":1,"date":1,"time":1,"timestamp":1,"email":1,"postalcode":1,"phone":1,"address":1,"person":1},_complexTypes:{"table":1,"atom":1,"xml":1,"json":1,"modeldata":1},specialTypes:{"mashupdata":1},_mappings:{text:{"url":1,"html":1,"number":1,"countrycode":1,"languagecode":1,"currency":1,"boolean":1,"date":1,"time":1,"timestamp":1,"email":1,"postalcode":1,"phone":1,"address":1,"person":1},"url":{},"html":{},"image":{},"number":{},"countrycode":{},"languagecode":{},"currency":{},"boolean":{},"date":{"timestamp":1},"time":{"timestamp":1},"timestamp":{"date":1,"time":1},"email":{},"postalcode":{},"phone":{},"address":{},"person":{},"json":{}},_SIMPLE_DATA_TYPE:1,_COMBINED_DATA_TYPE:2,_COMPLEX_DATA_TYPE:3,resourceBundle:null,constructor:function(_1646){
this.resourceBundle=dojo.i18n.getLocalization("com.ibm.mm.data","dataTypeStrings");
},addDataType:function(_1647,_1648){
if(_1647===null||typeof _1647==undefined){
return;
}
this._alltypes.typename=1;
if(_1648===null||typeof _1648==undefined||_1648==this._SIMPLE_DATA_TYPE){
this._simpleTypes.typename=1;
}else{
hthis._complexTypes.typename=1;
}
},removeDataType:function(_1649){
delete this._alltypes[_1649];
},addDataMapping:function(_164a,_164b){
if(this._mappings.typename1===null){
this._mappings.typename1={};
}
this._mappings[_164a][_164b]=1;
},removeDataMapping:function(_164c,_164d){
if(this._mappings[_164c]!==null){
if(this._mappings[_164c][_164d]!==null){
delete this._mappings[_164c][_164d];
}
}
},getAllTypes:function(){
return dojo.clone(this._alltypes);
},doesTypeMatch:function(_164e,_164f){
var _1650=false;
if(_164e===null||_164f===null){
return _1650;
}
_164e=_164e.toLowerCase();
_164f=_164f.toLowerCase();
if(_164e==_164f||_164e=="any"||_164f=="any"){
_1650=true;
}else{
var _1651=this.checkDataType(_164e);
switch(_1651){
case this._SIMPLE_DATA_TYPE:
var _1652=this.checkDataType(_164f);
switch(_1652){
case this._SIMPLE_DATA_TYPE:
if(this._mappings[_164e][_164f]==1){
_1650=true;
}
break;
case this._COMBINED_DATA_TYPE:
var _1653=this.getMainType(_164f);
if(_164e==_1653||this._mappings[_164e][_1653]==1){
_1650=true;
}
break;
default:
break;
}
break;
case this._COMBINED_DATA_TYPE:
case this._COMPLEX_DATA_TYPE:
default:
break;
}
}
return _1650;
},doesTypeFlexMatch:function(_1654,_1655){
var _1656=false;
if(_1654===null||_1655===null){
return _1656;
}
_1654=_1654.toLowerCase();
_1655=_1655.toLowerCase();
if(_1654==_1655||_1654=="any"||_1655=="any"){
_1656=true;
}else{
var _1657=this.checkDataType(_1654);
switch(_1657){
case this._SIMPLE_DATA_TYPE:
var _1658=this.checkDataType(_1655);
switch(_1658){
case this._SIMPLE_DATA_TYPE:
if(this._mappings[_1654][_1655]==1){
_1656=true;
}
break;
case this._COMBINED_DATA_TYPE:
var _1659=this.getMainType(_1655);
if(_1654==_1659||this._mappings[_1654][_1659]==1){
_1656=true;
}
break;
default:
break;
}
break;
case this._COMBINED_DATA_TYPE:
var _1658=this.checkDataType(_1655);
var _165a=this.getMainType(_1654);
switch(_1658){
case this._SIMPLE_DATA_TYPE:
if(_165a==_1655||this._mappings[_165a][_1655]==1){
_1656=true;
}
break;
case this._COMBINED_DATA_TYPE:
var _1659=this.getMainType(_1655);
if(_165a==_1659||this._mappings[_165a][_1659]==1){
_1656=true;
}
break;
default:
break;
}
case this._COMPLEX_DATA_TYPE:
default:
break;
}
}
return _1656;
},getMainType:function(_165b){
var _165c=_165b.indexOf(".");
if(_165c<0){
return _165b;
}else{
return _165b.substring(0,_165c);
}
},checkDataType:function(_165d){
var _165d=_165d.toLowerCase();
var types=_165d.split(".");
if(types.length==1){
if(this._simpleTypes[_165d]==1){
return this._SIMPLE_DATA_TYPE;
}else{
return this._COMPLEX_DATA_TYPE;
}
}else{
if(types.length==2||types.length==3){
var _165f=types[0];
var _1660=types[types.length-1];
if(_165f=="url"||_1660=="languagecode"||_1660=="countrycode"){
return this._COMBINED_DATA_TYPE;
}else{
return this._COMPLEX_DATA_TYPE;
}
}else{
return this._COMPLEX_DATA_TYPE;
}
}
},getTypeLabel:function(_1661,_1662){
var _1661=_1661.toLowerCase();
var _1663=_1661;
var _1664=this.checkDataType(_1661);
if(_1664==this._COMBINED_DATA_TYPE){
var _1665=_1661.indexOf(".");
var main=_1661.substring(0,_1665);
var _1667=this.getSimpleTypeLabel(main,_1662);
var sub=_1661.substring(_1665+1,_1661.length);
var _1669=this.getSimpleTypeLabel(sub,_1662);
_1663=_1667+" ("+_1669+")";
}else{
_1663=this.getSimpleTypeLabel(_1661,_1662);
}
return _1663;
},getSimpleTypeLabel:function(_166a,_166b){
var label;
if(this.resourceBundle[_166a]!=null){
label=this.resourceBundle[_166a];
}else{
label=_166a.charAt(0).toUpperCase()+_166a.substring(1);
}
return label;
}});
}
if(!dojo._hasResource["dojo.data.util.filter"]){
dojo._hasResource["dojo.data.util.filter"]=true;
dojo.provide("dojo.data.util.filter");
dojo.data.util.filter.patternToRegExp=function(_166d,_166e){
var rxp="^";
var c=null;
for(var i=0;i<_166d.length;i++){
c=_166d.charAt(i);
switch(c){
case "\\":
rxp+=c;
i++;
rxp+=_166d.charAt(i);
break;
case "*":
rxp+=".*";
break;
case "?":
rxp+=".";
break;
case "$":
case "^":
case "/":
case "+":
case ".":
case "|":
case "(":
case ")":
case "{":
case "}":
case "[":
case "]":
rxp+="\\";
default:
rxp+=c;
}
}
rxp+="$";
if(_166e){
return new RegExp(rxp,"mi");
}else{
return new RegExp(rxp,"m");
}
};
}
if(!dojo._hasResource["dojo.data.util.sorter"]){
dojo._hasResource["dojo.data.util.sorter"]=true;
dojo.provide("dojo.data.util.sorter");
dojo.data.util.sorter.basicComparator=function(a,b){
var r=-1;
if(a===null){
a=undefined;
}
if(b===null){
b=undefined;
}
if(a==b){
r=0;
}else{
if(a>b||a==null){
r=1;
}
}
return r;
};
dojo.data.util.sorter.createSortFunction=function(_1675,store){
var _1677=[];
function createSortFunction(attr,dir){
return function(itemA,itemB){
var a=store.getValue(itemA,attr);
var b=store.getValue(itemB,attr);
var _167e=null;
if(store.comparatorMap){
if(typeof attr!=="string"){
attr=store.getIdentity(attr);
}
_167e=store.comparatorMap[attr]||dojo.data.util.sorter.basicComparator;
}
_167e=_167e||dojo.data.util.sorter.basicComparator;
return dir*_167e(a,b);
};
};
var _167f;
for(var i=0;i<_1675.length;i++){
_167f=_1675[i];
if(_167f.attribute){
var _1681=(_167f.descending)?-1:1;
_1677.push(createSortFunction(_167f.attribute,_1681));
}
}
return function(rowA,rowB){
var i=0;
while(i<_1677.length){
var ret=_1677[i++](rowA,rowB);
if(ret!==0){
return ret;
}
}
return 0;
};
};
}
if(!dojo._hasResource["dojo.data.util.simpleFetch"]){
dojo._hasResource["dojo.data.util.simpleFetch"]=true;
dojo.provide("dojo.data.util.simpleFetch");
dojo.data.util.simpleFetch.fetch=function(_1686){
_1686=_1686||{};
if(!_1686.store){
_1686.store=this;
}
var self=this;
var _1688=function(_1689,_168a){
if(_168a.onError){
var scope=_168a.scope||dojo.global;
_168a.onError.call(scope,_1689,_168a);
}
};
var _168c=function(items,_168e){
var _168f=_168e.abort||null;
var _1690=false;
var _1691=_168e.start?_168e.start:0;
var _1692=(_168e.count&&(_168e.count!==Infinity))?(_1691+_168e.count):items.length;
_168e.abort=function(){
_1690=true;
if(_168f){
_168f.call(_168e);
}
};
var scope=_168e.scope||dojo.global;
if(!_168e.store){
_168e.store=self;
}
if(_168e.onBegin){
_168e.onBegin.call(scope,items.length,_168e);
}
if(_168e.sort){
items.sort(dojo.data.util.sorter.createSortFunction(_168e.sort,self));
}
if(_168e.onItem){
for(var i=_1691;(i<items.length)&&(i<_1692);++i){
var item=items[i];
if(!_1690){
_168e.onItem.call(scope,item,_168e);
}
}
}
if(_168e.onComplete&&!_1690){
var _1696=null;
if(!_168e.onItem){
_1696=items.slice(_1691,_1692);
}
_168e.onComplete.call(scope,_1696,_168e);
}
};
this._fetchItems(_1686,_168c,_1688);
return _1686;
};
}
if(!dojo._hasResource["dojox.data.CsvStore"]){
dojo._hasResource["dojox.data.CsvStore"]=true;
dojo.provide("dojox.data.CsvStore");
dojo.declare("dojox.data.CsvStore",null,{constructor:function(_1697){
this._attributes=[];
this._attributeIndexes={};
this._dataArray=[];
this._arrayOfAllItems=[];
this._loadFinished=false;
if(_1697.url){
this.url=_1697.url;
}
this._csvData=_1697.data;
if(_1697.label){
this.label=_1697.label;
}else{
if(this.label===""){
this.label=undefined;
}
}
this._storeProp="_csvStore";
this._idProp="_csvId";
this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};
this._loadInProgress=false;
this._queuedFetches=[];
this.identifier=_1697.identifier;
if(this.identifier===""){
delete this.identifier;
}else{
this._idMap={};
}
},url:"",label:"",identifier:"",_assertIsItem:function(item){
if(!this.isItem(item)){
throw new Error(this.declaredClass+": a function was passed an item argument that was not an item");
}
},_assertIsAttribute:function(_1699){
if(!dojo.isString(_1699)){
throw new Error(this.declaredClass+": a function was passed an attribute argument that was not an attribute object nor an attribute name string");
}
},_getIndex:function(item){
var idx=this.getIdentity(item);
if(this.identifier){
idx=this._idMap[idx];
}
return idx;
},getValue:function(item,_169d,_169e){
this._assertIsItem(item);
this._assertIsAttribute(_169d);
var _169f=_169e;
if(this.hasAttribute(item,_169d)){
var _16a0=this._dataArray[this._getIndex(item)];
_169f=_16a0[this._attributeIndexes[_169d]];
}
return _169f;
},getValues:function(item,_16a2){
var value=this.getValue(item,_16a2);
return (value?[value]:[]);
},getAttributes:function(item){
this._assertIsItem(item);
var _16a5=[];
var _16a6=this._dataArray[this._getIndex(item)];
for(var i=0;i<_16a6.length;i++){
if(_16a6[i]!==""){
_16a5.push(this._attributes[i]);
}
}
return _16a5;
},hasAttribute:function(item,_16a9){
this._assertIsItem(item);
this._assertIsAttribute(_16a9);
var _16aa=this._attributeIndexes[_16a9];
var _16ab=this._dataArray[this._getIndex(item)];
return (typeof _16aa!=="undefined"&&_16aa<_16ab.length&&_16ab[_16aa]!=="");
},containsValue:function(item,_16ad,value){
var _16af=undefined;
if(typeof value==="string"){
_16af=dojo.data.util.filter.patternToRegExp(value,false);
}
return this._containsValue(item,_16ad,value,_16af);
},_containsValue:function(item,_16b1,value,_16b3){
var _16b4=this.getValues(item,_16b1);
for(var i=0;i<_16b4.length;++i){
var _16b6=_16b4[i];
if(typeof _16b6==="string"&&_16b3){
return (_16b6.match(_16b3)!==null);
}else{
if(value===_16b6){
return true;
}
}
}
return false;
},isItem:function(_16b7){
if(_16b7&&_16b7[this._storeProp]===this){
var _16b8=_16b7[this._idProp];
if(this.identifier){
var data=this._dataArray[this._idMap[_16b8]];
if(data){
return true;
}
}else{
if(_16b8>=0&&_16b8<this._dataArray.length){
return true;
}
}
}
return false;
},isItemLoaded:function(_16ba){
return this.isItem(_16ba);
},loadItem:function(item){
},getFeatures:function(){
return this._features;
},getLabel:function(item){
if(this.label&&this.isItem(item)){
return this.getValue(item,this.label);
}
return undefined;
},getLabelAttributes:function(item){
if(this.label){
return [this.label];
}
return null;
},_fetchItems:function(_16be,_16bf,_16c0){
var self=this;
var _16c2=function(_16c3,_16c4){
var items=null;
if(_16c3.query){
var key,value;
items=[];
var _16c8=_16c3.queryOptions?_16c3.queryOptions.ignoreCase:false;
var _16c9={};
for(key in _16c3.query){
value=_16c3.query[key];
if(typeof value==="string"){
_16c9[key]=dojo.data.util.filter.patternToRegExp(value,_16c8);
}
}
for(var i=0;i<_16c4.length;++i){
var match=true;
var _16cc=_16c4[i];
for(key in _16c3.query){
value=_16c3.query[key];
if(!self._containsValue(_16cc,key,value,_16c9[key])){
match=false;
}
}
if(match){
items.push(_16cc);
}
}
}else{
if(_16c4.length>0){
items=_16c4.slice(0,_16c4.length);
}
}
_16bf(items,_16c3);
};
if(this._loadFinished){
_16c2(_16be,this._arrayOfAllItems);
}else{
if(this.url!==""){
if(this._loadInProgress){
this._queuedFetches.push({args:_16be,filter:_16c2});
}else{
this._loadInProgress=true;
var _16cd={url:self.url,handleAs:"text"};
var _16ce=dojo.xhrGet(_16cd);
_16ce.addCallback(function(data){
try{
self._processData(data);
_16c2(_16be,self._arrayOfAllItems);
self._handleQueuedFetches();
}
catch(e){
_16c0(e,_16be);
}
});
_16ce.addErrback(function(error){
self._loadInProgress=false;
if(_16c0){
_16c0(error,_16be);
}else{
throw error;
}
});
}
}else{
if(this._csvData){
try{
this._processData(this._csvData);
this._csvData=null;
_16c2(_16be,this._arrayOfAllItems);
}
catch(e){
_16c0(e,_16be);
}
}else{
var error=new Error(this.declaredClass+": No CSV source data was provided as either URL or String data input.");
if(_16c0){
_16c0(error,_16be);
}else{
throw error;
}
}
}
}
},close:function(_16d2){
},_getArrayOfArraysFromCsvFileContents:function(_16d3){
if(dojo.isString(_16d3)){
var _16d4=new RegExp("\r\n|\n|\r");
var _16d5=new RegExp("^\\s+","g");
var _16d6=new RegExp("\\s+$","g");
var _16d7=new RegExp("\"\"","g");
var _16d8=[];
var i;
var _16da=this._splitLines(_16d3);
for(i=0;i<_16da.length;++i){
var _16db=_16da[i];
if(_16db.length>0){
var _16dc=_16db.split(",");
var j=0;
while(j<_16dc.length){
var _16de=_16dc[j];
var _16df=_16de.replace(_16d5,"");
var field=_16df.replace(_16d6,"");
var _16e1=field.charAt(0);
var _16e2=field.charAt(field.length-1);
var _16e3=field.charAt(field.length-2);
var _16e4=field.charAt(field.length-3);
if(field.length===2&&field=="\"\""){
_16dc[j]="";
}else{
if((_16e1=="\"")&&((_16e2!="\"")||((_16e2=="\"")&&(_16e3=="\"")&&(_16e4!="\"")))){
if(j+1===_16dc.length){
return null;
}
var _16e5=_16dc[j+1];
_16dc[j]=_16df+","+_16e5;
_16dc.splice(j+1,1);
}else{
if((_16e1=="\"")&&(_16e2=="\"")){
field=field.slice(1,(field.length-1));
field=field.replace(_16d7,"\"");
}
_16dc[j]=field;
j+=1;
}
}
}
_16d8.push(_16dc);
}
}
this._attributes=_16d8.shift();
for(i=0;i<this._attributes.length;i++){
this._attributeIndexes[this._attributes[i]]=i;
}
this._dataArray=_16d8;
}
},_splitLines:function(_16e6){
var split=[];
var i;
var line="";
var _16ea=false;
for(i=0;i<_16e6.length;i++){
var c=_16e6.charAt(i);
switch(c){
case "\"":
_16ea=!_16ea;
line+=c;
break;
case "\r":
if(_16ea){
line+=c;
}else{
split.push(line);
line="";
if(i<(_16e6.length-1)&&_16e6.charAt(i+1)=="\n"){
i++;
}
}
break;
case "\n":
if(_16ea){
line+=c;
}else{
split.push(line);
line="";
}
break;
default:
line+=c;
}
}
if(line!==""){
split.push(line);
}
return split;
},_processData:function(data){
this._getArrayOfArraysFromCsvFileContents(data);
this._arrayOfAllItems=[];
if(this.identifier){
if(this._attributeIndexes[this.identifier]===undefined){
throw new Error(this.declaredClass+": Identity specified is not a column header in the data set.");
}
}
for(var i=0;i<this._dataArray.length;i++){
var id=i;
if(this.identifier){
var iData=this._dataArray[i];
id=iData[this._attributeIndexes[this.identifier]];
this._idMap[id]=i;
}
this._arrayOfAllItems.push(this._createItemFromIdentity(id));
}
this._loadFinished=true;
this._loadInProgress=false;
},_createItemFromIdentity:function(_16f0){
var item={};
item[this._storeProp]=this;
item[this._idProp]=_16f0;
return item;
},getIdentity:function(item){
if(this.isItem(item)){
return item[this._idProp];
}
return null;
},fetchItemByIdentity:function(_16f3){
var item;
var scope=_16f3.scope?_16f3.scope:dojo.global;
if(!this._loadFinished){
var self=this;
if(this.url!==""){
if(this._loadInProgress){
this._queuedFetches.push({args:_16f3});
}else{
this._loadInProgress=true;
var _16f7={url:self.url,handleAs:"text"};
var _16f8=dojo.xhrGet(_16f7);
_16f8.addCallback(function(data){
try{
self._processData(data);
var item=self._createItemFromIdentity(_16f3.identity);
if(!self.isItem(item)){
item=null;
}
if(_16f3.onItem){
_16f3.onItem.call(scope,item);
}
self._handleQueuedFetches();
}
catch(error){
if(_16f3.onError){
_16f3.onError.call(scope,error);
}
}
});
_16f8.addErrback(function(error){
this._loadInProgress=false;
if(_16f3.onError){
_16f3.onError.call(scope,error);
}
});
}
}else{
if(this._csvData){
try{
self._processData(self._csvData);
self._csvData=null;
item=self._createItemFromIdentity(_16f3.identity);
if(!self.isItem(item)){
item=null;
}
if(_16f3.onItem){
_16f3.onItem.call(scope,item);
}
}
catch(e){
if(_16f3.onError){
_16f3.onError.call(scope,e);
}
}
}
}
}else{
item=this._createItemFromIdentity(_16f3.identity);
if(!this.isItem(item)){
item=null;
}
if(_16f3.onItem){
_16f3.onItem.call(scope,item);
}
}
},getIdentityAttributes:function(item){
if(this.identifier){
return [this.identifier];
}else{
return null;
}
},_handleQueuedFetches:function(){
if(this._queuedFetches.length>0){
for(var i=0;i<this._queuedFetches.length;i++){
var fData=this._queuedFetches[i];
var _16ff=fData.filter;
var _1700=fData.args;
if(_16ff){
_16ff(_1700,this._arrayOfAllItems);
}else{
this.fetchItemByIdentity(fData.args);
}
}
this._queuedFetches=[];
}
}});
dojo.extend(dojox.data.CsvStore,dojo.data.util.simpleFetch);
}
if(!dojo._hasResource["com.ibm.mm.data.table"]){
dojo._hasResource["com.ibm.mm.data.table"]=true;
dojo.provide("com.ibm.mm.data.table");
dojo.declare("com.ibm.mm.data.table",dojox.data.CsvStore,{constructor:function(_1701){
if(this._isCSVLike(_1701["data"])){
_1701["data"]=this._CSVLike2CSV(_1701["data"]);
}
this._attributes=[];
this._attributeIndexes={};
this._dataArray=[];
this._arrayOfAllItems=[];
this._loadFinished=false;
if(_1701.url){
this.url=_1701.url;
}
this._csvData=_1701.data;
if(_1701.label){
this.label=_1701.label;
}else{
if(this.label===""){
this.label=undefined;
}
}
this._storeProp="_csvStore";
this._idProp="_csvId";
this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};
this._loadInProgress=false;
this._queuedFetches=[];
},_isCSVLike:function(_1702){
var data=dojo.clone(_1702);
if(dojo.isString(data)&&data!=null&&data.length>0){
data=data.replace(/\n/g,"");
var rows=data.split("|");
if(!rows||rows.length<2){
return false;
}
var _1705=this._splitterCSVLikeRow(rows[0]);
if(!_1705||_1705.length<=0){
return false;
}
var _1706=_1705.length;
for(var i=1;i<rows.length;i++){
if(rows[i]==""){
break;
}
var _1708=this._splitterCSVLikeRow(rows[i]);
if(!_1708||_1708.length!=_1706){
return false;
}
}
return true;
}
return false;
},_splitterCSVLikeRow:function(_1709){
var cells=_1709.split(",");
var len=cells.length;
var i,j;
for(var m=0;m<len;m++){
i=j=-1;
for(var k=0;k<cells.length;k++){
if(i==-1&&cells[k].charAt(0)=="\""&&cells[k].charAt(cells[k].length-1)!="\""){
i=k;
continue;
}
if(i>0&&cells[k].charAt(cells[k].length-1)=="\""&&cells[k].charAt(0)!="\""){
j=k;
break;
}
}
if(i>0&&j>0){
var str=cells[i];
for(var k=i+1;k<j+1;k++){
str=str+","+cells[k];
}
var temp=[];
for(var k=0;k<i;k++){
temp.push(cells[k]);
}
temp.push(str);
for(var k=j+1;k<cells.length;k++){
temp.push(cells[k]);
}
cells=temp;
}else{
break;
}
}
return cells;
},_CSVLike2CSV:function(_1712){
var _1713=["string"];
function _inArray(item,_1715){
for(var i=0;i<_1715.length;i++){
if(item.toUpperCase()==_1715[i].toUpperCase()){
return true;
}
}
return false;
};
function _addTypeInfo(_1717,_1718){
if(!_1718){
_1718=[];
for(var i=0;i<_1717.length;i++){
_1718.push("text");
}
}
if(_1717.length!=_1718.length){
throw ("Illegal CSV like data");
}
for(var i=0;i<_1717.length;i++){
_1717[i]=_1717[i]+"<"+_1718[i]+">";
}
return _1717;
};
var data=dojo.clone(_1712);
if(dojo.isString(data)&&data!=null&&data.length>0){
data=data.replace(/\n/g,"");
var rows=data.split("|");
var csv=[];
if(rows.length>=2){
var _171d=this._splitterCSVLikeRow(rows[0]);
var _171e=this._splitterCSVLikeRow(rows[1]);
var _171f=true;
for(var i=0;i<_171e.length;i++){
if(!_inArray(_171e[i],_1713)){
_171f=false;
break;
}
}
if(_171f){
_171d=_addTypeInfo(_171d,_171e);
csv.push(_171d.join(","));
for(var i=2;i<rows.length;i++){
csv.push(rows[i]);
}
}else{
_171d=_addTypeInfo(_171d,null);
csv.push(_171d.join(","));
for(var i=1;i<rows.length;i++){
csv.push(rows[i]);
}
}
}else{
var _171d=this._splitterCSVLikeRow(rows[0]);
_171d=_addTypeInfo(_171d,null);
csv.push(_171d.join(","));
}
return csv.join("\n");
}else{
throw ("Illegal CSV like data");
}
},_processData:function(data){
this._getArrayOfArraysFromCsvFileContents(data);
this._processAttributeTypes();
this._arrayOfAllItems=[];
for(var i=0;i<this._dataArray.length;i++){
this._arrayOfAllItems.push(this._createItemFromIdentity(i));
}
this._loadFinished=true;
this._loadInProgress=false;
},_processAttributeTypes:function(){
var _1723=[];
this._attributeTypes={};
var _1724,_1725,_1726;
var myRE=/^(\w|\s)+<(\w|(.\w)+)+>$/;
for(index=0;index<this._attributes.length;index++){
_1724=this._attributes[index];
if(_1724.match(myRE)){
_1725=_1724.indexOf("<");
_1726=_1724.substring(0,_1725);
_1723[_1723.length]=_1726;
this._attributeTypes[_1726]=_1724.substring(_1725+1,_1724.length-1);
this._attributeIndexes[_1726]=this._attributeIndexes[_1724];
delete this._attributeIndexes[_1724];
}else{
_1723[_1723.length]=_1724;
this._attributeTypes[_1724]="text";
}
}
this._attributes=_1723;
},getValueType:function(item,_1729){
return this._attributeTypes[_1729];
},toJson:function(){
var obj=new Object();
obj.className=this.declaredClass;
var json=new Object();
json.data=this._csvData;
obj.json=dojo.toJson(json);
return dojo.toJson(obj);
},serialize:function(){
var _172c="";
var _172d,_172e,_172f;
for(index=0;index<this._attributes.length;index++){
_172d=this._attributes[index];
_172c+=_172d+"<"+this._attributeTypes[_172d]+">,";
}
_172c+="\n";
if(this._dataArray!=null){
for(index=0;index<this._dataArray.length;index++){
_172e=this._dataArray[index];
if(_172e!=null){
for(index0=0;index0<_172e.length;index0++){
_172f=_172e[index0];
if(_172f.indexOf(",")>=0){
_172c+="\""+_172f+"\",";
}else{
_172c+=_172f+",";
}
}
_172c+="\n";
}
}
}
return _172c;
}});
}
if(!dojo._hasResource["dojox.data.XmlStore"]){
dojo._hasResource["dojox.data.XmlStore"]=true;
dojo.provide("dojox.data.XmlStore");
dojo.provide("dojox.data.XmlItem");
dojo.declare("dojox.data.XmlStore",null,{constructor:function(args){
if(args){
this.url=args.url;
this.rootItem=(args.rootItem||args.rootitem||this.rootItem);
this.keyAttribute=(args.keyAttribute||args.keyattribute||this.keyAttribute);
this._attributeMap=(args.attributeMap||args.attributemap);
this.label=args.label||this.label;
this.sendQuery=(args.sendQuery||args.sendquery||this.sendQuery);
}
this._newItems=[];
this._deletedItems=[];
this._modifiedItems=[];
},url:"",rootItem:"",keyAttribute:"",label:"",sendQuery:false,attributeMap:null,getValue:function(item,_1732,_1733){
var _1734=item.element;
var i;
var node;
if(_1732==="tagName"){
return _1734.nodeName;
}else{
if(_1732==="childNodes"){
for(i=0;i<_1734.childNodes.length;i++){
node=_1734.childNodes[i];
if(node.nodeType===1){
return this._getItem(node);
}
}
return _1733;
}else{
if(_1732==="text()"){
for(i=0;i<_1734.childNodes.length;i++){
node=_1734.childNodes[i];
if(node.nodeType===3||node.nodeType===4){
return node.nodeValue;
}
}
return _1733;
}else{
_1732=this._getAttribute(_1734.nodeName,_1732);
if(_1732.charAt(0)==="@"){
var name=_1732.substring(1);
var value=_1734.getAttribute(name);
return (value!==undefined)?value:_1733;
}else{
for(i=0;i<_1734.childNodes.length;i++){
node=_1734.childNodes[i];
if(node.nodeType===1&&node.nodeName===_1732){
return this._getItem(node);
}
}
return _1733;
}
}
}
}
},getValues:function(item,_173a){
var _173b=item.element;
var _173c=[];
var i;
var node;
if(_173a==="tagName"){
return [_173b.nodeName];
}else{
if(_173a==="childNodes"){
for(i=0;i<_173b.childNodes.length;i++){
node=_173b.childNodes[i];
if(node.nodeType===1){
_173c.push(this._getItem(node));
}
}
return _173c;
}else{
if(_173a==="text()"){
var ec=_173b.childNodes;
for(i=0;i<ec.length;i++){
node=ec[i];
if(node.nodeType===3||node.nodeType===4){
_173c.push(node.nodeValue);
}
}
return _173c;
}else{
_173a=this._getAttribute(_173b.nodeName,_173a);
if(_173a.charAt(0)==="@"){
var name=_173a.substring(1);
var value=_173b.getAttribute(name);
return (value!==undefined)?[value]:[];
}else{
for(i=0;i<_173b.childNodes.length;i++){
node=_173b.childNodes[i];
if(node.nodeType===1&&node.nodeName===_173a){
_173c.push(this._getItem(node));
}
}
return _173c;
}
}
}
}
},getAttributes:function(item){
var _1743=item.element;
var _1744=[];
var i;
_1744.push("tagName");
if(_1743.childNodes.length>0){
var names={};
var _1747=true;
var text=false;
for(i=0;i<_1743.childNodes.length;i++){
var node=_1743.childNodes[i];
if(node.nodeType===1){
var name=node.nodeName;
if(!names[name]){
_1744.push(name);
names[name]=name;
}
_1747=true;
}else{
if(node.nodeType===3){
text=true;
}
}
}
if(_1747){
_1744.push("childNodes");
}
if(text){
_1744.push("text()");
}
}
for(i=0;i<_1743.attributes.length;i++){
_1744.push("@"+_1743.attributes[i].nodeName);
}
if(this._attributeMap){
for(var key in this._attributeMap){
i=key.indexOf(".");
if(i>0){
var _174c=key.substring(0,i);
if(_174c===_1743.nodeName){
_1744.push(key.substring(i+1));
}
}else{
_1744.push(key);
}
}
}
return _1744;
},hasAttribute:function(item,_174e){
return (this.getValue(item,_174e)!==undefined);
},containsValue:function(item,_1750,value){
var _1752=this.getValues(item,_1750);
for(var i=0;i<_1752.length;i++){
if((typeof value==="string")){
if(_1752[i].toString&&_1752[i].toString()===value){
return true;
}
}else{
if(_1752[i]===value){
return true;
}
}
}
return false;
},isItem:function(_1754){
if(_1754&&_1754.element&&_1754.store&&_1754.store===this){
return true;
}
return false;
},isItemLoaded:function(_1755){
return this.isItem(_1755);
},loadItem:function(_1756){
},getFeatures:function(){
var _1757={"dojo.data.api.Read":true,"dojo.data.api.Write":true};
if(!this.sendQuery||this.keyAttribute!==""){
_1757["dojo.data.api.Identity"]=true;
}
return _1757;
},getLabel:function(item){
if((this.label!=="")&&this.isItem(item)){
var label=this.getValue(item,this.label);
if(label){
return label.toString();
}
}
return undefined;
},getLabelAttributes:function(item){
if(this.label!==""){
return [this.label];
}
return null;
},_fetchItems:function(_175b,_175c,_175d){
var url=this._getFetchUrl(_175b);
console.log("XmlStore._fetchItems(): url="+url);
if(!url){
_175d(new Error("No URL specified."));
return;
}
var _175f=(!this.sendQuery?_175b:{});
var self=this;
var _1761={url:url,handleAs:"xml",preventCache:true};
var _1762=dojo.xhrGet(_1761);
_1762.addCallback(function(data){
var items=self._getItems(data,_175f);
console.log("XmlStore._fetchItems(): length="+(items?items.length:0));
if(items&&items.length>0){
_175c(items,_175b);
}else{
_175c([],_175b);
}
});
_1762.addErrback(function(data){
_175d(data,_175b);
});
},_getFetchUrl:function(_1766){
if(!this.sendQuery){
return this.url;
}
var query=_1766.query;
if(!query){
return this.url;
}
if(dojo.isString(query)){
return this.url+query;
}
var _1768="";
for(var name in query){
var value=query[name];
if(value){
if(_1768){
_1768+="&";
}
_1768+=(name+"="+value);
}
}
if(!_1768){
return this.url;
}
var _176b=this.url;
if(_176b.indexOf("?")<0){
_176b+="?";
}else{
_176b+="&";
}
return _176b+_1768;
},_getItems:function(_176c,_176d){
var query=null;
if(_176d){
query=_176d.query;
}
var items=[];
var nodes=null;
if(this.rootItem!==""){
nodes=dojo.query(this.rootItem,_176c);
}else{
nodes=_176c.documentElement.childNodes;
}
var deep=_176d.queryOptions?_176d.queryOptions.deep:false;
if(deep){
nodes=this._flattenNodes(nodes);
}
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if(node.nodeType!=1){
continue;
}
var item=this._getItem(node);
if(query){
var found=true;
var _1776=_176d.queryOptions?_176d.queryOptions.ignoreCase:false;
var value;
var _1778={};
for(var key in query){
value=query[key];
if(typeof value==="string"){
_1778[key]=dojo.data.util.filter.patternToRegExp(value,_1776);
}
}
for(var _177a in query){
value=this.getValue(item,_177a);
if(value){
var _177b=query[_177a];
if((typeof value)==="string"&&(_1778[_177a])){
if((value.match(_1778[_177a]))!==null){
continue;
}
}else{
if((typeof value)==="object"){
if(value.toString&&(_1778[_177a])){
var _177c=value.toString();
if((_177c.match(_1778[_177a]))!==null){
continue;
}
}else{
if(_177b==="*"||_177b===value){
continue;
}
}
}
}
}
found=false;
break;
}
if(!found){
continue;
}
}
items.push(item);
}
dojo.forEach(items,function(item){
item.element.parentNode.removeChild(item.element);
},this);
return items;
},_flattenNodes:function(nodes){
var _177f=[];
if(nodes){
var i;
for(i=0;i<nodes.length;i++){
var node=nodes[i];
_177f.push(node);
if(node.childNodes&&node.childNodes.length>0){
_177f=_177f.concat(this._flattenNodes(node.childNodes));
}
}
}
return _177f;
},close:function(_1782){
},newItem:function(_1783,_1784){
console.log("XmlStore.newItem()");
_1783=(_1783||{});
var _1785=_1783.tagName;
if(!_1785){
_1785=this.rootItem;
if(_1785===""){
return null;
}
}
var _1786=this._getDocument();
var _1787=_1786.createElement(_1785);
for(var _1788 in _1783){
var text;
if(_1788==="tagName"){
continue;
}else{
if(_1788==="text()"){
text=_1786.createTextNode(_1783[_1788]);
_1787.appendChild(text);
}else{
_1788=this._getAttribute(_1785,_1788);
if(_1788.charAt(0)==="@"){
var name=_1788.substring(1);
_1787.setAttribute(name,_1783[_1788]);
}else{
var child=_1786.createElement(_1788);
text=_1786.createTextNode(_1783[_1788]);
child.appendChild(text);
_1787.appendChild(child);
}
}
}
}
var item=this._getItem(_1787);
this._newItems.push(item);
var pInfo=null;
if(_1784&&_1784.parent&&_1784.attribute){
pInfo={item:_1784.parent,attribute:_1784.attribute,oldValue:undefined};
var _178e=this.getValues(_1784.parent,_1784.attribute);
if(_178e&&_178e.length>0){
var _178f=_178e.slice(0,_178e.length);
if(_178e.length===1){
pInfo.oldValue=_178e[0];
}else{
pInfo.oldValue=_178e.slice(0,_178e.length);
}
_178f.push(item);
this.setValues(_1784.parent,_1784.attribute,_178f);
pInfo.newValue=this.getValues(_1784.parent,_1784.attribute);
}else{
this.setValues(_1784.parent,_1784.attribute,item);
pInfo.newValue=item;
}
}
return item;
},deleteItem:function(item){
console.log("XmlStore.deleteItem()");
var _1791=item.element;
if(_1791.parentNode){
this._backupItem(item);
_1791.parentNode.removeChild(_1791);
return true;
}
this._forgetItem(item);
this._deletedItems.push(item);
return true;
},setValue:function(item,_1793,value){
if(_1793==="tagName"){
return false;
}
this._backupItem(item);
var _1795=item.element;
var child;
var text;
if(_1793==="childNodes"){
child=value.element;
_1795.appendChild(child);
}else{
if(_1793==="text()"){
while(_1795.firstChild){
_1795.removeChild(_1795.firstChild);
}
text=this._getDocument(_1795).createTextNode(value);
_1795.appendChild(text);
}else{
_1793=this._getAttribute(_1795.nodeName,_1793);
if(_1793.charAt(0)==="@"){
var name=_1793.substring(1);
_1795.setAttribute(name,value);
}else{
for(var i=0;i<_1795.childNodes.length;i++){
var node=_1795.childNodes[i];
if(node.nodeType===1&&node.nodeName===_1793){
child=node;
break;
}
}
var _179b=this._getDocument(_1795);
if(child){
while(child.firstChild){
child.removeChild(child.firstChild);
}
}else{
child=_179b.createElement(_1793);
_1795.appendChild(child);
}
text=_179b.createTextNode(value);
child.appendChild(text);
}
}
}
return true;
},setValues:function(item,_179d,_179e){
if(_179d==="tagName"){
return false;
}
this._backupItem(item);
var _179f=item.element;
var i;
var child;
var text;
if(_179d==="childNodes"){
while(_179f.firstChild){
_179f.removeChild(_179f.firstChild);
}
for(i=0;i<_179e.length;i++){
child=_179e[i].element;
_179f.appendChild(child);
}
}else{
if(_179d==="text()"){
while(_179f.firstChild){
_179f.removeChild(_179f.firstChild);
}
var value="";
for(i=0;i<_179e.length;i++){
value+=_179e[i];
}
text=this._getDocument(_179f).createTextNode(value);
_179f.appendChild(text);
}else{
_179d=this._getAttribute(_179f.nodeName,_179d);
if(_179d.charAt(0)==="@"){
var name=_179d.substring(1);
_179f.setAttribute(name,_179e[0]);
}else{
for(i=_179f.childNodes.length-1;i>=0;i--){
var node=_179f.childNodes[i];
if(node.nodeType===1&&node.nodeName===_179d){
_179f.removeChild(node);
}
}
var _17a6=this._getDocument(_179f);
for(i=0;i<_179e.length;i++){
child=_17a6.createElement(_179d);
text=_17a6.createTextNode(_179e[i]);
child.appendChild(text);
_179f.appendChild(child);
}
}
}
}
return true;
},unsetAttribute:function(item,_17a8){
if(_17a8==="tagName"){
return false;
}
this._backupItem(item);
var _17a9=item.element;
if(_17a8==="childNodes"||_17a8==="text()"){
while(_17a9.firstChild){
_17a9.removeChild(_17a9.firstChild);
}
}else{
_17a8=this._getAttribute(_17a9.nodeName,_17a8);
if(_17a8.charAt(0)==="@"){
var name=_17a8.substring(1);
_17a9.removeAttribute(name);
}else{
for(var i=_17a9.childNodes.length-1;i>=0;i--){
var node=_17a9.childNodes[i];
if(node.nodeType===1&&node.nodeName===_17a8){
_17a9.removeChild(node);
}
}
}
}
return true;
},save:function(_17ad){
if(!_17ad){
_17ad={};
}
var i;
for(i=0;i<this._modifiedItems.length;i++){
this._saveItem(this._modifiedItems[i],_17ad,"PUT");
}
for(i=0;i<this._newItems.length;i++){
var item=this._newItems[i];
if(item.element.parentNode){
this._newItems.splice(i,1);
i--;
continue;
}
this._saveItem(this._newItems[i],_17ad,"POST");
}
for(i=0;i<this._deletedItems.length;i++){
this._saveItem(this._deletedItems[i],_17ad,"DELETE");
}
},revert:function(){
console.log("XmlStore.revert() _newItems="+this._newItems.length);
console.log("XmlStore.revert() _deletedItems="+this._deletedItems.length);
console.log("XmlStore.revert() _modifiedItems="+this._modifiedItems.length);
this._newItems=[];
this._restoreItems(this._deletedItems);
this._deletedItems=[];
this._restoreItems(this._modifiedItems);
this._modifiedItems=[];
return true;
},isDirty:function(item){
if(item){
var _17b1=this._getRootElement(item.element);
return (this._getItemIndex(this._newItems,_17b1)>=0||this._getItemIndex(this._deletedItems,_17b1)>=0||this._getItemIndex(this._modifiedItems,_17b1)>=0);
}else{
return (this._newItems.length>0||this._deletedItems.length>0||this._modifiedItems.length>0);
}
},_saveItem:function(item,_17b3,_17b4){
var url;
var scope;
if(_17b4==="PUT"){
url=this._getPutUrl(item);
}else{
if(_17b4==="DELETE"){
url=this._getDeleteUrl(item);
}else{
url=this._getPostUrl(item);
}
}
if(!url){
if(_17b3.onError){
scope=_17b3.scope||dojo.global;
_17b3.onError.call(scope,new Error("No URL for saving content: "+this._getPostContent(item)));
}
return;
}
var _17b7={url:url,method:(_17b4||"POST"),contentType:"text/xml",handleAs:"xml"};
var _17b8;
if(_17b4==="PUT"){
_17b7.putData=this._getPutContent(item);
_17b8=dojo.rawXhrPut(_17b7);
}else{
if(_17b4==="DELETE"){
_17b8=dojo.xhrDelete(_17b7);
}else{
_17b7.postData=this._getPostContent(item);
_17b8=dojo.rawXhrPost(_17b7);
}
}
scope=(_17b3.scope||dojo.global);
var self=this;
_17b8.addCallback(function(data){
self._forgetItem(item);
if(_17b3.onComplete){
_17b3.onComplete.call(scope);
}
});
_17b8.addErrback(function(error){
if(_17b3.onError){
_17b3.onError.call(scope,error);
}
});
},_getPostUrl:function(item){
return this.url;
},_getPutUrl:function(item){
return this.url;
},_getDeleteUrl:function(item){
var url=this.url;
if(item&&this.keyAttribute!==""){
var value=this.getValue(item,this.keyAttribute);
if(value){
var key=this.keyAttribute.charAt(0)==="@"?this.keyAttribute.substring(1):this.keyAttribute;
url+=url.indexOf("?")<0?"?":"&";
url+=key+"="+value;
}
}
return url;
},_getPostContent:function(item){
var _17c3=item.element;
var _17c4="<?xml version=\"1.0\"?>";
return _17c4+dojox.xml.parser.innerXML(_17c3);
},_getPutContent:function(item){
var _17c6=item.element;
var _17c7="<?xml version=\"1.0\"?>";
return _17c7+dojox.xml.parser.innerXML(_17c6);
},_getAttribute:function(_17c8,_17c9){
if(this._attributeMap){
var key=_17c8+"."+_17c9;
var value=this._attributeMap[key];
if(value){
_17c9=value;
}else{
value=this._attributeMap[_17c9];
if(value){
_17c9=value;
}
}
}
return _17c9;
},_getItem:function(_17cc){
try{
var q=null;
if(this.keyAttribute===""){
q=this._getXPath(_17cc);
}
return new dojox.data.XmlItem(_17cc,this,q);
}
catch(e){
console.log(e);
}
return null;
},_getItemIndex:function(items,_17cf){
for(var i=0;i<items.length;i++){
if(items[i].element===_17cf){
return i;
}
}
return -1;
},_backupItem:function(item){
var _17d2=this._getRootElement(item.element);
if(this._getItemIndex(this._newItems,_17d2)>=0||this._getItemIndex(this._modifiedItems,_17d2)>=0){
return;
}
if(_17d2!=item.element){
item=this._getItem(_17d2);
}
item._backup=_17d2.cloneNode(true);
this._modifiedItems.push(item);
},_restoreItems:function(items){
dojo.forEach(items,function(item){
if(item._backup){
item.element=item._backup;
item._backup=null;
}
},this);
},_forgetItem:function(item){
var _17d6=item.element;
var index=this._getItemIndex(this._newItems,_17d6);
if(index>=0){
this._newItems.splice(index,1);
}
index=this._getItemIndex(this._deletedItems,_17d6);
if(index>=0){
this._deletedItems.splice(index,1);
}
index=this._getItemIndex(this._modifiedItems,_17d6);
if(index>=0){
this._modifiedItems.splice(index,1);
}
},_getDocument:function(_17d8){
if(_17d8){
return _17d8.ownerDocument;
}else{
if(!this._document){
return dojox.xml.parser.parse();
}
}
return null;
},_getRootElement:function(_17d9){
while(_17d9.parentNode){
_17d9=_17d9.parentNode;
}
return _17d9;
},_getXPath:function(_17da){
var xpath=null;
if(!this.sendQuery){
var node=_17da;
xpath="";
while(node&&node!=_17da.ownerDocument){
var pos=0;
var _17de=node;
var name=node.nodeName;
while(_17de){
_17de=_17de.previousSibling;
if(_17de&&_17de.nodeName===name){
pos++;
}
}
var temp="/"+name+"["+pos+"]";
if(xpath){
xpath=temp+xpath;
}else{
xpath=temp;
}
node=node.parentNode;
}
}
return xpath;
},getIdentity:function(item){
if(!this.isItem(item)){
throw new Error("dojox.data.XmlStore: Object supplied to getIdentity is not an item");
}else{
var id=null;
if(this.sendQuery&&this.keyAttribute!==""){
id=this.getValue(item,this.keyAttribute).toString();
}else{
if(!this.serverQuery){
if(this.keyAttribute!==""){
id=this.getValue(item,this.keyAttribute).toString();
}else{
id=item.q;
}
}
}
return id;
}
},getIdentityAttributes:function(item){
if(!this.isItem(item)){
throw new Error("dojox.data.XmlStore: Object supplied to getIdentity is not an item");
}else{
if(this.keyAttribute!==""){
return [this.keyAttribute];
}else{
return null;
}
}
},fetchItemByIdentity:function(_17e4){
var _17e5=null;
var scope=null;
var self=this;
var url=null;
var _17e9=null;
var _17ea=null;
if(!self.sendQuery){
_17e5=function(data){
if(data){
if(self.keyAttribute!==""){
var _17ec={};
_17ec.query={};
_17ec.query[self.keyAttribute]=_17e4.identity;
var items=self._getItems(data,_17ec);
scope=_17e4.scope||dojo.global;
if(items.length===1){
if(_17e4.onItem){
_17e4.onItem.call(scope,items[0]);
}
}else{
if(items.length===0){
if(_17e4.onItem){
_17e4.onItem.call(scope,null);
}
}else{
if(_17e4.onError){
_17e4.onError.call(scope,new Error("Items array size for identity lookup greater than 1, invalid keyAttribute."));
}
}
}
}else{
var qArgs=_17e4.identity.split("/");
var i;
var node=data;
for(i=0;i<qArgs.length;i++){
if(qArgs[i]&&qArgs[i]!==""){
var _17f1=qArgs[i];
_17f1=_17f1.substring(0,_17f1.length-1);
var vals=_17f1.split("[");
var tag=vals[0];
var index=parseInt(vals[1],10);
var pos=0;
if(node){
var _17f6=node.childNodes;
if(_17f6){
var j;
var _17f8=null;
for(j=0;j<_17f6.length;j++){
var pNode=_17f6[j];
if(pNode.nodeName===tag){
if(pos<index){
pos++;
}else{
_17f8=pNode;
break;
}
}
}
if(_17f8){
node=_17f8;
}else{
node=null;
}
}else{
node=null;
}
}else{
break;
}
}
}
var item=null;
if(node){
item=self._getItem(node);
item.element.parentNode.removeChild(item.element);
}
if(_17e4.onItem){
scope=_17e4.scope||dojo.global;
_17e4.onItem.call(scope,item);
}
}
}
};
url=this._getFetchUrl(null);
_17e9={url:url,handleAs:"xml",preventCache:true};
_17ea=dojo.xhrGet(_17e9);
_17ea.addCallback(_17e5);
if(_17e4.onError){
_17ea.addErrback(function(error){
var s=_17e4.scope||dojo.global;
_17e4.onError.call(s,error);
});
}
}else{
if(self.keyAttribute!==""){
var _17fd={query:{}};
_17fd.query[self.keyAttribute]=_17e4.identity;
url=this._getFetchUrl(_17fd);
_17e5=function(data){
var item=null;
if(data){
var items=self._getItems(items,{});
if(items.length===1){
item=items[0];
}else{
if(_17e4.onError){
var scope=_17e4.scope||dojo.global;
_17e4.onError.call(scope,new Error("More than one item was returned from the server for the denoted identity"));
}
}
}
if(_17e4.onItem){
scope=_17e4.scope||dojo.global;
_17e4.onItem.call(scope,item);
}
};
_17e9={url:url,handleAs:"xml",preventCache:true};
_17ea=dojo.xhrGet(_17e9);
_17ea.addCallback(_17e5);
if(_17e4.onError){
_17ea.addErrback(function(error){
var s=_17e4.scope||dojo.global;
_17e4.onError.call(s,error);
});
}
}else{
if(_17e4.onError){
var s=_17e4.scope||dojo.global;
_17e4.onError.call(s,new Error("XmlStore is not told that the server to provides identity support.  No keyAttribute specified."));
}
}
}
}});
dojo.declare("dojox.data.XmlItem",null,{constructor:function(_1805,store,query){
this.element=_1805;
this.store=store;
this.q=query;
},toString:function(){
var str="";
if(this.element){
for(var i=0;i<this.element.childNodes.length;i++){
var node=this.element.childNodes[i];
if(node.nodeType===3||node.nodeType===4){
str+=node.nodeValue;
}
}
}
return str;
}});
dojo.extend(dojox.data.XmlStore,dojo.data.util.simpleFetch);
}
if(!dojo._hasResource["com.ibm.mm.data.xml"]){
dojo._hasResource["com.ibm.mm.data.xml"]=true;
dojo.provide("com.ibm.mm.data.xml");
dojo.declare("com.ibm.mm.data.xml",dojox.data.XmlStore,{getValueType:function(item,_180c){
if("tagName"==_180c){
return "text";
}
if("childNodes"==_180c){
if(item.element!=null){
return "json";
var _180d=item.element.getAttribute("type");
if(_180d==null){
return "json";
}else{
return _180d;
}
}
}
var _180e=this.getValue(item,_180c);
if(_180e instanceof dojox.data.XmlItem){
_180d=this.getValue(_180e,"@type");
if(_180d==null){
_180d="text";
}
return _180d;
}else{
return "text";
}
},getAttributes:function(item){
var _1810=item.element;
var _1811=[];
_1811.push("tagName");
if(_1810.childNodes.length>0){
var names={};
var _1813=true;
var text=false;
for(var i=0;i<_1810.childNodes.length;i++){
var node=_1810.childNodes[i];
if(node.nodeType===1){
var name=node.nodeName;
if(!names[name]){
_1811.push(name);
names[name]=name;
}
_1813=true;
}else{
if(node.nodeType===3){
text=true;
}
}
}
if(_1813){
_1811.push("childNodes");
}
}
for(var i=0,att;i<_1810.attributes.length;i++){
att=_1810.attributes[i].nodeName;
if("type"!=att){
_1811.push(_1810.attributes[i].nodeName);
}
}
if(this._attributeMap){
for(var key in this._attributeMap){
var i=key.indexOf(".");
if(i>0){
var _181a=key.substring(0,i);
if(_181a===_1810.nodeName){
_1811.push(key.substring(i+1));
}
}else{
_1811.push(key);
}
}
}
return _1811;
},serialize:function(){
return "";
}});
}
if(!dojo._hasResource["com.ibm.enabler"]){
dojo._hasResource["com.ibm.enabler"]=true;
dojo.provide("com.ibm.enabler");
dojo.provide("com.ibm.enabler.aggregation.javascript");
dojo.provide("com.ibm.enabler.iw");
dojo.provide("com.ibm.enabler.xpath");
dojo.provide("com.ibm.enabler.xslt");
dojo.provide("com.ibm.enabler.services");
dojo.provide("com.ibm.enabler.debug");
dojo.provide("com.ibm.enabler.iw.eventImpl");
dojo.provide("com.ibm.enabler.utilities");
dojo.provide("com.ibm.mm.enabler.iw");
com.ibm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER=com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER;
com.ibm.enabler.iw.utils=com.ibm.mm.iwidget.utils;
com.ibm.enabler.utilities=com.ibm.mm.enabler.utilities;
com.ibm.enabler.dom=com.ibm.mm.enabler.dom;
com.ibm.enabler.xpath.evaluateXPath=com.ibm.mashups.enabler.xml.XPath.evaluateXPath;
if(com.ibm.mm.enabler.xslt){
com.ibm.enabler.xslt.getXmlHttpRequest=com.ibm.mm.enabler.xslt.getXmlHttpRequest;
com.ibm.enabler.xslt.loadXml=com.ibm.mm.enabler.xslt.loadXml;
com.ibm.enabler.xslt.loadXmlString=com.ibm.mm.enabler.xslt.loadXmlString;
com.ibm.enabler.xslt.loadXsl=com.ibm.mm.enabler.xslt.loadXsl;
com.ibm.enabler.xslt.transform=com.ibm.mm.enabler.xslt.transform;
com.ibm.enabler.xslt.transformAndUpdate=com.ibm.mm.enabler.xslt.transformAndUpdate;
}
com.ibm.enabler.services.CONFIG_SERVICE=com.ibm.mm.enabler.services.CONFIG_SERVICE;
com.ibm.enabler.debug.Constants=com.ibm.mm.enabler.debug.Constants;
com.ibm.enabler.debug.log=com.ibm.mm.enabler.debug.log;
com.ibm.enabler.debug.entry=com.ibm.mm.enabler.debug.entry;
com.ibm.enabler.debug.exit=com.ibm.mm.enabler.debug.exit;
com.ibm.enabler.debug.info=com.ibm.mm.enabler.debug.info;
com.ibm.enabler.debug.warn=com.ibm.mm.enabler.debug.warn;
com.ibm.enabler.debug.error=com.ibm.mm.enabler.debug.error;
dojo.declare("com.ibm.enabler.iw.iEventDescriptionImpl",com.ibm.mm.iwidget.iEventDescriptionImpl,{constructor:function(){
}});
dojo.declare("com.ibm.enabler.utilities.HttpUrl",com.ibm.mm.enabler.utilities.HttpUrl,{constructor:function(){
}});
com.ibm.mm.enabler.iw.utils=com.ibm.mm.iwidget.utils;
com.ibm.mm.enabler.iw.iEvents=com.ibm.mm.iwidget.iEvents;
dojo.declare("com.ibm.mm.enabler.iw.iEventDescriptionImpl",com.ibm.mm.iwidget.iEventDescriptionImpl,{constructor:function(){
}});
dojo.provide("com.ibm.mashups.iwidget.services");
com.ibm.mashups.iwidget.services.ServiceManager=com.ibm.mashups.services.ServiceManager;
dojo.provide("com.ibm.mm.enabler.iw.eventImpl");
}
if(!dojo._hasResource["com.ibm.mm.enabler.encode.huffman"]){
dojo._hasResource["com.ibm.mm.enabler.encode.huffman"]=true;
dojo.provide("com.ibm.mm.enabler.encode.huffman");
dojo.declare("com.ibm.mm.enabler.encode.huffman.HuffmanURL",null,{URL_ALPHABET:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_!",LOG_LEVEL:com.ibm.mashups.enabler.logging.LogLevel.TRACE,constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
},_encodeTokens:function(_181b,nodes,_181d){
var len=_181d.length;
for(var i=0;i<len;++i){
this._addBits(_181b,nodes[_181d[i]].prefix);
}
return this._encodeStream(_181b);
},_encodeStream:function(_1820){
var len=_1820.dwords.length*4;
if(_1820.bits>0){
_1820.dwords.push(_1820.dword);
len+=((_1820.bits+7)>>3);
_1820.bits=0;
}
return this._encodeBase64(_1820.dwords,0,len);
},_initStream:function(_1822){
_1822.dword=0;
_1822.mask=1;
_1822.bits=0;
_1822.dwords=[];
return _1822;
},_addBits:function(_1823,data){
var mask=_1823.mask,dword=_1823.dword,bits=_1823.bits;
var len=data.length,off=0;
while(len>0){
var copy=Math.min(len,32-bits);
for(var i=0;i<copy;++i){
if(data[off+i]==1){
dword|=mask;
}
mask<<=1;
}
bits+=copy;
len-=copy;
off+=copy;
if(bits==32){
_1823.dwords.push(dword);
bits=0;
mask=1;
dword=0;
}
}
_1823.mask=mask;
_1823.bits=bits;
_1823.dword=dword;
},_addBit:function(_182c,bit){
if(bit==1){
_182c.dword|=_182c.mask;
}
_182c.mask<<=1;
_182c.bits++;
if(_182c.bits==32){
_182c.dwords.push(_182c.dword);
_182c.dword=0;
_182c.mask=1;
_182c.bits=0;
}
},_encodeBase64:function(data,off,len){
var ab=this.URL_ALPHABET;
var _1832=off>>2;
var shift=off&3;
var value=data[_1832++],_1835;
var c1,c2,c3,c4;
var _183a="";
for(var i=len;i>0;i-=3){
switch(shift){
case 0:
c1=((value>>2)&63);
c2=((value<<4)&48)|((value>>12)&15);
c3=((value>>6)&60)|((value>>22)&3);
c4=((value>>16)&63);
shift=3;
break;
case 1:
c1=((value>>10)&63);
c2=((value>>4)&48)|((value>>20)&15);
c3=((value>>14)&60)|((value>>30)&3);
c4=((value>>24)&63);
shift=0;
value=data[_1832++];
break;
case 2:
_1835=data[_1832++];
c1=((value>>18)&63);
c2=((value>>12)&48)|((value>>28)&15);
c3=((value>>22)&60)|((_1835>>6)&3);
c4=(_1835&63);
value=_1835;
shift=1;
break;
case 3:
_1835=data[_1832++];
c1=((value>>26)&63);
c2=((value>>20)&48)|((_1835>>4)&15);
c3=((_1835<<2)&60)|((_1835>>14)&3);
c4=((_1835>>8)&63);
value=_1835;
shift=2;
break;
}
switch(i){
case 1:
c3=64;
case 2:
c4=64;
break;
}
_183a+=ab.charAt(c1);
_183a+=ab.charAt(c2);
_183a+=ab.charAt(c3);
_183a+=ab.charAt(c4);
}
return _183a;
},_decodeBase64:function(_183c){
var ab=this.URL_ALPHABET;
var len=_183c.length/4;
var i=0;
var array=[];
for(var j=0;j<len;j++){
var _1842=0;
indexC1=ab.indexOf(_183c.charAt(i++));
indexC2=ab.indexOf(_183c.charAt(i++));
indexC3=ab.indexOf(_183c.charAt(i++));
if(indexC3==64){
_1842++;
}
indexC4=ab.indexOf(_183c.charAt(i++));
if(indexC4==64){
_1842++;
}
c1=(indexC1<<2)|(indexC2>>4);
c2=((indexC2&15)<<4)|(indexC3>>2);
c3=((indexC3&3)<<6)|indexC4;
array.push(c1);
switch(_1842){
case 0:
array.push(c2);
array.push(c3);
break;
case 1:
array.push(c2);
break;
case 2:
break;
}
}
return array;
},_frequencyCompare:function(n1,n2){
return n1.frequency-n2.frequency;
},_initTree:function(_1845,node,_1847){
if(node.left&&node.right){
this._addBit(_1845,1);
this._initTree(_1845,node.left,_1847.concat(0));
this._initTree(_1845,node.right,_1847.concat(1));
}else{
this._addBit(_1845,0);
node.prefix=_1847;
_1845.tokens.push(node.name);
}
return _1845;
},_dumpTokens:function(tree,nodes){
var _184a=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_184a){
for(var i=0;i<tree.tokens.length;++i){
this.LOGGER.trace("_dumpTokens()","["+nodes[tree.tokens[i]].frequency+", \""+tree.tokens[i]+"\"]");
}
}
},_buildTree:function(_184c){
var nodes={};
var len=_184c.length;
for(var i=len-1;i>=0;--i){
var token=_184c[i];
node=nodes[token];
if(node){
node.frequency++;
}else{
node={frequency:1,name:token};
nodes[token]=node;
}
}
var queue=[];
for(var node in nodes){
queue.push(nodes[node]);
}
queue.sort(this._frequencyCompare);
while(queue.length>1){
var left=queue.shift(),right=queue.shift();
queue.push({frequency:left.frequency+right.frequency,left:left,right:right});
queue.sort(this._frequencyCompare);
}
var root=queue[0];
var tree=this._initTree(this._initStream({tokens:[]}),queue.shift(),[]);
this._dumpTokens(tree,nodes);
var url=this._encodeStream(tree);
len=tree.tokens.length;
for(i=0;i<len;++i){
url+="/"+com.ibm.mm.enabler.encode.huffman.ZEncoder.zEncode(tree.tokens[i]);
}
url+="/"+this._encodeTokens(this._initStream({}),nodes,_184c);
return url;
},_buildTreeFromRegex:function(data,_1859){
var regex=new RegExp(_1859,"g");
var pos=[];
var _185c;
while((_185c=regex.exec(data))!=null){
pos.push(_185c.index);
}
if(pos[0]!=0){
pos.unshift(0);
}
if(pos[pos.length-1]!=data.length){
pos.push(data.length);
}
var _185d=[];
for(_185c=1;_185c<pos.length;++_185c){
_185d.push(data.substring(pos[_185c-1],pos[_185c]));
}
return this._buildTree(_185d);
},createRawSchemeSpecificPartFromTokens:function(_185e){
return this._buildTree(_185e);
},createRawSchemeSpecificPartFromRegex:function(data,_1860){
return this._buildTreeFromRegex(data,_1860);
},getDataFromHuffmanTree:function(tree){
return this._restoreData(tree);
},_restoreData:function(tree){
if(typeof tree=="undefined"||tree==null){
return null;
}
var i0=tree.indexOf("/");
var i1=tree.lastIndexOf("/");
if((i0>=0)&&(i1>=0)){
var _1865=this._decodeBase64(tree.substring(0,i0));
var _1866=tree.substring(i0+1,i1).split("/");
var _1867=this._decodeBase64(tree.substring(i1+1));
encodedTokens=this._decodeTokens(_1866);
var root=this._readStructure(this._convertBitToChar(_1865),encodedTokens);
var _1869=this._convertBitToChar(_1867);
var _186a="";
while(_1869.length>0){
_186a=this._buildData(_186a,_1869,root);
}
return _186a;
}
return null;
},_buildData:function(_186b,_186c,root){
var found=false;
var node=null;
while(found==false){
var bit=_186c.shift();
if(typeof bit=="undefined"){
node=null;
break;
}
node=this._getNode(bit,root);
if(node!=null&&node.token&&node.token!=null){
found=true;
}else{
if(node==null){
found=true;
}
}
root=node;
}
if(found==true&&node!=null){
_186b=_186b.concat(node.token);
}
return _186b;
},_getNode:function(bit,_1872){
var node=null;
if(bit==1){
node=_1872.right;
}else{
node=_1872.left;
}
if(typeof (node)=="undefined"||node==null){
return null;
}
return node;
},_convertBitToChar:function(_1874){
var arr=[];
var mask=1;
var bit=0;
for(var i=0;i<_1874.length;i++){
var _1879=_1874[i];
for(var j=0;j<8;j++){
bit=_1879&mask;
arr.push(bit);
_1879=(_1879>>1);
}
}
return arr;
},_readStructure:function(_187b,_187c){
var bit=_187b.shift();
var node={};
if(bit==1){
node.left=this._readStructure(_187b,_187c);
node.right=this._readStructure(_187b,_187c);
}else{
var token=_187c.shift();
node.token=token;
}
return node;
},_decodeTokens:function(_1880){
var arr=[];
for(var i in _1880){
arr.push(com.ibm.mm.enabler.encode.huffman.ZEncoder.zDecode(_1880[i]));
}
return arr;
}});
com.ibm.mm.enabler.encode.huffman.HuffmanURL=new com.ibm.mm.enabler.encode.huffman.HuffmanURL();
dojo.declare("com.ibm.mm.enabler.encode.huffman.ZEncoder",null,{HEX_CHARS:["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"],UNSAFE_CHARS:"$&+,/:;=?@ <>#%{}|\\^~[]`\"Z",constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
},isUnsafeChar:function(_1883){
if(this.UNSAFE_CHARS.indexOf(_1883)>-1||_1883.charCodeAt(0)<=32||_1883.charCodeAt(0)>=123){
return true;
}
return false;
},zEncode:function(value){
var _1885="";
for(var i=0;i<value.length;++i){
var _1887=value.charAt(i);
if(!this.isUnsafeChar(_1887)){
_1885+=_1887;
continue;
}
_1885+=this.zEncodeChar(_1887);
}
return _1885;
},zEncodeChar:function(_1888){
var _1889="Z";
return _1889+this.byteToHex(_1888.charCodeAt(0));
},byteToHex:function(_188a){
var upper=Math.floor(_188a/16);
var lower=_188a%16;
return this.HEX_CHARS[upper]+this.HEX_CHARS[lower];
},zDecode:function(value){
var _188e="";
var _188f="Z";
if(value.indexOf(_188f)!=-1){
for(var i=0;i<value.length;i++){
var charX=value.charAt(i);
if(charX==_188f){
var hex="0x"+value.substr(i+1,2);
i=i+2;
try{
var _1893=parseInt(hex);
_188e=_188e.concat(String.fromCharCode(_1893));
}
catch(e){
continue;
}
}else{
_188e=_188e.concat(value.substr(i,1));
}
}
}else{
_188e=value;
}
return _188e;
}});
com.ibm.mm.enabler.encode.huffman.ZEncoder=new com.ibm.mm.enabler.encode.huffman.ZEncoder();
}
if(!dojo._hasResource["com.ibm.mashups.enabler.io.multipart"]){
dojo._hasResource["com.ibm.mashups.enabler.io.multipart"]=true;
dojo.provide("com.ibm.mashups.enabler.io.multipart");
dojo.provide("com.ibm.mashups.enabler.io.XHRMultipart");
dojo.require("com.ibm.mm.enabler.services.ConfigService");
dojo.declare("com.ibm.mashups.enabler.io.XHRMultipart",null,{constructor:function(){
},startTransaction:function(){
},endTransaction:function(_1894,_1895){
},suspendTransaction:function(){
},resumeTransaction:function(){
},isTransaction:function(){
return new Boolean();
}});
}
if(!dojo._hasResource["com.ibm.mashups.enabler.io.factory"]){
dojo._hasResource["com.ibm.mashups.enabler.io.factory"]=true;
dojo.provide("com.ibm.mashups.enabler.io.factory");
dojo.declare("com.ibm.mashups.enabler.io.XHRMultipartFactory",null,{create:function(){
return new com.ibm.mashups.enabler.io.XHRMultipart();
},isMultipartEnabled:function(){
return new Boolean();
},isMultipartApplicationWidgets:function(){
return new Boolean();
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.io.multipart"]){
dojo._hasResource["com.ibm.mm.enabler.io.multipart"]=true;
dojo.provide("com.ibm.mm.enabler.io.multipart");
com.ibm.mm.enabler.io={urlToProxyUrl:function(url,_1897){
var ret=_1897?_1897:"/proxy";
var _1899="http";
var colon=url.indexOf("://");
if(colon>-1){
_1899=url.substring(0,colon);
url=url.substring(colon+3);
}
url=url.replace(/:/g,"%3A");
return ret+"/"+_1899+"/"+url;
}};
(function(){
var _189b=new String("{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}");
var newL=new String("\r\n");
var sep=new String("--");
var _189e=newL+sep+_189b+newL;
var endB=sep+_189b+sep+newL;
var _18a0=new RegExp(newL+"s*([^\r]*)s*","mg");
var _18a1=/\s*([^:]*):\s*(.+)/;
var _18a2=/boundary\s*=\s*\"?([^\"]*)\"?/;
var _18a3=function(_18a4,_18a5,_18a6,_18a7){
for(x in _18a4){
var work=dojo.hitch(_18a4[x],function(){
try{
if(_18a5 instanceof Error){
if(this.error){
this.error(_18a5,_18a6,_18a7);
}
}else{
if(this.load){
this.load(_18a5,_18a6,_18a7);
}
}
if(this.handle){
this.handle(_18a5,_18a6,_18a7);
}
}
catch(err){
try{
if(this.error){
this.error(_18a5,_18a6,_18a7);
}
}
catch(err2){
}
}
});
work();
}
};
dojo.mixin(com.ibm.mm.enabler.io,{handleMultiPartResponse:function(parts,_18aa,_18ab,_18ac){
var _18ad=_18ac.xhr.getResponseHeader("Content-Type").match(_18a2);
if(!_18ad){
throw new Error("No boundary specified in Content-Type response header");
}
var bound=_18ad[1];
var _18af=new RegExp(newL+sep+bound,"mg");
var _18b0=_18ab.split(_18af);
var _18b1=null;
if(_18aa){
_18b1=new com.ibm.mm.enabler.io.XHRMultipartImpl();
_18b1.startTransaction();
}
var i=1;
for(var _18b3 in parts){
var _18b4=parts[_18b3];
var part=_18b0[i++];
var _18b6={};
var _18b7=null;
var _18b8=null;
var _18b9=null;
_18a0.lastIndex=0;
while((_18b7=_18a0.exec(part))!=null&&(_18b7[1].length>0)){
if(-1==_18b7[1].indexOf(":")){
continue;
}
if(-1==_18b7[1].indexOf("digest=")){
var _18ba=_18b7[1].match(_18a1);
_18b6[_18ba[1]]=_18ba[2];
if(_18ba[1]=="X-Status-Code"){
_18b8=_18ba[2];
}else{
if(_18ba[1]=="Content-Type"){
_18b9=_18ba[2];
}
}
}
}
part=dojo.string.trim(part.substr(_18a0.lastIndex+newL.length));
var _18bb=part;
if(_18b4[0].handleAs=="xml"){
part=com.ibm.mm.enabler.dom.createDocument(part);
}else{
part=dojo._contentHandlers[_18b4[0].handleAs]({responseText:part});
}
var _18bc=parseInt(_18b8);
var _18bd=new com.ibm.mm.enabler.io.XHRWrapper(_18ac,_18bb,_18bc,_18b9);
var xhr=_18ac.xhr;
_18ac.xhr=_18bd;
_18a3(_18b4,part,_18ac,_18b6);
_18ac.xhr=xhr;
}
if(_18aa){
_18b1.endTransaction();
}
},multiPartXhr:function(_18bf,args,parts,_18c2){
var body="";
var _18c4=null;
for(var _18c5 in parts){
var part=parts[_18c5][0];
part.handleAs=part.handleAs?part.handleAs.toLowerCase():"text";
_18c4="";
for(var x in part.headers){
_18c4+=x+": "+part.headers[x]+newL;
}
body+=_189e+_18c4+newL;
if(part.data&&part.data.length>1){
body+=part.data+newL;
}else{
if(part.postData&&part.postData.length>1){
body+=part.postData+newL;
}else{
if(part.putData&&part.putData.length>1){
body+=part.putData+newL;
}
}
}
}
body+=endB;
if(_18bf.toUpperCase()!="PUT"){
_18bf="POST";
}
var _18c8=dojo.mixin({},args,{load:dojo.partial(com.ibm.mm.enabler.io.handleMultiPartResponse,parts,_18c2),error:function(_18c9,_18ca){
dojo.forEach(parts,function(part){
_18a3(part,_18c9,_18ca,null);
});
},headers:{"Content-type":"multipart/mixed; boundary=\""+_189b+"\""},handleAs:"text",form:null,content:null,postData:null,putData:null});
_18c8[_18bf.toLowerCase()+"Data"]=body;
return dojo.xhr(_18bf,_18c8,true);
}});
})();
dojo.declare("com.ibm.mm.enabler.io.XHRWrapper",null,{constructor:function(_18cc,_18cd,_18ce,_18cf){
this.ioArgs=_18cc;
this.xhr=_18cc.xhr;
this.readyState=_18cc.xhr.readyState;
this.responseText=_18cd;
this.responseXML=_18cc.xhr.responseXML;
this.status=_18ce;
this.statusText=_18cc.xhr.statusText;
this.contentType=_18cf;
},getAllResponseHeaders:function(){
return this.xhr.getAllResponseHeaders();
},getInterface:function(){
return this.xhr.getInterface();
},getResponseHeader:function(_18d0){
if(new String(_18d0).toLowerCase()=="content-type"){
return (this.contentType);
}
return this.xhr.getResponseHeader(_18d0);
}});
dojo.declare("com.ibm.mm.enabler.io.XHRMultipartImpl",com.ibm.mashups.enabler.io.XHRMultipart,{LOG_LEVEL:com.ibm.mashups.enabler.logging.LogLevel.TRACE,statics:{semaphore:0,digest:null,suspendedXhr:null},constructor:function(){
this.LOGGER=com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
var _18d1="constructor()";
var _18d2=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_18d2){
this.LOGGER.entering(_18d1);
}
this.method="POST";
this.partsArray=null;
var _18d3=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
this.correlateHosts=_18d3.getValue(com.ibm.mashups.enabler.services.ConfigConstants.MULTIPART_CORRELATE_HOSTS);
this.correlatedHosts=null;
this.privateUrl=_18d3.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT)+_18d3.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PRIVATE);
this.publicUrl=_18d3.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT)+_18d3.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PUBLIC);
this.doSiteMap=true;
this.serviceMPJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData([com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MODEL,com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MULTIPART]);
this.serviceSMJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData([com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MODEL,com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_HUFFMAN]);
this.doMultipart=com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled();
this.urlMaxLength=2000;
if(_18d2){
this.LOGGER.trace(_18d1,"Multipart is enabled - ${0}",this.doMultipart);
this.LOGGER.exiting(_18d1);
}
},suspendTransaction:function(){
if(0==this.statics.semaphore){
return;
}
if(null!=this.statics.suspendedXhr){
return;
}
this.statics.suspendedXhr=dojo.xhr;
dojo.xhr=this.statics.oldXhr;
},resumeTransaction:function(){
if(0==this.statics.semaphore){
return;
}
if(null==this.statics.suspendedXhr){
return;
}
dojo.xhr=this.statics.suspendedXhr;
this.statics.suspendedXhr=null;
},startTransaction:function(){
var _18d4="startTransaction()";
var _18d5=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_18d5){
this.LOGGER.entering(_18d4);
}
if(!this.doMultipart){
if(_18d5){
this.LOGGER.exiting(_18d4);
}
return;
}
this._acquire();
if(1<this.statics.semaphore){
if(_18d5){
this.LOGGER.exiting(_18d4);
}
return;
}
if(this.correlateHosts){
this.correlatedHosts=new com.ibm.mm.enabler.ArrayMap();
}else{
this.partsArray=new Array();
}
this.statics.oldXhr=dojo.xhr;
dojo.xhr=dojo.hitch(this,function(_18d6,args,_18d8){
var _18d9="mp - dojo.hitch()";
var _18da=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_18da){
this.LOGGER.entering(_18d9,[_18d6,args,_18d8]);
}
if(args.sync){
this.statics.oldXhr(_18d6,args,_18d8);
if(_18da){
this.LOGGER.exiting(_18d9);
}
return;
}
var _18db=new com.ibm.mm.enabler.utilities.HttpUrl(args.url);
var _18dc=_18db.getParameter("uri");
if(this.doSiteMap&&_18d6!="GET"){
this.doSiteMap=false;
}else{
if(this.doSiteMap&&(_18d6=="GET")&&(_18dc)&&(null!==_18dc)){
this.doSiteMap=false;
}
}
args.method=_18d6;
if(this.correlateHosts){
var _18dd=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
var _18de=_18db.server;
if(null!==_18dd){
_18dd+="/";
if(args.url.indexOf(_18dd)==0){
var index=args.url.indexOf("/",_18dd.length);
_18de=args.url.substring(0,index);
}
}
var _18e0=this.correlatedHosts.get(_18de);
if(null==_18e0){
_18e0=new Array();
this.correlatedHosts.put(_18de,_18e0);
}
this._addToPartsArray(_18e0,args);
}else{
this._addToPartsArray(this.partsArray,args);
}
if(_18da){
this.LOGGER.exiting(_18d9);
}
});
if(_18d5){
this.LOGGER.exiting(_18d4);
}
},isTransaction:function(){
return (0<this.statics.semaphore);
},_encodeUrl:function(url,_18e2){
if(_18e2){
return escape(url).replace(/\+/g,"%2B").replace(/%20/g,"+").replace(/\*/g,"%2A").replace(/\//g,"%2F").replace(/@/g,"%40").replace(/%21/g,"!");
}
return escape(url).replace(/\+/g,"%2B").replace(/%20/g,"+").replace(/\*/g,"%2A").replace(/\//g,"%2F").replace(/@/g,"%40");
},_createHuffmanUrl:function(parts){
var _18e4="_createHuffmanUrl(parts)";
var _18e5=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_18e5){
this.LOGGER.entering(_18e4,[parts]);
}
var cxml=this._createSiteMap(parts);
if(_18e5){
this.LOGGER.trace(_18e4,"sitemap:  ${0}",cxml);
}
cxml=com.ibm.mm.enabler.encode.huffman.HuffmanURL.createRawSchemeSpecificPartFromRegex(cxml,"[/. ]");
if(_18e5){
this.LOGGER.trace(_18e4,"huffman encoded:  ${0}",cxml);
}
var url;
if(this.serviceSMJson.template.indexOf("{uri_code}")!=-1){
cxml=this._encodeUrl(cxml,true);
if(_18e5){
this.LOGGER.trace(_18e4,"code is a parameter, encoding:  ${0}",cxml);
}
url=this.serviceSMJson.template.replace(/{uri_code}/,cxml);
}else{
url=this.serviceSMJson.template.replace(/{code}/,cxml);
}
if(_18e5){
this.LOGGER.exiting(_18e4,url);
}
return url;
},endTransaction:function(_18e8,_18e9,_18ea){
var _18eb="endTransaction(callback, parameters)";
var _18ec=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_18ec){
this.LOGGER.entering(_18eb,[_18e8,_18e9,_18ea]);
}
if(!this.doMultipart){
if(_18ec){
this.LOGGER.exiting(_18eb);
}
return;
}
this._release();
if(0<this.statics.semaphore){
if(_18ec){
this.LOGGER.exiting(_18eb);
}
return;
}
if(_18ec){
this.LOGGER.trace(_18eb,"Putting back the XHR");
}
dojo.xhr=this.statics.oldXhr;
var _18ed=false;
if(_18e8!==undefined){
_18ed=_18e8;
}
if(this.correlateHosts){
var _18ee=this.correlatedHosts.values();
for(i in _18ee){
if(this.doSiteMap){
var url=this._createHuffmanUrl(_18ee[i]);
if(_18ec){
this.LOGGER.trace(_18eb,"url:  ${0}",url);
}
if(url.length>this.urlMaxLength){
if(_18ec){
this.LOGGER.trace(_18eb,"url is too long, falling back to POST");
}
this._doMultipartPOSTRequest(this.method,_18ee[i],_18ed);
}else{
var _18f0={url:url,load:dojo.partial(com.ibm.mm.enabler.io.handleMultiPartResponse,_18ee[i],_18ed),error:function(_18f1,_18f2){
dojo.forEach(parts,function(part){
partHandler(part,_18f1,_18f2,null);
});
},handleAs:"text"};
dojo.xhrGet(_18f0,true);
}
}else{
this._doMultipartPOSTRequest(this.method,_18ee[i],_18ed);
}
}
}else{
if(0==this._assocArraySize(this.partsArray)){
return;
}
if(this.doSiteMap){
var url=this._createHuffmanUrl(this.partsArray);
if(_18ec){
this.LOGGER.trace(_18eb,"url:  ${0}",url);
}
if(url.length>this.urlMaxLength){
if(_18ec){
this.LOGGER.trace(_18eb,"url is too long, falling back to POST");
}
this._doMultipartPOSTRequest(this.method,this.partsArray,_18ed);
}else{
var _18f0={url:url,load:dojo.partial(com.ibm.mm.enabler.io.handleMultiPartResponse,this.partsArray,_18ed),error:function(_18f4,_18f5){
dojo.forEach(parts,function(part){
partHandler(part,_18f4,_18f5,null);
});
},handleAs:"text"};
dojo.xhrGet(_18f0,true);
}
}else{
this._doMultipartPOSTRequest(this.method,this.partsArray,_18ed);
}
}
if(_18e9){
_18e9(_18ea);
}
if(_18ec){
this.LOGGER.exiting(_18eb);
}
},_doMultipartPOSTRequest:function(_18f7,_18f8,_18f9){
this._processMultipartBody(_18f8);
var _18fa={url:this.serviceMPJson.url,sync:true};
com.ibm.mm.enabler.io.multiPartXhr(_18f7,_18fa,_18f8,_18f9);
},_assocArraySize:function(_18fb){
var size=0;
for(x in _18fb){
size++;
}
return size;
},_addToPartsArray:function(_18fd,args){
var _18ff=_18fd[args.url];
if((!_18ff)||(null==_18ff)){
_18fd[args.url]=new Array();
_18fd[args.url][0]=args;
}else{
_18ff[_18ff.length]=args;
}
},_acquire:function(){
this.statics.semaphore++;
},_release:function(_1900,_1901){
this.statics.semaphore--;
},_createPocURI:function(url){
var _1903="_createPocURI(url)";
var _1904=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_1904){
this.LOGGER.entering(_1903,url);
}
var _1905=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
_1905+="/http/";
if(url.indexOf(_1905)==0){
var _1906="http://";
var _1907=url.indexOf("/",_1905.length+1);
if(_1907>-1){
_1906+=unescape(url.substring(_1905.length,_1907));
_1906+=url.substring(_1907);
}else{
_1906="http://"+url.substring(_1905.length);
}
url=_1906;
}
var _1908=new com.ibm.mm.enabler.utilities.HttpUrl(url);
var uri="";
var _190a=_1908.isProxyNeeded();
if(_190a){
uri=_1908.toString();
}else{
uri="res:/"+_1908.toServerRelativeString();
}
if(_1904){
this.LOGGER.trace(_1903,"proxy? ${0}: ${1}",[_190a,uri]);
}
if(_1904){
this.LOGGER.exiting(_1903,uri);
}
return uri;
},_processMultipartBody:function(parts){
var _190c="_processMultipartBody(parts)";
var _190d=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_190d){
this.LOGGER.entering(_190c,parts);
}
for(w in parts){
var args=parts[w][0];
var uri=this._createPocURI(args.url);
var _1910=uri;
args.headers=dojo.mixin({},args.headers,{"X-Method-Override":args.method,"Content-ID":_1910});
}
if(_190d){
this.LOGGER.exiting(_190c);
}
},_createSiteMap:function(parts){
var _1912="_createSiteMap(parts)";
var _1913=this.LOGGER.isLoggable(this.LOG_LEVEL);
if(_1913){
this.LOGGER.entering(_1912,parts);
}
var cxml="<mashup:sitemap xmlns:mashup=\"http://www.ibm.com/xmlns/prod/websphere/portal/v6.0.2/mashup-sitemap\">";
for(w in parts){
var args=parts[w][0];
args.handleAs=args.handleAs?args.handleAs.toLowerCase():"text";
var uri=this._createPocURI(args.url).replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/&/g,"&amp;");
if(_1913){
this.LOGGER.trace(_1912,"proxy? ${0}: ${1}",[isProxyNeeded,uri]);
}
cxml+="<mashup:entry uri=\""+uri+"\" mode=\"download\"/>";
}
cxml+="</mashup:sitemap>";
if(_1913){
this.LOGGER.exiting(_1912,cxml);
}
return cxml;
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.io.strategy"]){
dojo._hasResource["com.ibm.mm.enabler.io.strategy"]=true;
dojo.provide("com.ibm.mm.enabler.io.strategy");
dojo.declare("com.ibm.mm.enabler.strategy.PageLoadAheadStrategyExecutor",null,{constructor:function(_1917){
this.strategies=_1917;
this.loadAheadUser=false;
this.loadAheadCatalogCategoryModel=false;
this.loadAheadLayoutModel=false;
this.userLoadAheadStrategy=null;
this.pageLoadAheadStrategy=null;
this.catalogCategoryLoadAheadStrategy=null;
for(x in this.strategies){
if(this.strategies[x] instanceof com.ibm.mashups.enabler.strategy.UserLoadAheadStrategy){
this.loadAheadUser=this.strategies[x].isLoadAheadUser();
this.userLoadAheadStrategy=this.strategies[x];
}else{
if(this.strategies[x] instanceof com.ibm.mashups.enabler.strategy.CatalogCategoryLoadAheadStrategy){
}else{
if(this.strategies[x] instanceof com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy){
var _1918=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _1919=_1918.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION);
if(_1919===true){
this.loadAheadLayoutModel=this.strategies[x].isLoadAheadLayoutModel();
}
var _191a=_1918.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION_THEME);
if(_1919===true){
this.loadAheadTheme=this.strategies[x].isLoadAheadTheme();
}else{
this.loadAheadTheme=false;
}
this.pageLoadAheadStrategy=_1917[x];
}
}
}
}
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
this.prefix=this.serviceJson.idprefix;
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},processLoadAhead:function(_191c,sync){
if(!com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled()){
return;
}
var _191e=com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
_191e.startTransaction();
if(_191c.length>0){
var _191f="atom:link[@rel='edit']";
var _1920=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(_191f,_191c[0].xmlData,this.ns);
if(_1920&&_1920.length>0){
var _1921=_1920[0].getAttribute("href");
var h_url=new com.ibm.mm.enabler.utilities.HttpUrl(_1921);
_191e.statics.digest=h_url.getParameter("digest");
}
}
if(this.loadAheadUser){
var _1923=this.userLoadAheadStrategy.getUserModel();
_1923.findCurrentUser().start();
}
if(this.loadAheadCatalogCategoryModel){
var _1924=this.catalogCategoryLoadAheadStrategy.getCatalogCategoryModel();
var _1925=_1924.getRoot().start();
var iter=_1924.getChildren(_1925);
iter.hasNext();
}
for(var i=0;i<_191c.length;i++){
if(this.loadAheadLayoutModel){
var href=null;
var id=null;
var expr="atom:link[@rel='related' and @ext:class='content-node']";
var nodes=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_191c[i].xmlData,this.ns);
if(nodes&&nodes.length>0){
href=nodes[0].getAttribute("href");
id=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,nodes[0]);
}
if(null==href){
continue;
}
var _192c=(id!==null)?id:_191c[i].getID();
var myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,null);
myUrl.setParameter("rep","full");
myUrl.addParameter("aspect","ac");
var _192e=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,false,sync);
_192e.read(dojo.hitch(this,function(type,data,xhr,args){
if((type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD)&&(args.node)&&(200==xhr.status)){
var _1933=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_1933&&_1933.length>0){
args.node._setFragmentData(_1933[0]);
}
}
}),{"node":_191c[i]});
myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL,null);
myUrl.setNodes([{value:_192c,isID:true},{value:"index.html",isID:false}]);
_192e=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,true,sync);
_192e.read(dojo.hitch(this,function(type,data,xhr,args){
if((type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD)&&(args.node)&&(200==xhr.status)){
args.node._setFragmentMediaData(data);
}else{
args.node._setFragmentData(null);
args.node._setFragmentMediaData(null);
}
}),{"node":_191c[i]});
}
if(this.loadAheadTheme){
var _1938=_191c[i].getTheme();
if(_1938!==null){
var _1939=com.ibm.mashups.enabler.model.Factory.getThemeModel();
_1939.find(_1938).start();
}
com.ibm.mm.builder.utils.skinUtil.getAllSkins();
}
}
_191e.endTransaction();
}});
dojo.declare("com.ibm.mm.enabler.strategy.PageLoadAheadStrategyImpl",com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy,{constructor:function(_193a,_193b,_193c){
this.loadAheadLayoutModel=_193a;
this.loadAheadUser=_193c;
this.userModel=null;
var _193d=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _193e=_193d.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION_THEME);
if(pageLoadOptimization===true){
this.loadAheadTheme=_193b;
}else{
this.loadAheadTheme=false;
}
this.serviceJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
var nsf=com.ibm.mm.enabler.model.NameSpaceFactory;
this.ns=nsf.getNameSpaces([nsf.NS_ATOM,nsf.NS_THR,nsf.NS_XML,nsf.NS_OPENSEARCH]);
this.prefix=this.serviceJson.idprefix;
for(prefix in this.serviceJson.namespaces){
this.ns[prefix]=this.serviceJson.namespaces[prefix];
}
},isLoadAheadLayoutModel:function(){
return this.loadAheadLayoutModel;
},isLoadAheadTheme:function(){
return this.loadAheadTheme;
},isLoadAheadUser:function(){
return this.loadAheadUser;
},setUserModel:function(_1940){
this.userModel=_1940;
},getUserModel:function(){
if(null==this.userModel){
this.userModel=com.ibm.mashups.enabler.model.Factory.getUserModel();
}
return this.userModel;
},_processLoadAhead:function(_1941,sync){
if(!com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled()){
return;
}
var _1943=com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
_1943.startTransaction();
if(this.loadAheadUser){
var _1944=this.getUserModel();
_1944.findCurrentUser().start();
}
for(var i=0;i<_1941.length;i++){
if(this.loadAheadLayoutModel){
var href=null;
var id=null;
var expr="atom:link[@rel='related' and @ext:class='content-node']";
var nodes=com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr,_1941[i].xmlData,this.ns);
if(nodes&&nodes.length>0){
href=nodes[0].getAttribute("href");
id=com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix,nodes[0]);
}
var _194a=(id!==null)?id:_1941[i].getID();
var myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href,null);
var _194c=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,false,sync);
_194c.read(dojo.hitch(this,function(type,data,xhr,args){
if((type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD)&&(args.node)){
var _1951=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_1951&&_1951.length>0){
args.node._setFragmentData(_1951[0]);
}
}
}),{"node":_1941[i]});
myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL,null);
myUrl.setNodes([{value:_194a,isID:true},{value:"index.html",isID:false}]);
_194c=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,true,sync);
_194c.read(dojo.hitch(this,function(type,data,xhr,args){
if((type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD)&&(args.node)){
args.node._setFragmentMediaData(data);
}
}),{"node":_1941[i]});
}
if(this.loadAheadTheme){
var _1956=_1941[i].getTheme();
if(_1956!==null){
var _1957=com.ibm.mashups.enabler.model.Factory.getThemeModel();
_1957.find(_1956).start();
}
}
}
_1943.endTransaction();
},_processFind:function(node,sync){
if(this.loadAheadLayoutModel){
var myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_URL,null);
var uri="0";
myUrl.setNodes([{value:uri,isID:true}]);
serviceReq=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,false,sync);
serviceReq.read(dojo.hitch(this,function(type,data,xhr,args){
if((type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD)&&(node)){
var _1960=com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry",data,this.ns);
if(_1960&&_1960.length>0){
node._setFragmentData(_1960[0]);
}
}
}));
myUrl=com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL,null);
myUrl.setNodes([{value:uri,isID:true},{value:"index.html",isID:false}]);
serviceReq=new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl,null,null,true,sync);
serviceReq.read(dojo.hitch(this,function(type,data,xhr,args){
if((type==com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD)&&(node)){
node._setFragmentMediaData(data);
}
}));
}
if(this.loadAheadTheme){
var _1965=com.ibm.mashups.enabler.model.Factory.getThemeModel();
_1965.find("0").start();
}
}});
}
if(!dojo._hasResource["com.ibm.mm.enabler.io.factory"]){
dojo._hasResource["com.ibm.mm.enabler.io.factory"]=true;
dojo.provide("com.ibm.mm.enabler.io.factory");
dojo.declare("com.ibm.mm.enabler.io.XHRMultipartFactoryImpl",null,{constructor:function(){
this.serviceMPJson=null;
if(dojo.exists("com.ibm.mm.enabler.model.ServiceDocumentModel")){
this.serviceMPJson=com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData([com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MODEL,com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MULTIPART]);
}
var _1966=com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
var _1967=_1966.getValue(com.ibm.mashups.enabler.services.ConfigConstants.MULTIPART_ENABLED);
this.doMultipart=false;
if(((null!=this.serviceMPJson)&&(this.serviceMPJson.url))&&(_1967)){
this.doMultipart=true;
}
var _1968=_1966.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION_APP_WIDGETS);
this.multipartAppWidgets=false;
if(typeof (_1968)=="undefined"||_1968==null||_1968===true){
this.multipartAppWidgets=true;
}
if(dojo.isIE==6){
this.doMultipart=false;
}
},create:function(){
return new com.ibm.mm.enabler.io.XHRMultipartImpl();
},isMultipartEnabled:function(){
return this.doMultipart;
},isMultipartApplicationWidgets:function(){
return this.multipartAppWidgets;
}});
com.ibm.mashups.enabler.io.XHRMultipartFactory=new com.ibm.mm.enabler.io.XHRMultipartFactoryImpl();
}
dojo.i18n._preloadLocalizations("com.ibm.mm.enabler.nls.enabler",["ROOT","ar","ca","cs","da","de","de-de","el","en","en-gb","en-us","es","es-es","fi","fi-fi","fr","fr-fr","he","he-il","hr","hu","it","it-it","ja","ja-jp","ko","ko-kr","nl","nl-be","nl-nl","no","pl","pt","pt-br","pt-pt","ro","ro-ro","ru","sk","sl","sv","th","tr","uk","xx","zh","zh-cn","zh-tw"]);
