/* Copyright IBM Corp. 2008  All Rights Reserved.                    */
dojo.provide("com.ibm.mm.enabler.core");
if(!dojo._hasResource["com.ibm.mm.enabler.status"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.status"] = true;
dojo.provide( "com.ibm.mm.enabler.status" );

dojo.declare( "com.ibm.mm.enabler.status.StatusType", 
    null,
    {
    constructor:function(/*int*/id,  /*String*/styleClass, /*String*/ iconPath, /*String*/ colorStr) {
	        this._id = id;
	        this._styleClass = styleClass;
	        this._iconPath = iconPath;
	        this._color = colorStr;  // status color fader start color for this class
	}    
});

dojo.declare( "com.ibm.mm.enabler.status.StatusMessage", 
    null, {
        constructor: function(/*int*/type, /*String*/message, /*String*/details) {
	        this._type = type;
	        this._message = message;
	        this._details = details;
        },
        render: function(containerNode) {
        
            var statusType = com.ibm.mm.enabler.status.statusTypesMap[this._type];

            // status entry base container
            var entry = document.createElement( "div" );
            entry.className = statusType._styleClass;

            // summary header - the colored area of each status message
            var header = document.createElement("h5");
        // Lefthandside (LHS) contains icon, message, and show/hide details
            var header_LHS = document.createElement("div");
            header_LHS.className = "statusHeaderLHS";
            var icon = document.createElement("img");
            icon.src = statusType._iconPath;
            header_LHS.appendChild(icon);
            header_LHS.appendChild(document.createTextNode(this._message));
            header.appendChild(header_LHS);
            entry.appendChild(header);
			if (this._details) {
				var detailsDiv = document.createElement("div");
				detailsDiv.className = "details";
				detailsDiv.appendChild(document.createTextNode(this._details));
				entry.appendChild(detailsDiv);				
			}
			containerNode.appendChild(entry);
        }
    }
);

dojo.declare( "com.ibm.mm.enabler.status.StatusTypesMap", 
    null,  {
    constructor:function()
    {
        this._baseURL=new dojo.moduleUrl("com.ibm.mm.enabler","image/");
       this.error = new com.ibm.mm.enabler.status.StatusType(0, "error",this._baseURL+"error.gif","#FF0000");
        this.warn = new com.ibm.mm.enabler.status.StatusType(1, "warning",this._baseURL+"warning.gif","FFFF00");
        this.info = new com.ibm.mm.enabler.status.StatusType(2, "info",this._baseURL+"info.gif","#0077FF");  
        this.constants={"ERROR":"error","WARN":"warn","INFO":"info"};
    }
});

com.ibm.mm.enabler.status.statusTypesMap = new com.ibm.mm.enabler.status.StatusTypesMap();



}

if(!dojo._hasResource["com.ibm.mashups.enabler.logging"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.logging"] = true;
dojo.provide("com.ibm.mashups.enabler.logging" ); 
dojo.provide("com.ibm.mashups.enabler.logging.LogHandler"); 
dojo.provide("com.ibm.mashups.enabler.logging.Logger");

/**
* The LogLevel class defines a set of standard logging levels that can be used to control logging output. 
* The logging levels are internally ordered. Enabling logging at a given level also enables logging at all higher levels.
*
* Clients should normally use the predefined Level constants such as <code>com.ibm.mashups.enabler.logging.LogLevel.SEVERE</code>.
*
* The levels in descending order are:
* <ul>
* <li>SEVERE (highest value)</li>
* <li>WARNING</li>
* <li>INFO</li>
* <li>TRACE (lowest value)</li>
* </ul>
*
* @ibm-api
*/
dojo.declare("com.ibm.mashups.enabler.logging.LogLevel", null,
{
	/**
	* TRACE is a message level providing tracing information.<br/><br/>
	* TRACE is intended for relatively detailed tracing. The exact meaning of the this levels will vary 
	* between subsystems. 
	* In general the TRACE level should be used for information that will be broadly interesting to developers 
	* who do not have a specialized interest in the specific subsystem.<br/><br/>
	* TRACE messages might include things like minor (recoverable) failures. Issues indicating potential 
	* performance problems are also worth logging as FINE. This level is initialized to <code>500</code>.
	* @type {int}
	*/
	TRACE:   500,
	/**
	* INFO is a message level for informational messages.<br/><br/>
	* Typically INFO messages will be written to the console or its equivalent (like the system messages widget).
	* So the INFO level should only be used for reasonably significant messages that will make sense 
	* to end users and system admins. This level is initialized to <code>800</code>.
	* @type {int}
	*/
	INFO:    800,
	/**
	* WARNING is a message level indicating a potential problem.<br/><br/>
	* In general WARNING messages should describe events that will be of interest to end users or system 
	* managers, or which indicate potential problems. This level is initialized to <code>900</code>. 
	* @type {int}
	*/
	WARNING: 900,
	/**
	* SEVERE is a message level indicating a serious failure.<br/><br/>
	* In general SEVERE messages should describe events that are of considerable importance and which 
	* will prevent normal program execution. They should be reasonably intelligible to end users and to 
	* system administrators. This level is initialized to <code>1000</code>. 
	* @type {int}
	*/
	SEVERE:  1000
});

// instance of the internal log level class for convinient accessing of the LogLevels.
com.ibm.mashups.enabler.logging.LogLevel = new com.ibm.mashups.enabler.logging.LogLevel();

/**
* A <code>LogHandler</code> object takes log messages from a Logger and exports them. It might for example, 
* write them to a console or write them to a widget or whatever. 
* @ibm-spi 
*/
dojo.declare("com.ibm.mashups.enabler.logging.LogHandler",null,
{
	/**
	* @private
	*/
	constructor: function() {
	},
	/**
	* Returns the ID of this handler. This ID needs to be unique and must not be <code>null</code>.
	* @type {String}
	* @return the ID of this handler.
	*/
	getHandlerID: function() {
		return null; 
	},
	/**
	* Get the log level specifying which messages will be logged by this <code>LogHandler</code>. Message levels lower than this level will be discarded. 
	* @type {int}
	* @return the level of messages being logged. The returned int needs to be a log level as defined in com.ibm.mashups.enabler.logging.LogLevel.
	*/
	getLogLevel: function() {
		return null;
	}, 
	/**
	* Method that get's invoked as soon as a subscribed and valid event is published in the logging framework.
	* @param {String} loggerName the name of the logger that published the event.
	* @param {int} logLevel  the LogLevel of the published event.
	* @param {String} method the method that caused the event.
	* @param {String} message the message sent by the method
	* @type {void}
	*/
	log: function(loggerName, logLevel, method, message) {
	} 
});

/**
* A Logger object is used to log messages for a specific system or application component. Loggers are 
* normally named, using a hierarchical dot-separated namespace. Logger names can be arbitrary strings, 
* but they should normally be based on the package name or class name of the logged component, such as com.ibm.mm.enabler or com.ibm.mm.enabler.services.ConfigService.
* <br/><br/>
* Logger objects may be obtained by calls on one of the getLogger factory methods. These will either create a new Logger or return a suitable existing Logger.
* <br/><br/>
* Logging messages will be forwarded to registered Handler objects, which can forward the messages to a variety of destinations, including consoles, files, OS logs, etc.
* <br/><br/>
* Each Logger keeps track of a &quot;parent&quot; Logger, which is its nearest existing ancestor in the Logger namespace. The default Enabler logging framework uses only one parent logger, the &quot;root Logger&quot;
* <br/><br/>
* On each logging call the Logger initially performs a cheap check of the request level (e.g. SEVERE or TRACE) against the effective global log level for the logger. If the request level is lower than the log level, the logging call returns immediately.
* <br/><br/>
* After passing this initial (cheap) test, the Logger will publish a the specified paramters to its output Handlers. By default, if the logger is not the root logger, it also publishes to it's parent's Handlers.
* <br/><br/>
* Most of the logger output methods take a &quot;message&quot; argument. This message argument may be either a raw value or a format string. During formatting, the format string will be filled in with the specified parameters. Otherwise the original message string is used. Typically the logger uses dojo.string.substitute style formatting to format parameters, so for example a format string &quot;${0} ${1}&quot; would format two parameters as strings.
* <br/><br/>
* A global JS object can be used to configure the loggers that are considered for tracing. <br />
* This object is named <code>traceConfig</code> and can be accessed through the ConfigService or initialized by ConfigService.properties<br/><br/>
* <pre>[
* "com.ibm.mashups.*",</br>
* "com.ibm.mm.*"
* ]</pre><br />Additional to the classes that should be logged the <code>isDebug</code> Flag must be set to <code>true</code>.
*/
dojo.declare("com.ibm.mashups.enabler.logging.Logger", null,
{
	/**
	* @private
	*/
	constructor: function() {
	},
	/**
	* Find or create a logger for a named subsystem. If a logger has already been created with the given name it is returned. Otherwise a new logger is created.
	* @ibm-api
	* @param {String} loggerName A name for the logger. This should be a dot-separated name and should normally be based on the package name or class name of the subsystem, such as com.ibm.mm.enabler or com.ibm.mm.enabler.services.ConfigService
	* @type {Logger}
	* @return a suitable Logger 
	*/
	getLogger: function(loggerName) {
		return null;
	},
	/**
	* Adds a handler to the handler chain, so that it is capable of receiving events from the logging framework.
	* @ibm-spi
	* @param {LogHandler} handler the LogHandler to subscribe to the specific logging events.
	* @type {void}
	*/
	addHandler: function(handler) {
	},
	/**
	* Removes a handler from the handler chain and unsubscribing it from the logging framework events.
	* @ibm-spi
	* @param {LogHandler} handler the LogHandler to unsubscribe to the specific logging events.
	* @type {void}
	*/
	removeHandler: function(handler) {
	},
	/**
	* This is a convenience method that can be used to log entry to a method. A event with the message "ENTRY", log level TRACE, and the given methodName is published
	* @ibm-api
	* @param {String} methodName  the name of the method .
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be added to the entering comment in a comma separated way.
	* @type {void}
	*/ 	
	entering: function(methodName, arguments) {
	},
	/**
	* This is a convenience method that can be used to log returning of a method. A event with the message "RETURN", log level TRACE, and the given methodName is published. 
	* This method allows components to trace the exiting of the method.
	* @ibm-api
	* @param {String} methodName  the name of the method .
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be added to the exiting comment in a comma separated way.
	* @type {void}
	*/ 	
	exiting: function(methodName, arguments) {
	},
	/**
	* This method allows components to log an INFO level event.
	* @ibm-api
	* @param {String} methodName  the name of the method .
	* @param {String} message the message that you want to log.
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be filled into the wildcards in your message.
	* @type {void}
	*/ 	
	info: function(methodName, message, arguments) {
	},
	/**
	* This method allows components to log an WARNING level event.
	* @ibm-api
	* @param {String} methodName  the name of the method .
	* @param {String} message the message that you want to log.
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be filled into the wildcards in your message.
	* @type {void}
	*/ 	
	warning: function(methodName, message, arguments) {
	},
	/**
	* This method allows components to log an SEVERE level event.
	* @ibm-api
	* @param {String} methodName  the name of the method .
	* @param {String} message the message that you want to log.
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be filled into the wildcards in your message.
	* @type {void}
	*/ 	
	severe: function(methodName, message, arguments) {
	},
	/**
	* This method allows components to log an TRACE level event.
	* @ibm-api
	* @param {String} methodName  the name of the method .
	* @param {String} message the message that you want to log.
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be filled into the wildcards in your message.
	* @type {void}
	*/ 	
	trace: function(methodName, message, arguments) {
	},
	/**
	* This method allows components to log a logging event for the specified logLevel.
	* @ibm-api
	* @param {int} logLevel the logLevel to use for logging.
	* @param {String} methodName  the name of the method.
	* @param {String} message the message that you want to log.
	* @param {Object[]} arguments  array of arguments that's passed into the method. Those arguments will be filled into the wildcards in your message.
	* @type {void}
	*/ 	
	log: function(logLevel, methodName, message, arguments) {
	},
	/**
	* Check if a message of the given level would actually be logged by this logger.
	* @ibm-api
	* @param {int} logLevel the LogLevel to check
	* @type {boolean}
	* @return <code>true</code> if the given message level is currently being logged.
	*/
	isLoggable: function(logLevel) {
		return false;
	}
});

}

if(!dojo._hasResource["com.ibm.mm.enabler.logging"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.logging"] = true;
dojo.provide("com.ibm.mm.enabler.logging" ); 
dojo.provide("com.ibm.mm.enabler.logging.ConsoleHandler"); 
dojo.provide("com.ibm.mm.enabler.logging.Logger");





dojo.declare("com.ibm.mm.enabler.logging.ConsoleHandler",[com.ibm.mashups.enabler.logging.LogHandler],
{
	constructor: function() {
		this.handlerID = "com.ibm.mm.enabler.logging.ConsoleHandler";
		this.logLevel = com.ibm.mashups.enabler.logging.LogLevel.TRACE;
	},
	getHandlerID: function() {
		return this.handlerID;
	},
	getLogLevel: function() {
		return this.logLevel;
	},
	log: function(loggerName, logLevel, method, message) {
		if (logLevel == com.ibm.mashups.enabler.logging.LogLevel.SEVERE)
			console.error(loggerName + " " + method + ": " + message);
		else if (logLevel == com.ibm.mashups.enabler.logging.LogLevel.WARNING)
			console.warn(loggerName + " " + method + ": " + message);
		else if (logLevel == com.ibm.mashups.enabler.logging.LogLevel.INFO)
			console.info(loggerName + " " + method + ": " + message);
		else if (logLevel == com.ibm.mashups.enabler.logging.LogLevel.TRACE)
			console.debug(loggerName + " " + method + ": " + message);
	} 
});

/**
* This is the root logger class which will automatically dispatch getLoggerRequests and other requests
* to it's real implementors.
*/
dojo.declare("com.ibm.mm.enabler.logging.LoggerImpl", [com.ibm.mashups.enabler.logging.Logger],
{
	BASE_TOPIC: "com.ibm.mm.enabler.logging.",
	
	constructor: function(name, parentLogger) {
		this.loggers = {};
		this.handlers = {};
		
		// make sure those two are really null
		this.name = name?name:null;
		this.parentLogger = parentLogger?parentLogger:null;
		
		if (!this.parentLogger) {
			if (ibmConfig && ibmConfig.traceConfig && dojo.isArray(ibmConfig.traceConfig))
				this._setTraceConfig(ibmConfig.traceConfig);
			else
				this._setTraceConfig();
		}
			
	},
	getLogger: function(name) {
		// if we have a parentlogger dispatch to it
		if (this.parentLogger)
			return this.parentLogger.getLogger(name);
			
		// since we are here we have no parent and need to handle everything be ourself
		if (!this.loggers[name])
			this.loggers[name] = new com.ibm.mm.enabler.logging.LoggerImpl(name, this);
		
		return this.loggers[name];
	},
	addHandler: function(handler) {
		if (this.parentLogger)
			return this.parentLogger.addHandler(handler);
			
		this.handlers[handler.handlerID] = {};
		handlerObject = this.handlers[handler.handlerID];
		handlerObject.handler = handler;
		
		
		// get the handlers desired log level and subscribe him with respect to priority
		// ordering including from RTL severe, warning, info, trace
		var logLevel = handler.getLogLevel();
		var handlerLogMethod = "log";
		
		// always subscribe to severe
		handlerObject.severeHandle = dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.SEVERE, handler, handlerLogMethod);
		
		// subscribe to warning, if warning or finer
		if (logLevel <= com.ibm.mashups.enabler.logging.LogLevel.WARNING)
			handlerObject.warningHandle = dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.WARNING, handler, handlerLogMethod);
			
		// subscribe to info, if info or finer
		if (logLevel <= com.ibm.mashups.enabler.logging.LogLevel.INFO)
			handlerObject.infoHandle = dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.INFO, handler, handlerLogMethod);
			
		// subscribe to trace, if trace or finer
		if (logLevel <= com.ibm.mashups.enabler.logging.LogLevel.TRACE)
			handlerObject.traceHandle = dojo.subscribe(this.BASE_TOPIC+com.ibm.mashups.enabler.logging.LogLevel.TRACE, handler, handlerLogMethod);
	},
	removeHandler: function(handler) {
		var handlerObject = this.handlers[handler.getHandlerID()];
		
		if (handlerObject) {
			if (handlerObject.severeHandle)
				dojo.unsubscribe(handlerObject.severeHandle);
				
			if (handlerObject.warningHandle)
				dojo.unsubscribe(handlerObject.warningHandle);
				
			if (handlerObject.infoHandle)
				dojo.unsubscribe(handlerObject.infoHandle);
				
			if (handlerObject.traceHandle)
				dojo.unsubscribe(handlerObject.traceHandle);
				
			if (handlerObject.handler)
				delete handlerObject.handler;
		}
		
		this.handlers[handler.getHandlerID()] = null
	},
	entering: function(methodName, args) {
		var logLevel = com.ibm.mashups.enabler.logging.LogLevel.TRACE;
		if (this.isLoggable(logLevel)) {
			var msg = this._getMessageString(args); 
			this._log(this.name, logLevel, methodName, "ENTRY" + (msg?" " + msg:""));
		}
			
	},
	exiting: function(methodName, args) {
		var logLevel = com.ibm.mashups.enabler.logging.LogLevel.TRACE;
		if (this.isLoggable(logLevel)) {
			var msg = this._getMessageString(args); 
			this._log(this.name, logLevel, methodName, "RETURN" + (msg?" " + msg:""));
		}
	},
	info: function(methodName, message, args) {
		var logLevel = com.ibm.mashups.enabler.logging.LogLevel.INFO;
		this.log(logLevel, methodName, message, args);
	},
	warning: function(methodName, message, args) {
		var logLevel = com.ibm.mashups.enabler.logging.LogLevel.WARNING;
		this.log(logLevel, methodName, message, args);
	},
	severe: function(methodName, message, args) {
		var logLevel = com.ibm.mashups.enabler.logging.LogLevel.SEVERE;
		this.log(logLevel, methodName, message, args);
	},
	trace: function(methodName, message, args) {
		var logLevel = com.ibm.mashups.enabler.logging.LogLevel.TRACE;
		this.log(logLevel, methodName, message, args);
	},
	log: function(logLevel, methodName, message, args) {
        if (!this.parentLogger) {
            this._log("com.ibm.mashups.enabler.logging.Logger", com.ibm.mashups.enabler.logging.LogLevel.WARNING, "{log|info|warning|severe|trace|entering|exiting}", 
            "You must not use the RootLogger (com.ibm.mashups.enabler.logging.Logger). Create your own logger for each class (https://w3.tap.ibm.com/w3ki03/display/MUM/Client+-+Development)");
        }
		if (this.isLoggable(logLevel))
			this._log(this.name, logLevel, methodName, message, args);
	},
	isLoggable: function(logLevel) {
		// unless we want to also modify loglevels per package return true for LL > TRACE
		if (logLevel != com.ibm.mashups.enabler.logging.LogLevel.TRACE)
			return true;
		
		// if not isDebug is set we don't want to log
		if (!(ibmConfig && ibmConfig.isDebug))
			return false;
			
		var regExp = this._getRegExp();
		
		if (regExp && regExp.exec(this.name))
			return true;
			
		return false;
	},
	_log: function(loggerName, logLevel, methodName, message, args) {
		// for convinience wrap single objects to an object (that user doesn't need to).
		if ((args && !dojo.isArray(args)) || args === false)
			args = [args];
		
		var formattedMessage;
		
		if (args)
			formattedMessage = dojo.string.substitute(message, args);
		else
			formattedMessage = message;
		
		// publish the logging event ...
		dojo.publish(this.BASE_TOPIC + logLevel, [loggerName, logLevel, methodName, formattedMessage]);
	},
	_getMessageString: function(args) {
		var argc = 0;
		var msg = "";
		if (args || args === false) {
			msg += "[ ";
			if (dojo.isArray(args)) {
				msg += args.join(", ");
			} else {
				msg += args;
			}
			
			msg += " ]";
		}
		
		return msg;
	},
	_setTraceConfig: function(traceConfig) {
		if (traceConfig) {
			this._log("RootLogger", com.ibm.mashups.enabler.logging.LogLevel.TRACE, "_setTraceConfig", "Changing traceConfig: " + traceConfig);
			var baseRegExp = dojo.isArray(traceConfig)?traceConfig.join("|"):traceConfig;
			this.regExp = new RegExp(baseRegExp);
		} else
			this.regExp = null;
	},
	_getRegExp: function() {
		if (this.parentLogger)
			return this.parentLogger._getRegExp();
		
		return this.regExp;
	}

});


// create the root logger (no package, no parentlogger)
com.ibm.mashups.enabler.logging.Logger = new com.ibm.mm.enabler.logging.LoggerImpl(); 
// add the default handler to the root logger
com.ibm.mashups.enabler.logging.Logger.addHandler(new com.ibm.mm.enabler.logging.ConsoleHandler());

}

if(!dojo._hasResource["com.ibm.mm.enabler.debug"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.debug"] = true;
dojo.provide( "com.ibm.mm.enabler.debug" );  

dojo.require( "com.ibm.mm.enabler.status" );


com.ibm.mm.enabler.debug.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.legacy"); 

com.ibm.mm.enabler.debug.Constants = {
    MMLogging:"/mm/logging",
    MMStatusMsg:"/mm/statusMsg",
    MMTracing:"/mm/tracing",
    LOG:"log",
    INFO:"info",
    WARN:"warn",
    ERROR:"error"
};

com.ibm.mm.enabler.debug.getObjectArryFromArguments = function (args) {
	if (args.length == 1)
		return null;
		
	var retVal = [];
	
	for (var i=1; i<args.length; i++) {
		retVal[i-1] = args[i];
	}
	
	return retVal;
};


com.ibm.mm.enabler.debug.log = function(/*string*/functionName) { 
//summary: writes a message to firebug console or publish the message.
//description: 
//		This can be used to write tracing statement to firebug console or publish to another page components
//      You may pass as many arguments you may like.
//functionName: function name with class, for example com.ibm.mm.enabler.iw.WidgetStub.getItemSet
	
	var objArr = com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
	
	var msg = com.ibm.mm.enabler.debug.LOGGER._getMessageString(objArr);
	
	com.ibm.mm.enabler.debug.LOGGER.trace(functionName, msg);
	
};

com.ibm.mm.enabler.debug.entry = function ( functionName ) {
//summary: writes a message to indicate function entry.
//description: 
//		This can be used to write a message to indicate it's a funciton entry
//      You may pass as many arguments you may like.
//functionName: function name within the class, for example com.ibm.mm.enabler.iw.WidgetStub.getItemSet

	var objArr = com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
	com.ibm.mm.enabler.debug.LOGGER.entering(functionName, objArr);	
};

com.ibm.mm.enabler.debug.exit = function( functionName ) {
//summary: writes a message to indicate function exit
//description: 
//		This can be used to write a message to indicate function exit
//      You may pass as many arguments you may like.
//functionName: function name within the class, for example com.ibm.mm.enabler.iw.WidgetStub.getItemSet    

	var objArr = com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
	com.ibm.mm.enabler.debug.LOGGER.exiting(functionName, objArr);		
};

com.ibm.mm.enabler.debug.escapeXmlForHTMLDisplay = function( string ) {
	string = string.replace( /</g, "&lt;" );
	string = string.replace( />/g, "&gt;" );
	return string;
};

com.ibm.mm.enabler.debug.info = function(functionName) {
//summary: writes a message as "info"
//description: 
//		This can be used to write a message as "info"  to firebug console or publish to another page components
//      You may pass as many arguments you may like.
//functionName: function name within the class, for example com.ibm.mm.enabler.iw.WidgetStub.getItemSet    

	var objArr = com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
	
	var msg = com.ibm.mm.enabler.debug.LOGGER._getMessageString(objArr);	
	com.ibm.mm.enabler.debug.LOGGER.info(functionName, msg);
};

com.ibm.mm.enabler.debug.warn = function(functionName) {
//summary: writes a message as "warning"
//description: 
//		This can be used to write a message as "warning"  to firebug console or publish to another page components
//      You may pass as many arguments you may like.
//functionName: function name within the class, for example com.ibm.mm.enabler.iw.WidgetStub.getItemSet    
	var objArr = com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
	
	var msg = com.ibm.mm.enabler.debug.LOGGER._getMessageString(objArr);	
	com.ibm.mm.enabler.debug.LOGGER.warning(functionName, msg);
};
com.ibm.mm.enabler.debug.error = function(functionName) {
//summary: writes a message as "error"
//description: 
//		This can be used to write a message as "error"  to firebug console or publish to another page components
//      You may pass as many arguments you may like.
//functionName: function name within the class, for example com.ibm.mm.enabler.iw.WidgetStub.getItemSet    
	var objArr = com.ibm.mm.enabler.debug.getObjectArryFromArguments(arguments);
	
	var msg = com.ibm.mm.enabler.debug.LOGGER._getMessageString(objArr);	
	com.ibm.mm.enabler.debug.LOGGER.severe(functionName, msg);
};
com.ibm.mm.enabler.debug._log = function(type,args) {
    if (com.ibm.mm.enabler.debug.isLogging)
    {   
        if (args.length >= 2 && dojo.isString(args[1])) {
            var arr = [];
            arr.push(args[0]+args[1]);
            for (var i=2;i<args.length;i++) {
                arr.push(args[i]);
            }
            console[type].apply(window.console,arr); 
        }
        else{
            console[type].apply(window.console,args);      
        } 
    }
};
com.ibm.mm.enabler.debug._publishTracing = function(type,args){
    if (typeof ibmConfig  != "undefined" && ibmConfig !== null && ibmConfig.allowPublishTracing === true) {
        var arguments = {};
        arguments.type = type;
        arguments.args = args;
        var temp = [];
        temp[0] = arguments;
        dojo.publish(com.ibm.mm.enabler.debug.Constants.MMTracing,temp);
    }
};
com.ibm.mm.enabler.debug._publishLogging = function(type,args){
    if (typeof ibmConfig  != "undefined" && ibmConfig !== null && ibmConfig.allowPublishLogging === true) {
        var arguments = {};
        arguments.type = type;
        //arguments.message = message;
        arguments.args = args;
        //arguments.details = details;
        var temp = [];
        temp[0] = arguments;
        dojo.publish(com.ibm.mm.enabler.debug.Constants.MMLogging,temp);
    }
};

if (typeof ibmConfig != "undefined" && ibmConfig !== null && ibmConfig.isDebug === true) {
	com.ibm.mm.enabler.debug.isLogging = true;
} else {
	com.ibm.mm.enabler.debug.isLogging = false;
}


com.ibm.mm.enabler.debug.logInlineMessage = function(containerNode,type,message,details,component){
//summary: writes a message to the page dom
//description: 
//		This can be used to write a message to the page dom.
//containerNode: dom element to which the message will be added 
//type: type of message such as "info","warn","error"
//message: message that need to be displayed
//details: detailed information such as exception details
//component: component that throws the message
    var statusMsg  = new com.ibm.mm.enabler.status.StatusMessage(type,message,details);
    if (containerNode) {
        statusMsg.render(containerNode);
    }
    com.ibm.mm.enabler.debug._publishStatusMsg(type,message,details,component);
};

com.ibm.mm.enabler.debug._publishStatusMsg = function(type,message,details,args,component){
    if (typeof ibmConfig  != "undefined" && ibmConfig !== null && ibmConfig.allowPublishStatusMsg === true) {
        var arguments = {};
        arguments.type = type;
        arguments.args = args;
        arguments.message = message;
        arguments.details = details;
        arguments.component = component;
        var temp = [];
        temp[0] = arguments;
        dojo.publish(com.ibm.mm.enabler.debug.Constants.MMStatusMsg,temp);
    }
};

}

if(!dojo._hasResource["com.ibm.mm.enabler.endpoints.endpoints"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.endpoints.endpoints"] = true;
dojo.provide("com.ibm.mm.enabler.endpoints.endpoints");




dojo.declare("com.ibm.mm.enabler.endpoints.XHREndpointExtensionImpl", null, {
    LOG_LEVEL: com.ibm.mashups.enabler.logging.LogLevel.TRACE,
    
    constructor: function(){
        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_METHOD = "dojo.xhrGet()";
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
        
        this.originalDojoXHR = dojo.xhr;
        
        dojo.xhr = dojo.hitch(this, function(/* String */ method, /* dojo.__XhrArgs */ args, /* Boolean */ hasBody) {
            if (this.bIsLoggable) {
                this.LOGGER.entering(this.LOG_METHOD, [args]);
            }
            
            var url = args["url"];
            var url2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(url);
            if (url2 != null) {
                args["url"] = url2;
            }
            
            var ret = this.originalDojoXHR(method, args, hasBody);
            
            if (this.bIsLoggable) {
                this.LOGGER.exiting(this.LOG_METHOD);
            }
            
            return ret;
        });
    }
});

com.ibm.mm.enabler.endpoints.XHREndpointExtension = new com.ibm.mm.enabler.endpoints.XHREndpointExtensionImpl();

}

if(!dojo._hasResource["com.ibm.mm.enabler.services.ConfigService"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.services.ConfigService"] = true;
dojo.provide("com.ibm.mm.enabler.services.ConfigService");
dojo.provide("com.ibm.mm.enabler.services.ConfigObject");



dojo.declare("com.ibm.mm.enabler.services.ConfigService", null, {
    PROXY_URL: "com.ibm.mashups.proxy.url",
    HUB_URL: "com.ibm.mashups.hub.url",
    LOGOUT_URL: "com.ibm.mashups.url.logout",
	LOGIN_URL: "com.ibm.mashups.url.login",
    
    CONTEXT_ROOT_MAIN: "com.ibm.mashups.contextroot",
    CONTEXT_ROOT_THEME_TEMP: "com.ibm.mashups.contextroot.theme.temp",
    CONTEXT_ROOT_BUILDER: "com.ibm.mashups.contextroot.builder",
    CONTEXT_ROOT_ENABLER: "com.ibm.mashups.contextroot.enabler",
    
    CONTENTHANDLER_PUBLIC: "com.ibm.mashups.contenthandler.public",
    CONTENTHANDLER_PRIVATE: "com.ibm.mashups.contenthandler.private",
    
    THEMES_FEEDS_EXPIRATION: "themes.feed.expiration",
    
    AVAILABLE_LOCALES: "available.locales",
    TUNNEL_MODE: "tunnel.mode",
    
    CLIENT_IS_DEBUG: "isDebug",
    CLIENT_IS_BIDI: "isBidi",
    
	WIDGETDEFID_SANDBOX_DISABLED: "com.ibm.mashups.sandbox.force.disable",
	
    CLIENT_ALLOW_PUBLISH_LOGGING: "allowPublishLogging",
    CLIENT_ALLOW_PUBLISH_TRACING: "allowPublishTracing",
    CLIENT_LOAD_SERVICES: "loadServices",
    CLIENT_POPUP_CONSOLE: "popupConsole",
    
    CLIENT_DEFAULT_THEME_ID: "com.ibm.mashups.theme.defaultThemeId",
    CLIENT_PAGE_SOURCE_READ_ONLY: "pageSourceReadOnly",
    CLIENT_AUTO_ACCEPT_SHARED_GROUPNAME: "autoAcceptSharedGroupName",
    CLIENT_USER_ID_KEY: "userIdKey",
    CLIENT_GROUP_CN_KEY: "groupCNKey",
    
    AUTO_WIRING_DEFAULT_ENABLED: "autoWiringDefaultEnabled",
    
    TRACE_CONFIG: "traceConfig",
    MULTIPART_ENABLED: "com.ibm.mashups.multipart.enabled",
    MULTIPART_CORRELATE_HOSTS: "com.ibm.mashups.multipart.correlatehosts",
    SUBDOMAINS: "subdomains",
    SERVERDOMAIN: "serverdomain",
    SANDBOXENABLED: "sandboxenabled",
    ENDPOINTS: "endpointIDs",
    ENDPOINT_CONFIG_PROVIDER: "Endpoints",
    NAVSTATE_PERSISTENCE_URL: "navstate.persistence.url",
    NAVSTATE_PERSISTENCE_PSTORE: "navstate.persistence.pstore",
    NAVSTATE_PERSISTENCE_URL_LIMIT: "navstate.persistence.url.limit",
	CREATE_SPACE_TEMPLATE_MODE: "createSpaceOnTemplateMode",
	FAVORITE_SPACES_MAXIMUM_NUMBER: "favorite.spaces.maximum.number",
	ENABLE_IMPORT_EXPORT_SPACE: "enable_import_export_space",
	WIDGET_BUILDER_ENABLED : "com.ibm.mashups.widgetBuilder.enabled",
    
    ANONYMOUS_USER: "anonymousUser",
	
	DEFAULT_USER_DISPLAY_PROP: "com.ibm.mashups.default.user.display.prop",

	DEFAULT_GROUP_DISPLAY_PROP: "com.ibm.mashups.default.group.display.prop",
	
    PRODUCT_NAME: "com.ibm.mashups.productname",
	
    ANON_VIRTUAL_USER_ID : "com.ibm.mashups.anonUserId",
	
    ALL_AUTH_VIRTUAL_GROUP_ID : "com.ibm.mashups.allAuthGroupId",
	
	ALL_AUTH_VIRTUAL_GROUP_ID : "com.ibm.mashups.allAuthGroupId",
	
	ANON_MODE_ENABLED : "com.ibm.mashups.anonymous.mode",
	
    constructor: function(){
        this.ns = {};
        this.ns["app"] = "http://www.w3.org/2007/app";
        this.ns["atom"] = "http://www.w3.org/2005/Atom";
    },
    
    /**
     * @deprecated
     */
    getPreferenceValue: function( /*string*/name){
        return this.getValue(name);
    },
    
    getValue: function( /*string*/name, internal){
        if (typeof internal == "undefined") {
            com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.services.ConfigService.getValue", "This method must not be used directly. Use com.ibm.mashups.enabler.services.ConfigService.getValue instead.", name);
        }
        //com.ibm.mm.enabler.debug.entry( "ConfigService.getValue",  name );
        var value = ibmConfig[name];
        //com.ibm.mm.enabler.debug.exit( "ConfigService.getValue", value );
        return value;
    },
    
    getConfigObject: function(/*string*/configProvider){
		if (!ibmConfig["CO_"+ configProvider]) {
			var co = new com.ibm.mm.enabler.services.ConfigObject(configProvider, this);
			ibmConfig["CO_"+ configProvider] = co;
		}
		
		return ibmConfig["CO_"+ configProvider];
    },
    
    getConfigProviderNames: function(){
        var ret = [];
        ret.push("all");
        
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.CONFIG_URL, this);
        myUrl.setSchemeSpecificPart("/*");
        myUrl.setParameter("rep", "compact");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, true);
        var me = this;
        serviceReq.read(function(type, data, xhr, args){
            var configXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("//atom:entry/atom:id", data, me.ns);
            if (configXmls && configXmls.length > 0) {
                for (var i = 0; i < configXmls.length; i++) {
                    var configXml = com.ibm.mm.enabler.dom.textContent(configXmls[i]);
                    var lastSlash = configXml.indexOf("/", 9);
                    configXml = configXml.substring(8, lastSlash).trim();;					
					for (config in ibmConfig) {
						if (ibmConfig[config] === configXml) {
							configXml = config.substring(15);
						}
					}
                    ret.push(configXml);
                }
            }
        });
        
        
        return ret;
    }
});

dojo.declare("com.ibm.mm.enabler.services.ConfigObject", null, {
    constructor: function(provider, configService){
		this.valuesArray = null;
        this.provider = provider;
        this.configService = configService;
		this.ns = {};
        this.ns["app"] = "http://www.w3.org/2007/app";
        this.ns["atom"] = "http://www.w3.org/2005/Atom";
    },
    
    /**
     * @deprecated
     */
    getPreferenceValue: function( /*string*/name){
        if (this.provider == "all") {
            return this.configService.getValue(name);
        }
        else {
            return this._getValue(this.provider, name);
        }
        
        return null;
    },
    
    getValue: function( /*string*/name, internal){
        if (typeof internal == "undefined") {
            com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.services.ConfigObject.getValue", "This method must not be used directly. Use com.ibm.mashups.enabler.services.ConfigObject.getValue instead.", name);
        }
        
        if (this.provider == "all") {
            return this.configService.getValue(name, internal);
        }
        else {
            return this._getValue(this.provider, name);
        }
        
        return null;
    },
    
    _getValue: function(/*string*/provider,  /*string*/name){
        if (!this.valuesArray) {
            this._loadConfigData(provider);
        }
        
        return this.valuesArray[name];
    },
    
    _loadConfigData: function(/*string*/ provider){
		var providerCheck = "ConfigProvider." + provider;

		var provider2 = ibmConfig[providerCheck];
		if ((typeof provider2 != "undefined") || (provider2 != null)) {
			provider = provider2;
		}
		
		var ret = {};
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.CONFIG_URL, this);
        myUrl.setSchemeSpecificPart("/" + provider + "/*");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, true);
        var me = this;
        serviceReq.read(function(type, data, xhr, args){
            var configXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("//atom:entry/atom:content/preferences/root/node/map/*", data, me.ns);
            if (configXmls && configXmls.length > 0) {
                for (var i = 0; i < configXmls.length; i++) {
					var name = configXmls[i].getAttribute("key");
					var value = configXmls[i].getAttribute("value");
					ret[name] = value;
                }
            }
        });
		
		this.valuesArray = ret;        
    }
});

com.ibm.mm.enabler.services.CONFIG_SERVICE = new com.ibm.mm.enabler.services.ConfigService();

}

if(!dojo._hasResource["com.ibm.mashups.iwidget.event"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.event"] = true;
dojo.provide("com.ibm.mashups.iwidget.event");
dojo.provide("com.ibm.mashups.iwidget.IEvent");
dojo.provide("com.ibm.mashups.iwidget.IEventDescription");

/**
it carries various pieces of information when an event flows at runtime

  @ibm-api
  */
dojo.declare("com.ibm.mashups.iwidget.IEvent",null,
{	constructor:function () {
	/**
            * @private
            */                 
    },
/**
The name of the event.
@type String
 */		
    name:/*String*/"",
/**
The type of any payload. If this is set to null, no information is being provided. 
@type String
 */
    type:/*String*/"",
/**
The data, if any, being provided by the source of the event.
@type Object
 */	
    payload:/*object*/null,
/**
The iWidget supplied id for the source iWidget.
@type String
 */	
    source:/*String*/""
});


/**
It contains various pieces of information describing an event.

  @ibm-api
  */
dojo.declare("com.ibm.mashups.iwidget.IEventDescription",null,{

	
    constructor:function () {
	/**
            * @private
            */
  },
/**
The name of the event.  
@type String
 */	 
    name:/*String*/"",
/**
The type of any payload. If this is set to null, no information is being provided.
@type String
 */	
    type:/*String*/"",
/**
Optional.If there are other events known to be semantically equivalent, this array provides that information as a hint to the underlying system, which might expose it to the user
@type String[]
@deprecated
@since Deprecated since Version 2.0
 */		
    aliases:/*String[]*/null,
/**
This provides the name of a callback function with the following signature and no return value.
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>   function(ievent,handlerAttributes) </code>
@type String
 */	 	
    handlingFn:/*String*/"",
/**
it returns a user-oriented description (markup allowed) of the event in the requested locale. If no locale is supplied, the default locale of the iWidget is used (with "en" being the default iWidget locale). The description is likely to be displayed when a user is wiring event flow between iWidgets.
 @param{String} locale  required locale. Can be NULL. If no locale is supplied, the default locale of the iWidget is used (with "en" being the default iWidget locale). 
@type String
@returns{String}  Return the description of a given locale,if no locale is provided, then the default locale of the iWidget is used.
@deprecated please use getAttribute("description",locale) instead
@since Deprecated since Version 2.0
 */		
    getDescription:function(/*String*/locale){
          return null; 
    },
/**
This provides the default language of all the localized attributes within this event description.
@type String
 */	 	
    lang:/*String*/"",
/**
This indicates if an event is a handled event or not. Default value is false.
@type Boolean
 */
    isHandled:false,
/**
This indicates if an event is a published event or not. Default value is false.
@type Boolean
 */
   isPublished:false,
/**
This method returns the asking value of an attribute of the event description. Each event description should have title and description . Normally title and description should be globalized, default locale should be specified by using the iso language code, if missing, the value for the default locale will be en. <br/>
@param{String} attributeName  name of attribute. Can  Not be NULL. 
@param{String} locale  required locale. Can be NULL. If no locale is supplied, the default locale of the iWidget is used (with "en" being the default iWidget locale). 
@type String
@returns{String}  Return the value of the required attribute,if locale is provided, it returns locale specific value.
 */		
    getAttribute:function(/*String*/attributeName,/*String*/locale){
          return null; 
    }, 
/**
The method set the value for a given event description attribute.It returns a handle of this eventdescription, return null upon failure. If the locale parameter is absent, then the given attribute won't be locale specific.
@param{String} attributeName  name of attribute. Can  Not be NULL. 
@param{String} attributeValue  value of attribute. Can  Not be NULL. 
@param{String} locale  optional, locale. Can be NULL. 
@type com.ibm.mashups.iwidget.IEventDescription
@returns{com.ibm.mashups.iwidget.IEventDescription}  return a handle of this eventdescription, return null upon failure..
 */		
   setAttribute:function(/*String*/ attributeName, /* String*/ attributeValue, /*String*/ locale){
   }

 });



}

if(!dojo._hasResource["com.ibm.mashups.enabler.context.localized"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.context.localized"] = true;
dojo.provide("com.ibm.mashups.enabler.context.localized");

/**
* LocalizedContext to get the preferred locale, the default locale, as well as titles 
* and descriptions of localized resources within this localized context.
* @ibm-api
*/
dojo.declare( "com.ibm.mashups.enabler.context.LocalizedContext", null,
	{
    	/**
        * @private
        **/
        constructor:function(/*String*/ preferredLocale, /*String*/ defaultLocale) {
        },
        
        /**
        * Returns the preferred locale of this LocalizedContext.
        * @ibm-api
        * @type {String}
        * @return the preferred locale
        */
		getPreferredLocale:function() {
			return new String();
		},
		
        /**
        * Returns the default locale of this LocalizedContext.
        * @ibm-api
        * @type {String}
        * @return the default locale
        */
		getDefaultLocale:function() {
			return new String();			
		},
		
        /**
        * Returns the locale of the localized resource, which matches best the locale set with 
        * ibmConfig.locale, set with the browser, or the default locale.
        * @ibm-api
        * @param {com.ibm.mashups.enabler.Localized} localized resource implementing the Localized interface; must not be <code>null</code>
        * @type {String}
        * @return the preferred locale. Returns <code>null</code> if no locale is available.
        */
        getLocale: function(/*com.ibm.mashups.enabler.Localized*/ localized) {
        	return new String();
        },
		
        /**
        * Returns the title of the localized resource in the locale, which matches best the locale 
        * set with ibmConfig.locale, set with the browser, or the default locale.
        * @ibm-api
        * @param {com.ibm.mashups.enabler.Localized} localized resource implementing the Localized interface; must not be <code>null</code>
        * @type {String}
        * @return the title string in the preferred locale. Returns <code>null</code> if no locale is available.
        */
		getTitle: function(/*com.ibm.mashups.enabler.Localized*/ localized) {
			return new String();
		},

        /**
        * Returns the description of the localized resource in the locale, which matches best the 
        * locale set with ibmConfig.locale, set with the browser, or the default locale.
        * @ibm-api
        * @param {com.ibm.mashups.enabler.Localized} localized resource implementing the Localized interface; must not be <code>null</code>
        * @type {String}
        * @return the description string in the preferred locale. Returns <code>null</code> if no locale is available.
        */
		getDescription: function(/*com.ibm.mashups.enabler.Localized*/ localized) {
			return new String();			
		}
	}
);

}

if(!dojo._hasResource["com.ibm.mashups.enabler.context.factory"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.context.factory"] = true;
dojo.provide("com.ibm.mashups.enabler.context.factory");


/**
* Factory to get context objects.
* @ibm-api
*/
dojo.declare( "com.ibm.mashups.enabler.context.Factory", null,
    {        
        /**
        * @private
        **/
        constructor:function() {
        },
        
        /**
        * Returns a LocalizedContext for the specified locales.
        * @ibm-api
        * @param {String} preferredLocale preferred locale to use; optional, defaults to the locale set 
        * with ibmConfig.locale, or, if this is not set, to the preferred locale set 
        * with the browser
        * @param {String} defaultLocale default locale to use; optional, defaults to the locale "en"
        * @type {com.ibm.mashups.enabler.context.LocalizedContext}
        * @return LocalizedContext for the specified locales.
        */
		getLocalizedContext:function(/*String*/preferredLocale, /*String*/defaultLocale){
			return com.ibm.mashups.enabler.context.LocalizedContext();
		}
	}
);

}

if(!dojo._hasResource["com.ibm.mashups.enabler.context"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.context"] = true;
dojo.provide("com.ibm.mashups.enabler.context");



}

if(!dojo._hasResource["com.ibm.mm.iwidget.eventImpl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.eventImpl"] = true;
dojo.provide("com.ibm.mm.iwidget.eventImpl");

dojo.provide("com.ibm.mm.iwidget.eventImpl");
dojo.provide("com.ibm.mm.iwidget.iEventDescriptionImpl");
dojo.provide("com.ibm.mm.iwidget.iEvents");




dojo.declare("com.ibm.mm.iwidget.iEventImpl", com.ibm.mashups.iwidget.IEvent, {

    constructor: function(/*String*/name,/*String*/ type,/*Object*/ payload,/*String*/ source){
        this.name = name;
        
        if (typeof type != "undefined") 
            this.type = type;
        else 
            this.type = null;
        
        if (typeof payload != "undefined") 
            this.payload = payload;
        else 
            this.payload = null;
        
        if (typeof source != "undefined") 
            this.source = source;
        else 
            this.source = null;
        this.source = source;
    }
});

dojo.declare("com.ibm.mm.iwidget.iEventDescriptionImpl", com.ibm.mashups.iwidget.IEventDescription, {

    constructor: function(/*String*/name,/*function*/ handlingFn,/*String*/ type,/*String*/ description,/*String[]*/ aliases, defaultLang,/*[]*/ descriptions){
        if (dojo.isString(name)) {
            /*backward compatibility, some widget are still trying to create iEventDescription by using this constuctor as is!*/
            var obj = {};
            obj.name = name;
            if (handlingFn && handlingFn != null) {
                obj.handlingFn = handlingFn;
                obj.isHandled = true;
                obj.isPublished = false; //backward compatibility either isPublished or isHandled
            }
            else {
                obj.isPublished = true;
            }
            
            if (typeof type != "undefined" && type != null) 
                obj.type = type;
            
            if (typeof defaultLang != "undefined" && defaultLang != null) 
                obj.lang = defaultLang;
            else {
                obj.lang = "en";
            }
            //how to set isPublished? or set it later
            obj.attributes = {};
            obj.localizedAttributes = {};
            if (typeof aliases != "undefined" && aliases != null) 
                obj.attributes.aliases = aliases;
            if (typeof descriptions != "undefined" && descriptions != null) {
                obj.localizedAttributes = descriptions;
            }
            //backward compatibility
          
			if (description && description != null) {
				if (!obj.localizedAttributes[obj.lang]) obj.localizedAttributes[obj.lang] = {};
                obj.localizedAttributes[obj.lang].description = description;
			}	
           
            this._internalJsonObj = obj;
        }
        else {
            this._internalJsonObj = name;
        }
        this.initPredefinedFields(this._internalJsonObj);
    },
    initPredefinedFields: function(obj){
        //initialize  fields
        this.name = obj.name;
        this.type = obj.type;
        this.lang = obj.lang;
        this.handlingFn = obj.handlingFn;
        if (this.handlingFn && this.handlingFn != null) 
            this.isHandled = true;
        else 
            this.isHandled = false;
        // set isPublished to true only when both isHandled and isPublished is not defined 
        // this is required for backward compatiblity reason
		if ((obj.isPublished && obj.isPublished == "true") ||(obj.isPublished && obj.isPublished == true) ) 
            this.isPublished = true;
    },
    getDescription: function(locale){
        return this._getLocalizedAttribute("description", locale);
    },
    getTitle: function(locale){
        return this._getLocalizedAttribute("title", locale);
    },
    _getLocalizedAttribute: function(attributeName, locale){
        var attValue = null, altAttValue = null;
		var lc = com.ibm.mashups.enabler.context.Factory.getLocalizedContext();
        var finalLocale = lc.getLocale(this, locale, this.lang);
        if (typeof this._internalJsonObj.localizedAttributes != "undefined" && this._internalJsonObj.localizedAttributes != null) {
            altAttValue = this._internalJsonObj.localizedAttributes[finalLocale];
            if (typeof altAttValue != "undefined" && altAttValue != null) {
                attValue = altAttValue[attributeName];
            }
        }
        if (typeof attValue == "undefined" || attValue == null) {
            attValue = this[attributeName];
        }
        
        if (typeof attValue == "undefined") 
            attValue = null;
        return attValue;
    },
    setOnRemoveWire: function(/*String*/handler){
        if (typeof handler == "undefined" || handler === null) {
            handler = "onRemoveWire";
        }
        //this.onRemoveWire = handler;    
        this._internalJsonObj.attributes["onRemoveWire"] = handler;
        return this;
    },
    getOnRemoveWire: function(){
        //can remove?
        if (this._internalJsonObj.attributes["onRemoveWire"]) {
            return this._internalJsonObj.attributes["onRemoveWire"];
        }
        return null;
    },
    setOnNewWire: function(/*String*/handler){
        if (typeof handler == "undefined" || handler === null) {
            handler = "onNewWire";
        }
        //this.onNewWire = handler;  
        this._internalJsonObj.attributes["onNewWire"] = handler;
        return this;
    },
    getOnNewWire: function(){
        if (this._internalJsonObj.attributes["onNewWire"]) {
            return this._internalJsonObj.attributes["onNewWire"];
        }
        return null;
    },
    getLocales: function(){
        var locales = [];
        if (typeof this._internalJsonObj.localizedAttributes != "undefined" && this._internalJsonObj.localizedAttributes != null) {
            for (var i in this._internalJsonObj.localizedAttributes) {
                locales.push(i);
            }
        }
        return locales;
    },
	 toString: function(){
	        //return null or unserialized string, dojo will throw exception if it's not a valid Json obj
		var temp = this.toJson();
        return dojo.toJson(temp);
    },
	_getInternalJsonObj:function(){
		return this._internalJsonObj;
	},
    toJson: function(){
		var internalJson = {};
		for (var i in this._internalJsonObj){
			if (i == "handlingFn"){ //it could be functionpointer
				if(dojo.isFunction(this._internalJsonObj[i]) == true){
					internalJson[i] = "HANDLEFN";
				continue;
				}
			}
			internalJson[i] = dojo.clone(this._internalJsonObj[i]);		
		}
		
        return internalJson;
   },
    clone: function(){
        var temp = dojo.toJson(this._internalJsonObj);
        if (temp != null) 
            return new com.ibm.mm.iwidget.iEventDescriptionImpl(dojo.fromJson(temp));
        else 
            return null;
    },
    getAttribute: function(attName, locale){
        if (typeof attName == "undefined " || attName == null) 
            return null;
        if (typeof locale == "undefined" || locale == null) {
            if (this._internalJsonObj.attributes && this._internalJsonObj.attributes[attName] && (this._internalJsonObj.attributes[attName] != null)) {
                return this._internalJsonObj.attributes[attName];
            }
            //get value for default locale
            if (this._internalJsonObj.localizedAttributes && this._internalJsonObj.localizedAttributes[this.lang] && (this._internalJsonObj.localizedAttributes[this.lang] != null)) {
                var attValue = this._internalJsonObj.localizedAttributes[this.lang][attName];
                if (typeof attValue != "undefined" && attValue != null) 
                    return attValue;
            }
            return null; //if no such attributes or localized attributes
        }
        else {
         	return this._getLocalizedAttribute(attName,locale);
        }
    },
    setAttribute: function(attName, attValue, locale){
        //todo; if no locale defined and attributes is predefined such as "title","description", set the value on default locale
        //return a handle of this eventdescription, return null upon failure.
        if (typeof attName == "undefined" || attName == null) 
            return null;
        if (typeof attValue == "undefined") 
            return null; // allow value to be null
        if (typeof locale == "undefined" && locale == null) {
            this._internalJsonObj.attributes[attName] = attValue;
            if (attValue == null) 
                delete this._internalJsonObj.attributes[attName];
            return this;
        }
        if (!this._internalJsonObj.localizedAttributes[locale]) 
            this._internalJsonObj.localizedAttributes[locale] = {};
        this._internalJsonObj.localizedAttributes[locale][attName] = attValue;
        if (attValue == null) 
            delete this._internalJsonObj.localizedAttributes[locale][attName];
        return this;
    }
});


dojo.declare("com.ibm.mm.iwidget.iEventsConstants", null, {
    constructor: function(){
        /**
         * @private
         */
    },
    onLoad:/*String*/ "onLoad",
    onUnLoad:/*String*/ "onUnload",
    onModeChanged:/*String*/ "onModeChanged",
    onItemSetChanged:/*String*/ "onItemSetChanged",
    unloadWidget:/*String*/ "/enabler/unloadWidget",
    unSubscribeWire:/*String*/ "/enabler/unSubscribeWire",
    modeChanged:/*String*/ "modeChanged"
});
com.ibm.mm.iwidget.iEvents.Constants = new com.ibm.mm.iwidget.iEventsConstants();



}

if(!dojo._hasResource["com.ibm.mashups.services"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.services"] = true;
dojo.provide("com.ibm.mashups.services");
dojo.provide("com.ibm.mashups.services.ServiceManager");

/**
 This interface manages services that are provided to the system, i.e. to iWidgets and other components.<br/>
 It provides capability to access Services in Lotus Mashups. <br/>
 By default EventService and ConfigService are provided.<br/>
 Page components are able to use event services by using following api:<p/>
 <code>var eventService = com.ibm.mashups.services.ServiceManager.getService(<br/>
 &nbsp;&nbsp;&nbsp;&nbsp;com.ibm.mashups.iwidget.services.EventService.SERVICE_NAME);</code><br/>
 <p/><p/>
<b>Configuration of services:</b><br/>
 This section describes how each service is configured and  how additional services can be added.<p/>
 
 Through the ConfigService.properties one can define an additional property named "additionalServices" 
 defining additional services besides EventService and ConfigService.<p/>
 Each entry should have the following format.<p />
 <code>"name": service name.</code><br/>
 <code>"path": url that point to the service js file.</code><br/>
 <code>"baseClass": the class that implements the service. one instance of this class will be generated.</code><br />
 <p/>
 Example:<br/>
  &nbsp;&nbsp;&nbsp;additionalServices = [<br/>
  &nbsp;&nbsp;&nbsp;{ "name":"SecurityService",<br/>
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"path":"/mum/js/com/ibm/enabler/iw/securityservices.js",<br/>
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"baseClass":"com.ibm.mm.iwidget.services.SecurityService"}<br/> 
  &nbsp;&nbsp;&nbsp;] <p />

   @ibm-spi
  */
dojo.declare("com.ibm.mashups.services.ServiceManager",null,
  {
    /**
     * @private
     */
    constructor:function(){
    },
    /**
    This interface allow page components to get the required service.
    @param{String} serviceName required service name that's used to uniquely identify a service .
    @type Object
    @returns{Object} an instance of required service. NULL if configured incorrectly.
    */
    getService:function(serviceName) {
    }
  }
);


}

if(!dojo._hasResource["com.ibm.mm.enabler.services"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.services"] = true;
dojo.provide( "com.ibm.mm.enabler.services");






dojo.declare("com.ibm.mm.enabler.services.ConfigServiceImpl",[com.ibm.mm.enabler.services.ConfigService],
{
    constructor: function() {
        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.services.ConfigService");
    },
    getValue: function (name) {
        var METHOD_NAME = "getValue(name)";
        var bIsLogging = this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
        if (bIsLogging)
            this.LOGGER.entering(METHOD_NAME, name);

        var ret = com.ibm.mm.enabler.services.CONFIG_SERVICE.getValue(name, true);

        if (bIsLogging)
            this.LOGGER.exiting(METHOD_NAME, ret);
        return ret;
    } ,
    
    getConfigObject: function (name) {
        var METHOD_NAME = "getConfigObject(name)";
        var bIsLogging = this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
        if (bIsLogging)
            this.LOGGER.entering(METHOD_NAME, name);

        var ret = new com.ibm.mm.enabler.services.ConfigObjectImpl(name);

        if (bIsLogging)
            this.LOGGER.exiting(METHOD_NAME, ret);
        return ret;

     },

     getConfigProviderNames: function () {
         var METHOD_NAME = "getConfigProviderNames()";
         var bIsLogging = this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
         if (bIsLogging)
             this.LOGGER.entering(METHOD_NAME, name);

         var ret = com.ibm.mm.enabler.services.CONFIG_SERVICE.getConfigProviderNames();

         if (bIsLogging)
             this.LOGGER.exiting(METHOD_NAME, ret);
         return ret;
     }
    
});

dojo.declare("com.ibm.mm.enabler.services.ConfigObjectImpl",[com.ibm.mm.enabler.services.ConfigObject],
		{
		    constructor: function(provider) {
		        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.services.ConfigObject");
		        this.provider = provider;
		    },
		    
		    getValue: function (name) {
		        var METHOD_NAME = "getValue(name)";
		        var bIsLogging = this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
		        if (bIsLogging)
		            this.LOGGER.entering(METHOD_NAME, name);

		        var co = com.ibm.mm.enabler.services.CONFIG_SERVICE.getConfigObject(this.provider);
		        var ret = null;
		        if (co) {
		            ret = co.getValue(name, true);
		        }

		        if (bIsLogging)
		            this.LOGGER.exiting(METHOD_NAME, ret);
		        return ret;
		    } 		    
		});


}

if(!dojo._hasResource["com.ibm.mashups.enabler.services"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.services"] = true;
dojo.provide("com.ibm.mashups.enabler.services");
dojo.provide("com.ibm.mashups.enabler.services.ConfigService");
dojo.provide("com.ibm.mashups.enabler.services.ConfigObject");
dojo.provide("com.ibm.mashups.enabler.services.ConfigConstants");

/**
 * The Config Service allows to access config variables as defined by the system.
 * The service can be retrieved using the following code: <br>
 * <code>var configService = com.ibm.mashups.services.ServiceManager.getService(<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);</code><br/>
 * @ibm-spi
 */
dojo.declare("com.ibm.mashups.enabler.services.ConfigService", null, {
    /**
     * The service name to be used to fetch the service from the ServiceManager
     * @type String
     */
    SERVICE_NAME: "configService",
    
    /**
     * This method returns the value of the config variable as defined by the system
     * @param {String} name the name of the config variable
     * @return {String} the value of the config variable. Maybe be NULL.
     */
    getValue: function(name) {
        return null;
    },
    
    /**
     * This method returns the value of the config object for a config provider
     * @param {String} name the name of the config provider
     * @return {ConfigObject} the config provider. Maybe be NULL.
     */
    getConfigObject: function(name) {
        return null;
    },
    
    /**
     * This method returns the Config Provider names.  Each Config Provider will
     * have a corresponding ConfigObject.
     * @return {String[]} the config provider names. Never NULL.
     */
    getConfigProviderNames: function() {
        return null;
    }
});

/**
 * The Config Object allows to access config variables as defined by the system.
 * for a specific config provider.
 * @ibm-spi
 */
dojo.declare("com.ibm.mashups.enabler.services.ConfigObject", null, {
    /**
     * This method returns the value of the config variable as defined by the system
     * @param {String} name the name of the config variable
     * @return {String} the value of the config variable. Maybe be NULL.
     */
    getValue: function(name) {
        return null;
    }
});

// make sure we can reference this globally
com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME = "configService";

/**
 * This constants class contains well defined constants available to the config service.
 * They are defined in the ConfigService.properties
 * @ibm-spi
 */
dojo.declare("com.ibm.mashups.enabler.services.ConfigConstants", null, {
    /**
     * URL pointing to the proxy
     * @type String
     */
    PROXY_URL: "com.ibm.mashups.proxy.url",
    
    /**
     * URL pointing to the hub
     * @type String
     */
    HUB_URL: "com.ibm.mashups.hub.url",
    
    /**
     * URL pointing to login
     * @type String
     */
    LOGIN_URL: "com.ibm.mashups.url.login",
    
    /**
     * URL pointing to logout
     * @type String
     */
    LOGOUT_URL: "com.ibm.mashups.url.logout",
    
    /**
     * context root of the enabler
     * @type String
     */
    CONTEXT_ROOT_ENABLER: "com.ibm.mashups.contextroot.enabler",
    /**
     * context root of the server
     * @type String
     */
    CONTEXT_ROOT: "com.ibm.mashups.contextroot",
    
    /**
     * public name of the content handler servlet
     * @type String
     */
    CONTENTHANDLER_PUBLIC: "com.ibm.mashups.contenthandler.public",
    /**
     * private name of the content handler servlet
     * @type String
     */
    CONTENTHANDLER_PRIVATE: "com.ibm.mashups.contenthandler.private",
    
    /**
     * public name of the embedding handler servlet
     * @type String
     */
    EMBEDDING_PUBLIC: "com.ibm.mashups.embedding.public",
    /**
     * private name of the content handler servlet
     * @type String
     */
    EMBEDDING_PRIVATE: "com.ibm.mashups.embedding.private",
    
    /**
     * TBD
     * @type String
     */
    THEMES_FEEDS_EXPIRATION: "themes.feed.expiration",
    
    /**
     * comma separated list of all available locales in the system
     * @type String
     */
    AVAILABLE_LOCALES: "availableLocales",
    /**
     * defines whether PUT/DELETE tunneling over POST should be used
     * @type String
     */
    TUNNEL_MODE: "tunnel.mode",
    
    /**
     * turns on debugging
     * @type String
     */
    CLIENT_IS_DEBUG: "isDebug",
    
    /**
     * BiDi setting
     * @type String
     */
    CLIENT_IS_BIDI: "isBidi",
    
    /**
     * Definition Url list of the widgets which is sandbox disabled: /dataEditor/dataEditor.xml,id1,id2
     * @type String
     */
    WIDGETDEFID_SANDBOX_DISABLED: "com.ibm.mashups.sandbox.force.disable",
    
    /**
     * Trace configuration for the client runtime
     * @type String
     */
    TRACE_CONFIG: "traceConfig",
    /**
     * tbd
     * @type String
     */
    CLIENT_POPUP_CONSOLE: "popupConsole",
    /**
     * tbd
     * @type String
     */
    CLIENT_ALLOW_PUBLISH_LOGGING: "allowPublishLogging",
    /**
     * tbd
     * @type String
     */
    CLIENT_ALLOW_PUBLISH_TRACING: "allowPublishTracing",
    /**
     * tbd
     * @type String
     */
    CLIENT_ADDITIONAL_SERVICES: "additionalServices",
    
    /**
     * Theme id used in case no theme is set.
     * @type String
     */
    CLIENT_DEFAULT_THEME_ID: "com.ibm.mashups.theme.defaultThemeId",
    /**
     * tbd
     * @type String
     */
    CLIENT_PAGE_SOURCE_READ_ONLY: "pageSourceReadOnly",
    /**
     * Group name used for auto accepting pages
     * @type String
     */
    CLIENT_AUTO_ACCEPT_SHARED_GROUPNAME: "autoAcceptSharedGroupName",
    /**
     * Default value for page level auto wiring enablement
     * @type String
     */
    AUTO_WIRING_DEFAULT_ENABLED: "autoWiringDefaultEnabled",
    /**
     * tbd
     * @type String
     */
    CLIENT_USER_ID_KEY: "userIdKey",
    /**
     * tbd
     * @type String
     */
    CLIENT_GROUP_CN_KEY: "groupCNKey",
    /**
     * Url used to fetch the service document
     * @type String
     */
    SERVICE_DOCUMENT_URL: "serviceDocumentUrl",
    /**
     * turns on multipart support
     * @type String
     */
    MULTIPART_ENABLED: "com.ibm.mashups.multipart.enabled",
    /**
     * if multipart support is enabled, determines if requests are correlated
     * by hostname
     * @type String
     */
    MULTIPART_CORRELATE_HOSTS: "com.ibm.mashups.multipart.correlatehosts",
    /**
     * Returns the semicolon separated list of Endpoint IDs
     * @type String
     */
    ENDPOINTS: "endpointIDs",
    /**
     * Returns the name of the Endpoints Config Provider
     * @type String
     */
    ENDPOINT_CONFIG_PROVIDER: "Endpoints",
    /**
     * Returns the name of the Anonymous User Config setting
     * @type {String}
     */
    ANONYMOUS_USER: "anonymousUser",
    /**
     * Returns the name of the current User Config setting
     *@type String
     */
    USER: "user",
    /**
     * Returns the name of subdomains Config setting, subdomains are used to create sandboxed iwidgets
     *@type String
     */
    SUBDOMAINS: "subdomains",
    /**
     * Returns the name of server domain Config setting
     *@type String
     */
    SERVERDOMAIN: "serverdomain",
    /**
     * Returns the name of sandboxenabled Config setting, sandboxed feature is disabled if this configuration is set to false
     *@type String
     */
    SANDBOXENABLED: "sandboxenabled",
    /**
     * Returns the name of config setting that decides if subdomain should be reused when an existing sandboxed iwidget is removed from the page.
     *@type String
     */
    SUBDOMAINREUSE: "subdomainreuse",
    /**
     * MetaData name used to indicate attributes that need to added to url
     *@type String
     */
    NAVSTATE_PERSISTENCE_URL: "navstate.persistence.url",
    /**
     * MetaData name used to indicate attributes that need to added to persistence store
     *@type String
     */
    NAVSTATE_PERSISTENCE_PSTORE: "navstate.persistence.pstore",
    /**
     * MetaData name used to indicate number of widgets whose navigation state will be added to url
     *@type String
     */
    NAVSTATE_PERSISTENCE_URL_LIMIT: "navstate.persistence.url.limit",
    /**
     * MetaData name used to indicate if navigation state is huffmann encoded or not
     *@type String
     */
    NAVSTATE_HUFFMANNENCODE_ENABLED: "navstate.huffmannencode.enabled",
    /**
     * MetaData name used to indicate the html fragment that's displayed when a widget is under loading
     *@type String
     */
    LOADING_HTML: "loadingHTML",
    
    /**
     * Specified whether pageloading should be optimized (Multipart)
     */
    PAGE_LOAD_OPTIMIZATION: "pageLoadOptimization",
    
    /**
     * Specified whether pageloading should be optimized for themes (Multipart)
     */
    PAGE_LOAD_OPTIMIZATION_THEME: "pageLoadOptimizationTheme",
	
	/**
	 * Specifies whether application widgets should be optimized (Multipart)
	 */
	PAGE_LOAD_OPTIMIZATION_APP_WIDGETS: "pageLoadOptimizationAppWidgets",
    
    /**
     * Allows to create New Spaces and Pages for anonymous users
     */
    ANONYMOUS_ALLOW_CREATE: "com.ibm.mashups.anonymous.allow.create",
    
    /**
     * If displayName is not sent from server use this property for User Display Name
     */
    DEFAULT_USER_DISPLAY_PROP: "com.ibm.mashups.default.user.display.prop",
    
    /**
     * The product name which will show up in the browser title, other product can replace it.
     */
    PRODUCT_NAME: "com.ibm.mashups.productname",
    
    /**
     * If displayName is not sent from server use this property for Group Display Name
     */
    DEFAULT_GROUP_DISPLAY_PROP: "com.ibm.mashups.default.group.display.prop",
    
    /**
     * The unique name of the welcome space
     */
    WELCOME_SPACE_ID: "com.ibm.mashups.welcome.space.name",
    
    /**
     * The filter as regexp for characters used on page and space title.
     */
    BUILDER_TITLE_FILTER_REGEXP : "com.ibm.mashups.builder.filter.title.regexp",
	
	/**
     * ID of the Anonymous Virtual User
     */
    ANON_VIRTUAL_USER_ID : "com.ibm.mashups.anonUserId",
	
	/**
     * ID of the All Authenticated Users Virtual Group
     */
    ALL_AUTH_VIRTUAL_GROUP_ID : "com.ibm.mashups.allAuthGroupId",
    
    /**
     * The server type this enabler is connected to. It can be either SERVER_TYPE_MASHUPS or SERVER_TYPE_PORTAL
     */
    SERVER_TYPE : "com.ibm.mashups.server",

    /**
     * The server type value for Lotus Mashups
     */
    SERVER_TYPE_MASHUPS : "Lotus_Mashups",

    /**
     * The server type value for WebSphere Portal
     */
    SERVER_TYPE_PORTAL : "WebSphere_Portal",
	
	/**
	 * Anonymous mode enabled default is false
	 */
	ANON_MODE_ENABLED : "com.ibm.mashups.anonymous.mode"
});

com.ibm.mashups.enabler.services.ConfigConstants = new com.ibm.mashups.enabler.services.ConfigConstants();

// now we add the impl


}

if(!dojo._hasResource["com.ibm.mm.enabler.utilities"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.utilities"] = true;
dojo.provide("com.ibm.mm.enabler.utilities");
dojo.provide("com.ibm.mm.enabler.ArrayMap");







com.ibm.mm.enabler.utilities = {
	
	rewriteURL: function (/*String*/ targetUrl) {
		var _targetURL = new com.ibm.mm.enabler.utilities.HttpUrl ( targetUrl );
		
		return _targetURL.toProxifiedString();
	},
    encodePath: function(path) {
        if (path.length == 0)
            return path;
            
        var parts = path.split("/");
        
        for (var i=0; i<parts.length; ++i) {
            parts[i] = escape(unescape(parts[i]));
        }
        
        return parts.join("/");
    },
    inStringArray:function(str,/*[]*/arrayObj)
    {
        var rc = false;
        for (var i in arrayObj) {
            var temp1 = arrayObj[i];
            if (temp1 == str) {
                rc = true;
                break;
            }
        }
        return rc;
    },
	isEmpty: function (object) {
		for(var i in object) {
			return false;
		}
		return true;
	},
    getLocale:function(/*com.ibm.mashups.enabler.Localized*/localized,aLocale,defaultLocale){

		// warn
        com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.utilities.getLocale", "Deprecated. Use com.ibm.mashups.enabler.context.Factory.getLocalizedContext().getLocale() instead.");

		if (typeof localized == "undefined" || localized === null) return null;
		
		var localeArr = localized.getLocales();
		if (typeof localeArr == "undefined" || localeArr === null || !dojo.isArray(localeArr)) return null;
		
		if (localeArr.length === 0) return null;
		
		var returnLocale = null;
		if (localeArr.length === 1) returnLocale =  localeArr[0];
		
		var arr = {};
		for (var i in localeArr){
			var temp = localeArr[i];
			arr[temp]=temp;
		}
		
		if (returnLocale === null) {
			if (typeof aLocale != "undefined" && aLocale !== null) {
			    returnLocale = this.findMatchLocale(arr,aLocale);
				if (returnLocale === null )
				{
					var tempArr = aLocale.split(/-|_/);
					if (tempArr.length == 2) {
						var iLocale = tempArr[0];
						if (typeof arr[iLocale] != "undefined" && arr[iLocale] !== null) {
							returnLocale = iLocale;
						}
					}
				}
			}
		}
		if (returnLocale === null){
			//get browser locale
            var browserLocale = (dojo.isIE ? navigator.userLanguage : navigator.language).toLowerCase();
            if (typeof ibmConfig != "undefined" && ibmConfig != null && typeof (ibmConfig.locale) != "undefined" && ibmConfig.locale != null) {
               browserLocale = ibmConfig.locale;
            }  
            if (browserLocale !== null){
					//browserLocale = browserLocale.replace(/-/,"_");
			    	returnLocale = this.findMatchLocale(arr,browserLocale);
					if (returnLocale === null){
					    var tempArr = browserLocale.split(/-|_/);
						if (tempArr.length == 2) {
							var tempLocale = tempArr[0];
							if (typeof arr[tempLocale] != "undefined" && arr[tempLocale] !== null) {
								returnLocale = tempLocale;
							}
						}				
					}				
			}
		}
		
		if (returnLocale === null){
			if (typeof defaultLocale != "undefined" && defaultLocale != null)
		    returnLocale = defaultLocale;
		}
		if (returnLocale === null){
			if (typeof arr["en"] != "undefined" && arr["en"]!== null){
				returnLocale = "en";
			}
		}
		if (returnLocale === null){
			returnLocale = localeArr[0];
		}
		return returnLocale;	
	},
	findMatchLocale:function(arr,locale){
		
		com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.utilities.findMatchLocale", "Deprecated. Use com.ibm.mm.enabler.utilities.matchLocale() instead.");
		
		var returnLocale = null;
		if (typeof arr[locale] != "undefined" && arr[locale] != null)
		{
			returnLocale = locale;
		}
		var serverLocale = this.toServerLocale(locale);
		if (returnLocale === null && (typeof arr[serverLocale] != "undefined" && arr[serverLocale] != null)){
			returnLocale = serverLocale;			
		}
		var serverLocaleLowercase  = serverLocale.toLowerCase();
		if (returnLocale === null && (typeof arr[serverLocaleLowercase] != "undefined" && arr[serverLocaleLowercase] != null)){
			returnLocale = serverLocaleLowercase;			
		}
		return returnLocale;		
	},
	
	/**
	 * match a locale against an array of locales
	 * 
	 * TODO: also allow preferred to be an array
	 * 
	 * @param {String} preferred
	 * @param {Array} available
	 */
	matchLocale: function(preferred, available) {
		return com.ibm.mm.enabler.utilities._matchLocale(
			com.ibm.mm.enabler.utilities._getLocaleObj(preferred),
			com.ibm.mm.enabler.utilities.normalizeLocale(available));
	},
	
	/**
	 * match a normalized locale against an array of normalized locales
	 * 
	 * FIXME: we need to add handling of multiple possible locales matching against multiple available ones,
	 * keeping in mind the order the user defined and also handling for exceptions
	 * (e.g. pt-br must not fall back to pt, sh traditional must fall back to simplified, etc.)
	 * 
	 * @param {Object} locale an locale object
	 * @param {Array} locales an Array of normalized locale strings
	 */
	_matchLocale: function(locale, locales, stop) {
		
		// console.debug("match locale:",locale,"against",locales);
		
		var _origLocale = locale;
		
		var match = null;
		var found = dojo.some(locales,function(item) {
			if(item == locale.toString()) {
				match = item;
				return true;	
			}
		});
		if(found && match) {
			return match;
		}
	
		if(locale.variant) {
			// try without variant
			locale.variant = null;
			return com.ibm.mm.enabler.utilities._matchLocale(locale,locales);
		}
		
		if(locale.country) {
			// try without country
			locale.country = null;
			return com.ibm.mm.enabler.utilities._matchLocale(locale,locales);
		}
		if(!stop) {
			// TODO: make list of aliases [he,iw], to automate this for other fallbacks.
		
			locale = _origLocale;
			switch(locale.language) {
				case 'he':
					// special handling for hebrew (he and iw (old) are equal)
					locale.language = "iw";
					break;
				case 'iw':
					// special handling for hebrew (he and iw (old) are equal)
					locale.language = "he";
					break;
			}
			return com.ibm.mm.enabler.utilities._matchLocale(locale,locales,true);
		}
		
		return null;
		
		
		/*
		
		// match full locale
		var result = locales[locale];

		// match variant & language part
		if (!result) {
			// direct match not possible
			
			if(!originalLocale) {
				// was not a recursive call, so set original
				originalLocale = locale;
			}
			
			if(locale.indexOf('_') != -1) {
				// locale has either country or variant extension
				return this._matchLocale(locale.substr(0,locale.lastIndexOf('_')),locales,locale) || null;
			}

			// special handling for hebrew (he and iw (old) are equal)
			if(locale.indexOf("he") === 0) {
				// locale starts with "he", so check if there are any "iw" locales available
				return this._matchLocale("iw"+originalLocale.substr(2),locales,locale);
			}
			if(locale.indexOf("iw") === 0) {
				// locale starts with "iw", so check if there are any "he" locales available
				return this._matchLocale("he"+originalLocale.substr(2),locales,locale);
			}
		}
		
		return result || null;
		*/
	},
	
	/**
	 * (DE_dE_VariAnt -> de_DE)
	 * removes the variant part to sustain backwards compatibility - please use com.ibm.mm.enabler.utilities.normalizeLocale
	 * whitespaces are trimmed at the beginning and end
	 * 
	 * @deprecated
	 * 
	 * @param {Object} locale
	 */
	toServerLocale:function(locale)
	{
		com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.utilities.normalizeLocale", "Deprecated. Use com.ibm.mm.enabler.utilities.normalizeLocale() instead.");
		
		if (typeof locale == "undefined" || locale == null) return null;
		if (locale.indexOf ("-") < 0 ) return locale;
		locale = locale.replace(/-/,"_");
		var tempArr = locale.split('_');
		var lang= tempArr[0];
		var country = tempArr[1].toUpperCase();
		var returnLocale = lang+"_"+country;
		return returnLocale;		
	},
	
	/**
	 * returns a locale object with normalized parts
	 * 
	 * (DE_dE_VariAnt -> {language: 'de', country: 'DE', variant: 'VariAnt'})
	 * whitespaces are trimmed at the beginning and end
	 * 
	 * @param {String|Array} locale
	 * 
	 */
	_getLocaleObj: function(locale) {
		if(dojo.isArray(locale)){
			return dojo.map(locale, function(item){
				return com.ibm.mm.enabler.utilities._getLocaleObj(item);
			});			
		} else if(dojo.isString(locale) && dojo.string.trim(locale).length > 0){
			var localeObj = {
				language: null,
				country: null,
				variant: null,
				toString: function() {
					return (this.language ? this.language + (this.country ? "_" + this.country + (this.variant ? "_" + this.variant : "") : "") : "");
				},
				isValid: function() {
					return !!this.language;
				}
			};
			var parts = dojo.string.trim(locale).replace(/-/g, "_").split('_');
			switch (parts.length) {
				case 3:
					// we have got a variant
					localeObj.variant = parts[2];
					// ATTN: no break here
				case 2:
					// we have got a country
					localeObj.country = parts[1].toUpperCase();
					// ATTN: no break here
				case 1:
					// and we have got a language
					localeObj.language = parts[0].toLowerCase();
					break;
			}
			return localeObj;
		} else {
			return null;
		}
	},
		
	/**
	 * normalizes a locale or an array of locales
	 * 
	 * (DE_dE_VariAnt -> de-DE_VariAnt)
	 * whitespaces are trimmed at the beginning and end
	 * @param {String|Array} locale
	 */
	normalizeLocale: function(locale) {
		if (dojo.isArray(locale)) {
			return dojo.map(locale, function(item){
				return com.ibm.mm.enabler.utilities.normalizeLocale(item);
			});
		} else if(locale){
			return com.ibm.mm.enabler.utilities._getLocaleObj(locale).toString();
		} else {
			return null;
		}
	},
	
	encodeModelID4Uri:function(uri)
	{
	    // encode uri part correctly
	    var pos = uri.indexOf(":");
	    if (pos != -1) {
	        var start = uri.slice(0,pos+1);
	        var end = uri.slice(pos+1);
	        uri = start + encodeURIComponent(end);
	    }
	    return encodeURIComponent(uri);
	},
	preloadImage:function(path,width,height){
        var image;
        if (width && height)
            image = new Image(width,height);
        else
            image = new Image();
        
		image.src = path;
        return image;
    },
    getAttributeWithNS:function(element,attName,localAttName,nsUri){
    	if (typeof element == "undefined" || element == null ) return null;
        if (typeof attName == "undefined" || attName == null ) return null;
        if (typeof localAttName == "undefined" || localAttName == null ) return null;
        if (typeof nsUri == "undefined" || nsUri == null ) return null;
	  	var value = null;
        if (dojo.isIE) {
			// IE with no namepsace
        	value = element.getAttribute(attName);	  	
		    if (value === null || value == "") {
			    // IE with namepsace
			    var attributes = element.attributes;
			    for (var i = attributes.length; i>0; i--) {
					if (attributes[i-1].baseName == localAttName && attributes[i-1].namespaceURI == nsUri) {
				    	value = attributes[i-1].value;
						break;
		  	  		}
			    }
      		}
        } else {
			// Safari & Firefox
            value =  element.getAttributeNS(nsUri, localAttName);
	  	}
        return value;
    },
    setAttributeWithNS:function(dom, element, attName, localAttName, nsUri, value){
        if (dojo.isIE) {
            attribute = dom.createNode(2, attName, nsUri); 
             // set value
            attribute.nodeValue = value;
            // attach to element
            element.setAttributeNode(attribute);
        }
        else {
            element.setAttributeNS(nsUri, attName, value);
        }
    }
}

com.ibm.mm.enabler.dom = {
    // summary:
    //      privide dom api util dojo 1.0 dom api is available
    //      dojox.xml.parser is not garanteed so wrap it here
	//	
    //set/get xml dom element content 
    textContent:function(node,text){
          if (node == null ) return "";
          if (arguments.length > 1){ 
              var doc = node.ownerDocument;
              if (!text) {
                  text = ""; // IE8 createTextNode fails when text == null
              }
              var aNode = doc.createTextNode(text);
              this.replaceChildren(node,aNode); 
              return;
          } else { 
		     var tc = dojox.xml.parser.textContent(node);
             if (tc != "undefined" && tc != null) { 
                 return tc; 
             } 
             var _result = ""; 
             for (var i = 0; i < node.childNodes.length; i++) { 
                 switch (node.childNodes[i].nodeType) { 
                     case 1: 
                     case 3: _result += node.childNodes[i].nodeValue; 
                         break; 
                     case 2: 
                     case 4: _result += node.childNodes[i].nodeValue; 
                         break; 
                     default: 
                         break; 
                 } 
              } 
             return _result; 
         }
    },
   createElement: function(dom,name,ns) {
      var newElem;
      if (dojo.isIE) {
          if (typeof ns != 'undefined' && ns != null) 
              newElem = dom.createNode(1, name, ns); 
          else
              newElem = dom.createElement(name); 
      } else {
          newElem = dom.createElementNS(ns, name);
      }
      return newElem;
   },
   destroyNode:function(node) {
		//avoid pseudo leaks since our webpage are open for long long time!
  		var garbageBin = document.getElementById('IELeakGarbageBin');
		if (!garbageBin) {
			garbageBin = document.createElement('DIV');
			garbageBin.id = 'IELeakGarbageBin';
			garbageBin.style.display = 'none';
			document.body.appendChild(garbageBin);
		}

		// move the element to the garbage bin
		garbageBin.appendChild(node);
		garbageBin.innerHTML = '';
		
		if(node.nodeType != 3){ // ingore TEXT_NODE
            if(dojo.isIE){
                node.outerHTML=''; //prevent ugly IE mem leak 
            }
        }
   },
   createDocument:function(/*string?*/ str, /*string?*/ mimetype){
        return dojox.xml.parser.parse(str,mimetype);
   },
   replaceChildren:function(/*Element*/node, /*Node || array*/ newChildren){
        return dojox.xml.parser.replaceChildren(node,newChildren);
   },
   innerXML:function(node){
        return dojox.xml.parser.innerXML(node);
   },
   removeChildren:function(node){
        return dojox.xml.parser.removeChildren(node);
   },
   copyChildren:function(/*Element*/srcNode, /*Element*/destNode, /*boolean?*/trim){
	var clonedNode = srcNode.cloneNode(true);
	return this.moveChildren(clonedNode, destNode, trim);	//	number
   },
   moveChildren:function(srcNode, destNode, trim){
	var count = 0;
	if(trim) {
		while(srcNode.hasChildNodes() &&
			srcNode.firstChild.nodeType == 3) {
			srcNode.removeChild(srcNode.firstChild);
		}
		while(srcNode.hasChildNodes() &&
			srcNode.lastChild.nodeType == 3) {
			srcNode.removeChild(srcNode.lastChild);
		}
	 }
     while(srcNode.hasChildNodes()){
		destNode.appendChild(srcNode.firstChild);
		count++;
	 }
     return count;	//	number
   } 
}



dojo.declare( "com.ibm.mm.enabler.utilities.HttpUrl", 
    null,
    {
        constructor:function ( /*String*/urlString ) {
			var resolved = com.ibm.mm.enabler.model.Utils.checkForEndpoints(urlString);
			if (resolved != null) {
				urlString = resolved;
			}
			
            this.scheme = this._extractScheme(urlString );
            this.server = this._extractServer(urlString );
            this.port = this._extractPort(urlString );
            this.path = this._extractPath(urlString );
            this.parameters = this._extractQuery(urlString );
            this.anchor = this._extractAnchor(urlString );
	    },

        addParameter: function ( /*String*/name, /*String*/value ) {
            if (dojo.isString(this.parameters[name])) {
                this.parameters[name] = [this.parameters[name], value];
            } else if (dojo.isArray(this.parameters[name])) {
                this.parameters[name].push(value);
            } else {
                this.parameters[name] = value;
            }
        },
        setParameter: function (/*String*/ name, /*Object*/ value) {
            this.parameters[name] = value;
        },
        getParameter: function (/*String*/ name) {
            return this.parameters[name];
        },
        getParameters: function() {
            return this.parameters;
        },
        isProxyNeeded: function() {
            var loc = document.location;
            // first test the scheme:
            if (loc.protocol != this.scheme)
                return true;
                
            // test the host
            if (loc.hostname != this.server)
                return true;

            // simplest case, ports are the same, return false
            if (loc.port == this.port)
                return false;
            
            // tests for http with default port
            if (this.scheme=="http:") {
                var defaultPort = "80";
                
                if ((loc.port == "" && this.port == defaultPort) ||
                    (loc.port == defaultPort && this.port == ""))
                    return false;
            }
            
            // tests for https with default port
            if (this.scheme == "https:") {
                var defaultPort = "443";
                
                if ((loc.port == "" && this.port == defaultPort) ||
                    (loc.port == defaultPort && this.port == ""))
                    return false;
            }
            
            return true;
        },
        toServerRelativeString: function() {
            var str = "";
            
            if (this.path != "") {
                str += "/" + com.ibm.mm.enabler.utilities.encodePath(this.path);
            }

            if (!com.ibm.mm.enabler.utilities.isEmpty(this.parameters))
                str += "?" + dojo.objectToQuery(this.parameters);

            if ( this.anchor != "" ) {
                str += "#" + this.anchor;
            }

            return str;
        },
        toProxifiedString: function () {
        //check if we need the proxy
            if (typeof ibmConfig == 'undefined')
                return this.toString();

            var newURL = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
            if (newURL == null)
                return this.toString();
            newURL += "/";

            if (window.location.protocol == this.scheme &&  window.location.hostname == this.server ) {
                if(window.location.port == this.port) {
                    return this.toString();
                } else if (this.scheme=="http:" && window.location.port == "" && this.port == "80") {
                    return this.toString();
                } else if (this.scheme=="https:" && window.location.port=="" && this.port=="443") {
                    return this.toString();
                } else if (this.scheme=="http:" && window.location.port == "80" && this.port == "") {
                    return this.toString();
                } else if (this.scheme=="https:" && window.location.port=="443" && this.port=="") {
                    return this.toString();
                }
            }

            // rewrite
            if (this.scheme == "https:") {
                newURL += "https/" + this.server + ((this.port != "443" && this.port != "") ? "%3A" + this.port:"");
            } else {
                newURL += "http/" + this.server + ((this.port != "80" && this.port != "")? "%3A" +this.port:"");
            }
            
            // add the slash portion in ANY case
            newURL += "/";
            
            if (this.path != "") {
                newURL += com.ibm.mm.enabler.utilities.encodePath(this.path);
            }

            if (!com.ibm.mm.enabler.utilities.isEmpty(this.parameters))
                newURL += "?" + dojo.objectToQuery(this.parameters);

            if ( this.anchor != "" ) {
                newURL += "#" + this.anchor;
            }

            return newURL;
        },
        toString: function () {
            var str = "";
            //safari doesn't support url normalization on xhr request
            if ( this.server != "" ) {
                str += this.scheme + "//" + this.server;
                if ( this.port != "") {    
                    if ( this.scheme == "http:" &&  this.port == "80" ) {
                        str +="";
                    }else if (this.scheme == "https:" && this.port =="443") {
                        str +="";
                    } else{
                        str += ":" + this.port;
                    }
                }
            }
    
            // add the slash portion in ANY case
            str += "/";
            
            if (this.path != "") {
                str += com.ibm.mm.enabler.utilities.encodePath(this.path);
            }

            if (!com.ibm.mm.enabler.utilities.isEmpty(this.parameters))
                str += "?" + dojo.objectToQuery(this.parameters);
    
            if ( this.anchor != "" ) {
                str += "#" + this.anchor;
            }

            return str;
        },
        _extractScheme: function (/*String*/ urlString ) {
            var indexOfScheme = urlString.indexOf ( "://" );

            if (indexOfScheme == -1)
                return window.location.protocol; // location.protocol returns the protocol like http: or https:

            return urlString.substring(0, indexOfScheme + 1);
        },
        _extractServer: function (/*String*/urlString ) {
            var indexOfScheme = urlString.indexOf( this.scheme );
            var retVal = "";
            if ( indexOfScheme == 0 ) {
                var indexOfSlash = urlString.indexOf( "/", indexOfScheme + this.scheme.length + 2 );
                if (indexOfSlash != -1) {
                    var serverAndPort = urlString.substring( indexOfScheme+ this.scheme.length+2, indexOfSlash );
                }else{
                    var serverAndPort = urlString.substring(indexOfScheme+ this.scheme.length+2);
                }
                retVal = serverAndPort.split( ":" )[0];
            } else {
                retVal = window.location.hostname;
            }

            return retVal; 
        },
        _extractPort: function (/*String*/urlString ) {
            var indexOfServer = urlString.indexOf( this.server );
            var retVal = "";
            if ( indexOfServer >= 0 ) {
                var indexOfSlash = urlString.indexOf( "/", indexOfServer );
                if (indexOfSlash != -1) {
                    var serverAndPort = urlString.substring( indexOfServer, indexOfSlash );
                }
                else{
                    var serverAndPort = urlString.substring(indexOfServer);
                }
                var serverAndPortParts = serverAndPort.split( ":" );
                if ( serverAndPortParts.length > 1 ) {
                    retVal = serverAndPortParts[1];
                }
            }

            if (retVal == ""){
                if(urlString.indexOf("/")==0)
                    retVal=window.location.port;
            else 
                retVal = "";
            }

            return retVal; 
        },
        _extractPath: function ( /*String*/urlString ) {
            var indexOfScheme = urlString.indexOf( this.scheme );
            var startIndex = 0;

            if (indexOfScheme == 0)
                startIndex = this.scheme.length+2;
                
            var retVal = "";

            var indexOfSlash = urlString.indexOf( "/", startIndex );
            var indexOfQuery = urlString.indexOf( "?" );
            var indexOfHash = urlString.lastIndexOf( "#" );
            if ( indexOfQuery >= 0 ) {
                retVal = urlString.substring( indexOfSlash + 1, indexOfQuery );
            }
            else {
                if ( indexOfHash >= 0 && indexOfSlash != -1 ) {
                    retVal = urlString.substring( indexOfSlash + 1, indexOfHash );
                }
                else if ( indexOfSlash != -1){
                    retVal = urlString.substring( indexOfSlash + 1 );
                }
            }

            return retVal;
        },
        _extractQuery: function ( /*String*/urlString ) {
            var retVal = {};
            var urlParts = urlString.split( "?" );

            if ( urlParts.length > 1 ) {
                retVal = dojo.queryToObject(urlParts[1].split( "#" )[0]);
            }

            return retVal;
        },
        _extractAnchor: function ( /*String*/urlString ) {
            var retVal = "";
            var urlParts = urlString.split( "#" );

            if ( urlParts.length > 1 ) {
                retVal = urlParts[urlParts.length - 1];
            }

            return retVal;
        }
    }
);

dojo.declare("com.ibm.mm.enabler.ArrayMap",null,
{
    constructor:function(){
         this.entries = [];
         this.keys = {}; 
    },
    values:function(){
        return this.entries;        
    },
    put:function(/*String*/key,/*object*/value){
         var index = this.keys[key];
         if (typeof index != 'undefined' && index != null){
             this.entries[index]= value;
         } 
         else{
             index = this.entries.length;
             this.entries.push(value);
             this.keys[key]=index;
         }       
    },
    getKey:function(index){
        if (index < this.entries.length){
            for (var key in this.keys){
                var temp = this.keys[key];
                if (temp != null && temp == index)
                {
                    return temp;                    
                }
            }            
        }            
        else
            return null;          
    },
    getValue:function(index){
        if (index < this.entries.length)
            return this.entries[index];
        else
            return null;        
    },
    get:function(key){
        var index = this.keys[key];
        if (typeof index != 'undefined' && index != null)
        {
           var value = this.entries[index];
           return value;
        }
        return null;        
    },
    remove:function(key){
        var index = this.keys[key];
        if (typeof index != 'undefined' && index != null)
        {
            this.entries.splice(index,1);
            this.keys[key] = null;
        }
        return index;
    },
    size:function(){
        return this.entries.length;       
    },
    keySet:function(){
        var arr = [];
        for (var key in this.keys){
            arr.push(key);           
        }
        return arr;
    }    
});



}

if(!dojo._hasResource["com.ibm.mashups.iwidget.services"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.services"] = true;
dojo.provide("com.ibm.mashups.iwidget.services");
dojo.provide("com.ibm.mashups.iwidget.services.EventService");

/**
* This interface defines iWidget EventService which provides  a topic driven subscribe/publish mechanism. 
* "fireEvent" and "broadcastEvent"  are provided as convenience functions on top of this basic model.
* The service can be retrieved using the following code: <br>
* <code>var eventService = com.ibm.mashups.services.ServiceManager.getService(<br/>
* &nbsp;&nbsp;&nbsp;&nbsp;com.ibm.mashups.iwidget.services.EventService.SERVICE_NAME);</code><br/>
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.services.EventService",null,  {
    /**
     * The service name to be used to fetch the service from the ServiceManager
     * @type String
     */
    SERVICE_NAME: "eventService",
    
  	/**
     * @private
     */
    constructor:function(){
    },

/**
Allows page component to invoke a handled event that's defined in an iWidget.<br/>
For example,  in Lotus Mashups, user can click "save" to save the attributes when user finished editing a widget .<br/>
Then the component that renders the "save" button could use this api to distribute an onModeChanged event to the widget.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>com.ibm.mashups.services.ServiceManager.getService("eventService").fireEvent(this.iwidgetId,"onModeChanged", {newMode:"view"});	 </code><br/>
So the widget could get notified and go back to "view"mode.<br/>
Same function can also be achieved by using "publishEvent"<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>com.ibm.mashups.services.ServiceManager.getService("eventService").publishEvent("widgetevents."+this.iwidgetId+"."+"onModeChanged", {newMode:"view"}); </code><br/>
@param{String } targetWidget  id of target iWidget. Must never be NULL.
@param{String } targetEvent  event name of target Event .Must never be NULL.
@param{Object } payload  optional. data object that's distributed with an event. May be NULL.
@param{String } payloadType  optional. type of the payload
@param{String } sourceid  optional. id of source component that triggers this event
@type void
*/
      fireEvent: function(targetWidget,targetEvent,payload,payloadType,sourceid){
      },	
/**
Allows page components to broadcast  an event to all the widgets/components on the page. There's no need for widgets to subscribe that topic first.<br/>
For example,  mode selector iWidget may broadcast a "pageModeChanged" event when page mode is changed from view mode to edit mode.<br/>
Then all the widgets/components  will get notified and all widgets/components that  can handle "pageModeChanged" event will update accordingly.<br/>
A widget that can handle this event must have this event defined. <br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;iw:event id="pageModechanged"  eventDescName="pageModeChanged_desc" handled="true"  onEvent="handlePageModeChange" /&gt; </code><br/>
A component that can handle this event must subscribe this event by using:<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>serviceManager.getService("eventService").subscribeEvent ("pageModechanged",handlerFn,scope,sourceid)</code><br/>
Code example:<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>com.ibm.mashups.services.ServiceManager.getService("eventService").broadcastEvent("pageModeChanged", payload,payloadtype,,sourceid); </code><br/>
Same function can also be achieved by using "publishEvent"<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>com.ibm.mashups.services.ServiceManager.getService("eventService").publishEvent("*"+"."+"onModeChanged", {newMode:"view"}); </code><br/>
@param{String } targetEvent  event name of target Event .Must never be NULL.
@param{Object } payload  optional.  data object that's distributed with an event. May be NULL.
@param{String } payloadType  optional.  type of the payload
@param{String } sourceid  optional. id of client component that triggers this event.
@type void
*/ 	 	  
      broadcastEvent: function(targetEvent,payload,payloadType,sourceid){
      },
/**
Allows page components to switch to a different page and broadcast an event to all the widgets/components on that page.<br/>
@param{String } targetEvent  event name of target Event .Must never be NULL.
@param{Object } payload  optional.  data object that's distributed with an event. May be NULL.
@param{String } payloadType  optional.  type of the payload
@param{String } sourceid  optional. id of client component that triggers this event.
@param{String } pageid  optional. id of page to switch to and receive the event. If none is provided, no page switch will occur and event will broadcast to current page.
@type void
*/ 	 	  
      broadcastEvent: function(targetEvent,payload,payloadType,sourceid,pageid){
      },
/**
Allows page components to switch to a different page and space and broadcast an event to all the widgets/components on that page.<br/>
@param{String } targetEvent  event name of target Event .Must never be NULL.
@param{Object } payload  optional.  data object that's distributed with an event. May be NULL.
@param{String } payloadType  optional.  type of the payload
@param{String } sourceid  optional. id of client component that triggers this event.
@param{String } pageid  optional. id of page to switch to and receive the event. If none is provided, no page switch will occur and event will broadcast to current page.
@param{String } spaceid  optional. id of space containing the page to switch to and receive the event. If none is provided, current space is assumed.
@type void
*/ 	 	  
      broadcastEvent: function(targetEvent,payload,payloadType,sourceid,pageid,spaceid){
      },
/**
Allows page components to broadcast more than one event to all the widgets/components on the page.<br/>
@param{Array } eventsArray   Array of objects each containing the following event information: &#123; "targetEvent": targetEvent, "payload": payload, "payloadType": payloadType &#125;. Must never be NULL.
@param{String } sourceid  optional. id of client component that triggers this event.
@type void
*/ 	 	  
      broadcastEvents: function(eventsArray,sourceid){
      },
/**
Allows page components to switch to a different page and broadcast more than one event to all the widgets/components on that page.<br/>
@param{Array } eventsArray   Array of objects each containing the following event information: &#123; "targetEvent": targetEvent, "payload": payload, "payloadType": payloadType &#125;. Must never be NULL.
@param{String } sourceid  optional. id of client component that triggers this event.
@param{String } pageid  optional. id of page to switch to and receive the events. If none is provided, no page switch will occur and events will broadcast to current page.
@type void
*/ 	 	  
      broadcastEvents: function(eventsArray,sourceid,pageid){
      },
/**
Allows page components to switch to a different page and space and broadcast more than one event to all the widgets/components on that page.<br/>
@param{Array } eventsArray   Array of objects each containing the following event information: &#123; "targetEvent": targetEvent, "payload": payload, "payloadType": payloadType &#125;. Must never be NULL.
@param{String } sourceid  optional. id of client component that triggers this event.
@param{String } pageid  optional. id of page to switch to and receive the events. If none is provided, no page switch will occur and events will broadcast to current page.
@param{String } spaceid  optional. id of space containing the page to switch to and receive the events. If none is provided, current space is assumed.
@type void
*/ 	 	  
      broadcastEvents: function(eventsArray,sourceid,pageid,spaceid){
      },
/**
Allows page component to publish a global event that's available to all the other page components.<br/>
Event service supports global topics. For these topics all the page components could subscribe to it.<br/>
For example. when an iWidget is removed from page, a global event -"/enabler/unloadWidget" will be published by the skin component.<br/>
iWidget container is a subscriber of this topic, thus it can clean up the resource related to this iWidget accordingly.<br/>
@param{String } topic  topic that's published.Must never be NULL.
@param{Object } payload  optional. payload object.
@param{String } payloadType optional.  type of the payload
@param{String } sourceid  optional. id of client component that triggers this event.
@type void
*/ 	  
      publishEvent: function(topic,payload,payloadType,sourceid){
      },
/**
Allows page component to subscribe  a global event that's available to all the other page components.<br/>
Event service supports global topic. for these topics all the page listeners could subscribe to it.<br/>
For example. when an iWidget is removed from page, a global event -"/enabler/unloadWidget" will be published by the skin component.<br/>
iWidget container is a subscriber of this topic, thus it can clean up the resource related to this iWidget accordingly.
@param{String } event  event name 
@param{Object } object  optional. scope object of the handlerFn. default scope is global scope.
@param{String} eventCallback optional. eventCallback that will be invoked when event is published
@param{String} subscribeCallback optional. callback  to tell is subscription is good
@param{String } sourceid  optional. id of client component that subscribes this event
@type void
*/	  
      subscribeEvent:function(event,object,eventCallback,subscribeCallback,sourceid){
      },
/**
Allows page component to unsubscribe  a global event that's available to all the other page components.<br/>
@param{Object } subscriptionHandler   subscriptionHandler
@param{String } sourceid  optional. id of client component that subscribes this event
@type void
*/
	  unsubscribeEvent:function(subscriptionHandler,sourceid){
	  }
});

// make sure we can reference this globally
com.ibm.mashups.iwidget.services.EventService.SERVICE_NAME = "eventService";


}

if(!dojo._hasResource["com.ibm.mm.iwidget.constants"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.constants"] = true;
dojo.provide("com.ibm.mm.iwidget.constants");

dojo.declare("com.ibm.mm.iwidget.Constants",null,{	
	constructor:function () {         
        	
    },	
	WIDGETEVENT_PREFIX:"widgetevents.",
	WILDCARD_PREFIX:"*.",
	mode_view:"view",
    mode_edit:"edit",
    mode_help:"help",
    ATTRIBUTES:"attributes",
    IDESCRIPTOR:"idescriptor",
    USERPROFILE:"userprofile",
    iDescriptorItems:{
        title:"title",
        name:"name",
        description:"description",
        defaultHeight:"defaultHeight",
        defaultWidth:"defaultWidth",
        locales:"locales",
        mode:"mode",
        size:"size",
        author:"author",
        email:"email",
        website:"website",
        version:"version",
        globalAttributes:"globalAttributes",
        icon:"icon"
    },
    CSSCLASS_INSTANCE:{
    	iwiWidget:"iWidget",
    	iwDefinition:"Definition",
    	iwHandler:"Handler",
    	iwItemDescription:"ItemDescription",
    	iwReadOnly:"ReadOnly",
    	iwItemSet:"ItemSet",
    	iwItemSetDescRef:"ItemSetDescRef",
    	iwResource:"Resource",
    	iwSrc:"iwSrc",
    	iwmime:"mime",
    	iwversion:"version",
    	iwcallback:"callback",
    	iwContent:"Content",
    	iwAllowInstanceContent:"AllowInstanceContent",
    	iwReceivedEvent:"ReceivedEvent",
    	iwSourceEvent:"SourceEvent",
    	iwTargetEvent:"TargetEvent",
    	iwItem:"Item",
    	iwValue:"Value"
    },
    RESOURCE:{
        src:"src",
        id:"id",
        mimetype:"mimetype",
        callback:"callback",
        version:"version"
    },
	EVENTS:{
		  	onLoad:/*String*/ "onLoad",
    		onUnLoad:/*String*/ "onUnload",
    		onModeChanged:/*String*/ "onModeChanged",
    		onItemSetChanged:/*String*/ "onItemSetChanged",
    		unloadWidget:/*String*/ "/enabler/unloadWidget",
    		unSubscribeWire:/*String*/ "/enabler/unSubscribeWire",
    		modeChanged:/*String*/ "modeChanged",
			onSizeChanged:/*String*/"onSizeChanged",
			onNavStateChanged:/*String*/"onNavStateChanged",
			onAttributeSaved:/*String*/"com.ibm.mashups.iwidget.onAttributeSaved"
	}	
});
iwConstants = new com.ibm.mm.iwidget.Constants();

}

if(!dojo._hasResource["com.ibm.mm.enabler.hub.mainhub"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.hub.mainhub"] = true;
dojo.provide("com.ibm.mm.enabler.hub.mainhub");



dojo.declare("com.ibm.mm.enabler.hub.ManagedHubImpl",null,  {
	constructor:function(){
        //implement singleton
		//allow any products to use enabler extensionregistry to plugin their own publishMgr and subscribeMgr,security manager
		//sample code
		/*var extensions = [];
				extensions.push({
					"com.ibm.mm.enabler.hub.ManagedHubImpl.publishMgr": {
						type: "around",
						handler: function ( executor, fnArgs ) { //executor is the default impl. function
							var topic = fnArgs[0];	
							var data = fnArgs[1];
							var pubClientID = fnArgs[2];
							var subClientID = fnArgs[3];						
							//do logic here...
							return;
						}
					}
				});
		*/	
    },	
	publishMgr:function( topic, data, pubClient, subClient ) {
		var pubClientID = pubClient ? pubClient.getClientID() : "manager";
        var subClientID = subClient ? subClient.getClientID() : "manager";
		var that = com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
 		if (that.bIsLoggable) that.LOGGER.trace("publishMgr", "(MANAGER): PUB: " + pubClientID + " -> " + subClientID + " || topic: '" + topic + "' data: '" + data + "'" );
        return true;
    },
	subscribeMgr:function( topic, client ) {
		var clientID = client ? client.getClientID() : "manager";
		var that = com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
        if (that.bIsLoggable) that.LOGGER.trace("subscribeMgr","(MANAGER): SUB: id: '" + clientID + "' topic: '" + topic + "'" );
        return true;
    },
	securityMgr:function(source, alertType){
		var that = com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
	      if (that.bIsLoggable) that.LOGGER.trace("securityMgr","source:"+source+" alertType:"+alertType );
	},
	getInstance:function(){
		//Hub api doc and sample is out of sync,need to confirm parameters
		var hub = com.ibm.mm.enabler.hub.ManagedHubImpl._instance;
		if (!hub) {
			com.ibm.mm.enabler.hub.ManagedHubImpl._instance = new OpenAjax.hub.ManagedHub({
				onPublish: this.publishMgr,
				onSubscribe: this.subscribeMgr,
				onSecurityAlert: this.securityMgr
			});
			com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.hub.ManagedHubImpl");
			com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
			com.ibm.mm.enabler.hub.ManagedHubImpl._instance.bIsLoggable = com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOGGER.isLoggable(com.ibm.mm.enabler.hub.ManagedHubImpl._instance.LOG_LEVEL);
			hub = com.ibm.mm.enabler.hub.ManagedHubImpl._instance;			
		}
		return hub;	       
	}
});
com.ibm.mm.enabler.hub.ManagedHubImpl = new com.ibm.mm.enabler.hub.ManagedHubImpl();

dojo.declare("com.ibm.mm.enabler.hub.MainHubAdapterImpl",null,  {
	constructor:function(managedhub){
		this._managedhub = managedhub;     
		//this._inlineContainerArr = {};
		//this._iframeContainerArr = {};
		this._inlineHubClients = {};	
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);	  
    },	
	PREFIX_INLINE:"_inline_",
	PREFIX_IFRAME:"_iframe_",
	createInlineHubContainer:function(id){
		var fullId = this.PREFIX_INLINE +id;
		var me = this;

		function onClientConnect( container ) {
				if (me.bIsLoggable) me.LOGGER.trace("onClientConnect", "++ " + container.getClientID() + " connected" );

        }
        function onClientDisconnect( container ) {
				if (me.bIsLoggable) me.LOGGER.trace("onClientDisconnect",  "-- " + container.getClientID() + " disconnected" );
       }
        function onClientSecurityAlert( container, securityAlert ) {
				if (me.bIsLoggable) me.LOGGER.trace("onClientSecurityAlert", "!! security alert - id: '" + container.getClientID() + "' msg: '" + securityAlert  );
        }
        function onClientError( container, error ) {
				if (me.bIsLoggable) me.LOGGER.trace("onClientError","!! error - id: '" + container.getClientID() + "' msg: '" + error  );
       }
            
        var params = {
                Container: {
                    onConnect: onClientConnect,
                    onDisconnect: onClientDisconnect,
                    onSecurityAlert: onClientSecurityAlert,
                    onError: onClientError
                }
         };
         var client= new OpenAjax.hub.InlineContainer( this._managedhub, fullId, params );
		 return client;	 
	},
	createIframeHubContainer:function(id,/*domNode*/widget,/*uri*/uri,isModal,width,height){
		var fullId = this.PREFIX_IFRAME +id;
	
		var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
        var enablerContext = configService.getValue(configService.CONTEXT_ROOT_ENABLER);
		var tunnelPath = enablerContext+"/js/openajaxhub/tunnel.html";
		
		var schema = window.location.protocol;
		var host = window.location.hostname;
		var port = window.location.port;
		var tunnelUri = schema + "//" + host+":"+port+tunnelPath;
		if (port == "")
			tunnelUri = schema + "//"+host+tunnelPath;
	    var me = this;
		function onClientConnect( container ) {
			if (me.bIsLoggable) me.LOGGER.trace("onClientConnect", "++ " + container.getClientID() + " connected" );
       }
        function onClientDisconnect( container ) {
 			if (me.bIsLoggable) me.LOGGER.trace("onClientDisconnect",  "-- " + container.getClientID() + " disconnected" );
        }
        function onClientSecurityAlert( container, securityAlert ) {
			if (me.bIsLoggable) me.LOGGER.trace("onClientSecurityAlert", "!! security alert - id: '" + container.getClientID() + "' msg: '" + securityAlert  );
        }			
			try {
        this.removeIframeHubContainer(id); // remove any that already exists so there is never duplicate
        if (isModal && isModal == "true") {
			var w = "600px";
			var h = "400px";
		}
		else{
			var w = "400px";
			var h = "auto";
		}
        if (width)  w = width;
		if (height) h = height;
		
				var client = new OpenAjax.hub.IframeContainer(this._managedhub, fullId, {
					Container: {
						onConnect: onClientConnect,
						onDisconnect: onClientDisconnect,
						//	      log:function(msg){
						//	   	console.log("!!!!!!"+msg);
						//	   },
						onSecurityAlert: onClientSecurityAlert
					
					},
					IframeContainer: {
						//uri: "http://c" + i + ".foo.bar.com/hub11/samples/plain_hub/widgetSender.html",
						uri: uri,
						tunnelURI: tunnelUri,
						//    timeout:1000000000,
						parent: widget,
						//	iframeAttrs:{ style: { width: "100%", height: "100%" },scrolling:"no" }		
						iframeAttrs: {
							title:"iframe",
							style: {
								width: w,//need to set default size since IE7/6 either have wierd or no default size at all
								height: h,
								border:"0px",
								overflow:"auto"
							},
							id:"iframe_"+id,
							name:id
						},
						timeout:1200000						
					}
				});
			}catch(e)
			{
				if (me.bIsLoggable) me.LOGGER.trace("createIframeHubContainer", "Creating iframe container exception:"+e.message ); 
			}
	},
	createInlineHubClient:function(id){
		//create hub client and connect to hub
		var fullId = this.PREFIX_INLINE +id;
		var me = this;

		var container = this._managedhub.getContainer(fullId);
		function onHubClientSecurityAlert( source, alertType ) {}
        var hubClient1 = new OpenAjax.hub.InlineHubClient({
                    HubClient: {
                        onSecurityAlert: onHubClientSecurityAlert
                    },
                    InlineHubClient: {
                        container: container
                    }
            });
		function onHubClientConnect( client, success, error ) {
            if ( ! success ) {
				if (me.bIsLoggable) me.LOGGER.trace("createIframeHubContainer", "!! client connection error = id: '" + client.getClientID() + "' msg: '" + error  ); 
            }
        }
		hubClient1.connect( onHubClientConnect );
		this._inlineHubClients[fullId]= hubClient1;
        return hubClient1;		
	},
	_getInlineHubClient:function(id){
		if (typeof id == "undefined" || id == null) return null;
		var fullId = this.PREFIX_INLINE +id;
		var client = this._inlineHubClients[fullId];
		if (typeof client == "undefined") client = null;
		return client;
	},
	getInlineHubClient:function(id){
		if (typeof id == "undefined" || id == null) return this._managedhub;
		var client = this._getInlineHubClient(id);
		return client ? client : this._managedhub;
	},
	isInlineClient:function(id){
		var rc = false;
		var hubClient = this._getInlineHubClient(id);
		if (typeof hubClient != "undefined" && hubClient != null)
		rc = true;
		return rc;		
	},
	removeInlineHubClient:function(id){
		//eg. widget is removed from the page
		var hubClient = this._getInlineHubClient(id);
		var fullId = this.PREFIX_INLINE +id;
		if (typeof hubClient != "undefined" && hubClient != null)
		{
			var me = this;
			function onHubClientDisconnect( client, success, error ) {
            	if ( ! success ) {
							if (me.bIsLoggable) me.LOGGER.trace("onHubClientDisconnect",  "-- " + client.getClientID() + " msg:"+error );
            	}
        	}
			hubClient.disconnect(onHubClientDisconnect);
		
			delete this._inlineHubClients[fullId];
			//var inlineContainer = this._inlineContainerArr[fullId];
			var inlineContainer = this._managedhub.getContainer(fullId);
			if (typeof inlineContainer != "undefined" && inlineContainer != null) {
				this._managedhub.removeContainer(inlineContainer);
			}
			return;
		}		
	},
	removeIframeHubContainer:function(id){
		var fullId = this.PREFIX_IFRAME +id;
		var iframeContainer = this._managedhub.getContainer(fullId);
		if (typeof iframeContainer != "undefined" && iframeContainer != null) {
			this._managedhub.removeContainer(iframeContainer);
		}
	},
	returnSubDomain:function(subDomain){
		this.getSubDomainPool().add(subDomain);
	},
	getSubDomainSize:function(){
		return this.getSubDomainPool().getSize();
	},
	getSubDomain:function(){
		return this.getSubDomainPool().get();
	},
	getSubDomainPool:function(){
		if (typeof this.subDomainPool == "undefined" || this.subDomainPool == null) {
			var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
			var subDomains = configService.getValue(configService.SUBDOMAINS);
			if (typeof subDomains != "undefined" && subDomains != null) {
				if (dojo.isArray(subDomains) == true && subDomains.length != 0) {
					this.subDomainPool = new com.ibm.mm.enabler.hub.SubDomainPoolImpl(subDomains);
				}
			}
			if(!this.subDomainPool)
				this.subDomainPool = new com.ibm.mm.enabler.hub.SubDomainPoolImpl();			
		}
		return this.subDomainPool;		
	}		
});
dojo.declare("com.ibm.mm.enabler.hub.SubDomainPoolImpl",null,  {
	constructor:function(arr){
		if (arr) {
			this._pool = arr;
			this._internalPool = dojo.clone(this._pool);
		}
		else{
			this._counter = 0;
			this._reusedSubDomain = [];
		}	
		this.configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
		this.reuseSubDomain = this.configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.SUBDOMAINREUSE);
   	},
	getSize:function(){
		if(this._internalPool ) return this._internalPool.length;
		return -1; //unlimited
	}, 
	//get next available
	get:function(){
		if(this._pool) return this._getFromPool();
		
		var cnt = this._counter;
		if (this.reuseSubDomain) {
			if (this._reusedSubDomain.length > 0) {
				cnt = this._reusedSubDomain.shift();
				return cnt;
			}
			else {
				this._counter++;
			}
		} else{
			this._counter++;
		}
		var counter = new String(cnt);		
		return "w"+ counter;		
		
	},
	//add old one back to pool for use eg. widget is deleted from the page
	add:function(subDomain){
		if(!this.reuseSubDomain) return;
		if (this._pool) {
			return this._addToPool(subDomain);
		}else{
			this._reusedSubDomain.push(subDomain);
		}
		return;
	},
	_getFromPool:function(){
		if (this._pool.length == 0) {
			return null;
		}	
		return this._pool.shift();
	},
	_addToPool:function(subDomain){
		this._pool.push(subDomain);
	}	
});

dojo.declare( "com.ibm.mm.enabler.hub.XHRHeaderExtensionImpl", null , {
    LOG_LEVEL: com.ibm.mashups.enabler.logging.LogLevel.TRACE,
    
    constructor: function () {
        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_METHOD = "dojo.xhr()";
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);

        this.originalDojoXHR = dojo.xhr;
        
        dojo.xhr = dojo.hitch(this, function(/* String */ method, /* dojo.__XhrArgs */ args, /* Boolean */ hasBody) {
            if (this.bIsLoggable) {
                this.LOGGER.entering(this.LOG_METHOD, [method, args, hasBody]);
            }
            
            if (!args.headers) args.headers = {};
            args.headers["com.ibm.lotus.openajax.virtualhost"] = document.location.hostname;
            args.headers["com.ibm.lotus.openajax.virtualport"] = document.location.port;
            if (this.bIsLoggable) {
                this.LOGGER.trace(this.LOG_METHOD, "Adding headers: com.ibm.lotus.openajax.virtualhost="+document.location.hostname+" - com.ibm.lotus.openajax.virtualport="+document.location.port);
            }
            var ret = this.originalDojoXHR(method, args, hasBody);
            
            if (this.bIsLoggable) {
                this.LOGGER.exiting(this.LOG_METHOD);
            }
            
            return ret;
        });
    }
});


com.ibm.mm.enabler.hub.XHRHeaderExtension = new com.ibm.mm.enabler.hub.XHRHeaderExtensionImpl();


}

if(!dojo._hasResource["com.ibm.mm.iwidget.services.eventservice"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.services.eventservice"] = true;
dojo.provide("com.ibm.mm.iwidget.services.eventservice");








dojo.declare("com.ibm.mm.iwidget.services.EventServiceImpl",com.ibm.mashups.iwidget.services.EventService,  {
	constructor:function(){
        this.subMgr = {};
		this.managedhub = com.ibm.mm.enabler.hub.ManagedHubImpl.getInstance();
		this.hubAdapter = new com.ibm.mm.enabler.hub.MainHubAdapterImpl(this.managedhub);
		this._subscribeEventService();	
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);	
    },
	setId:function(id){
		this.id = id;
	},
	getId:function(){
		return "main";
	},
	_subscribeEventService:function(){
		//dispatch event to each method....for now, just fireEvent
		//in future, broadcastEvent... has security concern though
		var that=this;
		// message should contain
		// methodname:fireEvent
		// params:{}
		// hubclient:hubclientid
	    function eventCallback( topic, message,subscribeData ){
			//(targetWidget,targetEvent,message.payload,message.payloadType,sourceWidget)
			var methodname = message.methodname;
			if (typeof methodname != "undefined" && methodname !=null){
				var fn = that[message.methodname];
				if (typeof fn != "undefined" && fn != null){
					that[methodname].apply(that,message.params);
				}	
			}			
		}				
		this.managedhub.subscribe("eventservice."+this.getId(),eventCallback,that,that._subscribeCallback);
	},
	_subscribeCallback:function(subHandle,success,/*OpenAjax.hub.Error*/error){
		//common _subscribeCallback function
		if (!success) {
			console.log("subscribe failed "+subHandle);
		}		
	},
	_getHubAdapter:function(){
		return this.hubAdapter;
	},	
	_getManagedHub:function(){
		return this.managedhub;
	},
	WIDGETEVENT_PREFIX:iwConstants.WIDGETEVENT_PREFIX,
	WILDCARD_PREFIX:iwConstants.WILDCARD_PREFIX,	
   	subscribeWire: function (/*String*/sourceWidget,/*String*/sourceEvent,/*String*/targetWidget,/*String*/targetEvent) {
        com.ibm.mm.enabler.debug.entry("eventService.subscribeWire", "source:"+sourceWidget+" sourceEvent:"+sourceEvent+" targetWidget:"+targetWidget+" targetEvent:"+targetEvent);
        if (typeof sourceWidget == "undefined" || sourceWidget === null) return false;
		if (typeof sourceEvent == "undefined" || sourceEvent === null)return false;
		if (typeof targetWidget == "undefined" || targetWidget === null)return false;
	    if (typeof targetEvent == "undefined" || targetEvent === null)return false;
	
		var rc = true;
		var that=this;
		
			// should be subHandle, topic, payload ( as defined in publishWire...)		       		     
			function eventCallback(topic, message,subscribeData){
				that.fireEvent(targetWidget, targetEvent, message.payload, message.payloadType, sourceWidget)
			}
			function callback(item, success, error){
				if (!success) {
					console.log("eventService.subscribeWire subscribe failed " + "source:" + sourceWidget + " sourceEvent:" + sourceEvent + " targetWidget:" + targetWidget + " targetEvent:" + targetEvent);
				}
			}
			// do real subscription only if it's an inline iwidget
			var hubClient = this.hubAdapter._getInlineHubClient(targetWidget);
			if (typeof hubClient != "undefined" && hubClient != null) {
				var subHandler = hubClient.subscribe(this.WIDGETEVENT_PREFIX + sourceWidget + "." + sourceEvent, eventCallback, null, callback);
				var wireId = this._generateWireId(sourceWidget, sourceEvent, targetWidget, targetEvent);
				this.subMgr[wireId] = subHandler;				
				
				//notify source iWidget  -- onNewWire
				var payload = {};
				payload.targetWidget = targetWidget;
				payload.sourceEvent = sourceEvent;
				payload.sourceWidget = sourceWidget;
				payload.targetEvent = targetEvent;
				this.fireEvent(sourceWidget, "onNewWire", payload);
			}  
        return rc;
    },
    publishWire: function(/*String*/sourceWidget,/*String*/sourceEvent,/*object*/payload,/*String*/payloadType){
       payload = this._serializePayload(payload);

        //allow widget to fire a event
        com.ibm.mm.enabler.debug.entry("eventService.publishWire", "source:"+sourceWidget+" sourceEvent:"+sourceEvent+" payload:"+payload+" payloadType:"+payloadType);
        
        if (typeof sourceWidget == "undefined" || sourceWidget === null)return false;
	    if (typeof sourceEvent == "undefined" || sourceEvent === null)	return false;
		
		var hubClient = this.hubAdapter._getInlineHubClient(sourceWidget);
		//publish wire only if it's an inline iwidget
		if (typeof hubClient != "undefined" && hubClient != null) {
			hubClient.publish(this.WIDGETEVENT_PREFIX+sourceWidget+"."+sourceEvent,{"payload": payload,"payloadType": payloadType});
		}	
        return true;
     },     
     _serializePayload: function(payload) {
        // complex payload objects must be serialized to json for case when widgets are sandboxed
        // to be serializable, complex payload objects must implement toJson method that returns json in format {"className":"x","json":"y"}
        // to be deserializable, complex payload objects must have a constructor with an argument that accepts the "y" json value returned from toJson
        if (typeof payload == 'object' && payload.toJson) {
          payload = payload.toJson();
        }
        return payload;
     },
     unSubscribeWire: function(sourceWidget,sourceEvent,targetWidget,targetEvent){
         if (typeof sourceWidget == "undefined" || sourceWidget === null) return false;
		 if (typeof sourceEvent == "undefined" || sourceEvent === null) return false;
		 if (typeof targetWidget == "undefined" || targetWidget === null) return false;		 
         if (typeof targetEvent == "undefined" || targetEvent === null) return false;
		 		 
		 var hubClient = this.hubAdapter._getInlineHubClient(targetWidget);
		if (typeof hubClient != "undefined" && hubClient != null) {
			//unsubscribe only if it's an inline widget
			var wireId = this._generateWireId(sourceWidget, sourceEvent, targetWidget, targetEvent);
			var subHandler = this.subMgr[wireId];
			if (typeof(subHandler) != "undefined" && subHandler != null) {
				this.unsubscribeEvent(subHandler, targetWidget);
				delete this.subMgr[wireId];
			}
			
			//onRemoveWire-- notify target widget
			var payload = {};
			payload.targetWidget = targetWidget;
			payload.targetEvent = targetEvent;
			payload.sourceWidget = sourceWidget;
			payload.sourceEvent = sourceEvent;
			this.fireEvent(targetWidget, "onRemoveWire", payload);
			this.fireEvent(sourceWidget,"onRemoveWire",payload);
			//todo:remove
			this.publishEvent(com.ibm.mm.iwidget.iEvents.Constants.unSubscribeWire, {
				wires: [payload]
			});
			
			//notify source widget
			
		}				
		return true;
     },
     addWire: function(sourceWidget,sourceEvent,targetWidget,targetEvent ){
     //SPI support, deprecated, should remove, no sandboxed support
	       com.ibm.mm.enabler.debug.entry("eventService.addWire", "source:"+sourceWidget+" sourceEvent:"+sourceEvent+" targetWidget:"+targetWidget+" targetEvent:"+targetEvent);
          if (typeof sourceWidget == "undefined" || sourceWidget === null) {
		  	return false;
		  }
          if (typeof sourceEvent == "undefined" || sourceEvent === null) {
		  	return false;
		  }
          if (typeof targetWidget == "undefined" || targetWidget === null) {
		  	return false;
		  }
          if (typeof targetEvent == "undefined" || targetEvent === null) {
		  	return false;
		  }
         
		 var rc = false; 
		  //if target widget is an iframe widget, we need to delegate the job to iframed widget
		var isInlineClient = this.hubAdapter.isInlineClient(targetWidget);
		//send message to 
		if (isInlineClient == false) {
			// Eventname:eventservice.widgetid
			// methodname:addWire
			// params:{}
			// hubclient:hubclientid
			var eventname = "eventservice." + targetWidget;
			var payload = {};
			payload.methodname = "addWire";
			payload.params = arguments;
			payload.hubclient = "main";
			this._publishEvent(event, payload);
			rc = true;
		}
		else {
			//update js object and subscribe wire
			rc = this.subscribeWire(sourceWidget, sourceEvent, targetWidget, targetEvent);
			if (rc) {
				var widget = iWidgetContainer.getWidgetById(targetWidget);
				if (typeof widget != "undefined" && widget !== null) {
					var aWire = {};
					aWire.SourceWidget = sourceWidget;
					aWire.SourceEvent = sourceEvent;
					aWire.TargetEvent = targetEvent;
					var instance = widget.getIWidgetInstance();
					var wireObj = new com.ibm.mm.iwidget.widget.WireImpl(targetWidget, aWire);
					instance._addWire(wireObj);
				}
			}
		}
          return rc;
      },
      removeWire: function(sourceWidget,sourceEvent,targetWidget,targetEvent){
       //SPI support, deprecated, remove , no sandboxed support
          com.ibm.mm.enabler.debug.entry("eventService.removeWire", "source:"+sourceWidget+" sourceEvent:"+sourceEvent+" targetWidget:"+targetWidget+" targetEvent:"+targetEvent);
          if (typeof sourceWidget == "undefined" || sourceWidget === null) {
		  	return false;
		  }
          if (typeof sourceEvent == "undefined" || sourceEvent === null) {
		  	return false;
		  }
          if (typeof targetWidget == "undefined" || targetWidget === null) {
		  	return false;
		  }
          if (typeof targetEvent == "undefined" || targetEvent === null) {
		  	return false;
		  }
          	 var rc = false; 
		  //if target widget is an iframe widget, we need to delegate the job to iframed widget
		var isInlineClient = this.hubAdapter.isInlineClient(targetWidget);
		//send message to 
		if (isInlineClient == false) {
			// Eventname:eventservice.widgetid
			// methodname:addWire
			// params:{}
			// hubclient:hubclientid
			var eventname = "eventservice." + targetWidget;
			var payload = {};
			payload.methodname = "removeWire";
			payload.params = arguments;
			payload.hubclient = "main";
			this._publishEvent(event, payload);
			rc = true;
		}
		else {
			rc = this.unSubscribeWire(sourceWidget, sourceEvent, targetWidget, targetEvent);
			if (rc) {
				var widget = iWidgetContainer.getWidgetById(targetWidget);
				if (typeof widget != "undefined" && widget !== null) {
					var aWire = {};
					aWire.SourceWidget = sourceWidget;
					aWire.SourceEvent = sourceEvent;
					aWire.TargetEvent = targetEvent;
					var instance = widget.getIWidgetInstance();
					var wireObj = new com.ibm.mm.iwidget.widget.WireImpl(targetWidget, aWire);
					instance._removeWire(wireObj.getID());
				}
			}
		}
           return rc;         
      },
      fireEvent: function(targetWidget,targetEvent,payload,payloadType,sourceWidget){      
        //allows a third party to fire a event in a target widget
         var aEvent = new com.ibm.mm.iwidget.iEventImpl(targetEvent,payloadType,payload,sourceWidget);    
         //need to make sure  the widget is loaded
		 var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
         var widget = widgetModel.find(targetWidget);
		 
		 var cb = function(eventSvr,targetWWrapper,aEvent,subscribeID){
		 	 var isInlineClient = eventSvr.hubAdapter.isInlineClient(targetWWrapper.id);
			 if(isInlineClient) eventSvr._publishEvent(eventSvr.WIDGETEVENT_PREFIX + targetWWrapper.id,aEvent,aEvent.source);
			 else{
			 	var payloadObj = {};
				if (aEvent.name == iwConstants.EVENTS.onModeChanged){			
					payloadObj.methodname = "_handleOnModeChange";
					payloadObj.params = [payload];
					targetWWrapper.handleEvent(payloadObj);
					return;			
				}
			
			 	payloadObj.methodname = "fireEvent";
		 		payloadObj.hubclient = eventSvr.getId();
		 		payloadObj.params = [targetWWrapper.id,aEvent.name,aEvent.payload,aEvent.type];
         		eventSvr._publishEvent("eventservice."+targetWWrapper.id,payloadObj);				 	
			 }	
			 if (subscribeID) { //delete subscriber
			 	var subHandle = eventSvr.subMgr[subscribeID];
				if (subHandle)eventSvr.unsubscribeEvent(subHandle);
				delete eventSvr.subMgr[subscribeID];			 	
			 }	 	
		 }
		 if (typeof widget != "undefined" && widget !== null && widget.isLoaded() == true ) {
		 	 cb(this,widget,aEvent);
			 
		}
		else{ 
			var that = this;
		//subscribe widgetloaded event with callback
			//var subscribeID = com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + "." + targetWidget;
			var subscribeID = dojox.uuid.generateTimeBasedUuid();
			var subHandle = this.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + "." + targetWidget, null, 		   function(){
				var widget = widgetModel.find(targetWidget);
				cb(that,widget,aEvent,subscribeID);
			});	
			this.subMgr[subscribeID]=subHandle;
		}
      },	
      //support pagechanged event and widget deleted event
      publishEvent: function(sourceEvent,payload, payloadType,sourceid){
	  	   // dojo dojo.publish(topic: String, args: Array);
           com.ibm.mm.enabler.debug.entry("eventService.publishEvent"," sourceEvent:"+sourceEvent);
           if (typeof sourceEvent == "undefined" || sourceEvent === null) {
		   	return;
		   }
		   if (sourceEvent.indexOf(this.WILDCARD_PREFIX) == 0){
			    var temp = this.WILDCARD_PREFIX;
				return this.broadcastEvent(sourceEvent.substring(temp.length),payload,payloadType,sourceid);    
		   }
		   else if (sourceEvent.indexOf(this.WIDGETEVENT_PREFIX) == 0) {
				var temp = sourceEvent.substring(this.WIDGETEVENT_PREFIX.length);
				var widget = temp.substring(0,temp.indexOf("."));
				var event = temp.substring(temp.indexOf(".")+1);
				return this.fireEvent(widget,event,payload,payloadType,sourceid);
		   }
           this._publishEvent(sourceEvent,payload,sourceid);
      },	
	  _publishEvent:function(event,payload,sourceid){	  
	  	//internal use	
		/*payload; need to be json object if it's openajax hub, for now, it's dojo, so it need to be array*/
		   var client = this.hubAdapter.getInlineHubClient(sourceid);		   
		   if (typeof payload == "undefined" || payload === null) {
		   	 client.publish(event);
		   }
		   else{
		   	 client.publish(event,payload);		
		   }	
	  },
		BROADCAST_EVENTS_COOKIE_ID: "com.ibm.mashups.enabler.broadcastEvents", 	
		BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID: "com.ibm.mashups.enabler.broadcastEventsSourceId", 	
	  broadcastEvent: function(targetEvent,payload,payloadType,sourceid){
			 this.broadcastEvent(targetEvent, payload, payloadType, sourceid, null);
		   return;
    },	
	  broadcastEvent: function(targetEvent,payload,payloadType,sourceid,pageid){
			 this.broadcastEvent(targetEvent, payload, payloadType, sourceid, pageid, null);
		   return;
    },	
	  broadcastEvent: function(targetEvent,payload,payloadType,sourceid,pageid,spaceid){
			 var eventObj = new Object();
			 eventObj.targetEvent = targetEvent;
			 eventObj.payload = payload;
			 eventObj.payloadType = payloadType;
			 this.broadcastEvents([ eventObj ], sourceid, pageid, spaceid);
		   return;
    },	
    broadcastEvents: function(eventsArray,sourceid){
			this.broadcastEvents(eventsArray, sourceid, null);
			return;
    },
    broadcastEvents: function(eventsArray,sourceid,pageid){
			this.broadcastEvents(eventsArray, sourceid, pageid, null);
			return;
    },
	  broadcastEvents: function(eventsArray,sourceid,pageid,spaceid){
			  if ((eventsArray === null) || !dojo.isArray(eventsArray)) {
			 	  return;
			  }
			  var navStateModel = com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
			  var spaceAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getSpaceAccessor(navStateModel);
			  var currentSpaceID = spaceAccessor.getSpaceID();
			  var pageAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getPageAccessor(navStateModel, currentSpaceID);
			  var currentPageID = pageAccessor.getPageID();

			  if ((pageid != null) && (typeof pageid == "string") && (pageid != currentPageID)) {
					// store cache. if target page is not a complete page reload, then cache will be
					// used directly without the need to read the cookie.
					this.broadcastEventsCache = eventsArray;
					this.broadcastEventsSourceIdCache = sourceid;
					// if target page has a different theme there is currently a complete page reload,
					// so store the events in a cookie. when switch theme is changed to not require
					// a complete page reload, then this cookie can be removed.
					if (dojo.cookie.isSupported()) {
		  			dojo.cookie(this.BROADCAST_EVENTS_COOKIE_ID, dojo.toJson(eventsArray), {expires:1});
		  			dojo.cookie(this.BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID, sourceid, {expires:1});
		  		}
	   	    // switch page
					if ((spaceid != null) && (typeof spaceid == "string") && (spaceid != currentSpaceID)) {
						spaceAccessor.setSpaceID(spaceid);
					}
					pageAccessor.setPageID(pageid);
					var deferred = navStateModel.commit();
					deferred.start();
				}	else {
					// no switch page - stay on current page
					var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
					var widgets = widgetModel.getAllWidgets();
					var that = this;
					var checkHandledEvents = function(widget, eventsArray,subscribeID){
						var handledEvents = widget.getWidgetHandledEvents();
						if (handledEvents != null) {
							for (var i = 0; i < eventsArray.length; i++) {
								for (var j = 0; j < handledEvents.length; j++) {
									if (eventsArray[i].targetEvent == handledEvents[j].name) {
										that.fireEvent(widget.getID(), eventsArray[i].targetEvent, eventsArray[i].payload, eventsArray[i].payloadType, sourceid);
										break;
									}
								}
							}
						}
						if (subscribeID && subscribeID != null) {							
							var subHandle = that.subMgr[subscribeID];
							if (subHandle)that.unsubscribeEvent(subHandle);
							delete that.subMgr[subscribeID];						
						}
					}
					for (var i in widgets) {
						var aWidget = widgets[i];
						if (aWidget.isLoaded() == true) {
							checkHandledEvents(aWidget, eventsArray);
						}
						else {
							if(!aWidget.lazyLoad || (aWidget.lazyLoad && aWidget.lazyLoad != true)){
							var subscribeID = dojox.uuid.generateTimeBasedUuid();
							var subHandle = this.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + "." + aWidget.getID(), null, dojo.partial(checkHandledEvents, aWidget, eventsArray,subscribeID));
							this.subMgr[subscribeID]=subHandle;
							}
						}
					}
					for (var i = 0; i < eventsArray.length; i++) {
						this._publishEvent(eventsArray[i].targetEvent, eventsArray[i].payload, sourceid);
					}
				}
			  return;
		},
  		_handleBroadcastEventsCache:function(){
		  if (this.broadcastEventsCache === null || typeof this.broadcastEventsCache == "undefined") {
				if (dojo.cookie.isSupported()) {
					this.broadcastEventsCache = dojo.fromJson(dojo.cookie(this.BROADCAST_EVENTS_COOKIE_ID));
				}
			}
		  if (this.broadcastEventsCache != null && typeof this.broadcastEventsCache != "undefined" && dojo.isArray(this.broadcastEventsCache)) {
			  if (this.broadcastEventsSourceIdCache === null || typeof this.broadcastEventsSourceIdCache == "undefined") {
					if (dojo.cookie.isSupported()) {
						this.broadcastEventsSourceIdCache = dojo.cookie(this.BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID);
					}
				}
				// use a shallow copy (dojo.map) of the array here to pass array by value rather than by reference
				this.broadcastEvents(dojo.map(this.broadcastEventsCache, function(item){return item;}), this.broadcastEventsSourceIdCache);
				// clear cache and cookies after broadcasting - use only once
				this.broadcastEventsCache = null;
				this.broadcastEventsSourceIdCache = null;
  			dojo.cookie(this.BROADCAST_EVENTS_COOKIE_ID, null, {expires:-1});
  			dojo.cookie(this.BROADCAST_EVENTS_SOURCE_ID_COOKIE_ID, null, {expires:-1});
	    }			
		},
	  _subscribeEvent:function(event,object,eventCallback,subscribeCallback,sourceid){
	  	  var client = this._getHubAdapter().getInlineHubClient(sourceid);
          //return dojo.subscribe(event,object,eventCallback);
		  //return subscription id for openajax hub
		  
		   var subHandle1 = client.subscribe( event,
              function( topic, data, subscriberData ) { /*onData*/
			     var ec = eventCallback;
				 if (typeof object != "undefined" && object != null && typeof eventCallback != "undefined" && eventCallback != null) {
					ec = dojo.hitch(object,eventCallback);
				 }
				 
				 //Deserialize data,not necessary		 
				 
				 if (typeof ec != "undefined" && ec != null) {
				 	ec(data);
				 }
               },
              null /* scope */,
              function( subID, success, error ) { /*onComplete*/
			   if (typeof object != "undefined" && object != null && typeof subscribeCallback != "undefined" && subscribeCallback != null) {
					subscribeCallback = dojo.hitch(object,subscribeCallback);
				 }
			 	if (typeof subscribeCallback != "undefined" && subscribeCallback != null){
					subscribeCallback.apply(this,[subID,success,error]);
				}
                if ( ! success ) {
                     console.log("subscription for "+subID+" failed");
                    return;
                }
              }
            );  
			return subHandle1; 
      },
	  subscribeEvent:function(event,object,eventCallback,subscribeCallback,sourceid){
	  	return this._subscribeEvent(event,object,eventCallback,subscribeCallback,sourceid);	
      },	     	     
	  _unsubscribeEvent:function(subscriptionHandler,sourceid){
	  	 var client = this._getHubAdapter().getInlineHubClient(sourceid);
    	 try {
		 	if (typeof client != "undefined" || client != null)
		 	client.unsubscribe(subscriptionHandler);
		 }
		 catch(e){//workaround for hub bug
				console.log("unsubscribe failure:"+e);
		 }     
      }, 
	  unsubscribeEvent:function(subscriptionHandler,sourceid){
	  	if (typeof subscriptionHandler == "undefined" || subscriptionHandler == null)return;
	  	this._unsubscribeEvent(subscriptionHandler,sourceid);
	  },
	  _generateWireId:function(sourceWidget,sourceEvent,targetWidget,targetEvent){
	  	return sourceWidget +"_"+ sourceEvent + "_"+targetWidget+"_"+targetEvent;
	  }  	  
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.services.iframeeventservice"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.services.iframeeventservice"] = true;
dojo.provide("com.ibm.mm.iwidget.services.iframeeventservice");







dojo.declare("com.ibm.mm.iwidget.services.IframeEventServiceImpl",null,  {
	constructor:function(){
		this.subMgr = {}; //save all the subscription on this widget
		this.eventQueue = [];
		this.getHubClient();//initialize connection 	
        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);			
    },	
	PREFIX_IFRAME:"_iframe_",
	getHubClient:function(){
		//console.log("getHubClient");
		if (this._hubClient != null) return this._hubClient;		
			var that = this;
			//create hub client and connect to hub		
			function onHubClientSecurityAlert(source, alertType){
			    if(that.bIsLoggable) that.LOGGER.trace("onHubClientSecurityAlert","security alert from " + source.getClientID());
			}
			var hubClient = new OpenAjax.hub.IframeHubClient({
				HubClient: {
					onSecurityAlert: onHubClientSecurityAlert				
				}
			});
			function onHubClientConnect2(client, success, error){
				if (!success) {
				    if(that.bIsLoggable) that.LOGGER.trace("onHubClientConnect2","!! client connection error = id: '" + client.getClientID() + "' msg: '" + error);
				}
				var id = client.getClientID();
				id = id.slice(8);
				that.setId(id);
				that._hubClient = client;
				that._subscribeEventService();
				for (var i in that.eventQueue){
					var args = that.eventQueue[i];
					args[0] = "widgetevents."+id+args[0];					
					that._subscribeEvent.apply(that,args);
				}			
			}
			
			function onHubClientDisconnect(client, success, error){
        if (!success) {
 		    if(that.bIsLoggable) that.LOGGER.trace("onHubClientDisconnect2","!! client disconnection error = id: '" + client.getClientID() + "' msg: '" + error);
        }
        client.connect(onHubClientConnect2);
      }
      
	  function onHubClientConnect1(client, success, error){
        if (!success) {
		  if(that.bIsLoggable) that.LOGGER.trace("onHubClientConnect1","!! client connection error = id: '" + client.getClientID() + "' msg: '" + error);
        }
	
		//In safari3.2 , if the current client is  a sub window like  "wid_edit"...call disconnect will disconnect all the subscription from the main iframe winodw"wid", thus we 
		//make the workaround, don't disconnect if it's bring up the edit window.
		var clientID = client.getClientID();
		if (clientID.indexOf("_edit") == -1){
		        client.disconnect(onHubClientDisconnect);
		}	
		else{
			onHubClientConnect2(client,success,error);
		}
      }
       
      // In browsers other than IE, it is important to connect, disconnect and connect again so as not to get
      // duplicate subscriptions when reusing the same hub client id. Disconnect clears all prior subscriptions,
      // so this logic ensures that there will never be duplicates. This technique is not required in IE as IE
      // does not reload the iframe when the parent changes. This is particularly important for change skin in
      // Safari, for example, where we do not have any other hook to disconnect the hub client.
      if (dojo.isIE) {
        hubClient.connect(onHubClientConnect2);
      } else {
        hubClient.connect(onHubClientConnect1);
      }
			return null;			
	},
  disconnectHubClient:function() {
    if (this._hubClient == null) return;
    this._hubClient.disconnect();
    this._hubClient = null;
  },
	setId:function(id){
		this.id = id;
	},
	getId:function(){
		return this.id;
	},
	_subscribeEventService:function(){
		//dispatch event to each method....for now, just fireEvent
		//in future, broadcastEvent... has security concern though
		var that=this;
		// message should contain
		// methodname:fireEvent
		// params:{}
		// hubclient:hubclientid
	    function eventCallback( topic, message,subscribeData ){
			//(targetWidget,targetEvent,message.payload,message.payloadType,sourceWidget)
			var methodname = message.methodname;
			if (typeof methodname != "undefined" && methodname !=null){
				var fn = that[message.methodname];
				if (typeof fn != "undefined" && fn != null){
					that[methodname].apply(that,message.params);
				}	
			}			
		}				
		this._hubClient.subscribe("eventservice."+this.getId(),eventCallback,this,this._subscribeCallback);
	},
	_subscribeCallback:function(subHandle,success,/*OpenAjax.hub.Error*/error){
		if (!success) {
			//console.log("subscribe failed "+subHandle);
		}		
	},	
	WIDGETEVENT_PREFIX:iwConstants.WIDGETEVENT_PREFIX,
	WILDCARD_PREFIX:iwConstants.WILDCARD_PREFIX,	
   	subscribeWire: function (/*String*/sourceWidget,/*String*/sourceEvent,/*String*/targetWidget,/*String*/targetEvent) {
		//called within iframe, target widget is the sandboxed iwidget
        com.ibm.mm.enabler.debug.entry("eventService.subscribeWire", "source:"+sourceWidget+" sourceEvent:"+sourceEvent+" targetWidget:"+targetWidget+" targetEvent:"+targetEvent);
        if (typeof sourceWidget == "undefined" || sourceWidget === null) return false;
        if (typeof sourceEvent == "undefined" || sourceEvent === null) return false;
        if (typeof targetWidget == "undefined" || targetWidget === null) return false;
		if (typeof targetEvent == "undefined" || targetEvent === null) return false;
		
		var rc = true;
		var that=this;
		
		// should be subHandle, topic, payload ( as defined in publishWire...)		       		     
		function eventCallback(topic, message,subscribeData){
			//that.fireEvent(targetWidget, targetEvent, message.payload, message.payloadType, sourceWidget);
		    //distribute event directly to iwidgetwrapper
			that.fireEvent(targetWidget, targetEvent, message.payload, message.payloadType, sourceWidget)
		}
		function callback(item, success, error){
			if (!success) {
				  if(that.bIsLoggable) that.LOGGER.trace("subscribeWire","eventService.subscribeWire subscribe failed " + "source:" + sourceWidget + " sourceEvent:" + sourceEvent + " targetWidget:" + targetWidget + " targetEvent:" + targetEvent);
				}
		}
		var subHandler = this._hubClient.subscribe(this.WIDGETEVENT_PREFIX + sourceWidget + "." + sourceEvent, eventCallback, null, callback);
		var wireId = this._generateWireId(sourceWidget, sourceEvent, targetWidget, targetEvent);
		this.subMgr[wireId] = subHandler;			
		    
        //notify source iWidget  -- onNewWire
        var payload = {};
        payload.targetWidget = targetWidget;
        payload.sourceEvent = sourceEvent;
        payload.sourceWidget = sourceWidget;
        payload.targetEvent = targetEvent;
        this.fireEvent(sourceWidget,"onNewWire",payload);     
        return rc;
    },
    publishWire: function(/*String*/sourceWidget,/*String*/sourceEvent,/*object*/payload,/*String*/payloadType){
       payload = this._serializePayload(payload);

        //allow widget to fire a event   
        if (typeof sourceWidget == "undefined" || sourceWidget === null) {
			return false;
		}
        if (typeof sourceEvent == "undefined" || sourceEvent === null) {
			return false;
		}
		this._hubClient.publish(this.WIDGETEVENT_PREFIX+sourceWidget+"."+sourceEvent,{"payload": payload,"payloadType": payloadType});
	    return true;
     },     
     _serializePayload: function(payload) {
        // complex payload objects must be serialized to json for case when widgets are sandboxed
        // to be serializable, complex payload objects must implement toJson method that returns json in format {"className":"x","json":"y"}
        // to be deserializable, complex payload objects must have a constructor with an argument that accepts the "y" json value returned from toJson
        if (typeof payload == 'object' && payload.toJson) {
          payload = payload.toJson();
        }
        return payload;
     },
     unSubscribeWire: function(sourceWidget,sourceEvent,targetWidget,targetEvent){
	 	 if (typeof sourceWidget == "undefined" || sourceWidget === null) return false;
		 if (typeof sourceEvent == "undefined" || sourceEvent === null) return false;
		 if (typeof targetWidget == "undefined" || targetWidget === null) return false;		 
         if (typeof targetEvent == "undefined" || targetEvent === null) return false;
        
		 //unsubscribe from OAHub
		 var wireId = this._generateWireId(sourceWidget,sourceEvent,targetWidget,targetEvent);
		 var subHandler =	this.subMgr[wireId];
		 if (typeof(subHandler) != "undefined" && subHandler != null) {
		 	this._unsubscribeEvent(subHandler, targetEvent);
			delete this.subMgr[wireId];
		 }				             
            
        //onRemoveWire-- notify target widget
		var payload = {};
		payload.targetWidget = targetWidget;
		payload.targetEvent = targetEvent;
		payload.sourceWidget = sourceWidget;
		payload.sourceEvent = sourceEvent;
		this.fireEvent(targetWidget, "onRemoveWire", payload);
		this.fireEvent(sourceWidget, "onRemoveWire", payload);
		//builder is listening on this event
		this._publishEvent(com.ibm.mm.iwidget.iEvents.Constants.unSubscribeWire, {
							wires: [payload]
						});		
     },     
     fireEvent: function(targetWidget,targetEvent,payload,payloadType,sourceWidget){
		var aEvent = new com.ibm.mm.iwidget.iEventImpl(targetEvent,payloadType,payload,sourceWidget);    
        // this._publishEvent(this.WIDGETEVENT_PREFIX+targetWidget,aEvent,sourceWidget);   
		var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
       	var widget = widgetModel.find(targetWidget);
		if (typeof widget != "undefined" && widget !== null) {
			if (widget.isLoaded()== true){
				//if widget isEventsReady
            	widget.handleEvent(aEvent);             
         	}
         	else{    
			   var subID = dojox.uuid.generateTimeBasedUuid();
			   var cb = function(eventSvr,wrapper,aEvent){
			   		wrapper.handleEvent(aEvent);
					var subHandler = eventSvr.subMgr[subID];
					if (subHandler) eventSvr._unsubscribeEvent(subHandler);								   	
			   }
    		   var subHandle = this.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + "." + widget.id, null, dojo.partial(cb, this,widget,aEvent));
			   this.subMgr[subID]=subHandle;	
           }
		}else{  //if widget doesn't belong to iframe delegate the job to main eventservice since it can check if widget is loaded or not
			//build payload methodname:fireEvent params:[] hubclient:hubclientid
		 	var payloadObj = {};
		 	payloadObj.methodname = "fireEvent";
		 	payloadObj.hubclient = this.getId();
		 	payloadObj.params = [targetWidget,targetEvent,payload,payloadType];
         	this._publishEvent("eventservice.main",payloadObj);
		}		        
     },	
     //support pagechanged event and widget deleted event
     publishEvent: function(sourceEvent,payload, payloadType,sourceid){
	  	  return;
     },	
	 _publishEvent:function(event,payload,sourceid){	  	
		/*payload; need to be json object if it's openajax hub, for now, it's dojo, so it need to be array*/
		   if (typeof payload == "undefined" || payload === null) {
		   	 this._hubClient.publish(event,"");
		   }
		   else{
		   	 this._hubClient.publish(event,payload);		
		   }	
	  },
	  broadcastEvent: function(targetEvent,payload,payloadType,sourceid){
			// untrusted widgets are not trusted to broadcast events
			return;
    },
	  broadcastEvent: function(targetEvent,payload,payloadType,sourceid,pageid){
			// untrusted widgets are not trusted to broadcast events
			return;
    },
	  broadcastEvent: function(targetEvent,payload,payloadType,sourceid,pageid,spaceid){
			// untrusted widgets are not trusted to broadcast events
			return;
    },
    broadcastEvents: function(eventsArray,sourceid){
			// untrusted widgets are not trusted to broadcast events
			return;
    },
    broadcastEvents: function(eventsArray,sourceid,pageid){
			// untrusted widgets are not trusted to broadcast events
			return;
    },
    broadcastEvents: function(eventsArray,sourceid,pageid,spaceid){
			// untrusted widgets are not trusted to broadcast events
			return;
    },
		_handleBroadcastEventsCache: function() {
			// pass to main event service
		 	var payloadObj = {};
		 	payloadObj.methodname = "_handleBroadcastEventsCache";
		 	payloadObj.hubclient = this.getId();
		 	payloadObj.params = [];
     	this._publishEvent("eventservice.main",payloadObj);			
		},
	  subscribeEvent:function(event,object,eventCallback,subscribeCallback,sourceid){
			return;
	  },
	  _subscribeEvent:function(event,object,eventCallback,subscribeCallback,sourceid){
	  	   //internal use only for subscription managed by container
		   //widgets should not use this at all. 
		   if (this._hubClient == null){
				this.eventQueue.push(arguments);
				return;		   
		   }			
			
		   var subHandle1 = this._hubClient.subscribe( event,
              function( topic, data, subscriberData ) { /*onData*/
			     if (typeof object != "undefined" && object != null && typeof eventCallback != "undefined" && eventCallback != null) {
					eventCallback = dojo.hitch(object,eventCallback);
				 }
				 
				 //Deserialize data,not necessary				 
				 
				 if (typeof eventCallback != "undefined" && eventCallback != null) {
				 	eventCallback.apply(this,[data]);
				 }
               },
              null /* scope */,
              function( subID, success, error ) { /*onComplete*/
			   if (typeof object != "undefined" && object != null && typeof subscribeCallback != "undefined" && subscribeCallback != null) {
					subscribeCallback = dojo.hitch(object,subscribeCallback);
				 }
			 	if (typeof subscribeCallback != "undefined" && subscribeCallback != null){
					subscribeCallback.apply(this,[subID,success,error]);
				}
                if ( ! success ) {
                    return;
                }
              }
            );  
			return subHandle1; 
      },	     
	  _unsubscribeEvent:function(subscriptionHandler,sourceid){   
	   	if (typeof subscriptionHandler == "undefined" || subscriptionHandler == null)return;
		 this._hubClient.unsubscribe(subscriptionHandler);          
      },
	  unsubscribeEvent:function(subscriptionHandler,sourceid){          
		 return;         
      },
	  _generateWireId:function(sourceWidget,sourceEvent,targetWidget,targetEvent){
	  	return sourceWidget +"_"+ sourceEvent + "_"+targetWidget+"_"+targetEvent;
	  }     	  
});


}

if(!dojo._hasResource["com.ibm.mashups.enabler.xml"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.xml"] = true;
dojo.provide( "com.ibm.mashups.enabler.xml" );
dojo.provide( "com.ibm.mashups.enabler.xml.XPath" );

/**
 Interface provides functions to select nodes  by evaluating XPATH expression
  @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.xml.XPath",null,  {
	/**
            * @private
            */
    constructor:function(){
 
    },

/**
This interface returns a list of XMLNodes upon XPATH evaluation.
@param{String} xpathExpr the xpath expression (i.e. /atom:content). Must not be NULL.
@param{XMLDocument} doc the XML document. Must not be NULL.
@param{JSON} namespaces the namespaces used as part of the xpath expression. The json must be of the format {"prefix": "URL", ... }. Must not be NULL.<br>
Example: { "atom" : "http://www.w3.org/2005/Atom", "app" : "http://www.w3.org/2007/app" };
@type XMLNodeList
@returns{XMLNodeList} select nodes from XML document with xpath. May be NULL.
*/ 	
    evaluateXPath:function(xpathExpr,  doc, namespaces){   
    }
});


}

if(!dojo._hasResource["com.ibm.mm.enabler.xpath"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.xpath"] = true;
dojo.provide( "com.ibm.mm.enabler.xpath" );

// generic impl

com.ibm.mm.enabler.xpath.evaluateXPath = function(/*String*/xpathExpr, /*DOMDocument*/ doc, /*Object{prefix:ns,prefix2:ns2,...}*/namespaces, internal) {
    if (typeof internal == "undefined") {
        com.ibm.mm.enabler.debug.warn("com.ibm.mm.enabler.xpath.evaluateXPath", 
        "This method must not be used directly. Use com.ibm.mashups.enabler.xml.evaluateXPath instead.",
        xpathExpr);
    }
	if (dojo.isSafari) {
		return com.ibm.mm.enabler.xpath.safari.evaluateXPath(xpathExpr,doc,namespaces);
	} else if (dojo.isIE) {
		return com.ibm.mm.enabler.xpath.ie.evaluateXPath(xpathExpr, doc, namespaces);
	} else {
		return com.ibm.mm.enabler.xpath.gecko.evaluateXPath(xpathExpr, doc, namespaces);
	}
};

// Safari implementation
dojo.provide("com.ibm.mm.enabler.xpath.safari");
com.ibm.mm.enabler.xpath.safari.evaluateXPath = function(/*String*/xpathExpr, /*DOMDocument*/ doc, /*Object{prefix:ns,prefix2:ns2,...}*/namespaces) {

    var result;
    if (typeof XPathResult != "undefined") {
        //use build in xpath support for Safari 3.0
        var results = document.evaluate(xpathExpr,doc, function(prefix) { return namespaces[prefix] || null;}, XPathResult.ANY_TYPE, null );
        var thisResult;
        result = [];
        var len = 0;
        do {
            thisResult = results.iterateNext();
            if (thisResult) {
                result[len] = thisResult;
                len++;
            }
        } while ( thisResult );
    }
    else {
        //use javeline Safari2 xpath support
        if (doc.selectNodes) {
            result = doc.selectNodes(xpathExpr);
        }
    }
    return result;
};



// IE Implementation

dojo.provide( "com.ibm.mm.enabler.xpath.ie" );

com.ibm.mm.enabler.xpath.ie.evaluateXPath = function(/*String*/xpathExpr, /*DOMDocument*/ doc, /*Object{prefix:ns,prefix2:ns2,...}*/namespaces) {
        if (namespaces) {        
            var ns = "";
            for (var prop in namespaces) {
                if (prop != "xml") {
					// TODO - unclear why this is required
					ns += "xmlns:" + prop + "='" + namespaces[prop] + "' ";
				}
            }
            if (doc.ownerDocument) {
                doc.ownerDocument.setProperty("SelectionNamespaces", ns); 
                doc.ownerDocument.setProperty("SelectionLanguage", "XPath"); 
            } else {
                doc.setProperty("SelectionNamespaces", ns);
                doc.setProperty("SelectionLanguage", "XPath"); 
            }
        }
        var result = doc.selectNodes(xpathExpr);

        var thisResult;
        var resultSet = [];
        var len = 0;
        for (var i=0; i<result.length; i++) {
            thisResult = result[i];
            if (thisResult) {
                resultSet[len] = thisResult;
                len++;
            }
        }
        return resultSet;
};


// GECKO Implementation

dojo.provide( "com.ibm.mm.enabler.xpath.gecko" );

com.ibm.mm.enabler.xpath.gecko.evaluateXPath = function(/*String*/xpathExpr, /*DOMDocument*/ doc, /*Object{prefix:ns,prefix2:ns2,...}*/namespaces) {
        var result;
        try {
            var xmlDocument = doc;
            if (doc.nodeType != 9) {
                xmlDocument = doc.ownerDocument;
            }  
            result = xmlDocument.evaluate( xpathExpr, doc, function(prefix) { return namespaces[prefix] || null;}, XPathResult.ANY_TYPE, null );
        } catch (exc) {
            //Callers should catch this and can substitute their own error message
            throw new Error("Error with xpath expression" + exc);
        }
    
        var thisResult;
        var resultSet = [];
        var len = 0;
        do {
            thisResult = result.iterateNext();
            if (thisResult) {
                resultSet[len] = thisResult;
                len++;
            }
        } while ( thisResult );
        return resultSet;
};

// evaluates the specified xpath, but creates xml elements, which are not part
// of the document; please note that attributes are not supported
com.ibm.mm.enabler.xpath.createXPath = function(xPath, node, namespaces) {

	// split off first part of xpath
	var xPathParts = xPath.split("/");

	// handle head
	var qName = xPathParts[0];

	// extract name and name space 
	var qNameParts = qName.split(":");
	if (qNameParts.length > 1) {
		var namespace = qNameParts[0];
		var name = qNameParts[1];
	} else {
		var name = qNameParts[0];					
	}

	// search for first part of xpath (what about case insensitive search for attributes, especially "_" vs "-" in locales?)
	var names = com.ibm.mashups.enabler.xml.XPath.evaluateXPath((namespace ? namespace + ":" : "") + name, node, namespaces);			
	if (names && names.length > 0) {
		// use existing xml element
		var result = names[0];
	} else {
		// what about attributes?
		// create xml element
        var result = com.ibm.mm.enabler.dom.createElement(node.ownerDocument, name, namespace ? namespaces[namespace] : null);		
		node.appendChild(result);
	}

	// handle remaining parts of xpath
	if (xPathParts.length > 1) {
		// recursive call with remaining xpath part
		result = com.ibm.mm.enabler.xpath.createXPath(xPath.substr(xPath.indexOf("/") + 1), result, namespaces);
	} 
	return result;
};

}

if(!dojo._hasResource["com.ibm.mm.enabler.xml"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.xml"] = true;
dojo.provide( "com.ibm.mm.enabler.xml");





dojo.declare("com.ibm.mm.enabler.xml.XPathImpl",[com.ibm.mashups.enabler.xml.XPath],
{
    constructor: function() {
        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.xml.XPath");
    },
    evaluateXPath: function(xpathExpr,  doc, namespaces) {
        var METHOD_NAME = "evaluateXPath(xpathExpr,  doc, namespaces)";
        var bIsLogging = this.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
        if (bIsLogging)
            this.LOGGER.entering(METHOD_NAME, [xpathExpr, doc, namespaces]);
            
        var ret = com.ibm.mm.enabler.xpath.evaluateXPath(xpathExpr, doc, namespaces, true);

        if (bIsLogging)
            this.LOGGER.exiting(METHOD_NAME, ret);

        return ret;
    } 
});

// create the singleton
com.ibm.mashups.enabler.xml.XPath = new com.ibm.mm.enabler.xml.XPathImpl(); 

}

if(!dojo._hasResource["com.ibm.mm.iwidget.services.internalservices"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.services.internalservices"] = true;
dojo.provide("com.ibm.mm.iwidget.services.internalservices");

dojo.declare("com.ibm.mm.iwidget.services.ResourceLoadServiceImpl",null, {
    constructor:function(){
      //loadModelus to keep track that if a resource has been loaded already
      this.modules = {};  
	  this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
      this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
      this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);	
	  this.LOADING_TOKEN = 0;
	  this.LOADING_ERROR_TOKEN = 1;
	  this.LOADED_TOKEN = 2;
	  this.waitingqueue = {};	  
    }, 

    loadResource: function(widgetId,name,uri,cb,mimetype,cb2){
       com.ibm.mm.enabler.debug.entry("loadService.loadResource","uri:"+uri+" mimetype:"+mimetype+" widgetId:"+widgetId);
       //name = name? name:uri;       
	   var path = this._rewriteUrl(uri,widgetId);
	   	
       var resourceData = this.modules[path];
	   var loadedFC = function(data,status){
		   if (cb2) {
		   	   // suspend the transaction in order to avoid feeds/other sensitive data
			   // from being part of the MP transaction
		       var mpHandler = com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
               mpHandler.suspendTransaction();
			   if(data &&status) cb2(data,status);
			   else  cb2();
               mpHandler.resumeTransaction();
           }	   
	   };
       if ( resourceData && resourceData !== null){
			var type = resourceData.type;
			switch(type){
				case 0:
					this.waitingqueue[path] = (this.waitingqueue[path])?this.waitingqueue[path]:[];
					this.waitingqueue[path].push({uri:uri,cb:cb,cb2:cb2});
					return;
					break;
				case 1:
					loadedFC(resourceData.data,resourceData.status);
					return;
					break;
				case 2:
					loadedFC();
					return;
					break;
			}   
	   }       
       
        resourceData = {};
		resourceData.type = this.LOADING_TOKEN;
		this.modules[path] = resourceData;   
 
         var extension = this._getExtension(uri);
        if (extension !== null && extension == "css") {
		    var retVal = this._loadCSS(path);
			this.modules[path].type = this.LOADED_TOKEN;
            if (cb2) {
                var mpHandler = com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
                mpHandler.suspendTransaction();
                cb2();
                mpHandler.resumeTransaction();
            }
            return retVal;
        }  
		
		var jsPath = path;
	    if (dojo.isIE == 6 && path.indexOf("/") == 0) { //ie6 doesn't like "/mum/proxy", it will throw obj error.
				var schema = window.location.protocol;
				var host = window.location.hostname;
				var port = window.location.port;
				jsPath = schema + "//" + host + ":" + port + path;
		}	
		var me = this;
		
		var mpHandler1 = com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
		var isSync = (mpHandler1.isTransaction()==true)?false:true;
		var args = {
                    url: jsPath,
                    sync: isSync,
                    load: function (data, ioArgs) {
                            //status is 0 if it's a local file system resource
                            if(ioArgs.xhr.status == 200 || ioArgs.xhr.status == 0){
                                var oldContents = ioArgs.xhr.responseText;
                                var contents = oldContents.replace(/_IWID_/g,"_"+widgetId+"_");

                                if(cb){
                                    //Todo: queue the response,with resourceData
                                }
                            }

                            if (!contents) {
                                return false;
                            }
             
                            if (extension === "js" || mimetype=="text/javascript") {
                                if (window.execScript) {
                                    window.execScript(contents); // eval in global scope for IE
                                }
                                else {
                                    dojo.eval(contents);
                                }           
                            }
        
                            me.modules[path].type = me.LOADED_TOKEN;   
                            if (cb2) {
                                var mpHandler = com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
                                mpHandler.suspendTransaction();
                                cb2();
                                mpHandler.resumeTransaction();
                            }
							var queue = me.waitingqueue[path];							
							if (queue && queue != null){
								for (var j=0; j<queue.length;j++){
									var req = queue[j];
									if (req.cb2 && req.cb2 != null){
										var callbackfn = req.cb2;
										callbackfn();
									}									
								}
							}
							me.waitingqueue[path] = null;
                        },
						error : function(data, ioArgs){
						     me.modules[path].type = me.LOADING_ERROR_TOKEN;   
							 me.modules[path].data = data;
							 me.modules[path].status = ioArgs.xhr.status;
								var xhr = ioArgs.xhr;
								if (cb2) cb2(data,xhr.status);
								var queue = me.waitingqueue[path];
								if (queue && queue != null){
									for (var h=0; h<queue.length;h++){
										var req = queue[h];
										if (req.cb2 && req.cb2 != null){
											var callbackfn = req.cb2;
											callbackfn(data,xhr.status);
										}									
									}
								}
								me.waitingqueue[path] = null;
 		                 }
                    };

            dojo.xhrGet(args);
    },
	
    _rewriteUrl:function(uri,id){
         var widget = iWidgetContainer.getWidgetById(id);
         var rawUri = widget.getIWidgetInstance().widgetXMLUrl;
		 var rawUri2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(rawUri);
		 if (rawUri2 != null) {
			rawUri = rawUri2;
		 }
		 
		 var queryStart = rawUri.indexOf("?");
         if (0 < queryStart) {
             rawUri = rawUri.substring(0, queryStart);
         }

         var baseUri = rawUri.substring(0,rawUri.lastIndexOf("/")+1);
         
         if ( baseUri.indexOf("://") != -1) {
           var indexOfScheme = uri.indexOf("://");
           var indexOfRoot = uri.indexOf("/",indexOfScheme+1);
           var serverRoot = uri.substring(0, indexOfRoot);
         }

         var path = uri;
         if ( uri.indexOf("://") == -1) {    
             if (uri.indexOf("/") === 0 ) {
                 if (typeof(serverRoot) != "undefined") {
				 	path = serverRoot + uri;
				 }
             }
             else{
                 if (typeof(baseUri) != "undefined") {
				 	path = baseUri + uri;
				 }
             }               
         } 
        if ((path.indexOf("http") === 0)  || (path.indexOf("endpoint") === 0)) {
			path = com.ibm.mm.enabler.utilities.rewriteURL(path);
		} 
        return path;

    },
     _getExtension: function(uri){
         return uri.substring(uri.lastIndexOf(".")+1,uri.length);
    },
    _loadCSS:function(path){
         var link=document.createElement("link");
         link.setAttribute("rel", "stylesheet");
         link.setAttribute("type", "text/css");
         link.setAttribute("href", path);
         document.getElementsByTagName("head")[0].appendChild(link);
    }
 
});

dojo.declare("com.ibm.mm.iwidget.services.PersistentAttributesFactoryServiceImpl",null,  {
    createPersistentAttributes: function(widget)  {
        return new com.ibm.mm.iwidget.itemset.PersistentAttributes(widget, true/*serverless*/);
    }
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.services.qservice"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.services.qservice"] = true;
dojo.provide("com.ibm.mm.iwidget.services.qservice");

dojo.declare("com.ibm.mm.iwidget.services.QueryServiceImpl",null,{
//remove after v2
    
	getiWidgetWrapperById:function(id){
		//deprecated
		var widget = iWidgetContainer.getWidgetById(id);
		if (typeof widget == "undefined" || widget === null) {
			return null;
		}
		return new com.ibm.mm.iwidget.iWidgetWrapperImpl(id); 
    },
    getWidgetById: function(id,obj,cb){
		//deprecated
      
       var widget = iWidgetContainer.getWidgetById(id);
       if (typeof widget == "undefined" || widget === null) {
	   	return null;
	   }
	   if (!obj || !cb){
			if (widget.isLoaded() == true) return new com.ibm.mm.iwidget.WidgetStub(widget);
			else return null;
	   }
	   var cbn = function(widget,obj,cb){
			  obj[cb](new com.ibm.mm.iwidget.WidgetStub(widget));	   
	   }
	   	   
	   if ( widget.isLoaded() == true ) {
		 	 cbn(widget,obj,cb);
	   }
		else{ 
			//subscribe widgetloaded event with callback
			com.ibm.mashups.services.ServiceManager.getService("eventService").subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + "." + id, null, function(){
				var widget = iWidgetContainer.find(id);
				cbn(widget,obj,cb);
			});	
		}     
    },	
    getWidgetsByDefUrl:function(url){
	//deprecated
   
       for(id in iWidgetContainer.widgetArr){
            var widget=iWidgetContainer.widgetArr[id];
            if ( widget && widget !== null ) { 
            var xmlURL=widget.getIWidgetInstance().widgetXMLUrl; 
            if (typeof xmlURL != "undefined" && xmlURL !== null && url == xmlURL) {
				arr.push(id);
			}
            }
       }  

        return arr;      
    }   
});


}

if(!dojo._hasResource["com.ibm.mm.enabler.xslt"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.xslt"] = true;
dojo.provide( "com.ibm.mm.enabler.xslt" );

//---------------------------------------------------------------------- xml related utility methods
/*
 * loadXml(sUrl) - returns oDomDoc. parses xml from the url into DOM document object.
 * loadXmlString() - returns oDomDoc. parses xml from the contents of the string into DOM document object.
 * loadXsl()
 * transform()
 */
com.ibm.mm.enabler.xslt.ie = {};
com.ibm.mm.enabler.xslt.gecko = {};

com.ibm.mm.enabler.xslt.getXmlHttpRequest = function() {
	var oXml = null;
	if (typeof ActiveXObject != "undefined") {
		oXml = new ActiveXObject("Microsoft.XMLHTTP");
	} else {
		oXml = new XMLHttpRequest();
	}
  return oXml;
};

com.ibm.mm.enabler.xslt.loadXml = function(sUrl) {
	if (typeof ActiveXObject != "undefined") {
		return com.ibm.mm.enabler.xslt.ie.loadXml(sUrl);
	}
	else {
		return com.ibm.mm.enabler.xslt.gecko.loadXml(sUrl);
	}
};

com.ibm.mm.enabler.xslt.loadXmlString = function(sXml) {
	if (typeof ActiveXObject != "undefined") {
		return com.ibm.mm.enabler.xslt.ie.loadXmlString(sXml);
	} else {
		var parser = new DOMParser();
		return com.ibm.mm.enabler.xslt.gecko.loadXmlString(sXml);
	}
};

com.ibm.mm.enabler.xslt.loadXsl = function(sUrl) {
	if (typeof ActiveXObject != "undefined") {
		return com.ibm.mm.enabler.xslt.ie.loadXsl(sUrl);
	} else {
		return com.ibm.mm.enabler.xslt.gecko.loadXsl(sUrl);
	}
};

com.ibm.mm.enabler.xslt.transform = function (xml, xsl, sXslMode, aXslParams, bReturnString)
{
   com.ibm.mm.enabler.debug.entry( "xslt.transform", xml,xsl,sXslMode,aXslParams,bReturnString );
   if (typeof ActiveXObject != "undefined") {
   	return com.ibm.mm.enabler.xslt.ie.transform(xml, xsl, sXslMode, aXslParams, bReturnString);
   } else {
   	return com.ibm.mm.enabler.xslt.gecko.transform(xml, xsl, sXslMode, aXslParams, bReturnString);
   }
};

com.ibm.mm.enabler.xslt.transformAndUpdate = function (/*HTMLElement*/nodeToUpdate, /*XMLDocument*/xml, /*XMLDocument*/xsl, /*String?*/sXslMode, /*Map*/aXslParams) {
	com.ibm.mm.enabler.debug.entry( "xslt.transformAndUpdate",  nodeToUpdate, xml, xsl, sXslMode, aXslParams );
	if ( typeof ActiveXObject != "undefined" ) {
		var results = com.ibm.mm.enabler.xslt.ie.transform(xml, xsl, sXslMode, aXslParams, true );
		//Don't really want to use innerHTML here, but seems to be the only way IE will 
		//take the update.
		com.ibm.mm.enabler.debug.log(  "xslt.transformAndUpdate","XSLT result: " + results );
		nodeToUpdate.innerHTML += results;
	}
	else {
		results = com.ibm.mm.enabler.xslt.gecko.transform(xml,xsl,sXslMode,aXslParams, false);
		com.ibm.mm.enabler.debug.log( "xslt.transformAndUpdate", "XSLT result: " + ( new XMLSerializer() ).serializeToString( results ), "com.ibm.mm.enabler.xslt.transformAndUpdate" );
		
		var toAppend = results.documentElement;
			
		if ( results.documentElement.tagName == "transformiix:result" ) {
			toAppend = results.documentElement.childNodes;
			com.ibm.mm.enabler.dom.copyChildren( results.documentElement, nodeToUpdate, true );
			/*var length = toAppend.length
			
			com.ibm.mm.enabler.debug.log( "xslt.transformAndUpdate", "there are " + toAppend.length + " items to add." );
			
			for ( var c = 0; c < length; c++ ) {
				com.ibm.mm.enabler.debug.log( "xslt.transformAndUpdate", "Appending: " + ( new XMLSerializer() ).serializeToString( toAppend[c] ), "com.ibm.mm.enabler.xslt.transformAndUpdate" );
				com.ibm.mm.enabler.debug.log( "xslt.transformAndUpdate", "toAppend = " + toAppend[c] + "; c=" + c + "; length=" + length );
				nodeToUpdate.appendChild( toAppend[c] );
			}*/
		}
		else {
			com.ibm.mm.enabler.debug.log( "xslt.transformAndUpdate", "Appending2: " + ( new XMLSerializer() ).serializeToString( toAppend ), "com.ibm.mm.enabler.xslt.transformAndUpdate" );
			nodeToUpdate.appendChild( toAppend );
		}
	}	
	com.ibm.mm.enabler.debug.exit(  "xslt.transformAndUpdate" );
};

//---------------------------------------------------------------------- IE xml related utility methods

com.ibm.mm.enabler.xslt.ie.loadXml = function(sUrl) {
	var oXmlDoc = new ActiveXObject("MSXML2.DOMDocument");
	oXmlDoc.async=0;
	oXmlDoc.resolveExternals = 0;
  	if(!oXmlDoc.load(sUrl))
  	{
  		//Callers should catch this and can substitute their own error message
  		throw new Error("Error loading xml file " + sUrl);
  	}
	return oXmlDoc;
};

com.ibm.mm.enabler.xslt.ie.loadXmlString = function(sXml) {
	var oXmlDoc = new ActiveXObject("MSXML2.DOMDocument");
	oXmlDoc.async=0;
	oXmlDoc.resolveExternals = 0;
  	if(!oXmlDoc.loadXML(sXml))
  	{
  	    //Callers should catch this and can substitute their own error message
  		throw new Error("Error loading xml string " + sXml); 
  	}
	return oXmlDoc;
};

com.ibm.mm.enabler.xslt.ie.loadXsl = function(sUrl) {
	//we need to use MSXML2.FreeThreadedDOMDocument interface in order to support 
	//mode and parameters in XSL transformation.
	var oXslDoc = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
	oXslDoc.async=0;
	oXslDoc.resolveExternals = 0;
  	if(!oXslDoc.load(sUrl))
  	{
  		//Callers should catch this and can substitute their own error message
  		throw new Error("Error loading xsl file " + sUrl);
  	}	
	return oXslDoc;
};

com.ibm.mm.enabler.xslt.ie.transform = function(xmlDoc, xsl, sXslMode, aXslParams,bReturnString) {
	var oXml = xmlDoc;
	var oXsl = xsl;

     try {		
		if (!oXsl.documentElement) {
			oXsl = this.loadXsl(xsl);
		}
	 } catch(e) {
		var sMsg = e.message;
		throw new Error(""+sMsg, ""+sMsg);
	 }
	//create the xsl processor and apply the transformation
	var oXslt = new ActiveXObject("Msxml2.XSLTemplate");
	oXslt.stylesheet = oXsl;
	var oXslProc = oXslt.createProcessor();
	oXslProc.input = oXml;
	
	//set paramaters if any
	if(aXslParams) {
		for(var p in aXslParams) {
			oXslProc.addParameter(p, aXslParams[p]);
		}
	}
	if (sXslMode) {
		oXslProc.addParameter("mode", sXslMode);
	}
	
	if (bReturnString) {
		if(!oXslProc.transform()) {
			//Callers should catch this and can substitute their own error message
  			throw new Error("Error transforming xml doc " + oXml); 
  		}
  		return oXslProc.output;
	} else {
		var oHtmlDoc = new ActiveXObject("MSXML2.DOMDocument");
		oHtmlDoc.async = 0;
		oHtmlDoc.validateOnParse = 1;
		oXml.transformNodeToObject(oXsl,oHtmlDoc);
		return oHtmlDoc;	
	}
};

//---------------------------------------------------------------------- GECKO xml related utility methods

com.ibm.mm.enabler.xslt.gecko.loadXml = function(sUrl) {
    //var oXmlResponse = NG.ServerRequest.postRequest(sUrl);
//    if (oXmlResponse) return xmlLoadString(oXmlResponse.responseText);
//    else return null;
};

com.ibm.mm.enabler.xslt.gecko.loadXmlString = function(sXml) {
    var parser = new DOMParser();
    try { oXmlDoc = parser.parseFromString(sXml, "text/xml"); }
    catch (exc) {
	    //Callers should catch this and can substitute their own error message
  		throw new Error("Error loading xml string " + sXml); 
    }
	return oXmlDoc;
};

com.ibm.mm.enabler.xslt.gecko.loadXsl = function(sUrl) {
	//This is done through createDocument because of anchor(#) we have in portal url. 
	//Do not change the code without testing the case.
	var oDomDoc = document.implementation.createDocument('','',null); 
	oDomDoc.async = 0; // this is the important part
	oDomDoc.load(sUrl);
	
	return oDomDoc;
};

com.ibm.mm.enabler.xslt.gecko.transform = function(xmlDoc, xsl, sXslMode, aXslParams,bReturnString) {
	try {
	  var xslDoc = xsl;
      if(!xslDoc.documentElement) 
      {
          xslDoc = this.loadXsl(xsl);
      }        
      var proc = new XSLTProcessor();
      proc.importStylesheet(xslDoc); 
 
      //set parameters if any
      if(aXslParams) {
	  	for(var p in aXslParams)  {
		    proc.setParameter(null, p, aXslParams[p]);
	    }
      }
      if (sXslMode) {
	  	proc.setParameter(null, "mode", sXslMode);
	  }
    
      var resultDoc = proc.transformToDocument(xmlDoc);
      if (!bReturnString) {
      	return resultDoc;
      }
      resultStr = resultDoc.documentElement.childNodes[0].textContent;    
    } 
    catch (exc)
    {
		//Callers should catch this and can substitute their own error message
  		throw new Error("Error transforming xml doc " + exc);
	}
    return resultStr;  
};

/* This method sets the content of a layer within the HTML page
 * to the result of transforming the xml parameter by the xsl
 * parameter. The xml and xsl parameters may be of any form
 * supported by the transformXml() method. The layer parameter
 * may be either a DOM object or the name of a DOM object that
 * can be found using the findObject() method.
 */

com.ibm.mm.enabler.xslt.setLayerContentByXml = function (layer, xml, xsl, xslparam,bReturnString) {
    var result = com.ibm.mm.enabler.xslt.transform(xml,xsl,null,xslparam,bReturnString);
    if (layer.innerHTML) {
		layer.innerHTML = result;
	} else {
		var obj = document.getElementById(layer);
		obj.innerHTML = result;
	}
};


}

if(!dojo._hasResource["com.ibm.mm.iwidget.services.fragmentservice"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.services.fragmentservice"] = true;
dojo.provide("com.ibm.mm.iwidget.services.fragmentservice");



dojo.declare("com.ibm.mm.iwidget.services.IWidgetFragmentServiceImpl",null,  {
/**
This function creates an Item in microformat as defined by iWidget spec.<p/>
If defaultValue is provided and no defaultLanguage is provided, following element will be created.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;a class="mm_Item" href="#{itemName}" &gt;{defaultValue} &lt;/a&gt; </code><br/>
If defaultLanguage is provided, following element will be created.</br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;a class="mm_Item" href="#{itemName}" lang="{defaultLang}"&gt; &lt;/a&gt; </code><br/>
@param{String } itemName name of the item. Must never be NULL.
@param{String } defaultValue  default value of the item. May be NULL.
@param{String } defaultLang  default language of a localized item .May be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type DOMElement
@returns{DOMElement }  DOMElement of the new item. 
*/ 		
	createItem:function(itemName,defaultValue,defaultLang,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var item= document.createElement("a");
		dojo.addClass(item, ns+iwConstants.CSSCLASS_INSTANCE.iwItem);
		dojo.style(item, "visibility", "hidden");
		dojo.style(item,"display", "none");     
	      
		item.setAttribute("href","#"+itemName);
		if (defaultLang) item.setAttribute("lang",defaultLang);
		if (defaultValue && !defaultLang) item.innerHTML = defaultValue;		
		return item;			
	},	
/**
This function creates an ItemSet in microformat as defined by iWidget spec.<p/>
Following element will be created.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;span class="mm_ItemSet"  title="{setName}"&gt;&lt;/span&gt;</code><br/>
@param{String } itemSetName name of the itemset. Must never be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type DOMElement
@returns{DOMElement }  DOMElement of the new itemset. 
*/ 		
    createItemSet:function(itemSetName,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var param = document.createElement("span");
        dojo.addClass(param, ns+iwConstants.CSSCLASS_INSTANCE.iwItemSet);
        param.setAttribute("title",itemSetName);
        dojo.style(param, "visibility", "hidden");
		dojo.style(param,"display", "none");     
        return param;	
	},
	/**
This function creates an  anchor link that points to url to load widget definition.<p/>
Following element will be created.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;a class="mm_Definition" href="{uri}" /&gt;&lt;/code&gt;<br/>
@param{String } widgetDefUrl  url to load widget definition xml. Must never be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type DOMElement
@returns{DOMElement }  DOMElement of the new anchor link. 
*/ 	
    createWidgetDefRef:function(widgetDefUrl,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var aTag=document.createElement("a");
		dojo.addClass(aTag,ns+iwConstants.CSSCLASS_INSTANCE.iwDefinition);
		aTag.setAttribute("href",widgetDefUrl);
		dojo.style(aTag, "visibility", "hidden");
		dojo.style(aTag,"display", "none");     
	    return aTag;
	},
	/**
This function returns the required itemset with the given iwidget id.<br/>
@param{String } iwidgetId  iwidget id. Must never be NULL.
@param{String } name  name of the required ItemSet. Must never be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type DOMElement
@returns{DOMElement }  DOMElement of the itemset. 
*/ 	
	getItemSet:function(iwidgetId,name,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var rc = null;
		var widgetSpan = dojo.byId(iwidgetId);
		var itemsets = dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwItemSet,widgetSpan);
		for (var i=0; i<itemsets.length; i++){
			var anItemSet = itemsets[i];
			var title = anItemSet.getAttribute("title");
			if (name == title) { rc = anItemSet; break; }
			
		}
		return rc;
	},
/**
This function returns the required item with the given parent.<br/>
item element is a nested element within itemset element.<br/>
@param{DOMElement } parent  parent element. Must never be NULL.
@param{String } name  name of the required item. Must never be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type DOMElement
@returns{DOMElement }  DOMElement of the item. 
*/ 		
	getItem:function(parent,name,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var rc = null;
		var items = dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwItem,parent);
		for (var i=0;i<items.length; i++){
			var anItem = items[i];
			var title = this.getKeyFromHref(anItem);
			if (title != null && title == name ) { rc = anItem; break;}
		}	
		return rc;
	},
	/**
This function returns the all the items within the given parent itemset.<br/>
item element is a nested element within itemset element.<br/>
@param{DOMElement } parent  parent element. Must never be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type DOMElement[]
@returns{DOMElement []}   list of DOMElements. 
*/ 		
	getItems:function(parent,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var items = dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwItem,parent);
		if (typeof items == "undefined" || items == null || items.length == 0) items = null;
		return items;
	},	
/**
This function returns the reference to the widget definition.<br/>
Widget definition reference is defined within anchor link.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;a class="mm_Definition" href="{uri}" /&gt;&lt;/code&gt;<br/>
@param{String } iwidgetId  id of the iWidget. Must never be NULL.
@param{String } prefix  optional. namespace of the class, default is "mm_". 
@type String
@returns{ String }   uri to download the iWidget definition. 
*/ 		
    getWidgetDefRef:function(iwidgetId,ns){
		if (typeof ns == "undefined" || ns == null) ns = "mm_";
		var rc = null;
		var widgetSpan = dojo.byId(iwidgetId);
		var def = dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwDefinition, widgetSpan)[0];
		var ref =  def.getAttribute("href");
		if (typeof ref != "undefined" && ref != null) rc = ref;
		return rc;
	},
	/**
This function provides a convenience function to get  the real value defined with an "href" attribute.<br/>
Per iWidget spec, several items are defined by using anchor link. <br/>
For example,  item element or sourceEvent within a ReceivedEvent.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;a class="mm_Item" href="#{itemName}" &gt;{value} &lt;/a&gt; </code><br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>&lt;a class="mm_SourceEvent" href="#{sourceWidgetID}"&gt;{sourceEventName} &lt;/a &gt;</code><br/>
This function will return itemname if it's an item node.<br/>
This function will return id of source iWidget if it's an sourceevent node within a ReceivedEvent.<br/>
@param{DOMNode } node  DOMNode which is an item. Must never be NULL.
@type String
@returns{ String }   . 
*/ 
	getKeyFromHref:function(node){
		var hrefValue = node.getAttribute("href");
		if(hrefValue==null) return null;
		var pos=hrefValue.indexOf("#")
		if(pos<0) return null;
		return hrefValue.substring(pos + 1);
	}  
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.widgetImpl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widgetImpl"] = true;
dojo.provide("com.ibm.mm.iwidget.widgetImpl");
//keep this file for backwardcompatibility support, remove after v2





dojo.declare("com.ibm.mm.iwidget.iWidgetWrapperImpl",null,{
	 constructor:function(id){
    	// summary: iWidgetWrapper; interface defines methods that administrative iWidget can retrieve information of another iWidget
	    // like metadata,events,wires,payload
	    this.id = id;
	},
	getiWidgetMetadata:function(){
	//summary:This method returns an object that contains iDescriptor items as defined by iWidget spec
    //in v1.1, it simply contains default title and icon
		return new com.ibm.mm.iwidget.iWidgetMetadataImpl(this.id);
	},
	getInstanceAttributes:function(){
		var widget = iWidgetContainer.getWidgetById(this.id);
	     if (typeof widget == "undefined" || widget === null) {
		   	return null;
		 }

         widget.getIWidgetInstance().loadItemSets(); 
	 	var instanceAttributes = widget.getIWidgetInstance()._getAttributes();
	 	var attItemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl();
        for (var j in instanceAttributes) {
            var itemName = j;
            var itemValue = instanceAttributes[itemName]["defaultValue"];
            attItemSet.setItemValue(itemName,itemValue,false);
        }
        return attItemSet;		
	}	
});

//in future, iWidgetMetadataImpl should implement com.ibm.mm.enabler.Deferred interface to support asynchronous action
//for example, need to get title from fragment feed
dojo.declare("com.ibm.mm.iwidget.iWidgetMetadataImpl",null,{
    constructor:function(id){
        // summary: iWidgetMetadata; interface defines 
		this._id = id;
		this._items = {}; //each item is saved as a json object {isDirty:false;detail:{itemName:"title",defaultValue:"defaultValue",defaultLang:"lang",localizedValue:[],isDirty:false}}
		this._debug = com.ibm.mm.enabler.debug;
	},
	CONSTANTS:{"title":"title","icon":"icon"},
	getItemValue:function(itemName, locale){
		if (!locale) {
			locale = "en";
		}
		
		if (typeof itemName == "undefined" || itemName === null) return null;
		
		if (!this.CONSTANTS[itemName]) return null;
		
		var internalWrapper = this._getInternalIWidgetWrapper();
		if (internalWrapper === null) return null;
		
		var data = this._items[itemName][locale];
		if (typeof data == "undefined" || data === null) 
		{		if (! this._loadData(itemName, locale)) return null;
			data = this._items[itemName][locale];
		}	
		if (data["detail"] != "undefined" && data["detail"] != null) {
			return data.detail;
		}	
		else return null;
	},
	_setItemValue:function(itemName, value){
        if (typeof itemName == "undefined" || itemName == null || typeof value=="undefined" || value === null) return null;
        if (!this.CONSTANTS[itemName]) return null;
        
        var instanceData = this._getInternalIWidgetWrapper().getIWidgetInstance().getIDescriptorItems();
        if (!instanceData)
            return;
            
        instanceData.setItemValue(itemName, value);
	},
	setItemValue:function(itemName, value, locale){
        if (typeof itemName == "undefined" || itemName == null || typeof value=="undefined" || value === null) return null;
        if (!this.CONSTANTS[itemName]) return null;
        
        var instanceData = this._getInternalIWidgetWrapper().getIWidgetInstance().getIDescriptorItems();
        if (!instanceData)
            return;
            
        instanceData.setItemValue(itemName, value, locale);
	},

	save:function(){
        iWidgetContainer.commit().start();
	},
	_getInternalIWidgetWrapper:function(){
		if (typeof (this._internalWidgetWrapper) == "undefined" || this._internalWidgetWrapper === null) 
		{	
		 var widget = iWidgetContainer.getWidgetById(this._id);
	     if (typeof widget == "undefined" || widget === null) {
		   	return null;
		 }
		 this._internalWidgetWrapper = widget;
		} 
		return this._internalWidgetWrapper;
	},
	_loadData:function(itemName,locale){
		if (!locale) {
			locale = "en";
		}
		
		var rc = false;
		var anItem = {};
		var instanceData = this._getInternalIWidgetWrapper().getIWidgetInstance().getIDescriptorItems();

		if (instanceData && instanceData.getItemValue(itemName, locale)){
			var anItemStr = dojo.toJson(instanceData.getItemValue(itemName, locale));
			anItem.isDirty = true;
			anItem.detail = dojo.fromJson(anItemStr);
			rc = true;
		}
		else{
			anItem.detail = {};
			anItem.detail.itemName = itemName;
			anItem.isDirty = false;
		}
		this._items[itemName][locale] = anItem; // empty item is data is not available
		return rc;
	},
	_updateMarkup:function(details){
        // ************
        // This method is not used anymore, because save is done by widget container
        // ************
		var itemName = details.itemName;
		//var defaultLang = details.defaultLang;
		var defaultValue = details.defaultValue;
		//var localizedValue = details.localizedValue;
		
		var fragmentService = com.ibm.mashups.services.ServiceManager.getService("iwidgetFragmentService");
		var iDescriptor = fragmentService.getItemSet(this._id,iwConstants.IDESCRIPTOR);
		if (iDescriptor == null){
			var node = fragmentService.createItemSet(iwConstants.IDESCRIPTOR);
			var widgetNode = dojo.byId(this._id);
			widgetNode.insertBefore(node,widgetNode.firstChild.nextSibling);
			iDescriptor = fragmentService.getItemSet(this._id,iwConstants.IDESCRIPTOR);			
		}	
		var anItem = fragmentService.getItem(iDescriptor,itemName);
		if (anItem == null){
			var node = fragmentService.createItem(itemName,defaultValue);
			iDescriptor.appendChild(node);
		}else{
			anItem.innerHTML = defaultValue;
		}
		//refresh the cache when markup is updated
		this._getInternalIWidgetWrapper().getIWidgetInstance().loadItemSets();
		
	}	
});

dojo.declare( "com.ibm.mm.iwidget.WidgetStub",null,
{
              constructor:function(aWidget) {
			  // summary: WidgetStub; interface defines methods that administrative iWidget can use to get information from another iWidget
				this._wrapper = aWidget;
                this.id = aWidget.id;
                //this.wires = aWidget.getWires();
                
                this.publishedEvents = aWidget._getPublishedEvents();
                this.handledEvents = aWidget._getHandledEvents();
                this.payloadDefs = aWidget.widgetDef.getPayloadDefs();
                this.supportedModes = aWidget.widgetDef.getSupportedModes();
     		  },
              getPublishedEventsNames:function(){
			  	 //summary:This method returns an array names of iwidget published events 
       
                   if (!this.publishedEvents) return null;
                   var eventNames = [];
                   var aEventName;
                   for ( aEventName in this.publishedEvents) {
                        eventNames.push(aEventName);
                   }
                   if (eventNames.length == 0) return null;
                   return eventNames; /*Object @return null or an array of published events names*/
              },
              getHandledEventsNames:function(){
			  	 //summary:This method returns an array names of iwidget handled events 
       
                  if (!this.handledEvents) return null;
                  var eventNames = [];
                  var aEventName;
                  for ( aEventName in this.handledEvents) {
                       eventNames.push(aEventName);
                  } 
                  if (eventNames.length == 0) return null;
                  return eventNames;/*Object @return null or an array of handled events names*/
              },
              getPublishedEvent:function(/*String*/eventName){
			  	 //summary:This method returns an eventdescription  of the specified published event 
                   if (!this.publishedEvents) return null;
                   return [this.publishedEvents[eventName]];/*Object @return null or an eventdescription of the specified published event*/

              },
              getHandledEvent:function(/*String*/eventName){
			  	//summary:This method returns an eventdescription  of the specified handled event 
                    if (!this.handledEvents) return null;
                   return [this.handledEvents[eventName]];/*Object @return null or an eventdescription of the specified handled event*/
		      },
              getPayloadDefs:function(){
			  	//summary:This method returns an array of payloaddef that's defined in this iwidget
                   return this.payloadDefs;
              },
              getPayloadDef:function(name){
			  	//summary:This method returns null or the specified payloadDef                
                  var payloadDef = this.payloadDefs[name];
                  if (typeof payloadDef == "undefined") return null;
                  return payloadDef;          
              },
              getPayloadDefNames:function(){
			  	//summary:This method returns null or an array of payloaddef names
                  var arr = [];
                  var a;
                  for (a in this.payloadDefs){
                      arr.push(a);                      
                  }
                  if (arr.length == 0) return null;
                  return arr;
              },
              getWires:function(){
			  	//summary:This method returns null or an array of wires that's defined in this iWidget
				//		  each array item is an json object and is in following format: 
                //        {SourceWidget:sth,SourceEvent:sth,TargetEvent:sth}
                 return this._wrapper.getWires();
              },
              getSupportedModes:function(){
			  	//summary:This method returns null or an array of supportedmodes			
                  return this.supportedModes;
              }
});


}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.shared"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.shared"] = true;
dojo.provide("com.ibm.mashups.enabler.model.shared");

// general
dojo.provide("com.ibm.mashups.enabler.Identifiable");
dojo.provide("com.ibm.mashups.enabler.Localized");
dojo.provide("com.ibm.mashups.enabler.MetaData");
dojo.provide("com.ibm.mashups.enabler.Locator");
dojo.provide("com.ibm.mashups.enabler.Iterator");
dojo.provide("com.ibm.mashups.enabler.Logout");
dojo.provide("com.ibm.mashups.enabler.ResourceLocator");

// strategies
dojo.provide("com.ibm.mashups.enabler.strategy.Strategy");
dojo.provide("com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.strategy.TreeLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy");
dojo.provide("com.ibm.mashups.enabler.strategy.UserLoadAheadStrategy");

// models
dojo.provide("com.ibm.mashups.enabler.model.Model");
dojo.provide("com.ibm.mashups.enabler.model.ListModel");
dojo.provide("com.ibm.mashups.enabler.model.TreeModel");

// Form support
dojo.provide("com.ibm.mashups.enabler.SubmittableFormProvider");
dojo.provide("com.ibm.mashups.enabler.SubmittableForm");

/**
 * Extended iterator interface that allows iterating over elements 
 * in a sequentiell order with the possibility to set the starting 
 * point of the iteration as well as the size of the list.
 * 
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.Iterator", null, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns <tt>true</tt> if the iteration has more elements.
     * @return  {Boolean} <tt>true</tt> if the iterator has more elements, 
     *          otherwise <tt>false</tt>.
     */
    hasNext: function () {
        return new Boolean(); 
    },

    /**
     * Returns the next element in the iteration.  Calling this method
     * repeatedly until the hasNext() method returns false will return 
     * each element in the underlying collection exactly once.
     * The cursor position is increased by one . if no element is available 
     * at the specified position, <code>null</code> is returned and the 
     * position is not changed
     * 
     * @returns  {Object} the next element in the iteration
     */
    next: function () {
        return {};
    },

    /**
     * Returns the number of elements in this iterator.
     * 
     * @type    Deferred
     * @return a deferred object used to start this operation. The 
     *          return value when executed through the deferred object 
     *          is the number of elements in this iterator
     */
    size: function () {
        return new Deferred();
    },

    /**
     * Sets the zero-based position of the cursor, i.e the last 
     * element is addressed through size()-1.
     * A position which is out of the bounds of the current iteration 
     * is ignored and in this case the position is set to the nearest 
     * possible value within valid bounds.
     * 
     * @param {int} position    position of the cursor. Defaults to zero
     * @type void
     */
    setCursorPosition: function (position) {
    },

    /**
     * Returns the zero-based position of the cursor, i.e. zero for the first element
     * 
     * @return {int} the position of the cursor
     */
    getCursorPosition: function () {
        return null;
    }
});

/**
 * Base interface for all classes which handle actions asynchronously.
 * An action may involve one or more operations, for example creating or
 * updating a model resource, which in turn may involve one or more HTTP
 * requests. The Deferred interface allows to trigger a callback after
 * the entire action, i.e. all involved HTTP requests, is finished. Thus,
 * the Deferred interface may be used to get the overall result of an action.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.Deferred", null, {
    /**
     * @private
     */
    constructor:function () {
    },

    /**
     * Sets the handler of the deferred action. It is called when the entire
     * action has finished.
     * @param {Object} callback the callback funtion in the format of <code>Function(Object resource, int statusCode, Object[] params)</code>. 
     * Must not be <code>null</code><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<b>Callbackparameters</b><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>resource</code> - resource object or id string
     * of the related resource.
     * May be <code>null</code> in case the action does not relate
     * to a particular resource. In case multiple resources are involved in the
     * action, the DeferredOperation interface may be used to obtain the resource
     * objects or string <code>id</code>s of those resources.<br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>statusCode</code> - the overall HTTP status
     * code of the action (the highest status code of the involved operations).<br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>params</code> - the parameters
     * passed into the callback
     * @param {Object[]} parameters optional array of parameters to be
     * passed on to the callback function. May be <code>null</code>
     * @type void
     */
    setFinishedCallback: function(callback, parameters) {
    },

    /**
     * Executes the deferred action and invokes the callback functions set
     * with the deferred object.
     * @param {Boolean} sync indicates if the deferred action is executed 
     * synchronously or asynchronously. Optional, defaults to true.
     * @return {Object} resource if called asynchronously, the return value is 
     * <code>undefined</code>, otherwise a resource object or id string of the 
     * related resource is returned.<br> In order to obtain information on
     * the resource as well as on the status code of the operation, you
     * must use the callback functions of the deferred object.     
     */
    start: function(sync) {
        return {};
    }
});

/**
 * In addition to the Deferred interface, which allows to trigger callbacks after the
 * entire action  has finished, the DeferredOperation interface allows to trigger a
 * callback for each involved operation.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.DeferredOperation", com.ibm.mashups.enabler.Deferred, {

    OPERATION_GET: "GET",
    OPERATION_CREATE: "CREATE",
    OPERATION_MODIFY: "MODIFY",
    OPERATION_DELETE: "DELETE",

    /**
     * @private
     */
    constructor:function () {
    },

    /**
     * Sets the handler of the deferred action. The handler is called for each
     * operation the action involves.
     * @param {Object} callback the callback funtion in the format of <code>Function(Object node, string mode, int statusCode, Object[] params)</code>. Must not be <code>null</code><br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<b>Callbackparameters</b><br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>node</code> - resource object or string id of the
     * related resource, depending on the operation. For example, when a resource is created, the
     * resource itself is returned. In case of a delete operation, the id is returned
     * instead.<br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>mode</code> - the mode of the operation.
     * May be one of <code>OPERATION_GET</code>, <code>OPERATION_CREATE</code>,
     * <code>OPERATION_MODIFY</code>, or <code>OPERATION_DELETE</code>.<br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>statusCode</code> - the overall HTTP status code
     * of the operation.<br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>params</code> - the parameters
     * passed into the callback
     * @param {Object[]} parameters optional array of parameters to be
     * passed on to the callback function. May be <code>null</code>
     * @type void
     */
    setOperationCallback: function(callback, parameters) {
    }
});

/**
 * The DeferredIterator can be used to iterate over a list of objects 
 * in an asynchronous fashion. The callback handler is called as 
 * soon as the next object has been loaded.
 * The start method is only used for the asynchronous aspect of 
 * the deferred iterator. For the synchronous aspect the methods
 * such as hasNext() can be called directly.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.DeferredIterator", [com.ibm.mashups.enabler.Deferred, com.ibm.mashups.enabler.Iterator], {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Sets the handler of the deferred action. It is called when the
     * next object in the list has been loaded and is ready to be processed.
     * @param {Object} callback the callback funtion in the format of <code>Function(object nextElement, Object[] params)</code>. Must not be <code>null</code><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<b>Callbackparameters</b><br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>nextElement</code> - the next 
     * object in the list<br/>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>params</code> - the parameters 
     * passed into the addForEachCallback
     * @param {Object[]} parameters optional array of parameters to be 
     * passed on to the callback function
     * @returns {Boolean} true if the loop should continue and call this method 
     * again for the next object (if there is one) or<br>false when the 
     * loop should be interrupted
     */
    setForEachCallback: function(callback, parameters) {
        return new Boolean();
    }
});

/**
 * Interface for any resource in the system that can be identified
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.Identifiable", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Returns the ID of the resource that implements the <code>Identifiable</code> interface.
     * @return {String} the identifier; never <code>null</code>
     */
    getID: function() {
        return String(); 
    }
});

/**
 * Interface for resources in the system that can be transformed
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.Transformable", null, {
  /**
      * @private
      */
    constructor:function () {
    },
	
    /**
     * Returns the xml representation of the resource. It may be modified,
     * e.g. with an xsl transformation.
     * WARNING: Please note that you must change the xml representation
     * of the resource in a compatible way only, since the Enabler API 
     * operates on this representation. Otherwise the Enabler API may 
     * function incorrectly or break.  
     * @return {Object} the xml representation; never <code>null</code>
     */
    getXml: function() {
        return new Object(); 
    }
});

/**
 * Read-Only interface providing methods to obtain title and description of a
 * resource. Please note that title or description are only returned if they
 * are available in the requested locale. No fallback for locales is performed.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.Localized", null, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns an array containing the locales that are supported by this
     * object. The presence of a locale in this list does not mean that a title
     * <b>and</b> description is available, but rather that either one or both are available in that locale.
     * @return {Array} a list of locales defined for this object, returns an 
     * empty array if no locales are supported. Can never be <code>null</code>.
     */
    getLocales: function() {
        return [];
    },

    /**
     * Returns the title of this object in the given locale.
     * @param {String} locale the locale for which to retrieve the title, 
     * must not be <code>null</code>.
     * @return {String} the title of this node in the given locale. If a title is not
     * available in the given locale, this method will return <code>null</code>. 
     * It is up to the invoker of the method to implement an appropriate fallback mechanism.
     */
    getTitle: function(locale) {
        return new String(); 
    },


    /**
     * Returns the description of this object in the given locale.
     * @param {String} locale   the locale for which to retrieve the 
     * description, must not be <code>null</code>.
     * @return {String} the description of this node in the given locale. If a 
     * description is not available in the given locale, this method 
     * will return <code>null</code>. It is up to the invoker of the 
     * method to implement an appropriate fallback mechanism.
     */
    getDescription: function(locale) {
        return new String(); 
    }
});

/**
 * Modifiable interface providing methods to set title and description of a
 * resource.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ModifiableLocalized", com.ibm.mashups.enabler.Localized, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Sets the title for the given locale.
     * @param {String} title    title to set; must not be <code>null</code>
     * @param {String} locale   locale to set the title for; must not be <code>null</code>
     * @return {String} the former title; if none existed, <code>null</code> is returned
     */
    setTitle: function(title, locale) {
        return new String(); 
    },
	
    /**
     * Confirms whether setting the title for the given locale is possible.
     * @param {String} title    title to set; must not be <code>null</code>
     * @param {String} locale   locale to set the title for; must not be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetTitle: function(title, locale) {
        return new Boolean(); 
    },

    /**
     * Sets the description for the given locale.
     * @param {String} desc     description to set; must not be <code>null</code>
     * @param {String} locale   locale to set the description for; must not be <code>null</code>
     * @return {String} the former description; if none existed, <code>null</code> is returned
     */
    setDescription: function(desc, locale) {
        return new String(); 
    },
    /**
     * Confirms whether setting the description for the given locale is possible.
     * @param {String} desc     description to set; must not be <code>null</code>
     * @param {String} locale   locale to set the description for; must not be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetDescription: function(desc, locale) {
        return new Boolean(); 
    }
});

/**
 * A read-only interface describing meta data associated with a resource.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.MetaData", null, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns a list of the names of meta data entries.
     * @return {String[]} an array containing the names; never <code>null</code> 
     */
    getMetaDataNames: function() {
        return []; 
    },

    /**
     * Returns the value of a meta data entry for the given parameter name.
     * @param {String} name the meta data name; must not be <code>null</null>
     * @return {String} the value of the meta data entry for the given name, or <code>null</code> if none exists
     */
    getMetaData: function(name) {
        return new String();
    }
});

/**
 * A modifiable interface allowing to set meta data associated with a resource.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ModifiableMetaData", com.ibm.mashups.enabler.MetaData, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Sets the value for the meta data identified by the specified name.
     * @param {String} name     name of meta data to set the value for; must not be <code>null</null>
     * @param {String} value    meta data value to set; must not be <code>null</null>
     * @return {String} the former value for the name; if none existed, <code>null</code> is returned
     */
    setMetaData: function(name, value) {
        return new String(); 
    },
    /**
     * Confirms whether setting the meta data is possible.
     * @param {String} name     name of meta data to set the value for; must not be <code>null</null>
     * @param {String} value    meta data value to set; must not be <code>null</null>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetMetaData: function(name, value) {
        return new Boolean(); 
    },

    /**
     * Removes the meta data identified with the specified name.
     * @param{String} name  name of meta data to remove; must not be <code>null</null>
     * @return {String} the former value for the name; if none existed, <code>null</code> is returned
     */
    removeMetaData: function(name) {
        return new String();
    },
    /**
     * Confirms whether removing the meta data is possible.
     * @param{String} name  name of meta data to remove; must not be <code>null</null>
     * @return {Boolean} true if the name can be removed, otherwise false.
     */
    confirmRemoveMetaData: function(name) {
        return new Boolean(); 
    }
});

/**
 * This interface defines search methods that allow locating resources in a model.
 * A resource is identified by its ID (mandatory). This interface is the base for all locators;
 * other locators allow a more specific search in the context they are offered in, 
 * e.g. a search for a node with certain properties in a model.<br>
 * A <code>Locator</code> is usually obtained using the <code>getLocator()</code> method .
 * <pre>
 * var treeModel model = ...;
 * var locator = model.getLocator();
 * var node = locator.find(...);
 * </pre>
 * This locator returns an {@code Object} which is part of some model.
 * What exact kind of object is returned depends on the locator.
 * Please refer to individual JavaScriptDoc for the locator used. 
 * The result object can be expected to be an element of the model
 * the locator is used on unless specified otherwise.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.Locator", null,     {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns an element of a model with the given ID.
     * @param {String} id   the id or uri of the object to find 
     * (without any scope). Must not be <code>null</code>.
     * @return {Deferred} a deferred object used to start this operation. 
     * The return value when executed through the deferred object is
     * the element with the given ID or <code>null</code> if the element cannot be found.
     */
    find: function (id) {
        return new Deferred();
    }
});

/**
 * Base class for all models
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.Model", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    
    /**
     * Sets the specified array of strategies or in case none has been 
     * defined falls back to the default strategy
     * @param {Strategy[]}  strategy    array of strategies to set;
     *                                  may be <code>null</code>
     * @type void
     */
    setStrategy: function (strategy) {
    },
	
	/**
	 * Returns the array of strategies which are in use
	 * @return {Strategy[]} array of strategies in use, <code>null</code> if no
	 *                      strategies are in use
	 */
	getStrategies: function () {
		return [];
	},
	
	/**
	 * Adds a strategy to the strategies array
	 * @param {Strategy} strategy strategy to add; must not be <code>null</code>
	 * @return {int} index where the strategy was added in the strategies 
	 *               array
	 */
	addStrategy: function (strategy) {
	},
	
	/**
	 * Removes the strategy at the given index
	 * @param {int} index index of the strategy to remove; must not be
	 *              <code>null</code>
	 * @type void
	 */
	removeStrategy: function (index) {
	}
});

/**
 * A read-only model representing a list. acting as a base class for all concrete list models
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ListModel", [com.ibm.mashups.enabler.model.Model, com.ibm.mashups.enabler.Locator], {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns an interator over elements of the list.
     * 
     * @type    DeferredIterator
     * @return  a deferred iterator
     */
    iterator: function () {
        return new Iterator(); 
    }
});

/**
 * A modifiable model representing a list. acting as a base class for all concrete list models
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ListModelController", com.ibm.mashups.enabler.ListModel, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * creates a new model object. The created node can be inserted 
     * into the model using an appropriate <code>insert</code> method defined 
     * on a subinterface of this interface. The node will not appear in the model 
     * unless it is inserted.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted 
     * names are defined in the appropriate subinterfaces
     * @type Object
     * @return the created node
     */
    create: function (context) {
        return new Object();
    },
    /**
     * Confirms whether creating the node is possible.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted 
     * names are defined in the appropriate subinterfaces
     * @return {Boolean} true if the node can be created, otherwise false.
     */
    confirmCreate: function(context) {
        return new Boolean(); 
    },

    /**
     * Inserts the specified node into the list model at the specified 
     * position; the node must be created with the create method of the 
     * concrete ListModel
     * 
     * @param {Object} node     node or node uri (without any scope) to
     *                          insert into the list model. Must not be 
     *                          <code>null</code>
     * @param {Object} nextNode node object or node uri (without any scope) of 
     *                          the successor node before which the node 
     *                          is to be inserted;
     *                          if <code>null</code> is specified, the 
     *                          node is appended at the end of the existing nodes
    * @type void
     */
    insert: function (node, nextNode) {
    },
    /**
     * Confirms whether inserting the node is possible.
     * @param {Object} node     node or node uri (without any scope) to
     *                          insert into the list model. Must not be 
     *                          <code>null</code>
     * @param {Object} nextNode node object or node uri (without any scope) of 
     *                          the successor node before which the node 
     *                          is to be inserted;
     *                          if <code>null</code> is specified, the 
     *                          node is appended at the end of the existing nodes
     * @return {Boolean} true if the node can be inserted, otherwise false.
     */
    confirmInsert: function(node, nextNode) {
        return new Boolean(); 
    },

    /**
     * Removes the specified node from the list model
     * 
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
    * @type void
     */
    remove: function (node) {
    },
    /**
     * Confirms whether removing the node is possible.
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
     * @return {Boolean} true if the node can be removed, otherwise false.
     */
    confirmRemove: function(node) {
        return new Boolean(); 
    }
});

/**
 * This interface provides a generic tree model acting as a base class 
 * for all concrete tree models
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.TreeModel", [com.ibm.mashups.enabler.model.Model, com.ibm.mashups.enabler.Locator], {
  /**
      * @private
      */
     constructor:function () {
    },

    /**
     * Returns the root node of the model; may return <code>null</code> 
     * if the concrete tree model supports for empty models
     * 
     * @type    Deferred
     * @return  a deferred object used to start this operation. The 
     *          return value when executed through the deferred object 
     *          is the root object of the tree model
     */
    getRoot: function () {
        return new Deferred();
    },

    /**
     * Returns whether or not the given node has children. Please pay 
     * attention to the documentation of the return value; it is not 
     * guaranteed that children are present if the method returns 
     * <code>true</code> - the iterator might be empty.
     * 
     * @param   {Object} node   node object or node uri (without any scope)
     *                          for which to check if it has children. Must 
     *                          not be <code>null</code>.
     * @type    Boolean
     * @return  <tt>true</tt> if the specified node has children, <tt>false</tt> otherwise  
     */
    hasChildren: function (node) {
        return new Boolean();
    },

    /**
     * Returns an iterator over the child elements for the given node.
     * 
     * @param {Object} node node object or node uri (without any scope) 
     *                      for which to return its children. Must not 
     *                      be <code>null</code>.
     * @type    com.ibm.mashups.enabler.DeferredIterator
     * @return  deferred iterator for the children of the given node. 
     *          Never <code>null</code>
     */
    getChildren: function (node) {
        return new com.ibm.mashups.enabler.DeferredIterator(); 
    },

    /**
     * Returns the parent of a given node.
     * @param {Object} node node object or node uri (without any scope) 
     *                      for which to return its parent. Must not 
     *                      be <code>null</code>.
     * @type    Deferred
     * @return  a deferred object used to start this operation. The 
     *          return value when executed through the deferred object 
     *          is the parent of the given node, or <code>null</code> 
     *          if the node has no parent
     */
    getParent: function (node) {
        return new Deferred();
    }
});

/**
 * This modifiable interface provides a generic tree model acting as a base class 
 * for all concrete tree models
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.TreeModelController", com.ibm.mashups.enabler.TreeModel, {
  /**
      * @private
      */
     constructor:function () {
    },

    /**
     * creates a new model object. The created node can be inserted 
     * into the model using an appropriate <code>insert</code> method defined 
     * on a subinterface of this interface. The node will not appear in the model 
     * unless it is inserted.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted 
     * names are defined in the appropriate subinterfaces
     * @type Object
     * @return the created node
     */
    create: function (context) {
        return new Object();
    },
    /**
     * Confirms whether creating the node is possible.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted 
     * names are defined in the appropriate subinterfaces
     * @return {Boolean} true if the node can be created, otherwise false.
     */
    confirmCreate: function(context) {
        return new Boolean(); 
    },
    
    /**
     * Inserts a node into the tree model at the specified location; 
     * the node must either be created with the create method of the 
     * concrete tree model before, or must exist in the tree model; 
     * in this case the existing node is moved to the specified location
     * 
     * @param {Object} node         node to insert or move. Must not be 
     *                              <code>null</code>.
     * @param {Object} parentNode   node object or node uri (without any 
     *                              scope) of the parent node. The given 
     *                              node is inserted/moved underneath the 
     *                              parent node; must not be <code>null</code>.
     * @param {Object} nextNode     node object or node uri (without any 
     *                              scope) of the successor node before 
     *                              which the node is to be inserted; 
     *                              if <code>null</code> is specified, 
     *                              the node is appended at the end of 
     *                              the existing nodes
     * @type void
     */
    insert: function (node, parentNode, nextNode) {
    },
    /**
     * Confirms whether inserting the node is possible.
     * @param {Object} node         node to insert or move. Must not be 
     *                              <code>null</code>.
     * @param {Object} parentNode   node object or node uri (without any 
     *                              scope) of the parent node. The given 
     *                              node is inserted/moved underneath the 
     *                              parent node; must not be <code>null</code>.
     * @param {Object} nextNode     node object or node uri (without any 
     *                              scope) of the successor node before 
     *                              which the node is to be inserted; 
     *                              if <code>null</code> is specified, 
     *                              the node is appended at the end of 
     *                              the existing nodes
     * @return {Boolean} true if the node can be inserted, otherwise false.
     */
    confirmInsert: function(node, parentNode, nextNode) {
        return new Boolean(); 
    },

    /**
     * Deletes a node from the model. All its children are deleted as well.
     * 
     * @param {Object} node node object or node uri (without any scope) 
     *                      to delete from the model. Must not be <code>null</code>.
     * @type void
     */
    remove: function (node) {
    },
    /**
     * Confirms whether removing the node is possible.
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
     * @return {Boolean} true if the node can be removed, otherwise false.
     */
    confirmRemove: function(node) {
        return new Boolean(); 
    }
});

/**
 * Interface that acts as base interface for all strategies. It can be set on 
 * models to define the behavior of the model, i.e. how resources are loaded 
 * from the server.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.strategy.Strategy", null, {
  /**
      * @private
      */
    constructor:function () {
    }

});

/**
 * Interface that defines a load ahead strategy for loading elements of a list.
 * When applied to a list model it will load the given number of elements at a 
 * time from the backend.<br>
 * Example; A ListLoadAheadStrategy with interval = 10 will cause the model to 
 * load new data from the backend with every 10th call of the method next() when 
 * using the iterator of the list.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.strategy.ListLoadAheadStrategy", com.ibm.mashups.enabler.strategy.Strategy,    {
   /**
    * @param {int} interval number of elements to be loaded ahead from the 
    * backend. must not be <code>null</code> or less than one.
    */
   constructor:function (interval) {
        this.interval = interval;
   },

   /**
   * Returns the number of elements to load ahead 
   * @type int 
   * @return number of elements to load ahead
   */
    getInterval: function() {
        return this.interval;
    }
});

/**
 * Interface that defines a load ahead strategy for loading elements wihin a 
 * tree hierarchy. When applied to a tree model it will load the given number 
 * of elements at a time from the backend.<br>
 * Example; A TreeLoadAheadStrategy with parentLevel = 2 and childrenLevel = 2 will<br>
 * <ul><li>load the parent as well as all the parents of the parent when calling 
 * getParent on a given node and</li>
 * <li>load the children as well as all the children of the child when calling 
 * getChildren on a given node.</li></ul>
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.strategy.TreeLoadAheadStrategy", com.ibm.mashups.enabler.strategy.Strategy,     {
    /**
     * @param {int} parentLevel number of parent levels to be loaded ahead from 
     * the backend. must not be <code>null</code> or less than one.
     * @param {int} childrenLevel number of children levels to be loaded ahead 
     * from the backend. must not be <code>null</code> or less than one.
     */
   constructor:function (parentLevel, childrenLevel) {
        this.parentLevel = parentLevel;
        this.childrenLevel = childrenLevel;
    },

   /**
   * Returns the number of children levels in the hierarchy to load ahead 
   * @type int 
   * @return number of children levels to load ahead
   */
    getChildrenLevel: function() {
        return this.childrenLevel; 
    },

   /**
   * Returns the number of parent levels in the hierarchy to load ahead 
   * @type int 
   * @return number of parent levels to load ahead
   */
    getParentLevel: function() {
        return this.parentLevel; 
    }
});

/**
 * Interface that defines a load ahead mulipart strategy for loading artifacts 
 * of a navigation node. When applied to a navigation model, the layout model,
 * theme, and current user may be preloaded via a multipart request
 * if multipart is supported by the server.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy", com.ibm.mashups.enabler.strategy.Strategy,    {
    /**
     * @param {boolean} loadAheadLayoutModel if the layout model should be 
     * preloaded when a navigation node is load. Must not be <code>null</code>.
     * @param {boolean} loadAheadTheme if the theme should be 
     * preloaded when a navigation node is load. Must not be <code>null</code>.
     */
    constructor:function (loadAheadLayoutModel, loadAheadTheme) {
		this.loadAheadLayoutModel = loadAheadLayoutModel;
        this.loadAheadTheme = loadAheadTheme;
    },
    
	/**
	 * Returns if the layout model should be loaded after a navigation node is
	 * loaded
	 * @return {Boolean} <code>true</code> if the layout model should be 
	 *                   preloaded, <code>false</code> otherwise
	 */
    isLoadAheadLayoutModel: function() {
        return this.loadAheadLayoutModel;
    },

    /**
     * Returns if a navigation node's theme should be loaded after the node 
     * is loaded
     * @return {Boolean} <code>true</code> if the theme should be 
     *                   preloaded, <code>false</code> otherwise
     */
    isLoadAheadTheme: function() {
        return this.loadAheadTheme;
    }
});

/**
 * Interface that defines a load ahead mulipart strategy for loading a user
 * as part of a multipart request
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.strategy.UserLoadAheadStrategy", com.ibm.mashups.enabler.strategy.Strategy,    {
    /**
     * @param {boolean} loadAheadUser if the current user should be 
     * preloaded. Must not be <code>null</code>.
     */
    constructor:function (loadAheadUser) {
        this.loadAheadUser = loadAheadUser;
        
        // temporary
        this.userModel = null;
    },
	
	/**
     * Returns if the current user should be loaded 
     * @return {Boolean} <code>true</code> if the current user should be 
     *                   preloaded, <code>false</code> otherwise
     */
    isLoadAheadUser: function() {
        return this.loadAheadUser;
    },
	
	// temporary
	setUserModel: function(userModel) {
        this.userModel = userModel;
    },

    getUserModel: function() {
        if (null == this.userModel) {
            this.userModel = com.ibm.mashups.enabler.model.Factory.getUserModel();
        }
        return this.userModel;
    }
});

/**
 * Interface that defines a load ahead mulipart strategy for loading the Catalog
 * Category Model as part of a multipart request
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.strategy.CatalogCategoryLoadAheadStrategy", com.ibm.mashups.enabler.strategy.Strategy,    {
    /**
     * @param {boolean} loadAheadCatalogCategoryModel if the catalog
     * category model should be preloaded. Must not be <code>null</code>.
     */
    constructor:function (loadAheadCatalogCategoryModel) {
        this.loadAheadCatalogCategoryModel = loadAheadCatalogCategoryModel;
        
        // temporary
        this.catalogCategoryModel = null;
    },
    
    /**
     * Returns if the catalog category model should be loaded 
     * @return {Boolean} <code>true</code> if the catalog category model should 
     *                   be preloaded, <code>false</code> otherwise
     */
    isLoadAheadCatalogCategoryModel: function() {
        return this.loadAheadCatalogCategoryModel;
    },
    
    // temporary
    setCatalogCategoryModel: function(catalogCategoryModel) {
        this.catalogCategoryModel = catalogCategoryModel;
    },

    getCatalogCategoryModel: function() {
        if (null == this.catalogCategoryModel) {
            this.catalogCategoryModel = com.ibm.mashups.enabler.model.Factory.getCatalogCategoryModel();
        }
        return this.catalogCategoryModel;
    }
});
	
/**
 * An interface that allows to retieve information about different representations of the resource.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.RepresentationProvider", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Returns a ListModel containing information about the alternate representations available. The model contains <code>Representation</code> objects .
     * @see Representation
     * @return {ListModel} ListModel containing alternate representations of the resource; never <code>null</code>
     */
    getAlternateModel: function() {
        return ListModel(); 
    }
});

/**
 * An interface that allows retrieving a URL and mime type representing the resource.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.Representation", com.ibm.mashups.enabler.Identifiable, {
  /**
      * @private
      */
    constructor:function () {
    },
    
    /**
     * Returns the mimetype of the representation.
     * @return {String} the identifier; never <code>null</code>
     */
    getID: function() {
        return String(); 
    },
    
    /**
     * Returns a full or absolute URL pointing to the resource in another representation.
     * @return {String} the URL pointing to the other representation; never <code>null</code>
     */
    getURL: function() {
        return String(); 
    },
    
    /**
     * Returns the mimetype of the content to which the URL is pointing to.
     * @return {String} the mimetype; never <code>null</code>
     */
    getMimeType: function() {
        return String(); 
    }
});

/**
* An interface that extends a model with additional selection methods.
*/
dojo.declare( "com.ibm.mashups.enabler.model.SelectionLocator", null, {
    /**
     * @private
     */
    constructor: function () {
    },
    /**
     * Get's the parent node for newly added shared pages.
     * @return {Deferred} a deferred object used to start this operation. The return value when 
     * executed through the deferred object is the default parent for accepted pages.
     */
    findDefaultAcceptParent: function() {
    }
    
});

/**
 * Interface for finding resources within a model.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.ResourceLocator", com.ibm.mashups.enabler.Locator, {

    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * Returns the URL of the resource to be located, or <code>null</code> if the resource cannot be found.
     * @param {Object} node A node of the model this locator is implemented on. Must not be <code>null</code>.
     * @param {String} name The name of the resource to be located within the given model. The name can also contain a directory path relative to the model. Must not be <code>null</code>.
     * @return {String} The URL that can be used to fetch the resource, or <code>null</code> if the resource cannot be found.
     */
    findResourceUrl: function(node, name){
    }
  
});
/**
 * An interface that allows to retieve submittable form
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.SubmittableFormProvider", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Returns a SubmittableForm object associated with the given id.
     * @param {String} id the id of the html form this object is associated with
     * @return {SubmittableForm} SubmittableForm object, maybe <code>null</code>
     */
    getSubmittableForm: function(id) {
        return SubmittableForm(); 
    }
});

/**
 * An interface that is associated with a submittable form. Such a form can for instance be used
 * for import usecases such as importing a space.
 * The form doesn't need to have the attributes enctype, action and method. They will be filled in automatically.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.SubmittableForm", com.ibm.mashups.enabler.Identifiable, {
  /**
      * @private
      */
    constructor:function () {
    },
    
    /**
     * Returns the URL this form is submitted to. Used to fill in the action attribute in the form.
     * @return {String} the URL this form is submitted to; never <code>null</code>
     */
    getURL: function() {
        return String(); 
    },
    
    /**
     * Returns the HTTP method used to submit this form. Used to fill in the method attribute in the form.
     * @return {String} the method; never <code>null</code>
     */
    getMethod: function() {
        return String(); 
    },
    
    /**
     * Submits the form
     * @return {Deferred} a deferred object used to start this operation. 
     */
    submit: function() {
         return Deferred();
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.iwidget.widget"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.widget"] = true;
dojo.provide("com.ibm.mashups.iwidget.widget");
dojo.provide("com.ibm.mashups.iwidget.widget.EventProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.Properties");
dojo.provide("com.ibm.mashups.iwidget.widget.PropertiesProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.ModifiableProperties");
dojo.provide("com.ibm.mashups.iwidget.widget.ModifiablePropertiesProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.Wire");
dojo.provide("com.ibm.mashups.iwidget.widget.WireProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.ModifiableWireProvider");
dojo.provide("com.ibm.mashups.iwidget.widget.IWidgetWrapper");
dojo.provide("com.ibm.mashups.iwidget.widget.IWidgetDefinition");
dojo.provide("com.ibm.mashups.iwidget.widget.IWidgetInstance");



/**
Interface defines functions to access handled or published event descriptions.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.EventProvider",null,{
	/**
	 * @private
	 */
	constructor: function(){
	
	},
	/**
	 This method returns an array of event description. Only published event of this widget will be returned.
	 @type {com.ibm.mashups.iwidget.IEventDescription}
	 @returns{com.ibm.mashups.iwidget.IEventDescription[] }  array of event description
	 */
	getWidgetPublishedEvents: function(){
	},
	
	/**
	 This method returns an array of event description. Only handled event of this widget will be returned.
	 @type {com.ibm.mashups.iwidget.IEventDescription[]}
	 @returns{com.ibm.mashups.iwidget.IEventDescription[] }  array of event description
	 */
	getWidgetHandledEvents: function(){
	},
	/**
	 This method returns the required event.
	 @param {String}name name of required public event
	 @type {com.ibm.mashups.iwidget.IEventDescription}
	 @returns{com.ibm.mashups.iwidget.IEventDescription }  an event description it returns NULL if event can't be found.
	 */
	getPublicEvent: function(name){
	}
	
});

/**
Interface defines functions to iterates , updates and persist Properties.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.Properties",null,{
  	/**
            * @private
            */	
    constructor:function(){
	},
/**
This method returns the value of the required item
@param{String}itemName name of the item.Must never be NULL.
@return{String }  return the  value of required item
 */	
	getItemValue:function(/*String*/ itemName){

	},
/**
This method returns an array of Strings,providing the name of each item. 
@return{String[]}  return an array of items names and return NULL if the set contains no item
 */
    getAllNames: function (){
       return null;
    }
});

/**
Read-Only interface defines functions to access properties that's defined with iWidget.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.PropertiesProvider",null,{
/**
  * @private
  */
    constructor:function(){
    },
/**
This method returns an object that contains iDescriptor items as defined by iWidget spec. It contains  default title and icon
@type com.ibm.mashups.iwidget.widget.Properties
@returns{com.ibm.mashups.iwidget.widget.Properties } object that contains iWidget  iDescriptor items information
*/
	getIDescriptorItems:function(){
	},
/**
This method returns an object that contains attributes as defined by iWidget spec. 
@type com.ibm.mashups.iwidget.widget.Properties
@returns{com.ibm.mashups.iwidget.widget.Properties } object that contains iWidget  iDescriptor items information
*/
	getAttributes:function(){
	}
});

/**
Modifiable interface defines functions to iterates , updates and persist Properties.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.ModifiableProperties",[com.ibm.mashups.iwidget.widget.Properties],{
    /**
            * @private
            */  
    constructor:function(){
    },
/**
This method creates or overwrites the value of the required item
@param{String}itemName name of the item.Must never be NULL.
@param{String} itemValue value of the item.Must never be NULL.
@return{com.ibm.mashups.iwidget.widget.Properties} return an handle of InstanceProperties upon successful, NULL upon failure.
 */     
    setItemValue:function(/*String*/ itemName,/*object*/itemValue){
        //summary:This method sets an value of an iDescriptor item
    },
/**
Removes the named item from the set. 
@param{String}itemName name of the item that needs to be removed.Must never be NULL.  
@return{com.ibm.mashups.iwidget.widget.Properties} return an handle of InstanceProperties upon successful, NULL upon failure..
 */ 
    removeItem:function(/*String*/ itemName){
        //summary:This method sets an value of an iDescriptor item
    }

});

/**
Modifiable interface defines functions to access properties that's defined with iWidget.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.ModifiablePropertiesProvider",null,{
/**
  * @private
  */
    constructor:function(){
    },
/**
This method returns an object that contains iDescriptor items as defined by iWidget spec. It contains  default title and icon
@type com.ibm.mashups.iwidget.widget.ModifiableProperties
@returns{com.ibm.mashups.iwidget.widget.ModifiableProperties } object that contains iWidget iDescriptor items information
*/          
    getIDescriptorItems:function(){
    },
    
/**
This method returns an object that contains attributes as defined by iWidget spec. 
@type com.ibm.mashups.iwidget.widget.ModifiableProperties
@returns{com.ibm.mashups.iwidget.widget.ModifiableProperties } object that contains iWidget iDescriptor items information
*/          
    getAttributes:function(){
    }
});

/**
Wire interface defines functions that expose information of a Wire
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.Wire",null,{
	/**
            * @private
            */
			constructor:function(){

		},
/**
This method returns id of the source iWidget that's  connected to.
@type String
@returns{String }  id of the source iWidget
*/ 			
		getSourceWidgetID:function(){

		},
/**
This method returns name of the event in the source iWidget.
@type String
@returns{String }  name of the source event
*/ 			
		getSourceEventName:function(){
		 //summary: This method returns an object that contains instance level attribute items	
		},
		/**
This method returns id of the source iWidget that's  connected to.
@type String
@returns{String }  id of the source iWidget
*/ 			
		getTargetWidgetID:function(){

		},
/**
This method returns name of the event in the source iWidget
@type String
@returns{String }  name of the source event
*/ 			
		getTargetEventName:function(){
		 //summary: This method returns an object that contains instance level attribute items	
		}
});

/**
Interface defines functions to access handled or published event descriptions.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.WireProvider",null,{
/**
  * @private
  */
	    constructor:function(id){
	
		},
/**
This method returns an array of supported wires. 
@type com.ibm.mashups.iwidget.widget.Wire[]
@returns{com.ibm.mashups.iwidget.widget.Wire[] }  array of Wire this iWidget is wired as  target .
*/				  
		getWires:function(){
		}
});

/**
Interface defines functions to access handled or published event descriptions.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.ModifiableWireProvider",com.ibm.mashups.iwidget.widget.WireProvider,{
/**
  * @private
  */
        constructor:function(id){
    
        },
        
        /**
        * @param {String}sourceWidgetId
        * @param {String}sourceEventName
        * @param {String}targetEventName
        * @type void
        */
        addWire: function(sourceWidgetId, sourceEventName, targetEventName) {
        },
        /**
        * @param {String}sourceWidgetId
        * @param {String}sourceEventName
        * @param {String}targetEventName
        * @type void
        */
        removeWire: function(sourceWidgetId, sourceEventName, targetEventName) {
        }
});

/**
 IWidgetWrapper interface  represents a runtime instance of an iWidget on the page. Information provided by the IWidgetWrapper is an aggregation of definition level data and instance level data.
 To get desriptive data that's specific to instance level and definition level. It should use Provider api that's implemented by IWidgetDefinition or IWidgetIstance.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.IWidgetWrapper",[com.ibm.mashups.enabler.Identifiable,com.ibm.mashups.iwidget.widget.WireProvider,com.ibm.mashups.iwidget.widget.EventProvider],{
/**
  * @private
  */
	    constructor:function(){
	
		},

/**
This method returns iWidgetDefinition of  this runtime instance.<br/>
<code>var deferred = widgetWrapper.getIWidgetDefinition();</code><br/>
<code>deferred.setFinishedCallback(callback,parameters);</code><br/>
<code>deferred.start(true);</code><br/>
here are the callback parameters that will be passed into callback function: <br/>
 &nbsp;&nbsp;&nbsp;&nbsp;<code>resource</code> -  IWidgetDefinition object <br>
&nbsp;&nbsp;&nbsp;&nbsp;<code>statusCode</code> - the overall HTTP status,code of the action (the highest status code of the involved operations).<br>
&nbsp;&nbsp;&nbsp;&nbsp;<code>params</code> - the parameters passed into the callback <br>
@type com.ibm.mashups.enabler.Deferred
@returns{com.ibm.mashups.enabler.Deferred}  a deferred object used to start this operation. 
@see com.ibm.mashups.iwidget.widget.IWidgetDefinition 
*/		
		getIWidgetDefinition:function(){
		},
/**
This method returns iWidgetInstance which contains all the descriptive data for this iWidget instance
@type com.ibm.mashups.iwidget.widget.IWidgetInstance
@returns{com.ibm.mashups.iwidget.widget.IWidgetInstance }  iWidgetInstance object
*/			
		getIWidgetInstance:function(){
		},
/**
* This method returns the a clone of the content of the widget as it is inside of the DOM.<br/>It removes automatically
* any markup that was added to the DOM using microformats (given that the microformat implements the unProcess handler).<br/>
* This method does not remove any additional DOM changes that where done by the widget itself and applies the unProcess only<br/>
* to the subnodes of the actual widget node.<br/><br/>
* If your widget needs to take special action to it's DOM nodes before the getMarkup is processing it, you can define the method<br/>
* <code>_onGetMarkup</code> in your widgets JavaScript file. This method, as part of the iScope, will always be called before the actual<br/>
* markup is processed.<br/><br/>
* <b>The synchrounus mode of returned Deferred is not supported.</b>
* @type com.ibm.mashups.enabler.Deferred
* @returns {com.ibm.mashups.enabler.Deferred} a deferred object used to fetch the actual markup. 
*/
        getMarkup: function() {
        }
});

/**
Interface defines functions to access all the data object in widget definition. PropertiesProvider is not implemented.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.IWidgetDefinition",[com.ibm.mashups.iwidget.widget.EventProvider,com.ibm.mashups.iwidget.widget.PropertiesProvider],{
  	/**
            * @private
            */	
    constructor:function(){
 
	},
/**
This method returns an array of supported modes such as "view" and "edit".
@returns{String[] }  array of supported modes this iWidget supports.
*/				  
    getSupportedModes:function(){
    },    

/**
This method returns a  JSON based spec compliant object that represents all the data that's defined in widget xml.<p/>
Rule to follow:<br/>
1. Element -- "iw:iwidget" is considered to be root Element and a root object is created from here.<p/>
2. Any  attribute of this element will be a field in the root object. '_' will be added as prefix to field names.<br/>
<code>&lt;iw:iwidget id="map" allowInstanceContent="false"......&gt;</code><br/>
{ _id:"map",_allowInstanceContent:"false"......}<p/>
3. All repreatable elements, element name (append with "s") is used as a field name and an object is created to contain all the repeatable elements.
Within that object, value of "id" attribute is used as field name for an individual element if id attribute is available.<br/>
{<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;resources:{<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"myId":{_id:"myId",_src:"my.js"},<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;		"myOtherId":{_id:"myOtherId",_src:"my2.js"}<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;		}<br/>
}<p/>
4. For "iw:content" elements, "contents" is used as the key in the parent object and an object is created to contain all the content elements.<br/>
For each "content" element, "mode" attribute is used  as the key and CDATA section is saved as the value.<br/>
{<br/>
contents:{ 
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"view":"cdatasection_for_viewmode",<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"edit":"cdatasection_for_editmode"<br/>
	     }<br/>
} <p/>
5. For "iw:alt" elements,"alts" is used as the key in parent object and an object is created to contain all the alt elements.<br/>
For each "alt" element, "lang" attribute is used  as the key and  all the attributes are saved per attributes convention.<br/>
eventDescname:{<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;_id:"eventDescnname",<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;_payloadType:"payloadType",<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alts:{<br/>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"en":{_lang:'en',_description:"description",_descriptionURI:"descriptionURI"},<br/>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"zh":{_lang:'zh',_description:"description",_descriptionURI:"descriptionURI"}<br/>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br/>
}<p/>
An example of simple iWidget and  the return result.<br/>
<code>&lt;iw:iwidget id="stock" xmlns:iw="http://www.ibm.com/xmlns/prod/iWidget" iScope="stock" allowInstanceContent="true" supportedModes="view edit " mode="view" lang="en"></code><br/>
&nbsp;&nbsp;&nbsp;<code> &lt;iw:itemSet id="attributes" private="true" onItemSetChanged="changeItemSet"&gt;</code><br/>
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;iw:item id="broker"  readOnly="false"    value="Etrade" /&gt;</code><br/>
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code> &lt;iw:item id="company"  value="IBM" /&gt;</code><br/>
 &nbsp;&nbsp;&nbsp;<code>&lt;/iw:itemSet&gt;</code><br/>
 &nbsp;&nbsp;&nbsp;<code> &lt;iw:event id="sendStockData" eventDescName="sendStockDataDesc"  published="true" onNewWire="sendData" /&gt; </code><br/> 
 &nbsp;&nbsp;&nbsp;<code> &lt;iw:eventDescription  id="sendStockDataDesc"  payloadType="stockData" title="Send stock data"  lang="en"  &gt;</code><br/>
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>&lt;iw:alt title="Send stock data"  lang="en" /&gt; </code><br/>
  &nbsp;&nbsp;&nbsp;<code>&lt;/iw:eventDescription&gt;</code><br/>
 &nbsp;&nbsp;&nbsp;<code>&lt;iw:resource src="stock.js" id="stock" /&gt;</code><br/>
  &nbsp;&nbsp;&nbsp;<code>&lt;iw:content mode="view"&gt;
        &lt;![CDATA[    
          mycontent
            ]]&gt;
     &lt;/iw:content&gt;</code><br/> 
  &nbsp;&nbsp;&nbsp;<code>&lt;/iw:iwidget&gt;</code><p/>
  
  Example of returnin json object. <br/>
  <code>
  {  _id:"map",_allowInstanceContent:"true",_iScope:"stock",_supportedModes:"view edit",_mode:"view",_lang:"en",<br/>
      &nbsp;&nbsp;&nbsp; itemSets:{<br/>
	       &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"attributes":{  _id:"attributes", _private:"true",_onItemSetChanged:"changedItemSet",<br/>
	        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;                  items:{ <br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  			"broker":{  _id:"broker",_readOnly:"false", _value:"Etrade"},<br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  			"company":{ _id:"company",_value;"IBM"} <br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;		     }<br/>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;	            }<br/>
     &nbsp;&nbsp;&nbsp;},<br/>
           &nbsp;&nbsp;&nbsp;events:{ <br/>
	        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"sendStockData":{  _id:"sendStockData", _eventDescName:"sendStockDataDesc", _published:"true",_onNewWire:"sendData"}<br/>
	 &nbsp;&nbsp;&nbsp;},<br/>
           &nbsp;&nbsp;&nbsp;eventDescriptions:{<br/>
	        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"sendStockDataDesc":{ _id:"sendStockDataDesc", _payloadType:"stockData",_title:"Send stock data",_lang:"en",<br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  	                    alts:{<br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;  			        "en":{ _lang:"en",_title:"Send stock data"}	<br/>		
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  			      }	<br/>	
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;			}<br/>	  
	&nbsp;&nbsp;&nbsp;		    },<br/>
         &nbsp;&nbsp;&nbsp; resources:{<br/>	
		       &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"stock":{ _id:"stock", _src:"stock.js"}<br/>
	&nbsp;&nbsp;&nbsp;},<br/>
           &nbsp;&nbsp;&nbsp;contents:{<br/>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; "view": {<br/>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; "_mode": "view",<br/>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; "value": "mycontent"<br/>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }<br/>
    &nbsp;&nbsp;&nbsp; }<br/>	 
  }<br/>
  </code>

@returns{object} a JSON based, spec compliant object that represents all the data that's defined in widget.xml
*/
    toSpecObject:function(){
    }
});

/**
Interface defines functions to access all the instance level descriptive data.
@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.widget.IWidgetInstance",[com.ibm.mashups.iwidget.widget.ModifiablePropertiesProvider,com.ibm.mashups.iwidget.widget.ModifiableWireProvider],{
  	/**
            * @private
            */	
    constructor:function(){
 
	}

});

}

if(!dojo._hasResource["com.ibm.mm.iwidget.widget.properties"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widget.properties"] = true;
dojo.provide("com.ibm.mm.iwidget.widget.properties");




dojo.declare("com.ibm.mm.iwidget.widget.PropertiesImpl", [com.ibm.mashups.iwidget.widget.Properties], {
    DELETE_TOKEN: "com.ibm.mm.iwidget.widget.DELETE_TOKEN",
    /**
    * @param items {<String, String>} the items this Properties class is based on
    * @param defaultProps {Properties} The default properties object
    **/
    constructor: function(items, localizedItems, defaultProps) {
        this._defaultProperties = defaultProps;
        
        if (items)
            this._items = items;
        else
            this._items = {};

        if (localizedItems)
            this._localizedItems = localizedItems;
        else
            this._localizedItems = {};			
    },
	
    _getItemValue: function(itemName) {
        if (itemName in this._items) {
            var value = this._items[itemName];
            
            if (value == this.DELETE_TOKEN)
                return null;
                
            return value;
        }
        
        if (this._defaultProperties)
            return this._defaultProperties.getItemValue(itemName);
            
        return null;
    },
	
	getItemValue: function(itemName, locale) {
		var ret = this._getItemValue3(itemName, locale);
		var ret2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(ret);
		if (ret2 != null) {
			ret = ret2;
		}
		
		return ret;
	},
	
	_getItemValue2: function(itemName, locale) {
		if (!locale) {
			locale = "en";
		}
		
		// normalize
		var loc = locale;
        var dash = locale.indexOf("-");
        if (-1 < dash) {
            loc = locale.slice(0, dash);
            loc += "_" + locale.slice(dash + 1).toUpperCase();
        } 

        if (itemName in this._localizedItems) {
			if (loc in this._localizedItems[itemName]) {
				var value = this._localizedItems[itemName][loc];
				
				if (value == this.DELETE_TOKEN) 
					return null;
				
				return value;
			}
        }
        
        if (this._defaultProperties)
            return this._defaultProperties.getItemValue(itemName, loc);
            
		return this._getItemValue(itemName);
    },
	
	_getItemValue3: function(itemName, locale) {
		if (!locale) {
			locale = "en";
		}
				
		if (itemName in this._localizedItems) {
			var matchLocales = [];
			for (var i in this._localizedItems[itemName]){
				matchLocales.push(i);
			}
			var value = this._localizedItems[itemName][com.ibm.mm.enabler.utilities.matchLocale(locale, matchLocales)] || null;
			if (value == this.DELETE_TOKEN) {
				return null;
			}
					
			return value;		
		}
		
        if (this._defaultProperties) {
			return this._defaultProperties.getItemValue(itemName, locale);
		}		
		
		return this._getItemValue(itemName);
	},
	
	getItemLocales: function(itemName) {
		if (itemName in this._localizedItems) {
			return this._localizedItems[itemName];
		}
		
		return [];
	},
		
    getAllNames: function() {
        var defaultNames = [];
        if (this._defaultProperties)
            defaultNames = this._defaultProperties.getAllNames();
        
        
        var mergedItems = {};
        
        for (var i=0; i<defaultNames.length; i++) {
            mergedItems[defaultNames[i]] = null;
        }
        
        for (itemName in this._items) {
            if (this._items[itemName] == this.DELETE_TOKEN) {
                 if (itemName in mergedItems)
                    delete mergedItems[itemName];
            } else {
                mergedItems[itemName] = null;
            }
        }
        
        for (itemName in this._localizedItems) {
            if (this._localizedItems[itemName] == this.DELETE_TOKEN) {
                 if (itemName in mergedItems)
                    delete mergedItems[itemName];
            } else {
                mergedItems[itemName] = null;
            }
        }
		
        var names = [];
        
        for (itemName in mergedItems) {
            names.push(itemName);
        }
        
        return names;
    }
});

dojo.declare("com.ibm.mm.iwidget.widget.ModifiablePropertiesImpl", [com.ibm.mm.iwidget.widget.PropertiesImpl], {
    constructor: function(items, localizedItems, defaultProps) {
        this._dirty = false;
    },
	
    _setItemValue: function(itemName, itemValue) {
        this._items[itemName] = itemValue;
        this._dirty = true;
        
        return this;
    },
	
	setItemValue: function(itemName, itemValue, readOnly, locale) {
		if (locale) {
			if (!this._localizedItems[itemName]) {
				this._localizedItems[itemName] = {};
			}
			
			var loc = locale.replace(/-/g, "_");
			this._localizedItems[itemName][loc] = itemValue;
			this._dirty = true;
	        return this;
		}
		else {
			return this._setItemValue(itemName, itemValue);
		}		        
    },
	
    _removeItem: function(itemName) {
        var deleted = false;
        if (itemName in this._items) {
            delete this._items[itemName];
            deleted = true;
        }
        
        if (this._defaultProperties && this._defaultProperties.getItemValue(itemName) !== null) {
            this._items[itemName] = this.DELETE_TOKEN;
            deleted = true;
        }
        
        if (deleted) {
            this._dirty = true;
            
            return this;
        } else
            return null;
    },
	
	removeItem: function(itemName, locale) {
        var deleted = false;
        if (itemName in this._localizedItems) {
			if (locale in this._localizedItems[itemName]) {
				delete this._localizedItems[itemName][locale];
				deleted = true;
			}
        }
        
        if (this._defaultProperties && this._defaultProperties.getLocalizedItemValue(itemName, locale) !== null) {
            this._localizedItems[itemName][locale] = this.DELETE_TOKEN;
            deleted = true;
        }
        
		this._removeItem(itemName);
		
        if (deleted) {
            this._dirty = true;
            
            return this;
        } else
            return null;
    },
    _isDirty: function() {
        return this._dirty;
    },
    _setDirty: function(value) {
        this._dirty = value;
    }
});

}

if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetdefinition"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetdefinition"] = true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetdefinition");

dojo.require("com.ibm.mm.enabler.xml" );



dojo.declare( "com.ibm.mm.iwidget.widget.IWidgetDefinitionImpl",com.ibm.mashups.iwidget.widget.IWidgetDefinition, 
{
              namespaces: {  "iw" : "http://www.ibm.com/xmlns/prod/iWidget" },
              constructor:function(/*/object*/widgetDef,xmlStr){
                   this.widgetDef= widgetDef;  //xmlStr is now widgetDef.xmlStr, xmlData is rarely used so only load when it's called in toSpec function.
				   if(xmlStr) this.xmlStr = xmlStr;
				   //this.xmlStr = widgetDef.xmlStr;
                   //this.xmlData = com.ibm.mm.enabler.xslt.loadXmlString(widgetDef.xmlStr);
              },			  
              getAllowInstanceContent:function(){
                 return this.widgetDef.allowInstanceContent;
              },
              getResources:function(){
                   return this.widgetDef.resources;
              },
              getIScope:function(){
                   return this.widgetDef.iScope;
              },
              getWidgetEvents:function(){
                   return this.widgetDef.widgetEvents;
              },
              getMarkupByMode:function(mode){
                   if (typeof this.widgetDef.markup != "undefined" && this.widgetDef.markup != null) {
                       if(!mode) mode="view";
                       var temp = this.widgetDef.markup[mode];
                       return temp;
                   }
                   else 
                       return null;
              },
              /**
               * PropertiesProvider Impl
               */
              getAttributes: function()
              {    
                if (!this.attributeProperties) {
                    var items = {};
                    var defAttrItemSet = this.widgetDef.itemSetsArr[iwConstants.ATTRIBUTES];
                    
                    if (defAttrItemSet) {
                        for (itemName in defAttrItemSet.items) {
                            items[itemName] = defAttrItemSet.items[itemName].value;
                        }
                    }
                    
                    var simpleAttributes = this.widgetDef.simpleAttributes;
                    
                    if (typeof simpleAttributes != "undefined" && simpleAttributes != null) {
                        for (var i in simpleAttributes) {
                            var value = simpleAttributes[i];
                            if (typeof value != "undefined" && value != null) {
                                items[i] = value;
                            }
                        }
                    }

                    this.attributeProperties = new com.ibm.mm.iwidget.widget.PropertiesImpl(items);
                }
                
                return this.attributeProperties;
              },
              /**
               * PropertiesProvider Impl
               */
              getIDescriptorItems:function(){
                if (!this.idescriptorProperties) {
                    this.idescriptorProperties = new com.ibm.mm.iwidget.widget.PropertiesImpl(this.widgetDef.iDescriptor);
                }
                
                return this.idescriptorProperties;
              },
              getAllItemSetNames: function(){
                  var names = new Array();
                  if ( typeof (this.widgetDef.itemSetsArr) == "undefined" || this.widgetDef.itemSetsArr == null ){
                      return names;
                  }
                  var i = 0;
                  for (itemName in this.widgetDef.itemSetsArr)
                  {
                      var itemSetWrapper = this.widgetDef.itemSetsArr[itemName];
                      if (typeof (itemSetWrapper) != "undefined" && itemName != iwConstants.ATTRIBUTES) {
                          names[i] = itemSetWrapper.name;
                          i++;
                      }
                  }
                  return names;
              },
              getItemSet: function(/*String*/name){
                  if ( name == "attributes") return this.getAttributes();

                  var itemSetWrapper = this.widgetDef.itemSetsArr[name];
                  if (typeof itemSetWrapper == "undefined" || itemSetWrapper == null) return null;               
                  return itemSetWrapper;
              },
              getPublishedEventsNames:function(){
                  if (!this.widgetDef.publicEvents) return [];
                   var eventNames = [];
                   var aEventName;
                   for ( aEventName in this.widgetDef.publicEvents) {
						var temp = this.widgetDef.publicEvents[aEventName];
						if (!temp.isPublished || (temp.isPublished && temp["isPublished"] == "true"))
                        eventNames.push(aEventName);
                   }
                   return eventNames;
              },
              getHandledEventsNames:function(){
                  if (!this.widgetDef.publicEvents) return [];
                  var eventNames = [];
                  var aEventName;
                  for ( aEventName in this.widgetDef.publicEvents) {
                        var temp = this.widgetDef.publicEvents[aEventName];
						//it's a valid handledEvent only when onEvent is defined
						if (temp.onEvent && temp.onEvent != null)
                        eventNames.push(aEventName);
                  } 
                  return eventNames;
              },
              getPublishedEvent:function(/*String*/eventName){
			  //generate a copy of ieventDescription object
			      if (!this.widgetDef.publicEvents) return null;
                   var event = this.getPublicEvent(eventName);
				   if (event != null){
						if(!event.isPublished || (event.isPublished && event.isPublished == "false"))
						event = null;
				   }
                   return event;                
              },
              getHandledEvent:function(/*String*/eventName){
			       //generate a copy of iEventDescription object 
                   if (!this.widgetDef.publicEvents) return null;
                   var event = this.getPublicEvent(eventName);
				   if (event != null){
						if(!event.onEvent)
						event = null;
				   }
                   return event;
              },
			  getPublicEvent:function(eventName){
			      //generate a copy of iEventDescription object , following json object should be created passinto iEventDescription
				  if (!this.widgetDef.publicEvents) return null;
				  if (this.eventsCache && this.eventsCache != null && this.eventsCache[eventName] != null) return new com.ibm.mm.iwidget.iEventDescriptionImpl(this.eventsCache[eventName]);
                   var data = this.widgetDef.publicEvents[eventName];
                   var event=null;
				   var obj = {};
				   if (typeof data != "undefined" && data != null) {
				       //mapping into json format defined by iwidget spec.
					   obj.name = data.id;
					   if (data.onEvent && data.onEvent != null) 
					   {
						obj.handlingFn = data.onEvent; //"String"-pass by value
						obj.isHandled = true;
					   }
					   else{
						obj.isHandled = false;
					   }
					   
					   //if isPublished == true or == "true", then isPublished = true;
					   if ((data.isPublished && data.isPublished == "true") || (data.isPublished && data.isPublished == true)) obj.isPublished = true;
					   
					   obj.attributes = {};
					   obj.localizedAttributes = {};
					   
					   var descriptionId = null;
					   for ( var i in data ){
							if ( i != "id" && i!="onEvent" && i != "description"){
								obj.attributes[i] = data[i];  // save onNewWire/onRemoveWire, potentially other attributes, all are string
							}
							if ( i == "description"){
								descriptionId = data[i];
							}
					   }

                       var description = null;
                       if (typeof descriptionId != "undefined" && descriptionId != null){
                           description = this._getEventDescription(descriptionId);
				           if (description != null){
                               var defaultLang = description.lang;
                               if (typeof defaultLang == "undefined" || defaultLang == null) {
                                   defaultLang = this.getDefaultLanguage();
                                   if (typeof defaultLang == "undefined" || defaultLang == null) {
                                   defaultLang = "en";
                                   }
                               }
							   obj.lang = defaultLang;
							   if (description.payloadType && description.payloadType != null)	obj.type = description.payloadType;
							   
							   //todo: save more attributes && localized attributes.
							   if (description.aliases && description.aliases != null) obj.attributes.aliases = description.aliases;
							   
							   var localizedAttributes = description.descriptions;
							   /*if (typeof localizedAttributes != "undefined" && localizedAttributes != null){	
								 obj.localizedAttributes= dojo.clone(description.descriptions);
							   }*/
							   if (typeof localizedAttributes != "undefined" && localizedAttributes != null){				          //performance improvement
								 obj.localizedAttributes= description.descriptions;
							   }
							   if (typeof (obj.localizedAttributes[defaultLang]) == "undefined") {
								   obj.localizedAttributes[defaultLang] = {};  
							   }							   
							   //backward compatibility
							   if (description.title && description.title != null ) obj.localizedAttributes[defaultLang].title = description.title;
							   if (description.description && description.description != null ) obj.localizedAttributes[defaultLang].description = description.description;
							   if (description.descriptionURI && description.descriptionURI != null ) obj.localizedAttributes[defaultLang].descriptionURI = description.descriptionURI;					 
				       	    }
                       }  
					    if (!this.eventsCache) this.eventsCache={};
						this.eventsCache[eventName] = obj;
					   event = new com.ibm.mm.iwidget.iEventDescriptionImpl(obj);  		
                  }
				  return event;
			  },
              getWidgetId:function(){
                  return this.widgetDef.id;                  
              },
              getWidgetName:function(){
                   return this.widgetDef.id;
              },
              getPayloadDefs:function(){
                   return this.widgetDef.payloadDefs;
              },
              getPayloadDef:function(name){
                  var payloadDef = this.widgetDef.payloadDefs[name];
                  if (typeof payloadDef == "undefined") return null;
                  return payloadDef;          
              },
              getPayloadDefNames:function(){
                  var arr = [];
                  var a;
                  for (a in this.widgetDef.payloadDefs){
                      arr.push(a);                      
                  }
                  return arr;
              },
              getSupportedModes:function(){
                   var temp = this.widgetDef.supportedModes;
                   if (typeof temp == "undefined" || temp == null) {
                       return null;
                   }
                   var arr = temp.split(" ");
                   return arr;
              },
              _getEventDescription:function(id){
                   var eventDescription=null;
                   if (typeof this.widgetDef.eventDescriptions != "undefined" || this.widgetDef.eventDescriptions != null) {
                       eventDescription = this.widgetDef.eventDescriptions[id];
                   }
                   return eventDescription; 
              },
			  _getPublicEvents:function(){
			  //return associative array, each eventdescription is identified by it's name
			  //return an empty object if there's no public Events;
			  //pass by data
				var publicEvents = {};
				for ( aEventName in this.widgetDef.publicEvents) {
				    var eventDescription = this.getPublicEvent(aEventName);
                    if (eventDescription != null) {
                        publicEvents[aEventName] = eventDescription; 
                    }
                }
				return publicEvents;
			  },	       
              getDefaultLanguage:function(){
                   return this.widgetDef.lang;
              },
              getMarkup:function(){
                   return this.widgetDef.markup;
              },
			  getWidgetPublishedEvents:function(){
			  	return this.getPublishedEvents();
			  },
			  getWidgetHandledEvents:function(){
			  	return this.getHandledEvents();
			  },
			  getPublishedEvents:function(){
			  //return an array of new generated eventDescription
			  //pass by data
                var publishedEvents = [];
                var publishedEventsNames = this.getPublishedEventsNames();
                for (var i=0;i<publishedEventsNames.length;i++) {
                    var publishedEventName = publishedEventsNames[i];
                    var eventDescription = this.getPublicEvent(publishedEventName);
                    if (eventDescription != null) {
                        publishedEvents[i] = eventDescription; //todo, remove array
                    }
                }
                return publishedEvents;  
              },
              getHandledEvents:function(){
			  //save as above
                   var handledEvents = [];
                   var handledEventsNames = this.getHandledEventsNames();
                   for (var i=0;i<handledEventsNames.length;i++) {
                       var handledEventName = handledEventsNames[i];
                       var eventDescription = this.getPublicEvent(handledEventName);
                       if (eventDescription != null) {
                           handledEvents[i] = eventDescription; //todo, remove array
                       }
                   }
                   return handledEvents;
              },
              toSpecObject: function() {
                  var outputJSON = {};
				  //no support within sandbox
				  if (typeof this.xmlStr == "undefined" || this.xmlStr == null) return {};
				  var xmlData = com.ibm.mm.enabler.xslt.loadXmlString(this.xmlStr);
          
                  var expr = "/iw:iwidget";
                  var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, xmlData, this.namespaces);
                  
                  if (nodes && nodes.length > 0) {
                      var rootNode = nodes[0];
                      this._addAttributesToJson(rootNode, outputJSON);
                      
                      this._addElements(rootNode, "eventDescription", "id", "alt", "lang", outputJSON);
                      this._addElements(rootNode, "event", "id", null, null, outputJSON);
                      
                      this._addElements(rootNode, "itemSetDescription", "id", "alt", "lang", outputJSON);
                      
                      this._addElements(rootNode, "itemDescription", "id", "alt", "lang", outputJSON);        
                      
                      this._addElements(rootNode, "itemSet", "id", "item", "id", outputJSON);     
                      
                      this._addElements(rootNode, "resource", "id", null, null, outputJSON);
                      this._addElements(rootNode, "content", "mode", null, null, outputJSON, true);
                  }
                  
                  return outputJSON;
              },
              _addAttributesToJson: function(node, jsonNode) {
                  var atts = node.attributes;
                  for (var i=0;i<atts.length;i++)
                  {
                      if (atts[i].nodeName.indexOf(":") == -1) {
                          jsonNode["_" + atts[i].nodeName] = atts[i].nodeValue;
                      }
                  }
              },
              _addElements: function(node, elementName, keyName, subElement, subElementKeyName, jsonNode, isContentNode) {
                  var elements = jsonNode[elementName + "s"] = {}; // do plural notation
                  
                  var expr = "iw:" + elementName;
                  var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, node, this.namespaces);
                  
                  if (nodes) {
                      for (var i=0; i<nodes.length; i++) {
                          var keyValue = nodes[i].getAttribute(keyName);
                          if (keyValue) {
                              var subNode = elements[keyValue] = {};
                              this._addAttributesToJson(nodes[i], subNode);
                              
                              // if there is also a subelement do one recursion
                              if (subElement) {
                                  this._addElements(nodes[i], subElement, subElementKeyName, null, null, subNode);
                              }
                              
                              // if this is a content node also add the content as "value"
                              if (isContentNode) {
                                  if (nodes[i].childNodes && nodes[i].childNodes.length > 0){
                                      subNode["value"] = nodes[i].childNodes[0].nodeValue + "";
                                  } else
                                      subNode["value"] = "";
                              }
                          }
                      }
                  }
              }
});

dojo.declare( "com.ibm.mm.iwidget.widget.IWidgetDefinitionLegacyImpl",com.ibm.mashups.iwidget.widget.IWidgetDefinition, 
{
//unfortunately sametime iwidget is still not spec 1.0 compliant
              constructor:function( /*object*/name, /*String*/markup,/*String*/iScope,/*object[]*/itemSetsArr,/*object*/widgetEvents,/*String*/uri,/*[]*/supportedModes,/*[]*/publishedEvents,/*[]*/handledEvents ,/*[]*/resources,/*[]*/payloadDefs,iDescriptor) {
                var arg1 = name;
                //todo:fix me
                if (dojo.isString(arg1)){				
			        this.name = name;
				    this.markup = markup;
                    this.iScope = iScope;
                    this.itemSetsArr = itemSetsArr;
                    this.uri = uri;
                    this.widgetEvents = widgetEvents;	
                    this.publishedEvents = publishedEvents;
                    this.handledEvents = handledEvents;	
                    this.supportedModes = supportedModes;
                    this.resources = resources;
                    this.payloadDefs = payloadDefs;
                    this.iDescriptor = iDescriptor;
                }
                else{
                    this.name = arg1["name"];
                    this.markup = arg1["markup"];
                    
                    this.metaData = arg1["metaData"];
                    this.events = arg1["events"];
                    this.itemSets = arg1["itemSets"];
                    this.resources = arg1["resources"];
                    this.payloadDefs = arg1["payloadDefs"];
                    this.iScope = this.metaData["iScope"];
                    this.supportedModes = this.metaData["supportedModes"];
                    this.uri = this.metaData["contentURI"];
                    
                    var anEvent;
                    this.widgetEvents = {};
                    for (anEvent in this.metaData){
                       
                        if (anEvent.indexOf("on") == 0)
                        {
                            this.widgetEvents[anEvent]=this.metaData[anEvent];
                        }
                    }
                    var publishedEventsData = arg1["events"]["publishedEvents"];
                    this.publishedEvents = {};
                    this.handledEvents = {};
                    var anEventName;
                    for (anEventName in publishedEventsData){
                        var anEvent = publishedEventsData[anEventName];
                        var iEventDescription=new com.ibm.mm.iwidget.iEventDescriptionImpl(anEvent.eventName,anEvent.payloadType,anEvent.description,anEvent.onEvent);
                        if (!this.publishedEvents[anEventName]) this.publishedEvents[anEventName]=[];
                             this.publishedEvents[anEventName].push(iEventDescription);          
                    }      
                    
                    var handledEventsData = arg1["events"]["handledEvents"];   
                    for (anEventName in handledEventsData){
                        var anEvent = handledEventsData[anEventName];
                        var iEventDescription=new com.ibm.mm.iwidget.iEventDescriptionImpl(anEvent.eventName,anEvent.payloadType,anEvent.description,anEvent.onEvent);
                        if (!this.handledEvents[anEventName]) this.handledEvents[anEventName]=[];
                             this.handledEvents[anEventName].push(iEventDescription);          
                    }
                    
                    var anItemSetName;
                    this.itemSetsArr = {};
                    for (anItemSetName in arg1["itemSets"]){
                        var anItemSetData = arg1["itemSets"][anItemSetName];
                        if (anItemSetName =="attributes"){
                            var anItemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(anItemSetData.name,anItemSetData.onItemSetChanged);
                        }
                        else{
                            var anItemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(anItemSetData.name,anItemSetData.onItemSetChanged);
                        }
                        //set data to the internal data field("items") in ItemSet
                        anItemSet["itemLists"]["items"]= anItemSetData["itemLists"];
                        this.itemSetsArr[anItemSetName]=anItemSet;
                    }
                }
			  },   
              _getPublishedEvents:function(){
                   return this.publishedEvents; // an associative array
              },
              _getHandledEvents:function(){
                   return this.handledEvents;
              },
			  getPublishedEvents:function(){
					//return a real array
                   var arr = [];
					for (var i in this.publishedEvents){
						arr.push(this.publishedEvents[i]);
					}
					return arr;
              },
              getHandledEvents:function(){
			  //return a real array
                   var arr = [];
					for (var i in this.handledEvents){
						arr.push(this.handledEvents[i]);
					}
					return arr;
              },
              getAttributes:function()
              { // need to implement SPI
                  //var itemSetWrapper = {name:name,onItemSetChanged:onItemSetChanged,isPrivate:isPrivate};
             //      itemSetWrapper.items = [];
             //var anItem = {id:id,value:value,readOnly:isReadOnly};  
                  var attributes = this.itemSetsArr["attributes"];
                  if (typeof attributes == "undefined" || attributes == null) attributes={name:"attributes",items:{}};
                  
                  if ( typeof (this.uri) != "undefined" && attributes != null) 
                          attributes.items["contentURI"] = {id:"contentURI",value:this.uri,readOnly:false};
                  if ( typeof (this.supportedModes ) != "undefined" && attributes != null)
                          attributes.items["supportedModes"] = {id:"supportedModes",value:this.uri,readOnly:false};
                   return attributes;
              },
              getAllItemSetNames:function(){
                  var names = new Array();
                  if ( typeof (this.itemSetsArr) == "undefined" || this.itemSetsArr == null ){
                      return names;
                  }
                  var i = 0;
                  for (itemName in this.itemSetsArr)
                  {
                      var itemSetWrapper = this.itemSetsArr[itemName];
                      if (typeof (itemSetWrapper) != "undefined") {
                          names[i] = itemSetWrapper.name;
                      }
                      i++;
                  }
                  return names;
              },
              getItemSet:function(/*String*/name){
                  if ( name == "attributes") return this.getAttributes();
                   var itemSetWrapper = this.itemSetsArr[name];
                   if (typeof (itemSetWrapper) != "undefined") {
                       return itemSetWrapper;
                   }
                   return null;
              },
               getPublishedEventsNames:function(){
                  if (!this.publishedEvents) return null;
                   var eventNames = [];
                   var aEventName;
                   for ( aEventName in this.publishedEvents) {
                        eventNames.push(aEventName);
                   }
                   return eventNames;
              },
              getHandledEventsNames:function(){
                  if (!this.handledEvents) return null;
                  var eventNames = [];
                  var aEventName;
                  for ( aEventName in this.handledEvents) {
                       eventNames.push(aEventName);
                  } 
                  return eventNames;
              },
              getPublishedEvent:function(/*String*/eventName){
                   if (!this.publishedEvents) return null;
                   //return an instance of iEventDescription
                   return this.publishedEvents[eventName];
              },
              getHandledEvent:function(/*String*/eventName){
                    if (!this.handledEvents) return null;
                   //return an instance of iEventDescription
                   return this.handledEvents[eventName];
              },
              getWidgetName:function(){
                  return this.name;                  
              },
              getPayloadDefs:function(){
                return this.payloadDefs;
              },
              getPayloadDef:function(name){
                  var payloadDef = this.payloadDefs[name];
                  if (typeof payloadDef == "undefined") return null;
                  return payloadDef;          
              },
              getPayloadDefNames:function(){
                  var arr = [];
                  var a;
                  for (a in this.payloadDefs){
                      arr.push(a);                      
                  }
                  return arr;
              },
              getSupportedModes:function(){
                   var temp = this.supportedModes;
                   if (typeof temp == "undefined" || temp == null) {
                       return null;
                   }
                   var arr = temp.split(" ");
                   return arr;
              },
              getIDescriptorItems:function(){
                   return null;
              },
              getMarkupByMode:function(mode){
                   return this.markup;
              },
              getWidgetEvents:function(){
                   return this.widgetEvents;
              },
              getIScope:function(){
                   return this.iScope;
              },
              getResources:function(){
                   return this.resources;
              },
              getDefaultLanguage:function(){
                   return "en";
              },
              getMarkup:function(){
                   return this.markup;
              },
              getAllowInstanceContent:function(){
                   return false;
              }
});

}

if(!dojo._hasResource["com.ibm.mm.iwidget.parserImpl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.parserImpl"] = true;

dojo.provide("com.ibm.mm.iwidget.parserImpl");




dojo.declare("com.ibm.mm.iwidget.parser.WidgetParser",null,  {
     parseWidgetDefinition: function(){   
         return null;
     }
});
dojo.declare("com.ibm.mm.iwidget.parser.legacyXMLParser",com.ibm.mm.iwidget.parser.WidgetParser,  {
    constructor:function(responseText){
        this.xmlStr = responseText;
    },
    namespaces: {
        "iw" : "http://www.ibm.com/iWidget"
    },
     parseWidgetDefinition: function(){  
         var xmlData = com.ibm.mm.enabler.xslt.loadXmlString(this.xmlStr);
         var markup = this.readMarkup( xmlData );	
         var itemSetsArr = this.readItemSets(xmlData);
         var uri = this.readContentURI(xmlData);
         var widgetEvents = this.readWidgetEvents(xmlData);
         var name = this.readName(xmlData);
         var iScope = this.readiScope(xmlData);
         var supportedModes = this.readSupportedModes(xmlData);
         var handledEvents = this.readPublicEvents(xmlData,"iw:handledEvents");
         var publishedEvents = this.readPublicEvents(xmlData,"iw:publishedEvents");
         var resources = this.readResources(xmlData);
         var payloadDefs = this.readPayloadDefs(xmlData);
         var iDescriptor = this.readIDescriptor(xmlData);
         return new com.ibm.mm.iwidget.widget.IWidgetDefinitionLegacyImpl(name,markup,iScope,itemSetsArr,widgetEvents,uri,supportedModes,publishedEvents,handledEvents,resources,payloadDefs,iDescriptor);
     },
     readMarkup: function ( /*XMLDocument*/xmlData ) {
                   com.ibm.mm.enabler.debug.entry( "legacyXMLParser.readMarkup", xmlData.text );
                   var contentsXPath = "/iw:iwidget/iw:content";
                   //we support html fragment only in iw:content
                   var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                   var defaultContent = "";					
                   if (nodes != null && nodes.length > 0) {
                       var rootNode =  nodes[0];
                       var child = rootNode.childNodes; 

                       for (var j=0; j<child.length; j++) {
                           var aNode = child[j];

                           //if this is CDATAsection   
                           if ( aNode.nodeType == 4 ) {
                               defaultContent = defaultContent.concat(aNode.nodeValue);
                           }
                           else if ( aNode.nodeType == 3 ){//textNode
                               defaultContent = defaultContent.concat(aNode.nodeValue);
                           }                           
                       }                          
                   }
                   com.ibm.mm.enabler.debug.exit("legacyXMLParser.readMarkup",defaultContent); 
                   return defaultContent;
               },
               readSupportedModes:function(/*XMLDocument*/xmlData){
                // read the iwidget's "supportedModes" attribute and store
                  // the string (no further parding here)
                  var root = xmlData.documentElement;
                    var modes = root.getAttribute("supportedModes");
                 // return null if not found
                    if (typeof modes == "undefined" || modes == null )return null;
                   return modes;                                                       
               },
               readItemSets: function ( /*XMLDocument*/xmlData ) {
                    com.ibm.mm.enabler.debug.entry("legacyXMLParser.readItemSets");

                    var itemSetsArr = {};
                    var contentsXPath = "/iw:iwidget/iw:itemSet";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                    for (var i=0; i< nodes.length ;i++) {
                        var aNode =  nodes[i];
                        var name = aNode.getAttribute("name");
                        var onItemSetChanged = aNode.getAttribute("onItemSetChanged");

                        var itemSetWrapper = {name:name,onItemSetChanged:onItemSetChanged};
                        itemSetWrapper.items={};
                        var child = aNode.childNodes; 
                        for (var j=0; j<child.length; j++) {
                            var aItemNode = child[j];
                             if ( aItemNode.nodeType == 1) {
                                 var isReadOnly = aItemNode.getAttribute("readOnly");
                                 com.ibm.mm.enabler.debug.entry("legacyXMLParser.readItemSets found attribute name:"+aItemNode.getAttribute("name")+" value:"+aItemNode.getAttribute("value")); 
                                 var anItem = {id:aItemNode.getAttribute("name"),value:aItemNode.getAttribute("value"),readOnly:isReadOnly};
                                 itemSetWrapper.items[anItem.id] =anItem;
                             }
                        } 
                        itemSetsArr[name]=itemSetWrapper;
                    }
                    com.ibm.mm.enabler.debug.exit("legacyXMLParser.readItemSets");
                    return itemSetsArr;
               },
               readPayloadDefs: function ( /*XMLDocument*/xmlData ) {
                    com.ibm.mm.enabler.debug.entry("legacyXMLParser.readPayloadDefs");
                    var payloadDefsArr = {};
                    var contentsXPath = "/iw:iwidget/iw:payloadDef";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                    for (var i=0; i< nodes.length ;i++) {
                        var aNode =  nodes[i];
                        var payloadDef = com.ibm.mm.iwidget.utils.getPayloadDef(aNode);                                                                                 
                        payloadDefsArr[payloadDef.name]=payloadDef;
                    }
                    com.ibm.mm.enabler.debug.exit("legacyXMLParser.readPayloadDef ",nodes.length+ " payloadDefs are saved "); 
                    return payloadDefsArr;
               },
               readName: function(/*XMLDocument*/xmlData){
                    var root = xmlData.documentElement;
                    var name = root.getAttribute("name");
                    if (typeof name == "undefined" || name == null ) return null;
                    return name;
               },
               //this attribute is a convenience for an extremely common iwidget attribute, if specifies a URI which the iwidget will use to fetch data or markup which it will present to the user
               readContentURI: function(/*XMLDocument*/xmlData){
                    var root = xmlData.documentElement;
                    var uri = root.getAttribute("contentURI");
                    if (typeof uri == "undefined" || uri == null ) return null;
                    return uri;
               },
               readiScope: function(/*XMLDocument*/xmlData){
                    var root = xmlData.documentElement;
                    var iScope = root.getAttribute("iScope");
                    if (typeof iScope == "undefined" || iScope == null ) return null;
                    return iScope;
               },
               readWidgetEvents: function(/*XMLDocument*/xmlData){
                   //read all teh onSth event
                   var root = xmlData.documentElement;
                   var widgetEvents = {};
                   var attributes = root.attributes;
                   for (var i=0;i<attributes.length;i++)
                   {
                      var event = attributes[i];

                      if (event.name.indexOf ("on") ==0)
                      {
                          var handler = event.value;
                          if (typeof handler != "undefined" && handler != null ) widgetEvents[event.name] = handler; 
                       }
                    }                      
                   return widgetEvents;                    
               },               
               readPublicEvents:function(/*XMLDocument*/xmlData,/*String*/eventType){
			   //returns iEventDescriptionImpl(name,onEvent,payloadType,description)
                    var contentsXPath = "/iw:iwidget/"+eventType;
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                    if (typeof nodes != "undefined" && nodes != null && nodes.length !=0 ){
                        var events = {};
                        var node = nodes[0];
                        var children = node.childNodes;
                        for (var j=0;j<children.length;j++){
                            var eventNode = children[j];
                            if ( eventNode.nodeType == 1) {
                            //todo. handle aliases
                            var iEventDescription=new com.ibm.mm.iwidget.iEventDescriptionImpl(eventNode.getAttribute("eventName"),eventNode.getAttribute("onEvent"),eventNode.getAttribute("payloadType"),eventNode.getAttribute("description"));
                            events[eventNode.getAttribute("eventName")]=iEventDescription; 
                            }                            
                        }                         
                    }
                    if (!events)return null;
                    return events;
                },
                readResources:function(/*XMLDocument*/xmlData){
                    var resourcePath = "/iw:iwidget/iw:resource";
                    var resources = [];
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(resourcePath, xmlData,this.namespaces);
                    if (typeof nodes != "undefined" && nodes != null && nodes.length !=0 ){
                        for (var i=0; i<nodes.length;i++){
                            var node = nodes[i];
                            var resource = {};
                            resource["name"] = node.getAttribute("resourceName");
                            resource["src"] = node.getAttribute("uri");
                            resource["version"] = node.getAttribute("version");
                            resource["callback"] = node.getAttribute("callback");     
                            resource["mimetype"] = node.getAttribute("mimetype");
                            resources[i]=resource;           
                        }                    
                    }
                    return resources;
                },
                readIDescriptor:function(/*XMLDocument*/xmlData){
                     //don't support this in legacy
                     return null;
                }

});

dojo.declare("com.ibm.mm.iwidget.parser.standardXMLParser",com.ibm.mm.iwidget.parser.WidgetParser,  {
    constructor:function(responseText){
        this.xmlStr = responseText;
    },
    namespaces: {
        "iw" : "http://www.ibm.com/xmlns/prod/iWidget"
    },
    reservedAttributes:{
        iScope:"iScope",
        supportedModes:"supportedModes",
        id:"id",
        allowInstanceContent:"allowInstanceContent",
        lang:"language",
        "xmlns:iw":"xmlns:iw"      
    },
     parseWidgetDefinition: function(){  
         var xmlData = com.ibm.mm.enabler.xslt.loadXmlString(this.xmlStr);
         var widgetDef = this.readRootElement(xmlData);  
         widgetDef.markup = this.readMarkup( xmlData );  
         widgetDef.itemSetsArr = this.readItemSets(xmlData);
         //widgetDef.handledEvents = this.readPublicEvents(xmlData,"handled");
         //widgetDef.publishedEvents = this.readPublicEvents(xmlData,"published");
		 widgetDef.publicEvents = this.readPublicEvents(xmlData);
         widgetDef.resources = this.readResources(xmlData);
         widgetDef.payloadDefs = this.readPayloadDefs(xmlData);
         widgetDef.eventDescriptions = this.readEventDescriptions(xmlData);
		 //widgetDef.xmlStr = this.xmlStr;
         return new com.ibm.mm.iwidget.widget.IWidgetDefinitionImpl(widgetDef,this.xmlStr);
     },
     readRootElement:function( /*XMLDocument*/xmlData ) {
          var widgetDef = {};
           var root = xmlData.documentElement;
           var modes = root.getAttribute("supportedModes");
           // return null if not found
           if (typeof modes == "undefined" || modes == null )modes="view";
           widgetDef.supportedModes = modes;  

           var name = root.getAttribute("id");
           if (typeof name == "undefined" || name == null ) name=null;
           widgetDef.id = name;
           widgetDef.name = name;

           var temp = root.getAttribute("allowInstanceContent");
           var allowInstanceContent = false;
           if (typeof temp != "undefined" && temp != null  && temp == "true") allowInstanceContent=true ;
           widgetDef.allowInstanceContent = allowInstanceContent;  

           var lang = root.getAttribute("language");
           if (typeof lang == "undefined" || lang == null ) lang="en";
           widgetDef.lang=lang;

           var widgetEvents = {};   
           var attributes = root.attributes;
           for (var i=0;i<attributes.length;i++)
           {
                var event = attributes[i];
                if (event.name.indexOf ("on") ==0)
                {
                    var handler = event.value;
                    if (typeof handler != "undefined" && handler != null ) widgetEvents[event.name] = handler; 
                 }
           } 
           widgetDef.widgetEvents = widgetEvents;

           var iScope = root.getAttribute("iScope");
           if (typeof iScope == "undefined" || iScope == null ) iScope=null;
           widgetDef.iScope = iScope;

           var iDescriptorItems = iwConstants.iDescriptorItems;
           var iDescriptor = {};
           for (var i in iDescriptorItems) {
               var name = iDescriptorItems[i];
               var value = root.getAttribute(name);
               iDescriptor[name] = value;
           }
           widgetDef.iDescriptor = iDescriptor;

           var simpleAttributes = {};
           var attributes = root.attributes;
           for (var i=0;i<attributes.length;i++)
           {
                var att = attributes[i];
                if (att.name.indexOf ("on") !=0 && !iwConstants.iDescriptorItems[att.name] && !this.reservedAttributes[att.name])
                {
                    var value = att.value;
                    if (typeof value != "undefined" && value != null ) simpleAttributes[att.name] = value; 
                 }
           } 
           widgetDef.simpleAttributes = simpleAttributes;
           return widgetDef;
     },
     readMarkup: function ( /*XMLDocument*/xmlData ) {
                   com.ibm.mm.enabler.debug.entry( "standardXMLParser.readMarkup", xmlData.text );
                   var contentsXPath = "/iw:iwidget/iw:content";
                   //we support html fragment only in iw:content
                   var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                   var contents = {};
                   var defaultContent = "";	 
                   var mode = null;
                   if (nodes != null && nodes.length > 0) {
                       for (var i=0;i<nodes.length;i++) {
                           var rootNode =  nodes[i];
                           var child = rootNode.childNodes; 
                           
                           for (var j=0; j<child.length; j++) {
                               var aNode = child[j];

                               //if this is CDATAsection   
                               if ( aNode.nodeType == 4 ) {
                                   defaultContent = defaultContent.concat(aNode.nodeValue);
                               }
                               else if ( aNode.nodeType == 3 ){//textNode
                                   defaultContent = defaultContent.concat(aNode.nodeValue);
                               }                           
                           }
                           mode = rootNode.getAttribute("mode");
                           if (typeof mode == "undefined" || mode == null) {
                               mode = "view";      //assign default mode
                               break;
                           }
                           contents[mode] = defaultContent;
                           defaultContent = "";
                       }
                   }
                   com.ibm.mm.enabler.debug.exit("standardXMLParser.readMarkup",contents); 
                   return contents;
               },
               readItemSets: function ( /*XMLDocument*/xmlData ) {
                    com.ibm.mm.enabler.debug.entry("standardXMLParser.readItemSets");

                    var itemSetsArr = {};
                    var contentsXPath = "/iw:iwidget/iw:itemSet";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                    for (var i=0; i< nodes.length ;i++) {
                        var aNode =  nodes[i];
                        var name = aNode.getAttribute("id");
                        var onItemSetChanged = aNode.getAttribute("onItemSetChanged");
                        var temp = aNode.getAttribute("private");
                        var isPrivate = false;
                        if (typeof temp != "undefined" && temp != null && temp =="true") {
                            isPrivate = true;
                        }

                        var descriptionRef = aNode.getAttribute("description");

                        var itemSetWrapper = {name:name,onItemSetChanged:onItemSetChanged,isPrivate:isPrivate};
                        itemSetWrapper.items = {};
                        
                        var child = aNode.childNodes; 
                        for (var j=0; j<child.length; j++) {
                            var aItemNode = child[j];
                             if ( aItemNode.nodeType == 1) {
                                 var isReadOnly = aItemNode.getAttribute("readOnly");
                                 com.ibm.mm.enabler.debug.entry("standardXMLParser.readItemSets found attribute name:"+aItemNode.getAttribute("name")+" value:"+aItemNode.getAttribute("value")); 
                                 if (typeof isReadOnly != "undefined" && isReadOnly != null && isReadOnly=="true") {
                                     isReadOnly = true;
                                 }
                                 else isReadOnly = false;
                                 var id = aItemNode.getAttribute("id");
                                 var value = aItemNode.getAttribute("value");
                                 var anItem = {id:id,value:value,readOnly:isReadOnly};
                                 itemSetWrapper.items[id]=anItem;
                             }
                        } 
                        itemSetsArr[name]=itemSetWrapper;
                    }
                    com.ibm.mm.enabler.debug.exit("standardXMLParser.readItemSets");
                    return itemSetsArr;
               },
               readPayloadDefs: function ( /*XMLDocument*/xmlData ) {
                    com.ibm.mm.enabler.debug.entry("standardXMLParser.readPayloadDefs");
                    var payloadDefsArr = {};
                    var contentsXPath = "/iw:iwidget/iw:payloadDef";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                    for (var i=0; i< nodes.length ;i++) {
                        var aNode =  nodes[i];
                        var payloadDef = com.ibm.mm.iwidget.utils.getPayloadDef(aNode);                                                                                 
                        payloadDefsArr[payloadDef.name]=payloadDef;
                    }
                    com.ibm.mm.enabler.debug.exit("standardXMLParser.readPayloadDef ",nodes.length+ " payloadDefs are saved "); 
                    return payloadDefsArr;
               },
               readPublicEvents:function(/*XMLDocument*/xmlData,/*String*/eventType){
				//return empty object if no events is defined
			    //var contentsXPath = "/iw:iwidget/iw:event[@"+eventType+"]";
					var contentsXPath = "/iw:iwidget/iw:event";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(contentsXPath, xmlData,this.namespaces);
                    if (typeof nodes != "undefined" && nodes != null && nodes.length !=0 ){
                        var events = {};
                        for (var j=0;j<nodes.length;j++){
                            var eventNode = nodes[j];
                            if ( eventNode.nodeType == 1) {
                            //todo. handler attributes
                            var iEvent={};
							var attributes = eventNode.attributes;
							for (var i=0;i<attributes.length;i++)
							{
								var att = attributes[i];
								var name = att.name;
								var value = att.value;
								if (name == "eventDescName"  ) name = "description"; //backward compatibility
								if (name == "handled" ) name = "isHandled"; //align with js representation
 								if (name == "published") name = "isPublished"; //align with js representation
								if (typeof (value) != "undefined" && value != null) iEvent[name]=value;												
							}				                             
                            events[iEvent.id] = iEvent;
                            }                            
                        }                         
                    }
                    if (!events)return {};
                    return events;
                },
                readResources:function(/*XMLDocument*/xmlData){
                    var resourcePath = "/iw:iwidget/iw:resource";
                    var resources = [];
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(resourcePath, xmlData,this.namespaces);
                    if (typeof nodes != "undefined" && nodes != null && nodes.length !=0 ){
                        for (var i=0; i<nodes.length;i++){
                            var node = nodes[i];
                            var resource = {};
                            resource[iwConstants.RESOURCE.id] = node.getAttribute("id");
							var src = node.getAttribute("src");
							if (typeof src == "undefined" || src == null) src = node.getAttribute("uri");
                            resource[iwConstants.RESOURCE.src] = src;
                            resource[iwConstants.RESOURCE.version] = node.getAttribute("version");
                            resource[iwConstants.RESOURCE.callback] = node.getAttribute("callback");     
                            resource[iwConstants.RESOURCE.mimetype] = node.getAttribute("mimeType");
                            resources[i]=resource;           
                        }                    
                    }
                    return resources;
                },
                readEventDescriptions:function(/*XMLDocument*/xmlData){
		             var eventDescriptionpath="iw:iwidget/iw:eventDescription";
                     var eventDescriptions = {};
                     var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(eventDescriptionpath, xmlData,this.namespaces);
                     if (typeof nodes != "undefined" && nodes != null && nodes.length !=0 ){
                       for (var i=0; i<nodes.length;i++){
                           var node = nodes[i];
                           var eventDescription = {};
                           var id =  node.getAttribute("id");   
                           eventDescription["id"] = id;
                           eventDescription["payloadType"] = node.getAttribute("payloadType");
                           eventDescription["description"] = node.getAttribute("description");
                           eventDescription["descriptionURI"] = node.getAttribute("descriptionURI");     
                           eventDescription["lang"] = node.getAttribute("lang");
                           eventDescription["aliases"] = node.getAttribute("aliases");
                           eventDescription["descriptions"]={};
                           var children = node.childNodes;
                           for (var j=0;j<children.length;j++) {
                               var aNode = children[j];
                               if ( aNode.nodeType == 1) {
                                   var temp = {};
                                   //temp["lang"] = aNode.getAttribute("lang");
                                   temp["description"] = aNode.getAttribute("description");
                                   temp["title"] = aNode.getAttribute("title");
                                   temp["descriptionURI"] = aNode.getAttribute("descriptionURI");
                                   eventDescription["descriptions"][aNode.getAttribute("lang")] = temp; 
                                }
                           } 
                           eventDescriptions[id]=eventDescription;           
                       }                    
                     } 
                     return eventDescriptions;
                }
});



}

if(!dojo._hasResource["com.ibm.mm.iwidget.parser"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.parser"] = true;
dojo.provide("com.ibm.mm.iwidget.parser");



dojo.declare("com.ibm.mm.iwidget.parser.WidgetParserFactory",null,  {
     getWidgetParser: function(responseText){
         var xmlStr = responseText.replace(/^\s+/, "").replace(/\s+$/, "");
         var isXML = this._isXML(xmlStr);
         var isLegacy = this._isLegacy(xmlStr);
         if ( isXML && isLegacy ) {
             return  new com.ibm.mm.iwidget.parser.legacyXMLParser(xmlStr);
         } else if ( isXML && !isLegacy) {
             return new com.ibm.mm.iwidget.parser.standardXMLParser(xmlStr);
         }
		 return null;
     },
     _isXML: function(responseText){
          var isXML = true;
          var index = responseText.indexOf("=\"http://www.w3.org/1999/xhtml\"");
          if (index != -1) {
               isXML = false;
          }
          com.ibm.mm.enabler.debug.log("parser._isXML", isXML);
          return isXML;
     },
     _isLegacy: function(responseText){
          var isLegacy = true;
          var index = responseText.indexOf("=\"http://www.ibm.com/xmlns/prod/iWidget\"");
         if (index != -1) {
              isLegacy = false;
         }
         com.ibm.mm.enabler.debug.log("parser._isLegacy", isLegacy);
         return isLegacy;
     }
});    

com.ibm.mm.iwidget.parser.WidgetParserFactory = new com.ibm.mm.iwidget.parser.WidgetParserFactory();

}

if(!dojo._hasResource["com.ibm.mm.iwidget.services.widgetloadservice"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.services.widgetloadservice"] = true;
dojo.provide("com.ibm.mm.iwidget.services.widgetloadservice");



dojo.declare( "com.ibm.mm.iwidget.services.WidgetLoadServiceImpl",
			  null,
			    { constructor:function(){
					//loadModelus to keep track that if a resource has been loaded already
					this.widgetDef = {};  //cached as url-widgetdefinition 
					this.LOADING_TOKEN = "LOADING_TOKEN";
					this.LOADING_ERROR_TOKEN = "LOADING_ERROR_TOKEN";
					this.waitingqueue = {};
				}, 
			  	getWidgetXML: function ( /*String*/ widgetUrl,/*boolean*/sync, callbackfn,/*String*/ widgetId) {
					// summary: Retrieves the WidgetInfo for the given widget url.
					// widgetUrl: a widget URL, should come directly from the microformat or from alias
               					
					var wInfo = this.widgetDef[widgetUrl];
					if ( typeof wInfo != "undefined" && wInfo != null && wInfo == this.LOADING_TOKEN){
						if (typeof (this.waitingqueue[widgetUrl]) == "undefined" || this.waitingqueue[widgetUrl] == null){
						this.waitingqueue[widgetUrl] = [];
						}
						var entry = {id:widgetId,cb:callbackfn};
						this.waitingqueue[widgetUrl].push(entry);
						return;
					}else if (typeof wInfo != "undefined" && wInfo != null && wInfo.error && wInfo.error == this.LOADING_ERROR_TOKEN){
						return this.handleCallback(callbackfn,wInfo.data,wInfo.status);
					}else if (typeof wInfo != "undefined" && wInfo != null ){
						return this.handleCallback(callbackfn,wInfo,"200");						
					}
					
					this.widgetDef[widgetUrl] = this.LOADING_TOKEN;					
                    var me = this;
					var contentUrl = widgetUrl;
                    if (contentUrl.indexOf("http") === 0) {
						contentUrl = com.ibm.mm.enabler.utilities.rewriteURL(contentUrl);
					}
                    var args = {
                        url: contentUrl,
                        load: function( data,ioArgs ) {
						    var xhr = ioArgs.xhr;
							var parser = com.ibm.mm.iwidget.parser.WidgetParserFactory.getWidgetParser(xhr.responseText);
							var wInfo = parser.parseWidgetDefinition();
							me.widgetDef[widgetUrl] = wInfo;		
							
							me.handleCallback(callbackfn,wInfo,xhr.status,xhr);		
							//check waiting queue
							var queue = me.waitingqueue[widgetUrl];
							if (queue && queue != null){
								for (var i in queue) {
									me.handleCallback(queue[i].cb, wInfo, xhr.status, xhr);
								}	
								 me.waitingqueue[widgetUrl] = null;								
							}
                        },
                        error : function(data, ioArgs){
								var xhr = ioArgs.xhr;
								me.widgetDef[widgetUrl] = {error:me.LOADING_ERROR_TOKEN,data:data,status:xhr.status};	
								me.handleCallback(callbackfn,data,xhr.status,xhr);	
								var queue = me.waitingqueue[widgetUrl];
								if (queue && queue != null){
								for ( var i in queue){
									me.handleCallback(queue[i].cb,data,xhr.status,xhr);	
								}	
								 me.waitingqueue[widgetUrl] = null;											 
								}								
		                 }, 
                        handleAs: "text", //tells framework this is an text document
						sync:sync //default is false, set to true if it's a blocking synchronous request
                    };
                    dojo.xhrGet(args); 
					return;
				},         
		
				handleCallback:function(callbackfn,data,statuscode,xhr){
						if(callbackfn) callbackfn( data,statuscode,xhr );  
				}
      		}
);   



}

if(!dojo._hasResource["com.ibm.mm.services"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.services"] = true;
dojo.provide("com.ibm.mm.services");













dojo.declare("com.ibm.mm.services.ServiceManager",com.ibm.mashups.services.ServiceManager,
    {
    constructor:function(){
        this._serviceEntries= {};
         
        //set default values
        this._serviceEntries["configService"] = 
            { name:      "configService",
              baseClass: "com.ibm.mm.enabler.services.ConfigServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.enabler","services.js")};
        this._serviceEntries["eventService"] = 
            { name:      "eventService",
              baseClass: "com.ibm.mm.iwidget.services.EventServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.iwidget","services/eventservice.js")};
        this._serviceEntries["queryService"] = 
            { name:      "queryService",
              baseClass: "com.ibm.mm.iwidget.services.QueryServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.iwidget","services/qservice.js")};
        this._serviceEntries["persistentAttributesFactoryService"] = 
            { name:      "persistentAttributeFactoryService",
              baseClass: "com.ibm.mm.iwidget.services.PersistentAttributesFactoryServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.iwidget","services/internalservices.js")};
        this._serviceEntries["iwidgetFragmentService"] = 
            { name:      "iwidgetFragmentService",
              baseClass: "com.ibm.mm.iwidget.services.IWidgetFragmentServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.iwidget","services/internalservices.js")};
        this._serviceEntries["widgetLoadService"] = 
            { name:      "widgetLoadService",
              baseClass: "com.ibm.mm.iwidget.services.WidgetLoadServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.iwidget","services/widgetloadservice.js")};
        this._serviceEntries["resourceLoadService"] = 
            { name:      "resourceLoadService",
              baseClass: "com.ibm.mm.iwidget.services.ResourceLoadServiceImpl",
              path:      dojo.moduleUrl("com.ibm.mm.iwidget","services/internalservices.js")};

        //allow overwritten if ibmConfig.loadServices is set
        if (typeof ibmConfig != "undefined" && ibmConfig != null && typeof ibmConfig.additionalServices != "undefined" && 
            ibmConfig.additionalServices != null && ibmConfig.additionalServices == true) {
            var entries = dojo.fromJson(ibmConfig.additionalServices);
            for (var i in entries){
                var anEntry = entries[i];
                me._serviceEntried[anEntry.name] = anEntry;
            }
        }
    },
    getService: function(serviceName){
        var serviceEntry = this._serviceEntries[serviceName];
        if ( typeof serviceEntry != "undefined" && serviceEntry !== null ){
            var serviceHandler = serviceEntry.serviceHandler;
            if (typeof serviceHandler == "undefined" || serviceHandler === null ){
                // assume js is already loaded, create service object
                serviceHandler = this._createService(serviceEntry);
                if (typeof serviceHandler == "undefined" || serviceHandler === null) {
                    this._loadScript(serviceEntry);
                    serviceHandler = this._createService(serviceEntry);
                }
            }  
            if ( typeof serviceHandler != "undefined" && serviceHandler !== null) {
                this._serviceEntries[serviceName]["serviceHandler"] = serviceHandler;
                return serviceHandler;
            }
        }
        return null;
    },
	setService:function(serviceName,baseClass,path){
		//create new service or overwrite an existing service
		var serviceEntry = this._serviceEntries[serviceName];
		if (serviceEntry != null) delete this._serviceEntries[serviceName];
		this._serviceEntries[serviceName] = 
            { name:      serviceName,
              baseClass: baseClass,
              path:      path};		
	},
    _loadScript: function(serviceEntry) {
        var me = this;
        dojo.xhrGet({
            url: serviceEntry.path,
            handleAs: "text",
            sync: true,
            load:function(result) {
                dojo.eval(result);
            },
            error:function(data,ioArgs) {
                com.ibm.mm.enabler.debug.error("com.ibm.mm.iwidget.services.ServiceManager","error loading service:"+serviceEntry.name,data);			 	
            }
        });
    },
    _createService:function(serviceEntry)
    {
        var service = null;
        try{
             service = dojo.eval("new "+serviceEntry.baseClass+"();");
        }
        catch (err){
            com.ibm.mm.enabler.debug.log("services.getService"," failed to create service error detail: "+err.description);	
        }
        return service;
    }
});

com.ibm.mashups.services.ServiceManager = new com.ibm.mm.services.ServiceManager();
window.serviceManager = com.ibm.mashups.services.ServiceManager;
// temp
//com.ibm.mashups.iwidget.services.ServiceManager = com.ibm.mashups.services.ServiceManager;

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.navigationstate"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.navigationstate"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.navigationstate" );

dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateModelFactory");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateModel");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateNode");
dojo.provide("com.ibm.mashups.enabler.model.state.AccessorFactory");
dojo.provide("com.ibm.mashups.enabler.model.state.Accessor");
dojo.provide("com.ibm.mashups.enabler.model.state.PageAccessor");
dojo.provide("com.ibm.mashups.enabler.model.state.SpaceAccessor");
dojo.provide("com.ibm.mashups.enabler.model.state.WidgetAccessor");
dojo.provide("com.ibm.mashups.enabler.model.state.NavigationStateProcessor");



/**
 * Interface for a NavigationStateModelFactory.
 * var navigationStateModel=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.NavigationStateModelFactory", null, {
  /**
    * @private
    */
    constructor:function () {
    },
    
    /**
     * Returns  the NavigationStateModel of Mashup Server.
     * @type com.ibm.mashups.enabler.model.state.NavigationStateModel 
     * @return {com.ibm.mashups.enabler.model.state.NavigationStateModel} The NavigationStateModel, never <code>null</code>.
     */
	getNavigationStateModel:function() {
	}
});

/**
 * Interface for a Navigation state model.<br/>
 * AccessorFactory API should be used to read/write navigation state within NavigationStateModel.</code><br/>
 * <code>var navStateModel=com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();</code><br/>
 * <code>var widgetAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(navStateModel);</code><br/>
 * <code>widgetAccessor.setSize("200","300");</code><br/>
 * <code>var deferred = navStateModel.commit();</code><br/>
 * <code>deferred.setFinishedCallback(cb);</code><br/>
 * <code>deferred.start();</code><br/> 
 * 
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.NavigationStateModel", null,     {
  /**
    * @private
    */
    constructor:function () {
    },
  /**
   * Event that will be published when navigation state is committed.
   * <b>Event</b>: ONNAVSTATEUPDATED<br/>
   * <b>Value</b>:"onNavStateUpdated"<br/>
   * For example: <br/>
   * An widget could subscribe to this event by using following SPI:<br/>
   * var eventService = com.ibm.mashups.services.ServiceManager.getService("eventService");<br/>
   * eventService.subscribeEvent("onNavStateUpdated",scope,"mycallbackfn");<br/>
   * In the callback function, an widget should use Accessor api to get the navstate they're interested </br>
   * Following example use PageAccessor as an example<br/>
   * 	var pageAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getPageAccessor(navigationStateModel);<br/>
   *	var pageId = pageAccessor.getPageID();		<br/> 
   * @type String
   */
	ONNAVSTATEUPDATED:"com.ibm.mashups.enabler.model.state.onNavStateUpdated",
  
   /**
   * Commits the modifications applied to this model. <br> 
   * After the model is committed successfully, this method must not be called 
   * again. The same is true for any other method modifying the model or its nodes.
   * @type com.ibm.mashups.enabler.Deferred 
   * @return {com.ibm.mashups.enabler.Deferred} A deferred object used to start this operation. The return value 
   * when executed through the deferred object is <code>null</code>
   */
    commit: function () {
        return new com.ibm.mashups.enabler.Deferred(); 
    },
  /**
   * Discards the modifications applied to this model. <br> 
   * @type void
   */
    discard: function () {
        return; 
    },
  /**
   * Dispose this model completely all the navigation state will be destroyed. <br>
   * @type void 
   */
    dispose: function () {
        return; 
    }
});

/**
 * Interface representing a NavigationStateNode.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.NavigationStateNode", com.ibm.mashups.enabler.Identifiable, {
  /**
    * @private
    */
    constructor:function () {
    },
	/**
     * Returns the value of this NavigationNode
     * @type Object
     * @return {Object} The value of the navigation node
     */
	get:function(){
	},
	 /**
     * Sets the value of navigation state node
     * @param {Object} value The value of the navigation state node
     * @type void
     */
	set:function(/*Object*/value){
	}
});

/**
 * Interface representing an AccessorFactory.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.AccessorFactory", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Returns the Accessor to access Page selection in each Space
     * @param {NavigationStateModel} navStateModel NavigationStateModel to get Space/Page Selection
     * @param {String} spaceId spaceId to getPage Selection    
     * @type com.ibm.mashups.enabler.model.state.PageAccessor
     * @return {com.ibm.mashups.enabler.model.state.PageAccessor} The PageAccessor of NavigationStateModel
     */
	getPageAccessor:function(navStateModel,spaceId) {
        // look for node in model and instatiate the Page Accessor with Node
	},
	 /**
     * Returns the Accessor to access Space selection
     * @param {NavigationStateModel} navStateModel NavigationStateModel to get Space Selection
     * @type com.ibm.mashups.enabler.model.state.SpaceAccessor
     * @return {com.ibm.mashups.enabler.model.state.SpaceAccessor} The SpaceAccessor of NavigationStateModel
     */
	getSpaceAccessor:function(navStateModel) {
	},
	/**
     * Returns the Widget Accessor to access Widget state information
     * @param {com.ibm.mashups.enabler.model.state.NavigationStateModel} navStateModel to Widget Navigation State
     * @param {String} widgetId to Widget Navigation State
      * @type com.ibm.mashups.enabler.model.state.WidgetAccessor
     * @return {com.ibm.mashups.enabler.model.state.WidgetAccessor} The WidgetAccessor of NavigationStateModel
     */
	getWidgetAccessor:function(navStateModel, widgetId) {
	},
   /**
     * Returns the Accessor to access Page mode of current page
     * @param {NavigationStateModel} navStateModel NavigationStateModel to get Space/Page Selection
     * @type com.ibm.mashups.enabler.model.state.PageModeAccessor
     * @return {com.ibm.mashups.enabler.model.state.PageModeAccessor} The PageModeAccessor of NavigationStateModel
     */
	getPageModeAccessor:function(navStateModel) {
        // look for node in model and instatiate the Page Accessor with Node
	}  

});

/**
 * Interface representing an Accessor.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.Accessor", null, {
  /**
      * @private
      */
    constructor:function () {
    }
});

/**
 * Interface representing an PageAccessor.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.PageAccessor", [com.ibm.mashups.enabler.model.state.Accessor] , {
  
    constructor:function (navStateModel,spaceid) {
    },
    /**
     * Returns the of the page within a space.
     * @type String
     * @return {String} The page id of provided space
     */
	getPageID:function() {
	},
	 /**
     * Sets the page of the space
     * @param {String} pageId id of page
     */
	setPageID:function(pageId) {
	}
});

/**
 * Interface representing an PageModeAccessor.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.PageModeAccessor", [com.ibm.mashups.enabler.model.state.Accessor] , {
  
  /**
    * VIEW mode of page, can be used as com.ibm.mashups.enabler.model.state.PageModeAccessor.VIEW with "view" as the actual value</br>
    * @type String
    */
  	VIEW:"view",
  /**
    * EDIT mode of page, can be used as com.ibm.mashups.enabler.model.state.PageModeAccessor.EDIT with "edit" as the actual value</br>
    * @type String
    */
	EDIT:"edit",
    constructor:function (navStateModel) {
    },
    /**
     * Returns the of the page mode of current page.
     * @type String
     * @return {String} The page mode of current page
     */
	getPageMode:function() {
	},
	 /**
     * Sets the page mode of the page
     * @param {String} pageMode The mode of the page
     */
	setPageMode:function(pageMode) {
	}
});
com.ibm.mashups.enabler.model.state.PageModeAccessor.VIEW = "view";
com.ibm.mashups.enabler.model.state.PageModeAccessor.EDIT = "edit";

/**
 * Interface representing a SpaceAccessor.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.SpaceAccessor", [com.ibm.mashups.enabler.model.state.Accessor], {
 
    constructor:function (navStateModel) {
    },
	/**
     * Returns the of the current space of Mashup.
     * @type String
     * @return {String} The spaceid
     */
	getSpaceID:function() {
	},
	/**
     * Sets the space
     * @param {String} spaceId id of space
     */
	setSpaceID:function(spaceId) {
	}
});

/**
 * Interface representing a WidgetAccessor. Reserved Widget Paramers:
 * "cp" : the reserved paremeter for widget customized state.
 * "h"  : the reserved paremeter for widget height.
 * "w"  : the reserved paremeter for widget width.
 * "st" : the reserved paremeter for widget window state. 
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.WidgetAccessor", [com.ibm.mashups.enabler.model.state.Accessor, com.ibm.mashups.enabler.Identifiable], {
  /**
      * @private
      */
    constructor:function (navStateModel, id) {
    },
	/**
     * Returns the widget id of the Widget
     * @type String
     * @return {String} ID of required Widget
     */
	getWidgetID:function() {
	},
	/**
     * Returns the state of the required widget state parameter
     * @param {String} key The name of the required parameter of Widget Navigation State
     * 				   "cp" is the reserved paremeter for widget customized state.
     * @type String
     * @return {String} Value of required parameter
     */
	getWidgetState:function(key) {
	},
	/**
     * Set the value of a widget state parameter
     * @param {String} key The name of the required parameter 
     * @param {String} value The value of the required parameter
     * @type void
     */
	setWidgetState:function(key,value){
	},
	/**
     * Remove a widget state parameter
     * @param {String} key The name of the required parameter 
     * @type void
     */
	removeWidgetState:function(key){
	},
	/**
     * Returns the window state of the required widget 
     * @type String
     * @return {String} The window state of the required widget following states are allowed: "normal","min","max"
     */
	getWindowState:function() {
	},
	/**
     * Set the window state of a widget
     * @param {String} windowState The window state of the required widget 
     * @type void
     */
	setWindowState:function(windowState) {
	},
	/**
     * Returns the size of the required widget 
     * @type Object
     * @return {Object} A JSON object representing the widget width/height, for example: <code>{w:"200",h:"400"}</code>
     */
	getSize:function() {
	},
	/**
     * Set the size of a widget
     * @param {String} width The width of the widget 
     * @param {String} height The height of the widget 
     * @type void
     */
	setSize:function(width, height) {
	}

});

/**
 * Interface representing NavigationStateProcessor.NavigationState is internally Represented as an JSON object.
 * Paramters are predefined.
 * {sid:{value:<sid>,params:{}},
 *  pid:{value:<pid>,params:{}},
 *  pageselection:{
 *	<spaceid>:{value:<pageid>,params:{lm:<timestamp>}},
 *	<spaceid>:{value:<pageid>,params:{lm:<timestamp>}}
 *	},
 *  wparams:{
 *  	<wid>:{value:{rp:{w:<"200">,h:<"300">,st:<"NORMAL">},cp:{<page:"3">}},params:{lm:<timestamp>}},
 *  	<wid>:{value:{rp:{w:<"300">,h:<"400">,st:<"MAX">},cp:{<page:"4">}},params:{lm:<timestamp>}}
 *  } 
 * }
 *
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.NavigationStateProcessor", null, {
	/**
     * Decode the url and store the state into a JSON Object. JSON object should be
     * pass into Callback.
     * <code>callback:function(state){};</code>
     * @param {String} url url string
     * @param {Function} callback callback function
     * @type void
     */
	decode:function(url,callback){
	},
	/**
     * Encode state object and generate fragment. Fragment should be passed into callback function.
     * pass into Callback.
     * <code>callback:function(fragment){};</code>
     * @param {Object} state JSON object representing Mashup state
     * @param {Function} callback callback function
     * @param {Object} oldState JSON object representing Mashup state before it gets updated
     * @type void
     */
	encode:function(state,callback,oldState){
	},
	/**
     * Encode state object and generate full url. Url should be passed into callback function.
     * pass into Callback.
     * <code>callback:function(url){};</code>
     * Sample parameter: {nohash:true}
     * if "nohash" is set to true,the returned url will not contain state in hash.
     * By default Lotus Mashups only supports url that contains navigation state in hash.  
     * Extensions can be added to support additional parameter by using extension registry.
     * 
     * @param {Object} state JSON object representing Mashup state
     * @param {Function} callback callback function
     * @param {JSON} params additional parameter in json format
     * @type void
     */
	generateUrl:function(state,callback,params){
	},
	/**
     * Preprocess could be used to filter the original state. For example, 
     * pulling more state information that's cached in cookie.
     * The final state should be passed into callback.
     *   <code>callback:function(state){};</code>
     * @param {Object} state JSON object representing Mashup state
     * @param {Function} callback callback function
     * @type void
     */
	preprocess:function(state,callback){
	},
	/**
     * Dispose the any navigation state that's persisted. Callback is executed when dispose action is done. 
     * <code>callback:function(){};</code>
     * @param {Function} callback callback function
     * @type void
     */
	dispose:function(callback){
	},
	/**
     * Postprocess could be used to filter the original state before url is generated.
     * For example,some state information should be persisted into cookie.
     * The final state should be passed into callback.
     *   <code>callback:function(state){};</code>
     * @param {Object} state JSON object representing Mashup state
     * @param {Function} callback callback function
     * @param {Object} oldState JSON object representing Mashup state before it gets updated
     * @type void
     */
	postprocess:function(state,callback,oldState){
	}
});

/**
 * Interface representing an UrlGeneratorFactory.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.UrlGeneratorFactory", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Returns the url generator to get the url based on navigationstatemodel
     * @type com.ibm.mashups.enabler.model.state.UrlGenerator
     * @return {com.ibm.mashups.enabler.model.state.UrlGenerator} The url generator based on navigation state model
     */
	getUrlGenerator:function() {
	}
});	

/**
 * Interface representing an UrlGenerator.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.model.state.UrlGenerator", null, {
  /**
      * @private
      */
    constructor:function () {
    },
    /**
     * Returns the url based on navigation state model and additional parameters.
     * Sample parameter: {nohash:"true"}
     * if "nohash" is set to "true",the returned url will not contain state in hash.
     * 
     * @param {NavigationStateModel} navStateModel NavigationStateModel to generate url
     * @param {Function} callback callback funtion is invoked when url is generated, url will be passed into callback
     * @param {JSON} params additional parameter in json format
     * @type String
     * @return {String} The url that's generated based on navigationStateModel
     */
	getUrl:function(navStateModel,callback,params) {
	}
});	

}

if(!dojo._hasResource["com.ibm.mm.enabler.model.navigationstate"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.model.navigationstate"] = true;
dojo.provide( "com.ibm.mm.enabler.model.navigationstate" );


dojo.declare( "com.ibm.mm.enabler.model.state.CookieManager", null, {
	//cookie limit is 4096byte(at least for IE)
	//cookie is persisted per user, cookiename uid+"_state"
	//need to split if we run into problems
	/* {sid:{value:<sid>,params:{}},
 	 *  pid:{value:<pid>,params:{}},
     *  pageselection:{
     *	<spaceid>:{value:<pageid>,params:{lm:<timestamp>}},
     *	<spaceid>:{value:<pageid>,params:{lm:<timestamp>}}
     *	},
     *  wparams:{
     *  	<wid>:{value:{rp:{w:<"200">,h:<"300">,st:<"NORMAL">}},params:{lm:<timestamp>}},
     *  	<wid>:{value:{rp:{w:<"300">,h:<"400">,st:<"MAX">}},params:{lm:<timestamp>}}
     *  } 
     * }
     */
	constructor:function () {
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
		this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);

		this._dirty = false;	
		this.configSvr = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
		this.cookiePath = window.location.pathname;
    },
	disposeState:function(){
		var id = this._getCookieID();
		if (id != null && dojo.cookie(id) != null) {
			dojo.isIE?dojo.cookie(id,null,{expires:-1}):
			dojo.cookie(id, null, {
				expires: -1,
				path: this.cookiePath
			});
		}
		if (this._state) {
			delete this._state;
		}
		this._dirty = false;	
	},
    _getCookieID:function(){
    	//get user id
    	if (!this._cookieID ){
  			var uid = this.configSvr.getValue(com.ibm.mashups.enabler.services.ConfigConstants.USER);
			if (!uid || (uid && uid == "null")) return null;
		   	this._cookieID = uid+"_state";
    	}
    	return this._cookieID;    	
    },
    _init:function(){
		if (this._getCookieID() == null) {
			this._state = {};
			return;
		}	
    	if (dojo.cookie.isSupported()){
			if (dojo.cookie(this._getCookieID()) != null && dojo.fromJson(dojo.cookie(this._getCookieID())) != null){
				this._state =  dojo.fromJson(dojo.cookie(this._getCookieID()));			
        	}		
		}
		if (! this._state) this._state = {};
    },	
   	getState:function(id){
    	//if id is not defined, return the whole state object
		if (!this._state) this._init();
    	if (!id) return this._state;
    	if (this._state[id]) return this._state[id];
    	return null;
    },
    setState:function(id,/*object*/value){
	//pid,sid,pageselection,wparams
		if (! this._state ) this._state = {};
    	this._state[id] = value; //create/overwrite    	
		this._dirty = true;
    },
    removeState:function(id){
    	if(this._state[id]) {
		delete this._state[id];
		this._dirty = true;
		}
    },
    commit:function(){
    	//cookie expiration?
    	if (this._dirty) {
			if (this._getCookieID() == null) {
				this._dirty = false;
				return;
			}
    		if (dojo.cookie.isSupported()){
				dojo.isIE? dojo.cookie(this._getCookieID(), dojo.toJson(this._state),{expires:3652}):  
    			dojo.cookie(this._getCookieID(), dojo.toJson(this._state),{expires:3652, path: this.cookiePath});
    		}
    		this._dirty = false;
    	}	
    }	
});
com.ibm.mashups.enabler.model.state.CookieManager = new com.ibm.mm.enabler.model.state.CookieManager();

dojo.declare( "com.ibm.mm.enabler.model.state.NavigationStateProcessorImpl", com.ibm.mashups.enabler.model.state.NavigationStateProcessor, {
	  
    constructor:function () {
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
		this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
		if(this.bIsLoggable == true) this.LOGGER.entering("constructor");

		this.configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
		var persistenceURL = this.configService.getValue(this.configService.NAVSTATE_PERSISTENCE_URL);
		if (persistenceURL) this.persistenceURL = this._getAssociativeArray(persistenceURL);
		var persistencePSTORE = this.configService.getValue(this.configService.NAVSTATE_PERSISTENCE_PSTORE);
		if (persistencePSTORE) this.persistencePSTORE = this._getAssociativeArray(persistencePSTORE);
		var limit = this.configService.getValue(this.configService.NAVSTATE_PERSISTENCE_URL_LIMIT);
		var index = 10;
		if (limit && limit != null){
			 index = parseInt(limit);
			}
		this.urlpersistenceLIMIT = index;	
		this.isHuffmannEnabled = this.configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.NAVSTATE_HUFFMANNENCODE_ENABLED);
   },
   HUFFMANN_PREFIX:"mashup:huffman/",
   dispose:function(callback){
   		var cookieManager = com.ibm.mashups.enabler.model.state.CookieManager;
 		var temp = cookieManager.disposeState();		
		if(callback)callback();   	
   },
   _getAssociativeArray:function(array){
   		var obj = {};
		if (dojo.isString(array)==true){
			obj[array]= array;
			return obj;
		}
   	   for (var i in array){
	   	  var value = array[i];
		  obj[value] = value;
	   }
	   return obj;
   },
   	decode:function(url,callback) {
		if (this.bIsLoggable == true) {
			this.LOGGER.entering("decode");
			this.LOGGER.trace("decode","url is "+url);
		}
		
		var hash = this._getHash(url);
		if(hash != null){
			if (url.indexOf("#") != -1){
				if (url.lastIndexOf("&") == (url.length-1)){
					url = url.concat(hash);					
				}else{
					url = url.concat("#");
					url = url.concat(hash);					
				}
			}else{
				url = url.concat("#");
				url = url.concat(hash);
			}
		}
		
    	var state = {};
    	//check if it's huffman encoded, 
    	//do huffman decode here if it is
		
		if ( url.indexOf(this.HUFFMANN_PREFIX) != -1 ){
			var arr = url.split(this.HUFFMANN_PREFIX);
			var result = com.ibm.mm.enabler.encode.huffman.HuffmanURL.getDataFromHuffmanTree(arr[1]);
			if (result != null)
			{
				url = arr[0]+result;
			} 
		}		
    	
    	var httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl(url);
    	var fragment = httpUrl.anchor; 
		if (this.bIsLoggable == true)this.LOGGER.trace("decode","fragment is "+fragment);
		 	
    	
    	if(fragment && fragment != null && fragment != ""){
    		/*This string:
  		    "sid=testspace&pid=test&w0=testwidget&w0cp=%20spaces%20=blah"
    		results in this object structure:
    		    {
    		        sid: "testspace",
    		        pid:"test",
    		        w0:"testwidget",
    		        w0cp: " spaces =blah",
    		    }
			*/
    		var parameters = dojo.queryToObject(fragment);			
			var timestamp = new Date().getTime();			
    		if (parameters.pid) {
				state.pid = {};
				state.pid.value = decodeURIComponent(parameters.pid);
				state.pid.params = {};
				state.pid.params.lm = timestamp;
			}	
    		if (parameters.sid) {
				state.sid = {};
				state.sid.value = decodeURIComponent(parameters.sid);
				state.sid.params = {};
				state.sid.params.lm = timestamp;
			}
		
			state.wparams= {};
			
    		//collect all the widget state parameters from url
			//10 should be the default
			//for example: w0,w1,w2...				
			for (var i in parameters){ 
			    if (i.indexOf("w") == 0 && i.indexOf("cp")== -1 && i.indexOf("rp") == -1){
					var widgetData = {};
					var index = i.substr(1)*1+timestamp;
					var wID = parameters[i];
					var wIndexCP = i+"cp";
					var wIndexRP = i+"rp";
					if (parameters[wIndexCP]){			
						widgetData.value = widgetData.value?widgetData.value:{};			
						widgetData.value.cp = dojo.fromJson(decodeURIComponent(parameters[wIndexCP]));
						widgetData.params = widgetData.params?widgetData.params:{};		
						widgetData.params.lm = index;
					}
					if (parameters[wIndexRP]){
						widgetData.value = widgetData.value?widgetData.value:{};			
						widgetData.value.rp = dojo.fromJson(decodeURIComponent(parameters[wIndexRP]));
						widgetData.params = widgetData.params?widgetData.params:{};		
						widgetData.params.lm = index;
					}						
					state.wparams[wID]=widgetData;	
				}
			}				
    	}
    	if (callback)
    		callback(state);
		if(!callback)
    	return state;
 	},
	encode:function(state,callback,oldState) {
		//change above state into url fragment as defined in CDD and url encoded
		//
		var fragment = "";
		for (var i in state){
			if(i == "pid" ){
				if (state[i] && state[i] != null && state[i].value && state[i].value != null) 
					if (this._contains(i, this.persistenceURL)) {
						fragment = fragment + i + "=" + encodeURIComponent(state[i].value) + "&";
					}
			}
			if (i == "sid"){
				if (!state["pid"]){
					if (state["pageselection"]&& state["pageselection"] != null){
						var pageselection = state["pageselection"];
						var sid = state["sid"].value;
						if (pageselection[sid] && pageselection[sid] != null){
							var pid = pageselection[sid].value;
							fragment = fragment + "pid" + "=" + encodeURIComponent(pid) + "&";
						}						
					}
				}
			}
			// widgets!
			if (i == "wparams" && state[i] && state[i] != null){
				//it's a realarray after sorting
				var widgetsData = this._sortData(dojo.clone(state[i]));//work with a clone copy...
				if (widgetsData.length > this.urlpersistenceLIMIT){
					widgetsData = widgetsData.slice(widgetsData.length-this.urlpersistenceLIMIT);
				}					
				var index = 0;
				for (var j in widgetsData){ //j should be widgetid now...
					var widgetData = widgetsData[j];					
					if ( widgetData != null && widgetData["value"] && widgetData["value"] != null && widgetData["value"]["cp"] && widgetData["value"]["cp"] != null){	
						var urlData = this._filterData(dojo.clone(widgetData["value"]["cp"]),this.persistenceURL,this.persistencePSTORE);
						if (this._isEmpty(urlData) == false) {
							var realData = dojo.toJson(urlData);
							fragment = fragment + "w" + index + "=" + widgetData.wid + "&" + "w" + index + "cp=" + encodeURIComponent(realData) + "&";
							index++;
							if (index >= this.urlpersistenceLIMIT) 
								break;
						}	
					}				
				}
			}		
		}
		
		if ( this.isHuffmannEnabled == true ){
			//need to generate url that's huffmann encoding enabled, don't encode pid for now... #pid
			if (fragment.indexOf("&") != -1 ){
			   var data = fragment.substr(fragment.indexOf("&")+1);
			   if (data.length >0){
					data = com.ibm.mm.enabler.encode.huffman.HuffmanURL.createRawSchemeSpecificPartFromRegex(data,"[%&c=]");
					fragment = fragment.substring(0,fragment.indexOf("&")+1); //include "&"
					fragment = fragment.concat(this.HUFFMANN_PREFIX);
					fragment = fragment.concat(data);		   
			   }
			}
		}		
		
		//huffman encoding if required
		if (callback){
			callback(fragment);
		}
		if (!callback)
		return fragment;
 	},
	_removeQueryState:function(wru){
			if (wru.indexOf("?") == -1) return wru;
			var queryParams = wru.substring(wru.indexOf("?")+1); //? is not included
			if (queryParams && queryParams != null &&queryParams.indexOf("#") != -1){
				queryParams = queryParams.substring(0,queryParams.indexOf("#"));
			}
			var prefix = wru.substr(0,wru.indexOf("?")); //prefix before query parameter,"?" is not included
						
			var st = null;
			var newqueryParams = "";
			if (queryParams && queryParams != null && (queryParams.indexOf("nst=")==0 ||queryParams.indexOf("&nst=") >=0 )){
				var temp = queryParams.substr(queryParams.indexOf("nst=")+3); //mystate&other=test
				var postSt = "";
				if (temp.indexOf("&") > 0 ) { //?nst=mystate&other=test
					st = temp.substring(0,temp.indexOf("&")); //mystate
					postSt = temp.substring(temp.indexOf("&")); //&other=test
				}
				else{
					st = temp;
				}
								
				if (queryParams.indexOf("&nst=") != -1){
					//?other=test&nst=mystate --> other=test
					newqueryParams = queryParams.substring(0,queryParams.indexOf("&nst="));
				}
				if(newqueryParams.length == 0 && postSt.length != 0){
					newqueryParams = newqueryParams.concat(postSt.substring(1)); //remove "&" here
				}
				else{
					newqueryParams = newqueryParams.concat(postSt);
				}	
			}else{
				return wru; //if there's no state information encoded in params.			
			}		
					
			//add hash
			var hash = wru.substr(wru.indexOf("#")+1);
		
			//remove "nst=" as query parameter
			var newWru = prefix;
			if(newqueryParams.length > 0)
				newWru = newWru.concat("?").concat(newqueryParams);
			if(hash.length>0)
				newWru = newWru.concat("#").concat(hash);
			return newWru;		
		
	},
	generateUrl:function(state,callback,params){
			var encodedFragment = 	this.encode(state);
			var href = window.location.href;
			//remove "?nst=" here
			href = this._removeQueryState(href);
			var preHref = href.substr(0,href.indexOf("#"));
			var url = preHref.concat("#");
			url = url.concat(encodedFragment);
			//{nohash:"true"}
			if (params && params.nohash && params.nohash == "true" ){
				//now need to generate a url without hash, by default we use query "?nst=b"
				//there could be =,& in the encodedFragment, need ot escape
				encodedFragment = escape(encodedFragment);
				
				if(preHref.indexOf("?") == -1){
					url = preHref.concat("?");
					url = url.concat("nst=");
					url = url.concat(encodedFragment);					
				}else{
					if (preHref.lastIndexOf("&")==(preHref.length-1)){
						url = preHref.concat("nst=");
						url = url.concat(encodedFragment);
					}else{
						url = preHref.concat("&");
						url = url.concat("nst=");
						url = url.concat(encodedFragment);						
					}
				}			
			}	
			
			if (callback && callback != null)
			callback(url);
			return url;
	},
	_getHash:function(wru){
			if (wru.indexOf("?") == -1) return null;
			if (wru.indexOf("#") != -1){
				var hashValue = wru.substr(wru.indexOf("#")+1);
				if (wru.indexOf("pid") != -1 || wru.indexOf("sid") != -1) return null;
			}
			var queryParams = wru.substring(wru.indexOf("?")+1); //? is not included
			if (queryParams && queryParams != null &&queryParams.indexOf("#") != -1){
				queryParams = queryParams.substring(0,queryParams.indexOf("#"));
			}
			//var prefix = wru.substr(0,wru.indexOf("?")); //prefix before query parameter,"?" is not included
						
			var st = null;
			//var newqueryParams = "";
			if (queryParams && queryParams != null && (queryParams.indexOf("nst=")==0 ||queryParams.indexOf("&nst=") >=0 )){
				var temp = queryParams.substr(queryParams.indexOf("nst=")+4); //mystate&other=test
				var postSt = "";
				if (temp.indexOf("&") > 0 ) { //?nst=mystate&other=test
					st = temp.substring(0,temp.indexOf("&")); //mystate
					}
				else{
					st = temp;
				}			
	
				st = unescape(st);
			}else{
				return null; //if there's no state information encoded in params.			
			}
			return st;	
	},
	_sortData:function(widgetsData){
		//sort data based on "lm" -- pass in an associative array
		var arr = [];
		for (var i in widgetsData){			
			widgetsData[i].wid = i;
			var widgetData = widgetsData[i]; //i is widgetid
			arr.push(widgetData);			
		}
		var sortby= function(a,b){
			return (a.params.lm - b.params.lm);
		}
		arr.sort(sortby);
		return arr;  //an array sorted in accending order
	},
	_getLength:function(obj){
		var length = 0;
		for (var i in obj){
			length++;
		}
		return length;		
	},
	_isEmpty:function(obj){
		for (var i in obj){
			return false;
		}
		return true;		
	},
	_contains:function(value,obj){
		if (obj[value])return true;
		return false;
	},
	_filterData:function(data,containsObj,notContainsObj){
		//removes data fields that's not in the containsObj if notContainsObject is not provided
		//removes data fields that's in notContainsObj and it's not in containsObj --> url
		if (! notContainsObj){ 
			for (var i in data) {
				if (this._contains(i,containsObj) == false) {
					delete data[i];
				}
			}
			return data;
		}
		for (var i in data){
			if ( this._contains(i,containsObj) == false && this._contains(i,notContainsObj) == true){
				delete data[i];
			}		
		}
		return data;		
	},	
	preprocess:function(state, callback) {		
 		//call cookie preprocessor to process data
 		//collect data from cookie
		if (this.bIsLoggable == true) {
			this.LOGGER.entering("preprocess");
			if(state && state != null)
				this.LOGGER.trace("preprocess","state is "+dojo.toJson(state));
		}
 		var cookieManager = com.ibm.mashups.enabler.model.state.CookieManager;
 		var temp = cookieManager.getState();
 		
 		//need to merge data
 		//pid/sid first
		//if state already contains sid and even pid is null, don't load it
		if (!state.pid && temp.pid && temp.pid != null & !state.sid) {
			state.pid = temp.pid;
		}	
		if (!state.sid && temp.sid && temp.sid != null) {
			state.sid = temp.sid;
		}	

		if (!state.pageselection && temp.pageselection && temp.pageselection != null ) state.pageselection = temp.pageselection;
		
		//widget data collection
		if(!state.wparams) state.wparams = {};
		var widgetsStateData = state.wparams;
		
		var widgetData = temp.wparams; //values in cookie
		for (var i in widgetData){
			var widget = i;
			var value = widgetData[i]; //data in cookie
			var widgetStateData = widgetsStateData[widget];//data in state object
			if (widgetStateData && widgetStateData != null ){
				value = dojo.mixin(value,dojo.clone(widgetStateData)); //merge data for widget,data in memory wins if duplicate, for example: "lm"
				widgetsStateData[widget]=value;	//set new dta in memory		
			}
			else{				
				widgetsStateData[widget]=value;			
			}  		
		}
		if(callback){
			callback(state);
		}	
		if(!callback)
		return state;
	},
	postprocess:function(state,callback,oldState){
	//persist into cookie
	    var cookieManager = com.ibm.mashups.enabler.model.state.CookieManager;
		
		for (var i in state){
			if(i == "pid" || i =="sid" || i == "pageselection"){
				cookieManager.setState(i,state[i]);
			}
			// widgets!
			if (i == "wparams"  && state[i] && state[i] != null){
				var widgetsstate = {};
				var widgetsData = state[i];
				for (j in widgetsData){
					var widgetData = widgetsData[j];
					var wID = j;//wid
					var pstoreData = {};
					if ( widgetData != null && widgetData.value && widgetData.value != null ){
						if (widgetData.value.rp && widgetData.value.rp != null) {
							var rpData = this._filterData(dojo.clone(widgetData.value.rp), this.persistencePSTORE);
							if (this._isEmpty(rpData) == false) {
							pstoreData.value = pstoreData.value?pstoreData.value:{};
							pstoreData.value.rp = rpData;
							}
						}
						if (widgetData.value.cp && widgetData.value.cp != null)	{
							var cpData = this._filterData(dojo.clone(widgetData.value.cp),this.persistencePSTORE);
							if (this._isEmpty(cpData) == false) {
							pstoreData.value = pstoreData.value?pstoreData.value:{};
							pstoreData.value.cp = cpData;
							}
						}
						if (this._isEmpty(pstoreData) == false)	{
							//if there's no value, no reason to save empty params. at least for now.
							if (widgetData.params && widgetData.params!= null)	{
								pstoreData.params = widgetData.params;
							}
							widgetsstate[wID] = pstoreData;							
						}							
					}				
				}
				cookieManager.setState("wparams",widgetsstate);
			}		
		}
		cookieManager.commit();		
				
		if(callback)
			callback(state);
		if(!callback)
		return state;
	}
	
});
dojo.declare( "com.ibm.mm.enabler.model.state.NavigationStateProcessorFactoryImpl", null, {
	  
    constructor:function () {
    },
   	getProcessor:function() {
       	return new com.ibm.mm.enabler.model.state.NavigationStateProcessorImpl();
 	}
});
com.ibm.mashups.enabler.model.state.NavigationStateProcessorFactory = new com.ibm.mm.enabler.model.state.NavigationStateProcessorFactoryImpl();


dojo.declare( "com.ibm.mm.enabler.model.state.NavigationStateNodeImpl", [com.ibm.mashups.enabler.model.state.NavigationStateNode],{
    
	constructor:function (navStateModel,key,value,id,ref) {
		this.model = navStateModel;
		this.key = key; //like pid
		this.value = value;//real pid
		if(id) this.id = id;
		if(ref) this.ref = ref;
    },
    setID:function(id){
    	this.id = id; //pointer to the position in jso object. wparams#widgetid#cp
    },
    setRef:function(ref){ //ref to the data in state json object: this._state["pid"]
    	this.ref = ref;
    },
    getID:function(){
    	return this.id;
    },
    getRef:function(){
    	return this.ref; //return the ref in state json object
    },	
    getKey:function(){
    	return this.key;
    },
    getValue:function(){
    	return this.value;
    },	
    get:function(){    	//return value only,not reference
    	return dojo.clone(this._ref);
    },
    set:function(value){
    	this.ref = value; //overwrite
    	this.model.setDirty(true);
    }
});    

dojo.declare( "com.ibm.mm.enabler.model.state.NavigationStateModelImpl", [com.ibm.mashups.enabler.model.state.NavigationStateModel],{
    
	DELIMITER:"#",
	ROOT:"ROOT",
	DELETE_TOKEN:"DELETE_TOKEN",
	constructor:function (state) {
			this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
		this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
	
		this.processor = com.ibm.mashups.enabler.model.state.NavigationStateProcessorFactory.getProcessor();
		
		if (state) {
			this._state = state;
			this._loaded = true;
		}
		else {
			this._loaded = false;
			this.processor.decode(window.location.href, dojo.hitch(this, "_preprocess"));
		}
    },
	_getFullUrl:function(cb,params){
		return this.processor.generateUrl(this._state,cb,params);		
	},
	clone:function(){
		var clone = dojo.clone(this._state);
		return new com.ibm.mm.enabler.model.state.NavigationStateModelImpl(clone);
	},
    _preprocess:function(/*json*/state){
		if (this.bIsLoggable == true) { 
			this.LOGGER.entering("_preprocess");
			if (state && state != null) this.LOGGER.trace("_preprocess","state:"+dojo.toJson(state));
		}

    	this.processor.preprocess(state,dojo.hitch(this,"_initializeState"));
    },
    _initializeState:function(/*json*/state){
		if (this.bIsLoggable == true) { 
			this.LOGGER.entering("_initializeState");
			if (state && state != null) this.LOGGER.trace("_initializeState","state:"+dojo.toJson(state));
		}
    	this._state = state; 
		this._stateInternal = dojo.clone(state);
    	this._rootNode = new com.ibm.mm.enabler.model.state.NavigationStateNodeImpl(this,this.ROOT,this._state,this.ROOT,this._state);
    	this._isDirty = false;
		this._dirtyProperties = {};
		this._loaded = true;
    },
    _postprocess:function(/*json*/state){
    	this.processor.encode(state,dojo.hitch(this,"_finishCommit"),this._stateInternal);    	
    },	
    _finishCommit:function(fragment){
    	//update url fragment identifier accordingly
    	//todo
		
		//update url
		window.location.hash = "#"+fragment;	
		
		//broadcast page Navigation updated event
		if (this._isDirty == true){
			var eventService = com.ibm.mashups.services.ServiceManager.getService("eventService");
			eventService.publishEvent(this.ONNAVSTATEUPDATED);
		}
			
		
		//just call dojo.backbutton...
    	this._isDirty = false;
		this._stateInternal = dojo.clone(this._state);
		delete this._dirtyProperties;
		this._dirtyProperties = {};
		
		//handle callback
		if (this._deferred) {
			var deferred = this._deferred;
			if (deferred && deferred.finishedCallback2) {
				// callback handling
				if (deferred.finishedCallback2) {
					deferred.finishedCallback2(null, com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK, deferred.finishedCallbackParameters2);
				}
			}
			delete this._deferred;
		}
    },	
    setDirty:function(isDirty,property){
    	this._isDirty = isDirty;
		if (property) this._dirtyProperties[property] = property;		
    },
    isDirty:function(){
    	return this._isDirty;
    },
	_find:function(id){//id
	//return the NavigationStateNode by id or return null
	if (typeof (id) == "undefined" || id == null) return null;
    	if(id == this.ROOT)
    		return this._rootNode;
    	else {
    		var aNode =  this._findReference(id); //return the ref in this._state
    		if (aNode != null){
    			var returnNode =  new com.ibm.mm.enabler.model.state.NavigationStateNodeImpl(this);
    			returnNode.setID(id);
    			returnNode.setRef(aNode);
    			return returnNode;
    		}	
    	}
    	return null;
    },	
	create:function(context){
    	//{key:id,value:data} 
		//{key:"pid",value:pid}
		//{key:"mywidgetid",value:json}
    	var key= context.key? context.key:null;  
    	var value = context.value?context.value:null;
    	var aNode = new com.ibm.mm.enabler.model.state.NavigationStateNodeImpl(this,key,value);
    	return aNode;
     },
    insert:function(aNode,parentNode){
		//For example, pid node should be inserted under rootnode
    	var parentData = parentNode.getRef();
    	var key = aNode.getKey();
    	var value = aNode.getValue();
       	if (value == null)value = {};
		
		//if parentNode is wparams, then aNode is widget node, widget node need to have an index in value
		var parentKey = parentNode.getID();
		/*if (parentKey && parentKey != null && parentKey == "wparams") {
			value.i = this._getIndex(parentData);
		}*/
		parentData[key] = value;//insert the node into JSON	
    	return;
    },	
	_getIndex:function(parentData){
		var index = 0;
		for (var i in parentData){
			index++;
		}
		return index;		
	},
	remove:function(aNode){
		//get id
		var id = aNode.getID();
		var arr = id.split("#");
		if (arr.length == 1){
			//remove from root
			if (this._state[id])
			delete this._state[id];
		}
		if(arr.length >1)
		{   var key = id.substring(id.lastIndexOf("#")+1);
			var parentId = id.substring(0,id.lastIndexOf("#"));
			var parentNode = this._find(parentId);
			if(parentNode != null){
				var ref = parentNode.getRef();
				if (ref[key])delete ref[key];
			}
		}
		return;	
	},
    _getRoot:function(){
    	return this._rootNode;    	
    },
    _findReference:function(id){
    	if (id == this.ROOT)return this._state;
    	var found = false;
    	var arr = id.split("#");
    	var node = this._state;
    	for ( var i in arr){
    		var j = arr[i];
    		found = false;
    		if(this._findMatch(node,j) == true){
    			node = node[j];
    			found = true;
    		}
    		else{
    			break;
    		}	
    	}
    	if (found == false) return null;
    	return node;
    },	
    _findMatch:function(node,key){
    	if (node[key]&& node[key] != null){
    		return true;
    	} 
    	return false;
    },
    commit: function () {
        return new com.ibm.mm.enabler.DeferredImpl(this, this._commit);
    },
    _commit:function(deferred,sync){ //default is synchronous
    	this._deferred = deferred;
		//don't commit if it's edit mode...
    	if (this._isDirty == true && (!this._pagemode || (this._pagemode && this._pagemode != "edit"))){
    		//persist to cookie
    	   	this.processor.postprocess(this._state,dojo.hitch(this,this._postprocess),this._stateInternal);
      	}    	
    },
	discard:function(){
		this._state =dojo.clone(this._stateInternal);
		this._isDirty = false;		
	},
	_getPageMode:function(){
		if(!this._pagemode)return null;
		return this._pagemode;
	},
	_setPageMode:function(pageMode){
		if (pageMode && pageMode != null) {
			this._pagemode = pageMode;
		}
	},
	dispose:function(){
		this._state = null; 
		this._stateInternal = null;
    	this._rootNode = null;
    	this._isDirty = null;
		this._dirtyProperties = null;
		this._loaded = null;
		this.processor.dispose();
	}	
});


dojo.declare( "com.ibm.mm.enabler.model.state.NavigationStateModelFactoryImpl", null, {
  /**
    * @private
    */
    constructor:function () {
			
    },    
    getNavigationStateModel:function() {
		if (!this.navigationstatemodel)
		this.navigationstatemodel = new com.ibm.mm.enabler.model.state.NavigationStateModelImpl();
    	return this.navigationstatemodel;
	}
});
com.ibm.mashups.enabler.model.state.NavigationStateModelFactory = new com.ibm.mm.enabler.model.state.NavigationStateModelFactoryImpl();


dojo.declare( "com.ibm.mm.enabler.model.state.WidgetAccessorImpl", [com.ibm.mashups.enabler.model.state.WidgetAccessor], {
  
    constructor:function (navStateModel, id) {
		this.navStateModel = navStateModel;
		this.wid = id;
		this.widgetNavStateNode = navStateModel._find(this.WIDGET_PREFIX+this.navStateModel.DELIMITER+id);
    },
    WIDGET_PREFIX:"wparams",
    WIDTH:"w",
    HEIGHT:"h",
    WINDOWSTATE:"st",
    SYSTEMSTATE:"rp",
    CUSTOMSTATE:"cp",
    MIN:"min",
    MAX:"max",
    NORMAL:"normal",
	VALUE:"value",
	PARAMS:"params",
	getWidgetID:function() {
    	return this.wid;
	},
	getWidgetStateSet:function(){
		var value = null;
		if (!this.widgetNavStateNode || this.widgetNavStateNode == null)return null;
		var data = this.widgetNavStateNode.getRef();
		if (data != null && data[this.VALUE] && data[this.VALUE] != null){
			if (data[this.VALUE][this.CUSTOMSTATE] && data[this.VALUE][this.CUSTOMSTATE]!= null){
				value = data[this.VALUE][this.CUSTOMSTATE];
			}			
		}
		return value;
	},
	_createWidgetNavStateNode:function(){
		var aNode = this.navStateModel.create({key:this.wid});
		var parentNode = this.navStateModel._find(this.WIDGET_PREFIX);
		if (parentNode == null){
			var temp = this.navStateModel.create({key:this.WIDGET_PREFIX});
			this.navStateModel.insert(temp,this.navStateModel._getRoot());
			parentNode = this.navStateModel._find(this.WIDGET_PREFIX);
		}	
		this.navStateModel.insert(aNode,parentNode);
		aNode = this.navStateModel._find(this.WIDGET_PREFIX+this.navStateModel.DELIMITER+this.wid)
		return aNode;
	},	
	setWidgetStateSet:function(object){
		
		var value = null;
		//need to support both string or object
		//if (dojo.isString(object) == true) object = dojo.fromJson(object);
		if (this.widgetNavStateNode == null)
		{
			//create this.widgetNavStateNode
			this.widgetNavStateNode = this._createWidgetNavStateNode();
		}
		var data = this.widgetNavStateNode.getRef();
		data.params = data.params?data.params:{};
		data.params.lm = new Date().getTime(); //todo	
		if (data != null && data[this.VALUE] && data[this.VALUE] != null){
			if (data[this.VALUE][this.CUSTOMSTATE] && data[this.VALUE][this.CUSTOMSTATE]!= null){
				value = dojo.clone(data[this.VALUE][this.CUSTOMSTATE]);
			}			
		}
		
		data[this.VALUE]= data[this.VALUE]?data[this.VALUE]:{};
		var obj = object;
		if ( value != null && dojo.isString(object) == false) {
				obj = dojo.mixin(value, object); //mixin behaviour
		}	
		data[this.VALUE][this.CUSTOMSTATE] = obj;
	
		
		this.navStateModel.setDirty(true);
		return;
	},
	getWidgetState:function(key) {
		if (key && key != null && key == "cp") return this.getWidgetStateSet();
		var value = null;
		if (!this.widgetNavStateNode || this.widgetNavStateNode == null)return null;
		var data = this.widgetNavStateNode.getRef();
		if (data != null && data[this.VALUE] && data[this.VALUE] != null){
			if (data[this.VALUE][this.SYSTEMSTATE] && data[this.VALUE][this.SYSTEMSTATE]!= null){
				data = data[this.VALUE][this.SYSTEMSTATE];
				if (data != null && data[key] && data[key]!= null){
						value = data[key];
				}				
			}			
		}
		return value;
	},
	setWidgetState:function(key, value){
		//overwrite behaviour
		if (key && key != null && key == "cp") return this.setWidgetStateSet(value);
		if (!this.widgetNavStateNode || this.widgetNavStateNode == null){
			this.widgetNavStateNode = this._createWidgetNavStateNode();
		}

		var data = this.widgetNavStateNode.getRef();
		data.params = data.params?data.params:{};
		data.params.lm = new Date().getTime(); //todo	
		var keyRef = null;
		data[this.VALUE] = data[this.VALUE]?data[this.VALUE]:{};
		data[this.VALUE][this.SYSTEMSTATE]= data[this.VALUE][this.SYSTEMSTATE]?data[this.VALUE][this.SYSTEMSTATE]:{};
		keyRef = data[this.VALUE][this.SYSTEMSTATE];
			
		keyRef[key]=value;	
		this.navStateModel.setDirty(true);
		return;
	},
	removeWidgetState:function(key){
		if (!this.widgetNavStateNode || this.widgetNavStateNode == null) {
			return;
		}	
		var data = this.widgetNavStateNode.getRef();
		data.params = data.params?data.params:{};
		data.params.lm = new Date().getTime(); //todo	
		if (key && key != null && key == "cp"){
			if (data != null && data[this.VALUE] && data[this.VALUE] != null && data[this.VALUE][this.CUSTOMSTATE] && data[this.VALUE][this.CUSTOMSTATE] != null) {
				data[this.VALUE][this.CUSTOMSTATE] = null;
				this.navStateModel.setDirty(true);
			}
			return;
		}	
		if (data != null && data[this.VALUE] && data[this.VALUE]!= null && data[this.VALUE][this.SYSTEMSTATE]&& data[this.VALUE][this.SYSTEMSTATE]!= null){
			var keyRef = data[this.VALUE][this.SYSTEMSTATE];
			if (keyRef != null && keyRef[key] && keyRef[key] != null){
			    keyRef[key] = null;
				this.navStateModel.setDirty(true);
				return;
			}	
		}
		return;
	},
	getWindowState:function() {
		rc = this.getWidgetState(this.WINDOWSTATE);
		rc = rc?rc:this.NORMAL;
		return rc;		
	},
	setWindowState:function(windowState) {	
		if (windowState && windowState != null && (windowState == this.MIN || windowState == this.MAX || windowState == this.NORMAL))	
		return this.setWidgetState(this.WINDOWSTATE,windowState);
	},
	getSize:function() {
		var size = {};
		var height = this.getWidgetState(this.HEIGHT);
		var width = this.getWidgetState(this.WIDTH);
		if(height && height!=null)size[this.HEIGHT]= height;
		if(width && width != null)size[this.WIDTH]=width;
		if(!size[this.HEIGHT]&&!size[this.WIDTH]) return null;
		return size;
	},
	setSize:function(width, height) {
		if (width && width != null)  this.setWidgetState(this.WIDTH,width);
		if (height && height != null) this.setWidgetState(this.HEIGHT,height);		
		return;
	}
});

dojo.declare( "com.ibm.mm.enabler.model.state.PageAccessorImpl", [com.ibm.mashups.enabler.model.state.PageAccessor] , {
  
    constructor:function (navStateModel,spaceid) {
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
		this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
		
		if(this.bIsLoggable == true){
			this.LOGGER.entering("constructor");
			this.LOGGER.trace("constructor","spaceId:"+spaceid);
		}
		this.navStateModel = navStateModel;
		if (spaceid) 
		this.spaceid = spaceid;
    },
   	getPageID:function() {
		var state = this.navStateModel._state;
		var rc = null;
		if (typeof state == "undefined" || state == null) return null;
	    if (! this.spaceid){
			if (state["pid"]) {
				if(this.bIsLoggable == true){
						this.LOGGER.trace("getPageID","No required pace is defined, return Pageid"+state["pid"].value);
				}
				return state["pid"].value;
			}
			if(this.bIsLoggable == true){
				this.LOGGER.trace("getPageID","No required space is defined, no pid is defined in state  return null");
			}
			return null;
		}else{
			if (state["pageselection"] && state["pageselection"][this.spaceid]){
				if(this.bIsLoggable == true){
					this.LOGGER.trace("getPageID","return pid:"+state["pageselection"][this.spaceid]+" for space:"+this.spaceid);
				}				
				return state["pageselection"][this.spaceid].value;
			}
			if(this.bIsLoggable == true){
				this.LOGGER.trace("getPageID","No page is found for required space "+this.spaceid+" return null");
			}
			return null;			
		}
		if(this.bIsLoggable == true){
				this.LOGGER.trace("getPageID","return null");
		}
		return null;
	},	
	setPageID:function(pageId) {
		if(this.bIsLoggable == true){
				this.LOGGER.trace("setPageID","pageId:"+pageId);
		}
		var state = this.navStateModel._state;
		if (typeof state == "undefined" || state == null) {
			this.navStateModel._state = {};
			state = this.navStateModel._state;
		}	
		
		if (!pageId || (pageId && pageId == null)){		   
			state["pid"] = null;
			if (this.spaceid && this.spaceid != null){
				if (state["pageselection"] && state["pageselection"] != null && state["pageselection"][this.spaceid] && state["pageselection"][this.spaceid] != null){
					state["pageselection"][this.spaceid] = null;
				}			
			}	
			return;
		}
	
		var lm = new Date().getTime(); 
		state["pid"] = state["pid"]?state["pid"]:{};
		state["pid"].value = pageId;	
		state["pid"]["params"] = state["pid"]["params"]?state["pid"]["params"]:{};
		state["pid"]["params"].lm = lm;	
		if (this.spaceid && this.spaceid != null){
			if (! state["pageselection"]) state["pageselection"]  = {};
			if (! state["pageselection"][this.spaceid])	state["pageselection"][this.spaceid] = {};
			state["pageselection"][this.spaceid].value = pageId;
			state["pageselection"][this.spaceid]["params"] = state["pageselection"][this.spaceid]["params"]?state["pageselection"][this.spaceid]["params"]:{};
			state["pageselection"][this.spaceid]["params"].lm = lm;
		}
	   	this.navStateModel.setDirty(true,"pid");
	}
});

dojo.declare( "com.ibm.mm.enabler.model.state.PageModeAccessorImpl", [com.ibm.mashups.enabler.model.state.PageModeAccessor] , {
  
  	constructor:function (navStateModel) {
		this.navStateModel = navStateModel;
    },
 	getPageMode:function() {
		var pageMode = this.navStateModel._getPageMode();
		if(!pageMode) return null;
		return pageMode;
	},
	setPageMode:function(mode) {
		if (mode && mode != null){
			this.navStateModel._setPageMode(mode);
		}
		return;
	}
});

dojo.declare( "com.ibm.mm.enabler.model.state.SpaceAccessorImpl", [com.ibm.mashups.enabler.model.state.SpaceAccessor] , {
  
    constructor:function (navStateModel) {
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
		this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
		
		if(this.bIsLoggable == true){
			this.LOGGER.entering("constructor");
		}
		this.navStateModel = navStateModel;
    },
   	getSpaceID:function() {
		var state = this.navStateModel._state;
		if (typeof state == "undefined" || state == null) return null;
	  	if (state["sid"] && state["sid"] != null && state["sid"]["value"]&&state["sid"]["value"] != null){
				if(this.bIsLoggable == true){
					this.LOGGER.trace("getSpaceID","sid:"+state["sid"]["value"]);
				}
				return state["sid"]["value"];
		}
		if(this.bIsLoggable == true){
					this.LOGGER.trace("getSpaceID","sid:null");
		}
		return null;
	},	
	setSpaceID:function(spaceId) {
		if(this.bIsLoggable == true){
					this.LOGGER.trace("setSpaceID","sid:"+spaceId);
		}
		var state = this.navStateModel._state;
		if (typeof state == "undefined" || state == null) {
			this.navStateModel._state = {};
			state = this.navStateModel._state;
		}	
		var lm = new Date().getTime(); //todo		
		state["sid"] = state["sid"] ?state["sid"] :{};	
	    state["sid"].value = spaceId;	
		state["sid"]["params"] = state["sid"]["params"]?state["sid"]["params"] :{};
		state["sid"]["params"].lm = lm;	
		this.navStateModel.setDirty(true,"sid");
	}
});
dojo.declare( "com.ibm.mm.enabler.model.state.AccessorFactoryImpl", null, {
  
    constructor:function () {
    },
	getPageAccessor:function(navStateModel,spaceId) {
		return new com.ibm.mm.enabler.model.state.PageAccessorImpl(navStateModel,spaceId);
 	},
	getPageModeAccessor:function(navStateModel) {
		return new com.ibm.mm.enabler.model.state.PageModeAccessorImpl(navStateModel);
 	},
	getSpaceAccessor:function(navStateModel) {
    	return new com.ibm.mm.enabler.model.state.SpaceAccessorImpl(navStateModel);
 	},
	getWidgetAccessor:function(navStateModel, widgetId) {	
		return new com.ibm.mm.enabler.model.state.WidgetAccessorImpl(navStateModel,widgetId);
 	} 
});
com.ibm.mashups.enabler.model.state.AccessorFactory = new com.ibm.mm.enabler.model.state.AccessorFactoryImpl();
dojo.declare( "com.ibm.mm.enabler.model.state.UrlGeneratorImpl", com.ibm.mashups.enabler.model.state.UrlGenerator, {

    constructor:function () {
    },
  	getUrl:function(navStateModel,callback,params) {
		if (typeof navStateModel == "undefined" && navStateModel != null) return null;
		var clone = navStateModel.clone(); //get a clone so it doesn't affect the original navStateModel
		return clone._getFullUrl(callback,params);
	}
});	
dojo.declare( "com.ibm.mm.enabler.model.state.UrlGeneratorFactoryImpl", com.ibm.mashups.enabler.model.state.UrlGeneratorFactory, {
  
    constructor:function () {
		this._urlGenerator = new com.ibm.mm.enabler.model.state.UrlGeneratorImpl();
    },
    getUrlGenerator:function() {
		return this._urlGenerator;		
	}
});	
com.ibm.mashups.enabler.model.state.UrlGeneratorFactory = new com.ibm.mm.enabler.model.state.UrlGeneratorFactoryImpl();

}

if(!dojo._hasResource["com.ibm.mashups.iwidget.model"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.model"] = true;
dojo.provide("com.ibm.mashups.iwidget.model");
dojo.provide("com.ibm.mashups.iwidget.model.WidgetModel");
dojo.provide("com.ibm.mashups.iwidget.model.Factory");


/**
 Interface represents  iWidgetModelFactory
  @ibm-spi
 */
dojo.declare("com.ibm.mashups.iwidget.model.Factory",null,  {
	/**
            * @private
            */
    constructor:function(){
 
    },
/**
Returns  global widget model.
@type com.ibm.mashups.iwidget.model.WidgetModel
@returns{com.ibm.mashups.iwidget.model.WidgetModel }  Interface for WidgetModel.
*/	
	getGlobalWidgetModel:function(){
	}

});


/**
WidgetModel interface defines functions that expose information of a widget model.<br/>
Global model available to all the page components.<br/>
<code>var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();</code>


@ibm-spi
  */
dojo.declare("com.ibm.mashups.iwidget.model.WidgetModel",null,{
/**
 * @private
 */
	constructor:function(id){

	},

/**
Returns  an iWidgetWrapper object which represents a runtime instance of an iWidget object. <br/>
Id is the  "id" attribute that's defined in  microformat. It's used to uniquely identify an iWidget instance on the page.<br/>
<code> &lt;span class="iw-iWidget" id="{id}"&gt;  </code>
@param{String} id  unique id of an iWidget wrapper. Must not be NULL.
@type com.ibm.mashups.iwidget.widget. IWidgetWrapper
@returns{com.ibm.mashups.iwidget.widget. IWidgetWrapper }  an  iWidget Wrapper of the required iWidget . iWidget Wrapper represents a runtime instance of an iWidget.
*/	
	find:function(id){	
	},
/**
Returns  whether or not the given node has children. NOT Implemented.
@param{com.ibm.mashups.iwidget.iWidgetWrapper} iWidgetWrapper  parent iWidgetWrapper object. Must not be NULL.
@type Boolean
@returns{Boolean }  returns TRUE if the given node has children.
*/	
	hasChildren:function(iWidgetWrapper){	
	},
/**
Returns  an array of iWidgetWrapper object. NOT Implemented.<br/>
@param{com.ibm.mashups.iwidget.widget.IWidgetWrapper} iWidgetWrapper  parent object .Must not be NULL.
@param{Boolean} isNested  optional. the default  value is TRUE. It returns all the nested iWidgets if it's true. It returns only direct children if it's false. 
@type  com.ibm.mashups.iwidget.widget. IWidgetWrapper[]
@returns{com.ibm.mashups.iwidget.widget. IWidgetWrapper[]}  return an array of iWidgetWrapper object .
*/	
	getChildren:function(iWidgetWrapper,isNested){	
	},
/**
Returns  the parent object of the specified iWidgetWrapper object . <br/>
@param{com.ibm.mashups.iwidget.widget. IWidgetWrapper} iWidgetWrapper  iWidgetWrapper object. Must not be NULL.
@type com.ibm.mashups.iwidget.widget. IWidgetWrapper
@returns{com.ibm.mashups.iwidget.widget. IWidgetWrapper } returns parent node or NULL if the node has no parent.
*/	
	getParent:function(iWidgetWrapper){	
	},

/**
Returns the deferred object used to start this operation and an IWidgetDefinition object is returned when deferred object is executed.<br/>
<code>var deferred = widgetModel.getWidgetDefinitionByUrl(url)</code><br/>
<code>deferred.setFinishedCallback(callback,parameters);</code><br/>
<code>deferred.start(false);</code><br/>
here are the callback parameters that will be passed into callback function: <br/>
 &nbsp;&nbsp;&nbsp;&nbsp;<code>resource</code> -  IWidgetDefinition object <br>
&nbsp;&nbsp;&nbsp;&nbsp;<code>statuscode</code> - the HTTP status,code of the action .<br>
&nbsp;&nbsp;&nbsp;&nbsp;<code>params</code> - optional.  may use this to pass additional parameters  into the callback .<br>
here is a sample implementation of callbackfunction:<br/>
 &nbsp;&nbsp;&nbsp;&nbsp;<code>function callback(resource, statuscode, params) { </code><br/>
 &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;<code>  if (statuscode == 200) {   </code><br/>
 &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;<code>  var defObj = resource;</code><br/>
 &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;<code> ... }</code><br/>
 &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;<code> } </code><br/>
@param{String} url  url to load widget definition. Must not be NULL.
@type com.ibm.mashups.enabler.Deferred
@returns{com.ibm.mashups.enabler.Deferred}  a deferred object used to start this operation. 
@see com.ibm.mashups.iwidget.widget.IWidgetDefinition
*/ 
	getWidgetDefinitionByUrl:function(url){
	},
    
    /**
This method persists all the changes to the backend. System could choose its persistence storage.<br/>
Example:<br/>
<code>var deferred = model.commit();</code><br/>
<code>deferred.start();</code><br/>
@type  com.ibm.mashups.enabler.Deferred
@return{com.ibm.mashups.enabler.Deferred}   a deferred object is returned to start this operation. This operation will commit all the updates that has been applied to this data set.
 */ 
    commit:function(){
        //summary: This method persists the data
    }
    
});


}

if(!dojo._hasResource["com.ibm.mm.enabler.deferred"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.deferred"] = true;
dojo.provide( "com.ibm.mm.enabler.deferred" );
//dojo.require( "com.ibm.mm.enabler.model" );
dojo.require( "com.ibm.mashups.enabler.model.shared" );

// base
dojo.declare( "com.ibm.mm.enabler.DeferredImpl", com.ibm.mashups.enabler.Deferred,
    {
		// If you mixin the DeferredImpl into your class, you may use a different 
		// set of parameters for the constructor, but then you do not have access
		// to the parameters 'context', 'startfn', as well as 'params' and thus, 
		// you need to overwrite the start function, which accesses those parameters.
		// If you want to use the start function defined in DeferredImpl, you need 
		// to make sure, the parameters 'context', 'startfn', as well as 'params' 
		// are set in the constructor of DeferredImpl.     
        constructor:function (context, startfn, params) {
			// context for start function
            this.context = context;

			// start function
			this.startfn = startfn;

			// parameters to pass to start function
            this.params = params;
        },

		// deprecated
        addErrorCallback: function (callback, parameters) {
            this.errorCallback = callback;
            this.errorCallbackParameters = parameters;
        },

		// deprecated
        addFinishedCallback: function (callback, parameters) {
            this.finishedCallback = callback;
            this.finishedCallbackParameters = parameters;
        },

        setFinishedCallback: function (callback, parameters) {
            this.finishedCallback2 = callback;
            this.finishedCallbackParameters2 = parameters;
        },

        start: function(sync) {
			var mode = (sync || typeof(sync) == 'undefined') ? true : false; 
            return dojo.hitch(this.context, this.startfn)(this, mode, this.params);
        }
    }
);

// operation
dojo.declare( "com.ibm.mm.enabler.DeferredOperationImpl", [com.ibm.mashups.enabler.DeferredOperation, com.ibm.mm.enabler.DeferredImpl],
    {
        setOperationCallback: function (callback, parameters) {
            this.operationCallback = callback;
            this.operationCallbackParameters = parameters;
        }
    }
);

// iterator
dojo.declare( "com.ibm.mm.enabler.DeferredIteratorImpl", [com.ibm.mashups.enabler.DeferredIterator, com.ibm.mm.enabler.DeferredImpl],
    {
        setForeachCallback: function (callback, parameters) {
            this.foreachCallback = callback;
            this.foreachCallbackParameters = parameters;
        }
    }
);

}

if(!dojo._hasResource["com.ibm.mm.iwidget.deferred"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.deferred"] = true;
dojo.provide( "com.ibm.mm.iwidget.deferred" );
dojo.require( "com.ibm.mm.enabler.deferred" );


// deferred Load
dojo.declare( "com.ibm.mm.iwidget.DeferredLoadImpl", com.ibm.mm.enabler.DeferredImpl,
    {
        constructor:function (uri,id,widgetDef) {
            this.uri = uri;
			if (typeof id == "undefined") id = null;
				this.id = id;
			if (typeof widgetDef == "undefined") widgetDef = null;
			this.widgetDef = widgetDef;
        },
        // defaults to asynchronous
        start: function(sync) {
			if (this.widgetDef != null){
				this._handleCallback(this.widgetDef,200); //resource first, status code second
				//this._handleCallback("200",this.widgetDef);
				return this.widgetDef;
			}
            var mode = (sync || typeof(sync) == 'undefined') ? false : true;
			var widgetLoadService = com.ibm.mashups.services.ServiceManager.getService("widgetLoadService");
			widgetLoadService.getWidgetXML(this.uri,mode,dojo.hitch(this,"_handleLoad"),this.id);   
			if (sync && sync == true) {
				return this.widgetDef;
			}
			return null;
        },
		_handleLoad:function(data,statuscode,xhr){
			    if(typeof xhr != "undefined" && xhr != null) statuscode = xhr.status;
				if(statuscode != 200) data = null; //set to null value
				this.widgetDef = data;
				this._handleCallback(data, status);	
		},
		_handleCallback:function(widgetDef,status){
				var callback = this.finishedCallback2;
				if (this.finishedCallback2 && this.finishedCallbackParameters2){
					callback(widgetDef,status,this.finishedCallbackParameters2);
				}
				else if (this.finishedCallback2){
					callback(widgetDef,status);
				}		
				return;
		}
    }
);

dojo.declare("com.ibm.mm.iwidget.DeferredLiveTextUnprocessImpl", com.ibm.mm.enabler.DeferredImpl,
{
    constructor: function(wrapper) {
        this.wrapper = wrapper;
    },
    start: function(sync) {
        // defaults to false
        if (sync) {
            return;
        }
        
        var widgetInstance = this.wrapper.getIWidgetInstance();
        
        if (dojo.isFunction(this.wrapper.iScope._onGetMarkup)) {
            this.wrapper.iScope._onGetMarkup();
        }
        
        var tempMarkup = dojo.clone(this.wrapper.rootElement);
        
        dojo.publish("/com/ibm/mashups/livetext/livetextunchange", [tempMarkup, true, null, null, dojo.hitch(this, this._unchangeCompleteCallback), this.includeParent]);
    },
    setIncludeParent: function(value) {
        this.includeParent = value;
    },
    getIncludeParent: function() {
        return this.includeParent;
    },
    _unchangeCompleteCallback: function(node) {
        //console.debug(this.finishedCallback2);
        if(dojo.isFunction(this.finishedCallback2)) {
            this.finishedCallback2(node, 200);
        }
    }
});
dojo.declare("com.ibm.mm.iwidget.DeferredLiveTextUnprocessStubImpl", com.ibm.mm.enabler.DeferredImpl,
{
    constructor: function(wrapper) {
        this.wrapper = wrapper;
    },
    start: function(sync) {
		// defaults to false
        if (sync) {
            return;
        }	
		//todo, what should we return if widget is sandboxed?
		var widgetInstance = this.wrapper.getIWidgetInstance();
        var tempMarkup = dojo.clone(this.wrapper.rootElement);
        this._unchangeCompleteCallback(tempMarkup);
    },
    setIncludeParent: function(value) {
        this.includeParent = value;
    },
    getIncludeParent: function() {
        return this.includeParent;
    },
    _unchangeCompleteCallback: function(node) {
        console.debug(this.finishedCallback2);
        if(dojo.isFunction(this.finishedCallback2)) {
            this.finishedCallback2(node, 200);
        }
    }
});

}

if(!dojo._hasResource["com.ibm.mm.enabler.aggregation.javascript"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.aggregation.javascript"] = true;
dojo.provide( "com.ibm.mm.enabler.aggregation.javascript" );

dojo.provide("com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter");





function com_ibm_enabler_aggregation_javascript_globalEvalNonIE( /*String*/ javascript ) {
	// summary: Evaluates a string of javascript in the global scope.
	// description: Calling eval.call( self, ... ); from within a JS object apparently makes "this" point to the object from which the
	//		eval call was made even though the scope is set using the "call" function. Therefore we need to have this function
	//		available in the global scope and not as a member variable on a JS object.
	eval.call( self, javascript );
}

dojo.declare( "com.ibm.mm.enabler.aggregation.javascript.Filter",
			  null,
			  {
			  	// summary:	Base interface for a filter. Each implementation must implement
 				//		the doFilter function.
				// description: Passes the given event through to give the implementation of
				//		this filter a chance to alter or handle the event in some way. 
			  	
				doFilter: function ( /*String or HTMLElement*/script ) {
					// summary: Filter the given event.
					// description: Allows this filter to handle or alter the event. If this function
					//		returns true, processing is stopped and the event is considered "handled".
					// script: the script block (string or HTMLElement) 
					//dojo.unimplemented( "com.ibm.mm.enabler.aggregation.JavascriptFilter.doFilter" );
				},
				evalGlobal: function ( /*String*/javascript ) {
					// summary: Evaluates the given javascript in the global context.
					// javascript: a string of javascript to evaluate.
					if ( window.execScript ) {
						window.execScript( this._stripHTMLComments( javascript ), "JavaScript" );
					}
					else {
						//Using eval.call( window, javascript ) was apparently not really eval'ing
						//in the global scope since 'this' was still referring to the Filter object 
						//and not the window object as it should have (or I think it should have)...
						com_ibm_enabler_aggregation_javascript_globalEvalNonIE( javascript );
					}
				},
				_stripHTMLComments: function( str ) {
					// summary: Strip all HTML comments from a script block.
					// description: Although HTML comments are allowed in a script block by the browser
					//		IE throws up whenever you try and eval a javascript string in the global context
					//		that has HTML comments in the string.
					com.ibm.mm.enabler.debug.entry( "com.ibm.mm.enabler.aggregation.javascript.Filter._stripHTMLComments",  str  );
					
					var resultStr = "";
					var startIndex = str.indexOf( "<!--" );
					
					if ( startIndex != -1 ) {
						resultStr = str.substring( 0, startIndex );
					}
					else {
						resultStr = str;
					}
					
					while ( startIndex >= 0 ) {
						var endIndex = str.indexOf( "-->" );
						if ( endIndex < 0 ) {
							//no closing tag found for the comment, something's wrong
							throw new Error( "Unclosed HTML comment found!!" );
						}
						resultStr += str.substring( endIndex + 3 );
						com.ibm.mm.enabler.debug.log( "com.ibm.mm.enabler.aggregation.javascript.Filter._stripHTMLComments", "result str = " + resultStr );
						startIndex = str.indexOf( "<!--", endIndex + 3 );
					}
					
					com.ibm.mm.enabler.debug.exit( "com.ibm.mm.enabler.aggregation.javascript.Filter._stripHTMLComments",  resultStr  );
					
					return resultStr;
				},
				prepareDocumentWrite: function( buffer ) {
					// summary: Prepares support for document.write() and document.writeln
					// description: Overrides the original document.write() and document.writeln()
					//       functions with functions writing to the buffer
					com.ibm.mm.enabler.debug.entry( "com.ibm.mm.enabler.aggregation.javascript.Filter.prepareDocumentWrite" );
					var me = this;
					document.write = function() {
						me._documentWrite( buffer, document.write.arguments );
					};
					document.writeln = function(str) {
						me._documentWrite( buffer, document.writeln.arguments );
					};
					com.ibm.mm.enabler.debug.exit( "com.ibm.mm.enabler.aggregation.javascript.Filter.prepareDocumentWrite" );
				},
				_documentWrite: function( buffer, /*String[]*/args ) {
					// summary: Internal document.write() function writing to the given buffer
					// description: Just appends the given String arguments to our buffer
					for ( var i = 0; i < args.length; i++ ) {
						buffer.content += args[i];
					}
				},
				applyDocumentWrite: function( /*HTMLElement*/script, buffer ) {
					// summary: Injects the markup in the given buffer into the DOM
					// description: Looks up the script element in the original DOM
					//       and injects the markup before that element
					com.ibm.mm.enabler.debug.entry( "com.ibm.mm.enabler.aggregation.javascript.Filter.applyDocumentWrite",  script, buffer.content );
					var cont = buffer.content;
					var id = script.getAttribute( "id" );
					var realScript = document.getElementById( id );
					if ( cont != null && cont.length > 0 ) {
						var div = document.createElement( "DIV" );
						div.innerHTML = cont;
						var children = div.childNodes;
						if ( children != null && children.length > 0 ) {
							// copy the nodes over into the DOM
							var pred = realScript;
							for ( var i = 0; i < children.length; ) {
								var node = children[children.length-1];
								// we need to inject the markup before the script element
								// to properly handle table updates
								dojo.dom.insertBefore( node, pred );
								pred = node;
							}
						}
						dojo.dom.destroyNode( div );
					}
					// remove id attribute if it is an internal id
					//if (typeof(id)!="undefined" && id!=null && id.indexOf("_scr#") == 0) {
						// defect 187082 - IE doesn't like it when we remove the id from the script element.
						//realScript.removeAttribute("id");
					//}
					com.ibm.mm.enabler.debug.exit( "com.ibm.mm.enabler.aggregation.javascript.Filter.applyDocumentWrite" );
				}
			  }	
);

dojo.declare( "com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter",
			  com.ibm.mm.enabler.aggregation.javascript.Filter,
			  {
			  	doFilter: function ( /*HTMLElement*/script ) {
					// summary: Filter the given event.
					// description: Allows this filter to handle or alter the event. If this function
					//		returns true, processing is stopped and the script is considered "handled".
					// script: the script block (HTMLElement) 
                    
					var url = this._getScriptUrl( script );

					var handled = false;
					
					if ( url ) {
						// check if the AJAX proxy is enabled
						var proxyURL = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
						if (proxyURL != null) {
							proxyURL += "/";
							url = this._rewriteURL(url, proxyURL);
						}
						// prepare buffer for document.write/ln
						var buffer = {content: ""};
						this.prepareDocumentWrite(buffer);
						this._loadExternalScript( url );
						// apply document.write/ln to DOM
						this.applyDocumentWrite(script, buffer);
						handled = true;
					}
					
					return handled;
				},
				_getScriptUrl: function ( /*HTMLElement*/script ) {
					// summary: Retrieve the src attribute value of a script tag if it exists.
					// returns: the url for the script tag or null if the script tag doesn't specify a URL
					var url = null;
					
					if ( script.getAttribute ) {
						url = script.getAttribute( "src" ); 
					}
					else {
						var start = script.toLowerCase().indexOf( "<script" );
						var end = script.toLowerCase().indexOf( ">" );
						
						var scriptTagSubstr = script.substring( start, end );
						var srcIndex = scriptTagSubstr.toLowerCase().indexOf("src");
						
						
						if (srcIndex != -1)
						{
							// figure out whether it's a src='blah' or src="blah"
							var quoteIndex = scriptTagSubstr.indexOf("'", srcIndex);
							var dblQuoteIndex = scriptTagSubstr.indexOf('"', srcIndex);
							var markerChar = '"';
							var markerIndex = dblQuoteIndex;
							if (dblQuoteIndex == -1 || (quoteIndex != -1 && quoteIndex < dblQuoteIndex))
							{
								markerChar = "'";
								markerIndex = quoteIndex;
							}
							var markerIndex2 = scriptTagSubstr.indexOf(markerChar, markerIndex + 1);
							url = scriptTagSubstr.substring(markerIndex + 1, markerIndex2);
						}
					}
					
					return url;
				},
				
				/**
				 * This is reused by space-extension remote script loading.
				 */
				loadExternalScript: function ( /*String*/url ) {
					var proxyURL = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
					if (proxyURL != null) {
						proxyURL += "/";
						url = this._rewriteURL(url, proxyURL);
					}
					
					this._loadExternalScript( url );
				},

				_loadExternalScript: function ( /*String*/url ) {
					var me = this;
					dojo.xhrGet({
						url: url,
						load: function (data,ioArgs) {
							com.ibm.mm.enabler.debug.log("com.ibm.mm.enabler.aggregation.javascript.Filter._loadExternalScript", "Retrieved JS file: ", data );
							me.evalGlobal( data );
						},
						sync: true,
						handleAs: "text"
					});	
				},
				_rewriteURL: function (/*String*/ targetUrl, /*String*/ proxyUrl) {
					var newURL = proxyUrl;
					var host = window.location.host;
					var protocol = window.location.protocol;

					// check if this is a proxy request:
					if (targetUrl.indexOf("://") < 0 || targetUrl.indexOf(protocol) == 0 && targetUrl.indexOf(host) == protocol.length+2) {
						return targetUrl;
					}

					// rewrite
					if (targetUrl.indexOf("https") == 0) 
						newURL += "https/";
					else
						newURL += "http/";

					newURL += targetUrl.substr(targetUrl.indexOf("://") + 3);
					return newURL;
				}
			  }	  
);

dojo.declare( "com.ibm.mm.enabler.aggregation.javascript.InlineScriptFilter",
			  com.ibm.mm.enabler.aggregation.javascript.Filter,
			  {
			  	doFilter: function ( /*HTMLElement*/script ) {
					// summary: Filter the given event.
					// description: Allows this filter to handle or alter the script. If this function
					//		returns true, processing is stopped and the script is considered "handled".
					// script: the script block (HTMLElement) 
                    

					var handled = false, tokenContents = "";
					
					if ( !dojo.isString( script ) ) {
						//Use innerHTML because IE doesn't correctly provide the textContent for a script tag.
						tokenContents = script.innerHTML;
					}
					else {
						var firstIndex = scriptStr.indexOf(">");
						var lastIndex = scriptStr.lastIndexOf("<");
						var scriptStr = script;
						tokenContents = scriptStr.substring(firstIndex+1, lastIndex);
					}
					
					com.ibm.mm.enabler.debug.log("com.ibm.mm.enabler.aggregation.javascript.InlineScriptFilter.doFilter", "Stripped HTML tags out: " + tokenContents, "processScriptArray" );
					if ( tokenContents ) {
						// prepare buffer for document.write/ln
						var buffer = {content: ""};
						this.prepareDocumentWrite(buffer);
						// Eval the contents
						this.evalGlobal( tokenContents );
						handled = true;
						// apply document.write/ln to DOM
						this.applyDocumentWrite(script, buffer);
					}
					
					return handled;	
				}
			  }  
);

dojo.declare( "com.ibm.mm.enabler.aggregation.javascript.FilterChain",
			  null,
{
    		  constructor: function() {
			  	this._filters = new Array();
			  },
 			  	// summary: Controls the registration and execution of the filters associated
				//		with this filter chain.
				
				addFilter: function ( filter ) {
					// summary: Register a filter at the end of the filter chain.
					// filter: the filter to append
					if ( !this._filters ) { this._filters = new Array(); }
					this._filters.push( filter );
				},
				applyFilters: function ( script ) {
					// summary: Execute the filter chain.
					// description: Calls doFilter on every filter registered in this filter chain
					//		until all filters have been called or one of the filters returns true.
					// e: the event object
					// returns: true if the event was handled, false if it was not
					var i = 0;
					var returnValue = false;
					while ( i < this._filters.length && !returnValue )	{
						returnValue = this._filters[i].doFilter(script);
						i = i + 1;		
					}
					
					return returnValue; //Boolean
				}	
			  } 
);

dojo.declare( "com.ibm.mm.enabler.aggregation.javascript.WidgetJavascriptHandler",
			  null,
{
			  constructor:function () {
			  	this.filterChain = new com.ibm.mm.enabler.aggregation.javascript.FilterChain();
			  },
			  	// summary: Examines all javascript included by a widget, modifies it if 
				//		necessary and evaluates it in the global context.
				// description: All script elements must be loaded manually since the widget
				//		markup is added asynchronously. This handler will evaluate a script
				//		element in the global context or load an external script file if necessary.
				
				handle: function ( script ) {
					// summary: Handles a script element added asynchronously.
					// script: the script element
					com.ibm.mm.enabler.debug.entry( "WidgetJavascriptHandler.handle",  script  );
					
					var val = this.filterChain.applyFilters( script );
						
					com.ibm.mm.enabler.debug.exit( "WidgetJavascriptHandler.handle" );
				}
			  }  
);

com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER = new com.ibm.mm.enabler.aggregation.javascript.WidgetJavascriptHandler();

//Register the filters. The order registered is the order executed.
com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER.filterChain.addFilter( new com.ibm.mm.enabler.aggregation.javascript.ExternalScriptFilter() );
com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER.filterChain.addFilter( new com.ibm.mm.enabler.aggregation.javascript.InlineScriptFilter() );


}

if(!dojo._hasResource["com.ibm.mashups.iwidget.itemset"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.itemset"] = true;
dojo.provide("com.ibm.mashups.iwidget.itemset");
dojo.provide("com.ibm.mashups.iwidget.itemset.ItemSet");
dojo.provide("com.ibm.mashups.iwidget.itemset.ManagedItemSet");
dojo.provide("com.ibm.mashups.iwidget.itemset.ManagedItemSetCallbackModel");

/**
Interface to a simple abstraction of a datamodel. This provides a base from which more sofisticated data models can be built.    
@ibm-api
  */
dojo.declare("com.ibm.mashups.iwidget.itemset.ItemSet", null, 
{   
/**
@private
 */
            constructor:function(){
            },
/**
This method sets an item within the ItemSet, creates or replaces an existing entry as needed.
 To append a value to any existing item, suggest to get the current value of this item and append
 the new value to the list and supply the result to this method.
 Marking an item as ReadOnly indicates to the iContext that while this item maybe shared with other components
 on the page, the access of those components should not include changing or removing item.
@param{String}itemName name of the item.Must never be NULL.
@param{Object}value value of the item.Must never be NULL.
@param{Boolean}readOnly optional Boolean attribute to indicate this item is readOnly or not.Default value is false if this parameter is not provided.
@return{ItemSet} return an handle of ItemSet upon successful, NULL upon failure.
 */
            setItemValue: function( /*String*/ itemName, /*Object*/ value,/*boolean*/readOnly ){          
                 return this; 
            }, 
/**
This method returns the value for the named item from the set. 
@param{String}itemName name of the item.Must never be NULL.
@return{ItemSet} return the named item for the set, NULL upon failure.
 */
            getItemValue: function( /*String*/ itemName ){   
                 return null;
            }, 
/**
This method returns an array of Strings,providing the name of each item. 
@return{String[]}  return an array of items names and return NULL if the set contains no item
 */
            getAllNames: function (){
                  return null;
            },
/**
Removes the named item from the set. 
@param{String}itemName name of the item that needs to be removed.Must never be NULL.  
@return{ItemSet} return the handle to the ManagedItemSet upon successful, NULL upon failure.
 */
            removeItem: function(/*String*/itemName){          
               return null; 
            },
/**
This method returns a new ItemSet which is a duplicate of the current ItemSet . 
@return{ItemSet}  return a new ItemSet which contains all the data item in the current ItemSet 
 */
            clone: function (){
                 return null; 
            }, 
/**
This method returns a Boolean indicating whether or not the item specified by the supplied name can be modified by the user.
@param{String}itemName name of the required Item.Must never be NULL.    
@return{Boolean} return a Boolean indicating whether or not the item specified by the supplied name can be modified by the user.Can never be NULL.      
 */
            isReadOnly: function(/*String*/itemName){
                      return null;
            },
/**
As a limitation in Lotus Mashups , this method returns NULL.
@return{Object} return As a limitation in Lotus Mashups , this method returns NULL.      
 */			
            getItemSetDescription:function(){
                     return null;
            }
});
/**
Interface to a simple abstraction of a datamodel. This provides a base from which more sofisticated datamodel can be built.
There're 3 default ManagedItemSet provided in Lotus Mashups. They are attributes, userprofile and  idescriptor.<p/>
<b>attributes</b>  contains iWidget attributes and is usually obtained using  the <code>this.iContext.getiWidgetAttributes()</code>  method .<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Following functions are not supported for attributes:<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>getItemSetDescription:function(){}</code><br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>clone:function(){}</code><p/>
<b>userprofile</b> contains user attributes and is usually obtained using the  <code>this.iContext.getUserProfile() </code> method .<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; In Lotus Mashups , all the user attributes are readonly.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Following functions are not supported for userprofile:<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>setItemValue:function(name,value,readOnly){} </code><br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>removeItem:function(name){}</code> <br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>save:function(cb){}</code> <br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>getItemSetDescription:function(){}</code><br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>clone:function(){}</code><p/>
<b>idescriptor</b> contains  iDescriptor items as defined by iWidget spec1.0 section5.2 and is usually obtained using the  <code>this.iContext.getiDescriptor() </code> method .<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; In Lotus Mashups , all the iDescriptor items are readonly.<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Following functions are not supported for idescriptor:<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>setItemValue:function(name,value,readOnly){} </code><br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>removeItem:function(name){}</code> <br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>save:function(cb){}</code> <br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>getItemSetDescription:function(){}</code><br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <code>clone:function(){}</code><p/>

@ibm-api
 */	
dojo.declare("com.ibm.mashups.iwidget.itemset.ManagedItemSet",com.ibm.mashups.iwidget.itemset.ItemSet,{
/**
@private
 */            
			constructor:function(){            
            },
/**
This method requests the iContext save the current state of the ManagedItemSet. 
The iContext MAY also choose to save the ManagedItemSet at times other than when iWidgets request a save. 
This method MAY operate asynchronously.  The iContext  MUST invoke any supplied callbackFn upon completion of the save attempt. 
It need to be implemented by each subclass...signiture of callback function is as follows</br>
	&nbsp;&nbsp;&nbsp;<code>function(in String managedItemSetName, in Boolean success);</code>
@param{com.ibm.mashups.iwidget.itemset.ManagedItemSetCallbackModel.postSaveCallbackFn}callbackfn optional callback function	
@type void
 */			
             save: function(callbackfn){
            }
});

/**
This API defines the callback functions for ManagedItemSet. 
@ibm-api
 */	
dojo.declare("com.ibm.mashups.iwidget.itemset.ManagedItemSetCallbackModel",null,{
/**
@private
 */            
			constructor:function(){            
            },
/**
This method defines the callback function after save operation.  IWidget may provide this function when invoke <code> managedItemSet.save(callbackfn)</code>.
The iContext will invoke callbackfn upon save completion.
@param{String}managedItemSetName  name of ManagedItemSet: attributes,idescriptor,userprofile.Must never be NULL.
@param{Boolean}success boolean indicates if save operation is successful or not.	
@type void
 */			
            postSaveCallbackFn: function(/*String*/managedItemSetName,/*Boolean*/success){
            }
});






}

if(!dojo._hasResource["com.ibm.mm.iwidget.itemSetImpl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.itemSetImpl"] = true;
dojo.provide("com.ibm.mm.iwidget.itemSetImpl");

dojo.provide("com.ibm.mm.iwidget.itemset");


dojo.declare("com.ibm.mm.iwidget.itemset.Item", null, {
            constructor:function(name,value,isReadOnly,descriptionId){        
                this.name = name;        
                this.value = value; 
                this.descriptionId = descriptionId;
                if (typeof isReadOnly == "undefined"  || isReadOnly == null) 
                    this.isReadOnly = false;
                else
                    this.isReadOnly = isReadOnly;   
            }
});  

dojo.declare("com.ibm.mm.iwidget.itemset.DefaultItemSetImpl", com.ibm.mashups.iwidget.itemset.ItemSet, {    
            constructor:function(parent,name,onItemSetChanged,description,isPrivate){
				if(parent){
					this.parent = parent.id;
					this.scope = parent.iScope;
				}
                this.name = name;
                this.onItemSetChanged = onItemSetChanged;
                this.description = description;
                this.isPrivate = isPrivate;
                this.items = {};
                this.listeners = {};
                if (onItemSetChanged) {
                    this.listeners[onItemSetChanged] = onItemSetChanged;
                }
                this._debug = com.ibm.mm.enabler.debug;
            },
            addListener:function(/*obj*/fn){
                 this.listeners[fn.toString()] = fn;
            },
            removeListener:function(/*obj*/fn){
                 if (this.listeners[fn.toString()]) {
                     this.listeners[fn.toString()] = null;
                 }  
            },
            setItemValue: function( /*String*/ itemName, /*Object*/ value,/*boolean*/readOnly ){          
                 this._debug.log("ItemSet.setItemValue ","itemName:"+itemName,"value:"+value,"readOnly:"+readOnly);
                 if ( typeof value == "undefined") return null;

                 var isReadOnly = false;
                 if (!(typeof readOnly == "undefined" || readOnly == null)) isReadOnly = readOnly;
                    this._debug.log("ManagedItemSet.setItemValue","creating new Item ("+"itemName:"+itemName+" value:"+value+" readOnly:"+readOnly+")");

                    var item = new com.ibm.mm.iwidget.itemset.Item(itemName,value,isReadOnly);
                    if (this.items[itemName]){              
                        // replace the old one only if the old item is not readOnly
                        this._debug.log("ManagedItemSet.setItemValue","Itemset readOnly is "+ this.items[itemName].isReadOnly);
                        if ( this.items[itemName].isReadOnly == "true" ){                  
                            return null;     
                        }
                        else{ 
                            var payload = {itemSetName: this.name,changeType:"changedValue"}
                            payload.old = this.items[itemName].value;
                            payload["new"] = value;
                            var iEvent = new com.ibm.mm.iwidget.iEventImpl("onItemSetChanged",null,payload);
                            this.items[itemName] =item;  
                            this._handleOnItemSetChanged(iEvent);
                        }          
                    }          
                    else{         
                        var payload = {itemSetName: this.name,changeType:"newItem"}
                        payload["new"] = value;
                        var iEvent = new com.ibm.mm.iwidget.iEventImpl("onItemSetChanged",null,payload);
                        this.items[itemName] =item;  
                        this._handleOnItemSetChanged(iEvent);
                    }
                    return this;  
                },  
            getItemValue: function( /*String*/ itemName ){   
                 var anItem = this.items[itemName];
                 if (typeof anItem == "undefined" || anItem == null) return null;
                    var value = this.items[itemName].value;
                 if (typeof value == "undefined" || value == null) return null;         
                 return value;
            },   
            getAllNames: function (){
                 if (typeof this.items == "undefined" || this.items == null ) return null;         
                 var names = new Array();  
                 var aName;    
                 var i=0;    
                 for ( aName in this.items){              
                     names.push(aName);  
                     i=i+1;        
                 }  
                 if (i==0) return null; 
                 return names;
            },   
            removeItem: function(/*String*/itemName){          
                 if (this.items[itemName]){    
                     if ( this.items[itemName].isReadOnly && this.items[itemName].isReadOnly == "true" ){                  
                         return null;     
                     }
                     else if (this.items[itemName] == null)     
                         return null;                    
                }          
                 var payload = {itemSetName: this.name,changeType:"removedItem"};
                 payload.old = this.items[itemName].value;
                 var iEvent = new com.ibm.mm.iwidget.iEventImpl("onItemSetChanged",null,payload);
                 this.items[itemName] = null;  
                 this._handleOnItemSetChanged(iEvent);
                 return this;
            },
            clone: function (){

                 var newItemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(null,this.name);
                 var arr = this.items;  
                 var anItem;        
                 for (anItem in arr){   
                     var newItem = new com.ibm.mm.iwidget.itemset.Item();
                     newItem = dojo.mixin(newItem,this.items[anItem]);           
                     newItemSet.items[newItem.name] = newItem;         
                 }
                 return newItemSet;
            }, 
            isReadOnly: function(/*String*/itemName){
                 this._debug.entry("ManagedItemSet.isReadOnly", "itemName:"+itemName);
                var anItem = this.items[itemName];
                if (typeof anItem == "undefined" || anItem == null ) return false;
                return anItem.isReadOnly;         
            },
            getItemSetDescription:function(){
                 return null;
            },
            _handleOnItemSetChanged:function(iEvent){  
                 for (var i=0; i<this.listeners;i++) {
                     var fn = this.listeners[i];
                     if (fn != null && this.scope) {
                         dojo.hitch(this.scope,fn)(iEvent);
                     }
                 }
            }
});

dojo.declare("com.ibm.mm.iwidget.itemset.iDescriptor",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{
            constructor:function(widgetId,defiDescriptor,instanceiDescriptor){
                this.widgetId = widgetId;
                this.defiDescriptorItems = defiDescriptor;    //associative array
                this.instanceiDescriptorItems = instanceiDescriptor;   //associative array
            },
            getItemValue:function(/*string*/name){
                 var value=null;
                 if(typeof name != "undefined" && name != null && name == iwConstants.iDescriptorItems.mode){
                     var widgetWrapper = this._getWidgetWrapper();
                     if (widgetWrapper != null) {
                         value = widgetWrapper.currentMode;
                     }
                 }
                 else{
                     value = this._getItemValue(/*String*/name);
                 }
                 return value;
            },
            _getItemValue:function(/*String*/itemName){
                 if (this.defiDescriptorItems != null) {
                     var defItem = this.defiDescriptorItems.getItemValue(itemName);
                 }
                 if (this.instanceiDescriptorItems != null) {
                     var instanceItem = this.instanceiDescriptorItems.getItemValue(itemName);   
                 }
                      
                 if (typeof instanceItem != "undefined" &&  instanceItem != null) 
                 return instanceItem;

                 if (typeof defItem == "undefined")  defItem = null;
                 return defItem;
            },
            setItemValue:function(name,value,readOnly){
                 //readonly
                 return null;
            },
            isReadOnly:function(name){
                 return true;
            },
            _getWidgetWrapper:function(){
                 if (this.widgetId) {
                     var widget=iWidgetContainer.widgetArr[this.widgetId];
                     if ( widget && widget != null ) return widget;
                 }
                 return null;
            },
            removeItem:function(name){
                 return null;
            },
            getAllNames:function(){
                 var arr = {};
                 if (this.defiDescriptorItems != null) {
                     var defNames = this.defiDescriptorItems.getAllNames();
                     for (var i in defNames) {
                         arr[defNames[i]] = true;
                     }
                 }
                 if (this.instanceiDescriptorItems != null) {
                     var instanceNames = this.instanceiDescriptorItems.getAllNames();
                     for (var j in instanceNames) {
                         arr[instanceNames[j]] = true;
                     }
                 }
                 var nameArr = [];
                 for (var name in arr) {
                     nameArr.push(name);
                 }
                 return nameArr;
            },
            save:function(cb){
                 return null;
            },
            getItemSetDescription:function(){
                 return null;
            }
            //todo:clone
}); 

// INTERNAL PRIVATE CLASS - do NOT use directly
// Use PersistentAttributes instead
dojo.declare("com.ibm.mm.iwidget.itemset.InternalPersistentAttributesToPreferenceModelAdapter", com.ibm.mashups.iwidget.itemset.ManagedItemSet, {
    //Provides an the ItemSet interface to to the preference subsystem
    constructor: function(widget, serverless) {
        this.xmlItems = {};
        
        // 6326 this.microformatItems = {};

        this.serverless = (serverless == true);

        this.modes = com.ibm.mm.iwidget.itemset._internalIbmModes;
        
        this.widget = widget; 
        
        this.widgetInstance = this.widget.getIWidgetInstance(); // 6326

        this.attributes = this.widgetInstance.getAttributes(); // 6326

/*
        if (this.serverless)
            return;
            
        this.personalNodeName = this._getHackOid(widget.id, "p_"); 
        this.instanceNodeName = this._getHackOid(widget.id, "i_");
        this.definitionNodeName = this._getHackOid(widget.getIWidgetInstance().widgetXMLUrl, "d_");

        this._init();
*/        
    },
    
    
    setItemValue: function( itemName, value, readOnly, _mode){ 
        value = value ? value : "";

        value = "" + value;  // TODO: Need to change to json object

        // TODO: find out whether the fact this needs to be done is a bug
        if (typeof readOnly == "string")
            readOnly = (readOnly.toLowerCase() == "true");
        else
            readOnly = (readOnly == true);

        if (this.serverless) {
            var mode = this._getMode(_mode);
            if (mode != this.modes.xml && mode != this.modes.microformat)
                return null; 

            var xmlItem = this.xmlItems[itemName];
            if (xmlItem && xmlItem.readOnly)
                return null;
            if (mode == this.modes.xml) {
                this.xmlItems[itemName] = {value: value, readOnly: readOnly};
                return this;
            }

//  6326          var mfItem = this.microformatItems[itemName];
//  6326          if (mfItem && mfItem.readOnly)
//  6326              return null;
//  6326          this.microformatItems[itemName] = {value: value, readOnly: readOnly};
            
            this.attributes.setItemValue(itemName, value); // 6326
            return (this);
        }

        return null;
/*
        var items = this._getItems(_mode, false)            
        if (items) {
            var item = items[itemName];
            if (item && item.readOnly)
                return null;    
            items[itemName] = {value: value, readOnly: readOnly};
            return this;
        }
        
        var prefSet = this._getPrefSet(_mode, false);
        var prefNode = prefSet.getPreference(itemName);
        if (prefNode) {
            if (prefNode.isReadOnly())
                return null;     
        }
        else {
            prefNode = prefSet.create({ type : "PreferenceNode", name : itemName});
            prefSet.insert(prefNode);
        }
        
        value = encodeURIComponent(value);
        
        // TODO: remove workaround prefNode.setValues([]) when for bug in pref system is fixed
        if (value == "")
            prefNode.setValues([])
        else
            prefNode.setValue(value);
            
        prefNode.setReadOnly(readOnly);
        this._dirtyPrefSets(_mode);  // TODO: after following bug in pref model is fixed, <-- this can be removed
                                     // Bug 492: Peformance Enhancement for Attributes ItemSet -- reduce hierarchy recalcuations 
        return this;
*/          
    }, 

    getItemValue: function(itemName, _mode, _merge){
        if (this.serverless) {
            var mode = this._getMode(_mode);
            if (mode != this.modes.xml && mode != this.modes.microformat)
                return null; 

            if (_merge == undefined)
                _merge = true;

            var xmlItem = this.xmlItems[itemName];
            // 6326 var mfItem = this.microformatItems[itemName];
            if (mode == this.modes.xml) {
                if (!xmlItem)
                    return null;
                return xmlItem.value;
            }
            
            var value = this.attributes.getItemValue(itemName); //6236
            
            if (_merge && xmlItem && (xmlItem.readOnly || (value == null))) //6326 
                    return xmlItem.value;

            // 6326 var value = mfItem.value; 
            return value; // 6326
        }

        return null;
/*
        var items = this._getItems(_mode, _merge)            
        if (items) {
            var item = items[itemName];
            if (item)
                return item.value;
            return null;
        }

        var prefSet = this._getPrefSet(_mode, _merge);
        
        var prefNode = prefSet.getPreference(itemName);
        if (!prefNode)
            return null;
        var value = prefNode.getValue();
        value = decodeURIComponent(value);
        return value;
*/        
    }, 

    getAllNames: function (_mode, _merge){
        if (this.serverless) {
            var mode = this._getMode(_mode);
            if (mode != this.modes.xml && mode != this.modes.microformat)
                return null; 
            if (_merge == undefined)
                _merge = true;
            
            if (!_merge) {
                if (mode == this.modes.xml)
                    return this._getNamesArray(this.xmlItems);
                    
                // 6326 return this._getNamesArray(this.microformatItems);
                return this.attributes.getAllNames(); // 6326
            }
                
            var mergedItems = {};
            var name;
            for (name in this.xmlItems) { 
                mergedItems[name] = true; 
            }
            var allNames = this.attributes.getAllNames();
            for (name in allNames) {                        // 6326
                mergedItems[allNames[name]] = true;         // 6326
            }                                               // 6326
            return this._getNamesArray(mergedItems);
        }

        return null;
/*        
        var i=0;
        var names = new Array();  

        var prefSet = this._getPrefSet(_mode, _merge);
        prefSet.setCursorPosition(0);
        while (prefSet.hasNext()) {
            var node = prefSet.next();
            names.push(node.getName());
            i++;
         }  
         if (i==0)
             return null; 
         return names;
*/         
    },

    removeItem: function(itemName, _mode){          
        if (this.serverless) {
            var mode = this._getMode(_mode);
            if (mode != this.modes.microformat)
                return null;
            // 6326 if (this.microformatItems[itemName])
            // 6326    delete this.microformatItems[itemName];
            
            this.attributes.removeItem(itemName); // 6326
            return this;    
        } 
        
        return null;
/*
        var prefSet = this._getPrefSet(_mode, false);
        var node = prefSet.getPreference(itemName);
        
        if (node) {
            prefSet.remove(node);
            this._dirtyPrefSets(_mode);  // TODO: after performance bug in pref model is fixed, this can be removed
        }
        
        return this;
*/        
    },

    clone: function (){
        // TODO: Not sure what to do here
        return null;
    }, 

    isReadOnly: function(/*String*/itemName, _mode, _merge){   	
        if (this.serverless) {
            var mode = this._getMode(_mode);
            if (mode != this.modes.xml && mode != this.modes.microformat)
                return false; 

            if (_merge == undefined)
                _merge = true;

            var xmlItem = this.xmlItems[itemName];
            // 6326 var mfItem = this.microformatItems[itemName];
            var mfItem = null; // 6326 temp hack until read only is supported
            if (mode == this.mode.xml) {
                if (!xmlItem)
                    return false;
                return xmlItem.readOnly;
            }

            if (_merge && xmlItem && (xmlItem.readOnly || (mfItem == null))) 
                   return xmlItem.readOnly;

            // 6326 return mfItem.readOnly;      
            return false; // 6326 temp hack until read only is supported
        }

        return null;
/*        
        var prefSet = this._getPrefSet(_mode, _merge);
        var prefNode = prefSet.getPreference(itemName);
        if (!prefNode)
            return false;
        return prefNode.isReadOnly();
*/        
    },

    save: function(callbackfn){
        if (this.serverless)
            this._saveMicroformat();
        else
            return null;
 /*
            this.pm.commit().start();
            // TODO: when error handling is available, should use it
*/        
        this.reload();
        
        if (callbackfn)
            callbackfn();
            
        return(this);
    },

    reload: function(){
        if (this.serverless)
            return this;

        return null;
/*            
        this.personalNode = null;
        this.instanceNode = null;
        this.definitionNode = null;
        this.personalPrefSet = null;
        this.instancePrefSet = null;
        this.definitionPrefSet = null;
        this.personalHierPrefSet = null;
        this.instanceHierPrefSet = null;
        this.definitionHierPrefSet = null;
        this._init();
        return (this);
*/        
    },
        
    _getNamesArray: function (items){
        var i=0;
        var names = new Array();  
        var name;

        for (name in items) {
            names.push(name);
            i++;
        }

        if (i==0)
            return null;
                
        return names;
    },

    _saveMicroformat: function(){
        /* 6326 var attributeItemSets;
        var i;
        var ns = this.widget.ns;
        var root = this.widget.rootElement;
        attributeItemSets = dojo.query('span.' + ns + 'ItemSet[title="' + iwConstants.ATTRIBUTES + '"]', root);
        for (i = 0; i < attributeItemSets.length; i++) {
            var itemSet = attributeItemSets[i];
            if (root == itemSet.parentNode)
                root.removeChild(itemSet);
        }
        
        var newItemSet = document.createElement("span");
        newItemSet.className = ns + 'ItemSet';
        newItemSet.title = iwConstants.ATTRIBUTES;
		newItemSet.style.display = "none";
		newItemSet.style.visibility="hidden";
        root.appendChild(newItemSet);

        var names = this.getAllNames(this.modes.microformat, false);
        if (!names)
            return;
            
        for (i = 0; i < names.length; i++) {
            var itemName = names[i];
            var itemValue = this.getItemValue(itemName, this.modes.microformat, false);
            var newItem = document.createElement("a");
            newItem.className = ns + 'Item';
            newItem.style.visibility = "hidden";
			newItem.style.display="none"
            newItem.href = "#" + itemName;
            newItem.appendChild(document.createTextNode(itemValue));
            newItemSet.appendChild(newItem);          
        } 6326 */
    	
    	// Seems like committing the whole widget is overkill, but just trying to
    	// commit the attributes causes problems.
    	this.widget.commit();
		var payloadObj = {};
		payloadObj.wid = this.widget.id;
		this.widget.eventSvr._publishEvent(iwConstants.EVENTS.onAttributeSaved,payloadObj,this.widget.hubId);				
   },
    
    _setMode: function(mode){
        //TODO: make obsolete when real mode support is available
        this._mode = mode;
    },
        
    _getMode: function(_mode){
        if (_mode)
            return _mode;
            
        //TODO: hook to real mode support when it is available
        if (!this._mode)
            this._mode = this.modes.microformat;
        return this._mode; 
    }
});

/*    
    _getHackID: function(idText, prefix){
        var id;
        var strippedText = idText.replace(/\W+/g, "");
        var len = strippedText.length;
        if (len >= 34)
            id = prefix + strippedText.slice(-34)
        else
            id = "__________________________________".slice(0, 34 - len) + prefix + strippedText;
            
        id = "id:" + id;
        return id;
    },

    _init: function() {
        if (this.serverless)
            return;

        // TODO: try with empty user
        this.pm = new com.ibm.mm.enabler.model.internal.PreferenceModelImpl("user");
        
        // TODO:  when lookup strategy is implemented use it
        // Bug 491: Peformance Enhancement for Attributes ItemSet -- reduce server hits
         
        // TODO:  what can be in uri, can I use / or colons or other characters

        this.personalNode = this.pm.find(this.personalNodeName).start();
        this.instanceNode = this.pm.find(this.instanceNodeName).start();
        this.definitionNode = this.pm.find(this.definitionNodeName).start();
        
        if (!this.definitionNode) {
            this.definitionNode = this.pm.create({id : this.definitionNodeName}); 
            this.pm.insert(this.definitionNode, null);
        }
            
        if (!this.instanceNode) {
            this.instanceNode = this.pm.create({id : this.instanceNodeName}); 
            this.pm.insert(this.instanceNode, this.definitionNode);
        }
        
        if (!this.personalNode) {
            this.personalNode = this.pm.create({id : this.personalNodeName}); 
            this.pm.insert(this.personalNode, this.instanceNode);
        }
            
        // TODO: when error handling is available, should use it
    },

    _initializeInstancePreferencesFromMicroformat: function(){
        var instancePreferences = dojo.query("span.com_ibm_attributes_internalInstancePreferences", this.widget.rootElement);
        for (var i = 0; i < instancePreferences.length; i++) {
            var itemSet = instancePreferences[i];
            var items = dojo.query("a.com_ibm_attributes_internalInstancePreference", itemSet);
            for (var j = 0; j < items.length; j++) {
                var item = items[j];
                var itemValue = decodeURIComponent(item.innerHTML);
                var itemName = null;
                var index = item.href.indexOf ("#");
                if (index != -1) {
                    itemName = item.href.substring(index+1);
                }
                if (itemName) {
                    if (itemName.indexOf("ro" == 2)) {
                        this.setItemValue(itemName.substring(2),itemValue,true, this.modes.microformat);
                    } else if (itemName.indexOf("rw" == 2)) {
                        this.setItemValue(href.substring(2),itemValue,false, this.modes.microformat);
                    }
                }
            }
        }
    },

    _saveInstancePreferencesToMicroformat: function(){
        var i;
        var instancePreferences = dojo.query("span.com_ibm_attributes_internalInstancePreferences", this.widget.rootElement);
        for (i = 0; i < instancePreferences.length; i++) {
            var itemSet = instancePreferences[i];
            itemSet.parentNode.removeChild(itemSet);
        }
        var newItemSet = document.createElement("span");
        newItemSet.className = "com_ibm_attributes_internalInstancePreferences";
        this.widget.rootElement.appendChild(newItemSet);

        var names = this.getAllNames(this.modes.microformat, false);
        if (!names)
            return;
            
        for (i = 0; i < names.length; i++) {
            var itemName = names[i];
            var itemValue = encodeURIComponent(this.getItemValue(itemName, this.modes.microformat, false));
            var readOnly = this.isReadOnly(itemName, this.modes.microformat, false);
            var newItem = document.createElement("a");
            newItem.className = "com_ibm_attributes_internalInstancePreference";
            newItem.setAttribute("style", "visibility:hidden");
            newItem.href = "#" + (readOnly ? "ro" : "rw") + itemName;
            newItem.innerHTML = itemValue;
            newItemSet.appendChild(newItem);          
        }
    },

    _getItems: function(mode, merge){
        if (merge == undefined || merge)
            return null;
            
        if (!mode)
            mode = this._getMode();
            
        var items = null;
        
        if(mode == this.modes.xml)
            items = this.xmlItems;
        else if (mode == this.modes.microformat)
            items = this.microformatItems;
            
        return items;
    },
            
    _preLevelItemsHook: function(level){
        if (level == "ADMIN")
            return this.xmlItems;
        if (level == "INSTANCE")  
            return this.microformatItems;
    },
    
    _getPrefSet: function(mode, merge){
        if (!mode)
            mode = this._getMode();

        if(mode == this.modes.xml)
            mode = this.modes.configure;
        else if (mode == this.modes.microformat)
            mode = this.modes.microformat;

        if (merge == undefined)
            merge = true;

        if (mode == this.modes.configure) {
            if (merge) {
                if (!this.definitionHierPrefSet)
                    this.definitionHierPrefSet = this.pm.getHierarchyPreferenceSetModel(this.definitionNode, this);
                prefSet = this.definitionHierPrefSet;
            } else {
                if (!this.definitionPrefSet)
                    this.definitionPrefSet = this.pm.getPreferenceSetModel(this.definitionNode);
                prefSet = this.definitionPrefSet;
            }
        }

        else if (mode == this.modes.microformat) {
            if (merge) {
                if (!this.instanceHierPrefSet)
                    this.instanceHierPrefSet = this.pm.getHierarchyPreferenceSetModel(this.instanceNode, this);
                prefSet = this.instanceHierPrefSet;
            } else {
                if (!this.instancePrefSet)
                    this.instancePrefSet = this.pm.getPreferenceSetModel(this.instanceNode);
                prefSet = this.instancePrefSet;
            }
        }
        else {
            if (merge) {
                if (!this.personalHierPrefSet)
                    this.personalHierPrefSet = this.pm.getHierarchyPreferenceSetModel(this.personalNode, this);
                prefSet = this.personalHierPrefSet;
            } else {
                if (!this.personalPrefSet)
                    this.personalPrefSet = this.pm.getPreferenceSetModel(this.personalNode);
                prefSet = this.personalPrefSet;
            }
        }

        return prefSet;
    },
        
    _dirtyPrefSets: function (mode){
        if (!mode)
            mode = this._getMode();
        if (mode == this.modes.configure) {
            this.definitionHierPrefSet = null;
            this.instanceHierPrefSet = null;
            this.personalHierPrefSet = null;
        }
        else if (mode == this.modes.microformat) {
            this.instanceHierPrefSet = null;
            this.personalHierPrefSet = null;
        }
        else {
            this.personalHierPrefSet = null;
        }
    }
});
*/    

dojo.declare("com.ibm.mm.iwidget.itemset.PersistentAttributes",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{
    constructor: function(widgetDefinitionUrl, widgetInstanceId, serverless) {

        this._internalPersistentAttributesToPreferenceModelAdapter = 
                new com.ibm.mm.iwidget.itemset.InternalPersistentAttributesToPreferenceModelAdapter(
                        widgetDefinitionUrl, widgetInstanceId, serverless);
    },
    
    setItemValue: function(itemName, value, readOnly){
        return this._internal().setItemValue(itemName, value, readOnly);          
    }, 

    getItemValue: function(itemName){
        return this._internal().getItemValue(itemName);          
    }, 

    getAllNames: function (){
        return this._internal().getAllNames();          
    },

    removeItem: function(itemName){          
        return this._internal().removeItem(itemName);          
    },

    clone: function (){
        return this._internal().clone();          
    }, 

    isReadOnly: function(itemName, _mode, _merge){
        return this._internal().isReadOnly(itemName);          
    },

    save: function(callbackfn){
        return this._internal().save(callbackfn);          
    },
    
    _internal: function() {
        return this._internalPersistentAttributesToPreferenceModelAdapter;
    }

});

com.ibm.mm.iwidget.itemset._internalIbmModes = {
    view:"view",
    edit:"edit",
    edit_default:"edit_default",
    microformat:"com.ibm.microformat",
    configure:"configure",
    xml:"com.ibm.xml",
    help:"help"
};

dojo.declare("com.ibm.mm.iwidget.itemset.UserProfile",com.ibm.mashups.iwidget.itemset.ManagedItemSet,{
            constructor:function(widgetId,user){
                this.widgetId = widgetId;
                this.user = user;
            },
            getItemValue:function(/*string*/name){
                 var value = this.user.getAttribute(name);
                 if(typeof value == "undefined") value = null;
                 return value;
            },
            setItemValue:function(name,value,readOnly){
                 //readonly
                 return null;
            },
            isReadOnly:function(name){
                 return true;
            },
            removeItem:function(name){
                 return null;
            },
            getAllNames:function(){
                 return this.user.getAttributeNames();
             },
            save:function(cb){
                 return null;
            },
            getItemSetDescription:function(){
                 return null;
            }
            //todo:clone
}); 


}

if(!dojo._hasResource["com.ibm.mm.iwidget.payloadDef"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.payloadDef"] = true;
dojo.provide("com.ibm.mm.iwidget.payloadDef");


dojo.declare("com.ibm.mm.iwidget.payloadDef", null, 
{
    constructor:function(name,type,defaultValue,description,attributes) {
        this.name = name;
        this.attributes = attributes;
        if (typeof (this.attributes) == "undefined" || this.attributes == null ) {
            this.attributes = {};
        }

        if (typeof type != "undefined" && type != null ) 
            this.attributes["type"] = type;
        if (typeof defaultValue != "undefined" && defaultValue != null ) 
           this.attributes["defaultValue"] = defaultValue;
        if (typeof description != "undefined" && description != null ) 
                   this.attributes["description"] = description;

        this.attributeNames = [];
        this.attributeNames.push("type");
        this.attributeNames.push("defaultValue");
        this.attributeNames.push("description");

        var aName;
        for (aName in attributes) {
            this.attributeNames.push(aName);
        }
        this.children = new com.ibm.mm.enabler.ArrayMap();/*an array of payloadDef*/
   },
   setAttribute:function(name,defaultValue){
        this.attributes[name] = defaultValue;
        if (typeof (this.attributeNames[name]) != "undefined"){
            this.attributeNames.push(name);
        }
   },
   getAttribute:function(name){
        var defaultValue =  this.attributes[name];
        if (typeof defaultValue == "undefined") {
            defaultValue = null;
        }
        return defaultValue;
   },
   getAttributeNames:function(){
        this.attributeNames;
   },
   getChildren:function(){
        return this.children.values();
   },
   getChild:function(name){
        return this.children.get(name);
   },
   setChild:function(name,/*object*/payloadDef){
         this.children.put(name,payloadDef);
   },
   getChildrenNames:function(){
       this.children.keySet();
   },
   getName:function(){
        return this.name;
   },
   getType:function(){
        return this.attributes["type"];
   },
   getDefaultValue:function(){
           return this.attributes["defaultValue"];
   },
   getDescription:function(){
           return this.attributes["description"];
   }
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.utils"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.utils"] = true;
dojo.provide("com.ibm.mm.iwidget.utils");




dojo.declare("com.ibm.mm.iwidget.UtilImpl",null,{

   widgetClassRE:new RegExp("(mm:|mm_|iw-)iWidget"),

   findElementByAttribute:function(/*String*/att,/*String*/value,/*DOMElement*/root,/*[]*/element,hasMultiple){
   
       var aRoot = root;
       if (!root.childNodes || root.childNodes == null) return false; 
	   
	   if(att && att != null && att == "class"){
			dojo.query("."+value,root).forEach(
				function(ele) {
					element.push(ele);
				}
			);
			if(element.length != 0) return true;
			return false;
	   }
	   
	   //other attributes
	   if ( root.getElementsByTagName){
	   	   
			var nodes = root.getElementsByTagName("*");
			for (var i =0 ; i< nodes.length; i++){
				var aNode = nodes[i];
				if (aNode && aNode.getAttribute ){
				var childValue = aNode.getAttribute(att);
				if (childValue == value){
					element.push(aNode);
					if(!hasMultiple) return true;
				}
				}			
			}	   
	   }
	   return false;
       
    
   },  
   
   getClass:function(/*object*/node){
        var childValue = node.getAttribute("class");
        childValue = childValue?childValue:node.getAttribute("className");
        return childValue;
   },

   checkParentElement:function(/*Node*/selfNode, /*RegExp*/classToFind)
   {
	   if (selfNode) {
		   var dadNode = selfNode.parentNode;
		   if (dadNode) {
			   if (dadNode.className) {
				   if (dadNode.className.match(classToFind)) {
					   return dadNode.id;
				   }
			   }
			   return this.checkParentElement(dadNode, classToFind);
		   }
	   }
	   return null;
   },

   getWidgetParent:function(/*Domnode*/node, /*RegExp*/classToFind)
   {
	   if (dojo.isString(node) == true) node = dojo.byId(node);
	   if (!classToFind) {
		   classToFind=this.widgetClassRE;
	   }
	   
	   return this.checkParentElement(node,classToFind);
   },

   getParents:function(/*widget*/widget,/*array*/arr)
   {
       var parent = widget.getParent();
       if (typeof parent != "undefined" && parent != null) {
           arr.push(parent);
           this.getParents(parent,arr);
       } 
       return;
   },
   getPayloadDef:function(aNode){
       var name = aNode.getAttribute("name");
       var payloadDef = new com.ibm.mm.iwidget.payloadDef(name);
       var attributes = aNode.attributes;
       //var attributesArr = [];
       for (var i=0;i<attributes.length;i++)
       {    
           var anAttribute = attributes[i];
           if (anAttribute.name != "name"){
              payloadDef.setAttribute(anAttribute.name,anAttribute.value);
           }   
       }
       var children = aNode.childNodes;
       for (var j=0;j<children.length;j++){
           var child = children[j];
           if ( child.nodeType == 1){
               var aChildPayloadDef = this.getPayloadDef(child);
               payloadDef.setChild(aChildPayloadDef.name,aChildPayloadDef);
           }
       }
       return payloadDef;
   }                      
});

com.ibm.mm.iwidget.utils = new com.ibm.mm.iwidget.UtilImpl();





}

if(!dojo._hasResource["com.ibm.mashups.iwidget.iContext"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.iContext"] = true;
dojo.provide("com.ibm.mashups.iwidget.iContext");
dojo.provide("com.ibm.mashups.iwidget.iEvents");
dojo.provide("com.ibm.mashups.iwidget.io");




/**
 This interface defines methods that the iWidget can use to interact with the iContext.  
 An iContext instance is created specifically for each iWidget instance and a reference will be set in iWidget encapsulation object.
 Thus within iWidget encapsulation class, iContext should be referred to by using <b>"this.iContext"</b><p/>
  &nbsp;&nbsp;&nbsp; <code>var root = this.iContext.getRootElement();</code><p/> 

  @ibm-api
  */
dojo.declare("com.ibm.mashups.iwidget.iContext", null, {
  
	/**
            * @private
            */
    constructor:function () {    
    },
/**
Defines constants that's available in iContext.<br/>
Constants defined within iContext can be referred as follows:</p>

   &nbsp;&nbsp;&nbsp; <code>this.iContext.constants.mode.VIEW</code><br/>
   &nbsp;&nbsp;&nbsp; <code>this.iContext.constants.mode.EDIT</code><br/>
   &nbsp;&nbsp;&nbsp;<code>this.iContext.constants.mode.HELP</code><br/>
   &nbsp;&nbsp;&nbsp;<code>this.iContext.constants.ATTRIBUTES</code><br/>
   &nbsp;&nbsp;&nbsp;<code>this.iContext.constants.IDESCRIPTOR</code><br/>
   &nbsp;&nbsp;&nbsp;<code>this.iContext.constants.USERPROFILE</code><br/>
 </code>   
@type object
 */	
    constants:{
       /*@type object*/ 
       mode:{
	       /*@type String*/ 
           VIEW:/*String*/"view",//The generated markup fragment(s) should reflect normal interaction with the iWidget
		   /*@type String*/ 
           EDIT:/*String*/"edit",//The generated markup fragment(s) should reflect iWidget interactions for editing iWidget attributes
		   /*@type String*/ 
           HELP:/*String*/"help"//The iWidget should generate markup fragment(s) to assist the user with interacting with the iWidget
       },
	   /*@type String*/ 
       ATTRIBUTES:/*String*/"attributes",   //Name for the ManagedItemSet holding the customization attributes.
	   /*@type String*/ 
       IDESCRIPTOR:/*String*/"idescriptor", //Name for the ManagedItemSet holding the items describing the iWidget
	   /*@type String*/ 
       USERPROFILE:/*String*/"userprofile", //Name for the ManagedItemSet holding data about the user
	   /*@type Object*/ 
       keys:{
		   /*@type int*/ 
           SHIFT:/*int*/1,
		   /*@type int*/ 
           ALT:/*int*/2,
		   /*@type int*/ 
           CTRL:/*int*/4,
		   /*@type int*/ 
           META:/*int*/8,
		   /*@type int*/ 
           CAPSLOCK:/*int*/16
       } 
   },
/**
Returns the root element of the iWidget such that iWidget can easily do things such as  searching its own markup. 
RootElement can also be a convenient place to place items which iWidget wishes to access later.
@type DOMElement       
@return{DOMElement}  rootElement of the iWidget. return <code>null</code> if element is not available.
*/   
    getRootElement:function(){
         return null; 
	},
/**
This method provides the same semantics as the DOM method by the same name with the distinction that this method will restrict the search to the iWidget's markup rather than the entire page
 @param{String} id  element id. Must never be NULL.
 @param{DOMElement} root  optional DOMElement to define a search scope, it will search in the scope of current active mode if root is not provided.
 @type DOMElement
 @return{DOMElement} return the element, or <code>null</code> if element is not found.
*/	
    getElementById: function(/*String*/id,/*DOMNode*/root){
          return null;
    },
/**
This method returns the ManagedItemSet that provides access to the iWidget's customization attributes.  
If there is no ManagedItemSet  related to the iWidget's customization attributes, this method MUST create an empty set and return it.
@type com.ibm.mashups.iwidget.itemset.ManagedItemSet 
 @return{com.ibm.mashups.iwidget.itemset.ManagedItemSet } return the ManagedItemSet or empty ManagedItemSet if no customization attributes is found.
*/	
    getiWidgetAttributes: function(){
         return {};
    }, 
/**
This method returns an ItemSet corresponding to the requested name. If it does not already exist, an ItemSet will be created and associated with the supplied name. 
@param{String}name name of ItemSet.Must never be NULL.
@param{Boolean}isPrivate optional, the "private" parameter controls whether or not the ItemSet can be exposed to other components. If the ItemSet already exists, the "private" parameter is ignored.  
@type com.ibm.mashups.iwidget.itemset.ItemSet
@return{com.ibm.mashups.iwidget.itemset.ItemSet} return the requested ItemSet or <code> null</code> if access is denied.
*/		
    getItemSet:function(/*String*/ name,/*Boolean*/isPrivate){
           return null;
    },
/**
Provides means for iWidget to declare dependency on set of shared resource support dynamic loads in asynchronous manner. JS and CSS resources are supported. 
@param{String} requiredItem  name of the Item that needs to be loaded. Must never be NULL.
@param{String}version  optional -- not supported for Lotus Mashups
@param{String}uri uri of the resource. Must never be NULL.
@param{Object}cb optional  not supported for Lotus Mashups 
@param{String}mimeType  optional -- not supported for Lotus Mashups
@type void
*/	
    requires: function(/*String*/ requiredItem,/*String*/version,/*String*/uri,/*function*/cb,/*String*/mimeType){
    },
/**
This method returns an instance of type Object which was initialized prior to the loading of the iWidget (either as a generic Object or an instance of the encapsulation Object ) . Its purpose is to support proper 
encapsulation of the iWidget's assets (variables and methods) such that multiple instances of the iWidget can be loaded into a
single page's DOM without stepping on each other.
 So iWidget resources can refer to any functions that's defined within iWidget encapsulation object by using iContext.iScope().fn(); 
 @type Object
@return{Object} return an instance of the encapsulation class or return a generic object 
*/		
    iScope:function(){
          return null; 
    },
/**
This method requests the iContext to process the markup such that it can be inserted into the iWidget's markup and properly interact with the page.
(i.e. all the iContext reference in the markup needs to be properly namespaced). Where, when and how the markup is inserted into the page
is the responsibility of the iWidget.
@param{String}markup  markupString that needs to be processed.Must never be NULL.
@type String
@return  On success this method MUST return the processed markup while on failure it MUST return null 
*/	
    processMarkup:function(/*String*/markup){
             return null;
    },
/**
This method requests the iContext to process the subtree under the supplied node for the purpose of resolving and instantiating any referenced iWidgets.
@param{DOMNode}root root element of the subtree. Must never be NULL.
@type void
*/		
    processiWidgets:function(/*DOMNode*/root){
        //summary: This method requests the iContext to process the subtree under the supplied node for the purpose of resolving and instantiating any referenced iWidgets.
        //root: root element of the subtree
    },
/**
This method returns an array of Elements within the iWidget's markup which have the supplied value as one of those specified by the Element's "class" attribute.
@param{String}classname  name of class attribute. Must never be NULL.
@param{DOMElement}root root element of the subtree. Must never be NULL
@type DOMElement[]
@return{DOMElement[]} return an array of elements
*/	
    getElementByClass:function(/*String*/classname,/*DOMElement*/root){
        return null;   
    },
/**
This method returns the ManagedItemSet that provides access to the user's profile data. 
@type com.ibm.mashups.iwidget.itemset.ManagedItemSet 
@return{com.ibm.mashups.iwidget.itemset.ManagedItemSet } if there is no ManagedItemSet related to the user's profile, this method creates an empty set and returns it. If access to the user's profile is denied, this method returns null. 
*/	
    getUserProfile:function(){
        return null;
    },
/**
This method returns the ManagedItemSet that provides access to iWidget's descriptive items.
@type com.ibm.mashups.iwidget.itemset.ManagedItemSet 
@return {com.ibm.mashups.iwidget.itemset.ManagedItemSet } If there is no ManagedItemSet  related to the iWidget's descriptive items this method creates an empty set and returns it.. 
*/
    getiDescriptor:function(){
         return null;
    },
/**
This method returns the path to the widget's XML definition file.
@type String
@return  Returns a string representing the path to the widget's XML definition file. 
*/	
    getWidgetXMLPath:function(){
             return null;
    },
/**
This object provides access to io service. io service is accessible by using "this.iContext.io".<p/>
@type com.ibm.mashups.iwidget.io
 */	
	io:{},
/**
This object provides access to events service. event service is accessible by using "this.iContext.iEvents".<p/>
@type com.ibm.mashups.iwidget.iEvents
 */	
	iEvents:{}
});  

/**
This interface defines methods that's  used for event distribution and event management. Events service is accessible by using <b>"this.iContext"</b><p/>
  &nbsp;&nbsp;&nbsp; <code>this.iContext.iEvents</code><p/> 
  To distribute an event:<p/>
  &nbsp;&nbsp;&nbsp; <code>this.iContext.iEvents.fireEvent("eventName");</code><p/>   

  @ibm-api
  */
dojo.declare("com.ibm.mashups.iwidget.iEvents",null,
{	/**
            * @private
            */
    constructor:function () {
 
    },
/**
This method informs the iContext to distribute an event with proper payload and payload type
@param{String} eventName name of the event that needs to be distributed.Must never be NULL.
@param{String} payloadType optional,type of the payload.
@param{object} payload optional,object of the payload that needs to be distributed together with the event     
@type void
*/	
    fireEvent:function(/*String*/eventName,/*String*/payloadType,/*object*/payload){
    },
/**
This method simply creates a new event definition or updates an existing event if the name already exists. <br/>
It returns true if new event is created successfully or existing event is updated successfully. It returns false if it fails to create new event or update existing event.<br/>
@param{com.ibm.mashups.iwidget.IEventDescription} eventDesc IEventDescription object.Must never be NULL.
@type Boolean
@returns{Boolean} returns true if new event is created successfully or existing event is updated successfully. It returns false if it fails to create new event or update existing event.
*/	
    setEvent:function(/* iEventDescription*/ eventDesc){
	},
/**
This method removes an existing event description.It returns true if event is removed successfully or event doesn't exist, otherwise it returns false. <br/>
@param{String} eventName event name.Must never be NULL.
@type Boolean
@returns{Boolean} returns true if event is removed successfully or event doesn't exist, otherwise it returns false. 
*/
   removeEvent:function(/*String*/ eventName){
   },
/**
The query method which takes a javascript object as condition, it returns a list of event descriptions which matches the given condition. <br/>
The scope of the events is limited to this iwidget instance. The returning result need to match all the conditions that's given. <br/>
For exampe, if a condition object looks like this: {type:'text', isHandled:true}<br/>
This method will return all the handled event description whose payload is text.<br/>
If no condition is provided, this method will return all the events. It returns null if no event is found for a given condition.Only predefined fields or non localized attributes should be used to define condition.
@param{Object} condition  JSON object that contains the condition.Must never be NULL.
@type com.ibm.mashups.iwidget.IEventDescription
@returns{com.ibm.mashups.iwidget.IEventDescription} returns an array of event description that matches the condition. It returns null if no event is found for a given condition. 
*/
   getEvents:function(/*Object*/ condition){
   },   
/**
This method allows to create a new IEventDescription object. All the data should be passed in as a JSON object.<br/>
Following rules applied to the JSON object:<br/>
1. Predefined fields: name,type,isHandled,isPublished,lang,handlingFn<br/>
2. Localized attributes: please see sample below<br/>
3. Non-localized attributes: please see sample below<br/>
4. Lotus Mashups provides a feature to allow a widget to register a private event so this event will not be exposed to other iwidgets by the wiring interface<br/>
&nbsp;&nbsp;&nbsp;private attribute is used to mark an event to be a private event. please see sample below<br/>
<code>
 &nbsp;&nbsp;&nbsp;var obj = {name:"sendData",  type:"text", isHandled:"true", lang:"en", handlingFn:"onSendData", <br/>
 &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;localizedAttributes:{  <br/>
  &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;"en":{"title":"mytitle_en","description":"mydescription_en"},<br/>
  &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;"fr":{"title":"mytitle_fr","description":"mydescription_fr"}  <br/>
  &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;} ,      <br/>
  &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;attributes:{  namespace:"com.ibm.mashups", onRemoveWire:"handleRemoveWire",private:"true"} <br/>
 &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;  };<br/>
 &nbsp;&nbsp;&nbsp;var event = this.iContext.iEvents.createEventDescription(obj);<br/>
 &nbsp;&nbsp;&nbsp;this.iContext.iEvents.setEvent(event);<br/>
</code>
@param{Object} object  JSON object that contains all the data to create an IEventDescription. Must not be NULL.
@type com.ibm.mashups.iwidget.IEventDescription
@returns{com.ibm.mashups.iwidget.IEventDescription} returns an  IEventDescription . It returns null if it fail to create the iEventDescription. 
*/ 
  createEventDescription:function(/* Object */object){
  }
	
});

/**
This interface defines support the iContext is supplying regarding IO operations.<p/>
  &nbsp;&nbsp;&nbsp; <code>this.iContext.io.rewriteURI(aUri);</code><p/> 
 
  @ibm-api
  */
dojo.declare("com.ibm.mashups.iwidget.io",null,
{
	/**
            * @private
            */
	constructor:function () {
 
    },
/**
This method takes a URI as a parameter and returns a URI which the browser can resolve for accessing the supplied URI. 
Examples of usage include resolving a relative URI against the source of the iWidget's definition and resolving other URIs to address any intermediate
 gateways, such as a proxy server. <p/>
  &nbsp;&nbsp;&nbsp;Sample usage that resolves URI to address a proxy server ,assume url to proxy server is "/mum/proxy".<br/>
 <code>
  &nbsp;&nbsp;&nbsp; var aUri = "http://yourco.com/mytest.js"; <br/>
  &nbsp;&nbsp;&nbsp; var rc = this.iContext.io.rewriteURI(aUri); <br/>
</code>
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;the result will be "/mum/proxy/http/yourco.com/mytest.js"<br/>
<br/>
 &nbsp;&nbsp;&nbsp;Sample usage that resolves a relative URI against the source of the iWidget's deinfition<br/>
 &nbsp;&nbsp;&nbsp; Assume iwidget is included on a page as follows:<br/>
 <code>
 &nbsp;&nbsp;&nbsp; &lt;span id="yourcoWidget" class="mm_iWidget"&gt;&lt;a class="mm_Definition" href="/mm/widget-catalog/yourcoWidget.xml"&gt;&lt;/a&gt;&lt;/span&gt;<br/><br/>
 &nbsp;&nbsp;&nbsp; var aUri = "mytest.js"; <br/> 
 &nbsp;&nbsp;&nbsp; var rc = this.iContext.io.rewriteURI(aUri);  <br/>
</code>
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;the result will be "/mm/widget-catalog/mytest.js" <br/>     
<br/>
 &nbsp;&nbsp;&nbsp;Sample usage that resolves a relative URI against the source of the iWidget's deinfition for an image resource.<br/>
 &nbsp;&nbsp;&nbsp; Assume iwidget is included on a page as follows:<br/>
 <code>
 &nbsp;&nbsp;&nbsp; &lt;span id="yourcoWidget" class="mm_iWidget"&gt;&lt;a class="mm_Definition" href="http://yourco.com/mm/widget-catalog/yourcoWidget.xml"&gt;&lt;/a&gt;&lt;/span&gt;<br/><br/>
 </code>
 &nbsp;&nbsp;&nbsp;the url for the img resource  of following code will be "http://yourco.com/mm/widget-catalog/mytest.gif" <br/>
 <code>
 &nbsp;&nbsp;&nbsp; var aUri = "mytest.gif"; <br/> 
 &nbsp;&nbsp;&nbsp; var returnUri = this.iContext.io.rewriteURI(aUri,false);  <br/> 
 &nbsp;&nbsp;&nbsp; var img = dojo.byId(id); <br/>
 &nbsp;&nbsp;&nbsp;  img.src = returnUri;<br/>
</code>     
@param{String} uri URI that needs to be resolved. Must never be NULL.
@param{Boolean} isXhr optional,boolean indicating the url is used as xhr. If no value is provided, the default is true.
@type String
@returns{String} return a URI which the browser can resolve for accessing the supplied URI.Must never be NULL.
*/	
    rewriteURI:function(/*String*/uri,/*Boolean*/isXhr){ 
           return null;
    }
 });
  

















}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.catalog"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.catalog"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.catalog" );
dojo.provide("com.ibm.mashups.enabler.model.CatalogCategoryModel");
dojo.provide("com.ibm.mashups.enabler.model.CatalogElementModel");
dojo.provide("com.ibm.mashups.enabler.catalog.CatalogNode");
dojo.provide("com.ibm.mashups.enabler.catalog.CatalogCategory");
dojo.provide("com.ibm.mashups.enabler.catalog.CatalogElement");



/**
 * Interface for a catalog model containing category nodes. This tree model 
 * describes the topology in which the categories are structured.
 * As of now only one level below the root is supported; no child categories.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.CatalogCategoryModel", com.ibm.mashups.enabler.TreeModelController,     {
  /**
      * @private
      */
    constructor:function ( ) {
    },

    /**
     * Returns the catalog entry model for the given category.
     * @param {CatalogCategoryNode} category the CatalogCategoryNode for which 
     * to return the CatalogEntryModel; must not be <code>null</code>
     * @type CatalogEntryModel 
     * @return catalog entry model for given category, Never <code>null</code>. 
     */
    getCatalogEntryModel: function (category) {
        return new CatalogEntryModel(); 
    },

    /**
     * creates a new CatalogCategoryNode. The created node can be inserted into 
     * the model using an appropriate <code>insert</code> method. The node will 
     * not appear in the model unless it is inserted.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted names are:<br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>category</code> - the name of the category 
     * to be created (mandatory)<br>
     * @type CatalogCategoryNode 
     * @return the created node 
     */
    create: function (context) {
        return new CatalogCategoryNode();
    },

    /**
     * Commits the modifications applied to this model and all dependant models.<br>
     * After the model is committed successfully, this method must not be called 
     * again. The same is true for any other method modifying the model or its nodes.
     * @type Deferred 
     * @return a deferred object used to start this operation. The return value 
     * when executed through the deferred object is <code>null</null>
     */
    commit: function () {
        return new Deferred();
    }
});

/**
 * Interface for a catalog model containing entry nodes. This list model 
 * describes a list of concrete catalog entries for a given category.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.CatalogEntryModel", com.ibm.mashups.enabler.ListModelController, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * creates a new CatalogEnryNode. The created node can be inserted into the
     * model using an appropriate <code>insert</code> method. The node will not 
     * appear in the model unless it is inserted.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted 
     * names are:<br>
     * &nbsp;&nbsp;&nbsp;&nbsp;<code>cid</code> - the client id for the entry 
     * to be created (optional)<br>
     * @type CatalogEntryNode 
     * @return the created node
     */
    create: function (context) {
        return new CatalogEntryNode();
    }

});

/**
 * Interface that represents a catalog category; used in the CatalogCategoryModel
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.catalog.CatalogCategoryNode", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.ModifiableLocalized],     {
  /**
      * @private
      */
    constructor:function ( ) {
    }
});

/**
 * Interface that represents a catalog entry; used in the CatalogEntryModel
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.catalog.CatalogEntryNode", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.ModifiableLocalized, com.ibm.mashups.enabler.ModifiableMetaData],     {
  /**
      * @private
      */
    constructor:function ( ) {
    },

    /**
     * Returns the definition URL of this catalog entry
     * @param {boolean} optional parameter to resolve endpoint:// url default is true
     * @type String 
     * @return the definition url, never <code>null</code>
     */
    getDefinitionURL: function(resolveEndpoints) {
        return new String();
    },
	
    /**
     * Returns the icon URL of this catalog entry
     * @param {boolean} optional parameter to resolve endpoint:// url default is true 
     * @type String 
     * @return the icon url, never <code>null</code>
     */
    getIconURL: function(resolveEndpoints) {
        return new String();
    },
	
	/**
     * Returns the preview thumbnail URL for this catalog entry
     * @param {boolean} optional parameter to resolve endpoint:// url default is true 
     * @type String 
     * @return the preview thumbnail url, may be <code>null</code>
     */
    getPreviewThumbnailURL: function(resolveEndpoints) {
        return new String();
    },
	
	/**
	 * Returns the preview URL for this catalog entry
	 * @param {boolean} optional parameter to resolve endpoint:// url default is true
	 * @type String
	 * @return the preview url, may be <code>null</code>
	 */
	getPreviewURL: function(resolveEndpoints) {
		return new String();
	},

    /**
     * Returns the help URL for this catalog entry
     * @param {boolean} optional parameter to resolve endpoint:// url default is true 
     * @type String 
     * @return the help url, may be <code>null</code>
     */
    getHelpURL: function(resolveEndpoints) {
        return new String();
    },

    /**
     * Sets the definition URL of this catalog entry
     * @param {String} url definition url to set; must not be <code>null</code>
     * @type void
     */
    setDefinitionURL: function(url) {
    },
    /**
     * Confirms whether setting the url is possible.
     * @param {String} url definition url to set; must not be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetDefinitionURL: function(url) {
        return new Boolean(); 
    },

    /**
     * Sets the icon URL of this catalog entry
     * @param {String} url icon url to set; must not be <code>null</code>
     * @type void
     */
    setIconURL: function(url) {
    },
    /**
     * Confirms whether setting the url is possible.
     * @param {String} url icon url to set; must not be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetIconURL: function(url) {
        return new Boolean(); 
    },
	
	/**
     * Sets the preview thumbnail URL of this catalog entry
     * @param {String} url preview thumbnail url to set; may be <code>null</code>
     * @type void
     */
    setPreviewThumbnailURL: function(url) {
    },
    /**
     * Confirms whether setting the url is possible.
     * @param {String} url preview thumbnail url to set; may be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetPreviewThumbnailURL: function(url) {
        return new Boolean(); 
    },
	
	/**
     * Sets the preview URL of this catalog entry
     * @param {String} url preview url to set; may be <code>null</code>
     * @type void
     */
    setPreviewURL: function(url) {
    },
    /**
     * Confirms whether setting the url is possible.
     * @param {String} url preview url to set; may be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetPreviewURL: function(url) {
        return new Boolean(); 
    },

    /**
     * Sets the help URL of this catalog entry
     * @param {String} url help url to set; may be <code>null</code>
     * @type void
     */
    setHelpURL: function(url) {
    },
    /**
     * Confirms whether setting the url is possible.
     * @param {String} url help url to set; may be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetHelpURL: function(url) {
        return new Boolean(); 
    },
	
	/**
     * Returns the short description of this object in the given locale.
     * @param {String} locale   the locale for which to retrieve the 
     * short description, must not be <code>null</code>.
     * @return {String} the short description of this node in the given locale. If a 
     * short description is not available in the given locale, this method 
     * will return <code>null</code>. It is up to the invoker of the 
     * method to implement an appropriate fallback mechanism.
     */
    getShortDescription: function(locale) {
        return new String(); 
    },
	
	/**
     * Sets the short description for the given locale.
     * @param {String} desc     short description to set; must not be <code>null</code>
     * @param {String} locale   locale to set the short description for; must not be <code>null</code>
     * @return {String} the former short description; if none existed, <code>null</code> is returned
     */
    setShortDescription: function(desc, locale) {
        return new String(); 
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.theme"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.theme"] = true;
dojo.provide("com.ibm.mashups.enabler.model.theme");



/**
 * An interface that allows the retrieval and setting of a Theme object that
 * is associated with a resource.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.ThemeProvider", null, {
    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * Returns the theme id associated with this element.
     * @type String
     * @return the theme id for this element or <code>null</code> if none was set.
     * @deprecated use com.ibm.mashups.enabler.ThemeProvider.getThemeIdentifier instead
     */
    getTheme: function(){
        return new String();
    },
    
    /**
     * Sets the theme id.
     * @param {String} theme theme id to set, must not be <code>null</code>.
     * @type void
     * @deprecated use com.ibm.mashups.enabler.ThemeProvider.setThemeIdentifier instead
     */
    setTheme: function(theme){
    },
    
    /**
     * Returns the theme identifier associated with this element.
     * @type com.ibm.mashups.enabler.Identifiable
     * @return theme identifier for this element or <code>null</code> if none
     * was set.
     */
    getThemeIdentifier: function(){
        return new com.ibm.mashups.enabler.Identifiable();
    },
    
    /**
     * Sets the theme by its identifier.
     * @param {com.ibm.mashups.enabler.Identifiable} theme identifier to set, must not be <code>null</code>.
     * @type void
     */
    setThemeIdentifier: function(theme){
    }
    
});


/**
 * Interface for a theme model. This list model describes a list of theme objects.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.model.ThemeModel", [com.ibm.mashups.enabler.ListModel, com.ibm.mashups.enabler.ResourceLocator], {
    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * Returns the skin model for the given theme.
     * @param {Theme} theme the Theme for which to return the skin model;
     * must not be <code>null</code>
     * @type SkinModel
     * @return skin model for given theme, Never <code>null</code>.
     */
    getSkinModel: function(theme){
        return new SkinModel();
    }
    
});

/**
 * Interface that represents a theme; used in the ThemeModel
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.theme.Theme", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.Localized, com.ibm.mashups.enabler.MetaData], {
    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * Returns the base url of the theme.
     * @type String
     * @return base url of the theme. can never be <code>null</code>
     * @deprecated Since 2.0. Use ThemeModel/ResourceLocator findResourceUrl instead
     */
    getBaseUrl: function(){
        return new String();
    },
    
    /**
     * Returns the default skin id for the given theme.
     * @type String
     * @return the default skin id for given theme, <code>null</code> in case of no default skin set.
     * @deprecated use com.ibm.mashups.enabler.ThemeProvider.getDefaultSkinIdentifier instead
     */
    getDefaultSkin: function(){
        return new String();
    },
    
    /**
     * Returns the default skin identifier for this theme.
     * @type com.ibm.mashups.enabler.Identifiable
     * @return the default skin id for this theme, <code>null</code> in case of
     * no default skin set.
     */
    getDefaultSkinIdentifier: function(){
        return new com.ibm.mashups.enabler.Identifiable();
    }
    
});

/**
 * Interface for a skin model. This list model describes a list of skin objects.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.model.SkinModel",  [com.ibm.mashups.enabler.ListModel, com.ibm.mashups.enabler.ResourceLocator], {
    /**
     * @private
     */
    constructor: function(){
    }
});

/**
 * Interface that represents a skin; used in the SkinModel
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.theme.Skin", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.Localized, com.ibm.mashups.enabler.MetaData], {
    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * Returns the base url of the skin
     * @type String
     * @return base url of the skin. can never be <code>null</code>
     * @deprecated Since 2.0. Use ThemeModel/ResourceLocator findResourceUrl instead
     */
    getBaseUrl: function(){
        return new String();
    },
    
    /**
     * Returns an image which can be used for preview urls
     * @type String
     * @return url to an image; may be <code>null</code>
     */
    getPreviewUrl: function(){
        return new String();
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.navigation"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.navigation"] = true;
dojo.provide("com.ibm.mashups.enabler.model.navigation");
dojo.provide("com.ibm.mashups.enabler.model.NavigationModel");
dojo.provide("com.ibm.mashups.enabler.navigation.NavigationNode");




/**
 * Interface for a navigation model. This tree model describes the topology in 
 * which the navigation is structured.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.NavigationModel", [com.ibm.mashups.enabler.TreeModelController, com.ibm.mashups.enabler.model.SelectionLocator], {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns whether or not the given node has an attached layout model.
     * 
     * @param   {Object} node   node object or node uri (without any scope)
     *                          for which to check if it has a layout model. Must 
     *                          not be <code>null</code>.
     * @type    Boolean
     * @return  <tt>true</tt> if the specified node has a layout model, <tt>false</tt> otherwise  
     */
    hasLayoutModel: function (node) {
        return new Boolean();
    },
    
    /**
     * Returns the layout model for the given page.
     * @param {NavigationNode} node the NavigationNode or, if node is a string, 
     * the uri of the node for which to return its model. The page must be part 
     * of this model. Must not be <code>null</code>.
     * @type com.ibm.mashups.enabler.model.LayoutModel
     * @return a layout model or <code>null</code> if none exists. 
     */
    getLayoutModel: function (node) {
        return new com.ibm.mashups.enabler.model.LayoutModel();
    },

    /**
     * Returns a special node of the model defining the root of all pages that 
     * are shared with a user. May be <code>null</code> if the navigation tree is empty
     * @type Deferred(Object)
     * @return a deferred object used to start this operation. The return value 
     * when executed through the deferred object is the shared root object of the tree model
     */
    getSharedRoot: function () {
        return new Deferred();
    },

    /**
     * Confirms whether exporting the node is possible.
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
     * @return {Boolean} true if the node can be exported, otherwise false.
     */
    confirmExport: function(node) {
        return new Boolean(); 
    },

    /**
     * creates a new navigation node object. The created node can be inserted 
     * into the model using an appropriate <code>insert</code> method defined 
     * on a subinterface of this interface. The node will not appear in the model 
     * unless it is inserted.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted 
     * names are:<br>
     * &nbsp;&nbsp;<code>template</code> - creates a new navigation node based on 
     * the specified com.ibm.mashups.enabler.navigation.NavigationNode
     * @type com.ibm.mashups.enabler.navigation.NavigationNode
     * @return the created node
     */
    create: function (context) {
        return new com.ibm.mashups.enabler.navigation.NavigationNode();
    },

    /**
     * Commits the modifications applied to this model and all dependant models<br>
     * After the model is committed successfully, this method must not be called 
     * again. The same is true for any other method modifying the model or its nodes.
     * @type Deferred
     * @return a deferred object used to start this operation. The return value 
     * when executed through the deferred object is <code>null</null>
     */
    commit: function () {
        return new Deferred();
    }
});

/**
 * Interface representing a navigation node
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.navigation.NavigationNode", 
[com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.ModifiableLocalized, com.ibm.mashups.enabler.ModifiableMetaData, com.ibm.mashups.enabler.ThemeProvider, com.ibm.mashups.enabler.RepresentationProvider], {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns whether this navigation node is flagged as hidden. It is the responsibility of the
     * UI to render the navigation correctly and honor this flag.
     * @type Boolean
     * @return true if the navigation is flagged as hidden, otherwise false
     */
    isHidden: function() {
        return new Boolean();
    },

    /**
     * Allows to flag the navigation node as hidden or visible.
     * @param {Boolean} hide true to hide the navigation, otherwise false
     * @type void
     */
    setHidden: function(hide) {
        return new Boolean();
    },
	
    /**
     * Confirms whether setting the hidden flag is possible.
     * @param {Boolean} hide true to hide the space, otherwise false
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetHidden: function(hide) {
        return new Boolean(); 
    },

	/**
     * Returns the URL for export page and post page to hub, or <code>null</code>
     * if no resource link has been put into navigation feed.
     * @type String
     * @return the link for export page.
     */
    getExportPageURL: function() {
        return new String();
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.user"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.user"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.user" );



/**
 * Constant class defining the anonymous mode
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.user.AnonymousMode", null, {
    
    /**
    * Constant defining that a normal user is accessing the system
    * @type {AnonymousMode}
    */
    USER:       "user",
    /**
    * Constant defining that an anonymous user is accessing the system
    * @type {AnonymousMode}
    */
    ANONYMOUS:  "anonymous"
    
});
com.ibm.mashups.enabler.user.AnonymousMode = new com.ibm.mashups.enabler.user.AnonymousMode();

/**
 * Interface for a user model used to search for user and groups
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.UserModel", [com.ibm.mashups.enabler.ListModel, com.ibm.mashups.enabler.Locator], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * Returns the mode in which the anonymous user is accessing the system.
   * @return {AnonymousMode} the mode in which the anonymous user is accessing the system. Never <code>null</code>.
   */
    getAnonymousMode: function() {
    },

   /**
   * Returns the current user. 
   * @type Deferred 
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is the current user or <code>null</code>.
   */
    findCurrentUser: function () {
        return new Deferred();
    },

   /**
   * Returns a user array that matches the LDAP query attributeName=attributeValue 
   * @param {String} attributeName name of the LDAP query
   * @param {String} attributeValue value of the LDAP query
   * @type Deferred
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is an array of User objects. 
   * Never <code>null</code>.
   */
    findUsersByAttribute: function (attributeName, attributeValue) {
        return new Deferred();
    },

   /**
   * Returns the group with the given id or null if no such group exists 
   * @param {String} id the id
   * @type Deferred
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is the group with the given id 
   * or <code>null</code>.
   */
    findGroupByID: function (id) {
        return new Deferred(); 
    },

   /**
   * Returns a group array that matches the LDAP query attributeName=attributeValue 
   * @param {String} attributeName name of the LDAP query
   * @param {String} attributeValue value of the LDAP query
   * @type Deferred
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is an array of Group objects. 
   * Never <code>null</code>.
   */
    findGroupsByAttribute: function (attributeName,attributeValue) {
        return new Deferred(); 
    },

   /**
   * Returns an array of attributes for the searchable Group attributes in the 
   * user repository. 
   * @type Attribute[] 
   * @return an array of searchable group attributes. Never <code>null</code>.
   */
    findGroupAttributes: function() {
        return []; 
    },

   /**
   * Returns an array of attributes for the searchable User attributes in the 
   * user repository. 
   * @type  Attribute[] 
   * @return an array of searchable user attributes. Never <code>null</code>.
   */
    findUserAttributes: function() {
        return []; 
    },
	
   /**
   * Returns an array of Virtual Users (like Anonymous)
   * @type  User[] 
   * @return an array registered virtual users. Never <code>null</code>.
   */
    getVirtualUsers: function(){
        return [];
    },
    
   /**
   * Returns an array of Virtual Groups (like All Authenticated)
   * @type  Group[] 
   * @return an array registered virtual groups. Never <code>null</code>.
   */
    getVirtualGroups: function(){
        return [];
    },
	
   /**
   * Returns the attribute names for Lookaside properties as string array.
   * Does not include non-lookaside attribute names 
   * @type String[] 
   * @return all lookaside attributes names as string array; never  <code>null</code>.
   */
    getLookasideAttributeNames:function(){
        return []; 
    }
});

/**
 * Interface representing an entity which acts as a base class for a user or a group
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.user.Entity", [com.ibm.mashups.enabler.Identifiable], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * Returns a useful display name. Currently CN + SN for users and CN for groups 
   * @type String 
   * @return the display name; may be <code>null</code>.
   */
    getDisplayName:function () {
        return new String();
    },

   /**
   * Returns the value of user LDAP CN attribute 
   * @type String 
   * @return the value of the CN attritibute; may be <code>null</code>.
   */
    getCN:function () {
        return new String(); 
    },

   /**
   * Returns the value of the given  attribute name 
   * @param {String} name the attribute name to look up
   * @type String 
   * @return the value of the given attribute name; may be <code>null</code>.
   */
    getAttribute:function(name){
        return new String(); 
    },

   /**
   * Returns the attribute names as string array.
   *  
   * @type String[] 
   * @return all attributes names as string array; never  <code>null</code>.
   */
    getAttributeNames:function(){
        return []; 
    }	
});

/**
 * Interface representing a user
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.user.User", [com.ibm.mashups.enabler.user.Entity], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * Returns the user LDAP principalName attribute
   * @type String 
   * @return the login name; may be <code>null</code>.
   */
    getLoginName:function () {
        return new String(); 
    },

   /**
   * Returns the user LDAP SN attribute
   * @type String 
   * @return the value of the SN attribute; may be <code>null</code>.
   */
    getSN:function () {
     
        return new String();
    },

   /**
   * Returns a String representation of the user's email 
   * @type String 
   * @return the user's email; may be <code>null</code>.
   */
    getEmail:function () {
        return new String();
    },
    
    /**
     * Sets the value for the attribute identified by the specified name.
     * @param {String} name     name of attribute to set the value for; must not be <code>null</null>
     * @param {String} value    attribute value to set; must not be <code>null</null>
     * @return {String} the former value for the name; if none existed, <code>null</code> is returned
     */
    setAttribute: function(name, value) {
        return new String(); 
    },
    
    /**
     * Removes the attribute identified with the specified name.
     * @param{String} name  name of attribute to remove; must not be <code>null</null>
     * @return {String} the former value for the name; if none existed, <code>null</code> is returned
     */
    removeAttribute: function(name) {
        return new String();
    }  
});

/**
 * Interface representing the current user
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.user.CurrentUser", [com.ibm.mashups.enabler.user.User], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * Returns the J2EE principalName attribute
   * @type String 
   * @return the J2EE principal name; may be <code>null</code>.
   */
    getJ2EEPrincipalName:function () {
        return new String(); 
    }
});

/**
 * Interface representing a group
 * 
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.user.Group", [com.ibm.mashups.enabler.user.Entity], {
  /**
      * @private
      */
    constructor:function () {
    }
});

/**
 * Interface representing an attribute used in an enitity
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.user.Attribute", null, {
  /**
      * @private
      */
   constructor:function () {
   },
   
   /**
    * Returns the attribute name
    * @type     String
    * @return   the attribute name; never <code>null</code>.
    */
   
   getName:function () {
        return new String(); 
   },

   /**
    * Returns the attribute type
    * @type     String
    * @return   the attribute type; never <code>null</code>.
    */
   getType:function () {
        return new String(); 
   }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.factory"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.factory"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.factory");






/**
 * Interface representing a model factory
 *
 */
dojo.declare( "com.ibm.mashups.enabler.model.Factory", null, {
    
    /**
     * Returns the catalog category model
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.CatalogCategoryModel
     * @return  catalog category model, never <code>null</code>
     */
    getCatalogCategoryModel: function() {
        return new com.ibm.mashups.enabler.model.CatalogCategoryModel();
    },

    /**
     * Returns the navigation model
     * 
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.NavigationModel
     * @return  navigation model, never <code>null</code>
     */
    getNavigationModel: function() {
        return new com.ibm.mashups.enabler.model.NavigationModel(); 
    },

    /**
     * Returns the shared navigation model
     * 
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.SharedNavigationModel
     * @return  shared navigation model, never <code>null</code>
     */
    getSharedNavigationModel: function() {
        return new com.ibm.mashups.enabler.model.SharedNavigationModel(); 
    },
    
//    getPreferenceModel: function(user) {
//        // summary: returns a preference model
//        // name: the name of the user
//        return new com.ibm.mashups.enabler.model.PreferenceModel(user);  /*PreferenceModel @return preference model*/
//    },
    
    /**
     * Returns the theme model
     * 
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.ThemeModel
     * @return  theme model, never <code>null</code> 
     */
    getThemeModel: function() {
        return new com.ibm.mashups.enabler.model.ThemeModel();
    },

    /**
     * Returns the user model
     * @type com.ibm.mashups.enabler.model.UserModel
     * @return user model, never <code>null</code>
     */
    getUserModel: function() {
        return new com.ibm.mashups.enabler.model.UserModel();  
    },
	
    /**
     * Returns the remote model
     * @type com.ibm.mashups.enabler.model.RemoteModel
     * @return remote model, never <code>null</code>
     */	
	getRemoteModel: function() {
         return new com.ibm.mashups.enabler.model.RemoteModel();  
    },

    /**
     * Returns the space model
     * 
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.SpaceModel
     * @return  space model, never <code>null</code>
     */
    getSpaceModel: function() {
        return new com.ibm.mashups.enabler.model.SpaceModel();
    },
	
    /**
     * Returns the template model
     * 
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.TemplateModel
     * @return  template model, never <code>null</code>
     */
    getTemplateModel: function() {
        return new com.ibm.mashups.enabler.model.TemplateModel();
    },
	
	/**
     * Returns the space extension model
     * 
     * @ibm-api
     * @type    com.ibm.mashups.enabler.model.SpaceExtensionModel
     * @return  space extension model model, never <code>null</code>
     */
    getSpaceExtensionModel: function() {
        return new com.ibm.mashups.enabler.model.SpaceExtensionModel();
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.layout"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.layout"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.layout" );
dojo.provide("com.ibm.mashups.enabler.model.LayoutModel");
dojo.provide("com.ibm.mashups.enabler.layout.LayoutNode");
dojo.provide("com.ibm.mashups.enabler.layout.LayoutFragment");



/**
 * This interface provides a tree model for the layout of a page. As of now the 
 * only node within a layout model is a fragment node.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.LayoutModel", com.ibm.mashups.enabler.TreeModelController, {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * creates a new layout node object. The created node can be inserted into 
     * the model using an appropriate <code>insert</code> method. The node will 
     * not appear in the model unless it is inserted.
     * @param {JSON} context array of predefined information 
     * used for the creation of the node. May be <code>null</code>. Accepted names are:<br>
     * - xyz - value: TODO
     * @type com.ibm.mashups.enabler.layout.LayoutNode
     * @return the created node
     */
    create: function (context) {
        return new com.ibm.mashups.enabler.layout.LayoutNode();
    }
});

/**
 * An interface for the nodes of a LayoutModel.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.layout.LayoutNode", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.ModifiableMetaData],     {
  /**
      * @private
      */
    constructor:function () {
    }
});

/**
 * Interface that represents a layout fragment
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.layout.LayoutFragment", [com.ibm.mashups.enabler.layout.LayoutNode],     {
  /**
      * @private
      */
    constructor:function ( ) {
    },

    /**
     * Returns the content of the fragment as a string.
     * @type String
     * @return the fragment content. Never <code>null</code>
     */
    getFragment: function() {
        return new String();
    },

    /**
     * Sets the content of the fragment. Any previously set content is replaced.
     * @param {String} content content to set. Must not be <code>null</code>.
     * @type void
     */
    setFragment: function(content) {
    },
	
    /**
     * Confirms whether setting the fragment is possible.
     * @param {String} content     content to set; must not be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetFragment: function(content) {
        return new Boolean(); 
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.sharedNavigation"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.sharedNavigation"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.sharedNavigation" );

dojo.provide("com.ibm.mashups.enabler.model.SharedNavigationModel");

dojo.provide("com.ibm.mashups.enabler.navigation.SharedNavigationNode");
dojo.provide("com.ibm.mashups.enabler.navigation.SharedNavigationRoot");



/**
 * Interface for a shared navigation model. This tree model contains a dedicated root
 * node, which holds navigation nodes shared to me by other users. These nodes may have
 * child nodes in case other users shared not only single navigation nodes but whole
 * navigation trees.
 * The shared navigation model is read-only. It may be used only to locate navigation nodes
 * shared by other users. Subscribing to (also referred to as accepting) such navigation
 * nodes is done with the users navigation model.
 * @ibm-api
 */

dojo.declare( "com.ibm.mashups.enabler.model.SharedNavigationModel", com.ibm.mashups.enabler.TreeModel, {
	/**
     * @private
     */
    constructor:function () {
    },

    /**
     * Returns the layout model for the given page.
     * @param {NavigationNode} node the NavigationNode or, if node is a string, 
     * the uri of the node for which to return its model. The page must be part 
     * of this model. Must not be <code>null</code>.
     * @type com.ibm.mashups.enabler.model.LayoutModel
     * @return a layout model or <code>null</code> if none exists. 
     */
    getLayoutModel: function (node) {
        return new com.ibm.mashups.enabler.model.LayoutModel();
    },
	
    /**
     * Indicates if the shared navigation node is subscribed to, also referred to
     * accepted, or not.
     * @param {String} id of the node. Must not be <code>null</code>.
     * @type Boolean
     * @return <code>true</code> if the shared navigation node is subscribed to,
     * <code>false</code> if not.
     */
    isAccepted:function (id) {
    	return new Boolean();
    }

});

/**
 * Marker interface representing a shared navigation node
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.navigation.SharedNavigationNode", com.ibm.mashups.enabler.navigation.NavigationNode,     {
  /**
      * @private
      */
    constructor:function () {
    }
});

/**
 * Marker interface representing a shared navigation node
 * @ibm-api
 * @deprecated
 * @since Deprecated since Version 2.0
 */
dojo.declare( "com.ibm.mashups.enabler.navigation.SharedNavigationRoot", com.ibm.mashups.enabler.navigation.NavigationNode,     {
  /**
      * @private
      */
    constructor:function () {
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.url"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.url"] = true;
dojo.provide("com.ibm.mashups.enabler.model.url");

/**
* Interface for an ModelUrl Factory that allows to generate ModelUrl's a comfortable way.
* This class should not be instantiated directly, but should be used through it's defined singleton 
* (<code>com.ibm.mashups.enabler.model.url.ModelUrlFactory</code>). 
* @ibm-spi
*/
dojo.declare( "com.ibm.mashups.enabler.model.url.ModelUrlFactory", null,
    {
        /**
        * Constant for creation of a navigation URL
        * @type {String}
        */
        NAVIGATION_URL:            "nav",
        /**
        * Constant for creation of a shared navigation URL
        * @type {String}
        */
        SHARED_NAVIGATION_URL:     "sharednav",
        /**
        * Constant for creation of a fragment URL
        * @type {String}
        */
        FRAGMENT_URL:       "fragment",
        /**
        * Constant for creation of a fragment-media URL
        * @type {String}
        */
        FRAGMENT_MEDIA_URL: "fragment-media",
        /**
        * Constant for creation of a user URL
        * @type {String}
        */
        USER_URL:           "user",
        /**
        * Constant for creation of a theme URL
        * @type {String}
        */
        THEME_URL:          "theme",
        /**
        * Constant for creation of a theme-media URL
        * @type {String}
        */
        THEME_MEDIA_URL:    "theme-media",
        /**
        * Constant for creation of a catalog URL
        * @type {String}
        */
        CATALOG_URL:        "cat",
        /**
        * Constant for creation of a config URL
        * @type {String}
        */
        CONFIG_URL:        "config",
        /**
        * Constant for creation of a space URL
        * @type {String}
        */
        SPACE_URL:      "space",
        		/**
        * Constant for creation of a space-favorite URL
        * @type {String}
        */
        SPACE_FAVORITE_URL:      "space-favorite",
        /**
        * Constant for creation of a ac URL
        * @type {String}
        */
        AC_URL:      "ac",
        /**
        * Constant for creation of a ac URL
        * @type {String}
        */
        AI_URL:      "ai",
        /**
        * Constant for creation of a template URL
        * @type {String}
        */
        TEMPLATE_URL:      "template",
        /**
        * Constant for member sub model
        * @type {String}
        */
        SUBMODEL_MEMBER:    "member",
        /**
        * Constant for role sub model
        * @type {String}
        */
        SUBMODEL_ROLE:      "role",
        
        /**
        * Constant for allowed-access sub model
        * @type {String}
        */
        SUBMODEL_ACCESS:      "access",

        /**
        * Constant for resource sub model
        * @type {String}
        */
        SUBMODEL_RESOURCE:      "resource",
        
        /**
        * @private
        **/
        constructor:function () {
        },
        
        /**
        * Create a ModelUrl based on the specified urlType. Afterwards parameters and scheme 
        * specific parts can be changed.<br />
        * Sample:
        * <pre>var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.NAVIGATION_URL, this);</pre>
        * @param {String} urlType the type of ModelUrl that should be created. You should use the URL constants that are defined in this interface. (Must not be <code>null</code>)
        * @param {com.ibm.mashups.enabler.model.Model} model the model used to create this ModelUrl object for. (Might be <code>null</code>)
        * @type {ModelUrl}
        * @return the created <code>ModelUrl</code>. Returns <code>null</code> if the specified urlType is not known.
        */
        createModelUrl: function (urlType, model) {
        	return new com.ibm.mashups.enabler.model.url.ModelUrl(urlType, model);
        },
        /**
        * Create a ModelUrl based on the specified URL. Afterwards parameters and scheme specific parts can be changed.
        * @param {String} url the url that should be used to create a <code>ModelUrl</code>. (Must not be <code>null</code>)
        * @param {com.ibm.mashups.enabler.model.Model} model the model used to create this ModelUrl object for. (Might be <code>null</code>)
        * @type {ModelUrl}
        * @return the created <code>ModelUrl</code> (Must not be <code>null</code>). 
        */
        getModelUrl: function (url, model) {
        	return new com.ibm.mashups.enabler.model.url.ModelUrl(url, model);
        }
    }
);

/**
* Interface for the representation of a model URL. This class should be used by the specific model
* API's in order to generate a valid model URL. The low level classes like ModelRestServiceRequest
* expect a request to be made with an implementation of the interface. It also allows an easy way
* to handle uris. e.g. <br/>
* <code>&lt;scheme&gt;:&lt;primaryNode&gt;@&lt;secondaryNode&gt;</code><bt/>
* <code>scheme specific part (ssp) = &lt;primaryNode&gt;@&lt;secondaryNode&gt;
* 
* @ibm-spi
*/
dojo.declare("com.ibm.mashups.enabler.model.url.ModelUrl", null,
	{
		/**
		* @private
		*/
		constructor: function () {
		},
        /**
        * Sets the nodes of the schemespecific part.
        * @param {JSONArray} nodes an array containing the nodes of the schemespecific part in a JSON notation way.<br/>
        *                          The ordering of the array elements specifies the position of the node, meaning
        *                          the array element 0 will become node 1 and so on and so forth.<br/><br/>
        * valid JSON attributes are: <br/>
        * <ul>
        * <li>value <i>{String} [mandatory]</i></li>
        * <li>isID <i>{boolean} [optional, default: true]</i></li>
        * <li>subModel <i>{String} [optional]</i></li>
        * </ul><br/>
        * example for &quot;nodes&quot;: <br/>
        * <code>
        * [ {<br/> 
        * value: &quot;100&quot;,<br/>
        *   isID: false,<br/>
        *   subModel: &quot;member&quot;<br/>
        * } ]
        * </code>
        * @type {void}
        */ 
        setNodes: function(nodes) {
        },
		/**
		* Sets the scheme specific part of the unerlying URI.
		* @param {String} value the value for the scheme specifc part. (Must not be <code>null</code>)
		* @type {void} 
		*/
		setSchemeSpecificPart: function (value) {
		},
		/**
		* Gets the scheme specific part of the underlying URI.
		* @type {String}
		* @return the scheme specific part. If a ssp was set through <code>setSchemeSpecificPart</code>
		*         the raw value will be returned. If the SSP was set by using <code>setNodes</code>,
		*         the converted part will be returned. If neither a node nor the raw SSP was set, 
		*         this method returns <code>null</code>.
		*/
		getSchemeSpecificPart: function() {
			return null;
		},
        /**
        * Adds the value of the specified parameter.
        * @param {String} name the name of the parameter. (Must not be <code>null</code>)
        * @param {String} value the value of the parameter. Valid is only a single String. (Must not be <code>null</code>)
        * @type {void} 
        */
        addParameter: function (name, value) {
        },
		/**
		* Sets the value(s) of the specified parameter.
		* @param {String} name the name of the parameter. (Must not be <code>null</code>)
		* @param {String} value the value of the parameter. Valid are either a single String or a String array. (Must not be <code>null</code>)
		* @type {void} 
		*/
		setParameter: function (name, value) {
		},
		/**
		* Gets the value(s) of the specified parameter.
		* @param {String} name the name of the parameter. (Must not be <code>null</code>)
		* @type {String}
		* @return the value(s) of the specified parameter or <code>null</code> if the specified parameter wasn't found. In case the parameter has one value
        *   the return type is String. For multiple values a String array is returned.
		*/
		getParameter: function (name) {
			return null;
		},
        /**
        * Gets the parameters as an object. <b>Note: this must be used read-only</b>
        * @type {JSON}
        * @return an object contain all parameters in the format { <name>: [<values>], ... }
        */
        getParameters: function() {
            return null;
        },
        /**
        * Returns the absolute URL of this object.
        * @type {String}
        * @return the absolute URL of this object. e.g. <code>http://myhost/contenthandler?uri=acme:id:myid</code>
        *         or <code>/contenthandler?uri=acme:id:myid</code>
        */
        getAbsoluteURL: function () {
        	return null;
        },
		/**
		* The same as <code>getAbsoluteURL</code> with the difference that this URL is (if needed) converted to a proxified URL
		* @type {String}
		* @return the proxified absolute URL. e.g. <code>http://acme.com/proxy/http/myhost/contenthandler?uri=acme:id:myid</code>
		*/
		getProxifiedAbsoluteURL: function () {
			return null;
		},
		/**
		* Gets the model URI of this object. If the complete link is e.g. <code>/mum/contenthandler?uri=acme:id:myid</code>,
		* this method will return <code>acme:id:myid</code>.
		* @type {String}
		* @return the URI portion of this Model URL. 
		*/
		getModelURI: function () {
			return null;
		}
	}
);

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.space"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.space"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.space" );

dojo.provide("com.ibm.mashups.enabler.model.SpaceModel");
dojo.provide("com.ibm.mashups.enabler.space.SpaceNode");

/**
 * This locator interface allows searching on the space model
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.space.SpaceLocator", [com.ibm.mashups.enabler.Locator],     {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns the corresponding space node for the given navigation node, or null if none exists
     * @param {com.ibm.mashups.enabler.navigation.NavigationNode} navigationNode the NavigationNode object to find the space for. Must not be <code>null</code>.
     * @return {Deferred} a deferred object used to start this operation. 
     * The return value when executed through the deferred object is
     * a space node for the given navigation node or <code>null</code> if there no appropriate space available.
     * @see SpaceNode
     */
    findSpaceByNavigation: function (navigationNode) {
        return new Deferred();
    },
	
    /**
     * Returns an interator containing all favorite spaces of the list.
     * 
     * @type    DeferredIterator
     * @return  a deferred iterator
     */
    findFavorites: function () {
        return new Iterator(); 
    }
});

/**
 * Interface for a space model.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.SpaceModel", 
[com.ibm.mashups.enabler.ListModelController, com.ibm.mashups.enabler.SubmittableFormProvider, com.ibm.mashups.enabler.space.SpaceLocator], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * creates a new Space node. The created node can be inserted into the model 
   * using an appropriate <code>insert</code> method. The node will not appear 
   * in the model unless it is inserted.
   * @param {JSON} context array of predefined information 
   * used for the creation of the node. Should be <code>null</code>.
   * @type SpaceNode 
   * @return created space node
   */
    create: function (context) {
        return new SpaceNode(); 
    },

   /**
   * Commits the modifications applied to this model and all dependant models.<br> 
   * After the model is committed successfully, this method must not be called 
   * again. The same is true for any other method modifying the model or its nodes.
   * @type Deferred 
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is <code>null</null>
   */
    commit: function () {
        return new Deferred(); 
    },
    
    /**
     * Confirms whether exporting the node is possible.
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
     * @return {Boolean} true if the node can be exported, otherwise false.
     */
	confirmExport: function(node) {
	    return new Boolean(); 
    },

    /**
     * Confirms whether copying the node is possible.
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
     * @return {Boolean} true if the node can be copied, otherwise false.
     */		
	confirmCopy: function(node) {
	    return new Boolean(); 
	},
	
    /**
     * Returns a SubmittableForm object associated with the given id to import a space.
     * Same as <code>getSubmittableForm</code>
     * @param {String} id the id of the html form this object is associated with
     * @return {SubmittableForm} SubmittableForm object, maybe <code>null</code>
     */
    getSubmittableImportForm: function(id) {
        return SubmittableForm(); 
    }
});

/**
 * Interface representing a space node.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.space.SpaceNode", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.ModifiableLocalized, com.ibm.mashups.enabler.ModifiableMetaData, com.ibm.mashups.enabler.ThemeProvider],     {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns the root navigation ID, or <code>null</code> if no navigation has been 
     * associated with the node.
     * @type com.ibm.mashups.enabler.Identifiable
     * @return the root navigation ID, or <code>null</code> if it has not been associated
     */
    getRootNavigation: function() {
    	return new com.ibm.mashups.enabler.Identifiable();
    },
    
    /**
     * Returns a URL to export the space in zip file format 
     * @type String
     * @return link to export the space
     */
    getExportSpaceURL: function() {
    	return new String();
    },
    
    /**
     * Returns a URL to export the space as a template
     * in zip file format 
     * @type String
     * @return link to export the space as a template
     */
    getExportTemplateURL: function() {
    	return new String();
    },
    
	/**
	 * Save the space as template.
	 * @return template object.
	 */
	saveAsTemplate: function() {
	},
	
    /**
     * Returns whether this space node is flagged as hidden. It is the responsibility of the
     * UI to render the space nodes correctly and honor this flag.
     * @type Boolean
     * @return true if the space is flagged as hidden, otherwise false
     */
    isHidden: function() {
        return new Boolean();
    },

    /**
     * Allows to flag the space node as hidden or visible.
     * @param {Boolean} hide true to hide the space, otherwise false
     * @type void
     */
    setHidden: function(hide) {
        return new Boolean();
    },
    /**
     * Confirms whether setting the hidden flag is possible.
     * @param {Boolean} hide true to hide the space, otherwise false
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetHidden: function(hide) {
        return new Boolean(); 
    },
	
    /**
     * Returns whether this space node is flagged as a favorite space.
     * @type Boolean
     * @return true if the space is flagged as favorite, otherwise false
     */
    isFavorite: function() {
        return new Boolean();
    },

    /**
     * Allows to mark the space node as favorite ir non-favorite.
     * @param {Boolean} favorite true to mark this space as favorite, otherwise false
     * @type void
     */
    setFavorite: function(favorite) {
        return new Boolean();
    }
	
	
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.template"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.template"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.template" );

dojo.provide("com.ibm.mashups.enabler.model.TemplateModel");
dojo.provide("com.ibm.mashups.enabler.template.TemplateNode");

/**
 * Interface for a template model.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.model.TemplateModel", [com.ibm.mashups.enabler.ListModelController, com.ibm.mashups.enabler.SubmittableFormProvider], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * Commits the modifications applied to this model and all dependant models.<br> 
   * After the model is committed successfully, this method must not be called 
   * again. The same is true for any other method modifying the model or its nodes.
   * @type Deferred 
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is <code>null</null>
   */
    commit: function () {
        return new Deferred(); 
    },
    
    /**
     * Confirms whether exporting the node is possible.
     * @param{Object} node  node object or node uri (without any scope). 
     *                      Must not be <code>null</code>
     * @return {Boolean} true if the node can be exported, otherwise false.
     */
    confirmExport: function(node) {
        return new Boolean(); 
    },
    
    /**
     * Returns a SubmittableForm object associated with the given id to import a template.
     * Same as <code>getSubmittableForm</code>
     * @param {String} id the id of the html form this object is associated with
     * @return {SubmittableForm} SubmittableForm object, maybe <code>null</code>
     */
    getSubmittableImportForm: function(id) {
        return SubmittableForm(); 
    }
});

/**
 * Interface representing a template node.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.template.TemplateNode", [com.ibm.mashups.enabler.Identifiable, com.ibm.mashups.enabler.ModifiableLocalized],     {
  /**
      * @private
      */
    constructor:function () {
    },
    
    /**
     * Returns a URL to export the template in zip file format 
     * @type String
     * @return link to export the template
     */
    getExportURL: function() {
    	return new String();
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteLocator"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteLocator"] = true;
dojo.provide("com.ibm.mashups.enabler.remote.RemoteLocator");

/**
 * Interface for finding RemoteFile objects.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.remote.RemoteLocator", null, {

    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * Returns the current user's home Directory.
     * @return {com.ibm.mashups.enabler.Deferred} A Deferred object for which the callback will be passed 
     * a RemoteFile. 
     */
    getUserRoot: function(){
    
    }
  
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteFile"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.remote.RemoteFile"] = true;
dojo.provide("com.ibm.mashups.enabler.remote.RemoteFile");



/**
 * Interface for a remote File.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.remote.RemoteFile", [com.ibm.mashups.enabler.MetaData, com.ibm.mashups.enabler.Identifiable], {
    /**
     * @private
     */
    constructor: function(){
    },
   
    /**
     * Returns the name of this File
     * @return {String} The name
     */
    getName: function(){
    
    },
	
    /**
     * Returns true if this is a directory otherwise returns false.
     * @return {boolean} True if this is a directory
     */
    isDirectory: function(){
    
    },
	
    /**
     * Returns the absolute URL of this file.
     * @return {String} The URL
     */	
	getUrl: function () {
		
	}	
	
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.remote"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.remote"] = true;
dojo.provide("com.ibm.mashups.enabler.model.remote");



/**
 * Interface for a remote File.
 * @ibm-api
 */
dojo.declare("com.ibm.mashups.enabler.model.RemoteModel", [com.ibm.mashups.enabler.TreeModel, com.ibm.mashups.enabler.remote.RemoteLocator], {

    /**
     * @private
     */
    constructor: function(){
    }  
});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.ac"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.ac"] = true;
dojo.provide( "com.ibm.mashups.enabler.model.ac" );

dojo.provide("com.ibm.mashups.enabler.ac.AccessControlModelFactory");
dojo.provide("com.ibm.mashups.enabler.ac.AccessControlModel");
dojo.provide("com.ibm.mashups.enabler.ac.ResourceAccessControlModel");
dojo.provide("com.ibm.mashups.enabler.ac.MemberModel");
dojo.provide("com.ibm.mashups.enabler.ac.RoleModel");
dojo.provide("com.ibm.mashups.enabler.ac.MemberNode");
dojo.provide("com.ibm.mashups.enabler.ac.RoleNode");
dojo.provide("com.ibm.mashups.enabler.ac.RoleType");




/**
 * This class allows to retrieve allowed access information of nodes and virtual nodes.
 * The factory can be used using the following code: <br>
 * <code>var permission = com.ibm.mashups.enabler.ac.AccessFactory.getEffectiveAccessVirtualResource(<br/>
* &nbsp;&nbsp;&nbsp;&nbsp;com.ibm.mashups.enabler.ac.VirtualResourceType.TEMPLATE);</code><br/>
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.ac.AccessFactory", null,
{
    /**
     * Returns the effective allowed access for a given node. Please note that the node has
     * to be a resolved and loaded node such as NavigationNode.
     * No string or plain Identifiable is allowed.
     * 
     * @param {Object} node a resolved model node such as a NavigationNode.
     * @return {EffectiveAccess} the effective allowed access object.
     * May be <code>NULL</code> if no valid access has been found, for the given node.
     */
    getEffectiveAccess: function(node) {
    },
    
    /**
     * Returns the effective allowed access for a given virtual resource.
     * 
     * @param {VirtualResourceType} resource a virtual resource type
     * @return {EffectiveAccess} the effective access object.
     * May be <code>NULL</code> if no valid access has been found for the given virtual resource.
     */
    getEffectiveAccessVirtualResource: function(resource) {
    }
});

/**
 * Interface representing effective allowed access.
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.ac.EffectiveAccess", null,
{
    /**
     * Returns whether a given role is set.
     * 
     * @param {RoleType} roletype the role type
     * @return {Boolean} true if the role is available, otherwise false.
     */
    hasRole: function(roletype) {
        return false;
    }
});

/**
 * Interface defining predefined virtual resources
 * @ibm-spi
 */
dojo.declare( "com.ibm.mashups.enabler.ac.VirtualResourceType", null, {
    /**
    * Constant for a virtual resource defining the overall root
    * @type {VirtualResourceType}
    */
    ROOT:           "wps.PORTAL",

    /**
    * Constant for a virtual resource defining templates
    * @type {VirtualResourceType}
    */
    TEMPLATE:      "wps.TEMPLATE_DEPLOYMENT",
    
    /**
    * Constant for a virtual resource defining spaces
    * @type {VirtualResourceType}
    */
    SPACE:          "wps.APPLICATION_ENTITIES"
    
});
com.ibm.mashups.enabler.ac.VirtualResourceType = new com.ibm.mashups.enabler.ac.VirtualResourceType();

/**
 * Interface for a access control model factory.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.AccessControlModelFactory", null, {
    /**
    * @private
    **/
    constructor:function () {
    },
    
    /**
     * 
     * @param {com.ibm.mashups.enabler.layout.LayoutNode} resourceNode
     * @type AccessControlModel
     */
    getAccessControlModel: function (resourceNode) {
        return null;
    },
	/**
	 * 
	 * @param {com.ibm.mashups.enabler.space.SpaceNode} spaceNode
     * @type AccessControlModel
	 */
    getAccessControlModel: function (spaceNode) {
        return null;
    },
	/**
	 * 
	 * @param {com.ibm.mashups.enabler.space.SpaceNode} spaceNode
	 * @param {com.ibm.mashups.enabler.layout.LayoutNode} resourceNode
     * @type ResourceAccessControlModel
	 */
    getAccessControlModel: function (spaceNode, resourceNode) {
        return null;
    }
});

/**
 * Interface for a access control model.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.AccessControlModel", [com.ibm.mashups.enabler.model.Model], {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * Returns the owner ...
   * @type User 
   * @return the owner of this .... Never <code>null</code>.
   */
    getOwner:function () 
    {
        return new User(); 
    },
    /**
     * @type void
	 * @param {User} user
	 */
    setOwner:function (user)
    {
    },
    
    /**
     * Confirms whether setting a new owner is possible.
     * @param {User} user    user to set; must not be <code>null</code>
     * @return {Boolean} true if the value can be set, otherwise false.
     */
    confirmSetOwner: function(user) {
        return new Boolean(); 
    },
    
    /**
     * Same as getRoleModel(true).
     * @type RoleModel
     * @return a RoleModel object. Can never be <code>NULL</code>.
     */
    getRoleModel: function() {
        return new RoleModel(); 
    },
    /**
     * Returns the role model for the given access control model.
     * @type RoleModel
     * @param {Boolean} create defines whether the role model should be created if it is not available
     * @return a RoleModel object. Might be <code>NULL</code> if called with create equals false.
     */
    getRoleModel: function(create) {
        return new RoleModel(); 
    },
    
    /**
     * Confirms whether getting the role model is possible
     * @return {Boolean} true if retrieving the role model is possible, otherwise false.
     */
    confirmGetRoleModel: function() {
        return new Boolean(); 
    },

   /**
   * Commits the modifications applied to this model and all dependant models.<br> 
   * After the model is committed successfully, this method must not be called 
   * again. The same is true for any other method modifying the model or its nodes.
   * @type Deferred 
   * @return a deferred object used to start this operation. The return value 
   * when executed through the deferred object is <code>null</null>
   */
    commit: function () {
        return new Deferred();
    }
});

/**
 * Interface for a access control model with additional features for resource handling.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.ResourceAccessControlModel", [com.ibm.mashups.enabler.ac.AccessControlModel],     {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * 
     * @param {RoleType} roletype the role type for which to retrieve the inheritance block
     * @type boolean
     */
    isInheritanceBlock:function (roletype) 
    {
        return true; 
    },
    /**
     * 
     * @param {RoleType} roletype the role type for which to set the inheritance block
     * @param {boolean} value
     * @type void
     */
    setInheritanceBlock:function (roletype, value) 
    { 
    }
	
});

/**
 * Interface for an access control role model
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.RoleModel", [com.ibm.mashups.enabler.ListModelController],     {

  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * creates a new Role. The created node can be inserted into the model 
   * using an appropriate <code>insert</code> method. The node will not appear 
   * in the model unless it is inserted.
   * @param {JSON} context json object of predefined name/value pairs
   * used for the creation of the node. Never <code>null</code>. Accepted names are:<br>
   * &nbsp;&nbsp;&nbsp;&nbsp;<code>roletype</code> - value: one of the role type constants
   * (mandatory)<br>
   * @type RoleNode
   * @return created role node
   */
    create: function (context) {
        return new RoleNode(); 
    },
	
    /**
     * Returns the member model for the given role.
     * @param {RoleNode} roleNode the role to retrieve the member model for
     * @type MemberModel
     */
    getMemberModel: function(roleNode) {
        return new MemberModel(); 
    }
});

/**
 * Interface for an access control member model
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.MemberModel", [com.ibm.mashups.enabler.ListModelController],     {
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * creates a new Member. The created node can be inserted into the model 
   * using an appropriate <code>insert</code> method. The node will not appear 
   * in the model unless it is inserted.
   * @param {JSON} context array of predefined information 
   * used for the creation of the node. Never <code>null</code>. Accepted names are:<br>
   * &nbsp;&nbsp;&nbsp;&nbsp;<code>entity</code> - an Entity object
   * (mandatory)<br>
   * @type MemberNode
   * @return created member node
   */
    create: function (context) {
        return new MemberNode(); 
    }
});

/**
 * Interface defining predefined RoleTypes
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.RoleType", null, {
    /**
    * Constant for a role type of user
    * @type {RoleType}
    */
    USER:      "USER",
    /**
    * Constant for a role type of editor
    * @type {RoleType}
    */
    EDITOR:    "EDITOR",
    /**
    * Constant for a role type of manager
    * @type {RoleType}
    */
    MANAGER:   "MANAGER",
    /**
    * Constant for a role type of administrator
    * @type {RoleType}
    */
    ADMIN:   "ADMIN",
    /**
    * Constant for an unknown role type
    * @type {RoleType}
    */
    UNKNOWN:   "UNKNOWN"
});
com.ibm.mashups.enabler.ac.RoleType = new com.ibm.mashups.enabler.ac.RoleType();

/**
 * Interface representing a role
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.RoleNode", [com.ibm.mashups.enabler.Identifiable], {
  /**
      * @private
      */
    constructor:function() {
    },
	
    /**
     * Returns the corresponding role name
     * @type String
     */
    getRoleName: function()
    {
        return null;
    },

	/**
	 * Returns the corresponding role type
	 * @type RoleType
	 */
	getRoleType: function()
	{
		return null;
	}

});


/**
 * Interface representing a member
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.ac.MemberNode", null, {
  /**
      * @private
      */
    constructor:function() {
    },

   /**
   * returns the user or group Entity 
   * @type Entity 
   * @return the enitity of this participant. Never <code>null</code>. 
   */
    getEntity: function() {
        return new Entity(); 
    }
	
});


}

if(!dojo._hasResource["com.ibm.mashups.enabler.model.spaceextension"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model.spaceextension"] = true;
dojo.provide("com.ibm.mashups.enabler.model.spaceextension");

dojo.provide("com.ibm.mashups.enabler.model.space.SpaceExtension");
dojo.provide("com.ibm.mashups.enabler.model.space.SpaceExtensionResult");
dojo.provide("com.ibm.mashups.enabler.model.SpaceExtensionModel");

/**
 *
 * Interface SpaceExtension for space life cycle events.
 */
dojo.declare("com.ibm.mashups.enabler.model.space.SpaceExtension", null, {

    /**
     * @private
     */
    constructor: function(){
    },
    
    /**
     * This method is called before space is created in business space.
     *
     * spaceId: String, Id of the space
     * spaceName: String, name of the space
     * spaceDescription: String, description of the space
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means "notification has been delivered successfully and accepted".
     */
    onSpaceCreate: function(spaceId, spaceName, spaceDescription, optionalInfo){
        // alert("SpaceExtension.onSpaceCreate");
    },
    
    /**
     * This method is called before space is copied in business space.
     *
     * sourceSpaceId: String, Id of the source space
     * targetSpaceId: String, Id of the target space
     * targetSpaceName: String, name of the target space
     * targetDescription: String, description of the target space
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means "notification has been delivered successfully and accepted".
     */
    onSpaceCopy: function(sourceSpaceId, targetSpaceId, targetSpaceName, targetDescription, optionalInfo){
        // alert("SpaceExtension.onSpaceCopy");
    },
    
    /**
     * This method is called before space is updated in business space.
     *
     * spaceId: String, Id of the space
     * spaceData: JSON object, the set of space data that's going to be updated.
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means "notification has been delivered successfully and accepted".
     */
    onSpaceUpdate: function(spaceId, spaceData, optionalInfo){
        // alert("SpaceExtension.onSpaceUpdate");
    },
    
    /**
     * This method is called before space is deleted in business space.
     *
     * spaceId: String, Id of the space
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means "notification has been delivered successfully and accepted".
     */
    onSpaceDelete: function(spaceId, optionalInfo){
        // alert("SpaceExtension.onSpaceDelete");
    },
    
    /**
     * This method is used to check if the specified space can be exported.
     *
     * spaceId: String, Id of the space
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means that the space can be exported.
     */
    canExportSpace: function(spaceId, optionalInfo){
        // alert("SpaceExtension.canExportSpace");
    },
    
    /**
     * This method is used to check if the specified space can be copied.
     *
     * spaceId: String, Id of the space
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means that the space can be copied.
     */
    canCopySpace: function(spaceId, optionalInfo){
        // alert("SpaceExtension.canCopySpace");
    },
    
    /**
     * This method is used to check if the specified space can be deleted.
     *
     * spaceId: String, Id of the space
     * optionalInfo: this is a field reserved for future.
     *
     * return: SpaceExtensionResult or no return.
     *         No return means that the space can be deleted.
     */
    canDeleteSpace: function(spaceId, optionalInfo){
        // alert("SpaceExtension.prototype.canDeleteSpace");
    }
    
});

/**
 * SpaceExtensionResult class.
 */
dojo.declare("com.ibm.mashups.enabler.model.space.SpaceExtensionResult", null, {
    STATE_OK: "OK",
    STATE_WARNING: "WARNING",
    STATE_ERROR: "ERROR",

    /**
     * Defining the constructor function of the class.
     * The instance of this class is used to carry the return value of SpaceExtension methods.
     *
     * result: String value, indicate the overall status of result. Must be one of following -
     *                SpaceExtensionResult.STATE_OK
     *                SpaceExtensionResult.STATE_WARNING
     *                SpaceExtensionResult.STATE_ERROR
     *
     * This class may also have following fields
     *     message: String, localized message to show what has happened.
     *     solution: String, localized solution message to suggest what actions can be taken to correct the problem.
     *     optionalInfo: this is a field reserved for future.
     */
    constructor: function(result){
        this.result = result;
    },
    
    /**
     * Returns a String value to indicate the overall state of the SpaceExtensionResult
     */
    getState: function(){
        return this.result;
    },
    
    /**
     * Returns localized message
     * return: String, localized message or empty String if mesage doesn't exist.
     */
    getLocaleMessage: function(){
        return this.message || "";
    },
    
    /**
     * Returns localized solution
     * return: String, localized solution message or empty String if solution doesn't exist.
     */
    getLocaleSolution: function(){
        return this.solution || "";
    },
    
    /**
     * Returns additional information from the result.
     * this is reserved for future.
     */
    getOptionalInfo: function(){
        return this.optionalInfo || "";
    },
    
    /**
     * Sets a localized message to the result.
     * localeMessage: String, localized message to show what has happened.
     */
    setLocaleMessage: function(localeMessage){
        this.message = localeMessage;
    },
    
    /**
     * set a localized solution to the result.
     * localeSolution: String, localized solution message to suggest what actions can be taken to correct the problem.
     */
    setLocaleSolution: function(localeSolution){
        this.solution = localeSolution;
    },
    
    /**
     * set additional information to the result.
     * this is reserved for future.
     */
    setOptionalInfo: function(info){
        if (optionalInfo) {
            this.optionalInfo = info;
        }
    }
});

/**
 * This locator interface allows searching on the space extension model
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.space.SpaceExtensionLocator", [com.ibm.mashups.enabler.Locator],     {
  /**
      * @private
      */
    constructor:function () {
    },

    /**
     * Returns the corresponding space extension for the given space node, or null if none exists
     * @param {com.ibm.mashups.enabler.space.SpaceNode} spaceNode the SpaceNode object to find the extension for. Must not be <code>null</code>.
     * @return {Deferred} a deferred object used to start this operation. 
     * The return value when executed through the deferred object is
     * a space extension for the given space node or <code>null</code> if there no appropriate space extension available.
     * @see SpaceExtension
     */
    findExtensionBySpace: function (spaceNode) {
        return new Deferred();
    }
	
});

/** Interface for a space extension model.
 * @ibm-api.
 */
dojo.declare( "com.ibm.mashups.enabler.model.SpaceExtensionModel",
[com.ibm.mashups.enabler.ListModelController, com.ibm.mashups.enabler.space.SpaceExtensionLocator], {
	
  /**
      * @private
      */
    constructor:function () {
    },

   /**
   * creates a new Space extension. The created node can be inserted into the model 
   * using an appropriate <code>insert</code> method. The node will not appear 
   * in the model unless it is inserted.
   * @param {JSON} context array of predefined information 
   * used for the creation of the node. Should be <code>null</code>.
   * @type SpaceExtension 
   * @return created space extension
   */
    create: function (context) {
        return new SpaceExtension(); 
    }

});

}

if(!dojo._hasResource["com.ibm.mashups.enabler.model"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.model"] = true;
dojo.provide( "com.ibm.mashups.enabler.model" );


















}

if(!dojo._hasResource["com.ibm.mm.enabler.services.ModelRestServiceRequest"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.services.ModelRestServiceRequest"] = true;
dojo.provide( "com.ibm.mm.enabler.services.ModelRestServiceRequest" );

//Required for AJAX requests.
dojo.require( "com.ibm.mm.enabler.utilities" );





dojo.declare( "com.ibm.mm.enabler.services.ModelRestServiceRequest",
    null,
{
    REQUEST_METHOD_POST:"POST",
	REQUEST_METHOD_PUT:"PUT",
	REQUEST_METHOD_DELETE:"DELETE",
	POST_ACTION_HEADER : "X-Method-Override",
	MODIFICATION_COOKIE: "modified.id",

    constructor:function( /*HttpUrl*/feedlocation, /*HTMLFormElement?*/formNode, /*Function?*/formFilter, /*boolean?*/textOnly, /*boolean?*/sync ) {
        com.ibm.mm.enabler.debug.entry( "ModelRestServiceRequest.constructor",  feedlocation, formNode, formFilter, textOnly, sync  );
        this._feedURI = feedlocation.toProxifiedString();
        this._textOnly = textOnly;
        this._sync = sync;
        this._formNode = formNode;
        this._formFilter = formFilter;
        this._config = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
        
        //Make sure this isn't undefined.
        if ( !this._sync ) {
            this._sync = false;
        }
        com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest.constructor" );
    },
        // summary: Sends a request to one of the Portal REST Services and handles the response.
        // description: Create a new instance of this object for every REST service request that is
        //      sent. The URL is passed in to the constructor. If a form node and form filter is
        //      passed into the constructor, the REST service request is handled as a form submit.
        //      The request can also be executed synchronously if TRUE is passed into the constructor.
        //      In general, only the model implementations should send these requests.

        create: function ( /*ibm.atom.Feed*/feed, /*Function*/callbackfn, /*Object?*/addtlCallbackFnArguments ) {
            // summary: Creates an entry in a feed.
            // description: Creates an entry in a feed. This operation is not implemented in this
            //       class. It should be overridden by subclasses and properly implemented if
            //       the REST service supports the create operation.
            // feed: the ATOM feed object
            // entry: the ATOM entry to create
            // callbackfn: the function to call when the operation is complete

            com.ibm.mm.enabler.debug.entry( "ModelRestServiceRequest.create",  callbackfn ,addtlCallbackFnArguments );
            com.ibm.mm.enabler.debug.log( "ModelRestServiceRequest.create","feed:"+ feed );
            com.ibm.mm.enabler.debug.log( "ModelRestServiceRequest.create","Attempting to retrieve: " + this._feedURI + "; synchronously? " + this._sync );

            this._updateCookie();
            
            var me = this;
            var args = {
                url: this._feedURI,
                headers: { "If-Modified-Since": "Thu, 1 Jan 1970 00:00:00 GMT","Content-Type":"application/atom+xml"}, //temporary to force the browser to ignore cached requests
                load: function( response,ioArgs ) {

                    var xhr = ioArgs.xhr;
                    var data = response;

                    var contentType = xhr.getResponseHeader("Content-Type" );
                    if ( typeof contentType != "undefined" && contentType !== null && contentType.indexOf( "text/html" ) >= 0 ) {
                        me._doLogin();
                        
                        return;
                    }

                   if (dojo.isIE) {
                      data = dojox.xml.parser.parse(xhr.responseText);
                      callbackfn("load", data, xhr, addtlCallbackFnArguments);
                   } else {
                      //var doc = com.ibm.mm.enabler.dom.createDocument(data);
                       callbackfn("load", data, xhr, addtlCallbackFnArguments);
                   }
                },
                error: function( response, ioArgs ) {
                    var xhr = ioArgs.xhr;
                    var status = xhr.status;

                    // Check whether we are having an authorization problem
                    if (status == 401) {
                        me._doLogin();
                        return;
                    }
                },
                sync: this._sync,
                postData: feed,
                handleAs: "xml"
            };

            dojo.rawXhrPost( args );

            com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest.create" );
        },
        read: function ( /*Function?*/callbackfn, /*Object?*/addtlCallbackFnArguments ) {
            // summary: Read the ATOM feed provided by the REST service.
            // description: If textOnly is set to true, the ATOM feed is returned as text and
            //       passed in as a single argument to the specified callback function.
            //       Otherwise, the ATOM feed is parsed into an {@link ibm.atom.Feed} object
            //       and passed into the callback function along with the original XML Document
            //       Object Model object.
            // callbackfn: the function to call when the operation is complete (only valid if
            //       sync is false)
            // addtlCallbackFnArguments: any arguments to pass through to the callback function
            com.ibm.mm.enabler.debug.entry( "ModelRestServiceRequest.read",  callbackfn, addtlCallbackFnArguments  );
            if ( this._textOnly ) {
                this._retrieveRawFeed( callbackfn, addtlCallbackFnArguments );
            }
            else {
                this._retrieve( callbackfn, addtlCallbackFnArguments );
            }
            com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest.read");
        },

        update: function ( /*ibm.atom.Feed*/feed, /*Function*/callbackfn, /*Object?*/addtlCallbackFnArguments ) {
            // summary: Updates an entry in a feed.
            // description: Updates an entry in a feed. This operation is not implemented in this
            //      class. It should be overridden by subclasses and properly implemented if the
            //      REST service supports the update operation.
            // feed: the ATOM feed object
            // entry: the ATOM entry to create
            // callbackfn: the function to call when the operation is complete
            com.ibm.mm.enabler.debug.entry("ModelRestServiceRequest.update" , callbackfn );
            com.ibm.mm.enabler.debug.log( "ModelRestServiceRequest.update","feed:"+ feed );
            com.ibm.mm.enabler.debug.log( "ModelRestServiceRequest.update","Attempting to retrieve: " + this._feedURI + "; synchronously? " + this._sync );

            this._updateCookie();
            var me = this;
			 var args = {
                url: this._feedURI,
                load: function( response,ioArgs ) {
                    var data = response;
                    var xhr = ioArgs.xhr;

                    var contentType = xhr.getResponseHeader("Content-Type" );

                    if ( typeof contentType != "undefined" && contentType !== null && contentType.indexOf( "text/html" ) >= 0 ) {
                        me._doLogin();
                        
                        return;
                   }

                   if (dojo.isIE) {
                       data = dojox.xml.parser.parse(xhr.responseText);
                       callbackfn("load", data, xhr, addtlCallbackFnArguments);
                   } else {
                       //var doc = com.ibm.mm.enabler.dom.createDocument(data);
                       callbackfn("load", data, xhr, addtlCallbackFnArguments);
                   }

                },
                error: function( response, ioArgs ) {
                    var xhr = ioArgs.xhr;
                    var status = xhr.status;

                    // Check whether we are having an authorization problem
                    if (status == 401) {
                        me._doLogin();
                        return;
                    }
                },
                sync: this._sync,
                handleAs: "xml"
            };
			var requestHeaders = { "If-Modified-Since": "Thu, 1 Jan 1970 00:00:00 GMT","Content-Type":"application/atom+xml"};
			if (com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.TUNNEL_MODE) === true){
				requestHeaders[this.POST_ACTION_HEADER] = this.REQUEST_METHOD_PUT;	
				args.headers = requestHeaders;
				args.postData = feed;	
	            com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update", "TUNNELMODE",true  );
    			dojo.rawXhrPost( args );	
			}
			else{
				args.putData = feed;
				args.headers = requestHeaders;
			    com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update", "TUNNELMODE",false  );    	
				dojo.rawXhrPut( args );				
			}           

             com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest.update" );
        },
        remove: function (/*Function*/callbackfn,  /*Object?*/addtlCallbackFnArguments ) {
            // summary: Removes an entry from a feed.
            // description: Removes an entry from a feed. This operation is not implemented in this
            //      class. It should be overridden by subclasses and properly implemented if the
            //      REST service supports the remove operation.
            // feed: the ATOM feed object
            // entry: the ATOM entry to create
            // callbackfn: the function to call when the operation is complete
             com.ibm.mm.enabler.debug.entry( "ModelRestServiceRequest.remove",callbackfn );
              com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.remove", "Attempting to retrieve: " + this._feedURI + "; synchronously? " + this._sync );

            this._updateCookie();
            var me = this;
            var args = {
                url: this._feedURI,
                load: function( response,ioArgs ) {
                    var type = "load";
                    var data = response;
                    
                    var xhr = ioArgs.xhr;
                    var contentType = xhr.getResponseHeader("Content-Type" );

                    if ( typeof contentType != "undefined" && contentType !== null && contentType.indexOf( "text/html" ) >= 0 ) {
                        me._doLogin();
                        
                        return;
                    }

                    if (dojo.isIE) {
                        data = dojox.xml.parser.parse(xhr.responseText);
                        callbackfn(type, data, xhr, addtlCallbackFnArguments);
                    } else {
                        //var doc = com.ibm.mm.enabler.dom.createDocument(data);
                        callbackfn(type, data, xhr, addtlCallbackFnArguments);
                    }
                },
                error: function( response, ioArgs ) {
                    var xhr = ioArgs.xhr;
                    var status = xhr.status;

                    // Check whether we are having an authorization problem
                    if (status == 401) {
                        me._doLogin();
                        return;
                    }
                },
                sync: this._sync,
                handleAs: "xml"
            };
			var requestHeaders = { "If-Modified-Since": "Thu, 1 Jan 1970 00:00:00 GMT","Content-Type":"application/atom+xml"};
			if (com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.TUNNEL_MODE) === true){
				requestHeaders[this.POST_ACTION_HEADER] = this.REQUEST_METHOD_DELETE;	
				args.headers = requestHeaders;
				com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update", "TUNNELMODE",true  );
    			dojo.rawXhrPost( args );	
			}
			else{
			    args.headers = requestHeaders;
			    com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.update", "TUNNELMODE",false  );    	
				dojo.xhrDelete( args );				
			}         

            com.ibm.mm.enabler.debug.log("ModelRestServiceRequest.remove", "sync:",args.sync );
            com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest.remove" );
        },
        _retrieveRawFeed: function ( callbackfn, callbackargs ) {
            com.ibm.mm.enabler.debug.entry( "ModelRestServiceRequest._retrieveRawFeed", callbackfn, callbackargs );

            dojo.xhrGet({
                url: this._feedURI,
                headers: { "If-Modified-Since": "Thu, 1 Jan 1970 00:00:00 GMT"},
                load: function( data, ioArgs ) {
                    callbackfn( com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD, data, ioArgs.xhr, callbackargs );
                },
                error: function( data, ioArgs ) {
                    callbackfn( com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR, data, ioArgs.xhr, callbackargs );
                },
                sync: this._sync
            });

            com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest._retrieveRawFeed");
        },
        _retrieve: function ( callbackfn, callbackargs, formNode, formFilter ) {
            com.ibm.mm.enabler.debug.entry(  "ModelRestServiceRequest._retrieve",  callbackfn ,callbackargs,formNode,formFilter );
            var content = {};
            var mt = "xml"; //temp

            if ( dojo.isIE ) {
                //content = { "com.ibm.wps.web2.contenttype": "text/xml" };
                mt = "text"; //temp
            }

            com.ibm.mm.enabler.debug.log( "ModelRestServiceRequest._retrieve", "Attempting to retrieve: " + this._feedURI + "; synchronously? " + this._sync );
            var me = this;
            var args = {
                url: this._feedURI,
                content: content,
                headers: { "If-Modified-Since": "Thu, 1 Jan 1970 00:00:00 GMT"}, //temporary to force the browser to ignore cached requests
                load: function( response, ioArgs ) {
                    var data = response;
                    var xhr = ioArgs.xhr;
                    var contentType = xhr.getResponseHeader("Content-Type" );

                    //If the HTML content is returned, this is probably another re-direction so we need to
                    //force a full-page refresh.
                   
                    if (typeof contentType != "undefined" && contentType !== null && contentType.indexOf( "text/html" ) >= 0 ) {
                        me._doLogin();
                        
                        return;
                    }

                    if ( dojo.isIE ) {
                         var doc = com.ibm.mm.enabler.dom.createDocument( data );
                         callbackfn( com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD, doc, xhr, callbackargs );
                    } else {
                         callbackfn( com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD, data, xhr, callbackargs );
                    }
                },
                error: function( response, ioArgs ) {
                    var data = response;
                    var xhr = ioArgs.xhr;
                    
                    var status = xhr.status;

                    // Check whether we are having an authorization problem
                    if (status == 401) {
                        me._doLogin();
                        return;
                    }

                    if ( dojo.isIE ) {
                         var doc = com.ibm.mm.enabler.dom.createDocument( data );
                         callbackfn( com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR, doc, xhr, callbackargs );
                    } else {
                         callbackfn( com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR, data, xhr, callbackargs );
                    }
                },
                sync: this._sync,
                handleAs: mt
            };

            var method = "Get";
            if ( this._formNode ) {
                args.form = this._formNode;
                method = "Post";
            }

            if ( this._formFilter ) {
                args.formFilter = this._formFilter;
            }
            com.ibm.mm.enabler.debug.log( "ModelRestServiceRequest._retrieve", "sync:",args.sync  );
            dojo["xhr" + method]( args );

            com.ibm.mm.enabler.debug.exit( "ModelRestServiceRequest._retrieve" );
        },

        _updateCookie: function() {
            var dt = new Date();
            var properties = {};
            properties.path = this._config.getValue(com.ibm.mm.enabler.services.CONFIG_SERVICE.CONTEXT_ROOT_MAIN);
            dojo.cookie(this.MODIFICATION_COOKIE, dt.getTime(), properties);        	
        },
        _doLogin: function() {
            var pid = null;
            var url = document.location.href;
            
            // make sure we add the timeout only once
            /*if (url.indexOf("timeout=true") > 0) {
                alert("Internal problem while reading resource");
                return;
            }
            
            // test if we have a assigned hash so that we can transport this as well to the server
            if (url.indexOf("#") > 0) {
                var  arr = url.split("#");
                if (arr[1])
                    pid = arr[1];
                    
                url = arr[0];
            }
            
            // see if the url has already some parameters
            if (url.indexOf("?") > -1)
                url += "&";
            else
                url += "?";
            
            url += "timeout=true";
            
            
            if (pid)
                url += "&" + pid;
            */
			//get full page refresh redirect url
			var cb = function(url){
				if (url && url != null)
				top.location.href = url;
			}
			var navStateModel = com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
			com.ibm.mashups.enabler.model.state.UrlGeneratorFactory.getUrlGenerator().getUrl(navStateModel,cb,{nohash:"true"});			
        },
        toString: function () {
            return this._feedURI;
        }
    }
);

// constants
com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD = "load";
com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR = "error";

dojo.declare( "com.ibm.mm.enabler.services.XHRModelHeaderExtensionImpl", null , {
    LOG_LEVEL: com.ibm.mashups.enabler.logging.LogLevel.TRACE,
    
    constructor: function () {
        this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_METHOD = "dojo.xhr()";
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);

        this.originalDojoXHR = dojo.xhr;
        
        dojo.xhr = dojo.hitch(this, function(/* String */ method, /* dojo.__XhrArgs */ args, /* Boolean */ hasBody) {
            if (this.bIsLoggable) {
                this.LOGGER.entering(this.LOG_METHOD, [method, args, hasBody]);
            }
            
            if (!args.headers) args.headers = {};
            args.headers["X-IBM-XHR"] = "true";

            if (this.bIsLoggable) {
                this.LOGGER.trace(this.LOG_METHOD, "Adding X-IBM-XHR header");
            }
            var ret = this.originalDojoXHR(method, args, hasBody);
            
            if (this.bIsLoggable) {
                this.LOGGER.exiting(this.LOG_METHOD);
            }
            
            return ret;
        });
    }
});


com.ibm.mm.enabler.services.XHRModelHeaderExtension = new com.ibm.mm.enabler.services.XHRModelHeaderExtensionImpl();


}

if(!dojo._hasResource["com.ibm.mm.enabler.model.url"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.model.url"] = true;
dojo.provide("com.ibm.mm.enabler.model.url");












dojo.declare("com.ibm.mm.enabler.model.url.ModelUrlFactoryImpl", [com.ibm.mashups.enabler.model.url.ModelUrlFactory], {
    WEBDAV_URL: "webdav",
    
    /**
     * @private
     **/
    constructor: function() {
        this.schemeMap = {};
        this.schemeMap[this.NAVIGATION_URL] = "nm";
        this.schemeMap[this.SHARED_NAVIGATION_URL] = "snm";
        this.schemeMap[this.FRAGMENT_URL] = "fragment";
        this.schemeMap[this.FRAGMENT_MEDIA_URL] = "fragment-media";
        this.schemeMap[this.USER_URL] = "um";
        this.schemeMap[this.THEME_URL] = "theme";
        this.schemeMap[this.THEME_MEDIA_URL] = "theme-media";
        this.schemeMap[this.CATALOG_URL] = "catalog";
        this.schemeMap[this.CONFIG_URL] = "config";
        this.schemeMap[this.SPACE_URL] = "space";
        this.schemeMap[this.SPACE_FAVORITE_URL] = "space-favorite";
        this.schemeMap[this.AC_URL] = "ac";
        this.schemeMap[this.AI_URL] = "ai";
        this.schemeMap[this.TEMPLATE_URL] = "template";
        // internal, not exposed
        this.schemeMap["service"] = "service";
        this.schemeMap[this.WEBDAV_URL] = "dav:mmdav";
    },
    
    createModelUrl: function(urlType, model) {
        var METHOD_NAME = "createModelUrl(urlType, model)";
        var bIsLogging = com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.isLoggable(com.ibm.mashups.enabler.logging.LogLevel.TRACE);
        if (bIsLogging) 
            com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.entering(METHOD_NAME, [urlType, model]);
        
        var modelSchema = com.ibm.mashups.enabler.model.url.ModelUrlFactory.schemeMap[urlType];
        
        if (bIsLogging) 
            com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.trace(METHOD_NAME, "modelSchema found for specified urlType: ${0}", urlType);
        
        if (!modelSchema) 
            return null;
        
        var urlImpl;
        if (urlType == this.THEME_MEDIA_URL) {
            urlImpl = new com.ibm.mm.enabler.model.url.ThemeResourceUrlImpl(modelSchema, model);
        }
        else if (urlType == this.FRAGMENT_MEDIA_URL) {
            urlImpl = new com.ibm.mm.enabler.model.url.SchemeBasedModelMediaUrlImpl(modelSchema, model);
        }
        else {
            urlImpl = new com.ibm.mm.enabler.model.url.SchemeBasedModelUrlImpl(modelSchema, model);
        }
        
        if (bIsLogging) 
            com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER.exiting(METHOD_NAME, urlImpl);
        
        return urlImpl;
    },
    getModelUrl: function(url, model) {
        return new com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl(url, model);
    }
});

dojo.declare("com.ibm.mm.enabler.model.url.BaseModelUrl", [com.ibm.mashups.enabler.model.url.ModelUrl], {
    modelSchema: null,
    schemeSpecific: null,
    isMediaUrl: false,
    httpUrl: null,
    
    VALUE: "value",
    IS_ID: "isID",
    SUBMODEL: "submodel",
    
    constructor: function() {
        this.nodes = [];
        this.prefix = null;
        
        this.subModelSchemeMap = {};
        this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_RESOURCE] = "resource";
        this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ROLE] = "role";
        this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_MEMBER] = "member";
        this.subModelSchemeMap[com.ibm.mashups.enabler.model.url.ModelUrlFactory.SUBMODEL_ACCESS] = "access";
    },
    _loadPrefix: function() {
        if (this.prefix == null) {
            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            this.prefix = this.serviceJson.idprefix;
        }
    },
    setPrimaryNode: function(value, isID, subModel) {
        if (typeof internal == "undefined") {
            com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.model.url.ModelUrl.setPrimaryNode", "This method must not be used anymore. Use setNodes instead." );
        }

        var primary = {};
        primary.value = value;
        primary.isID = (isID != null) ? isID : true;
        primary.subModel = subModel;
        
        this.nodes[0] = primary;
        
        this._updateURI();
    },
    setSecondaryNode: function(value, isID, subModel) {
        if (typeof internal == "undefined") {
            com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.model.url.ModelUrl.setSecondaryNode", "This method must not be used anymore. Use setNodes instead." );
        }

        var secondary = {};
        secondary.value = value;
        secondary.isID = (isID != null) ? isID : true;
        secondary.subModel = subModel;
        
        this.nodes[1] = secondary;
        
        this._updateURI();
    },
    setNodes: function(nodes) {
        this.nodes = nodes;
        
        for (var i = 0; i < nodes.length; i++) {
            nodes[i].isID = (nodes[i].isID != null) ? nodes[i].isID : true;
        }
        
        this._updateURI();
    },
    setSchemeSpecificPart: function(value) {
        this.nodes = []
        this.schemeSpecific = value;
        
        this._updateURI();
    },
    getSchemeSpecificPart: function() {
        if (this.schemeSpecific != null) 
            return this.schemeSpecific;
        
        var tempSSP = "";
        if (this.isMediaUrl) tempSSP = "/";
        
        if (!this.nodes) 
            return tempSSP;
        
        if (this.isMediaUrl) {
            for (var i = 0; i < this.nodes.length; i++) {
                var node = this.nodes[i];
                // the prefix MUST only be loaded if the prefix is needed, since the
                // loading method uses this function as well which would causea infinite loop
                if (node.isID && !this.prefix) 
                    this._loadPrefix();
                if (i>0) {
                    if (i<this.nodes.length-1) tempSSP += "@";
                    else tempSSP += "/";
                }
                tempSSP += node.value;
            }
        }
        else {
            for (var i = 0; i < this.nodes.length; i++) {
                var node = this.nodes[i];
                // the prefix MUST only be loaded if the prefix is needed, since the
                // loading method uses this function as well which would causea infinite loop
                if (node.isID && !this.prefix) 
                    this._loadPrefix();
                if (tempSSP!="") 
                    tempSSP += "@";
                if (node.subModel) 
                    tempSSP += this.subModelSchemeMap[node.subModel] + ":";
                if (node.isID) 
                    tempSSP += this.prefix + ":";
                
                tempSSP += node.value;
            }
        }
        return tempSSP;
    },
    _updateURI: function() {
        var uri = this.modelSchema + ":" + this.getSchemeSpecificPart();
        this.httpUrl.setParameter("uri", uri);
    },
    addParameter: function(name, value) {
        this.httpUrl.addParameter(name, value);
    },
    setParameter: function(name, value) {
        this.httpUrl.setParameter(name, value);
    },
    getParameter: function(name) {
        return this.httpUrl.getParameter(name);
    },
    getParameters: function() {
        return this.httpUrl.getParameters();
    },
    getAbsoluteURL: function() {
        return this.httpUrl.toString();
    },
    getProxifiedAbsoluteURL: function() {
        return this.httpUrl.toProxifiedString();
    },
    getModelURI: function() {
        return this.httpUrl.getParameter("uri");
    },
    toProxifiedString: function() {
        // TBD: REMOVE AFTER FULL SWITCH
        return this.httpUrl.toProxifiedString();
    }
    
});

dojo.declare("com.ibm.mm.enabler.model.url.SchemeBasedModelUrlImpl", [com.ibm.mm.enabler.model.url.BaseModelUrl], {
    constructor: function(modelSchema, model) {
        this.modelSchema = modelSchema;
        this.model = model;
        
        var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
        var url = "";
        
        // add the contextroot
        url += configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);
        
        // add the public contenthandler url
        var anonymousUser = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.ANONYMOUS_USER);
        
        var contenthandlerPath;
        
        if (anonymousUser) 
            contenthandlerPath = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PUBLIC);
        else 
            contenthandlerPath = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PRIVATE);
        
        url += contenthandlerPath;
        
        this.httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl(url);
        
        this.httpUrl.setParameter("uri", this.modelSchema); // first initialization
    }
});

dojo.declare("com.ibm.mm.enabler.model.url.SchemeBasedModelMediaUrlImpl", [com.ibm.mm.enabler.model.url.SchemeBasedModelUrlImpl], {
    constructor: function(modelSchema, model) {
        this.isMediaUrl = true;
    }
});

dojo.declare("com.ibm.mm.enabler.model.url.ThemeResourceUrlImpl", [com.ibm.mm.enabler.model.url.BaseModelUrl],
    {
        constructor: function (modelSchema, model) {
            this.modelSchema = modelSchema;
            this.model = model;
            
            this.httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl("/");
            this.httpUrl.setParameter("uri", this.modelSchema); // first initialization
        },
        _updateURI: function() {
            // at this point we know it must be a theme or skin resource we try to fetch
            if (this.nodes.length==2) { // theme
                var themeId = this.nodes[0].value;
                var resource = this.nodes[1].value;
                var themeNode = this.model.find(themeId).start();
                var url = themeNode._getBaseUrl();
                this.httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl(url+resource);
            }
            else if (this.nodes.length==3) { // skin
                var skinId = this.nodes[0].value;
                var themeId = this.nodes[1].value;
                var resource = this.nodes[2].value;
                var skinNode = this.model.find(skinId).start();
                var url = skinNode._getBaseUrl();
                this.httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl(url+resource);
            }
            else {
                this.httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl("/");
            }
        }
    }
);

dojo.declare("com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl", [com.ibm.mm.enabler.model.url.BaseModelUrl], {
    constructor: function(url, model) {
        if (!com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT) {
            com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);
            
            com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PRIVATE_HANDLER = com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT +
            com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PRIVATE);
            
            com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PUBLIC_HANDLER = com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.CONTEXT_ROOT +
            com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PUBLIC);
        }
        
        if (url.indexOf("?") == 0) {
            // add the public contenthandler url
            var anonymousUser = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.ANONYMOUS_USER);
            
            var contenthandlerPath;
            
            if (anonymousUser) 
                contenthandlerPath = com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PUBLIC_HANDLER;
            else 
                contenthandlerPath = com.ibm.mm.enabler.model.url.StringBasedModelUrlImpl.PRIVATE_HANDLER;
            
            var newURL = "";
            
            // add contenthandlerPath
            newURL += contenthandlerPath;
            
            
            url = newURL + url;
        }
        
        this.httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl(url);
    }
});

com.ibm.mm.enabler.model.UrlFactory = new com.ibm.mm.enabler.model.url.ModelUrlFactoryImpl();
// define public factory
com.ibm.mashups.enabler.model.url.ModelUrlFactory = com.ibm.mm.enabler.model.UrlFactory;
com.ibm.mashups.enabler.model.url.ModelUrlFactory.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger("com.ibm.mm.enabler.model.UrlFactory");

}

if(!dojo._hasResource["com.ibm.mm.enabler.servicedocument"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.servicedocument"] = true;
dojo.provide( "com.ibm.mm.enabler.servicedocument" );

dojo.require("dojox.xml.parser" );
dojo.require("com.ibm.mashups.enabler.xml" );
dojo.require("com.ibm.mm.enabler.xml" );
dojo.require("com.ibm.mm.enabler.debug" );

dojo.require( "com.ibm.mm.enabler.services.ModelRestServiceRequest" );

// service document model
dojo.declare("com.ibm.mm.enabler.model.ServiceDocumentModelImpl", null,
    {
        SERVICE_NAVIGATION: "navigation",
        SERVICE_SPACE_NAVIGATION: "space-navigation",
        SERVICE_SHARED_NAVIGATION: "shared-navigation",
        SERVICE_CONTENT: "content",
        SERVICE_CATALOG: "catalog",
        SERVICE_RESOURCE: "resource",
        SERVICE_WIDGET: "widget",
        SERVICE_THEME: "theme",
        SERVICE_USER: "user",
        SERVICE_MODEL: "model",
        SERVICE_MULTIPART: "multipart",
        SERVICE_HUFFMAN: "huffman",
        SERVICE_SITEMAP: "sitemap",
        SERVICE_COMPOSITE: "composite-applications",
        SERVICE_SPACE: "application",
        SERVICE_SPACE_FAVORITE: "application-favorite",
        SERVICE_TEMPLATE: "template",
        SERVICE_CONFIG: "config",
        SERVICE_FILESTORE: "filestore",
        SERVICE_WEBDAV: "webdav",
        
        constructor: function () {
            this.prefix = "service";
            this.ns = { "atom" : "http://www.w3.org/2005/Atom",
                        "app" : "http://www.w3.org/2007/app",
                        "service" : "http://www.ibm.com/xmlns/prod/sw/model/service/1.0"};
            this.xmlData = null;
            this.xmlDataAsString = null;
            this.cache = [];
        },

        getInstance: function() {
            var instance = com.ibm.mm.enabler.model.ServiceDocumentModelImpl._instance;
            return instance ? instance : (com.ibm.mm.enabler.model.ServiceDocumentModelImpl._instance = new com.ibm.mm.enabler.model.ServiceDocumentModelImpl());
        },

        _loadAhead: function() {
            if (ibmConfig.servicedocument!=null) {
                if (this.xmlDataAsString != ibmConfig.servicedocument) {
                    this.xmlData = null;
                }
            }
            if (this.xmlData != null) return;
            com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.ServiceDocumentModelImpl._loadAhead");
            if (ibmConfig.servicedocument!=null) {
                this.xmlData = dojox.xml.parser.parse( ibmConfig.servicedocument );
                this.xmlDataAsString = ibmConfig.servicedocument;
            } else {
                var myUrl;
                if (ibmConfig.serviceDocumentUrl != null) {
                    myUrl = new com.ibm.mm.enabler.utilities.HttpUrl(ibmConfig.serviceDocumentUrl);
                } else {
                    myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl("service", null);
                    myUrl.setNodes([{
                            value: "collection",
                            isID: false
                        }]);
                }
                var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, true);
                serviceReq.read(
                    dojo.hitch(this,
                        function (type, data, xhr, args) {
                            if (type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) {
                                this.xmlData = data;
                            } else if (type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_ERROR) {
                                // TODO
                            }
                        }
                    )
                );
            }
            this._fillCache();
            com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.ServiceDocumentModelImpl._loadAhead");
        },
        _fillCache: function() {
            var matches = [];
            var expr = "//app:collection";
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
            for (var i=0; i<nodes.length; ++i) {
                var found = this._processCollection(i, nodes[i]);
                if (found) {
                    this.cache[this.cache.length] = found;
                }
            }
            var expr = "//service:collection";
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
            for (var i=0; i<nodes.length; ++i) {
                var found = this._processCollection(i, nodes[i]);
                if (found) {
                    this.cache[this.cache.length] = found;
                }
            }
        },
        
        /**
        Returns an array of available model ids which are compatible for the enabler runtime
        */
        getModelCollections: function() {
            this._loadAhead();
            var ret = [];
            var count = 0;
            var expr = "//atom:category[@term='enabler-ns-base']";
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
            for (var i=0; i<nodes.length; ++i) {
                var parent = nodes[i].parentNode;
                var expr2 = "//atom:category[not (@term='enabler-ns-base' or @term='enabler-ns-model' or @term='enabler-ns-ext' or @term='enabler-ns-creationcontext' or @term='mashups')]";
                var nodes2 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr2, parent, this.ns);
                if (nodes2 && nodes2.length>0) {
                    var terms = [];
                    for (var ii=0; ii<nodes2.length; ++ii) {
                        if (nodes2[ii].parentNode==parent)
                            terms.push(nodes2[ii].getAttribute("term"));
                    }
                    terms.sort();
                    // verify if already exists(e.g. due to another version)
                    var dup = this._isDuplicate(ret, terms);
                    if (!dup) {
                        ret[count] = terms;
                        count++;
                    }
                }
            }
            return ret;
        },
        _isDuplicate: function(array, newterm) {
            var dup = false;
            for (var ii=0; ii<array.length; ii++) {
                if (array[ii].length==newterm.length) {
                    var equal = true;
                    for (var c=0; c<newterm.length; c++) {
                        if (array[ii][c]!=newterm[c]) {
                            equal = false;
                            break;
                        }
                    }
                    if (equal) {
                        dup = true;
                        break;
                    }
                }
            }
            return dup;
        },
        /**
        Returns an array of available model ids which are compatible for the enabler runtime
        */
        getMashupsCollections: function() {
            this._loadAhead();
            var ret = [];
            var count = 0;
            var expr = "//atom:category[@term='mashups']";
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
            for (var i=0; i<nodes.length; ++i) {
                var parent = nodes[i].parentNode;
                var expr2 = "//atom:category[not (@term='enabler-ns-base' or @term='enabler-ns-model' or @term='enabler-ns-ext' or @term='enabler-ns-creationcontext' or @term='mashups')]";
                var nodes2 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr2, parent, this.ns);
                if (nodes2 && nodes2.length>0) {
                    var terms = [];
                    for (var ii=0; ii<nodes2.length; ++ii) {
                        if (nodes2[ii].parentNode==parent)
                            terms.push(nodes2[ii].getAttribute("term"));
                    }
                    terms.sort();
                    // verify if already exists(e.g. due to another version)
                    var dup = this._isDuplicate(ret, terms);
                    if (!dup) {
                        ret[count] = terms;
                        count++;
                    }
                }
            }            
            return ret;
        },
        /**
        Returns a JSON object for a given collection link in the service document. Not all elements are mandatory
        JSON format
        { id: "the id array",
          url :"the url",
          template :"the template",
          idprefix: "id|oid",
          namespaces : { "base" : "base-url", "model" : "model-url", "ext" : "ext-url", "creation-context" : "creation-context-url" },
          accept: "accept MIME type",
          version: "major.minor"
        };
        @param {Array} idArray
        @type Object
        @return {Object} Returns a JSON object for a given collection link in the service document
        */
        getCollectionData: function(idArray) {
            this._loadAhead();
            var ret = {}; 
            if (this.xmlData == null) {
                return ret;
            }
            var ids = [];
            if (dojo.isArray(idArray)) {
                ids = idArray;
            }
            else {
                ids = [idArray];
            }

            ret = this._getCachedValue(ids);
            return ret;
        },
        _getCachedValue: function(ids)
        {
            // try the best match
            var scoreCard = [];
            for (var i = 0; i < this.cache.length; i++) {
                var matchIds = this.cache[i].id;
                var score = 0;
                for (j = 0; j < matchIds.length; j++) {
                    if (matchIds[j] == "mashups") {
                        // we prefer the mashups link. therefore we give score for it
                        score += 500;
                    }
                    for (m = 0; m < ids.length; m++) {
                        if (matchIds[j] == ids[m]) {
                            score += 1000;
                        }
                    }
                }
                // now honor version
                var version = this.cache[i].version;
                version = version.replace(/\./g, "");
                score += parseInt(version);
                scoreCard[i] = score;
            }
            // see who won
            var winner = -1;
            var winningScore = 1000; // we need at least one matched item, therefore the minimum is 1000 points
            for (var i = 0; i < scoreCard.length; i++) {
                if (scoreCard[i] > winningScore) {
                    winner = i;
                    winningScore = scoreCard[i];
                }
            }
            if (winner == -1) return null;
            return this.cache[winner];  
        },
        _processCollection: function(i, node)
        {
            var ret = {};
            // we found a match
            var expr3 = "app:categories//atom:category[@term]";
            var nodes3 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr3, node, this.ns);
            var nodeIDs = [];
            if (nodes3) {
                for (var jj = 0; jj < nodes3.length; jj++) {
                    var term = nodes3[jj].getAttribute('term');
                    if (term.indexOf("enabler-ns-")==0) 
                        continue;
                    nodeIDs.push(term);
                }
            }
            ret["id"] = nodeIDs;
            ret["url"] = node.getAttribute("href");
            ret["version"] = com.ibm.mm.enabler.utilities.getAttributeWithNS(
                node,"service:version","version",this.ns.service);
            if (!ret["version"])
                ret["version"] = "1.0";
            ret["template"] = com.ibm.mm.enabler.utilities.getAttributeWithNS(
                node,"service:template","template",this.ns.service);
            ret["idprefix"] = "id";
            var ns = {};
            var expr3 = "app:categories/atom:category[@term='enabler-ns-base']";
            var nodes3 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr3, node, this.ns);
            if (nodes3 && nodes3.length>0) {
                ns["base"] = nodes3[0].getAttribute("scheme");
                if (ns["base"].indexOf("/mashups/")==-1)
                    ret["idprefix"] = "oid";
            }
            var expr3 = "app:categories/atom:category[@term='enabler-ns-model']";
            var nodes3 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr3, node, this.ns);
            if (nodes3 && nodes3.length>0)
                ns["model"] = nodes3[0].getAttribute("scheme");
            var expr3 = "app:categories/atom:category[@term='enabler-ns-ext']";
            var nodes3 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr3, node, this.ns);
            if (nodes3 && nodes3.length>0)
                ns["ext"] = nodes3[0].getAttribute("scheme");
            var expr3 = "app:categories/atom:category[@term='enabler-ns-creationcontext']";
            var nodes3 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr3, node, this.ns);
            if (nodes3 && nodes3.length>0)
                ns["creation-context"] = nodes3[0].getAttribute("scheme");
            ret["namespaces"] = ns;
            var expr3 = "app:accept";
            var nodes3 = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr3, node, this.ns);
            if (nodes3 && nodes3.length>0)
                ret["accept"] = nodes3[0].firstChild.nodeValue;
            return ret;
        }
    }
);
com.ibm.mm.enabler.model.ServiceDocumentModel = com.ibm.mm.enabler.model.ServiceDocumentModelImpl.prototype.getInstance();

}

if(!dojo._hasResource["com.ibm.mm.enabler.model.utils"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.model.utils"] = true;
dojo.provide( "com.ibm.mm.enabler.model.utils" );

dojo.require( "com.ibm.mm.enabler.utilities" );



dojo.require( "com.ibm.mm.enabler.servicedocument" );

//internal factory
dojo.declare( "com.ibm.mm.enabler.model.NameSpaceFactoryImpl", null,
    {
        constructor:function () {

            // name space prefixes
            this.NS_APP 	    		= "app";
            this.NS_ATOM 	    		= "atom";
            this.NS_THR 	    		= "thr";
            this.NS_UM 		   	 		= "um";
            this.NS_XHTML      			= "xhtml";
            this.NS_XML 	    		= "xml";
            this.NS_XSI 	    		= "xsi";
            this.NS_OPENSEARCH  		= "opensearch";
            this.NS_CM          		= "cm";
            this.NS_CA          		= "ca";
            this.NS_CREATION_CONTEXT    = "creation-context";
            this.NS_AC                  = "ac";

            // name space URIs
            this.namespaces = {};
            this.namespaces[this.NS_APP]        		= "http://www.w3.org/2007/app";
            this.namespaces[this.NS_ATOM]       		= "http://www.w3.org/2005/Atom";
            this.namespaces[this.NS_THR]        		= "http://purl.org/syndication/thread/1.0";
            this.namespaces[this.NS_UM]         		= "http://www.ibm.com/xmlns/prod/websphere/um.xsd";
            this.namespaces[this.NS_XHTML]      		= "http://www.w3.org/1999/xhtml";
            this.namespaces[this.NS_XML]        		= "http://www.w3.org/XML/1998/namespace";
            this.namespaces[this.NS_XSI]        		= "http://www.w3.org/2001/XMLSchema-datatypes";
            this.namespaces[this.NS_OPENSEARCH] 		= "http://a9.com/-/spec/opensearch/1.1/";
            this.namespaces[this.NS_CM]         		= "http://www.ibm.com/xmlns/prod/composite-applications/v1.0";
            this.namespaces[this.NS_CA]         		= "http://www.ibm.com/xmlns/prod/composite-applications/v1.0";
            this.namespaces[this.NS_AC]                 = "http://www.ibm.com/xmlns/prod/lotus/access-control/v1.0";
        },

        /**
		 * Returns an object with a property for each element in the
		 * passed in array and the corresponding name space uri as value
		 * @param {Array} prefixes
		 */
        getNameSpaces: function(prefixes) {
            var result = {};
            var len = prefixes.length;
            for (i=0; i<len; i++) {
                var name = prefixes[i];
            	result[name] = this.namespaces[name];
            }
            return result;
        },

        /**
         * Returns the name space uri that corresponds to the passed in prefix
         */
        getNameSpaceUri: function(prefix) {
            return this.namespaces[prefix];
        }
    }
);

com.ibm.mm.enabler.model.NameSpaceFactory = new com.ibm.mm.enabler.model.NameSpaceFactoryImpl();

//internal factory
dojo.declare( "com.ibm.mm.enabler.model.HttpStatusCodesImpl", null,
    {
        constructor:function () {
            this.HTTP_CONTINUE              = "100";
            this.HTTP_SWITCHING_PROTOCOLS   = "101";
            this.HTTP_OK 	                = "200";
            this.HTTP_CREATED               = "201";
            this.HTTP_NOT_FOUND 	        = "404";
            this.HTTP_REQUEST_TIMEOUT       = "408";
            this.HTTP_INTERNAL_SERVER_ERROR = "500";
            this.HTTP_SERVICE_UNAVAILABLE   = "503";
        }
    }
);

//internal
dojo.declare( "com.ibm.mm.enabler.model.UtilsImpl", null,
    {
        constructor:function () {
            // we do a lazy init
            this.serviceJson = null;
        },
        _lazyInit:function() {
            if (this.serviceJson) return;
            this.xmlDom = com.ibm.mm.enabler.dom.createDocument();
            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            this.prefix = this.serviceJson.idprefix;
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.ns = nsf.getNameSpaces([nsf.NS_ATOM]);
            for (prefix in this.serviceJson.namespaces) {
                this.ns[prefix] = this.serviceJson.namespaces[prefix];
            }
        },

        createNode: function(name, ns) {
            this._lazyInit();
            return com.ibm.mm.enabler.dom.createElement(this.xmlDom, name, ns);
        },

        createLinkNode: function(href, rel, ns) {
            var linkNode = this.createNode("atom:link", ns);
            linkNode.setAttribute("href", href);
            linkNode.setAttribute("rel", rel);
            return linkNode;
        },

        createExtLinkNode: function(href, rel, extrel) {
            this._lazyInit();
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            var linkNode = this.createNode("atom:link", this.ns[nsf.NS_ATOM]);
            linkNode.setAttribute("href", href);
            if (rel) linkNode.setAttribute("rel", rel);
            com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom,
                linkNode, "ext:rel", "rel", this.ns["ext"], extrel);
            return linkNode;
        },

        getIdFromExtUri: function(prefix, node) {
            this._lazyInit();
            var id = null;
            var uri = com.ibm.mm.enabler.utilities.getAttributeWithNS(
                node,"ext:uri", "uri", this.ns["ext"]);
            // remove model scope from id
            if (uri) {
                // check for associative id
                var aPos = uri.indexOf("@");
                if (aPos != -1) {
                    uri = uri.slice(0, aPos);
                }
                id = uri;
                // remove model scope from id
                var idPos = id.lastIndexOf(":");
                if (idPos!=-1)
                    id = id.slice(idPos + 1);
                var idPos = id.toUpperCase().lastIndexOf("%3A");
                if (idPos!=-1)
                    id = id.slice(idPos + 3);
                idPos = id.lastIndexOf("/");
                if (idPos!=-1)
                    id = id.slice(idPos + 1);
            }
            return id;
        },

		
		getHrefFromIdentifiable: function(identifiable) {
			return (identifiable && (typeof identifiable._getParameters == "function")) ? identifiable._getParameters().href : null;			
		},
		
		getIdFromIdentifiable: function(identifiable) {
			return (identifiable instanceof com.ibm.mashups.enabler.Identifiable) ? identifiable.getID() : identifiable; 			
		},

        setAttributeWithNS: function(element, attName, nsUri, value){
            this._lazyInit();
            com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlDom, element, attName, null, nsUri, value);
        },
        createFeed: function(id, title, entry, namespaces) {
            var ns = "";
            for (prefix in namespaces) {
                ns += "xmlns:" + prefix + "=\"" + namespaces[prefix] + "\" ";
            }
            var time = new Date();
            var feed = '<?xml version="1.0" encoding="UTF-8"?>\n' +
                       '<atom:feed ' + ns +' >\n' +
                       '<atom:title>' + title + '</atom:title>\n' +
                       '<atom:id>' + id + '</atom:id>\n' +
                       '<atom:updated>' + time.toGMTString() + '</atom:updated>\n' +
                       entry + 
                       '</atom:feed>';
            return feed;
        },
		
        checkForEndpoints: function(/*String*/url){
            if (!url) {
                return null;
            }
        
            var result = url.toString();
            if (result) {
                var index = result.indexOf("endpoint://", 0);
                if (index == 0) {
                    var relativeIndex = result.indexOf("/", 11);
                    if (relativeIndex > 0) {
                        var endpoint = result.substring(11, relativeIndex);
                        var relativeURL = result.substring(relativeIndex + 1);
                        var resolvedEndpoint = this._resolveEndpoint(endpoint);
                        if (resolvedEndpoint.charAt(resolvedEndpoint.length - 1) == '/') {
                            result = resolvedEndpoint + relativeURL;
                        } else {
                            result = resolvedEndpoint + '/' + relativeURL;
                        }
                        return result;
                    }
                } else if (index > 0) {
                    var origUrl = result.substring(0, index);
                    var endpointPortion = result.substring(index);
                    var endpointPortion2 = this.checkForEndpoints(endpointPortion);
                    if (endpointPortion2 != null) {
                        return origUrl + endpointPortion2.substring(1);
                    }
                }
            }
		
            return null;
        },
	    
        _resolveEndpoint: function(/*String*/endpoint){
            if (!this.cs) {
                this.cs = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
            }
			
            if (!this.co) {
                this.co = this.cs.getConfigObject(this.cs.ENDPOINT_CONFIG_PROVIDER);
            }
            var url = this.co.getValue(decodeURIComponent(endpoint) + ".url");
            if ((url) && (url.charAt(0) != "/") && (url.substr(0, 4) != "http")) {
                url = "/" + url;
            }
        
            return url;
        }
    }
);

// internal factory
dojo.declare( "com.ibm.mm.enabler.model.NavigationNodeFactoryImpl", null,
    {
        constructor:function () {
            // we do a lazy init
            this.serviceJson = null;
        },
        _lazyInit:function() {
            if (this.serviceJson) return;
            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.ns = nsf.getNameSpaces([nsf.NS_ATOM]);
            for (prefix in this.serviceJson.namespaces) {
                this.ns[prefix] = this.serviceJson.namespaces[prefix];
            }
        },
        createNavigationNode: function(xmlData) {
            this._lazyInit();
            var result = null;
            var navNodeExpr = "atom:link[@ext:class='content-node']";
            var navNode = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(navNodeExpr, xmlData, this.ns);
            if (navNode && navNode.length > 0) {
                var user_own = com.ibm.mm.enabler.utilities.getAttributeWithNS(
                    navNode[0],"ext:user-own","user-own",this.ns["ext"]);
                if (user_own == "false") {
                    result = new com.ibm.mm.enabler.navigation.SharedNavigationNodeImpl(xmlData);
                }
            }
            if (!result) {
                result = new com.ibm.mm.enabler.navigation.NavigationNodeImpl(xmlData);
            }
            return result;
        }
    }
);

// internal factories
com.ibm.mm.enabler.model.HttpStatusCodes = new com.ibm.mm.enabler.model.HttpStatusCodesImpl();
com.ibm.mm.enabler.model.Utils = new com.ibm.mm.enabler.model.UtilsImpl();
com.ibm.mm.enabler.model.NavigationNodeFactory = new com.ibm.mm.enabler.model.NavigationNodeFactoryImpl();

}

if(!dojo._hasResource["dojo.io.iframe"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.io.iframe"] = true;
dojo.provide("dojo.io.iframe");

/*=====
dojo.declare("dojo.io.iframe.__ioArgs", dojo.__IoArgs, {
	constructor: function(){
		//	summary:
		//		All the properties described in the dojo.__ioArgs type, apply
		//		to this type. The following additional properties are allowed
		//		for dojo.io.iframe.send():
		//	method: String?
		//		The HTTP method to use. "GET" or "POST" are the only supported
		//		values.  It will try to read the value from the form node's
		//		method, then try this argument. If neither one exists, then it
		//		defaults to POST.
		//	handleAs: String?
		//		Specifies what format the result data should be given to the
		//		load/handle callback. Valid values are: text, html, xml, json,
		//		javascript. IMPORTANT: For all values EXCEPT html and xml, The
		//		server response should be an HTML file with a textarea element.
		//		The response data should be inside the textarea element. Using an
		//		HTML document the only reliable, cross-browser way this
		//		transport can know when the response has loaded. For the html
		//		handleAs value, just return a normal HTML document.  NOTE: xml
		//		is now supported with this transport (as of 1.1+); a known issue
		//		is if the XML document in question is malformed, Internet Explorer
		//		will throw an uncatchable error.
		//	content: Object?
		//		If "form" is one of the other args properties, then the content
		//		object properties become hidden form form elements. For
		//		instance, a content object of {name1 : "value1"} is converted
		//		to a hidden form element with a name of "name1" and a value of
		//		"value1". If there is not a "form" property, then the content
		//		object is converted into a name=value&name=value string, by
		//		using dojo.objectToQuery().
		this.method = method;
		this.handleAs = handleAs;
		this.content = content;
	}
});
=====*/

dojo.io.iframe = {
	create: function(/*String*/fname, /*String*/onloadstr, /*String?*/uri){
		//	summary:
		//		Creates a hidden iframe in the page. Used mostly for IO
		//		transports.  You do not need to call this to start a
		//		dojo.io.iframe request. Just call send().
		//	fname: String
		//		The name of the iframe. Used for the name attribute on the
		//		iframe.
		//	onloadstr: String
		//		A string of JavaScript that will be executed when the content
		//		in the iframe loads.
		//	uri: String
		//		The value of the src attribute on the iframe element. If a
		//		value is not given, then dojo/resources/blank.html will be
		//		used.
		if(window[fname]){ return window[fname]; }
		if(window.frames[fname]){ return window.frames[fname]; }
		var cframe = null;
		var turi = uri;
		if(!turi){
			if(dojo.config["useXDomain"] && !dojo.config["dojoBlankHtmlUrl"]){
				console.warn("dojo.io.iframe.create: When using cross-domain Dojo builds,"
					+ " please save dojo/resources/blank.html to your domain and set djConfig.dojoBlankHtmlUrl"
					+ " to the path on your domain to blank.html");
			}
			turi = (dojo.config["dojoBlankHtmlUrl"]||dojo.moduleUrl("dojo", "resources/blank.html"));
		}
		var ifrstr = dojo.isIE ? '<iframe name="'+fname+'" src="'+turi+'" onload="'+onloadstr+'">' : 'iframe';
		cframe = dojo.doc.createElement(ifrstr);
		with(cframe){
			name = fname;
			setAttribute("name", fname);
			id = fname;
		}
		dojo.body().appendChild(cframe);
		window[fname] = cframe;
	
		with(cframe.style){
			if(!(dojo.isSafari < 3)){
				//We can't change the src in Safari 2.0.3 if absolute position. Bizarro.
				position = "absolute";
			}
			left = top = "1px";
			height = width = "1px";
			visibility = "hidden";
		}

		if(!dojo.isIE){
			this.setSrc(cframe, turi, true);
			cframe.onload = new Function(onloadstr);
		}

		return cframe;
	},

	setSrc: function(/*DOMNode*/iframe, /*String*/src, /*Boolean*/replace){
		//summary:
		//		Sets the URL that is loaded in an IFrame. The replace parameter
		//		indicates whether location.replace() should be used when
		//		changing the location of the iframe.
		try{
			if(!replace){
				if(dojo.isWebKit){
					iframe.location = src;
				}else{
					frames[iframe.name].location = src;
				}
			}else{
				// Fun with DOM 0 incompatibilities!
				var idoc;
				//WebKit > 521 corresponds with Safari 3, which started with 522 WebKit version.
				if(dojo.isIE || dojo.isWebKit > 521){
					idoc = iframe.contentWindow.document;
				}else if(dojo.isSafari){
					idoc = iframe.document;
				}else{ //  if(d.isMozilla){
					idoc = iframe.contentWindow;
				}
	
				//For Safari (at least 2.0.3) and Opera, if the iframe
				//has just been created but it doesn't have content
				//yet, then iframe.document may be null. In that case,
				//use iframe.location and return.
				if(!idoc){
					iframe.location = src;
					return;
				}else{
					idoc.location.replace(src);
				}
			}
		}catch(e){ 
			console.log("dojo.io.iframe.setSrc: ", e); 
		}
	},

	doc: function(/*DOMNode*/iframeNode){
		//summary: Returns the document object associated with the iframe DOM Node argument.
		var doc = iframeNode.contentDocument || // W3
			(
				(
					(iframeNode.name) && (iframeNode.document) && 
					(document.getElementsByTagName("iframe")[iframeNode.name].contentWindow) &&
					(document.getElementsByTagName("iframe")[iframeNode.name].contentWindow.document)
				)
			) ||  // IE
			(
				(iframeNode.name)&&(document.frames[iframeNode.name])&&
				(document.frames[iframeNode.name].document)
			) || null;
		return doc;
	},

	send: function(/*dojo.io.iframe.__ioArgs*/args){
		//summary: function that sends the request to the server.
		//This transport can only process one send() request at a time, so if send() is called
		//multiple times, it will queue up the calls and only process one at a time.
		if(!this["_frame"]){
			this._frame = this.create(this._iframeName, dojo._scopeName + ".io.iframe._iframeOnload();");
		}

		//Set up the deferred.
		var dfd = dojo._ioSetArgs(
			args,
			function(/*Deferred*/dfd){
				//summary: canceller function for dojo._ioSetArgs call.
				dfd.canceled = true;
				dfd.ioArgs._callNext();
			},
			function(/*Deferred*/dfd){
				//summary: okHandler function for dojo._ioSetArgs call.
				var value = null;
				try{
					var ioArgs = dfd.ioArgs;
					var dii = dojo.io.iframe;
					var ifd = dii.doc(dii._frame);
					var handleAs = ioArgs.handleAs;

					//Assign correct value based on handleAs value.
					value = ifd; //html
					if(handleAs != "html"){
						if(handleAs == "xml"){
							//	FF, Saf 3+ and Opera all seem to be fine with ifd being xml.  We have to
							//	do it manually for IE.  Refs #6334.
							if(dojo.isIE){
								dojo.query("a", dii._frame.contentWindow.document.documentElement).orphan();
								var xmlText=(dii._frame.contentWindow.document).documentElement.innerText;
								xmlText=xmlText.replace(/>\s+</g, "><");
								xmlText=dojo.trim(xmlText);
								//Reusing some code in base dojo for handling XML content.  Simpler and keeps
								//Core from duplicating the effort needed to locate the XML Parser on IE.
								var fauxXhr = { responseText: xmlText };
								value = dojo._contentHandlers["xml"](fauxXhr); // DOMDocument
							}
						}else{
							value = ifd.getElementsByTagName("textarea")[0].value; //text
							if(handleAs == "json"){
								value = dojo.fromJson(value); //json
							}else if(handleAs == "javascript"){
								value = dojo.eval(value); //javascript
							}
						}
					}
				}catch(e){
					value = e;
				}finally{
					ioArgs._callNext();				
				}
				return value;
			},
			function(/*Error*/error, /*Deferred*/dfd){
				//summary: errHandler function for dojo._ioSetArgs call.
				dfd.ioArgs._hasError = true;
				dfd.ioArgs._callNext();
				return error;
			}
		);

		//Set up a function that will fire the next iframe request. Make sure it only
		//happens once per deferred.
		dfd.ioArgs._callNext = function(){
			if(!this["_calledNext"]){
				this._calledNext = true;
				dojo.io.iframe._currentDfd = null;
				dojo.io.iframe._fireNextRequest();
			}
		}

		this._dfdQueue.push(dfd);
		this._fireNextRequest();
		
		//Add it the IO watch queue, to get things like timeout support.
		dojo._ioWatch(
			dfd,
			function(/*Deferred*/dfd){
				//validCheck
				return !dfd.ioArgs["_hasError"];
			},
			function(dfd){
				//ioCheck
				return (!!dfd.ioArgs["_finished"]);
			},
			function(dfd){
				//resHandle
				if(dfd.ioArgs._finished){
					dfd.callback(dfd);
				}else{
					dfd.errback(new Error("Invalid dojo.io.iframe request state"));
				}
			}
		);

		return dfd;
	},

	_currentDfd: null,
	_dfdQueue: [],
	_iframeName: dojo._scopeName + "IoIframe",

	_fireNextRequest: function(){
		//summary: Internal method used to fire the next request in the bind queue.
		try{
			if((this._currentDfd)||(this._dfdQueue.length == 0)){ return; }
			var dfd = this._currentDfd = this._dfdQueue.shift();
			var ioArgs = dfd.ioArgs;
			var args = ioArgs.args;

			ioArgs._contentToClean = [];
			var fn = dojo.byId(args["form"]);
			var content = args["content"] || {};
			if(fn){
				if(content){
					// if we have things in content, we need to add them to the form
					// before submission
					var pHandler = function(name, value) {
						var tn;
						if(dojo.isIE){
							tn = dojo.doc.createElement("<input type='hidden' name='"+name+"'>");
						}else{
							tn = dojo.doc.createElement("input");
							tn.type = "hidden";
							tn.name = name;
						}
						tn.value = value;
						fn.appendChild(tn);
						ioArgs._contentToClean.push(name);
					};
					for(var x in content){
						var val = content[x];
						if(dojo.isArray(val) && val.length > 1){
							var i;
							for (i = 0; i < val.length; i++) {
								pHandler(x,val[i]);
							}
						}else{
							if(!fn[x]){
								pHandler(x,val);
							}else{
								fn[x].value = val;
							}
						}
					}
				}
				//IE requires going through getAttributeNode instead of just getAttribute in some form cases, 
				//so use it for all.  See #2844
				var actnNode = fn.getAttributeNode("action");
				var mthdNode = fn.getAttributeNode("method");
				var trgtNode = fn.getAttributeNode("target");
				if(args["url"]){
					ioArgs._originalAction = actnNode ? actnNode.value : null;
					if(actnNode){
						actnNode.value = args.url;
					}else{
						fn.setAttribute("action",args.url);
					}
				}
				if(!mthdNode || !mthdNode.value){
					if(mthdNode){
						mthdNode.value= (args["method"]) ? args["method"] : "post";
					}else{
						fn.setAttribute("method", (args["method"]) ? args["method"] : "post");
					}
				}
				ioArgs._originalTarget = trgtNode ? trgtNode.value: null;
				if(trgtNode){
					trgtNode.value = this._iframeName;
				}else{
					fn.setAttribute("target", this._iframeName);
				}
				fn.target = this._iframeName;
				fn.submit();
			}else{
				// otherwise we post a GET string by changing URL location for the
				// iframe
				var tmpUrl = args.url + (args.url.indexOf("?") > -1 ? "&" : "?") + ioArgs.query;
				this.setSrc(this._frame, tmpUrl, true);
			}
		}catch(e){
			dfd.errback(e);
		}
	},

	_iframeOnload: function(){
		var dfd = this._currentDfd;
		if(!dfd){
			this._fireNextRequest();
			return;
		}

		var ioArgs = dfd.ioArgs;
		var args = ioArgs.args;
		var fNode = dojo.byId(args.form);
	
		if(fNode){
			// remove all the hidden content inputs
			var toClean = ioArgs._contentToClean;
			for(var i = 0; i < toClean.length; i++) {
				var key = toClean[i];
				//Need to cycle over all nodes since we may have added
				//an array value which means that more than one node could
				//have the same .name value.
				for(var j = 0; j < fNode.childNodes.length; j++){
					var chNode = fNode.childNodes[j];
					if(chNode.name == key){
						dojo.destroy(chNode);
						break;
					}
				}
			}

			// restore original action + target
			if(ioArgs["_originalAction"]){
				fNode.setAttribute("action", ioArgs._originalAction);
			}
			if(ioArgs["_originalTarget"]){
				fNode.setAttribute("target", ioArgs._originalTarget);
				fNode.target = ioArgs._originalTarget;
			}
		}

		ioArgs._finished = true;
	}
}

}

if(!dojo._hasResource["com.ibm.mm.enabler.aspects"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.aspects"] = true;
dojo.provide( "com.ibm.mm.enabler.aspects" );
//dojo.require( "com.ibm.mm.enabler.model" );
dojo.require( "com.ibm.mm.enabler.xpath" );
dojo.require( "com.ibm.mm.enabler.debug" );
dojo.require( "com.ibm.mashups.enabler.model" );
dojo.require( "com.ibm.mm.enabler.deferred" );
dojo.require( "com.ibm.mm.enabler.model.utils" );



dojo.require( "com.ibm.mm.enabler.services.ConfigService" );



dojo.require( "dojo.i18n" );


// allowed access helper
dojo.declare( "com.ibm.mm.enabler.EffectiveAccessImpl", [com.ibm.mashups.enabler.ac.EffectiveAccess],
{
    constructor:function () {
        var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
        this.ns_ac = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_AC]);
        this.EDIT_LINK = "atom:link[@rel='edit']";
        this.XPATH1 = "atom:content/*/ac:allowed-access";
        this.XPATH2 = "atom:content/*/ac:allowed-access/ac:access-level";
    },

    _init: function(data) {
        this.xmlData = data;
        this.XPATH1 = "atom:content/ac:allowed-access";
        this.XPATH2 = "atom:content/ac:allowed-access/ac:access-level";
    },
    
    _hasEditLink: function() {
        var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.EDIT_LINK, this.xmlData, this.ns_ac);
        if (nodes && nodes.length > 0) {
            return true;
        } else {
            return false;
        }
    },

    _hasAllowedAccess: function() {
        var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.XPATH1, this.xmlData, this.ns_ac);
        if (nodes && nodes.length > 0) {
            return true;
        } else {
            return false;
        }
    },
    
    hasRole: function(roletype) {
        roletype = roletype.toUpperCase();
        if (this._hasAllowedAccess()) {
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.XPATH2, this.xmlData, this.ns_ac);
            if (nodes && nodes.length > 0) {
                for (var i=0; i<nodes.length; i++) {
                    var type = com.ibm.mm.enabler.utilities.getAttributeWithNS(nodes[i],"ac:type","type",this.ns_ac.ac);
                    if (type) {
                        if (type.toUpperCase()==roletype) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        else {
            if (roletype == "USER") {
                return true;
            }
            return this._hasEditLink();
        }
    }
});

// anonymous helper
dojo.declare( "com.ibm.mm.enabler.AnonymousHelper", null,
{
    constructor:function () {
    },
    _isAnonymous: function() {
        if (ibmConfig.anonymousUser) {
            return true;
        } else {
            return false;
        }
    },
    _isAnonymousLockedOnMode: function() {
        var allow = ibmConfig["com.ibm.mashups.anonymous.mode.locked.on"];
        if (allow)
            return true;
        else
            return false;
    },
    _isAnonymousLockedDown: function() {
        if (!this._isAnonymous()) return false;
        return !this._isAnonymousLockedOnMode();
    },
    _isAnonymousLockedOn: function() {
        if (!this._isAnonymous()) return false;
        return this._isAnonymousLockedOnMode();
    },
    getAnonymousMode: function() {
        if (this._isAnonymousLockedDown())
            return com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS;
        else
            return com.ibm.mashups.enabler.user.AnonymousMode.USER;
    }
});
com.ibm.mm.enabler.AnonymousHelper = new com.ibm.mm.enabler.AnonymousHelper();

// confirmable model helper
dojo.declare( "com.ibm.mm.enabler.ConfirmableModelImpl", null,
{
    constructor:function () {
        var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
        this.ns_ac = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_AC]);
        this.helper = com.ibm.mm.enabler.AnonymousHelper;
    },
    getConfirmCreate: function() {
        // if possible we should use the virtual resources here
        if (com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS)
            return false;
        return true;
    },
    getConfirmInsert: function() {
        // if possible we should use the virtual resources here
        if (com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS)
            return false;
        return true;
    },
    getConfirmReparent: function(node, parent, next) {
        if (this.helper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS)
            return false;
        var parentAccess = true;
        if (parent) parentAccess = parent.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        var nodeAccess = true; 
        if (node) nodeAccess = node.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
        return nodeAccess && parentAccess;
    },
    getConfirmReorder: function(node, parent, next) {
        if (this.helper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS)
            return false;
        var nextAccess = true;
        if (next) nextAccess = next.hasRole(com.ibm.mashups.enabler.ac.RoleType.USER);
        var parentAccess = true;
        if (parent) parentAccess = parent.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        var nodeAccess = true; 
        if (node) nodeAccess = node.hasRole(com.ibm.mashups.enabler.ac.RoleType.USER);
        return nodeAccess && parentAccess && nextAccess;
    },
    getConfirmRemove: function(node) {
        if (this.helper.getAnonymousMode()==com.ibm.mashups.enabler.user.AnonymousMode.ANONYMOUS)
            return false;
        if (node) {
            return node.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
        }
        return false;
    }
});

// submittable form provider
dojo.declare( "com.ibm.mm.enabler.SubmittableFormProviderImpl", com.ibm.mashups.enabler.SubmittableFormProvider, 
	{
    	constructor:function() {
    	},
    
		/**
     	* Returns a SubmittableForm object associated with the given id.
     	* @param {String} id the id of the html form this object is associated with
     	* @return {SubmittableForm} SubmittableForm object, maybe <code>null</code>
     	*/
    	getSubmittableForm: function(id) {
			var model = null;
			var url;
			if (id == "spaceForm") {
				url = new com.ibm.mm.enabler.model.UrlFactory.createModelUrl(com.ibm.mm.enabler.model.UrlFactory.SPACE_URL, null);
                url.setNodes([{
                        value: "collection",
                        isID: false
                    }]);
	      	  	url.setParameter("mode", "import");
		      	url.setParameter("mime-type", "text/html");	
				// When we import page .data file came from old BSpace data, we should use the import space rest api, and post spaceId to server.
				if (arguments[1] != null)
					url.setParameter("spaceId", arguments[1]);	
							
				url =  url.toProxifiedString();
				/*"/mum/mycontenthandler?uri=space:collection&mode=import"*/
            	model = new com.ibm.mm.enabler.SubmittableFormImpl(url, "post", id);
			}
			else if (id == "pageForm") {
 				var serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_RESOURCE);
				url = new com.ibm.mm.enabler.model.UrlFactory.getModelUrl(serviceJson.url,this);
		        url.setParameter("mode", "import");
			    url.setParameter("mime-type", "text/html");
				// post the spaceId to server.
				if (arguments[1] != null)
					url.setParameter("spaceId", arguments[1]);
					
				url =  url.toProxifiedString();
				/*"/mum/mycontenthandler?uri=resource:collection&mode=import"*/
            	model = new com.ibm.mm.enabler.SubmittableFormImpl(url , "post", id);
			}
			return model;
    	}
});

// sumbittable form
dojo.declare( "com.ibm.mm.enabler.SubmittableFormImpl", com.ibm.mashups.enabler.SubmittableForm, 
	{
		constructor:function(url, method, formId) {
			this.url = url;
			this.method = method;
			this.formId = formId;
    	},
    
    	/**
     	* Returns the URL this form is submitted to. Used to fill in the action attribute in the form.
     	* @return {String} the URL this form is submitted to; never <code>null</code>
     	*/
    	getURL: function() {
        	return this.url; 
    	},
    
    	/**
     	* Returns the HTTP method used to submit this form. Used to fill in the method attribute in the form.
     	* @return {String} the method; never <code>null</code>
     	*/
    	getMethod: function() {
        	return this.method; 
    	},

    	/**
     	* Submits the form
     	* @return {Deferred} a deferred object used to start this operation. 
     	*/
    	submit: function() {
            return new com.ibm.mm.enabler.DeferredImpl(this, this._submit);
		},
    
    	/**
     	* Submits the form
     	* @return {Deferred} a deferred object used to start this operation. 
     	*/
    	_submit: function(deferred) {
			dojo.io.iframe.send({
			 		url: this.url,
			 		method: this.method,
			 		handleAs: "text",
					// For IE issue
			 		form: document.getElementsByName(this.formId)[0],
					load: function(data,ioArgs){
						if (deferred && deferred.finishedCallback2) {
							// callback handling
							deferred.finishedCallback2(data, com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_CREATED, deferred.finishedCallbackParameters2);
						}
	 		 		},
	 		 		error: function(data,ioArgs){
						if (deferred && deferred.finishedCallback2) {
							deferred.finishedCallback2(data, com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_NOT_FOUND, deferred.finishedCallbackParameters2);
						}
	 		 		}
		 	});
    	}
});

//identifiable
dojo.declare( "com.ibm.mm.enabler.IdentifiableImpl", com.ibm.mashups.enabler.Identifiable,
    {
        constructor:function () {
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.id_ns = nsf.getNameSpaces([nsf.NS_ATOM]);
            this.ATOM_ID = "atom:id";
            // service document and initialization
            this.id_serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            this.id_prefix = this.id_serviceJson.idprefix;
        },

        getID: function() {
            var result = null;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ATOM_ID, this.xmlData, this.id_ns );
            if (nodes && nodes.length > 0) {
                var id = com.ibm.mm.enabler.dom.textContent(nodes[0]);

                // check for associative id
                var aPos = id.indexOf("@");
                if (aPos != -1) {
                    id = id.slice(0, aPos);
                }

                // remove model scope from id
                var idPos = id.lastIndexOf(":");
                if (idPos!=-1)
                    id = id.slice(idPos + 1);
                var idPos = id.toUpperCase().lastIndexOf("%3A");
                if (idPos!=-1)
                    id = id.slice(idPos + 3);
                idPos = id.lastIndexOf("/");
                if (idPos!=-1)
                    id = id.slice(idPos + 1);
                
                result = id;
            } else {
                throw new Error(dojo.string.substitute(me.modelMessages.E_ELEMENT_NOT_FOUND_2, [this.ATOM_ID, this.toString()]));
            }
            return result;
        },

        setID: function(id) {
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ATOM_ID, this.xmlData, this.id_ns );
            if (nodes && nodes.length > 0) {
                var currentId = com.ibm.mm.enabler.dom.textContent(nodes[0]);

                // associative id (including '@')
                var aPos = currentId.indexOf("@");
                var association = (aPos != -1) ? currentId.slice(aPos) : "";

                // model schema
                var mPos = currentId.indexOf(this.id_prefix + ":");
                var model = (mPos > 0) ? currentId.slice(0, mPos) : "";

                // remove model scope and add 'id:' from input id if necessary
                var idPos = id.indexOf(this.id_prefix + ":");
                var value = (idPos >=0) ? id.slice(idPos) : this.id_prefix + ":" + id;

                com.ibm.mm.enabler.dom.textContent(nodes[0], model + value + association);
            } else {
                throw new Error(dojo.string.substitute(me.modelMessages.E_ELEMENT_NOT_FOUND_2, [this.ATOM_ID, this.toString()]));
            }
        }
    }
);

// transformable
dojo.declare( "com.ibm.mm.enabler.TransformableImpl", com.ibm.mashups.enabler.Transformable,
    {
        constructor:function () {
        },

        getXml: function() {
        	return this.xmlData;
		},
		
        setXml: function(xml) {
        	this.xmlData = xml;
		}
    }
);

//localized
dojo.declare( "com.ibm.mm.enabler.LocalizedImpl", [com.ibm.mashups.enabler.Localized, com.ibm.mm.enabler.EffectiveAccessImpl],
    {
        constructor:function () {
            // service document and initialization
            var serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.li_ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_XML]);
            for (p in serviceJson.namespaces) {
                this.li_ns[p] = serviceJson.namespaces[p];
            }
            
            this.NLS_TITLE = "atom:content/*/model:title/base:nls-string";
            this.NLS_TITLE_TOP = "atom:content/*/model:title";
            this.NLS_DESCRIPTION = "atom:content/*/model:description/base:nls-string";
            this.NLS_DESCRIPTION_TOP = "atom:content/*/model:description";
            this.BASE_TITLE = "base:nls-string";
            this.BASE_DESCRIPTION = "base:nls-string";
            this.BASE_NS = this.li_ns.base;
        },

        getLocales: function() {
            var result = [];
			// use titles to scan for locales (a title is mandatory for a locale)
            var titles = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_TITLE, this.xmlData, this.li_ns);
            if (titles) {
				for (var i = 0; i < titles.length; i++) {
					var lang = com.ibm.mm.enabler.utilities.getAttributeWithNS(titles[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml")); 
                    if (lang !== null) {
                        result.push(lang);
                    }
                }
            }
            return result;
        },

        getTitle: function(loc) {
            var result = null;
            var locale = loc.replace(/-/g, "_").toLowerCase();
            var titles = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_TITLE, this.xmlData, this.li_ns);
            if (titles) {
				for (var i = 0; i < titles.length; i++) {
					var lang = com.ibm.mm.enabler.utilities.getAttributeWithNS(titles[i], "xml:lang", "lang", com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
					if (lang !== null && lang.replace(/-/g, "_").toLowerCase() == locale.toLowerCase()) {
						result = com.ibm.mm.enabler.dom.textContent(titles[i]);
						break;
					}
				}
			}
            return result;
        },

        getDescription: function(loc) {
            var result = null;
            var locale = loc.replace(/-/g, "_").toLowerCase();
            var descriptions = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLS_DESCRIPTION, this.xmlData, this.li_ns);
			if (descriptions) {
				for (var i = 0; i < descriptions.length; i++) {
					var lang = com.ibm.mm.enabler.utilities.getAttributeWithNS(descriptions[i], "xml:lang", "lang", com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
					if (lang !== null && lang.replace(/-/g, "_").toLowerCase() == locale.toLowerCase()) {
						result = com.ibm.mm.enabler.dom.textContent(descriptions[i]);
						break;
					}
				}
			}
            return result;
        },

        setTitle: function(title, loc) {
            if (title != null && typeof(title) != "undefined" && 
				loc != null && typeof(loc) != "undefined") {
				// iterate the localized titles
				var titleBase = com.ibm.mm.enabler.xpath.createXPath(this.NLS_TITLE_TOP, this.xmlData, this.li_ns);
				var titles = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.BASE_TITLE, titleBase, this.li_ns);
				var locale = loc.replace(/-/g, "_").toLowerCase();
				var localeExists = false;
				var i = titles.length;
				while (--i >= 0) {
					var lang = com.ibm.mm.enabler.utilities.getAttributeWithNS(titles[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
					if (lang !== null && lang.replace(/-/g, "_").toLowerCase() == locale.toLowerCase()) {
						// update title
						com.ibm.mm.enabler.dom.textContent(titles[i], title);
						localeExists = true;
						break;
					}
				}
    
				// create locale if it does not exists
				if (!localeExists) {
					var xmlDom = this.xmlData.ownerDocument;
					var node = com.ibm.mm.enabler.dom.createElement(xmlDom, this.BASE_TITLE, this.BASE_NS);
					com.ibm.mm.enabler.utilities.setAttributeWithNS(xmlDom, node, "xml:lang", "lang", this.li_ns.xml, loc);					
					com.ibm.mm.enabler.dom.textContent(node, title);
					titleBase.appendChild(node);
				}
			} else {
				com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.Localized.setTitle", "Make sure to not pass in undefined or null parameters.");
			}
        },
        confirmSetTitle: function(title, locale) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        },
    
        setDescription: function(description, loc) {
            if (description != null && typeof(description) != "undefined" && 
				loc != null && typeof(loc) != "undefined") {
				// iterate the localized descriptions
				var descBase = com.ibm.mm.enabler.xpath.createXPath(this.NLS_DESCRIPTION_TOP, this.xmlData, this.li_ns);
				var descriptions = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.BASE_DESCRIPTION, descBase, this.li_ns);
				var locale = loc.replace(/-/g, "_").toLowerCase();
				var localeExists = false;
				var i = descriptions.length;
				while (--i >= 0) {
					var lang = com.ibm.mm.enabler.utilities.getAttributeWithNS(descriptions[i],"xml:lang","lang",com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xml"));
					if (lang !== null && lang.replace(/-/g, "_").toLowerCase() == locale.toLowerCase()) {
						// update description
						com.ibm.mm.enabler.dom.textContent(descriptions[i], description);
						localeExists = true;
						break;
					}
				}
    
				// create locale if it does not exists
				if (!localeExists) {
					var xmlDom = this.xmlData.ownerDocument;
					var node = com.ibm.mm.enabler.dom.createElement(xmlDom, this.BASE_DESCRIPTION, this.BASE_NS);
					com.ibm.mm.enabler.utilities.setAttributeWithNS(xmlDom, node, "xml:lang", "lang", this.li_ns.xml, loc);					
					com.ibm.mm.enabler.dom.textContent(node, description);
					descBase.appendChild(node);
				}
			} else {
				com.ibm.mm.enabler.debug.warn("com.ibm.mashups.enabler.Localized.setDescription", "Make sure to not pass in undefined or null parameters.");
			}
        },
        confirmSetDescription: function(title, locale) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        }
    }
);

// meta data
dojo.declare( "com.ibm.mm.enabler.MetaDataImpl", [com.ibm.mashups.enabler.MetaData, com.ibm.mm.enabler.EffectiveAccessImpl],
    {
        constructor:function () {
            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.mdi_ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_XML]);
            for (prefix in this.serviceJson.namespaces) {
                this.mdi_ns[prefix] = this.serviceJson.namespaces[prefix];
            }
            this.MODEL_METADATA = "atom:content/*/model:metadata";
            this.MODEL_VALUE = "model:value";
        },

		// compatibility
        getMetadataNames: function() {
			return this.getMetaDataNames();
		},

		// compatibility
        getMetadata: function(name) {
			return this.getMetaData(name);
		},

		// compatibility
		setMetadata: function(name, value) {
			return this.setMetaData(name, value);
		},
		
		// compatibility
		removeMetadata: function(name) {
			this.removeMetaData(name);
		},

        getMetaDataNames: function() {
            var result = [];
			var expr = this.MODEL_METADATA + "[@name]";
            var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns);
            if (md) {
                for (var i=0; i<md.length; ++i) {
                    result.push(md[i].getAttribute("name"));
                }
            }
            return result;
        },

        getMetaData: function(name) {
			var expr = this.MODEL_METADATA + "[@name='" + name + "']/" + this.MODEL_VALUE;
            var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns);
            return (md && md.length > 0) ? md[0].getAttribute("value") : null;
        },

        setMetaData: function(name, value) {
            var result = null;
            var expr = this.MODEL_METADATA + "[@name='" + name + "']/" + this.MODEL_VALUE;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns );
            if (nodes && nodes.length > 0) {
                // update existing meta data
                nodes[0].setAttribute("value", value);
            } else {
                // create meta data
				var mdBase = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/*", this.xmlData, this.mdi_ns);
                if (mdBase && mdBase.length>0) {
                	var xmlDom = this.xmlData.ownerDocument;
                    var nameNode = com.ibm.mm.enabler.dom.createElement(xmlDom, "model:metadata", this.mdi_ns.model);
                    nameNode.setAttribute("name", name);
                    var valueNode = com.ibm.mm.enabler.dom.createElement(xmlDom, this.MODEL_VALUE, this.mdi_ns.model);
                    com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,
                        valueNode, "xsi:type", "type", com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xsi"), 
                        "xsd:string");
                    valueNode.setAttribute("value", value);
                    mdBase[0].appendChild(nameNode);
                    nameNode.appendChild(valueNode);
                }
            }
            return result;
        },
        confirmSetMetaData: function(name, value) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        },

		removeMetaData: function(name) {
            var expr = this.MODEL_METADATA + "[@name='" + name + "']";
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns );
            if (nodes && nodes.length > 0) {
                var parent = nodes[0].parentNode;
                parent.removeChild(nodes[0]);
            }
        },
        confirmRemoveMetaData: function(name, value) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        }
    }
);

// alternate meta data implementation with 'base' namespace prefix 
// instead of 'model' namespace prefix for meta data value
dojo.declare( "com.ibm.mm.enabler.MetaDataImpl2", [com.ibm.mashups.enabler.MetaData, com.ibm.mm.enabler.EffectiveAccessImpl],
    {
        constructor:function () {
            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.mdi_ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_XML]);
            for (prefix in this.serviceJson.namespaces) {
                this.mdi_ns[prefix] = this.serviceJson.namespaces[prefix];
            }
            this.MODEL_METADATA = "atom:content/*/model:metadata";
            this.BASE_VALUE = "base:value";
        },

        // compatibility
        getMetadataNames: function() {
            return this.getMetaDataNames();
        },

        // compatibility
        getMetadata: function(name) {
            return this.getMetaData(name);
        },

        // compatibility
        setMetadata: function(name, value) {
            return this.setMetaData(name, value);
        },
        
        // compatibility
        removeMetadata: function(name) {
            this.removeMetaData(name);
        },

        getMetaDataNames: function() {
            var result = [];
            var expr = this.MODEL_METADATA + "[@name]";
            var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns);
            if (md) {
                for (var i=0; i<md.length; ++i) {
                    result.push(md[i].getAttribute("name"));
                }
            }
            return result;
        },

        getMetaData: function(name, resolveEndpoints) {
            var expr = this.MODEL_METADATA + "[@name='" + name + "']/" + this.BASE_VALUE;
            var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns);
			if (md && md.length > 0) {
				var valh = md[0].getAttribute("value");
				
                if (resolveEndpoints == true) {
                    var valh2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(valh);
                    if (valh2 != null) {
                        valh = valh2;
                    }
                }

				return valh;
			}
			
            return null;
        },
		
        setMetaData: function(name, value) {
            var result = null;
            var expr = this.MODEL_METADATA + "[@name='" + name + "']/" + this.BASE_VALUE;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns );
            if (nodes && nodes.length > 0) {
                // update existing meta data
                nodes[0].setAttribute("value", value);
            } else {
                // create meta data
                var mdBase = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/*", this.xmlData, this.mdi_ns);
                if (mdBase && mdBase.length>0) {
                    var xmlDom = this.xmlData.ownerDocument;
                    var nameNode = com.ibm.mm.enabler.dom.createElement(xmlDom, "model:metadata", this.mdi_ns.model);
                    nameNode.setAttribute("name", name);
                    var valueNode = com.ibm.mm.enabler.dom.createElement(xmlDom, this.BASE_VALUE, this.mdi_ns.base);
                    com.ibm.mm.enabler.utilities.setAttributeWithNS(this.xmlData.ownerDocument,
                        valueNode, "xsi:type", "type", com.ibm.mm.enabler.model.NameSpaceFactory.getNameSpaceUri("xsi"), 
                        "xsd:string");
                    valueNode.setAttribute("value", value);
                    mdBase[0].appendChild(nameNode);
                    nameNode.appendChild(valueNode);
                }
            }
            return result;
        },
        confirmSetMetaData: function(name, value) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
        },

        removeMetaData: function(name) {
            var expr = this.MODEL_METADATA + "[@name='" + name + "']";
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns );
            if (nodes && nodes.length > 0) {
                var parent = nodes[0].parentNode;
                parent.removeChild(nodes[0]);
            }
        },
        confirmRemoveMetaData: function(name) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
        }
    }
);

// alternate meta data implementation with values stored as node text content 
// used by composite apps (spaces). Also parameterized MODEL_METADATA/
// MODEL_METADATA_BASE/NAME_ATTR to be overridden by components for extensibility
dojo.declare( "com.ibm.mm.enabler.MetaDataImpl3", [com.ibm.mashups.enabler.MetaData, com.ibm.mm.enabler.EffectiveAccessImpl],
{
   constructor:function () {
       // service document and initialization
       this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_SPACE);
       var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
       this.mdi_ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_XML, nsf.NS_CA]);
       for (prefix in this.serviceJson.namespaces) {
           this.mdi_ns[prefix] = this.serviceJson.namespaces[prefix];
       }
       this.MODEL_METADATA = "atom:content/ca:application/ca:meta-data";
       this.MODEL_METADATA_BASE = "ca:meta-data";
       this.NAME_ATTR = "ca:name";
   },

   // compatibility
   getMetadataNames: function() {
       return this.getMetaDataNames();
   },

   // compatibility
   getMetadata: function(name) {
       return this.getMetaData(name);
   },

   // compatibility
   setMetadata: function(name, value) {
       return this.setMetaData(name, value);
   },
   
   // compatibility
   removeMetadata: function(name) {
       this.removeMetaData(name);
   },

   getMetaDataNames: function() {
       var result = [];
       var expr = this.MODEL_METADATA + "[@"+this.NAME_ATTR+"]";
       var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns);
       if (md) {
           for (var i=0; i<md.length; ++i) {
               result.push(md[i].getAttribute(this.NAME_ATTR));
           }
       }
       return result;
   },

   getMetaData: function(name) {
       var expr = this.MODEL_METADATA + "[@"+this.NAME_ATTR+"='" + name + "']";
       var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns);
       return (md && md.length > 0) ? com.ibm.mm.enabler.dom.textContent(md[0]) : null;
   },

   setMetaData: function(name, value) {
       var result = null;
       var expr = this.MODEL_METADATA + "[@"+this.NAME_ATTR+"='" + name + "']";
       var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns );
       if (nodes && nodes.length > 0) {
           // update existing meta data
           com.ibm.mm.enabler.dom.textContent(nodes[0], value);
       } else {
           // create meta data
           var mdBase = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/*", this.xmlData, this.mdi_ns);
           if (mdBase && mdBase.length>0) {
               var xmlDom = this.xmlData.ownerDocument;
               var nameNode = com.ibm.mm.enabler.dom.createElement(xmlDom, this.MODEL_METADATA_BASE, this.mdi_ns.ca);
               var pos = this.NAME_ATTR.indexOf(":"); // strip off "id:"
               var localName = this.NAME_ATTR.slice(pos+1);
               com.ibm.mm.enabler.utilities.setAttributeWithNS(xmlDom, nameNode, this.NAME_ATTR, localName, this.mdi_ns.ca, name);
               com.ibm.mm.enabler.dom.textContent(nameNode, value);
               mdBase[0].appendChild(nameNode);
           }
       }
       return result;
   },
    confirmSetMetaData: function(name, value) {
        return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.EDITOR);
    },

   removeMetaData: function(name) {
       var expr = this.MODEL_METADATA + "[@"+this.NAME_ATTR+"='" + name + "']";
       var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.mdi_ns );
       if (nodes && nodes.length > 0) {
           var parent = nodes[0].parentNode;
           parent.removeChild(nodes[0]);
       }
   },
        confirmRemoveMetaData: function(name) {
            return this.hasRole(com.ibm.mashups.enabler.ac.RoleType.MANAGER);
        }
   
}
);


// edit link provider
dojo.declare( "com.ibm.mm.enabler.EditLinkProviderImpl", null,
    {
		constructor: function(node){
			// initializaion
            this.modelMessages = dojo.i18n.getLocalization("com.ibm.mm.enabler", "modelMessages");
			var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
			this.ns_elp = nsf.getNameSpaces([nsf.NS_ATOM]);
			this.ELP_EDIT_LINK = "atom:link[@rel='edit']";
		},

		getEditLink: function(){
			var result = null;
			var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.ELP_EDIT_LINK, this.xmlData, this.ns_elp);
			if (nodes && nodes.length > 0) {
				result = nodes[0].getAttribute("href");
			} else {
				throw new Error(dojo.string.substitute(this.modelMessages.E_ELEMENT_NOT_FOUND_2, [this.ELP_EDIT_LINK, this.toString()]));
			}
			return result;
		}
	}
);

dojo.declare( "com.ibm.mm.enabler.NextLinkProviderImpl", null,
    {
        constructor: function(node){
            // initializaion
            this.modelMessages = dojo.i18n.getLocalization("com.ibm.mm.enabler", "modelMessages");
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.ns_nlp = nsf.getNameSpaces([nsf.NS_ATOM]);
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            for (prefix in this.serviceJson.namespaces) {
                this.ns_nlp[prefix] = this.serviceJson.namespaces[prefix];
            }
            this.NLP_NEXT_LINK = "atom:link[@rel='next']";
        },

        _getNextURI: function(){
            var result = null;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.NLP_NEXT_LINK, this.xmlData, this.ns_nlp);
            if (nodes && nodes.length > 0) {
                result = com.ibm.mm.enabler.utilities.getAttributeWithNS(
                    link,"ext:rel", "rel", this.ns_nlp["ext"]); 
            } else {
                throw new Error(dojo.string.substitute(this.modelMessages.E_ELEMENT_NOT_FOUND_2, [this.NLP_NEXT_LINK, this.toString()]));
            }
            return result;
        }
    }
);

dojo.declare( "com.ibm.mm.enabler.ACLinkProviderImpl", null,
    {
        constructor: function() {
            // service document and initialization
            var serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.ns_acrlp = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_XML, nsf.NS_EXT, nsf.NS_AC, nsf.NS_CA]);
            for (prefix in serviceJson.namespaces) {
                this.ns_acrlp[prefix] = serviceJson.namespaces[prefix];
            }
            this.AC_RESOURCE_ATOM_LINK = "atom:link[@ext:rel='ac-resource-config']";
            this.AC_ROLES_ATOM_LINK = "atom:link[@ext:rel='roles']";
            this.CA_ROLES_ATOM_LINK = "atom:link[@ca:rel='roles']";
            this.AC_MEMBERS_ATOM_LINK = "atom:link[@ac:rel='members']";
        },

        getACResourceLink: function(xmlData) {
            var result = null;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.AC_RESOURCE_ATOM_LINK, xmlData, this.ns_acrlp);
            if (nodes && nodes.length > 0) {
                result = nodes[0].getAttribute("href");
            }
            return result;
        },
        
        getACRolesLink: function(xmlData) {
            var result = null;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.AC_ROLES_ATOM_LINK, xmlData, this.ns_acrlp);
            if (nodes && nodes.length > 0) {
                result = nodes[0].getAttribute("href");
            }
            return result;
        },
        
        getCARolesLink: function(xmlData) {
            var result = null;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.CA_ROLES_ATOM_LINK, xmlData, this.ns_acrlp);
            if (nodes && nodes.length > 0) {
                result = nodes[0].getAttribute("href");
            }
            return result;
        },

        getACMembersLink: function(xmlData) {
            var result = null;
            var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.AC_MEMBERS_ATOM_LINK, xmlData, this.ns_acrlp);
            if (nodes && nodes.length > 0) {
                result = nodes[0].getAttribute("href");
            }
            return result;
        }
    }
);

// representation provider
dojo.declare( "com.ibm.mm.enabler.RepresentationProviderImpl", com.ibm.mashups.enabler.RepresentationProvider,
    {
        constructor:function () {
            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.r_ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_XML]);
            for (prefix in this.serviceJson.namespaces) {
                this.r_ns[prefix] = this.serviceJson.namespaces[prefix];
            }
            this.XPATH = "atom:link";
        },

        getAlternateModel: function() {
            var validLinks = [];
            var md = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(this.XPATH, this.xmlData, this.r_ns);
            if (md && md.length > 0) {
                for (var i = 0; i < md.length; i++) {
                    var link = md[i];
                    var rel = link.getAttribute("rel");
                    var extrel = com.ibm.mm.enabler.utilities.getAttributeWithNS(
                        link,"ext:rel", "rel", this.r_ns["ext"]); 
                    if (extrel=="") extrel = null;
                    if (((rel==null) || (rel=='alternate')) && (extrel==null)) {
                        validLinks[validLinks.length] = link;
                    }
                }
            }
            var model = new com.ibm.mm.enabler.RepresentationModelImpl(validLinks);
            return model;
        }
    }
);

// alternate representation list model
dojo.declare("com.ibm.mm.enabler.RepresentationModelImpl", [com.ibm.mashups.enabler.ListModel, com.ibm.mm.enabler.DeferredIteratorImpl],
    {
        constructor:function (nodes) {
            this.loadedNodes = {};
            this.entries = [];
            this.cursor = 0;
            this.size = null;
            this.start= null;
            this.num = null;
            this.strategy = null;

            // now fill in loadedNodes and entries
            if (nodes && nodes.length > 0) {
                this.size = nodes.length;
                for (var i = 0; i < nodes.length; i++) {
                    var link = nodes[i];
                    var url = link.getAttribute("href");
                    var mimetype = link.getAttribute("type");
                    // create a new representation node
                    var uri = mimetype;
                    var node = new com.ibm.mm.enabler.RepresentationImpl(url, mimetype);
                    // setup the internal objects
                    this.entries[i] = uri;
                    this.loadedNodes[uri] = node;
                }
            }
        },

        find: function (uri) {
            return new com.ibm.mm.enabler.DeferredImpl(this, this._find, uri);
        },

        _find: function (deferred, sync, uri) {
            return this._load(uri, deferred, sync);
        },

        start: function(sync) {
            while (this._hasNext(this, sync)) {
                if (this._next(this, sync)) {
                    continue;
                } else {
                    break;
                }
            }
        },

        hasNext: function () {
            return this._hasNext(null, true);
        },

        _hasNext: function (deferred, sync) {
            if (this.start === null || this.cursor < this.start || (this.cursor >= (this.start + this.num) && (this.size > this.cursor) )) {
                this._loadAhead(deferred, sync);
            }
            return (this.size > this.cursor);
        },

        next: function () {
            return this._next(null, true);
        },

        _next: function (deferred, sync) {
            return this._hasNext(deferred, sync) ? this.loadedNodes[this.entries[this.cursor++]] : null;
        },

        size: function () {
            return this.size;
        },

        setCursorPosition: function (position) {
            this.cursor = position;
        },

        getCursorPosition: function () {
            return this.cursor;
        },

        setStrategy: function (strategy) {
            if (strategy instanceof Array) {
                // evaluate the first strategy only
                this.strategy = strategy[0];
            } else {
                // backwards compatibility
                this.strategy = strategy;
            }
        },

        _load: function(uri, deferred, sync) {
            com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.RepresentationModelImpl._load", uri, sync ? "sync" : "async");
            if (uri in this.loadedNodes) {
                // fetch node from cache
                if (deferred && deferred.finishedCallback2) {
                    deferred.finishedCallback2(this.loadedNodes[uri], com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK, deferred.finishedCallbackParameters2);
                }
            }
            com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.RepresentationModelImpl._load");
            return this.loadedNodes[uri];
        },

        _loadAhead: function(deferred, sync) {
            // noop
        }
    }
);

// representation
dojo.declare( "com.ibm.mm.enabler.RepresentationImpl", com.ibm.mashups.enabler.Representation,
    {
        constructor:function (url, type) {
            this.url = url;
            this.type = type;
        },

        getID: function() {
            return this.type;
        },

        getURL: function() {
            return this.url;
        },

        getMimeType: function() {
            return this.type;
        }
  }
);

// identifier
dojo.declare( "com.ibm.mm.enabler.IdentifierImpl", com.ibm.mashups.enabler.Identifiable,
    {
        constructor:function (id, params) {
            this.id = id;
            this.params = params;
        },

        getID: function() {
            return this.id;
        },

        _getParameters: function() {
            return this.params;
        }
  	}
);

}

if(!dojo._hasResource["com.ibm.mm.enabler.model.shared"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.model.shared"] = true;
dojo.provide("com.ibm.mm.enabler.model.shared");



dojo.declare("com.ibm.mm.enabler.ModelImpl", com.ibm.mashups.enabler.Model, {
    constructor: function(){
        // strategy
        this.strategy = null;
    },
    
    setStrategy: function(strategy){
        if (strategy instanceof Array) {
            this.strategy = strategy;
        } else {
            this.strategy = new Array();
            this.strategy[0] = strategy;
        }
    },
    
    getStrategies: function(){
        return this.strategies;
    },
    
    addStrategy: function(strategy){
        if (null == this.strategy) {
            // null strategy array
            this.strategy = new Array(strategy);
        }
        var index = this.strategy.length;
        this.strategy[index] = strategy;
        return index;
    },
    
    removeStrategy: function(index){
        if (null == this.strategy) {
			// nothing to do
			return;
		} else if ((index) && (index < this.strategy.length) && (index >= 0)) {
			// valid index
			this.strategy[index] = null;
		}
    }
    
});

}

if(!dojo._hasResource["com.ibm.mm.enabler.model.user"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.model.user"] = true;
dojo.provide("com.ibm.mm.enabler.model.user");
dojo.provide("com.ibm.mm.enabler.model.UserModel.iConfig");














// User Model
dojo.declare("com.ibm.mm.enabler.model.UserModelImpl", [com.ibm.mashups.enabler.ListModel, com.ibm.mm.enabler.ModelImpl], {
    constructor: function(){
        this.root = null;
        var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
        this.ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_UM]);
        this.currentUser = null;
        
		var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
        var eps = configService.getValue("ConfigProvider.Endpoints");

	    this.anonUserID = configService.getValue(configService.ANON_VIRTUAL_USER_ID);
		
		if ((typeof this.anonUserID == "undefined") || (this.anonUserID === null)) {
			this.anonUserID = "anonymous portal user";
		}
		
	    this.allAuthID =  configService.getValue(configService.ALL_AUTH_VIRTUAL_GROUP_ID);	
        if ((typeof this.allAuthID == "undefined") || (this.allAuthID === null)) {
			this.allAuthID = "all authenticated portal users";
		}

		this.anonEnabled = false;
		
		var anonMode = configService.getValue(configService.ANON_MODE_ENABLED);
		if (anonMode && ((anonMode == true) || (anonMode == "true") || (anonMode == "on") || (anonMode == "TRUE") || (anonMode == "ON"))) {
			this.anonEnabled = true;
		} 
		
		this.anonUserIDEncoded = encodeURIComponent(this.anonUserID);
		this.allAuthIDEncoded = encodeURIComponent(this.allAuthID);
				
	    this.anonUser = new com.ibm.mm.enabler.user.AnonUserImpl(this.anonUserID, this.anonUserIDEncoded);
	    this.allAuth = new com.ibm.mm.enabler.user.AllAuthGroupImpl(this.allAuthID, this.allAuthIDEncoded);
		
		// user cache
		this.loadedUsers = {};
    },
	
    // singleton
    getInstance: function(){
        var instance = com.ibm.mm.enabler.model.UserModelImpl._instance;
        return instance ? instance : (com.ibm.mm.enabler.model.UserModelImpl._instance = new com.ibm.mm.enabler.model.UserModelImpl());
    },
    
    getAnonymousMode: function(){
        return com.ibm.mm.enabler.AnonymousHelper.getAnonymousMode();
    },
    
    find: function(uri){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._find, uri);
    },
    
    _find: function(dfr, sync, id){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._find", id);
        if (this.currentUser !== null && this.currentUser.getID() == id) {
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.currentUser, com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK, dfr.finishedCallbackParameters2);
            }
            // convenience
            return this.currentUser;
        }
        
		if ((id === this.anonUserID) || (id === this.anonUserIDEncoded)) {
			this.entry = this.anonUser;
			return this.anonUser;
		}
		
		if ((id === this.allAuthID) || (id === this.allAuthIDEncoded)) {
			this.entry = this.allAuth;
			return this.allAuth;
		}

		// check if user is cached
		if (id in this.loadedUsers) {
			this.entry = this.loadedUsers[id];
			return this.entry;
		}
		
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        myUrl.setSchemeSpecificPart("users:profiles:" + encodeURIComponent(id));
        myUrl.setParameter("expandRefs", "true");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        this.entry = null;
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry", data, this.ns);
            if (userXmls && userXmls.length > 0) {
                this.entry = new com.ibm.mm.enabler.user.UserImpl(userXmls[0], this.anonUserID, this.anonUserIDEncoded);
            }
            else {
                // also check for just the atom:entry as this is allowed by the ATOM spec
                userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
                if (userXmls && userXmls.length > 0) {
                    this.entry = new com.ibm.mm.enabler.user.UserImpl(userXmls[0], this.anonUserID, this.anonUserIDEncoded);
                }
            }
			// cache user
			this.loadedUsers[this.entry.getID()] = this.entry; 

            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.entry, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._find");
        // convenience
        return this.entry;
    },
    
    findUsersByAttribute: function(/*String*/attributeName, /*String*/ attributeValue){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._findUsersByAttribute, {
            name: attributeName,
            value: attributeValue
        });
    },
    
    _findUsersByAttribute: function(dfr, sync, attr){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findUsersByAttribute", attributeName, attributeValue);
        var attributeName = attr.name;
        var attributeValue = attr.value;
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        myUrl.setSchemeSpecificPart("users:profiles");
        myUrl.setParameter("expandRefs", "true");
        myUrl.setParameter("searchAttributes", attributeName + "=" + encodeURIComponent(attributeValue));
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        this.entry = null;
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
            var users = [];
            
            for (var i = 0; i < userXmls.length; i++) {
                var user = new com.ibm.mm.enabler.user.UserImpl(userXmls[i], this.anonUserID, this.anonUserIDEncoded);
                users.push(user);
            }
            this.entry = users;
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.entry, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findUsersByAttribute");
        // convenience
        return this.entry;
    },
    
    findGroupByID: function(/*String*/id){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._findGroupByID, id);
    },
    
    _findGroupByID: function(dfr, sync, id){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findGroupByID", id);
        
		if ((id === this.allAuthID) || (id === this.allAuthIDEncoded)) {
			this.entry = this.allAuth;
			return this.allAuth;
		}
		
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        myUrl.setSchemeSpecificPart("groups:profiles:" + encodeURIComponent(id));
        myUrl.setParameter("expandRefs", "true");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        this.entry = null;
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var groupXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry", data, this.ns);
            if (groupXmls && groupXmls.length > 0) {
                var group = new com.ibm.mm.enabler.user.GroupImpl(groupXmls[0], this.allAuthID, this.allAuthIDEncoded);
                this.entry = group;
            }
            else {
                groupXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
                if (groupXmls && groupXmls.length > 0) {
                    var group = new com.ibm.mm.enabler.user.GroupImpl(groupXmls[0], this.allAuthID, this.allAuthIDEncoded);
                    this.entry = group;
                }
            }
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.entry, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findGroupByID");
        // convenience
        return this.entry;
    },
    
    findGroupsByAttribute: function(/*String*/attributeName, /*String*/ attributeValue){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._findGroupsByAttribute, {
            name: attributeName,
            value: attributeValue
        });
    },
    
    _findGroupsByAttribute: function(dfr, sync, attr){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findGroupsByAttribute", attributeName, attributeValue);
        var attributeName = attr.name;
        var attributeValue = attr.value;
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        //myUrl.addParameter("uri", "um:groups:profiles&expandRefs=true&searchAttributes="+attributeName+"="+attributeValue);
        myUrl.setSchemeSpecificPart("groups:profiles");
        myUrl.setParameter("expandRefs", "true");
        myUrl.setParameter("searchAttributes", attributeName + "=" + encodeURIComponent(attributeValue));
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        this.entry = null;
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var groupXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
            
            var groups = [];
                       
            for (var i = 0; i < groupXmls.length; i++) {
                var group = new com.ibm.mm.enabler.user.GroupImpl(groupXmls[i], this.allAuthID, this.allAuthIDEncoded);
                groups.push(group);
            }
            this.entry = groups;
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.entry, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findGroupsByAttribute");
        // convenience
        return this.entry;
    },
    
    findCurrentUser: function(){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._findCurrentUser);
    },
    
    _findCurrentUser: function(dfr, sync){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl._findCurrentUser");
        if (this.currentUser !== null) {
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.currentUser, com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK, dfr.finishedCallbackParameters2);
            }
            // convenience
            return this.currentUser;
        }
        
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        myUrl.setSchemeSpecificPart("currentuser:profile");
        myUrl.setParameter("expandRefs", "true");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry", data, this.ns);
            if (userXmls && userXmls.length > 0) {
                this.currentUser = new com.ibm.mm.enabler.user.CurrentUserImpl(userXmls[0], this.anonUserID, this.anonUserIDEncoded);
                this.entry = userXmls[0];
            }
            else {
                userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
                if (userXmls && userXmls.length > 0) {
                    this.currentUser = new com.ibm.mm.enabler.user.CurrentUserImpl(userXmls[0], this.anonUserID, this.anonUserIDEncoded);
                    this.entry = userXmls[0];
                }
            }
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.currentUser, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl._findCurrentUser");
        // convenience
        return this.currentUser;
    },
    
    findGroupAttributes: function(){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._findGroupAttributes);
    },
    
    _findGroupAttributes: function(dfr, sync){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl.findGroupAttributes");
        
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        myUrl.setSchemeSpecificPart("attributes:groups");
        myUrl.setParameter("expandRefs", "true");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        this.entry = null;
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var attributeXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
            var attributes = [];
            for (var i = 0; i < attributeXmls.length; i++) {
                var attribute = new com.ibm.mm.enabler.user.AttributeImpl(attributeXmls[i]);
                attributes.push(attribute);
            }
            this.entry = attributes;
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.entry, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl.findGroupAttributes");
        // convenience
        return this.entry;
    },
    
    findUserAttributes: function(){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._findUserAttributes);
    },
    
    _findUserAttributes: function(dfr, sync){
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.enabler.model.UserModelImpl.findUserAttributes");
        
        var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
        myUrl.setSchemeSpecificPart("attributes:users");
        myUrl.setParameter("expandRefs", "true");
        
        var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
        this.attEntry = null;
        serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
            var attributeXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
            var attributes = [];
            for (var i = 0; i < attributeXmls.length; i++) {
                var attribute = new com.ibm.mm.enabler.user.AttributeImpl(attributeXmls[i]);
                attributes.push(attribute);
            }
            this.attEntry = attributes;
            if (dfr && dfr.finishedCallback2) {
                dfr.finishedCallback2(this.attEntry, xhr.status, dfr.finishedCallbackParameters2);
            }
        }));
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.model.UserModelImpl.findUserAttributes");
        // convenience
        return this.attEntry;
    },
    
    commit: function(){
        return new com.ibm.mm.enabler.DeferredOperationImpl(this, this._commit);
    },
    
    _commit: function(deferred, sync){
        if (this.currentUser) {
            if (this.currentUser.getAddedAttributeNames() || this.currentUser.getChangedAttributeNames() || this.currentUser.getChangedAttributeNames()) {
                // HTTP PUT updated nodes
                var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.USER_URL, this);
                myUrl.setSchemeSpecificPart("currentuser:profile");
                myUrl.setParameter("expandRefs", "true");
                this.statusCode = com.ibm.mm.enabler.model.HttpStatusCodes.HTTP_OK;
                this.requestCount = 0;
                this._acquire();
                
                var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, true);
                
                serviceReq.update(this.currentUser.toString(), dojo.hitch(this, function(type, data, xhr, args){
                    if (deferred && deferred.operationCallback) {
                        deferred.operationCallback(null, com.ibm.mashups.enabler.DeferredOperation.OPERATION_MODIFY, xhr.status, deferred.operationCallbackParameters);
                    }
                    this._release(deferred, xhr.status);
                    this.currentUser.clearChangedAttributeNames();
                    var userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:entry", data, this.ns);
                    if (userXmls && userXmls.length > 0) {
                        var user = new com.ibm.mm.enabler.user.UserImpl(userXmls[0], this.anonUserID, this.anonUserIDEncoded);
                        this.currentUser = user;
                        this.entry = userXmls[0];
                    }
                    else {
                        userXmls = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
                        if (userXmls && userXmls.length > 0) {
                            var user = new com.ibm.mm.enabler.user.UserImpl(userXmls[0]);
                            this.currentUser = user;
                            this.entry = userXmls[0];
                        }
                    }
					// update cache
					if (user.getID() in this.loadedUsers) {
						this.loadedUsers[user.getID()] = user;
					}
                }));
            }
        }
    },
    
    // acquire semaphore
    _acquire: function(){
        this.requestCount++;
    },
    
    // release semaphore
    _release: function(deferred, statusCode){
        // set overall status Code
        this.statusCode = Math.max(parseInt(statusCode, 10), this.statusCode);
        // check for full release
        this.requestCount--;
        if (this.requestCount <= 0) {
            if (deferred && deferred.finishedCallback2) {
                deferred.finishedCallback2(null, this.statusCode, deferred.finishedCallbackParameters2);
            }
        }
    },
	
	getVirtualUsers: function(){
        return new com.ibm.mm.enabler.DeferredImpl(this, this._getVirtualUsers);
    },
    
    _getVirtualUsers: function(dfr, sync){
        var users = [];
		if (this.anonEnabled) {
			users.push(this.anonUser);
		}
        return users;
    },
    
	getVirtualGroups: function(){
		return new com.ibm.mm.enabler.DeferredImpl(this, this._getVirtualGroups);
	},
		
   _getVirtualGroups: function(dfr, sync){
        var groups = [];
        groups.push(this.allAuth);
        return groups;
    },
	
	getLookasideAttributeNames: function(){
		return new com.ibm.mm.enabler.DeferredImpl(this, this._getLookasideAttributeNames);
	},
	
	_getLookasideAttributeNames: function(dfr, sync){
		if ((typeof this.lookasideAttributes == "undefined") || (this.lookasideAttributes == null)) {
			 this.lookasideAttributes = [];
		     var attributes = this.findUserAttributes().start();
			 for (i = 0; i < attributes.length; i++) {
			 	var attName = attributes[i].getName();
				if (attName.indexOf("com.ibm.mashups.user.") == 0) {
					this.lookasideAttributes.push(attName);
				}
			 }
		}
		
		return this.lookasideAttributes;
	}
});


// Entity
dojo.declare("com.ibm.mm.enabler.user.EntityImpl", [com.ibm.mm.enabler.IdentifiableImpl], { // UserImpl and GroupImpl provide their own getLoginName(), getCN(), and getID()
});


// User
dojo.declare("com.ibm.mm.enabler.user.UserImpl", [com.ibm.mm.enabler.user.EntityImpl], {
    constructor: function(data, anonUserID, anonUserIDEncoded){
		this.anonUserID = anonUserID;
		this.anonUserIDEncoded = anonUserIDEncoded;
        var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
        this.ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_UM]);
        this.xmlData = data;
        this.changedAttributes = {};
        this.addedAttributes = {};
        this.removedAttributes = {};
    },
    
    getAttribute: function(attName){
        if (typeof attName == "undefined" || attName === null) {
            return null;
        }
        
        if (this.removedAttributes[attName]) {
            return null;
        }
        else 
            if (this.changedAttributes[attName]) {
                return this.changedAttributes[attName];
            }
            else 
                if (this.addedAttributes[attName]) {
                    return this.addedAttributes[attName];
                }
        
        
        var expr = "atom:content/um:profile/um:attribute[@name='" + attName + "']/um:attributeValue";
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
        if (xmlResult.length === 0) {
            return null;
        }
        var attValue = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return attValue;
    },
    
    getAttributeNames: function(){
        if (typeof this.attNames != "undefined" && this.lookasideAttNames !== null) {
            return this.attNames;
        }
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute", this.xmlData, this.ns);
        if (xmlResult.length === 0) {
            return null;
        }
        this.attNames = [];
        for (var i = 0; i < xmlResult.length; i++) {
            var aNode = xmlResult[i];
            var aName = aNode.getAttribute("name");
            if (typeof aName != "undefined" && aName !== null && aName !== "") {
				if (aName.indexOf() == 0) {
					this.attNames.push(aName);
				}
            }
        }
        return this.attNames;
    },
	
	    
    getID: function(){
        var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:id", this.xmlData, this.ns);
        if ((nodes === null) || (nodes.length === 0)) {
            return null;
        }
        
        var fullID = com.ibm.mm.enabler.dom.textContent(nodes[0]);
        if ((fullID === null) || (fullID.length === 0)) {
            return null;
        }
        // strip off extra details
        var pos = fullID.indexOf("profiles/");
        if (pos == -1) {
            pos = fullID.indexOf("profiles:");
        }
        var id = fullID.slice(pos + "profiles:".length);
        
        return decodeURIComponent(id);
    },
    
    getLoginName: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='principalName']/um:attributeValue", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            return null;
        }
        var principalName = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return principalName;
        
    },
    
    getSN: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='sn']/um:attributeValue", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            return null;
        }
        var sn = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return sn;
    },
    
    getCN: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='cn']/um:attributeValue", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            return null;
        }
        var cn = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return cn;
    },
    
    // TODO: add email to feed
    getEmail: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='email']/um:attributeValue", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='mail']/um:attributeValue", this.xmlData, this.ns);
            if ((xmlResult === null) || (xmlResult.length === 0)) {
                return null;
            }
        }
        var email = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return email;
    },
    
    getDisplayName: function(){
        if ((this.getID() == this.anonUserID) || (this.getID() == this.anonUserIDEncoded)) {
            this.iwStr = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwStr");
            return this.iwStr.ANON;
        }
        
        var displayName = null;
        
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='displayName']/um:attributeValue", this.xmlData, this.ns);
        
        if ((xmlResult != null) && (xmlResult.length > 0)) {
            displayName = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        }
        
        if ((typeof displayName == "undefined") || (displayName == null)) {
            var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
            var displayNameProp = configService.getValue(configService.DEFAULT_USER_DISPLAY_PROP);
            if ((typeof displayNameProp != "undefined") && (displayNameProp != null)) {
                displayName = this.getAttribute(displayNameProp);
            }
        }
        
        if ((typeof displayName == "undefined") || (displayName == null)) {
            displayName = this.getLoginName();
        }
        
        return displayName;
    },
    
    getEntityType: function(){
        return "user";
    },
    
    setAttribute: function(name, value){
        var result = null;
        var expr = "atom:content/*/um:attribute" + "[@name='" + name + "']/" + "um:attributeValue";
        var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
        if (nodes && nodes.length > 0) {
            // update existing meta data
            com.ibm.mm.enabler.dom.textContent(nodes[0], value);
            this.changedAttributes[name] = value;
            this.removedAttributes[name] = null;
        }
        else {
            // create meta data
            var mdBase = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile", this.xmlData, this.ns);
            if (mdBase && mdBase.length > 0) {
                var xmlDom = this.xmlData.ownerDocument;
                var nameNode = com.ibm.mm.enabler.dom.createElement(xmlDom, "um:attribute", this.ns.um);
                nameNode.setAttribute("name", name);
                nameNode.setAttribute("type", "xs:string");
                nameNode.setAttribute("multiValued", "false");
                var valueNode = com.ibm.mm.enabler.dom.createElement(xmlDom, "um:attributeValue", this.ns.um);
                com.ibm.mm.enabler.dom.textContent(valueNode, value);
                nameNode.appendChild(valueNode);
                mdBase[0].appendChild(nameNode);
                this.changedAttributes[name] = null;
                this.addedAttributes[name] = value;
                this.removedAttributes[name] = null;
            }
        }
        return result;
    },
    
    removeAttribute: function(name){
        var expr = "atom:content/*/um:attribute" + "[@name='" + name + "']";
        var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
        if (nodes && nodes.length > 0) {
            var parent = nodes[0].parentNode;
            parent.removeChild(nodes[0]);
            this.changedAttributes[name] = null;
            this.addedAttributes[name] = null;
            this.removedAttributes[name] = "";
            return new String();
        }
    },
    
    getChangedAttributeNames: function(){
        return this.changedAttributes;
    },
    
    getAddedAttributeNames: function(){
        return this.addedAttributes;
    },
    
    getRemovedAttributeNames: function(){
        return this.removedAttributes;
    },
    
    clearChangedAttributeNames: function(){
        this.changedAttributes = {};
        this.addedAttributes = {};
        this.removedAttributes = {};
    },

    toString: function() {
         return com.ibm.mm.enabler.dom.innerXML(this.xmlData);
    }

});

// Current User
dojo.declare("com.ibm.mm.enabler.user.CurrentUserImpl", [com.ibm.mashups.enabler.user.CurrentUser, com.ibm.mm.enabler.user.UserImpl], {
    constructor: function(){
    },
    
    getJ2EEPrincipalName: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='j2ee_principialname']/um:attributeValue", this.xmlData, this.ns);
        if (xmlResult != null && xmlResult.length > 0) {
            // return j2ee principal name
            return com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        }
        else {
            // fall back to principal name
            return this.getLoginName();
        }
    }
});

// Group
dojo.declare("com.ibm.mm.enabler.user.GroupImpl", [com.ibm.mm.enabler.user.EntityImpl], {
    constructor: function(data, allAuthID, allAuthIDEncoded){
		this.allAuthID = allAuthID;
		this.allAuthIDEncoded = allAuthIDEncoded;
        var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
        this.ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_UM]);
        this.xmlData = data;
    },
    
    getID: function(){
        var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:id", this.xmlData, this.ns);
        if ((nodes === null) || (nodes.length === 0)) {
            return null;
        }
        
        var fullID = com.ibm.mm.enabler.dom.textContent(nodes[0]);
        if ((fullID === null) || (fullID.length === 0)) {
            return null;
        }
        
        if (com.ibm.mm.enabler.model.UserModel.iConfig.getID) {
            return com.ibm.mm.enabler.model.UserModel.iConfig.getID(fullID);
        }
        // strip off extra details
        var pos = fullID.indexOf("profiles/");
        if (pos == -1) {
            pos = fullID.indexOf("profiles:");
        }
        var id = fullID.slice(pos + "profiles:".length);
        return  decodeURIComponent(id);
    },
    
    getCN: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='cn']/um:attributeValue", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            return null;
        }
        var cn = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return cn;
    },
    
    getDisplayName: function(){
        if ((this.getID() == this.allAuthID) || (this.getID() == this.allAuthIDEncoded)) {
            this.iwStr = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwStr");
            return this.iwStr.ALL_AUTH;
        }
        
        var displayName = null;
        
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:profile/um:attribute[@name='displayName']/um:attributeValue", this.xmlData, this.ns);
        
        if ((xmlResult != null) && (xmlResult.length > 0)) {
            displayName = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        }
        
        if ((typeof displayName == "undefined") || (displayName == null)) {
            var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
            var displayNameProp = configService.getValue(configService.DEFAULT_GROUP_DISPLAY_PROP);
            if ((typeof displayNameProp != "undefined") && (displayNameProp != null)) {
                displayName = this.getAttribute(displayNameProp);
            }
        }
        
        if ((typeof displayName == "undefined") || (displayName == null)) {
            displayName = this.getCN();
        }
        
        return displayName;
    },
    
    getEntityType: function(){
        return "group";
    },
    
    getAttribute: function(attName){
        var expr = "atom:content/um:profile/um:attribute[@name='" + attName + "']/um:attributeValue";
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, this.xmlData, this.ns);
        if (xmlResult.length === 0) {
            return null;
        }
        var attValue = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return attValue;
    }
});

// Attribute
dojo.declare("com.ibm.mm.enabler.user.AttributeImpl", null, {
    constructor: function(data){
        var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
        this.ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_UM]);
        this.xmlData = data;
    },
    
    getName: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:title", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            return null;
        }
        
        var name = com.ibm.mm.enabler.dom.textContent(xmlResult[0]);
        return name;
    },
    
    getType: function(){
        var xmlResult = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:content/um:attribute", this.xmlData, this.ns);
        if ((xmlResult === null) || (xmlResult.length === 0)) {
            return null;
        }
        return xmlResult[0].getAttribute("type");
    }
});

dojo.declare("com.ibm.mm.enabler.user.AllAuthGroupImpl", [com.ibm.mm.enabler.user.EntityImpl], {
    constructor: function(allAuthID, allAuthIDEncoded){
		this.allAuthID = allAuthID;
		this.allAuthIDEncoded = allAuthIDEncoded;
    },
    
    getID: function(){
        return this.allAuthID;
    },
    
    getCN: function(){
        return "all authenticated portal users";
    },
    
    getDisplayName: function(){
        this.iwStr = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwStr");
        return this.iwStr.ALL_AUTH;
    },
    
    getEntityType: function(){
        return "group";
    },
    
    getAttribute: function(attName){
        return null;
    }
});

// User
dojo.declare("com.ibm.mm.enabler.user.AnonUserImpl", [com.ibm.mm.enabler.user.EntityImpl], {
    constructor: function(anonUserID, anonUserIDEncoded){
		this.anonUserID = anonUserID;
		this.anonUserIDEncoded = anonUserIDEncoded;
    },
    
    getAttribute: function(attName){
        return null;
    },
    
    getAttributeNames: function(){
        return [];
    },
    
    getID: function(){
        return this.anonUserID;
    },
    
    getLoginName: function(){
        return "anonymous portal user";
    },
    
    getSN: function(){
        return "anonymous portal user";
    },
    
    getCN: function(){
        return "anonymous portal user";
    },
    
    // TODO: add email to feed
    getEmail: function(){
        return null;
    },
    
    getDisplayName: function(){
        this.iwStr = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwStr");
        return this.iwStr.ANON;
    },
    
    getEntityType: function(){
        return "user";
    },
    
    setAttribute: function(name, value){
        return null;
    },
    
    removeAttribute: function(name){
        return null;
    },
    
    getChangedAttributeNames: function(){
        return {};
    },
    
    getAddedAttributeNames: function(){
        return {};
    },
    
    getRemovedAttributeNames: function(){
        return {};
    },
    
    clearChangedAttributeNames: function(){
    }
});

}

if(!dojo._hasResource["com.ibm.mm.enabler.model.factory"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.model.factory"] = true;
dojo.provide( "com.ibm.mm.enabler.model.factory" );
//dojo.require( "com.ibm.mm.enabler.model" );

// public factory
dojo.declare( "com.ibm.mm.enabler.model.FactoryImpl", null,
    {
        constructor:function () {
        },

        getCatalogCategoryModel: function() {
            return new com.ibm.mm.enabler.model.CatalogCategoryModelImpl();
        },

        getNavigationModel: function() {
            return com.ibm.mm.enabler.model.NavigationModelImpl.prototype.getInstance();
        },

        getSharedNavigationModel: function() {
            return com.ibm.mm.enabler.model.SharedNavigationModelImpl.prototype.getInstance();
        },
        
        getThemeModel: function() {
            return com.ibm.mm.enabler.model.ThemeModelImpl.prototype.getInstance();
        },

//        getPreferenceModel: function(user) {
//            return new com.ibm.mm.enabler.model.PreferenceModelImpl(user);
//        },

        getUserModel: function() {
            return com.ibm.mm.enabler.model.UserModelImpl.prototype.getInstance();
        },
	
		getRemoteModel: function() {
	        return new com.ibm.mm.enabler.model.RemoteModelImpl();   
	    },
    	
		getSpaceModel: function() {
	        return new com.ibm.mm.enabler.model.SpaceModelImpl();   
	    },
    	
		getTemplateModel: function() {
            return new com.ibm.mm.enabler.model.TemplateModelImpl();
	    },
		
		getSpaceExtensionModel: function() {
        	return new com.ibm.mm.enabler.model.SpaceExtensionModelImpl();
    	}
		
    }
);

// public factory
com.ibm.mashups.enabler.model.Factory = new com.ibm.mm.enabler.model.FactoryImpl();

}

if(!dojo._hasResource["com.ibm.mm.iwidget.iContextImpl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.iContextImpl"] = true;
dojo.provide("com.ibm.mm.iwidget.iContextImpl");

dojo.provide("com.ibm.mm.iwidget.iEventsImpl");
dojo.provide("com.ibm.mm.iwidget.io");



dojo.require( "com.ibm.mm.enabler.utilities" );





//support userprofile

dojo.require( "com.ibm.mm.enabler.model.factory" );

dojo.declare("com.ibm.mm.iwidget.iContextImpl", com.ibm.mashups.iwidget.iContext, {

    constructor:function (wrapper) {
    //information accessible from iwidget 
		this.widgetwrapper = wrapper;
        this.widgetId =wrapper.id; 
        this.scope =  {};
        this.iEvents = new com.ibm.mm.iwidget.iEventsImpl(this.widgetwrapper);
        this.io = new com.ibm.mm.iwidget.io(this.widgetwrapper);

        //todo: root is associated with mode
        //this.rootElement = wrapper.rootElement;
		//keep this.rootElement and this.ns since this will break some widget code
		this.rootElement = dojo.byId(this.widgetId);
        this.ns = this.rootElement.className.substr(0,3);  
        this._mm = new com.ibm.mm.iwidget.iContextImpl.mmExtension(this.widgetwrapper);  
    },
    getRootElement:function(){
        //summary: returns the root element of the iWidget such that iWidget can easily do things such as
        // searching its own markup. RootElement can also be a convenient place to place items which iWidget wishes
        // to access later.
		//we generate it dynamically so it can work for sandboxed iwidget 
        return dojo.byId(this.widgetId);
    },
    getElementById: function(/*String*/id,root){
 
         //summary: this method provides the same semantics as the DOM method by the same name with the distinction that
         //  this method will restrict the search to the iWidget's markup rather than entire page
         if (!root) {
             root = this._getContentRoot();
         }
		 
		 //following dojo.query will query by id however it doesn't work, so use our legacy stuff instead
		 /*
		 var nodeList = dojo.query("#"+id,root);
		 if (nodeList.length >= 1){
		 	return nodeList[0];
		 }
		 return null;
		 */
		 
         var element=[];
         var rc = com.ibm.mm.iwidget.utils.findElementByAttribute("id",id,root,element,false);
      
         if (rc) {
             return element[0];
         }
         else
             return null;
    },
    getiWidgetAttributes: function(){
        //Summary: returns an ManagedItemSet which provides access to the iWidget's customization attributes. 
        //          The returned ManagedItemSet will be the same as getItemSet(iContext.constants.itemset.ATTRIBUTES).
        //          returns empty set if there's no ItemSet.
        var attrs = this.widgetwrapper.getAttributes();
        return attrs;
    },  
     getItemSet:function(/*String*/ name){
        com.ibm.mm.enabler.debug.entry("iContext.getItemSet","name:"+name);
        if (typeof name == "undefined" || name == null) return null;
        if (name == iwConstants.ATTRIBUTES) return this.getiWidgetAttributes();
        if (name == iwConstants.USERPROFILE) return this.getUserProfile();
        if (name == iwConstants.IDESCRIPTOR) return this.getiDescriptor(); 
         

       
        var itemSet = this.widgetwrapper.getWidgetItemSet(name);
        if (typeof itemSet == 'undefined' || itemSet == null) {
            itemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl();
        }
        com.ibm.mm.enabler.debug.exit("iContext.getItemSet","object:"+itemSet);

        return itemSet;
    },
    requires: function(/*String*/ requiredItem,/*String*/version,/*String*/uri,/*function*/cb,mimeType){
         //Summery: provides means for iWidget to declare dependency on set of non-required items:
         //         "io"...
         //         no uri should be specified for above
         // shared resources can be loaded just once for all iwidgets like dojo.js
         // version support?
         // support dynamic loads in asynchronous manner
         if (typeof mimeType == "undefined" || mimeType == null){
             mimeType = "text/plain";
         }
         if (typeof uri != "undefined" && uri != null){
               com.ibm.mashups.services.ServiceManager.getService("resourceLoadService").loadResource(this.widgetId,requiredItem,uri,cb,mimeType);
         } 
    },
    iScope:function(){
          return this.scope;
    },
    processMarkup:function(/*string*/markup){
         //return null upon failure
         var oldMarkup = markup.replace(/_IWID_/g,"_"+this.widgetId+"_");
         var finalMarkup = oldMarkup.replace(/iContext(?=\.|\s|\(|\))/g,"_"+this.widgetId+"_iContext");
        return finalMarkup;  
    },
    processiWidgets:function(/*domnode*/root){
         dojo.publish("/com/ibm/mashups/livetext/livetextchanged",[root,true]);
    },
    getElementByClass:function(classname,root){
         if (!root) {
            root = this._getContentRoot();
        }

        //todo: use dojo.query
		var nodeList = dojo.query("."+classname,root);
		if  (typeof nodeList != "undefined" && nodeList !== null) {
             if (nodeList.length == 0){
			 	return null;
			 }
			 else{
			 	var elements = [];
				for ( var i=0;i<nodeList.length;i++){
					elements.push(nodeList[i]);
				}
				return elements;
			 }
        }
		return null;
		/*
        var element=[];
        var rc = com.ibm.mm.iwidget.utils.findElementByAttribute("class",classname,root,element,true);
        com.ibm.mm.enabler.debug.log("iContext.getElementByClass", "found:"+rc);

        if (rc) {
            return element;
        }
        else
            return null;  
        */ 
    },
    getWidgetXMLPath: function(){         
	     var url = this.widgetwrapper.getIWidgetInstance().widgetXMLUrl;
		 var queryStart = url.indexOf("?");
         if (0 < queryStart) {
             url = url.substring(0, queryStart);
         }

		 var url2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(url);
		 if (url2 != null) {
		 	url = url2;
		 }
		 
         return url;
    },    
    _getWidgetBaseUri: function(){
         
         var widgetBaseUri = this.widgetwrapper.getIWidgetInstance().widgetXMLUrl;
         var queryStart = widgetBaseUri.indexOf("?");
         if (0 < queryStart) {
             widgetBaseUri = widgetBaseUri.substring(0, queryStart);
         }

         return widgetBaseUri.substring(0,widgetBaseUri.lastIndexOf("/")+1);
    },   
    _getContentRoot:function(){
      
		 var contentRoot =  this.getRootElement();
         var currentMode = this.widgetwrapper.currentMode;   
	     if (!currentMode) {
             currentMode = "view";
         } 
         var currentWindow = this.widgetwrapper.windowManager[currentMode];
         if (typeof currentWindow != "undefined" && currentWindow != null) {
             var temp = currentWindow.root;
             if (typeof temp != "undefined" && temp != null) contentRoot = temp;
         }
		
         return contentRoot;
    },	
    getUserProfile:function(){
         var userModel = com.ibm.mashups.enabler.model.Factory.getUserModel();
         var user = userModel.findCurrentUser().start();
         var userProfile = null;
         if (typeof user != "undefined" && user != null) {
            userProfile = new com.ibm.mm.iwidget.itemset.UserProfile(this.widgetId,user);
         }                                                             
         return userProfile;
    },
    getiDescriptor:function(){
        //var widget = iWidgetContainer.getWidgetById(this.widgetId);
        var iDescriptor= this.widgetwrapper.getIDescriptorItems();
        return iDescriptor;
    }
});    

dojo.declare("com.ibm.mm.iwidget.iContextImpl.mmExtension", null, {

    constructor:function (wrapper) {
    //information accessible from iwidget 
		this.widget = wrapper;
        this.widgetId =wrapper.id; 
    },
    getSupportedModes:function(){
          //var widget = iWidgetContainer.getWidgetById(this.widgetId);
          var supportedModes = this.widgetwrapper.widgetDef.getSupportedModes();
          return supportedModes;            
    },
    getPayloadDef:function(name){
        
        var payloadDefs = this.widget.widgetDef.payloadDefs;    
        var payloadDef = payloadDefs[name];
        if (typeof payloadDef == "undefined") return null;
        return payloadDef;          
    },
    getPayloadDefNames:function(){
           var payloadDefs = this.widget.widgetDef.payloadDefs;                       
         var arr = [];
         var a;
         for (a in payloadDefs){
                      arr.push(a);                      
         }
         return arr;
    }
});




dojo.declare("com.ibm.mm.iwidget.io",com.ibm.mashups.iwidget.io,
{
	constructor:function (wrapper) {
        this.id = wrapper.id;
        var widget = wrapper;
        var rawUri = widget.getIWidgetInstance().widgetXMLUrl;

        var queryStart = rawUri.indexOf("?");
        if (0 < queryStart) {
            rawUri = rawUri.substring(0, queryStart);
        }
		
		var uri2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(rawUri);
		if (uri2 != null) {
			rawUri = uri2;
		}
		
        this.widgetBaseUri = rawUri.substring(0,rawUri.lastIndexOf("/")+1);
		
		this.widgetBaseUriXhr = this.widgetBaseUri;
		if (this.widgetBaseUri.indexOf("/") != 0)
		this.widgetBaseUriXhr = com.ibm.mm.enabler.utilities.rewriteURL(this.widgetBaseUri);

        if ( this.widgetBaseUri.indexOf("://") != -1) {
            var indexOfScheme = this.widgetBaseUri.indexOf("://");
            var indexOfRoot = this.widgetBaseUri.indexOf("/",indexOfScheme+3);
            this.serverRoot = this.widgetBaseUri.substring(0, indexOfRoot);
            this.serverRootXhr = com.ibm.mm.enabler.utilities.rewriteURL(this.serverRoot);
            // strip the trailing slash
            this.serverRootXhr = this.serverRootXhr.substring(0, this.serverRootXhr.length-1);
        }
    },
    rewriteURI:function(/*String*/uri,isXhr){ 
        com.ibm.mm.enabler.debug.entry("com.ibm.mm.iwidget.io.rewriteURI",uri+" isXhr:"+isXhr);

		
        if (typeof isXhr == "undefined") {
            isXhr = true;
        }
		
		var uri2 = com.ibm.mm.enabler.model.Utils.checkForEndpoints(uri);
		if (uri2 != null) {
			uri = uri2;
		}
		
        var returnUri = uri;
		
        if (isXhr) {
            if (uri.indexOf("://")!= -1 ) {
                returnUri =  com.ibm.mm.enabler.utilities.rewriteURL(uri);
            } else if (uri.indexOf(this.serverRootXhr) == 0) {
                // seems the uri is already rewritten, so reuse it
                returnUri = uri; 
            } else {
                var pathQuery = uri.split("?"); // split the query
                var encPath = com.ibm.mm.enabler.utilities.encodePath(pathQuery[0]);
                if (uri.indexOf("/") == 0 ) {
                    returnUri =  ((typeof (this.serverRootXhr) != "undefined") ? this.serverRootXhr : "") + encPath;
                } else {
                    returnUri = ((typeof (this.widgetBaseUriXhr) != "undefined") ? this.widgetBaseUriXhr : "") + encPath;
                }
                 
                if (pathQuery.length == 2)
                    returnUri += "?" + pathQuery[1]
             }   
        } else {
            if (uri.indexOf("://") == -1 ) {
                var pathQuery = uri.split("?"); // split the query
                var encPath = com.ibm.mm.enabler.utilities.encodePath(pathQuery[0]);
                if (uri.indexOf("/") == 0 ) {
                    if (typeof (this.serverRootXhr) != "undefined")
                        returnUri =  this.serverRoot+encPath;
                } else {
                    if ( typeof (this.widgetBaseUri) != "undefined" ) 
                        returnUri =  this.widgetBaseUri + encPath;
                }

                if (pathQuery.length == 2)
                    returnUri += "?" + pathQuery[1]
            }
        }
         
        com.ibm.mm.enabler.debug.exit("com.ibm.mm.iwidget.io.rewriteURI",returnUri);

        return returnUri;
    },
	getWebAppRootPath:function() {
		var returnUri="/";
		if ( typeof (this.widgetBaseUri) != "undefined" ) {
			returnUri = this.widgetBaseUri;
			if (returnUri.length > 0) {
				if (returnUri.indexOf("://") > 0) {
					var parts = returnUri.split("/");
					if (parts.length >= 4) {
						returnUri = parts[0] + "//" + parts[2] + "/" + parts[3] + "/";
					}
					else {
						returnUri = "/";
					}
				}
			}
		}	
		return returnUri;
	},			
	request:function(requestVerb,uri,callbackFn,message,/* [{headerName, value}] */requestHeader){
         //Sends an HTTP request with the given method
         //The method argument should be uppercase.
		 //sample callback Fn
		 /*function callbackFunction(){
			if (this.readyState != 4) return;
			var response = this.responseText;
			}			
		 */
		 var xhr = dojo._xhrObj();   
         var realUri = this.rewriteURI(uri);

         var async = false;
         if(callbackFn) 
         {    xhr.onreadystatechange = callbackFn;
              //sets it to asynchronous only if a callbackFn is provided, per xhr spec, user agent should consider default is true if it's omitted
              async = true;
         }
         var method = requestVerb;
         if (typeof requestVerb == "undefined" || requestVerb == null ) method=this.httpmethods.GET;
         if (typeof requestVerb != "undefined" && requestVerb != null) {
             if (!this.httpmethods[requestVerb]) {
                 method = this.httpmethods.GET;
             }
         }
		 
		            //user/password    xhr.open(method,realUri,async,user,pwd); 
         xhr.open(method,realUri,async);
             //xhr.send(); 
         console.debug(method+" "+realUri);

         var _defaultContentType = "application/x-www-form-urlencoded";  
         if (requestHeader) {
             //Authors are strongly encouraged to ensure that they have specified the Content-Type header via setRequestHeader() before invoking send() with a non-null data argument.
             for (var i=0; i<requestHeader.length;i++) {
                 var anItem = requestHeader[i];
                 var headerName = anItem[headerName];
                 var value = anItem[value];
                 if (headerName == "Content-Type") {
                     var contentType = value;
                 }
                 else{
                     xhr.setRequestHeader(headerName,value);
                 }    
             }
         }
         xhr.setRequestHeader("Content-Type", (contentType||_defaultContentType));

         //user/password    xhr.open(method,realUri,async,user,pwd); 
         if (method == this.httpmethods.PUT || method==this.httpmethods.POST) {
             if (message) {
                  xhr.send(message);
             }
         }else{
              xhr.send(null); 
         }
         return xhr;         
    },	
    httpmethods:{
        GET:"GET",
        PUT:"PUT",
        POST:"POST",
        DELETE:"DELETE",
        HEAD:"HEAD",
        OPTIONS:"OPTIONS"
    }
});


dojo.declare("com.ibm.mm.iwidget.iEventsImpl",com.ibm.mashups.iwidget.iEvents,
{

    constructor:function(wrapper){
		this.widget = wrapper;
        this.id = wrapper.id;
		this.svc = com.ibm.mashups.services.ServiceManager.getService("eventService");
    },
	createEventDescription:function(/*json*/object){ 
		return new com.ibm.mm.iwidget.iEventDescriptionImpl(object);
	},
	getEvents:function(condition){
	 //always return a data copy of each iEventDescription
	 //return null if no events is found		
		var eventModel = this.widget._getPublicEvents(); //get the internal eventModel
		var events = eventModel.getEvents(condition);
		//now build a copy of iEventDescription
		if (events == null ) return null;
		var arr = [];
		for (var i in events){
			arr.push(events[i].clone());
		}
		return arr; 
	},
	setEvent:function(eventDesc){
	//create/update event
	//return true if event is successful
		
		var eventModel = this.widget._getPublicEvents(); //get the internal eventModel
		var rc  = eventModel.eventExists(eventDesc.name);
		if (rc) {
			if (this.widget._inIframe()) {
			this.svc._publishEvent(this.svc.WIDGETEVENT_PREFIX +"_stub_"+this.id, {
				"scope": "eventmodel",
				"methodname": "updateEvent",
				"params": [eventDesc.toJson()]
			}, this.id);
			}	
			rc = eventModel.updateEvent(eventDesc);
			}
		else{
			if (this.widget._inIframe()) {
				this.svc._publishEvent(this.svc.WIDGETEVENT_PREFIX +"_stub_"+this.id, {
				"scope": "eventmodel",
				"methodname": "createEvent",
				"params": [eventDesc.toJson()] //turn iEventDescription into an json object 
				}, this.id);
			}	
			rc = eventModel.createEvent(eventDesc);
		}
		return rc;	
	}, 
   	removeEvent:function(eventName){
		//remove event
		//return true upon successful, if event doesn't exist or for other reason event can't be deleted, return false;
		if (this.widget._inIframe()) {
			this.svc._publishEvent(this.svc.WIDGETEVENT_PREFIX + "_stub_"+this.id, {
				"scope": "eventmodel",
				"methodname": "removeEvent",
				"params": [eventName]
			}, this.id);
		}	
		var eventModel = this.widget._getPublicEvents(); //get the internal eventModel
		var rc  = eventModel.removeEvent(eventName);
		return rc;	
	},
    publishEvent:function(/*String*/eventName,payload,payloadType){
		//internal, deprecated, todo remove
        return this.fireEvent(eventName,payloadType,payload); 
    },
    fireEvent:function(/*String*/eventName,payloadType,payload){
      //event description here...
      var aEvent = new com.ibm.mm.iwidget.iEventImpl(eventName,payloadType,payload,null);  
	  var eventModel = this.widget._getPublicEvents();
      //var isHandled = widgetWrapper.handleEvent(eventName,aEvent);
	  //handle internally only if it's not a handled event
	  var isHandledEvent = false;
	  if (eventModel != null){
		var temp = eventModel.find(eventName);
		if (temp != null && temp.handlingFn && temp.handlingFn != null){
			isHandledEvent = true;
		}
	  }	 
	  if( isHandledEvent == false) this.widget.handleEvent(aEvent);

      //publish wire if it's a published event      
	  if (eventModel != null){
	  	var temp = eventModel.find(eventName);
		if (temp != null && (temp.isPublished == "true" || temp.isPublished == true)){
	     this.svc.publishWire(this.id,eventName,payload,payloadType);   
		}
	  }  
    }
  
});

















}

if(!dojo._hasResource["com.ibm.mm.iwidget.widget.wire"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widget.wire"] = true;
dojo.provide("com.ibm.mm.iwidget.widget.wire");


dojo.declare("com.ibm.mm.iwidget.widget.WireImpl",[com.ibm.mashups.iwidget.widget.Wire, com.ibm.mashups.enabler.Identifiable],{

		constructor:function(widgetid,/*JSON object*/obj){
			//"SourceWidget","SourceEvent","TargetEvent"
			if(obj){
			this.SourceWidget = obj.SourceWidget;
			this.SourceEvent = obj.SourceEvent;
			this.TargetEvent = obj.TargetEvent;
			}
			this.TargetWidget = widgetid;
			this._isDirty = false;
			this._type = null;
		},
		TYPE_NEW:"NEW",
		TYPE_DELETE:"DELETE",	
		getID:function() {
			return this.SourceWidget +"_"+ this.SourceEvent +"_"+ this.TargetWidget+"_"+this.TargetEvent;
		},
		getSourceWidgetID:function(){
			return this.SourceWidget;
		},
		getSourceEventName:function(){
			return this.SourceEvent;	
		},
		getTargetWidgetID:function(){
			return this.TargetWidget;
		},
		getTargetEventName:function(){
			return this.TargetEvent;	
		},
		setDirty:function(isDirty){
			this._isDirty = isDirty;
		},
		isDirty:function(){
			return this._isDirty;
		},
		setType:function(type){
			this._type = type;			
		},
		getType:function(){
			return this._type;
		},
		setSubHandler:function(subHandle){
			this._subHandle = subHandle;			
		},
		getSubHandler:function(){
			return this._subHandle;
		}	
});

dojo.declare("com.ibm.mm.iwidget.widget.ModifiableWireModelImpl", null, {
    constructor: function(widgetInstance) {
        this._dirty = false;	
		this._instance = widgetInstance;
		this.svc = com.ibm.mashups.services.ServiceManager.getService("eventService");
	
    },    	
	toJson:function(){
		var returnObj = {};
		returnObj._dirty = this._dirty;
		if(this._wires) returnObj._wires = dojo.clone(this._wires);
		if(this._targets) returnObj._targets = dojo.clone(this._targets ); 
		return returnObj;
	},
    isDirty: function() {
        return this._dirty;
    },
	setDirty: function(isDirty) {
      this._dirty = isDirty;
    },
	registerTargets:function(tw,te,se){
	 if (!this._targets) this._targets = {};
	 if (!this._targets[tw]) this._targets[tw] = [];
	 var wire = {tw:tw,te:te,sw:this._instance.id,se:se};
	 this._targets[tw].push(wire);
	 this._dirty = true;
	},
	getTargets:function(){
		if(! this._targets) return null;
		return this._targets;
	},
	removeTargets:function(tw,te,se){
		if(this._targets){
			if (this._targets[tw]) {
				if(!te && !se){
					delete(this._targets[tw]);
					this._dirty = true;
				}
				//todo,very rare case te,se will be available
			}	
		}		
	},
	_addWire:function(wire,loadFromDom) {
		if (this._findWire(wire.getID()) == null) {
			if (typeof this._wires == "undefined"  || this._wires == null) this._wires = [];
			if (!(loadFromDom && loadFromDom == true)) {
				wire.setDirty(true);
				wire.setType(wire.TYPE_NEW);
				this._dirty = true;	
			}
			this._wires.push(wire);
			this.svc.subscribeWire(wire.SourceWidget, wire.SourceEvent, this._instance.id, wire.TargetEvent);
					
		}		
	},	
	_removeWire:function(id) {
		var wire = this._findWire(id);
		if (wire != null) {
			// unsubscribe wire
			for ( var i in this._wires) {
				if (this._wires[i].getID() == id) {
					// remove wire from wire array
					//this._wires.splice(j-1,1);
					this._wires[i].setDirty(true);
					this._wires[i].setType(this._wires[i].TYPE_DELETE);
					this.svc.unSubscribeWire(wire.SourceWidget, wire.SourceEvent, this._instance.id, wire.TargetEvent);			
					this._dirty=true;
					break;
				}
			}			
		}				
	},
	addWire:function(sourceWidget,sourceEvent,targetEvent) {
		var aWire = {};
		aWire.SourceWidget = sourceWidget;
		aWire.SourceEvent = sourceEvent;
		aWire.TargetEvent = targetEvent;
		var wire = new com.ibm.mm.iwidget.widget.WireImpl(this._instance.id, aWire);
		this._addWire(wire);		
	},	
	removeWire:function(sourceWidget,sourceEvent,targetEvent) {
		var aWire = {};
		if (sourceWidget && sourceWidget != null&& sourceEvent&& sourceEvent != null && targetEvent && targetEvent != null) {
			aWire.SourceWidget = sourceWidget;
			aWire.SourceEvent = sourceEvent;
			aWire.TargetEvent = targetEvent;
			var wireObj = new com.ibm.mm.iwidget.widget.WireImpl(this._instance.id, aWire);
			this._removeWire(wireObj.getID());
		}else if (sourceWidget && sourceWidget != null){
			//delete all the wires that has this widget as source
			for (var w in this._wires) {
				if (this._wires[w].getSourceWidgetID() == sourceWidget) {
					this._wires[w].setDirty(true);
					this._wires[w].setType(this._wires[w].TYPE_DELETE);
					var wire = this._wires[w];
					this.svc.unSubscribeWire(sourceWidget, wire.SourceEvent, wire.TargetWidget, wire.TargetEvent);			
					this._dirty=true;		
				}
			}			
		}
	},
	// find Wire by id
	_findWire: function(id) {
		if (typeof(this._wires) != "undefined" && this._wires != null) {
			for (var w in this._wires) {
				if (this._wires[w].getID() == id) {
					var wire = this._wires[w]; //commit the change
					if (wire.isDirty() && wire.getType() != null && wire.getType() == wire.TYPE_DELETE) {
						this._removeFromDOM(wire);
						delete this._wires[w];
						wire = null;
					}	
					else 
					break;
				}
			}
		}
		return wire || null;
	},
	getWires:function(){
		if (typeof (this._wires) == "undefined" || this._wires == null ) {
			this._loadWires();
		}
		var arr = [];
		for (var i in this._wires){
			var aWire = this._wires[i];
			if (!(aWire.isDirty()  == true && (aWire.getType() != null && aWire.getType() == aWire.TYPE_DELETE))){
				arr.push(aWire);				
			}
		}
		//if (arr.length == 0 ) return null;
		return arr;
	},
	_loadWires:function(){
          this._wires = [];
          var ns = this._instance.ns;
          var className="ReceivedEvent";
          var nodes=[];
          com.ibm.mm.iwidget.utils.findElementByAttribute("class",ns+className,this._instance.rootElement,nodes,true);
          var names = ["SourceWidget","SourceEvent","TargetEvent"];
          var classes = ["SourceEvent","TargetEvent"];
          for (var i=0;i<nodes.length;i++){
               var aNode = nodes[i];
               var aWire = {};
               var isValid = true;
               for (var j=0;j<2;j++){
                   var element=[];
                   com.ibm.mm.iwidget.utils.findElementByAttribute("class",ns+classes[j],aNode,element,false);
                   if (element.length == 0 ){ isValid = false; }
                   else{
                       if ( j==0 ) {
                           var temp = element[0].getAttribute("href");
                           if (typeof temp != "undefined" || temp != null) {
                             var index = temp.indexOf ("#");
                             if (index != -1) {
                                 temp=temp.substring(index+1);
                             }
                             aWire[names[0]] = temp;
                             aWire[names[1]] = element[0].innerHTML;
                            }
                       }
                       else{
                           aWire[names[2]] = element[0].innerHTML;                       
                       }
                   }                   
               }
               if (isValid) {
			   	  this._addWire(new com.ibm.mm.iwidget.widget.WireImpl(this._instance.id,aWire),true);
				//  com.ibm.mashups.services.ServiceManager.getService("eventService").subscribeWire(aWire.SourceWidget,aWire.SourceEvent,this._instance.id,aWire.TargetEvent);
			   }                
           } 	
	},
	commit:function(){
		//update dom for ADD and Delete
		if (this.isDirty() == true){
			for (var i in this._wires){
				var aWire = this._wires[i];
				if (aWire.isDirty() && aWire.getType() != null && aWire.getType() == aWire.TYPE_NEW) {
					this._addToDOM(aWire);
					aWire.setDirty(false);
					aWire.setType(null);
				}
				else if (aWire.isDirty() && aWire.getType() != null && aWire.getType() == aWire.TYPE_DELETE) {
					this._removeFromDOM(aWire);
					//delete this._wires[i];
					this._wires.splice(i,1);
				}	
			}
			this.setDirty(false);
		}
	},
	_addToDOM:function(aWire){
		var sourceId = aWire.getSourceWidgetID();
		var sourceEvent = aWire.getSourceEventName();
		var targetEvent = aWire.getTargetEventName();
		
		var recEvent = document.createElement("span");
    	recEvent.className = this._instance.ns+"ReceivedEvent";
        var srcWidget = document.createElement("a");
    	srcWidget.className = this._instance.ns+"SourceEvent";
    	srcWidget.setAttribute("href", "#" + sourceId);
    	srcWidget.innerHTML = sourceEvent;
    
    	var tarEvent = document.createElement("span"); 
    	tarEvent.className = this._instance.ns+"TargetEvent";
    	tarEvent.innerHTML = targetEvent;
    
    	recEvent.appendChild(srcWidget);
    	recEvent.appendChild(tarEvent);
    	
		this._instance.rootElement.appendChild(recEvent);
		
	},
	_removeFromDOM:function(aWire){
		var sourceId = aWire.getSourceWidgetID();
		var sourceEvent = aWire.getSourceEventName();
		var targetEvent = aWire.getTargetEventName();
		
		var widgetSpan = this._instance.rootElement;    
    	var allWireSpans = dojo.query("." + this._instance.ns+"ReceivedEvent", widgetSpan);
		var fragmentService = com.ibm.mashups.services.ServiceManager.getService("iwidgetFragmentService");
    	for (var i = 0; i < allWireSpans.length; i++) {
        	var wireSpan = allWireSpans[i];
        	var srcWidgetSpan = dojo.query("."+this._instance.ns+"SourceEvent", wireSpan)[0];
        	var srcEvent = srcWidgetSpan.innerHTML; 
        	var tarEventSpan = dojo.query("."+this._instance.ns+"TargetEvent", wireSpan)[0]; 
			
        	if (fragmentService.getKeyFromHref(srcWidgetSpan) == sourceId && srcEvent == sourceEvent && tarEventSpan.innerHTML == targetEvent) {
				widgetSpan.removeChild(wireSpan);
				break;
			}
        }        
    }   
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetinstance"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetinstance"] = true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetinstance");









dojo.declare("com.ibm.mm.iwidget.widget.IWidgetInstanceImpl",com.ibm.mashups.iwidget.widget.IWidgetInstance,{
    constructor:function(/*RootElement*/widgetSpan,/*String*/id){
        this.rootElement = widgetSpan;
        this.id = id;
        this.ns = widgetSpan.className.substr(0,3);

        var nodes=[];
        className=this.ns+"Definition";
        com.ibm.mm.iwidget.utils.findElementByAttribute("class",className,this.rootElement,nodes,false);

        var node = nodes[0];
        var url = node.getAttribute("href");
		if (typeof (url) != "undefined" && url !== null ){
               this.widgetXMLUrl = url;
        } 
		this.wiremodel = new com.ibm.mm.iwidget.widget.ModifiableWireModelImpl(this);
    }, 
    getDefaultViewContent:function(){
         if (this.defaultViewContent) return this.defaultViewContent;
         var className = this.ns+"Content";
         var nodeList = dojo.query("span."+className,this.rootElement);
         if (typeof nodeList != "undefined" && nodeList !== null) {
             var node = nodeList[0];
         }
         if (node) {
		 	this.defaultViewContent = node.innerHTML;
		 	return this.defaultViewContent;
		 }
		 else {
		 	return null;
		 }
    },
    getWidgetEvents: function(){
        //simple events including all the predefined events and onSth. event
        if (this.widgetEvents) return this.widgetEvents;
            var widgetEvents = {};
            var attributes = this.rootElement.attributes;
            for (var i=0;i<attributes.length;i++)
            {
                var attribute = attributes[i];
                if (attribute.name !== null && attribute.name.indexOf("on")===0)
                {
                    var handler = this.rootElement.getAttribute(attribute.name);
                    if (typeof handler != "undefined" && handler !== null ) 
                    {
                        widgetEvents[attribute.name] = handler;
                        com.ibm.mm.enabler.debug.log("iWidgetInstance.getWidgetEvents","eventName:"+attribute.name+" handler:"+widgetEvents[attribute.name]);
                    }
                }
             }
             this.widgetEvents = widgetEvents;
         
          return this.widgetEvents;
    },	
	_addWire:function(wire) {
		return this.wiremodel._addWire(wire);		
	},	
	_removeWire:function(id) {
		return this.wiremodel._removeWire(id);				
	},
	addWire:function(sourceWidget,sourceEvent,targetEvent) {
	   return this.wiremodel.addWire(sourceWidget,sourceEvent,targetEvent);
	},	
	removeWire:function(sourceWidget,sourceEvent,targetEvent) {
		return this.wiremodel.removeWire(sourceWidget,sourceEvent,targetEvent);	
	},
    getWires:function(){
  		return this.wiremodel.getWires();
    },
	getWireModel:function(){
		return this.wiremodel;
	},	
    /**
     * ModifiablePropertiesProvider Impl
     */
    getAttributes: function(){
        if (!this.attributeProperties) {
            //return all the attributes as  JSON data
            var attributes = this.getItemSets()[iwConstants.ATTRIBUTES];
            
            var items = {};
			var localizedItems = {};
            if (attributes) {
                for (itemName in attributes) {
                    items[itemName] = attributes[itemName].defaultValue;
					if (attributes[itemName].localizedValues) {
					    localizedItems[itemName] = {};
					 	for (locale in attributes[itemName].localizedValues) {
							localizedItems[itemName][locale] = attributes[itemName].localizedValues[locale];
						}
					} 					
                }
            }
            
            this.attributeProperties = new com.ibm.mm.iwidget.widget.ModifiablePropertiesImpl(items, localizedItems);
        }
        
        return this.attributeProperties;
    },
    /**
     * ModifiablePropertiesProvider Impl
     */
    getIDescriptorItems: function(){
        if (!this.idescriptorProperties) {
            //return all the attributes as  JSON data
            var iDescriptor = this.getItemSets()[iwConstants.IDESCRIPTOR];
            
            var items = {};
			var localizedItems = {};

            if (iDescriptor) {
                for (itemName in iDescriptor) {
                    items[itemName] = iDescriptor[itemName].defaultValue;		
					if (iDescriptor[itemName].localizedValues) {
						localizedItems[itemName] = {};
					 	for (locale in iDescriptor[itemName].localizedValues) {
							localizedItems[itemName][locale] = iDescriptor[itemName].localizedValues[locale];
						}
					} 
                }
            }

            
            this.idescriptorProperties = new com.ibm.mm.iwidget.widget.ModifiablePropertiesImpl(items, localizedItems);
        }
        
        return this.idescriptorProperties;
    },

    _getItemSets:function(){
         if (this.itemSets) {
		 	return this.itemSets;
		 }
         this.loadItemSets();
         return this.itemSets;
    },
	getItemSets:function(){        
         return this._getItemSets();
    },
    loadItemSets:function(){
    	delete this.itemSets;
        this.itemSets = {};
        var itemSetChildren = [];
        com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.ns+"ItemSet",this.rootElement,itemSetChildren,true);
        if ( itemSetChildren.length > 0 ) {
            for (var i=0;i<itemSetChildren.length;i++) {
                var elem = itemSetChildren[i];
                var itemSetName = elem.getAttribute("title");
                if (typeof (itemSetName) != "undefined")    {
                    aItemSet = this.itemSets[itemSetName];
                    if (typeof aItemSet == "undefined" || aItemSet === null) {
                        //aItemSet = [];
                        this.itemSets[itemSetName] = {};
                    }
                    // now get the Item schildren and add them to aItemSet
                    var itemChildren =[];
                    com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.ns+"Item",elem,itemChildren,true);
                    if (itemChildren.length !=0 ) {
                        for (var j=0; j<itemChildren.length;j++) {
                            var elem1 = itemChildren[j];
                            var anItem = this._loadLocalizedItem(elem1);
                            var itemName = anItem.itemName;
                            this.itemSets[itemSetName][itemName]=anItem;
                        }
                    }
                }
            }
        }
    },	
	
	// invalidate itemsets
	_invalidateItemSets:function(name) {
        if (typeof itemSetName == "undefined" || itemSetName === null) {
        	// invalidate all itemset
			this.itemSets = {};
        } else {
			// invalidate a single itemsets
            this.itemSets[name] = {};			
		}
	},
    _loadLocalizedItem:function(/*element*/elem1){
    	 //get itemName
    	 var item = {};
    	 var itemName = elem1.getAttribute("href");

         var index = itemName.indexOf ("#");
         if (index != -1) {
             itemName=itemName.substring(index+1);
         }
         item.itemName = itemName;

         //get default lang
         var lang = elem1.getAttribute("lang");
         if(typeof lang == "undefined") lang = null;
         if (lang != null) {
        	 item.defaultLang = lang;
         }	          
 
         item.defaultValue = null;

         var children = [];
         com.ibm.mm.iwidget.utils.findElementByAttribute("class", this.ns + "Value", elem1, children, true)
         if (children.length != 0) {
             item.localizedValues = [];
             var firstValue = null;
             for (var j = 0; j < children.length; j++) {
                var elem2 = children[j];
                var locale = elem2.getAttribute("lang");
                var lValue =  com.ibm.mm.enabler.dom.textContent(elem2);
                item.localizedValues[locale] = lValue;
                if ("en" === locale) {
                    item.defaultValue = lValue;
                }
                if (firstValue == null) {
                   firstValue = lValue;
                }
             }
             if (item.defaultValue == null) {
                 item.defaultValue = firstValue;
             }
         }

         if (item.defaultValue == null) {
             var defaultValue = elem1.innerHTML;
             if (typeof defaultValue != "undefined" || defaultValue != null) item.defaultValue = defaultValue;
         }
             
         
         com.ibm.mm.enabler.debug.exit("com.ibm.mm.enabler.iWidgetInstanceStandard._loadLocalizedItem","item:"+item);
         return item;         
    },
	
	_getInstanceMarkup:function(){
		var node = dojo.clone(this.rootElement);
		//remove content div if it's available		
		dojo.query("."+this.ns+"Content",node).forEach(
    		function(contentNode) {
        		com.ibm.mm.enabler.dom.destroyNode( contentNode );
   			}
		);	
		dojo.query("."+this.ns+"loading",node).forEach(
    		function(contentNode) {
        		com.ibm.mm.enabler.dom.destroyNode( contentNode );
   			}
		);		
		
		var tempEl=document.createElement("div");
		tempEl.appendChild(node);
		var html=tempEl.innerHTML;
		return html;				
	}	
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.model.eventmodel"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.model.eventmodel"] = true;
dojo.provide("com.ibm.mm.iwidget.model.eventmodel");

/*provide Locator and Iterator,query by condition and other convenience function*/
/*internal model for widget wrapper */
dojo.declare("com.ibm.mm.iwidget.model.EventModelImpl",null,{	
 constructor:function (obj,wrapper) { 
	    //widget wrapper id
		this.wrapper = wrapper;
		//an associative array of eventDescription object
		this.eventDescriptionPool = obj;    
 },
 _PredefinedFields:{
     name:"name",
     type:"type",
     lang:"lang",
     isPublished:"isPublished",
     isHandled:"isHandled",
     handlingFn:"handlingFn"
 },
 /*id is eventName*/
 find:function(id){
     var event = this.eventDescriptionPool[id];
     if (typeof (event) != "undefined" && event != null)
         return event;
     if (this.wrapper.handledEvents && this.wrapper.handledEvents != null){
	 	if (this.wrapper.handledEvents[id] && this.wrapper.handledEvents[id] != null)
		return this.wrapper.handledEvents[id][0];
	 }
	  if (this.wrapper.publishedEvents && this.wrapper.publishedEvents != null){
	 	if (this.wrapper.publishedEvents[id] && this.wrapper.publishedEvents[id] != null)
		return this.wrapper.publishedEvents[id][0];
	 }
     return null;
 },
 eventExists:function(eventName){
     var temp = this.eventDescriptionPool[eventName];
     if (typeof temp != "undefined" && temp != null)
         return true;
     else
         return false;			
 },
 _getEventDescObj:function(eventDesc){
 	var obj = eventDesc;
	var declaredClass = eventDesc.declaredClass;
	if (typeof declaredClass == "undefined" || declaredClass == null)
	 obj = new com.ibm.mm.iwidget.iEventDescriptionImpl(eventDesc);	
	return obj; 	
 },
 createEvent:function(eventDescData){
 	 var eventDesc = this._getEventDescObj(eventDescData);
 	  var eventExists = this.eventExists(eventDesc.name);
     if (eventExists) {
         return false;
     }	
     else {
         this.eventDescriptionPool[eventDesc.name] = eventDesc;
		 return true;
     }
 },
 removeEvent:function(eventName){
     var eventExists = this.eventExists(eventName);
     if (eventExists) {
         delete this.eventDescriptionPool[eventName];
         return true;
     }	
     else {
         return true;
     }		
 },
 updateEvent:function(eventDescData){
 	 var eventDesc = this._getEventDescObj(eventDescData);
     var eventExists = this.eventExists(eventDesc.name);
     if (eventExists) {
         this.eventDescriptionPool[eventDesc.name] = eventDesc;
     }	
     else {
         return false;
     }
 },
 getEvents:function(condition){
  //return  an array of iEventDescription ( by reference)
  //return null if no events is found

     if (typeof condition == "undefined" || condition == null) {
         return this._getEventsInArray(this.eventDescriptionPool);		
     }
	 //check any events from previous session
	 var array = [];
	 
	 if(condition.isHandled && condition.isHandled == "true"){
	 	//check if we have any events in the wrapper array
		//backward compatibility
		if(this.wrapper.handledEvents){
			this._addEvents(array,this.wrapper.handledEvents);
		}	 	
	 }	 
	
	 if(condition.isPublished && condition.isPublished =="true"){
	 	//check if we have any events in the wrapper array
		//backward compatibility
		if(this.wrapper.publishedEvents){
			this._addEvents(array,this.wrapper.publishedEvents);
		}	 	
	 }
	 if (dojo.isString(condition)) {
		 try{
			 condition = dojo.fromJson(condition);
		 }
		 catch (e){
			 return null; // invalid condition
		 }
	 }

  
     for (var j in this.eventDescriptionPool){
         var eventDesc = this.eventDescriptionPool[j];
         var rc = this._checkMatch(eventDesc._getInternalJsonObj(),condition);	
        if (rc ) array.push(eventDesc);
     }	
     if (array.length == 0 ) return null;
     else return array;
 },
 /*turn associative array into real array, return null if empty*/
 _getEventsInArray:function(arr){
     var returnArr = [];
     for (var j in arr){
             returnArr.push(arr[j]);
     }
     if (returnArr.length == 0 ) return null;
     else return returnArr;
 },
 _checkBoolean:function(str,name,value){
	  var rc = false;
	  var temp = "\""+name+"\""+":"+value;
	  if (str.indexOf(temp) != -1) {
		  return true;
	  }
	  temp = "\""+name+"\""+":\""+value+"\"";
	  if (str.indexOf(temp) != -1) {
		  return true;
	  }
	  return false;
 },
 //can be replaced with regular expression, do some basic stuff for now
 _checkMatch:function(eventDesc,condition){
     var rc = true;
     var conditionArr = [];
     for (var i in condition){
         if (condition[i] == null) continue; //check next condition if current condition is null
         if ( typeof ( this._PredefinedFields[i] ) != "undefined"){
             //for predefined fields
             if (i == this._PredefinedFields.isPublished && (condition[i] == true|| condition[i]=="true")){
                 //check if isPublished is true
				//break if !(isPublished is defined and isPublished = true) 
				 //eventDesc.isPublished returns undefined if eventDesc.isPublished = true!
				 if(!this._checkBoolean(dojo.toJson(eventDesc),i,"true")){ 
					 rc = false; 
					 break;} //break if isPublished  != true;					
             }
             else if (i == this._PredefinedFields.isPublished && (condition[i] == "false" || condition[i] == false)){
			 	//check if isPublished is false
                 //break if isPublished is defined and isPublished is not "false"
                 if(!this._checkBoolean(dojo.toJson(eventDesc),i,"false")){ 
					 rc = false; 
					 break;}					
             }
             else if (i == this._PredefinedFields.isHandled && (condition[i] == true|| condition[i]=="true")){
             //break if handlingFn is not defined or it's null	
                 if(!eventDesc[this._PredefinedFields.handlingFn] || (eventDesc[this._PredefinedFields.handlingFn]  && eventDesc[this._PredefinedFields.handlingFn] == null)) { 
					 rc = false; 
					 break;} 			
             }
             else if (i == this._PredefinedFields.isHandled && (condition[i] == "false" || condition[i] == false)){
                 //break if handlingFn is defined and it's not null
                 if (eventDesc[this._PredefinedFields.handlingFn] && (eventDesc[this._PredefinedFields.handlingFn] != null)){ 
					 rc = false; 
					 break;}					
             }
             else if (! (eventDesc[i] && eventDesc[i] != null && eventDesc[i] == condition[i])) { 
			 //break if !(condition exists and condition match)
				 rc = false; 
				 break;}
         }
         //for attributes
         else if (!( eventDesc.attributes && eventDesc.attributes[i]&& eventDesc.attributes[i] == condition[i])){
		 		rc = false;
				break;
       }
         //continue with next condition, break if condition doesn't meet
     }
     return rc;		
 },
 _addEvents:function(arr,associativeArr){
 	for (var i in associativeArr){
		var eventDescArr = associativeArr[i];
		for (var j in eventDescArr){
			arr.push(eventDescArr[j]);
		}
	}		
 } 

});



}

if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapper"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapper"] = true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetwrapper");










  








dojo.declare("com.ibm.mm.iwidget.widget.IWidgetWrapperDefaultImpl",com.ibm.mashups.iwidget.widget.IWidgetWrapper,{
     constructor: function (widgetSpan,id) { 
        this._internalIbmModes = com.ibm.mm.iwidget.itemset._internalIbmModes;

        //parsing microformat
        this.rootElement = widgetSpan;
        if (typeof (id) != "undefined" && id != null ) {
            this.id = id;
        }
        else {
            this.id = widgetSpan.getAttribute("id");
        }
		this.hubId = this.id; //hubClientId -- used for communication with openajax hub, for main view, it's the same as instanceid
		this.simpleWidgetEvents = {};
        this.loaded = false;
        this.widgetAttributes = null; // defer creation
        this.widgetItemSets = null;   // defer creation to getWidgetItemSet or getItemSets
        this.ns = widgetSpan.className.substr(0,3);
        this.windowManager = {}; // an associative array of window entities, key is windowid(for release1,it's mode);
                                 // value is simple json object: {id:"edit",root:rootElement,active:false}
        this.iwMessages = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwMessages"); 
		this.eventSvr = com.ibm.mashups.services.ServiceManager.getService("eventService");
		this._jsHandler = com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER;
		this.eventHandlers = [];
		//backward compatibility
		this.publishedEvents = {};
		this.handledEvents = {};
		
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);	
    },
	getID:function(){
		return this.id;
	},	
	getIWidgetInstance: function(){
		if (typeof this.widgetInstance != "undefined" || this.widgetInstance != null) return this.widgetInstance;
			this.widgetInstance = new com.ibm.mm.iwidget.widget.IWidgetInstanceImpl(this.rootElement,this.id);
		return this.widgetInstance;
	},
	setIWidgetDefinition: function(widgetDef){
		this.widgetDef = widgetDef;
	},
	getIWidgetDefinition: function(){
		if (this.loaded) {
			return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id,this.widgetDef);
		}
		else{
			return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id);
		}		
	},
    getMarkup: function() {
        return new com.ibm.mm.iwidget.DeferredLiveTextUnprocessImpl(this);
    },  
	/*  
	isEventsReady:function(){
		if(typeof (this._isEventsReady) == "undefined" || this._isEventsReady == null){
			return false;
		}
		return this._isEventsReady;
	},*/
	doRender:function(){
		try {   
      			this.prepare();
				this.execute();							
			}
			catch(e){
		       com.ibm.mm.enabler.debug.error("IWidgetWrapper.doRender","widget:"+this.hubId+" OnloadingException:"+e);
			}  		
	},
	prepare: function(){
 	    variableName = "_"+this.id+"_"+"iContext";
		if (this.isModal() == false){
		dojo.global[variableName]= new com.ibm.mm.iwidget.iContextImpl(this,this.ns);
		}else{
			 //change for defect 7187
			var mainframeId = this.id;
			if (dojo.isIE) mainframeId = "iframe_"+this.id;
			var iContextInstance = parent[mainframeId][variableName];
			dojo.global[variableName] = iContextInstance;		
		}

    	//subscribe event handler so event can be handled
		//if (this._inIframe() == true)  console.log("subscribe hubClient:"+this.eventSvr.WIDGETEVENT_PREFIX + this.hubId);
		var eventServiceHandler = this.eventSvr._subscribeEvent( this.eventSvr.WIDGETEVENT_PREFIX + this.hubId,this,"handleEvent",null,this.hubId);
		
		if (this._inIframe() == false){
			this.eventHandlers.push(eventServiceHandler);
		}
     //com.ibm.mm.enabler.debug.exit("iWidget.prepare");
    },
	execute:function(){ 
		this._initialize();
		this._doRender();
	},	
	_updateMarkup: function(mode,contentDiv){
       //com.ibm.mm.enabler.debug.entry("iWidget._updateMarkup");
        var wInfo = this.widgetDef;

        var markup = wInfo.getMarkupByMode(mode);
        if (mode == iwConstants.mode_view) {
            if (this.widgetDef.getAllowInstanceContent()) {
                var temp = this.getIWidgetInstance().getDefaultViewContent();
                if (temp && temp !== null) {
					markup = temp;
				}
            }
        }
        if (typeof markup == "undefined" || markup === null) {
            var error = dojo.string.substitute(this.iwMessages.E_IWIDGETDEF_CONTENTNOTAVAILABLE_1, [mode]);  
            com.ibm.mm.enabler.debug.info("iWidget._updateMarkup",error);
            return false;
        }
        //parse the mark and replace iContext with _widgetid_iContext
        var updatedMarkup = this._prepareMarkup(markup);
        updatedMarkup = updatedMarkup.replace(/^\s+|\s+$/, '');
		if (updatedMarkup.indexOf("<script") == 0 ) updatedMarkup = "&nbsp;"+updatedMarkup;
		
        //append all the nodes to a temporary div element
        var tempDIV = document.createElement( "DIV" );
        tempDIV.innerHTML = updatedMarkup;
       					
        // find the script elements
		var scriptElems = tempDIV.getElementsByTagName( "script" );
		if ( scriptElems !== null ) {
			// iterate over script elements and attach an id attribute ,
            // this is necessary so if there's document.write, it got over written
            // otherwise you will get a blank page!
			for ( var i = 0; i < scriptElems.length; i++ ) {
					var scriptElem = scriptElems[i];

					// include an id if there is none so far
					// (needed to lookup script in original DOM later on)
					var id = scriptElem.getAttribute( "id" );
					if (id === null || id == "" ) {
						scriptElem.setAttribute( "id", "_scr#" + i );
					}
			}
		}
		// update the DOM before executing the scripts
		// (the scripts might rely on elements in the DOM)
		//var contentDiv = this.rootElement.lastChild;           
        contentDiv.innerHTML = tempDIV.innerHTML;         
        //destroy tempDiv
        com.ibm.mm.enabler.dom.destroyNode( tempDIV );        
       //com.ibm.mm.enabler.debug.exit("iWidget._updateMarkup");
        return true;
	},
    _prepareMarkup: function(markup){
        //com.ibm.mm.enabler.debug.entry("iWidget._prepareMarkup");
         var oldMarkup = markup.replace(/_IWID_/g,"_"+this.id+"_");
         //?= is javascript 1.5 feature
         var finalMarkup = oldMarkup.replace(/iContext(?=\.|\s|\(|\))/g,"_"+this.id+"_iContext");
        //com.ibm.mm.enabler.debug.exit("iWidget._prepareMarkup",finalMarkup);
         return finalMarkup;
    },
	destroy: function () {	
		if (this.loaded && this.isModal() == false) {
				this._handleEventInternal(com.ibm.mm.iwidget.iEvents.Constants.onUnLoad);
		}   
		if (this._inIframe() == false) {	
			//notify targetwidgets source is removed.
			var wireModel = this.getIWidgetInstance().getWireModel();
			if(wireModel && wireModel != null){
				var targets = wireModel.getTargets();
			}
			if (targets && targets != null) {
				var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
				for (var i in targets) {
				var widget = widgetModel.find(i);
					if (widget && widget != null) {
						var wires = widget.getIWidgetInstance().getWireModel(); // remove all the wires that contains "this.id" as source
						wires.removeWire(this.id)
						widget.commit();
					}
				}
			}	
			for (var i in this.eventHandlers) {
				this.eventSvr._unsubscribeEvent(this.eventHandlers[i], this.hubId);
			}
			this.eventSvr._getHubAdapter(this.hubId).removeInlineHubClient(this.hubId);
			if (dojo.global["_"+this.id+"_"+"iContext"] && dojo.global["_"+this.id+"_"+"iContext"] != null)//when iframe is removed,this could be null
					dojo.global["_"+this.id+"_"+"iContext"] = null;         
		}          
		else {
		//delete dojo.global["_"+this.id+"_"+"iContext"];   //doesn't work on IE7, can't delete from global context
			if (this.isModal() == false){
				this.eventSvr.disconnectHubClient();
				if (dojo.global["_"+this.id+"_"+"iContext"] && dojo.global["_"+this.id+"_"+"iContext"] != null)//when iframe is removed,this could be null
					dojo.global["_"+this.id+"_"+"iContext"] = null;   		
			}  			
		}	
		if (this.rootElement){
			this.rootElement = null;
		}
	 	if (this.windowManager) this.windowManager = null;
		
		//notify target widget to removeWire

  	},		
	update2:function(widgetSpan) {
       
		// set updated root element
        this.rootElement = widgetSpan;
                
        // update default mode
        var aMode = this._getDefaultMode();
        this.currentMode = (aMode == null) ? iwConstants.mode_view : aMode;
        
        // update published and handled events 
        this._getPublicEvents();
        
        // update wires 
        this.getIWidgetInstance()._updateWires();

		// invalidate item sets
		this.getIWidgetInstance().itemSets = null;		
		
       //com.ibm.mm.enabler.debug.exit("iWidget.update2"); 
	},
	_doRender: function() {
    	var tempDiv = document.createElement( "div" );
        tempDiv.className = this.ns+"Content";
        this.rootElement.appendChild(tempDiv);
        var contentDiv = this.rootElement.lastChild;
		dojo.addClass(contentDiv,this.currentMode);
		contentDiv.style.visibility = "hidden"; 	
		if (this._inIframe() == true){
		 dojo.style(contentDiv,"height","100%");	
		} 
		//need to render default mode for modal dialog since some widgets will create dom in onload etc...
		var defIDescriptor =  this.widgetDef.getIDescriptorItems();
		var defaultMode = defIDescriptor.getItemValue(iwConstants.iDescriptorItems.mode);
		if ( this.isModal()&& this.currentMode != defaultMode){
			//create a div tag for main view
			var tempDiv1 = document.createElement( "div" );
        	tempDiv1.className = this.ns+"Content";
        	this.rootElement.appendChild(tempDiv1);
        	contentDiv1 = this.rootElement.lastChild;
			dojo.addClass(contentDiv1,defaultMode);
			contentDiv1.style.visibility = "hidden"; 	
			contentDiv1.style.display="none";		
			this._updateMarkup(defaultMode,contentDiv1);	
		}	
		
        this._updateMarkup(this.currentMode, contentDiv);        
        this._loadWidgetSharedResource(dojo.partial(this._finishRender, contentDiv, this));
	},	
	_finishRender:function(contentDiv, wrapper) {
		// Important for timing to subscribe to this event before loading widget
		var eventHandler = wrapper.eventSvr._subscribeEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+"."+wrapper.id,wrapper,"handleSizeChanged", null,wrapper.id);
		wrapper.eventHandlers.push(eventHandler);

		wrapper._createiScope();
        //contentDiv = wrapper.rootElement?
        wrapper._evalScripts(contentDiv);
        wrapper.windowManager[wrapper.currentMode] = {
            id: wrapper.currentMode,
            root: contentDiv,
            active: true,
            external: false
        };
		
		// tell event service it's ready to accept event
		//wrapper._isEventsReady = true;
		//wrapper.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX + wrapper.hubId+".eventsready",null,wrapper.hubId);     
        wrapper.onLoad();              
                
		// if there are any events coming from a different page, handle them
		wrapper.eventSvr._handleBroadcastEventsCache();
			
        //now handle queued events if there's any
        if(typeof wrapper._eventqueue != "undefined" && wrapper._eventqueue != null){
            for (var event in wrapper._eventqueue){
                  wrapper.handleEvent(wrapper._eventqueue[event]);
            }
        }
        dojo.query("."+wrapper.ns+"loading",wrapper.rootElement).forEach(
            function(elem){
                  com.ibm.mm.enabler.dom.destroyNode(elem);
        }); 
        dojo.query("."+wrapper.currentMode,wrapper.rootElement).style({
            "visibility":""     //display:"none" will make mode selector not displaying properly    
                                //set visible will work funny in FF, the node will be visible even parent node is set to be invisible       
        });
	},
		
    _initialize:function(){
       //com.ibm.mm.enabler.debug.entry("iWidget._initialize");
        var lang = this.widgetDef.getDefaultLanguage();
        if (typeof lang != "undefined" && lang != null) {
            this.defaultLanguage = lang;
        }
        else{
            this.defaultLanguage = "en";
        }

        var aMode  = this._getDefaultMode();
        if (aMode == null) aMode = iwConstants.mode_view;
        this.currentMode = aMode;
       
        //initialize publishedEvents and handledEvents
        this._getPublicEvents();
               
        //register wires
        this.getWires();
       //com.ibm.mm.enabler.debug.exit("iWidget._initialize"); 
    },
	_evalScripts:function(contentDiv){
        var scriptElems = contentDiv.getElementsByTagName( "script" ); 
        for ( var i=0; i<scriptElems.length; i++) {
            this._jsHandler.handle( scriptElems[i] );
        }
  	},
	onLoad:function(){ 
  	if (this.isModal()  == false){ //no need to call onload anymore since it should already be initialized
        this._handleEventInternal(com.ibm.mm.iwidget.iEvents.Constants.onLoad);
		}
		//update state like onNavStateChanged
		this.updateState();
		//tell the stub widget is loaded
	    this._handleEventInternal("on"+this.currentMode);
		this.loaded = true;   
		try {
			//tell builder widget is loaded
			dojo.publish(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED + "." + this.id, [this.id]);
		}
		catch(e){
			//workaround
			console.log("!!!!!!Exception:"+e);
		}
	 	this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+this.hubId,this.hubId);
       
  },   
  _getSimpleEventHandler:function(/*String*/eventName){
      //com.ibm.mm.enabler.debug.entry("iWidget._getSimpleEventHandler",eventName);
       if ( this.simpleWidgetEvents  && this.simpleWidgetEvents[eventName])  return this.simpleWidgetEvents[eventName];
       var handler = this.widgetDef.getWidgetEvents()[eventName];
       if ( handler == null) handler = eventName;
       
       var scope = this._getHandlerScope(handler);
       var handlerObj = null;
       if (scope != null) {
           handlerObj = dojo.hitch(scope,handler);
           this.simpleWidgetEvents[eventName]= handlerObj;
       }
       else if ( handler.indexOf("on") == 0){
    	   //get Uppercase event like onedit --> onEdit
    	   var newhandler = "on"+handler.substr(2,1).toUpperCase()+handler.substr(3);
    	   if (newhandler != handler){
    		   scope = this._getHandlerScope(newhandler);
    		   if(scope != null){
    			   handlerObj = dojo.hitch(scope,newhandler);
    	           this.simpleWidgetEvents[eventName]= handlerObj;    			   
    		   }   
    	   }    	   
       }	   
      //com.ibm.mm.enabler.debug.exit("iWidget._getSimpleEventHandler",handlerObj);
       return handlerObj;       
   },
   _getHandlerScope:function(/*fn*/handler){
       //com.ibm.mm.enabler.debug.entry("iWidget._getHandlerScope",handler);

       //returns a global function or scope object
       var fn = dojo.global["_"+this.id+"_"+handler];
       if (typeof (fn) == "undefined")
       {
           widgetScope = dojo.global["_"+this.id+"_iContext"].iScope();
           if (widgetScope && widgetScope[handler])
           fn = widgetScope;                
       } 
       if (typeof fn == "undefined" || fn == null ) fn = dojo.global[handler];
       if (typeof fn == "undefined" || fn == null ) return null;
       else{
          //com.ibm.mm.enabler.debug.exit("iWidget._getHandlerScope",fn);
           return fn;
       }
    },
	handleEvent:function(payload){
		//event handler that subscribes to event handler
		var declaredClass = payload.declaredClass;
		if (typeof declaredClass != "undefined" && declaredClass != null && declaredClass == "com.ibm.mm.iwidget.iEventImpl") {
			var eventName = payload.name;
			return this._handleEvent(eventName, payload);
		}
		//if it's a payload other than iEvent --used for internal communication between wrapper and wrapper stub
		//for example: _getMarkup(includeParent); 
		var scope = payload.scope;
		if (typeof scope != "undefined" && scope != null) {
			if(scope == "instance"){
				scope = this.getIWidgetInstance();		
			}else if (scope == "eventmodel"){
				scope = this._getPublicEvents();
			}
		}
		else{
			scope = this;
		}	
		var methodname = payload.methodname;	
		if (typeof methodname != "undefined" && methodname != null) {
			if(scope[methodname] && dojo.isFunction(scope[methodname])){
				scope[methodname].apply(scope,payload.params);				
			}
		}		
	},
   	_handleEvent: function(eventName,iEvent){
      iEvent = this._deserializePayload(iEvent);

      //check here. it's just one payload with {eventName,iEvent}
       if (typeof eventName == "undefined" || eventName == null) return false;
	   	if(this.loaded == false){
			if(typeof this._eventqueue == "undefined" || this._eventqueue == null ) this._eventqueue = {};
			this._eventqueue[eventName] = iEvent;
			return;
		}
       //handle onModeChanged event
	   try {
	   	if (eventName == iwConstants.EVENTS.onNavStateChanged) {
	   		return this._handleOnNavStateChanged(iEvent);
	   	}	   
	   	if (eventName == iwConstants.EVENTS.onModeChanged) {
			if(this._inIframe() == true){
				//publish event to stub widget
				var payloadObj = {};
				payloadObj.methodname = "_handleOnModeChange";
				payloadObj.hubclient = this.hubId;
				payloadObj.params = [iEvent.payload];
				//var id = "_stub_"+this.id.slice(0,this.id.lastIndexOf("_"));			
				var id = "_stub_"+this.id;
				this.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX + id,payloadObj,this.hubId);				
				return;
			}

	   		return this._handleModeChange(iEvent);
	   	}
	   	if (eventName == "onNewWire") {
	   		return this._handleNewWire(iEvent);
	   	}
	   	if (eventName == "onRemoveWire") {
	   		return this._handleRemoveWire(iEvent);
	   	}
	   	return this._handleEventInternal(eventName, iEvent);
	   }catch (e){
	   	com.ibm.mm.enabler.debug.error("IWidgetWrapper.handleEvent","widget:"+this.hubId+"eventName:"+eventName+" HandleEventException:"+e);
	   }    
   },   
   _deserializePayload: function(iEvent) {
      // complex payload objects must be deserialized from json for case when widgets are sandboxed
      // to be serializable, complex payload objects must implement toJson method that returns json in format {"className":"x","json":"y"}
      // to be deserializable, complex payload objects must have a constructor with an argument that accepts the "y" json value returned from toJson
      if (typeof iEvent.payload == 'string' && iEvent.payload.indexOf("className") != -1 && iEvent.payload.indexOf("json") != -1) {
        try {
          var deserialized = dojo.fromJson(iEvent.payload);
          if (deserialized.className && typeof deserialized.className == 'string' && deserialized.className.length > 0 && deserialized.json && typeof deserialized.json == 'string') {
            iEvent.payload = eval("new " + deserialized.className + "(" + deserialized.json + ");");
          }
        } catch (e) {
        }
      }
      return iEvent;
   },
   _handleNewWire:function(iEvent){
        var payload = iEvent.payload;
		//registerTargets
		var wireModel = this.getIWidgetInstance().getWireModel();
		wireModel.registerTargets(payload.targetWidget,payload.targetEvent,payload.sourceEvent);
		this.commit(); //need to send updates to stub, if it's iframe
		
        var eventName = payload.sourceEvent;  //check if there's onNewWire defined in iEventDescription

        //var event = this.publishedEvents[eventName];
		var eventModel = this._getPublicEvents();
	    if (eventModel == null) return false;
	   
	    var eventDesc = eventModel.find(eventName);
      	//need to get original event....
        if (typeof eventDesc != "undefined" && eventDesc != null) {
            var handler = eventDesc.getOnNewWire();
            if ( handler != null) {
                var scope = this._getHandlerScope(handler);
                if (scope != null && dojo.isFunction(scope)){
                    scope(iEvent);
                } 
                else if (scope != null && dojo.isObject(scope))
                {
                    scope[handler](iEvent);
                }
                return true;
            }
        } 
        return false;
   },
   _handleRemoveWire:function(iEvent){
        var payload = iEvent.payload;
        var eventName = payload.targetEvent;   // check if there's onRemoveWire defined in iEventDescription
       	if (this.id == payload.sourceWidget){ //since it could be provided by publish event as well
			eventName = payload.sourceEvent;
		}
        
		var eventModel = this._getPublicEvents();
	    if (eventModel == null) return false;
	   
	    var eventDesc = eventModel.find(eventName);
      
        if (typeof eventDesc != "undefined" && eventDesc != null) {
           var handler = eventDesc.getOnRemoveWire();
           if ( handler != null) {
               var scope = this._getHandlerScope(handler);
               if (scope != null && dojo.isFunction(scope)){
                   scope(iEvent);
               } 
               else if (scope != null && dojo.isObject(scope))
               {
                   scope[handler](iEvent);
               }
               return true;
           }
        } 
       return false; 
   },
   _handleOnModeChange:function(newMode){
		var aEvent = new com.ibm.mm.iwidget.iEventImpl("onModeChanged",null,{newMode:newMode},null);  
	    this._handleModeChange(aEvent);
   },
   _handleModeChange:function(iEvent){
		var isHandled = false;
        var oldMode = this.currentMode;

        var payload = iEvent.payload;
        if (typeof payload == "undefined" || payload == null ) return false;  
        if (dojo.isString(payload)) payload = dojo.fromJson(payload);
        if (typeof payload == "undefined" || payload == null ) return false;  
        var newMode = payload.newMode;
        if (typeof newMode == "undefined" )  newMode = null;
        var newRoot = payload.rootElementId;
        if (typeof newRoot == "undefined" ) newRoot = null;
		
        // support one active mode only, thus don't support this operation
        if (newMode!= null && newMode == this.currentMode) return false;
        if (newMode == null) return false;
		
		var external = false;
        if(newRoot != null) external = true;  
        var updatedNewRoot = newRoot;

		var defaultMode = this._getDefaultMode();
		if(!defaultMode ||defaultMode == null) defaultMode = "view";
		if (this._inIframe() == true && defaultMode == newMode){
			//swtich back to view mode
			this.currentMode = newMode;
			this.windowManager[newMode] ={id:newMode,root:updatedNewRoot,active:true,external:false}; 		
			this._handleOnModeEvent(newMode);			
			return;
		}		
		//change:e
   	
        var oldWindow = this.windowManager[newMode];
        var isWindowAvailable = false;
        if (typeof oldWindow != "undefined" && oldWindow !== null){
            var oldRoot = oldWindow.root;
            if (!oldWindow.external && oldRoot != null && newRoot === null) {
                updatedNewRoot = oldRoot;
                isWindowAvailable = true;
                isHandled = true;
                //how to verify a node doesn't exist anymore?
                 // turn on this window
                 dojo.style(oldRoot,"display","");

             }
        }
        //create new window and update markup
        if(!isWindowAvailable){
            if (updatedNewRoot === null){
                var tempDiv = document.createElement( "div" );
                tempDiv.className = this.ns+"Content";
                this.rootElement.appendChild(tempDiv);
                updatedNewRoot = this.rootElement.lastChild;
				dojo.addClass(updatedNewRoot,newMode);   
            }
            isHandled = this._updateMarkup(newMode,updatedNewRoot); 
        }        
        if (isHandled) {
             //hide current view 
            var currentWindow = this.windowManager[this.currentMode];
            var currentRoot = currentWindow.root;
                if (currentWindow.external ) {
                    dojo.style(currentRoot,"display","none");//todo, destroy external window?
                    this.windowManager[this.currentMode] = null;
                }
                else if (newRoot != null) {   //if the newRoot is provided, don't hide current window. leave builder to do this.
                    currentWindow.active = false;
                }
                else{
                    currentWindow.active = false;
                    dojo.style(currentRoot,"display","none");
                }  
            
            //change current mode
            this.currentMode = newMode;

            //  save/reset new window
            this.windowManager[newMode] ={id:newMode,root:updatedNewRoot,active:true,external:external};   
    
            if (!isWindowAvailable ) {this._evalScripts(updatedNewRoot);}
            this._handleOnModeEvent(newMode);
        }
        if(isHandled && this._inIframe() == false ){
		   dojo.publish(com.ibm.mm.iwidget.iEvents.Constants.modeChanged,[this.id,oldMode,newMode]);
  			var payload = {};
		   payload.id = this.id;
		   payload.oldMode = oldMode;
		   payload.newMode = newMode;
		   this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED,payload,this.hubId);
 		}
				
		if(this._inIframe() == true){
			//switch from view -->edit  very rare use case since mode switch are triggered from skin
			//just tell stub mode is updated
				var payloadObj = {};
			payloadObj.methodname = "_handleOnModeUpdated";
			payloadObj.hubclient = this.hubId;
			payloadObj.params = [iEvent.payload];
				//var id = "_stub_"+this.id.slice(0,this.id.lastIndexOf("_"));			
			var id = "_stub_"+this.id;
			this.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX + id,payloadObj,this.hubId);				
		}

        return isHandled;
   },
  _handleOnModeUpdated:function(mode){
//	    console.log("IWidgetWrapper Iframe --> new mode is "+mode);
		this.currentMode = mode;
        this.windowManager[mode] ={id:mode,active:true,external:true};     
   },
    _handleOnModeEvent:function(mode){
		if(this._inIframe() == true) {
		dojo.setContext(iWidgetContainer.global,iWidgetContainer.doc);
			if(dojo.isIE){
				if(document._mmcreateElement && document._mmcreateElement != null)
					document.createElement = document._mmcreateElement;
				if(document._mmgetElementsByTagName	&& document._mmgetElementsByTagName != null)
					document.getElementsByTagName = document._mmgetElementsByTagName;
			}
		}
      var isHandled = false;
        //handle event
        var eventName = "on"+mode;
        var eventHandler = this._getSimpleEventHandler(eventName);
        if (eventHandler !== null ) {
            eventHandler();
            isHandled = true;
        }
        return isHandled;
   },
    _handleEventInternal: function(/*String*/eventName,iEvent){      
      //com.ibm.mm.enabler.debug.entry("iWidget._handleEventInternal",eventName,iEvent);
       if (typeof eventName == "undefined" || eventName === null) return false;

       var isHandled = false;
       var handlerFn = null;
     	    
       if (eventName.indexOf("on")===0) 
       {
           var eventHandler = this._getSimpleEventHandler(eventName);
           if (eventHandler!==null) handlerFn = eventHandler;           
       }
       if (handlerFn === null) {             
           handlerFn = this.getPublicEventHandler(eventName); 
       } 
       if (handlerFn && handlerFn !== null ){
          //com.ibm.mm.enabler.debug.log("iWidget._handleEventInternal","handlerFn:",handlerFn);
		   try {
		   	if (iEvent  && iEvent !== null) 
		   		handlerFn(iEvent);
		   	else 
		   		handlerFn();
		   }
		   catch(e){
		       com.ibm.mm.enabler.debug.error("IWidgetWrapper._handleEventInternal","widget:"+this.hubId+" eventName:"+eventName+" HandleEventException:"+e);
		   }
           isHandled = true;
       }   
      //com.ibm.mm.enabler.debug.exit("iWidget._handleEventInternal",isHandled);
       return isHandled;
   },
   getPublicEventHandler:function(/*String|Function*/eventName)
   {   
      //com.ibm.mm.enabler.debug.entry("iWidget.getPublicEventHandler",eventName);
       
       //var eventDesc = this._getHandledEvents()[eventName];
	   var eventModel = this._getPublicEvents();
	   if (eventModel == null) return null;
	   
	   var eventDesc = eventModel.find(eventName);
       if (!eventDesc) return null;
	     
	   var handlerFn = eventDesc.handlingFn;
       if (handlerFn && handlerFn != null) {
	   		var handlerObj = null;
			if (dojo.isFunction(handlerFn)) {
				handlerObj = handlerFn;
			} else {
				var scope = this._getHandlerScope(handlerFn);
				if (scope != null) {
					handlerObj = dojo.hitch(scope, handlerFn);
				}
			}
       }
      //com.ibm.mm.enabler.debug.exit("iWidget._getPublicEventHandler",handlerObj);
       return handlerObj;       
   },
   _getParent:function(){
        if (!this.parent)
		 this.parent = com.ibm.mm.iwidget.utils.getWidgetParent(this.rootElement);
 		if (typeof this.parent == "undefined" || this.parent == null ) this.parent = null;
        return this.parent;
   },
   _setParent:function(parent){
        this.parent = parent;	
   },
   getAttributes: function(){
        //Summary: returns an ManagedItemSet which provides access to the iWidget's customization attributes. 
        //          The returned ManagedItemSet will be teh same as getItemSet(iContext.constants.itemset.ATTRIBUTES).
        //          returns empty set if there's no ItemSet.Return null if iWidget customization attributes is not
        //          supported
        if ( typeof (this.widgetAttributes) == "undefined" || this.widgetAttributes == null ){
            var service = com.ibm.mashups.services.ServiceManager.getService("persistentAttributesFactoryService");
            this.widgetAttributes = service.createPersistentAttributes(this);
            
            this._loadWidgetAttributes();
        }
        return this.widgetAttributes;
    },  
    _loadDefWidgetAttributes: function(){
        //load attributes from widget XML
        // <(iw-|mm_)itemSet name="" uri="" onItemSetChanged="">
        //   <(iw-|mm_)item name="" type="" value="" description="" readOnly="false"/>
        // </(iw-|mm_)itemSet>
       //com.ibm.mm.enabler.debug.entry("iWidget:_loadDefWidgetAttributes");
        if (typeof (this.widgetDef) != "undefined" ) {
            var attributes = this.widgetDef.getAttributes();
            if (typeof attributes != "undefined" && attributes != null) {
                var attNames = attributes.getAllNames();
            
                for (var i=0; i<attNames.length; i++) {
                    var itemName = attNames[i];
                    var itemValue = attributes.getItemValue(itemName);
                
                    this.widgetAttributes._internal().setItemValue(itemName,itemValue,false, this._internalIbmModes.xml);
                }
            }
        }
       //com.ibm.mm.enabler.debug.exit("iWidget:_loadDefWidgetAttributes");
    },
    /* this can be used to support <span id="" zipcode="27511" contentURI="foo">*/
    _loadWidgetInstanceAttributesFromRootElement: function(){
      //com.ibm.mm.enabler.debug.entry("iWidget._loadWidgetInstanceAttributesFromRootElement");
       var attributes = this.rootElement.attributes;
       for (var i=0; i<attributes.length;i++) {
           var att = attributes[i];
           var value = this.rootElement.getAttribute(att.name);
            if ( typeof value != "undefined" && value != null && value != "") {
               this.widgetAttributes._internal().setItemValue(att.name,value,false, this._internalIbmModes.microformat);
              //com.ibm.mm.enabler.debug.log("iWidget._loadWidgetInstanceAttributesFromRootElement", "name:"+att.name+" value:"+value);
           }
       } 
      //com.ibm.mm.enabler.debug.exit("iWidget._loadWidgetInstanceAttributesFromRootElement");
    },
    getWidgetItemSet:function(/*String*/name){
        if ( typeof (this.widgetItemSets) == "undefined" || this.widgetItemSets == null ){
            this._loadItemSets();
        }
        var rtnVal =  this.widgetItemSets[name];
        if (typeof rtnVal == "undefined" ) 
        {rtnVal = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(parent,name);
            this.widgetItemSets[name] = rtnVal;
        }    
        return rtnVal;
    },
    _loadWidgetDefItemSets: function(){
    //com.ibm.mm.enabler.debug.entry("iWidget._loadWidgetDefItemSets");
     if (typeof (this.widgetDef) != "undefined" ) {
         var names = this.widgetDef.getAllItemSetNames();
         for ( var i = 0 ; i < names.length ; i++ ){
             var name = names[i];
             var itemSetWrapper = this.widgetDef.getItemSet(name);
             var anItemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(parent,itemSetWrapper.name,itemSetWrapper.onItemSetChanged,null,itemSetWrapper.isPrivate);
             var items = itemSetWrapper.items;
             for (var j in items) {
                 var anItem = items[j];
                 anItemSet.setItemValue(anItem.id,anItem.value,anItem.isReadOnly);
             }
             this.widgetItemSets[name] = anItemSet; 
         }
     }
    //com.ibm.mm.enabler.debug.exit("iWidget._loadWidgetDefItemSets");
   },
    _loadWidgetSharedResource: function(cb2){
        var resources = this.widgetDef.getResources();
       //com.ibm.mm.enabler.debug.entry("iWidget._loadWidgetSharedResource",resources);
		if (typeof resources != "undefined" && resources != null){
			var size = resources.length - 1;
			if (size == -1){
				cb2();
			}
			
			// css's must be loaded first for multipart
			var sortedResources = [];
			for (var x in resources) {
    		    var resource = resources[x];
                var uri = resource[iwConstants.RESOURCE.src];
                var extension =  uri.substring(uri.lastIndexOf(".")+1,uri.length);
                if ((null !== extension) && ("css" == extension)) {
                    sortedResources.unshift(resource);
                } else {
                    sortedResources.push(resource);
                }
            }
			var me = this;
			var mycb = function(i,extension,data,status){
				var self = this;
				if(data && status && extension && extension != "css"){
					self.error = "true";
					if (!self.data)self.data = [];
					self.data.push({data:data.message,status:status});					
				}
				if (size == i){
				    if (self.error && self.error == "true")
					{  
				     	dojo.query("." + me.ns + "loading", me.rootElement).forEach(function(elem){
							elem.innerHTML = "";
							var wTitle = unescape(me.getIWidgetInstance().getIDescriptorItems().getItemValue("title",dojo.locale));
							if(!wTitle) wTitle = me.widgetXMLUrl;
							var message = "";
							for (var j in self.data){
								message = message.concat(self.data[j].data).concat("\n");
							}
							com.ibm.mm.enabler.debug.logInlineMessage(elem,"error",dojo.string.substitute(me.iwMessages.E_WIDGET_DISPLAY_FAIL_2, [wTitle,message]));
						});   
						self.error = null;
						self.data = null;   
					}
					else{
						if(cb2)cb2();
					}	
				}
			}			
			
			for (var i = 0; i<sortedResources.length;i++){
                var resource = sortedResources[i];
                var name = resource[iwConstants.RESOURCE.id];
                var uri = resource[iwConstants.RESOURCE.src];
                var mimeType = resource[iwConstants.RESOURCE.mimetype];
                var callback = resource[iwConstants.RESOURCE.callback];
				var extension =  uri.substring(uri.lastIndexOf(".")+1,uri.length);
                if (typeof mimeType == "undefined" || mimeType == null){
                    mimeType = "text/plain";
                }
                if (typeof uri != "undefined" && uri != null){
						com.ibm.mashups.services.ServiceManager.getService("resourceLoadService").loadResource(this.id,null,uri,callback,mimeType,dojo.partial(mycb,i,extension));
               
                }
             }           
        }
     },
 	_createiScope:function(){
 		if (this.isModal() == false){
			var iScope = this.widgetDef.getIScope();
			var iScopeInstance = null;
			if (typeof iScope != undefined  && iScope != null)
			{
            try{
                iScopeInstance = eval("new "+iScope+"();");
                }
            catch(err){             
                com.ibm.mm.enabler.debug.log("iWidget._createiScope","iScope"+iScope,"Error",err);
            }                
			}         
			if (typeof iScopeInstance == "undefined" || iScopeInstance == null) iScopeInstance = {};
			this.iScope = iScopeInstance;
        
			dojo.global["_"+this.id+"_iContext"].scope = this.iScope;  
		}
		else{
			this.iScope = dojo.global["_"+this.id+"_iContext"].scope;
			}
       this.iScope.iContext =  dojo.global["_"+this.id+"_iContext"]; 
    },
    getIDescriptorItems:function()
    {
         if (this.iDescriptor) {
             return this.iDescriptor;
         }
         //read only for now
         this.iDescriptor = new com.ibm.mm.iwidget.itemset.iDescriptor(this.id,this.widgetDef.getIDescriptorItems(),this.getIWidgetInstance().getIDescriptorItems());
         return this.iDescriptor;
    },
	_getPublicEvents:function(){
	    //Initialize internal eventmodel for iWidgetWrapper, events data are loaded in event model
		//An associative array is passed from widget definition to widgetwrapper
		if (!this.publicEvents) {
			var events = this.widgetDef._getPublicEvents();
			var wrapperevents = {};
			for (var i in events){
				//wrapperevents[i] = events[i].clone();
				wrapperevents[i] = events[i];
			}
			this.publicEvents = new com.ibm.mm.iwidget.model.EventModelImpl(wrapperevents, this);
		}
		return this.publicEvents;		
	}, 	
	 _getPublishedEvents:function(){
	   //Todo:should remove once widgetstub is removed,backward compatibility as part of queryservice
	   //return an associative array, with reference
	   var publishedEvents =  this.getWidgetPublishedEvents();
	   var arr = {}; 
	   if (publishedEvents != null) {
		   var i=0;
		   for ( i;i<publishedEvents.length;i++){
			   arr[publishedEvents[i].name] = publishedEvents[i];		
		   }
	   }
	   return arr;
   },
   _getHandledEvents:function(){
	   //Todo: should remove once widgetStub is removed,backward compatibility as part of queryservice
	   var handledEvents =  this.getWidgetHandledEvents();
	   var arr = {}; 
	   if (handledEvents != null) {
		   var i=0;
		   for ( i;i<handledEvents.length;i++){
			   arr[handledEvents[i].name] = handledEvents[i];		
		   }
	   }
	   return arr;
   },
    getWidgetPublishedEvents:function(){
	//return a reference of event description for backward compatibility so it won't break the use case below
		var eventModel = this._getPublicEvents();
		if (eventModel && eventModel != null){
			var condition = {};
			condition["isPublished"] = "true";
			return eventModel.getEvents(condition);
		}	
		return null;	
	},
	getWidgetHandledEvents:function(){
	//return a reference of events array
		var eventModel = this._getPublicEvents();
		if (eventModel && eventModel != null){
			var condition = {};
			condition["isHandled"] = "true";
			return eventModel.getEvents(condition);
		}	
		return null;		
	},
	getPublishedEvents:function(){
		//backwardcompatibility
		if(!this.publishedEvents){
			this.publishedEvents = {};
		}
		return this.publishedEvents;
	},	
	getHandledEvents:function(){
		//backwardcompatibility
		if(!this.handledEvents){
			this.handledEvents = {};
		}
		return this.handledEvents;
	},	
    _loadWidgetAttributes: function(){
        //com.ibm.mm.enabler.debug.entry("iWidget:_loadWidgetAttributes");

       this._loadDefWidgetAttributes();
        var instanceAtt = this.getIWidgetInstance().getAttributes();
        if (instanceAtt) {
            var names = instanceAtt.getAllNames();
            for (var i=0; i<names.length; i++) {
                var name = names[i];
                var value = instanceAtt.getItemValue(name); 
                value = value.replace(/&lt;/gi, "<");
                value = value.replace(/&gt;/gi, ">");
                value = value.replace(/&amp;/gi, "&");
                this.widgetAttributes._internal().setItemValue(name,value,false, this._internalIbmModes.microformat);
            }
        }
       //com.ibm.mm.enabler.debug.exit("iWidget:_loadWidgetAttributes");
    },
    _loadItemSets: function(){
         //load only once
        //com.ibm.mm.enabler.debug.entry("iWidget._loadItemSets");
         this.widgetItemSets = {};
         // load previously parsed xml format ItemSets
         this._loadWidgetDefItemSets();

         //load itemsets from microformat defined on the html
         var instanceItemSets = this.getIWidgetInstance()._getItemSets();
         if (instanceItemSets != null) {

             for (var i in instanceItemSets) {
                 if (i == iwConstants.ATTRIBUTES || i == iwConstants.USERPROFILE || i == iwConstants.IDESCRIPTOR) {
                     continue;
                 }
                 var instanceItemSet = instanceItemSets[i];
                 var aItemSet = this.widgetItemSets[i];
                 if (typeof aItemSet == "undefined" || aItemSet == null) {
                        aItemSet = new com.ibm.mm.iwidget.itemset.DefaultItemSetImpl(this,i);
                        this.widgetItemSets[i] = aItemSet;
                 }

                 for (var j in instanceItemSet) {
                     var itemName = j;
                     var itemValue = instanceItemSet[itemName]["defaultValue"];
                     this.widgetItemSets[i].setItemValue(itemName,itemValue,false);
                 }
             }

         }  
        //com.ibm.mm.enabler.debug.exit("iWidget._loadItemSets");
      },
      _getDefaultMode:function(){
           var instanceIDescriptor = this.getIWidgetInstance().getIDescriptorItems();
           if (typeof instanceIDescriptor != "undefined" && instanceIDescriptor != null) {
               var instanceItem = instanceIDescriptor.getItemValue(iwConstants.iDescriptorItems.mode);
               if (typeof instanceItem != "undefined" ||  instanceItem != null) 
                return instanceItem; 
           }
           var defIDescriptor =  this.widgetDef.getIDescriptorItems();
           var defItem = null;
           if (typeof defIDescriptor != "undefined" && defIDescriptor != null) {
              defItem = defIDescriptor.getItemValue(iwConstants.iDescriptorItems.mode);
              if (typeof defItem == "undefined")  defItem = null;
           }
           return defItem; 
      },
      getWires:function(){
			  return this.getIWidgetInstance().getWires();
      },
	  _getMarkup:function(includeParent){
	  	//returning Markup to proxy widget stub		
		var that = this;
		function cb(node,status){			
  			that.eventSvr._publishEvent(that.eventSvr.WIDGETEVENT_PREFIX + that.id+".onMarkupReturned", node);
		}		
		var deferred =this.getMarkup();
		deferred.setIncludeParent(includeParent);
		deferred.setFinishedCallback(cb);
		deferred.start();
	  },
	  _inIframe:function(){
	  	if (this._isInIframe) return this._isInIframe;
	  	var inIframe = true;
	    if (this.eventSvr.declaredClass == "com.ibm.mm.iwidget.services.EventServiceImpl") {
		  	inIframe = false;
		}	
		this._isInIframe = inIframe;
		return this._isInIframe;	  
	  },
  	  commit:function(noSync){
	  	 var widgetInstance = this.getIWidgetInstance();
	  	  
			if (this._inIframe() == true && (!(noSync && noSync == true))){ //if it's within iframe, synchronize all the data change...
				//send attributes/wiremodel  to the stub for now...
			
				var dataObj = {};
				var instanceAttributes = widgetInstance.getAttributes();
				if (instanceAttributes && instanceAttributes._isDirty()) {
					dataObj.attributes = dojo.clone(instanceAttributes);
				}
				var wireModel = widgetInstance.getWireModel();
				if (wireModel && wireModel != null && wireModel.isDirty()) {
					dataObj.wiremodel = wireModel.toJson();
				}
				
				var payloadObj = {};
		 		payloadObj.methodname = "_handleDataSync";
		 		payloadObj.hubclient = this.hubId;
		 		payloadObj.params = [dataObj];
				//send any updates to stub widget first

				var	 id = "_stub_"+this.id;
				this.eventSvr._publishEvent(iwConstants.WIDGETEVENT_PREFIX + id,payloadObj,this.hubId);
				//here's the flow main dialog -- stub
				return;			
			
			}			
	         // need to check attribute properties and idescriptor attributes
            var instanceAttributes = widgetInstance.getAttributes();
            
            if (instanceAttributes && instanceAttributes._isDirty()) {
                this._writePropertiesToDOM(this, "attributes", instanceAttributes);
                instanceAttributes._setDirty(false);
            }
            
            var instanceIDescriptor = widgetInstance.getIDescriptorItems();
            
            if (instanceIDescriptor && instanceIDescriptor._isDirty()) {
                this._writePropertiesToDOM(this, "idescriptor", instanceIDescriptor);
                instanceIDescriptor._setDirty(false);
            }
            
            //check wires
			var wiremodel = widgetInstance.getWireModel();
			if (wiremodel && wiremodel.isDirty()){
				wiremodel.commit();
			}
	  },
	 _writePropertiesToDOM: function(widgetWrapper, itemSetName, properties) {
        var i;
        var ns = widgetWrapper.ns;
        var root = widgetWrapper.rootElement;
        
        // query the markup for the given itemSetName
        var itemSets = dojo.query('span.' + ns + 'ItemSet[title="' + itemSetName + '"]', root);
        
        // iterate through the itemsets and delete those that are already inside of the markup
        for (i = 0; i < itemSets.length; i++) {
            var itemSet = itemSets[i];
            if (root == itemSet.parentNode)
                root.removeChild(itemSet);
        }
        
        // create the new ItemSet span
        var newItemSet = document.createElement("span");
        newItemSet.className = ns + 'ItemSet';
        newItemSet.title = itemSetName;
        newItemSet.style.display = "none";
        newItemSet.style.visibility="hidden";
        
        // append it to the DOM
        root.appendChild(newItemSet);

        var names = properties.getAllNames();
        
        if (!names)
            return;
            
        // iterate through all the items in the itemset
        for (i = 0; i < names.length; i++) {			
            var itemName = names[i];
			
            var itemValue = properties._getItemValue3(itemName);
			
			
            // create the new Element
            var newItem = document.createElement("a");
            newItem.className = ns + 'Item';
            newItem.style.visibility = "hidden";
            newItem.style.display="none"
            newItem.href = "#" + itemName;
            newItem.appendChild(document.createTextNode(itemValue));
			
			var locales = properties.getItemLocales(itemName);
			for (locale in locales) {
				var langSpan = document.createElement("span");
				langSpan.setAttribute("class", ns + "Value");
				langSpan.setAttribute("lang", locale);
				var langValue = properties._getItemValue3(itemName, locale);
				langSpan.appendChild(document.createTextNode(langValue));
				newItem.appendChild(langSpan);
			}
            
            // append it to the itemset Span
            newItemSet.appendChild(newItem);
        }
    },
	getPublicEvent:function(name){
			var eventModel = this._getPublicEvents();
			return eventModel.find(name);
	},
	setModal:function(isModal){
		this._isModal = isModal;
	},
	isModal:function(){
		//indicate if this is an iframe rendered in a modal dialog
		return this._isModal? this._isModal:false;
	},
	_handleDataSync:function(payload){
		//for now it's just attributes
		//any sub window may have changed data these updates need to be sent to stub widget
		if(typeof payload.attributes != "undefined" && payload.attributes != null){
			var attributes = payload.attributes;
			this._syncModifiableProperties(attributes,this.getIWidgetInstance().getAttributes());
		}	
		if(typeof payload.idescriptors != "undefined" && payload.idescriptors != null){
			var idescriptors = payload.idescriptors;
			this._syncModifiableProperties(idescriptors,this.getIWidgetInstance().getIDescriptorItems());
		}
		if(typeof payload.wiremodel != "undefined" && payload.wiremodel != null){
			var wiremodel = payload.wiremodel;
			this._syncWireModel(wiremodel,this.getIWidgetInstance().getWireModel());
		}	
		this.commit(true);	//commit any data change in instance		
	},
	_syncModifiableProperties:function(properties,instanceProperties){
			var items = properties._items;				
			///if(properties._dirty && properties._dirty == true){ //might be hub bug, _dirty is set to be false here even though it's set to true before it gets published
				for (var i in items){
					var name = i;
					var value = items[i];
					if (typeof value != "undefined" && value != null && value == instanceProperties.DELETE_TOKEN){
						instanceProperties.removeItem(name);
					}
					else{
						instanceProperties.setItemValue(name,value);
					}
				}		
			//}			
	},
	_syncWireModel:function(wiremodel,instanceWireModel){
		var wires = wiremodel._wires;
		for (var i in wires){
				var aWire = wires[i];
				if (aWire._isDirty && aWire._type != null && aWire._type == "NEW") {
					instanceWireModel.addWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
				}
				else if (aWire._isDirty && aWire._type != null && aWire._type == "DELETE") {
					instanceWireModel.removeWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
				}	
		}
		var targets = wiremodel._targets;
		instanceWireModel._targets = targets;//simple replacement of array.		
	},
	isLoaded:function(){
		return this.loaded;
	},
	handleSizeChanged:function(payload){
		if (payload.newWidth && payload.newWidth != null){
			this.width = payload.newWidth;
		}
		if (payload.newHeight && payload.newHeight != null){
			this.height = payload.newHeight;
		}
        var aEvent = new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onSizeChanged,null,payload,null);    
     	this._handleEvent(iwConstants.EVENTS.onSizeChanged,aEvent);		
	},
	/*
	_handleStateDataRequest:function(requester){
		//gather state data and publish it
		var stateData = {};
		//just do iScope for now
	    var temp  =  dojo.global["_"+this.id+"_iContext"].iScope(); 
		
		var tempObj = {};
		if (temp.toJson) tempObj = temp.toJson();
		else{
		//no function
		//no dom node
		//no emptry object
		//no null value
		//can be serialized
		for (var i in temp){
			if (dojo.isFunction(temp[i]) != true && temp[i] != null &&(!temp[i].declaredClass )&&(!temp[i].ownerDocument)){
				if (!(dojo.isObject(temp[i]) == true && this._isEmpty(temp[i]) == true)){
					try{
						dojo.toJson(temp[i]);
						tempObj[i] = temp[i];
						}
						catch(e){
							//console.log("serialization exception:"+e);
						}
				}
				
			}
		}
			tempObj = dojo.toJson(tempObj);
		}
		stateData.iScope = tempObj;// must serialize, iscope is persisted as statedata in a serialized string
		var payloadObj = {};
		payloadObj.methodname = "_handleStateDataReceived";
		payloadObj.params = [stateData];
		this.eventSvr._publishEvent(this.eventSvr.WIDGETEVENT_PREFIX+requester,payloadObj);
	},	
	_handleStateDataReceived:function(stateData){
	//update iScope
		var iScope = dojo.global["_"+this.id+"_iContext"].iScope(); 
		iScope = dojo.mixin(iScope,dojo.fromJson(stateData.iScope)); //must deserialize
		dojo.global["_"+this.id+"_iContext"].scope = iScope;
	},*/
	setStateData:function(stateData){
		this.stateData = stateData;
		//StateData includes: widgetNavigationState
	},
	updateState:function(){
		//frameworks distribute onNavStateChanged event
		//handle onNavStateChanged Event here...
		//distribute onNavStateChanged event to iWidget
		if (this._inIframe() == false) {//do this when it's not iframed
			var navigationStateModel = com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
			var widgetAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(navigationStateModel, this.id);
			if (widgetAccessor != null) {
				var customParams = widgetAccessor.getWidgetState("cp");
				if (customParams && customParams != null) {
					//send json object to widget
					var iEvent = new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onNavStateChanged, "json", customParams);//json format
					this._handleEventInternal(iwConstants.EVENTS.onNavStateChanged, iEvent);
				}
			}
		}else{
			if (this.stateData && this.stateData != null){
				//find onNavStateChanged in iScope and pass data
					var iEvent = new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onNavStateChanged, null, this.stateData);//json format/string
					this._handleEventInternal(iwConstants.EVENTS.onNavStateChanged, iEvent);
			}			
		}    
	},
	_isEmpty:function(variable){
		for(var i in variable) { return false; }
			return true;
	},
	_handleOnNavStateChanged:function(iEvent){
		//widget fire onNavStateChanged event
		if (this._inIframe() == false) {
			var state = iEvent.payload;
			if (state && state != null) {
			//call navstate api
		    var navigationStateModel = com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
			var widgetAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(navigationStateModel,this.id);
			 widgetAccessor.setWidgetState("cp",state);
			 var deferred = navigationStateModel.commit();
     		deferred.start();	
			}
		}else{
	        var payloadObj = {};
			payloadObj.methodname = "_handleOnNavStateChanged";
			payloadObj.params = [iEvent];
			this.eventSvr._publishEvent(this.eventSvr.WIDGETEVENT_PREFIX+"_stub_"+this.id,payloadObj);
		}
	}
});	

}

if(!dojo._hasResource["com.ibm.mashups.iwidget.constants"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.iwidget.constants"] = true;
dojo.provide("com.ibm.mashups.iwidget.constants");

/**
 * com.ibm.mashups.iwidget.Constants defines all the public iwidget framework constants.<br/>
 * Each constants should be referred to as : com.ibm.mashups.iwidget.Constants.WIDGET_LOADED...
 * @ibm-spi
 */

dojo.declare("com.ibm.mashups.iwidget.Constants", null, {

   /**
	*  Enabler would publish WIDGET_LOADED event when an iwidget is loaded. <br/>
  	* <b>Event</b>: com.ibm.mashups.iwidget.Constants.WIDGET_LOADED<br/>
	* <b>Value</b>:"com.ibm.mashups.iwidget.widgetloaded"<br/>
	* <b>Payload</b>: String -- widgetid<br/>
	* For example: 
	* When event is published, a name convention is use: com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+widgetId
	* An widget could subscribe to this event by using following SPI:
	* var eventService = com.ibm.mashups.services.ServiceManager.getService("eventService");
	* eventService.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+widgetId,scopeobject,"mycallbackfn");
	* @type String
	*/ 
	WIDGET_LOADED: "com.ibm.mashups.iwidget.widgetloaded",	
	
  /**
    *  Enabler would subscribe this event and page components could publish RESIZE_WIDGET event to indicate an iwidget need to be resized.<br/>
    *  When event is published, a name convention is used: com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+"."+widgetId
	*  Page component should publish event by using following SPI:
	*  var eventService = com.ibm.mashups.services.ServiceManager.getService("eventService");
	*  eventService.publishEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+"."+widgetId,payload);
	* <b>Event</b>: com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET<br/>
	* <b>Value</b>:"com.ibm.mashups.iwidget.resizewidget"<br/>
	* <b>Payload</b>: JSON object: {"newWidth": "","newHeight": ""}<br/>
	* @type String
	*/
   	RESIZE_WIDGET: "com.ibm.mashups.iwidget.resizewidget",  


  /**
    *  Enabler would subscribe this event and page components could publish UNLOAD_WIDGETS event to unload certain widgets.<br/>
    *  For example: layout widget could publish this event to unload all the widgets on the page upon page switch<br/>
    *  When all the requested iwidgets are unloaded, enabler would publish event --com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED <br/>
	* <b>Event</b>: com.ibm.mashups.iwidget.Constants.UNLOAD_WIDGETS<br/>
	* <b>Value</b>:"com.ibm.mashups.iwidget.unloadwidgets"<br/>
	* <b>Payload</b>: an array of widget id that need to be unloaded<br/>
	* @type String
	*/
   	UNLOAD_WIDGETS: "com.ibm.mashups.iwidget.unloadwidgets",  

  /**
    *  Enabler would publish WIDGETS_UNLOADED event when requested iwidgets are  unloaded. This event is used together with com.ibm.mashups.iwidget.Constants.UNLOAD_WIDGETS.<br/>
    * <b>Event</b>: com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED<br/>
    * <b>Value</b>:"com.ibm.mashups.iwidget.widgetsunloaded"<br/>
    * <b>Payload</b>: an array of widget id that are unloaded<br/>
    * @type String
    */   
	WIDGETS_UNLOADED: "com.ibm.mashups.iwidget.widgetsunloaded", 
 /**
    *  Enabler would publish WIDGET_MODECHANGED event when requested iwidget has switched from one mode to another mode. <br/>
    * <b>Event</b>: com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED<br/>
    * <b>Value</b>:"com.ibm.mashups.iwidget.widgetmodechanged"<br/>
    * <b>Payload</b>: JSON object: {id:"",oldMode:"",newMode:""}<br/>
    * @type String
    */   
	WIDGET_MODECHANGED: "com.ibm.mashups.iwidget.widgetmodechanged" 
});

com.ibm.mashups.iwidget.Constants = new com.ibm.mashups.iwidget.Constants();

}

if(!dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapperstub"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.widget.iwidgetwrapperstub"] = true;
dojo.provide("com.ibm.mm.iwidget.widget.iwidgetwrapperstub");






dojo.declare("com.ibm.mm.iwidget.widget.IWidgetWrapperStubImpl",com.ibm.mashups.iwidget.widget.IWidgetWrapper,{
    // available from IWidgetWrapperDefaultImpl:
	// this.rootElement,this.id,this.loaded,this.ns,this.iwMessages
	// RenderController will set this.widgetDef
	PREFIX_STUB:"_stub_",
	getID:function(){
		return this.id; //need to implement all the method defined by IWidgetWrapper otherwise mixin will take the default impl in the interface!
	},	
	getIWidgetInstance: function(){
		if (typeof this.widgetInstance != "undefined" || this.widgetInstance != null) return this.widgetInstance;
			this.widgetInstance = new com.ibm.mm.iwidget.widget.IWidgetInstanceImpl(this.rootElement,this.id);
		return this.widgetInstance;
	},	
	setIWidgetDefinition:function(widgetDef){
		this.widgetDef = widgetDef;
	},
	getIWidgetDefinition:function(){
		if (this.loaded) {
			return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id,this.widgetDef);
		}
		else{
			return new com.ibm.mm.iwidget.DeferredLoadImpl(this.getIWidgetInstance().widgetXMLUrl,this.id);
		}		
	},
    getMarkup: function() {
        //return new com.ibm.mm.iwidget.DeferredLiveTextUnprocessImpl(this);
		//to do need to fix this...
		return new com.ibm.mm.iwidget.DeferredLiveTextUnprocessStubImpl(this);
    },	
	doRender:function(){
		try {
			this.subHandler = {};
    		this.eventSvr = com.ibm.mashups.services.ServiceManager.getService("eventService");
			//subscribe general event channel for the wrapper stub, this channel could be used to accept events distributed to stub
			//should be used for stub -- impl communication
			//widgetevents._stub_myrealid
			var subHandler2 =this.eventSvr.subscribeEvent(this.eventSvr.WIDGETEVENT_PREFIX + this.PREFIX_STUB+this.id, this, "handleEvent");  //subscribe eventHandler for _stub_realwidgetid 
			this.subHandler[this.PREFIX_STUB+this.id] = [];
			this.subHandler[this.PREFIX_STUB+this.id].push(subHandler2);   			
			
			var instancedata = this._getInstanceMarkup();
			
			//get default mode
			var aMode  = this._getDefaultMode();
        	if (aMode == null) aMode = iwConstants.mode_view;
        	this.currentMode = aMode;
			//get root to render iframe
			var tempDiv = document.createElement( "div" );
        	tempDiv.className = this.ns+"Content";
        	this.rootElement.appendChild(tempDiv);
        	var contentDiv = this.rootElement.lastChild;
			dojo.addClass(contentDiv,this.currentMode);
			contentDiv.visibility = "hidden"; 
			
			//use instance id to create iframe for default view
			this.windowManager[this.currentMode]= {id:this.id,root:contentDiv,active:true,main:true};
			 var navigationStateModel = com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
			var widgetAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(navigationStateModel,this.id);
			if (widgetAccessor != null) {
				var customParams = widgetAccessor.getWidgetState("cp");
			}
			this._createIframe(instancedata,contentDiv,this.id,"false",this,customParams);			
		}
		catch(e){
	       com.ibm.mm.enabler.debug.error("IWidgetWrapper.doRender","widget:"+this.id+" Creating iframe Exception:"+e);
		}  		
	},
	destroy: function () {	 
		//return subdomain
		this.eventSvr._getHubAdapter(this.id).returnSubDomain(this._getSubDomain());
		
		//notify targetwidgets source is removed.
		var wireModel = this.getIWidgetInstance().getWireModel();
		if(wireModel && wireModel != null){
			var targets = wireModel.getTargets();
		}
		if (targets && targets != null) {
			var widgetModel = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();
			for (var i in targets) {
				var widget = widgetModel.find(i);
				if (widget && widget != null) {
					var wires = widget.getIWidgetInstance().getWireModel(); // remove all the wires that contains "this.id" as source
					wires.removeWire(this.id)
					widget.commit();
				}
			}
		}
	 	 //this.eventSvr.unsubscribeEvent(this.eventServiceHandler);   
		 for (var i in this.subHandler){
		   	for (var j in this.subHandler[i]) {
				this.eventSvr.unsubscribeEvent(this.subHandler[i][j]);
			}   
		   }
  
          //this will remove hubclient and container and destroy all the subscription on the client--remove the window for default view		  
         this.eventSvr._getHubAdapter(this.id).removeIframeHubContainer(this.id);  	  
		 
		 var node = dojo.byId(this.id);//get widget node
		 if (node && node != null) {
		 	com.ibm.mm.enabler.dom.destroyNode(node);
		 }    
		 
 		 if (this.windowManager) this.windowManager = null;
        
 	},	
	update2:function(span){
		return; 
	},	
   _getParent:function(){
        if (!this.parent)
        this.parent = com.ibm.mm.iwidget.utils.getWidgetParent(this.rootElement);
		if (typeof this.parent == "undefined" || this.parent == null ) this.parent = null;
        return this.parent;
   },
   _setParent:function(parent){
        this.parent = parent;	
   }, 
	_getPublicEvents:function(){
	    //Initialize internal eventmodel for iWidgetWrapper, events data are loaded in event model
		//An associative array is passed from widget definition to widgetwrapper
		if (!this.publicEvents) {
			var events = this.widgetDef._getPublicEvents();
			var wrapperevents = {};
			for (var i in events){
				wrapperevents[i] = events[i].clone();
			}
			this.publicEvents = new com.ibm.mm.iwidget.model.EventModelImpl(wrapperevents, this.id);
		}
		return this.publicEvents;		
	}, 	
	 _getPublishedEvents:function(){
	   //Todo:should remove once widgetstub is removed,backward compatibility as part of queryservice
	   //return an associative array, with reference
	   var publishedEvents =  this.getWidgetPublishedEvents();
	   var arr = {}; 
	   if (publishedEvents != null) {
		   var i=0;
		   for ( i;i<publishedEvents.length;i++){
			   arr[publishedEvents[i].name] = publishedEvents[i];		
		   }
	   }
	   return arr;
   },
   _getHandledEvents:function(){
	   //Todo: should remove once widgetStub is removed,backward compatibility as part of queryservice
	   var handledEvents =  this.getWidgetHandledEvents();
	   var arr = {}; 
	   if (handledEvents != null) {
		   var i=0;
		   for ( i;i<handledEvents.length;i++){
			   arr[handledEvents[i].name] = handledEvents[i];		
		   }
	   }
	   return arr;
   },
    getWidgetPublishedEvents:function(){
	//return a reference of event description for backward compatibility so it won't break the use case below
		var eventModel = this._getPublicEvents();
		if (eventModel && eventModel != null){
			var condition = {};
			condition["isPublished"] = "true";
			return eventModel.getEvents(condition);
		}	
		return null;	
	},
	getWidgetHandledEvents:function(){
	//return a reference of events array
		var eventModel = this._getPublicEvents();
		if (eventModel && eventModel != null){
			var condition = {};
			condition["isHandled"] = "true";
			return eventModel.getEvents(condition);
		}	
		return null;		
	},  
    getWires:function(){
		 return this.getIWidgetInstance().getWires();
    },
	_getInstanceMarkup:function(){
		return this.getIWidgetInstance()._getInstanceMarkup();
	},
	handleEvent:function(payload){
		//console.log("receive payload:"+payload);
		var scope = payload.scope;
		if (typeof scope != "undefined" && scope != null) {
			if(scope == "instance"){
				scope = this.getIWidgetInstance();		
			}else if (scope == "eventmodel"){
				scope = this._getPublicEvents();
			}
		}
		else{
			scope = this;
		}	
		var methodname = payload.methodname;	
		if (typeof methodname != "undefined" && methodname != null) {
			if(scope[methodname] && dojo.isFunction(scope[methodname])){
				scope[methodname].apply(scope,payload.params);				
			}
		}		
	},
	_handleOnModeChange:function(payload){
		//change the mode to the new mode and create dialog in mode
		var isHandled = false;
        var oldMode = this.currentMode;        
        if (typeof payload == "undefined" || payload == null ) return false;  
        if (dojo.isString(payload)) payload = dojo.fromJson(payload);
        if (typeof payload == "undefined" || payload == null ) return false;  
		
        var newMode = payload.newMode;
        if (typeof newMode == "undefined" )  newMode = null;
        var newRoot = payload.rootElementId;
        if (typeof newRoot == "undefined" ) newRoot = null;
				
        // support one active mode only, thus don't support this operation
        if (newMode!= null && newMode == this.currentMode) return false;
        if (newMode == null) return false;
		var payloadObj = {};
		
		var currentModeWindow = this.windowManager[this.currentMode];
		if (typeof currentModeWindow != "undefined" &&  currentModeWindow != null && currentModeWindow.main == true && newRoot == null){
			//sendover to iframe and switch mode there, not popular usecase
			payloadObj.methodname = "_handleOnModeChange";//refresh
			//var aEvent = new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onModeChanged,null,{newMode:newMode});    
   			payloadObj.params = [newMode];
		   	this.eventSvr._publishEvent("widgetevents."+this.id,payloadObj);		
			return;
		}
		
		//switch from default mode  to custom mode like edit mode
		if (typeof currentModeWindow != "undefined" &&  currentModeWindow != null && currentModeWindow.main == true && newRoot != null){
			//create iframe
			var instancedata = this._getInstanceMarkup();
			//add custom mode as iDescriptor
			instancedata = this._getInstanceMarkupForMode(instancedata,newMode);
			//get state data from main frame and create new iframe with id  realwidgetid_newmode
			this._createIframe(instancedata,newRoot,this.id+"_"+newMode,"true",this);
			var oldMode = this.currentMode;
			this.currentMode = newMode;
			this.windowManager[this.currentMode]= {id:this.id+"_"+newMode,root:newRoot,active:true,main:false};	
			
		 	//tell the default mode wrapper the new mode	
			payloadObj.methodname = "_handleOnModeUpdated";
		 	payloadObj.params = [newMode];
			
         	this.eventSvr._publishEvent("widgetevents."+this.id,payloadObj);
			
			dojo.publish(com.ibm.mm.iwidget.iEvents.Constants.modeChanged,[this.id,oldMode,newMode]);
			var payload = {};
		   payload.id = this.id;
		   payload.oldMode = oldMode;
		   payload.newMode = newMode;
		   this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED,payload,this.hubId);
  
		    return;
		}
		
		//switch from custom mode to default mode (like view mode)
		var newModeOldWindow = this.windowManager[newMode];
		if (typeof newModeOldWindow != "undefined" && newModeOldWindow != null && newModeOldWindow.main == true){
		    //call onView
			
			var payloadObj = {};
			payloadObj.methodname = "_handleOnModeChange";//refresh
			//var aEvent = new com.ibm.mm.iwidget.iEventImpl(iwConstants.EVENTS.onModeChanged,null,{newMode:newMode});    
   			payloadObj.params = [newMode];
			try{
		      	this.eventSvr._publishEvent("widgetevents."+this.id,payloadObj);	
			}catch(e){
				console.log("catching exception!!!"+e);
			}				
			
			//remove the hubcontainer for edit mode
            this.eventSvr._getHubAdapter(this.id).removeIframeHubContainer(this.id+"_"+this.currentMode);
			//unsubscribe any event related to edit dialog
			try{
				for (var j in this.subHandler[this.id+"_"+this.currentMode]) {
					this.eventSvr.unsubscribeEvent(this.subHandler[this.id+"_"+this.currentMode][j]);
				}  
			}catch(e){
				console.log("IWidgetWrapperStub:_handleOnModeChange unsubscribe exception:"+e);			
			}  	  

			delete this.windowManager[this.currentMode]; //delete any window that's not main window	
			
			var oldMode = this.currentMode;
			this.currentMode = newMode;
			//todo, verify how it's used with builder
			dojo.publish(com.ibm.mm.iwidget.iEvents.Constants.modeChanged,[this.id,oldMode,newMode]);
			var payload = {};
		   payload.id = this.id;
		   payload.oldMode = oldMode;
		   payload.newMode = newMode;
		   this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.WIDGET_MODECHANGED,payload,this.hubId);
    
		}	
        return;
	},
	_getDefaultMode:function(){
           var instanceIDescriptor = this.getIWidgetInstance().getIDescriptorItems();
           if (typeof instanceIDescriptor != "undefined" && instanceIDescriptor != null) {
               var instanceItem = instanceIDescriptor[iwConstants.iDescriptorItems.mode];
               if (typeof instanceItem != "undefined" ||  instanceItem != null) 
                return instanceItem.defaultValue; 
           }
           var defIDescriptor =  this.widgetDef.getIDescriptorItems();
           var defItem = null;
           if (typeof defIDescriptor != "undefined" && defIDescriptor != null) {
              defItem = defIDescriptor[iwConstants.iDescriptorItems.mode];
              if (typeof defItem == "undefined")  defItem = null;
           }
           return defItem; 
      },
	    commit:function(noSync){
	  		//need to commit any change in iframe
		   var widgetInstance = this.getIWidgetInstance();
	         // need to check attribute properties and idescriptor attributes
           var instanceAttributes = widgetInstance.getAttributes();
		   var instanceIDescriptor = widgetInstance.getIDescriptorItems();
		   var wiremodel = widgetInstance.getWireModel();
		   var params = {};
		   if (instanceAttributes && instanceAttributes._isDirty()) {
		   		params.attributes = instanceAttributes;
		   }
		   if (instanceIDescriptor && instanceIDescriptor._isDirty()){
		   		params.idescriptors = instanceIDescriptor;
		   }
		   if (wiremodel && wiremodel.isDirty()){
		   		params.wiremodel = wiremodel.toJson();
		   } 	
		   // send events to widget  main view to handle data Sync ... 
		   if(!(noSync && noSync == true)){
		   this.eventSvr._publishEvent(this.eventSvr.WIDGETEVENT_PREFIX + this.id, {"methodname": "_handleDataSync","params":[params]},this.id);
		   }	
            if (instanceAttributes && instanceAttributes._isDirty()) {
                this._writePropertiesToDOM(this, "attributes", instanceAttributes);
                instanceAttributes._setDirty(false);
           }
            if (instanceIDescriptor && instanceIDescriptor._isDirty()) {
                this._writePropertiesToDOM(this, "idescriptor", instanceIDescriptor);
                instanceIDescriptor._setDirty(false);
            }
             //check wires
			if (wiremodel && wiremodel.isDirty()){
				wiremodel.commit();
			}
	  },
	  _writePropertiesToDOM: function(widgetWrapper, itemSetName, properties) {
        var i;
        var ns = widgetWrapper.ns;
        var root = widgetWrapper.rootElement;
        
        // query the markup for the given itemSetName
        var itemSets = dojo.query('span.' + ns + 'ItemSet[title="' + itemSetName + '"]', root);
        
        // iterate through the itemsets and delete those that are already inside of the markup
        for (i = 0; i < itemSets.length; i++) {
            var itemSet = itemSets[i];
            if (root == itemSet.parentNode)
                root.removeChild(itemSet);
        }
        
        // create the new ItemSet span
        var newItemSet = document.createElement("span");
        newItemSet.className = ns + 'ItemSet';
        newItemSet.title = itemSetName;
        newItemSet.style.display = "none";
        newItemSet.style.visibility="hidden";
        
        // append it to the DOM
        root.appendChild(newItemSet);

        var names = properties.getAllNames();
        
        if (!names)
            return;
            
        // iterate through all the items in the itemset
        for (i = 0; i < names.length; i++) {
            var itemName = names[i];
            var itemValue = properties._getItemValue3(itemName);
            
            // create the new Element
            var newItem = document.createElement("a");
            newItem.className = ns + 'Item';
            newItem.style.visibility = "hidden";
            newItem.style.display="none"
            newItem.href = "#" + itemName;
            newItem.appendChild(document.createTextNode(itemValue));
            
            // append it to the itemset Span
            newItemSet.appendChild(newItem);
        }
    },
	getPublicEvent:function(name){
			var eventModel = this._getPublicEvents();
			return eventModel.find(name);
	},	
	_getInstanceMarkupForMode:function(markup,mode){		
    	var newDiv = document.createElement("div");
		newDiv.innerHTML = markup;
		var root = newDiv.firstChild;
		root.id = this.id;
		//root.id = this.id+"_"+mode; //don't change widget id , keep it in sync so less widgets will break,widgets do cache id
        // query the markup for the given itemSetName
        var iDescriptors = dojo.query('span.' + this.ns + 'ItemSet[title="' + iwConstants.IDESCRIPTOR + '"]', root);
		var newItemSet = null;
		if (iDescriptors.length == 0){
			newItemSet = document.createElement("span");
        	newItemSet.className = this.ns + 'ItemSet';
        	newItemSet.title = iwConstants.IDESCRIPTOR;
        	newItemSet.style.display = "none";
        	newItemSet.style.visibility="hidden";b
        
        	// append it to the newDiv
        	root.appendChild(newItemSet);			
		}else{
			newItemSet = iDescriptors[0];
		}
		
		var items = dojo.query('.'+this.ns+'Item[href="#'+'mode'+'"]',newItemSet);
		for (i = 0; i < items.length; i++) {
            var item = items[i];
            if (newItemSet == item.parentNode)
                newItemSet.removeChild(item);
        }
		//create new one
		var newItem = document.createElement("a");
        newItem.className = this.ns + 'Item';
        newItem.style.visibility = "hidden";
        newItem.style.display="none"
        newItem.href = "#" + "mode";
        newItem.appendChild(document.createTextNode(mode));
		
		newItemSet.appendChild(newItem);
		//console.log("MarkupWithMode:"+newDiv.innerHTML);
		return newDiv.innerHTML;	
	},
	_createIframe:function(instancedata,root,id,isModal,wrapper,stateData){
	//render iframe here
		var that = wrapper;
		var cssUrl = wrapper.getCSSUrl();
		wrapper.subHandler[id] = [];
		function eventCallback(payload){	
			//sometime, iframe will automatically reloaded, in these paricular cases, we need to update instance markup so we don't lose any updates after widget is loaded eg. wires, attributes
			if (wrapper.isLoaded() == true&& isModal && isModal == "false"){
				wrapper.loaded = false;
				instancedata = wrapper._getInstanceMarkup();
			}	
			if (stateData && stateData != null) {
				that.eventSvr._publishEvent(that.eventSvr.WIDGETEVENT_PREFIX + id + "." + "onWidgetLoading", {
					"html": instancedata,
					"xml": that.widgetDef.widgetDef,//original parsed data
					"isModal": isModal,
					"hubId": id,
					"cssUrl": cssUrl,
					"stateData":stateData
				});
			}else{
				that.eventSvr._publishEvent(that.eventSvr.WIDGETEVENT_PREFIX + id + "." + "onWidgetLoading", {
					"html": instancedata,
					"xml": that.widgetDef.widgetDef,//original parsed data
					"isModal": isModal,
					"hubId": id,
					"cssUrl": cssUrl
				});
				
			}	
			var subHandler3 = that.eventSvr.subscribeEvent(com.ibm.mashups.iwidget.Constants.WIDGET_LOADED+"."+id, null, 
			 function( payload ) { /*onData*/
					if (isModal== "false") {
						that.loaded = true;
						// if there are any events coming from a different page, handle them
						wrapper.eventSvr._handleBroadcastEventsCache();
						dojo.query("." + that.ns + "loading", that.rootElement).forEach(function(elem){
							com.ibm.mm.enabler.dom.destroyNode(elem);
						});
						dojo.query("." + that.currentMode, that.rootElement).style({
							"visibility": "" //display:"none" will make mode selector not displaying properly	
						//set visible will work funny in FF, the node will be visible even parent node is set to be invisible		
						});
					}	
                 });
			that.subHandler[id].push(subHandler3);
			var eventHandler = that.eventSvr.subscribeEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+"."+that.id,that,"handleSizeChanged");
			that.subHandler[id].push(eventHandler);	
        }       
        	var subHandler1 = wrapper.eventSvr.subscribeEvent(wrapper.eventSvr.WIDGETEVENT_PREFIX + id+"."+"onFrameLoaded", null, eventCallback);   
			wrapper.subHandler[id].push(subHandler1);
			
			
			var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
 
     		 var url = window.location.protocol;
			 var host = window.location.hostname;
			 var serverdomain = configService.getValue(configService.SERVERDOMAIN);
			 if (typeof serverdomain != "undefined" && serverdomain != null&& serverdomain != "null") host = serverdomain;
			 var port = window.location.port;	
			 var path=window.location.pathname;	// for example "/mum/enabler"	
			 var startOfRealUrl=configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT);//get Mashup context root.. "/mum"
			 var junction = null;
			 if (path.indexOf(startOfRealUrl)>0) { //there's junciton point like http://host:8080/jp/mum/enabler
				    junction=path.slice(0,path.indexOf(startOfRealUrl)); //it will be "/jp"
        	 }
			
			if (wrapper._getSubDomain() != null) {
				var subdomain = wrapper._getSubDomain() + "." + host;
				if (port != "") 
					url += "//" + subdomain + ":" + port;
				else 
					url += "//" + subdomain;
				if (junction != null) {
					url += junction;
				}
				url += configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT_ENABLER);
				url += "/widgetsandbox";
				wrapper.eventSvr._getHubAdapter().createIframeHubContainer(id, root, url,isModal);
			}
			else{
				//throw error message
				var subDomainSize = wrapper.eventSvr._getHubAdapter().getSubDomainSize();
				 var wTitle = unescape(wrapper.getIWidgetInstance().getIDescriptorItems().getItemValue("title",dojo.locale));
			    if(!wTitle) wTitle = wrapper.getID();
				var reuseSubDomain = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.SUBDOMAINREUSE);
				var fmt = wrapper.iwMessages.E_SUBDOMAIN_NOTAVAILABLE1_2;
				if(reuseSubDomain){
					fmt = wrapper.iwMessages.E_SUBDOMAIN_NOTAVAILABLE_2;
				}
				var message = dojo.string.substitute(fmt,[wTitle,subDomainSize]);
				var nodes =  [];
        		com.ibm.mm.iwidget.utils.findElementByAttribute("class",wrapper.ns+"loading",wrapper.rootElement,nodes,false);
        		if (nodes.length > 0) {
					aNode = nodes[0];
					aNode.innerHTML = "";
					com.ibm.mm.enabler.debug.logInlineMessage(aNode, "error", message);
				}	
			}		
	},
	_getSubDomain:function(){
		if (typeof this.subDomain == "undefined" || this.subDomain == null)
		this.subDomain = this.eventSvr._getHubAdapter().getSubDomain();
		return this.subDomain;		
	},
	_handleDataSync:function(payload){
		//for now it's just attributes, handle any received data....
		//any sub window may have changed data these updates need to be sent to stub widget
		if(typeof payload.attributes != "undefined" && payload.attributes != null){
			var attributes = payload.attributes;
			this._syncModifiableProperties(attributes,this.getIWidgetInstance().getAttributes());
		}	
		if(typeof payload.wiremodel != "undefined" && payload.wiremodel != null){
			var wiremodel = payload.wiremodel;
			this._syncWireModel(wiremodel,this.getIWidgetInstance().getWireModel());
		}	
		
		this.commit(true);	//commit any change in the stub		
	},
	_syncWireModel:function(wiremodel,instanceWireModel){
		var wires = wiremodel._wires;
		for (var i in wires){
				var aWire = wires[i];
				if (aWire._isDirty && aWire._type != null && aWire._type == "NEW") {
					instanceWireModel.addWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
				}
				else if (aWire._isDirty && aWire._type != null && aWire._type == "DELETE") {
					instanceWireModel.removeWire(aWire.SourceWidget,aWire.SourceEvent,aWire.TargetEvent);
				}	
		}
		
		var targets = wiremodel._targets;
		instanceWireModel._targets = targets;//simple replacement of array.		
	},
	_syncModifiableProperties:function(properties,instanceProperties){
			var items = properties._items;				
			if(properties._dirty && properties._dirty == true){
				for (var i in items){
					var name = i;
					var value = items[i];
					if (typeof value != "undefined" && value != null && value == instanceProperties.DELETE_TOKEN){
						instanceProperties.removeItem(name);
					}
					else{
						instanceProperties.setItemValue(name,value);
					}
				}		
			}			
	},
	handleSizeChanged:function(payload){
		var currentModeWindow = this.windowManager[this.currentMode];
		var id = this.id;
		if (currentModeWindow.main == false){
			id = this.id+"_"+this.currentMode;
		}

		var root = currentModeWindow.root;
		var iframeNode = root.childNodes[0];
		if (payload.newWidth && payload.newWidth != null){
			 var width = parseInt(payload.newWidth);
			 width = width-5;
	         dojo.style(iframeNode, "width", width+"px");
		}
		if (payload.newHeight && payload.newHeight != null){
			 var height = parseInt(payload.newHeight);
			 height = height-5;
	         dojo.style(iframeNode, "height", height+"px");
	    }
		
		//publish event to current active iframe, either view iframe or edit iframe
	   	this.eventSvr._publishEvent(com.ibm.mashups.iwidget.Constants.RESIZE_WIDGET+id,payload);		
   	},
	getCSSUrl:function(){
		var that = this;
		if(this.themeCSS && this.themeCSS != null) return this.themeCSS;
		//gather all the css link elements and find theme.css or theme_rtl.css
		dojo.forEach(document.getElementsByTagName("link"), function(cssNode){
				if (cssNode.href && cssNode.href != null && cssNode.href.indexOf("theme.css") != -1 ){
					var index1 = cssNode.href.length - 9;
					if (cssNode.href.indexOf("theme.css") == index1)
					 that.themeCSS = cssNode.href;
				}
				else if (cssNode.href && cssNode.href != null && cssNode.href.indexOf("theme_rtl.css") != -1 ){
					var index2 = cssNode.href.length - 13;
					if (cssNode.href.indexOf("theme_rtl.css") == index2)
					 that.themeCSS = cssNode.href;
				}
		});
		return this.themeCSS;		
	},
	_handleOnNavStateChanged:function(iEvent){
			var state = iEvent.payload;
			if (state && state != null) {
				//call navstate api
				var navigationStateModel = com.ibm.mashups.enabler.model.state.NavigationStateModelFactory.getNavigationStateModel();
				var widgetAccessor = com.ibm.mashups.enabler.model.state.AccessorFactory.getWidgetAccessor(navigationStateModel, this.id);
				widgetAccessor.setWidgetState("cp",state);
				var deferred = navigationStateModel.commit();
				deferred.start();
			}	
	}
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.rendercontroller"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.rendercontroller"] = true;
dojo.provide("com.ibm.mm.iwidget.rendercontroller");



dojo.declare("com.ibm.mm.iwidget.RenderController",null,{
    constructor: function (widgetwrapper) { 
		this.widgetwrapper = widgetwrapper;
		this.widgetXMLUrl = this.widgetwrapper.getIWidgetInstance().widgetXMLUrl;
        this.iwStr = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwStr"); 
 
		dojo.subscribe(this.inlineMessageHandler);
    },
	render: function(){	  
        this._loadWidgetDefinition();
	},
    _resourceBaseURL: new dojo.moduleUrl("com.ibm.mm.iwidget","image/"),
    _setLoading: function(){
		//create div tag and set image
        var tempDiv = document.createElement( "div" );
        tempDiv.className = this.widgetwrapper.ns+"loading";
        if (ibmConfig && ibmConfig.loadingHTML) {
            tempDiv.innerHTML = ibmConfig.loadingHTML;
        }
        else{
            tempDiv.innerHTML = "<img alt='"+this.iwStr.LOAD+"' src='" + this._resourceBaseURL + "progress-anim.gif' />&nbsp;"+this.iwStr.LOAD; 
        }
        this.widgetwrapper.rootElement.appendChild(tempDiv); 
      },    
    _loadWidgetDefinition: function(){
        com.ibm.mm.enabler.debug.entry("iWidget.loadWidgetDefinition");
        var widgetSpan = this.widgetwrapper.rootElement;
        if (this.widgetwrapper.loaded) {
			return false;
		}        
        this._setLoading();
        if (this.widgetXMLUrl !== null) {
			//var iWidgetService = com.ibm.mashups.services.ServiceManager.getService("widgetLoadService");
			var iWidgetService = com.ibm.mashups.services.ServiceManager.getService("widgetLoadService");
			iWidgetService.getWidgetXML(this.widgetXMLUrl,false,dojo.hitch(this,"handleWidgetInfoRetrieved"),this.widgetwrapper.id);
		}
		else {
			return false;
		} // no io is involved
        com.ibm.mm.enabler.debug.entry("iWidget.loadWidgetDefinition",true);
        return true;		
	}, 
	handleWidgetInfoRetrieved:function(data,statuscode,xhr){
        com.ibm.mm.enabler.debug.entry("iWidget.handleWidgetInfoRetrieved");
		if (statuscode == "200" || statuscode == "0"){
				this.widgetwrapper.setIWidgetDefinition(data); //save widget definition
				this.widgetDef = data; 
		} else{
			//handle error			
			this._handleInlineMessage("error",dojo.string.substitute(this.widgetwrapper.iwMessages.E_IWIDGETDEF_NOTAVAILABLE_1, [this.widgetXMLUrl]),data.message);
			return;
		}		
		var isSandboxed = this.isSandboxed();
		if (dojo.isIE <7  && isSandboxed == true){
			var wTitle = unescape(this.widgetwrapper.getIWidgetInstance().getIDescriptorItems().getItemValue("title",dojo.locale));
			if(!wTitle) wTitle = this.widgetXMLUrl;
 			this._handleInlineMessage("error",dojo.string.substitute(this.widgetwrapper.iwMessages.E_NODISPLAY_UNSECUREWIDGET_1, [wTitle]));
			return;
		}
		this._doRender(isSandboxed);	
        com.ibm.mm.enabler.debug.exit("iWidget.handleWidgetInfoRetrieved",this.id);
	},
	isSandboxed:function(){
		var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
 	    var isSandboxed = configService.getValue(configService.SANDBOXENABLED);
		if (isSandboxed == false) return false;
		var myLocation = document.location + "";
        // check if it's embedding usecase, no sandbox needed if it's embedding
        /*if (myLocation.indexOf("widget:html") > -1) {
			return false;
		}*/	
		var isSandboxed = false;
		var attributes = this.widgetDef.getAttributes();
		if (typeof attributes != "undefined" && attributes != null){
			var value = attributes.getItemValue("sandbox");
			if (typeof value != "undefined" && value != null){
				if (value == "true")
				isSandboxed = true;
			}			
		}
		if (isSandboxed == false){
			//check attribute at instance level
			if (this.widgetwrapper.rootElement.getAttribute("sandbox") !== null && this.widgetwrapper.rootElement.getAttribute("sandbox") == "true") {
				isSandboxed = true;
	    	}
		}
		//check disable flag
		if (isSandboxed == true) {			
			if (this._isSandboxDisabledWidget(this.widgetXMLUrl) == true)
			isSandboxed = false;		
		}
		return isSandboxed;		
	},
	_isSandboxDisabledWidget:function(widgetDefUrl){
					var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
	var temp = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.WIDGETDEFID_SANDBOX_DISABLED);
			var disabledWidgetsList = temp;
			if (dojo.isString(disabledWidgetsList) == true) disabledWidgetsList = [temp];
			if (disabledWidgetsList.length == 0) return false;
			for (var i = 0; i < disabledWidgetsList.length; i++) {
				if (dojo.trim(widgetDefUrl) === dojo.trim(disabledWidgetsList[i])) {
					return true;
				}
				else 
					if (dojo.trim(widgetDefUrl).indexOf(dojo.trim(disabledWidgetsList[i])) != -1 && dojo.trim(disabledWidgetsList[i]).indexOf("/") != 0) {//check relative path like dataEditor/dataEditor.xml
						return true;
					}
					else 
						if (dojo.trim(widgetDefUrl).indexOf(dojo.trim(disabledWidgetsList[i])) != -1 && dojo.trim(disabledWidgetsList[i]).indexOf("/") == 0 && dojo.trim(widgetDefUrl).indexOf(":") != -1) { //check absolute path like /dataEditor/dataEditor.xml
							//make sure protocol, hostname,port match to window.location.
							var buf = widgetDefUrl.split("//");
							var protocol = buf[0];
							var buf2 = buf[1].split("/");
							var host = buf2[0];
							if (protocol == window.location.protocol && window.location.host == host) {
								return true;
							}
							else 
								if (protocol == window.location.protocol && protocol == "http:" && host.indexOf(window.location.host) == 0) {
									if (host.substr(host.indexOf(":") + 1) == "80") 
										return true;
								}
								else 
									if (protocol == window.location.protocol && protocol == "https:" && host.indexOf(window.location.host) == 0) {
										if (host.substr(host.indexOf(":") + 1) == "443") 
											return true;
									}
						}
			}
			return false;		
	},
	_handleInlineMessage:function(type,message,details){
        var nodes =  [];
        com.ibm.mm.iwidget.utils.findElementByAttribute("class",this.widgetwrapper.ns+"loading",this.widgetwrapper.rootElement,nodes,false);
        var aNode = nodes[0];
        aNode.innerHTML = "";
        com.ibm.mm.enabler.debug.logInlineMessage(aNode,type,message,details);
    },
	_doRender:function(isSandboxed){
		var eventSvr = com.ibm.mashups.services.ServiceManager.getService("eventService");

		if (isSandboxed){
			dojo.mixin(this.widgetwrapper,new com.ibm.mm.iwidget.widget.IWidgetWrapperStubImpl());			
		}
		else{
			eventSvr._getHubAdapter().createInlineHubContainer(this.widgetwrapper.id);
	    	eventSvr._getHubAdapter().createInlineHubClient(this.widgetwrapper.id);
		}
		this.widgetwrapper.doRender();
	}
});


}

if(!dojo._hasResource["com.ibm.mm.iwidget.model.widgetmodel"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.model.widgetmodel"] = true;
dojo.provide("com.ibm.mm.iwidget.model.widgetmodel");




dojo.require("com.ibm.mm.iwidget.deferred" );




dojo.declare("com.ibm.mm.iwidget.model.WidgetModelImpl",com.ibm.mashups.iwidget.model.WidgetModel,{	
	constructor:function () {         
        //subscribe to page changed event, thus it can got notified once
        //a page is updated   
		this.widgetArr = {}; //associate array since it provides direct access
		this.parentMap = {}; // maps from widget id to parent widget id
	    this.eventService = com.ibm.mashups.services.ServiceManager.getService("eventService");
       // this.queryService = com.ibm.mashups.services.ServiceManager.getService("queryService");
        //deprecated
		this.eventService.subscribeEvent("/enabler/pageChanged",this,"_unloadWidgets"); 
        dojo.subscribe( "/enabler/widgetDeleted",this,"_unloadWidgets"); //deprecated
  		this.eventService.subscribeEvent(com.ibm.mashups.iwidget.Constants.UNLOAD_WIDGETS,this,"_unloadWidgets"); 
     
		if (!ibmConfig || (ibmConfig && typeof ibmConfig.loadingHTML != "string")) {  // only preload anim gif if loadingHTML is not set
			var url = new dojo.moduleUrl("com.ibm.mm.iwidget","image/"),
			url = url+"progress-anim.gif";
        this.processAnim = com.ibm.mm.enabler.utilities.preloadImage(url,20,20);
		}	
		// for example release all the resource upon page refresh
		//todo, fix this for dojo1.3 support
		dojo.connect(window, "onunload", this, "_onWindowUnload");
		this.global = dojo.global;
		this.doc = dojo.doc;	
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
    //    this.iwMessages = dojo.i18n.getLocalization("com.ibm.mm.enabler", "iwMessages"); 
    },
	_onWindowUnload:function(){
		try {
			var arr = []
			for (i in this.widgetArr){
				this._unloadWidget(i);   //use _unloadWidget to avoid pulish event com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED
			}
		}
		catch(e){
  			console.log("_onWindowUnload "+ e.message);
		}
	},	
	createWidget: function(/*DomElment*/widgetSpan)
	{   
       // for now by design id is required attribute for each widget
        var id = widgetSpan.getAttribute("id");
        if (typeof(id) == "undefined") {
			return;
		}

        // each fragment is uniquely identified by the widget id, thus we don't 
		// support different fragment that shares the same id the old one will 
		//be deleted
        var oldWidget = this.widgetArr[id];
        if (typeof oldWidget != "undefined" && oldWidget !== null) {
            var oldfragment = oldWidget.rootElement;
            if (oldfragment == widgetSpan) { //eg. switch skin if it's the same dom node
                return oldWidget;
            } else{
                this._unloadWidget(id);
            }
        }

        var aWidget = new com.ibm.mm.iwidget.widget.IWidgetWrapperDefaultImpl(widgetSpan,id);  
        this.widgetArr[id] = aWidget;
		//this.parentMap[id] = aWidget._getParent();
		this.parentMap[id] = "DEFER_TOKEN";
	     return aWidget;  
	},	
	updateWidget: function(widgetSpan) {
 		var widget = null;
		var id = widgetSpan.getAttribute("id");
		if (id !== null) {
			widget = this.find(id);
			if (widget !== null) {
				widget.update2(widgetSpan);
			}
		}
 		return widget;		
	},	
	renderWidget: function(/*Object*/iWidget)
	{
        if (typeof iWidget == "undefined") {
			return;
		}
        if (iWidget.loaded && iWidget.loaded == true) {
            return;
        }
        var renderController = new com.ibm.mm.iwidget.RenderController(iWidget);
		renderController.render();
	},
    getWidgetById: function(/*String*/id)
    {    //deprecated
        return this.find(id);
    }, 
	find: function(/*String*/id)
    {
       var widget = this.widgetArr[id];
        if (typeof widget != "undefined" ) {
			if(widget.lazyLoad && widget.loaded == false){
				var renderController = new com.ibm.mm.iwidget.RenderController(widget);
				renderController.render();	
				delete widget.lazyLoad;			
			}
            return widget;
        }
        return null;
    },
    commit: function() {
        return new com.ibm.mm.enabler.DeferredOperationImpl(this, this._commit);
    },
    _commit: function(deferred, sync) {
        // iterate through my widgets and see whether any itemset is dirty or not.
        for (var widgetId in this.widgetArr) {
            var widgetWrapper = this.widgetArr[widgetId];
            var widgetInstance = widgetWrapper.getIWidgetInstance();
            
            if (!widgetInstance)
                continue;
			
			widgetWrapper.commit();	  
        }
    },  
    _unloadWidgets: function(/*[]*/arr)
    {
        var aWidget;
        if (typeof arr != "undefined" || arr !== null)
        {
            if (dojo.isArray(arr)) {
                for (var i in arr){
                    aWidget = arr[i]; 
                    this._unloadWidget(aWidget);                      
                }  
              	dojo.publish(com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED,[arr]);
				this.eventService.publishEvent(com.ibm.mashups.iwidget.Constants.WIDGETS_UNLOADED,arr); 
            }
            else if (dojo.isString(arr)) {
                this._unloadWidget(arr);
            }
        }
     },
    _unloadWidget:function(aWidget)
    {
		if (typeof this.widgetArr[aWidget] != "undefined" && this.widgetArr[aWidget] !== null ) {
			
				var widgetwrapper = this.widgetArr[aWidget];
				try {
					widgetwrapper.destroy();
				}
				catch(e){
					//this.LOGGER.severe("_unloadWidget",dojo.string.substitute(this.iwMessages.E_WIDGET_UNLOAD_FAIL_2, [aWidget,e.message]));
				}
				delete this.widgetArr[aWidget];
				if (this.parentMap[aWidget]) {
					delete this.parentMap[aWidget];
				}		
        } 
    },
	getParent:function(widget) {
		var parentId = this.parentMap[widget.getID()];
		if (parentId && parentId == "DEFER_TOKEN"){
			parentId = widget._getParent();
			this.parentMap[widget.getID()] = parentId;
		}
		if (parentId && parentId != null) {
			parent = this.find(parentId);
		} 
		return parent || null;
	},
	hasChildren:function(widget) {
		return (this.getChildren(widget, false).length == 0) ? false : true;
	},
	getChildren:function(widget, isNested) {
		this._checkParentMap();
		var children = [];
        var nested = (typeof isNested == "undefined") ? true : isNested;
		this._getChildren(widget, nested, children);
		return children;
	},
	_checkParentMap:function(){
		//make sure parent map is built
		for (var id in this.widgetArr){
			var parentId = this.parentMap[id];
			if (parentId && parentId == "DEFER_TOKEN"){
			var aWidget = this.widgetArr[id];
				parentId = aWidget._getParent();
				this.parentMap[id] = parentId;			
			}		
		}	
	},
	_getChildren:function(parent, nested, children) {
		// iterate parent map
		for (var id in this.parentMap) {
			// collect children
			if (this.parentMap[id] == parent.getID()) {
				var widget = this.find(id);
				if (widget != null) {
					children.push(widget);
					if (nested) {
						// collect nested children
						this._getChildren(widget, nested, children);
					}
				}
			}
		}
	},
	getWidgetDefinitionByUrl:function(url){
		return  new com.ibm.mm.iwidget.DeferredLoadImpl(url);
	},
	getAllWidgets:function(){
		return this.widgetArr;
	}
	
});

}

if(!dojo._hasResource["com.ibm.mm.iwidget.model.factory"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.iwidget.model.factory"] = true;
dojo.provide("com.ibm.mm.iwidget.model.factory");




dojo.declare("com.ibm.mm.iwidget.model.FactoryImpl",com.ibm.mashups.iwidget.model.Factory,{	
	constructor:function () {         
        	
    },	
	getGlobalWidgetModel:function(){
		if (typeof (this._globalWidgetModel) == "undefined" || this._globalWidgetModel == null){
			this._globalWidgetModel = new com.ibm.mm.iwidget.model.WidgetModelImpl();
		}
		return this._globalWidgetModel;
	}	
});
com.ibm.mashups.iwidget.model.Factory = new com.ibm.mm.iwidget.model.FactoryImpl();
iWidgetContainer = com.ibm.mashups.iwidget.model.Factory.getGlobalWidgetModel();


}

if(!dojo._hasResource["com.ibm.mm.livetext.serviceImpl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.livetext.serviceImpl"] = true;
dojo.provide("com.ibm.mm.livetext.serviceImpl");

/** 
   The implementation class of the com.ibm.mashups.livetext.serviceModel.        
   @class com.ibm.mm.livetext.serviceImpl 
   @name com.ibm.mm.livetext.serviceImpl 
   @augments com.ibm.mashups.livetext.service
  */ 
dojo.declare("com.ibm.mm.livetext.serviceImpl", null,
/** @lends com.ibm.mm.livetext.serviceImpl */
{
	_tagTypes:null,
	tagChanged:"/com/ibm/mashups/livetext/livetextchanged",
    unchangeTag: "/com/ibm/mashups/livetext/livetextunchange",
	tagStatusChange: "/com/ibm/mashups/livetext/livetextchanged",
	tagContentChanged: "/com/ibm/mashups/livetext/livetextcontentchanged",
	entryAdded: "/com/ibm/mashups/livetext/configentryadded",
	entryRemoved: "/com/ibm/mashups/livetext/configentryremoved",
	constructor:function(){
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);  
	},	

	/**
    Initiate the tag service. This should be only called once after a page is completed loaded.
    Load the livetext configuration by calling loadTags method.<b> 
	Subscribe to two event topics and prepare to catch events fired by other components.
	Publish the content changed event and start the entire document parsing.
	@returns  
	*/ 
	init: function() {
		this._loadTags(); 	
		dojo.subscribe(this.tagChanged, this, "onTagChanged");	
        dojo.subscribe(this.unchangeTag, this, "onUnchangeTag");
		dojo.subscribe(this.tagContentChanged, this, "onTagContentChanged");
		dojo.subscribe(this.entryAdded, this, "onAddConfigEntry");
		dojo.subscribe(this.entryRemoved, this, "onRemoveConfigEntry");
		dojo.publish(this.tagContentChanged, [document, true]);
	},

	/**
    The core method to query the match tags according to the matching condition defined as CSS3 selection expression. 
    If the type of the tag is defined to query the enclosed tag, then simply do one dojo query and return all the nodes.<b> 
	If the type of the tag is defined to query tags excluding the enclosed tags, then two query will be performed, the offset 
	of the two query results will be returned. The first query gets all the tags, the second query gets the tags which has nested 
	tag inside, then the difference of the two results will be returned.   
	@param {DOMNode} node the root node which will be parsed.
	@param {Object} tagType a tag type which maps to one of the configuration entries.
	@returns {Array} list of the matching tags.
	*/ 
	_getNodes: function(node, tagType) {
		if (tagType.processEnclosedTags) {
			var aNodeList = dojo.query(tagType.match, node);
			var a = [];
	    aNodeList.forEach(function(node, index, nodeList){
        a.push(node);
      });
			return a;
		}
		else {
			var aNodeList = dojo.query(tagType.match +' ' + tagType.match, node);
			var a = [];
	    aNodeList.forEach(function(node, index, nodeList){
        a.push(node);
      });
			var bNodeList = dojo.query(tagType.match, node);
			var b = [];
	    bNodeList.forEach(function(node, index, nodeList){
        b.push(node);
      });
			var anItem, bIndex;			
			while (a.length > 0) {
				anItem = a[0]; bIndex = 0;
				while (bIndex < b.length) {
					if (anItem == b[bIndex]) {
						a.splice(0,1); b.splice(bIndex, 1);	break;
					}			
					else {
						bIndex++;
					}
				}
			}
			return b;	
		}
	},

	/**
	The event handler when a tag and/or its content get changed.
	@param {DOMNode} node the root node which will be parsed.
	@param {Boolean} continueAfterException a flag indicate if the process should continue when error occurrs.
	@param {Function} preProcessCallback the callback function which will be called before nodes being processed.
	@param {Function} postProcessCallback the callback function which will be called after nodes being processed.
	@returns 
	*/ 
	onTagChanged: function(node, continueAfterException, preProcessCallback, postProcessCallback) {
		var tag = null, nextTag=null, tags= null;		
		for (var index=0; index<this._tagTypes.length;index++) {		
			tag = this._tagTypes[index];

			this._processTypeTag(node,tag, continueAfterException, preProcessCallback, postProcessCallback, true);
		}
	},
    /**
    The event handler when a tag and/or its content should be removed.
    @param {DOMNode} node the root node which will be parsed.
    @param {Boolean} continueAfterException a flag indicate if the process should continue when error occurrs.
    @param {Function} preProcessCallback the callback function which will be called before nodes being processed.
    @param {Function} postProcessCallback the callback function which will be called after nodes being processed.
    @param {Function} postUnProcessCallbcak the callback function which will be called after the content is unchanged.
    @returns 
    */ 
    onUnchangeTag: function(node, continueAfterException, preUnProcessCallback, postUnProcessCallback, unchangeCompleteCallback) {
        var tag = null, nextTag=null, tags= null;        
        for (var index=0; index<this._tagTypes.length;index++) {
            tag = this._tagTypes[index];
            this._unprocessTypeTag(node,tag, continueAfterException, preUnProcessCallback, postUnProcessCallback, false);
        }
        
        if (dojo.isFunction(unchangeCompleteCallback)) {
            unchangeCompleteCallback(node);
        }
    },

	/**
	The event handler when a tag content gets changed. The passed in DOM node will not be processed. Only its child nodes
	will be processed.
	@param {DOMNode} node the root node which will be parsed.
	@param {Boolean} continueAfterException a flag indicate if the process should continue when error occurrs.
	@param {Function} preProcessCallback the callback function which will be called before nodes being processed.
	@param {Function} postProcessCallback the callback function which will be called after nodes being processed.
	@returns 
	*/ 
	onTagContentChanged: function(node, continueAfterException, preProcessCallback, postProcessCallback){
		var tag = null, nextTag=null, tags= null;		 
		for (var index=0; index<this._tagTypes.length;index++) {
			tag = this._tagTypes[index];
			this._processTypeTag(node,tag, continueAfterException, preProcessCallback, postProcessCallback, false);
		}						   
	},

	/**
	Once a type of tags have been found, each of the same type of tags will be processed by that type of the tag processor
	class defined in the configuration. If that type of the tag processor class has not been loaded, then the tag processor will
	be loaded and a new instance of that class will be created. 
	After tag processor is created, this method will check if the passed in node should be included according to the includeRoot parameter.<b> 
	If the passed in node should be included, then the check the node against the matching condition. If condition is met, then the node will
	be included in the list of the tags being processed individually. Otherwise, only the matching tags will be processed.<b> 
	Before each tag is being processed, the preProcessCallBack function will be called. All the tags found will be passed into this callback function
	The loop in the middle of the method go through each tag in the list, using the tag processor to process each individual tag.<b> 
	After entire tags in the list get processed, the postProcessCallback function get called with exceptions which might have occurred.<b> 
	@param {DOMNode} node the root node which will be parsed.
	@param {Object} tag the tag type entry object from the configration.
	@param {Boolean} continueAfterException a flag indicate if the process should continue when error occurrs.
	@param {Function} preProcessCallback the callback function which will be called before nodes being processed.
	@param {Function} postProcessCallback the callback function which will be called after nodes being processed.
	@param {Boolean} includeRoot the flag indicate if the passed in node should be included in the process. This flag is used to differiate
	the event tag changed from tag content changed.
	@returns 
	*/ 
	_processTypeTag:function(node, tag, continueAfterException, preProcessCallback, postProcessCallback, includeRoot) {
		var tags = [];
		if (includeRoot && this._checkRoot(node, tag)) {
			tags[0] = node;
		}
		
		tags = tags.concat(this._getNodes(node, tag));
		
		var tagsforcallbackfunc = [];
		tagsforcallbackfunc = tagsforcallbackfunc.concat(tags);
		
		if (tagsforcallbackfunc.length > 0) {		
			if (tag.loaded == null){
				this._loadTagHandler(tag);
			}
			var errors = [];
			if (dojo.isFunction(preProcessCallback)) {
				try {preProcessCallback(node, tagsforcallbackfunc);} catch (error) {console.debug(error)}
			}
			
			for (var index0=0; index0<tags.length;index0++) {
				try{
					tag.tagHandler.processTag(tags[index0]);
				}catch(error){
    			     this.LOGGER.trace("_processTypeTag","processTag tag:"+tag.baseClass+" error:"+error.message);	
					errors[errors.length] = error;
					if (continueAfterException) break;			
				}				 
			}
			
			if (dojo.isFunction(postProcessCallback)) {
				try {postProcessCallback(node, tagsforcallbackfunc, errors);} catch (error) {console.debug(error)}
			}	
		}
	},
    _unprocessTypeTag: function (node, tag, continueAfterException, preUnProcessCallback, postUnProcessCallback, includeRoot) {
        var tags = [];
        if (includeRoot && this._checkRoot(node, tag)) {
            tags[0] = node;
        }
        
        tags = tags.concat(this._getNodes(node, tag));
        
        var tagsforcallbackfunc = [];
        tagsforcallbackfunc = tagsforcallbackfunc.concat(tags);
        
        var errors = [];
        if (dojo.isFunction(preUnProcessCallback)) {
            try {preUnProcessCallback(node, tagsforcallbackfunc);} catch (error) {console.debug(error)}
        }
        
        if (tagsforcallbackfunc.length > 0) {       
            if (tag.loaded == null){
                this._loadTagHandler(tag);
            }
            
            for (var index0=0; index0<tags.length;index0++) {
                try{
                    tag.tagHandler.unprocessTag(tags[index0]);
                }catch(error){
                    errors[errors.length] = error;
                    if (continueAfterException) break;          
                }                
            }
        }
        
        if (dojo.isFunction(postUnProcessCallback)) {
            try {postUnProcessCallback(node, tagsforcallbackfunc, errors);} catch (error) {console.debug(error)}
        }
    },
	/**
	The method to check individual node to see if the passed in node meet a given tag matching condition. If it does, then
	a value of true will be returned, otherwise a value of false will be returned.
	@param {DOMNode} node the DOM node to check with
	@param {Object} tag the tag type object
	@returns {Boolean} the value which indicate if the node meet the matching condition.
	*/
	_checkRoot:function(node, tag) {
		var shouldInclude = false;
		if (node != null && node.nodeType) {
			var copyOfNode = node.cloneNode(false);
			var copyNodeParent = document.createElement("div");
			copyNodeParent.appendChild(copyOfNode);
			var result = this._getNodes(copyNodeParent, tag);
			if (result != null && result.length > 0) {
				shouldInclude = true;
			}
			delete copyOfNode;
			delete copyNodeParent;
			delete result;
		}
		return shouldInclude;
	},

	/**
	This method will load the livetext framework configuration. It will first check if a livetextCfg global variable exists,
	if it does, then it assume that the global variable is the list of the tag configuration entries. This is to improve the performance
	and assume that the bootstrap will create a such javascript object.<b> 
	If it does not exist, then it will load from a configuration file. The configuration file is assumed at the same location where 
	this file is located. The format of this file is defined as the following
	
  	&nbsp;&nbsp;&nbsp;[<br/>			
    &nbsp;&nbsp;&nbsp;{"match":"*.iWidgetSkin[skin]","processEnclosedTags":true,'waitOnPreTag':true,<br/>
    &nbsp;&nbsp;&nbsp;&nbsp;"module":"tagservices", "path":"../../tagservices", "baseClass":"tagservices.skins"},<br/>		
    &nbsp;&nbsp;&nbsp;{"match":"*.mm_iWidget","processEnclosedTags":false,'waitOnPreTag':false,<br/>
    &nbsp;&nbsp;&nbsp;&nbsp;"module":"tagservices", "path":"../../tagservices", "baseClass":"tagservices.widgets"}<br/>
    &nbsp;&nbsp;&nbsp;] <p />
 	
 	match, the value of the match is the CSS3 selection expression which presents a tag (livetext) matching condition.<b> 
 	processEnclosedTags, the boolean value to indicate if the enclosed same tag should be presented in this query. a value of true will cause
 	all the tags to be processed. a value of false will make the outmost tags to be processed.<b> 
	waitOnPreTag, this is not used for 1.1, it is for the future release.
	module, the string value to indicate a javascript module which the tag processor should be loaded against.
	path, the string value to indicate the processor javascript resources.<b> 
	baseClass, the javascript class for the tag processor.	
 	@returns
	*/
	_loadTags:function() {	
		if (this._tagTypes == null) {
			var thisObj = this;
			if (typeof ibmConfig.livetextService != "undefined") {
				//if we have the livetext configuration exists as a global variable which is loaded by the bootstrap, 
				//then we will simply use it. otherwise, we load from the configuration file.
				this._tagTypes = ibmConfig.livetextService;
			}
			else {
				dojo.xhrGet({
					url: dojo.moduleUrl("com.ibm.mm.livetext", "tagservice.entries.cfg"),
					handleAs: "text",
					sync: true,
					load:function(result) {
						thisObj._tagTypes = dojo.fromJson(result);
					},
					error:function(data) {
						console.dir(data);				 	
					}
				});
			}
		}
	},

	/**
	* @param {com.ibm.mashups.livetext.configEntry} entry The entry that should be added to the configuration.
	* @returns
 	* @throws The sermantic tag service exception.	
	*/
	onAddConfigEntry: function(/* com.ibm.mashups.livetext.configEntry */ entry) {
		/* not implemented */
	},
	
				/**
	* @param {com.ibm.mashups.livetext.configEntry} entry The entry that should be removed from the configuration.
	* @returns
 	* @throws The sermantic tag service exception.	
	*/
	onRemoveConfigEntry: function(/* com.ibm.mashups.livetext.configEntry */ entry) {
		/* not implemented */		
	},		

	/**
	This method is to provide a fall back for backfoward compatibility. If a component is still using the SemTagSvc.parseDom method,
	this method will still ensure the correctness of that component but it is strongly recommended to use the event model.
 	* @param {Object} event Not used.
 	* @param {DOMNode} node The dom node to be processed.
 	  @deprecated this methid has been deprecated. Use the publish event to invoke the process of the tags.
 	  @returns
 	*/		
	parseDom:function(aEvent, node) {
		dojo.publish(this.tagChanged, [node]);
	},
	
	/**
	This method will register the tag processor module, then load the processor module and create an instance of base class.<b>
	After the tag processor is created, the flag on the tag type object will be set to true. This ensures that each tag processor will
	only have one instance and the module will be loaded only once. 
	@param {Object} tag, the tag configuration entry.<b> 
	@returns
	*/
	_loadTagHandler:function(tag) {
		 dojo.registerModulePath(tag.module, tag.path);
		 //this is to fix the stupid build tool.
		 dojo.eval("dojo.r" + "equire('" + tag.baseClass + "')");
		 var jsonStr = "{create:function(){return new " + tag.baseClass + "()}}";
		 var classCreator = dojo.fromJson(jsonStr);
		 tag.tagHandler = classCreator.create();
		 tag.loaded = true;
	}
});

}

if(!dojo._hasResource["tagservices.widgets"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["tagservices.widgets"] = true;
dojo.provide("tagservices.widgets");



dojo.declare("tagservices.widgets", null, {
	constructor:function(){
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
        this.LOG_LEVEL=com.ibm.mashups.enabler.logging.LogLevel.TRACE;
        this.bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);  
	},
    processTag: function(tag) {
		var id = tag.getAttribute("id");
		var lazyLoad = tag.getAttribute("lazyLoad");
        this.LOGGER.trace("processTag","widgets:process IWidget:"+id+ "lazyLoad:"+lazyLoad);
				
        if (typeof(id) != "undefined") {
			var iWidget = iWidgetContainer.find(id);
			if (iWidget === null) {
				// create widget
	    	    iWidget = iWidgetContainer.createWidget(tag);				
			} else {
				// update widget
				iWidgetContainer.updateWidget(tag);
			}
        	if (iWidget) {
				// render widget
				if (!lazyLoad || (lazyLoad && lazyLoad != "true")) {
					iWidgetContainer.renderWidget(iWidget);
				}
				else{
					iWidget.lazyLoad = true;
				}
			}			
		}
    },
    unprocessTag: function(tag) {
        var ns = "mm_";
        
        // search the content nodes
        var contentNodes = dojo.query("."+ns+iwConstants.CSSCLASS_INSTANCE.iwContent,tag);
        
        // iterate through them and delete them
        for (var i=0; i< contentNodes.length; i++) {
            com.ibm.mm.enabler.dom.destroyNode(  contentNodes[i] );
        }
    }
});

}

if(!dojo._hasResource["com.ibm.mashups.data.Util"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.data.Util"] = true;
dojo.provide("com.ibm.mashups.data.Util");

/**
 * Defines methods that are commonly used utilities when working with Mashups' standard data types.  
 * @ibm-api 
*/ 

dojo.declare("com.ibm.mashups.data.Util", null, {
	/**
	 * This method ensures that one cell of CSV data is properly formatted as defined by <a href="http://dojotoolkit.org/book/dojo-book-0-9/part-3-programmatic-dijit-and-dojo/what-dojo-data/available-stores/dojox-data-csv">dojox.data.CsvStore</a> with internal double-quotes doubled and external double quotes if internal double-quotes or commas.
	 * @param {String} cell The cell of data to format.
	 * @type String
	 * @return {String} Return the cell of data properly formatted.
	*/	
	encodeCSVCell:function(cell) {
		cell = "" + cell;
		var result = cell.replace(/"/g, '""');
	  if (result.indexOf(',') >= 0 || result.indexOf('"') >= 0) {
			result = '"' + result + '"';
		}
		result = result.replace(/\n/g, "");
		return result;
	},
	
	/**
	 * This method converts an object or array of objects into a CSV data string that is properly formatted as defined by <a href="http://dojotoolkit.org/book/dojo-book-0-9/part-3-programmatic-dijit-and-dojo/what-dojo-data/available-stores/dojox-data-csv">dojox.data.CsvStore</a>.
	 * @param {Object} json The object or array of objects to convert to CSV.
	 * @type String
	 * @return {String} Return the CSV data string.
	*/	
	JSONObject2CSV:function(json) {
	    if (!dojo.isArray(json)) {
	      json = [json];
	    }
	    var rowColumnName = '', rowData = '';
	    var firstKey = true;
	    for (var i = 0; i < json.length; i++) {
	      firstKey = true;
		    for (var key in json[i]) {
	  			if (key) {
				    if (i == 0) {
		          if (!firstKey) {
		  					rowColumnName += ",";
			  			}
				  		rowColumnName += this.encodeCSVCell(key);
				    }
		        if (!firstKey) {
	    				rowData += ",";
	    			}
					  rowData += this.encodeCSVCell(json[i][key]);
	        }
	        firstKey = false;
		    }
		    if (i == 0) {
		    	rowColumnName += '\n';
		    }
		    rowData += '\n';
	  	}    
	    return rowColumnName + rowData;
	},
	
	/**
	 * This method converts an object or array of objects into the Mashups' standard table data type.
	 * @param {Object} json The object or array of objects to convert to table data type.
	 * @type com.ibm.mm.data.table
	 * @return {com.ibm.mm.data.table} Return the target data formatted as the Mashups' standard table data type.
	*/	
	JSONObject2Table:function(json) {
	    var csv = this.JSONObject2CSV(json);
	    var table = new com.ibm.mm.data.table({data : csv});
	    return table;
	}
});

com.ibm.mashups.data.Util = new com.ibm.mashups.data.Util();

}

if(!dojo._hasResource["com.ibm.mm.data.exception"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.data.exception"] = true;
dojo.provide("com.ibm.mm.data.exception");

/**
   This API defines the exception which can be thrown by the semantic services during the parsing and processing
      
   A exceptionId should identify the current exception. It is a 7 character long string which uniquely identifies the 
   current abnormal condition of the parsing and processing. <p />   
   
   @author <a href="mailto:litong01@us.ibm.com">Tong Li</a>      
   @class com.ibm.mm.data.exception 
   @name com.ibm.mm.data.exception 
  */ 
dojo.declare("com.ibm.mm.data.exception", null,
/** @lends com.ibm.mm.data.exception */
{
	_exceptionId:null,
	_variable:null,
	
	/**
    * Create new instance of data exception. <p />
    *
    * @param {String} exceptionId The exception identifier.
 	* @param {Object} variable The list of the parameters to describe this error condition. This object must hold all the necessary 
 	* values to populate the exception message.  For example, a message may be defined as the following: <p />
 	*
 	* &nbsp;&nbsp;&nbsp;&nbsp;"The node ${id} does not have the necessary attribute ${attribute} or the attribute has unrecongnized values." <p/>
 	* When an exception is throw, the variable object should have members namded "id" and "attribute" respectively. Here is an example of such object <p />
 	*
 	* &nbsp;&nbsp;&nbsp;&nbsp;throw new com.ibm.mm.data.exception('E000001', {'id':100, 'attribute':'DeJaWu'});
 	*
 	* @constructs 
	*/ 
	constructor: function(/* String */exceptionId, /* Object */ variable) {
		this._exceptionId = exceptionId;
		this._variable = variable;
	},
						   
	/**
	* Retrieve locale specific description by the using the status code. This method should not cause any exception. If 
	* no locale specific message is found, then an empty string will be returned. 
 	* @param {Array} locales The list of the locales which the locale specific error should be looked up.
 	* @returns {String} The locale specific exception message.
 	*/			
	getMessage: function(/* Array */ locales) {		
		//we need to load the locale specific resource files and return the matching message.
		//Then we should replace the variables in the message with the values provided by the variable object.
		return "Not implemented";			   
	}
});

}

if(!dojo._hasResource["com.ibm.mm.data.datatypes"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.data.datatypes"] = true;
dojo.provide("com.ibm.mm.data.datatypes");

/**
 @author <a href="mailto:litong01@us.ibm.com">Tong Li</a>
 @author <a href="mailto:bizheng@cn.ibm.com">Zheng Bi</a>
 @class com.ibm.mm.data.datatypes
 @name com.ibm.mm.data.datatypes
 */




dojo.declare("com.ibm.mm.data.datatypes", null, /** @lends com.ibm.mm.data.datatypes */ {

    _alltypes: {
        'text': 1,
        'url': 1,
        'html': 1,
        'image': 1,
        'number': 1,
        'countrycode': 1,
        'languagecode': 1,
        'currency': 1,
        'boolean': 1,
        'date': 1,
        'time': 1,
        'timestamp': 1,
        'email': 1,
        'postalcode': 1,
        'phone': 1,
        'address': 1,
        'person': 1,
        'table': 1,
		'atom': 1,
		'xml': 1,
		'json': 1,
		'modeldata': 1
    },

	_simpleTypes: {
		'text': 1,
        'url': 1,
        'html': 1,
        'image': 1,
        'number': 1,
        'countrycode': 1,
        'languagecode': 1,
        'currency': 1,
        'boolean': 1,
        'date': 1,
        'time': 1,
        'timestamp': 1,
        'email': 1,
        'postalcode': 1,
        'phone': 1,
        'address': 1,
        'person': 1
	},

	_complexTypes: {
		'table': 1,
		'atom': 1,
		'xml': 1,
		'json': 1,
		'modeldata': 1
	},

	specialTypes: {
		'mashupdata':1
	},

    _mappings: {
        text: {
            'url': 1,
	        'html': 1,
	        'number': 1,
	        'countrycode': 1,
	        'languagecode': 1,
	        'currency': 1,
	        'boolean': 1,
	        'date': 1,
	        'time': 1,
	        'timestamp': 1,
	        'email': 1,
	        'postalcode': 1,
	        'phone': 1,
	        'address': 1,
	        'person': 1
        },

        'url': {},
        'html': {},
        'image': {},
        'number': {},
        'countrycode': {},
        'languagecode': {},
        'currency': {},
        'boolean': {},
        'date': {
            'timestamp': 1
        },
        'time': {
            'timestamp': 1
        },
        'timestamp': {
            'date': 1,
            'time': 1
        },
        'email': {},
        'postalcode': {},
        'phone': {},
        'address': {},
        'person': {},
        'json': {}
    },


    _SIMPLE_DATA_TYPE: 1,
    _COMBINED_DATA_TYPE: 2,
    _COMPLEX_DATA_TYPE: 3,

	resourceBundle:null,


    constructor: function(/* String */datatypecfg){
   		this.resourceBundle = dojo.i18n.getLocalization("com.ibm.mm.data", "dataTypeStrings");
    },

    addDataType: function(/* String */typename, /* String */typeCat){
		//Check type name
		if(typename === null || typeof typename == undefined) {
			return;
		}
        this._alltypes.typename = 1;
		//Check the type category
		if (typeCat === null || typeof typeCat == undefined || typeCat == this._SIMPLE_DATA_TYPE) {
			this._simpleTypes.typename = 1;
		} else {
			hthis._complexTypes.typename = 1;
		}
    },

    removeDataType: function(/* String */typename) {
        delete this._alltypes[typename];
    },

    addDataMapping: function(/* String */typename1, /* String */ typename2) {
        if (this._mappings.typename1 === null) {
            this._mappings.typename1 = {};
        }
        this._mappings[typename1][typename2] = 1;
    },

    removeDataMapping: function(/* String */typename1, /* String */ typename2) {
        if (this._mappings[typename1] !== null) {
            if (this._mappings[typename1][typename2] !== null) {
                delete this._mappings[typename1][typename2];
            }
        }
    },

    getAllTypes: function() {
        return dojo.clone(this._alltypes);
    },

    /**
	* The method to return if two types should be considered as a match.
	* It may need more work to include the combined data type mapping mechanism.
	*
	* @param {String} typename1 The first data type name(handle event)
	* @param {String} typename2 The second data type name.(publish event)<b>
	* @returns {Boolean}
	*/
	doesTypeMatch:function(/* String */ typename1, /* String */ typename2) {
		var doesItMatch = false;
		//null type does not match to any thing.
		if (typename1 === null || typename2 === null) {
		    return doesItMatch;
		}
		//date type is case-insensitive
		typename1 = typename1.toLowerCase();
		typename2 = typename2.toLowerCase();
		//if two types are same or either type is any, then they are considered as a match.
		if (typename1 == typename2 || typename1 == 'any' || typename2 == 'any') {
			doesItMatch = true;
		} else {
			//check the type of the "payload type"
			var typeOfName1 = this.checkDataType(typename1);
			switch(typeOfName1) {
				//typename1 is simple data type
				case this._SIMPLE_DATA_TYPE:
					var typeOfName2 = this.checkDataType(typename2);
					switch(typeOfName2) {
						 //Two simple data types, use the mapping to decide whether they match or not
						case this._SIMPLE_DATA_TYPE:
							if (this._mappings[typename1][typename2] == 1) {
							    doesItMatch = true;
						    }
							break;
						//Simple data type VS combine data type, compare the main type. (url.text's main type is :url)
						case this._COMBINED_DATA_TYPE:
							var mainTypeOfType2 = this.getMainType(typename2);
							if (typename1 == mainTypeOfType2 || this._mappings[typename1][mainTypeOfType2] == 1) { //url can handle url.text
								doesItMatch = true;
							}
							break;
						default:
							break;
					}//end of switch(typeOfName2) {
					break;
				//For comebined type and complex data type as received data type, currently, consider match only when type names are exactly same
				//we can add more logic here in future
				case this._COMBINED_DATA_TYPE:
				case this._COMPLEX_DATA_TYPE:
				default:
					break;
			}// enf of switch(typeOfName1)
		}
		return doesItMatch;
	},
	
	/**
	* The method to return if two types should be considered as a match with a much more flex rule 
	* on combined type: only cares about the main type
	*
	* @param {String} typename1 The first data type name(handle event)
	* @param {String} typename2 The second data type name.(publish event)<b>
	* @returns {Boolean}
	*/
	doesTypeFlexMatch:function(/* String */ typename1, /* String */ typename2) {
		var doesItMatch = false;
		//null type does not match to any thing.
		if (typename1 === null || typename2 === null) {
		    return doesItMatch;
		}
		//date type is case-insensitive
		typename1 = typename1.toLowerCase();
		typename2 = typename2.toLowerCase();
		//if two types are same or either type is any, then they are considered as a match.
		if (typename1 == typename2 || typename1 == 'any' || typename2 == 'any') {
			doesItMatch = true;
		} else {
			//check the type of the "payload type"
			var typeOfName1 = this.checkDataType(typename1);
			switch(typeOfName1) {
				//typename1 is simple data type
				case this._SIMPLE_DATA_TYPE:
					var typeOfName2 = this.checkDataType(typename2);
					switch(typeOfName2) {
						 //Two simple data types, use the mapping to decide whether they match or not
						case this._SIMPLE_DATA_TYPE:
							if (this._mappings[typename1][typename2] == 1) {
							    doesItMatch = true;
						    }
							break;
						//Simple data type VS combine data type, compare the main type. (url.text's main type is :url)
						case this._COMBINED_DATA_TYPE:
							var mainTypeOfType2 = this.getMainType(typename2);
							if (typename1 == mainTypeOfType2 || this._mappings[typename1][mainTypeOfType2] == 1 ) { //url can handle url.text
								doesItMatch = true;
							}
							break;
						default:
							break;
					}//end of switch(typeOfName2) {
					break;
				//For comebined type and complex data type as received data type, currently, consider match when they have the same mail(prefix) type
				case this._COMBINED_DATA_TYPE:
					var typeOfName2 = this.checkDataType(typename2);
					var mainTypeOfType1 = this.getMainType(typename1);
					switch(typeOfName2) {
						 //Two simple data types, use the mapping to decide whether they match or not
						case this._SIMPLE_DATA_TYPE:
							if (mainTypeOfType1 == typename2 || this._mappings[mainTypeOfType1][typename2] == 1) {
							    doesItMatch = true;
						    }
							break;
						//Simple data type VS combine data type, compare the main type. (url.text's main type is :url)
						case this._COMBINED_DATA_TYPE:
							var mainTypeOfType2 = this.getMainType(typename2);
							if (mainTypeOfType1 == mainTypeOfType2 || this._mappings[mainTypeOfType1][mainTypeOfType2] == 1 ) { //url can handle url.text
								doesItMatch = true;
							}
							break;
						default:
							break;
					}//end of switch(typeOfName2) {
				case this._COMPLEX_DATA_TYPE:
				default:
					break;
			}// end of switch(typeOfName1)
		}
		return doesItMatch;
	},
	
	/**
	 * The method to return the mail type of a combined data type. If it's not combined data type,
	 * For example:
	 * url.text will return url
	 *
	 * @param {String} typename
	 */
    getMainType: function(/* String */ typename){
        var dotPosition = typename.indexOf('.');
		if(dotPosition < 0 ) {
			return typename;
		} else {
       	    return typename.substring(0, dotPosition);
       	}
    },

    checkDataType: function(/* String */ typename){
        //Check if the type name is the format like url.text
		var typename = typename.toLowerCase();
		var types = typename.split('.');
        if (types.length == 1) { // Not combine data type
            if (this._simpleTypes[typename] == 1) {
                return this._SIMPLE_DATA_TYPE;
            } else {
                return this._COMPLEX_DATA_TYPE;
            }
        } else if(types.length == 2 || types.length == 3) {  // type like: url.text || text.countrycode || url.text.countrycode
            var prefixType = types[0];
            var suffixType = types[types.length - 1];
			//In v1.1, only support url as prefix and
            //if (this._alltypes[prefixType] == 1 && this._alltypes[suffixType] == 1)
			if (prefixType == "url" || suffixType == "languagecode" || suffixType == "countrycode") {
                return this._COMBINED_DATA_TYPE;
            } else {
                return this._COMPLEX_DATA_TYPE;
            }
        } else {
			return this._COMPLEX_DATA_TYPE;
		}
    },

    getTypeLabel: function(/* String */typename, /* String */ locale) {
    	var typename = typename.toLowerCase();
		var shownType = typename;
		var result = this.checkDataType(typename);

       	if (result==this._COMBINED_DATA_TYPE){
			var dotPosition = typename.indexOf('.');
			var main = typename.substring(0, dotPosition);
			var mainType = this.getSimpleTypeLabel(main,locale);
			var sub = typename.substring(dotPosition+1,typename.length);
			var subType = this.getSimpleTypeLabel(sub,locale);
			shownType = mainType+' ('+subType+')';
    	} else {
		    shownType = this.getSimpleTypeLabel(typename,locale);
		}
		return shownType;
    },

	/**
	 * Get the display name of the simple or complex data type. The rule here is
	 * 1. For the simple type predefined, return the display name for this locale
	 * 2. For user defined or complex data type, if it's composed with English characters, return the date type with first letter capitalized
	 * 3. Otherwise, return the original data type
	 * @param {String} typename
	 * @param {String} locale
	 */
	getSimpleTypeLabel: function(/* String */typename, /* String */ locale){
		var label;
		if(this.resourceBundle[typename]!=null) {
			label=this.resourceBundle[typename];
		} else {
			label = typename.charAt(0).toUpperCase() + typename.substring(1);
		}
		return label;
	}
});

}

if(!dojo._hasResource["com.ibm.mm.data.table"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.data.table"] = true;
dojo.provide("com.ibm.mm.data.table");



/**
   @author <a href="mailto:litong01@us.ibm.com">Tong Li</a>      
   @class com.ibm.mm.data.table 
   @name com.ibm.mm.data.table
*/ 
dojo.declare("com.ibm.mm.data.table", dojox.data.CsvStore, 
/** @lends com.ibm.mm.data.table */
{

	/*
	 * Extend CsvStore to support CSV like data
	 */
	constructor: function(/* Object */ keywordParameters){
	// summary: initializer
	// keywordParameters: {url: String}
	// keywordParameters: {data: String}
	// keywordParameters: {label: String} The column label for the column to use for the label returned by getLabel.
	// keywordParameters: {csvlike: String} support CSV like data

		if (this._isCSVLike(keywordParameters['data'])){
			keywordParameters['data'] = this._CSVLike2CSV(keywordParameters['data']);
		}
		
		//below code copied from dojox.data.CsvStore as super class's constructor is always
		//called before subclass's constructor automatically
		this._attributes = [];			// e.g. ["Title", "Year", "Producer"]
		this._attributeIndexes = {};	// e.g. {Title: 0, Year: 1, Producer: 2}
 		this._dataArray = [];			// e.g. [[<Item0>],[<Item1>],[<Item2>]]
 		this._arrayOfAllItems = [];		// e.g. [{_csvId:0,_csvStore:store},...]
		this._loadFinished = false;
		if(keywordParameters.url){
			this.url = keywordParameters.url;
		}
		this._csvData = keywordParameters.data;
		if(keywordParameters.label){
			this.label = keywordParameters.label;
		}else if(this.label === ""){
			this.label = undefined;
		}
		this._storeProp = "_csvStore";	// Property name for the store reference on every item.
		this._idProp = "_csvId"; 		// Property name for the Item Id on every item.
		this._features = {	
			'dojo.data.api.Read': true,
			'dojo.data.api.Identity': true 
		};
		this._loadInProgress = false;	//Got to track the initial load to prevent duelling loads of the dataset.
		this._queuedFetches = [];
	},
	
	_isCSVLike: function(csvlike){
		
		var data = dojo.clone(csvlike);
		
		if (dojo.isString(data) && data != null && data.length > 0){
			data = data.replace(/\n/g, "");
			var rows = data.split('|');
			if (!rows || rows.length < 2){
				return false;
			}
			
			var columnList = this._splitterCSVLikeRow(rows[0]);
			if (!columnList || columnList.length <= 0) return false;
	
			var columnLength = columnList.length;
			for (var i=1; i<rows.length; i++){
				if (rows[i] == "") {
					break;
				}
	
				var rowList = this._splitterCSVLikeRow(rows[i]);
				if (!rowList || rowList.length != columnLength) return false;
			}
	
			return true;			
		}

		return false;
	},
	
	/*
	 * Split CSV like row to cells, note CSV like cell may contain separator , | "
	 */
	_splitterCSVLikeRow: function(dataString){
		var cells = dataString.split(",");

		//handle case where cell contains ,
		var len = cells.length;
		var i, j;
		for (var m=0; m<len; m++){
			i = j = -1;
			for (var k=0; k<cells.length; k++){
				if (i == -1 && cells[k].charAt(0) == '"' && cells[k].charAt(cells[k].length - 1) != '"' ){
					i = k;
					continue;
				}
				if (i>0 && cells[k].charAt(cells[k].length - 1) == '"' && cells[k].charAt(0) != '"' ){
					j = k;
					break;
				}
			}
			
			if (i >0 && j >0){
				var str = cells[i];
				for (var k=i+1; k<j+1; k++){
					str = str + "," + cells[k];
				}

				var temp = [];
				for (var k=0; k<i; k++){
					temp.push(cells[k]);
				}
				temp.push(str);
				for (var k=j+1; k<cells.length; k++){
					temp.push(cells[k]);
				}
				cells = temp;
			}else {
				break;
			}
			
		}

		return cells;		
	},
	
	/*
	 * Convert CSV like data to CSV data
	 */
	_CSVLike2CSV: function(/* String */csvlike){
		/*
		 * There are two differences between CSV data and CSV like data
		 * 1. add CSV like data's type information to CSV column row
		 * 2. replace row separator '|' with '\n'
		 */
		
		var typeArray = ['string'];/*add possible CSV like data's type term here*/

		function _inArray(item, arrayData){
			for (var i=0; i<arrayData.length; i++){
				if (item.toUpperCase() == arrayData[i].toUpperCase()) return true;
			}
			return false;
		}
		
		function _addTypeInfo(columnList, typeList){
			if (!typeList){
				typeList = [];
				for (var i=0; i<columnList.length; i++){
					typeList.push('text');
				}
			}

			if (columnList.length != typeList.length){
				throw('Illegal CSV like data');
			}

			for (var i=0; i<columnList.length; i++){
				columnList[i] = columnList[i] + '<' + typeList[i] + '>';
			}
			
			return columnList;
		}
		
		var data = dojo.clone(csvlike);
		
		if (dojo.isString(data) && data != null && data.length > 0){

			data = data.replace(/\n/g, "");
			var rows = data.split('|');
			var csv = [];

			if (rows.length >= 2){
				var columnList = this._splitterCSVLikeRow(rows[0]);
				var typeList = this._splitterCSVLikeRow(rows[1]);
				
				var isTypeRow = true;
				for (var i=0; i<typeList.length; i++){
					if (!_inArray(typeList[i], typeArray)){
						isTypeRow = false;
						break;
					}
				}
				
				if (isTypeRow){
					columnList = _addTypeInfo(columnList, typeList);
					csv.push(columnList.join(","));
					for (var i=2; i<rows.length; i++){
						csv.push(rows[i]);
					}
				} else {
					columnList = _addTypeInfo(columnList, null/*add default text type*/);
					csv.push(columnList.join(","));
					for (var i=1; i<rows.length; i++){
						csv.push(rows[i]);
					}
				}
				
			} else{
				//only has column name row, no real data
				var columnList = this._splitterCSVLikeRow(rows[0]);
				columnList = _addTypeInfo(columnList, null/*add default text type*/);
				csv.push(columnList.join(","));
			}
			
			return csv.join("\n");
		} else {
			throw('Illegal CSV like data');
		}

	},
	
	/**
	* overwrite the attribute this._attributes and this._attributeIndexes
	* this is to make sure that the the Csv store handles the data types correctly.<b>
	* will also add this._attributeTypes for a given attribute. 
	*/
	_processData: function(/* String */ data){
		this._getArrayOfArraysFromCsvFileContents(data);
		this._processAttributeTypes();
		this._arrayOfAllItems = [];
		for(var i=0; i<this._dataArray.length; i++){
			this._arrayOfAllItems.push(this._createItemFromIdentity(i));
		}
		this._loadFinished = true;
		this._loadInProgress = false;
	},

	_processAttributeTypes: function() {
		var _newAttributes = [];
		this._attributeTypes = {};
		var anAttribute, startPos, newAttributeName;		
		var myRE = /^(\w|\s)+<(\w|(.\w)+)+>$/;
		for (index=0; index<this._attributes.length; index++) {
			anAttribute = this._attributes[index];
			if (anAttribute.match(myRE)) {
				startPos = anAttribute.indexOf("<");				
				newAttributeName = anAttribute.substring(0, startPos);
				_newAttributes[_newAttributes.length] = newAttributeName;
				this._attributeTypes[newAttributeName] = anAttribute.substring(startPos+1, anAttribute.length - 1);
				this._attributeIndexes[newAttributeName] = this._attributeIndexes[anAttribute];
				delete this._attributeIndexes[anAttribute];
			}
			else { 
				_newAttributes[_newAttributes.length] = anAttribute;
				this._attributeTypes[anAttribute] = "text";
			}
		}
		this._attributes = _newAttributes;		
	},

    /** 
    * summary:
    * Returns data type of the given *item*
    *
    * @param {Object} item The item to access attributes on.
    * @returns {String}
    */
    getValueType: function(/* Object */ item, /* String */ attribute) {
    	return this._attributeTypes[attribute];
    },
        
    /**
    * This method will serialize the data object to a JSON string of the format required by the iWidget spec:
    * To be serializable, complex payload objects must implement toJson method that returns json in format {"className":"x","json":"y"}
    * To be deserializable, complex payload objects must have a constructor with an argument that accepts the "y" json value returned from toJson
    * @returns {String}
    */
    toJson: function () {
			var obj = new Object();
			obj.className = this.declaredClass;
			var json = new Object();
			json.data = this._csvData;
			obj.json = dojo.toJson(json);
			return dojo.toJson(obj);
		},
		
    /**
    * This method will serialize the data object to a format that can be persisted. If this table has not been loaded, that is,
    * if that the fetch method has not been called, then the serialize method may not serialize the entire data set. We probaby have to
    * escape the double quotes.
    * @returns {Object} a serialized data object. For most of the data this should return a human readable string.
    */
    serialize: function () {
    	var theString = "";
    	//add all the attributes
    	var anAttrName, anItem, aValue;
    	for (index=0; index<this._attributes.length; index++) {
    		anAttrName = this._attributes[index]
    		theString += anAttrName + "<" + this._attributeTypes[anAttrName] + ">,";
    	}
		
		theString += "\n";		
		if (this._dataArray != null) {		
			for (index=0; index<this._dataArray.length;index++) {
				anItem = this._dataArray[index];
				if (anItem != null) {
					for (index0=0; index0<anItem.length;index0++) {
						aValue = anItem[index0];
						if (aValue.indexOf(",") >= 0) {
							theString += "\"" + aValue + "\",";
						}
						else {
							theString += aValue + ",";
						}
					}
					theString += "\n";
				}
			}    	
		}
		return theString;
    }
});

}

if(!dojo._hasResource["com.ibm.mm.data.xml"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.data.xml"] = true;
dojo.provide("com.ibm.mm.data.xml");



/**
   @author <a href="mailto:litong01@us.ibm.com">Tong Li</a>      
   @class com.ibm.mm.data.xml 
   @name com.ibm.mm.data.xml
*/ 
dojo.declare("com.ibm.mm.data.xml", dojox.data.XmlStore, {
	
	getValueType: function( /* Object */ item, /* String */ attribute) {
		if ('tagName' == attribute) return "text";
		if ('childNodes' == attribute) {
			if (item.element != null) {
				//all child nodes make a json object. so let's simply return json as its type.
				return "json";
				
				//in case we want to use the item type to indicate type, then we use the following code.
				var theType = item.element.getAttribute("type");
				if (theType == null) {
					return "json";
				}
				else {
					return theType;
				}
			}
		}
		var theValue = this.getValue(item, attribute);
		if (theValue instanceof dojox.data.XmlItem) {
			theType = this.getValue(theValue, "@type");
			if (theType == null) {
				theType = "text";
			}
			return theType;
		}
		else {
			return "text";
		}
	},
	
	getAttributes: function(/* item */ item) {
		//	summary:
		//		Return an array of attribute names
		// 	description:
		//		'item' must be an instance of a dojox.data.XmlItem from the store instance.
		//		tag names of child elements and XML attribute names of attributes
		//		specified to the element are returned along with special attribute
		//		names applicable to the element including "tagName", "childNodes"
		//		if the element has child elements, "text()" if the element has
		//		child text nodes, and attribute names in '_attributeMap' that match
		//		the tag name of the element.
		//	item:
		//		An XML element
		//	returns:
		//		An array of attributes found
		var element = item.element;
		var attributes = [];
		attributes.push("tagName");
		if(element.childNodes.length > 0){
			var names = {};
			var childNodes = true;
			var text = false;
			for(var i = 0; i < element.childNodes.length; i++){
				var node = element.childNodes[i];
				if (node.nodeType === 1 /*ELEMENT_NODE*/) {
					var name = node.nodeName;
					if(!names[name]){
						attributes.push(name);
						names[name] = name;
					}
					childNodes = true;
				}else if(node.nodeType === 3){
					text = true;
				}
			}
			if(childNodes){
				attributes.push("childNodes");
			}
			/*
			if(text){
				attributes.push("text()");
			}
			*/
		}
		for(var i = 0, att; i < element.attributes.length; i++){
			att = element.attributes[i].nodeName;
			if ('type' != att) {
				attributes.push(element.attributes[i].nodeName);
			}
		}
		if(this._attributeMap){
			for (var key in this._attributeMap){
				var i = key.indexOf('.');
				if(i > 0){
					var tagName = key.substring(0, i);
					if (tagName === element.nodeName){
						attributes.push(key.substring(i + 1));
					}
				}else{ // global attribute
					attributes.push(key);
				}
			}
		}
		return attributes; //array
	},
	
	serialize: function () {
		//not implemented yet.
		return "";
	}
}); 

}

if(!dojo._hasResource["com.ibm.enabler"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.enabler"] = true;
dojo.provide("com.ibm.enabler");
dojo.provide("com.ibm.enabler.aggregation.javascript");
dojo.provide("com.ibm.enabler.iw");
dojo.provide("com.ibm.enabler.xpath");
dojo.provide("com.ibm.enabler.xslt");
dojo.provide("com.ibm.enabler.services");
dojo.provide("com.ibm.enabler.debug");
dojo.provide("com.ibm.enabler.iw.eventImpl");
dojo.provide("com.ibm.enabler.utilities");
dojo.provide("com.ibm.mm.enabler.iw");


com.ibm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER = com.ibm.mm.enabler.aggregation.javascript.JAVASCRIPT_HANDLER ; 
com.ibm.enabler.iw.utils = com.ibm.mm.iwidget.utils;
com.ibm.enabler.utilities = com.ibm.mm.enabler.utilities;
com.ibm.enabler.dom = com.ibm.mm.enabler.dom;

com.ibm.enabler.xpath.evaluateXPath = com.ibm.mashups.enabler.xml.XPath.evaluateXPath;
if (com.ibm.mm.enabler.xslt){
com.ibm.enabler.xslt.getXmlHttpRequest = com.ibm.mm.enabler.xslt.getXmlHttpRequest;
com.ibm.enabler.xslt.loadXml = com.ibm.mm.enabler.xslt.loadXml;
com.ibm.enabler.xslt.loadXmlString = com.ibm.mm.enabler.xslt.loadXmlString;
com.ibm.enabler.xslt.loadXsl = com.ibm.mm.enabler.xslt.loadXsl;
com.ibm.enabler.xslt.transform = com.ibm.mm.enabler.xslt.transform; 
com.ibm.enabler.xslt.transformAndUpdate = com.ibm.mm.enabler.xslt.transformAndUpdate;  
}
com.ibm.enabler.services.CONFIG_SERVICE = com.ibm.mm.enabler.services.CONFIG_SERVICE;

com.ibm.enabler.debug.Constants = com.ibm.mm.enabler.debug.Constants;
com.ibm.enabler.debug.log = com.ibm.mm.enabler.debug.log;
com.ibm.enabler.debug.entry = com.ibm.mm.enabler.debug.entry;
com.ibm.enabler.debug.exit = com.ibm.mm.enabler.debug.exit;
com.ibm.enabler.debug.info = com.ibm.mm.enabler.debug.info;
com.ibm.enabler.debug.warn = com.ibm.mm.enabler.debug.warn;
com.ibm.enabler.debug.error = com.ibm.mm.enabler.debug.error;

dojo.declare("com.ibm.enabler.iw.iEventDescriptionImpl",com.ibm.mm.iwidget.iEventDescriptionImpl,{
    constructor:function () {
      //empty wrapper for backward compatibility
     }
});

dojo.declare("com.ibm.enabler.utilities.HttpUrl",com.ibm.mm.enabler.utilities.HttpUrl,{
    constructor:function () {
      //empty wrapper for backward compatibility
     }
});

//v2
com.ibm.mm.enabler.iw.utils = com.ibm.mm.iwidget.utils;//dataEditorWidget was using it.
com.ibm.mm.enabler.iw.iEvents = com.ibm.mm.iwidget.iEvents; //dataEditor and widget menu
dojo.declare("com.ibm.mm.enabler.iw.iEventDescriptionImpl",com.ibm.mm.iwidget.iEventDescriptionImpl,{
    constructor:function () {
      //empty wrapper for backward compatibility
     }
});

dojo.provide("com.ibm.mashups.iwidget.services");
com.ibm.mashups.iwidget.services.ServiceManager = com.ibm.mashups.services.ServiceManager;

//dynamic eventing backward compatibility for 1.1 widgets 
dojo.provide("com.ibm.mm.enabler.iw.eventImpl");







}

if(!dojo._hasResource["com.ibm.mm.enabler.encode.huffman"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.encode.huffman"] = true;
dojo.provide("com.ibm.mm.enabler.encode.huffman");
dojo.declare("com.ibm.mm.enabler.encode.huffman.HuffmanURL", null, {

    // alphabet used for base64 encoding, this is NOT the default base64 alphabet but an alphabet that only contains URL safe characters
    URL_ALPHABET : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_!",
	
	LOG_LEVEL: com.ibm.mashups.enabler.logging.LogLevel.TRACE,

    constructor: function() {
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);  
    },
    
    /** Encodes the huffman codes of the tokens in the alphabet into a stream
     * @param the target stream
     * @param the map between token and prefix
     * @param the array of tokens to encode
     */
    _encodeTokens : function(stream, nodes, tokens) {
        // iterate over all tokens
        var len = tokens.length;
        for (var i = 0; i < len; ++i) {
            // add the code for the token
            this._addBits(stream, nodes[tokens[i]].prefix);
        }
        // return the stream
        return this._encodeStream(stream);
    },

    /** Encodes the dwords in the stream into a base64 encoded string 
     * 
     * @param stream stream to encode
     * @return a string of the base64 encoded dwords
     */
    _encodeStream : function(stream) {
       // number of bytes to encode
       var len = stream.dwords.length * 4;
       // push the last dword
       if (stream.bits > 0) {
           // add the last dword
           stream.dwords.push(stream.dword);
           // update the length
           len += ((stream.bits + 0x07) >> 0x03);
           stream.bits = 0;
       }
       // compute the number of bytes and encode
       return this._encodeBase64(stream.dwords, 0, len);
    }, 

    /* Initializes the stream object 
    * @param stream the stream to be initialized
    * @return the actual stream
    */
    _initStream : function(stream) {
         // reset the masks and the current dword
         stream.dword = 0;
         stream.mask = 1;
         stream.bits = 0;
         // start with an empty array of encoded dwords
         stream.dwords = [];
         // the stream
         return stream;
    }, 

    /* Encode an array of 0/1 values that are stored in the data array into a sequence of 32 bit values stored
    * in the stream.
    * 
    * @param stream target stream that contains a dword array
    * @param data the data array of 0/1 values to be encoded
    */
    _addBits : function(stream, data) {
         // cache the data in local variables and save it back to the stream object at the end
         var mask = stream.mask, dword = stream.dword, bits = stream.bits;
         // add all bits sequentially 
         var len = data.length, off = 0;
         while (len > 0) {
             // check how many bits we can add in a batch
             var copy = Math.min(len, 0x20 - bits);
             for (var i = 0; i < copy; ++i) {
                 // add the bit
                 if (data[off + i] == 1) {
                     dword |= mask;
                 }
                 mask <<= 1;
             }
             // update
             bits += copy;
             len -= copy;
             off += copy;
             // check for an overflow
             if (bits == 0x20) {
                 // add the new word
                 stream.dwords.push(dword);
                 bits = 0;
                 mask = 1;
                 dword = 0;
             }           
         }
         // update the object
         stream.mask = mask;
         stream.bits = bits;
         stream.dword = dword;
    },

    /* Adds a single bit (0/1) to the the stream
    * @param stream target stream that contains a dword array
    * @param bit to be encoded, must be 1 or 0
    */
    _addBit : function(stream, bit) {
        // add to the dword
        if (bit == 1) {
            stream.dword |= stream.mask;
        }
        stream.mask <<= 1;
        stream.bits++;
        // check for the max mask
        if (stream.bits == 0x20) {
            // add the dword to the list
            stream.dwords.push(stream.dword);
            stream.dword = 0;
            stream.mask = 1;
            stream.bits = 0;
        }
    },

    /**  encodes the data into base64 format, the data is packed in 32bit integer values in little endian notation.
     * Offset and length refer to the actual bytes, not the dwords. */
    _encodeBase64 : function(data, off, len) {
        // cache the alphabet
        var ab = this.URL_ALPHABET;
        // starting dword and offset of the byte inside the dword
        var srcIdx = off >> 0x02;
        var shift = off & 0x03;
        // the current dword and a place holder for the next (wrapping) dword
        var value = data[srcIdx++], newValue;
        // the four 6-bit numbers that we decode from three consequtive bytes
        var c1, c2, c3, c4;
        // the resulting base64 encoding
        var result = "";
        // iterate over the range of bytes in three-byte tuples
        for (var i = len; i > 0; i -= 3) {
            /** get the next three bytes. We use direct bit operations based on the packing.
             */
            switch (shift) {
            case 0:
                // all bytes are available inside the dword
                c1 = ((value >> 0x02) & 0x3f);
                c2 = ((value << 0x04) & 0x30) | ((value >> 0x0c) & 0x0f);
                c3 = ((value >> 0x06) & 0x3c) | ((value >> 0x16) & 0x03);
                c4 = ((value >> 0x10) & 0x3f);
                // next shift
                shift = 3;
                break;
            case 1:
                // all bytes are available inside the dword
                c1 = ((value >> 0x0a) & 0x3f);
                c2 = ((value >> 0x04) & 0x30) | ((value >> 0x14) & 0x0f) ;
                c3 = ((value >> 0x0e) & 0x3c) | ((value >> 0x1e) & 0x03);
                c4 = ((value >> 0x18) & 0x3f);
                // next shift
                shift = 0;
                value = data[srcIdx++];
                break;
            case 2:
                // wrap around to the next dword
                newValue = data[srcIdx++];
                c1 = ((value >> 0x12) & 0x3f);
                c2 = ((value >> 0x0c) & 0x30) | ((value >> 0x1c) & 0x0f);
                c3 = ((value >> 0x16) & 0x3c) | ((newValue >> 0x06) & 0x03);
                c4 = (newValue & 0x3f);
                // next shift
                value = newValue;
                shift = 1;
                break;
            case 3:
                // wrap around to the next dword
                newValue = data[srcIdx++];
                c1 = ((value >> 0x1A) & 0x3f);
                c2 = ((value >> 0x14) & 0x30) | ((newValue >> 0x04) & 0x0f);
                c3 = ((newValue << 0x02) & 0x3c) | ((newValue >> 0x0e) & 0x03);
                c4 = ((newValue >> 0x08) & 0x3f);
                // next shift
                value = newValue;
                shift = 2;
                break;
            }           
            // padding
            switch (i) {
            case 1:
                c3 = 0x40;
            case 2:
                c4 = 0x40;
                break;
            }
            // construct the 4-character tuple
            result += ab.charAt(c1);
            result += ab.charAt(c2);
            result += ab.charAt(c3);
            result += ab.charAt(c4);
        }
        // return the result of the encoding process
        return result;
    },
	//decode encoded string
	//conver 4 byte into 3
	//return an array of charcode
	//first item in the array should be the right most in bit stream... 
	_decodeBase64 : function(encodedStr) {
		var ab = this.URL_ALPHABET;
		var len = encodedStr.length/4;
		var i=0;
		var array = []; //each array item contains 3 char
	    for(var j=0;j<len;j++){
		var padding = 0;
	     indexC1 = ab.indexOf(encodedStr.charAt(i++));
		 indexC2 = ab.indexOf(encodedStr.charAt(i++));
		 indexC3 = ab.indexOf(encodedStr.charAt(i++));
		 if ( indexC3 == 64 ) {padding++;}
		 indexC4 = ab.indexOf(encodedStr.charAt(i++));
		 if ( indexC4 == 64 ) {padding++}
         
         c1 = (indexC1 << 2) | (indexC2 >> 4);  //this is the last byte (from right)
         c2 = ((indexC2 & 15) << 4) | (indexC3 >> 2); //this is the middle byte
         c3 = ((indexC3 & 3) << 6) | indexC4; //this is the byte on the left
	
       	array.push(c1);
		 switch(padding){
			case 0:
				array.push(c2);
				array.push(c3);
				break;
			case 1:
				array.push(c2);
				break;
			case 2:
				break;		 
		 }
		} 
 		return array;      
    },   	
	
    /** Callback used by the sort method to compare nodes by frequency
     */ 
    _frequencyCompare : function(n1, n2) {
         return n1.frequency - n2.frequency;
    },

    /** Initializes the encoding and the prefixes of the huffman tree. The
     * method writes the tree structure as a bit sequence into the stream and 
     * initializes the node prefixes with the huffman code.
     * 
     * @param stream    the stream that contains the tree structure and the sequence of the node names
     * @param node      the current node in the tree to encode
     * @param prefix    the huffman prefix of the parent node, an array that contains 0/1 bits
     */
    _initTree : function(stream, node, prefix) {
         // iterate into the children
         if (node.left && node.right) {
             // add to the stream
             this._addBit(stream, 1);
             // recurse the left and right branch
             this._initTree(stream, node.left,  prefix.concat(0));
             this._initTree(stream, node.right, prefix.concat(1));
         } else {
             // add to the stream
             this._addBit(stream, 0);
             // this is our huffman code!
             node.prefix = prefix;
             // add this node
             stream.tokens.push(node.name);
         }
         // ok
         return stream;
    },

    _dumpTokens : function(tree, nodes) {
		var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
        if (bIsLoggable) {
			for (var i = 0; i < tree.tokens.length; ++i) {
				this.LOGGER.trace("_dumpTokens()", "[" + nodes[tree.tokens[i]].frequency + ", \"" + tree.tokens[i] + "\"]");
			}
		}   
    },

    /** Constructs the huffman tree from the token sequence
     * 
     * @param array of tokens
     * @return the URL that encodes the tokens
     */
    _buildTree : function(tokens) {
         // build a list of token frequencies
         var nodes = {};
         // iterate and fill the node map
         var len = tokens.length; 
         for (var i = len - 1; i >= 0; --i) {
             // do we know the node?
             var token = tokens[i];
             node = nodes[token];
             if (node) {
                 // increment the frequency of the node
                 node.frequency++;
             } else {
                 // construct the new token
                 node = {frequency:1, name:token};
                 // add the node
                 nodes[token] = node;
             }
         }
         // produce a sorted list based on the frequencies
         var queue = [];
         for (var node in nodes) {
             queue.push(nodes[node]);
         }
         queue.sort(this._frequencyCompare);
         // build the huffman tree
         while (queue.length > 1) {
             // remove the smallest items
             var left = queue.shift(), right = queue.shift();
             // construct the new, combined node
             queue.push({frequency: left.frequency + right.frequency, left: left, right:right});
             queue.sort(this._frequencyCompare);
         }
         // now, we have the tree, initialize its huffman codes
         var root = queue[0];
         var tree = this._initTree(this._initStream({tokens:[]}), queue.shift(), []);

         this._dumpTokens(tree, nodes);

         // serialize the tree into a prefix
         var url = this._encodeStream(tree);
         // append the tokens
         len = tree.tokens.length;
         for (i = 0; i < len; ++i) {
		 	url += "/" + com.ibm.mm.enabler.encode.huffman.ZEncoder.zEncode(tree.tokens[i]);
         }      
         // serialize the huffman codes
         url += "/" + this._encodeTokens(this._initStream({}), nodes, tokens);
         // return the url
         return url;
    },

    /**  Constructs the huffman tree from a data string an a regular expression that splits
     * the string into tokens. The delimiters are considered part of the tokens.
     * @param data the data string to split
     * @param regexStrg the regular expression string, e.g. "[\/\.<>]"
     * 
     * @return the encoded URL
     */
    _buildTreeFromRegex : function(data, regexStrg) {
         // compile the regex
         var regex = new RegExp(regexStrg, "g");
         // record the split positions
         var pos = [];
         var result;
         while ((result = regex.exec(data)) != null) {
             pos.push(result.index);
         }
         // padding
         if (pos[0] != 0) {
             pos.unshift(0);
         }
         if (pos[pos.length - 1] != data.length) {
             pos.push(data.length);
         }
         // split
         var tokens = [];
         for (result = 1; result < pos.length; ++result) {
             tokens.push(data.substring(pos[result-1], pos[result]));
         }
         // construct the URL
         return this._buildTree(tokens);
    },
    
    /** Constructs the huffman tree from the token sequence
     * 
     * @param array of tokens
     * @return the URL that encodes the tokens
     */
    createRawSchemeSpecificPartFromTokens : function(tokens) {
        return this._buildTree(tokens);
    }, 
    
    /**  Constructs the huffman tree from a data string an a regular expression that splits
     * the string into tokens. The delimiters are considered part of the tokens.
     * @param data the data string to split
     * @param regexStrg the regular expression string, e.g. "[\/\.<>]"
     * 
     * @return the encoded URL
     */
    createRawSchemeSpecificPartFromRegex : function(data, regexStrg) {
        return this._buildTreeFromRegex(data, regexStrg);
    },
	
  /** Restores data from the encoded huffman tree based on  the token sequence
        * @param  url encoded data
        * @return the data string that's decoded from huffman tree 
        */
    getDataFromHuffmanTree : function(tree) {
        return this._restoreData(tree);
    }, 	
	 _restoreData:function(tree){		
		if ( typeof tree == "undefined" || tree == null) return null;
		var i0 = tree.indexOf("/");
		var i1 = tree.lastIndexOf("/");
		if ( (i0 >=0)&& (i1 >=0)){
			var treeStream = this._decodeBase64(tree.substring(0,i0));
			var encodedToken = tree.substring(i0+1,i1).split("/");
			var codeStream = this._decodeBase64(tree.substring(i1+1));	
			//array of decoded tokens
			encodedTokens = this._decodeTokens(encodedToken);
			//build tree with token			
			var root = this._readStructure(this._convertBitToChar(treeStream),encodedTokens);
						
			var bitArr = this._convertBitToChar(codeStream);
			var retVal = "";
			while(bitArr.length>0){
				retVal = this._buildData(retVal,bitArr,root);
			}
			return retVal;		
		}
		return null;
	},
	_buildData:function(retVal,bitArr,root){
			  var found = false;
		  var node = null;
		  while(found == false){
				var bit = bitArr.shift();
				if (typeof bit == "undefined"){
					node = null;
					break;				
				}		
				node = this._getNode(bit,root);
				if ( node != null && node.token && node.token != null)
				{
					found = true;								
				}
				else if (node == null){
					found = true;
				}
				root = node;
		   }
		   if (found == true && node != null)
		   retVal = retVal.concat(node.token);
		 return retVal;
	},
	_getNode:function(bit,parent){
	//0 --left, 1--right
		var node = null;
		if (bit == 1){
			node = parent.right;		
		}else{
			node = parent.left;
		} 
		if ( typeof(node) == "undefined" || node == null) return null;
		return node;
	},
	_convertBitToChar:function(charCodeArr){
		var arr = [];
		var mask = 0x01;
		var bit = 0;
		for (var i = 0;i <charCodeArr.length; i++){
			var charCode = charCodeArr[i];
			for (var j=0;j<8;j++){
				bit = charCode & mask;
				arr.push(bit);
				charCode = (charCode >> 1); //remove 1 bit			
			}		
		}
		return arr;
	},
	_readStructure:function(charArr,encodedTokens){
	     var bit = charArr.shift();
		 var node = {};
		 if ( bit == 1 ){  // internal node
			  node.left = this._readStructure(charArr,encodedTokens);
			  node.right = this._readStructure(charArr,encodedTokens);	 
		 }
		 else{ //leaf node		 
			var token = encodedTokens.shift();
					node.token = token;					
		 }
		return node;
	},
	// an array of tokens try to zDecode it
	_decodeTokens:function(encodedToken){
		var arr = [];
		for (var i in encodedToken){
			arr.push( com.ibm.mm.enabler.encode.huffman.ZEncoder.zDecode(encodedToken[i]));		
		}
		return arr;
	}	
});

com.ibm.mm.enabler.encode.huffman.HuffmanURL = new com.ibm.mm.enabler.encode.huffman.HuffmanURL();

dojo.declare( "com.ibm.mm.enabler.encode.huffman.ZEncoder", null, {
	HEX_CHARS: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F" ],
    UNSAFE_CHARS: "$&+,/:;=?@ <>#%{}|\\^~[]`\"Z",
	
	constructor: function() {
		this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);  
    },
	
	isUnsafeChar : function(testChar) {
        if (this.UNSAFE_CHARS.indexOf(testChar) > -1 || testChar.charCodeAt(0) <= 32 || testChar.charCodeAt(0) >= 123)
            return true;
            
        return false;
    },
	
	zEncode : function(value) {
        var retVal = "";
        for (var i=0; i<value.length; ++i) {
            var currentChar = value.charAt(i);
            if (!this.isUnsafeChar(currentChar)) {
                retVal += currentChar;
                continue;
            }
            
            retVal += this.zEncodeChar(currentChar);
        }
        
        return retVal;
    },
	
	zEncodeChar : function(plainChar) {
        var magicChar = "Z";
        
        return magicChar + this.byteToHex(plainChar.charCodeAt(0));
    },
    
    byteToHex : function(byteValue) {
        var upper = Math.floor(byteValue / 16);
        var lower = byteValue % 16;
        
        return this.HEX_CHARS[upper] + this.HEX_CHARS[lower];
    },
	zDecode:function(value){
		var retVal = "";
		var magicChar = "Z";
		
		if (value.indexOf(magicChar) != -1){
		
			for ( var  i = 0;i <value.length;i++){
				var charX = value.charAt(i);
				if ( charX == magicChar){
					var hex = "0x"+value.substr(i+1,2);
					i= i+2;
					try{
						var charCode = parseInt(hex);
						retVal = retVal.concat(String.fromCharCode(charCode));	
					}
					catch(e){
						continue;
					}				
				}
				else{
					retVal = retVal.concat(value.substr(i,1)); //concat character
				}		
			}		
		}
		else{
			retVal = value;
		}
		return retVal;		
	}
});

com.ibm.mm.enabler.encode.huffman.ZEncoder = new com.ibm.mm.enabler.encode.huffman.ZEncoder();

}

if(!dojo._hasResource["com.ibm.mashups.enabler.io.multipart"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.io.multipart"] = true;
dojo.provide("com.ibm.mashups.enabler.io.multipart");
dojo.provide("com.ibm.mashups.enabler.io.XHRMultipart");
dojo.require( "com.ibm.mm.enabler.services.ConfigService" );

/**
 * Provides Dojo XHR support.  Requests are batched together via a transaction
 * concept - any XHR requests which are made between the start and end 
 * transaction calls will be batched.  If the com.ibm.mashups.multipart.correlatehosts
 * Configuration Service property is set to true, multipart requests will be 
 * split by hostname.
 * @ibm-api
 */
dojo.declare( "com.ibm.mashups.enabler.io.XHRMultipart", null,
    {
        /**
         * @private
         */
        constructor: function () {
        },
        
        /**
         * Begins a multipart transaction.  If the com.ibm.mashups.multipart.enabled
         * property is set to false, this method simply returns.
         * @type void
         */
        startTransaction: function () {
        },
        
        /**
         * Ends a multipart transaction and submits the multipart request to 
         * the server.  If the com.ibm.mashups.multipart.enabled
         * property is set to false, this method simply returns.
         * @param {Object} callback the callback funtion in the format of <code>Function(Object[] params)</code>. May be <code>null</code><br>
         * &nbsp;&nbsp;&nbsp;&nbsp;<b>Callbackparameters</b><br>
         * &nbsp;&nbsp;&nbsp;&nbsp;<code>params</code> - the parameters
         * passed into the callback
         * @param {Object[]} parameters optional array of parameters to be
         * passed on to the callback function. May be <code>null</code>
         * @type void
         */
        endTransaction: function (callback, parameters) {
	    },
		
		/**
		 * Suspends a mulitpart transaction, allowing normal XHR requests
		 * to be made.  If the com.ibm.mashups.multipart.enabled
         * property is set to false, this method simply returns.
         * @type void
		 */
		suspendTransaction: function() {
		},
		
		/**
		 * Resumes a mulitpart transaction.  If the com.ibm.mashups.multipart.enabled
         * property is set to false, this method simply returns.
         * @type void
		 */
		resumeTransaction: function() {
		},
		/**
         * Returns if there is an active multipart transaction
         * @return {Boolean} <code>true</code> if there is an active multipart 
         * transaction, <code>false</code> otherwise
         */
		isTransaction: function() {
			return new Boolean();
		}
    }
);

}

if(!dojo._hasResource["com.ibm.mashups.enabler.io.factory"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mashups.enabler.io.factory"] = true;
dojo.provide("com.ibm.mashups.enabler.io.factory");




/**
 * Interface representing the XHR multipart handler factory
 */
dojo.declare( "com.ibm.mashups.enabler.io.XHRMultipartFactory", null, {
    
    /**
     * Returns a new XHR multipart handler
     * @ibm-api
     * @type    com.ibm.mashups.enabler.io.XHRMultipart
     * @return  a new multipart handler, never <code>null</code>
     */
    create: function() {
        return new com.ibm.mashups.enabler.io.XHRMultipart();
    },
	
	/**
     * Returns if multipart is enabled on the server
     * @return {Boolean} <code>true</code> if multipart is
     * enabled, <code>false</code> otherwise
     */
    isMultipartEnabled: function() {
        return new Boolean();
    },
	
	/**
     * Returns if application widgets should be fetched in multipart requests
     * @return {Boolean} <code>true</code> if application widgets should be 
     * fetched in multipart requests, <code>false</code> otherwise
     */
    isMultipartApplicationWidgets: function() {
        return new Boolean();
    }
});

}

if(!dojo._hasResource["com.ibm.mm.enabler.io.multipart"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.io.multipart"] = true;
dojo.provide("com.ibm.mm.enabler.io.multipart");





com.ibm.mm.enabler.io = {
    urlToProxyUrl: function ( /*String*/ url, /*String?*/ proxyURI ) {
        var ret = proxyURI ? proxyURI : "/proxy";
        var protocol = "http";
        var colon = url.indexOf('://');
        if(colon > -1) {
            protocol = url.substring(0, colon);
            url = url.substring(colon + 3);
        }
        url = url.replace(/:/g, '%3A');
        
        return ret + '/' + protocol + '/' + url;
    }
};

(function(){
    // unique (arbitrary) boundary
    var boundary = new String("{EB2F8DA2-5B2C-F66A-CDD0-A2D42143F5AC}");
    var newL = new String("\r\n");
    var sep = new String("--");
    var startB = newL + sep + boundary + newL;          
    var endB = sep + boundary + sep + newL;
    
    // used to capture the header
    var headerRegx= new RegExp(newL + "\s*([^\r]*)\s*", "mg");
    var headerPartsRegx = /\s*([^:]*):\s*(.+)/;
    
    // used to find the boundary
    var boundaryRegx = /boundary\s*=\s*\"?([^\"]*)\"?/;
    
    var partHandler = function(partArgs, responsePart, ioArgs, partHeaders) {
		for (x in partArgs) {
        var work = dojo.hitch(partArgs[x], 
            function(){
				try {
                    if(responsePart instanceof Error) {
                        if(this.error) this.error(responsePart, ioArgs, partHeaders);
                    }
                    else {
                        if(this.load) this.load(responsePart, ioArgs, partHeaders);
                    }
                    // always call the handle function if it exists
                    if(this.handle) this.handle(responsePart, ioArgs, partHeaders);
				} catch(err) {
				    // make one attempt to call the error handler
					try {
					   if(this.error) this.error(responsePart, ioArgs, partHeaders);
					} catch(err2) {
					   //noop
					}
				}
            });
            work();
        }
    }
    
    dojo.mixin(com.ibm.mm.enabler.io, {
        handleMultiPartResponse: function(parts, multipartParts, response, ioArgs) {
            // Getting the Content-Type header from the response, and extract
            // the boundary string
            var boundMatch = ioArgs.xhr.getResponseHeader("Content-Type").match(boundaryRegx);
            if(!boundMatch) throw new Error("No boundary specified in Content-Type response header");
            var bound = boundMatch[1];
            // build a regx from the response boundary string used to split the parts
            var splitterRegx = new RegExp(newL + sep + bound, "mg");
            
            var respParts = response.split(splitterRegx);
            
            // if handleAs is xml, it comes as text so build it using the domUtilities
            
            // iterate through the response parts, handling the callbacks for each
			var mpHandler = null;
            if (multipartParts) {
                mpHandler = new com.ibm.mm.enabler.io.XHRMultipartImpl();
                mpHandler.startTransaction();
            }
			
			var i = 1;
            for (var current in parts) {
                var requestArgs = parts[current];
                var part = respParts[i++];
                var partHeaders = {};
                var header = null;				
                var statusCodeText = null;
				var contentType = null;
				
                headerRegx.lastIndex = 0;
                // extract the headers for this part, stopping at the blank line
                while((header = headerRegx.exec(part)) != null && (header[1].length > 0)) {
					// ensure bad headers are not allowed through
					if (-1 == header[1].indexOf(":")) {
                        continue;
                    }

                    if (-1 == header[1].indexOf("digest=")) {
                        var headerParts = header[1].match(headerPartsRegx);
                        partHeaders[headerParts[1]] = headerParts[2];
                        if (headerParts[1] == "X-Status-Code") {
                            statusCodeText = headerParts[2];
						} else if (headerParts[1] == "Content-Type") {
                            contentType = headerParts[2];
                        }
                    }
                }
                
                part = dojo.string.trim(part.substr(headerRegx.lastIndex + newL.length));
				var partString = part;
                
                if(requestArgs[0].handleAs == "xml") {
                    // create document object from text string
                    part = com.ibm.mm.enabler.dom.createDocument(part);
                }
                else {
                    // call the appropriate content handler for this part
                    part = dojo._contentHandlers[requestArgs[0].handleAs]({responseText: part});
                }
                
				// Set the appropriate status code
                var statusCode = parseInt(statusCodeText);
                var xhrWrapper = new com.ibm.mm.enabler.io.XHRWrapper(ioArgs, 
				    partString, statusCode, contentType);
				var xhr = ioArgs.xhr;
                ioArgs.xhr = xhrWrapper;
				
                partHandler(requestArgs, part, ioArgs, partHeaders);
				ioArgs.xhr = xhr;
            }
			if (multipartParts) {
                mpHandler.endTransaction();
            }
        },
        
        multiPartXhr: function( /*String*/ method, /*dojo.__XhrArgs*/ args, /*Array*/ parts, multipartParts) {
            // summary: Sends a request with a multi-part body (and content type) to
            //      the server.  Uses dojo.xhr functions under the covers, so the args
            //      object has the same structure as what those functions expect.
            //      The main difference is that this function builds the raw post or put
            //      data automatically from the parts array.  Each item in the parts array
            //      is an object which is a subset of the dojo.__XhrArgs type.  The callbacks
            //      should be specified per part as this function will provide a general
            //      callback that parses the multi-part response and calls the callback
            //      associated with that response part provided in the parts array.
            // method: String specifying the HTTP method used.  Must be either POST or PUT.
            //      Default is POST.
            // args: dojo.__XhrArgs specifying how this XHR should be handled.  The following
            //      properties are not used since they do not make sense in this context -
            //          [form, handle, load, content, handleAs]
            // parts: Array the multiple parts to use to build the multi-part request body.
            //      Each item in the array should be an object with these properties -
            //          {
            //              headers: Object key-value map which is used to write out a
            //                  section at the top of this part in the form key: value.
            //                  Example could be Content-Type of this part of the multi-part
            //                  request.
            //              data: String text to write out the body of this part
            //              load: function(response, ioArgs){} callback called where
            //                  the response body is the body of the part associated this
            //                  request part
            //              error: function(response, ioArgs){} callback called when
            //                  a failure occurs either in the transmission or from the
            //                  server
            //              handle: function(response, ioArgs){} callback called at the
            //                  end of this request with either the response or an error
            //                  if one occured
            //              handleAs: String value indicating how the response body of this
            //                  part should be handled
            //          }
            // returns: Deferred object which can be used to attach additional callbacks to
            
            var body = "";
            var headersStr = null;
			for (var current in parts) {
                var part = parts[current][0];
                part.handleAs = part.handleAs ? part.handleAs.toLowerCase() : "text";
                headersStr = "";
                for(var x in part.headers) {
                    headersStr += x + ": " + part.headers[x] + newL;
                }
                body += startB + headersStr + newL;
                if(part.data && part.data.length > 1) {
                    body += part.data + newL;
                } else if(part.postData && part.postData.length > 1) {
                    body += part.postData + newL;
                } else if (part.putData && part.putData.length > 1) {
                    body += part.putData + newL;
                }
            }
            
            body += endB;
            
            // if method is PUT, leave it be; otherwise set it to POST
            if(method.toUpperCase() != "PUT") method = "POST";
            
            var xhrArgs = dojo.mixin({}, args, {
                load: dojo.partial(com.ibm.mm.enabler.io.handleMultiPartResponse, parts, multipartParts), 
                error: function(response, ioArgs) {
                    dojo.forEach(parts, function(part){
                        partHandler(part, response, ioArgs, null);
                    });
                },
                headers: {
                    "Content-type": 'multipart/mixed; boundary="' + boundary + '"'
                },
                handleAs: "text",
                form: null,
                content: null,
                postData: null,
                putData: null
            });
            
            xhrArgs[method.toLowerCase() + "Data"] = body;
            
            return dojo.xhr(method, xhrArgs, true);
        }
    });
})();

dojo.declare("com.ibm.mm.enabler.io.XHRWrapper", null, {
    constructor: function(ioArgs, partString, statusCode, contentType){
        this.ioArgs = ioArgs;
        this.xhr = ioArgs.xhr;
        this.readyState = ioArgs.xhr.readyState;
        this.responseText = partString;
        this.responseXML = ioArgs.xhr.responseXML;
        this.status = statusCode;
        this.statusText = ioArgs.xhr.statusText;
		this.contentType = contentType;
    },
    
    getAllResponseHeaders: function(){
        return this.xhr.getAllResponseHeaders();
    },
    
    getInterface: function(){
        return this.xhr.getInterface();
    },
    
    getResponseHeader: function(header){
		if (new String(header).toLowerCase() == "content-type") {
            return(this.contentType);
        }
        return this.xhr.getResponseHeader(header);
    }
});


dojo.declare( "com.ibm.mm.enabler.io.XHRMultipartImpl", com.ibm.mashups.enabler.io.XHRMultipart,
    {
		LOG_LEVEL: com.ibm.mashups.enabler.logging.LogLevel.TRACE,
		
		statics: {semaphore: 0, digest: null, suspendedXhr: null},
		
        constructor: function () {
			this.LOGGER = com.ibm.mashups.enabler.logging.Logger.getLogger(this.declaredClass);
			var LOG_METHOD = "constructor()";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD);
            }
            this.method = "POST";
            this.partsArray = null;
            var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
            this.correlateHosts = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.MULTIPART_CORRELATE_HOSTS);
            this.correlatedHosts = null;
			this.privateUrl = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT) +
                configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PRIVATE);
            this.publicUrl = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTEXT_ROOT) +
                configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.CONTENTHANDLER_PUBLIC);
            this.doSiteMap = true;
            this.serviceMPJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(
                [com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MODEL, com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MULTIPART]);
            this.serviceSMJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(
                [com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MODEL, com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_HUFFMAN]);
            this.doMultipart = com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled();
			this.urlMaxLength = 2000;
            
			if (bIsLoggable) {
                this.LOGGER.trace(LOG_METHOD, "Multipart is enabled - ${0}", this.doMultipart);
                this.LOGGER.exiting(LOG_METHOD);
            }
        },
		
		suspendTransaction: function() {
            if (0 == this.statics.semaphore) {
                return;
            }

            if (null != this.statics.suspendedXhr) {
                return;
            }

            this.statics.suspendedXhr = dojo.xhr;
            dojo.xhr = this.statics.oldXhr;
		},

		resumeTransaction: function() {
            if (0 == this.statics.semaphore) {
                return;
            }

            if (null == this.statics.suspendedXhr) {
                return;
            }

            dojo.xhr = this.statics.suspendedXhr;
            this.statics.suspendedXhr = null;
		},
        
        startTransaction: function () {
			var LOG_METHOD = "startTransaction()";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD);
            }
			
            if (!this.doMultipart) {
				if (bIsLoggable) {
                    this.LOGGER.exiting(LOG_METHOD);
                }
                return;
            }

            this._acquire();

            // return if another handler is in use
            if (1 < this.statics.semaphore) {
                if (bIsLoggable) {
                    this.LOGGER.exiting(LOG_METHOD);
                }
                return;
            }
			
            if (this.correlateHosts) {
                this.correlatedHosts = new com.ibm.mm.enabler.ArrayMap();
            } else {
                this.partsArray = new Array();
            }

            this.statics.oldXhr = dojo.xhr;

            dojo.xhr = dojo.hitch(this, function(/* String */ method, /* dojo.__XhrArgs */ args, /* Boolean */ hasBody) {
				var LOG_METHOD = "mp - dojo.hitch()";
                var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
                if (bIsLoggable) {
                    this.LOGGER.entering(LOG_METHOD, [method, args, hasBody]);
                }
                
                if (args.sync) {
                    this.statics.oldXhr(method, args, hasBody);
                    if (bIsLoggable) {
                        this.LOGGER.exiting(LOG_METHOD);
                    }
                    return;
                }
                
                // Create a header for our method
                var _targetURL = new com.ibm.mm.enabler.utilities.HttpUrl ( args.url );
                var contentIdHeader = _targetURL.getParameter("uri");
                
                if (this.doSiteMap && method != "GET") {
                    this.doSiteMap = false;
                } else if (this.doSiteMap && (method == "GET") && 
				           (contentIdHeader) && (null !== contentIdHeader)) {
                    this.doSiteMap = false; 
                }
                
                args.method = method;

                if (this.correlateHosts) {
                    var proxyURL = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
                    var server = _targetURL.server;
                    if (null !== proxyURL) {
                        proxyURL += "/";
                        if (args.url.indexOf(proxyURL) == 0) {
                            var index = args.url.indexOf("/", proxyURL.length);
                            server = args.url.substring(0, index);
                        }
                    }
                    var _partsArray = this.correlatedHosts.get(server); 
                    if (null == _partsArray) {
                        _partsArray = new Array();
                        this.correlatedHosts.put(server, _partsArray);
                    }
                    this._addToPartsArray(_partsArray, args);
                } else {
					this._addToPartsArray(this.partsArray, args);
                }
				
				if (bIsLoggable) {
                    this.LOGGER.exiting(LOG_METHOD);
                }
            });
			
			if (bIsLoggable) {
               this.LOGGER.exiting(LOG_METHOD);
            }
        },
		isTransaction: function() {
            return (0 < this.statics.semaphore);
        },
		
		_encodeUrl: function (url, escapeExclamations) {
			if (escapeExclamations) {
            	return escape(url).replace(/\+/g,'%2B').replace(/%20/g, '+').replace(/\*/g, '%2A').replace(/\//g, '%2F').replace(/@/g, '%40').replace(/%21/g, '!');
			}
            return escape(url).replace(/\+/g,'%2B').replace(/%20/g, '+').replace(/\*/g, '%2A').replace(/\//g, '%2F').replace(/@/g, '%40');
        },
		
		_createHuffmanUrl: function (parts) {
			var LOG_METHOD = "_createHuffmanUrl(parts)";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD, [parts]);
            }
            var cxml = this._createSiteMap(parts);
            if (bIsLoggable) {
                this.LOGGER.trace(LOG_METHOD, 'sitemap:  ${0}', cxml);
            }
            
            cxml = com.ibm.mm.enabler.encode.huffman.HuffmanURL.createRawSchemeSpecificPartFromRegex(cxml, "[/\. ]");
            if (bIsLoggable) {
                this.LOGGER.trace(LOG_METHOD, 'huffman encoded:  ${0}', cxml);
            }
            // encode appropriately
			var url;
            if (this.serviceSMJson.template.indexOf('{uri_code}') != -1) {
                cxml = this._encodeUrl(cxml, true);
                if (bIsLoggable) {
                    this.LOGGER.trace(LOG_METHOD, 'code is a parameter, encoding:  ${0}', cxml);
                }
				url = this.serviceSMJson.template.replace(/{uri_code}/, cxml);
            } else {
				url = this.serviceSMJson.template.replace(/{code}/, cxml);
			}
			
            if (bIsLoggable) {
                this.LOGGER.exiting(LOG_METHOD, url);
            }
			return url;
		},

        
        endTransaction: function (multipartParts, callback, parameters) {
			var LOG_METHOD = "endTransaction(callback, parameters)";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD, [multipartParts, callback, parameters]);
            }
            if (!this.doMultipart) {
				if (bIsLoggable) {
                    this.LOGGER.exiting(LOG_METHOD);
                }
                return;
            }
			
			this._release();

            // return if another handler is in use
            if (0 < this.statics.semaphore) {
                if (bIsLoggable) {
                    this.LOGGER.exiting(LOG_METHOD);
                }
                return;
            }
			
			if (bIsLoggable) {
				this.LOGGER.trace(LOG_METHOD, "Putting back the XHR");
			}
            dojo.xhr = this.statics.oldXhr;
			var doMultipartParts = false;
            if (multipartParts !== undefined) {
                doMultipartParts = multipartParts;
            }
			
            if (this.correlateHosts) {
                var _correlatedHosts = this.correlatedHosts.values();
                for (i in _correlatedHosts) {
                    
                    if (this.doSiteMap) {
						var url = this._createHuffmanUrl(_correlatedHosts[i]);
						if (bIsLoggable) {
                        	this.LOGGER.trace(LOG_METHOD, 'url:  ${0}', url);
                    	}
						
						if (url.length > this.urlMaxLength) {
							if (bIsLoggable) {
								this.LOGGER.trace(LOG_METHOD, 'url is too long, falling back to POST');
							}
							// fall back
							this._doMultipartPOSTRequest(this.method, _correlatedHosts[i], doMultipartParts);
						}
						else {
							var xhrArgs = {
								url: url,
								load: dojo.partial(com.ibm.mm.enabler.io.handleMultiPartResponse, _correlatedHosts[i], doMultipartParts),
								error: function(response, ioArgs){
									dojo.forEach(parts, function(part){
										partHandler(part, response, ioArgs, null);
									});
								},
								handleAs: "text"
							};
							dojo.xhrGet(xhrArgs, true);
						}
                        
                    } else {
                        this._doMultipartPOSTRequest(this.method, _correlatedHosts[i], doMultipartParts);
                    }
                }

            } else {
                // nothing in the parts array
                if (0 == this._assocArraySize(this.partsArray)) {
                    return;
                }
				
                
                if (this.doSiteMap) {
					var url = this._createHuffmanUrl(this.partsArray);
					if (bIsLoggable) {
                        this.LOGGER.trace(LOG_METHOD, 'url:  ${0}', url);
                    }
                    
					if (url.length > this.urlMaxLength) {
						if (bIsLoggable) {
							this.LOGGER.trace(LOG_METHOD, 'url is too long, falling back to POST');
						}
						// fall back
						this._doMultipartPOSTRequest(this.method, this.partsArray, doMultipartParts);
					} else {
						var xhrArgs = {
							url: url,
							load: dojo.partial(com.ibm.mm.enabler.io.handleMultiPartResponse, this.partsArray, doMultipartParts),
							error: function(response, ioArgs){
								dojo.forEach(parts, function(part){
									partHandler(part, response, ioArgs, null);
								});
							},
							handleAs: "text"
						};
						dojo.xhrGet(xhrArgs, true);
					}
                    
                } else {
                    this._doMultipartPOSTRequest(this.method, this.partsArray, doMultipartParts);
                }
            }
			
			if (callback) {
				callback(parameters);
			}
			
			if (bIsLoggable) {
                this.LOGGER.exiting(LOG_METHOD);
            }
        },
		
		_doMultipartPOSTRequest: function(method, partsArray, doMultipartParts) {
            this._processMultipartBody(partsArray);
            var rawMPArgs = { url: this.serviceMPJson.url, sync: true };
            com.ibm.mm.enabler.io.multiPartXhr(method, rawMPArgs, partsArray, doMultipartParts); 
        },

		_assocArraySize: function(tempArray) {
            var size = 0;
            for (x in tempArray) {
                size++;
            }
            return size;
        },
		
		_addToPartsArray: function (partsArray, args) {
            var existing = partsArray[args.url];
            if ((!existing) || (null == existing)) {
                partsArray[args.url] = new Array();
                partsArray[args.url][0] = args;
            } else {
                existing[existing.length] = args;
            }
        },


        // acquire semaphore
        _acquire: function () {
            this.statics.semaphore++;
        },

        // release semaphore
        _release: function (deferred, statusCode) {
            this.statics.semaphore--;
        },
        
        _createPocURI: function (url) {
            var LOG_METHOD = "_createPocURI(url)";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD, url);
            }
            
            // OR added de-proxyfication since this is not needed for resolver uri's
            var proxyPrefix = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME).getValue(com.ibm.mashups.enabler.services.ConfigConstants.PROXY_URL);
            proxyPrefix += "/http/"; // e.g. /mum/proxy/http/
            
            if (url.indexOf(proxyPrefix) == 0) {
                var newUrl = "http://";
                var slashPos = url.indexOf("/", proxyPrefix.length+1) // skip /http/ to find next /


                // need to decode the authority part in order to have a valid URI
                if (slashPos > -1) {
                    newUrl += unescape(url.substring(proxyPrefix.length, slashPos));
                    newUrl += url.substring(slashPos);
                } else {                
                    newUrl = "http://" + url.substring(proxyPrefix.length);
                }
                
                url = newUrl;
            }
            
            // OR changed url to be HttpURL and get files by res://
            var httpUrl = new com.ibm.mm.enabler.utilities.HttpUrl(url);
            
            var uri = "";
            
            var isProxyNeeded = httpUrl.isProxyNeeded();
            
            if (isProxyNeeded)
                uri = httpUrl.toString(); // the URI is the true url
            else
                uri = "res:/" + httpUrl.toServerRelativeString(); // need to prefix res:/ before the server relative url
            
            if (bIsLoggable)
                this.LOGGER.trace(LOG_METHOD, 'proxy? ${0}: ${1}', [isProxyNeeded, uri]);

            if (bIsLoggable) {
                this.LOGGER.exiting(LOG_METHOD, uri);
            }

            return uri;
        },
		
        _processMultipartBody: function(parts) {
            var LOG_METHOD = "_processMultipartBody(parts)";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD, parts);
            }
            
            for (w in parts) {
                // Create a header for our method
                var args = parts[w][0];
                
                var uri = this._createPocURI(args.url);
                
                var contentIdHeader = uri;
                
                args.headers = dojo.mixin({}, args.headers, { "X-Method-Override": args.method, "Content-ID": contentIdHeader });
            }
            
            if (bIsLoggable) {
                this.LOGGER.exiting(LOG_METHOD);
            }
        },
        
        _createSiteMap: function (parts) {
            var LOG_METHOD = "_createSiteMap(parts)";
            var bIsLoggable = this.LOGGER.isLoggable(this.LOG_LEVEL);
            if (bIsLoggable) {
                this.LOGGER.entering(LOG_METHOD, parts);
            }
            
            var cxml = '<mashup:sitemap xmlns:mashup="http://www.ibm.com/xmlns/prod/websphere/portal/v6.0.2/mashup-sitemap">';
            for (w in parts) {
                // Create a header for our method
                var args = parts[w][0];
                args.handleAs = args.handleAs ? args.handleAs.toLowerCase() : "text";
                
				var uri = this._createPocURI(args.url).replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/&/g,"&amp;");
                
                if (bIsLoggable)
                    this.LOGGER.trace(LOG_METHOD, 'proxy? ${0}: ${1}', [isProxyNeeded, uri]);

                cxml += '<mashup:entry uri="' + uri + '" mode="download"/>';
            }           
            cxml += '</mashup:sitemap>';
            
            if (bIsLoggable) {
                this.LOGGER.exiting(LOG_METHOD, cxml);
            }
            return cxml;
        }
    }
);

}

if(!dojo._hasResource["com.ibm.mm.enabler.io.strategy"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.io.strategy"] = true;
dojo.provide("com.ibm.mm.enabler.io.strategy");


dojo.declare("com.ibm.mm.enabler.strategy.PageLoadAheadStrategyExecutor", null,
    {
        constructor:function (strategies) {
      
            this.strategies = strategies;
			
			this.loadAheadUser = false;
			this.loadAheadCatalogCategoryModel = false;
			this.loadAheadLayoutModel = false;
			this.userLoadAheadStrategy = null;
			this.pageLoadAheadStrategy = null;
			this.catalogCategoryLoadAheadStrategy = null;
			for (x in this.strategies) {
				if (this.strategies[x] instanceof com.ibm.mashups.enabler.strategy.UserLoadAheadStrategy) {
					this.loadAheadUser = this.strategies[x].isLoadAheadUser();
					this.userLoadAheadStrategy = this.strategies[x];
				} 
                else if (this.strategies[x] instanceof com.ibm.mashups.enabler.strategy.CatalogCategoryLoadAheadStrategy) {
					/*
                    this.loadAheadCatalogCategoryModel = this.strategies[x].isLoadAheadCatalogCategoryModel();
                    this.catalogCategoryLoadAheadStrategy = this.strategies[x];
                    */
				} 
                else if (this.strategies[x] instanceof com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy) {
                    var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
                    var pageLoadOptimization = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION);
                    if (pageLoadOptimization === true)
                        this.loadAheadLayoutModel = this.strategies[x].isLoadAheadLayoutModel();
                    var pageLoadOptimizationTheme = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION_THEME);
                    if (pageLoadOptimization === true)
                        this.loadAheadTheme = this.strategies[x].isLoadAheadTheme();
                    else
                        this.loadAheadTheme = false;
					this.pageLoadAheadStrategy = strategies[x];
				}
			}

            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_THR, nsf.NS_XML, nsf.NS_OPENSEARCH]);
            this.prefix = this.serviceJson.idprefix;
            for (prefix in this.serviceJson.namespaces) {
                this.ns[prefix] = this.serviceJson.namespaces[prefix];
            }
            
        },
		
		processLoadAhead: function(loadedNodes, sync) {
            if (!com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled()) {
                // nothing to do
                return;
            }
			
            var mpHandler = com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
            mpHandler.startTransaction();
			// Hack!  extract the digest 
            if (loadedNodes.length > 0) {
                    var h_expr = "atom:link[@rel='edit']";
                    //var h_expr = "atom:link[@rel='edit' and @ext:class='content-node']";
                    var h_nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(h_expr, loadedNodes[0].xmlData, this.ns);
                    if (h_nodes && h_nodes.length > 0) {
                        // href of fragment
                        var h_href = h_nodes[0].getAttribute("href");
                        var h_url = new com.ibm.mm.enabler.utilities.HttpUrl(h_href);
                        mpHandler.statics.digest = h_url.getParameter("digest");
                    }
            }
			
            // Load the current user
            if (this.loadAheadUser) {
                var userModel = this.userLoadAheadStrategy.getUserModel();
                userModel.findCurrentUser().start();
            }
			
			// Catalog Entry Model
			if (this.loadAheadCatalogCategoryModel) {
				var catalogEntryModel = this.catalogCategoryLoadAheadStrategy.getCatalogCategoryModel();
				var rootNode = catalogEntryModel.getRoot().start();
                var iter = catalogEntryModel.getChildren(rootNode);
                iter.hasNext();
			}
			
			// Layout model
            for (var i = 0; i < loadedNodes.length; i++) {
                if (this.loadAheadLayoutModel) {
			
                    // Preload the fragment if the strategy dictates it
                    // fetch uri from navigation node
                    var href = null;
                    var id = null;
                    var expr = "atom:link[@rel='related' and @ext:class='content-node']";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, loadedNodes[i].xmlData, this.ns);
                    if (nodes && nodes.length > 0) {
                        // href of fragment
                        href = nodes[0].getAttribute("href");
                        id = com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix, nodes[0]);
                    }
					if (null == href) {
						// no fragment
                        continue;
                    }
                    var fragmentId = (id !== null) ? id : loadedNodes[i].getID();
                    var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href, null);
					myUrl.setParameter("rep", "full"); // force full representation mode
                    myUrl.addParameter("aspect", "ac");
                    //                this.layoutModels[nodeId] = new com.ibm.mm.enabler.model.LayoutModelImpl(href, fragmentId);
                    var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
                    serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
						if ((type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) 
							&& (args.node) 
							&& (200 == xhr.status)) {
                            var fragmentNodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
							if (fragmentNodes && fragmentNodes.length > 0) {
	                            args.node._setFragmentData(fragmentNodes[0]);
							}
                        }
                    }), {
                        "node": loadedNodes[i]
                    });
                    
                    myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL, null);
                    myUrl.setNodes([{
                            value: fragmentId,
                            isID: true
                        }, {
                            value: "index.html",
                            isID: false
                        }]);
                    serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, true, sync);
                    serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
                        if ((type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) 
							&& (args.node) 
							&& (200 == xhr.status)) {
                            args.node._setFragmentMediaData(data);
                        } else {
                            args.node._setFragmentData(null);
                            args.node._setFragmentMediaData(null);
                        }

                    }), {
                        "node": loadedNodes[i]
                    });
                }
                if (this.loadAheadTheme) {
                    var themeId = loadedNodes[i].getTheme();
                    if (themeId !== null) {
                        var themeModel = com.ibm.mashups.enabler.model.Factory.getThemeModel();
                        themeModel.find(themeId).start();
                    }
                    // skins
                    com.ibm.mm.builder.utils.skinUtil.getAllSkins();
                }
            }
            mpHandler.endTransaction();
        }
	}
);

dojo.declare("com.ibm.mm.enabler.strategy.PageLoadAheadStrategyImpl", com.ibm.mashups.enabler.strategy.PageLoadAheadStrategy,
    {
        constructor:function (loadAheadLayoutModel, loadAheadTheme, loadAheadUser) {
      
            this.loadAheadLayoutModel = loadAheadLayoutModel;
            this.loadAheadUser = loadAheadUser;
            this.userModel = null;

            var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
            var pageLoadOptimizationTheme = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION_THEME);
            if (pageLoadOptimization === true)
                this.loadAheadTheme = loadAheadTheme;
            else
                this.loadAheadTheme = false;

            // service document and initialization
            this.serviceJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_NAVIGATION);
            var nsf = com.ibm.mm.enabler.model.NameSpaceFactory;
            this.ns = nsf.getNameSpaces([nsf.NS_ATOM, nsf.NS_THR, nsf.NS_XML, nsf.NS_OPENSEARCH]);
            this.prefix = this.serviceJson.idprefix;
            for (prefix in this.serviceJson.namespaces) {
                this.ns[prefix] = this.serviceJson.namespaces[prefix];
            }
            
        },
       
        isLoadAheadLayoutModel: function() {
            return this.loadAheadLayoutModel;
        },

        isLoadAheadTheme: function() {
            return this.loadAheadTheme;
        },

		isLoadAheadUser: function() {
            return this.loadAheadUser;
        },
        
		setUserModel: function(userModel) {
            this.userModel = userModel;
        },

        getUserModel: function() {
            if (null == this.userModel) {
                this.userModel = com.ibm.mashups.enabler.model.Factory.getUserModel();
            }
            return this.userModel;
        },
        
        _processLoadAhead: function(loadedNodes, sync) {
			if (!com.ibm.mashups.enabler.io.XHRMultipartFactory.isMultipartEnabled()) {
				// nothing to do
				return;
			}
			var mpHandler = com.ibm.mashups.enabler.io.XHRMultipartFactory.create();
            mpHandler.startTransaction();
			// Load the current user
			if (this.loadAheadUser) {
				var userModel = this.getUserModel();
                userModel.findCurrentUser().start();
			}
            for (var i = 0; i < loadedNodes.length; i++) {
                if (this.loadAheadLayoutModel) {
                    // MDG todo debug
                    //                console.info("Node: " + loadedNodes[i]);
                    // Preload the fragment if the strategy dictates it
                    // fetch uri from navigation node
                    var href = null;
                    var id = null;
                    var expr = "atom:link[@rel='related' and @ext:class='content-node']";
                    var nodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath(expr, loadedNodes[i].xmlData, this.ns);
                    if (nodes && nodes.length > 0) {
                        // href of fragment
                        href = nodes[0].getAttribute("href");
                        id = com.ibm.mm.enabler.model.Utils.getIdFromExtUri(this.prefix, nodes[0]);
                    }
                    var fragmentId = (id !== null) ? id : loadedNodes[i].getID();
                    var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.getModelUrl(href, null);
                    //                this.layoutModels[nodeId] = new com.ibm.mm.enabler.model.LayoutModelImpl(href, fragmentId);
                    var serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
                    serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
                        if ((type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) && (args.node)) {
							var fragmentNodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
							if (fragmentNodes && fragmentNodes.length > 0) {
	                            args.node._setFragmentData(fragmentNodes[0]);
							}
                        }
                    }), {
                        "node": loadedNodes[i]
                    });
                    
                    myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL, null);
                    myUrl.setNodes([{
                            value: fragmentId,
                            isID: true
                        }, {
                            value: "index.html",
                            isID: false
                        }]);
                    serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, true, sync);
                    serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
                        if ((type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) && (args.node)) {
                            args.node._setFragmentMediaData(data);
                        }
                    }), {
                        "node": loadedNodes[i]
                    });
                }
                
                if (this.loadAheadTheme) {
                    var themeId = loadedNodes[i].getTheme();
                    if (themeId !== null) {
                        var themeModel = com.ibm.mashups.enabler.model.Factory.getThemeModel();
                        themeModel.find(themeId).start();
                    }
                }
            }
            mpHandler.endTransaction();
        },
        
        _processFind: function(node, sync){
            if (this.loadAheadLayoutModel) {
                var myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_URL, null);
                var uri = "0";
                myUrl.setNodes([{
                        value: uri,
                        isID: true
                    }]);
                serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, false, sync);
                serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
                    if ((type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) && (node)) {
                        var fragmentNodes = com.ibm.mashups.enabler.xml.XPath.evaluateXPath("atom:feed/atom:entry", data, this.ns);
						if (fragmentNodes && fragmentNodes.length > 0) {
	                        node._setFragmentData(fragmentNodes[0]);
						}
                    }
                }));
                
                myUrl = com.ibm.mashups.enabler.model.url.ModelUrlFactory.createModelUrl(com.ibm.mashups.enabler.model.url.ModelUrlFactory.FRAGMENT_MEDIA_URL, null);
                myUrl.setNodes([{
                        value: uri,
                        isID: true
                    }, {
                        value: "index.html",
                        isID: false
                    }]);
                serviceReq = new com.ibm.mm.enabler.services.ModelRestServiceRequest(myUrl, null, null, true, sync);
                
                serviceReq.read(dojo.hitch(this, function(type, data, xhr, args){
                    if ((type == com.ibm.mm.enabler.services.ModelRestServiceRequest.XHR_STATUS_LOAD) && (node)) {
                        node._setFragmentMediaData(data);
                    }
                }));
            }
            
            if (this.loadAheadTheme) {
                var themeModel = com.ibm.mashups.enabler.model.Factory.getThemeModel();
                themeModel.find("0").start();
            }
        }
	}	
);

}

if(!dojo._hasResource["com.ibm.mm.enabler.io.factory"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["com.ibm.mm.enabler.io.factory"] = true;
dojo.provide( "com.ibm.mm.enabler.io.factory" );

// public factory
dojo.declare( "com.ibm.mm.enabler.io.XHRMultipartFactoryImpl", null,
    {
        constructor:function () {
            this.serviceMPJson = null;
            if (dojo.exists("com.ibm.mm.enabler.model.ServiceDocumentModel")) {
	            this.serviceMPJson = com.ibm.mm.enabler.model.ServiceDocumentModel.getCollectionData(
	                [com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MODEL, com.ibm.mm.enabler.model.ServiceDocumentModel.SERVICE_MULTIPART]);
            }
			var configService = com.ibm.mashups.services.ServiceManager.getService(com.ibm.mashups.enabler.services.ConfigService.SERVICE_NAME);
            var multipartConfig = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.MULTIPART_ENABLED);
            this.doMultipart = false;
            if (((null != this.serviceMPJson) && (this.serviceMPJson.url))
				&& (multipartConfig)) {
                this.doMultipart = true;
            }
			
			var pageLoadOptAppWidgets = configService.getValue(com.ibm.mashups.enabler.services.ConfigConstants.PAGE_LOAD_OPTIMIZATION_APP_WIDGETS);
			this.multipartAppWidgets = false;
			if (typeof(pageLoadOptAppWidgets) == "undefined" ||
			    pageLoadOptAppWidgets == null ||
			    pageLoadOptAppWidgets === true) {
				this.multipartAppWidgets = true;
			}

			// disable on IE6
			if (dojo.isIE == 6) {
                this.doMultipart = false;
            }
        },

        create: function() {
            return new com.ibm.mm.enabler.io.XHRMultipartImpl();
        },
		
		isMultipartEnabled: function() {
            return this.doMultipart;
        },
		
		isMultipartApplicationWidgets: function() {
            return this.multipartAppWidgets;
        }
    }
);

// public factory
com.ibm.mashups.enabler.io.XHRMultipartFactory = new com.ibm.mm.enabler.io.XHRMultipartFactoryImpl();

}


dojo.i18n._preloadLocalizations("com.ibm.mm.enabler.nls.enabler", ["ROOT","ar","ca","cs","da","de","de-de","el","en","en-gb","en-us","es","es-es","fi","fi-fi","fr","fr-fr","he","he-il","hr","hu","it","it-it","ja","ja-jp","ko","ko-kr","nl","nl-be","nl-nl","no","pl","pt","pt-br","pt-pt","ro","ro-ro","ru","sk","sl","sv","th","tr","uk","xx","zh","zh-cn","zh-tw"]);
