<%!

public void jspInit() {
    // Use the Generic Web AppServer platform
    final String webInfPath = 
        getServletConfig().getServletContext().getRealPath("WEB-INF");

    System.setProperty("com.ibm.mashups.configuration.path", webInfPath);
    System.setProperty("com.ibm.mm.framework.platform", 
        "com.ibm.mm.framework.platform.GenericWebAppServerPlatform");
}

%>

<%

String builderContext = "/mum";
String enablerContext = "/mum";
String publicHome = "/mum/enabler";
String tunnelMode = "false";
String availableLocales = "tr,ar,de,en,es,fr,it,he,ja,ko,pt-br,zh,zh-tw,ROOT";
String hubUrl = "/mashuphub";
boolean needEnlargeFont = false;
String isDebug = "false";
final String productName = "Lotus Mashups";

String[] common_js = null;
String[] subdomainarray = null;
String subdomains = "[]";

if (subdomainarray != null){
    subdomains = "[";
    for (int i=0; i<subdomainarray.length; i++) {
        subdomains += "\""+subdomainarray[i]+"\"" + ",";
    }
    subdomains = subdomains.substring(0, subdomains.length() -1);
    subdomains +="]";
}

// this is mandatory to make sure that we pull the whole framework in the normal mode
request.setAttribute("framework", "full");

%>

    <script language="JavaScript" type="text/javascript">
        (function(){
            var _href  = window.location.href;
            if(_href.indexOf("?pid=")>0){
                var _newLocation = _href.replace("?pid=", "#pid=")
                location = _newLocation;
            }

            if(_href.indexOf("&pid=")>0){
                var pid = '<%=request.getParameter("pid")%>';
                var _newLocation = _href.replace("&pid=" + pid, "");
                location = _newLocation + "#pid=" + pid;
            }
        })();

        ibmConfig = {
                    "com.ibm.mashups.proxy.url": "/mum/proxy",
                    "com.ibm.mashups.hub.url": "/mashuphub",
                    "com.ibm.mashups.contextroot": "/mum",
                    "com.ibm.mashups.contextroot.builder": "/mum",
                    "com.ibm.mashups.contextroot.theme.temp": "/mum/themes",
                    "com.ibm.mashups.contextroot.enabler": "/mum",
                    "com.ibm.mashups.contenthandler.private": "/mycontenthandler",
                    "com.ibm.mashups.contenthandler.public": "/contenthandler",
                    "serviceDocumentUrl":"/mum/contenthandler?uri=service:collection",
                    "isDebug": "false",
                    "allowPublishLogging": "true",
                    "allowPublishTracing": "false",
                    "popupConsole": <%=isDebug%>,
                    "defaultThemeId": "defaultTheme",
                    "pageSourceReadOnly": "true",
                    "autoAcceptSharedGroupName": "default",
                    "userIdKey": "uid",
                    "groupCNKey": "cn",

            <%// TEMP SECTION BEGIN
            // NEEDS TO BE FIXED BY BUILDER TEAM. LEFT IT IN HERE UNTIL BUILDER JS CODE
            // SWITCHED TO CONFIG SERVICE%>
            contextRootEnabler: "<%=enablerContext%>",
            contextRootBuilder: "<%=builderContext%>",          
            <%// TEMP SECTION END%>

            loadServices:false,
            availableLocales:"<%=availableLocales%>",
            <% // dynamic values, cannot be moved to ConfigService %>
            sessionId: "<%=request.getRequestedSessionId()%>",
            hubURL: "<%=hubUrl%>",
            locale:"en",
            fontSizeEnlarged:<%=needEnlargeFont%>,
            mappingFunction: null,
            extensions: [],
            anonymousUser: <%=request.getUserPrincipal() == null%>,
	    	securityOff: false,
            isBidi: 0
        };
        
        djConfig={
            isDebug:ibmConfig.isDebug,
            popup:ibmConfig.popupConsole,
            locale:"en"
        };
    </script>