/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.core.internal.testclient;

import com.ibm.etools.webtools.gadgets.core.WidgetsFacetUtil;
import com.ibm.etools.webtools.gadgets.core.internal.testclient.WidgetLaunchable;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.WebResource;

public class WidgetLaunchableAdapter
extends LaunchableAdapterDelegate {
    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        IFile file;
        if (server == null || moduleArtifact == null) {
            return null;
        }
        if (!(moduleArtifact instanceof WebResource)) {
            return null;
        }
        WebResource resource = (WebResource)moduleArtifact;
        IPath resourcePath = resource.getPath();
        if (!"xml".equalsIgnoreCase(resourcePath.getFileExtension())) {
            return null;
        }
        IProject project = resource.getModule().getProject();
        String webRoot = new Path(WidgetsFacetUtil.getWebRoot(project)).lastSegment();
        if (!webRoot.endsWith("/")) {
            webRoot = String.valueOf(webRoot) + "/";
        }
        if (!WidgetsFacetUtil.isWidgetXML(file = project.getFile(String.valueOf(webRoot) + resource.getName()))) {
            return null;
        }
        URL url = null;
        IURLProvider provider = (IURLProvider)server.loadAdapter(IURLProvider.class, null);
        if (provider != null && (url = provider.getModuleRootURL(moduleArtifact.getModule())) != null) {
            try {
                String urlString;
                String path = resource.getPath().toString();
                Trace.trace((int)1, (String)("getLaunchable(): path: " + path));
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (!(urlString = url.toString()).endsWith("/")) {
                    urlString = String.valueOf(urlString) + "/";
                }
                url = new URL(String.valueOf(urlString) + path);
                return new WidgetLaunchable(url);
            }
            catch (Exception e) {
                Trace.trace((int)3, (String)"Error in launchable adapter", (Throwable)e);
            }
        }
        return null;
    }
}

