/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.core.internal.references;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class LinkDetectorProvider
implements ILinkDetectorProvider {
    private static final String IW = "iw";
    private static final String SRC_ATTRIBUTE = "src";
    private static final String RESOURCE_ELEMENT = "resource";

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            NodeList nodeList = document.getElementsByTagName("iw:resource");
            int i = 0;
            while (i < nodeList.getLength()) {
                IDOMElement resourceElement = (IDOMElement)nodeList.item(i);
                NamedNodeMap attrMap = resourceElement.getAttributes();
                IDOMNode src = (IDOMNode)attrMap.getNamedItem(SRC_ATTRIBUTE);
                String linkName = src.getNodeValue();
                String linkType = "web.commonlink";
                ILink desc = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, resourceElement, src, linkType, linkName, false));
                links.add(desc);
                ++i;
            }
        }
        return links;
    }
}

