/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.core;

import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WidgetsFacetUtil {
    private static final String XML_EXTENSION = ".xml";
    private static final String IWIDGET_XML_CONTENT_TYPE_ID = "com.ibm.etools.webtools.gadgets.iwidget.xml";

    public static boolean fileNameContainsValidExtension(String fileName) {
        if (fileName.toLowerCase().endsWith(XML_EXTENSION)) {
            return true;
        }
        int dotIndex = fileName.lastIndexOf(".");
        return dotIndex == -1;
    }

    public static String generateWidgetName(String folder, String fileName) {
        int i = 1;
        while (WidgetsFacetUtil.widgetExists(folder, String.valueOf(fileName) + i)) {
            ++i;
        }
        return String.valueOf(fileName) + i;
    }

    public static boolean widgetExists(String folder, String fileName) {
        Path path = new Path(folder);
        path = path.append(String.valueOf(fileName) + XML_EXTENSION);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return file != null && file.exists();
    }

    public static boolean folderExists(String folder) {
        Path path = new Path(folder);
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        return iFolder != null && iFolder.exists();
    }

    public static String getWebRoot(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IPath webContainerPath = component.getRootFolder().getWorkspaceRelativePath();
            return webContainerPath.toString();
        }
        return null;
    }

    public static String getWebRootName(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            return component.getRootFolder().getProjectRelativePath().lastSegment();
        }
        return null;
    }

    public static boolean isWithinWebRoot(String folder) {
        Path path = new Path(folder);
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        return ProjectFacetsUtil.isWithinWebRoot((IContainer)iFolder);
    }

    public static boolean isFolderINF(String folder) {
        return (folder = folder.toLowerCase()).contains("WEB-INF".toLowerCase()) || folder.contains("META-INF".toLowerCase());
    }

    public static boolean isWidgetXML(IFile file) throws CoreException {
        IContentType iWidget = Platform.getContentTypeManager().getContentType(IWIDGET_XML_CONTENT_TYPE_ID);
        return iWidget.getDefaultDescription() == file.getContentDescription();
    }

    public static boolean isStaticProject(IProject project) throws CoreException {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
        return WidgetsFacetUtil.hasFacet(project, facet);
    }

    public static boolean hasFacet(IProject project, IProjectFacet facet) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        Set facets = new HashSet();
        if (facetedProject != null) {
            facets = facetedProject.getProjectFacets();
            for (IProjectFacetVersion fv : facets) {
                if (fv.getProjectFacet() != facet) continue;
                return true;
            }
        }
        return false;
    }
}

