/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.core;

import com.ibm.etools.webtools.gadgets.core.IGadgetsModelProperties;
import com.ibm.etools.webtools.gadgets.core.Messages;
import com.ibm.etools.webtools.gadgets.core.WidgetsFacetUtil;
import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;

public class WidgetsFacetInstallConfig
extends FacetInstallDataModelProvider
implements IGadgetsModelProperties,
IFacetDataModelProperties {
    private Object context;

    public WidgetsFacetInstallConfig(Object context) {
        this.context = context;
    }

    public WidgetsFacetInstallConfig() {
    }

    public Object create() {
        IDataModel model = (IDataModel)super.create();
        return model;
    }

    public Set<String> getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("WIDGET_NAME");
        names.add("VIEW_MODE");
        names.add("EDIT_MODE");
        names.add("WIDGET_PROJECT");
        names.add("FOLDER");
        names.add("WIDGET_TYPE");
        names.add("INSTALL_WIDGET_FACET");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IFacetDataModelProperties.FACET_ID".equals(propertyName)) {
            return "enabler.widgets";
        }
        if ("WIDGET_NAME".equals(propertyName)) {
            return this.getWidgetName();
        }
        if ("VIEW_MODE".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("EDIT_MODE".equals(propertyName)) {
            return Boolean.FALSE;
        }
        if ("WIDGET_PROJECT".equals(propertyName)) {
            return this.getProject();
        }
        if ("FOLDER".equals(propertyName)) {
            return this.getFolder();
        }
        if ("WIDGET_TYPE".equals(propertyName)) {
            return this.getWidgetTypes();
        }
        if ("INSTALL_WIDGET_FACET".equals(propertyName)) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getWidgetTypes() {
        return this.getValidPropertyDescriptors("WIDGET_TYPE")[0].getPropertyValue();
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("WIDGET_TYPE")) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(Messages.SIMPLE_WIDGET_TEMPLATE);
            strings.add(Messages.PUBLISHER_WIDGET_TEMPLATE);
            strings.add(Messages.SUBSCRIBER_WIDGET_TEMPLATE);
            strings.add(Messages.JSP_WIDGET_TEMPLATE);
            return DataModelPropertyDescriptor.createDescriptors((Object[])strings.toArray());
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    private Object getFolder() {
        if (this.isPropertySet("WIDGET_PROJECT") && this.model.validateProperty("WIDGET_PROJECT").isOK()) {
            IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
            return WidgetsFacetUtil.getWebRoot(project);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFullPath().toString();
    }

    private Object getWidgetName() {
        String projectFacetName = null;
        if (this.isPropertySet("IFacetDataModelProperties.FACET_PROJECT_NAME") && this.model.validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").isOK()) {
            return this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        }
        if (this.isPropertySet("WIDGET_PROJECT") && this.model.validateProperty("WIDGET_PROJECT").isOK()) {
            IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
            projectFacetName = project.getName();
            if (this.isPropertySet("FOLDER") && this.model.validateProperty("FOLDER").isOK()) {
                String folder = this.model.getStringProperty("FOLDER");
                projectFacetName = WidgetsFacetUtil.generateWidgetName(folder, projectFacetName);
            }
        }
        return projectFacetName;
    }

    private Object getProject() {
        if (this.isPropertySet("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY") && this.model.validateProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY").isOK()) {
            IFacetedProjectWorkingCopy workingCopy = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            return workingCopy.getProject();
        }
        return null;
    }

    public IStatus validate(String name) {
        if ("WIDGET_NAME".equals(name)) {
            String fileName = this.model.getStringProperty("WIDGET_NAME");
            if (fileName == null || fileName.trim().equals("")) {
                return new Status(4, "com.ibm.etools.webtools.gadgets", Messages.WidgetsFactoryInstallActionConfig_must_specify_widget_name);
            }
            if (!WidgetsFacetUtil.fileNameContainsValidExtension(fileName)) {
                return new Status(4, "com.ibm.etools.webtools.gadgets", Messages.WidgetsFactoryInstallActionConfig_not_valid_extension);
            }
            if (this.model.isPropertySet("FOLDER") && WidgetsFacetUtil.widgetExists(this.model.getStringProperty("FOLDER"), fileName)) {
                return new Status(4, "com.ibm.etools.webtools.gadgets", Messages.WidgetsFactoryInstallActionConfig_file_already_exists);
            }
        }
        if ("FOLDER".equals(name)) {
            String folder = this.model.getStringProperty("FOLDER");
            if (!WidgetsFacetUtil.folderExists(folder)) {
                return new Status(4, "com.ibm.etools.webtools.gadgets", Messages.WidgetsFactoryInstallActionConfig_folder_does_not_exist);
            }
            if (!WidgetsFacetUtil.isWithinWebRoot(folder)) {
                return new Status(4, "com.ibm.etools.webtools.gadgets", Messages.WidgetsFactoryInstallActionConfig_folder_not_under_webroot);
            }
            if (WidgetsFacetUtil.isFolderINF(folder)) {
                return new Status(4, "com.ibm.etools.webtools.gadgets", Messages.WidgetsFactoryInstallActionConfig_folder_invalid);
            }
        }
        return super.validate(name);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("WIDGET_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("WIDGET_NAME", 3);
            this.model.notifyPropertyChange("WIDGET_NAME", 1);
        }
        if ("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY".equals(propertyName)) {
            this.model.notifyPropertyChange("WIDGET_PROJECT", 3);
            this.model.notifyPropertyChange("WIDGET_PROJECT", 1);
        }
        if ("WIDGET_PROJECT".equals(propertyName)) {
            if (!this.isPropertySet("FOLDER")) {
                IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
                this.model.setProperty("FOLDER", (Object)WidgetsFacetUtil.getWebRoot(project));
            }
            try {
                this.model.setProperty("INSTALL_WIDGET_FACET", (Object)(!ProjectFacetsUtil.projectHasFacet((IProject)((IProject)propertyValue), (String)"enabler.widgets", null) ? 1 : 0));
            }
            catch (CoreException coreException) {
                this.model.setProperty("INSTALL_WIDGET_FACET", (Object)Boolean.FALSE);
            }
        }
        if ("FOLDER".equals(propertyName) && !this.isPropertySet("WIDGET_PROJECT")) {
            IResource resource;
            String folderString = (String)this.model.getProperty("FOLDER");
            Path folderPath = new Path(folderString);
            String firstSegment = folderPath.segment(0);
            IProject project = null;
            if (firstSegment != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(firstSegment)) != null) {
                project = resource.getProject();
            }
            this.model.setProperty("WIDGET_PROJECT", project);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public void init() {
        super.init();
        if (this.context != null) {
            if (this.context instanceof IJavaProject) {
                this.context = ((IJavaProject)this.context).getProject();
            }
            if (this.context instanceof IResource) {
                if (this.context instanceof IContainer) {
                    if (this.context instanceof IProject) {
                        IProject project = (IProject)this.context;
                        this.model.setProperty("WIDGET_PROJECT", (Object)project);
                        if (ProjectFacetsUtil.isWebProject((IProject)project)) {
                            this.model.setProperty("FOLDER", (Object)WidgetsFacetUtil.getWebRoot(project));
                        }
                    } else if (this.context instanceof IFolder) {
                        IFolder folder = (IFolder)this.context;
                        if (!ProjectFacetsUtil.isWithinWebRoot((IContainer)folder)) {
                            this.model.setProperty("FOLDER", (Object)WidgetsFacetUtil.getWebRoot(folder.getProject()));
                        } else {
                            String folderPath = folder.getFullPath().lastSegment();
                            if (folderPath.equalsIgnoreCase("WEB-INF") || folderPath.equalsIgnoreCase("META-INF")) {
                                this.model.setProperty("FOLDER", (Object)WidgetsFacetUtil.getWebRoot(folder.getProject()));
                            } else {
                                this.model.setProperty("FOLDER", (Object)folder.getFullPath().toString());
                            }
                        }
                    }
                } else {
                    IFile file = (IFile)this.context;
                    IContainer parent = file.getParent();
                    if (!ProjectFacetsUtil.isWithinWebRoot((IContainer)parent)) {
                        this.model.setProperty("FOLDER", (Object)WidgetsFacetUtil.getWebRoot(file.getProject()));
                    } else {
                        this.model.setProperty("FOLDER", (Object)file.getParent().getFullPath().toString());
                    }
                }
            }
        }
    }
}

