/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.core;

import com.ibm.etools.webtools.gadgets.GadgetsActivator;
import com.ibm.etools.webtools.gadgets.core.Messages;
import com.ibm.etools.webtools.gadgets.core.WidgetsFacetUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class WidgetsCreateWizard {
    private static final String XML_EXTENSION = ".xml";
    private static final String WIDGETS_PATH = "templates";
    private static final String WEBCONTENT = "WebContent";
    private static final String SIMPLE_WIDGET_TEMPLATE = "iWidget-template.xml";
    private static final String EVENT_PUBLISHER_TEMPLATE = "publisher-iWidget-template.zip";
    private static final String EVENT_SUBSCRIBER_TEMPLATE = "subscriber-iWidget-template.zip";
    private static final String JSP_WIDGET_TEMPLATE = "jsp-iWidget-template.zip";
    private static final String CATALOG_ENTRY = "catalog-entry.xml";
    private static final String MASHUP_PROPERTIES = "mashup.properties";
    private static final String TEMPLATE_STRING = "myWidget";
    private static final String END_ELEMENT = "</iw:iwidget>";
    private static final String MODES = "MODES";
    private static final String EDIT_CONTENT = "<iw:content mode=\"edit\">\r\n</iw:content>\r\n</iw:iwidget>";
    private static final String FOLDER_VAR = "FOLDER";
    private static final String CATEGORY = "</category>";
    private static final String UNIQUEID = "UNIQUEID";
    public IDataModel model;
    private Shell shell;

    public WidgetsCreateWizard() {
    }

    public WidgetsCreateWizard(IDataModel dataModel, Shell shell) {
        this.model = dataModel;
        this.shell = shell;
    }

    public void createWidget() throws CoreException {
        try {
            this.installFacet();
            IFile newFile = this.copyTemplate();
            this.openFileInEditor(newFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void installFacet() throws CoreException {
        Boolean installFacet = this.model.getBooleanProperty("INSTALL_WIDGET_FACET");
        if (installFacet.booleanValue()) {
            IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) {
                return;
            }
            IProjectFacet iWidgetFacet = ProjectFacetsManager.getProjectFacet((String)"enabler.widgets");
            IProjectFacetVersion iWidgetFacetVersion = iWidgetFacet.getLatestVersion();
            facetedProject.installProjectFacet(iWidgetFacetVersion, null, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IFile copyTemplate() throws CoreException, IOException, ResourceAlreadyExists, ResourceInUse {
        String templateType = this.getTemplateType();
        String fileName = this.model.getStringProperty("WIDGET_NAME");
        IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
        if (!fileName.toLowerCase().endsWith(XML_EXTENSION)) {
            fileName = String.valueOf(fileName) + XML_EXTENSION;
        }
        String webRoot = WEBCONTENT;
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            webRoot = WidgetsFacetUtil.getWebRootName(project);
        }
        IPath path = project.getFolder((IPath)new Path(webRoot)).getFullPath();
        if (this.model.isPropertySet(FOLDER_VAR)) {
            path = new Path(this.model.getStringProperty(FOLDER_VAR));
        }
        path = path.append(fileName);
        IPath templatePath = new Path(WIDGETS_PATH).append(templateType);
        URL templateURL = GadgetsActivator.getResource(templatePath.makeAbsolute().toString());
        ArrayList<IFile> newFiles = templateType.endsWith(XML_EXTENSION) ? this.copySimpleTemplate(path, templateURL) : this.copyArchivedTemplate(path, templateURL);
        for (IFile newFile : newFiles) {
            this.updateFileWithWidgetDetails(newFile);
        }
        if (!WidgetsFacetUtil.isStaticProject(project)) {
            this.copyCatalog(project, this.getWidgetName((IPath)new Path(path.lastSegment())));
            this.createMashupProperties(project);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    private String getTemplateType() {
        String templateType = SIMPLE_WIDGET_TEMPLATE;
        String widgetType = this.model.getStringProperty("WIDGET_TYPE");
        if (widgetType.equals(Messages.PUBLISHER_WIDGET_TEMPLATE)) {
            templateType = EVENT_PUBLISHER_TEMPLATE;
        } else if (widgetType.equals(Messages.SUBSCRIBER_WIDGET_TEMPLATE)) {
            templateType = EVENT_SUBSCRIBER_TEMPLATE;
        } else if (widgetType.equals(Messages.JSP_WIDGET_TEMPLATE)) {
            templateType = JSP_WIDGET_TEMPLATE;
        }
        return templateType;
    }

    private ArrayList<IFile> copySimpleTemplate(IPath path, URL templateURL) throws IOException, CoreException {
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        InputStream inputStream = templateURL.openStream();
        try {
            newFile.create(inputStream, true, null);
        }
        finally {
            inputStream.close();
        }
        ArrayList<IFile> fileSet = new ArrayList<IFile>();
        fileSet.add(newFile);
        return fileSet;
    }

    private ArrayList<IFile> copyArchivedTemplate(IPath path, URL templateURL) throws IOException, CoreException {
        ZipInputStream zipInputStream = new ZipInputStream(templateURL.openStream());
        String widgetName = this.getWidgetName((IPath)new Path(path.lastSegment()));
        IPath folderPath = path.removeLastSegments(1);
        IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
        IFolder folder = project.getFolder(folderPath.removeFirstSegments(1));
        FileOutputStream fileoutputstream = null;
        ArrayList<IFile> fileSet = new ArrayList<IFile>();
        try {
            try {
                ZipEntry entry = null;
                byte[] buf = new byte[8024];
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    String newFileString = project.getWorkspace().getRoot().getLocation().toString();
                    newFileString = String.valueOf(newFileString) + folder.getFullPath().toString() + '/';
                    Path entryPath = new Path(entryName);
                    newFileString = String.valueOf(newFileString) + widgetName + "." + entryPath.getFileExtension();
                    fileoutputstream = new FileOutputStream(newFileString);
                    int n = 0;
                    while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                    IPath fileEntry = folderPath.append(String.valueOf(widgetName) + "." + entryPath.getFileExtension());
                    fileSet.add(ResourcesPlugin.getWorkspace().getRoot().getFile(fileEntry));
                    fileoutputstream.close();
                }
                folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (fileoutputstream != null) {
                    fileoutputstream.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        }
        finally {
            if (fileoutputstream != null) {
                fileoutputstream.close();
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        return fileSet;
    }

    private void updateFileWithWidgetDetails(IFile newFile) throws IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
        String widgetName = this.getWidgetName(newFile);
        IStructuredModel structuredModel = null;
        try {
            int startIndex;
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(newFile);
            if (structuredModel == null) {
                this.updateNonSSEFile(newFile, widgetName);
                return;
            }
            IStructuredDocument doc = structuredModel.getStructuredDocument();
            String text = doc.getText();
            while ((startIndex = text.indexOf(TEMPLATE_STRING)) != -1) {
                doc.replaceText((Object)structuredModel, startIndex, TEMPLATE_STRING.length(), widgetName);
                text = doc.getText();
            }
            Boolean isEditMode = this.model.getBooleanProperty("EDIT_MODE");
            String mode = "view";
            mode = String.valueOf(mode) + (isEditMode != false ? " edit" : "");
            int startIndex2 = text.indexOf(MODES);
            if (startIndex2 != -1) {
                doc.replaceText((Object)structuredModel, startIndex2, MODES.length(), mode.trim());
            }
            if (isEditMode.booleanValue() && (startIndex2 = (text = doc.getText()).indexOf(END_ELEMENT)) != -1) {
                doc.replaceText((Object)structuredModel, startIndex2, END_ELEMENT.length(), EDIT_CONTENT);
            }
            if (!structuredModel.isSharedForEdit()) {
                structuredModel.save(newFile);
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    private void updateNonSSEFile(IFile newFile, String widgetName) {
        try {
            InputStream is = newFile.getContents(true);
            int available = is.available();
            char[] buf = new char[available];
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            reader.read(buf);
            is.close();
            reader.close();
            String text = new String(buf);
            text = text.replaceAll(TEMPLATE_STRING, widgetName);
            ByteArrayInputStream source = new ByteArrayInputStream(text.getBytes());
            newFile.setContents((InputStream)source, 1, null);
            source.close();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openFileInEditor(final IFile file) throws CoreException, IOException {
        if (file != null && file.exists()) {
            Display display;
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)activeWindow);
            }
            Display display2 = display = this.shell != null ? this.shell.getDisplay() : Display.getDefault();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IWorkbenchWindow workbenchWindow = GadgetsActivator.getInstance().getWorkbench().getActiveWorkbenchWindow();
                            IDE.openEditor((IWorkbenchPage)workbenchWindow.getActivePage(), (IFile)file, (boolean)true);
                        }
                        catch (PartInitException partInitException) {}
                    }
                });
            }
        }
    }

    private String getWidgetName(IFile file) {
        return this.getWidgetName((IPath)new Path(file.getName()));
    }

    private String getWidgetName(IPath path) {
        return path.removeFileExtension().toString();
    }

    private void copyCatalog(IProject project, String widgetName) throws IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
        IPath templatePath = new Path(WIDGETS_PATH).append("catalog.xml");
        URL catalogURL = GadgetsActivator.getResource(templatePath.makeAbsolute().toString());
        IPath catalogPath = new Path(WidgetsFacetUtil.getWebRoot(project)).append("WEB-INF").append("catalog.xml");
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(catalogPath);
        if (!newFile.exists()) {
            InputStream inputStream = catalogURL.openStream();
            try {
                newFile.create(inputStream, true, null);
            }
            finally {
                inputStream.close();
            }
        }
        IPath catalogEntryPath = new Path(WIDGETS_PATH).append(CATALOG_ENTRY);
        URL catalogEntryURL = GadgetsActivator.getResource(catalogEntryPath.makeAbsolute().toString());
        InputStream fis = catalogEntryURL.openStream();
        int available = fis.available();
        byte[] b = new byte[available];
        fis.read(b);
        String entry = new String(b);
        fis.close();
        String folder = this.model.getStringProperty(FOLDER_VAR);
        if (folder != null) {
            int beginIndex;
            String webRoot = WEBCONTENT;
            if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
                webRoot = WidgetsFacetUtil.getWebRootName(project);
            }
            if ((beginIndex = folder.indexOf(webRoot)) != -1 && (folder = folder.substring(beginIndex + webRoot.length())).startsWith("/") && (folder = folder.substring(1)).length() > 0 && !folder.endsWith("/")) {
                folder = String.valueOf(folder) + '/';
            }
        } else {
            Assert.isNotNull((Object)folder, (String)"Source folder should not be null");
        }
        entry = entry.replaceAll(TEMPLATE_STRING, widgetName);
        entry = entry.replaceAll(UNIQUEID, folder.replace('/', '-'));
        entry = entry.replaceAll(FOLDER_VAR, folder);
        IStructuredModel structuredModel = null;
        try {
            IStructuredDocument doc;
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(newFile);
            if (structuredModel != null && (doc = structuredModel.getStructuredDocument()) != null) {
                String text = doc.getText();
                int startIndex = text.indexOf(CATEGORY);
                if (startIndex != -1) {
                    doc.replaceText((Object)structuredModel, startIndex, CATEGORY.length(), String.valueOf(entry) + "\r\n" + CATEGORY);
                }
                if (!structuredModel.isSharedForEdit()) {
                    structuredModel.save(newFile);
                }
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    private void createMashupProperties(IProject project) throws CoreException, IOException {
        IPath propsPath = new Path(WidgetsFacetUtil.getWebRoot(project)).append("WEB-INF").append(MASHUP_PROPERTIES);
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(propsPath);
        if (newFile.exists()) {
            return;
        }
        String projectName = project.getName();
        String str = new String("contextRoot=" + projectName);
        str = str.concat("\r\ncomponentName=" + projectName);
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        try {
            newFile.create((InputStream)bis, true, null);
        }
        finally {
            bis.close();
        }
    }
}

