/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.ui.customizations;

import com.ibm.etools.webtools.gadgets.ui.Messages;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetContentModeCustomization
implements IAdvancedCustomizationObject {
    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        String mode;
        ViewModeDialog viewModeDialog = new ViewModeDialog(editorPart.getSite().getShell());
        viewModeDialog.create();
        viewModeDialog.getShell().setText(Messages.iWidgetEditor_set_content_mode_dialog_title);
        viewModeDialog.setBlockOnOpen(true);
        if (closestAncestor.getNodeName().endsWith("content")) {
            closestAncestor = (Element)closestAncestor.getParentNode();
        }
        NodeList contentElements = closestAncestor.getElementsByTagNameNS("http://www.ibm.com/xmlns/prod/iWidget", "content");
        int i = 0;
        while (i < contentElements.getLength()) {
            Element element;
            String mode2;
            Node node = contentElements.item(i);
            if (node.getNodeType() == 1 && (mode2 = (element = (Element)node).getAttribute("mode")) != null && !mode2.equals(value)) {
                viewModeDialog.disableMode(mode2);
            }
            ++i;
        }
        viewModeDialog.setMode(value);
        if (viewModeDialog.open() == 0 && !(mode = viewModeDialog.getMode()).equals(value)) {
            return mode;
        }
        return null;
    }

    private class ViewModeDialog
    extends Dialog {
        private String mode;
        private Text customModeText;
        private Button viewModeButton;
        private Button editModeButton;
        private Button helpModeButton;
        private Button printModeButton;
        private Button customModeButton;

        protected ViewModeDialog(Shell parentShell) {
            super(parentShell);
            this.mode = "";
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogAreaComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            dialogAreaComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1808);
            gridData.widthHint = 250;
            dialogAreaComposite.setLayoutData((Object)gridData);
            Group section = new Group(dialogAreaComposite, 0);
            section.setText(Messages.iWidgetEditor_set_content_mode_group_title);
            section.setLayoutData((Object)new GridData(1808));
            section.setLayout((Layout)new GridLayout(2, false));
            this.viewModeButton = new Button((Composite)section, 16);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.viewModeButton.setText(Messages.iWidgetEditor_set_content_view);
            this.viewModeButton.setLayoutData((Object)gridData);
            this.editModeButton = new Button((Composite)section, 16);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.editModeButton.setText(Messages.iWidgetEditor_set_content_edit);
            this.editModeButton.setLayoutData((Object)gridData);
            this.helpModeButton = new Button((Composite)section, 16);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.helpModeButton.setText(Messages.iWidgetEditor_set_content_help);
            this.helpModeButton.setLayoutData((Object)gridData);
            this.printModeButton = new Button((Composite)section, 16);
            this.printModeButton.setText(Messages.iWidgetEditor_set_content_print);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.printModeButton.setLayoutData((Object)gridData);
            this.customModeButton = new Button((Composite)section, 16);
            this.customModeButton.setText(Messages.iWidgetEditor_set_content_custom);
            this.customModeText = new Text((Composite)section, 2048);
            this.customModeText.setLayoutData((Object)new GridData(768));
            return dialogAreaComposite;
        }

        protected void okPressed() {
            this.mode = this.viewModeButton.getSelection() ? "view" : (this.editModeButton.getSelection() ? "edit" : (this.helpModeButton.getSelection() ? "help" : (this.printModeButton.getSelection() ? "print" : this.customModeText.getText())));
            super.okPressed();
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
            if ("view".equals(mode)) {
                this.viewModeButton.setSelection(true);
            } else if ("edit".equals(mode)) {
                this.editModeButton.setSelection(true);
            } else if ("help".equals(mode)) {
                this.helpModeButton.setSelection(true);
            } else if ("print".equals(mode)) {
                this.printModeButton.setSelection(true);
            } else if (!"".equals(mode)) {
                this.customModeButton.setSelection(true);
                this.customModeText.setText(mode);
                this.customModeText.setFocus();
            }
        }

        public void disableMode(String mode) {
            if ("view".equals(mode)) {
                this.viewModeButton.setEnabled(false);
            } else if ("edit".equals(mode)) {
                this.editModeButton.setEnabled(false);
            } else if ("help".equals(mode)) {
                this.helpModeButton.setEnabled(false);
            } else if ("print".equals(mode)) {
                this.printModeButton.setEnabled(false);
            }
        }
    }
}

